#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    texpdf
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module SiSU_Parts_TeXpdf
  require_relative 'generic_parts'                       # generic_parts.rb
  include SiSU_Parts_Generic
  def the_line_break
    ' \\ '
  end
  def url_decoration
    def tex_open                     #'{\UseTextSymbol{OML}{<}}'
      Dx[:url_o]
    end
    def tex_close                    #'{\UseTextSymbol{OML}{>}}'
      Dx[:url_c]
    end
    def txt_open
      '<'
    end
    def txt_close
      '>'
    end
    self
  end
  def the_font
    def set_fonts
      'verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman'
    end
    self
  end
  class TeX
    def initialize(papersize='')
      @papersize=papersize
    end
    def a4
      def portrait
        def w
          160
        end
        def h
          228
        end
        def img_px
          450
        end
        self
      end
      def landscape
        def w
          238
        end
        def h
          160
        end
        def img_px
          300
        end
        self
      end
      self
    end
    def letter
      def portrait
        def w
          166
        end
        def h
          212
        end
        def img_px
          468
        end
        self
      end
      def landscape
        def w
          226
        end
        def h
          166
        end
        def img_px
          290
        end
        self
      end
      self
    end
    def legal
      def portrait
        def w
          168
        end
        def h
          286
        end
        def img_px
          474
        end
        self
      end
      def landscape
        def w
          296
        end
        def h
          166
        end
        def img_px
          420
        end
        self
      end
      self
    end
    def b5
      def portrait
        def w
          140
        end
        def h
          204
        end
        def img_px
          356
        end
        self
      end
      def landscape
        def w
          200
        end
        def h
          130
        end
        def img_px
          260
        end
        self
      end
      self
    end
    def a5
      def portrait
        def w
          112
        end
        def h
          162
        end
        def img_px
          280
        end
        self
      end
      def landscape
        def w
          152
        end
        def h
          100
        end
        def img_px
          190
        end
        self
      end
      self
    end
    def dimensions
      case @papersize
      when /a4/     then a4
      when /letter/ then letter
      when /legal/  then legal
      when /b5/     then b5
      when /a5/     then a5
      else               a4
      end
    end
  end
end
__END__
