package games.strategy.engine.xml;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;

public class TestAttachment extends DefaultAttachment {
  private static final long serialVersionUID = 4886924951201479496L;
  private String m_value;

  /** Creates new TestAttachment. */
  public TestAttachment(final String name, final Attachable attachable, final GameData gameData) {
    super(name, attachable, gameData);
  }

  @Override
  public Attachable getAttachedTo() {
    return null;
  }

  @InternalDoNotExport
  @Override
  public void setAttachedTo(final Attachable unused) {}

  @Override
  public String getName() {
    return null;
  }

  @InternalDoNotExport
  @Override
  public void setName(final String name) {}

  @GameProperty(xmlProperty = true, gameProperty = true, adds = false)
  public void setValue(final String value) {
    m_value = value;
  }

  public String getValue() {
    return m_value;
  }

  public void resetValue() {
    m_value = null;
  }

  @Override
  public void validate(final GameData data) {}
}
