#ifndef DRW_CPTABLES_H
#define DRW_CPTABLES_H

#include <array>

//first entry in all tables are 0x80
#define CPOFFSET 0x80
constexpr int CPLENGTHCOMMON = 128;

//Table 874
static const std::array<int, CPLENGTHCOMMON> DRW_Table874 = {
    0x20AC, //1 #EURO SIGN
    0x00  , //2 #UNDEFINED
    0x00  , //3 #UNDEFINED
    0x00  , //4 #UNDEFINED
    0x00  , //5 #UNDEFINED
    0x2026, //6 #HORIZONTAL ELLIPSIS
    0x00  , //7 #UNDEFINED
    0x00  , //8 #UNDEFINED
    0x00  , //9 #UNDEFINED
    0x00  , //10 #UNDEFINED
    0x00  , //11 #UNDEFINED
    0x00  , //12 #UNDEFINED
    0x00  , //13 #UNDEFINED
    0x00  , //14 #UNDEFINED
    0x00  , //15 #UNDEFINED
    0x00  , //16 #UNDEFINED
    0x00  , //17 #UNDEFINED
    0x2018, //18 #LEFT SINGLE QUOTATION MARK
    0x2019, //19 #RIGHT SINGLE QUOTATION MARK
    0x201C, //20 #LEFT DOUBLE QUOTATION MARK
    0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
    0x2022, //22 #BULLET
    0x2013, //23 #EN DASH
    0x2014, //24 #EM DASH
    0x00  , //25 #UNDEFINED
    0x00  , //26 #UNDEFINED
    0x00  , //27 #UNDEFINED
    0x00  , //28 #UNDEFINED
    0x00  , //29 #UNDEFINED
    0x00  , //30 #UNDEFINED
    0x00  , //31 #UNDEFINED
    0x00  , //32 #UNDEFINED
    0x00A0, //33 #NO-BREAK SPACE
    0x0E01, //34 #THAI CHARACTER KO KAI
    0x0E02, //35 #THAI CHARACTER KHO KHAI
    0x0E03, //36 #THAI CHARACTER KHO KHUAT
    0x0E04, //37 #THAI CHARACTER KHO KHWAI
    0x0E05, //38 #THAI CHARACTER KHO KHON
    0x0E06, //39 #THAI CHARACTER KHO RAKHANG
    0x0E07, //40 #THAI CHARACTER NGO NGU
    0x0E08, //41 #THAI CHARACTER CHO CHAN
    0x0E09, //42 #THAI CHARACTER CHO CHING
    0x0E0A, //43 #THAI CHARACTER CHO CHANG
    0x0E0B, //44 #THAI CHARACTER SO SO
    0x0E0C, //45 #THAI CHARACTER CHO CHOE
    0x0E0D, //46 #THAI CHARACTER YO YING
    0x0E0E, //47 #THAI CHARACTER DO CHADA
    0x0E0F, //48 #THAI CHARACTER TO PATAK
    0x0E10, //49 #THAI CHARACTER THO THAN
    0x0E11, //50 #THAI CHARACTER THO NANGMONTHO
    0x0E12, //51 #THAI CHARACTER THO PHUTHAO
    0x0E13, //52 #THAI CHARACTER NO NEN
    0x0E14, //53 #THAI CHARACTER DO DEK
    0x0E15, //54 #THAI CHARACTER TO TAO
    0x0E16, //55 #THAI CHARACTER THO THUNG
    0x0E17, //56 #THAI CHARACTER THO THAHAN
    0x0E18, //57 #THAI CHARACTER THO THONG
    0x0E19, //58 #THAI CHARACTER NO NU
    0x0E1A, //59 #THAI CHARACTER BO BAIMAI
    0x0E1B, //60 #THAI CHARACTER PO PLA
    0x0E1C, //61 #THAI CHARACTER PHO PHUNG
    0x0E1D, //62 #THAI CHARACTER FO FA
    0x0E1E, //63 #THAI CHARACTER PHO PHAN
    0x0E1F, //64 #THAI CHARACTER FO FAN
    0x0E20, //65 #THAI CHARACTER PHO SAMPHAO
    0x0E21, //66 #THAI CHARACTER MO MA
    0x0E22, //67 #THAI CHARACTER YO YAK
    0x0E23, //68 #THAI CHARACTER RO RUA
    0x0E24, //69 #THAI CHARACTER RU
    0x0E25, //70 #THAI CHARACTER LO LING
    0x0E26, //71 #THAI CHARACTER LU
    0x0E27, //72 #THAI CHARACTER WO WAEN
    0x0E28, //73 #THAI CHARACTER SO SALA
    0x0E29, //74 #THAI CHARACTER SO RUSI
    0x0E2A, //75 #THAI CHARACTER SO SUA
    0x0E2B, //76 #THAI CHARACTER HO HIP
    0x0E2C, //77 #THAI CHARACTER LO CHULA
    0x0E2D, //78 #THAI CHARACTER O ANG
    0x0E2E, //79 #THAI CHARACTER HO NOKHUK
    0x0E2F, //80 #THAI CHARACTER PAIYANNOI
    0x0E30, //81 #THAI CHARACTER SARA A
    0x0E31, //82 #THAI CHARACTER MAI HAN-AKAT
    0x0E32, //83 #THAI CHARACTER SARA AA
    0x0E33, //84 #THAI CHARACTER SARA AM
    0x0E34, //85 #THAI CHARACTER SARA I
    0x0E35, //86 #THAI CHARACTER SARA II
    0x0E36, //87 #THAI CHARACTER SARA UE
    0x0E37, //88 #THAI CHARACTER SARA UEE
    0x0E38, //89 #THAI CHARACTER SARA U
    0x0E39, //90 #THAI CHARACTER SARA UU
    0x0E3A, //91 #THAI CHARACTER PHINTHU
    0x00  , //92 #UNDEFINED
    0x00  , //93 #UNDEFINED
    0x00  , //94 #UNDEFINED
    0x00  , //95 #UNDEFINED
    0x0E3F, //96 #THAI CURRENCY SYMBOL BAHT
    0x0E40, //97 #THAI CHARACTER SARA E
    0x0E41, //98 #THAI CHARACTER SARA AE
    0x0E42, //99 #THAI CHARACTER SARA O
    0x0E43, //100 #THAI CHARACTER SARA AI MAIMUAN
    0x0E44, //101 #THAI CHARACTER SARA AI MAIMALAI
    0x0E45, //102 #THAI CHARACTER LAKKHANGYAO
    0x0E46, //103 #THAI CHARACTER MAIYAMOK
    0x0E47, //104 #THAI CHARACTER MAITAIKHU
    0x0E48, //105 #THAI CHARACTER MAI EK
    0x0E49, //106 #THAI CHARACTER MAI THO
    0x0E4A, //107 #THAI CHARACTER MAI TRI
    0x0E4B, //108 #THAI CHARACTER MAI CHATTAWA
    0x0E4C, //109 #THAI CHARACTER THANTHAKHAT
    0x0E4D, //110 #THAI CHARACTER NIKHAHIT
    0x0E4E, //111 #THAI CHARACTER YAMAKKAN
    0x0E4F, //112 #THAI CHARACTER FONGMAN
    0x0E50, //113 #THAI DIGIT ZERO
    0x0E51, //114 #THAI DIGIT ONE
    0x0E52, //115 #THAI DIGIT TWO
    0x0E53, //116 #THAI DIGIT THREE
    0x0E54, //117 #THAI DIGIT FOUR
    0x0E55, //118 #THAI DIGIT FIVE
    0x0E56, //119 #THAI DIGIT SIX
    0x0E57, //120 #THAI DIGIT SEVEN
    0x0E58, //121 #THAI DIGIT EIGHT
    0x0E59, //122 #THAI DIGIT NINE
    0x0E5A, //123 #THAI CHARACTER ANGKHANKHU
    0x0E5B, //124 #THAI CHARACTER KHOMUT
    0x00  , //125 #UNDEFINED
    0x00  , //126 #UNDEFINED
    0x00  , //127 #UNDEFINED
    0x00    //128 #UNDEFINED
};

//Table 1250
static const std::array<int, CPLENGTHCOMMON> DRW_Table1250 = {
0x20AC, //1 #EURO SIGN
0x00,   //2 #UNDEFINED
0x201A, //3 #SINGLE LOW-9 QUOTATION MARK
0x00,   //4 #UNDEFINED
0x201E, //5 #DOUBLE LOW-9 QUOTATION MARK
0x2026, //6 #HORIZONTAL ELLIPSIS
0x2020, //7 #DAGGER
0x2021, //8 #DOUBLE DAGGER
0x00,   //9 #UNDEFINED
0x2030, //10 #PER MILLE SIGN
0x0160, //11 #LATIN CAPITAL LETTER S WITH CARON
0x2039, //12 #SINGLE LEFT-POINTING ANGLE QUOTATION MARK
0x015A, //13 #LATIN CAPITAL LETTER S WITH ACUTE
0x0164, //14 #LATIN CAPITAL LETTER T WITH CARON
0x017D, //15 #LATIN CAPITAL LETTER Z WITH CARON
0x0179, //16 #LATIN CAPITAL LETTER Z WITH ACUTE
0x00,   //17 #UNDEFINED
0x2018, //18 #LEFT SINGLE QUOTATION MARK
0x2019, //19 #RIGHT SINGLE QUOTATION MARK
0x201C, //20 #LEFT DOUBLE QUOTATION MARK
0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
0x2022, //22 #BULLET
0x2013, //23 #EN DASH
0x2014, //24 #EM DASH
0x00,   //25 #UNDEFINED
0x2122, //26 #TRADE MARK SIGN
0x0161, //27 #LATIN SMALL LETTER S WITH CARON
0x203A, //28 #SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
0x015B, //29 #LATIN SMALL LETTER S WITH ACUTE
0x0165, //30 #LATIN SMALL LETTER T WITH CARON
0x017E, //31 #LATIN SMALL LETTER Z WITH CARON
0x017A, //32 #LATIN SMALL LETTER Z WITH ACUTE
0x00A0, //33 #NO-BREAK SPACE
0x02C7, //34 #CARON
0x02D8, //35 #BREVE
0x0141, //36 #LATIN CAPITAL LETTER L WITH STROKE
0x00A4, //37 #CURRENCY SIGN
0x0104, //38 #LATIN CAPITAL LETTER A WITH OGONEK
0x00A6, //39 #BROKEN BAR
0x00A7, //40 #SECTION SIGN
0x00A8, //41 #DIAERESIS
0x00A9, //42 #COPYRIGHT SIGN
0x015E, //43 #LATIN CAPITAL LETTER S WITH CEDILLA
0x00AB, //44 #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
0x00AC, //45 #NOT SIGN
0x00AD, //46 #SOFT HYPHEN
0x00AE, //47 #REGISTERED SIGN
0x017B, //48 #LATIN CAPITAL LETTER Z WITH DOT ABOVE
0x00B0, //49 #DEGREE SIGN
0x00B1, //50 #PLUS-MINUS SIGN
0x02DB, //51 #OGONEK
0x0142, //52 #LATIN SMALL LETTER L WITH STROKE
0x00B4, //53 #ACUTE ACCENT
0x00B5, //54 #MICRO SIGN
0x00B6, //55 #PILCROW SIGN
0x00B7, //56 #MIDDLE DOT
0x00B8, //57 #CEDILLA
0x0105, //58 #LATIN SMALL LETTER A WITH OGONEK
0x015F, //59 #LATIN SMALL LETTER S WITH CEDILLA
0x00BB, //60 #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
0x013D, //61 #LATIN CAPITAL LETTER L WITH CARON
0x02DD, //62 #DOUBLE ACUTE ACCENT
0x013E, //63 #LATIN SMALL LETTER L WITH CARON
0x017C, //64 #LATIN SMALL LETTER Z WITH DOT ABOVE
0x0154, //65 #LATIN CAPITAL LETTER R WITH ACUTE
0x00C1, //66 #LATIN CAPITAL LETTER A WITH ACUTE
0x00C2, //67 #LATIN CAPITAL LETTER A WITH CIRCUMFLEX
0x0102, //68 #LATIN CAPITAL LETTER A WITH BREVE
0x00C4, //69 #LATIN CAPITAL LETTER A WITH DIAERESIS
0x0139, //70 #LATIN CAPITAL LETTER L WITH ACUTE
0x0106, //71 #LATIN CAPITAL LETTER C WITH ACUTE
0x00C7, //72 #LATIN CAPITAL LETTER C WITH CEDILLA
0x010C, //73 #LATIN CAPITAL LETTER C WITH CARON
0x00C9, //74 #LATIN CAPITAL LETTER E WITH ACUTE
0x0118, //75 #LATIN CAPITAL LETTER E WITH OGONEK
0x00CB, //76 #LATIN CAPITAL LETTER E WITH DIAERESIS
0x011A, //77 #LATIN CAPITAL LETTER E WITH CARON
0x00CD, //78 #LATIN CAPITAL LETTER I WITH ACUTE
0x00CE, //79 #LATIN CAPITAL LETTER I WITH CIRCUMFLEX
0x010E, //80 #LATIN CAPITAL LETTER D WITH CARON
0x0110, //81 #LATIN CAPITAL LETTER D WITH STROKE
0x0143, //82 #LATIN CAPITAL LETTER N WITH ACUTE
0x0147, //83 #LATIN CAPITAL LETTER N WITH CARON
0x00D3, //84 #LATIN CAPITAL LETTER O WITH ACUTE
0x00D4, //85 #LATIN CAPITAL LETTER O WITH CIRCUMFLEX
0x0150, //86 #LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
0x00D6, //87 #LATIN CAPITAL LETTER O WITH DIAERESIS
0x00D7, //88 #MULTIPLICATION SIGN
0x0158, //89 #LATIN CAPITAL LETTER R WITH CARON
0x016E, //90 #LATIN CAPITAL LETTER U WITH RING ABOVE
0x00DA, //91 #LATIN CAPITAL LETTER U WITH ACUTE
0x0170, //92 #LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
0x00DC, //93 #LATIN CAPITAL LETTER U WITH DIAERESIS
0x00DD, //94 #LATIN CAPITAL LETTER Y WITH ACUTE
0x0162, //95 #LATIN CAPITAL LETTER T WITH CEDILLA
0x00DF, //96 #LATIN SMALL LETTER SHARP S
0x0155, //97 #LATIN SMALL LETTER R WITH ACUTE
0x00E1, //98 #LATIN SMALL LETTER A WITH ACUTE
0x00E2, //99 #LATIN SMALL LETTER A WITH CIRCUMFLEX
0x0103, //100 #LATIN SMALL LETTER A WITH BREVE
0x00E4, //101 #LATIN SMALL LETTER A WITH DIAERESIS
0x013A, //102 #LATIN SMALL LETTER L WITH ACUTE
0x0107, //103 #LATIN SMALL LETTER C WITH ACUTE
0x00E7, //104 #LATIN SMALL LETTER C WITH CEDILLA
0x010D, //105 #LATIN SMALL LETTER C WITH CARON
0x00E9, //106 #LATIN SMALL LETTER E WITH ACUTE
0x0119, //107 #LATIN SMALL LETTER E WITH OGONEK
0x00EB, //108 #LATIN SMALL LETTER E WITH DIAERESIS
0x011B, //109 #LATIN SMALL LETTER E WITH CARON
0x00ED, //110 #LATIN SMALL LETTER I WITH ACUTE
0x00EE, //111 #LATIN SMALL LETTER I WITH CIRCUMFLEX
0x010F, //112 #LATIN SMALL LETTER D WITH CARON
0x0111, //113 #LATIN SMALL LETTER D WITH STROKE
0x0144, //114 #LATIN SMALL LETTER N WITH ACUTE
0x0148, //115 #LATIN SMALL LETTER N WITH CARON
0x00F3, //116 #LATIN SMALL LETTER O WITH ACUTE
0x00F4, //117 #LATIN SMALL LETTER O WITH CIRCUMFLEX
0x0151, //118 #LATIN SMALL LETTER O WITH DOUBLE ACUTE
0x00F6, //119 #LATIN SMALL LETTER O WITH DIAERESIS
0x00F7, //120 #DIVISION SIGN
0x0159, //121 #LATIN SMALL LETTER R WITH CARON
0x016F, //122 #LATIN SMALL LETTER U WITH RING ABOVE
0x00FA, //123 #LATIN SMALL LETTER U WITH ACUTE
0x0171, //124 #LATIN SMALL LETTER U WITH DOUBLE ACUTE
0x00FC, //125 #LATIN SMALL LETTER U WITH DIAERESIS
0x00FD, //126 #LATIN SMALL LETTER Y WITH ACUTE
0x0163, //127 #LATIN SMALL LETTER T WITH CEDILLA
0x02D9 //128 #DOT ABOVE
};


//Table 1251
static const std::array<int, CPLENGTHCOMMON> DRW_Table1251 = {
    0x0402, //1 #CYRILLIC CAPITAL LETTER DJE
    0x0403, //2 #CYRILLIC CAPITAL LETTER GJE
    0x201A, //3 #SINGLE LOW-9 QUOTATION MARK
    0x0453, //4 #CYRILLIC SMALL LETTER GJE
    0x201E, //5 #DOUBLE LOW-9 QUOTATION MARK
    0x2026, //6 #HORIZONTAL ELLIPSIS
    0x2020, //7 #DAGGER
    0x2021, //8 #DOUBLE DAGGER
    0x20AC, //9 #EURO SIGN
    0x2030, //10 #PER MILLE SIGN
    0x0409, //11 #CYRILLIC CAPITAL LETTER LJE
    0x2039, //12 #SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    0x040A, //13 #CYRILLIC CAPITAL LETTER NJE
    0x040C, //14 #CYRILLIC CAPITAL LETTER KJE
    0x040B, //15 #CYRILLIC CAPITAL LETTER TSHE
    0x040F, //16 #CYRILLIC CAPITAL LETTER DZHE
    0x0452, //17 #CYRILLIC SMALL LETTER DJE
    0x2018, //18 #LEFT SINGLE QUOTATION MARK
    0x2019, //19 #RIGHT SINGLE QUOTATION MARK
    0x201C, //20 #LEFT DOUBLE QUOTATION MARK
    0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
    0x2022, //22 #BULLET
    0x2013, //23 #EN DASH
    0x2014, //24 #EM DASH
    0x00,   //25 #UNDEFINED
    0x2122, //26 #TRADE MARK SIGN
    0x0459, //27 #CYRILLIC SMALL LETTER LJE
    0x203A, //28 #SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    0x045A, //29 #CYRILLIC SMALL LETTER NJE
    0x045C, //30 #CYRILLIC SMALL LETTER KJE
    0x045B, //31 #CYRILLIC SMALL LETTER TSHE
    0x045F, //32 #CYRILLIC SMALL LETTER DZHE
    0x00A0, //33 #NO-BREAK SPACE
    0x040E, //34 #CYRILLIC CAPITAL LETTER SHORT U
    0x045E, //35 #CYRILLIC SMALL LETTER SHORT U
    0x0408, //36 #CYRILLIC CAPITAL LETTER JE
    0x00A4, //37 #CURRENCY SIGN
    0x0490, //38 #CYRILLIC CAPITAL LETTER GHE WITH UPTURN
    0x00A6, //39 #BROKEN BAR
    0x00A7, //40 #SECTION SIGN
    0x0401, //41 #CYRILLIC CAPITAL LETTER IO
    0x00A9, //42 #COPYRIGHT SIGN
    0x0404, //43 #CYRILLIC CAPITAL LETTER UKRAINIAN IE
    0x00AB, //44 #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00AC, //45 #NOT SIGN
    0x00AD, //46 #SOFT HYPHEN
    0x00AE, //47 #REGISTERED SIGN
    0x0407, //48 #CYRILLIC CAPITAL LETTER YI
    0x00B0, //49 #DEGREE SIGN
    0x00B1, //50 #PLUS-MINUS SIGN
    0x0406, //51 #CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
    0x0456, //52 #CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    0x0491, //53 #CYRILLIC SMALL LETTER GHE WITH UPTURN
    0x00B5, //54 #MICRO SIGN
    0x00B6, //55 #PILCROW SIGN
    0x00B7, //56 #MIDDLE DOT
    0x0451, //57 #CYRILLIC SMALL LETTER IO
    0x2116, //58 #NUMERO SIGN
    0x0454, //59 #CYRILLIC SMALL LETTER UKRAINIAN IE
    0x00BB, //60 #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x0458, //61 #CYRILLIC SMALL LETTER JE
    0x0405, //62 #CYRILLIC CAPITAL LETTER DZE
    0x0455, //63 #CYRILLIC SMALL LETTER DZE
    0x0457, //64 #CYRILLIC SMALL LETTER YI
    0x0410, //65 #CYRILLIC CAPITAL LETTER A
    0x0411, //66 #CYRILLIC CAPITAL LETTER BE
    0x0412, //67 #CYRILLIC CAPITAL LETTER VE
    0x0413, //68 #CYRILLIC CAPITAL LETTER GHE
    0x0414, //69 #CYRILLIC CAPITAL LETTER DE
    0x0415, //70 #CYRILLIC CAPITAL LETTER IE
    0x0416, //71 #CYRILLIC CAPITAL LETTER ZHE
    0x0417, //72 #CYRILLIC CAPITAL LETTER ZE
    0x0418, //73 #CYRILLIC CAPITAL LETTER I
    0x0419, //74 #CYRILLIC CAPITAL LETTER SHORT I
    0x041A, //75 #CYRILLIC CAPITAL LETTER KA
    0x041B, //76 #CYRILLIC CAPITAL LETTER EL
    0x041C, //77 #CYRILLIC CAPITAL LETTER EM
    0x041D, //78 #CYRILLIC CAPITAL LETTER EN
    0x041E, //79 #CYRILLIC CAPITAL LETTER O
    0x041F, //80 #CYRILLIC CAPITAL LETTER PE
    0x0420, //81 #CYRILLIC CAPITAL LETTER ER
    0x0421, //82 #CYRILLIC CAPITAL LETTER ES
    0x0422, //83 #CYRILLIC CAPITAL LETTER TE
    0x0423, //84 #CYRILLIC CAPITAL LETTER U
    0x0424, //85 #CYRILLIC CAPITAL LETTER EF
    0x0425, //86 #CYRILLIC CAPITAL LETTER HA
    0x0426, //87 #CYRILLIC CAPITAL LETTER TSE
    0x0427, //88 #CYRILLIC CAPITAL LETTER CHE
    0x0428, //89 #CYRILLIC CAPITAL LETTER SHA
    0x0429, //90 #CYRILLIC CAPITAL LETTER SHCHA
    0x042A, //91 #CYRILLIC CAPITAL LETTER HARD SIGN
    0x042B, //92 #CYRILLIC CAPITAL LETTER YERU
    0x042C, //93 #CYRILLIC CAPITAL LETTER SOFT SIGN
    0x042D, //94 #CYRILLIC CAPITAL LETTER E
    0x042E, //95 #CYRILLIC CAPITAL LETTER YU
    0x042F, //96 #CYRILLIC CAPITAL LETTER YA
    0x0430, //97 #CYRILLIC SMALL LETTER A
    0x0431, //98 #CYRILLIC SMALL LETTER BE
    0x0432, //99 #CYRILLIC SMALL LETTER VE
    0x0433, //100 #CYRILLIC SMALL LETTER GHE
    0x0434, //101 #CYRILLIC SMALL LETTER DE
    0x0435, //102 #CYRILLIC SMALL LETTER IE
    0x0436, //103 #CYRILLIC SMALL LETTER ZHE
    0x0437, //104 #CYRILLIC SMALL LETTER ZE
    0x0438, //105 #CYRILLIC SMALL LETTER I
    0x0439, //106 #CYRILLIC SMALL LETTER SHORT I
    0x043A, //107 #CYRILLIC SMALL LETTER KA
    0x043B, //108 #CYRILLIC SMALL LETTER EL
    0x043C, //109 #CYRILLIC SMALL LETTER EM
    0x043D, //110 #CYRILLIC SMALL LETTER EN
    0x043E, //111 #CYRILLIC SMALL LETTER O
    0x043F, //112 #CYRILLIC SMALL LETTER PE
    0x0440, //113 #CYRILLIC SMALL LETTER ER
    0x0441, //114 #CYRILLIC SMALL LETTER ES
    0x0442, //115 #CYRILLIC SMALL LETTER TE
    0x0443, //116 #CYRILLIC SMALL LETTER U
    0x0444, //117 #CYRILLIC SMALL LETTER EF
    0x0445, //118 #CYRILLIC SMALL LETTER HA
    0x0446, //119 #CYRILLIC SMALL LETTER TSE
    0x0447, //120 #CYRILLIC SMALL LETTER CHE
    0x0448, //121 #CYRILLIC SMALL LETTER SHA
    0x0449, //122 #CYRILLIC SMALL LETTER SHCHA
    0x044A, //123 #CYRILLIC SMALL LETTER HARD SIGN
    0x044B, //124 #CYRILLIC SMALL LETTER YERU
    0x044C, //125 #CYRILLIC SMALL LETTER SOFT SIGN
    0x044D, //126 #CYRILLIC SMALL LETTER E
    0x044E, //127 #CYRILLIC SMALL LETTER YU
    0x044F  //128 #CYRILLIC SMALL LETTER YA
};


//Table 1252
static const std::array<int, CPLENGTHCOMMON> DRW_Table1252 = {
    0x20AC, //1 #EURO SIGN
    0x00,   //2 #UNDEFINED
    0x201A, //3 #SINGLE LOW-9 QUOTATION MARK
    0x0192, //4 #LATIN SMALL LETTER F WITH HOOK
    0x201E, //5 #DOUBLE LOW-9 QUOTATION MARK
    0x2026, //6 #HORIZONTAL ELLIPSIS
    0x2020, //7 #DAGGER
    0x2021, //8 #DOUBLE DAGGER
    0x02C6, //9 #MODIFIER LETTER CIRCUMFLEX ACCENT
    0x2030, //10 #PER MILLE SIGN
    0x0160, //11 #LATIN CAPITAL LETTER S WITH CARON
    0x2039, //12 #SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    0x0152, //13 #LATIN CAPITAL LIGATURE OE
    0x00,   //14 #UNDEFINED
    0x017D, //15 #LATIN CAPITAL LETTER Z WITH CARON
    0x00,   //16 #UNDEFINED
    0x00,   //17 #UNDEFINED
    0x2018, //18 #LEFT SINGLE QUOTATION MARK
    0x2019, //19 #RIGHT SINGLE QUOTATION MARK
    0x201C, //20 #LEFT DOUBLE QUOTATION MARK
    0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
    0x2022, //22 #BULLET
    0x2013, //23 #EN DASH
    0x2014, //24 #EM DASH
    0x02DC, //25 #SMALL TILDE
    0x2122, //26 #TRADE MARK SIGN
    0x0161, //27 #LATIN SMALL LETTER S WITH CARON
    0x203A, //28 #SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    0x0153, //29 #LATIN SMALL LIGATURE OE
    0x00,   //30 #UNDEFINED
    0x017E, //31 #LATIN SMALL LETTER Z WITH CARON
    0x0178, //32 #LATIN CAPITAL LETTER Y WITH DIAERESIS
    0x00A0, //33 #NO-BREAK SPACE
    0x00A1, //34 #INVERTED EXCLAMATION MARK
    0x00A2, //35 #CENT SIGN
    0x00A3, //36 #POUND SIGN
    0x00A4, //37 #CURRENCY SIGN
    0x00A5, //38 #YEN SIGN
    0x00A6, //39 #BROKEN BAR
    0x00A7, //40 #SECTION SIGN
    0x00A8, //41 #DIAERESIS
    0x00A9, //42 #COPYRIGHT SIGN
    0x00AA, //43 #FEMININE ORDINAL INDICATOR
    0x00AB, //44 #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00AC, //45 #NOT SIGN
    0x00AD, //46 #SOFT HYPHEN
    0x00AE, //47 #REGISTERED SIGN
    0x00AF, //48 #MACRON
    0x00B0, //49 #DEGREE SIGN
    0x00B1, //50 #PLUS-MINUS SIGN
    0x00B2, //51 #SUPERSCRIPT TWO
    0x00B3, //52 #SUPERSCRIPT THREE
    0x00B4, //53 #ACUTE ACCENT
    0x00B5, //54 #MICRO SIGN
    0x00B6, //55 #PILCROW SIGN
    0x00B7, //56 #MIDDLE DOT
    0x00B8, //57 #CEDILLA
    0x00B9, //58 #SUPERSCRIPT ONE
    0x00BA, //59 #MASCULINE ORDINAL INDICATOR
    0x00BB, //60 #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00BC, //61 #VULGAR FRACTION ONE QUARTER
    0x00BD, //62 #VULGAR FRACTION ONE HALF
    0x00BE, //63 #VULGAR FRACTION THREE QUARTERS
    0x00BF, //64 #INVERTED QUESTION MARK
    0x00C0, //65 #LATIN CAPITAL LETTER A WITH GRAVE
    0x00C1, //66 #LATIN CAPITAL LETTER A WITH ACUTE
    0x00C2, //67 #LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x00C3, //68 #LATIN CAPITAL LETTER A WITH TILDE
    0x00C4, //69 #LATIN CAPITAL LETTER A WITH DIAERESIS
    0x00C5, //70 #LATIN CAPITAL LETTER A WITH RING ABOVE
    0x00C6, //71 #LATIN CAPITAL LETTER AE
    0x00C7, //72 #LATIN CAPITAL LETTER C WITH CEDILLA
    0x00C8, //73 #LATIN CAPITAL LETTER E WITH GRAVE
    0x00C9, //74 #LATIN CAPITAL LETTER E WITH ACUTE
    0x00CA, //75 #LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x00CB, //76 #LATIN CAPITAL LETTER E WITH DIAERESIS
    0x00CC, //77 #LATIN CAPITAL LETTER I WITH GRAVE
    0x00CD, //78 #LATIN CAPITAL LETTER I WITH ACUTE
    0x00CE, //79 #LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x00CF, //80 #LATIN CAPITAL LETTER I WITH DIAERESIS
    0x00D0, //81 #LATIN CAPITAL LETTER ETH
    0x00D1, //82 #LATIN CAPITAL LETTER N WITH TILDE
    0x00D2, //83 #LATIN CAPITAL LETTER O WITH GRAVE
    0x00D3, //84 #LATIN CAPITAL LETTER O WITH ACUTE
    0x00D4, //85 #LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x00D5, //86 #LATIN CAPITAL LETTER O WITH TILDE
    0x00D6, //87 #LATIN CAPITAL LETTER O WITH DIAERESIS
    0x00D7, //88 #MULTIPLICATION SIGN
    0x00D8, //89 #LATIN CAPITAL LETTER O WITH STROKE
    0x00D9, //90 #LATIN CAPITAL LETTER U WITH GRAVE
    0x00DA, //91 #LATIN CAPITAL LETTER U WITH ACUTE
    0x00DB, //92 #LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x00DC, //93 #LATIN CAPITAL LETTER U WITH DIAERESIS
    0x00DD, //94 #LATIN CAPITAL LETTER Y WITH ACUTE
    0x00DE, //95 #LATIN CAPITAL LETTER THORN
    0x00DF, //96 #LATIN SMALL LETTER SHARP S
    0x00E0, //97 #LATIN SMALL LETTER A WITH GRAVE
    0x00E1, //98 #LATIN SMALL LETTER A WITH ACUTE
    0x00E2, //99 #LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x00E3, //100 #LATIN SMALL LETTER A WITH TILDE
    0x00E4, //101 #LATIN SMALL LETTER A WITH DIAERESIS
    0x00E5, //102 #LATIN SMALL LETTER A WITH RING ABOVE
    0x00E6, //103 #LATIN SMALL LETTER AE
    0x00E7, //104 #LATIN SMALL LETTER C WITH CEDILLA
    0x00E8, //105 #LATIN SMALL LETTER E WITH GRAVE
    0x00E9, //106 #LATIN SMALL LETTER E WITH ACUTE
    0x00EA, //107 #LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x00EB, //108 #LATIN SMALL LETTER E WITH DIAERESIS
    0x00EC, //109 #LATIN SMALL LETTER I WITH GRAVE
    0x00ED, //110 #LATIN SMALL LETTER I WITH ACUTE
    0x00EE, //111 #LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x00EF, //112 #LATIN SMALL LETTER I WITH DIAERESIS
    0x00F0, //113 #LATIN SMALL LETTER ETH
    0x00F1, //114 #LATIN SMALL LETTER N WITH TILDE
    0x00F2, //115 #LATIN SMALL LETTER O WITH GRAVE
    0x00F3, //116 #LATIN SMALL LETTER O WITH ACUTE
    0x00F4, //117 #LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x00F5, //118 #LATIN SMALL LETTER O WITH TILDE
    0x00F6, //119 #LATIN SMALL LETTER O WITH DIAERESIS
    0x00F7, //120 #DIVISION SIGN
    0x00F8, //121 #LATIN SMALL LETTER O WITH STROKE
    0x00F9, //122 #LATIN SMALL LETTER U WITH GRAVE
    0x00FA, //123 #LATIN SMALL LETTER U WITH ACUTE
    0x00FB, //124 #LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x00FC, //125 #LATIN SMALL LETTER U WITH DIAERESIS
    0x00FD, //126 #LATIN SMALL LETTER Y WITH ACUTE
    0x00FE, //127 #LATIN SMALL LETTER THORN
    0x00FF  //128 #LATIN SMALL LETTER Y WITH DIAERESIS
};

//Table 1253
static const std::array<int, CPLENGTHCOMMON> DRW_Table1253 = {
    0x20AC, //1 #EURO SIGN
    0x00  , //2 #UNDEFINED
    0x201A, //3 #SINGLE LOW-9 QUOTATION MARK
    0x0192, //4 #LATIN SMALL LETTER F WITH HOOK
    0x201E, //5 #DOUBLE LOW-9 QUOTATION MARK
    0x2026, //6 #HORIZONTAL ELLIPSIS
    0x2020, //7 #DAGGER
    0x2021, //8 #DOUBLE DAGGER
    0x00  , //9 #UNDEFINED
    0x2030, //10 #PER MILLE SIGN
    0x00  , //11 #UNDEFINED
    0x2039, //12 #SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    0x00  , //13 #UNDEFINED
    0x00  , //14 #UNDEFINED
    0x00  , //15 #UNDEFINED
    0x00  , //16 #UNDEFINED
    0x00  , //17 #UNDEFINED
    0x2018, //18 #LEFT SINGLE QUOTATION MARK
    0x2019, //19 #RIGHT SINGLE QUOTATION MARK
    0x201C, //20 #LEFT DOUBLE QUOTATION MARK
    0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
    0x2022, //22 #BULLET
    0x2013, //23 #EN DASH
    0x2014, //24 #EM DASH
    0x00  , //25 #UNDEFINED
    0x2122, //26 #TRADE MARK SIGN
    0x00  , //27 #UNDEFINED
    0x203A, //28 #SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    0x00  , //29 #UNDEFINED
    0x00  , //30 #UNDEFINED
    0x00  , //31 #UNDEFINED
    0x00  , //32 #UNDEFINED
    0x00A0, //33 #NO-BREAK SPACE
    0x0385, //34 #GREEK DIALYTIKA TONOS
    0x0386, //35 #GREEK CAPITAL LETTER ALPHA WITH TONOS
    0x00A3, //36 #POUND SIGN
    0x00A4, //37 #CURRENCY SIGN
    0x00A5, //38 #YEN SIGN
    0x00A6, //39 #BROKEN BAR
    0x00A7, //40 #SECTION SIGN
    0x00A8, //41 #DIAERESIS
    0x00A9, //42 #COPYRIGHT SIGN
    0x00  , //43 #UNDEFINED
    0x00AB, //44 #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00AC, //45 #NOT SIGN
    0x00AD, //46 #SOFT HYPHEN
    0x00AE, //47 #REGISTERED SIGN
    0x2015, //48 #HORIZONTAL BAR
    0x00B0, //49 #DEGREE SIGN
    0x00B1, //50 #PLUS-MINUS SIGN
    0x00B2, //51 #SUPERSCRIPT TWO
    0x00B3, //52 #SUPERSCRIPT THREE
    0x0384, //53 #GREEK TONOS
    0x00B5, //54 #MICRO SIGN
    0x00B6, //55 #PILCROW SIGN
    0x00B7, //56 #MIDDLE DOT
    0x0388, //57 #GREEK CAPITAL LETTER EPSILON WITH TONOS
    0x0389, //58 #GREEK CAPITAL LETTER ETA WITH TONOS
    0x038A, //59 #GREEK CAPITAL LETTER IOTA WITH TONOS
    0x00BB, //60 #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x038C, //61 #GREEK CAPITAL LETTER OMICRON WITH TONOS
    0x00BD, //62 #VULGAR FRACTION ONE HALF
    0x038E, //63 #GREEK CAPITAL LETTER UPSILON WITH TONOS
    0x038F, //64 #GREEK CAPITAL LETTER OMEGA WITH TONOS
    0x0390, //65 #GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
    0x0391, //66 #GREEK CAPITAL LETTER ALPHA
    0x0392, //67 #GREEK CAPITAL LETTER BETA
    0x0393, //68 #GREEK CAPITAL LETTER GAMMA
    0x0394, //69 #GREEK CAPITAL LETTER DELTA
    0x0395, //70 #GREEK CAPITAL LETTER EPSILON
    0x0396, //71 #GREEK CAPITAL LETTER ZETA
    0x0397, //72 #GREEK CAPITAL LETTER ETA
    0x0398, //73 #GREEK CAPITAL LETTER THETA
    0x0399, //74 #GREEK CAPITAL LETTER IOTA
    0x039A, //75 #GREEK CAPITAL LETTER KAPPA
    0x039B, //76 #GREEK CAPITAL LETTER LAMDA
    0x039C, //77 #GREEK CAPITAL LETTER MU
    0x039D, //78 #GREEK CAPITAL LETTER NU
    0x039E, //79 #GREEK CAPITAL LETTER XI
    0x039F, //80 #GREEK CAPITAL LETTER OMICRON
    0x03A0, //81 #GREEK CAPITAL LETTER PI
    0x03A1, //82 #GREEK CAPITAL LETTER RHO
    0x00  , //83 #UNDEFINED
    0x03A3, //84 #GREEK CAPITAL LETTER SIGMA
    0x03A4, //85 #GREEK CAPITAL LETTER TAU
    0x03A5, //86 #GREEK CAPITAL LETTER UPSILON
    0x03A6, //87 #GREEK CAPITAL LETTER PHI
    0x03A7, //88 #GREEK CAPITAL LETTER CHI
    0x03A8, //89 #GREEK CAPITAL LETTER PSI
    0x03A9, //90 #GREEK CAPITAL LETTER OMEGA
    0x03AA, //91 #GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
    0x03AB, //92 #GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
    0x03AC, //93 #GREEK SMALL LETTER ALPHA WITH TONOS
    0x03AD, //94 #GREEK SMALL LETTER EPSILON WITH TONOS
    0x03AE, //95 #GREEK SMALL LETTER ETA WITH TONOS
    0x03AF, //96 #GREEK SMALL LETTER IOTA WITH TONOS
    0x03B0, //97 #GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
    0x03B1, //98 #GREEK SMALL LETTER ALPHA
    0x03B2, //99 #GREEK SMALL LETTER BETA
    0x03B3, //100 #GREEK SMALL LETTER GAMMA
    0x03B4, //101 #GREEK SMALL LETTER DELTA
    0x03B5, //102 #GREEK SMALL LETTER EPSILON
    0x03B6, //103 #GREEK SMALL LETTER ZETA
    0x03B7, //104 #GREEK SMALL LETTER ETA
    0x03B8, //105 #GREEK SMALL LETTER THETA
    0x03B9, //106 #GREEK SMALL LETTER IOTA
    0x03BA, //107 #GREEK SMALL LETTER KAPPA
    0x03BB, //108 #GREEK SMALL LETTER LAMDA
    0x03BC, //109 #GREEK SMALL LETTER MU
    0x03BD, //110 #GREEK SMALL LETTER NU
    0x03BE, //111 #GREEK SMALL LETTER XI
    0x03BF, //112 #GREEK SMALL LETTER OMICRON
    0x03C0, //113 #GREEK SMALL LETTER PI
    0x03C1, //114 #GREEK SMALL LETTER RHO
    0x03C2, //115 #GREEK SMALL LETTER FINAL SIGMA
    0x03C3, //116 #GREEK SMALL LETTER SIGMA
    0x03C4, //117 #GREEK SMALL LETTER TAU
    0x03C5, //118 #GREEK SMALL LETTER UPSILON
    0x03C6, //119 #GREEK SMALL LETTER PHI
    0x03C7, //120 #GREEK SMALL LETTER CHI
    0x03C8, //121 #GREEK SMALL LETTER PSI
    0x03C9, //122 #GREEK SMALL LETTER OMEGA
    0x03CA, //123 #GREEK SMALL LETTER IOTA WITH DIALYTIKA
    0x03CB, //124 #GREEK SMALL LETTER UPSILON WITH DIALYTIKA
    0x03CC, //125 #GREEK SMALL LETTER OMICRON WITH TONOS
    0x03CD, //126 #GREEK SMALL LETTER UPSILON WITH TONOS
    0x03CE, //127 #GREEK SMALL LETTER OMEGA WITH TONOS
    0x00    //128 #UNDEFINED
};

//Table 1254
static const std::array<int, CPLENGTHCOMMON> DRW_Table1254 = {
    0x20AC, //1 #EURO SIGN
    0x00  , //2 #UNDEFINED
    0x201A, //3 #SINGLE LOW-9 QUOTATION MARK
    0x0192, //4 #LATIN SMALL LETTER F WITH HOOK
    0x201E, //5 #DOUBLE LOW-9 QUOTATION MARK
    0x2026, //6 #HORIZONTAL ELLIPSIS
    0x2020, //7 #DAGGER
    0x2021, //8 #DOUBLE DAGGER
    0x02C6, //9 #MODIFIER LETTER CIRCUMFLEX ACCENT
    0x2030, //10 #PER MILLE SIGN
    0x0160, //11 #LATIN CAPITAL LETTER S WITH CARON
    0x2039, //12 #SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    0x0152, //13 #LATIN CAPITAL LIGATURE OE
    0x00  , //14 #UNDEFINED
    0x00  , //15 #UNDEFINED
    0x00  , //16 #UNDEFINED
    0x00  , //17 #UNDEFINED
    0x2018, //18 #LEFT SINGLE QUOTATION MARK
    0x2019, //19 #RIGHT SINGLE QUOTATION MARK
    0x201C, //20 #LEFT DOUBLE QUOTATION MARK
    0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
    0x2022, //22 #BULLET
    0x2013, //23 #EN DASH
    0x2014, //24 #EM DASH
    0x02DC, //25 #SMALL TILDE
    0x2122, //26 #TRADE MARK SIGN
    0x0161, //27 #LATIN SMALL LETTER S WITH CARON
    0x203A, //28 #SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    0x0153, //29 #LATIN SMALL LIGATURE OE
    0x00  , //30 #UNDEFINED
    0x00  , //31 #UNDEFINED
    0x0178, //32 #LATIN CAPITAL LETTER Y WITH DIAERESIS
    0x00A0, //33 #NO-BREAK SPACE
    0x00A1, //34 #INVERTED EXCLAMATION MARK
    0x00A2, //35 #CENT SIGN
    0x00A3, //36 #POUND SIGN
    0x00A4, //37 #CURRENCY SIGN
    0x00A5, //38 #YEN SIGN
    0x00A6, //39 #BROKEN BAR
    0x00A7, //40 #SECTION SIGN
    0x00A8, //41 #DIAERESIS
    0x00A9, //42 #COPYRIGHT SIGN
    0x00AA, //43 #FEMININE ORDINAL INDICATOR
    0x00AB, //44 #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00AC, //45 #NOT SIGN
    0x00AD, //46 #SOFT HYPHEN
    0x00AE, //47 #REGISTERED SIGN
    0x00AF, //48 #MACRON
    0x00B0, //49 #DEGREE SIGN
    0x00B1, //50 #PLUS-MINUS SIGN
    0x00B2, //51 #SUPERSCRIPT TWO
    0x00B3, //52 #SUPERSCRIPT THREE
    0x00B4, //53 #ACUTE ACCENT
    0x00B5, //54 #MICRO SIGN
    0x00B6, //55 #PILCROW SIGN
    0x00B7, //56 #MIDDLE DOT
    0x00B8, //57 #CEDILLA
    0x00B9, //58 #SUPERSCRIPT ONE
    0x00BA, //59 #MASCULINE ORDINAL INDICATOR
    0x00BB, //60 #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00BC, //61 #VULGAR FRACTION ONE QUARTER
    0x00BD, //62 #VULGAR FRACTION ONE HALF
    0x00BE, //63 #VULGAR FRACTION THREE QUARTERS
    0x00BF, //64 #INVERTED QUESTION MARK
    0x00C0, //65 #LATIN CAPITAL LETTER A WITH GRAVE
    0x00C1, //66 #LATIN CAPITAL LETTER A WITH ACUTE
    0x00C2, //67 #LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x00C3, //68 #LATIN CAPITAL LETTER A WITH TILDE
    0x00C4, //69 #LATIN CAPITAL LETTER A WITH DIAERESIS
    0x00C5, //70 #LATIN CAPITAL LETTER A WITH RING ABOVE
    0x00C6, //71 #LATIN CAPITAL LETTER AE
    0x00C7, //72 #LATIN CAPITAL LETTER C WITH CEDILLA
    0x00C8, //73 #LATIN CAPITAL LETTER E WITH GRAVE
    0x00C9, //74 #LATIN CAPITAL LETTER E WITH ACUTE
    0x00CA, //75 #LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x00CB, //76 #LATIN CAPITAL LETTER E WITH DIAERESIS
    0x00CC, //77 #LATIN CAPITAL LETTER I WITH GRAVE
    0x00CD, //78 #LATIN CAPITAL LETTER I WITH ACUTE
    0x00CE, //79 #LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x00CF, //80 #LATIN CAPITAL LETTER I WITH DIAERESIS
    0x011E, //81 #LATIN CAPITAL LETTER G WITH BREVE
    0x00D1, //82 #LATIN CAPITAL LETTER N WITH TILDE
    0x00D2, //83 #LATIN CAPITAL LETTER O WITH GRAVE
    0x00D3, //84 #LATIN CAPITAL LETTER O WITH ACUTE
    0x00D4, //85 #LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x00D5, //86 #LATIN CAPITAL LETTER O WITH TILDE
    0x00D6, //87 #LATIN CAPITAL LETTER O WITH DIAERESIS
    0x00D7, //88 #MULTIPLICATION SIGN
    0x00D8, //89 #LATIN CAPITAL LETTER O WITH STROKE
    0x00D9, //90 #LATIN CAPITAL LETTER U WITH GRAVE
    0x00DA, //91 #LATIN CAPITAL LETTER U WITH ACUTE
    0x00DB, //92 #LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x00DC, //93 #LATIN CAPITAL LETTER U WITH DIAERESIS
    0x0130, //94 #LATIN CAPITAL LETTER I WITH DOT ABOVE
    0x015E, //95 #LATIN CAPITAL LETTER S WITH CEDILLA
    0x00DF, //96 #LATIN SMALL LETTER SHARP S
    0x00E0, //97 #LATIN SMALL LETTER A WITH GRAVE
    0x00E1, //98 #LATIN SMALL LETTER A WITH ACUTE
    0x00E2, //99 #LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x00E3, //100 #LATIN SMALL LETTER A WITH TILDE
    0x00E4, //101 #LATIN SMALL LETTER A WITH DIAERESIS
    0x00E5, //102 #LATIN SMALL LETTER A WITH RING ABOVE
    0x00E6, //103 #LATIN SMALL LETTER AE
    0x00E7, //104 #LATIN SMALL LETTER C WITH CEDILLA
    0x00E8, //105 #LATIN SMALL LETTER E WITH GRAVE
    0x00E9, //106 #LATIN SMALL LETTER E WITH ACUTE
    0x00EA, //107 #LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x00EB, //108 #LATIN SMALL LETTER E WITH DIAERESIS
    0x00EC, //109 #LATIN SMALL LETTER I WITH GRAVE
    0x00ED, //110 #LATIN SMALL LETTER I WITH ACUTE
    0x00EE, //111 #LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x00EF, //112 #LATIN SMALL LETTER I WITH DIAERESIS
    0x011F, //113 #LATIN SMALL LETTER G WITH BREVE
    0x00F1, //114 #LATIN SMALL LETTER N WITH TILDE
    0x00F2, //115 #LATIN SMALL LETTER O WITH GRAVE
    0x00F3, //116 #LATIN SMALL LETTER O WITH ACUTE
    0x00F4, //117 #LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x00F5, //118 #LATIN SMALL LETTER O WITH TILDE
    0x00F6, //119 #LATIN SMALL LETTER O WITH DIAERESIS
    0x00F7, //120 #DIVISION SIGN
    0x00F8, //121 #LATIN SMALL LETTER O WITH STROKE
    0x00F9, //122 #LATIN SMALL LETTER U WITH GRAVE
    0x00FA, //123 #LATIN SMALL LETTER U WITH ACUTE
    0x00FB, //124 #LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x00FC, //125 #LATIN SMALL LETTER U WITH DIAERESIS
    0x0131, //126 #LATIN SMALL LETTER DOTLESS I
    0x015F, //127 #LATIN SMALL LETTER S WITH CEDILLA
    0x00FF //128 #LATIN SMALL LETTER Y WITH DIAERESIS
};

//Table 1255
static const std::array<int, CPLENGTHCOMMON> DRW_Table1255 = {
    0x20AC, //1 #EURO SIGN
    0x00  , //2 #UNDEFINED
    0x201A, //3 #SINGLE LOW-9 QUOTATION MARK
    0x0192, //4 #LATIN SMALL LETTER F WITH HOOK
    0x201E, //5 #DOUBLE LOW-9 QUOTATION MARK
    0x2026, //6 #HORIZONTAL ELLIPSIS
    0x2020, //7 #DAGGER
    0x2021, //8 #DOUBLE DAGGER
    0x02C6, //9 #MODIFIER LETTER CIRCUMFLEX ACCENT
    0x2030, //10 #PER MILLE SIGN
    0x00  , //11 #UNDEFINED
    0x2039, //12 #SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    0x00  , //13 #UNDEFINED
    0x00  , //14 #UNDEFINED
    0x00  , //15 #UNDEFINED
    0x00  , //16 #UNDEFINED
    0x00  , //17 #UNDEFINED
    0x2018, //18 #LEFT SINGLE QUOTATION MARK
    0x2019, //19 #RIGHT SINGLE QUOTATION MARK
    0x201C, //20 #LEFT DOUBLE QUOTATION MARK
    0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
    0x2022, //22 #BULLET
    0x2013, //23 #EN DASH
    0x2014, //24 #EM DASH
    0x02DC, //25 #SMALL TILDE
    0x2122, //26 #TRADE MARK SIGN
    0x00  , //27 #UNDEFINED
    0x203A, //28 #SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    0x00  , //29 #UNDEFINED
    0x00  , //30 #UNDEFINED
    0x00  , //31 #UNDEFINED
    0x00  , //32 #UNDEFINED
    0x00A0, //33 #NO-BREAK SPACE
    0x00A1, //34 #INVERTED EXCLAMATION MARK
    0x00A2, //35 #CENT SIGN
    0x00A3, //36 #POUND SIGN
    0x20AA, //37 #NEW SHEQEL SIGN
    0x00A5, //38 #YEN SIGN
    0x00A6, //39 #BROKEN BAR
    0x00A7, //40 #SECTION SIGN
    0x00A8, //41 #DIAERESIS
    0x00A9, //42 #COPYRIGHT SIGN
    0x00D7, //43 #MULTIPLICATION SIGN
    0x00AB, //44 #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00AC, //45 #NOT SIGN
    0x00AD, //46 #SOFT HYPHEN
    0x00AE, //47 #REGISTERED SIGN
    0x00AF, //48 #MACRON
    0x00B0, //49 #DEGREE SIGN
    0x00B1, //50 #PLUS-MINUS SIGN
    0x00B2, //51 #SUPERSCRIPT TWO
    0x00B3, //52 #SUPERSCRIPT THREE
    0x00B4, //53 #ACUTE ACCENT
    0x00B5, //54 #MICRO SIGN
    0x00B6, //55 #PILCROW SIGN
    0x00B7, //56 #MIDDLE DOT
    0x00B8, //57 #CEDILLA
    0x00B9, //58 #SUPERSCRIPT ONE
    0x00F7, //59 #DIVISION SIGN
    0x00BB, //60 #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00BC, //61 #VULGAR FRACTION ONE QUARTER
    0x00BD, //62 #VULGAR FRACTION ONE HALF
    0x00BE, //63 #VULGAR FRACTION THREE QUARTERS
    0x00BF, //64 #INVERTED QUESTION MARK
    0x05B0, //65 #HEBREW POINT SHEVA
    0x05B1, //66 #HEBREW POINT HATAF SEGOL
    0x05B2, //67 #HEBREW POINT HATAF PATAH
    0x05B3, //68 #HEBREW POINT HATAF QAMATS
    0x05B4, //69 #HEBREW POINT HIRIQ
    0x05B5, //70 #HEBREW POINT TSERE
    0x05B6, //71 #HEBREW POINT SEGOL
    0x05B7, //72 #HEBREW POINT PATAH
    0x05B8, //73 #HEBREW POINT QAMATS
    0x05B9, //74 #HEBREW POINT HOLAM
    0x00  , //75 #UNDEFINED
    0x05BB, //76 #HEBREW POINT QUBUTS
    0x05BC, //77 #HEBREW POINT DAGESH OR MAPIQ
    0x05BD, //78 #HEBREW POINT METEG
    0x05BE, //79 #HEBREW PUNCTUATION MAQAF
    0x05BF, //80 #HEBREW POINT RAFE
    0x05C0, //81 #HEBREW PUNCTUATION PASEQ
    0x05C1, //82 #HEBREW POINT SHIN DOT
    0x05C2, //83 #HEBREW POINT SIN DOT
    0x05C3, //84 #HEBREW PUNCTUATION SOF PASUQ
    0x05F0, //85 #HEBREW LIGATURE YIDDISH DOUBLE VAV
    0x05F1, //86 #HEBREW LIGATURE YIDDISH VAV YOD
    0x05F2, //87 #HEBREW LIGATURE YIDDISH DOUBLE YOD
    0x05F3, //88 #HEBREW PUNCTUATION GERESH
    0x05F4, //89 #HEBREW PUNCTUATION GERSHAYIM
    0x00  , //90 #UNDEFINED
    0x00  , //91 #UNDEFINED
    0x00  , //92 #UNDEFINED
    0x00  , //93 #UNDEFINED
    0x00  , //94 #UNDEFINED
    0x00  , //95 #UNDEFINED
    0x00  , //96 #UNDEFINED
    0x05D0, //97 #HEBREW LETTER ALEF
    0x05D1, //98 #HEBREW LETTER BET
    0x05D2, //99 #HEBREW LETTER GIMEL
    0x05D3, //100 #HEBREW LETTER DALET
    0x05D4, //101 #HEBREW LETTER HE
    0x05D5, //102 #HEBREW LETTER VAV
    0x05D6, //103 #HEBREW LETTER ZAYIN
    0x05D7, //104 #HEBREW LETTER HET
    0x05D8, //105 #HEBREW LETTER TET
    0x05D9, //106 #HEBREW LETTER YOD
    0x05DA, //107 #HEBREW LETTER FINAL KAF
    0x05DB, //108 #HEBREW LETTER KAF
    0x05DC, //109 #HEBREW LETTER LAMED
    0x05DD, //110 #HEBREW LETTER FINAL MEM
    0x05DE, //111 #HEBREW LETTER MEM
    0x05DF, //112 #HEBREW LETTER FINAL NUN
    0x05E0, //113 #HEBREW LETTER NUN
    0x05E1, //114 #HEBREW LETTER SAMEKH
    0x05E2, //115 #HEBREW LETTER AYIN
    0x05E3, //116 #HEBREW LETTER FINAL PE
    0x05E4, //117 #HEBREW LETTER PE
    0x05E5, //118 #HEBREW LETTER FINAL TSADI
    0x05E6, //119 #HEBREW LETTER TSADI
    0x05E7, //120 #HEBREW LETTER QOF
    0x05E8, //121 #HEBREW LETTER RESH
    0x05E9, //122 #HEBREW LETTER SHIN
    0x05EA, //123 #HEBREW LETTER TAV
    0x00  , //124 #UNDEFINED
    0x00  , //125 #UNDEFINED
    0x200E, //126 #LEFT-TO-RIGHT MARK
    0x200F, //127 #RIGHT-TO-LEFT MARK
    0x00    //128 #UNDEFINED
};

//Table 1256
static const std::array<int, CPLENGTHCOMMON> DRW_Table1256 = {
    0x20AC, //1 #EURO SIGN
    0x067E, //2 #ARABIC LETTER PEH
    0x201A, //3 #SINGLE LOW-9 QUOTATION MARK
    0x0192, //4 #LATIN SMALL LETTER F WITH HOOK
    0x201E, //5 #DOUBLE LOW-9 QUOTATION MARK
    0x2026, //6 #HORIZONTAL ELLIPSIS
    0x2020, //7 #DAGGER
    0x2021, //8 #DOUBLE DAGGER
    0x02C6, //9 #MODIFIER LETTER CIRCUMFLEX ACCENT
    0x2030, //10 #PER MILLE SIGN
    0x0679, //11 #ARABIC LETTER TTEH
    0x2039, //12 #SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    0x0152, //13 #LATIN CAPITAL LIGATURE OE
    0x0686, //14 #ARABIC LETTER TCHEH
    0x0698, //15 #ARABIC LETTER JEH
    0x0688, //16 #ARABIC LETTER DDAL
    0x06AF, //17 #ARABIC LETTER GAF
    0x2018, //18 #LEFT SINGLE QUOTATION MARK
    0x2019, //19 #RIGHT SINGLE QUOTATION MARK
    0x201C, //20 #LEFT DOUBLE QUOTATION MARK
    0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
    0x2022, //22 #BULLET
    0x2013, //23 #EN DASH
    0x2014, //24 #EM DASH
    0x06A9, //25 #ARABIC LETTER KEHEH
    0x2122, //26 #TRADE MARK SIGN
    0x0691, //27 #ARABIC LETTER RREH
    0x203A, //28 #SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    0x0153, //29 #LATIN SMALL LIGATURE OE
    0x200C, //30 #ZERO WIDTH NON-JOINER
    0x200D, //31 #ZERO WIDTH JOINER
    0x06BA, //32 #ARABIC LETTER NOON GHUNNA
    0x00A0, //33 #NO-BREAK SPACE
    0x060C, //34 #ARABIC COMMA
    0x00A2, //35 #CENT SIGN
    0x00A3, //36 #POUND SIGN
    0x00A4, //37 #CURRENCY SIGN
    0x00A5, //38 #YEN SIGN
    0x00A6, //39 #BROKEN BAR
    0x00A7, //40 #SECTION SIGN
    0x00A8, //41 #DIAERESIS
    0x00A9, //42 #COPYRIGHT SIGN
    0x06BE, //43 #ARABIC LETTER HEH DOACHASHMEE
    0x00AB, //44 #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00AC, //45 #NOT SIGN
    0x00AD, //46 #SOFT HYPHEN
    0x00AE, //47 #REGISTERED SIGN
    0x00AF, //48 #MACRON
    0x00B0, //49 #DEGREE SIGN
    0x00B1, //50 #PLUS-MINUS SIGN
    0x00B2, //51 #SUPERSCRIPT TWO
    0x00B3, //52 #SUPERSCRIPT THREE
    0x00B4, //53 #ACUTE ACCENT
    0x00B5, //54 #MICRO SIGN
    0x00B6, //55 #PILCROW SIGN
    0x00B7, //56 #MIDDLE DOT
    0x00B8, //57 #CEDILLA
    0x00B9, //58 #SUPERSCRIPT ONE
    0x061B, //59 #ARABIC SEMICOLON
    0x00BB, //60 #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00BC, //61 #VULGAR FRACTION ONE QUARTER
    0x00BD, //62 #VULGAR FRACTION ONE HALF
    0x00BE, //63 #VULGAR FRACTION THREE QUARTERS
    0x061F, //64 #ARABIC QUESTION MARK
    0x06C1, //65 #ARABIC LETTER HEH GOAL
    0x0621, //66 #ARABIC LETTER HAMZA
    0x0622, //67 #ARABIC LETTER ALEF WITH MADDA ABOVE
    0x0623, //68 #ARABIC LETTER ALEF WITH HAMZA ABOVE
    0x0624, //69 #ARABIC LETTER WAW WITH HAMZA ABOVE
    0x0625, //70 #ARABIC LETTER ALEF WITH HAMZA BELOW
    0x0626, //71 #ARABIC LETTER YEH WITH HAMZA ABOVE
    0x0627, //72 #ARABIC LETTER ALEF
    0x0628, //73 #ARABIC LETTER BEH
    0x0629, //74 #ARABIC LETTER TEH MARBUTA
    0x062A, //75 #ARABIC LETTER TEH
    0x062B, //76 #ARABIC LETTER THEH
    0x062C, //77 #ARABIC LETTER JEEM
    0x062D, //78 #ARABIC LETTER HAH
    0x062E, //79 #ARABIC LETTER KHAH
    0x062F, //80 #ARABIC LETTER DAL
    0x0630, //81 #ARABIC LETTER THAL
    0x0631, //82 #ARABIC LETTER REH
    0x0632, //83 #ARABIC LETTER ZAIN
    0x0633, //84 #ARABIC LETTER SEEN
    0x0634, //85 #ARABIC LETTER SHEEN
    0x0635, //86 #ARABIC LETTER SAD
    0x0636, //87 #ARABIC LETTER DAD
    0x00D7, //88 #MULTIPLICATION SIGN
    0x0637, //89 #ARABIC LETTER TAH
    0x0638, //90 #ARABIC LETTER ZAH
    0x0639, //91 #ARABIC LETTER AIN
    0x063A, //92 #ARABIC LETTER GHAIN
    0x0640, //93 #ARABIC TATWEEL
    0x0641, //94 #ARABIC LETTER FEH
    0x0642, //95 #ARABIC LETTER QAF
    0x0643, //96 #ARABIC LETTER KAF
    0x00E0, //97 #LATIN SMALL LETTER A WITH GRAVE
    0x0644, //98 #ARABIC LETTER LAM
    0x00E2, //99 #LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x0645, //100 #ARABIC LETTER MEEM
    0x0646, //101 #ARABIC LETTER NOON
    0x0647, //102 #ARABIC LETTER HEH
    0x0648, //103 #ARABIC LETTER WAW
    0x00E7, //104 #LATIN SMALL LETTER C WITH CEDILLA
    0x00E8, //105 #LATIN SMALL LETTER E WITH GRAVE
    0x00E9, //106 #LATIN SMALL LETTER E WITH ACUTE
    0x00EA, //107 #LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x00EB, //108 #LATIN SMALL LETTER E WITH DIAERESIS
    0x0649, //109 #ARABIC LETTER ALEF MAKSURA
    0x064A, //110 #ARABIC LETTER YEH
    0x00EE, //111 #LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x00EF, //112 #LATIN SMALL LETTER I WITH DIAERESIS
    0x064B, //113 #ARABIC FATHATAN
    0x064C, //114 #ARABIC DAMMATAN
    0x064D, //115 #ARABIC KASRATAN
    0x064E, //116 #ARABIC FATHA
    0x00F4, //117 #LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x064F, //118 #ARABIC DAMMA
    0x0650, //119 #ARABIC KASRA
    0x00F7, //120 #DIVISION SIGN
    0x0651, //121 #ARABIC SHADDA
    0x00F9, //122 #LATIN SMALL LETTER U WITH GRAVE
    0x0652, //123 #ARABIC SUKUN
    0x00FB, //124 #LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x00FC, //125 #LATIN SMALL LETTER U WITH DIAERESIS
    0x200E, //126 #LEFT-TO-RIGHT MARK
    0x200F, //127 #RIGHT-TO-LEFT MARK
    0x06D2  //128 #ARABIC LETTER YEH BARREE
};

//Table 1257
static const std::array<int, CPLENGTHCOMMON> DRW_Table1257 = {
    0x20AC, //1 #EURO SIGN
    0x00  , //2 #UNDEFINED
    0x201A, //3 #SINGLE LOW-9 QUOTATION MARK
    0x00  , //4 #UNDEFINED
    0x201E, //5 #DOUBLE LOW-9 QUOTATION MARK
    0x2026, //6 #HORIZONTAL ELLIPSIS
    0x2020, //7 #DAGGER
    0x2021, //8 #DOUBLE DAGGER
    0x00  , //9 #UNDEFINED
    0x2030, //10 #PER MILLE SIGN
    0x00  , //11 #UNDEFINED
    0x2039, //12 #SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    0x00  , //13 #UNDEFINED
    0x00A8, //14 #DIAERESIS
    0x02C7, //15 #CARON
    0x00B8, //16 #CEDILLA
    0x00  , //17 #UNDEFINED
    0x2018, //18 #LEFT SINGLE QUOTATION MARK
    0x2019, //19 #RIGHT SINGLE QUOTATION MARK
    0x201C, //20 #LEFT DOUBLE QUOTATION MARK
    0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
    0x2022, //22 #BULLET
    0x2013, //23 #EN DASH
    0x2014, //24 #EM DASH
    0x00  , //25 #UNDEFINED
    0x2122, //26 #TRADE MARK SIGN
    0x00  , //27 #UNDEFINED
    0x203A, //28 #SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    0x00  , //29 #UNDEFINED
    0x00AF, //30 #MACRON
    0x02DB, //31 #OGONEK
    0x00  , //32 #UNDEFINED
    0x00A0, //33 #NO-BREAK SPACE
    0x00  , //34 #UNDEFINED
    0x00A2, //35 #CENT SIGN
    0x00A3, //36 #POUND SIGN
    0x00A4, //37 #CURRENCY SIGN
    0x00  , //38 #UNDEFINED
    0x00A6, //39 #BROKEN BAR
    0x00A7, //40 #SECTION SIGN
    0x00D8, //41 #LATIN CAPITAL LETTER O WITH STROKE
    0x00A9, //42 #COPYRIGHT SIGN
    0x0156, //43 #LATIN CAPITAL LETTER R WITH CEDILLA
    0x00AB, //44 #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00AC, //45 #NOT SIGN
    0x00AD, //46 #SOFT HYPHEN
    0x00AE, //47 #REGISTERED SIGN
    0x00C6, //48 #LATIN CAPITAL LETTER AE
    0x00B0, //49 #DEGREE SIGN
    0x00B1, //50 #PLUS-MINUS SIGN
    0x00B2, //51 #SUPERSCRIPT TWO
    0x00B3, //52 #SUPERSCRIPT THREE
    0x00B4, //53 #ACUTE ACCENT
    0x00B5, //54 #MICRO SIGN
    0x00B6, //55 #PILCROW SIGN
    0x00B7, //56 #MIDDLE DOT
    0x00F8, //57 #LATIN SMALL LETTER O WITH STROKE
    0x00B9, //58 #SUPERSCRIPT ONE
    0x0157, //59 #LATIN SMALL LETTER R WITH CEDILLA
    0x00BB, //60 #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00BC, //61 #VULGAR FRACTION ONE QUARTER
    0x00BD, //62 #VULGAR FRACTION ONE HALF
    0x00BE, //63 #VULGAR FRACTION THREE QUARTERS
    0x00E6, //64 #LATIN SMALL LETTER AE
    0x0104, //65 #LATIN CAPITAL LETTER A WITH OGONEK
    0x012E, //66 #LATIN CAPITAL LETTER I WITH OGONEK
    0x0100, //67 #LATIN CAPITAL LETTER A WITH MACRON
    0x0106, //68 #LATIN CAPITAL LETTER C WITH ACUTE
    0x00C4, //69 #LATIN CAPITAL LETTER A WITH DIAERESIS
    0x00C5, //70 #LATIN CAPITAL LETTER A WITH RING ABOVE
    0x0118, //71 #LATIN CAPITAL LETTER E WITH OGONEK
    0x0112, //72 #LATIN CAPITAL LETTER E WITH MACRON
    0x010C, //73 #LATIN CAPITAL LETTER C WITH CARON
    0x00C9, //74 #LATIN CAPITAL LETTER E WITH ACUTE
    0x0179, //75 #LATIN CAPITAL LETTER Z WITH ACUTE
    0x0116, //76 #LATIN CAPITAL LETTER E WITH DOT ABOVE
    0x0122, //77 #LATIN CAPITAL LETTER G WITH CEDILLA
    0x0136, //78 #LATIN CAPITAL LETTER K WITH CEDILLA
    0x012A, //79 #LATIN CAPITAL LETTER I WITH MACRON
    0x013B, //80 #LATIN CAPITAL LETTER L WITH CEDILLA
    0x0160, //81 #LATIN CAPITAL LETTER S WITH CARON
    0x0143, //82 #LATIN CAPITAL LETTER N WITH ACUTE
    0x0145, //83 #LATIN CAPITAL LETTER N WITH CEDILLA
    0x00D3, //84 #LATIN CAPITAL LETTER O WITH ACUTE
    0x014C, //85 #LATIN CAPITAL LETTER O WITH MACRON
    0x00D5, //86 #LATIN CAPITAL LETTER O WITH TILDE
    0x00D6, //87 #LATIN CAPITAL LETTER O WITH DIAERESIS
    0x00D7, //88 #MULTIPLICATION SIGN
    0x0172, //89 #LATIN CAPITAL LETTER U WITH OGONEK
    0x0141, //90 #LATIN CAPITAL LETTER L WITH STROKE
    0x015A, //91 #LATIN CAPITAL LETTER S WITH ACUTE
    0x016A, //92 #LATIN CAPITAL LETTER U WITH MACRON
    0x00DC, //93 #LATIN CAPITAL LETTER U WITH DIAERESIS
    0x017B, //94 #LATIN CAPITAL LETTER Z WITH DOT ABOVE
    0x017D, //95 #LATIN CAPITAL LETTER Z WITH CARON
    0x00DF, //96 #LATIN SMALL LETTER SHARP S
    0x0105, //97 #LATIN SMALL LETTER A WITH OGONEK
    0x012F, //98 #LATIN SMALL LETTER I WITH OGONEK
    0x0101, //99 #LATIN SMALL LETTER A WITH MACRON
    0x0107, //100 #LATIN SMALL LETTER C WITH ACUTE
    0x00E4, //101 #LATIN SMALL LETTER A WITH DIAERESIS
    0x00E5, //102 #LATIN SMALL LETTER A WITH RING ABOVE
    0x0119, //103 #LATIN SMALL LETTER E WITH OGONEK
    0x0113, //104 #LATIN SMALL LETTER E WITH MACRON
    0x010D, //105 #LATIN SMALL LETTER C WITH CARON
    0x00E9, //106 #LATIN SMALL LETTER E WITH ACUTE
    0x017A, //107 #LATIN SMALL LETTER Z WITH ACUTE
    0x0117, //108 #LATIN SMALL LETTER E WITH DOT ABOVE
    0x0123, //109 #LATIN SMALL LETTER G WITH CEDILLA
    0x0137, //110 #LATIN SMALL LETTER K WITH CEDILLA
    0x012B, //111 #LATIN SMALL LETTER I WITH MACRON
    0x013C, //112 #LATIN SMALL LETTER L WITH CEDILLA
    0x0161, //113 #LATIN SMALL LETTER S WITH CARON
    0x0144, //114 #LATIN SMALL LETTER N WITH ACUTE
    0x0146, //115 #LATIN SMALL LETTER N WITH CEDILLA
    0x00F3, //116 #LATIN SMALL LETTER O WITH ACUTE
    0x014D, //117 #LATIN SMALL LETTER O WITH MACRON
    0x00F5, //118 #LATIN SMALL LETTER O WITH TILDE
    0x00F6, //119 #LATIN SMALL LETTER O WITH DIAERESIS
    0x00F7, //120 #DIVISION SIGN
    0x0173, //121 #LATIN SMALL LETTER U WITH OGONEK
    0x0142, //122 #LATIN SMALL LETTER L WITH STROKE
    0x015B, //123 #LATIN SMALL LETTER S WITH ACUTE
    0x016B, //124 #LATIN SMALL LETTER U WITH MACRON
    0x00FC, //125 #LATIN SMALL LETTER U WITH DIAERESIS
    0x017C, //126 #LATIN SMALL LETTER Z WITH DOT ABOVE
    0x017E, //127 #LATIN SMALL LETTER Z WITH CARON
    0x02D9  //128 #DOT ABOVE
};

//Table 1258
static const std::array<int, CPLENGTHCOMMON> DRW_Table1258 = {
    0x20AC, //1 #EURO SIGN
    0x00  , //2 #UNDEFINED
    0x201A, //3 #SINGLE LOW-9 QUOTATION MARK
    0x0192, //4 #LATIN SMALL LETTER F WITH HOOK
    0x201E, //5 #DOUBLE LOW-9 QUOTATION MARK
    0x2026, //6 #HORIZONTAL ELLIPSIS
    0x2020, //7 #DAGGER
    0x2021, //8 #DOUBLE DAGGER
    0x02C6, //9 #MODIFIER LETTER CIRCUMFLEX ACCENT
    0x2030, //10 #PER MILLE SIGN
    0x00  , //11 #UNDEFINED
    0x2039, //12 #SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    0x0152, //13 #LATIN CAPITAL LIGATURE OE
    0x00  , //14 #UNDEFINED
    0x00  , //15 #UNDEFINED
    0x00  , //16 #UNDEFINED
    0x00  , //17 #UNDEFINED
    0x2018, //18 #LEFT SINGLE QUOTATION MARK
    0x2019, //19 #RIGHT SINGLE QUOTATION MARK
    0x201C, //20 #LEFT DOUBLE QUOTATION MARK
    0x201D, //21 #RIGHT DOUBLE QUOTATION MARK
    0x2022, //22 #BULLET
    0x2013, //23 #EN DASH
    0x2014, //24 #EM DASH
    0x02DC, //25 #SMALL TILDE
    0x2122, //26 #TRADE MARK SIGN
    0x00  , //27 #UNDEFINED
    0x203A, //28 #SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    0x0153, //29 #LATIN SMALL LIGATURE OE
    0x00  , //30 #UNDEFINED
    0x00  , //31 #UNDEFINED
    0x0178, //32 #LATIN CAPITAL LETTER Y WITH DIAERESIS
    0x00A0, //33 #NO-BREAK SPACE
    0x00A1, //34 #INVERTED EXCLAMATION MARK
    0x00A2, //35 #CENT SIGN
    0x00A3, //36 #POUND SIGN
    0x00A4, //37 #CURRENCY SIGN
    0x00A5, //38 #YEN SIGN
    0x00A6, //39 #BROKEN BAR
    0x00A7, //40 #SECTION SIGN
    0x00A8, //41 #DIAERESIS
    0x00A9, //42 #COPYRIGHT SIGN
    0x00AA, //43 #FEMININE ORDINAL INDICATOR
    0x00AB, //44 #LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00AC, //45 #NOT SIGN
    0x00AD, //46 #SOFT HYPHEN
    0x00AE, //47 #REGISTERED SIGN
    0x00AF, //48 #MACRON
    0x00B0, //49 #DEGREE SIGN
    0x00B1, //50 #PLUS-MINUS SIGN
    0x00B2, //51 #SUPERSCRIPT TWO
    0x00B3, //52 #SUPERSCRIPT THREE
    0x00B4, //53 #ACUTE ACCENT
    0x00B5, //54 #MICRO SIGN
    0x00B6, //55 #PILCROW SIGN
    0x00B7, //56 #MIDDLE DOT
    0x00B8, //57 #CEDILLA
    0x00B9, //58 #SUPERSCRIPT ONE
    0x00BA, //59 #MASCULINE ORDINAL INDICATOR
    0x00BB, //60 #RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00BC, //61 #VULGAR FRACTION ONE QUARTER
    0x00BD, //62 #VULGAR FRACTION ONE HALF
    0x00BE, //63 #VULGAR FRACTION THREE QUARTERS
    0x00BF, //64 #INVERTED QUESTION MARK
    0x00C0, //65 #LATIN CAPITAL LETTER A WITH GRAVE
    0x00C1, //66 #LATIN CAPITAL LETTER A WITH ACUTE
    0x00C2, //67 #LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x0102, //68 #LATIN CAPITAL LETTER A WITH BREVE
    0x00C4, //69 #LATIN CAPITAL LETTER A WITH DIAERESIS
    0x00C5, //70 #LATIN CAPITAL LETTER A WITH RING ABOVE
    0x00C6, //71 #LATIN CAPITAL LETTER AE
    0x00C7, //72 #LATIN CAPITAL LETTER C WITH CEDILLA
    0x00C8, //73 #LATIN CAPITAL LETTER E WITH GRAVE
    0x00C9, //74 #LATIN CAPITAL LETTER E WITH ACUTE
    0x00CA, //75 #LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x00CB, //76 #LATIN CAPITAL LETTER E WITH DIAERESIS
    0x0300, //77 #COMBINING GRAVE ACCENT
    0x00CD, //78 #LATIN CAPITAL LETTER I WITH ACUTE
    0x00CE, //79 #LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x00CF, //80 #LATIN CAPITAL LETTER I WITH DIAERESIS
    0x0110, //81 #LATIN CAPITAL LETTER D WITH STROKE
    0x00D1, //82 #LATIN CAPITAL LETTER N WITH TILDE
    0x0309, //83 #COMBINING HOOK ABOVE
    0x00D3, //84 #LATIN CAPITAL LETTER O WITH ACUTE
    0x00D4, //85 #LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x01A0, //86 #LATIN CAPITAL LETTER O WITH HORN
    0x00D6, //87 #LATIN CAPITAL LETTER O WITH DIAERESIS
    0x00D7, //88 #MULTIPLICATION SIGN
    0x00D8, //89 #LATIN CAPITAL LETTER O WITH STROKE
    0x00D9, //90 #LATIN CAPITAL LETTER U WITH GRAVE
    0x00DA, //91 #LATIN CAPITAL LETTER U WITH ACUTE
    0x00DB, //92 #LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x00DC, //93 #LATIN CAPITAL LETTER U WITH DIAERESIS
    0x01AF, //94 #LATIN CAPITAL LETTER U WITH HORN
    0x0303, //95 #COMBINING TILDE
    0x00DF, //96 #LATIN SMALL LETTER SHARP S
    0x00E0, //97 #LATIN SMALL LETTER A WITH GRAVE
    0x00E1, //98 #LATIN SMALL LETTER A WITH ACUTE
    0x00E2, //99 #LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x0103, //100 #LATIN SMALL LETTER A WITH BREVE
    0x00E4, //101 #LATIN SMALL LETTER A WITH DIAERESIS
    0x00E5, //102 #LATIN SMALL LETTER A WITH RING ABOVE
    0x00E6, //103 #LATIN SMALL LETTER AE
    0x00E7, //104 #LATIN SMALL LETTER C WITH CEDILLA
    0x00E8, //105 #LATIN SMALL LETTER E WITH GRAVE
    0x00E9, //106 #LATIN SMALL LETTER E WITH ACUTE
    0x00EA, //107 #LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x00EB, //108 #LATIN SMALL LETTER E WITH DIAERESIS
    0x0301, //109 #COMBINING ACUTE ACCENT
    0x00ED, //110 #LATIN SMALL LETTER I WITH ACUTE
    0x00EE, //111 #LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x00EF, //112 #LATIN SMALL LETTER I WITH DIAERESIS
    0x0111, //113 #LATIN SMALL LETTER D WITH STROKE
    0x00F1, //114 #LATIN SMALL LETTER N WITH TILDE
    0x0323, //115 #COMBINING DOT BELOW
    0x00F3, //116 #LATIN SMALL LETTER O WITH ACUTE
    0x00F4, //117 #LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x01A1, //118 #LATIN SMALL LETTER O WITH HORN
    0x00F6, //119 #LATIN SMALL LETTER O WITH DIAERESIS
    0x00F7, //120 #DIVISION SIGN
    0x00F8, //121 #LATIN SMALL LETTER O WITH STROKE
    0x00F9, //122 #LATIN SMALL LETTER U WITH GRAVE
    0x00FA, //123 #LATIN SMALL LETTER U WITH ACUTE
    0x00FB, //124 #LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x00FC, //125 #LATIN SMALL LETTER U WITH DIAERESIS
    0x01B0, //126 #LATIN SMALL LETTER U WITH HORN
    0x20AB, //127 #DONG SIGN
    0x00FF  //128 #LATIN SMALL LETTER Y WITH DIAERESIS
};

#endif // DRW_CPTABLES_H
