const char * html_table = "<div id=\"mendeleiev_table\" style=\"position: relative; width: 940px; height: 602px;\"><style>\n"
"div.element{display:inline-block;position:absolute;width:44px;height:56px;border:1px solid black;border-radius:3px;background:lightyellow}\n"
"p.symbol{position:absolute;top:-18px;width:44px;text-align:center;font-size:26px}\n"
"p.Z{position:absolute;top:-16px;left:2px;font-size:14px}p.mass{position:absolute;top:28px;width:44px;text-align:center;font-size:12px}\n"
"p.str0{display:inherit;position:absolute;top:-4px;left:26px;font-size:4px;line-height:3.6px}\n"
"div.r1{top:20px}div.r2{top:82px}div.r3{top:144px}div.r4{top:206px}div.r5{top:268px}\n"
"div.r6{top:330px}div.r7{top:392px}div.r8{top:464px}div.r9{top:526px}div.c1{left:20px}\n"
"div.c2{left:70px}div.c3{left:126px}div.c4{left:176px}div.c5{left:226px}div.c6{left:276px}\n"
"div.c7{left:326px}div.c8{left:376px}div.c9{left:426px}div.c10{left:476px}\n"
"div.c11{left:526px}div.c12{left:576px}div.c13{left:626px}div.c14{left:676px}\n"
"div.c15{left:726px}div.c16{left:776px}div.c17{left:826px}div.c18{left:876px}</style>\n"
"<script>\n"
"\n"
"/* Script to enhance the interactivity of the periodic table */\n"
"\n"
"function add_interaction(){\n"
"    var elements = jQuery(\"div.element\");\n"
"    elements.each(function(i, elt){\n"
"	elt = jQuery(elt);\n"
"	elt.css(\"cursor\", \"help\");\n"
"	var symbol = elt.find(\".symbol\").text();\n"
"	var Z = elt.find(\".Z\").text();\n"
"	var mass = elt.find(\".mass\").text();\n"
"	var struct = elt.find(\".str0\").html();\n"
"	elt.click(\n"
"	    function make_callback(o){\n"
"		return function (evt){\n"
"		    var x = elt.css(\"top\"), y = elt.css(\"top\");\n"
"		    o.html(\"\"); /* erase all previous contents */\n"
"		    var p;\n"
"		    p = jQuery(\"<p>\").text(\"Element: \" + symbol);\n"
"		    o.append(p);\n"
"		    p = jQuery(\"<p>\").text(\"Atomic number: \" + Z);\n"
"		    o.append(p);\n"
"		    p = jQuery(\"<p>\").text(\"Molar mass: \" + mass);\n"
"		    o.append(p);\n"
"		    p = jQuery(\"<p>\").html(\"Electronic structure: \" + struct);\n"
"		    o.append(p);\n"
"		    o.dialog();\n"
"		    var top = evt.clientY;\n"
"		    if (top > 250){\n"
"			/* the element is low enough, let us animate above */\n"
"			top -= 250;\n"
"		    } else {\n"
"			top += 60;\n"
"		    }\n"
"		    var left = evt.clientX;\n"
"		    if (left > 340){\n"
"			/* the element is right enough, let us go to the left */\n"
"			left -= 340;\n"
"		    } else{\n"
"			left +=50;\n"
"		    }	       \n"
"		    o.parents(\".ui-dialog\").animate(\n"
"			{top: top+\"px\", left: left+\"px\"});\n"
"		}\n"
"	    }(jQuery(\"#one_element\")));\n"
"    });\n"
"    jQuery(\"#wait\").fadeOut();\n"
"}\n"
"\n"
"function jQueryIsHere(){\n"
"    result = true;\n"
"    try {\n"
"	if (! jQuery) result = false;\n"
"    }\n"
"    catch(e) {\n"
"	if(e.name == \"ReferenceError\") {\n"
"	    result = false;\n"
"	}\n"
"    }\n"
"    return result\n"
"}\n"
"\n"
"function scriptLoader(scriptUrl){\n"
"    /* copied from https://stackoverflow.com/questions/538745/how-to-tell-if-a-script-tag-failed-to-load */\n"
"    return new Promise(function (res, rej) {\n"
"	let script = document.createElement('script');\n"
"	script.src = scriptUrl;\n"
"	script.type = 'text/javascript';\n"
"	script.onerror = rej;\n"
"	script.async = true;\n"
"	script.onload = res;\n"
"	script.addEventListener('error',rej);\n"
"	script.addEventListener('load',res);\n"
"	document.head.appendChild(script);\n"
"    })    \n"
"}\n"
"\n"
"function cssLoader(cssUrl){\n"
"    return new Promise(function (res, rej) {\n"
"	let link = document.createElement('link');\n"
"	link.href = cssUrl;\n"
"	link.rel = 'stylesheet';\n"
"	link.type = 'text/css';\n"
"	link.onerror = rej;\n"
"	link.async = true;\n"
"	link.onload = res;\n"
"	link.addEventListener('error',rej);\n"
"	link.addEventListener('load',res);\n"
"	document.head.appendChild(link);\n"
"    })    \n"
"}\n"
"\n"
"function tryLocal(){\n"
"    return Promise.all([\n"
"	scriptLoader(\"http://localhost/javascript/jquery/jquery.js\"),\n"
"	scriptLoader(\"http://localhost/javascript/jquery-ui/jquery-ui.js\"),\n"
"	cssLoader(\"http://localhost/javascript/jquery-ui/css/smoothness/jquery-ui.css\")]);\n"
"}\n"
"\n"
"function tryRemote(){\n"
"    return Promise.all([\n"
"	scriptLoader(\"https://code.jquery.com/jquery-1.11.3.js\"),\n"
"	scriptLoader(\"https://code.jquery.com/ui/1.13.2/jquery-ui.js\"),\n"
"	cssLoader(\"https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css\")\n"
"    ]);\n"
"}\n"
"\n"
"window.onload = function(){\n"
"    let p1 = new Promise((res, rej) => {\n"
"	if (jQueryIsHere()) res(\"jQuery found immediately\");\n"
"	else rej(\"no jQuery immediately\")\n"
"    })\n"
"	.then((msg) => {\n"
"	    console.log(msg);\n"
"	    add_interaction();\n"
"	})\n"
"	.catch((msg) =>{\n"
"	    console.log(msg);\n"
"	    tryLocal().then((values) => {\n"
"		console.log(values, \"local scripts and css files not found\");\n"
"		add_interaction();\n"
"	    }).catch((reason) => {\n"
"		console.log(reason);\n"
"		tryRemote().then((values) => {\n"
"		    console.log(values);\n"
"		    add_interaction();\n"
"		}).catch((reason) => {\n"
"		    console.log(reason, \"remote scripts and css files not found\");\n"
"		});\n"
"	    });\n"
"	})\n"
"};\n"
"</script>\n"
"<div class=\"element c1 r1\" style=\"cursor: wait;\" title=\"1 H Hydrogen 1.008, row = 1, col = 1, elec. struct. 1s^{1}\"><p class=\"symbol\">H</p><p class=\"Z\">1</p><p class=\"mass\">1.008</p><p class=\"str0\"><span class=\"layer\">1s<sup>1</sup></span> </p></div>\n"
"<div class=\"element c18 r1\" style=\"cursor: wait;\" title=\"2 He Helium 4.0026, row = 1, col = 18, elec. struct. 1s^{2}\"><p class=\"symbol\">He</p><p class=\"Z\">2</p><p class=\"mass\">4.0026</p><p class=\"str0\"><span class=\"layer\">1s<sup>2</sup></span> </p></div>\n"
"<div class=\"element c1 r2\" style=\"cursor: wait;\" title=\"3 Li Lithium 6.94, row = 2, col = 1, elec. struct. [He] 2s^{1}\"><p class=\"symbol\">Li</p><p class=\"Z\">3</p><p class=\"mass\">6.94</p><p class=\"str0\">[He] <span class=\"layer\">2s<sup>1</sup></span> </p></div>\n"
"<div class=\"element c2 r2\" style=\"cursor: wait;\" title=\"4 Be Beryllium 9.0122, row = 2, col = 2, elec. struct. [He] 2s^{2}\"><p class=\"symbol\">Be</p><p class=\"Z\">4</p><p class=\"mass\">9.0122</p><p class=\"str0\">[He] <span class=\"layer\">2s<sup>2</sup></span> </p></div>\n"
"<div class=\"element c13 r2\" style=\"cursor: wait;\" title=\"5 B Boron 10.81, row = 2, col = 13, elec. struct. [He] 2s^{2} 2p^{1}\"><p class=\"symbol\">B</p><p class=\"Z\">5</p><p class=\"mass\">10.81</p><p class=\"str0\">[He] <span class=\"layer\">2s<sup>2</sup></span> <span class=\"layer\">2p<sup>1</sup></span> </p></div>\n"
"<div class=\"element c14 r2\" style=\"cursor: wait;\" title=\"6 C Carbon 12.011, row = 2, col = 14, elec. struct. [He] 2s^{2} 2p^{2}\"><p class=\"symbol\">C</p><p class=\"Z\">6</p><p class=\"mass\">12.011</p><p class=\"str0\">[He] <span class=\"layer\">2s<sup>2</sup></span> <span class=\"layer\">2p<sup>2</sup></span> </p></div>\n"
"<div class=\"element c15 r2\" style=\"cursor: wait;\" title=\"7 N Nitrogen 14.007, row = 2, col = 15, elec. struct. [He] 2s^{2} 2p^{3}\"><p class=\"symbol\">N</p><p class=\"Z\">7</p><p class=\"mass\">14.007</p><p class=\"str0\">[He] <span class=\"layer\">2s<sup>2</sup></span> <span class=\"layer\">2p<sup>3</sup></span> </p></div>\n"
"<div class=\"element c16 r2\" style=\"cursor: wait;\" title=\"8 O Oxygen 15.999, row = 2, col = 16, elec. struct. [He] 2s^{2} 2p^{4}\"><p class=\"symbol\">O</p><p class=\"Z\">8</p><p class=\"mass\">15.999</p><p class=\"str0\">[He] <span class=\"layer\">2s<sup>2</sup></span> <span class=\"layer\">2p<sup>4</sup></span> </p></div>\n"
"<div class=\"element c17 r2\" style=\"cursor: wait;\" title=\"9 F Fluorine 18.998, row = 2, col = 17, elec. struct. [He] 2s^{2} 2p^{5}\"><p class=\"symbol\">F</p><p class=\"Z\">9</p><p class=\"mass\">18.998</p><p class=\"str0\">[He] <span class=\"layer\">2s<sup>2</sup></span> <span class=\"layer\">2p<sup>5</sup></span> </p></div>\n"
"<div class=\"element c18 r2\" style=\"cursor: wait;\" title=\"10 Ne Neon 20.18, row = 2, col = 18, elec. struct. [He] 2s^{2} 2p^{6}\"><p class=\"symbol\">Ne</p><p class=\"Z\">10</p><p class=\"mass\">20.18</p><p class=\"str0\">[He] <span class=\"layer\">2s<sup>2</sup></span> <span class=\"layer\">2p<sup>6</sup></span> </p></div>\n"
"<div class=\"element c1 r3\" style=\"cursor: wait;\" title=\"11 Na Sodium 22.99, row = 3, col = 1, elec. struct. [Ne] 3s^{1}\"><p class=\"symbol\">Na</p><p class=\"Z\">11</p><p class=\"mass\">22.99</p><p class=\"str0\">[Ne] <span class=\"layer\">3s<sup>1</sup></span> </p></div>\n"
"<div class=\"element c2 r3\" style=\"cursor: wait;\" title=\"12 Mg Magnesium 24.305, row = 3, col = 2, elec. struct. [Ne] 3s^{2}\"><p class=\"symbol\">Mg</p><p class=\"Z\">12</p><p class=\"mass\">24.305</p><p class=\"str0\">[Ne] <span class=\"layer\">3s<sup>2</sup></span> </p></div>\n"
"<div class=\"element c13 r3\" style=\"cursor: wait;\" title=\"13 Al Aluminum 26.982, row = 3, col = 13, elec. struct. [Ne] 3s^{2} 3p^{1}\"><p class=\"symbol\">Al</p><p class=\"Z\">13</p><p class=\"mass\">26.982</p><p class=\"str0\">[Ne] <span class=\"layer\">3s<sup>2</sup></span> <span class=\"layer\">3p<sup>1</sup></span> </p></div>\n"
"<div class=\"element c14 r3\" style=\"cursor: wait;\" title=\"14 Si Silicon 28.085, row = 3, col = 14, elec. struct. [Ne] 3s^{2} 3p^{2}\"><p class=\"symbol\">Si</p><p class=\"Z\">14</p><p class=\"mass\">28.085</p><p class=\"str0\">[Ne] <span class=\"layer\">3s<sup>2</sup></span> <span class=\"layer\">3p<sup>2</sup></span> </p></div>\n"
"<div class=\"element c15 r3\" style=\"cursor: wait;\" title=\"15 P Phosphorus 30.974, row = 3, col = 15, elec. struct. [Ne] 3s^{2} 3p^{3}\"><p class=\"symbol\">P</p><p class=\"Z\">15</p><p class=\"mass\">30.974</p><p class=\"str0\">[Ne] <span class=\"layer\">3s<sup>2</sup></span> <span class=\"layer\">3p<sup>3</sup></span> </p></div>\n"
"<div class=\"element c16 r3\" style=\"cursor: wait;\" title=\"16 S Sulfur 32.06, row = 3, col = 16, elec. struct. [Ne] 3s^{2} 3p^{4}\"><p class=\"symbol\">S</p><p class=\"Z\">16</p><p class=\"mass\">32.06</p><p class=\"str0\">[Ne] <span class=\"layer\">3s<sup>2</sup></span> <span class=\"layer\">3p<sup>4</sup></span> </p></div>\n"
"<div class=\"element c17 r3\" style=\"cursor: wait;\" title=\"17 Cl Chlorine 35.45, row = 3, col = 17, elec. struct. [Ne] 3s^{2} 3p^{5}\"><p class=\"symbol\">Cl</p><p class=\"Z\">17</p><p class=\"mass\">35.45</p><p class=\"str0\">[Ne] <span class=\"layer\">3s<sup>2</sup></span> <span class=\"layer\">3p<sup>5</sup></span> </p></div>\n"
"<div class=\"element c18 r3\" style=\"cursor: wait;\" title=\"18 Ar Argon 39.948, row = 3, col = 18, elec. struct. [Ne] 3s^{2} 3p^{6}\"><p class=\"symbol\">Ar</p><p class=\"Z\">18</p><p class=\"mass\">39.948</p><p class=\"str0\">[Ne] <span class=\"layer\">3s<sup>2</sup></span> <span class=\"layer\">3p<sup>6</sup></span> </p></div>\n"
"<div class=\"element c1 r4\" style=\"cursor: wait;\" title=\"19 K Potassium 39.098, row = 4, col = 1, elec. struct. [Ar] 4s^{1}\"><p class=\"symbol\">K</p><p class=\"Z\">19</p><p class=\"mass\">39.098</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>1</sup></span> </p></div>\n"
"<div class=\"element c2 r4\" style=\"cursor: wait;\" title=\"20 Ca Calcium 40.078, row = 4, col = 2, elec. struct. [Ar] 4s^{2}\"><p class=\"symbol\">Ca</p><p class=\"Z\">20</p><p class=\"mass\">40.078</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> </p></div>\n"
"<div class=\"element c3 r4\" style=\"cursor: wait;\" title=\"21 Sc Scandium 44.956, row = 4, col = 3, elec. struct. [Ar] 3d^{1} 4s^{2}\"><p class=\"symbol\">Sc</p><p class=\"Z\">21</p><p class=\"mass\">44.956</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>1</sup></span> </p></div>\n"
"<div class=\"element c4 r4\" style=\"cursor: wait;\" title=\"22 Ti Titanium 47.867, row = 4, col = 4, elec. struct. [Ar] 3d^{2} 4s^{2}\"><p class=\"symbol\">Ti</p><p class=\"Z\">22</p><p class=\"mass\">47.867</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>2</sup></span> </p></div>\n"
"<div class=\"element c5 r4\" style=\"cursor: wait;\" title=\"23 V Vanadium 50.942, row = 4, col = 5, elec. struct. [Ar] 3d^{3} 4s^{2}\"><p class=\"symbol\">V</p><p class=\"Z\">23</p><p class=\"mass\">50.942</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>3</sup></span> </p></div>\n"
"<div class=\"element c6 r4\" style=\"cursor: wait;\" title=\"24 Cr Chromium 51.996, row = 4, col = 6, elec. struct. [Ar] 3d^{4} 4s^{2}\"><p class=\"symbol\">Cr</p><p class=\"Z\">24</p><p class=\"mass\">51.996</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>4</sup></span> </p></div>\n"
"<div class=\"element c7 r4\" style=\"cursor: wait;\" title=\"25 Mn Manganese 54.938, row = 4, col = 7, elec. struct. [Ar] 3d^{5} 4s^{2}\"><p class=\"symbol\">Mn</p><p class=\"Z\">25</p><p class=\"mass\">54.938</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>5</sup></span> </p></div>\n"
"<div class=\"element c8 r4\" style=\"cursor: wait;\" title=\"26 Fe Iron 55.845, row = 4, col = 8, elec. struct. [Ar] 3d^{6} 4s^{2}\"><p class=\"symbol\">Fe</p><p class=\"Z\">26</p><p class=\"mass\">55.845</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>6</sup></span> </p></div>\n"
"<div class=\"element c9 r4\" style=\"cursor: wait;\" title=\"27 Co Cobalt 58.933, row = 4, col = 9, elec. struct. [Ar] 3d^{7} 4s^{2}\"><p class=\"symbol\">Co</p><p class=\"Z\">27</p><p class=\"mass\">58.933</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>7</sup></span> </p></div>\n"
"<div class=\"element c10 r4\" style=\"cursor: wait;\" title=\"28 Ni Nickel 58.693, row = 4, col = 10, elec. struct. [Ar] 3d^{8} 4s^{2}\"><p class=\"symbol\">Ni</p><p class=\"Z\">28</p><p class=\"mass\">58.693</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>8</sup></span> </p></div>\n"
"<div class=\"element c11 r4\" style=\"cursor: wait;\" title=\"29 Cu Copper 63.546, row = 4, col = 11, elec. struct. [Ar] 3d^{9} 4s^{2}\"><p class=\"symbol\">Cu</p><p class=\"Z\">29</p><p class=\"mass\">63.546</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>9</sup></span> </p></div>\n"
"<div class=\"element c12 r4\" style=\"cursor: wait;\" title=\"30 Zn Zinc 65.38, row = 4, col = 12, elec. struct. [Ar] 3d^{10} 4s^{2}\"><p class=\"symbol\">Zn</p><p class=\"Z\">30</p><p class=\"mass\">65.38</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>10</sup></span> </p></div>\n"
"<div class=\"element c13 r4\" style=\"cursor: wait;\" title=\"31 Ga Gallium 69.723, row = 4, col = 13, elec. struct. [Ar] 3d^{10} 4s^{2} 4p^{1}\"><p class=\"symbol\">Ga</p><p class=\"Z\">31</p><p class=\"mass\">69.723</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>10</sup></span> <span class=\"layer\">4p<sup>1</sup></span> </p></div>\n"
"<div class=\"element c14 r4\" style=\"cursor: wait;\" title=\"32 Ge Germanium 72.63, row = 4, col = 14, elec. struct. [Ar] 3d^{10} 4s^{2} 4p^{2}\"><p class=\"symbol\">Ge</p><p class=\"Z\">32</p><p class=\"mass\">72.63</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>10</sup></span> <span class=\"layer\">4p<sup>2</sup></span> </p></div>\n"
"<div class=\"element c15 r4\" style=\"cursor: wait;\" title=\"33 As Arsenic 74.922, row = 4, col = 15, elec. struct. [Ar] 3d^{10} 4s^{2} 4p^{3}\"><p class=\"symbol\">As</p><p class=\"Z\">33</p><p class=\"mass\">74.922</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>10</sup></span> <span class=\"layer\">4p<sup>3</sup></span> </p></div>\n"
"<div class=\"element c16 r4\" style=\"cursor: wait;\" title=\"34 Se Selenium 78.971, row = 4, col = 16, elec. struct. [Ar] 3d^{10} 4s^{2} 4p^{4}\"><p class=\"symbol\">Se</p><p class=\"Z\">34</p><p class=\"mass\">78.971</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>10</sup></span> <span class=\"layer\">4p<sup>4</sup></span> </p></div>\n"
"<div class=\"element c17 r4\" style=\"cursor: wait;\" title=\"35 Br Bromine 79.904, row = 4, col = 17, elec. struct. [Ar] 3d^{10} 4s^{2} 4p^{5}\"><p class=\"symbol\">Br</p><p class=\"Z\">35</p><p class=\"mass\">79.904</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>10</sup></span> <span class=\"layer\">4p<sup>5</sup></span> </p></div>\n"
"<div class=\"element c18 r4\" style=\"cursor: wait;\" title=\"36 Kr Krypton 83.798, row = 4, col = 18, elec. struct. [Ar] 3d^{10} 4s^{2} 4p^{6}\"><p class=\"symbol\">Kr</p><p class=\"Z\">36</p><p class=\"mass\">83.798</p><p class=\"str0\">[Ar] <span class=\"layer\">4s<sup>2</sup></span> <span class=\"layer\">3d<sup>10</sup></span> <span class=\"layer\">4p<sup>6</sup></span> </p></div>\n"
"<div class=\"element c1 r5\" style=\"cursor: wait;\" title=\"37 Rb Rubidium 85.468, row = 5, col = 1, elec. struct. [Kr] 5s^{1}\"><p class=\"symbol\">Rb</p><p class=\"Z\">37</p><p class=\"mass\">85.468</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>1</sup></span> </p></div>\n"
"<div class=\"element c2 r5\" style=\"cursor: wait;\" title=\"38 Sr Strontium 87.62, row = 5, col = 2, elec. struct. [Kr] 5s^{2}\"><p class=\"symbol\">Sr</p><p class=\"Z\">38</p><p class=\"mass\">87.62</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> </p></div>\n"
"<div class=\"element c3 r5\" style=\"cursor: wait;\" title=\"39 Y Yttrium 88.906, row = 5, col = 3, elec. struct. [Kr] 4d^{1} 5s^{2}\"><p class=\"symbol\">Y</p><p class=\"Z\">39</p><p class=\"mass\">88.906</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>1</sup></span> </p></div>\n"
"<div class=\"element c4 r5\" style=\"cursor: wait;\" title=\"40 Zr Zirconium 91.224, row = 5, col = 4, elec. struct. [Kr] 4d^{2} 5s^{2}\"><p class=\"symbol\">Zr</p><p class=\"Z\">40</p><p class=\"mass\">91.224</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>2</sup></span> </p></div>\n"
"<div class=\"element c5 r5\" style=\"cursor: wait;\" title=\"41 Nb Niobium 92.906, row = 5, col = 5, elec. struct. [Kr] 4d^{3} 5s^{2}\"><p class=\"symbol\">Nb</p><p class=\"Z\">41</p><p class=\"mass\">92.906</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>3</sup></span> </p></div>\n"
"<div class=\"element c6 r5\" style=\"cursor: wait;\" title=\"42 Mo Molybdenum 95.95, row = 5, col = 6, elec. struct. [Kr] 4d^{4} 5s^{2}\"><p class=\"symbol\">Mo</p><p class=\"Z\">42</p><p class=\"mass\">95.95</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>4</sup></span> </p></div>\n"
"<div class=\"element c7 r5\" style=\"cursor: wait;\" title=\"43 Tc Technetium 97.0, row = 5, col = 7, elec. struct. [Kr] 4d^{5} 5s^{2}\"><p class=\"symbol\">Tc</p><p class=\"Z\">43</p><p class=\"mass\">97.0</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>5</sup></span> </p></div>\n"
"<div class=\"element c8 r5\" style=\"cursor: wait;\" title=\"44 Ru Ruthenium 101.07, row = 5, col = 8, elec. struct. [Kr] 4d^{6} 5s^{2}\"><p class=\"symbol\">Ru</p><p class=\"Z\">44</p><p class=\"mass\">101.07</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>6</sup></span> </p></div>\n"
"<div class=\"element c9 r5\" style=\"cursor: wait;\" title=\"45 Rh Rhodium 102.91, row = 5, col = 9, elec. struct. [Kr] 4d^{7} 5s^{2}\"><p class=\"symbol\">Rh</p><p class=\"Z\">45</p><p class=\"mass\">102.91</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>7</sup></span> </p></div>\n"
"<div class=\"element c10 r5\" style=\"cursor: wait;\" title=\"46 Pd Palladium 106.42, row = 5, col = 10, elec. struct. [Kr] 4d^{8} 5s^{2}\"><p class=\"symbol\">Pd</p><p class=\"Z\">46</p><p class=\"mass\">106.42</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>8</sup></span> </p></div>\n"
"<div class=\"element c11 r5\" style=\"cursor: wait;\" title=\"47 Ag Silver 107.87, row = 5, col = 11, elec. struct. [Kr] 4d^{9} 5s^{2}\"><p class=\"symbol\">Ag</p><p class=\"Z\">47</p><p class=\"mass\">107.87</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>9</sup></span> </p></div>\n"
"<div class=\"element c12 r5\" style=\"cursor: wait;\" title=\"48 Cd Cadmium 112.41, row = 5, col = 12, elec. struct. [Kr] 4d^{10} 5s^{2}\"><p class=\"symbol\">Cd</p><p class=\"Z\">48</p><p class=\"mass\">112.41</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>10</sup></span> </p></div>\n"
"<div class=\"element c13 r5\" style=\"cursor: wait;\" title=\"49 In Indium 114.82, row = 5, col = 13, elec. struct. [Kr] 4d^{10} 5s^{2} 5p^{1}\"><p class=\"symbol\">In</p><p class=\"Z\">49</p><p class=\"mass\">114.82</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>10</sup></span> <span class=\"layer\">5p<sup>1</sup></span> </p></div>\n"
"<div class=\"element c14 r5\" style=\"cursor: wait;\" title=\"50 Sn Tin 118.71, row = 5, col = 14, elec. struct. [Kr] 4d^{10} 5s^{2} 5p^{2}\"><p class=\"symbol\">Sn</p><p class=\"Z\">50</p><p class=\"mass\">118.71</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>10</sup></span> <span class=\"layer\">5p<sup>2</sup></span> </p></div>\n"
"<div class=\"element c15 r5\" style=\"cursor: wait;\" title=\"51 Sb Antimony 121.76, row = 5, col = 15, elec. struct. [Kr] 4d^{10} 5s^{2} 5p^{3}\"><p class=\"symbol\">Sb</p><p class=\"Z\">51</p><p class=\"mass\">121.76</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>10</sup></span> <span class=\"layer\">5p<sup>3</sup></span> </p></div>\n"
"<div class=\"element c16 r5\" style=\"cursor: wait;\" title=\"52 Te Tellurium 127.6, row = 5, col = 16, elec. struct. [Kr] 4d^{10} 5s^{2} 5p^{4}\"><p class=\"symbol\">Te</p><p class=\"Z\">52</p><p class=\"mass\">127.6</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>10</sup></span> <span class=\"layer\">5p<sup>4</sup></span> </p></div>\n"
"<div class=\"element c17 r5\" style=\"cursor: wait;\" title=\"53 I Iodine 126.9, row = 5, col = 17, elec. struct. [Kr] 4d^{10} 5s^{2} 5p^{5}\"><p class=\"symbol\">I</p><p class=\"Z\">53</p><p class=\"mass\">126.9</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>10</sup></span> <span class=\"layer\">5p<sup>5</sup></span> </p></div>\n"
"<div class=\"element c18 r5\" style=\"cursor: wait;\" title=\"54 Xe Xenon 131.29, row = 5, col = 18, elec. struct. [Kr] 4d^{10} 5s^{2} 5p^{6}\"><p class=\"symbol\">Xe</p><p class=\"Z\">54</p><p class=\"mass\">131.29</p><p class=\"str0\">[Kr] <span class=\"layer\">5s<sup>2</sup></span> <span class=\"layer\">4d<sup>10</sup></span> <span class=\"layer\">5p<sup>6</sup></span> </p></div>\n"
"<div class=\"element c1 r6\" style=\"cursor: wait;\" title=\"55 Cs Cesium 132.91, row = 6, col = 1, elec. struct. [Xe] 6s^{1}\"><p class=\"symbol\">Cs</p><p class=\"Z\">55</p><p class=\"mass\">132.91</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>1</sup></span> </p></div>\n"
"<div class=\"element c2 r6\" style=\"cursor: wait;\" title=\"56 Ba Barium 137.33, row = 6, col = 2, elec. struct. [Xe] 6s^{2}\"><p class=\"symbol\">Ba</p><p class=\"Z\">56</p><p class=\"mass\">137.33</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> </p></div>\n"
"<div class=\"element c4 r8\" style=\"cursor: wait;\" title=\"57 La Lanthanum 138.91, row = 8, col = 4, elec. struct. [Xe] 4f^{1} 6s^{2}\"><p class=\"symbol\">La</p><p class=\"Z\">57</p><p class=\"mass\">138.91</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>1</sup></span> </p></div>\n"
"<div class=\"element c5 r8\" style=\"cursor: wait;\" title=\"58 Ce Cerium 140.12, row = 8, col = 5, elec. struct. [Xe] 4f^{2} 6s^{2}\"><p class=\"symbol\">Ce</p><p class=\"Z\">58</p><p class=\"mass\">140.12</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>2</sup></span> </p></div>\n"
"<div class=\"element c6 r8\" style=\"cursor: wait;\" title=\"59 Pr Praseodymium 140.91, row = 8, col = 6, elec. struct. [Xe] 4f^{3} 6s^{2}\"><p class=\"symbol\">Pr</p><p class=\"Z\">59</p><p class=\"mass\">140.91</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>3</sup></span> </p></div>\n"
"<div class=\"element c7 r8\" style=\"cursor: wait;\" title=\"60 Nd Neodymium 144.24, row = 8, col = 7, elec. struct. [Xe] 4f^{4} 6s^{2}\"><p class=\"symbol\">Nd</p><p class=\"Z\">60</p><p class=\"mass\">144.24</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>4</sup></span> </p></div>\n"
"<div class=\"element c8 r8\" style=\"cursor: wait;\" title=\"61 Pm Promethium 145.0, row = 8, col = 8, elec. struct. [Xe] 4f^{5} 6s^{2}\"><p class=\"symbol\">Pm</p><p class=\"Z\">61</p><p class=\"mass\">145.0</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>5</sup></span> </p></div>\n"
"<div class=\"element c9 r8\" style=\"cursor: wait;\" title=\"62 Sm Samarium 150.36, row = 8, col = 9, elec. struct. [Xe] 4f^{6} 6s^{2}\"><p class=\"symbol\">Sm</p><p class=\"Z\">62</p><p class=\"mass\">150.36</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>6</sup></span> </p></div>\n"
"<div class=\"element c10 r8\" style=\"cursor: wait;\" title=\"63 Eu Europium 151.96, row = 8, col = 10, elec. struct. [Xe] 4f^{7} 6s^{2}\"><p class=\"symbol\">Eu</p><p class=\"Z\">63</p><p class=\"mass\">151.96</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>7</sup></span> </p></div>\n"
"<div class=\"element c11 r8\" style=\"cursor: wait;\" title=\"64 Gd Gadolinium 157.25, row = 8, col = 11, elec. struct. [Xe] 4f^{8} 6s^{2}\"><p class=\"symbol\">Gd</p><p class=\"Z\">64</p><p class=\"mass\">157.25</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>8</sup></span> </p></div>\n"
"<div class=\"element c12 r8\" style=\"cursor: wait;\" title=\"65 Tb Terbium 158.93, row = 8, col = 12, elec. struct. [Xe] 4f^{9} 6s^{2}\"><p class=\"symbol\">Tb</p><p class=\"Z\">65</p><p class=\"mass\">158.93</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>9</sup></span> </p></div>\n"
"<div class=\"element c13 r8\" style=\"cursor: wait;\" title=\"66 Dy Dysprosium 162.5, row = 8, col = 13, elec. struct. [Xe] 4f^{10} 6s^{2}\"><p class=\"symbol\">Dy</p><p class=\"Z\">66</p><p class=\"mass\">162.5</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>10</sup></span> </p></div>\n"
"<div class=\"element c14 r8\" style=\"cursor: wait;\" title=\"67 Ho Holmium 164.93, row = 8, col = 14, elec. struct. [Xe] 4f^{11} 6s^{2}\"><p class=\"symbol\">Ho</p><p class=\"Z\">67</p><p class=\"mass\">164.93</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>11</sup></span> </p></div>\n"
"<div class=\"element c15 r8\" style=\"cursor: wait;\" title=\"68 Er Erbium 167.26, row = 8, col = 15, elec. struct. [Xe] 4f^{12} 6s^{2}\"><p class=\"symbol\">Er</p><p class=\"Z\">68</p><p class=\"mass\">167.26</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>12</sup></span> </p></div>\n"
"<div class=\"element c16 r8\" style=\"cursor: wait;\" title=\"69 Tm Thulium 168.93, row = 8, col = 16, elec. struct. [Xe] 4f^{13} 6s^{2}\"><p class=\"symbol\">Tm</p><p class=\"Z\">69</p><p class=\"mass\">168.93</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>13</sup></span> </p></div>\n"
"<div class=\"element c17 r8\" style=\"cursor: wait;\" title=\"70 Yb Ytterbium 173.05, row = 8, col = 17, elec. struct. [Xe] 4f^{14} 6s^{2}\"><p class=\"symbol\">Yb</p><p class=\"Z\">70</p><p class=\"mass\">173.05</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> </p></div>\n"
"<div class=\"element c18 r8\" style=\"cursor: wait;\" title=\"71 Lu Lutetium 174.97, row = 8, col = 18, elec. struct. [Xe] 4f^{14} 5d^{1} 6s^{2}\"><p class=\"symbol\">Lu</p><p class=\"Z\">71</p><p class=\"mass\">174.97</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>1</sup></span> </p></div>\n"
"<div class=\"element c4 r6\" style=\"cursor: wait;\" title=\"72 Hf Hafnium 178.49, row = 6, col = 4, elec. struct. [Xe] 4f^{14} 5d^{2} 6s^{2}\"><p class=\"symbol\">Hf</p><p class=\"Z\">72</p><p class=\"mass\">178.49</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>2</sup></span> </p></div>\n"
"<div class=\"element c5 r6\" style=\"cursor: wait;\" title=\"73 Ta Tantalum 180.95, row = 6, col = 5, elec. struct. [Xe] 4f^{14} 5d^{3} 6s^{2}\"><p class=\"symbol\">Ta</p><p class=\"Z\">73</p><p class=\"mass\">180.95</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>3</sup></span> </p></div>\n"
"<div class=\"element c6 r6\" style=\"cursor: wait;\" title=\"74 W Tungsten 183.84, row = 6, col = 6, elec. struct. [Xe] 4f^{14} 5d^{4} 6s^{2}\"><p class=\"symbol\">W</p><p class=\"Z\">74</p><p class=\"mass\">183.84</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>4</sup></span> </p></div>\n"
"<div class=\"element c7 r6\" style=\"cursor: wait;\" title=\"75 Re Rhenium 186.21, row = 6, col = 7, elec. struct. [Xe] 4f^{14} 5d^{5} 6s^{2}\"><p class=\"symbol\">Re</p><p class=\"Z\">75</p><p class=\"mass\">186.21</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>5</sup></span> </p></div>\n"
"<div class=\"element c8 r6\" style=\"cursor: wait;\" title=\"76 Os Osmium 190.23, row = 6, col = 8, elec. struct. [Xe] 4f^{14} 5d^{6} 6s^{2}\"><p class=\"symbol\">Os</p><p class=\"Z\">76</p><p class=\"mass\">190.23</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>6</sup></span> </p></div>\n"
"<div class=\"element c9 r6\" style=\"cursor: wait;\" title=\"77 Ir Iridium 192.22, row = 6, col = 9, elec. struct. [Xe] 4f^{14} 5d^{7} 6s^{2}\"><p class=\"symbol\">Ir</p><p class=\"Z\">77</p><p class=\"mass\">192.22</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>7</sup></span> </p></div>\n"
"<div class=\"element c10 r6\" style=\"cursor: wait;\" title=\"78 Pt Platinum 195.08, row = 6, col = 10, elec. struct. [Xe] 4f^{14} 5d^{8} 6s^{2}\"><p class=\"symbol\">Pt</p><p class=\"Z\">78</p><p class=\"mass\">195.08</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>8</sup></span> </p></div>\n"
"<div class=\"element c11 r6\" style=\"cursor: wait;\" title=\"79 Au Gold 196.97, row = 6, col = 11, elec. struct. [Xe] 4f^{14} 5d^{9} 6s^{2}\"><p class=\"symbol\">Au</p><p class=\"Z\">79</p><p class=\"mass\">196.97</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>9</sup></span> </p></div>\n"
"<div class=\"element c12 r6\" style=\"cursor: wait;\" title=\"80 Hg Mercury 200.59, row = 6, col = 12, elec. struct. [Xe] 4f^{14} 5d^{10} 6s^{2}\"><p class=\"symbol\">Hg</p><p class=\"Z\">80</p><p class=\"mass\">200.59</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>10</sup></span> </p></div>\n"
"<div class=\"element c13 r6\" style=\"cursor: wait;\" title=\"81 Tl Thallium 204.38, row = 6, col = 13, elec. struct. [Xe] 4f^{14} 5d^{10} 6s^{2} 6p^{1}\"><p class=\"symbol\">Tl</p><p class=\"Z\">81</p><p class=\"mass\">204.38</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>10</sup></span> <span class=\"layer\">6p<sup>1</sup></span> </p></div>\n"
"<div class=\"element c14 r6\" style=\"cursor: wait;\" title=\"82 Pb Lead 207.2, row = 6, col = 14, elec. struct. [Xe] 4f^{14} 5d^{10} 6s^{2} 6p^{2}\"><p class=\"symbol\">Pb</p><p class=\"Z\">82</p><p class=\"mass\">207.2</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>10</sup></span> <span class=\"layer\">6p<sup>2</sup></span> </p></div>\n"
"<div class=\"element c15 r6\" style=\"cursor: wait;\" title=\"83 Bi Bismuth 208.98, row = 6, col = 15, elec. struct. [Xe] 4f^{14} 5d^{10} 6s^{2} 6p^{3}\"><p class=\"symbol\">Bi</p><p class=\"Z\">83</p><p class=\"mass\">208.98</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>10</sup></span> <span class=\"layer\">6p<sup>3</sup></span> </p></div>\n"
"<div class=\"element c16 r6\" style=\"cursor: wait;\" title=\"84 Po Polonium 209.0, row = 6, col = 16, elec. struct. [Xe] 4f^{14} 5d^{10} 6s^{2} 6p^{4}\"><p class=\"symbol\">Po</p><p class=\"Z\">84</p><p class=\"mass\">209.0</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>10</sup></span> <span class=\"layer\">6p<sup>4</sup></span> </p></div>\n"
"<div class=\"element c17 r6\" style=\"cursor: wait;\" title=\"85 At Astatine 210.0, row = 6, col = 17, elec. struct. [Xe] 4f^{14} 5d^{10} 6s^{2} 6p^{5}\"><p class=\"symbol\">At</p><p class=\"Z\">85</p><p class=\"mass\">210.0</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>10</sup></span> <span class=\"layer\">6p<sup>5</sup></span> </p></div>\n"
"<div class=\"element c18 r6\" style=\"cursor: wait;\" title=\"86 Rn Radon 222.0, row = 6, col = 18, elec. struct. [Xe] 4f^{14} 5d^{10} 6s^{2} 6p^{6}\"><p class=\"symbol\">Rn</p><p class=\"Z\">86</p><p class=\"mass\">222.0</p><p class=\"str0\">[Xe] <span class=\"layer\">6s<sup>2</sup></span> <span class=\"layer\">4f<sup>14</sup></span> <span class=\"layer\">5d<sup>10</sup></span> <span class=\"layer\">6p<sup>6</sup></span> </p></div>\n"
"<div class=\"element c1 r7\" style=\"cursor: wait;\" title=\"87 Fr Francium 223.0, row = 7, col = 1, elec. struct. [Rn] 7s^{1}\"><p class=\"symbol\">Fr</p><p class=\"Z\">87</p><p class=\"mass\">223.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>1</sup></span> </p></div>\n"
"<div class=\"element c2 r7\" style=\"cursor: wait;\" title=\"88 Ra Radium 226.0, row = 7, col = 2, elec. struct. [Rn] 7s^{2}\"><p class=\"symbol\">Ra</p><p class=\"Z\">88</p><p class=\"mass\">226.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> </p></div>\n"
"<div class=\"element c4 r9\" style=\"cursor: wait;\" title=\"89 Ac Actinium 227.0, row = 9, col = 4, elec. struct. [Rn] 5f^{1} 7s^{2}\"><p class=\"symbol\">Ac</p><p class=\"Z\">89</p><p class=\"mass\">227.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>1</sup></span> </p></div>\n"
"<div class=\"element c5 r9\" style=\"cursor: wait;\" title=\"90 Th Thorium 232.04, row = 9, col = 5, elec. struct. [Rn] 5f^{2} 7s^{2}\"><p class=\"symbol\">Th</p><p class=\"Z\">90</p><p class=\"mass\">232.04</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>2</sup></span> </p></div>\n"
"<div class=\"element c6 r9\" style=\"cursor: wait;\" title=\"91 Pa Protactinium 231.04, row = 9, col = 6, elec. struct. [Rn] 5f^{3} 7s^{2}\"><p class=\"symbol\">Pa</p><p class=\"Z\">91</p><p class=\"mass\">231.04</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>3</sup></span> </p></div>\n"
"<div class=\"element c7 r9\" style=\"cursor: wait;\" title=\"92 U Uranium 238.03, row = 9, col = 7, elec. struct. [Rn] 5f^{4} 7s^{2}\"><p class=\"symbol\">U</p><p class=\"Z\">92</p><p class=\"mass\">238.03</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>4</sup></span> </p></div>\n"
"<div class=\"element c8 r9\" style=\"cursor: wait;\" title=\"93 Np Neptunium 237.0, row = 9, col = 8, elec. struct. [Rn] 5f^{5} 7s^{2}\"><p class=\"symbol\">Np</p><p class=\"Z\">93</p><p class=\"mass\">237.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>5</sup></span> </p></div>\n"
"<div class=\"element c9 r9\" style=\"cursor: wait;\" title=\"94 Pu Plutonium 244.0, row = 9, col = 9, elec. struct. [Rn] 5f^{6} 7s^{2}\"><p class=\"symbol\">Pu</p><p class=\"Z\">94</p><p class=\"mass\">244.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>6</sup></span> </p></div>\n"
"<div class=\"element c10 r9\" style=\"cursor: wait;\" title=\"95 Am Americium 243.0, row = 9, col = 10, elec. struct. [Rn] 5f^{7} 7s^{2}\"><p class=\"symbol\">Am</p><p class=\"Z\">95</p><p class=\"mass\">243.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>7</sup></span> </p></div>\n"
"<div class=\"element c11 r9\" style=\"cursor: wait;\" title=\"96 Cm Curium 247.0, row = 9, col = 11, elec. struct. [Rn] 5f^{8} 7s^{2}\"><p class=\"symbol\">Cm</p><p class=\"Z\">96</p><p class=\"mass\">247.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>8</sup></span> </p></div>\n"
"<div class=\"element c12 r9\" style=\"cursor: wait;\" title=\"97 Bk Berkelium 247.0, row = 9, col = 12, elec. struct. [Rn] 5f^{9} 7s^{2}\"><p class=\"symbol\">Bk</p><p class=\"Z\">97</p><p class=\"mass\">247.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>9</sup></span> </p></div>\n"
"<div class=\"element c13 r9\" style=\"cursor: wait;\" title=\"98 Cf Californium 251.0, row = 9, col = 13, elec. struct. [Rn] 5f^{10} 7s^{2}\"><p class=\"symbol\">Cf</p><p class=\"Z\">98</p><p class=\"mass\">251.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>10</sup></span> </p></div>\n"
"<div class=\"element c14 r9\" style=\"cursor: wait;\" title=\"99 Es Einsteinium 252.0, row = 9, col = 14, elec. struct. [Rn] 5f^{11} 7s^{2}\"><p class=\"symbol\">Es</p><p class=\"Z\">99</p><p class=\"mass\">252.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>11</sup></span> </p></div>\n"
"<div class=\"element c15 r9\" style=\"cursor: wait;\" title=\"100 Fm Fermium 257.0, row = 9, col = 15, elec. struct. [Rn] 5f^{12} 7s^{2}\"><p class=\"symbol\">Fm</p><p class=\"Z\">100</p><p class=\"mass\">257.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>12</sup></span> </p></div>\n"
"<div class=\"element c16 r9\" style=\"cursor: wait;\" title=\"101 Md Mendelevium 258.0, row = 9, col = 16, elec. struct. [Rn] 5f^{13} 7s^{2}\"><p class=\"symbol\">Md</p><p class=\"Z\">101</p><p class=\"mass\">258.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>13</sup></span> </p></div>\n"
"<div class=\"element c17 r9\" style=\"cursor: wait;\" title=\"102 No Nobelium 259.0, row = 9, col = 17, elec. struct. [Rn] 5f^{14} 7s^{2}\"><p class=\"symbol\">No</p><p class=\"Z\">102</p><p class=\"mass\">259.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> </p></div>\n"
"<div class=\"element c18 r9\" style=\"cursor: wait;\" title=\"103 Lr Lawrencium 266.0, row = 9, col = 18, elec. struct. [Rn] 5f^{14} 6d^{1} 7s^{2}\"><p class=\"symbol\">Lr</p><p class=\"Z\">103</p><p class=\"mass\">266.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>1</sup></span> </p></div>\n"
"<div class=\"element c4 r7\" style=\"cursor: wait;\" title=\"104 Rf Rutherfordium 267.0, row = 7, col = 4, elec. struct. [Rn] 5f^{14} 6d^{2} 7s^{2}\"><p class=\"symbol\">Rf</p><p class=\"Z\">104</p><p class=\"mass\">267.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>2</sup></span> </p></div>\n"
"<div class=\"element c5 r7\" style=\"cursor: wait;\" title=\"105 Db Dubnium 268.0, row = 7, col = 5, elec. struct. [Rn] 5f^{14} 6d^{3} 7s^{2}\"><p class=\"symbol\">Db</p><p class=\"Z\">105</p><p class=\"mass\">268.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>3</sup></span> </p></div>\n"
"<div class=\"element c6 r7\" style=\"cursor: wait;\" title=\"106 Sg Seaborgium 269.0, row = 7, col = 6, elec. struct. [Rn] 5f^{14} 6d^{4} 7s^{2}\"><p class=\"symbol\">Sg</p><p class=\"Z\">106</p><p class=\"mass\">269.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>4</sup></span> </p></div>\n"
"<div class=\"element c7 r7\" style=\"cursor: wait;\" title=\"107 Bh Bohrium 270.0, row = 7, col = 7, elec. struct. [Rn] 5f^{14} 6d^{5} 7s^{2}\"><p class=\"symbol\">Bh</p><p class=\"Z\">107</p><p class=\"mass\">270.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>5</sup></span> </p></div>\n"
"<div class=\"element c8 r7\" style=\"cursor: wait;\" title=\"108 Hs Hassium 269.0, row = 7, col = 8, elec. struct. [Rn] 5f^{14} 6d^{6} 7s^{2}\"><p class=\"symbol\">Hs</p><p class=\"Z\">108</p><p class=\"mass\">269.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>6</sup></span> </p></div>\n"
"<div class=\"element c9 r7\" style=\"cursor: wait;\" title=\"109 Mt Meitnerium 278.0, row = 7, col = 9, elec. struct. [Rn] 5f^{14} 6d^{7} 7s^{2}\"><p class=\"symbol\">Mt</p><p class=\"Z\">109</p><p class=\"mass\">278.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>7</sup></span> </p></div>\n"
"<div class=\"element c10 r7\" style=\"cursor: wait;\" title=\"110 Ds Darmstadtium 281.0, row = 7, col = 10, elec. struct. [Rn] 5f^{14} 6d^{8} 7s^{2}\"><p class=\"symbol\">Ds</p><p class=\"Z\">110</p><p class=\"mass\">281.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>8</sup></span> </p></div>\n"
"<div class=\"element c11 r7\" style=\"cursor: wait;\" title=\"111 Rg Roentgenium 282.0, row = 7, col = 11, elec. struct. [Rn] 5f^{14} 6d^{9} 7s^{2}\"><p class=\"symbol\">Rg</p><p class=\"Z\">111</p><p class=\"mass\">282.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>9</sup></span> </p></div>\n"
"<div class=\"element c12 r7\" style=\"cursor: wait;\" title=\"112 Cn Copernicium 285.0, row = 7, col = 12, elec. struct. [Rn] 5f^{14} 6d^{10} 7s^{2}\"><p class=\"symbol\">Cn</p><p class=\"Z\">112</p><p class=\"mass\">285.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>10</sup></span> </p></div>\n"
"<div class=\"element c13 r7\" style=\"cursor: wait;\" title=\"113 Nh Nihonium 286.0, row = 7, col = 13, elec. struct. [Rn] 5f^{14} 6d^{10} 7s^{2} 7p^{1}\"><p class=\"symbol\">Nh</p><p class=\"Z\">113</p><p class=\"mass\">286.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>10</sup></span> <span class=\"layer\">7p<sup>1</sup></span> </p></div>\n"
"<div class=\"element c14 r7\" style=\"cursor: wait;\" title=\"114 Fl Flerovium 289.0, row = 7, col = 14, elec. struct. [Rn] 5f^{14} 6d^{10} 7s^{2} 7p^{2}\"><p class=\"symbol\">Fl</p><p class=\"Z\">114</p><p class=\"mass\">289.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>10</sup></span> <span class=\"layer\">7p<sup>2</sup></span> </p></div>\n"
"<div class=\"element c15 r7\" style=\"cursor: wait;\" title=\"115 Mc Moscovium 289.0, row = 7, col = 15, elec. struct. [Rn] 5f^{14} 6d^{10} 7s^{2} 7p^{3}\"><p class=\"symbol\">Mc</p><p class=\"Z\">115</p><p class=\"mass\">289.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>10</sup></span> <span class=\"layer\">7p<sup>3</sup></span> </p></div>\n"
"<div class=\"element c16 r7\" style=\"cursor: wait;\" title=\"116 Lv Livermorium 293.0, row = 7, col = 16, elec. struct. [Rn] 5f^{14} 6d^{10} 7s^{2} 7p^{4}\"><p class=\"symbol\">Lv</p><p class=\"Z\">116</p><p class=\"mass\">293.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>10</sup></span> <span class=\"layer\">7p<sup>4</sup></span> </p></div>\n"
"<div class=\"element c17 r7\" style=\"cursor: wait;\" title=\"117 Ts Tennessine 294.0, row = 7, col = 17, elec. struct. [Rn] 5f^{14} 6d^{10} 7s^{2} 7p^{5}\"><p class=\"symbol\">Ts</p><p class=\"Z\">117</p><p class=\"mass\">294.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>10</sup></span> <span class=\"layer\">7p<sup>5</sup></span> </p></div>\n"
"<div class=\"element c18 r7\" style=\"cursor: wait;\" title=\"118 Og Oganesson 294.0, row = 7, col = 18, elec. struct. [Rn] 5f^{14} 6d^{10} 7s^{2} 7p^{6}\"><p class=\"symbol\">Og</p><p class=\"Z\">118</p><p class=\"mass\">294.0</p><p class=\"str0\">[Rn] <span class=\"layer\">7s<sup>2</sup></span> <span class=\"layer\">5f<sup>14</sup></span> <span class=\"layer\">6d<sup>10</sup></span> <span class=\"layer\">7p<sup>6</sup></span> </p></div>\n"
"</div>\n"
"<div id=\"one_element\"></div>\n"
"<div id=\"wait\" style=\"width:500; text-align: center;\n"
"     background: rgba(200,200,255,0.5); position: absolute;\n"
"     top: 50px; left: 200px; border: 1px navy solid; border-radius: 3px;\">\n"
"        Wait a few seconds...\n"
"</div>\n"
"\n";
