/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PointObject;

public class SetAwayTool
extends ObjectConstructor {
    ObjectConstructor OC;
    IntersectionObject P;
    boolean Away;

    public SetAwayTool(ZirkelCanvas zirkelCanvas, IntersectionObject intersectionObject, boolean bl, ObjectConstructor objectConstructor) {
        this.P = intersectionObject;
        this.OC = objectConstructor;
        this.P.setSelected(true);
        this.Away = bl;
        zirkelCanvas.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        PointObject pointObject = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
        if (pointObject == null) {
            return;
        }
        if (zirkelCanvas.getConstruction().dependsOn(pointObject, this.P)) {
            zirkelCanvas.warning(ConstructionObject.text1(Zirkel.name("error.depends"), this.P.getText()));
            return;
        }
        this.P.setAway(pointObject.getName(), this.Away);
        this.P.setUseAlpha(mouseEvent.isShiftDown());
        zirkelCanvas.validate();
        this.reset(zirkelCanvas);
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.Away) {
            zirkelCanvas.showStatus(Zirkel.name("message.setaway.away"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.setaway.close"));
        }
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        zirkelCanvas.setTool(this.OC);
        zirkelCanvas.validate();
        zirkelCanvas.repaint();
    }

    public boolean useSmartBoard() {
        return false;
    }
}

