/* completion.c generated by valac 0.52.3, the Vala compiler
 * generated from completion.vala, do not modify */

/* Completion facility functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define TYPE_COMPLETION (completion_get_type ())
#define COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION, Completion))
#define COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION, CompletionClass))
#define IS_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION))
#define IS_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION))
#define COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION, CompletionClass))

typedef struct _Completion Completion;
typedef struct _CompletionClass CompletionClass;
typedef struct _CompletionPrivate CompletionPrivate;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef enum  {
	COMPLETION_FLAGS_POPPEDUP = 1 << 0,
	COMPLETION_FLAGS_CLOSE = 1 << 1,
	COMPLETION_FLAGS_FILENAME = 1 << 2
} CompletionFlags;

#define COMPLETION_TYPE_FLAGS (completion_flags_get_type ())
typedef enum  {
	COMPLETION_CODE_notmatched,
	COMPLETION_CODE_matched,
	COMPLETION_CODE_matchednonunique,
	COMPLETION_CODE_nonunique
} CompletionCode;

#define COMPLETION_TYPE_CODE (completion_code_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _buffer_unref0(var) ((var == NULL) ? NULL : (var = (buffer_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
#define _window_unref0(var) ((var == NULL) ? NULL : (var = (window_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _completion_unref0(var) ((var == NULL) ? NULL : (var = (completion_unref (var), NULL)))
typedef struct _WindowPrivate WindowPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;
typedef void (*BufferWriter) (gpointer user_data);
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ParamSpecCompletion ParamSpecCompletion;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Completion {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompletionPrivate * priv;
	gchar* match;
	Buffer* old_bp;
	GeeSortedSet* completions;
	GeeSortedSet* matches;
	glong matchsize;
	CompletionFlags flags;
	gchar* path;
};

struct _CompletionClass {
	GTypeClass parent_class;
	void (*finalize) (Completion *self);
};

struct _Block4Data {
	int _ref_count_;
	Completion* self;
	GeeSortedSet* l;
};

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

struct _ParamSpecCompletion {
	GParamSpec parent_instance;
};

static gpointer completion_parent_class = NULL;
extern Window* cur_wp;
extern Window* head_wp;
extern Buffer* cur_bp;

gpointer completion_ref (gpointer instance);
void completion_unref (gpointer instance);
GParamSpec* param_spec_completion (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_completion (GValue* value,
                           gpointer v_object);
void value_take_completion (GValue* value,
                            gpointer v_object);
gpointer value_get_completion (const GValue* value);
GType completion_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Completion, completion_unref)
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
GType completion_flags_get_type (void) G_GNUC_CONST ;
GType completion_code_get_type (void) G_GNUC_CONST ;
Completion* completion_new (gboolean fileflag);
Completion* completion_construct (GType object_type,
                                  gboolean fileflag);
void completion_scroll_up (void);
gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
Window* window_find (const gchar* name);
void window_set_current (Window* self);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
void window_resync (Window* self);
void term_redisplay (void);
void completion_scroll_down (void);
static guint completion_max_length (GeeTraversable* l);
static guint __lambda5_ (gchar* s,
                  guint maxlen);
static gpointer ___lambda5__gee_fold_func (gpointer g,
                                    gpointer a,
                                    gpointer self);
static void completion_popup_completion (Completion* self,
                                  gboolean allflag);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
void write_temp_buffer (const gchar* name,
                        gboolean show,
                        BufferWriter func,
                        gpointer func_target);
static void __lambda6_ (Block4Data* _data4_);
void bprintf (const gchar* fmt,
              ...);
gboolean insert_newline (void);
static void ___lambda6__buffer_writer (gpointer self);
static gchar* completion_readdir (Completion* self,
                           const gchar* in_path);
gchar* expand_path (const gchar* path);
gchar* compact_path (const gchar* in_path);
CompletionCode completion_try (Completion* self,
                               const gchar* in_search,
                               gboolean popup_when_complete);
static void completion_finalize (Completion * obj);
static GType completion_get_type_once (void);

static GType
completion_code_get_type_once (void)
{
	static const GEnumValue values[] = {{COMPLETION_CODE_notmatched, "COMPLETION_CODE_notmatched", "notmatched"}, {COMPLETION_CODE_matched, "COMPLETION_CODE_matched", "matched"}, {COMPLETION_CODE_matchednonunique, "COMPLETION_CODE_matchednonunique", "matchednonunique"}, {COMPLETION_CODE_nonunique, "COMPLETION_CODE_nonunique", "nonunique"}, {0, NULL, NULL}};
	GType completion_code_type_id;
	completion_code_type_id = g_enum_register_static ("CompletionCode", values);
	return completion_code_type_id;
}

GType
completion_code_get_type (void)
{
	static volatile gsize completion_code_type_id__volatile = 0;
	if (g_once_init_enter (&completion_code_type_id__volatile)) {
		GType completion_code_type_id;
		completion_code_type_id = completion_code_get_type_once ();
		g_once_init_leave (&completion_code_type_id__volatile, completion_code_type_id);
	}
	return completion_code_type_id__volatile;
}

static GType
completion_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{COMPLETION_FLAGS_POPPEDUP, "COMPLETION_FLAGS_POPPEDUP", "poppedup"}, {COMPLETION_FLAGS_CLOSE, "COMPLETION_FLAGS_CLOSE", "close"}, {COMPLETION_FLAGS_FILENAME, "COMPLETION_FLAGS_FILENAME", "filename"}, {0, NULL, NULL}};
	GType completion_flags_type_id;
	completion_flags_type_id = g_flags_register_static ("CompletionFlags", values);
	return completion_flags_type_id;
}

GType
completion_flags_get_type (void)
{
	static volatile gsize completion_flags_type_id__volatile = 0;
	if (g_once_init_enter (&completion_flags_type_id__volatile)) {
		GType completion_flags_type_id;
		completion_flags_type_id = completion_flags_get_type_once ();
		g_once_init_leave (&completion_flags_type_id__volatile, completion_flags_type_id);
	}
	return completion_flags_type_id__volatile;
}

Completion*
completion_construct (GType object_type,
                      gboolean fileflag)
{
	Completion* self = NULL;
	GeeTreeSet* _tmp0_;
	GeeTreeSet* _tmp1_;
#line 45 "src/completion.vala"
	self = (Completion*) g_type_create_instance (object_type);
#line 46 "src/completion.vala"
	_tmp0_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 46 "src/completion.vala"
	_g_object_unref0 (self->completions);
#line 46 "src/completion.vala"
	self->completions = (GeeSortedSet*) _tmp0_;
#line 47 "src/completion.vala"
	_tmp1_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 47 "src/completion.vala"
	_g_object_unref0 (self->matches);
#line 47 "src/completion.vala"
	self->matches = (GeeSortedSet*) _tmp1_;
#line 49 "src/completion.vala"
	if (fileflag) {
#line 321 "completion.c"
		gchar* _tmp2_;
		CompletionFlags _tmp3_;
#line 50 "src/completion.vala"
		_tmp2_ = g_strdup ("");
#line 50 "src/completion.vala"
		_g_free0 (self->path);
#line 50 "src/completion.vala"
		self->path = _tmp2_;
#line 51 "src/completion.vala"
		_tmp3_ = self->flags;
#line 51 "src/completion.vala"
		self->flags = _tmp3_ | COMPLETION_FLAGS_FILENAME;
#line 334 "completion.c"
	}
#line 45 "src/completion.vala"
	return self;
#line 338 "completion.c"
}

Completion*
completion_new (gboolean fileflag)
{
#line 45 "src/completion.vala"
	return completion_construct (TYPE_COMPLETION, fileflag);
#line 346 "completion.c"
}

static gpointer
_window_ref0 (gpointer self)
{
#line 56 "src/completion.vala"
	return self ? window_ref (self) : NULL;
#line 354 "completion.c"
}

void
completion_scroll_up (void)
{
	Window* old_wp = NULL;
	Window* _tmp0_;
	Window* _tmp1_;
	Window* wp = NULL;
	Window* _tmp2_;
	Window* _tmp3_;
	Window* _tmp4_;
	Window* _tmp6_;
#line 56 "src/completion.vala"
	_tmp0_ = cur_wp;
#line 56 "src/completion.vala"
	_tmp1_ = _window_ref0 (_tmp0_);
#line 56 "src/completion.vala"
	old_wp = _tmp1_;
#line 57 "src/completion.vala"
	_tmp2_ = window_find ("*Completions*");
#line 57 "src/completion.vala"
	wp = _tmp2_;
#line 58 "src/completion.vala"
	_tmp3_ = wp;
#line 58 "src/completion.vala"
	_vala_assert (_tmp3_ != NULL, "wp != null");
#line 59 "src/completion.vala"
	_tmp4_ = wp;
#line 59 "src/completion.vala"
	window_set_current (_tmp4_);
#line 60 "src/completion.vala"
	if (funcall ("scroll-up", NULL, NULL) == FALSE) {
#line 388 "completion.c"
		Window* _tmp5_;
#line 61 "src/completion.vala"
		funcall ("beginning-of-buffer", NULL, NULL);
#line 62 "src/completion.vala"
		_tmp5_ = cur_wp;
#line 62 "src/completion.vala"
		window_resync (_tmp5_);
#line 396 "completion.c"
	}
#line 64 "src/completion.vala"
	_tmp6_ = old_wp;
#line 64 "src/completion.vala"
	window_set_current (_tmp6_);
#line 66 "src/completion.vala"
	term_redisplay ();
#line 55 "src/completion.vala"
	_window_unref0 (wp);
#line 55 "src/completion.vala"
	_window_unref0 (old_wp);
#line 408 "completion.c"
}

void
completion_scroll_down (void)
{
	Window* old_wp = NULL;
	Window* _tmp0_;
	Window* _tmp1_;
	Window* wp = NULL;
	Window* _tmp2_;
	Window* _tmp3_;
	Window* _tmp4_;
	Window* _tmp6_;
#line 70 "src/completion.vala"
	_tmp0_ = cur_wp;
#line 70 "src/completion.vala"
	_tmp1_ = _window_ref0 (_tmp0_);
#line 70 "src/completion.vala"
	old_wp = _tmp1_;
#line 71 "src/completion.vala"
	_tmp2_ = window_find ("*Completions*");
#line 71 "src/completion.vala"
	wp = _tmp2_;
#line 72 "src/completion.vala"
	_tmp3_ = wp;
#line 72 "src/completion.vala"
	_vala_assert (_tmp3_ != NULL, "wp != null");
#line 73 "src/completion.vala"
	_tmp4_ = wp;
#line 73 "src/completion.vala"
	window_set_current (_tmp4_);
#line 74 "src/completion.vala"
	if (funcall ("scroll-down", NULL, NULL) == FALSE) {
#line 442 "completion.c"
		Window* _tmp5_;
#line 75 "src/completion.vala"
		funcall ("end-of-buffer", NULL, NULL);
#line 76 "src/completion.vala"
		_tmp5_ = cur_wp;
#line 76 "src/completion.vala"
		window_resync (_tmp5_);
#line 450 "completion.c"
	}
#line 78 "src/completion.vala"
	_tmp6_ = old_wp;
#line 78 "src/completion.vala"
	window_set_current (_tmp6_);
#line 80 "src/completion.vala"
	term_redisplay ();
#line 69 "src/completion.vala"
	_window_unref0 (wp);
#line 69 "src/completion.vala"
	_window_unref0 (old_wp);
#line 462 "completion.c"
}

static guint
__lambda5_ (gchar* s,
            guint maxlen)
{
	gint _tmp0_;
	gint _tmp1_;
	guint result = 0U;
#line 84 "src/completion.vala"
	g_return_val_if_fail (s != NULL, 0U);
#line 85 "src/completion.vala"
	_tmp0_ = strlen (s);
#line 85 "src/completion.vala"
	_tmp1_ = _tmp0_;
#line 85 "src/completion.vala"
	result = MAX ((guint) _tmp1_, maxlen);
#line 85 "src/completion.vala"
	_g_free0 (s);
#line 85 "src/completion.vala"
	return result;
#line 484 "completion.c"
}

static gpointer
___lambda5__gee_fold_func (gpointer g,
                           gpointer a,
                           gpointer self)
{
	gpointer result;
	result = (gpointer) ((guintptr) __lambda5_ ((gchar*) g, (guint) ((guintptr) a)));
#line 84 "src/completion.vala"
	return result;
#line 496 "completion.c"
}

static guint
completion_max_length (GeeTraversable* l)
{
	gpointer _tmp0_;
	guint result = 0U;
#line 83 "src/completion.vala"
	g_return_val_if_fail (l != NULL, 0U);
#line 84 "src/completion.vala"
	_tmp0_ = gee_traversable_fold (l, G_TYPE_UINT, NULL, NULL, ___lambda5__gee_fold_func, NULL, (gpointer) ((guintptr) 0U));
#line 84 "src/completion.vala"
	result = (guint) ((guintptr) _tmp0_);
#line 84 "src/completion.vala"
	return result;
#line 512 "completion.c"
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 89 "src/completion.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 89 "src/completion.vala"
	return _data4_;
#line 522 "completion.c"
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 89 "src/completion.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 532 "completion.c"
		Completion* self;
#line 89 "src/completion.vala"
		self = _data4_->self;
#line 89 "src/completion.vala"
		_completion_unref0 (self);
#line 89 "src/completion.vala"
		g_slice_free (Block4Data, _data4_);
#line 540 "completion.c"
	}
}

static void
__lambda6_ (Block4Data* _data4_)
{
	Completion* self;
	guint max = 0U;
	GeeSortedSet* _tmp0_;
	guint numcols = 0U;
	Window* _tmp1_;
	guint col = 0U;
#line 97 "src/completion.vala"
	self = _data4_->self;
#line 99 "src/completion.vala"
	_tmp0_ = _data4_->l;
#line 99 "src/completion.vala"
	max = completion_max_length ((GeeTraversable*) _tmp0_) + 5;
#line 100 "src/completion.vala"
	_tmp1_ = cur_wp;
#line 100 "src/completion.vala"
	numcols = (((guint) _tmp1_->ewidth) - 1) / max;
#line 102 "src/completion.vala"
	bprintf ("Possible completions are:\n", NULL);
#line 103 "src/completion.vala"
	col = (guint) 0;
#line 567 "completion.c"
	{
		GeeIterator* _s_it = NULL;
		GeeSortedSet* _tmp2_;
		GeeIterator* _tmp3_;
#line 104 "src/completion.vala"
		_tmp2_ = _data4_->l;
#line 104 "src/completion.vala"
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
#line 104 "src/completion.vala"
		_s_it = _tmp3_;
#line 104 "src/completion.vala"
		while (TRUE) {
#line 580 "completion.c"
			GeeIterator* _tmp4_;
			gchar* s = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp7_;
#line 104 "src/completion.vala"
			_tmp4_ = _s_it;
#line 104 "src/completion.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 104 "src/completion.vala"
				break;
#line 592 "completion.c"
			}
#line 104 "src/completion.vala"
			_tmp5_ = _s_it;
#line 104 "src/completion.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 104 "src/completion.vala"
			s = (gchar*) _tmp6_;
#line 105 "src/completion.vala"
			_tmp7_ = s;
#line 105 "src/completion.vala"
			bprintf ("%-*s", (gint) max, _tmp7_, NULL);
#line 107 "src/completion.vala"
			col = (col + 1) % numcols;
#line 108 "src/completion.vala"
			if (col == ((guint) 0)) {
#line 109 "src/completion.vala"
				insert_newline ();
#line 610 "completion.c"
			}
#line 104 "src/completion.vala"
			_g_free0 (s);
#line 614 "completion.c"
		}
#line 104 "src/completion.vala"
		_g_object_unref0 (_s_it);
#line 618 "completion.c"
	}
}

static void
___lambda6__buffer_writer (gpointer self)
{
#line 95 "src/completion.vala"
	__lambda6_ (self);
#line 627 "completion.c"
}

static gpointer
_buffer_ref0 (gpointer self)
{
#line 114 "src/completion.vala"
	return self ? buffer_ref (self) : NULL;
#line 635 "completion.c"
}

static void
completion_popup_completion (Completion* self,
                             gboolean allflag)
{
	Block4Data* _data4_;
	CompletionFlags _tmp0_;
	Window* _tmp1_;
	Window* _tmp2_;
	GeeSortedSet* _tmp4_ = NULL;
	CompletionFlags _tmp7_;
#line 89 "src/completion.vala"
	g_return_if_fail (self != NULL);
#line 89 "src/completion.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 89 "src/completion.vala"
	_data4_->_ref_count_ = 1;
#line 89 "src/completion.vala"
	_data4_->self = completion_ref (self);
#line 90 "src/completion.vala"
	_tmp0_ = self->flags;
#line 90 "src/completion.vala"
	self->flags = _tmp0_ | COMPLETION_FLAGS_POPPEDUP;
#line 91 "src/completion.vala"
	_tmp1_ = head_wp;
#line 91 "src/completion.vala"
	_tmp2_ = _tmp1_->next;
#line 91 "src/completion.vala"
	if (_tmp2_ == NULL) {
#line 666 "completion.c"
		CompletionFlags _tmp3_;
#line 92 "src/completion.vala"
		_tmp3_ = self->flags;
#line 92 "src/completion.vala"
		self->flags = _tmp3_ | COMPLETION_FLAGS_CLOSE;
#line 672 "completion.c"
	}
#line 94 "src/completion.vala"
	if (allflag) {
#line 676 "completion.c"
		GeeSortedSet* _tmp5_;
#line 94 "src/completion.vala"
		_tmp5_ = self->completions;
#line 94 "src/completion.vala"
		_tmp4_ = _tmp5_;
#line 682 "completion.c"
	} else {
		GeeSortedSet* _tmp6_;
#line 94 "src/completion.vala"
		_tmp6_ = self->matches;
#line 94 "src/completion.vala"
		_tmp4_ = _tmp6_;
#line 689 "completion.c"
	}
#line 94 "src/completion.vala"
	_data4_->l = _tmp4_;
#line 95 "src/completion.vala"
	write_temp_buffer ("*Completions*", TRUE, ___lambda6__buffer_writer, _data4_);
#line 113 "src/completion.vala"
	_tmp7_ = self->flags;
#line 113 "src/completion.vala"
	if ((_tmp7_ & COMPLETION_FLAGS_CLOSE) == COMPLETION_FLAGS_CLOSE) {
#line 699 "completion.c"
		Buffer* _tmp8_;
		Buffer* _tmp9_;
#line 114 "src/completion.vala"
		_tmp8_ = cur_bp;
#line 114 "src/completion.vala"
		_tmp9_ = _buffer_ref0 (_tmp8_);
#line 114 "src/completion.vala"
		_buffer_unref0 (self->old_bp);
#line 114 "src/completion.vala"
		self->old_bp = _tmp9_;
#line 710 "completion.c"
	}
#line 116 "src/completion.vala"
	term_redisplay ();
#line 89 "src/completion.vala"
	block4_data_unref (_data4_);
#line 89 "src/completion.vala"
	_data4_ = NULL;
#line 718 "completion.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 735 "completion.c"
}

static gchar*
completion_readdir (Completion* self,
                    const gchar* in_path)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	GeeTreeSet* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* pdir = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GDir* dir = NULL;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_ = NULL;
	GDir* _tmp40_;
	gchar* _tmp42_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 122 "src/completion.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 122 "src/completion.vala"
	g_return_val_if_fail (in_path != NULL, NULL);
#line 123 "src/completion.vala"
	_tmp0_ = g_strdup (in_path);
#line 123 "src/completion.vala"
	path = _tmp0_;
#line 124 "src/completion.vala"
	_tmp1_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 124 "src/completion.vala"
	_g_object_unref0 (self->completions);
#line 124 "src/completion.vala"
	self->completions = (GeeSortedSet*) _tmp1_;
#line 126 "src/completion.vala"
	_tmp2_ = path;
#line 126 "src/completion.vala"
	_tmp3_ = expand_path (_tmp2_);
#line 126 "src/completion.vala"
	_g_free0 (path);
#line 126 "src/completion.vala"
	path = _tmp3_;
#line 126 "src/completion.vala"
	_tmp4_ = path;
#line 126 "src/completion.vala"
	if (_tmp4_ == NULL) {
#line 127 "src/completion.vala"
		result = NULL;
#line 127 "src/completion.vala"
		_g_free0 (path);
#line 127 "src/completion.vala"
		return result;
#line 793 "completion.c"
	}
#line 132 "src/completion.vala"
	_tmp5_ = path;
#line 132 "src/completion.vala"
	_tmp6_ = path;
#line 132 "src/completion.vala"
	_tmp7_ = strlen (_tmp6_);
#line 132 "src/completion.vala"
	_tmp8_ = _tmp7_;
#line 132 "src/completion.vala"
	if (string_get (_tmp5_, (glong) (_tmp8_ - 1)) != '/') {
#line 805 "completion.c"
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
#line 133 "src/completion.vala"
		_tmp9_ = path;
#line 133 "src/completion.vala"
		_tmp10_ = g_path_get_dirname (_tmp9_);
#line 133 "src/completion.vala"
		_g_free0 (pdir);
#line 133 "src/completion.vala"
		pdir = _tmp10_;
#line 134 "src/completion.vala"
		_tmp11_ = pdir;
#line 134 "src/completion.vala"
		if (g_strcmp0 (_tmp11_, "/") != 0) {
#line 823 "completion.c"
			const gchar* _tmp12_;
			gchar* _tmp13_;
#line 135 "src/completion.vala"
			_tmp12_ = pdir;
#line 135 "src/completion.vala"
			_tmp13_ = g_strconcat (_tmp12_, "/", NULL);
#line 135 "src/completion.vala"
			_g_free0 (pdir);
#line 135 "src/completion.vala"
			pdir = _tmp13_;
#line 834 "completion.c"
		}
#line 136 "src/completion.vala"
		_tmp14_ = path;
#line 136 "src/completion.vala"
		_tmp15_ = g_path_get_basename (_tmp14_);
#line 136 "src/completion.vala"
		_g_free0 (path);
#line 136 "src/completion.vala"
		path = _tmp15_;
#line 844 "completion.c"
	} else {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
#line 138 "src/completion.vala"
		_tmp16_ = path;
#line 138 "src/completion.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 138 "src/completion.vala"
		_g_free0 (pdir);
#line 138 "src/completion.vala"
		pdir = _tmp17_;
#line 139 "src/completion.vala"
		_tmp18_ = g_strdup ("");
#line 139 "src/completion.vala"
		_g_free0 (path);
#line 139 "src/completion.vala"
		path = _tmp18_;
#line 863 "completion.c"
	}
#line 142 "src/completion.vala"
	dir = NULL;
#line 867 "completion.c"
	{
		GDir* _tmp19_ = NULL;
		const gchar* _tmp20_;
		GDir* _tmp21_;
		GDir* _tmp22_;
		gchar* name = NULL;
#line 144 "src/completion.vala"
		_tmp20_ = pdir;
#line 144 "src/completion.vala"
		_tmp21_ = g_dir_open (_tmp20_, (guint) 0, &_inner_error0_);
#line 144 "src/completion.vala"
		_tmp19_ = _tmp21_;
#line 144 "src/completion.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 144 "src/completion.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 884 "completion.c"
				goto __catch0_g_file_error;
			}
#line 144 "src/completion.vala"
			_g_dir_close0 (dir);
#line 144 "src/completion.vala"
			_g_free0 (pdir);
#line 144 "src/completion.vala"
			_g_free0 (path);
#line 144 "src/completion.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 144 "src/completion.vala"
			g_clear_error (&_inner_error0_);
#line 144 "src/completion.vala"
			return NULL;
#line 899 "completion.c"
		}
#line 144 "src/completion.vala"
		_tmp22_ = _tmp19_;
#line 144 "src/completion.vala"
		_tmp19_ = NULL;
#line 144 "src/completion.vala"
		_g_dir_close0 (dir);
#line 144 "src/completion.vala"
		dir = _tmp22_;
#line 145 "src/completion.vala"
		name = NULL;
#line 146 "src/completion.vala"
		while (TRUE) {
#line 913 "completion.c"
			GDir* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* p = NULL;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* s = NULL;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			GeeSortedSet* _tmp35_;
			const gchar* _tmp36_;
#line 146 "src/completion.vala"
			_tmp23_ = dir;
#line 146 "src/completion.vala"
			_tmp24_ = g_dir_read_name (_tmp23_);
#line 146 "src/completion.vala"
			_tmp25_ = g_strdup (_tmp24_);
#line 146 "src/completion.vala"
			_g_free0 (name);
#line 146 "src/completion.vala"
			name = _tmp25_;
#line 146 "src/completion.vala"
			_tmp26_ = name;
#line 146 "src/completion.vala"
			if (!(_tmp26_ != NULL)) {
#line 146 "src/completion.vala"
				break;
#line 944 "completion.c"
			}
#line 147 "src/completion.vala"
			_tmp27_ = pdir;
#line 147 "src/completion.vala"
			_tmp28_ = name;
#line 147 "src/completion.vala"
			_tmp29_ = g_build_filename (_tmp27_, _tmp28_, NULL);
#line 147 "src/completion.vala"
			p = _tmp29_;
#line 148 "src/completion.vala"
			_tmp30_ = name;
#line 148 "src/completion.vala"
			_tmp31_ = g_strdup (_tmp30_);
#line 148 "src/completion.vala"
			s = _tmp31_;
#line 149 "src/completion.vala"
			_tmp32_ = p;
#line 149 "src/completion.vala"
			if (g_file_test (_tmp32_, G_FILE_TEST_IS_DIR)) {
#line 964 "completion.c"
				const gchar* _tmp33_;
				gchar* _tmp34_;
#line 150 "src/completion.vala"
				_tmp33_ = s;
#line 150 "src/completion.vala"
				_tmp34_ = g_strconcat (_tmp33_, "/", NULL);
#line 150 "src/completion.vala"
				_g_free0 (s);
#line 150 "src/completion.vala"
				s = _tmp34_;
#line 975 "completion.c"
			}
#line 151 "src/completion.vala"
			_tmp35_ = self->completions;
#line 151 "src/completion.vala"
			_tmp36_ = s;
#line 151 "src/completion.vala"
			gee_collection_add ((GeeCollection*) _tmp35_, _tmp36_);
#line 146 "src/completion.vala"
			_g_free0 (s);
#line 146 "src/completion.vala"
			_g_free0 (p);
#line 987 "completion.c"
		}
#line 143 "src/completion.vala"
		_g_free0 (name);
#line 143 "src/completion.vala"
		_g_dir_close0 (_tmp19_);
#line 993 "completion.c"
	}
	goto __finally0;
	__catch0_g_file_error:
	{
#line 143 "src/completion.vala"
		g_clear_error (&_inner_error0_);
#line 1000 "completion.c"
	}
	__finally0:
#line 143 "src/completion.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 143 "src/completion.vala"
		_g_dir_close0 (dir);
#line 143 "src/completion.vala"
		_g_free0 (pdir);
#line 143 "src/completion.vala"
		_g_free0 (path);
#line 143 "src/completion.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 143 "src/completion.vala"
		g_clear_error (&_inner_error0_);
#line 143 "src/completion.vala"
		return NULL;
#line 1017 "completion.c"
	}
#line 155 "src/completion.vala"
	_tmp37_ = pdir;
#line 155 "src/completion.vala"
	_tmp38_ = compact_path (_tmp37_);
#line 155 "src/completion.vala"
	_g_free0 (self->path);
#line 155 "src/completion.vala"
	self->path = _tmp38_;
#line 157 "src/completion.vala"
	_tmp40_ = dir;
#line 157 "src/completion.vala"
	if (_tmp40_ != NULL) {
#line 1031 "completion.c"
		const gchar* _tmp41_;
#line 157 "src/completion.vala"
		_tmp41_ = path;
#line 157 "src/completion.vala"
		_tmp39_ = _tmp41_;
#line 1037 "completion.c"
	} else {
#line 157 "src/completion.vala"
		_tmp39_ = NULL;
#line 1041 "completion.c"
	}
#line 157 "src/completion.vala"
	_tmp42_ = g_strdup (_tmp39_);
#line 157 "src/completion.vala"
	result = _tmp42_;
#line 157 "src/completion.vala"
	_g_dir_close0 (dir);
#line 157 "src/completion.vala"
	_g_free0 (pdir);
#line 157 "src/completion.vala"
	_g_free0 (path);
#line 157 "src/completion.vala"
	return result;
#line 1055 "completion.c"
}

CompletionCode
completion_try (Completion* self,
                const gchar* in_search,
                gboolean popup_when_complete)
{
	gchar* search = NULL;
	gchar* _tmp0_;
	GeeTreeSet* _tmp1_;
	CompletionFlags _tmp2_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gsize fullmatches = 0UL;
	GeeSortedSet* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	CompletionCode result = 0;
#line 163 "src/completion.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 163 "src/completion.vala"
	g_return_val_if_fail (in_search != NULL, 0);
#line 164 "src/completion.vala"
	_tmp0_ = g_strdup (in_search);
#line 164 "src/completion.vala"
	search = _tmp0_;
#line 165 "src/completion.vala"
	_tmp1_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 165 "src/completion.vala"
	_g_object_unref0 (self->matches);
#line 165 "src/completion.vala"
	self->matches = (GeeSortedSet*) _tmp1_;
#line 167 "src/completion.vala"
	_tmp2_ = self->flags;
#line 167 "src/completion.vala"
	if ((_tmp2_ & COMPLETION_FLAGS_FILENAME) == COMPLETION_FLAGS_FILENAME) {
#line 1093 "completion.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
#line 168 "src/completion.vala"
		_tmp3_ = search;
#line 168 "src/completion.vala"
		_tmp4_ = completion_readdir (self, _tmp3_);
#line 168 "src/completion.vala"
		_g_free0 (search);
#line 168 "src/completion.vala"
		search = _tmp4_;
#line 168 "src/completion.vala"
		_tmp5_ = search;
#line 168 "src/completion.vala"
		if (_tmp5_ == NULL) {
#line 169 "src/completion.vala"
			result = COMPLETION_CODE_notmatched;
#line 169 "src/completion.vala"
			_g_free0 (search);
#line 169 "src/completion.vala"
			return result;
#line 1115 "completion.c"
		}
	}
#line 171 "src/completion.vala"
	_tmp6_ = search;
#line 171 "src/completion.vala"
	_tmp7_ = strlen (_tmp6_);
#line 171 "src/completion.vala"
	_tmp8_ = _tmp7_;
#line 171 "src/completion.vala"
	if (_tmp8_ == 0) {
#line 1126 "completion.c"
		GeeSortedSet* _tmp9_;
		gpointer _tmp10_;
		GeeSortedSet* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
#line 172 "src/completion.vala"
		_tmp9_ = self->completions;
#line 172 "src/completion.vala"
		_tmp10_ = gee_sorted_set_first (_tmp9_);
#line 172 "src/completion.vala"
		_g_free0 (self->match);
#line 172 "src/completion.vala"
		self->match = (gchar*) _tmp10_;
#line 173 "src/completion.vala"
		_tmp11_ = self->completions;
#line 173 "src/completion.vala"
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
#line 173 "src/completion.vala"
		_tmp13_ = _tmp12_;
#line 173 "src/completion.vala"
		if (_tmp13_ > 1) {
#line 174 "src/completion.vala"
			self->matchsize = (glong) 0;
#line 175 "src/completion.vala"
			completion_popup_completion (self, TRUE);
#line 176 "src/completion.vala"
			result = COMPLETION_CODE_nonunique;
#line 176 "src/completion.vala"
			_g_free0 (search);
#line 176 "src/completion.vala"
			return result;
#line 1158 "completion.c"
		} else {
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 178 "src/completion.vala"
			_tmp14_ = self->match;
#line 178 "src/completion.vala"
			_tmp15_ = strlen (_tmp14_);
#line 178 "src/completion.vala"
			_tmp16_ = _tmp15_;
#line 178 "src/completion.vala"
			self->matchsize = (glong) _tmp16_;
#line 179 "src/completion.vala"
			result = COMPLETION_CODE_matched;
#line 179 "src/completion.vala"
			_g_free0 (search);
#line 179 "src/completion.vala"
			return result;
#line 1177 "completion.c"
		}
	}
#line 183 "src/completion.vala"
	fullmatches = (gsize) 0;
#line 1182 "completion.c"
	{
		GeeIterator* _s_it = NULL;
		GeeSortedSet* _tmp17_;
		GeeIterator* _tmp18_;
#line 184 "src/completion.vala"
		_tmp17_ = self->completions;
#line 184 "src/completion.vala"
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
#line 184 "src/completion.vala"
		_s_it = _tmp18_;
#line 184 "src/completion.vala"
		while (TRUE) {
#line 1195 "completion.c"
			GeeIterator* _tmp19_;
			gchar* s = NULL;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
#line 184 "src/completion.vala"
			_tmp19_ = _s_it;
#line 184 "src/completion.vala"
			if (!gee_iterator_next (_tmp19_)) {
#line 184 "src/completion.vala"
				break;
#line 1211 "completion.c"
			}
#line 184 "src/completion.vala"
			_tmp20_ = _s_it;
#line 184 "src/completion.vala"
			_tmp21_ = gee_iterator_get (_tmp20_);
#line 184 "src/completion.vala"
			s = (gchar*) _tmp21_;
#line 185 "src/completion.vala"
			_tmp22_ = s;
#line 185 "src/completion.vala"
			_tmp23_ = search;
#line 185 "src/completion.vala"
			_tmp24_ = search;
#line 185 "src/completion.vala"
			_tmp25_ = strlen (_tmp24_);
#line 185 "src/completion.vala"
			_tmp26_ = _tmp25_;
#line 185 "src/completion.vala"
			if (strncmp (_tmp22_, _tmp23_, (gsize) _tmp26_) == 0) {
#line 1231 "completion.c"
				GeeSortedSet* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
#line 186 "src/completion.vala"
				_tmp27_ = self->matches;
#line 186 "src/completion.vala"
				_tmp28_ = s;
#line 186 "src/completion.vala"
				gee_collection_add ((GeeCollection*) _tmp27_, _tmp28_);
#line 187 "src/completion.vala"
				_tmp29_ = s;
#line 187 "src/completion.vala"
				_tmp30_ = search;
#line 187 "src/completion.vala"
				if (g_strcmp0 (_tmp29_, _tmp30_) == 0) {
#line 1248 "completion.c"
					gsize _tmp31_;
#line 188 "src/completion.vala"
					fullmatches = fullmatches + 1;
#line 188 "src/completion.vala"
					_tmp31_ = fullmatches;
#line 1254 "completion.c"
				}
			}
#line 184 "src/completion.vala"
			_g_free0 (s);
#line 1259 "completion.c"
		}
#line 184 "src/completion.vala"
		_g_object_unref0 (_s_it);
#line 1263 "completion.c"
	}
#line 192 "src/completion.vala"
	_tmp32_ = self->matches;
#line 192 "src/completion.vala"
	_tmp33_ = gee_collection_get_size ((GeeCollection*) _tmp32_);
#line 192 "src/completion.vala"
	_tmp34_ = _tmp33_;
#line 192 "src/completion.vala"
	if (_tmp34_ == 0) {
#line 193 "src/completion.vala"
		result = COMPLETION_CODE_notmatched;
#line 193 "src/completion.vala"
		_g_free0 (search);
#line 193 "src/completion.vala"
		return result;
#line 1279 "completion.c"
	} else {
		GeeSortedSet* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
#line 194 "src/completion.vala"
		_tmp35_ = self->matches;
#line 194 "src/completion.vala"
		_tmp36_ = gee_collection_get_size ((GeeCollection*) _tmp35_);
#line 194 "src/completion.vala"
		_tmp37_ = _tmp36_;
#line 194 "src/completion.vala"
		if (_tmp37_ == 1) {
#line 1292 "completion.c"
			GeeSortedSet* _tmp38_;
			gpointer _tmp39_;
			const gchar* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
#line 195 "src/completion.vala"
			_tmp38_ = self->matches;
#line 195 "src/completion.vala"
			_tmp39_ = gee_sorted_set_first (_tmp38_);
#line 195 "src/completion.vala"
			_g_free0 (self->match);
#line 195 "src/completion.vala"
			self->match = (gchar*) _tmp39_;
#line 196 "src/completion.vala"
			_tmp40_ = self->match;
#line 196 "src/completion.vala"
			_tmp41_ = strlen (_tmp40_);
#line 196 "src/completion.vala"
			_tmp42_ = _tmp41_;
#line 196 "src/completion.vala"
			self->matchsize = (glong) _tmp42_;
#line 197 "src/completion.vala"
			result = COMPLETION_CODE_matched;
#line 197 "src/completion.vala"
			_g_free0 (search);
#line 197 "src/completion.vala"
			return result;
#line 1320 "completion.c"
		} else {
			gboolean _tmp43_ = FALSE;
			GeeSortedSet* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
#line 198 "src/completion.vala"
			_tmp44_ = self->matches;
#line 198 "src/completion.vala"
			_tmp45_ = gee_collection_get_size ((GeeCollection*) _tmp44_);
#line 198 "src/completion.vala"
			_tmp46_ = _tmp45_;
#line 198 "src/completion.vala"
			if (_tmp46_ > 1) {
#line 198 "src/completion.vala"
				_tmp43_ = fullmatches == ((gsize) 1);
#line 1336 "completion.c"
			} else {
#line 198 "src/completion.vala"
				_tmp43_ = FALSE;
#line 1340 "completion.c"
			}
#line 198 "src/completion.vala"
			if (_tmp43_) {
#line 1344 "completion.c"
				GeeSortedSet* _tmp47_;
				gpointer _tmp48_;
				const gchar* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
#line 199 "src/completion.vala"
				_tmp47_ = self->matches;
#line 199 "src/completion.vala"
				_tmp48_ = gee_sorted_set_first (_tmp47_);
#line 199 "src/completion.vala"
				_g_free0 (self->match);
#line 199 "src/completion.vala"
				self->match = (gchar*) _tmp48_;
#line 200 "src/completion.vala"
				_tmp49_ = self->match;
#line 200 "src/completion.vala"
				_tmp50_ = strlen (_tmp49_);
#line 200 "src/completion.vala"
				_tmp51_ = _tmp50_;
#line 200 "src/completion.vala"
				self->matchsize = (glong) _tmp51_;
#line 201 "src/completion.vala"
				if (popup_when_complete) {
#line 202 "src/completion.vala"
					completion_popup_completion (self, FALSE);
#line 1370 "completion.c"
				}
#line 203 "src/completion.vala"
				result = COMPLETION_CODE_matchednonunique;
#line 203 "src/completion.vala"
				_g_free0 (search);
#line 203 "src/completion.vala"
				return result;
#line 1378 "completion.c"
			}
		}
	}
	{
		guint i = 0U;
		const gchar* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
#line 206 "src/completion.vala"
		_tmp52_ = search;
#line 206 "src/completion.vala"
		_tmp53_ = strlen (_tmp52_);
#line 206 "src/completion.vala"
		_tmp54_ = _tmp53_;
#line 206 "src/completion.vala"
		i = (guint) _tmp54_;
#line 1395 "completion.c"
		{
			gboolean _tmp55_ = FALSE;
#line 206 "src/completion.vala"
			_tmp55_ = TRUE;
#line 206 "src/completion.vala"
			while (TRUE) {
#line 1402 "completion.c"
				gchar c = '\0';
				GeeSortedSet* _tmp57_;
				gpointer _tmp58_;
				gchar* _tmp59_;
				gchar _tmp60_;
#line 206 "src/completion.vala"
				if (!_tmp55_) {
#line 1410 "completion.c"
					guint _tmp56_;
#line 206 "src/completion.vala"
					i = i + 1;
#line 206 "src/completion.vala"
					_tmp56_ = i;
#line 1416 "completion.c"
				}
#line 206 "src/completion.vala"
				_tmp55_ = FALSE;
#line 207 "src/completion.vala"
				_tmp57_ = self->matches;
#line 207 "src/completion.vala"
				_tmp58_ = gee_sorted_set_first (_tmp57_);
#line 207 "src/completion.vala"
				_tmp59_ = (gchar*) _tmp58_;
#line 207 "src/completion.vala"
				_tmp60_ = string_get (_tmp59_, (glong) i);
#line 207 "src/completion.vala"
				_g_free0 (_tmp59_);
#line 207 "src/completion.vala"
				c = _tmp60_;
#line 1432 "completion.c"
				{
					GeeIterator* _s_it = NULL;
					GeeSortedSet* _tmp61_;
					GeeIterator* _tmp62_;
#line 208 "src/completion.vala"
					_tmp61_ = self->matches;
#line 208 "src/completion.vala"
					_tmp62_ = gee_iterable_iterator ((GeeIterable*) _tmp61_);
#line 208 "src/completion.vala"
					_s_it = _tmp62_;
#line 208 "src/completion.vala"
					while (TRUE) {
#line 1445 "completion.c"
						GeeIterator* _tmp63_;
						gchar* s = NULL;
						GeeIterator* _tmp64_;
						gpointer _tmp65_;
						const gchar* _tmp66_;
#line 208 "src/completion.vala"
						_tmp63_ = _s_it;
#line 208 "src/completion.vala"
						if (!gee_iterator_next (_tmp63_)) {
#line 208 "src/completion.vala"
							break;
#line 1457 "completion.c"
						}
#line 208 "src/completion.vala"
						_tmp64_ = _s_it;
#line 208 "src/completion.vala"
						_tmp65_ = gee_iterator_get (_tmp64_);
#line 208 "src/completion.vala"
						s = (gchar*) _tmp65_;
#line 209 "src/completion.vala"
						_tmp66_ = s;
#line 209 "src/completion.vala"
						if (string_get (_tmp66_, (glong) i) != c) {
#line 1469 "completion.c"
							GeeSortedSet* _tmp67_;
							gpointer _tmp68_;
#line 210 "src/completion.vala"
							_tmp67_ = self->matches;
#line 210 "src/completion.vala"
							_tmp68_ = gee_sorted_set_first (_tmp67_);
#line 210 "src/completion.vala"
							_g_free0 (self->match);
#line 210 "src/completion.vala"
							self->match = (gchar*) _tmp68_;
#line 211 "src/completion.vala"
							self->matchsize = (glong) i;
#line 212 "src/completion.vala"
							completion_popup_completion (self, FALSE);
#line 213 "src/completion.vala"
							result = COMPLETION_CODE_nonunique;
#line 213 "src/completion.vala"
							_g_free0 (s);
#line 213 "src/completion.vala"
							_g_object_unref0 (_s_it);
#line 213 "src/completion.vala"
							_g_free0 (search);
#line 213 "src/completion.vala"
							return result;
#line 1494 "completion.c"
						}
#line 208 "src/completion.vala"
						_g_free0 (s);
#line 1498 "completion.c"
					}
#line 208 "src/completion.vala"
					_g_object_unref0 (_s_it);
#line 1502 "completion.c"
				}
			}
		}
	}
}

static void
value_completion_init (GValue* value)
{
#line 22 "src/completion.vala"
	value->data[0].v_pointer = NULL;
#line 1514 "completion.c"
}

static void
value_completion_free_value (GValue* value)
{
#line 22 "src/completion.vala"
	if (value->data[0].v_pointer) {
#line 22 "src/completion.vala"
		completion_unref (value->data[0].v_pointer);
#line 1524 "completion.c"
	}
}

static void
value_completion_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
#line 22 "src/completion.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "src/completion.vala"
		dest_value->data[0].v_pointer = completion_ref (src_value->data[0].v_pointer);
#line 1536 "completion.c"
	} else {
#line 22 "src/completion.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1540 "completion.c"
	}
}

static gpointer
value_completion_peek_pointer (const GValue* value)
{
#line 22 "src/completion.vala"
	return value->data[0].v_pointer;
#line 1549 "completion.c"
}

static gchar*
value_completion_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
#line 22 "src/completion.vala"
	if (collect_values[0].v_pointer) {
#line 1560 "completion.c"
		Completion * object;
		object = collect_values[0].v_pointer;
#line 22 "src/completion.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "src/completion.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1567 "completion.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "src/completion.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1571 "completion.c"
		}
#line 22 "src/completion.vala"
		value->data[0].v_pointer = completion_ref (object);
#line 1575 "completion.c"
	} else {
#line 22 "src/completion.vala"
		value->data[0].v_pointer = NULL;
#line 1579 "completion.c"
	}
#line 22 "src/completion.vala"
	return NULL;
#line 1583 "completion.c"
}

static gchar*
value_completion_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	Completion ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "src/completion.vala"
	if (!object_p) {
#line 22 "src/completion.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1598 "completion.c"
	}
#line 22 "src/completion.vala"
	if (!value->data[0].v_pointer) {
#line 22 "src/completion.vala"
		*object_p = NULL;
#line 1604 "completion.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "src/completion.vala"
		*object_p = value->data[0].v_pointer;
#line 1608 "completion.c"
	} else {
#line 22 "src/completion.vala"
		*object_p = completion_ref (value->data[0].v_pointer);
#line 1612 "completion.c"
	}
#line 22 "src/completion.vala"
	return NULL;
#line 1616 "completion.c"
}

GParamSpec*
param_spec_completion (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecCompletion* spec;
#line 22 "src/completion.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_COMPLETION), NULL);
#line 22 "src/completion.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "src/completion.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "src/completion.vala"
	return G_PARAM_SPEC (spec);
#line 1635 "completion.c"
}

gpointer
value_get_completion (const GValue* value)
{
#line 22 "src/completion.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPLETION), NULL);
#line 22 "src/completion.vala"
	return value->data[0].v_pointer;
#line 1645 "completion.c"
}

void
value_set_completion (GValue* value,
                      gpointer v_object)
{
	Completion * old;
#line 22 "src/completion.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPLETION));
#line 22 "src/completion.vala"
	old = value->data[0].v_pointer;
#line 22 "src/completion.vala"
	if (v_object) {
#line 22 "src/completion.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPLETION));
#line 22 "src/completion.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "src/completion.vala"
		value->data[0].v_pointer = v_object;
#line 22 "src/completion.vala"
		completion_ref (value->data[0].v_pointer);
#line 1667 "completion.c"
	} else {
#line 22 "src/completion.vala"
		value->data[0].v_pointer = NULL;
#line 1671 "completion.c"
	}
#line 22 "src/completion.vala"
	if (old) {
#line 22 "src/completion.vala"
		completion_unref (old);
#line 1677 "completion.c"
	}
}

void
value_take_completion (GValue* value,
                       gpointer v_object)
{
	Completion * old;
#line 22 "src/completion.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPLETION));
#line 22 "src/completion.vala"
	old = value->data[0].v_pointer;
#line 22 "src/completion.vala"
	if (v_object) {
#line 22 "src/completion.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPLETION));
#line 22 "src/completion.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "src/completion.vala"
		value->data[0].v_pointer = v_object;
#line 1698 "completion.c"
	} else {
#line 22 "src/completion.vala"
		value->data[0].v_pointer = NULL;
#line 1702 "completion.c"
	}
#line 22 "src/completion.vala"
	if (old) {
#line 22 "src/completion.vala"
		completion_unref (old);
#line 1708 "completion.c"
	}
}

static void
completion_class_init (CompletionClass * klass,
                       gpointer klass_data)
{
#line 22 "src/completion.vala"
	completion_parent_class = g_type_class_peek_parent (klass);
#line 22 "src/completion.vala"
	((CompletionClass *) klass)->finalize = completion_finalize;
#line 1720 "completion.c"
}

static void
completion_instance_init (Completion * self,
                          gpointer klass)
{
#line 22 "src/completion.vala"
	self->ref_count = 1;
#line 1729 "completion.c"
}

static void
completion_finalize (Completion * obj)
{
	Completion * self;
#line 22 "src/completion.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION, Completion);
#line 22 "src/completion.vala"
	g_signal_handlers_destroy (self);
#line 23 "src/completion.vala"
	_g_free0 (self->match);
#line 24 "src/completion.vala"
	_buffer_unref0 (self->old_bp);
#line 25 "src/completion.vala"
	_g_object_unref0 (self->completions);
#line 26 "src/completion.vala"
	_g_object_unref0 (self->matches);
#line 29 "src/completion.vala"
	_g_free0 (self->path);
#line 1750 "completion.c"
}

static GType
completion_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_completion_init, value_completion_free_value, value_completion_copy_value, value_completion_peek_pointer, "p", value_completion_collect_value, "p", value_completion_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Completion), 0, (GInstanceInitFunc) completion_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType completion_type_id;
	completion_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Completion", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return completion_type_id;
}

GType
completion_get_type (void)
{
	static volatile gsize completion_type_id__volatile = 0;
	if (g_once_init_enter (&completion_type_id__volatile)) {
		GType completion_type_id;
		completion_type_id = completion_get_type_once ();
		g_once_init_leave (&completion_type_id__volatile, completion_type_id);
	}
	return completion_type_id__volatile;
}

gpointer
completion_ref (gpointer instance)
{
	Completion * self;
	self = instance;
#line 22 "src/completion.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "src/completion.vala"
	return instance;
#line 1785 "completion.c"
}

void
completion_unref (gpointer instance)
{
	Completion * self;
	self = instance;
#line 22 "src/completion.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "src/completion.vala"
		COMPLETION_GET_CLASS (self)->finalize (self);
#line 22 "src/completion.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1799 "completion.c"
	}
}

