package ONVIF::Analytics::Types::H264Configuration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %GovLength_of :ATTR(:get<GovLength>);
my %H264Profile_of :ATTR(:get<H264Profile>);

__PACKAGE__->_factory(
    [ qw(        GovLength
        H264Profile

    ) ],
    {
        'GovLength' => \%GovLength_of,
        'H264Profile' => \%H264Profile_of,
    },
    {
        'GovLength' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'H264Profile' => 'ONVIF::Analytics::Types::H264Profile',
    },
    {

        'GovLength' => 'GovLength',
        'H264Profile' => 'H264Profile',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::H264Configuration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
H264Configuration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * GovLength


=item * H264Profile




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::H264Configuration
   GovLength =>  $some_value, # int
   H264Profile => $some_value, # H264Profile
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

