import builtins
import typing

from gi.repository import Atk
from gi.repository import GLib
from gi.repository import GObject
from gi.repository import Gdk
from gi.repository import GdkPixbuf
from gi.repository import Gio
from gi.repository import Pango
import cairo


class PyGTKDeprecationWarning():
    ...


class TreeModelRow():

    def __getitem__(self, key: int) -> typing.Any: ...


class TreeModelRowIter():
    def __next__(self) -> TreeModelRow: ...

    iter: TreeIter


class AccelGroup(GObject.Object):
    parent: GObject.Object

    def activate(self, accel_quark: builtins.int, acceleratable: GObject.Object, accel_key: builtins.int, accel_mods: Gdk.ModifierType) -> builtins.bool: ...

    def connect(self, accel_key: builtins.int, accel_mods: Gdk.ModifierType, accel_flags: AccelFlags, closure: AccelGroupActivate) -> None: ...  # type: ignore

    def connect_by_path(self, accel_path: builtins.str, closure: GObject.Closure) -> None: ...

    def disconnect(self, closure: typing.Optional[GObject.Closure]) -> builtins.bool: ...  # type: ignore

    def disconnect_key(self, accel_key: builtins.int, accel_mods: Gdk.ModifierType) -> builtins.bool: ...

    def find(self, find_func: AccelGroupFindFunc, *data: typing.Optional[builtins.object]) -> AccelKey: ...

    @staticmethod
    def from_accel_closure(closure: GObject.Closure) -> typing.Optional[AccelGroup]: ...

    def get_is_locked(self) -> builtins.bool: ...

    def get_modifier_mask(self) -> Gdk.ModifierType: ...

    def lock(self) -> None: ...

    @staticmethod
    def new(**kwargs) -> AccelGroup: ...  # type: ignore

    def query(self, accel_key: builtins.int, accel_mods: Gdk.ModifierType) -> typing.Optional[typing.Sequence[AccelGroupEntry]]: ...

    def unlock(self) -> None: ...

    def do_accel_changed(self, keyval: builtins.int, modifier: Gdk.ModifierType, accel_closure: GObject.Closure) -> None: ...


class AccelMap(GObject.Object):

    @staticmethod
    def add_entry(accel_path: builtins.str, accel_key: builtins.int, accel_mods: Gdk.ModifierType) -> None: ...

    @staticmethod
    def add_filter(filter_pattern: builtins.str) -> None: ...

    @staticmethod
    def change_entry(accel_path: builtins.str, accel_key: builtins.int, accel_mods: Gdk.ModifierType, replace: builtins.bool) -> builtins.bool: ...

    @staticmethod
    def foreach(data: typing.Optional[builtins.object], foreach_func: AccelMapForeach) -> None: ...

    @staticmethod
    def foreach_unfiltered(data: typing.Optional[builtins.object], foreach_func: AccelMapForeach) -> None: ...

    @staticmethod
    def get() -> AccelMap: ...

    @staticmethod
    def load(file_name: builtins.str) -> None: ...

    @staticmethod
    def load_fd(fd: builtins.int) -> None: ...

    @staticmethod
    def load_scanner(scanner: GLib.Scanner) -> None: ...

    @staticmethod
    def lock_path(accel_path: builtins.str) -> None: ...

    @staticmethod
    def lookup_entry(accel_path: builtins.str) -> typing.Tuple[builtins.bool, AccelKey]: ...

    @staticmethod
    def save(file_name: builtins.str) -> None: ...

    @staticmethod
    def save_fd(fd: builtins.int) -> None: ...

    @staticmethod
    def unlock_path(accel_path: builtins.str) -> None: ...


class Accessible(Atk.Object):
    parent: Atk.Object

    def connect_widget_destroyed(self) -> None: ...

    def get_widget(self) -> typing.Optional[Widget]: ...

    def set_widget(self, widget: typing.Optional[Widget]) -> None: ...

    def do_connect_widget_destroyed(self) -> None: ...

    def do_widget_set(self) -> None: ...

    def do_widget_unset(self) -> None: ...


class Actionable(GObject.GInterface):

    def get_action_name(self) -> typing.Optional[builtins.str]: ...

    def get_action_target_value(self) -> GLib.Variant: ...

    def set_action_name(self, action_name: typing.Optional[builtins.str]) -> None: ...

    def set_action_target_value(self, target_value: typing.Optional[GLib.Variant]) -> None: ...

    def set_detailed_action_name(self, detailed_action_name: builtins.str) -> None: ...

    def do_get_action_name(self) -> typing.Optional[builtins.str]: ...

    def do_get_action_target_value(self) -> GLib.Variant: ...

    def do_set_action_name(self, action_name: typing.Optional[builtins.str]) -> None: ...

    def do_set_action_target_value(self, target_value: typing.Optional[GLib.Variant]) -> None: ...


class Activatable(GObject.GInterface):

    def do_set_related_action(self, action: Action) -> None: ...

    def get_related_action(self) -> Action: ...

    def get_use_action_appearance(self) -> builtins.bool: ...

    def set_related_action(self, action: Action) -> None: ...

    def set_use_action_appearance(self, use_appearance: builtins.bool) -> None: ...

    def sync_action_properties(self, action: typing.Optional[Action]) -> None: ...

    def do_sync_action_properties(self, action: typing.Optional[Action]) -> None: ...

    def do_update(self, action: Action, property_name: builtins.str) -> None: ...


class Adjustment(GObject.InitiallyUnowned):
    parent_instance: GObject.InitiallyUnowned

    def changed(self) -> None: ...

    def clamp_page(self, lower: builtins.float, upper: builtins.float) -> None: ...

    def configure(self, value: builtins.float, lower: builtins.float, upper: builtins.float, step_increment: builtins.float, page_increment: builtins.float, page_size: builtins.float) -> None: ...

    def get_lower(self) -> builtins.float: ...

    def get_minimum_increment(self) -> builtins.float: ...

    def get_page_increment(self) -> builtins.float: ...

    def get_page_size(self) -> builtins.float: ...

    def get_step_increment(self) -> builtins.float: ...

    def get_upper(self) -> builtins.float: ...

    def get_value(self) -> builtins.float: ...

    @staticmethod
    def new(value: builtins.float, lower: builtins.float, upper: builtins.float, step_increment: builtins.float, page_increment: builtins.float, page_size: builtins.float) -> Adjustment: ...

    def set_lower(self, lower: builtins.float) -> None: ...

    def set_page_increment(self, page_increment: builtins.float) -> None: ...

    def set_page_size(self, page_size: builtins.float) -> None: ...

    def set_step_increment(self, step_increment: builtins.float) -> None: ...

    def set_upper(self, upper: builtins.float) -> None: ...

    def set_value(self, value: builtins.float) -> None: ...

    def value_changed(self) -> None: ...

    def do_changed(self) -> None: ...

    def do_value_changed(self) -> None: ...


class AppChooser(GObject.GInterface):

    def get_app_info(self) -> typing.Optional[Gio.AppInfo]: ...

    def get_content_type(self) -> builtins.str: ...

    def refresh(self) -> None: ...


class Application(Gio.Application):
    parent: Gio.Application

    def add_accelerator(self, accelerator: builtins.str, action_name: builtins.str, parameter: typing.Optional[GLib.Variant]) -> None: ...

    def add_window(self, window: Window) -> None: ...

    def get_accels_for_action(self, detailed_action_name: builtins.str) -> typing.Sequence[builtins.str]: ...

    def get_actions_for_accel(self, accel: builtins.str) -> typing.Sequence[builtins.str]: ...

    def get_active_window(self) -> typing.Optional[Window]: ...

    def get_app_menu(self) -> typing.Optional[Gio.MenuModel]: ...

    def get_menu_by_id(self, id: builtins.str) -> Gio.Menu: ...

    def get_menubar(self) -> Gio.MenuModel: ...

    def get_window_by_id(self, id: builtins.int) -> typing.Optional[Window]: ...

    def get_windows(self) -> typing.Sequence[Window]: ...

    def inhibit(self, window: typing.Optional[Window], flags: ApplicationInhibitFlags, reason: typing.Optional[builtins.str]) -> builtins.int: ...

    def is_inhibited(self, flags: ApplicationInhibitFlags) -> builtins.bool: ...

    def list_action_descriptions(self) -> typing.Sequence[builtins.str]: ...

    @staticmethod
    def new(application_id: typing.Optional[builtins.str], flags: Gio.ApplicationFlags) -> Application: ...  # type: ignore

    def prefers_app_menu(self) -> builtins.bool: ...

    def remove_accelerator(self, action_name: builtins.str, parameter: typing.Optional[GLib.Variant]) -> None: ...

    def remove_window(self, window: Window) -> None: ...

    def set_accels_for_action(self, detailed_action_name: builtins.str, accels: typing.Sequence[builtins.str]) -> None: ...

    def set_app_menu(self, app_menu: typing.Optional[Gio.MenuModel]) -> None: ...

    def set_menubar(self, menubar: typing.Optional[Gio.MenuModel]) -> None: ...

    def uninhibit(self, cookie: builtins.int) -> None: ...

    def do_window_added(self, window: Window) -> None: ...

    def do_window_removed(self, window: Window) -> None: ...


class Buildable(GObject.GInterface):

    def add_child(self, builder: Builder, child: GObject.Object, type: typing.Optional[builtins.str]) -> None: ...

    def construct_child(self, builder: Builder, name: builtins.str) -> GObject.Object: ...

    def custom_finished(self, builder: Builder, child: typing.Optional[GObject.Object], tagname: builtins.str, data: typing.Optional[builtins.object]) -> None: ...

    def custom_tag_end(self, builder: Builder, child: typing.Optional[GObject.Object], tagname: builtins.str, data: typing.Optional[builtins.object]) -> None: ...

    def custom_tag_start(self, builder: Builder, child: typing.Optional[GObject.Object], tagname: builtins.str) -> typing.Tuple[builtins.bool, GLib.MarkupParser, builtins.object]: ...

    def get_internal_child(self, builder: Builder, childname: builtins.str) -> GObject.Object: ...

    def get_name(self) -> builtins.str: ...

    def parser_finished(self, builder: Builder) -> None: ...

    def set_buildable_property(self, builder: Builder, name: builtins.str, value: GObject.Value) -> None: ...

    def set_name(self, name: builtins.str) -> None: ...

    def do_add_child(self, builder: Builder, child: GObject.Object, type: typing.Optional[builtins.str]) -> None: ...

    def do_construct_child(self, builder: Builder, name: builtins.str) -> GObject.Object: ...

    def do_custom_finished(self, builder: Builder, child: typing.Optional[GObject.Object], tagname: builtins.str, data: typing.Optional[builtins.object]) -> None: ...

    def do_custom_tag_end(self, builder: Builder, child: typing.Optional[GObject.Object], tagname: builtins.str, data: typing.Optional[builtins.object]) -> None: ...

    def do_custom_tag_start(self, builder: Builder, child: typing.Optional[GObject.Object], tagname: builtins.str) -> typing.Tuple[builtins.bool, GLib.MarkupParser, builtins.object]: ...

    def do_get_internal_child(self, builder: Builder, childname: builtins.str) -> GObject.Object: ...

    def do_get_name(self) -> builtins.str: ...

    def do_parser_finished(self, builder: Builder) -> None: ...

    def do_set_buildable_property(self, builder: Builder, name: builtins.str, value: GObject.Value) -> None: ...

    def do_set_name(self, name: builtins.str) -> None: ...


class Builder(GObject.Object):
    parent_instance: GObject.Object

    def __init__(self,
        *,
        translation_domain: typing.Optional[str] = None,
    ) -> None: ...

    def add_callback_symbol(self, callback_name: builtins.str, callback_symbol: GObject.Callback) -> None: ...

    def add_from_file(self, filename: builtins.str) -> builtins.int: ...

    def add_from_resource(self, resource_path: builtins.str) -> builtins.int: ...

    def add_from_string(self, buffer: builtins.str, length: builtins.int) -> builtins.int: ...

    def add_objects_from_file(self, filename: builtins.str, object_ids: typing.Sequence[builtins.str]) -> builtins.int: ...

    def add_objects_from_resource(self, resource_path: builtins.str, object_ids: typing.Sequence[builtins.str]) -> builtins.int: ...

    def add_objects_from_string(self, buffer: builtins.str, length: builtins.int, object_ids: typing.Sequence[builtins.str]) -> builtins.int: ...

    def connect_signals(self, user_data: typing.Optional[builtins.object]) -> None: ...

    def connect_signals_full(self, func: BuilderConnectFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def expose_object(self, name: builtins.str, object: GObject.Object) -> None: ...

    def extend_with_template(self, widget: Widget, template_type: GObject.GType, buffer: builtins.str, length: builtins.int) -> builtins.int: ...

    def get_application(self) -> typing.Optional[Application]: ...

    def get_object(self, name: builtins.str) -> typing.Optional[GObject.Object]: ...

    def get_objects(self) -> typing.Sequence[GObject.Object]: ...

    def get_translation_domain(self) -> builtins.str: ...

    def get_type_from_name(self, type_name: builtins.str) -> GObject.GType: ...

    @staticmethod
    def new(**kwargs) -> Builder: ...  # type: ignore

    @staticmethod
    def new_from_file(filename: builtins.str) -> Builder: ...

    @staticmethod
    def new_from_resource(resource_path: builtins.str) -> Builder: ...

    @staticmethod
    def new_from_string(string: builtins.str, length: builtins.int) -> Builder: ...

    def set_application(self, application: Application) -> None: ...

    def set_translation_domain(self, domain: typing.Optional[builtins.str]) -> None: ...

    def value_from_string(self, pspec: GObject.ParamSpec, string: builtins.str) -> typing.Tuple[builtins.bool, GObject.Value]: ...

    def value_from_string_type(self, type: GObject.GType, string: builtins.str) -> typing.Tuple[builtins.bool, GObject.Value]: ...

    def do_get_type_from_name(self, type_name: builtins.str) -> GObject.GType: ...


class CellAccessibleParent(GObject.GInterface):

    def activate(self, cell: CellAccessible) -> None: ...

    def edit(self, cell: CellAccessible) -> None: ...

    def expand_collapse(self, cell: CellAccessible) -> None: ...

    def get_cell_area(self, cell: CellAccessible) -> Gdk.Rectangle: ...

    def get_cell_extents(self, cell: CellAccessible, coord_type: Atk.CoordType) -> typing.Tuple[builtins.int, builtins.int, builtins.int, builtins.int]: ...

    def get_cell_position(self, cell: CellAccessible) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_child_index(self, cell: CellAccessible) -> builtins.int: ...

    def get_column_header_cells(self, cell: CellAccessible) -> typing.Sequence[Atk.Object]: ...

    def get_renderer_state(self, cell: CellAccessible) -> CellRendererState: ...

    def get_row_header_cells(self, cell: CellAccessible) -> typing.Sequence[Atk.Object]: ...

    def grab_focus(self, cell: CellAccessible) -> builtins.bool: ...

    def update_relationset(self, cell: CellAccessible, relationset: Atk.RelationSet) -> None: ...

    def do_activate(self, cell: CellAccessible) -> None: ...

    def do_edit(self, cell: CellAccessible) -> None: ...

    def do_expand_collapse(self, cell: CellAccessible) -> None: ...

    def do_get_cell_area(self, cell: CellAccessible) -> Gdk.Rectangle: ...

    def do_get_cell_extents(self, cell: CellAccessible, coord_type: Atk.CoordType) -> typing.Tuple[builtins.int, builtins.int, builtins.int, builtins.int]: ...

    def do_get_cell_position(self, cell: CellAccessible) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_child_index(self, cell: CellAccessible) -> builtins.int: ...

    def do_get_column_header_cells(self, cell: CellAccessible) -> typing.Sequence[Atk.Object]: ...

    def do_get_renderer_state(self, cell: CellAccessible) -> CellRendererState: ...

    def do_get_row_header_cells(self, cell: CellAccessible) -> typing.Sequence[Atk.Object]: ...

    def do_grab_focus(self, cell: CellAccessible) -> builtins.bool: ...

    def do_update_relationset(self, cell: CellAccessible, relationset: Atk.RelationSet) -> None: ...


class CellAreaContext(GObject.Object):
    parent_instance: GObject.Object

    def allocate(self, width: builtins.int, height: builtins.int) -> None: ...

    def get_allocation(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_area(self) -> CellArea: ...

    def get_preferred_height(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_height_for_width(self, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_width(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_width_for_height(self, height: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def push_preferred_height(self, minimum_height: builtins.int, natural_height: builtins.int) -> None: ...

    def push_preferred_width(self, minimum_width: builtins.int, natural_width: builtins.int) -> None: ...

    def reset(self) -> None: ...

    def do_allocate(self, width: builtins.int, height: builtins.int) -> None: ...

    def do_get_preferred_height_for_width(self, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_width_for_height(self, height: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_reset(self) -> None: ...


class CellEditable(GObject.GInterface):

    def editing_done(self) -> None: ...

    def remove_widget(self) -> None: ...

    def start_editing(self, event: typing.Optional[Gdk.Event]) -> None: ...

    def do_editing_done(self) -> None: ...

    def do_remove_widget(self) -> None: ...

    def do_start_editing(self, event: typing.Optional[Gdk.Event]) -> None: ...


class CellLayout(GObject.GInterface):

    def add_attribute(self, cell: CellRenderer, attribute: builtins.str, column: builtins.int) -> None: ...

    def clear(self) -> None: ...

    def clear_attributes(self, cell: CellRenderer) -> None: ...

    def get_area(self) -> typing.Optional[CellArea]: ...

    def get_cells(self) -> typing.Sequence[CellRenderer]: ...

    def pack_end(self, cell: CellRenderer, expand: builtins.bool) -> None: ...

    def pack_start(self, cell: CellRenderer, expand: builtins.bool) -> None: ...

    def reorder(self, cell: CellRenderer, position: builtins.int) -> None: ...

    def set_cell_data_func(self, cell: CellRenderer, func: typing.Optional[CellLayoutDataFunc], *func_data: typing.Optional[builtins.object]) -> None: ...

    def do_add_attribute(self, cell: CellRenderer, attribute: builtins.str, column: builtins.int) -> None: ...

    def do_clear(self) -> None: ...

    def do_clear_attributes(self, cell: CellRenderer) -> None: ...

    def do_get_area(self) -> typing.Optional[CellArea]: ...

    def do_get_cells(self) -> typing.Sequence[CellRenderer]: ...

    def do_pack_end(self, cell: CellRenderer, expand: builtins.bool) -> None: ...

    def do_pack_start(self, cell: CellRenderer, expand: builtins.bool) -> None: ...

    def do_reorder(self, cell: CellRenderer, position: builtins.int) -> None: ...

    def do_set_cell_data_func(self, cell: CellRenderer, func: typing.Optional[CellLayoutDataFunc], func_data: typing.Optional[builtins.object]) -> None: ...


class CellRenderer(GObject.InitiallyUnowned):
    parent_instance: GObject.InitiallyUnowned

    class _Props:
        sensitive: bool

    props: _Props

    def activate(self, event: Gdk.Event, widget: Widget, path: builtins.str, background_area: Gdk.Rectangle, cell_area: Gdk.Rectangle, flags: CellRendererState) -> builtins.bool: ...

    def get_aligned_area(self, widget: Widget, flags: CellRendererState, cell_area: Gdk.Rectangle) -> Gdk.Rectangle: ...

    def get_alignment(self) -> typing.Tuple[builtins.float, builtins.float]: ...

    def get_fixed_size(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_padding(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_height(self, widget: Widget) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_height_for_width(self, widget: Widget, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_size(self, widget: Widget) -> typing.Tuple[Requisition, Requisition]: ...

    def get_preferred_width(self, widget: Widget) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_width_for_height(self, widget: Widget, height: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_request_mode(self) -> SizeRequestMode: ...

    def get_sensitive(self) -> builtins.bool: ...

    def get_size(self, widget: Widget, cell_area: typing.Optional[Gdk.Rectangle]) -> typing.Tuple[builtins.int, builtins.int, builtins.int, builtins.int]: ...

    def get_state(self, widget: typing.Optional[Widget], cell_state: CellRendererState) -> StateFlags: ...

    def get_visible(self) -> builtins.bool: ...

    def is_activatable(self) -> builtins.bool: ...

    def render(self, cr: cairo.Context, widget: Widget, background_area: Gdk.Rectangle, cell_area: Gdk.Rectangle, flags: CellRendererState) -> None: ...

    def set_alignment(self, xalign: builtins.float, yalign: builtins.float) -> None: ...

    def set_fixed_size(self, width: builtins.int, height: builtins.int) -> None: ...

    def set_padding(self, xpad: builtins.int, ypad: builtins.int) -> None: ...

    def set_sensitive(self, sensitive: builtins.bool) -> None: ...

    def set_visible(self, visible: builtins.bool) -> None: ...

    def start_editing(self, event: typing.Optional[Gdk.Event], widget: Widget, path: builtins.str, background_area: Gdk.Rectangle, cell_area: Gdk.Rectangle, flags: CellRendererState) -> typing.Optional[CellEditable]: ...

    def stop_editing(self, canceled: builtins.bool) -> None: ...

    @staticmethod
    def set_accessible_type(type: GObject.GType) -> None: ...

    def do_activate(self, event: Gdk.Event, widget: Widget, path: builtins.str, background_area: Gdk.Rectangle, cell_area: Gdk.Rectangle, flags: CellRendererState) -> builtins.bool: ...

    def do_editing_canceled(self) -> None: ...

    def do_editing_started(self, editable: CellEditable, path: builtins.str) -> None: ...

    def do_get_aligned_area(self, widget: Widget, flags: CellRendererState, cell_area: Gdk.Rectangle) -> Gdk.Rectangle: ...

    def do_get_preferred_height(self, widget: Widget) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_height_for_width(self, widget: Widget, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_width(self, widget: Widget) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_width_for_height(self, widget: Widget, height: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_request_mode(self) -> SizeRequestMode: ...

    def do_get_size(self, widget: Widget, cell_area: typing.Optional[Gdk.Rectangle]) -> typing.Tuple[builtins.int, builtins.int, builtins.int, builtins.int]: ...

    def do_render(self, cr: cairo.Context, widget: Widget, background_area: Gdk.Rectangle, cell_area: Gdk.Rectangle, flags: CellRendererState) -> None: ...

    def do_start_editing(self, event: typing.Optional[Gdk.Event], widget: Widget, path: builtins.str, background_area: Gdk.Rectangle, cell_area: Gdk.Rectangle, flags: CellRendererState) -> typing.Optional[CellEditable]: ...


class Clipboard(GObject.Object):

    def clear(self) -> None: ...

    @staticmethod
    def get(selection: Gdk.Atom) -> Clipboard: ...

    @staticmethod
    def get_default(display: Gdk.Display) -> Clipboard: ...

    def get_display(self) -> Gdk.Display: ...

    @staticmethod
    def get_for_display(display: Gdk.Display, selection: Gdk.Atom) -> Clipboard: ...

    def get_owner(self) -> typing.Optional[GObject.Object]: ...

    def request_contents(self, target: Gdk.Atom, callback: ClipboardReceivedFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def request_image(self, callback: ClipboardImageReceivedFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def request_rich_text(self, buffer: TextBuffer, callback: ClipboardRichTextReceivedFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def request_targets(self, callback: ClipboardTargetsReceivedFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def request_text(self, callback: ClipboardTextReceivedFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def request_uris(self, callback: ClipboardURIReceivedFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_can_store(self, targets: typing.Optional[typing.Sequence[TargetEntry]]) -> None: ...

    def set_image(self, pixbuf: GdkPixbuf.Pixbuf) -> None: ...

    def set_text(self, text: builtins.str, len: builtins.int) -> None: ...

    def store(self) -> None: ...

    def wait_for_contents(self, target: Gdk.Atom) -> typing.Optional[SelectionData]: ...

    def wait_for_image(self) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def wait_for_rich_text(self, buffer: TextBuffer) -> typing.Tuple[typing.Optional[builtins.bytes], Gdk.Atom]: ...

    def wait_for_targets(self) -> typing.Tuple[builtins.bool, typing.Sequence[Gdk.Atom]]: ...

    def wait_for_text(self) -> typing.Optional[builtins.str]: ...

    def wait_for_uris(self) -> typing.Optional[typing.Sequence[builtins.str]]: ...

    def wait_is_image_available(self) -> builtins.bool: ...

    def wait_is_rich_text_available(self, buffer: TextBuffer) -> builtins.bool: ...

    def wait_is_target_available(self, target: Gdk.Atom) -> builtins.bool: ...

    def wait_is_text_available(self) -> builtins.bool: ...

    def wait_is_uris_available(self) -> builtins.bool: ...


class ColorChooser(GObject.GInterface):

    def add_palette(self, orientation: Orientation, colors_per_line: builtins.int, colors: typing.Optional[typing.Sequence[Gdk.RGBA]]) -> None: ...

    def get_rgba(self) -> Gdk.RGBA: ...

    def get_use_alpha(self) -> builtins.bool: ...

    def set_rgba(self, color: Gdk.RGBA) -> None: ...

    def set_use_alpha(self, use_alpha: builtins.bool) -> None: ...

    def do_add_palette(self, orientation: Orientation, colors_per_line: builtins.int, colors: typing.Optional[typing.Sequence[Gdk.RGBA]]) -> None: ...

    def do_color_activated(self, color: Gdk.RGBA) -> None: ...

    def do_get_rgba(self) -> Gdk.RGBA: ...

    def do_set_rgba(self, color: Gdk.RGBA) -> None: ...


class Editable(GObject.GInterface):

    def copy_clipboard(self) -> None: ...

    def cut_clipboard(self) -> None: ...

    def delete_selection(self) -> None: ...

    def delete_text(self, start_pos: builtins.int, end_pos: builtins.int) -> None: ...

    def get_chars(self, start_pos: builtins.int, end_pos: builtins.int) -> builtins.str: ...

    def get_editable(self) -> builtins.bool: ...

    def get_position(self) -> builtins.int: ...

    def get_selection_bounds(self) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...

    def insert_text(self, new_text: builtins.str, new_text_length: builtins.int, position: builtins.int) -> builtins.int: ...

    def paste_clipboard(self) -> None: ...

    def select_region(self, start_pos: builtins.int, end_pos: builtins.int) -> None: ...

    def set_editable(self, is_editable: builtins.bool) -> None: ...

    def set_position(self, position: builtins.int) -> None: ...

    def do_changed(self) -> None: ...

    def do_delete_text(self, start_pos: builtins.int, end_pos: builtins.int) -> None: ...

    def do_do_delete_text(self, start_pos: builtins.int, end_pos: builtins.int) -> None: ...

    def do_do_insert_text(self, new_text: builtins.str, new_text_length: builtins.int, position: builtins.int) -> builtins.int: ...

    def do_get_chars(self, start_pos: builtins.int, end_pos: builtins.int) -> builtins.str: ...

    def do_get_position(self) -> builtins.int: ...

    def do_get_selection_bounds(self) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...

    def do_insert_text(self, new_text: builtins.str, new_text_length: builtins.int, position: builtins.int) -> builtins.int: ...

    def do_set_position(self, position: builtins.int) -> None: ...

    def do_set_selection_bounds(self, start_pos: builtins.int, end_pos: builtins.int) -> None: ...


class EntryBuffer(GObject.Object):
    parent_instance: GObject.Object

    class _Props:
        text: str

    props: _Props

    def delete_text(self, position: builtins.int, n_chars: builtins.int) -> builtins.int: ...

    def emit_deleted_text(self, position: builtins.int, n_chars: builtins.int) -> None: ...

    def emit_inserted_text(self, position: builtins.int, chars: builtins.str, n_chars: builtins.int) -> None: ...

    def get_bytes(self) -> builtins.int: ...

    def get_length(self) -> builtins.int: ...

    def get_max_length(self) -> builtins.int: ...

    def get_text(self) -> builtins.str: ...

    def insert_text(self, position: builtins.int, chars: builtins.str, n_chars: builtins.int) -> builtins.int: ...

    @staticmethod
    def new(initial_chars: typing.Optional[builtins.str], n_initial_chars: builtins.int, **kwargs) -> EntryBuffer: ...  # type: ignore

    def set_max_length(self, max_length: builtins.int) -> None: ...

    def set_text(self, chars: builtins.str, n_chars: builtins.int) -> None: ...

    def do_delete_text(self, position: builtins.int, n_chars: builtins.int) -> builtins.int: ...

    def do_deleted_text(self, position: builtins.int, n_chars: builtins.int) -> None: ...

    def do_get_length(self) -> builtins.int: ...

    def do_get_text(self, n_bytes: builtins.int) -> builtins.str: ...

    def do_insert_text(self, position: builtins.int, chars: builtins.str, n_chars: builtins.int) -> builtins.int: ...

    def do_inserted_text(self, position: builtins.int, chars: builtins.str, n_chars: builtins.int) -> None: ...


class EntryIconAccessible(Atk.Object, Atk.Action, Atk.Component):  # type: ignore
    ...


class EventController(GObject.Object):

    def get_propagation_phase(self) -> PropagationPhase: ...

    def get_widget(self) -> Widget: ...

    def handle_event(self, event: Gdk.Event) -> builtins.bool: ...

    def reset(self) -> None: ...

    def set_propagation_phase(self, phase: PropagationPhase) -> None: ...


class FileChooser(GObject.GInterface):

    def add_choice(self, id: builtins.str, label: builtins.str, options: typing.Optional[typing.Sequence[builtins.str]], option_labels: typing.Optional[typing.Sequence[builtins.str]]) -> None: ...

    def add_filter(self, filter: FileFilter) -> None: ...

    def add_shortcut_folder(self, folder: builtins.str) -> builtins.bool: ...

    def add_shortcut_folder_uri(self, uri: builtins.str) -> builtins.bool: ...

    def get_action(self) -> FileChooserAction: ...

    def get_choice(self, id: builtins.str) -> builtins.str: ...

    def get_create_folders(self) -> builtins.bool: ...

    def get_current_folder(self) -> typing.Optional[builtins.str]: ...

    def get_current_folder_file(self) -> Gio.File: ...

    def get_current_folder_uri(self) -> typing.Optional[builtins.str]: ...

    def get_current_name(self) -> builtins.str: ...

    def get_do_overwrite_confirmation(self) -> builtins.bool: ...

    def get_extra_widget(self) -> typing.Optional[Widget]: ...

    def get_file(self) -> Gio.File: ...

    def get_filename(self) -> typing.Optional[builtins.str]: ...

    def get_filenames(self) -> typing.Sequence[builtins.str]: ...

    def get_files(self) -> typing.Sequence[Gio.File]: ...

    def get_filter(self) -> typing.Optional[FileFilter]: ...

    def get_local_only(self) -> builtins.bool: ...

    def get_preview_file(self) -> typing.Optional[Gio.File]: ...

    def get_preview_filename(self) -> typing.Optional[builtins.str]: ...

    def get_preview_uri(self) -> typing.Optional[builtins.str]: ...

    def get_preview_widget(self) -> typing.Optional[Widget]: ...

    def get_preview_widget_active(self) -> builtins.bool: ...

    def get_select_multiple(self) -> builtins.bool: ...

    def get_show_hidden(self) -> builtins.bool: ...

    def get_uri(self) -> typing.Optional[builtins.str]: ...

    def get_uris(self) -> typing.Sequence[builtins.str]: ...

    def get_use_preview_label(self) -> builtins.bool: ...

    def list_filters(self) -> typing.Sequence[FileFilter]: ...

    def list_shortcut_folder_uris(self) -> typing.Optional[typing.Sequence[builtins.str]]: ...

    def list_shortcut_folders(self) -> typing.Optional[typing.Sequence[builtins.str]]: ...

    def remove_choice(self, id: builtins.str) -> None: ...

    def remove_filter(self, filter: FileFilter) -> None: ...

    def remove_shortcut_folder(self, folder: builtins.str) -> builtins.bool: ...

    def remove_shortcut_folder_uri(self, uri: builtins.str) -> builtins.bool: ...

    def select_all(self) -> None: ...

    def select_file(self, file: Gio.File) -> builtins.bool: ...

    def select_filename(self, filename: builtins.str) -> builtins.bool: ...

    def select_uri(self, uri: builtins.str) -> builtins.bool: ...

    def set_action(self, action: FileChooserAction) -> None: ...

    def set_choice(self, id: builtins.str, option: builtins.str) -> None: ...

    def set_create_folders(self, create_folders: builtins.bool) -> None: ...

    def set_current_folder(self, filename: builtins.str) -> builtins.bool: ...

    def set_current_folder_file(self, file: Gio.File) -> builtins.bool: ...

    def set_current_folder_uri(self, uri: builtins.str) -> builtins.bool: ...

    def set_current_name(self, name: builtins.str) -> None: ...

    def set_do_overwrite_confirmation(self, do_overwrite_confirmation: builtins.bool) -> None: ...

    def set_extra_widget(self, extra_widget: Widget) -> None: ...

    def set_file(self, file: Gio.File) -> builtins.bool: ...

    def set_filename(self, filename: builtins.str) -> builtins.bool: ...

    def set_filter(self, filter: FileFilter) -> None: ...

    def set_local_only(self, local_only: builtins.bool) -> None: ...

    def set_preview_widget(self, preview_widget: Widget) -> None: ...

    def set_preview_widget_active(self, active: builtins.bool) -> None: ...

    def set_select_multiple(self, select_multiple: builtins.bool) -> None: ...

    def set_show_hidden(self, show_hidden: builtins.bool) -> None: ...

    def set_uri(self, uri: builtins.str) -> builtins.bool: ...

    def set_use_preview_label(self, use_label: builtins.bool) -> None: ...

    def unselect_all(self) -> None: ...

    def unselect_file(self, file: Gio.File) -> None: ...

    def unselect_filename(self, filename: builtins.str) -> None: ...

    def unselect_uri(self, uri: builtins.str) -> None: ...


class FontChooser(GObject.GInterface):

    def get_font(self) -> typing.Optional[builtins.str]: ...

    def get_font_desc(self) -> typing.Optional[Pango.FontDescription]: ...

    def get_font_face(self) -> typing.Optional[Pango.FontFace]: ...

    def get_font_family(self) -> typing.Optional[Pango.FontFamily]: ...

    def get_font_features(self) -> builtins.str: ...

    def get_font_map(self) -> typing.Optional[Pango.FontMap]: ...

    def get_font_size(self) -> builtins.int: ...

    def get_language(self) -> builtins.str: ...

    def get_level(self) -> FontChooserLevel: ...

    def get_preview_text(self) -> builtins.str: ...

    def get_show_preview_entry(self) -> builtins.bool: ...

    def set_filter_func(self, filter: typing.Optional[FontFilterFunc], *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_font(self, fontname: builtins.str) -> None: ...

    def set_font_desc(self, font_desc: Pango.FontDescription) -> None: ...

    def set_font_map(self, fontmap: typing.Optional[Pango.FontMap]) -> None: ...

    def set_language(self, language: builtins.str) -> None: ...

    def set_level(self, level: FontChooserLevel) -> None: ...

    def set_preview_text(self, text: builtins.str) -> None: ...

    def set_show_preview_entry(self, show_preview_entry: builtins.bool) -> None: ...

    def do_font_activated(self, fontname: builtins.str) -> None: ...

    def do_get_font_face(self) -> typing.Optional[Pango.FontFace]: ...

    def do_get_font_family(self) -> typing.Optional[Pango.FontFamily]: ...

    def do_get_font_map(self) -> typing.Optional[Pango.FontMap]: ...

    def do_get_font_size(self) -> builtins.int: ...

    def do_set_filter_func(self, filter: typing.Optional[FontFilterFunc], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_set_font_map(self, fontmap: typing.Optional[Pango.FontMap]) -> None: ...


class IMContext(GObject.Object):
    parent_instance: GObject.Object

    def delete_surrounding(self, offset: builtins.int, n_chars: builtins.int) -> builtins.bool: ...

    def filter_keypress(self, event: Gdk.EventKey) -> builtins.bool: ...

    def focus_in(self) -> None: ...

    def focus_out(self) -> None: ...

    def get_preedit_string(self) -> typing.Tuple[builtins.str, Pango.AttrList, builtins.int]: ...

    def get_surrounding(self) -> typing.Tuple[builtins.bool, builtins.str, builtins.int]: ...

    def reset(self) -> None: ...

    def set_client_window(self, window: typing.Optional[Gdk.Window]) -> None: ...

    def set_cursor_location(self, area: Gdk.Rectangle) -> None: ...

    def set_surrounding(self, text: builtins.str, len: builtins.int, cursor_index: builtins.int) -> None: ...

    def set_use_preedit(self, use_preedit: builtins.bool) -> None: ...

    def do_commit(self, str: builtins.str) -> None: ...

    def do_delete_surrounding(self, offset: builtins.int, n_chars: builtins.int) -> builtins.bool: ...

    def do_filter_keypress(self, event: Gdk.EventKey) -> builtins.bool: ...

    def do_focus_in(self) -> None: ...

    def do_focus_out(self) -> None: ...

    def do_get_preedit_string(self) -> typing.Tuple[builtins.str, Pango.AttrList, builtins.int]: ...

    def do_get_surrounding(self) -> typing.Tuple[builtins.bool, builtins.str, builtins.int]: ...

    def do_preedit_changed(self) -> None: ...

    def do_preedit_end(self) -> None: ...

    def do_preedit_start(self) -> None: ...

    def do_reset(self) -> None: ...

    def do_retrieve_surrounding(self) -> builtins.bool: ...

    def do_set_client_window(self, window: typing.Optional[Gdk.Window]) -> None: ...

    def do_set_cursor_location(self, area: Gdk.Rectangle) -> None: ...

    def do_set_surrounding(self, text: builtins.str, len: builtins.int, cursor_index: builtins.int) -> None: ...

    def do_set_use_preedit(self, use_preedit: builtins.bool) -> None: ...


class IconInfo(GObject.Object):

    def get_attach_points(self) -> typing.Tuple[builtins.bool, typing.Sequence[Gdk.Point]]: ...

    def get_base_scale(self) -> builtins.int: ...

    def get_base_size(self) -> builtins.int: ...

    def get_builtin_pixbuf(self) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def get_display_name(self) -> builtins.str: ...

    def get_embedded_rect(self) -> typing.Tuple[builtins.bool, Gdk.Rectangle]: ...

    def get_filename(self) -> typing.Optional[builtins.str]: ...

    def is_symbolic(self) -> builtins.bool: ...

    def load_icon(self) -> GdkPixbuf.Pixbuf: ...

    def load_icon_async(self, cancellable: typing.Optional[Gio.Cancellable], callback: typing.Optional[Gio.AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def load_icon_finish(self, res: Gio.AsyncResult) -> GdkPixbuf.Pixbuf: ...

    def load_surface(self, for_window: typing.Optional[Gdk.Window]) -> cairo.Surface: ...

    def load_symbolic(self, fg: Gdk.RGBA, success_color: typing.Optional[Gdk.RGBA], warning_color: typing.Optional[Gdk.RGBA], error_color: typing.Optional[Gdk.RGBA]) -> typing.Tuple[GdkPixbuf.Pixbuf, builtins.bool]: ...

    def load_symbolic_async(self, fg: Gdk.RGBA, success_color: typing.Optional[Gdk.RGBA], warning_color: typing.Optional[Gdk.RGBA], error_color: typing.Optional[Gdk.RGBA], cancellable: typing.Optional[Gio.Cancellable], callback: typing.Optional[Gio.AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def load_symbolic_finish(self, res: Gio.AsyncResult) -> typing.Tuple[GdkPixbuf.Pixbuf, builtins.bool]: ...

    def load_symbolic_for_context(self, context: StyleContext) -> typing.Tuple[GdkPixbuf.Pixbuf, builtins.bool]: ...

    def load_symbolic_for_context_async(self, context: StyleContext, cancellable: typing.Optional[Gio.Cancellable], callback: typing.Optional[Gio.AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def load_symbolic_for_context_finish(self, res: Gio.AsyncResult) -> typing.Tuple[GdkPixbuf.Pixbuf, builtins.bool]: ...

    def load_symbolic_for_style(self, style: Style, state: StateType) -> typing.Tuple[GdkPixbuf.Pixbuf, builtins.bool]: ...

    @staticmethod
    def new_for_pixbuf(icon_theme: IconTheme, pixbuf: GdkPixbuf.Pixbuf) -> IconInfo: ...

    def set_raw_coordinates(self, raw_coordinates: builtins.bool) -> None: ...


class IconTheme(GObject.Object):
    parent_instance: GObject.Object

    @staticmethod
    def add_builtin_icon(icon_name: builtins.str, size: builtins.int, pixbuf: GdkPixbuf.Pixbuf) -> None: ...

    def add_resource_path(self, path: builtins.str) -> None: ...

    def append_search_path(self, path: builtins.str) -> None: ...

    def choose_icon(self, icon_names: typing.Sequence[builtins.str], size: builtins.int, flags: IconLookupFlags) -> typing.Optional[IconInfo]: ...

    def choose_icon_for_scale(self, icon_names: typing.Sequence[builtins.str], size: builtins.int, scale: builtins.int, flags: IconLookupFlags) -> typing.Optional[IconInfo]: ...

    @staticmethod
    def get_default() -> IconTheme: ...

    def get_example_icon_name(self) -> typing.Optional[builtins.str]: ...

    @staticmethod
    def get_for_screen(screen: Gdk.Screen) -> IconTheme: ...

    def get_icon_sizes(self, icon_name: builtins.str) -> typing.Sequence[builtins.int]: ...

    def get_search_path(self) -> typing.Sequence[builtins.str]: ...

    def has_icon(self, icon_name: builtins.str) -> builtins.bool: ...

    def list_contexts(self) -> typing.Sequence[builtins.str]: ...

    def list_icons(self, context: typing.Optional[builtins.str]) -> typing.Sequence[builtins.str]: ...

    def load_icon(self, icon_name: builtins.str, size: builtins.int, flags: IconLookupFlags) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def load_icon_for_scale(self, icon_name: builtins.str, size: builtins.int, scale: builtins.int, flags: IconLookupFlags) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def load_surface(self, icon_name: builtins.str, size: builtins.int, scale: builtins.int, for_window: typing.Optional[Gdk.Window], flags: IconLookupFlags) -> typing.Optional[cairo.Surface]: ...

    def lookup_by_gicon(self, icon: Gio.Icon, size: builtins.int, flags: IconLookupFlags) -> typing.Optional[IconInfo]: ...

    def lookup_by_gicon_for_scale(self, icon: Gio.Icon, size: builtins.int, scale: builtins.int, flags: IconLookupFlags) -> typing.Optional[IconInfo]: ...

    def lookup_icon(self, icon_name: builtins.str, size: builtins.int, flags: IconLookupFlags) -> typing.Optional[IconInfo]: ...

    def lookup_icon_for_scale(self, icon_name: builtins.str, size: builtins.int, scale: builtins.int, flags: IconLookupFlags) -> typing.Optional[IconInfo]: ...

    @staticmethod
    def new(**kwargs) -> IconTheme: ...  # type: ignore

    def prepend_search_path(self, path: builtins.str) -> None: ...

    def rescan_if_needed(self) -> builtins.bool: ...

    def set_custom_theme(self, theme_name: typing.Optional[builtins.str]) -> None: ...

    def set_screen(self, screen: Gdk.Screen) -> None: ...

    def set_search_path(self, path: typing.Sequence[builtins.str]) -> None: ...

    def do_changed(self) -> None: ...


class MountOperation(Gio.MountOperation):
    parent_instance: Gio.MountOperation

    def get_parent(self) -> Window: ...

    def get_screen(self) -> Gdk.Screen: ...

    def is_showing(self) -> builtins.bool: ...

    @staticmethod
    def new(parent: typing.Optional[Window]) -> Gio.MountOperation: ...  # type: ignore

    def set_parent(self, parent: typing.Optional[Window]) -> None: ...

    def set_screen(self, screen: Gdk.Screen) -> None: ...


class NativeDialog(GObject.Object):
    parent_instance: GObject.Object

    def destroy(self) -> None: ...

    def get_modal(self) -> builtins.bool: ...

    def get_title(self) -> typing.Optional[builtins.str]: ...

    def get_transient_for(self) -> typing.Optional[Window]: ...

    def get_visible(self) -> builtins.bool: ...

    def hide(self) -> None: ...

    def run(self) -> builtins.int: ...

    def set_modal(self, modal: builtins.bool) -> None: ...

    def set_title(self, title: builtins.str) -> None: ...

    def set_transient_for(self, parent: typing.Optional[Window]) -> None: ...

    def show(self) -> None: ...

    def do_hide(self) -> None: ...

    def do_response(self, response_id: builtins.int) -> None: ...

    def do_show(self) -> None: ...


class NotebookPageAccessible(Atk.Object, Atk.Component):
    parent: Atk.Object

    def invalidate(self) -> None: ...

    @staticmethod
    def new(notebook: NotebookAccessible, child: Widget) -> Atk.Object: ...


class NumerableIcon(Gio.EmblemedIcon):
    parent: Gio.EmblemedIcon

    def get_background_gicon(self) -> typing.Optional[Gio.Icon]: ...

    def get_background_icon_name(self) -> typing.Optional[builtins.str]: ...

    def get_count(self) -> builtins.int: ...

    def get_label(self) -> typing.Optional[builtins.str]: ...

    def get_style_context(self) -> typing.Optional[StyleContext]: ...

    @staticmethod
    def new(base_icon: Gio.Icon) -> Gio.Icon: ...  # type: ignore

    @staticmethod
    def new_with_style_context(base_icon: Gio.Icon, context: StyleContext) -> Gio.Icon: ...

    def set_background_gicon(self, icon: typing.Optional[Gio.Icon]) -> None: ...

    def set_background_icon_name(self, icon_name: typing.Optional[builtins.str]) -> None: ...

    def set_count(self, count: builtins.int) -> None: ...

    def set_label(self, label: typing.Optional[builtins.str]) -> None: ...

    def set_style_context(self, style: StyleContext) -> None: ...


class Orientable(GObject.GInterface):

    def get_orientation(self) -> Orientation: ...

    def set_orientation(self, orientation: Orientation) -> None: ...


class PageSetup(GObject.Object):

    def copy(self) -> PageSetup: ...

    def get_bottom_margin(self, unit: Unit) -> builtins.float: ...

    def get_left_margin(self, unit: Unit) -> builtins.float: ...

    def get_orientation(self) -> PageOrientation: ...

    def get_page_height(self, unit: Unit) -> builtins.float: ...

    def get_page_width(self, unit: Unit) -> builtins.float: ...

    def get_paper_height(self, unit: Unit) -> builtins.float: ...

    def get_paper_size(self) -> PaperSize: ...

    def get_paper_width(self, unit: Unit) -> builtins.float: ...

    def get_right_margin(self, unit: Unit) -> builtins.float: ...

    def get_top_margin(self, unit: Unit) -> builtins.float: ...

    def load_file(self, file_name: builtins.str) -> builtins.bool: ...

    def load_key_file(self, key_file: GLib.KeyFile, group_name: typing.Optional[builtins.str]) -> builtins.bool: ...

    @staticmethod
    def new(**kwargs) -> PageSetup: ...  # type: ignore

    @staticmethod
    def new_from_file(file_name: builtins.str) -> PageSetup: ...

    @staticmethod
    def new_from_gvariant(variant: GLib.Variant) -> PageSetup: ...

    @staticmethod
    def new_from_key_file(key_file: GLib.KeyFile, group_name: typing.Optional[builtins.str]) -> PageSetup: ...

    def set_bottom_margin(self, margin: builtins.float, unit: Unit) -> None: ...

    def set_left_margin(self, margin: builtins.float, unit: Unit) -> None: ...

    def set_orientation(self, orientation: PageOrientation) -> None: ...

    def set_paper_size(self, size: PaperSize) -> None: ...

    def set_paper_size_and_default_margins(self, size: PaperSize) -> None: ...

    def set_right_margin(self, margin: builtins.float, unit: Unit) -> None: ...

    def set_top_margin(self, margin: builtins.float, unit: Unit) -> None: ...

    def to_file(self, file_name: builtins.str) -> builtins.bool: ...

    def to_gvariant(self) -> GLib.Variant: ...

    def to_key_file(self, key_file: GLib.KeyFile, group_name: typing.Optional[builtins.str]) -> None: ...


class PrintContext(GObject.Object):

    def create_pango_context(self) -> Pango.Context: ...

    def create_pango_layout(self) -> Pango.Layout: ...

    def get_cairo_context(self) -> cairo.Context: ...

    def get_dpi_x(self) -> builtins.float: ...

    def get_dpi_y(self) -> builtins.float: ...

    def get_hard_margins(self) -> typing.Tuple[builtins.bool, builtins.float, builtins.float, builtins.float, builtins.float]: ...

    def get_height(self) -> builtins.float: ...

    def get_page_setup(self) -> PageSetup: ...

    def get_pango_fontmap(self) -> Pango.FontMap: ...

    def get_width(self) -> builtins.float: ...

    def set_cairo_context(self, cr: cairo.Context, dpi_x: builtins.float, dpi_y: builtins.float) -> None: ...


class PrintOperationPreview(GObject.GInterface):

    def end_preview(self) -> None: ...

    def is_selected(self, page_nr: builtins.int) -> builtins.bool: ...

    def render_page(self, page_nr: builtins.int) -> None: ...

    def do_end_preview(self) -> None: ...

    def do_got_page_size(self, context: PrintContext, page_setup: PageSetup) -> None: ...

    def do_is_selected(self, page_nr: builtins.int) -> builtins.bool: ...

    def do_ready(self, context: PrintContext) -> None: ...

    def do_render_page(self, page_nr: builtins.int) -> None: ...


class PrintSettings(GObject.Object):

    def copy(self) -> PrintSettings: ...

    def foreach(self, func: PrintSettingsFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def get(self, key: builtins.str) -> builtins.str: ...

    def get_bool(self, key: builtins.str) -> builtins.bool: ...

    def get_collate(self) -> builtins.bool: ...

    def get_default_source(self) -> builtins.str: ...

    def get_dither(self) -> builtins.str: ...

    def get_double(self, key: builtins.str) -> builtins.float: ...

    def get_double_with_default(self, key: builtins.str, def_: builtins.float) -> builtins.float: ...

    def get_duplex(self) -> PrintDuplex: ...

    def get_finishings(self) -> builtins.str: ...

    def get_int(self, key: builtins.str) -> builtins.int: ...

    def get_int_with_default(self, key: builtins.str, def_: builtins.int) -> builtins.int: ...

    def get_length(self, key: builtins.str, unit: Unit) -> builtins.float: ...

    def get_media_type(self) -> builtins.str: ...

    def get_n_copies(self) -> builtins.int: ...

    def get_number_up(self) -> builtins.int: ...

    def get_number_up_layout(self) -> NumberUpLayout: ...

    def get_orientation(self) -> PageOrientation: ...

    def get_output_bin(self) -> builtins.str: ...

    def get_page_ranges(self) -> typing.Sequence[PageRange]: ...

    def get_page_set(self) -> PageSet: ...

    def get_paper_height(self, unit: Unit) -> builtins.float: ...

    def get_paper_size(self) -> PaperSize: ...

    def get_paper_width(self, unit: Unit) -> builtins.float: ...

    def get_print_pages(self) -> PrintPages: ...

    def get_printer(self) -> builtins.str: ...

    def get_printer_lpi(self) -> builtins.float: ...

    def get_quality(self) -> PrintQuality: ...

    def get_resolution(self) -> builtins.int: ...

    def get_resolution_x(self) -> builtins.int: ...

    def get_resolution_y(self) -> builtins.int: ...

    def get_reverse(self) -> builtins.bool: ...

    def get_scale(self) -> builtins.float: ...

    def get_use_color(self) -> builtins.bool: ...

    def has_key(self, key: builtins.str) -> builtins.bool: ...

    def load_file(self, file_name: builtins.str) -> builtins.bool: ...

    def load_key_file(self, key_file: GLib.KeyFile, group_name: typing.Optional[builtins.str]) -> builtins.bool: ...

    @staticmethod
    def new(**kwargs) -> PrintSettings: ...  # type: ignore

    @staticmethod
    def new_from_file(file_name: builtins.str) -> PrintSettings: ...

    @staticmethod
    def new_from_gvariant(variant: GLib.Variant) -> PrintSettings: ...

    @staticmethod
    def new_from_key_file(key_file: GLib.KeyFile, group_name: typing.Optional[builtins.str]) -> PrintSettings: ...

    def set(self, key: builtins.str, value: typing.Optional[builtins.str]) -> None: ...

    def set_bool(self, key: builtins.str, value: builtins.bool) -> None: ...

    def set_collate(self, collate: builtins.bool) -> None: ...

    def set_default_source(self, default_source: builtins.str) -> None: ...

    def set_dither(self, dither: builtins.str) -> None: ...

    def set_double(self, key: builtins.str, value: builtins.float) -> None: ...

    def set_duplex(self, duplex: PrintDuplex) -> None: ...

    def set_finishings(self, finishings: builtins.str) -> None: ...

    def set_int(self, key: builtins.str, value: builtins.int) -> None: ...

    def set_length(self, key: builtins.str, value: builtins.float, unit: Unit) -> None: ...

    def set_media_type(self, media_type: builtins.str) -> None: ...

    def set_n_copies(self, num_copies: builtins.int) -> None: ...

    def set_number_up(self, number_up: builtins.int) -> None: ...

    def set_number_up_layout(self, number_up_layout: NumberUpLayout) -> None: ...

    def set_orientation(self, orientation: PageOrientation) -> None: ...

    def set_output_bin(self, output_bin: builtins.str) -> None: ...

    def set_page_ranges(self, page_ranges: typing.Sequence[PageRange]) -> None: ...

    def set_page_set(self, page_set: PageSet) -> None: ...

    def set_paper_height(self, height: builtins.float, unit: Unit) -> None: ...

    def set_paper_size(self, paper_size: PaperSize) -> None: ...

    def set_paper_width(self, width: builtins.float, unit: Unit) -> None: ...

    def set_print_pages(self, pages: PrintPages) -> None: ...

    def set_printer(self, printer: builtins.str) -> None: ...

    def set_printer_lpi(self, lpi: builtins.float) -> None: ...

    def set_quality(self, quality: PrintQuality) -> None: ...

    def set_resolution(self, resolution: builtins.int) -> None: ...

    def set_resolution_xy(self, resolution_x: builtins.int, resolution_y: builtins.int) -> None: ...

    def set_reverse(self, reverse: builtins.bool) -> None: ...

    def set_scale(self, scale: builtins.float) -> None: ...

    def set_use_color(self, use_color: builtins.bool) -> None: ...

    def to_file(self, file_name: builtins.str) -> builtins.bool: ...

    def to_gvariant(self) -> GLib.Variant: ...

    def to_key_file(self, key_file: GLib.KeyFile, group_name: typing.Optional[builtins.str]) -> None: ...

    def unset(self, key: builtins.str) -> None: ...


class RcStyle(GObject.Object):
    base: typing.Sequence[Gdk.Color]
    bg: typing.Sequence[Gdk.Color]
    bg_pixmap_name: typing.Sequence[builtins.str]
    color_flags: typing.Sequence[RcFlags]
    engine_specified: builtins.int
    fg: typing.Sequence[Gdk.Color]
    font_desc: Pango.FontDescription
    icon_factories: typing.Sequence[builtins.object]
    name: builtins.str
    parent_instance: GObject.Object
    rc_properties: typing.Sequence[builtins.object]
    rc_style_lists: typing.Sequence[builtins.object]
    text: typing.Sequence[Gdk.Color]
    xthickness: builtins.int
    ythickness: builtins.int

    def copy(self) -> RcStyle: ...

    @staticmethod
    def new(**kwargs) -> RcStyle: ...  # type: ignore

    def do_merge(self, src: RcStyle) -> None: ...

    def do_parse(self, settings: Settings, scanner: GLib.Scanner) -> builtins.int: ...


class RecentChooser(GObject.GInterface):

    def add_filter(self, filter: RecentFilter) -> None: ...

    def get_current_item(self) -> RecentInfo: ...

    def get_current_uri(self) -> builtins.str: ...

    def get_filter(self) -> RecentFilter: ...

    def get_items(self) -> typing.Sequence[RecentInfo]: ...

    def get_limit(self) -> builtins.int: ...

    def get_local_only(self) -> builtins.bool: ...

    def get_select_multiple(self) -> builtins.bool: ...

    def get_show_icons(self) -> builtins.bool: ...

    def get_show_not_found(self) -> builtins.bool: ...

    def get_show_private(self) -> builtins.bool: ...

    def get_show_tips(self) -> builtins.bool: ...

    def get_sort_type(self) -> RecentSortType: ...

    def get_uris(self) -> typing.Sequence[builtins.str]: ...

    def list_filters(self) -> typing.Sequence[RecentFilter]: ...

    def remove_filter(self, filter: RecentFilter) -> None: ...

    def select_all(self) -> None: ...

    def select_uri(self, uri: builtins.str) -> builtins.bool: ...

    def set_current_uri(self, uri: builtins.str) -> builtins.bool: ...

    def set_filter(self, filter: typing.Optional[RecentFilter]) -> None: ...

    def set_limit(self, limit: builtins.int) -> None: ...

    def set_local_only(self, local_only: builtins.bool) -> None: ...

    def set_select_multiple(self, select_multiple: builtins.bool) -> None: ...

    def set_show_icons(self, show_icons: builtins.bool) -> None: ...

    def set_show_not_found(self, show_not_found: builtins.bool) -> None: ...

    def set_show_private(self, show_private: builtins.bool) -> None: ...

    def set_show_tips(self, show_tips: builtins.bool) -> None: ...

    def set_sort_func(self, sort_func: RecentSortFunc, *sort_data: typing.Optional[builtins.object]) -> None: ...

    def set_sort_type(self, sort_type: RecentSortType) -> None: ...

    def unselect_all(self) -> None: ...

    def unselect_uri(self, uri: builtins.str) -> None: ...

    def do_add_filter(self, filter: RecentFilter) -> None: ...

    def do_get_current_uri(self) -> builtins.str: ...

    def do_get_items(self) -> typing.Sequence[RecentInfo]: ...

    def do_item_activated(self) -> None: ...

    def do_list_filters(self) -> typing.Sequence[RecentFilter]: ...

    def do_remove_filter(self, filter: RecentFilter) -> None: ...

    def do_select_all(self) -> None: ...

    def do_select_uri(self, uri: builtins.str) -> builtins.bool: ...

    def do_selection_changed(self) -> None: ...

    def do_set_current_uri(self, uri: builtins.str) -> builtins.bool: ...

    def do_set_sort_func(self, sort_func: RecentSortFunc, sort_data: typing.Optional[builtins.object]) -> None: ...

    def do_unselect_all(self) -> None: ...

    def do_unselect_uri(self, uri: builtins.str) -> None: ...


class RecentManager(GObject.Object):
    parent_instance: GObject.Object

    def add_full(self, uri: builtins.str, recent_data: RecentData) -> builtins.bool: ...

    def add_item(self, uri: builtins.str) -> builtins.bool: ...

    @staticmethod
    def get_default() -> RecentManager: ...

    def get_items(self) -> typing.Sequence[RecentInfo]: ...

    def has_item(self, uri: builtins.str) -> builtins.bool: ...

    def lookup_item(self, uri: builtins.str) -> typing.Optional[RecentInfo]: ...

    def move_item(self, uri: builtins.str, new_uri: typing.Optional[builtins.str]) -> builtins.bool: ...

    @staticmethod
    def new(**kwargs) -> RecentManager: ...  # type: ignore

    def purge_items(self) -> builtins.int: ...

    def remove_item(self, uri: builtins.str) -> builtins.bool: ...

    def do_changed(self) -> None: ...


class Scrollable(GObject.GInterface):

    def get_border(self) -> typing.Tuple[builtins.bool, Border]: ...

    def get_hadjustment(self) -> Adjustment: ...

    def get_hscroll_policy(self) -> ScrollablePolicy: ...

    def get_vadjustment(self) -> Adjustment: ...

    def get_vscroll_policy(self) -> ScrollablePolicy: ...

    def set_hadjustment(self, hadjustment: typing.Optional[Adjustment]) -> None: ...

    def set_hscroll_policy(self, policy: ScrollablePolicy) -> None: ...

    def set_vadjustment(self, vadjustment: typing.Optional[Adjustment]) -> None: ...

    def set_vscroll_policy(self, policy: ScrollablePolicy) -> None: ...

    def do_get_border(self) -> typing.Tuple[builtins.bool, Border]: ...


class StatusIcon(GObject.Object):
    parent_instance: GObject.Object

    class _Props:
        icon_name: typing.Optional[str]
        tooltip_markup: str
        visible: bool

    props: _Props

    def __init__(self,
        *,
        icon_name: typing.Optional[str] = None,
        tooltip_markup: str = "",
        visible: bool = True,
    ) -> None: ...

    def get_geometry(self) -> typing.Tuple[builtins.bool, Gdk.Screen, Gdk.Rectangle, Orientation]: ...

    def get_gicon(self) -> typing.Optional[Gio.Icon]: ...

    def get_has_tooltip(self) -> builtins.bool: ...

    def get_icon_name(self) -> typing.Optional[builtins.str]: ...

    def get_pixbuf(self) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def get_screen(self) -> Gdk.Screen: ...

    def get_size(self) -> builtins.int: ...

    def get_stock(self) -> typing.Optional[builtins.str]: ...

    def get_storage_type(self) -> ImageType: ...

    def get_title(self) -> builtins.str: ...

    def get_tooltip_markup(self) -> typing.Optional[builtins.str]: ...

    def get_tooltip_text(self) -> typing.Optional[builtins.str]: ...

    def get_visible(self) -> builtins.bool: ...

    def get_x11_window_id(self) -> builtins.int: ...

    def is_embedded(self) -> builtins.bool: ...

    @staticmethod
    def new(**kwargs) -> StatusIcon: ...  # type: ignore

    @staticmethod
    def new_from_file(filename: builtins.str) -> StatusIcon: ...

    @staticmethod
    def new_from_gicon(icon: Gio.Icon) -> StatusIcon: ...

    @staticmethod
    def new_from_icon_name(icon_name: builtins.str) -> StatusIcon: ...

    @staticmethod
    def new_from_pixbuf(pixbuf: GdkPixbuf.Pixbuf) -> StatusIcon: ...

    @staticmethod
    def new_from_stock(stock_id: builtins.str, **kwargs) -> StatusIcon: ...  # type: ignore

    @staticmethod
    def position_menu(menu: Menu, x: builtins.int, y: builtins.int, user_data: StatusIcon) -> typing.Tuple[builtins.int, builtins.int, builtins.bool]: ...

    def set_from_file(self, filename: builtins.str) -> None: ...

    def set_from_gicon(self, icon: Gio.Icon) -> None: ...

    def set_from_icon_name(self, icon_name: builtins.str) -> None: ...

    def set_from_pixbuf(self, pixbuf: typing.Optional[GdkPixbuf.Pixbuf]) -> None: ...

    def set_from_stock(self, stock_id: builtins.str) -> None: ...

    def set_has_tooltip(self, has_tooltip: builtins.bool) -> None: ...

    def set_name(self, name: builtins.str) -> None: ...

    def set_screen(self, screen: Gdk.Screen) -> None: ...

    def set_title(self, title: builtins.str) -> None: ...

    def set_tooltip_markup(self, markup: typing.Optional[builtins.str]) -> None: ...

    def set_tooltip_text(self, text: builtins.str) -> None: ...

    def set_visible(self, visible: builtins.bool) -> None: ...

    def do_activate(self) -> None: ...

    def do_button_press_event(self, event: Gdk.EventButton) -> builtins.bool: ...

    def do_button_release_event(self, event: Gdk.EventButton) -> builtins.bool: ...

    def do_popup_menu(self, button: builtins.int, activate_time: builtins.int) -> None: ...

    def do_query_tooltip(self, x: builtins.int, y: builtins.int, keyboard_mode: builtins.bool, tooltip: Tooltip) -> builtins.bool: ...

    def do_scroll_event(self, event: Gdk.EventScroll) -> builtins.bool: ...

    def do_size_changed(self, size: builtins.int) -> builtins.bool: ...


class Style(GObject.Object):
    attach_count: builtins.int
    background: typing.Sequence[cairo.Pattern]
    base: typing.Sequence[Gdk.Color]
    bg: typing.Sequence[Gdk.Color]
    black: Gdk.Color
    dark: typing.Sequence[Gdk.Color]
    fg: typing.Sequence[Gdk.Color]
    font_desc: Pango.FontDescription
    icon_factories: typing.Sequence[builtins.object]
    light: typing.Sequence[Gdk.Color]
    mid: typing.Sequence[Gdk.Color]
    parent_instance: GObject.Object
    private_font_desc: Pango.FontDescription
    property_cache: typing.Sequence[builtins.object]
    rc_style: RcStyle
    styles: typing.Sequence[builtins.object]
    text: typing.Sequence[Gdk.Color]
    text_aa: typing.Sequence[Gdk.Color]
    visual: Gdk.Visual
    white: Gdk.Color
    xthickness: builtins.int
    ythickness: builtins.int

    def apply_default_background(self, cr: cairo.Context, window: Gdk.Window, state_type: StateType, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def copy(self) -> Style: ...

    def detach(self) -> None: ...

    def get_style_property(self, widget_type: GObject.GType, property_name: builtins.str) -> GObject.Value: ...

    def has_context(self) -> builtins.bool: ...

    def lookup_color(self, color_name: builtins.str) -> typing.Tuple[builtins.bool, Gdk.Color]: ...

    def lookup_icon_set(self, stock_id: builtins.str) -> IconSet: ...

    @staticmethod
    def new(**kwargs) -> Style: ...  # type: ignore

    def render_icon(self, source: IconSource, direction: TextDirection, state: StateType, size: builtins.int, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str]) -> GdkPixbuf.Pixbuf: ...

    def set_background(self, window: Gdk.Window, state_type: StateType) -> None: ...

    def do_copy(self, src: Style) -> None: ...

    def do_draw_arrow(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, arrow_type: ArrowType, fill: builtins.bool, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_box(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_box_gap(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, gap_side: PositionType, gap_x: builtins.int, gap_width: builtins.int) -> None: ...

    def do_draw_check(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_diamond(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_expander(self, cr: cairo.Context, state_type: StateType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, expander_style: ExpanderStyle) -> None: ...

    def do_draw_extension(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, gap_side: PositionType) -> None: ...

    def do_draw_flat_box(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_focus(self, cr: cairo.Context, state_type: StateType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_handle(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, orientation: Orientation) -> None: ...

    def do_draw_hline(self, cr: cairo.Context, state_type: StateType, widget: Widget, detail: builtins.str, x1: builtins.int, x2: builtins.int, y: builtins.int) -> None: ...

    def do_draw_layout(self, cr: cairo.Context, state_type: StateType, use_text: builtins.bool, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, layout: Pango.Layout) -> None: ...

    def do_draw_option(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_resize_grip(self, cr: cairo.Context, state_type: StateType, widget: Widget, detail: builtins.str, edge: Gdk.WindowEdge, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_shadow(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_shadow_gap(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, gap_side: PositionType, gap_x: builtins.int, gap_width: builtins.int) -> None: ...

    def do_draw_slider(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, orientation: Orientation) -> None: ...

    def do_draw_spinner(self, cr: cairo.Context, state_type: StateType, widget: Widget, detail: builtins.str, step: builtins.int, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_tab(self, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: Widget, detail: builtins.str, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_draw_vline(self, cr: cairo.Context, state_type: StateType, widget: Widget, detail: builtins.str, y1_: builtins.int, y2_: builtins.int, x: builtins.int) -> None: ...

    def do_init_from_rc(self, rc_style: RcStyle) -> None: ...

    def do_realize(self) -> None: ...

    def do_render_icon(self, source: IconSource, direction: TextDirection, state: StateType, size: builtins.int, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str]) -> GdkPixbuf.Pixbuf: ...

    def do_set_background(self, window: Gdk.Window, state_type: StateType) -> None: ...

    def do_unrealize(self) -> None: ...


class StyleContext(GObject.Object):
    parent_object: GObject.Object

    def add_class(self, class_name: builtins.str) -> None: ...

    def add_provider(self, provider: StyleProvider, priority: builtins.int) -> None: ...

    @staticmethod
    def add_provider_for_screen(screen: Gdk.Screen, provider: StyleProvider, priority: builtins.int) -> None: ...

    def add_region(self, region_name: builtins.str, flags: RegionFlags) -> None: ...

    def cancel_animations(self, region_id: typing.Optional[builtins.object]) -> None: ...

    def get_background_color(self, state: StateFlags) -> Gdk.RGBA: ...

    def get_border(self, state: StateFlags) -> Border: ...

    def get_border_color(self, state: StateFlags) -> Gdk.RGBA: ...

    def get_color(self, state: StateFlags) -> Gdk.RGBA: ...

    def get_direction(self) -> TextDirection: ...

    def get_font(self, state: StateFlags) -> Pango.FontDescription: ...

    def get_frame_clock(self) -> typing.Optional[Gdk.FrameClock]: ...

    def get_junction_sides(self) -> JunctionSides: ...

    def get_margin(self, state: StateFlags) -> Border: ...

    def get_padding(self, state: StateFlags) -> Border: ...

    def get_parent(self) -> typing.Optional[StyleContext]: ...

    def get_path(self) -> WidgetPath: ...

    def get_property(self, property: builtins.str, state: StateFlags) -> GObject.Value: ...  # type: ignore

    def get_scale(self) -> builtins.int: ...

    def get_screen(self) -> Gdk.Screen: ...

    def get_section(self, property: builtins.str) -> typing.Optional[CssSection]: ...

    def get_state(self) -> StateFlags: ...

    def get_style_property(self, property_name: builtins.str, value: GObject.Value) -> None: ...

    def has_class(self, class_name: builtins.str) -> builtins.bool: ...

    def has_region(self, region_name: builtins.str) -> typing.Tuple[builtins.bool, RegionFlags]: ...

    def invalidate(self) -> None: ...

    def list_classes(self) -> typing.Sequence[builtins.str]: ...

    def list_regions(self) -> typing.Sequence[builtins.str]: ...

    def lookup_color(self, color_name: builtins.str) -> typing.Tuple[builtins.bool, Gdk.RGBA]: ...

    def lookup_icon_set(self, stock_id: builtins.str) -> typing.Optional[IconSet]: ...

    @staticmethod
    def new(**kwargs) -> StyleContext: ...  # type: ignore

    def notify_state_change(self, window: Gdk.Window, region_id: typing.Optional[builtins.object], state: StateType, state_value: builtins.bool) -> None: ...

    def pop_animatable_region(self) -> None: ...

    def push_animatable_region(self, region_id: typing.Optional[builtins.object]) -> None: ...

    def remove_class(self, class_name: builtins.str) -> None: ...

    def remove_provider(self, provider: StyleProvider) -> None: ...

    @staticmethod
    def remove_provider_for_screen(screen: Gdk.Screen, provider: StyleProvider) -> None: ...

    def remove_region(self, region_name: builtins.str) -> None: ...

    @staticmethod
    def reset_widgets(screen: Gdk.Screen) -> None: ...

    def restore(self) -> None: ...

    def save(self) -> None: ...

    def scroll_animations(self, window: Gdk.Window, dx: builtins.int, dy: builtins.int) -> None: ...

    def set_background(self, window: Gdk.Window) -> None: ...

    def set_direction(self, direction: TextDirection) -> None: ...

    def set_frame_clock(self, frame_clock: Gdk.FrameClock) -> None: ...

    def set_junction_sides(self, sides: JunctionSides) -> None: ...

    def set_parent(self, parent: typing.Optional[StyleContext]) -> None: ...

    def set_path(self, path: WidgetPath) -> None: ...

    def set_scale(self, scale: builtins.int) -> None: ...

    def set_screen(self, screen: Gdk.Screen) -> None: ...

    def set_state(self, flags: StateFlags) -> None: ...

    def state_is_running(self, state: StateType) -> typing.Tuple[builtins.bool, builtins.float]: ...

    def to_string(self, flags: StyleContextPrintFlags) -> builtins.str: ...

    def do_changed(self) -> None: ...


class StyleProvider(GObject.GInterface):

    def get_icon_factory(self, path: WidgetPath) -> typing.Optional[IconFactory]: ...

    def get_style(self, path: WidgetPath) -> typing.Optional[StyleProperties]: ...

    def get_style_property(self, path: WidgetPath, state: StateFlags, pspec: GObject.ParamSpec) -> typing.Tuple[builtins.bool, GObject.Value]: ...

    def do_get_icon_factory(self, path: WidgetPath) -> typing.Optional[IconFactory]: ...

    def do_get_style(self, path: WidgetPath) -> typing.Optional[StyleProperties]: ...

    def do_get_style_property(self, path: WidgetPath, state: StateFlags, pspec: GObject.ParamSpec) -> typing.Tuple[builtins.bool, GObject.Value]: ...


class TextBuffer(GObject.Object):
    parent_instance: GObject.Object

    def add_mark(self, mark: TextMark, where: TextIter) -> None: ...

    def add_selection_clipboard(self, clipboard: Clipboard) -> None: ...

    def apply_tag(self, tag: TextTag, start: TextIter, end: TextIter) -> None: ...

    def apply_tag_by_name(self, name: builtins.str, start: TextIter, end: TextIter) -> None: ...

    def backspace(self, iter: TextIter, interactive: builtins.bool, default_editable: builtins.bool) -> builtins.bool: ...

    def begin_user_action(self) -> None: ...

    def copy_clipboard(self, clipboard: Clipboard) -> None: ...

    def create_child_anchor(self, iter: TextIter) -> TextChildAnchor: ...

    def create_mark(self, mark_name: typing.Optional[builtins.str], where: TextIter, left_gravity: builtins.bool) -> TextMark: ...

    def cut_clipboard(self, clipboard: Clipboard, default_editable: builtins.bool) -> None: ...

    def delete(self, start: TextIter, end: TextIter) -> None: ...

    def delete_interactive(self, start_iter: TextIter, end_iter: TextIter, default_editable: builtins.bool) -> builtins.bool: ...

    def delete_mark(self, mark: TextMark) -> None: ...

    def delete_mark_by_name(self, name: builtins.str) -> None: ...

    def delete_selection(self, interactive: builtins.bool, default_editable: builtins.bool) -> builtins.bool: ...

    def deserialize(self, content_buffer: TextBuffer, format: Gdk.Atom, iter: TextIter, data: builtins.bytes) -> builtins.bool: ...

    def deserialize_get_can_create_tags(self, format: Gdk.Atom) -> builtins.bool: ...

    def deserialize_set_can_create_tags(self, format: Gdk.Atom, can_create_tags: builtins.bool) -> None: ...

    def end_user_action(self) -> None: ...

    def get_bounds(self) -> typing.Tuple[TextIter, TextIter]: ...

    def get_char_count(self) -> builtins.int: ...

    def get_copy_target_list(self) -> TargetList: ...

    def get_deserialize_formats(self) -> typing.Sequence[Gdk.Atom]: ...

    def get_end_iter(self) -> TextIter: ...

    def get_has_selection(self) -> builtins.bool: ...

    def get_insert(self) -> TextMark: ...

    def get_iter_at_child_anchor(self, anchor: TextChildAnchor) -> TextIter: ...

    def get_iter_at_line(self, line_number: builtins.int) -> TextIter: ...

    def get_iter_at_line_index(self, line_number: builtins.int, byte_index: builtins.int) -> TextIter: ...

    def get_iter_at_line_offset(self, line_number: builtins.int, char_offset: builtins.int) -> TextIter: ...

    def get_iter_at_mark(self, mark: TextMark) -> TextIter: ...

    def get_iter_at_offset(self, char_offset: builtins.int) -> TextIter: ...

    def get_line_count(self) -> builtins.int: ...

    def get_mark(self, name: builtins.str) -> typing.Optional[TextMark]: ...

    def get_modified(self) -> builtins.bool: ...

    def get_paste_target_list(self) -> TargetList: ...

    def get_selection_bound(self) -> TextMark: ...

    def get_selection_bounds(self) -> typing.Tuple[builtins.bool, TextIter, TextIter]: ...

    def get_serialize_formats(self) -> typing.Sequence[Gdk.Atom]: ...

    def get_slice(self, start: TextIter, end: TextIter, include_hidden_chars: builtins.bool) -> builtins.str: ...

    def get_start_iter(self) -> TextIter: ...

    def get_tag_table(self) -> TextTagTable: ...

    def get_text(self, start: TextIter, end: TextIter, include_hidden_chars: builtins.bool) -> builtins.str: ...

    def insert(self, iter: TextIter, text: builtins.str, len: builtins.int) -> None: ...

    def insert_at_cursor(self, text: builtins.str, len: builtins.int) -> None: ...

    def insert_child_anchor(self, iter: TextIter, anchor: TextChildAnchor) -> None: ...

    def insert_interactive(self, iter: TextIter, text: builtins.str, len: builtins.int, default_editable: builtins.bool) -> builtins.bool: ...

    def insert_interactive_at_cursor(self, text: builtins.str, len: builtins.int, default_editable: builtins.bool) -> builtins.bool: ...

    def insert_markup(self, iter: TextIter, markup: builtins.str, len: builtins.int) -> None: ...

    def insert_pixbuf(self, iter: TextIter, pixbuf: GdkPixbuf.Pixbuf) -> None: ...

    def insert_range(self, iter: TextIter, start: TextIter, end: TextIter) -> None: ...

    def insert_range_interactive(self, iter: TextIter, start: TextIter, end: TextIter, default_editable: builtins.bool) -> builtins.bool: ...

    def move_mark(self, mark: TextMark, where: TextIter) -> None: ...

    def move_mark_by_name(self, name: builtins.str, where: TextIter) -> None: ...

    @staticmethod
    def new(table: typing.Optional[TextTagTable], **kwargs) -> TextBuffer: ...  # type: ignore

    def paste_clipboard(self, clipboard: Clipboard, override_location: typing.Optional[TextIter], default_editable: builtins.bool) -> None: ...

    def place_cursor(self, where: TextIter) -> None: ...

    def register_deserialize_format(self, mime_type: builtins.str, function: TextBufferDeserializeFunc, *user_data: typing.Optional[builtins.object]) -> Gdk.Atom: ...

    def register_deserialize_tagset(self, tagset_name: typing.Optional[builtins.str]) -> Gdk.Atom: ...

    def register_serialize_format(self, mime_type: builtins.str, function: TextBufferSerializeFunc, *user_data: typing.Optional[builtins.object]) -> Gdk.Atom: ...

    def register_serialize_tagset(self, tagset_name: typing.Optional[builtins.str]) -> Gdk.Atom: ...

    def remove_all_tags(self, start: TextIter, end: TextIter) -> None: ...

    def remove_selection_clipboard(self, clipboard: Clipboard) -> None: ...

    def remove_tag(self, tag: TextTag, start: TextIter, end: TextIter) -> None: ...

    def remove_tag_by_name(self, name: builtins.str, start: TextIter, end: TextIter) -> None: ...

    def select_range(self, ins: TextIter, bound: TextIter) -> None: ...

    def serialize(self, content_buffer: TextBuffer, format: Gdk.Atom, start: TextIter, end: TextIter) -> builtins.bytes: ...

    def set_modified(self, setting: builtins.bool) -> None: ...

    def set_text(self, text: builtins.str, len: builtins.int) -> None: ...

    def unregister_deserialize_format(self, format: Gdk.Atom) -> None: ...

    def unregister_serialize_format(self, format: Gdk.Atom) -> None: ...

    def do_apply_tag(self, tag: TextTag, start: TextIter, end: TextIter) -> None: ...

    def do_begin_user_action(self) -> None: ...

    def do_changed(self) -> None: ...

    def do_delete_range(self, start: TextIter, end: TextIter) -> None: ...

    def do_end_user_action(self) -> None: ...

    def do_insert_child_anchor(self, iter: TextIter, anchor: TextChildAnchor) -> None: ...

    def do_insert_pixbuf(self, iter: TextIter, pixbuf: GdkPixbuf.Pixbuf) -> None: ...

    def do_insert_text(self, pos: TextIter, new_text: builtins.str, new_text_length: builtins.int) -> None: ...

    def do_mark_deleted(self, mark: TextMark) -> None: ...

    def do_mark_set(self, location: TextIter, mark: TextMark) -> None: ...

    def do_modified_changed(self) -> None: ...

    def do_paste_done(self, clipboard: Clipboard) -> None: ...

    def do_remove_tag(self, tag: TextTag, start: TextIter, end: TextIter) -> None: ...


class TextChildAnchor(GObject.Object):
    parent_instance: GObject.Object
    segment: builtins.object

    def get_deleted(self) -> builtins.bool: ...

    def get_widgets(self) -> typing.Sequence[Widget]: ...

    @staticmethod
    def new(**kwargs) -> TextChildAnchor: ...  # type: ignore


class TextMark(GObject.Object):
    parent_instance: GObject.Object
    segment: builtins.object

    def get_buffer(self) -> TextBuffer: ...

    def get_deleted(self) -> builtins.bool: ...

    def get_left_gravity(self) -> builtins.bool: ...

    def get_name(self) -> typing.Optional[builtins.str]: ...

    def get_visible(self) -> builtins.bool: ...

    @staticmethod
    def new(name: typing.Optional[builtins.str], left_gravity: builtins.bool, **kwargs) -> TextMark: ...  # type: ignore

    def set_visible(self, setting: builtins.bool) -> None: ...


class TextTag(GObject.Object):
    parent_instance: GObject.Object

    def changed(self, size_changed: builtins.bool) -> None: ...

    def event(self, event_object: GObject.Object, event: Gdk.Event, iter: TextIter) -> builtins.bool: ...

    def get_priority(self) -> builtins.int: ...

    @staticmethod
    def new(name: typing.Optional[builtins.str], **kwargs) -> TextTag: ...  # type: ignore

    def set_priority(self, priority: builtins.int) -> None: ...

    def do_event(self, event_object: GObject.Object, event: Gdk.Event, iter: TextIter) -> builtins.bool: ...


class ThemingEngine(GObject.Object):
    parent_object: GObject.Object

    def get_background_color(self, state: StateFlags) -> Gdk.RGBA: ...

    def get_border(self, state: StateFlags) -> Border: ...

    def get_border_color(self, state: StateFlags) -> Gdk.RGBA: ...

    def get_color(self, state: StateFlags) -> Gdk.RGBA: ...

    def get_direction(self) -> TextDirection: ...

    def get_font(self, state: StateFlags) -> Pango.FontDescription: ...

    def get_junction_sides(self) -> JunctionSides: ...

    def get_margin(self, state: StateFlags) -> Border: ...

    def get_padding(self, state: StateFlags) -> Border: ...

    def get_path(self) -> WidgetPath: ...

    def get_property(self, property: builtins.str, state: StateFlags) -> GObject.Value: ...  # type: ignore

    def get_screen(self) -> typing.Optional[Gdk.Screen]: ...

    def get_state(self) -> StateFlags: ...

    def get_style_property(self, property_name: builtins.str) -> GObject.Value: ...

    def has_class(self, style_class: builtins.str) -> builtins.bool: ...

    def has_region(self, style_region: builtins.str) -> typing.Tuple[builtins.bool, RegionFlags]: ...

    @staticmethod
    def load(name: builtins.str) -> typing.Optional[ThemingEngine]: ...

    def lookup_color(self, color_name: builtins.str) -> typing.Tuple[builtins.bool, Gdk.RGBA]: ...

    def state_is_running(self, state: StateType) -> typing.Tuple[builtins.bool, builtins.float]: ...

    def do_render_activity(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...

    def do_render_arrow(self, cr: cairo.Context, angle: builtins.float, x: builtins.float, y: builtins.float, size: builtins.float) -> None: ...

    def do_render_background(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...

    def do_render_check(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...

    def do_render_expander(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...

    def do_render_extension(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float, gap_side: PositionType) -> None: ...

    def do_render_focus(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...

    def do_render_frame(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...

    def do_render_frame_gap(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float, gap_side: PositionType, xy0_gap: builtins.float, xy1_gap: builtins.float) -> None: ...

    def do_render_handle(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...

    def do_render_icon(self, cr: cairo.Context, pixbuf: GdkPixbuf.Pixbuf, x: builtins.float, y: builtins.float) -> None: ...

    def do_render_icon_surface(self, cr: cairo.Context, surface: cairo.Surface, x: builtins.float, y: builtins.float) -> None: ...

    def do_render_layout(self, cr: cairo.Context, x: builtins.float, y: builtins.float, layout: Pango.Layout) -> None: ...

    def do_render_line(self, cr: cairo.Context, x0: builtins.float, y0: builtins.float, x1: builtins.float, y1: builtins.float) -> None: ...

    def do_render_option(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...

    def do_render_slider(self, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float, orientation: Orientation) -> None: ...


class ToolShell(GObject.GInterface):

    def get_ellipsize_mode(self) -> Pango.EllipsizeMode: ...

    def get_icon_size(self) -> builtins.int: ...

    def get_orientation(self) -> Orientation: ...

    def get_relief_style(self) -> ReliefStyle: ...

    def get_style(self) -> ToolbarStyle: ...

    def get_text_alignment(self) -> builtins.float: ...

    def get_text_orientation(self) -> Orientation: ...

    def get_text_size_group(self) -> SizeGroup: ...

    def rebuild_menu(self) -> None: ...

    def do_get_ellipsize_mode(self) -> Pango.EllipsizeMode: ...

    def do_get_icon_size(self) -> IconSize: ...

    def do_get_orientation(self) -> Orientation: ...

    def do_get_relief_style(self) -> ReliefStyle: ...

    def do_get_style(self) -> ToolbarStyle: ...

    def do_get_text_alignment(self) -> builtins.float: ...

    def do_get_text_orientation(self) -> Orientation: ...

    def do_get_text_size_group(self) -> SizeGroup: ...

    def do_rebuild_menu(self) -> None: ...


class Tooltip(GObject.Object):

    def set_custom(self, custom_widget: typing.Optional[Widget]) -> None: ...

    def set_icon(self, pixbuf: typing.Optional[GdkPixbuf.Pixbuf]) -> None: ...

    def set_icon_from_gicon(self, gicon: typing.Optional[Gio.Icon], size: builtins.int) -> None: ...

    def set_icon_from_icon_name(self, icon_name: typing.Optional[builtins.str], size: builtins.int) -> None: ...

    def set_icon_from_stock(self, stock_id: typing.Optional[builtins.str], size: builtins.int) -> None: ...

    def set_markup(self, markup: typing.Optional[builtins.str]) -> None: ...

    def set_text(self, text: typing.Optional[builtins.str]) -> None: ...

    def set_tip_area(self, rect: Gdk.Rectangle) -> None: ...

    @staticmethod
    def trigger_tooltip_query(display: Gdk.Display) -> None: ...


class ToplevelAccessible(Atk.Object):
    parent: Atk.Object

    def get_children(self) -> typing.Sequence[Window]: ...


class TreeDragDest(GObject.GInterface):

    def drag_data_received(self, dest: TreePath, selection_data: SelectionData) -> builtins.bool: ...

    def row_drop_possible(self, dest_path: TreePath, selection_data: SelectionData) -> builtins.bool: ...

    def do_drag_data_received(self, dest: TreePath, selection_data: SelectionData) -> builtins.bool: ...

    def do_row_drop_possible(self, dest_path: TreePath, selection_data: SelectionData) -> builtins.bool: ...


class TreeDragSource(GObject.GInterface):

    def drag_data_delete(self, path: TreePath) -> builtins.bool: ...

    def drag_data_get(self, path: TreePath, selection_data: SelectionData) -> builtins.bool: ...

    def row_draggable(self, path: TreePath) -> builtins.bool: ...

    def do_drag_data_delete(self, path: TreePath) -> builtins.bool: ...

    def do_drag_data_get(self, path: TreePath, selection_data: SelectionData) -> builtins.bool: ...

    def do_row_draggable(self, path: TreePath) -> builtins.bool: ...


class TreeModel(GObject.GInterface):

    def __len__(self) -> int: ...

    def __iter__(self) -> typing.Iterator[TreeModelRowIter]: ...

    def __getitem__(self, key: typing.Union[TreePath, int, str]) -> TreeModelRow: ...

    def filter_new(self, root: typing.Optional[TreePath] = None) -> TreeModelFilter: ...

    def foreach(self, func: TreeModelForeachFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def get(self, treeiter: TreeIter, *columns: int) -> typing.Tuple[object, ...]: ...

    def get_column_type(self, index_: builtins.int) -> GObject.GType: ...

    def get_flags(self) -> TreeModelFlags: ...

    def get_iter(self, path: typing.Union[TreePath, str, int]) -> typing.Optional[TreeIter]: ...

    def get_iter_first(self) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def get_iter_from_string(self, path_string: builtins.str) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def get_n_columns(self) -> builtins.int: ...

    def get_path(self, iter: TreeIter) -> TreePath: ...

    def get_string_from_iter(self, iter: TreeIter) -> builtins.str: ...

    def get_value(self, iter: TreeIter, column: builtins.int) -> typing.Any: ...

    def iter_children(self, parent: typing.Optional[TreeIter]) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def iter_has_child(self, iter: TreeIter) -> builtins.bool: ...

    def iter_n_children(self, iter: typing.Optional[TreeIter]) -> builtins.int: ...

    def iter_next(self, iter: TreeIter) -> builtins.bool: ...

    def iter_nth_child(self, parent: typing.Optional[TreeIter], n: builtins.int) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def iter_parent(self, child: TreeIter) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def iter_previous(self, iter: TreeIter) -> builtins.bool: ...

    def ref_node(self, iter: TreeIter) -> None: ...

    def row_changed(self, path: TreePath, iter: TreeIter) -> None: ...

    def row_deleted(self, path: TreePath) -> None: ...

    def row_has_child_toggled(self, path: TreePath, iter: TreeIter) -> None: ...

    def row_inserted(self, path: TreePath, iter: TreeIter) -> None: ...

    def rows_reordered(self, path: TreePath, iter: typing.Optional[TreeIter], new_order: typing.Sequence[builtins.int]) -> None: ...

    def unref_node(self, iter: TreeIter) -> None: ...

    def do_get_column_type(self, index_: builtins.int) -> GObject.GType: ...

    def do_get_flags(self) -> TreeModelFlags: ...

    def do_get_iter(self, path: TreePath) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def do_get_n_columns(self) -> builtins.int: ...

    def do_get_path(self, iter: TreeIter) -> TreePath: ...

    def do_get_value(self, iter: TreeIter, column: builtins.int) -> GObject.Value: ...

    def do_iter_children(self, parent: typing.Optional[TreeIter]) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def do_iter_has_child(self, iter: TreeIter) -> builtins.bool: ...

    def do_iter_n_children(self, iter: typing.Optional[TreeIter]) -> builtins.int: ...

    def do_iter_next(self, iter: TreeIter) -> builtins.bool: ...

    def do_iter_nth_child(self, parent: typing.Optional[TreeIter], n: builtins.int) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def do_iter_parent(self, child: TreeIter) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def do_iter_previous(self, iter: TreeIter) -> builtins.bool: ...

    def do_ref_node(self, iter: TreeIter) -> None: ...

    def do_row_changed(self, path: TreePath, iter: TreeIter) -> None: ...

    def do_row_deleted(self, path: TreePath) -> None: ...

    def do_row_has_child_toggled(self, path: TreePath, iter: TreeIter) -> None: ...

    def do_row_inserted(self, path: TreePath, iter: TreeIter) -> None: ...

    def do_unref_node(self, iter: TreeIter) -> None: ...


class TreeSelection(GObject.Object):
    parent: GObject.Object

    def count_selected_rows(self) -> builtins.int: ...

    def get_mode(self) -> SelectionMode: ...

    def get_selected(self) -> typing.Tuple[TreeModelFilter, typing.Optional[TreeIter]]: ...

    def get_selected_rows(self) -> typing.Tuple[TreeModel, typing.Sequence[TreePath]]: ...

    def get_tree_view(self) -> TreeView: ...

    def iter_is_selected(self, iter: TreeIter) -> builtins.bool: ...

    def path_is_selected(self, path: TreePath) -> builtins.bool: ...

    def select_all(self) -> None: ...

    def select_iter(self, iter: TreeIter) -> None: ...

    def select_path(self, path: typing.Union[TreePath, str, int]) -> None: ...

    def select_range(self, start_path: TreePath, end_path: TreePath) -> None: ...

    def selected_foreach(self, func: TreeSelectionForeachFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def set_mode(self, type: SelectionMode) -> None: ...

    def set_select_function(self, func: typing.Optional[TreeSelectionFunc], *data: typing.Optional[builtins.object]) -> None: ...

    def unselect_all(self) -> None: ...

    def unselect_iter(self, iter: TreeIter) -> None: ...

    def unselect_path(self, path: TreePath) -> None: ...

    def unselect_range(self, start_path: TreePath, end_path: TreePath) -> None: ...

    def do_changed(self) -> None: ...


class TreeSortable(GObject.GInterface):

    def get_sort_column_id(self) -> typing.Tuple[builtins.bool, builtins.int, SortType]: ...

    def has_default_sort_func(self) -> builtins.bool: ...

    def set_default_sort_func(self, sort_func: TreeIterCompareFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_sort_column_id(self, sort_column_id: builtins.int, order: SortType) -> None: ...

    def set_sort_func(self, sort_column_id: builtins.int, sort_func: TreeIterCompareFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def sort_column_changed(self) -> None: ...

    def do_get_sort_column_id(self) -> typing.Tuple[builtins.bool, builtins.int, SortType]: ...

    def do_has_default_sort_func(self) -> builtins.bool: ...

    def do_set_default_sort_func(self, sort_func: TreeIterCompareFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_set_sort_column_id(self, sort_column_id: builtins.int, order: SortType) -> None: ...

    def do_set_sort_func(self, sort_column_id: builtins.int, sort_func: TreeIterCompareFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_sort_column_changed(self) -> None: ...


class WindowGroup(GObject.Object):
    parent_instance: GObject.Object

    def add_window(self, window: Window) -> None: ...

    def get_current_device_grab(self, device: Gdk.Device) -> typing.Optional[Widget]: ...

    def get_current_grab(self) -> Widget: ...

    def list_windows(self) -> typing.Sequence[Window]: ...

    @staticmethod
    def new(**kwargs) -> WindowGroup: ...  # type: ignore

    def remove_window(self, window: Window) -> None: ...


class CellAccessible(Accessible, Atk.Action, Atk.Component, Atk.TableCell):  # type: ignore
    parent: Accessible

    def do_update_cache(self, emit_signal: builtins.bool) -> None: ...


class WidgetAccessible(Accessible, Atk.Component):
    parent: Accessible


class Action(GObject.Object, Buildable):
    object: GObject.Object

    def activate(self) -> None: ...

    def block_activate(self) -> None: ...

    def connect_accelerator(self) -> None: ...

    def create_icon(self, icon_size: builtins.int) -> Widget: ...

    def create_menu(self) -> Widget: ...

    def create_menu_item(self) -> Widget: ...

    def create_tool_item(self) -> Widget: ...

    def disconnect_accelerator(self) -> None: ...

    def get_accel_closure(self) -> GObject.Closure: ...

    def get_accel_path(self) -> builtins.str: ...

    def get_always_show_image(self) -> builtins.bool: ...

    def get_gicon(self) -> Gio.Icon: ...

    def get_icon_name(self) -> builtins.str: ...

    def get_is_important(self) -> builtins.bool: ...

    def get_label(self) -> builtins.str: ...

    def get_name(self) -> builtins.str: ...

    def get_proxies(self) -> typing.Sequence[Widget]: ...

    def get_sensitive(self) -> builtins.bool: ...

    def get_short_label(self) -> builtins.str: ...

    def get_stock_id(self) -> builtins.str: ...

    def get_tooltip(self) -> builtins.str: ...

    def get_visible(self) -> builtins.bool: ...

    def get_visible_horizontal(self) -> builtins.bool: ...

    def get_visible_vertical(self) -> builtins.bool: ...

    def is_sensitive(self) -> builtins.bool: ...

    def is_visible(self) -> builtins.bool: ...

    @staticmethod
    def new(name: builtins.str, label: typing.Optional[builtins.str], tooltip: typing.Optional[builtins.str], stock_id: typing.Optional[builtins.str], **kwargs) -> Action: ...  # type: ignore

    def set_accel_group(self, accel_group: typing.Optional[AccelGroup]) -> None: ...

    def set_accel_path(self, accel_path: builtins.str) -> None: ...

    def set_always_show_image(self, always_show: builtins.bool) -> None: ...

    def set_gicon(self, icon: Gio.Icon) -> None: ...

    def set_icon_name(self, icon_name: builtins.str) -> None: ...

    def set_is_important(self, is_important: builtins.bool) -> None: ...

    def set_label(self, label: builtins.str) -> None: ...

    def set_sensitive(self, sensitive: builtins.bool) -> None: ...

    def set_short_label(self, short_label: builtins.str) -> None: ...

    def set_stock_id(self, stock_id: builtins.str) -> None: ...

    def set_tooltip(self, tooltip: builtins.str) -> None: ...

    def set_visible(self, visible: builtins.bool) -> None: ...

    def set_visible_horizontal(self, visible_horizontal: builtins.bool) -> None: ...

    def set_visible_vertical(self, visible_vertical: builtins.bool) -> None: ...

    def unblock_activate(self) -> None: ...

    def do_activate(self) -> None: ...

    def do_connect_proxy(self, proxy: Widget) -> None: ...

    def do_create_menu(self) -> Widget: ...

    def do_create_menu_item(self) -> Widget: ...

    def do_create_tool_item(self) -> Widget: ...

    def do_disconnect_proxy(self, proxy: Widget) -> None: ...


class ActionGroup(GObject.Object, Buildable):
    parent: GObject.Object

    def add_action(self, action: Action) -> None: ...

    def add_action_with_accel(self, action: Action, accelerator: typing.Optional[builtins.str]) -> None: ...

    def get_accel_group(self) -> AccelGroup: ...

    def get_action(self, action_name: builtins.str) -> Action: ...

    def get_name(self) -> builtins.str: ...

    def get_sensitive(self) -> builtins.bool: ...

    def get_visible(self) -> builtins.bool: ...

    def list_actions(self) -> typing.Sequence[Action]: ...

    @staticmethod
    def new(name: builtins.str, **kwargs) -> ActionGroup: ...  # type: ignore

    def remove_action(self, action: Action) -> None: ...

    def set_accel_group(self, accel_group: typing.Optional[AccelGroup]) -> None: ...

    def set_sensitive(self, sensitive: builtins.bool) -> None: ...

    def set_translate_func(self, func: TranslateFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def set_translation_domain(self, domain: typing.Optional[builtins.str]) -> None: ...

    def set_visible(self, visible: builtins.bool) -> None: ...

    def translate_string(self, string: builtins.str) -> builtins.str: ...

    def do_get_action(self, action_name: builtins.str) -> Action: ...


class FileFilter(GObject.InitiallyUnowned, Buildable):

    def add_custom(self, needed: FileFilterFlags, func: FileFilterFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def add_mime_type(self, mime_type: builtins.str) -> None: ...

    def add_pattern(self, pattern: builtins.str) -> None: ...

    def add_pixbuf_formats(self) -> None: ...

    def filter(self, filter_info: FileFilterInfo) -> builtins.bool: ...

    def get_name(self) -> typing.Optional[builtins.str]: ...  # type: ignore

    def get_needed(self) -> FileFilterFlags: ...

    @staticmethod
    def new() -> FileFilter: ...

    @staticmethod
    def new_from_gvariant(variant: GLib.Variant) -> FileFilter: ...

    def set_name(self, name: typing.Optional[builtins.str]) -> None: ...

    def to_gvariant(self) -> GLib.Variant: ...


class IconFactory(GObject.Object, Buildable):
    parent_instance: GObject.Object

    def add(self, stock_id: builtins.str, icon_set: IconSet) -> None: ...

    def add_default(self) -> None: ...

    def lookup(self, stock_id: builtins.str) -> IconSet: ...

    @staticmethod
    def lookup_default(stock_id: builtins.str) -> IconSet: ...

    @staticmethod
    def new(**kwargs) -> IconFactory: ...  # type: ignore

    def remove_default(self) -> None: ...


class RecentFilter(GObject.InitiallyUnowned, Buildable):

    def add_age(self, days: builtins.int) -> None: ...

    def add_application(self, application: builtins.str) -> None: ...

    def add_custom(self, needed: RecentFilterFlags, func: RecentFilterFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def add_group(self, group: builtins.str) -> None: ...

    def add_mime_type(self, mime_type: builtins.str) -> None: ...

    def add_pattern(self, pattern: builtins.str) -> None: ...

    def add_pixbuf_formats(self) -> None: ...

    def filter(self, filter_info: RecentFilterInfo) -> builtins.bool: ...

    def get_name(self) -> typing.Optional[builtins.str]: ...  # type: ignore

    def get_needed(self) -> RecentFilterFlags: ...

    @staticmethod
    def new() -> RecentFilter: ...

    def set_name(self, name: builtins.str) -> None: ...


class SizeGroup(GObject.Object, Buildable):
    parent_instance: GObject.Object

    def add_widget(self, widget: Widget) -> None: ...

    def get_ignore_hidden(self) -> builtins.bool: ...

    def get_mode(self) -> SizeGroupMode: ...

    def get_widgets(self) -> typing.Sequence[Widget]: ...

    @staticmethod
    def new(mode: SizeGroupMode, **kwargs) -> SizeGroup: ...  # type: ignore

    def remove_widget(self, widget: Widget) -> None: ...

    def set_ignore_hidden(self, ignore_hidden: builtins.bool) -> None: ...

    def set_mode(self, mode: SizeGroupMode) -> None: ...


class TextTagTable(GObject.Object, Buildable):
    parent_instance: GObject.Object

    def add(self, tag: TextTag) -> builtins.bool: ...

    def foreach(self, func: TextTagTableForeach, *data: typing.Optional[builtins.object]) -> None: ...

    def get_size(self) -> builtins.int: ...

    def lookup(self, name: builtins.str) -> typing.Optional[TextTag]: ...

    @staticmethod
    def new(**kwargs) -> TextTagTable: ...  # type: ignore

    def remove(self, tag: TextTag) -> None: ...

    def do_tag_added(self, tag: TextTag) -> None: ...

    def do_tag_changed(self, tag: TextTag, size_changed: builtins.bool) -> None: ...

    def do_tag_removed(self, tag: TextTag) -> None: ...


class UIManager(GObject.Object, Buildable):
    parent: GObject.Object

    def add_ui(self, merge_id: builtins.int, path: builtins.str, name: builtins.str, action: typing.Optional[builtins.str], type: UIManagerItemType, top: builtins.bool) -> None: ...

    def add_ui_from_file(self, filename: builtins.str) -> builtins.int: ...

    def add_ui_from_resource(self, resource_path: builtins.str) -> builtins.int: ...

    def add_ui_from_string(self, buffer: builtins.str, length: builtins.int) -> builtins.int: ...

    def ensure_update(self) -> None: ...

    def get_accel_group(self) -> AccelGroup: ...

    def get_action(self, path: builtins.str) -> Action: ...

    def get_action_groups(self) -> typing.Sequence[ActionGroup]: ...

    def get_add_tearoffs(self) -> builtins.bool: ...

    def get_toplevels(self, types: UIManagerItemType) -> typing.Sequence[Widget]: ...

    def get_ui(self) -> builtins.str: ...

    def get_widget(self, path: builtins.str) -> Widget: ...

    def insert_action_group(self, action_group: ActionGroup, pos: builtins.int) -> None: ...

    @staticmethod
    def new(**kwargs) -> UIManager: ...  # type: ignore

    def new_merge_id(self) -> builtins.int: ...

    def remove_action_group(self, action_group: ActionGroup) -> None: ...

    def remove_ui(self, merge_id: builtins.int) -> None: ...

    def set_add_tearoffs(self, add_tearoffs: builtins.bool) -> None: ...

    def do_actions_changed(self) -> None: ...

    def do_add_widget(self, widget: Widget) -> None: ...

    def do_connect_proxy(self, action: Action, proxy: Widget) -> None: ...

    def do_disconnect_proxy(self, action: Action, proxy: Widget) -> None: ...

    def do_get_action(self, path: builtins.str) -> Action: ...

    def do_get_widget(self, path: builtins.str) -> Widget: ...

    def do_post_activate(self, action: Action) -> None: ...

    def do_pre_activate(self, action: Action) -> None: ...


class Widget(GObject.InitiallyUnowned, Atk.ImplementorIface, Buildable):
    parent_instance: GObject.InitiallyUnowned

    class _Props:
        halign: Align
        has_tooltip: bool
        height_request: int
        hexpand: bool
        margin: int
        margin_left: int
        name: typing.Optional[str]
        opacity: float
        parent: typing.Optional[Container]
        receives_default: bool
        sensitive: bool
        tooltip_text: typing.Optional[str]
        valign: Align
        vexpand: bool
        visible: bool
        width_request: int

    props: _Props

    def __init__(self,
        *,
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def activate(self) -> builtins.bool: ...

    def add_accelerator(self, accel_signal: builtins.str, accel_group: AccelGroup, accel_key: builtins.int, accel_mods: Gdk.ModifierType, accel_flags: AccelFlags) -> None: ...

    def add_device_events(self, device: Gdk.Device, events: Gdk.EventMask) -> None: ...

    def add_events(self, events: builtins.int) -> None: ...

    def add_mnemonic_label(self, label: Widget) -> None: ...

    def add_tick_callback(self, callback: TickCallback, *user_data: typing.Optional[builtins.object]) -> builtins.int: ...

    def can_activate_accel(self, signal_id: builtins.int) -> builtins.bool: ...

    def child_focus(self, direction: DirectionType) -> builtins.bool: ...

    def child_notify(self, child_property: builtins.str) -> None: ...

    def class_path(self) -> typing.Tuple[builtins.int, builtins.str, builtins.str]: ...

    def compute_expand(self, orientation: Orientation) -> builtins.bool: ...

    def create_pango_context(self) -> Pango.Context: ...

    def create_pango_layout(self, text: typing.Optional[builtins.str]) -> Pango.Layout: ...

    def destroy(self) -> None: ...

    def destroyed(self, widget_pointer: Widget) -> Widget: ...

    def device_is_shadowed(self, device: Gdk.Device) -> builtins.bool: ...

    def drag_begin(self, targets: TargetList, actions: Gdk.DragAction, button: builtins.int, event: typing.Optional[Gdk.Event]) -> Gdk.DragContext: ...

    def drag_begin_with_coordinates(self, targets: TargetList, actions: Gdk.DragAction, button: builtins.int, event: typing.Optional[Gdk.Event], x: builtins.int, y: builtins.int) -> Gdk.DragContext: ...

    def drag_check_threshold(self, start_x: builtins.int, start_y: builtins.int, current_x: builtins.int, current_y: builtins.int) -> builtins.bool: ...

    def drag_dest_add_image_targets(self) -> None: ...

    def drag_dest_add_text_targets(self) -> None: ...

    def drag_dest_add_uri_targets(self) -> None: ...

    def drag_dest_find_target(self, context: Gdk.DragContext, target_list: typing.Optional[TargetList]) -> Gdk.Atom: ...

    def drag_dest_get_target_list(self) -> typing.Optional[TargetList]: ...

    def drag_dest_get_track_motion(self) -> builtins.bool: ...

    def drag_dest_set(self, flags: DestDefaults, targets: typing.Optional[typing.Sequence[TargetEntry]], actions: Gdk.DragAction) -> None: ...

    def drag_dest_set_proxy(self, proxy_window: Gdk.Window, protocol: Gdk.DragProtocol, use_coordinates: builtins.bool) -> None: ...

    def drag_dest_set_target_list(self, target_list: typing.Optional[TargetList]) -> None: ...

    def drag_dest_set_track_motion(self, track_motion: builtins.bool) -> None: ...

    def drag_dest_unset(self) -> None: ...

    def drag_get_data(self, context: Gdk.DragContext, target: Gdk.Atom, time_: builtins.int) -> None: ...

    def drag_highlight(self) -> None: ...

    def drag_source_add_image_targets(self) -> None: ...

    def drag_source_add_text_targets(self) -> None: ...

    def drag_source_add_uri_targets(self) -> None: ...

    def drag_source_get_target_list(self) -> typing.Optional[TargetList]: ...

    def drag_source_set(self, start_button_mask: Gdk.ModifierType, targets: typing.Optional[typing.Sequence[TargetEntry]], actions: Gdk.DragAction) -> None: ...

    def drag_source_set_icon_gicon(self, icon: Gio.Icon) -> None: ...

    def drag_source_set_icon_name(self, icon_name: builtins.str) -> None: ...

    def drag_source_set_icon_pixbuf(self, pixbuf: GdkPixbuf.Pixbuf) -> None: ...

    def drag_source_set_icon_stock(self, stock_id: builtins.str) -> None: ...

    def drag_source_set_target_list(self, target_list: typing.Optional[TargetList]) -> None: ...

    def drag_source_unset(self) -> None: ...

    def drag_unhighlight(self) -> None: ...

    def draw(self, cr: cairo.Context) -> None: ...

    def ensure_style(self) -> None: ...

    def error_bell(self) -> None: ...

    def event(self, event: Gdk.Event) -> builtins.bool: ...

    def freeze_child_notify(self) -> None: ...

    def get_accessible(self) -> Atk.Object: ...

    def get_action_group(self, prefix: builtins.str) -> typing.Optional[Gio.ActionGroup]: ...

    def get_allocated_baseline(self) -> builtins.int: ...

    def get_allocated_height(self) -> builtins.int: ...

    def get_allocated_size(self) -> typing.Tuple[Gdk.Rectangle, builtins.int]: ...

    def get_allocated_width(self) -> builtins.int: ...

    def get_allocation(self) -> Gdk.Rectangle: ...

    def get_ancestor(self, widget_type: GObject.GType) -> typing.Optional[Widget]: ...

    def get_app_paintable(self) -> builtins.bool: ...

    def get_can_default(self) -> builtins.bool: ...

    def get_can_focus(self) -> builtins.bool: ...

    def get_child_requisition(self) -> Requisition: ...

    def get_child_visible(self) -> builtins.bool: ...

    def get_clip(self) -> Gdk.Rectangle: ...

    def get_clipboard(self, selection: Gdk.Atom) -> Clipboard: ...

    def get_composite_name(self) -> builtins.str: ...

    @staticmethod
    def get_default_direction() -> TextDirection: ...

    @staticmethod
    def get_default_style() -> Style: ...

    def get_device_enabled(self, device: Gdk.Device) -> builtins.bool: ...

    def get_device_events(self, device: Gdk.Device) -> Gdk.EventMask: ...

    def get_direction(self) -> TextDirection: ...

    def get_display(self) -> Gdk.Display: ...

    def get_double_buffered(self) -> builtins.bool: ...

    def get_events(self) -> builtins.int: ...

    def get_focus_on_click(self) -> builtins.bool: ...

    def get_font_map(self) -> typing.Optional[Pango.FontMap]: ...

    def get_font_options(self) -> typing.Optional[cairo.FontOptions]: ...

    def get_frame_clock(self) -> typing.Optional[Gdk.FrameClock]: ...

    def get_halign(self) -> Align: ...

    def get_has_tooltip(self) -> builtins.bool: ...

    def get_has_window(self) -> builtins.bool: ...

    def get_hexpand(self) -> builtins.bool: ...

    def get_hexpand_set(self) -> builtins.bool: ...

    def get_mapped(self) -> builtins.bool: ...

    def get_margin_bottom(self) -> builtins.int: ...

    def get_margin_end(self) -> builtins.int: ...

    def get_margin_left(self) -> builtins.int: ...

    def get_margin_right(self) -> builtins.int: ...

    def get_margin_start(self) -> builtins.int: ...

    def get_margin_top(self) -> builtins.int: ...

    def get_modifier_mask(self, intent: Gdk.ModifierIntent) -> Gdk.ModifierType: ...

    def get_modifier_style(self) -> RcStyle: ...

    def get_name(self) -> builtins.str: ...

    def get_no_show_all(self) -> builtins.bool: ...

    def get_opacity(self) -> builtins.float: ...

    def get_pango_context(self) -> Pango.Context: ...

    def get_parent(self) -> typing.Optional[Widget]: ...

    def get_parent_window(self) -> typing.Optional[Gdk.Window]: ...

    def get_path(self) -> WidgetPath: ...

    def get_pointer(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_height(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_height_and_baseline_for_width(self, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int, builtins.int, builtins.int]: ...

    def get_preferred_height_for_width(self, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_size(self) -> typing.Tuple[Requisition, Requisition]: ...

    def get_preferred_width(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_width_for_height(self, height: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_realized(self) -> builtins.bool: ...

    def get_receives_default(self) -> builtins.bool: ...

    def get_request_mode(self) -> SizeRequestMode: ...

    def get_requisition(self) -> Requisition: ...

    def get_root_window(self) -> Gdk.Window: ...

    def get_scale_factor(self) -> builtins.int: ...

    def get_screen(self) -> Gdk.Screen: ...

    def get_sensitive(self) -> builtins.bool: ...

    def get_settings(self) -> Settings: ...

    def get_size_request(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_state(self) -> StateType: ...

    def get_state_flags(self) -> StateFlags: ...

    def get_style(self) -> Style: ...

    def get_style_context(self) -> StyleContext: ...

    def get_support_multidevice(self) -> builtins.bool: ...

    def get_template_child(self, widget_type: GObject.GType, name: builtins.str) -> GObject.Object: ...

    def get_tooltip_markup(self) -> typing.Optional[builtins.str]: ...

    def get_tooltip_text(self) -> typing.Optional[builtins.str]: ...

    def get_tooltip_window(self) -> Window: ...

    def get_toplevel(self) -> Widget: ...

    def get_valign(self) -> Align: ...

    def get_valign_with_baseline(self) -> Align: ...

    def get_vexpand(self) -> builtins.bool: ...

    def get_vexpand_set(self) -> builtins.bool: ...

    def get_visible(self) -> builtins.bool: ...

    def get_visual(self) -> Gdk.Visual: ...

    def get_window(self) -> typing.Optional[Gdk.Window]: ...

    def grab_add(self) -> None: ...

    def grab_default(self) -> None: ...

    def grab_focus(self) -> None: ...

    def grab_remove(self) -> None: ...

    def has_default(self) -> builtins.bool: ...

    def has_focus(self) -> builtins.bool: ...

    def has_grab(self) -> builtins.bool: ...

    def has_rc_style(self) -> builtins.bool: ...

    def has_screen(self) -> builtins.bool: ...

    def has_visible_focus(self) -> builtins.bool: ...

    def hide(self) -> None: ...

    def hide_on_delete(self) -> builtins.bool: ...

    def in_destruction(self) -> builtins.bool: ...

    def init_template(self) -> None: ...

    def input_shape_combine_region(self, region: typing.Optional[cairo.Region]) -> None: ...

    def insert_action_group(self, name: builtins.str, group: typing.Optional[Gio.ActionGroup]) -> None: ...

    def intersect(self, area: Gdk.Rectangle) -> typing.Tuple[builtins.bool, Gdk.Rectangle]: ...

    def is_ancestor(self, ancestor: Widget) -> builtins.bool: ...

    def is_composited(self) -> builtins.bool: ...

    def is_drawable(self) -> builtins.bool: ...

    def is_focus(self) -> builtins.bool: ...

    def is_sensitive(self) -> builtins.bool: ...

    def is_toplevel(self) -> builtins.bool: ...

    def is_visible(self) -> builtins.bool: ...

    def keynav_failed(self, direction: DirectionType) -> builtins.bool: ...

    def list_accel_closures(self) -> typing.Sequence[GObject.Closure]: ...

    def list_action_prefixes(self) -> typing.Sequence[builtins.str]: ...

    def list_mnemonic_labels(self) -> typing.Sequence[Widget]: ...

    def map(self) -> None: ...

    def mnemonic_activate(self, group_cycling: builtins.bool) -> builtins.bool: ...

    def modify_base(self, state: StateType, color: typing.Optional[Gdk.Color]) -> None: ...

    def modify_bg(self, state: StateType, color: typing.Optional[Gdk.Color]) -> None: ...

    def modify_cursor(self, primary: typing.Optional[Gdk.Color], secondary: typing.Optional[Gdk.Color]) -> None: ...

    def modify_fg(self, state: StateType, color: typing.Optional[Gdk.Color]) -> None: ...

    def modify_font(self, font_desc: typing.Optional[Pango.FontDescription]) -> None: ...

    def modify_style(self, style: RcStyle) -> None: ...

    def modify_text(self, state: StateType, color: typing.Optional[Gdk.Color]) -> None: ...

    def override_background_color(self, state: StateFlags, color: typing.Optional[Gdk.RGBA]) -> None: ...

    def override_color(self, state: StateFlags, color: typing.Optional[Gdk.RGBA]) -> None: ...

    def override_cursor(self, cursor: typing.Optional[Gdk.RGBA], secondary_cursor: typing.Optional[Gdk.RGBA]) -> None: ...

    def override_font(self, font_desc: typing.Optional[Pango.FontDescription]) -> None: ...

    def override_symbolic_color(self, name: builtins.str, color: typing.Optional[Gdk.RGBA]) -> None: ...

    def path(self) -> typing.Tuple[builtins.int, builtins.str, builtins.str]: ...

    @staticmethod
    def pop_composite_child() -> None: ...

    @staticmethod
    def push_composite_child() -> None: ...

    def queue_allocate(self) -> None: ...

    def queue_compute_expand(self) -> None: ...

    def queue_draw(self) -> None: ...

    def queue_draw_area(self, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def queue_draw_region(self, region: cairo.Region) -> None: ...

    def queue_resize(self) -> None: ...

    def queue_resize_no_redraw(self) -> None: ...

    def realize(self) -> None: ...

    def region_intersect(self, region: cairo.Region) -> cairo.Region: ...

    def register_window(self, window: Gdk.Window) -> None: ...

    def remove_accelerator(self, accel_group: AccelGroup, accel_key: builtins.int, accel_mods: Gdk.ModifierType) -> builtins.bool: ...

    def remove_mnemonic_label(self, label: Widget) -> None: ...

    def remove_tick_callback(self, id: builtins.int) -> None: ...

    def render_icon(self, stock_id: builtins.str, size: builtins.int, detail: typing.Optional[builtins.str]) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def render_icon_pixbuf(self, stock_id: builtins.str, size: builtins.int) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def reparent(self, new_parent: Widget) -> None: ...

    def reset_rc_styles(self) -> None: ...

    def reset_style(self) -> None: ...

    def send_expose(self, event: Gdk.Event) -> builtins.int: ...

    def send_focus_change(self, event: Gdk.Event) -> builtins.bool: ...

    def set_accel_path(self, accel_path: typing.Optional[builtins.str], accel_group: typing.Optional[AccelGroup]) -> None: ...

    def set_allocation(self, allocation: Gdk.Rectangle) -> None: ...

    def set_app_paintable(self, app_paintable: builtins.bool) -> None: ...

    def set_can_default(self, can_default: builtins.bool) -> None: ...

    def set_can_focus(self, can_focus: builtins.bool) -> None: ...

    def set_child_visible(self, is_visible: builtins.bool) -> None: ...

    def set_clip(self, clip: Gdk.Rectangle) -> None: ...

    def set_composite_name(self, name: builtins.str) -> None: ...

    @staticmethod
    def set_default_direction(dir: TextDirection) -> None: ...

    def set_device_enabled(self, device: Gdk.Device, enabled: builtins.bool) -> None: ...

    def set_device_events(self, device: Gdk.Device, events: Gdk.EventMask) -> None: ...

    def set_direction(self, dir: TextDirection) -> None: ...

    def set_double_buffered(self, double_buffered: builtins.bool) -> None: ...

    def set_events(self, events: builtins.int) -> None: ...

    def set_focus_on_click(self, focus_on_click: builtins.bool) -> None: ...

    def set_font_map(self, font_map: typing.Optional[Pango.FontMap]) -> None: ...

    def set_font_options(self, options: typing.Optional[cairo.FontOptions]) -> None: ...

    def set_halign(self, align: Align) -> None: ...

    def set_has_tooltip(self, has_tooltip: builtins.bool) -> None: ...

    def set_has_window(self, has_window: builtins.bool) -> None: ...

    def set_hexpand(self, expand: builtins.bool) -> None: ...

    def set_hexpand_set(self, set: builtins.bool) -> None: ...

    def set_mapped(self, mapped: builtins.bool) -> None: ...

    def set_margin_bottom(self, margin: builtins.int) -> None: ...

    def set_margin_end(self, margin: builtins.int) -> None: ...

    def set_margin_left(self, margin: builtins.int) -> None: ...

    def set_margin_right(self, margin: builtins.int) -> None: ...

    def set_margin_start(self, margin: builtins.int) -> None: ...

    def set_margin_top(self, margin: builtins.int) -> None: ...

    def set_name(self, name: builtins.str) -> None: ...

    def set_no_show_all(self, no_show_all: builtins.bool) -> None: ...

    def set_opacity(self, opacity: builtins.float) -> None: ...

    def set_parent(self, parent: Widget) -> None: ...

    def set_parent_window(self, parent_window: Gdk.Window) -> None: ...

    def set_realized(self, realized: builtins.bool) -> None: ...

    def set_receives_default(self, receives_default: builtins.bool) -> None: ...

    def set_redraw_on_allocate(self, redraw_on_allocate: builtins.bool) -> None: ...

    def set_sensitive(self, sensitive: builtins.bool) -> None: ...

    def set_size_request(self, width: builtins.int, height: builtins.int) -> None: ...

    def set_state(self, state: StateType) -> None: ...

    def set_state_flags(self, flags: StateFlags, clear: builtins.bool) -> None: ...

    def set_style(self, style: typing.Optional[Style]) -> None: ...

    def set_support_multidevice(self, support_multidevice: builtins.bool) -> None: ...

    def set_tooltip_markup(self, markup: typing.Optional[builtins.str]) -> None: ...

    def set_tooltip_text(self, text: typing.Optional[builtins.str]) -> None: ...

    def set_tooltip_window(self, custom_window: typing.Optional[Window]) -> None: ...

    def set_valign(self, align: Align) -> None: ...

    def set_vexpand(self, expand: builtins.bool) -> None: ...

    def set_vexpand_set(self, set: builtins.bool) -> None: ...

    def set_visible(self, visible: builtins.bool) -> None: ...

    def set_visual(self, visual: typing.Optional[Gdk.Visual]) -> None: ...

    def set_window(self, window: Gdk.Window) -> None: ...

    def shape_combine_region(self, region: typing.Optional[cairo.Region]) -> None: ...

    def show(self) -> None: ...

    def show_all(self) -> None: ...

    def show_now(self) -> None: ...

    def size_allocate(self, allocation: Gdk.Rectangle) -> None: ...

    def size_allocate_with_baseline(self, allocation: Gdk.Rectangle, baseline: builtins.int) -> None: ...

    def size_request(self) -> Requisition: ...

    def style_attach(self) -> None: ...

    def style_get_property(self, property_name: builtins.str, value: GObject.Value) -> None: ...

    def thaw_child_notify(self) -> None: ...

    def translate_coordinates(self, dest_widget: Widget, src_x: builtins.int, src_y: builtins.int) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...

    def trigger_tooltip_query(self) -> None: ...

    def unmap(self) -> None: ...

    def unparent(self) -> None: ...

    def unrealize(self) -> None: ...

    def unregister_window(self, window: Gdk.Window) -> None: ...

    def unset_state_flags(self, flags: StateFlags) -> None: ...

    @staticmethod
    def bind_template_callback_full(callback_name: builtins.str, callback_symbol: GObject.Callback) -> None: ...

    @staticmethod
    def bind_template_child_full(name: builtins.str, internal_child: builtins.bool, struct_offset: builtins.int) -> None: ...

    @staticmethod
    def find_style_property(property_name: builtins.str) -> GObject.ParamSpec: ...

    @staticmethod
    def get_css_name() -> builtins.str: ...

    @staticmethod
    def install_style_property(pspec: GObject.ParamSpec) -> None: ...

    @staticmethod
    def list_style_properties() -> typing.Sequence[GObject.ParamSpec]: ...

    @staticmethod
    def set_accessible_role(role: Atk.Role) -> None: ...

    @staticmethod
    def set_accessible_type(type: GObject.GType) -> None: ...

    @staticmethod
    def set_connect_func(connect_func: BuilderConnectFunc, *connect_data: typing.Optional[builtins.object]) -> None: ...

    @staticmethod
    def set_css_name(name: builtins.str) -> None: ...

    @staticmethod
    def set_template(template_bytes: GLib.Bytes) -> None: ...

    @staticmethod
    def set_template_from_resource(resource_name: builtins.str) -> None: ...

    def do_adjust_baseline_allocation(self, baseline: builtins.int) -> None: ...

    def do_adjust_baseline_request(self, minimum_baseline: builtins.int, natural_baseline: builtins.int) -> None: ...

    def do_adjust_size_allocation(self, orientation: Orientation, minimum_size: builtins.int, natural_size: builtins.int, allocated_pos: builtins.int, allocated_size: builtins.int) -> None: ...

    def do_adjust_size_request(self, orientation: Orientation, minimum_size: builtins.int, natural_size: builtins.int) -> None: ...

    def do_button_press_event(self, event: Gdk.EventButton) -> builtins.bool: ...

    def do_button_release_event(self, event: Gdk.EventButton) -> builtins.bool: ...

    def do_can_activate_accel(self, signal_id: builtins.int) -> builtins.bool: ...

    def do_child_notify(self, child_property: GObject.ParamSpec) -> None: ...

    def do_composited_changed(self) -> None: ...

    def do_compute_expand(self, hexpand_p: builtins.bool, vexpand_p: builtins.bool) -> None: ...

    def do_configure_event(self, event: Gdk.EventConfigure) -> builtins.bool: ...

    def do_damage_event(self, event: Gdk.EventExpose) -> builtins.bool: ...

    def do_delete_event(self, event: Gdk.EventAny) -> builtins.bool: ...

    def do_destroy(self) -> None: ...

    def do_destroy_event(self, event: Gdk.EventAny) -> builtins.bool: ...

    def do_direction_changed(self, previous_direction: TextDirection) -> None: ...

    def do_dispatch_child_properties_changed(self, n_pspecs: builtins.int, pspecs: GObject.ParamSpec) -> None: ...

    def do_drag_begin(self, context: Gdk.DragContext) -> None: ...

    def do_drag_data_delete(self, context: Gdk.DragContext) -> None: ...

    def do_drag_data_get(self, context: Gdk.DragContext, selection_data: SelectionData, info: builtins.int, time_: builtins.int) -> None: ...

    def do_drag_data_received(self, context: Gdk.DragContext, x: builtins.int, y: builtins.int, selection_data: SelectionData, info: builtins.int, time_: builtins.int) -> None: ...

    def do_drag_drop(self, context: Gdk.DragContext, x: builtins.int, y: builtins.int, time_: builtins.int) -> builtins.bool: ...

    def do_drag_end(self, context: Gdk.DragContext) -> None: ...

    def do_drag_failed(self, context: Gdk.DragContext, result: DragResult) -> builtins.bool: ...

    def do_drag_leave(self, context: Gdk.DragContext, time_: builtins.int) -> None: ...

    def do_drag_motion(self, context: Gdk.DragContext, x: builtins.int, y: builtins.int, time_: builtins.int) -> builtins.bool: ...

    def do_draw(self, cr: cairo.Context) -> builtins.bool: ...

    def do_enter_notify_event(self, event: Gdk.EventCrossing) -> builtins.bool: ...

    def do_event(self, event: Gdk.Event) -> builtins.bool: ...

    def do_focus(self, direction: DirectionType) -> builtins.bool: ...

    def do_focus_in_event(self, event: Gdk.EventFocus) -> builtins.bool: ...

    def do_focus_out_event(self, event: Gdk.EventFocus) -> builtins.bool: ...

    def do_get_accessible(self) -> Atk.Object: ...

    def do_get_preferred_height(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_height_and_baseline_for_width(self, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int, builtins.int, builtins.int]: ...

    def do_get_preferred_height_for_width(self, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_width(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_width_for_height(self, height: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_request_mode(self) -> SizeRequestMode: ...

    def do_grab_broken_event(self, event: Gdk.EventGrabBroken) -> builtins.bool: ...

    def do_grab_focus(self) -> None: ...

    def do_grab_notify(self, was_grabbed: builtins.bool) -> None: ...

    def do_hide(self) -> None: ...

    def do_hierarchy_changed(self, previous_toplevel: Widget) -> None: ...

    def do_key_press_event(self, event: Gdk.EventKey) -> builtins.bool: ...

    def do_key_release_event(self, event: Gdk.EventKey) -> builtins.bool: ...

    def do_keynav_failed(self, direction: DirectionType) -> builtins.bool: ...

    def do_leave_notify_event(self, event: Gdk.EventCrossing) -> builtins.bool: ...

    def do_map(self) -> None: ...

    def do_map_event(self, event: Gdk.EventAny) -> builtins.bool: ...

    def do_mnemonic_activate(self, group_cycling: builtins.bool) -> builtins.bool: ...

    def do_motion_notify_event(self, event: Gdk.EventMotion) -> builtins.bool: ...

    def do_move_focus(self, direction: DirectionType) -> None: ...

    def do_parent_set(self, previous_parent: Widget) -> None: ...

    def do_popup_menu(self) -> builtins.bool: ...

    def do_property_notify_event(self, event: Gdk.EventProperty) -> builtins.bool: ...

    def do_proximity_in_event(self, event: Gdk.EventProximity) -> builtins.bool: ...

    def do_proximity_out_event(self, event: Gdk.EventProximity) -> builtins.bool: ...

    def do_query_tooltip(self, x: builtins.int, y: builtins.int, keyboard_tooltip: builtins.bool, tooltip: Tooltip) -> builtins.bool: ...

    def do_queue_draw_region(self, region: cairo.Region) -> None: ...

    def do_realize(self) -> None: ...

    def do_screen_changed(self, previous_screen: Gdk.Screen) -> None: ...

    def do_scroll_event(self, event: Gdk.EventScroll) -> builtins.bool: ...

    def do_selection_clear_event(self, event: Gdk.EventSelection) -> builtins.bool: ...

    def do_selection_get(self, selection_data: SelectionData, info: builtins.int, time_: builtins.int) -> None: ...

    def do_selection_notify_event(self, event: Gdk.EventSelection) -> builtins.bool: ...

    def do_selection_received(self, selection_data: SelectionData, time_: builtins.int) -> None: ...

    def do_selection_request_event(self, event: Gdk.EventSelection) -> builtins.bool: ...

    def do_show(self) -> None: ...

    def do_show_all(self) -> None: ...

    def do_show_help(self, help_type: WidgetHelpType) -> builtins.bool: ...

    def do_size_allocate(self, allocation: Gdk.Rectangle) -> None: ...

    def do_state_changed(self, previous_state: StateType) -> None: ...

    def do_state_flags_changed(self, previous_state_flags: StateFlags) -> None: ...

    def do_style_set(self, previous_style: Style) -> None: ...

    def do_style_updated(self) -> None: ...

    def do_touch_event(self, event: Gdk.EventTouch) -> builtins.bool: ...

    def do_unmap(self) -> None: ...

    def do_unmap_event(self, event: Gdk.EventAny) -> builtins.bool: ...

    def do_unrealize(self) -> None: ...

    def do_visibility_notify_event(self, event: Gdk.EventVisibility) -> builtins.bool: ...

    def do_window_state_event(self, event: Gdk.EventWindowState) -> builtins.bool: ...


class CellArea(GObject.InitiallyUnowned, Buildable, CellLayout):
    parent_instance: GObject.InitiallyUnowned

    def activate(self, context: CellAreaContext, widget: Widget, cell_area: Gdk.Rectangle, flags: CellRendererState, edit_only: builtins.bool) -> builtins.bool: ...

    def activate_cell(self, widget: Widget, renderer: CellRenderer, event: Gdk.Event, cell_area: Gdk.Rectangle, flags: CellRendererState) -> builtins.bool: ...

    def add(self, renderer: CellRenderer) -> None: ...

    def add_focus_sibling(self, renderer: CellRenderer, sibling: CellRenderer) -> None: ...

    def apply_attributes(self, tree_model: TreeModel, iter: TreeIter, is_expander: builtins.bool, is_expanded: builtins.bool) -> None: ...

    def attribute_connect(self, renderer: CellRenderer, attribute: builtins.str, column: builtins.int) -> None: ...

    def attribute_disconnect(self, renderer: CellRenderer, attribute: builtins.str) -> None: ...

    def attribute_get_column(self, renderer: CellRenderer, attribute: builtins.str) -> builtins.int: ...

    def cell_get_property(self, renderer: CellRenderer, property_name: builtins.str, value: GObject.Value) -> None: ...

    def cell_set_property(self, renderer: CellRenderer, property_name: builtins.str, value: GObject.Value) -> None: ...

    def copy_context(self, context: CellAreaContext) -> CellAreaContext: ...

    def create_context(self) -> CellAreaContext: ...

    def event(self, context: CellAreaContext, widget: Widget, event: Gdk.Event, cell_area: Gdk.Rectangle, flags: CellRendererState) -> builtins.int: ...

    def focus(self, direction: DirectionType) -> builtins.bool: ...

    def foreach(self, callback: CellCallback, *callback_data: typing.Optional[builtins.object]) -> None: ...

    def foreach_alloc(self, context: CellAreaContext, widget: Widget, cell_area: Gdk.Rectangle, background_area: Gdk.Rectangle, callback: CellAllocCallback, *callback_data: typing.Optional[builtins.object]) -> None: ...

    def get_cell_allocation(self, context: CellAreaContext, widget: Widget, renderer: CellRenderer, cell_area: Gdk.Rectangle) -> Gdk.Rectangle: ...

    def get_cell_at_position(self, context: CellAreaContext, widget: Widget, cell_area: Gdk.Rectangle, x: builtins.int, y: builtins.int) -> typing.Tuple[CellRenderer, Gdk.Rectangle]: ...

    def get_current_path_string(self) -> builtins.str: ...

    def get_edit_widget(self) -> CellEditable: ...

    def get_edited_cell(self) -> CellRenderer: ...

    def get_focus_cell(self) -> CellRenderer: ...

    def get_focus_from_sibling(self, renderer: CellRenderer) -> typing.Optional[CellRenderer]: ...

    def get_focus_siblings(self, renderer: CellRenderer) -> typing.Sequence[CellRenderer]: ...

    def get_preferred_height(self, context: CellAreaContext, widget: Widget) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_height_for_width(self, context: CellAreaContext, widget: Widget, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_width(self, context: CellAreaContext, widget: Widget) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_preferred_width_for_height(self, context: CellAreaContext, widget: Widget, height: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_request_mode(self) -> SizeRequestMode: ...

    def has_renderer(self, renderer: CellRenderer) -> builtins.bool: ...

    def inner_cell_area(self, widget: Widget, cell_area: Gdk.Rectangle) -> Gdk.Rectangle: ...

    def is_activatable(self) -> builtins.bool: ...

    def is_focus_sibling(self, renderer: CellRenderer, sibling: CellRenderer) -> builtins.bool: ...

    def remove(self, renderer: CellRenderer) -> None: ...

    def remove_focus_sibling(self, renderer: CellRenderer, sibling: CellRenderer) -> None: ...

    def render(self, context: CellAreaContext, widget: Widget, cr: cairo.Context, background_area: Gdk.Rectangle, cell_area: Gdk.Rectangle, flags: CellRendererState, paint_focus: builtins.bool) -> None: ...

    def request_renderer(self, renderer: CellRenderer, orientation: Orientation, widget: Widget, for_size: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def set_focus_cell(self, renderer: CellRenderer) -> None: ...

    def stop_editing(self, canceled: builtins.bool) -> None: ...

    @staticmethod
    def find_cell_property(property_name: builtins.str) -> GObject.ParamSpec: ...

    @staticmethod
    def install_cell_property(property_id: builtins.int, pspec: GObject.ParamSpec) -> None: ...

    @staticmethod
    def list_cell_properties() -> typing.Sequence[GObject.ParamSpec]: ...

    def do_activate(self, context: CellAreaContext, widget: Widget, cell_area: Gdk.Rectangle, flags: CellRendererState, edit_only: builtins.bool) -> builtins.bool: ...

    def do_add(self, renderer: CellRenderer) -> None: ...

    def do_apply_attributes(self, tree_model: TreeModel, iter: TreeIter, is_expander: builtins.bool, is_expanded: builtins.bool) -> None: ...

    def do_copy_context(self, context: CellAreaContext) -> CellAreaContext: ...

    def do_create_context(self) -> CellAreaContext: ...

    def do_event(self, context: CellAreaContext, widget: Widget, event: Gdk.Event, cell_area: Gdk.Rectangle, flags: CellRendererState) -> builtins.int: ...

    def do_focus(self, direction: DirectionType) -> builtins.bool: ...

    def do_foreach(self, callback: CellCallback, callback_data: typing.Optional[builtins.object]) -> None: ...

    def do_foreach_alloc(self, context: CellAreaContext, widget: Widget, cell_area: Gdk.Rectangle, background_area: Gdk.Rectangle, callback: CellAllocCallback, callback_data: typing.Optional[builtins.object]) -> None: ...

    def do_get_cell_property(self, renderer: CellRenderer, property_id: builtins.int, value: GObject.Value, pspec: GObject.ParamSpec) -> None: ...

    def do_get_preferred_height(self, context: CellAreaContext, widget: Widget) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_height_for_width(self, context: CellAreaContext, widget: Widget, width: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_width(self, context: CellAreaContext, widget: Widget) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_preferred_width_for_height(self, context: CellAreaContext, widget: Widget, height: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_get_request_mode(self) -> SizeRequestMode: ...

    def do_is_activatable(self) -> builtins.bool: ...

    def do_remove(self, renderer: CellRenderer) -> None: ...

    def do_render(self, context: CellAreaContext, widget: Widget, cr: cairo.Context, background_area: Gdk.Rectangle, cell_area: Gdk.Rectangle, flags: CellRendererState, paint_focus: builtins.bool) -> None: ...

    def do_set_cell_property(self, renderer: CellRenderer, property_id: builtins.int, value: GObject.Value, pspec: GObject.ParamSpec) -> None: ...


class EntryCompletion(GObject.Object, Buildable, CellLayout):
    parent_instance: GObject.Object

    def complete(self) -> None: ...

    def compute_prefix(self, key: builtins.str) -> typing.Optional[builtins.str]: ...

    def delete_action(self, index_: builtins.int) -> None: ...

    def get_completion_prefix(self) -> builtins.str: ...

    def get_entry(self) -> Widget: ...

    def get_inline_completion(self) -> builtins.bool: ...

    def get_inline_selection(self) -> builtins.bool: ...

    def get_minimum_key_length(self) -> builtins.int: ...

    def get_model(self) -> typing.Optional[TreeModel]: ...

    def get_popup_completion(self) -> builtins.bool: ...

    def get_popup_set_width(self) -> builtins.bool: ...

    def get_popup_single_match(self) -> builtins.bool: ...

    def get_text_column(self) -> builtins.int: ...

    def insert_action_markup(self, index_: builtins.int, markup: builtins.str) -> None: ...

    def insert_action_text(self, index_: builtins.int, text: builtins.str) -> None: ...

    def insert_prefix(self) -> None: ...

    @staticmethod
    def new(**kwargs) -> EntryCompletion: ...  # type: ignore

    @staticmethod
    def new_with_area(area: CellArea) -> EntryCompletion: ...

    def set_inline_completion(self, inline_completion: builtins.bool) -> None: ...

    def set_inline_selection(self, inline_selection: builtins.bool) -> None: ...

    def set_match_func(self, func: EntryCompletionMatchFunc, *func_data: typing.Optional[builtins.object]) -> None: ...

    def set_minimum_key_length(self, length: builtins.int) -> None: ...

    def set_model(self, model: typing.Optional[TreeModel]) -> None: ...

    def set_popup_completion(self, popup_completion: builtins.bool) -> None: ...

    def set_popup_set_width(self, popup_set_width: builtins.bool) -> None: ...

    def set_popup_single_match(self, popup_single_match: builtins.bool) -> None: ...

    def set_text_column(self, column: builtins.int) -> None: ...

    def do_action_activated(self, index_: builtins.int) -> None: ...

    def do_cursor_on_match(self, model: TreeModel, iter: TreeIter) -> builtins.bool: ...

    def do_insert_prefix(self, prefix: builtins.str) -> builtins.bool: ...

    def do_match_selected(self, model: TreeModel, iter: TreeIter) -> builtins.bool: ...

    def do_no_matches(self) -> None: ...


class TreeViewColumn(GObject.InitiallyUnowned, Buildable, CellLayout):
    parent_instance: GObject.InitiallyUnowned

    def add_attribute(self, cell_renderer: CellRenderer, attribute: builtins.str, column: builtins.int) -> None: ...

    def cell_get_position(self, cell_renderer: CellRenderer) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...

    def cell_get_size(self, cell_area: typing.Optional[Gdk.Rectangle]) -> typing.Tuple[builtins.int, builtins.int, builtins.int, builtins.int]: ...

    def cell_is_visible(self) -> builtins.bool: ...

    def cell_set_cell_data(self, tree_model: TreeModel, iter: TreeIter, is_expander: builtins.bool, is_expanded: builtins.bool) -> None: ...

    def clear(self) -> None: ...

    def clear_attributes(self, cell_renderer: CellRenderer) -> None: ...

    def clicked(self) -> None: ...

    def focus_cell(self, cell: CellRenderer) -> None: ...

    def get_alignment(self) -> builtins.float: ...

    def get_button(self) -> Widget: ...

    def get_clickable(self) -> builtins.bool: ...

    def get_expand(self) -> builtins.bool: ...

    def get_fixed_width(self) -> builtins.int: ...

    def get_max_width(self) -> builtins.int: ...

    def get_min_width(self) -> builtins.int: ...

    def get_reorderable(self) -> builtins.bool: ...

    def get_resizable(self) -> builtins.bool: ...

    def get_sizing(self) -> TreeViewColumnSizing: ...

    def get_sort_column_id(self) -> builtins.int: ...

    def get_sort_indicator(self) -> builtins.bool: ...

    def get_sort_order(self) -> SortType: ...

    def get_spacing(self) -> builtins.int: ...

    def get_title(self) -> builtins.str: ...

    def get_tree_view(self) -> typing.Optional[Widget]: ...

    def get_visible(self) -> builtins.bool: ...

    def get_widget(self) -> typing.Optional[Widget]: ...

    def get_width(self) -> builtins.int: ...

    def get_x_offset(self) -> builtins.int: ...

    @staticmethod
    def new() -> TreeViewColumn: ...

    @staticmethod
    def new_with_area(area: CellArea) -> TreeViewColumn: ...

    def pack_end(self, cell: CellRenderer, expand: builtins.bool) -> None: ...

    def pack_start(self, cell: CellRenderer, expand: builtins.bool) -> None: ...

    def queue_resize(self) -> None: ...

    def set_alignment(self, xalign: builtins.float) -> None: ...

    def set_attributes(self, cell_renderer: CellRenderer, **kwargs: int) -> None: ...

    def set_cell_data_func(self, cell_renderer: CellRenderer, func: typing.Optional[TreeCellDataFunc], *func_data: typing.Optional[builtins.object]) -> None: ...

    def set_clickable(self, clickable: builtins.bool) -> None: ...

    def set_expand(self, expand: builtins.bool) -> None: ...

    def set_fixed_width(self, fixed_width: builtins.int) -> None: ...

    def set_max_width(self, max_width: builtins.int) -> None: ...

    def set_min_width(self, min_width: builtins.int) -> None: ...

    def set_reorderable(self, reorderable: builtins.bool) -> None: ...

    def set_resizable(self, resizable: builtins.bool) -> None: ...

    def set_sizing(self, type: TreeViewColumnSizing) -> None: ...

    def set_sort_column_id(self, sort_column_id: builtins.int) -> None: ...

    def set_sort_indicator(self, setting: builtins.bool) -> None: ...

    def set_sort_order(self, order: SortType) -> None: ...

    def set_spacing(self, spacing: builtins.int) -> None: ...

    def set_title(self, title: builtins.str) -> None: ...

    def set_visible(self, visible: builtins.bool) -> None: ...

    def set_widget(self, widget: typing.Optional[Widget]) -> None: ...

    def do_clicked(self) -> None: ...


class CellRendererPixbuf(CellRenderer):
    parent: CellRenderer

    def __init__(self,
        *,
        stock_size: int = 1,
    ) -> None: ...

    @staticmethod
    def new() -> CellRenderer: ...


class CellRendererSpinner(CellRenderer):
    parent: CellRenderer

    @staticmethod
    def new() -> CellRenderer: ...


class CellRendererText(CellRenderer):
    parent: CellRenderer

    class _Props(CellRenderer._Props):
        ellipsize: Pango.EllipsizeMode
        style: Pango.Style

    props: _Props

    def __init__(self,
        *,
        ellipsize: Pango.EllipsizeMode = Pango.EllipsizeMode.NONE,
        style: Pango.Style = Pango.Style.NORMAL,
    ) -> None: ...

    @staticmethod
    def new() -> CellRenderer: ...

    def set_fixed_height_from_font(self, number_of_rows: builtins.int) -> None: ...

    def do_edited(self, path: builtins.str, new_text: builtins.str) -> None: ...


class CellRendererToggle(CellRenderer):
    parent: CellRenderer

    def get_activatable(self) -> builtins.bool: ...

    def get_active(self) -> builtins.bool: ...

    def get_radio(self) -> builtins.bool: ...

    @staticmethod
    def new() -> CellRenderer: ...

    def set_activatable(self, setting: builtins.bool) -> None: ...

    def set_active(self, setting: builtins.bool) -> None: ...

    def set_radio(self, radio: builtins.bool) -> None: ...

    def do_toggled(self, path: builtins.str) -> None: ...


class EventControllerKey(EventController):

    def forward(self, widget: Widget) -> builtins.bool: ...

    def get_group(self) -> builtins.int: ...

    def get_im_context(self) -> IMContext: ...

    @staticmethod
    def new(widget: Widget) -> EventController: ...

    def set_im_context(self, im_context: IMContext) -> None: ...


class EventControllerMotion(EventController):

    @staticmethod
    def new(widget: Widget) -> EventController: ...


class EventControllerScroll(EventController):

    def get_flags(self) -> EventControllerScrollFlags: ...

    @staticmethod
    def new(widget: Widget, flags: EventControllerScrollFlags) -> EventController: ...

    def set_flags(self, flags: EventControllerScrollFlags) -> None: ...


class Gesture(EventController):

    def get_bounding_box(self) -> typing.Tuple[builtins.bool, Gdk.Rectangle]: ...

    def get_bounding_box_center(self) -> typing.Tuple[builtins.bool, builtins.float, builtins.float]: ...

    def get_device(self) -> typing.Optional[Gdk.Device]: ...

    def get_group(self) -> typing.Sequence[Gesture]: ...

    def get_last_event(self, sequence: typing.Optional[Gdk.EventSequence]) -> typing.Optional[Gdk.Event]: ...

    def get_last_updated_sequence(self) -> typing.Optional[Gdk.EventSequence]: ...

    def get_point(self, sequence: typing.Optional[Gdk.EventSequence]) -> typing.Tuple[builtins.bool, builtins.float, builtins.float]: ...

    def get_sequence_state(self, sequence: Gdk.EventSequence) -> EventSequenceState: ...

    def get_sequences(self) -> typing.Sequence[Gdk.EventSequence]: ...

    def get_window(self) -> typing.Optional[Gdk.Window]: ...

    def group(self, gesture: Gesture) -> None: ...

    def handles_sequence(self, sequence: typing.Optional[Gdk.EventSequence]) -> builtins.bool: ...

    def is_active(self) -> builtins.bool: ...

    def is_grouped_with(self, other: Gesture) -> builtins.bool: ...

    def is_recognized(self) -> builtins.bool: ...

    def set_sequence_state(self, sequence: Gdk.EventSequence, state: EventSequenceState) -> builtins.bool: ...

    def set_state(self, state: EventSequenceState) -> builtins.bool: ...

    def set_window(self, window: typing.Optional[Gdk.Window]) -> None: ...

    def ungroup(self) -> None: ...


class PadController(EventController):

    @staticmethod
    def new(window: Window, group: Gio.ActionGroup, pad: typing.Optional[Gdk.Device]) -> PadController: ...

    def set_action(self, type: PadActionType, index: builtins.int, mode: builtins.int, label: builtins.str, action_name: builtins.str) -> None: ...

    def set_action_entries(self, entries: typing.Sequence[PadActionEntry]) -> None: ...


class IMContextSimple(IMContext):
    object: IMContext

    def add_compose_file(self, compose_file: builtins.str) -> None: ...

    @staticmethod
    def new() -> IMContext: ...


class IMMulticontext(IMContext):
    object: IMContext

    def append_menuitems(self, menushell: MenuShell) -> None: ...

    def get_context_id(self) -> builtins.str: ...

    @staticmethod
    def new() -> IMContext: ...

    def set_context_id(self, context_id: builtins.str) -> None: ...


class FileChooserNative(NativeDialog, FileChooser):

    def get_accept_label(self) -> typing.Optional[builtins.str]: ...

    def get_cancel_label(self) -> typing.Optional[builtins.str]: ...

    @staticmethod
    def new(title: typing.Optional[builtins.str], parent: typing.Optional[Window], action: FileChooserAction, accept_label: typing.Optional[builtins.str], cancel_label: typing.Optional[builtins.str]) -> FileChooserNative: ...

    def set_accept_label(self, accept_label: typing.Optional[builtins.str]) -> None: ...

    def set_cancel_label(self, cancel_label: typing.Optional[builtins.str]) -> None: ...


class CellRendererProgress(CellRenderer, Orientable):
    parent_instance: CellRenderer

    @staticmethod
    def new() -> CellRenderer: ...


class PrintOperation(GObject.Object, PrintOperationPreview):
    parent_instance: GObject.Object

    def cancel(self) -> None: ...

    def draw_page_finish(self) -> None: ...

    def get_default_page_setup(self) -> PageSetup: ...

    def get_embed_page_setup(self) -> builtins.bool: ...

    def get_error(self) -> None: ...

    def get_has_selection(self) -> builtins.bool: ...

    def get_n_pages_to_print(self) -> builtins.int: ...

    def get_print_settings(self) -> PrintSettings: ...

    def get_status(self) -> PrintStatus: ...

    def get_status_string(self) -> builtins.str: ...

    def get_support_selection(self) -> builtins.bool: ...

    def is_finished(self) -> builtins.bool: ...

    @staticmethod
    def new(**kwargs) -> PrintOperation: ...  # type: ignore

    def run(self, action: PrintOperationAction, parent: typing.Optional[Window]) -> PrintOperationResult: ...

    def set_allow_async(self, allow_async: builtins.bool) -> None: ...

    def set_current_page(self, current_page: builtins.int) -> None: ...

    def set_custom_tab_label(self, label: typing.Optional[builtins.str]) -> None: ...

    def set_default_page_setup(self, default_page_setup: typing.Optional[PageSetup]) -> None: ...

    def set_defer_drawing(self) -> None: ...

    def set_embed_page_setup(self, embed: builtins.bool) -> None: ...

    def set_export_filename(self, filename: builtins.str) -> None: ...

    def set_has_selection(self, has_selection: builtins.bool) -> None: ...

    def set_job_name(self, job_name: builtins.str) -> None: ...

    def set_n_pages(self, n_pages: builtins.int) -> None: ...

    def set_print_settings(self, print_settings: typing.Optional[PrintSettings]) -> None: ...

    def set_show_progress(self, show_progress: builtins.bool) -> None: ...

    def set_support_selection(self, support_selection: builtins.bool) -> None: ...

    def set_track_print_status(self, track_status: builtins.bool) -> None: ...

    def set_unit(self, unit: Unit) -> None: ...

    def set_use_full_page(self, full_page: builtins.bool) -> None: ...

    def do_begin_print(self, context: PrintContext) -> None: ...

    def do_custom_widget_apply(self, widget: Widget) -> None: ...

    def do_done(self, result: PrintOperationResult) -> None: ...

    def do_draw_page(self, context: PrintContext, page_nr: builtins.int) -> None: ...

    def do_end_print(self, context: PrintContext) -> None: ...

    def do_paginate(self, context: PrintContext) -> builtins.bool: ...

    def do_preview(self, preview: PrintOperationPreview, context: PrintContext, parent: Window) -> builtins.bool: ...

    def do_request_page_setup(self, context: PrintContext, page_nr: builtins.int, setup: PageSetup) -> None: ...

    def do_status_changed(self) -> None: ...

    def do_update_custom_widget(self, widget: Widget, setup: PageSetup, settings: PrintSettings) -> None: ...


class CssProvider(GObject.Object, StyleProvider):
    parent_instance: GObject.Object

    @staticmethod
    def get_default() -> CssProvider: ...

    @staticmethod
    def get_named(name: builtins.str, variant: typing.Optional[builtins.str]) -> CssProvider: ...

    def load_from_data(self, data: builtins.bytes) -> builtins.bool: ...

    def load_from_file(self, file: Gio.File) -> builtins.bool: ...

    def load_from_path(self, path: builtins.str) -> builtins.bool: ...

    def load_from_resource(self, resource_path: builtins.str) -> None: ...

    @staticmethod
    def new(**kwargs) -> CssProvider: ...  # type: ignore

    def to_string(self) -> builtins.str: ...

    def do_parsing_error(self, section: CssSection, error: GLib.Error) -> None: ...


class Settings(GObject.Object, StyleProvider):
    parent_instance: GObject.Object

    @staticmethod
    def get_default() -> typing.Optional[Settings]: ...

    @staticmethod
    def get_for_screen(screen: Gdk.Screen) -> Settings: ...

    @staticmethod
    def install_property(pspec: GObject.ParamSpec) -> None: ...  # type: ignore

    @staticmethod
    def install_property_parser(pspec: GObject.ParamSpec, parser: RcPropertyParser) -> None: ...

    def reset_property(self, name: builtins.str) -> None: ...

    def set_double_property(self, name: builtins.str, v_double: builtins.float, origin: builtins.str) -> None: ...

    def set_long_property(self, name: builtins.str, v_long: builtins.int, origin: builtins.str) -> None: ...

    def set_property_value(self, name: builtins.str, svalue: SettingsValue) -> None: ...

    def set_string_property(self, name: builtins.str, v_string: builtins.str, origin: builtins.str) -> None: ...


class StyleProperties(GObject.Object, StyleProvider):
    parent_object: GObject.Object

    def clear(self) -> None: ...

    def get_property(self, property: builtins.str, state: StateFlags) -> typing.Tuple[builtins.bool, GObject.Value]: ...  # type: ignore

    def lookup_color(self, name: builtins.str) -> SymbolicColor: ...

    def map_color(self, name: builtins.str, color: SymbolicColor) -> None: ...

    def merge(self, props_to_merge: StyleProperties, replace: builtins.bool) -> None: ...

    @staticmethod
    def new(**kwargs) -> StyleProperties: ...  # type: ignore

    def set_property(self, property: builtins.str, state: StateFlags, value: GObject.Value) -> None: ...  # type: ignore

    def unset_property(self, property: builtins.str, state: StateFlags) -> None: ...


class TreeModelFilter(GObject.Object, TreeDragSource, TreeModel):
    parent: GObject.Object

    def clear_cache(self) -> None: ...

    def convert_child_iter_to_iter(self, child_iter: TreeIter) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def convert_child_path_to_path(self, child_path: TreePath) -> typing.Optional[TreePath]: ...

    def convert_iter_to_child_iter(self, filter_iter: TreeIter) -> TreeIter: ...

    def convert_path_to_child_path(self, filter_path: TreePath) -> typing.Optional[TreePath]: ...

    def get_model(self) -> TreeModel: ...

    def refilter(self) -> None: ...

    def set_modify_func(self, types: typing.Sequence[GObject.GType], func: TreeModelFilterModifyFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def set_visible_column(self, column: builtins.int) -> None: ...

    def set_visible_func(self, func: TreeModelFilterVisibleFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def do_modify(self, child_model: TreeModel, iter: TreeIter, value: GObject.Value, column: builtins.int) -> None: ...

    def do_visible(self, child_model: TreeModel, iter: TreeIter) -> builtins.bool: ...


class ListStore(GObject.Object, Buildable, TreeDragDest, TreeDragSource, TreeModel, TreeSortable):
    parent: GObject.Object

    def __init__(self, *column_types: type) -> None: ...

    def append(self, row: typing.Optional[typing.Collection[object]] = None) -> TreeIter: ...

    def clear(self) -> None: ...

    def insert(self, position: builtins.int) -> TreeIter: ...

    def insert_after(self, sibling: typing.Optional[TreeIter]) -> TreeIter: ...

    def insert_before(self, sibling: typing.Optional[TreeIter]) -> TreeIter: ...

    def insert_with_valuesv(self, position: builtins.int, columns: typing.Sequence[builtins.int], values: typing.Sequence[GObject.Value]) -> TreeIter: ...

    def iter_is_valid(self, iter: TreeIter) -> builtins.bool: ...

    def move_after(self, iter: TreeIter, position: typing.Optional[TreeIter]) -> None: ...

    def move_before(self, iter: TreeIter, position: typing.Optional[TreeIter]) -> None: ...

    @staticmethod
    def new(types: typing.Sequence[GObject.GType], **kwargs) -> ListStore: ...  # type: ignore

    def prepend(self, row: typing.Optional[typing.Collection[object]] = None) -> TreeIter: ...

    def remove(self, iter: TreeIter) -> builtins.bool: ...

    def reorder(self, new_order: typing.Sequence[builtins.int]) -> None: ...

    def set(self, iter: TreeIter, *args: object) -> None: ...

    def set_column_types(self, types: typing.Sequence[GObject.GType]) -> None: ...

    def set_value(self, iter: TreeIter, column: builtins.int, value: GObject.Value) -> None: ...

    def swap(self, a: TreeIter, b: TreeIter) -> None: ...


class TreeModelSort(GObject.Object, TreeDragSource, TreeModel, TreeSortable):
    parent: GObject.Object

    def clear_cache(self) -> None: ...

    def convert_child_iter_to_iter(self, child_iter: TreeIter) -> typing.Tuple[builtins.bool, TreeIter]: ...

    def convert_child_path_to_path(self, child_path: TreePath) -> typing.Optional[TreePath]: ...

    def convert_iter_to_child_iter(self, sorted_iter: TreeIter) -> TreeIter: ...

    def convert_path_to_child_path(self, sorted_path: TreePath) -> typing.Optional[TreePath]: ...

    def get_model(self) -> TreeModel: ...

    def iter_is_valid(self, iter: TreeIter) -> builtins.bool: ...

    @staticmethod
    def new_with_model(child_model: TreeModel) -> TreeModelSort: ...

    def reset_default_sort_func(self) -> None: ...


class TreeStore(GObject.Object, Buildable, TreeDragDest, TreeDragSource, TreeModel, TreeSortable):
    parent: GObject.Object

    def append(self, parent: typing.Optional[TreeIter]) -> TreeIter: ...

    def clear(self) -> None: ...

    def insert(self, parent: typing.Optional[TreeIter], position: builtins.int) -> TreeIter: ...

    def insert_after(self, parent: typing.Optional[TreeIter], sibling: typing.Optional[TreeIter]) -> TreeIter: ...

    def insert_before(self, parent: typing.Optional[TreeIter], sibling: typing.Optional[TreeIter]) -> TreeIter: ...

    def insert_with_values(self, parent: typing.Optional[TreeIter], position: builtins.int, columns: typing.Sequence[builtins.int], values: typing.Sequence[GObject.Value]) -> TreeIter: ...

    def is_ancestor(self, iter: TreeIter, descendant: TreeIter) -> builtins.bool: ...

    def iter_depth(self, iter: TreeIter) -> builtins.int: ...

    def iter_is_valid(self, iter: TreeIter) -> builtins.bool: ...

    def move_after(self, iter: TreeIter, position: typing.Optional[TreeIter]) -> None: ...

    def move_before(self, iter: TreeIter, position: typing.Optional[TreeIter]) -> None: ...

    @staticmethod
    def new(types: typing.Sequence[GObject.GType], **kwargs) -> TreeStore: ...  # type: ignore

    def prepend(self, parent: typing.Optional[TreeIter]) -> TreeIter: ...

    def remove(self, iter: TreeIter) -> builtins.bool: ...

    def set(self, iter: TreeIter, columns: typing.Sequence[builtins.int], values: typing.Sequence[GObject.Value]) -> None: ...

    def set_column_types(self, types: typing.Sequence[GObject.GType]) -> None: ...

    def set_value(self, iter: TreeIter, column: builtins.int, value: GObject.Value) -> None: ...

    def swap(self, a: TreeIter, b: TreeIter) -> None: ...


class ContainerCellAccessible(CellAccessible):
    parent: CellAccessible

    def add_child(self, child: CellAccessible) -> None: ...

    def get_children(self) -> typing.Sequence[CellAccessible]: ...

    @staticmethod
    def new() -> ContainerCellAccessible: ...

    def remove_child(self, child: CellAccessible) -> None: ...


class RendererCellAccessible(CellAccessible):
    parent: CellAccessible

    @staticmethod
    def new(renderer: CellRenderer) -> Atk.Object: ...


class ArrowAccessible(WidgetAccessible, Atk.Image):
    parent: WidgetAccessible


class ContainerAccessible(WidgetAccessible):
    parent: WidgetAccessible


class EntryAccessible(WidgetAccessible, Atk.Action, Atk.EditableText, Atk.Text):  # type: ignore
    parent: WidgetAccessible


class ImageAccessible(WidgetAccessible, Atk.Image):
    parent: WidgetAccessible


class LabelAccessible(WidgetAccessible, Atk.Hypertext, Atk.Text):
    parent: WidgetAccessible


class LevelBarAccessible(WidgetAccessible, Atk.Value):
    parent: WidgetAccessible


class ProgressBarAccessible(WidgetAccessible, Atk.Value):
    parent: WidgetAccessible


class RangeAccessible(WidgetAccessible, Atk.Value):
    parent: WidgetAccessible


class SpinnerAccessible(WidgetAccessible, Atk.Image):
    parent: WidgetAccessible


class SwitchAccessible(WidgetAccessible, Atk.Action):  # type: ignore
    parent: WidgetAccessible


class RecentAction(Action, RecentChooser):
    parent_instance: Action

    def get_show_numbers(self) -> builtins.bool: ...

    @staticmethod
    def new(name: builtins.str, label: typing.Optional[builtins.str], tooltip: typing.Optional[builtins.str], stock_id: typing.Optional[builtins.str]) -> Action: ...  # type: ignore

    @staticmethod
    def new_for_manager(name: builtins.str, label: typing.Optional[builtins.str], tooltip: typing.Optional[builtins.str], stock_id: typing.Optional[builtins.str], manager: typing.Optional[RecentManager]) -> Action: ...

    def set_show_numbers(self, show_numbers: builtins.bool) -> None: ...


class ToggleAction(Action):
    parent: Action

    def get_active(self) -> builtins.bool: ...

    def get_draw_as_radio(self) -> builtins.bool: ...

    @staticmethod
    def new(name: builtins.str, label: typing.Optional[builtins.str], tooltip: typing.Optional[builtins.str], stock_id: typing.Optional[builtins.str]) -> ToggleAction: ...  # type: ignore

    def set_active(self, is_active: builtins.bool) -> None: ...

    def set_draw_as_radio(self, draw_as_radio: builtins.bool) -> None: ...

    def toggled(self) -> None: ...

    def do_toggled(self) -> None: ...


class Calendar(Widget):
    widget: Widget

    def clear_marks(self) -> None: ...

    def get_date(self) -> typing.Tuple[builtins.int, builtins.int, builtins.int]: ...

    def get_day_is_marked(self, day: builtins.int) -> builtins.bool: ...

    def get_detail_height_rows(self) -> builtins.int: ...

    def get_detail_width_chars(self) -> builtins.int: ...

    def get_display_options(self) -> CalendarDisplayOptions: ...

    def mark_day(self, day: builtins.int) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    def select_day(self, day: builtins.int) -> None: ...

    def select_month(self, month: builtins.int, year: builtins.int) -> None: ...

    def set_detail_func(self, func: CalendarDetailFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def set_detail_height_rows(self, rows: builtins.int) -> None: ...

    def set_detail_width_chars(self, chars: builtins.int) -> None: ...

    def set_display_options(self, flags: CalendarDisplayOptions) -> None: ...

    def unmark_day(self, day: builtins.int) -> None: ...

    def do_day_selected(self) -> None: ...

    def do_day_selected_double_click(self) -> None: ...

    def do_month_changed(self) -> None: ...

    def do_next_month(self) -> None: ...

    def do_next_year(self) -> None: ...

    def do_prev_month(self) -> None: ...

    def do_prev_year(self) -> None: ...


class CellView(Widget, CellLayout, Orientable):
    parent_instance: Widget

    def get_displayed_row(self) -> typing.Optional[TreePath]: ...

    def get_draw_sensitive(self) -> builtins.bool: ...

    def get_fit_model(self) -> builtins.bool: ...

    def get_model(self) -> typing.Optional[TreeModel]: ...

    def get_size_of_row(self, path: TreePath) -> typing.Tuple[builtins.bool, Requisition]: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_context(area: CellArea, context: CellAreaContext) -> Widget: ...

    @staticmethod
    def new_with_markup(markup: builtins.str) -> Widget: ...

    @staticmethod
    def new_with_pixbuf(pixbuf: GdkPixbuf.Pixbuf) -> Widget: ...

    @staticmethod
    def new_with_text(text: builtins.str) -> Widget: ...

    def set_background_color(self, color: Gdk.Color) -> None: ...

    def set_background_rgba(self, rgba: Gdk.RGBA) -> None: ...

    def set_displayed_row(self, path: typing.Optional[TreePath]) -> None: ...

    def set_draw_sensitive(self, draw_sensitive: builtins.bool) -> None: ...

    def set_fit_model(self, fit_model: builtins.bool) -> None: ...

    def set_model(self, model: typing.Optional[TreeModel]) -> None: ...


class Container(Widget):
    widget: Widget

    def __init__(self,
        *,
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def add(self, widget: Widget) -> None: ...

    def check_resize(self) -> None: ...

    def child_get_property(self, child: Widget, property_name: builtins.str, value: GObject.Value) -> None: ...

    def child_notify(self, child: Widget, child_property: builtins.str) -> None: ...  # type: ignore

    def child_notify_by_pspec(self, child: Widget, pspec: GObject.ParamSpec) -> None: ...

    def child_set_property(self, child: Widget, property_name: builtins.str, value: GObject.Value) -> None: ...

    def child_type(self) -> GObject.GType: ...

    def forall(self, callback: Callback, *callback_data: typing.Optional[builtins.object]) -> None: ...

    def foreach(self, callback: typing.Callable[[Widget], None]) -> None: ...

    def get_border_width(self) -> builtins.int: ...

    def get_children(self) -> typing.Sequence[Widget]: ...

    def get_focus_chain(self) -> typing.Tuple[builtins.bool, typing.Sequence[Widget]]: ...

    def get_focus_child(self) -> typing.Optional[Widget]: ...

    def get_focus_hadjustment(self) -> typing.Optional[Adjustment]: ...

    def get_focus_vadjustment(self) -> typing.Optional[Adjustment]: ...

    def get_path_for_child(self, child: Widget) -> WidgetPath: ...

    def get_resize_mode(self) -> ResizeMode: ...

    def propagate_draw(self, child: Widget, cr: cairo.Context) -> None: ...

    def remove(self, widget: Widget) -> None: ...

    def resize_children(self) -> None: ...

    def set_border_width(self, border_width: builtins.int) -> None: ...

    def set_focus_chain(self, focusable_widgets: typing.Sequence[Widget]) -> None: ...

    def set_focus_child(self, child: typing.Optional[Widget]) -> None: ...

    def set_focus_hadjustment(self, adjustment: Adjustment) -> None: ...

    def set_focus_vadjustment(self, adjustment: Adjustment) -> None: ...

    def set_reallocate_redraws(self, needs_redraws: builtins.bool) -> None: ...

    def set_resize_mode(self, resize_mode: ResizeMode) -> None: ...

    def unset_focus_chain(self) -> None: ...

    @staticmethod
    def find_child_property(property_name: builtins.str) -> typing.Optional[GObject.ParamSpec]: ...

    @staticmethod
    def handle_border_width() -> None: ...

    @staticmethod
    def install_child_properties(pspecs: typing.Sequence[GObject.ParamSpec]) -> None: ...

    @staticmethod
    def install_child_property(property_id: builtins.int, pspec: GObject.ParamSpec) -> None: ...

    @staticmethod
    def list_child_properties() -> typing.Sequence[GObject.ParamSpec]: ...

    def do_add(self, widget: Widget) -> None: ...

    def do_check_resize(self) -> None: ...

    def do_child_type(self) -> GObject.GType: ...

    def do_composite_name(self, child: Widget) -> builtins.str: ...

    def do_forall(self, include_internals: builtins.bool, callback: Callback, callback_data: typing.Optional[builtins.object]) -> None: ...

    def do_get_child_property(self, child: Widget, property_id: builtins.int, value: GObject.Value, pspec: GObject.ParamSpec) -> None: ...

    def do_get_path_for_child(self, child: Widget) -> WidgetPath: ...

    def do_remove(self, widget: Widget) -> None: ...

    def do_set_child_property(self, child: Widget, property_id: builtins.int, value: GObject.Value, pspec: GObject.ParamSpec) -> None: ...

    def do_set_focus_child(self, child: typing.Optional[Widget]) -> None: ...


class DrawingArea(Widget):
    dummy: builtins.object
    widget: Widget

    @staticmethod
    def new() -> Widget: ...


class Entry(Widget, CellEditable, Editable):
    parent_instance: Widget

    class _Props(Widget._Props):
        secondary_icon_name: typing.Optional[str]
        secondary_icon_tooltip_text: typing.Optional[str]
        text: str

    props: _Props

    def __init__(self,
        *,
        secondary_icon_name: typing.Optional[str] = None,
        secondary_icon_tooltip_text: typing.Optional[str] = None,
        text: str = "",
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_activates_default(self) -> builtins.bool: ...

    def get_alignment(self) -> builtins.float: ...

    def get_attributes(self) -> typing.Optional[Pango.AttrList]: ...

    def get_buffer(self) -> EntryBuffer: ...

    def get_completion(self) -> EntryCompletion: ...

    def get_current_icon_drag_source(self) -> builtins.int: ...

    def get_cursor_hadjustment(self) -> typing.Optional[Adjustment]: ...

    def get_has_frame(self) -> builtins.bool: ...

    def get_icon_activatable(self, icon_pos: EntryIconPosition) -> builtins.bool: ...

    def get_icon_area(self, icon_pos: EntryIconPosition) -> Gdk.Rectangle: ...

    def get_icon_at_pos(self, x: builtins.int, y: builtins.int) -> builtins.int: ...

    def get_icon_gicon(self, icon_pos: EntryIconPosition) -> typing.Optional[Gio.Icon]: ...

    def get_icon_name(self, icon_pos: EntryIconPosition) -> typing.Optional[builtins.str]: ...

    def get_icon_pixbuf(self, icon_pos: EntryIconPosition) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def get_icon_sensitive(self, icon_pos: EntryIconPosition) -> builtins.bool: ...

    def get_icon_stock(self, icon_pos: EntryIconPosition) -> builtins.str: ...

    def get_icon_storage_type(self, icon_pos: EntryIconPosition) -> ImageType: ...

    def get_icon_tooltip_markup(self, icon_pos: EntryIconPosition) -> typing.Optional[builtins.str]: ...

    def get_icon_tooltip_text(self, icon_pos: EntryIconPosition) -> typing.Optional[builtins.str]: ...

    def get_inner_border(self) -> typing.Optional[Border]: ...

    def get_input_hints(self) -> InputHints: ...

    def get_input_purpose(self) -> InputPurpose: ...

    def get_invisible_char(self) -> builtins.str: ...

    def get_layout(self) -> Pango.Layout: ...

    def get_layout_offsets(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_max_length(self) -> builtins.int: ...

    def get_max_width_chars(self) -> builtins.int: ...

    def get_overwrite_mode(self) -> builtins.bool: ...

    def get_placeholder_text(self) -> builtins.str: ...

    def get_progress_fraction(self) -> builtins.float: ...

    def get_progress_pulse_step(self) -> builtins.float: ...

    def get_tabs(self) -> typing.Optional[Pango.TabArray]: ...

    def get_text(self) -> builtins.str: ...

    def get_text_area(self) -> Gdk.Rectangle: ...

    def get_text_length(self) -> builtins.int: ...

    def get_visibility(self) -> builtins.bool: ...

    def get_width_chars(self) -> builtins.int: ...

    def grab_focus_without_selecting(self) -> None: ...

    def im_context_filter_keypress(self, event: Gdk.EventKey) -> builtins.bool: ...

    def layout_index_to_text_index(self, layout_index: builtins.int) -> builtins.int: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_buffer(buffer: EntryBuffer) -> Widget: ...

    def progress_pulse(self) -> None: ...

    def reset_im_context(self) -> None: ...

    def set_activates_default(self, setting: builtins.bool) -> None: ...

    def set_alignment(self, xalign: builtins.float) -> None: ...

    def set_attributes(self, attrs: Pango.AttrList) -> None: ...

    def set_buffer(self, buffer: EntryBuffer) -> None: ...

    def set_completion(self, completion: typing.Optional[EntryCompletion]) -> None: ...

    def set_cursor_hadjustment(self, adjustment: typing.Optional[Adjustment]) -> None: ...

    def set_has_frame(self, setting: builtins.bool) -> None: ...

    def set_icon_activatable(self, icon_pos: EntryIconPosition, activatable: builtins.bool) -> None: ...

    def set_icon_drag_source(self, icon_pos: EntryIconPosition, target_list: TargetList, actions: Gdk.DragAction) -> None: ...

    def set_icon_from_gicon(self, icon_pos: EntryIconPosition, icon: typing.Optional[Gio.Icon]) -> None: ...

    def set_icon_from_icon_name(self, icon_pos: EntryIconPosition, icon_name: typing.Optional[builtins.str]) -> None: ...

    def set_icon_from_pixbuf(self, icon_pos: EntryIconPosition, pixbuf: typing.Optional[GdkPixbuf.Pixbuf]) -> None: ...

    def set_icon_from_stock(self, icon_pos: EntryIconPosition, stock_id: typing.Optional[builtins.str]) -> None: ...

    def set_icon_sensitive(self, icon_pos: EntryIconPosition, sensitive: builtins.bool) -> None: ...

    def set_icon_tooltip_markup(self, icon_pos: EntryIconPosition, tooltip: typing.Optional[builtins.str]) -> None: ...

    def set_icon_tooltip_text(self, icon_pos: EntryIconPosition, tooltip: typing.Optional[builtins.str]) -> None: ...

    def set_inner_border(self, border: typing.Optional[Border]) -> None: ...

    def set_input_hints(self, hints: InputHints) -> None: ...

    def set_input_purpose(self, purpose: InputPurpose) -> None: ...

    def set_invisible_char(self, ch: builtins.str) -> None: ...

    def set_max_length(self, max: builtins.int) -> None: ...

    def set_max_width_chars(self, n_chars: builtins.int) -> None: ...

    def set_overwrite_mode(self, overwrite: builtins.bool) -> None: ...

    def set_placeholder_text(self, text: typing.Optional[builtins.str]) -> None: ...

    def set_progress_fraction(self, fraction: builtins.float) -> None: ...

    def set_progress_pulse_step(self, fraction: builtins.float) -> None: ...

    def set_tabs(self, tabs: Pango.TabArray) -> None: ...

    def set_text(self, text: builtins.str) -> None: ...

    def set_visibility(self, visible: builtins.bool) -> None: ...

    def set_width_chars(self, n_chars: builtins.int) -> None: ...

    def text_index_to_layout_index(self, text_index: builtins.int) -> builtins.int: ...

    def unset_invisible_char(self) -> None: ...

    def do_activate(self) -> None: ...

    def do_backspace(self) -> None: ...

    def do_copy_clipboard(self) -> None: ...

    def do_cut_clipboard(self) -> None: ...

    def do_delete_from_cursor(self, type: DeleteType, count: builtins.int) -> None: ...

    def do_get_frame_size(self, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_get_text_area_size(self, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def do_insert_at_cursor(self, str: builtins.str) -> None: ...

    def do_insert_emoji(self) -> None: ...

    def do_move_cursor(self, step: MovementStep, count: builtins.int, extend_selection: builtins.bool) -> None: ...

    def do_paste_clipboard(self) -> None: ...

    def do_populate_popup(self, popup: Widget) -> None: ...

    def do_toggle_overwrite(self) -> None: ...


class GLArea(Widget):
    parent_instance: Widget

    def attach_buffers(self) -> None: ...

    def get_auto_render(self) -> builtins.bool: ...

    def get_context(self) -> Gdk.GLContext: ...

    def get_error(self) -> typing.Optional[GLib.Error]: ...

    def get_has_alpha(self) -> builtins.bool: ...

    def get_has_depth_buffer(self) -> builtins.bool: ...

    def get_has_stencil_buffer(self) -> builtins.bool: ...

    def get_required_version(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_use_es(self) -> builtins.bool: ...

    def make_current(self) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    def queue_render(self) -> None: ...

    def set_auto_render(self, auto_render: builtins.bool) -> None: ...

    def set_error(self, error: typing.Optional[GLib.Error]) -> None: ...

    def set_has_alpha(self, has_alpha: builtins.bool) -> None: ...

    def set_has_depth_buffer(self, has_depth_buffer: builtins.bool) -> None: ...

    def set_has_stencil_buffer(self, has_stencil_buffer: builtins.bool) -> None: ...

    def set_required_version(self, major: builtins.int, minor: builtins.int) -> None: ...

    def set_use_es(self, use_es: builtins.bool) -> None: ...

    def do_render(self, context: Gdk.GLContext) -> builtins.bool: ...

    def do_resize(self, width: builtins.int, height: builtins.int) -> None: ...


class HSV(Widget):
    parent_instance: Widget

    def get_color(self) -> typing.Tuple[builtins.float, builtins.float, builtins.float]: ...

    def get_metrics(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def is_adjusting(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    def set_color(self, h: builtins.float, s: builtins.float, v: builtins.float) -> None: ...

    def set_metrics(self, size: builtins.int, ring_width: builtins.int) -> None: ...

    @staticmethod
    def to_rgb(h: builtins.float, s: builtins.float, v: builtins.float) -> typing.Tuple[builtins.float, builtins.float, builtins.float]: ...

    def do_changed(self) -> None: ...

    def do_move(self, type: DirectionType) -> None: ...


class Invisible(Widget):
    widget: Widget

    def get_screen(self) -> Gdk.Screen: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_for_screen(screen: Gdk.Screen) -> Widget: ...

    def set_screen(self, screen: Gdk.Screen) -> None: ...


class LevelBar(Widget, Orientable):
    parent: Widget

    def add_offset_value(self, name: builtins.str, value: builtins.float) -> None: ...

    def get_inverted(self) -> builtins.bool: ...

    def get_max_value(self) -> builtins.float: ...

    def get_min_value(self) -> builtins.float: ...

    def get_mode(self) -> LevelBarMode: ...

    def get_offset_value(self, name: typing.Optional[builtins.str]) -> typing.Tuple[builtins.bool, builtins.float]: ...

    def get_value(self) -> builtins.float: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_for_interval(min_value: builtins.float, max_value: builtins.float) -> Widget: ...

    def remove_offset_value(self, name: typing.Optional[builtins.str]) -> None: ...

    def set_inverted(self, inverted: builtins.bool) -> None: ...

    def set_max_value(self, value: builtins.float) -> None: ...

    def set_min_value(self, value: builtins.float) -> None: ...

    def set_mode(self, mode: LevelBarMode) -> None: ...

    def set_value(self, value: builtins.float) -> None: ...

    def do_offset_changed(self, name: builtins.str) -> None: ...


class Misc(Widget):
    widget: Widget

    def get_alignment(self) -> typing.Tuple[builtins.float, builtins.float]: ...

    def get_padding(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def set_alignment(self, xalign: builtins.float, yalign: builtins.float) -> None: ...

    def set_padding(self, xpad: builtins.int, ypad: builtins.int) -> None: ...


class ProgressBar(Widget, Orientable):
    parent: Widget

    class _Props(Widget._Props):
        fraction: float
        text: typing.Optional[str]

    props: _Props

    def __init__(self,
        *,
        fraction: float = 0,
        text: typing.Optional[str] = None,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
        # Orientable
        orientation: Orientation = Orientation.HORIZONTAL,
    ) -> None: ...

    def get_ellipsize(self) -> Pango.EllipsizeMode: ...

    def get_fraction(self) -> builtins.float: ...

    def get_inverted(self) -> builtins.bool: ...

    def get_pulse_step(self) -> builtins.float: ...

    def get_show_text(self) -> builtins.bool: ...

    def get_text(self) -> typing.Optional[builtins.str]: ...

    @staticmethod
    def new() -> Widget: ...

    def pulse(self) -> None: ...

    def set_ellipsize(self, mode: Pango.EllipsizeMode) -> None: ...

    def set_fraction(self, fraction: builtins.float) -> None: ...

    def set_inverted(self, inverted: builtins.bool) -> None: ...

    def set_pulse_step(self, fraction: builtins.float) -> None: ...

    def set_show_text(self, show_text: builtins.bool) -> None: ...

    def set_text(self, text: typing.Optional[builtins.str]) -> None: ...


class Range(Widget, Orientable):
    widget: Widget

    def get_adjustment(self) -> Adjustment: ...

    def get_fill_level(self) -> builtins.float: ...

    def get_flippable(self) -> builtins.bool: ...

    def get_inverted(self) -> builtins.bool: ...

    def get_lower_stepper_sensitivity(self) -> SensitivityType: ...

    def get_min_slider_size(self) -> builtins.int: ...

    def get_range_rect(self) -> Gdk.Rectangle: ...

    def get_restrict_to_fill_level(self) -> builtins.bool: ...

    def get_round_digits(self) -> builtins.int: ...

    def get_show_fill_level(self) -> builtins.bool: ...

    def get_slider_range(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_slider_size_fixed(self) -> builtins.bool: ...

    def get_upper_stepper_sensitivity(self) -> SensitivityType: ...

    def get_value(self) -> builtins.float: ...

    def set_adjustment(self, adjustment: Adjustment) -> None: ...

    def set_fill_level(self, fill_level: builtins.float) -> None: ...

    def set_flippable(self, flippable: builtins.bool) -> None: ...

    def set_increments(self, step: builtins.float, page: builtins.float) -> None: ...

    def set_inverted(self, setting: builtins.bool) -> None: ...

    def set_lower_stepper_sensitivity(self, sensitivity: SensitivityType) -> None: ...

    def set_min_slider_size(self, min_size: builtins.int) -> None: ...

    def set_range(self, min: builtins.float, max: builtins.float) -> None: ...

    def set_restrict_to_fill_level(self, restrict_to_fill_level: builtins.bool) -> None: ...

    def set_round_digits(self, round_digits: builtins.int) -> None: ...

    def set_show_fill_level(self, show_fill_level: builtins.bool) -> None: ...

    def set_slider_size_fixed(self, size_fixed: builtins.bool) -> None: ...

    def set_upper_stepper_sensitivity(self, sensitivity: SensitivityType) -> None: ...

    def set_value(self, value: builtins.float) -> None: ...

    def do_adjust_bounds(self, new_value: builtins.float) -> None: ...

    def do_change_value(self, scroll: ScrollType, new_value: builtins.float) -> builtins.bool: ...

    def do_get_range_border(self, border_: Border) -> None: ...

    def do_get_range_size_request(self, orientation: Orientation, minimum: builtins.int, natural: builtins.int) -> None: ...

    def do_move_slider(self, scroll: ScrollType) -> None: ...

    def do_value_changed(self) -> None: ...


class Separator(Widget, Orientable):
    widget: Widget

    def __init__(self,
        *,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
        # Orientable
        orientation: Orientation = Orientation.HORIZONTAL,
    ) -> None: ...

    @staticmethod
    def new(orientation: Orientation) -> Widget: ...


class Spinner(Widget):
    parent: Widget

    @staticmethod
    def new() -> Widget: ...

    def start(self) -> None: ...

    def stop(self) -> None: ...


class Switch(Widget, Actionable, Activatable):
    parent_instance: Widget

    def get_active(self) -> builtins.bool: ...

    def get_state(self) -> builtins.bool: ...  # type: ignore

    @staticmethod
    def new() -> Widget: ...

    def set_active(self, is_active: builtins.bool) -> None: ...

    def set_state(self, state: builtins.bool) -> None: ...  # type: ignore

    def do_activate(self) -> None: ...

    def do_state_set(self, state: builtins.bool) -> builtins.bool: ...


class CellAreaBox(CellArea, Orientable):
    parent_instance: CellArea

    def get_spacing(self) -> builtins.int: ...

    @staticmethod
    def new() -> CellArea: ...

    def pack_end(self, renderer: CellRenderer, expand: builtins.bool, align: builtins.bool, fixed: builtins.bool) -> None: ...  # type: ignore

    def pack_start(self, renderer: CellRenderer, expand: builtins.bool, align: builtins.bool, fixed: builtins.bool) -> None: ...  # type: ignore

    def set_spacing(self, spacing: builtins.int) -> None: ...


class CellRendererAccel(CellRendererText):
    parent: CellRendererText

    @staticmethod
    def new() -> CellRenderer: ...

    def do_accel_cleared(self, path_string: builtins.str) -> None: ...

    def do_accel_edited(self, path_string: builtins.str, accel_key: builtins.int, accel_mods: Gdk.ModifierType, hardware_keycode: builtins.int) -> None: ...


class CellRendererCombo(CellRendererText):
    parent: CellRendererText

    @staticmethod
    def new() -> CellRenderer: ...


class CellRendererSpin(CellRendererText):
    parent: CellRendererText

    @staticmethod
    def new() -> CellRenderer: ...


class GestureRotate(Gesture):

    def get_angle_delta(self) -> builtins.float: ...

    @staticmethod
    def new(widget: Widget) -> Gesture: ...


class GestureSingle(Gesture):

    def get_button(self) -> builtins.int: ...

    def get_current_button(self) -> builtins.int: ...

    def get_current_sequence(self) -> typing.Optional[Gdk.EventSequence]: ...

    def get_exclusive(self) -> builtins.bool: ...

    def get_touch_only(self) -> builtins.bool: ...

    def set_button(self, button: builtins.int) -> None: ...

    def set_exclusive(self, exclusive: builtins.bool) -> None: ...

    def set_touch_only(self, touch_only: builtins.bool) -> None: ...


class GestureZoom(Gesture):

    def get_scale_delta(self) -> builtins.float: ...

    @staticmethod
    def new(widget: Widget) -> Gesture: ...


class BooleanCellAccessible(RendererCellAccessible):
    parent: RendererCellAccessible


class ImageCellAccessible(RendererCellAccessible, Atk.Image):  # type: ignore
    parent: RendererCellAccessible


class TextCellAccessible(RendererCellAccessible, Atk.Text):  # type: ignore
    parent: RendererCellAccessible


class ButtonAccessible(ContainerAccessible, Atk.Action, Atk.Image):  # type: ignore
    parent: ContainerAccessible


class ComboBoxAccessible(ContainerAccessible, Atk.Action, Atk.Selection):  # type: ignore
    parent: ContainerAccessible


class ExpanderAccessible(ContainerAccessible, Atk.Action):  # type: ignore
    parent: ContainerAccessible


class FlowBoxAccessible(ContainerAccessible, Atk.Selection):
    parent: ContainerAccessible


class FlowBoxChildAccessible(ContainerAccessible):
    parent: ContainerAccessible


class FrameAccessible(ContainerAccessible):
    parent: ContainerAccessible


class HeaderBarAccessible(ContainerAccessible):
    parent: ContainerAccessible


class IconViewAccessible(ContainerAccessible, Atk.Selection):
    parent: ContainerAccessible


class ListBoxAccessible(ContainerAccessible, Atk.Selection):
    parent: ContainerAccessible


class ListBoxRowAccessible(ContainerAccessible):
    parent: ContainerAccessible


class MenuItemAccessible(ContainerAccessible, Atk.Action, Atk.Selection):  # type: ignore
    parent: ContainerAccessible


class MenuShellAccessible(ContainerAccessible, Atk.Selection):
    parent: ContainerAccessible


class NotebookAccessible(ContainerAccessible, Atk.Selection):
    parent: ContainerAccessible


class PanedAccessible(ContainerAccessible, Atk.Value):
    parent: ContainerAccessible


class PopoverAccessible(ContainerAccessible):
    parent: ContainerAccessible


class ScrolledWindowAccessible(ContainerAccessible):
    parent: ContainerAccessible


class StackAccessible(ContainerAccessible):
    parent: ContainerAccessible


class StatusbarAccessible(ContainerAccessible):
    parent: ContainerAccessible


class TextViewAccessible(ContainerAccessible, Atk.EditableText, Atk.StreamableContent, Atk.Text):
    parent: ContainerAccessible


class TreeViewAccessible(ContainerAccessible, Atk.Selection, Atk.Table, CellAccessibleParent):  # type: ignore
    parent: ContainerAccessible


class WindowAccessible(ContainerAccessible, Atk.Window):
    parent: ContainerAccessible


class SpinButtonAccessible(EntryAccessible, Atk.Value):  # type: ignore
    parent: EntryAccessible


class ScaleAccessible(RangeAccessible):
    parent: RangeAccessible


class RadioAction(ToggleAction):
    parent: ToggleAction

    def get_current_value(self) -> builtins.int: ...

    def get_group(self) -> typing.Sequence[RadioAction]: ...

    def join_group(self, group_source: typing.Optional[RadioAction]) -> None: ...

    @staticmethod
    def new(name: builtins.str, label: typing.Optional[builtins.str], tooltip: typing.Optional[builtins.str], stock_id: typing.Optional[builtins.str], value: builtins.int) -> RadioAction: ...  # type: ignore

    def set_current_value(self, current_value: builtins.int) -> None: ...

    def set_group(self, group: typing.Optional[typing.Sequence[RadioAction]]) -> None: ...

    def do_changed(self, current: RadioAction) -> None: ...


class Bin(Container):
    container: Container

    def get_child(self) -> typing.Optional[Widget]: ...


class Box(Container, Orientable):
    container: Container

    def __init__(self,
        *,
        homogeneous: bool = False,
        spacing: int = 0,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
        # Orientable
        orientation: Orientation = Orientation.HORIZONTAL,
    ) -> None: ...

    def get_baseline_position(self) -> BaselinePosition: ...

    def get_center_widget(self) -> typing.Optional[Widget]: ...

    def get_homogeneous(self) -> builtins.bool: ...

    def get_spacing(self) -> builtins.int: ...

    @staticmethod
    def new(orientation: Orientation, spacing: builtins.int) -> Widget: ...

    def pack_end(self, child: Widget, expand: builtins.bool, fill: builtins.bool, padding: builtins.int) -> None: ...

    def pack_start(self, child: Widget, expand: builtins.bool, fill: builtins.bool, padding: builtins.int) -> None: ...

    def query_child_packing(self, child: Widget) -> typing.Tuple[builtins.bool, builtins.bool, builtins.int, PackType]: ...

    def reorder_child(self, child: Widget, position: builtins.int) -> None: ...

    def set_baseline_position(self, position: BaselinePosition) -> None: ...

    def set_center_widget(self, widget: typing.Optional[Widget]) -> None: ...

    def set_child_packing(self, child: Widget, expand: builtins.bool, fill: builtins.bool, padding: builtins.int, pack_type: PackType) -> None: ...

    def set_homogeneous(self, homogeneous: builtins.bool) -> None: ...

    def set_spacing(self, spacing: builtins.int) -> None: ...


class Fixed(Container):
    container: Container

    def move(self, widget: Widget, x: builtins.int, y: builtins.int) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    def put(self, widget: Widget, x: builtins.int, y: builtins.int) -> None: ...


class FlowBox(Container, Orientable):
    container: Container

    def bind_model(self, model: typing.Optional[Gio.ListModel], create_widget_func: FlowBoxCreateWidgetFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def get_activate_on_single_click(self) -> builtins.bool: ...

    def get_child_at_index(self, idx: builtins.int) -> typing.Optional[FlowBoxChild]: ...

    def get_child_at_pos(self, x: builtins.int, y: builtins.int) -> typing.Optional[FlowBoxChild]: ...

    def get_column_spacing(self) -> builtins.int: ...

    def get_homogeneous(self) -> builtins.bool: ...

    def get_max_children_per_line(self) -> builtins.int: ...

    def get_min_children_per_line(self) -> builtins.int: ...

    def get_row_spacing(self) -> builtins.int: ...

    def get_selected_children(self) -> typing.Sequence[FlowBoxChild]: ...

    def get_selection_mode(self) -> SelectionMode: ...

    def insert(self, widget: Widget, position: builtins.int) -> None: ...

    def invalidate_filter(self) -> None: ...

    def invalidate_sort(self) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    def select_all(self) -> None: ...

    def select_child(self, child: FlowBoxChild) -> None: ...

    def selected_foreach(self, func: FlowBoxForeachFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def set_activate_on_single_click(self, single: builtins.bool) -> None: ...

    def set_column_spacing(self, spacing: builtins.int) -> None: ...

    def set_filter_func(self, filter_func: typing.Optional[FlowBoxFilterFunc], *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_hadjustment(self, adjustment: Adjustment) -> None: ...

    def set_homogeneous(self, homogeneous: builtins.bool) -> None: ...

    def set_max_children_per_line(self, n_children: builtins.int) -> None: ...

    def set_min_children_per_line(self, n_children: builtins.int) -> None: ...

    def set_row_spacing(self, spacing: builtins.int) -> None: ...

    def set_selection_mode(self, mode: SelectionMode) -> None: ...

    def set_sort_func(self, sort_func: typing.Optional[FlowBoxSortFunc], *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_vadjustment(self, adjustment: Adjustment) -> None: ...

    def unselect_all(self) -> None: ...

    def unselect_child(self, child: FlowBoxChild) -> None: ...

    def do_activate_cursor_child(self) -> None: ...

    def do_child_activated(self, child: FlowBoxChild) -> None: ...

    def do_move_cursor(self, step: MovementStep, count: builtins.int) -> builtins.bool: ...

    def do_select_all(self) -> None: ...

    def do_selected_children_changed(self) -> None: ...

    def do_toggle_cursor_child(self) -> None: ...

    def do_unselect_all(self) -> None: ...


class Grid(Container, Orientable):
    container: Container

    def __init__(self,
        *,
        row_spacing: int = 0,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
        # Orientable
        orientation: Orientation = Orientation.HORIZONTAL,
    ) -> None: ...

    def attach(self, child: Widget, left: builtins.int, top: builtins.int, width: builtins.int, height: builtins.int) -> None: ...

    def attach_next_to(self, child: Widget, sibling: typing.Optional[Widget], side: PositionType, width: builtins.int, height: builtins.int) -> None: ...

    def get_baseline_row(self) -> builtins.int: ...

    def get_child_at(self, left: builtins.int, top: builtins.int) -> typing.Optional[Widget]: ...

    def get_column_homogeneous(self) -> builtins.bool: ...

    def get_column_spacing(self) -> builtins.int: ...

    def get_row_baseline_position(self, row: builtins.int) -> BaselinePosition: ...

    def get_row_homogeneous(self) -> builtins.bool: ...

    def get_row_spacing(self) -> builtins.int: ...

    def insert_column(self, position: builtins.int) -> None: ...

    def insert_next_to(self, sibling: Widget, side: PositionType) -> None: ...

    def insert_row(self, position: builtins.int) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    def remove_column(self, position: builtins.int) -> None: ...

    def remove_row(self, position: builtins.int) -> None: ...

    def set_baseline_row(self, row: builtins.int) -> None: ...

    def set_column_homogeneous(self, homogeneous: builtins.bool) -> None: ...

    def set_column_spacing(self, spacing: builtins.int) -> None: ...

    def set_row_baseline_position(self, row: builtins.int, pos: BaselinePosition) -> None: ...

    def set_row_homogeneous(self, homogeneous: builtins.bool) -> None: ...

    def set_row_spacing(self, spacing: builtins.int) -> None: ...


class HeaderBar(Container):
    container: Container

    def get_custom_title(self) -> typing.Optional[Widget]: ...

    def get_decoration_layout(self) -> builtins.str: ...

    def get_has_subtitle(self) -> builtins.bool: ...

    def get_show_close_button(self) -> builtins.bool: ...

    def get_subtitle(self) -> typing.Optional[builtins.str]: ...

    def get_title(self) -> typing.Optional[builtins.str]: ...

    @staticmethod
    def new() -> Widget: ...

    def pack_end(self, child: Widget) -> None: ...

    def pack_start(self, child: Widget) -> None: ...

    def set_custom_title(self, title_widget: typing.Optional[Widget]) -> None: ...

    def set_decoration_layout(self, layout: typing.Optional[builtins.str]) -> None: ...

    def set_has_subtitle(self, setting: builtins.bool) -> None: ...

    def set_show_close_button(self, setting: builtins.bool) -> None: ...

    def set_subtitle(self, subtitle: typing.Optional[builtins.str]) -> None: ...

    def set_title(self, title: typing.Optional[builtins.str]) -> None: ...


class IconView(Container, CellLayout, Scrollable):
    parent: Container

    def convert_widget_to_bin_window_coords(self, wx: builtins.int, wy: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def create_drag_icon(self, path: TreePath) -> cairo.Surface: ...

    def enable_model_drag_dest(self, targets: typing.Sequence[TargetEntry], actions: Gdk.DragAction) -> None: ...

    def enable_model_drag_source(self, start_button_mask: Gdk.ModifierType, targets: typing.Sequence[TargetEntry], actions: Gdk.DragAction) -> None: ...

    def get_activate_on_single_click(self) -> builtins.bool: ...

    def get_cell_rect(self, path: TreePath, cell: typing.Optional[CellRenderer]) -> typing.Tuple[builtins.bool, Gdk.Rectangle]: ...

    def get_column_spacing(self) -> builtins.int: ...

    def get_columns(self) -> builtins.int: ...

    def get_cursor(self) -> typing.Tuple[builtins.bool, TreePath, CellRenderer]: ...

    def get_dest_item_at_pos(self, drag_x: builtins.int, drag_y: builtins.int) -> typing.Tuple[builtins.bool, TreePath, IconViewDropPosition]: ...

    def get_drag_dest_item(self) -> typing.Tuple[TreePath, IconViewDropPosition]: ...

    def get_item_at_pos(self, x: builtins.int, y: builtins.int) -> typing.Tuple[builtins.bool, TreePath, CellRenderer]: ...

    def get_item_column(self, path: TreePath) -> builtins.int: ...

    def get_item_orientation(self) -> Orientation: ...

    def get_item_padding(self) -> builtins.int: ...

    def get_item_row(self, path: TreePath) -> builtins.int: ...

    def get_item_width(self) -> builtins.int: ...

    def get_margin(self) -> builtins.int: ...

    def get_markup_column(self) -> builtins.int: ...

    def get_model(self) -> typing.Optional[TreeModel]: ...

    def get_path_at_pos(self, x: builtins.int, y: builtins.int) -> typing.Optional[TreePath]: ...

    def get_pixbuf_column(self) -> builtins.int: ...

    def get_reorderable(self) -> builtins.bool: ...

    def get_row_spacing(self) -> builtins.int: ...

    def get_selected_items(self) -> typing.Sequence[TreePath]: ...

    def get_selection_mode(self) -> SelectionMode: ...

    def get_spacing(self) -> builtins.int: ...

    def get_text_column(self) -> builtins.int: ...

    def get_tooltip_column(self) -> builtins.int: ...

    def get_tooltip_context(self, x: builtins.int, y: builtins.int, keyboard_tip: builtins.bool) -> typing.Tuple[builtins.bool, builtins.int, builtins.int, TreeModel, TreePath, TreeIter]: ...

    def get_visible_range(self) -> typing.Tuple[builtins.bool, TreePath, TreePath]: ...

    def item_activated(self, path: TreePath) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_area(area: CellArea) -> Widget: ...

    @staticmethod
    def new_with_model(model: TreeModel) -> Widget: ...

    def path_is_selected(self, path: TreePath) -> builtins.bool: ...

    def scroll_to_path(self, path: TreePath, use_align: builtins.bool, row_align: builtins.float, col_align: builtins.float) -> None: ...

    def select_all(self) -> None: ...

    def select_path(self, path: TreePath) -> None: ...

    def selected_foreach(self, func: IconViewForeachFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def set_activate_on_single_click(self, single: builtins.bool) -> None: ...

    def set_column_spacing(self, column_spacing: builtins.int) -> None: ...

    def set_columns(self, columns: builtins.int) -> None: ...

    def set_cursor(self, path: TreePath, cell: typing.Optional[CellRenderer], start_editing: builtins.bool) -> None: ...

    def set_drag_dest_item(self, path: typing.Optional[TreePath], pos: IconViewDropPosition) -> None: ...

    def set_item_orientation(self, orientation: Orientation) -> None: ...

    def set_item_padding(self, item_padding: builtins.int) -> None: ...

    def set_item_width(self, item_width: builtins.int) -> None: ...

    def set_margin(self, margin: builtins.int) -> None: ...

    def set_markup_column(self, column: builtins.int) -> None: ...

    def set_model(self, model: typing.Optional[TreeModel]) -> None: ...

    def set_pixbuf_column(self, column: builtins.int) -> None: ...

    def set_reorderable(self, reorderable: builtins.bool) -> None: ...

    def set_row_spacing(self, row_spacing: builtins.int) -> None: ...

    def set_selection_mode(self, mode: SelectionMode) -> None: ...

    def set_spacing(self, spacing: builtins.int) -> None: ...

    def set_text_column(self, column: builtins.int) -> None: ...

    def set_tooltip_cell(self, tooltip: Tooltip, path: TreePath, cell: typing.Optional[CellRenderer]) -> None: ...

    def set_tooltip_column(self, column: builtins.int) -> None: ...

    def set_tooltip_item(self, tooltip: Tooltip, path: TreePath) -> None: ...

    def unselect_all(self) -> None: ...

    def unselect_path(self, path: TreePath) -> None: ...

    def unset_model_drag_dest(self) -> None: ...

    def unset_model_drag_source(self) -> None: ...

    def do_activate_cursor_item(self) -> builtins.bool: ...

    def do_item_activated(self, path: TreePath) -> None: ...

    def do_move_cursor(self, step: MovementStep, count: builtins.int) -> builtins.bool: ...

    def do_select_all(self) -> None: ...

    def do_select_cursor_item(self) -> None: ...

    def do_selection_changed(self) -> None: ...

    def do_toggle_cursor_item(self) -> None: ...

    def do_unselect_all(self) -> None: ...


class Layout(Container, Scrollable):
    container: Container

    def get_bin_window(self) -> Gdk.Window: ...

    def get_hadjustment(self) -> Adjustment: ...

    def get_size(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_vadjustment(self) -> Adjustment: ...

    def move(self, child_widget: Widget, x: builtins.int, y: builtins.int) -> None: ...

    @staticmethod
    def new(hadjustment: typing.Optional[Adjustment], vadjustment: typing.Optional[Adjustment]) -> Widget: ...

    def put(self, child_widget: Widget, x: builtins.int, y: builtins.int) -> None: ...

    def set_hadjustment(self, adjustment: typing.Optional[Adjustment]) -> None: ...

    def set_size(self, width: builtins.int, height: builtins.int) -> None: ...

    def set_vadjustment(self, adjustment: typing.Optional[Adjustment]) -> None: ...


class ListBox(Container):
    parent_instance: Container

    def bind_model(self, model: typing.Optional[Gio.ListModel], create_widget_func: typing.Optional[ListBoxCreateWidgetFunc], *user_data: typing.Optional[builtins.object]) -> None: ...

    def drag_highlight_row(self, row: ListBoxRow) -> None: ...

    def drag_unhighlight_row(self) -> None: ...

    def get_activate_on_single_click(self) -> builtins.bool: ...

    def get_adjustment(self) -> Adjustment: ...

    def get_row_at_index(self, index_: builtins.int) -> typing.Optional[ListBoxRow]: ...

    def get_row_at_y(self, y: builtins.int) -> typing.Optional[ListBoxRow]: ...

    def get_selected_row(self) -> ListBoxRow: ...

    def get_selected_rows(self) -> typing.Sequence[ListBoxRow]: ...

    def get_selection_mode(self) -> SelectionMode: ...

    def insert(self, child: Widget, position: builtins.int) -> None: ...

    def invalidate_filter(self) -> None: ...

    def invalidate_headers(self) -> None: ...

    def invalidate_sort(self) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    def prepend(self, child: Widget) -> None: ...

    def select_all(self) -> None: ...

    def select_row(self, row: typing.Optional[ListBoxRow]) -> None: ...

    def selected_foreach(self, func: ListBoxForeachFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def set_activate_on_single_click(self, single: builtins.bool) -> None: ...

    def set_adjustment(self, adjustment: typing.Optional[Adjustment]) -> None: ...

    def set_filter_func(self, filter_func: typing.Optional[ListBoxFilterFunc], *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_header_func(self, update_header: typing.Optional[ListBoxUpdateHeaderFunc], *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_placeholder(self, placeholder: typing.Optional[Widget]) -> None: ...

    def set_selection_mode(self, mode: SelectionMode) -> None: ...

    def set_sort_func(self, sort_func: typing.Optional[ListBoxSortFunc], *user_data: typing.Optional[builtins.object]) -> None: ...

    def unselect_all(self) -> None: ...

    def unselect_row(self, row: ListBoxRow) -> None: ...

    def do_activate_cursor_row(self) -> None: ...

    def do_move_cursor(self, step: MovementStep, count: builtins.int) -> None: ...

    def do_row_activated(self, row: ListBoxRow) -> None: ...

    def do_row_selected(self, row: ListBoxRow) -> None: ...

    def do_select_all(self) -> None: ...

    def do_selected_rows_changed(self) -> None: ...

    def do_toggle_cursor_row(self) -> None: ...

    def do_unselect_all(self) -> None: ...


class MenuShell(Container):
    container: Container

    def activate_item(self, menu_item: Widget, force_deactivate: builtins.bool) -> None: ...

    def append(self, child: MenuItem) -> None: ...

    def bind_model(self, model: typing.Optional[Gio.MenuModel], action_namespace: typing.Optional[builtins.str], with_separators: builtins.bool) -> None: ...

    def cancel(self) -> None: ...

    def deactivate(self) -> None: ...

    def deselect(self) -> None: ...

    def get_parent_shell(self) -> Widget: ...

    def get_selected_item(self) -> Widget: ...

    def get_take_focus(self) -> builtins.bool: ...

    def insert(self, child: Widget, position: builtins.int) -> None: ...

    def prepend(self, child: Widget) -> None: ...

    def select_first(self, search_sensitive: builtins.bool) -> None: ...

    def select_item(self, menu_item: Widget) -> None: ...

    def set_take_focus(self, take_focus: builtins.bool) -> None: ...

    def do_activate_current(self, force_hide: builtins.bool) -> None: ...

    def do_cancel(self) -> None: ...

    def do_deactivate(self) -> None: ...

    def do_get_popup_delay(self) -> builtins.int: ...

    def do_insert(self, child: Widget, position: builtins.int) -> None: ...

    def do_move_current(self, direction: MenuDirectionType) -> None: ...

    def do_move_selected(self, distance: builtins.int) -> builtins.bool: ...

    def do_select_item(self, menu_item: Widget) -> None: ...

    def do_selection_done(self) -> None: ...


class Notebook(Container):
    container: Container

    def append_page(self, child: Widget, tab_label: typing.Optional[Widget]) -> builtins.int: ...

    def append_page_menu(self, child: Widget, tab_label: typing.Optional[Widget], menu_label: typing.Optional[Widget]) -> builtins.int: ...

    def detach_tab(self, child: Widget) -> None: ...

    def get_action_widget(self, pack_type: PackType) -> typing.Optional[Widget]: ...

    def get_current_page(self) -> builtins.int: ...

    def get_group_name(self) -> typing.Optional[builtins.str]: ...

    def get_menu_label(self, child: Widget) -> typing.Optional[Widget]: ...

    def get_menu_label_text(self, child: Widget) -> typing.Optional[builtins.str]: ...

    def get_n_pages(self) -> builtins.int: ...

    def get_nth_page(self, page_num: builtins.int) -> typing.Optional[Widget]: ...

    def get_scrollable(self) -> builtins.bool: ...

    def get_show_border(self) -> builtins.bool: ...

    def get_show_tabs(self) -> builtins.bool: ...

    def get_tab_detachable(self, child: Widget) -> builtins.bool: ...

    def get_tab_hborder(self) -> builtins.int: ...

    def get_tab_label(self, child: Widget) -> typing.Optional[Widget]: ...

    def get_tab_label_text(self, child: Widget) -> typing.Optional[builtins.str]: ...

    def get_tab_pos(self) -> PositionType: ...

    def get_tab_reorderable(self, child: Widget) -> builtins.bool: ...

    def get_tab_vborder(self) -> builtins.int: ...

    def insert_page(self, child: Widget, tab_label: typing.Optional[Widget], position: builtins.int) -> builtins.int: ...

    def insert_page_menu(self, child: Widget, tab_label: typing.Optional[Widget], menu_label: typing.Optional[Widget], position: builtins.int) -> builtins.int: ...

    @staticmethod
    def new() -> Widget: ...

    def next_page(self) -> None: ...

    def page_num(self, child: Widget) -> builtins.int: ...

    def popup_disable(self) -> None: ...

    def popup_enable(self) -> None: ...

    def prepend_page(self, child: Widget, tab_label: typing.Optional[Widget]) -> builtins.int: ...

    def prepend_page_menu(self, child: Widget, tab_label: typing.Optional[Widget], menu_label: typing.Optional[Widget]) -> builtins.int: ...

    def prev_page(self) -> None: ...

    def remove_page(self, page_num: builtins.int) -> None: ...

    def reorder_child(self, child: Widget, position: builtins.int) -> None: ...

    def set_action_widget(self, widget: Widget, pack_type: PackType) -> None: ...

    def set_current_page(self, page_num: builtins.int) -> None: ...

    def set_group_name(self, group_name: typing.Optional[builtins.str]) -> None: ...

    def set_menu_label(self, child: Widget, menu_label: typing.Optional[Widget]) -> None: ...

    def set_menu_label_text(self, child: Widget, menu_text: builtins.str) -> None: ...

    def set_scrollable(self, scrollable: builtins.bool) -> None: ...

    def set_show_border(self, show_border: builtins.bool) -> None: ...

    def set_show_tabs(self, show_tabs: builtins.bool) -> None: ...

    def set_tab_detachable(self, child: Widget, detachable: builtins.bool) -> None: ...

    def set_tab_label(self, child: Widget, tab_label: typing.Optional[Widget]) -> None: ...

    def set_tab_label_text(self, child: Widget, tab_text: builtins.str) -> None: ...

    def set_tab_pos(self, pos: PositionType) -> None: ...

    def set_tab_reorderable(self, child: Widget, reorderable: builtins.bool) -> None: ...

    def do_change_current_page(self, offset: builtins.int) -> builtins.bool: ...

    def do_focus_tab(self, type: NotebookTab) -> builtins.bool: ...

    def do_insert_page(self, child: Widget, tab_label: Widget, menu_label: Widget, position: builtins.int) -> builtins.int: ...

    def do_move_focus_out(self, direction: DirectionType) -> None: ...

    def do_page_added(self, child: Widget, page_num: builtins.int) -> None: ...

    def do_page_removed(self, child: Widget, page_num: builtins.int) -> None: ...

    def do_page_reordered(self, child: Widget, page_num: builtins.int) -> None: ...

    def do_reorder_tab(self, direction: DirectionType, move_to_last: builtins.bool) -> builtins.bool: ...

    def do_select_page(self, move_focus: builtins.bool) -> builtins.bool: ...

    def do_switch_page(self, page: Widget, page_num: builtins.int) -> None: ...


class Paned(Container, Orientable):
    container: Container

    def add1(self, child: Widget) -> None: ...

    def add2(self, child: Widget) -> None: ...

    def get_child1(self) -> typing.Optional[Widget]: ...

    def get_child2(self) -> typing.Optional[Widget]: ...

    def get_handle_window(self) -> Gdk.Window: ...

    def get_position(self) -> builtins.int: ...

    def get_wide_handle(self) -> builtins.bool: ...

    @staticmethod
    def new(orientation: Orientation) -> Widget: ...

    def pack1(self, child: Widget, resize: builtins.bool, shrink: builtins.bool) -> None: ...

    def pack2(self, child: Widget, resize: builtins.bool, shrink: builtins.bool) -> None: ...

    def set_position(self, position: builtins.int) -> None: ...

    def set_wide_handle(self, wide: builtins.bool) -> None: ...

    def do_accept_position(self) -> builtins.bool: ...

    def do_cancel_position(self) -> builtins.bool: ...

    def do_cycle_child_focus(self, reverse: builtins.bool) -> builtins.bool: ...

    def do_cycle_handle_focus(self, reverse: builtins.bool) -> builtins.bool: ...

    def do_move_handle(self, scroll: ScrollType) -> builtins.bool: ...

    def do_toggle_handle_focus(self) -> builtins.bool: ...


class Socket(Container):
    container: Container

    def add_id(self, window: builtins.int) -> None: ...

    def get_id(self) -> builtins.int: ...

    def get_plug_window(self) -> typing.Optional[Gdk.Window]: ...

    @staticmethod
    def new() -> Widget: ...

    def do_plug_added(self) -> None: ...

    def do_plug_removed(self) -> builtins.bool: ...


class Stack(Container):
    parent_instance: Container

    def add_named(self, child: Widget, name: builtins.str) -> None: ...

    def add_titled(self, child: Widget, name: builtins.str, title: builtins.str) -> None: ...

    def get_child_by_name(self, name: builtins.str) -> typing.Optional[Widget]: ...

    def get_hhomogeneous(self) -> builtins.bool: ...

    def get_homogeneous(self) -> builtins.bool: ...

    def get_interpolate_size(self) -> builtins.bool: ...

    def get_transition_duration(self) -> builtins.int: ...

    def get_transition_running(self) -> builtins.bool: ...

    def get_transition_type(self) -> StackTransitionType: ...

    def get_vhomogeneous(self) -> builtins.bool: ...

    def get_visible_child(self) -> typing.Optional[Widget]: ...

    def get_visible_child_name(self) -> typing.Optional[builtins.str]: ...

    @staticmethod
    def new() -> Widget: ...

    def set_hhomogeneous(self, hhomogeneous: builtins.bool) -> None: ...

    def set_homogeneous(self, homogeneous: builtins.bool) -> None: ...

    def set_interpolate_size(self, interpolate_size: builtins.bool) -> None: ...

    def set_transition_duration(self, duration: builtins.int) -> None: ...

    def set_transition_type(self, transition: StackTransitionType) -> None: ...

    def set_vhomogeneous(self, vhomogeneous: builtins.bool) -> None: ...

    def set_visible_child(self, child: Widget) -> None: ...

    def set_visible_child_full(self, name: builtins.str, transition: StackTransitionType) -> None: ...

    def set_visible_child_name(self, name: builtins.str) -> None: ...


class Table(Container):
    container: Container

    def attach(self, child: Widget, left_attach: builtins.int, right_attach: builtins.int, top_attach: builtins.int, bottom_attach: builtins.int, xoptions: AttachOptions, yoptions: AttachOptions, xpadding: builtins.int, ypadding: builtins.int) -> None: ...

    def attach_defaults(self, widget: Widget, left_attach: builtins.int, right_attach: builtins.int, top_attach: builtins.int, bottom_attach: builtins.int) -> None: ...

    def get_col_spacing(self, column: builtins.int) -> builtins.int: ...

    def get_default_col_spacing(self) -> builtins.int: ...

    def get_default_row_spacing(self) -> builtins.int: ...

    def get_homogeneous(self) -> builtins.bool: ...

    def get_row_spacing(self, row: builtins.int) -> builtins.int: ...

    def get_size(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    @staticmethod
    def new(rows: builtins.int, columns: builtins.int, homogeneous: builtins.bool) -> Widget: ...

    def resize(self, rows: builtins.int, columns: builtins.int) -> None: ...

    def set_col_spacing(self, column: builtins.int, spacing: builtins.int) -> None: ...

    def set_col_spacings(self, spacing: builtins.int) -> None: ...

    def set_homogeneous(self, homogeneous: builtins.bool) -> None: ...

    def set_row_spacing(self, row: builtins.int, spacing: builtins.int) -> None: ...

    def set_row_spacings(self, spacing: builtins.int) -> None: ...


class TextView(Container, Scrollable):
    parent_instance: Container

    def add_child_at_anchor(self, child: Widget, anchor: TextChildAnchor) -> None: ...

    def add_child_in_window(self, child: Widget, which_window: TextWindowType, xpos: builtins.int, ypos: builtins.int) -> None: ...

    def backward_display_line(self, iter: TextIter) -> builtins.bool: ...

    def backward_display_line_start(self, iter: TextIter) -> builtins.bool: ...

    def buffer_to_window_coords(self, win: TextWindowType, buffer_x: builtins.int, buffer_y: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def forward_display_line(self, iter: TextIter) -> builtins.bool: ...

    def forward_display_line_end(self, iter: TextIter) -> builtins.bool: ...

    def get_accepts_tab(self) -> builtins.bool: ...

    def get_border_window_size(self, type: TextWindowType) -> builtins.int: ...

    def get_bottom_margin(self) -> builtins.int: ...

    def get_buffer(self) -> TextBuffer: ...

    def get_cursor_locations(self, iter: typing.Optional[TextIter]) -> typing.Tuple[Gdk.Rectangle, Gdk.Rectangle]: ...

    def get_cursor_visible(self) -> builtins.bool: ...

    def get_default_attributes(self) -> TextAttributes: ...

    def get_editable(self) -> builtins.bool: ...

    def get_hadjustment(self) -> Adjustment: ...

    def get_indent(self) -> builtins.int: ...

    def get_input_hints(self) -> InputHints: ...

    def get_input_purpose(self) -> InputPurpose: ...

    def get_iter_at_location(self, x: builtins.int, y: builtins.int) -> typing.Tuple[builtins.bool, TextIter]: ...

    def get_iter_at_position(self, x: builtins.int, y: builtins.int) -> typing.Tuple[builtins.bool, TextIter, builtins.int]: ...

    def get_iter_location(self, iter: TextIter) -> Gdk.Rectangle: ...

    def get_justification(self) -> Justification: ...

    def get_left_margin(self) -> builtins.int: ...

    def get_line_at_y(self, y: builtins.int) -> typing.Tuple[TextIter, builtins.int]: ...

    def get_line_yrange(self, iter: TextIter) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_monospace(self) -> builtins.bool: ...

    def get_overwrite(self) -> builtins.bool: ...

    def get_pixels_above_lines(self) -> builtins.int: ...

    def get_pixels_below_lines(self) -> builtins.int: ...

    def get_pixels_inside_wrap(self) -> builtins.int: ...

    def get_right_margin(self) -> builtins.int: ...

    def get_tabs(self) -> typing.Optional[Pango.TabArray]: ...

    def get_top_margin(self) -> builtins.int: ...

    def get_vadjustment(self) -> Adjustment: ...

    def get_visible_rect(self) -> Gdk.Rectangle: ...

    def get_window(self, win: TextWindowType) -> typing.Optional[Gdk.Window]: ...  # type: ignore

    def get_window_type(self, window: Gdk.Window) -> TextWindowType: ...

    def get_wrap_mode(self) -> WrapMode: ...

    def im_context_filter_keypress(self, event: Gdk.EventKey) -> builtins.bool: ...

    def move_child(self, child: Widget, xpos: builtins.int, ypos: builtins.int) -> None: ...

    def move_mark_onscreen(self, mark: TextMark) -> builtins.bool: ...

    def move_visually(self, iter: TextIter, count: builtins.int) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_buffer(buffer: TextBuffer) -> Widget: ...

    def place_cursor_onscreen(self) -> builtins.bool: ...

    def reset_cursor_blink(self) -> None: ...

    def reset_im_context(self) -> None: ...

    def scroll_mark_onscreen(self, mark: TextMark) -> None: ...

    def scroll_to_iter(self, iter: TextIter, within_margin: builtins.float, use_align: builtins.bool, xalign: builtins.float, yalign: builtins.float) -> builtins.bool: ...

    def scroll_to_mark(self, mark: TextMark, within_margin: builtins.float, use_align: builtins.bool, xalign: builtins.float, yalign: builtins.float) -> None: ...

    def set_accepts_tab(self, accepts_tab: builtins.bool) -> None: ...

    def set_border_window_size(self, type: TextWindowType, size: builtins.int) -> None: ...

    def set_bottom_margin(self, bottom_margin: builtins.int) -> None: ...

    def set_buffer(self, buffer: typing.Optional[TextBuffer]) -> None: ...

    def set_cursor_visible(self, setting: builtins.bool) -> None: ...

    def set_editable(self, setting: builtins.bool) -> None: ...

    def set_indent(self, indent: builtins.int) -> None: ...

    def set_input_hints(self, hints: InputHints) -> None: ...

    def set_input_purpose(self, purpose: InputPurpose) -> None: ...

    def set_justification(self, justification: Justification) -> None: ...

    def set_left_margin(self, left_margin: builtins.int) -> None: ...

    def set_monospace(self, monospace: builtins.bool) -> None: ...

    def set_overwrite(self, overwrite: builtins.bool) -> None: ...

    def set_pixels_above_lines(self, pixels_above_lines: builtins.int) -> None: ...

    def set_pixels_below_lines(self, pixels_below_lines: builtins.int) -> None: ...

    def set_pixels_inside_wrap(self, pixels_inside_wrap: builtins.int) -> None: ...

    def set_right_margin(self, right_margin: builtins.int) -> None: ...

    def set_tabs(self, tabs: Pango.TabArray) -> None: ...

    def set_top_margin(self, top_margin: builtins.int) -> None: ...

    def set_wrap_mode(self, wrap_mode: WrapMode) -> None: ...

    def starts_display_line(self, iter: TextIter) -> builtins.bool: ...

    def window_to_buffer_coords(self, win: TextWindowType, window_x: builtins.int, window_y: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def do_backspace(self) -> None: ...

    def do_copy_clipboard(self) -> None: ...

    def do_cut_clipboard(self) -> None: ...

    def do_delete_from_cursor(self, type: DeleteType, count: builtins.int) -> None: ...

    def do_draw_layer(self, layer: TextViewLayer, cr: cairo.Context) -> None: ...

    def do_extend_selection(self, granularity: TextExtendSelection, location: TextIter, start: TextIter, end: TextIter) -> builtins.bool: ...

    def do_insert_at_cursor(self, str: builtins.str) -> None: ...

    def do_insert_emoji(self) -> None: ...

    def do_move_cursor(self, step: MovementStep, count: builtins.int, extend_selection: builtins.bool) -> None: ...

    def do_paste_clipboard(self) -> None: ...

    def do_populate_popup(self, popup: Widget) -> None: ...

    def do_set_anchor(self) -> None: ...

    def do_toggle_overwrite(self) -> None: ...


class ToolItemGroup(Container, ToolShell):  # type: ignore
    parent_instance: Container

    def get_collapsed(self) -> builtins.bool: ...

    def get_drop_item(self, x: builtins.int, y: builtins.int) -> ToolItem: ...

    def get_ellipsize(self) -> Pango.EllipsizeMode: ...

    def get_header_relief(self) -> ReliefStyle: ...

    def get_item_position(self, item: ToolItem) -> builtins.int: ...

    def get_label(self) -> builtins.str: ...

    def get_label_widget(self) -> Widget: ...

    def get_n_items(self) -> builtins.int: ...

    def get_nth_item(self, index: builtins.int) -> ToolItem: ...

    def insert(self, item: ToolItem, position: builtins.int) -> None: ...

    @staticmethod
    def new(label: builtins.str) -> Widget: ...

    def set_collapsed(self, collapsed: builtins.bool) -> None: ...

    def set_ellipsize(self, ellipsize: Pango.EllipsizeMode) -> None: ...

    def set_header_relief(self, style: ReliefStyle) -> None: ...

    def set_item_position(self, item: ToolItem, position: builtins.int) -> None: ...

    def set_label(self, label: builtins.str) -> None: ...

    def set_label_widget(self, label_widget: Widget) -> None: ...


class ToolPalette(Container, Orientable, Scrollable):
    parent_instance: Container

    def add_drag_dest(self, widget: Widget, flags: DestDefaults, targets: ToolPaletteDragTargets, actions: Gdk.DragAction) -> None: ...

    def get_drag_item(self, selection: SelectionData) -> Widget: ...

    @staticmethod
    def get_drag_target_group() -> TargetEntry: ...

    @staticmethod
    def get_drag_target_item() -> TargetEntry: ...

    def get_drop_group(self, x: builtins.int, y: builtins.int) -> typing.Optional[ToolItemGroup]: ...

    def get_drop_item(self, x: builtins.int, y: builtins.int) -> typing.Optional[ToolItem]: ...

    def get_exclusive(self, group: ToolItemGroup) -> builtins.bool: ...

    def get_expand(self, group: ToolItemGroup) -> builtins.bool: ...

    def get_group_position(self, group: ToolItemGroup) -> builtins.int: ...

    def get_hadjustment(self) -> Adjustment: ...

    def get_icon_size(self) -> builtins.int: ...

    def get_style(self) -> ToolbarStyle: ...  # type: ignore

    def get_vadjustment(self) -> Adjustment: ...

    @staticmethod
    def new() -> Widget: ...

    def set_drag_source(self, targets: ToolPaletteDragTargets) -> None: ...

    def set_exclusive(self, group: ToolItemGroup, exclusive: builtins.bool) -> None: ...

    def set_expand(self, group: ToolItemGroup, expand: builtins.bool) -> None: ...

    def set_group_position(self, group: ToolItemGroup, position: builtins.int) -> None: ...

    def set_icon_size(self, icon_size: builtins.int) -> None: ...

    def set_style(self, style: ToolbarStyle) -> None: ...  # type: ignore

    def unset_icon_size(self) -> None: ...

    def unset_style(self) -> None: ...


class Toolbar(Container, Orientable, ToolShell):
    container: Container

    def get_drop_index(self, x: builtins.int, y: builtins.int) -> builtins.int: ...

    def get_icon_size(self) -> IconSize: ...

    def get_item_index(self, item: ToolItem) -> builtins.int: ...

    def get_n_items(self) -> builtins.int: ...

    def get_nth_item(self, n: builtins.int) -> typing.Optional[ToolItem]: ...

    def get_relief_style(self) -> ReliefStyle: ...

    def get_show_arrow(self) -> builtins.bool: ...

    def get_style(self) -> ToolbarStyle: ...  # type: ignore

    def insert(self, item: ToolItem, pos: builtins.int) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    def set_drop_highlight_item(self, tool_item: typing.Optional[ToolItem], index_: builtins.int) -> None: ...

    def set_icon_size(self, icon_size: IconSize) -> None: ...

    def set_show_arrow(self, show_arrow: builtins.bool) -> None: ...

    def set_style(self, style: ToolbarStyle) -> None: ...  # type: ignore

    def unset_icon_size(self) -> None: ...

    def unset_style(self) -> None: ...

    def do_orientation_changed(self, orientation: Orientation) -> None: ...

    def do_popup_context_menu(self, x: builtins.int, y: builtins.int, button_number: builtins.int) -> builtins.bool: ...

    def do_style_changed(self, style: ToolbarStyle) -> None: ...


class TreeView(Container, Scrollable):
    parent: Container

    class _Props(Container._Props):
        headers_visible: bool
        model: typing.Optional[TreeModel]

    props: _Props

    def __init__(self,
        *,
        headers_visible: bool = True,
        model: typing.Optional[TreeModel] = None,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def append_column(self, column: TreeViewColumn) -> builtins.int: ...

    def collapse_all(self) -> None: ...

    def collapse_row(self, path: TreePath) -> builtins.bool: ...

    def columns_autosize(self) -> None: ...

    def convert_bin_window_to_tree_coords(self, bx: builtins.int, by: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def convert_bin_window_to_widget_coords(self, bx: builtins.int, by: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def convert_tree_to_bin_window_coords(self, tx: builtins.int, ty: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def convert_tree_to_widget_coords(self, tx: builtins.int, ty: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def convert_widget_to_bin_window_coords(self, wx: builtins.int, wy: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def convert_widget_to_tree_coords(self, wx: builtins.int, wy: builtins.int) -> typing.Tuple[builtins.int, builtins.int]: ...

    def create_row_drag_icon(self, path: TreePath) -> cairo.Surface: ...

    def enable_model_drag_dest(self, targets: typing.Sequence[TargetEntry], actions: Gdk.DragAction) -> None: ...

    def enable_model_drag_source(self, start_button_mask: Gdk.ModifierType, targets: typing.Sequence[TargetEntry], actions: Gdk.DragAction) -> None: ...

    def expand_all(self) -> None: ...

    def expand_row(self, path: TreePath, open_all: builtins.bool) -> builtins.bool: ...

    def expand_to_path(self, path: TreePath) -> None: ...

    def get_activate_on_single_click(self) -> builtins.bool: ...

    def get_background_area(self, path: typing.Optional[TreePath], column: typing.Optional[TreeViewColumn]) -> Gdk.Rectangle: ...

    def get_bin_window(self) -> typing.Optional[Gdk.Window]: ...

    def get_cell_area(self, path: typing.Optional[TreePath], column: typing.Optional[TreeViewColumn]) -> Gdk.Rectangle: ...

    def get_column(self, n: builtins.int) -> typing.Optional[TreeViewColumn]: ...

    def get_columns(self) -> typing.Sequence[TreeViewColumn]: ...

    def get_cursor(self) -> typing.Tuple[typing.Optional[TreePath], typing.Optional[TreeViewColumn]]: ...

    def get_dest_row_at_pos(self, drag_x: builtins.int, drag_y: builtins.int) -> typing.Tuple[builtins.bool, typing.Optional[TreePath], TreeViewDropPosition]: ...

    def get_drag_dest_row(self) -> typing.Tuple[typing.Optional[TreePath], TreeViewDropPosition]: ...

    def get_enable_search(self) -> builtins.bool: ...

    def get_enable_tree_lines(self) -> builtins.bool: ...

    def get_expander_column(self) -> TreeViewColumn: ...

    def get_fixed_height_mode(self) -> builtins.bool: ...

    def get_grid_lines(self) -> TreeViewGridLines: ...

    def get_hadjustment(self) -> Adjustment: ...

    def get_headers_clickable(self) -> builtins.bool: ...

    def get_headers_visible(self) -> builtins.bool: ...

    def get_hover_expand(self) -> builtins.bool: ...

    def get_hover_selection(self) -> builtins.bool: ...

    def get_level_indentation(self) -> builtins.int: ...

    def get_model(self) -> typing.Optional[TreeModel]: ...

    def get_n_columns(self) -> builtins.int: ...

    def get_path_at_pos(self, x: builtins.int, y: builtins.int) -> typing.Optional[typing.Tuple[typing.Optional[TreePath], typing.Optional[TreeViewColumn], builtins.int, builtins.int]]: ...

    def get_reorderable(self) -> builtins.bool: ...

    def get_rubber_banding(self) -> builtins.bool: ...

    def get_rules_hint(self) -> builtins.bool: ...

    def get_search_column(self) -> builtins.int: ...

    def get_search_entry(self) -> Entry: ...

    def get_selection(self) -> TreeSelection: ...

    def get_show_expanders(self) -> builtins.bool: ...

    def get_tooltip_column(self) -> builtins.int: ...

    def get_tooltip_context(self, x: builtins.int, y: builtins.int, keyboard_tip: builtins.bool) -> typing.Tuple[builtins.bool, builtins.int, builtins.int, typing.Optional[TreeModel], TreePath, TreeIter]: ...

    def get_vadjustment(self) -> Adjustment: ...

    def get_visible_range(self) -> typing.Tuple[builtins.bool, TreePath, TreePath]: ...

    def get_visible_rect(self) -> Gdk.Rectangle: ...

    def insert_column(self, column: TreeViewColumn, position: builtins.int) -> builtins.int: ...

    def insert_column_with_data_func(self, position: builtins.int, title: builtins.str, cell: CellRenderer, func: TreeCellDataFunc, *data: typing.Optional[builtins.object]) -> builtins.int: ...

    def is_blank_at_pos(self, x: builtins.int, y: builtins.int) -> typing.Tuple[builtins.bool, typing.Optional[TreePath], typing.Optional[TreeViewColumn], builtins.int, builtins.int]: ...

    def is_rubber_banding_active(self) -> builtins.bool: ...

    def map_expanded_rows(self, func: TreeViewMappingFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def move_column_after(self, column: TreeViewColumn, base_column: typing.Optional[TreeViewColumn]) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_model(model: TreeModel) -> Widget: ...

    def remove_column(self, column: TreeViewColumn) -> builtins.int: ...

    def row_activated(self, path: TreePath, column: TreeViewColumn) -> None: ...

    def row_expanded(self, path: TreePath) -> builtins.bool: ...

    def scroll_to_cell(self, path: typing.Optional[TreePath], column: typing.Optional[TreeViewColumn], use_align: builtins.bool, row_align: builtins.float, col_align: builtins.float) -> None: ...

    def scroll_to_point(self, tree_x: builtins.int, tree_y: builtins.int) -> None: ...

    def set_activate_on_single_click(self, single: builtins.bool) -> None: ...

    def set_column_drag_function(self, func: typing.Optional[TreeViewColumnDropFunc], *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_cursor(self, path: typing.Union[TreePath, int, str], focus_column: typing.Optional[TreeViewColumn] = None, start_editing: bool = False) -> None: ...

    def set_cursor_on_cell(self, path: TreePath, focus_column: typing.Optional[TreeViewColumn], focus_cell: typing.Optional[CellRenderer], start_editing: builtins.bool) -> None: ...

    def set_destroy_count_func(self, func: typing.Optional[TreeDestroyCountFunc], *data: typing.Optional[builtins.object]) -> None: ...

    def set_drag_dest_row(self, path: typing.Optional[TreePath], pos: TreeViewDropPosition) -> None: ...

    def set_enable_search(self, enable_search: builtins.bool) -> None: ...

    def set_enable_tree_lines(self, enabled: builtins.bool) -> None: ...

    def set_expander_column(self, column: typing.Optional[TreeViewColumn]) -> None: ...

    def set_fixed_height_mode(self, enable: builtins.bool) -> None: ...

    def set_grid_lines(self, grid_lines: TreeViewGridLines) -> None: ...

    def set_hadjustment(self, adjustment: typing.Optional[Adjustment]) -> None: ...

    def set_headers_clickable(self, setting: builtins.bool) -> None: ...

    def set_headers_visible(self, headers_visible: builtins.bool) -> None: ...

    def set_hover_expand(self, expand: builtins.bool) -> None: ...

    def set_hover_selection(self, hover: builtins.bool) -> None: ...

    def set_level_indentation(self, indentation: builtins.int) -> None: ...

    def set_model(self, model: typing.Optional[TreeModel]) -> None: ...

    def set_reorderable(self, reorderable: builtins.bool) -> None: ...

    def set_row_separator_func(self, func: typing.Optional[TreeViewRowSeparatorFunc], *data: typing.Optional[builtins.object]) -> None: ...

    def set_rubber_banding(self, enable: builtins.bool) -> None: ...

    def set_rules_hint(self, setting: builtins.bool) -> None: ...

    def set_search_column(self, column: builtins.int) -> None: ...

    def set_search_entry(self, entry: typing.Optional[Entry]) -> None: ...

    def set_search_equal_func(self, search_equal_func: typing.Callable[[TreeModel, int, str, TreeIter], bool], *search_user_data: typing.Optional[builtins.object]) -> None: ...

    def set_search_position_func(self, func: typing.Optional[TreeViewSearchPositionFunc], *data: typing.Optional[builtins.object]) -> None: ...

    def set_show_expanders(self, enabled: builtins.bool) -> None: ...

    def set_tooltip_cell(self, tooltip: Tooltip, path: typing.Optional[TreePath], column: typing.Optional[TreeViewColumn], cell: typing.Optional[CellRenderer]) -> None: ...

    def set_tooltip_column(self, column: builtins.int) -> None: ...

    def set_tooltip_row(self, tooltip: Tooltip, path: TreePath) -> None: ...

    def set_vadjustment(self, adjustment: typing.Optional[Adjustment]) -> None: ...

    def unset_rows_drag_dest(self) -> None: ...

    def unset_rows_drag_source(self) -> None: ...

    def do_columns_changed(self) -> None: ...

    def do_cursor_changed(self) -> None: ...

    def do_expand_collapse_cursor_row(self, logical: builtins.bool, expand: builtins.bool, open_all: builtins.bool) -> builtins.bool: ...

    def do_move_cursor(self, step: MovementStep, count: builtins.int) -> builtins.bool: ...

    def do_row_activated(self, path: TreePath, column: TreeViewColumn) -> None: ...

    def do_row_collapsed(self, iter: TreeIter, path: TreePath) -> None: ...

    def do_row_expanded(self, iter: TreeIter, path: TreePath) -> None: ...

    def do_select_all(self) -> builtins.bool: ...

    def do_select_cursor_parent(self) -> builtins.bool: ...

    def do_select_cursor_row(self, start_editing: builtins.bool) -> builtins.bool: ...

    def do_start_interactive_search(self) -> builtins.bool: ...

    def do_test_collapse_row(self, iter: TreeIter, path: TreePath) -> builtins.bool: ...

    def do_test_expand_row(self, iter: TreeIter, path: TreePath) -> builtins.bool: ...

    def do_toggle_cursor_row(self) -> builtins.bool: ...

    def do_unselect_all(self) -> builtins.bool: ...


class SearchEntry(Entry):
    parent: Entry

    def handle_event(self, event: Gdk.Event) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    def do_next_match(self) -> None: ...

    def do_previous_match(self) -> None: ...

    def do_search_changed(self) -> None: ...

    def do_stop_search(self) -> None: ...


class SpinButton(Entry, Orientable):
    entry: Entry

    class _Props(Entry._Props):
        numeric: bool
        value: float

    props: _Props

    def __init__(self,
        *,
        numeric: bool = False,
        value: float = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
        # Orientable
        orientation: Orientation = Orientation.HORIZONTAL,
    ) -> None: ...

    def configure(self, adjustment: typing.Optional[Adjustment], climb_rate: builtins.float, digits: builtins.int) -> None: ...

    def get_adjustment(self) -> Adjustment: ...

    def get_digits(self) -> builtins.int: ...

    def get_increments(self) -> typing.Tuple[builtins.float, builtins.float]: ...

    def get_numeric(self) -> builtins.bool: ...

    def get_range(self) -> typing.Tuple[builtins.float, builtins.float]: ...

    def get_snap_to_ticks(self) -> builtins.bool: ...

    def get_update_policy(self) -> SpinButtonUpdatePolicy: ...

    def get_value(self) -> builtins.float: ...

    def get_value_as_int(self) -> builtins.int: ...

    def get_wrap(self) -> builtins.bool: ...

    @staticmethod
    def new(adjustment: typing.Optional[Adjustment], climb_rate: builtins.float, digits: builtins.int) -> Widget: ...  # type: ignore

    @staticmethod
    def new_with_range(min: builtins.float, max: builtins.float, step: builtins.float) -> Widget: ...

    def set_adjustment(self, adjustment: Adjustment) -> None: ...

    def set_digits(self, digits: builtins.int) -> None: ...

    def set_increments(self, step: builtins.float, page: builtins.float) -> None: ...

    def set_numeric(self, numeric: builtins.bool) -> None: ...

    def set_range(self, min: builtins.float, max: builtins.float) -> None: ...

    def set_snap_to_ticks(self, snap_to_ticks: builtins.bool) -> None: ...

    def set_update_policy(self, policy: SpinButtonUpdatePolicy) -> None: ...

    def set_value(self, value: builtins.float) -> None: ...

    def set_wrap(self, wrap: builtins.bool) -> None: ...

    def spin(self, direction: SpinType, increment: builtins.float) -> None: ...

    def update(self) -> None: ...

    def do_change_value(self, scroll: ScrollType) -> None: ...

    def do_input(self, new_value: builtins.float) -> builtins.int: ...

    def do_output(self) -> builtins.int: ...

    def do_value_changed(self) -> None: ...

    def do_wrapped(self) -> None: ...


class Arrow(Misc):
    misc: Misc

    @staticmethod
    def new(arrow_type: ArrowType, shadow_type: ShadowType) -> Widget: ...

    def set(self, arrow_type: ArrowType, shadow_type: ShadowType) -> None: ...


class Image(Misc):
    misc: Misc

    class _Props(Misc._Props):
        icon_name: typing.Optional[str]
        pixel_size: int

    props: _Props

    def __init__(self,
        *,
        icon_name: typing.Optional[str] = None,
        pixel_size: int = -1,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def clear(self) -> None: ...

    def get_animation(self) -> typing.Optional[GdkPixbuf.PixbufAnimation]: ...

    def get_gicon(self) -> typing.Tuple[Gio.Icon, builtins.int]: ...

    def get_icon_name(self) -> typing.Tuple[builtins.str, builtins.int]: ...

    def get_icon_set(self) -> typing.Tuple[IconSet, builtins.int]: ...

    def get_pixbuf(self) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def get_pixel_size(self) -> builtins.int: ...

    def get_stock(self) -> typing.Tuple[builtins.str, builtins.int]: ...

    def get_storage_type(self) -> ImageType: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_from_animation(animation: GdkPixbuf.PixbufAnimation) -> Widget: ...

    @staticmethod
    def new_from_file(filename: builtins.str) -> Widget: ...

    @staticmethod
    def new_from_gicon(icon: Gio.Icon, size: builtins.int) -> Widget: ...

    @staticmethod
    def new_from_icon_name(icon_name: typing.Optional[builtins.str], size: builtins.int) -> Widget: ...

    @staticmethod
    def new_from_icon_set(icon_set: IconSet, size: builtins.int) -> Widget: ...

    @staticmethod
    def new_from_pixbuf(pixbuf: typing.Optional[GdkPixbuf.Pixbuf]) -> Widget: ...

    @staticmethod
    def new_from_resource(resource_path: builtins.str) -> Widget: ...

    @staticmethod
    def new_from_stock(stock_id: builtins.str, size: builtins.int) -> Widget: ...

    @staticmethod
    def new_from_surface(surface: typing.Optional[cairo.Surface]) -> Widget: ...

    def set_from_animation(self, animation: GdkPixbuf.PixbufAnimation) -> None: ...

    def set_from_file(self, filename: typing.Optional[builtins.str]) -> None: ...

    def set_from_gicon(self, icon: Gio.Icon, size: builtins.int) -> None: ...

    def set_from_icon_name(self, icon_name: typing.Optional[builtins.str], size: builtins.int) -> None: ...

    def set_from_icon_set(self, icon_set: IconSet, size: builtins.int) -> None: ...

    def set_from_pixbuf(self, pixbuf: typing.Optional[GdkPixbuf.Pixbuf]) -> None: ...

    def set_from_resource(self, resource_path: typing.Optional[builtins.str]) -> None: ...

    def set_from_stock(self, stock_id: builtins.str, size: builtins.int) -> None: ...

    def set_from_surface(self, surface: typing.Optional[cairo.Surface]) -> None: ...

    def set_pixel_size(self, pixel_size: builtins.int) -> None: ...


class Label(Misc):
    misc: Misc

    class _Props(Misc._Props):
        ellipsize: Pango.EllipsizeMode
        label: str
        selectable: bool
        single_line_mode: bool
        use_markup: bool
        wrap: bool
        xalign: float

    props: _Props

    def __init__(self,
        *,
        ellipsize: Pango.EllipsizeMode = Pango.EllipsizeMode.NONE,
        label: str = "",
        selectable: bool = False,
        single_line_mode: bool = False,
        use_markup: bool = False,
        wrap: bool = False,
        xalign: float = 0.5,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_angle(self) -> builtins.float: ...

    def get_attributes(self) -> typing.Optional[Pango.AttrList]: ...

    def get_current_uri(self) -> builtins.str: ...

    def get_ellipsize(self) -> Pango.EllipsizeMode: ...

    def get_justify(self) -> Justification: ...

    def get_label(self) -> builtins.str: ...

    def get_layout(self) -> Pango.Layout: ...

    def get_layout_offsets(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_line_wrap(self) -> builtins.bool: ...

    def get_line_wrap_mode(self) -> Pango.WrapMode: ...

    def get_lines(self) -> builtins.int: ...

    def get_max_width_chars(self) -> builtins.int: ...

    def get_mnemonic_keyval(self) -> builtins.int: ...

    def get_mnemonic_widget(self) -> typing.Optional[Widget]: ...

    def get_selectable(self) -> builtins.bool: ...

    def get_selection_bounds(self) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...

    def get_single_line_mode(self) -> builtins.bool: ...

    def get_text(self) -> builtins.str: ...

    def get_track_visited_links(self) -> builtins.bool: ...

    def get_use_markup(self) -> builtins.bool: ...

    def get_use_underline(self) -> builtins.bool: ...

    def get_width_chars(self) -> builtins.int: ...

    def get_xalign(self) -> builtins.float: ...

    def get_yalign(self) -> builtins.float: ...

    @staticmethod
    def new(str: typing.Optional[builtins.str]) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(str: typing.Optional[builtins.str]) -> Widget: ...

    def select_region(self, start_offset: builtins.int, end_offset: builtins.int) -> None: ...

    def set_angle(self, angle: builtins.float) -> None: ...

    def set_attributes(self, attrs: typing.Optional[Pango.AttrList]) -> None: ...

    def set_ellipsize(self, mode: Pango.EllipsizeMode) -> None: ...

    def set_justify(self, jtype: Justification) -> None: ...

    def set_label(self, str: builtins.str) -> None: ...

    def set_line_wrap(self, wrap: builtins.bool) -> None: ...

    def set_line_wrap_mode(self, wrap_mode: Pango.WrapMode) -> None: ...

    def set_lines(self, lines: builtins.int) -> None: ...

    def set_markup(self, str: builtins.str) -> None: ...

    def set_markup_with_mnemonic(self, str: builtins.str) -> None: ...

    def set_max_width_chars(self, n_chars: builtins.int) -> None: ...

    def set_mnemonic_widget(self, widget: typing.Optional[Widget]) -> None: ...

    def set_pattern(self, pattern: builtins.str) -> None: ...

    def set_selectable(self, setting: builtins.bool) -> None: ...

    def set_single_line_mode(self, single_line_mode: builtins.bool) -> None: ...

    def set_text(self, str: builtins.str) -> None: ...

    def set_text_with_mnemonic(self, str: builtins.str) -> None: ...

    def set_track_visited_links(self, track_links: builtins.bool) -> None: ...

    def set_use_markup(self, setting: builtins.bool) -> None: ...

    def set_use_underline(self, setting: builtins.bool) -> None: ...

    def set_width_chars(self, n_chars: builtins.int) -> None: ...

    def set_xalign(self, xalign: builtins.float) -> None: ...

    def set_yalign(self, yalign: builtins.float) -> None: ...

    def do_activate_link(self, uri: builtins.str) -> builtins.bool: ...

    def do_copy_clipboard(self) -> None: ...

    def do_move_cursor(self, step: MovementStep, count: builtins.int, extend_selection: builtins.bool) -> None: ...

    def do_populate_popup(self, menu: Menu) -> None: ...


class Scale(Range):
    range: Range

    def add_mark(self, value: builtins.float, position: PositionType, markup: typing.Optional[builtins.str]) -> None: ...

    def clear_marks(self) -> None: ...

    def get_digits(self) -> builtins.int: ...

    def get_draw_value(self) -> builtins.bool: ...

    def get_has_origin(self) -> builtins.bool: ...

    def get_layout(self) -> typing.Optional[Pango.Layout]: ...

    def get_layout_offsets(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_value_pos(self) -> PositionType: ...

    @staticmethod
    def new(orientation: Orientation, adjustment: typing.Optional[Adjustment]) -> Widget: ...

    @staticmethod
    def new_with_range(orientation: Orientation, min: builtins.float, max: builtins.float, step: builtins.float) -> Widget: ...

    def set_digits(self, digits: builtins.int) -> None: ...

    def set_draw_value(self, draw_value: builtins.bool) -> None: ...

    def set_has_origin(self, has_origin: builtins.bool) -> None: ...

    def set_value_pos(self, pos: PositionType) -> None: ...

    def do_draw_value(self) -> None: ...

    def do_format_value(self, value: builtins.float) -> builtins.str: ...

    def do_get_layout_offsets(self) -> typing.Tuple[builtins.int, builtins.int]: ...


class Scrollbar(Range):
    range: Range

    @staticmethod
    def new(orientation: Orientation, adjustment: typing.Optional[Adjustment]) -> Widget: ...


class HSeparator(Separator):
    separator: Separator

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class VSeparator(Separator):
    separator: Separator

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class GestureDrag(GestureSingle):

    def get_offset(self) -> typing.Tuple[builtins.bool, builtins.float, builtins.float]: ...

    def get_start_point(self) -> typing.Tuple[builtins.bool, builtins.float, builtins.float]: ...

    @staticmethod
    def new(widget: Widget) -> Gesture: ...


class GestureLongPress(GestureSingle):

    @staticmethod
    def new(widget: Widget) -> Gesture: ...


class GestureMultiPress(GestureSingle):

    def get_area(self) -> typing.Tuple[builtins.bool, Gdk.Rectangle]: ...

    @staticmethod
    def new(widget: Widget) -> Gesture: ...

    def set_area(self, rect: typing.Optional[Gdk.Rectangle]) -> None: ...


class GestureStylus(GestureSingle):

    def get_axes(self, axes: typing.Sequence[Gdk.AxisUse]) -> typing.Tuple[builtins.bool, typing.Sequence[builtins.float]]: ...

    def get_axis(self, axis: Gdk.AxisUse) -> typing.Tuple[builtins.bool, builtins.float]: ...

    def get_device_tool(self) -> typing.Optional[Gdk.DeviceTool]: ...

    @staticmethod
    def new(widget: Widget) -> Gesture: ...


class GestureSwipe(GestureSingle):

    def get_velocity(self) -> typing.Tuple[builtins.bool, builtins.float, builtins.float]: ...

    @staticmethod
    def new(widget: Widget) -> Gesture: ...


class LinkButtonAccessible(ButtonAccessible, Atk.HyperlinkImpl):  # type: ignore
    parent: ButtonAccessible


class LockButtonAccessible(ButtonAccessible):
    parent: ButtonAccessible


class ScaleButtonAccessible(ButtonAccessible, Atk.Value):  # type: ignore
    parent: ButtonAccessible


class ToggleButtonAccessible(ButtonAccessible):
    parent: ButtonAccessible


class CheckMenuItemAccessible(MenuItemAccessible):
    parent: MenuItemAccessible


class MenuAccessible(MenuShellAccessible):
    parent: MenuShellAccessible


class ActionBar(Bin):
    bin: Bin

    def get_center_widget(self) -> typing.Optional[Widget]: ...

    @staticmethod
    def new() -> Widget: ...

    def pack_end(self, child: Widget) -> None: ...

    def pack_start(self, child: Widget) -> None: ...

    def set_center_widget(self, center_widget: typing.Optional[Widget]) -> None: ...


class Alignment(Bin):
    bin: Bin

    def get_padding(self) -> typing.Tuple[builtins.int, builtins.int, builtins.int, builtins.int]: ...

    @staticmethod
    def new(xalign: builtins.float, yalign: builtins.float, xscale: builtins.float, yscale: builtins.float) -> Widget: ...

    def set(self, xalign: builtins.float, yalign: builtins.float, xscale: builtins.float, yscale: builtins.float) -> None: ...

    def set_padding(self, padding_top: builtins.int, padding_bottom: builtins.int, padding_left: builtins.int, padding_right: builtins.int) -> None: ...


class Button(Bin, Actionable, Activatable):
    bin: Bin

    class _Props(Bin._Props):
        image: typing.Optional[Widget]
        label: typing.Optional[str]
        relief: ReliefStyle
        use_underline: bool

    props: _Props

    def __init__(self,
        *,
        image: typing.Optional[Widget] = None,
        label: typing.Optional[str] = None,
        relief: ReliefStyle = ReliefStyle.NORMAL,
        use_underline: bool = False,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def clicked(self) -> None: ...

    def enter(self) -> None: ...

    def get_alignment(self) -> typing.Tuple[builtins.float, builtins.float]: ...

    def get_always_show_image(self) -> builtins.bool: ...

    def get_event_window(self) -> Gdk.Window: ...

    def get_focus_on_click(self) -> builtins.bool: ...

    def get_image(self) -> typing.Optional[Widget]: ...

    def get_image_position(self) -> PositionType: ...

    def get_label(self) -> builtins.str: ...

    def get_relief(self) -> ReliefStyle: ...

    def get_use_stock(self) -> builtins.bool: ...

    def get_use_underline(self) -> builtins.bool: ...

    def leave(self) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_from_icon_name(icon_name: typing.Optional[builtins.str], size: builtins.int) -> Widget: ...

    @staticmethod
    def new_from_stock(stock_id: builtins.str) -> Widget: ...

    @staticmethod
    def new_with_label(label: builtins.str) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(label: builtins.str) -> Widget: ...

    def pressed(self) -> None: ...

    def released(self) -> None: ...

    def set_alignment(self, xalign: builtins.float, yalign: builtins.float) -> None: ...

    def set_always_show_image(self, always_show: builtins.bool) -> None: ...

    def set_focus_on_click(self, focus_on_click: builtins.bool) -> None: ...

    def set_image(self, image: typing.Optional[Widget]) -> None: ...

    def set_image_position(self, position: PositionType) -> None: ...

    def set_label(self, label: builtins.str) -> None: ...

    def set_relief(self, relief: ReliefStyle) -> None: ...

    def set_use_stock(self, use_stock: builtins.bool) -> None: ...

    def set_use_underline(self, use_underline: builtins.bool) -> None: ...

    def do_activate(self) -> None: ...

    def do_clicked(self) -> None: ...

    def do_enter(self) -> None: ...

    def do_leave(self) -> None: ...

    def do_pressed(self) -> None: ...

    def do_released(self) -> None: ...


class ComboBox(Bin, CellEditable, CellLayout):
    parent_instance: Bin

    class _Props(Bin._Props):
        model: TreeModel

    props: _Props

    def __init__(self,
        *,
        model: TreeModel,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_active(self) -> builtins.int: ...

    def get_active_id(self) -> typing.Optional[builtins.str]: ...

    def get_active_iter(self) -> typing.Optional[TreeIter]: ...

    def get_add_tearoffs(self) -> builtins.bool: ...

    def get_button_sensitivity(self) -> SensitivityType: ...

    def get_column_span_column(self) -> builtins.int: ...

    def get_entry_text_column(self) -> builtins.int: ...

    def get_focus_on_click(self) -> builtins.bool: ...

    def get_has_entry(self) -> builtins.bool: ...

    def get_id_column(self) -> builtins.int: ...

    def get_model(self) -> TreeModel: ...

    def get_popup_accessible(self) -> Atk.Object: ...

    def get_popup_fixed_width(self) -> builtins.bool: ...

    def get_row_span_column(self) -> builtins.int: ...

    def get_title(self) -> builtins.str: ...

    def get_wrap_width(self) -> builtins.int: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_area(area: CellArea) -> Widget: ...

    @staticmethod
    def new_with_area_and_entry(area: CellArea) -> Widget: ...

    @staticmethod
    def new_with_entry() -> Widget: ...

    @staticmethod
    def new_with_model(model: TreeModel) -> Widget: ...

    @staticmethod
    def new_with_model_and_entry(model: TreeModel) -> Widget: ...

    def popdown(self) -> None: ...

    def popup(self) -> None: ...

    def popup_for_device(self, device: Gdk.Device) -> None: ...

    def set_active(self, index_: builtins.int) -> None: ...

    def set_active_id(self, active_id: typing.Optional[builtins.str]) -> builtins.bool: ...

    def set_active_iter(self, iter: typing.Optional[TreeIter]) -> None: ...

    def set_add_tearoffs(self, add_tearoffs: builtins.bool) -> None: ...

    def set_button_sensitivity(self, sensitivity: SensitivityType) -> None: ...

    def set_column_span_column(self, column_span: builtins.int) -> None: ...

    def set_entry_text_column(self, text_column: builtins.int) -> None: ...

    def set_focus_on_click(self, focus_on_click: builtins.bool) -> None: ...

    def set_id_column(self, id_column: builtins.int) -> None: ...

    def set_model(self, model: typing.Optional[TreeModel]) -> None: ...

    def set_popup_fixed_width(self, fixed: builtins.bool) -> None: ...

    def set_row_separator_func(self, func: TreeViewRowSeparatorFunc, *data: typing.Optional[builtins.object]) -> None: ...

    def set_row_span_column(self, row_span: builtins.int) -> None: ...

    def set_title(self, title: builtins.str) -> None: ...

    def set_wrap_width(self, width: builtins.int) -> None: ...

    def do_changed(self) -> None: ...

    def do_format_entry_text(self, path: builtins.str) -> builtins.str: ...


class EventBox(Bin):
    bin: Bin

    def get_above_child(self) -> builtins.bool: ...

    def get_visible_window(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    def set_above_child(self, above_child: builtins.bool) -> None: ...

    def set_visible_window(self, visible_window: builtins.bool) -> None: ...


class Expander(Bin):
    bin: Bin

    def __init__(self,
        *,
        label_widget: typing.Optional[Widget] = None,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_expanded(self) -> builtins.bool: ...

    def get_label(self) -> typing.Optional[builtins.str]: ...

    def get_label_fill(self) -> builtins.bool: ...

    def get_label_widget(self) -> typing.Optional[Widget]: ...

    def get_resize_toplevel(self) -> builtins.bool: ...

    def get_spacing(self) -> builtins.int: ...

    def get_use_markup(self) -> builtins.bool: ...

    def get_use_underline(self) -> builtins.bool: ...

    @staticmethod
    def new(label: typing.Optional[builtins.str]) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(label: typing.Optional[builtins.str]) -> Widget: ...

    def set_expanded(self, expanded: builtins.bool) -> None: ...

    def set_label(self, label: typing.Optional[builtins.str]) -> None: ...

    def set_label_fill(self, label_fill: builtins.bool) -> None: ...

    def set_label_widget(self, label_widget: typing.Optional[Widget]) -> None: ...

    def set_resize_toplevel(self, resize_toplevel: builtins.bool) -> None: ...

    def set_spacing(self, spacing: builtins.int) -> None: ...

    def set_use_markup(self, use_markup: builtins.bool) -> None: ...

    def set_use_underline(self, use_underline: builtins.bool) -> None: ...

    def do_activate(self) -> None: ...


class FlowBoxChild(Bin):
    parent_instance: Bin

    def changed(self) -> None: ...

    def get_index(self) -> builtins.int: ...

    def is_selected(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    def do_activate(self) -> None: ...


class Frame(Bin):
    bin: Bin

    def get_label(self) -> typing.Optional[builtins.str]: ...

    def get_label_align(self) -> typing.Tuple[builtins.float, builtins.float]: ...

    def get_label_widget(self) -> typing.Optional[Widget]: ...

    def get_shadow_type(self) -> ShadowType: ...

    @staticmethod
    def new(label: typing.Optional[builtins.str]) -> Widget: ...

    def set_label(self, label: typing.Optional[builtins.str]) -> None: ...

    def set_label_align(self, xalign: builtins.float, yalign: builtins.float) -> None: ...

    def set_label_widget(self, label_widget: typing.Optional[Widget]) -> None: ...

    def set_shadow_type(self, type: ShadowType) -> None: ...

    def do_compute_child_allocation(self, allocation: Gdk.Rectangle) -> None: ...


class HandleBox(Bin):
    bin: Bin

    def get_child_detached(self) -> builtins.bool: ...

    def get_handle_position(self) -> PositionType: ...

    def get_shadow_type(self) -> ShadowType: ...

    def get_snap_edge(self) -> PositionType: ...

    @staticmethod
    def new() -> Widget: ...

    def set_handle_position(self, position: PositionType) -> None: ...

    def set_shadow_type(self, type: ShadowType) -> None: ...

    def set_snap_edge(self, edge: PositionType) -> None: ...

    def do_child_attached(self, child: Widget) -> None: ...

    def do_child_detached(self, child: Widget) -> None: ...


class ListBoxRow(Bin, Actionable):
    parent_instance: Bin

    def changed(self) -> None: ...

    def get_activatable(self) -> builtins.bool: ...

    def get_header(self) -> typing.Optional[Widget]: ...

    def get_index(self) -> builtins.int: ...

    def get_selectable(self) -> builtins.bool: ...

    def is_selected(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    def set_activatable(self, activatable: builtins.bool) -> None: ...

    def set_header(self, header: typing.Optional[Widget]) -> None: ...

    def set_selectable(self, selectable: builtins.bool) -> None: ...

    def do_activate(self) -> None: ...


class MenuItem(Bin, Actionable, Activatable):
    bin: Bin

    def __init__(self,
        *,
        label: str = "",
        use_underline: bool = False,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def activate(self) -> None: ...  # type: ignore

    def deselect(self) -> None: ...

    def get_accel_path(self) -> typing.Optional[builtins.str]: ...

    def get_label(self) -> builtins.str: ...

    def get_reserve_indicator(self) -> builtins.bool: ...

    def get_right_justified(self) -> builtins.bool: ...

    def get_submenu(self) -> typing.Optional[Widget]: ...

    def get_use_underline(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_label(label: builtins.str) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(label: builtins.str) -> MenuItem: ...

    def select(self) -> None: ...

    def set_accel_path(self, accel_path: typing.Optional[builtins.str]) -> None: ...  # type: ignore

    def set_label(self, label: builtins.str) -> None: ...

    def set_reserve_indicator(self, reserve: builtins.bool) -> None: ...

    def set_right_justified(self, right_justified: builtins.bool) -> None: ...

    def set_submenu(self, submenu: typing.Optional[Menu]) -> None: ...

    def set_use_underline(self, setting: builtins.bool) -> None: ...

    def toggle_size_allocate(self, allocation: builtins.int) -> None: ...

    def toggle_size_request(self, requisition: builtins.int) -> builtins.int: ...

    def do_activate(self) -> None: ...

    def do_activate_item(self) -> None: ...

    def do_deselect(self) -> None: ...

    def do_get_label(self) -> builtins.str: ...

    def do_select(self) -> None: ...

    def do_set_label(self, label: builtins.str) -> None: ...

    def do_toggle_size_allocate(self, allocation: builtins.int) -> None: ...

    def do_toggle_size_request(self, requisition: builtins.int) -> builtins.int: ...


class Overlay(Bin):
    parent: Bin

    def add_overlay(self, widget: Widget) -> None: ...

    def get_overlay_pass_through(self, widget: Widget) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    def reorder_overlay(self, child: Widget, index_: builtins.int) -> None: ...

    def set_overlay_pass_through(self, widget: Widget, pass_through: builtins.bool) -> None: ...

    def do_get_child_position(self, widget: Widget, allocation: Gdk.Rectangle) -> builtins.bool: ...


class Popover(Bin):
    parent_instance: Bin

    def bind_model(self, model: typing.Optional[Gio.MenuModel], action_namespace: typing.Optional[builtins.str]) -> None: ...

    def get_constrain_to(self) -> PopoverConstraint: ...

    def get_default_widget(self) -> typing.Optional[Widget]: ...

    def get_modal(self) -> builtins.bool: ...

    def get_pointing_to(self) -> typing.Tuple[builtins.bool, Gdk.Rectangle]: ...

    def get_position(self) -> PositionType: ...

    def get_relative_to(self) -> Widget: ...

    def get_transitions_enabled(self) -> builtins.bool: ...

    @staticmethod
    def new(relative_to: typing.Optional[Widget]) -> Widget: ...

    @staticmethod
    def new_from_model(relative_to: typing.Optional[Widget], model: Gio.MenuModel) -> Widget: ...

    def popdown(self) -> None: ...

    def popup(self) -> None: ...

    def set_constrain_to(self, constraint: PopoverConstraint) -> None: ...

    def set_default_widget(self, widget: typing.Optional[Widget]) -> None: ...

    def set_modal(self, modal: builtins.bool) -> None: ...

    def set_pointing_to(self, rect: Gdk.Rectangle) -> None: ...

    def set_position(self, position: PositionType) -> None: ...

    def set_relative_to(self, relative_to: typing.Optional[Widget]) -> None: ...

    def set_transitions_enabled(self, transitions_enabled: builtins.bool) -> None: ...

    def do_closed(self) -> None: ...


class Revealer(Bin):
    parent_instance: Bin

    def get_child_revealed(self) -> builtins.bool: ...

    def get_reveal_child(self) -> builtins.bool: ...

    def get_transition_duration(self) -> builtins.int: ...

    def get_transition_type(self) -> RevealerTransitionType: ...

    @staticmethod
    def new() -> Widget: ...

    def set_reveal_child(self, reveal_child: builtins.bool) -> None: ...

    def set_transition_duration(self, duration: builtins.int) -> None: ...

    def set_transition_type(self, transition: RevealerTransitionType) -> None: ...


class ScrolledWindow(Bin):
    container: Bin

    class _Props(Bin._Props):
        hscrollbar_policy: PolicyType
        overlay_scrolling: bool
        shadow_type: ShadowType
        vscrollbar_policy: PolicyType

    props: _Props

    def __init__(self,
        *,
        hscrollbar_policy: PolicyType = PolicyType.AUTOMATIC,
        overlay_scrolling: bool = True,
        shadow_type: ShadowType = ShadowType.NONE,
        vscrollbar_policy: PolicyType = PolicyType.AUTOMATIC,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def add_with_viewport(self, child: Widget) -> None: ...

    def get_capture_button_press(self) -> builtins.bool: ...

    def get_hadjustment(self) -> Adjustment: ...

    def get_hscrollbar(self) -> Widget: ...

    def get_kinetic_scrolling(self) -> builtins.bool: ...

    def get_max_content_height(self) -> builtins.int: ...

    def get_max_content_width(self) -> builtins.int: ...

    def get_min_content_height(self) -> builtins.int: ...

    def get_min_content_width(self) -> builtins.int: ...

    def get_overlay_scrolling(self) -> builtins.bool: ...

    def get_placement(self) -> CornerType: ...

    def get_policy(self) -> typing.Tuple[PolicyType, PolicyType]: ...

    def get_propagate_natural_height(self) -> builtins.bool: ...

    def get_propagate_natural_width(self) -> builtins.bool: ...

    def get_shadow_type(self) -> ShadowType: ...

    def get_vadjustment(self) -> Adjustment: ...

    def get_vscrollbar(self) -> Widget: ...

    @staticmethod
    def new(hadjustment: typing.Optional[Adjustment], vadjustment: typing.Optional[Adjustment]) -> Widget: ...

    def set_capture_button_press(self, capture_button_press: builtins.bool) -> None: ...

    def set_hadjustment(self, hadjustment: typing.Optional[Adjustment]) -> None: ...

    def set_kinetic_scrolling(self, kinetic_scrolling: builtins.bool) -> None: ...

    def set_max_content_height(self, height: builtins.int) -> None: ...

    def set_max_content_width(self, width: builtins.int) -> None: ...

    def set_min_content_height(self, height: builtins.int) -> None: ...

    def set_min_content_width(self, width: builtins.int) -> None: ...

    def set_overlay_scrolling(self, overlay_scrolling: builtins.bool) -> None: ...

    def set_placement(self, window_placement: CornerType) -> None: ...

    def set_policy(self, hscrollbar_policy: PolicyType, vscrollbar_policy: PolicyType) -> None: ...

    def set_propagate_natural_height(self, propagate: builtins.bool) -> None: ...

    def set_propagate_natural_width(self, propagate: builtins.bool) -> None: ...

    def set_shadow_type(self, type: ShadowType) -> None: ...

    def set_vadjustment(self, vadjustment: typing.Optional[Adjustment]) -> None: ...

    def unset_placement(self) -> None: ...

    def do_move_focus_out(self, direction: DirectionType) -> None: ...

    def do_scroll_child(self, scroll: ScrollType, horizontal: builtins.bool) -> builtins.bool: ...


class SearchBar(Bin):
    parent: Bin

    def connect_entry(self, entry: Entry) -> None: ...

    def get_search_mode(self) -> builtins.bool: ...

    def get_show_close_button(self) -> builtins.bool: ...

    def handle_event(self, event: Gdk.Event) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    def set_search_mode(self, search_mode: builtins.bool) -> None: ...

    def set_show_close_button(self, visible: builtins.bool) -> None: ...


class StackSidebar(Bin):
    parent: Bin

    def get_stack(self) -> typing.Optional[Stack]: ...

    @staticmethod
    def new() -> Widget: ...

    def set_stack(self, stack: Stack) -> None: ...


class ToolItem(Bin, Activatable):
    parent: Bin

    def get_ellipsize_mode(self) -> Pango.EllipsizeMode: ...

    def get_expand(self) -> builtins.bool: ...

    def get_homogeneous(self) -> builtins.bool: ...

    def get_icon_size(self) -> builtins.int: ...

    def get_is_important(self) -> builtins.bool: ...

    def get_orientation(self) -> Orientation: ...

    def get_proxy_menu_item(self, menu_item_id: builtins.str) -> typing.Optional[Widget]: ...

    def get_relief_style(self) -> ReliefStyle: ...

    def get_text_alignment(self) -> builtins.float: ...

    def get_text_orientation(self) -> Orientation: ...

    def get_text_size_group(self) -> SizeGroup: ...

    def get_toolbar_style(self) -> ToolbarStyle: ...

    def get_use_drag_window(self) -> builtins.bool: ...

    def get_visible_horizontal(self) -> builtins.bool: ...

    def get_visible_vertical(self) -> builtins.bool: ...

    @staticmethod
    def new() -> ToolItem: ...

    def rebuild_menu(self) -> None: ...

    def retrieve_proxy_menu_item(self) -> Widget: ...

    def set_expand(self, expand: builtins.bool) -> None: ...

    def set_homogeneous(self, homogeneous: builtins.bool) -> None: ...

    def set_is_important(self, is_important: builtins.bool) -> None: ...

    def set_proxy_menu_item(self, menu_item_id: builtins.str, menu_item: typing.Optional[Widget]) -> None: ...

    def set_tooltip_markup(self, markup: builtins.str) -> None: ...  # type: ignore

    def set_tooltip_text(self, text: builtins.str) -> None: ...  # type: ignore

    def set_use_drag_window(self, use_drag_window: builtins.bool) -> None: ...

    def set_visible_horizontal(self, visible_horizontal: builtins.bool) -> None: ...

    def set_visible_vertical(self, visible_vertical: builtins.bool) -> None: ...

    def toolbar_reconfigured(self) -> None: ...

    def do_create_menu_proxy(self) -> builtins.bool: ...

    def do_toolbar_reconfigured(self) -> None: ...


class Viewport(Bin, Scrollable):
    bin: Bin

    def __init__(self,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_bin_window(self) -> Gdk.Window: ...

    def get_hadjustment(self) -> Adjustment: ...

    def get_shadow_type(self) -> ShadowType: ...

    def get_vadjustment(self) -> Adjustment: ...

    def get_view_window(self) -> Gdk.Window: ...

    @staticmethod
    def new(hadjustment: typing.Optional[Adjustment], vadjustment: typing.Optional[Adjustment]) -> Widget: ...

    def set_hadjustment(self, adjustment: typing.Optional[Adjustment]) -> None: ...

    def set_shadow_type(self, type: ShadowType) -> None: ...

    def set_vadjustment(self, adjustment: typing.Optional[Adjustment]) -> None: ...


class Window(Bin):
    bin: Bin

    class _Props(Bin._Props):
        application: typing.Optional[Application]
        default_height: int
        default_width: int
        icon_name: typing.Optional[str]
        modal: bool
        resizable: bool
        skip_taskbar_hint: bool
        title: typing.Optional[str]
        type_hint: Gdk.WindowTypeHint
        window_position: WindowPosition

    props: _Props

    def __init__(self,
        *,
        application: typing.Optional[Application] = None,
        default_height: int = -1,
        default_width: int = -1,
        icon_name: typing.Optional[str] = None,
        modal: bool = False,
        resizable: bool = True,
        skip_taskbar_hint: bool = False,
        title: typing.Optional[str] = None,
        type_hint: Gdk.WindowTypeHint = Gdk.WindowTypeHint.NORMAL,
        window_position: WindowPosition = WindowPosition.NONE,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def activate_default(self) -> builtins.bool: ...

    def activate_focus(self) -> builtins.bool: ...

    def activate_key(self, event: Gdk.EventKey) -> builtins.bool: ...

    def add_accel_group(self, accel_group: AccelGroup) -> None: ...

    def add_mnemonic(self, keyval: builtins.int, target: Widget) -> None: ...

    def begin_move_drag(self, button: builtins.int, root_x: builtins.int, root_y: builtins.int, timestamp: builtins.int) -> None: ...

    def begin_resize_drag(self, edge: Gdk.WindowEdge, button: builtins.int, root_x: builtins.int, root_y: builtins.int, timestamp: builtins.int) -> None: ...

    def close(self) -> None: ...

    def deiconify(self) -> None: ...

    def fullscreen(self) -> None: ...

    def fullscreen_on_monitor(self, screen: Gdk.Screen, monitor: builtins.int) -> None: ...

    def get_accept_focus(self) -> builtins.bool: ...

    def get_application(self) -> typing.Optional[Application]: ...

    def get_attached_to(self) -> typing.Optional[Widget]: ...

    def get_decorated(self) -> builtins.bool: ...

    @staticmethod
    def get_default_icon_list() -> typing.Sequence[GdkPixbuf.Pixbuf]: ...

    @staticmethod
    def get_default_icon_name() -> builtins.str: ...

    def get_default_size(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_default_widget(self) -> typing.Optional[Widget]: ...

    def get_deletable(self) -> builtins.bool: ...

    def get_destroy_with_parent(self) -> builtins.bool: ...

    def get_focus(self) -> typing.Optional[Widget]: ...

    def get_focus_on_map(self) -> builtins.bool: ...

    def get_focus_visible(self) -> builtins.bool: ...

    def get_gravity(self) -> Gdk.Gravity: ...

    def get_group(self) -> WindowGroup: ...

    def get_has_resize_grip(self) -> builtins.bool: ...

    def get_hide_titlebar_when_maximized(self) -> builtins.bool: ...

    def get_icon(self) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def get_icon_list(self) -> typing.Sequence[GdkPixbuf.Pixbuf]: ...

    def get_icon_name(self) -> typing.Optional[builtins.str]: ...

    def get_mnemonic_modifier(self) -> Gdk.ModifierType: ...

    def get_mnemonics_visible(self) -> builtins.bool: ...

    def get_modal(self) -> builtins.bool: ...

    def get_opacity(self) -> builtins.float: ...

    def get_position(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_resizable(self) -> builtins.bool: ...

    def get_resize_grip_area(self) -> typing.Tuple[builtins.bool, Gdk.Rectangle]: ...

    def get_role(self) -> typing.Optional[builtins.str]: ...

    def get_screen(self) -> Gdk.Screen: ...

    def get_size(self) -> typing.Tuple[builtins.int, builtins.int]: ...

    def get_skip_pager_hint(self) -> builtins.bool: ...

    def get_skip_taskbar_hint(self) -> builtins.bool: ...

    def get_title(self) -> typing.Optional[builtins.str]: ...

    def get_titlebar(self) -> typing.Optional[Widget]: ...

    def get_transient_for(self) -> typing.Optional[Window]: ...

    def get_type_hint(self) -> Gdk.WindowTypeHint: ...

    def get_urgency_hint(self) -> builtins.bool: ...

    def get_window_type(self) -> WindowType: ...

    def has_group(self) -> builtins.bool: ...

    def has_toplevel_focus(self) -> builtins.bool: ...

    def iconify(self) -> None: ...

    def is_active(self) -> builtins.bool: ...

    def is_maximized(self) -> builtins.bool: ...

    @staticmethod
    def list_toplevels() -> typing.Sequence[Widget]: ...

    def maximize(self) -> None: ...

    def mnemonic_activate(self, keyval: builtins.int, modifier: Gdk.ModifierType) -> builtins.bool: ...  # type: ignore

    def move(self, x: builtins.int, y: builtins.int) -> None: ...

    @staticmethod
    def new(type: WindowType) -> Widget: ...

    def parse_geometry(self, geometry: builtins.str) -> builtins.bool: ...

    def present(self) -> None: ...

    def present_with_time(self, timestamp: builtins.int) -> None: ...

    def propagate_key_event(self, event: Gdk.EventKey) -> builtins.bool: ...

    def remove_accel_group(self, accel_group: AccelGroup) -> None: ...

    def remove_mnemonic(self, keyval: builtins.int, target: Widget) -> None: ...

    def reshow_with_initial_size(self) -> None: ...

    def resize(self, width: builtins.int, height: builtins.int) -> None: ...

    def resize_grip_is_visible(self) -> builtins.bool: ...

    def resize_to_geometry(self, width: builtins.int, height: builtins.int) -> None: ...

    def set_accept_focus(self, setting: builtins.bool) -> None: ...

    def set_application(self, application: typing.Optional[Application]) -> None: ...

    def set_attached_to(self, attach_widget: typing.Optional[Widget]) -> None: ...

    @staticmethod
    def set_auto_startup_notification(setting: builtins.bool) -> None: ...

    def set_decorated(self, setting: builtins.bool) -> None: ...

    def set_default(self, default_widget: typing.Optional[Widget]) -> None: ...

    def set_default_geometry(self, width: builtins.int, height: builtins.int) -> None: ...

    @staticmethod
    def set_default_icon(icon: GdkPixbuf.Pixbuf) -> None: ...

    @staticmethod
    def set_default_icon_from_file(filename: builtins.str) -> builtins.bool: ...

    @staticmethod
    def set_default_icon_list(list: typing.Sequence[GdkPixbuf.Pixbuf]) -> None: ...

    @staticmethod
    def set_default_icon_name(name: builtins.str) -> None: ...

    def set_default_size(self, width: builtins.int, height: builtins.int) -> None: ...

    def set_deletable(self, setting: builtins.bool) -> None: ...

    def set_destroy_with_parent(self, setting: builtins.bool) -> None: ...

    def set_focus(self, focus: typing.Optional[Widget]) -> None: ...

    def set_focus_on_map(self, setting: builtins.bool) -> None: ...

    def set_focus_visible(self, setting: builtins.bool) -> None: ...

    def set_geometry_hints(self, geometry_widget: typing.Optional[Widget], geometry: typing.Optional[Gdk.Geometry], geom_mask: Gdk.WindowHints) -> None: ...

    def set_gravity(self, gravity: Gdk.Gravity) -> None: ...

    def set_has_resize_grip(self, value: builtins.bool) -> None: ...

    def set_has_user_ref_count(self, setting: builtins.bool) -> None: ...

    def set_hide_titlebar_when_maximized(self, setting: builtins.bool) -> None: ...

    def set_icon(self, icon: typing.Optional[GdkPixbuf.Pixbuf]) -> None: ...

    def set_icon_from_file(self, filename: builtins.str) -> builtins.bool: ...

    def set_icon_list(self, list: typing.Sequence[GdkPixbuf.Pixbuf]) -> None: ...

    def set_icon_name(self, name: typing.Optional[builtins.str]) -> None: ...

    @staticmethod
    def set_interactive_debugging(enable: builtins.bool) -> None: ...

    def set_keep_above(self, setting: builtins.bool) -> None: ...

    def set_keep_below(self, setting: builtins.bool) -> None: ...

    def set_mnemonic_modifier(self, modifier: Gdk.ModifierType) -> None: ...

    def set_mnemonics_visible(self, setting: builtins.bool) -> None: ...

    def set_modal(self, modal: builtins.bool) -> None: ...

    def set_opacity(self, opacity: builtins.float) -> None: ...

    def set_position(self, position: WindowPosition) -> None: ...

    def set_resizable(self, resizable: builtins.bool) -> None: ...

    def set_role(self, role: builtins.str) -> None: ...

    def set_screen(self, screen: Gdk.Screen) -> None: ...

    def set_skip_pager_hint(self, setting: builtins.bool) -> None: ...

    def set_skip_taskbar_hint(self, setting: builtins.bool) -> None: ...

    def set_startup_id(self, startup_id: builtins.str) -> None: ...

    def set_title(self, title: builtins.str) -> None: ...

    def set_titlebar(self, titlebar: typing.Optional[Widget]) -> None: ...

    def set_transient_for(self, parent: typing.Optional[Window]) -> None: ...

    def set_type_hint(self, hint: Gdk.WindowTypeHint) -> None: ...

    def set_urgency_hint(self, setting: builtins.bool) -> None: ...

    def set_wmclass(self, wmclass_name: builtins.str, wmclass_class: builtins.str) -> None: ...

    def stick(self) -> None: ...

    def unfullscreen(self) -> None: ...

    def unmaximize(self) -> None: ...

    def unstick(self) -> None: ...

    def do_activate_default(self) -> None: ...

    def do_activate_focus(self) -> None: ...

    def do_enable_debugging(self, toggle: builtins.bool) -> builtins.bool: ...

    def do_keys_changed(self) -> None: ...

    def do_set_focus(self, focus: typing.Optional[Widget]) -> None: ...


class AppChooserWidget(Box, AppChooser):
    parent: Box

    def get_default_text(self) -> builtins.str: ...

    def get_show_all(self) -> builtins.bool: ...

    def get_show_default(self) -> builtins.bool: ...

    def get_show_fallback(self) -> builtins.bool: ...

    def get_show_other(self) -> builtins.bool: ...

    def get_show_recommended(self) -> builtins.bool: ...

    @staticmethod
    def new(content_type: builtins.str) -> Widget: ...  # type: ignore

    def set_default_text(self, text: builtins.str) -> None: ...

    def set_show_all(self, setting: builtins.bool) -> None: ...

    def set_show_default(self, setting: builtins.bool) -> None: ...

    def set_show_fallback(self, setting: builtins.bool) -> None: ...

    def set_show_other(self, setting: builtins.bool) -> None: ...

    def set_show_recommended(self, setting: builtins.bool) -> None: ...

    def do_application_activated(self, app_info: Gio.AppInfo) -> None: ...

    def do_application_selected(self, app_info: Gio.AppInfo) -> None: ...

    def do_populate_popup(self, menu: Menu, app_info: Gio.AppInfo) -> None: ...


class ButtonBox(Box):
    box: Box

    def get_child_non_homogeneous(self, child: Widget) -> builtins.bool: ...

    def get_child_secondary(self, child: Widget) -> builtins.bool: ...

    def get_layout(self) -> ButtonBoxStyle: ...

    @staticmethod
    def new(orientation: Orientation) -> Widget: ...  # type: ignore

    def set_child_non_homogeneous(self, child: Widget, non_homogeneous: builtins.bool) -> None: ...

    def set_child_secondary(self, child: Widget, is_secondary: builtins.bool) -> None: ...

    def set_layout(self, layout_style: ButtonBoxStyle) -> None: ...


class ColorChooserWidget(Box, ColorChooser):
    parent_instance: Box

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class ColorSelection(Box):
    parent_instance: Box

    def get_current_alpha(self) -> builtins.int: ...

    def get_current_color(self) -> Gdk.Color: ...

    def get_current_rgba(self) -> Gdk.RGBA: ...

    def get_has_opacity_control(self) -> builtins.bool: ...

    def get_has_palette(self) -> builtins.bool: ...

    def get_previous_alpha(self) -> builtins.int: ...

    def get_previous_color(self) -> Gdk.Color: ...

    def get_previous_rgba(self) -> Gdk.RGBA: ...

    def is_adjusting(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    @staticmethod
    def palette_from_string(str: builtins.str) -> typing.Tuple[builtins.bool, typing.Sequence[Gdk.Color]]: ...

    @staticmethod
    def palette_to_string(colors: typing.Sequence[Gdk.Color]) -> builtins.str: ...

    def set_current_alpha(self, alpha: builtins.int) -> None: ...

    def set_current_color(self, color: Gdk.Color) -> None: ...

    def set_current_rgba(self, rgba: Gdk.RGBA) -> None: ...

    def set_has_opacity_control(self, has_opacity: builtins.bool) -> None: ...

    def set_has_palette(self, has_palette: builtins.bool) -> None: ...

    def set_previous_alpha(self, alpha: builtins.int) -> None: ...

    def set_previous_color(self, color: Gdk.Color) -> None: ...

    def set_previous_rgba(self, rgba: Gdk.RGBA) -> None: ...

    def do_color_changed(self) -> None: ...


class FileChooserButton(Box, FileChooser):
    parent: Box

    def get_focus_on_click(self) -> builtins.bool: ...

    def get_title(self) -> builtins.str: ...

    def get_width_chars(self) -> builtins.int: ...

    @staticmethod
    def new(title: builtins.str, action: FileChooserAction) -> Widget: ...  # type: ignore

    @staticmethod
    def new_with_dialog(dialog: Dialog) -> Widget: ...

    def set_focus_on_click(self, focus_on_click: builtins.bool) -> None: ...

    def set_title(self, title: builtins.str) -> None: ...

    def set_width_chars(self, n_chars: builtins.int) -> None: ...

    def do_file_set(self) -> None: ...


class FileChooserWidget(Box, FileChooser):
    parent_instance: Box

    @staticmethod
    def new(action: FileChooserAction) -> Widget: ...  # type: ignore


class FontChooserWidget(Box, FontChooser):
    parent_instance: Box

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class FontSelection(Box):
    parent_instance: Box

    def get_face(self) -> Pango.FontFace: ...

    def get_face_list(self) -> Widget: ...

    def get_family(self) -> Pango.FontFamily: ...

    def get_family_list(self) -> Widget: ...

    def get_font_name(self) -> builtins.str: ...

    def get_preview_entry(self) -> Widget: ...

    def get_preview_text(self) -> builtins.str: ...

    def get_size(self) -> builtins.int: ...

    def get_size_entry(self) -> Widget: ...

    def get_size_list(self) -> Widget: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    def set_font_name(self, fontname: builtins.str) -> builtins.bool: ...

    def set_preview_text(self, text: builtins.str) -> None: ...


class HBox(Box):
    box: Box

    @staticmethod
    def new(homogeneous: builtins.bool, spacing: builtins.int) -> Widget: ...  # type: ignore


class InfoBar(Box):
    parent: Box

    def __init__(self,
        *,
        show_close_button: bool = False,
        # Box
        homogeneous: bool = False,
        spacing: int = 0,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
        # Orientable
        orientation: Orientation = Orientation.HORIZONTAL,
    ) -> None: ...

    def add_action_widget(self, child: Widget, response_id: builtins.int) -> None: ...

    def add_button(self, button_text: builtins.str, response_id: builtins.int) -> Button: ...

    def get_action_area(self) -> Box: ...

    def get_content_area(self) -> Box: ...

    def get_message_type(self) -> MessageType: ...

    def get_revealed(self) -> builtins.bool: ...

    def get_show_close_button(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    def response(self, response_id: builtins.int) -> None: ...

    def set_default_response(self, response_id: builtins.int) -> None: ...

    def set_message_type(self, message_type: MessageType) -> None: ...

    def set_response_sensitive(self, response_id: builtins.int, setting: builtins.bool) -> None: ...

    def set_revealed(self, revealed: builtins.bool) -> None: ...

    def set_show_close_button(self, setting: builtins.bool) -> None: ...

    def do_close(self) -> None: ...

    def do_response(self, response_id: builtins.int) -> None: ...


class RecentChooserWidget(Box, RecentChooser):
    parent_instance: Box

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    @staticmethod
    def new_for_manager(manager: RecentManager) -> Widget: ...


class ShortcutLabel(Box):

    def get_accelerator(self) -> typing.Optional[builtins.str]: ...

    def get_disabled_text(self) -> typing.Optional[builtins.str]: ...

    @staticmethod
    def new(accelerator: builtins.str) -> Widget: ...  # type: ignore

    def set_accelerator(self, accelerator: builtins.str) -> None: ...

    def set_disabled_text(self, disabled_text: builtins.str) -> None: ...


class ShortcutsGroup(Box):
    ...


class ShortcutsSection(Box):
    ...


class ShortcutsShortcut(Box):
    ...


class StackSwitcher(Box):
    widget: Box

    def get_stack(self) -> typing.Optional[Stack]: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    def set_stack(self, stack: typing.Optional[Stack]) -> None: ...


class Statusbar(Box):
    parent_widget: Box

    def get_context_id(self, context_description: builtins.str) -> builtins.int: ...

    def get_message_area(self) -> Box: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    def pop(self, context_id: builtins.int) -> None: ...

    def push(self, context_id: builtins.int, text: builtins.str) -> builtins.int: ...

    def remove(self, context_id: builtins.int, message_id: builtins.int) -> None: ...  # type: ignore

    def remove_all(self, context_id: builtins.int) -> None: ...

    def do_text_popped(self, context_id: builtins.int, text: builtins.str) -> None: ...

    def do_text_pushed(self, context_id: builtins.int, text: builtins.str) -> None: ...


class VBox(Box):
    box: Box

    @staticmethod
    def new(homogeneous: builtins.bool, spacing: builtins.int) -> Widget: ...  # type: ignore


class Menu(MenuShell):
    menu_shell: MenuShell

    def attach(self, child: Widget, left_attach: builtins.int, right_attach: builtins.int, top_attach: builtins.int, bottom_attach: builtins.int) -> None: ...

    def attach_to_widget(self, attach_widget: Widget, detacher: typing.Optional[MenuDetachFunc]) -> None: ...

    def detach(self) -> None: ...

    def get_accel_group(self) -> AccelGroup: ...

    def get_accel_path(self) -> builtins.str: ...

    def get_active(self) -> Widget: ...

    def get_attach_widget(self) -> Widget: ...

    @staticmethod
    def get_for_attach_widget(widget: Widget) -> typing.Sequence[Widget]: ...

    def get_monitor(self) -> builtins.int: ...

    def get_reserve_toggle_size(self) -> builtins.bool: ...

    def get_tearoff_state(self) -> builtins.bool: ...

    def get_title(self) -> builtins.str: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_from_model(model: Gio.MenuModel) -> Widget: ...

    def place_on_monitor(self, monitor: Gdk.Monitor) -> None: ...

    def popdown(self) -> None: ...

    def popup(self, parent_menu_shell: typing.Optional[Widget], parent_menu_item: typing.Optional[Widget], func: typing.Optional[MenuPositionFunc], data: typing.Optional[builtins.object], button: builtins.int, activate_time: builtins.int) -> None: ...

    def popup_at_pointer(self, trigger_event: typing.Optional[Gdk.Event]) -> None: ...

    def popup_at_rect(self, rect_window: Gdk.Window, rect: Gdk.Rectangle, rect_anchor: Gdk.Gravity, menu_anchor: Gdk.Gravity, trigger_event: typing.Optional[Gdk.Event] = None) -> None: ...

    def popup_at_widget(self, widget: Widget, widget_anchor: Gdk.Gravity, menu_anchor: Gdk.Gravity, trigger_event: typing.Optional[Gdk.Event]) -> None: ...

    def popup_for_device(self, device: typing.Optional[Gdk.Device], parent_menu_shell: typing.Optional[Widget], parent_menu_item: typing.Optional[Widget], func: typing.Optional[MenuPositionFunc], data: typing.Optional[builtins.object], button: builtins.int, activate_time: builtins.int) -> None: ...

    def reorder_child(self, child: Widget, position: builtins.int) -> None: ...

    def reposition(self) -> None: ...

    def set_accel_group(self, accel_group: typing.Optional[AccelGroup]) -> None: ...

    def set_accel_path(self, accel_path: typing.Optional[builtins.str]) -> None: ...  # type: ignore

    def set_active(self, index: builtins.int) -> None: ...

    def set_monitor(self, monitor_num: builtins.int) -> None: ...

    def set_reserve_toggle_size(self, reserve_toggle_size: builtins.bool) -> None: ...

    def set_screen(self, screen: typing.Optional[Gdk.Screen]) -> None: ...

    def set_tearoff_state(self, torn_off: builtins.bool) -> None: ...

    def set_title(self, title: typing.Optional[builtins.str]) -> None: ...


class MenuBar(MenuShell):
    menu_shell: MenuShell

    def get_child_pack_direction(self) -> PackDirection: ...

    def get_pack_direction(self) -> PackDirection: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_from_model(model: Gio.MenuModel) -> Widget: ...

    def set_child_pack_direction(self, child_pack_dir: PackDirection) -> None: ...

    def set_pack_direction(self, pack_dir: PackDirection) -> None: ...


class HPaned(Paned):
    paned: Paned

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class VPaned(Paned):
    paned: Paned

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class AccelLabel(Label):
    label: Label

    def get_accel(self) -> typing.Tuple[builtins.int, Gdk.ModifierType]: ...

    def get_accel_widget(self) -> typing.Optional[Widget]: ...

    def get_accel_width(self) -> builtins.int: ...

    @staticmethod
    def new(string: builtins.str) -> Widget: ...  # type: ignore

    def refetch(self) -> builtins.bool: ...

    def set_accel(self, accelerator_key: builtins.int, accelerator_mods: Gdk.ModifierType) -> None: ...

    def set_accel_closure(self, accel_closure: typing.Optional[GObject.Closure]) -> None: ...

    def set_accel_widget(self, accel_widget: typing.Optional[Widget]) -> None: ...


class HScale(Scale):
    scale: Scale

    @staticmethod
    def new(adjustment: typing.Optional[Adjustment]) -> Widget: ...  # type: ignore

    @staticmethod
    def new_with_range(min: builtins.float, max: builtins.float, step: builtins.float) -> Widget: ...  # type: ignore


class VScale(Scale):
    scale: Scale

    @staticmethod
    def new(adjustment: Adjustment) -> Widget: ...  # type: ignore

    @staticmethod
    def new_with_range(min: builtins.float, max: builtins.float, step: builtins.float) -> Widget: ...  # type: ignore


class HScrollbar(Scrollbar):
    scrollbar: Scrollbar

    @staticmethod
    def new(adjustment: typing.Optional[Adjustment]) -> Widget: ...  # type: ignore


class VScrollbar(Scrollbar):
    scrollbar: Scrollbar

    @staticmethod
    def new(adjustment: typing.Optional[Adjustment]) -> Widget: ...  # type: ignore


class GesturePan(GestureDrag):

    def get_orientation(self) -> Orientation: ...

    @staticmethod
    def new(widget: Widget, orientation: Orientation) -> Gesture: ...  # type: ignore

    def set_orientation(self, orientation: Orientation) -> None: ...


class MenuButtonAccessible(ToggleButtonAccessible):
    parent: ToggleButtonAccessible


class RadioButtonAccessible(ToggleButtonAccessible):
    parent: ToggleButtonAccessible


class RadioMenuItemAccessible(CheckMenuItemAccessible):
    parent: CheckMenuItemAccessible


class ColorButton(Button, ColorChooser):
    button: Button

    def get_alpha(self) -> builtins.int: ...

    def get_color(self) -> Gdk.Color: ...

    def get_title(self) -> builtins.str: ...

    def get_use_alpha(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_color(color: Gdk.Color) -> Widget: ...

    @staticmethod
    def new_with_rgba(rgba: Gdk.RGBA) -> Widget: ...

    def set_alpha(self, alpha: builtins.int) -> None: ...

    def set_color(self, color: Gdk.Color) -> None: ...

    def set_title(self, title: builtins.str) -> None: ...

    def set_use_alpha(self, use_alpha: builtins.bool) -> None: ...

    def do_color_set(self) -> None: ...


class FontButton(Button, FontChooser):
    button: Button

    def get_font_name(self) -> builtins.str: ...

    def get_show_size(self) -> builtins.bool: ...

    def get_show_style(self) -> builtins.bool: ...

    def get_title(self) -> builtins.str: ...

    def get_use_font(self) -> builtins.bool: ...

    def get_use_size(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_font(fontname: builtins.str) -> Widget: ...

    def set_font_name(self, fontname: builtins.str) -> builtins.bool: ...

    def set_show_size(self, show_size: builtins.bool) -> None: ...

    def set_show_style(self, show_style: builtins.bool) -> None: ...

    def set_title(self, title: builtins.str) -> None: ...

    def set_use_font(self, use_font: builtins.bool) -> None: ...

    def set_use_size(self, use_size: builtins.bool) -> None: ...

    def do_font_set(self) -> None: ...


class LinkButton(Button):
    parent_instance: Button

    def get_uri(self) -> builtins.str: ...

    def get_visited(self) -> builtins.bool: ...

    @staticmethod
    def new(uri: builtins.str) -> Widget: ...  # type: ignore

    @staticmethod
    def new_with_label(uri: builtins.str, label: typing.Optional[builtins.str]) -> Widget: ...  # type: ignore

    def set_uri(self, uri: builtins.str) -> None: ...

    def set_visited(self, visited: builtins.bool) -> None: ...

    def do_activate_link(self) -> builtins.bool: ...


class LockButton(Button):
    parent: Button

    def get_permission(self) -> Gio.Permission: ...

    @staticmethod
    def new(permission: typing.Optional[Gio.Permission]) -> Widget: ...  # type: ignore

    def set_permission(self, permission: typing.Optional[Gio.Permission]) -> None: ...


class ModelButton(Button):

    @staticmethod
    def new() -> Widget: ...


class ScaleButton(Button, Orientable):
    parent: Button

    def get_adjustment(self) -> Adjustment: ...

    def get_minus_button(self) -> Button: ...

    def get_plus_button(self) -> Button: ...

    def get_popup(self) -> Widget: ...

    def get_value(self) -> builtins.float: ...

    @staticmethod
    def new(size: builtins.int, min: builtins.float, max: builtins.float, step: builtins.float, icons: typing.Optional[typing.Sequence[builtins.str]]) -> Widget: ...  # type: ignore

    def set_adjustment(self, adjustment: Adjustment) -> None: ...

    def set_icons(self, icons: typing.Sequence[builtins.str]) -> None: ...

    def set_value(self, value: builtins.float) -> None: ...

    def do_value_changed(self, value: builtins.float) -> None: ...


class ToggleButton(Button):
    button: Button

    class _Props(Button._Props):
        active: bool

    props: _Props

    def __init__(self,
        *,
        active: bool = False,
        # Button
        image: typing.Optional[Widget] = None,
        label: typing.Optional[str] = None,
        relief: ReliefStyle = ReliefStyle.NORMAL,
        use_underline: bool = False,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_active(self) -> builtins.bool: ...

    def get_inconsistent(self) -> builtins.bool: ...

    def get_mode(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_label(label: builtins.str) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(label: builtins.str) -> Widget: ...

    def set_active(self, is_active: builtins.bool) -> None: ...

    def set_inconsistent(self, setting: builtins.bool) -> None: ...

    def set_mode(self, draw_indicator: builtins.bool) -> None: ...

    def toggled(self) -> None: ...

    def do_toggled(self) -> None: ...


class AppChooserButton(ComboBox, AppChooser):
    parent: ComboBox

    def append_custom_item(self, name: builtins.str, label: builtins.str, icon: Gio.Icon) -> None: ...

    def append_separator(self) -> None: ...

    def get_heading(self) -> typing.Optional[builtins.str]: ...

    def get_show_default_item(self) -> builtins.bool: ...

    def get_show_dialog_item(self) -> builtins.bool: ...

    @staticmethod
    def new(content_type: builtins.str) -> Widget: ...  # type: ignore

    def set_active_custom_item(self, name: builtins.str) -> None: ...

    def set_heading(self, heading: builtins.str) -> None: ...

    def set_show_default_item(self, setting: builtins.bool) -> None: ...

    def set_show_dialog_item(self, setting: builtins.bool) -> None: ...

    def do_custom_item_activated(self, item_name: builtins.str) -> None: ...


class ComboBoxText(ComboBox):
    parent_instance: ComboBox

    def append(self, id: typing.Optional[builtins.str], text: builtins.str) -> None: ...

    def append_text(self, text: builtins.str) -> None: ...

    def get_active_text(self) -> builtins.str: ...

    def insert(self, position: builtins.int, id: typing.Optional[builtins.str], text: builtins.str) -> None: ...

    def insert_text(self, position: builtins.int, text: builtins.str) -> None: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_entry() -> Widget: ...

    def prepend(self, id: typing.Optional[builtins.str], text: builtins.str) -> None: ...

    def prepend_text(self, text: builtins.str) -> None: ...

    def remove(self, position: builtins.int) -> None: ...  # type: ignore

    def remove_all(self) -> None: ...


class AspectFrame(Frame):
    frame: Frame

    @staticmethod
    def new(label: typing.Optional[builtins.str], xalign: builtins.float, yalign: builtins.float, ratio: builtins.float, obey_child: builtins.bool) -> Widget: ...  # type: ignore

    def set(self, xalign: builtins.float, yalign: builtins.float, ratio: builtins.float, obey_child: builtins.bool) -> None: ...


class CheckMenuItem(MenuItem):
    menu_item: MenuItem

    class _Props(MenuItem._Props):
        active: bool

    props: _Props

    def __init__(self,
        *,
        # MenuItem
        label: str = "",
        use_underline: bool = False,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_active(self) -> builtins.bool: ...

    def get_draw_as_radio(self) -> builtins.bool: ...

    def get_inconsistent(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_label(label: builtins.str) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(label: builtins.str) -> CheckMenuItem: ...

    def set_active(self, is_active: builtins.bool) -> None: ...

    def set_draw_as_radio(self, draw_as_radio: builtins.bool) -> None: ...

    def set_inconsistent(self, setting: builtins.bool) -> None: ...

    def toggled(self) -> None: ...

    def do_draw_indicator(self, cr: cairo.Context) -> None: ...

    def do_toggled(self) -> None: ...


class ImageMenuItem(MenuItem):
    menu_item: MenuItem

    def __init__(self,
        *,
        image: typing.Optional[Widget] = None,
        # MenuItem
        label: str = "",
        use_underline: bool = False,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_always_show_image(self) -> builtins.bool: ...

    def get_image(self) -> Widget: ...

    def get_use_stock(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_from_stock(stock_id: builtins.str, accel_group: typing.Optional[AccelGroup]) -> Widget: ...

    @staticmethod
    def new_with_label(label: builtins.str) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(label: builtins.str) -> ImageMenuItem: ...

    def set_accel_group(self, accel_group: AccelGroup) -> None: ...

    def set_always_show_image(self, always_show: builtins.bool) -> None: ...

    def set_image(self, image: typing.Optional[Widget]) -> None: ...

    def set_use_stock(self, use_stock: builtins.bool) -> None: ...


class SeparatorMenuItem(MenuItem):
    menu_item: MenuItem

    @staticmethod
    def new() -> Widget: ...


class TearoffMenuItem(MenuItem):
    menu_item: MenuItem

    @staticmethod
    def new() -> Widget: ...


class PopoverMenu(Popover):

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    def open_submenu(self, name: builtins.str) -> None: ...


class PlacesSidebar(ScrolledWindow):

    def add_shortcut(self, location: Gio.File) -> None: ...

    def get_local_only(self) -> builtins.bool: ...

    def get_location(self) -> typing.Optional[Gio.File]: ...

    def get_nth_bookmark(self, n: builtins.int) -> typing.Optional[Gio.File]: ...

    def get_open_flags(self) -> PlacesOpenFlags: ...

    def get_show_connect_to_server(self) -> builtins.bool: ...

    def get_show_desktop(self) -> builtins.bool: ...

    def get_show_enter_location(self) -> builtins.bool: ...

    def get_show_other_locations(self) -> builtins.bool: ...

    def get_show_recent(self) -> builtins.bool: ...

    def get_show_starred_location(self) -> builtins.bool: ...

    def get_show_trash(self) -> builtins.bool: ...

    def list_shortcuts(self) -> typing.Sequence[Gio.File]: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    def remove_shortcut(self, location: Gio.File) -> None: ...

    def set_drop_targets_visible(self, visible: builtins.bool, context: Gdk.DragContext) -> None: ...

    def set_local_only(self, local_only: builtins.bool) -> None: ...

    def set_location(self, location: typing.Optional[Gio.File]) -> None: ...

    def set_open_flags(self, flags: PlacesOpenFlags) -> None: ...

    def set_show_connect_to_server(self, show_connect_to_server: builtins.bool) -> None: ...

    def set_show_desktop(self, show_desktop: builtins.bool) -> None: ...

    def set_show_enter_location(self, show_enter_location: builtins.bool) -> None: ...

    def set_show_other_locations(self, show_other_locations: builtins.bool) -> None: ...

    def set_show_recent(self, show_recent: builtins.bool) -> None: ...

    def set_show_starred_location(self, show_starred_location: builtins.bool) -> None: ...

    def set_show_trash(self, show_trash: builtins.bool) -> None: ...


class SeparatorToolItem(ToolItem):
    parent: ToolItem

    def get_draw(self) -> builtins.bool: ...

    @staticmethod
    def new() -> ToolItem: ...

    def set_draw(self, draw: builtins.bool) -> None: ...


class ToolButton(ToolItem, Actionable):
    parent: ToolItem

    class _Props(ToolItem._Props):
        icon_widget: typing.Optional[Widget]
        label: typing.Optional[str]

    props: _Props

    def __init__(self,
        *,
        icon_widget: typing.Optional[Widget],
        label: typing.Optional[str] = None,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_icon_name(self) -> typing.Optional[builtins.str]: ...

    def get_icon_widget(self) -> typing.Optional[Widget]: ...

    def get_label(self) -> typing.Optional[builtins.str]: ...

    def get_label_widget(self) -> typing.Optional[Widget]: ...

    def get_stock_id(self) -> builtins.str: ...

    def get_use_underline(self) -> builtins.bool: ...

    @staticmethod
    def new(icon_widget: typing.Optional[Widget], label: typing.Optional[builtins.str]) -> ToolItem: ...  # type: ignore

    @staticmethod
    def new_from_stock(stock_id: builtins.str) -> ToolItem: ...

    def set_icon_name(self, icon_name: typing.Optional[builtins.str]) -> None: ...

    def set_icon_widget(self, icon_widget: typing.Optional[Widget]) -> None: ...

    def set_label(self, label: typing.Optional[builtins.str]) -> None: ...

    def set_label_widget(self, label_widget: typing.Optional[Widget]) -> None: ...

    def set_stock_id(self, stock_id: typing.Optional[builtins.str]) -> None: ...

    def set_use_underline(self, use_underline: builtins.bool) -> None: ...

    def do_clicked(self) -> None: ...


class ApplicationWindow(Window, Gio.ActionGroup, Gio.ActionMap):
    parent_instance: Window

    def __init__(self,
        *,
        # Window
        application: typing.Optional[Application] = None,
        default_height: int = -1,
        default_width: int = -1,
        icon_name: typing.Optional[str] = None,
        modal: bool = False,
        resizable: bool = True,
        skip_taskbar_hint: bool = False,
        title: typing.Optional[str] = None,
        type_hint: Gdk.WindowTypeHint = Gdk.WindowTypeHint.NORMAL,
        window_position: WindowPosition = WindowPosition.NONE,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def get_help_overlay(self) -> typing.Optional[ShortcutsWindow]: ...

    def get_id(self) -> builtins.int: ...

    def get_show_menubar(self) -> builtins.bool: ...

    @staticmethod
    def new(application: Application) -> Widget: ...  # type: ignore

    def set_help_overlay(self, help_overlay: typing.Optional[ShortcutsWindow]) -> None: ...

    def set_show_menubar(self, show_menubar: builtins.bool) -> None: ...


class Assistant(Window):
    parent: Window

    def add_action_widget(self, child: Widget) -> None: ...

    def append_page(self, page: Widget) -> builtins.int: ...

    def commit(self) -> None: ...

    def get_current_page(self) -> builtins.int: ...

    def get_n_pages(self) -> builtins.int: ...

    def get_nth_page(self, page_num: builtins.int) -> typing.Optional[Widget]: ...

    def get_page_complete(self, page: Widget) -> builtins.bool: ...

    def get_page_has_padding(self, page: Widget) -> builtins.bool: ...

    def get_page_header_image(self, page: Widget) -> GdkPixbuf.Pixbuf: ...

    def get_page_side_image(self, page: Widget) -> GdkPixbuf.Pixbuf: ...

    def get_page_title(self, page: Widget) -> builtins.str: ...

    def get_page_type(self, page: Widget) -> AssistantPageType: ...

    def insert_page(self, page: Widget, position: builtins.int) -> builtins.int: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    def next_page(self) -> None: ...

    def prepend_page(self, page: Widget) -> builtins.int: ...

    def previous_page(self) -> None: ...

    def remove_action_widget(self, child: Widget) -> None: ...

    def remove_page(self, page_num: builtins.int) -> None: ...

    def set_current_page(self, page_num: builtins.int) -> None: ...

    def set_forward_page_func(self, page_func: typing.Optional[AssistantPageFunc], *data: typing.Optional[builtins.object]) -> None: ...

    def set_page_complete(self, page: Widget, complete: builtins.bool) -> None: ...

    def set_page_has_padding(self, page: Widget, has_padding: builtins.bool) -> None: ...

    def set_page_header_image(self, page: Widget, pixbuf: typing.Optional[GdkPixbuf.Pixbuf]) -> None: ...

    def set_page_side_image(self, page: Widget, pixbuf: typing.Optional[GdkPixbuf.Pixbuf]) -> None: ...

    def set_page_title(self, page: Widget, title: builtins.str) -> None: ...

    def set_page_type(self, page: Widget, type: AssistantPageType) -> None: ...

    def update_buttons_state(self) -> None: ...

    def do_apply(self) -> None: ...

    def do_cancel(self) -> None: ...

    def do_close(self) -> None: ...

    def do_prepare(self, page: Widget) -> None: ...


class Dialog(Window):
    window: Window

    @property
    def action_area(self) -> Box: ...

    @property
    def vbox(self) -> Box: ...

    def add_action_widget(self, child: Widget, response_id: builtins.int) -> None: ...

    def add_button(self, button_text: builtins.str, response_id: builtins.int) -> Button: ...

    def add_buttons(self, *args: typing.Any) -> None: ...

    def get_action_area(self) -> Box: ...

    def get_content_area(self) -> Box: ...

    def get_header_bar(self) -> HeaderBar: ...

    def get_response_for_widget(self, widget: Widget) -> builtins.int: ...

    def get_widget_for_response(self, response_id: builtins.int) -> typing.Optional[Widget]: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    def response(self, response_id: builtins.int) -> None: ...

    def run(self) -> builtins.int: ...

    def set_alternative_button_order_from_array(self, new_order: typing.Sequence[builtins.int]) -> None: ...

    def set_default_response(self, response_id: builtins.int) -> None: ...

    def set_response_sensitive(self, response_id: builtins.int, setting: builtins.bool) -> None: ...

    def do_close(self) -> None: ...

    def do_response(self, response_id: builtins.int) -> None: ...


class OffscreenWindow(Window):
    parent_object: Window

    def get_pixbuf(self) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def get_surface(self) -> typing.Optional[cairo.Surface]: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class Plug(Window):
    window: Window

    def construct(self, socket_id: builtins.int) -> None: ...

    def construct_for_display(self, display: Gdk.Display, socket_id: builtins.int) -> None: ...

    def get_embedded(self) -> builtins.bool: ...

    def get_id(self) -> builtins.int: ...

    def get_socket_window(self) -> typing.Optional[Gdk.Window]: ...

    @staticmethod
    def new(socket_id: builtins.int) -> Plug: ...

    @staticmethod
    def new_for_display(display: Gdk.Display, socket_id: builtins.int) -> Widget: ...

    def do_embedded(self) -> None: ...


class ShortcutsWindow(Window):
    window: Window

    def do_close(self) -> None: ...

    def do_search(self) -> None: ...


class HButtonBox(ButtonBox):
    button_box: ButtonBox

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class VButtonBox(ButtonBox):
    button_box: ButtonBox

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class RecentChooserMenu(Menu, Activatable, RecentChooser):
    parent_instance: Menu

    def get_show_numbers(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_for_manager(manager: RecentManager) -> Widget: ...

    def set_show_numbers(self, show_numbers: builtins.bool) -> None: ...


class VolumeButton(ScaleButton):
    parent: ScaleButton

    @staticmethod
    def new() -> Widget: ...  # type: ignore


class CheckButton(ToggleButton):
    toggle_button: ToggleButton

    @staticmethod
    def new() -> Widget: ...

    @staticmethod
    def new_with_label(label: builtins.str) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(label: builtins.str) -> Widget: ...

    def do_draw_indicator(self, cr: cairo.Context) -> None: ...


class MenuButton(ToggleButton):
    parent: ToggleButton

    def get_align_widget(self) -> typing.Optional[Widget]: ...

    def get_direction(self) -> ArrowType: ...  # type: ignore

    def get_menu_model(self) -> typing.Optional[Gio.MenuModel]: ...

    def get_popover(self) -> typing.Optional[Popover]: ...

    def get_popup(self) -> typing.Optional[Menu]: ...

    def get_use_popover(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...

    def set_align_widget(self, align_widget: typing.Optional[Widget]) -> None: ...

    def set_direction(self, direction: ArrowType) -> None: ...  # type: ignore

    def set_menu_model(self, menu_model: typing.Optional[Gio.MenuModel]) -> None: ...

    def set_popover(self, popover: typing.Optional[Widget]) -> None: ...

    def set_popup(self, menu: typing.Optional[Widget]) -> None: ...

    def set_use_popover(self, use_popover: builtins.bool) -> None: ...


class RadioMenuItem(CheckMenuItem):
    check_menu_item: CheckMenuItem

    def get_group(self) -> typing.Sequence[RadioMenuItem]: ...

    def join_group(self, group_source: typing.Optional[RadioMenuItem]) -> None: ...

    @staticmethod
    def new(group: typing.Optional[typing.Sequence[RadioMenuItem]]) -> Widget: ...  # type: ignore

    @staticmethod
    def new_from_widget(group: typing.Optional[RadioMenuItem]) -> Widget: ...

    @staticmethod
    def new_with_label(group: typing.Optional[typing.Sequence[RadioMenuItem]], label: builtins.str) -> RadioMenuItem: ...  # type: ignore

    @staticmethod
    def new_with_label_from_widget(group: typing.Optional[RadioMenuItem], label: typing.Optional[builtins.str]) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(group: typing.Optional[typing.Sequence[RadioMenuItem]], label: builtins.str) -> RadioMenuItem: ...  # type: ignore

    @staticmethod
    def new_with_mnemonic_from_widget(group: typing.Optional[RadioMenuItem], label: typing.Optional[builtins.str]) -> Widget: ...

    def set_group(self, group: typing.Optional[typing.Sequence[RadioMenuItem]]) -> None: ...

    def do_group_changed(self) -> None: ...


class MenuToolButton(ToolButton):
    parent: ToolButton

    def get_menu(self) -> Widget: ...

    @staticmethod
    def new(icon_widget: typing.Optional[Widget], label: typing.Optional[builtins.str]) -> ToolItem: ...  # type: ignore

    @staticmethod
    def new_from_stock(stock_id: builtins.str) -> ToolItem: ...

    def set_arrow_tooltip_markup(self, markup: builtins.str) -> None: ...

    def set_arrow_tooltip_text(self, text: builtins.str) -> None: ...

    def set_menu(self, menu: Widget) -> None: ...

    def do_show_menu(self) -> None: ...


class ToggleToolButton(ToolButton):
    parent: ToolButton

    def get_active(self) -> builtins.bool: ...

    @staticmethod
    def new() -> ToolItem: ...  # type: ignore

    @staticmethod
    def new_from_stock(stock_id: builtins.str) -> ToolItem: ...

    def set_active(self, is_active: builtins.bool) -> None: ...

    def do_toggled(self) -> None: ...


class AboutDialog(Dialog):
    parent_instance: Dialog

    def add_credit_section(self, section_name: builtins.str, people: typing.Sequence[builtins.str]) -> None: ...

    def get_artists(self) -> typing.Sequence[builtins.str]: ...

    def get_authors(self) -> typing.Sequence[builtins.str]: ...

    def get_comments(self) -> builtins.str: ...

    def get_copyright(self) -> builtins.str: ...

    def get_documenters(self) -> typing.Sequence[builtins.str]: ...

    def get_license(self) -> builtins.str: ...

    def get_license_type(self) -> License: ...

    def get_logo(self) -> GdkPixbuf.Pixbuf: ...

    def get_logo_icon_name(self) -> builtins.str: ...

    def get_program_name(self) -> builtins.str: ...

    def get_translator_credits(self) -> builtins.str: ...

    def get_version(self) -> builtins.str: ...

    def get_website(self) -> builtins.str: ...

    def get_website_label(self) -> builtins.str: ...

    def get_wrap_license(self) -> builtins.bool: ...

    @staticmethod
    def new() -> Widget: ...  # type: ignore

    def set_artists(self, artists: typing.Sequence[builtins.str]) -> None: ...

    def set_authors(self, authors: typing.Sequence[builtins.str]) -> None: ...

    def set_comments(self, comments: typing.Optional[builtins.str]) -> None: ...

    def set_copyright(self, copyright: typing.Optional[builtins.str]) -> None: ...

    def set_documenters(self, documenters: typing.Sequence[builtins.str]) -> None: ...

    def set_license(self, license: typing.Optional[builtins.str]) -> None: ...

    def set_license_type(self, license_type: License) -> None: ...

    def set_logo(self, logo: typing.Optional[GdkPixbuf.Pixbuf]) -> None: ...

    def set_logo_icon_name(self, icon_name: typing.Optional[builtins.str]) -> None: ...

    def set_program_name(self, name: builtins.str) -> None: ...

    def set_translator_credits(self, translator_credits: typing.Optional[builtins.str]) -> None: ...

    def set_version(self, version: typing.Optional[builtins.str]) -> None: ...

    def set_website(self, website: typing.Optional[builtins.str]) -> None: ...

    def set_website_label(self, website_label: builtins.str) -> None: ...

    def set_wrap_license(self, wrap_license: builtins.bool) -> None: ...

    def do_activate_link(self, uri: builtins.str) -> builtins.bool: ...


class AppChooserDialog(Dialog, AppChooser):
    parent: Dialog

    def get_heading(self) -> typing.Optional[builtins.str]: ...

    def get_widget(self) -> Widget: ...

    @staticmethod
    def new(parent: typing.Optional[Window], flags: DialogFlags, file: Gio.File) -> Widget: ...  # type: ignore

    @staticmethod
    def new_for_content_type(parent: typing.Optional[Window], flags: DialogFlags, content_type: builtins.str) -> Widget: ...

    def set_heading(self, heading: builtins.str) -> None: ...


class ColorChooserDialog(Dialog, ColorChooser):
    parent_instance: Dialog

    @staticmethod
    def new(title: typing.Optional[builtins.str], parent: typing.Optional[Window]) -> Widget: ...  # type: ignore


class ColorSelectionDialog(Dialog):
    parent_instance: Dialog

    def get_color_selection(self) -> Widget: ...

    @staticmethod
    def new(title: builtins.str) -> Widget: ...  # type: ignore


class FileChooserDialog(Dialog, FileChooser):
    parent_instance: Dialog


class FontChooserDialog(Dialog, FontChooser):
    parent_instance: Dialog

    @staticmethod
    def new(title: typing.Optional[builtins.str], parent: typing.Optional[Window]) -> Widget: ...  # type: ignore


class FontSelectionDialog(Dialog):
    parent_instance: Dialog

    def get_cancel_button(self) -> Widget: ...

    def get_font_name(self) -> builtins.str: ...

    def get_font_selection(self) -> Widget: ...

    def get_ok_button(self) -> Widget: ...

    def get_preview_text(self) -> builtins.str: ...

    @staticmethod
    def new(title: builtins.str) -> Widget: ...  # type: ignore

    def set_font_name(self, fontname: builtins.str) -> builtins.bool: ...

    def set_preview_text(self, text: builtins.str) -> None: ...


class MessageDialog(Dialog):
    parent_instance: Dialog

    class _Props(Dialog._Props):
        secondary_text: typing.Optional[str]
        secondary_use_markup: bool
        text: typing.Optional[str]
        type: MessageType = MessageType.INFO

    props: _Props

    def __init__(self,
        *,
        buttons: ButtonsType = ButtonsType.NONE,
        secondary_text: typing.Optional[str] = None,
        secondary_use_markup: bool = False,
        text: typing.Optional[str] = "",
        type: MessageType = MessageType.INFO,
        # Window
        application: typing.Optional[Application] = None,
        default_height: int = -1,
        default_width: int = -1,
        icon_name: typing.Optional[str] = None,
        modal: bool = False,
        resizable: bool = True,
        skip_taskbar_hint: bool = False,
        title: typing.Optional[str] = None,
        type_hint: Gdk.WindowTypeHint = Gdk.WindowTypeHint.NORMAL,
        window_position: WindowPosition = WindowPosition.NONE,
        # Container
        border_width: int = 0,
        # Widget
        halign: Align = Align.FILL,
        has_tooltip: bool = False,
        height_request: int = -1,
        hexpand: bool = False,
        margin: int = 0,
        margin_left: int = 0,
        name: typing.Optional[str] = None,
        opacity: float = 1,
        parent: typing.Optional[Container] = None,
        receives_default: bool = False,
        sensitive: bool = True,
        tooltip_text: typing.Optional[str] = None,
        valign: Align = Align.FILL,
        vexpand: bool = False,
        visible: bool = False,
        width_request: int = -1,
    ) -> None: ...

    def format_secondary_markup(self, message_format: str, *args: object) -> None: ...

    def format_secondary_text(self, message_format: str, *args: object) -> None: ...

    def get_image(self) -> Widget: ...

    def get_message_area(self) -> Box: ...

    def set_image(self, image: Widget) -> None: ...

    def set_markup(self, str: builtins.str) -> None: ...


class RecentChooserDialog(Dialog, RecentChooser):
    parent_instance: Dialog


class RadioButton(CheckButton):
    check_button: CheckButton

    def get_group(self) -> typing.Sequence[RadioButton]: ...

    def join_group(self, group_source: typing.Optional[RadioButton]) -> None: ...

    @staticmethod
    def new(group: typing.Optional[typing.Sequence[RadioButton]]) -> Widget: ...  # type: ignore

    @staticmethod
    def new_from_widget(radio_group_member: typing.Optional[RadioButton]) -> Widget: ...

    @staticmethod
    def new_with_label(group: typing.Optional[typing.Sequence[RadioButton]], label: builtins.str) -> Widget: ...  # type: ignore

    @staticmethod
    def new_with_label_from_widget(radio_group_member: typing.Optional[RadioButton], label: builtins.str) -> Widget: ...

    @staticmethod
    def new_with_mnemonic(group: typing.Optional[typing.Sequence[RadioButton]], label: builtins.str) -> Widget: ...  # type: ignore

    @staticmethod
    def new_with_mnemonic_from_widget(radio_group_member: typing.Optional[RadioButton], label: builtins.str) -> Widget: ...

    def set_group(self, group: typing.Optional[typing.Sequence[RadioButton]]) -> None: ...

    def do_group_changed(self) -> None: ...


class RadioToolButton(ToggleToolButton):
    parent: ToggleToolButton

    def get_group(self) -> typing.Sequence[RadioButton]: ...

    @staticmethod
    def new(group: typing.Optional[typing.Sequence[RadioButton]]) -> ToolItem: ...  # type: ignore

    @staticmethod
    def new_from_stock(group: typing.Optional[typing.Sequence[RadioButton]], stock_id: builtins.str) -> ToolItem: ...  # type: ignore

    @staticmethod
    def new_from_widget(group: typing.Optional[RadioToolButton]) -> ToolItem: ...

    @staticmethod
    def new_with_stock_from_widget(group: typing.Optional[RadioToolButton], stock_id: builtins.str) -> ToolItem: ...

    def set_group(self, group: typing.Optional[typing.Sequence[RadioButton]]) -> None: ...


class AccelGroupEntry():
    accel_path_quark: builtins.int
    closure: GObject.Closure
    key: AccelKey


class AccelKey():
    accel_flags: builtins.int
    accel_key: builtins.int
    accel_mods: Gdk.ModifierType


class ActionEntry():
    accelerator: builtins.str
    callback: GObject.Callback
    label: builtins.str
    name: builtins.str
    stock_id: builtins.str
    tooltip: builtins.str


class BindingArg():
    arg_type: GObject.GType


class BindingEntry():
    binding_set: BindingSet
    destroyed: builtins.int
    hash_next: BindingEntry
    in_emission: builtins.int
    keyval: builtins.int
    marks_unbound: builtins.int
    modifiers: Gdk.ModifierType
    set_next: BindingEntry
    signals: BindingSignal

    @staticmethod
    def add_signal_from_string(binding_set: BindingSet, signal_desc: builtins.str) -> GLib.TokenType: ...

    @staticmethod
    def add_signall(binding_set: BindingSet, keyval: builtins.int, modifiers: Gdk.ModifierType, signal_name: builtins.str, binding_args: typing.Sequence[BindingArg]) -> None: ...

    @staticmethod
    def remove(binding_set: BindingSet, keyval: builtins.int, modifiers: Gdk.ModifierType) -> None: ...

    @staticmethod
    def skip(binding_set: BindingSet, keyval: builtins.int, modifiers: Gdk.ModifierType) -> None: ...


class BindingSet():
    class_branch_pspecs: typing.Sequence[builtins.object]
    current: BindingEntry
    entries: BindingEntry
    parsed: builtins.int
    priority: builtins.int
    set_name: builtins.str
    widget_class_pspecs: typing.Sequence[builtins.object]
    widget_path_pspecs: typing.Sequence[builtins.object]

    def activate(self, keyval: builtins.int, modifiers: Gdk.ModifierType, object: GObject.Object) -> builtins.bool: ...

    def add_path(self, path_type: PathType, path_pattern: builtins.str, priority: PathPriorityType) -> None: ...

    @staticmethod
    def find(set_name: builtins.str) -> typing.Optional[BindingSet]: ...


class BindingSignal():
    args: typing.Sequence[BindingArg]
    n_args: builtins.int
    next: BindingSignal
    signal_name: builtins.str


class Border():
    bottom: builtins.int
    left: builtins.int
    right: builtins.int
    top: builtins.int

    def copy(self) -> Border: ...

    def free(self) -> None: ...

    @staticmethod
    def new() -> Border: ...


class CssSection():

    def get_end_line(self) -> builtins.int: ...

    def get_end_position(self) -> builtins.int: ...

    def get_file(self) -> Gio.File: ...

    def get_parent(self) -> typing.Optional[CssSection]: ...

    def get_section_type(self) -> CssSectionType: ...

    def get_start_line(self) -> builtins.int: ...

    def get_start_position(self) -> builtins.int: ...

    def ref(self) -> CssSection: ...

    def unref(self) -> None: ...


class FileFilterInfo():
    contains: FileFilterFlags
    display_name: builtins.str
    filename: builtins.str
    mime_type: builtins.str
    uri: builtins.str


class FixedChild():
    widget: Widget
    x: builtins.int
    y: builtins.int


class Gradient():

    def add_color_stop(self, offset: builtins.float, color: SymbolicColor) -> None: ...

    @staticmethod
    def new_linear(x0: builtins.float, y0: builtins.float, x1: builtins.float, y1: builtins.float) -> Gradient: ...

    @staticmethod
    def new_radial(x0: builtins.float, y0: builtins.float, radius0: builtins.float, x1: builtins.float, y1: builtins.float, radius1: builtins.float) -> Gradient: ...

    def ref(self) -> Gradient: ...

    def resolve(self, props: StyleProperties) -> typing.Tuple[builtins.bool, cairo.Pattern]: ...

    def resolve_for_context(self, context: StyleContext) -> cairo.Pattern: ...

    def to_string(self) -> builtins.str: ...

    def unref(self) -> None: ...


class IMContextInfo():
    context_id: builtins.str
    context_name: builtins.str
    default_locales: builtins.str
    domain: builtins.str
    domain_dirname: builtins.str


class IconSet():

    def add_source(self, source: IconSource) -> None: ...

    def copy(self) -> IconSet: ...

    def get_sizes(self) -> typing.Sequence[builtins.int]: ...

    @staticmethod
    def new() -> IconSet: ...

    @staticmethod
    def new_from_pixbuf(pixbuf: GdkPixbuf.Pixbuf) -> IconSet: ...

    def ref(self) -> IconSet: ...

    def render_icon(self, style: typing.Optional[Style], direction: TextDirection, state: StateType, size: builtins.int, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str]) -> GdkPixbuf.Pixbuf: ...

    def render_icon_pixbuf(self, context: StyleContext, size: builtins.int) -> GdkPixbuf.Pixbuf: ...

    def render_icon_surface(self, context: StyleContext, size: builtins.int, scale: builtins.int, for_window: typing.Optional[Gdk.Window]) -> cairo.Surface: ...

    def unref(self) -> None: ...


class IconSource():

    def copy(self) -> IconSource: ...

    def free(self) -> None: ...

    def get_direction(self) -> TextDirection: ...

    def get_direction_wildcarded(self) -> builtins.bool: ...

    def get_filename(self) -> builtins.str: ...

    def get_icon_name(self) -> builtins.str: ...

    def get_pixbuf(self) -> GdkPixbuf.Pixbuf: ...

    def get_size(self) -> builtins.int: ...

    def get_size_wildcarded(self) -> builtins.bool: ...

    def get_state(self) -> StateType: ...

    def get_state_wildcarded(self) -> builtins.bool: ...

    @staticmethod
    def new() -> IconSource: ...

    def set_direction(self, direction: TextDirection) -> None: ...

    def set_direction_wildcarded(self, setting: builtins.bool) -> None: ...

    def set_filename(self, filename: builtins.str) -> None: ...

    def set_icon_name(self, icon_name: typing.Optional[builtins.str]) -> None: ...

    def set_pixbuf(self, pixbuf: GdkPixbuf.Pixbuf) -> None: ...

    def set_size(self, size: builtins.int) -> None: ...

    def set_size_wildcarded(self, setting: builtins.bool) -> None: ...

    def set_state(self, state: StateType) -> None: ...

    def set_state_wildcarded(self, setting: builtins.bool) -> None: ...


class LabelSelectionInfo():
    ...


class PadActionEntry():
    action_name: builtins.str
    index: builtins.int
    label: builtins.str
    mode: builtins.int
    type: PadActionType


class PageRange():
    end: builtins.int
    start: builtins.int


class PaperSize():

    def copy(self) -> PaperSize: ...

    def free(self) -> None: ...

    @staticmethod
    def get_default() -> builtins.str: ...

    def get_default_bottom_margin(self, unit: Unit) -> builtins.float: ...

    def get_default_left_margin(self, unit: Unit) -> builtins.float: ...

    def get_default_right_margin(self, unit: Unit) -> builtins.float: ...

    def get_default_top_margin(self, unit: Unit) -> builtins.float: ...

    def get_display_name(self) -> builtins.str: ...

    def get_height(self, unit: Unit) -> builtins.float: ...

    def get_name(self) -> builtins.str: ...

    @staticmethod
    def get_paper_sizes(include_custom: builtins.bool) -> typing.Sequence[PaperSize]: ...

    def get_ppd_name(self) -> builtins.str: ...

    def get_width(self, unit: Unit) -> builtins.float: ...

    def is_custom(self) -> builtins.bool: ...

    def is_equal(self, size2: PaperSize) -> builtins.bool: ...

    def is_ipp(self) -> builtins.bool: ...

    @staticmethod
    def new(name: typing.Optional[builtins.str]) -> PaperSize: ...

    @staticmethod
    def new_custom(name: builtins.str, display_name: builtins.str, width: builtins.float, height: builtins.float, unit: Unit) -> PaperSize: ...

    @staticmethod
    def new_from_gvariant(variant: GLib.Variant) -> PaperSize: ...

    @staticmethod
    def new_from_ipp(ipp_name: builtins.str, width: builtins.float, height: builtins.float) -> PaperSize: ...

    @staticmethod
    def new_from_key_file(key_file: GLib.KeyFile, group_name: typing.Optional[builtins.str]) -> PaperSize: ...

    @staticmethod
    def new_from_ppd(ppd_name: builtins.str, ppd_display_name: builtins.str, width: builtins.float, height: builtins.float) -> PaperSize: ...

    def set_size(self, width: builtins.float, height: builtins.float, unit: Unit) -> None: ...

    def to_gvariant(self) -> GLib.Variant: ...

    def to_key_file(self, key_file: GLib.KeyFile, group_name: builtins.str) -> None: ...


class RadioActionEntry():
    accelerator: builtins.str
    label: builtins.str
    name: builtins.str
    stock_id: builtins.str
    tooltip: builtins.str
    value: builtins.int


class RcContext():
    ...


class RcProperty():
    origin: builtins.str
    property_name: builtins.int
    type_name: builtins.int
    value: GObject.Value

    @staticmethod
    def parse_border(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...

    @staticmethod
    def parse_color(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...

    @staticmethod
    def parse_enum(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...

    @staticmethod
    def parse_flags(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...

    @staticmethod
    def parse_requisition(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...


class RecentData():
    app_exec: builtins.str
    app_name: builtins.str
    description: builtins.str
    display_name: builtins.str
    groups: typing.Sequence[builtins.str]
    is_private: builtins.bool
    mime_type: builtins.str


class RecentFilterInfo():
    age: builtins.int
    applications: typing.Sequence[builtins.str]
    contains: RecentFilterFlags
    display_name: builtins.str
    groups: typing.Sequence[builtins.str]
    mime_type: builtins.str
    uri: builtins.str


class RecentInfo():

    def create_app_info(self, app_name: typing.Optional[builtins.str]) -> typing.Optional[Gio.AppInfo]: ...

    def exists(self) -> builtins.bool: ...

    def get_added(self) -> builtins.int: ...

    def get_age(self) -> builtins.int: ...

    def get_application_info(self, app_name: builtins.str) -> typing.Tuple[builtins.bool, builtins.str, builtins.int, builtins.int]: ...

    def get_applications(self) -> typing.Sequence[builtins.str]: ...

    def get_description(self) -> builtins.str: ...

    def get_display_name(self) -> builtins.str: ...

    def get_gicon(self) -> typing.Optional[Gio.Icon]: ...

    def get_groups(self) -> typing.Sequence[builtins.str]: ...

    def get_icon(self, size: builtins.int) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def get_mime_type(self) -> builtins.str: ...

    def get_modified(self) -> builtins.int: ...

    def get_private_hint(self) -> builtins.bool: ...

    def get_short_name(self) -> builtins.str: ...

    def get_uri(self) -> builtins.str: ...

    def get_uri_display(self) -> typing.Optional[builtins.str]: ...

    def get_visited(self) -> builtins.int: ...

    def has_application(self, app_name: builtins.str) -> builtins.bool: ...

    def has_group(self, group_name: builtins.str) -> builtins.bool: ...

    def is_local(self) -> builtins.bool: ...

    def last_application(self) -> builtins.str: ...

    def match(self, info_b: RecentInfo) -> builtins.bool: ...

    def ref(self) -> RecentInfo: ...

    def unref(self) -> None: ...


class RequestedSize():
    data: builtins.object
    minimum_size: builtins.int
    natural_size: builtins.int


class Requisition():
    height: builtins.int
    width: builtins.int

    def copy(self) -> Requisition: ...

    def free(self) -> None: ...

    @staticmethod
    def new() -> Requisition: ...


class SelectionData():

    def copy(self) -> SelectionData: ...

    def free(self) -> None: ...

    def get_data(self) -> builtins.bytes: ...

    def get_data_type(self) -> Gdk.Atom: ...

    def get_display(self) -> Gdk.Display: ...

    def get_format(self) -> builtins.int: ...

    def get_length(self) -> builtins.int: ...

    def get_pixbuf(self) -> typing.Optional[GdkPixbuf.Pixbuf]: ...

    def get_selection(self) -> Gdk.Atom: ...

    def get_target(self) -> Gdk.Atom: ...

    def get_targets(self) -> typing.Tuple[builtins.bool, typing.Sequence[Gdk.Atom]]: ...

    def get_text(self) -> typing.Optional[builtins.str]: ...

    def get_uris(self) -> typing.Sequence[builtins.str]: ...

    def set(self, type: Gdk.Atom, format: builtins.int, data: builtins.bytes) -> None: ...

    def set_pixbuf(self, pixbuf: GdkPixbuf.Pixbuf) -> builtins.bool: ...

    def set_text(self, str: builtins.str, len: builtins.int) -> builtins.bool: ...

    def set_uris(self, uris: typing.Sequence[builtins.str]) -> builtins.bool: ...

    def targets_include_image(self, writable: builtins.bool) -> builtins.bool: ...

    def targets_include_rich_text(self, buffer: TextBuffer) -> builtins.bool: ...

    def targets_include_text(self) -> builtins.bool: ...

    def targets_include_uri(self) -> builtins.bool: ...


class SettingsValue():
    origin: builtins.str
    value: GObject.Value


class StockItem():
    keyval: builtins.int
    label: builtins.str
    modifier: Gdk.ModifierType
    stock_id: builtins.str
    translation_domain: builtins.str

    def free(self) -> None: ...


class SymbolicColor():

    @staticmethod
    def new_alpha(color: SymbolicColor, factor: builtins.float) -> SymbolicColor: ...

    @staticmethod
    def new_literal(color: Gdk.RGBA) -> SymbolicColor: ...

    @staticmethod
    def new_mix(color1: SymbolicColor, color2: SymbolicColor, factor: builtins.float) -> SymbolicColor: ...

    @staticmethod
    def new_name(name: builtins.str) -> SymbolicColor: ...

    @staticmethod
    def new_shade(color: SymbolicColor, factor: builtins.float) -> SymbolicColor: ...

    @staticmethod
    def new_win32(theme_class: builtins.str, id: builtins.int) -> SymbolicColor: ...

    def ref(self) -> SymbolicColor: ...

    def resolve(self, props: typing.Optional[StyleProperties]) -> typing.Tuple[builtins.bool, Gdk.RGBA]: ...

    def to_string(self) -> builtins.str: ...

    def unref(self) -> None: ...


class TableChild():
    bottom_attach: builtins.int
    left_attach: builtins.int
    right_attach: builtins.int
    top_attach: builtins.int
    widget: Widget
    xexpand: builtins.int
    xfill: builtins.int
    xpadding: builtins.int
    xshrink: builtins.int
    yexpand: builtins.int
    yfill: builtins.int
    ypadding: builtins.int
    yshrink: builtins.int


class TableRowCol():
    allocation: builtins.int
    empty: builtins.int
    expand: builtins.int
    need_expand: builtins.int
    need_shrink: builtins.int
    requisition: builtins.int
    shrink: builtins.int
    spacing: builtins.int


class TargetEntry():
    flags: builtins.int
    info: builtins.int
    target: builtins.str

    def copy(self) -> TargetEntry: ...

    def free(self) -> None: ...

    @staticmethod
    def new(target: builtins.str, flags: builtins.int, info: builtins.int) -> TargetEntry: ...


class TargetList():

    def add(self, target: Gdk.Atom, flags: builtins.int, info: builtins.int) -> None: ...

    def add_image_targets(self, info: builtins.int, writable: builtins.bool) -> None: ...

    def add_rich_text_targets(self, info: builtins.int, deserializable: builtins.bool, buffer: TextBuffer) -> None: ...

    def add_table(self, targets: typing.Sequence[TargetEntry]) -> None: ...

    def add_text_targets(self, info: builtins.int) -> None: ...

    def add_uri_targets(self, info: builtins.int) -> None: ...

    def find(self, target: Gdk.Atom) -> typing.Tuple[builtins.bool, builtins.int]: ...

    @staticmethod
    def new(targets: typing.Optional[typing.Sequence[TargetEntry]]) -> TargetList: ...

    def ref(self) -> TargetList: ...

    def remove(self, target: Gdk.Atom) -> None: ...

    def unref(self) -> None: ...


class TargetPair():
    flags: builtins.int
    info: builtins.int
    target: Gdk.Atom


class TextAppearance():
    bg_color: Gdk.Color
    draw_bg: builtins.int
    fg_color: Gdk.Color
    inside_selection: builtins.int
    is_text: builtins.int
    rise: builtins.int
    strikethrough: builtins.int
    underline: builtins.int


class TextAttributes():
    appearance: TextAppearance
    bg_full_height: builtins.int
    direction: TextDirection
    editable: builtins.int
    font: Pango.FontDescription
    font_scale: builtins.float
    indent: builtins.int
    invisible: builtins.int
    justification: Justification
    language: Pango.Language
    left_margin: builtins.int
    letter_spacing: builtins.int
    no_fallback: builtins.int
    pg_bg_color: Gdk.Color
    pg_bg_rgba: Gdk.RGBA
    pixels_above_lines: builtins.int
    pixels_below_lines: builtins.int
    pixels_inside_wrap: builtins.int
    refcount: builtins.int
    right_margin: builtins.int
    tabs: Pango.TabArray
    wrap_mode: WrapMode

    def copy(self) -> TextAttributes: ...

    def copy_values(self, dest: TextAttributes) -> None: ...

    @staticmethod
    def new() -> TextAttributes: ...

    def ref(self) -> TextAttributes: ...

    def unref(self) -> None: ...


class TextBTree():
    ...


class TextIter():
    dummy10: builtins.object
    dummy11: builtins.int
    dummy12: builtins.int
    dummy13: builtins.int
    dummy14: builtins.object
    dummy1: builtins.object
    dummy2: builtins.object
    dummy3: builtins.int
    dummy4: builtins.int
    dummy5: builtins.int
    dummy6: builtins.int
    dummy7: builtins.int
    dummy8: builtins.int
    dummy9: builtins.object

    def assign(self, other: TextIter) -> None: ...

    def backward_char(self) -> builtins.bool: ...

    def backward_chars(self, count: builtins.int) -> builtins.bool: ...

    def backward_cursor_position(self) -> builtins.bool: ...

    def backward_cursor_positions(self, count: builtins.int) -> builtins.bool: ...

    def backward_find_char(self, pred: TextCharPredicate, user_data: typing.Optional[builtins.object], limit: typing.Optional[TextIter]) -> builtins.bool: ...

    def backward_line(self) -> builtins.bool: ...

    def backward_lines(self, count: builtins.int) -> builtins.bool: ...

    def backward_search(self, str: builtins.str, flags: TextSearchFlags, limit: typing.Optional[TextIter]) -> typing.Tuple[builtins.bool, TextIter, TextIter]: ...

    def backward_sentence_start(self) -> builtins.bool: ...

    def backward_sentence_starts(self, count: builtins.int) -> builtins.bool: ...

    def backward_to_tag_toggle(self, tag: typing.Optional[TextTag]) -> builtins.bool: ...

    def backward_visible_cursor_position(self) -> builtins.bool: ...

    def backward_visible_cursor_positions(self, count: builtins.int) -> builtins.bool: ...

    def backward_visible_line(self) -> builtins.bool: ...

    def backward_visible_lines(self, count: builtins.int) -> builtins.bool: ...

    def backward_visible_word_start(self) -> builtins.bool: ...

    def backward_visible_word_starts(self, count: builtins.int) -> builtins.bool: ...

    def backward_word_start(self) -> builtins.bool: ...

    def backward_word_starts(self, count: builtins.int) -> builtins.bool: ...

    def begins_tag(self, tag: typing.Optional[TextTag]) -> builtins.bool: ...

    def can_insert(self, default_editability: builtins.bool) -> builtins.bool: ...

    def compare(self, rhs: TextIter) -> builtins.int: ...

    def copy(self) -> TextIter: ...

    def editable(self, default_setting: builtins.bool) -> builtins.bool: ...

    def ends_line(self) -> builtins.bool: ...

    def ends_sentence(self) -> builtins.bool: ...

    def ends_tag(self, tag: typing.Optional[TextTag]) -> builtins.bool: ...

    def ends_word(self) -> builtins.bool: ...

    def equal(self, rhs: TextIter) -> builtins.bool: ...

    def forward_char(self) -> builtins.bool: ...

    def forward_chars(self, count: builtins.int) -> builtins.bool: ...

    def forward_cursor_position(self) -> builtins.bool: ...

    def forward_cursor_positions(self, count: builtins.int) -> builtins.bool: ...

    def forward_find_char(self, pred: TextCharPredicate, user_data: typing.Optional[builtins.object], limit: typing.Optional[TextIter]) -> builtins.bool: ...

    def forward_line(self) -> builtins.bool: ...

    def forward_lines(self, count: builtins.int) -> builtins.bool: ...

    def forward_search(self, str: builtins.str, flags: TextSearchFlags, limit: typing.Optional[TextIter]) -> typing.Tuple[builtins.bool, TextIter, TextIter]: ...

    def forward_sentence_end(self) -> builtins.bool: ...

    def forward_sentence_ends(self, count: builtins.int) -> builtins.bool: ...

    def forward_to_end(self) -> None: ...

    def forward_to_line_end(self) -> builtins.bool: ...

    def forward_to_tag_toggle(self, tag: typing.Optional[TextTag]) -> builtins.bool: ...

    def forward_visible_cursor_position(self) -> builtins.bool: ...

    def forward_visible_cursor_positions(self, count: builtins.int) -> builtins.bool: ...

    def forward_visible_line(self) -> builtins.bool: ...

    def forward_visible_lines(self, count: builtins.int) -> builtins.bool: ...

    def forward_visible_word_end(self) -> builtins.bool: ...

    def forward_visible_word_ends(self, count: builtins.int) -> builtins.bool: ...

    def forward_word_end(self) -> builtins.bool: ...

    def forward_word_ends(self, count: builtins.int) -> builtins.bool: ...

    def free(self) -> None: ...

    def get_attributes(self) -> typing.Tuple[builtins.bool, TextAttributes]: ...

    def get_buffer(self) -> TextBuffer: ...

    def get_bytes_in_line(self) -> builtins.int: ...

    def get_char(self) -> builtins.str: ...

    def get_chars_in_line(self) -> builtins.int: ...

    def get_child_anchor(self) -> TextChildAnchor: ...

    def get_language(self) -> Pango.Language: ...

    def get_line(self) -> builtins.int: ...

    def get_line_index(self) -> builtins.int: ...

    def get_line_offset(self) -> builtins.int: ...

    def get_marks(self) -> typing.Sequence[TextMark]: ...

    def get_offset(self) -> builtins.int: ...

    def get_pixbuf(self) -> GdkPixbuf.Pixbuf: ...

    def get_slice(self, end: TextIter) -> builtins.str: ...

    def get_tags(self) -> typing.Sequence[TextTag]: ...

    def get_text(self, end: TextIter) -> builtins.str: ...

    def get_toggled_tags(self, toggled_on: builtins.bool) -> typing.Sequence[TextTag]: ...

    def get_visible_line_index(self) -> builtins.int: ...

    def get_visible_line_offset(self) -> builtins.int: ...

    def get_visible_slice(self, end: TextIter) -> builtins.str: ...

    def get_visible_text(self, end: TextIter) -> builtins.str: ...

    def has_tag(self, tag: TextTag) -> builtins.bool: ...

    def in_range(self, start: TextIter, end: TextIter) -> builtins.bool: ...

    def inside_sentence(self) -> builtins.bool: ...

    def inside_word(self) -> builtins.bool: ...

    def is_cursor_position(self) -> builtins.bool: ...

    def is_end(self) -> builtins.bool: ...

    def is_start(self) -> builtins.bool: ...

    def order(self, second: TextIter) -> None: ...

    def set_line(self, line_number: builtins.int) -> None: ...

    def set_line_index(self, byte_on_line: builtins.int) -> None: ...

    def set_line_offset(self, char_on_line: builtins.int) -> None: ...

    def set_offset(self, char_offset: builtins.int) -> None: ...

    def set_visible_line_index(self, byte_on_line: builtins.int) -> None: ...

    def set_visible_line_offset(self, char_on_line: builtins.int) -> None: ...

    def starts_line(self) -> builtins.bool: ...

    def starts_sentence(self) -> builtins.bool: ...

    def starts_tag(self, tag: typing.Optional[TextTag]) -> builtins.bool: ...

    def starts_word(self) -> builtins.bool: ...

    def toggles_tag(self, tag: typing.Optional[TextTag]) -> builtins.bool: ...


class ThemeEngine():
    ...


class ToggleActionEntry():
    accelerator: builtins.str
    callback: GObject.Callback
    is_active: builtins.bool
    label: builtins.str
    name: builtins.str
    stock_id: builtins.str
    tooltip: builtins.str


class TreeIter():
    stamp: builtins.int
    user_data2: builtins.object
    user_data3: builtins.object
    user_data: builtins.object

    def copy(self) -> TreeIter: ...

    def free(self) -> None: ...


class TreePath():

    def append_index(self, index_: builtins.int) -> None: ...

    def compare(self, b: TreePath) -> builtins.int: ...

    def copy(self) -> TreePath: ...

    def down(self) -> None: ...

    def free(self) -> None: ...

    def get_depth(self) -> builtins.int: ...

    def get_indices(self) -> typing.Sequence[builtins.int]: ...

    def is_ancestor(self, descendant: TreePath) -> builtins.bool: ...

    def is_descendant(self, ancestor: TreePath) -> builtins.bool: ...

    @staticmethod
    def new() -> TreePath: ...

    @staticmethod
    def new_first() -> TreePath: ...

    @staticmethod
    def new_from_indices(indices: typing.Sequence[builtins.int]) -> TreePath: ...

    @staticmethod
    def new_from_string(path: builtins.str) -> TreePath: ...

    def next(self) -> None: ...

    def prepend_index(self, index_: builtins.int) -> None: ...

    def prev(self) -> builtins.bool: ...

    def to_string(self) -> builtins.str: ...

    def up(self) -> builtins.bool: ...


class TreeRowReference():

    def copy(self) -> TreeRowReference: ...

    @staticmethod
    def deleted(proxy: GObject.Object, path: TreePath) -> None: ...

    def free(self) -> None: ...

    def get_model(self) -> TreeModel: ...

    def get_path(self) -> typing.Optional[TreePath]: ...

    @staticmethod
    def inserted(proxy: GObject.Object, path: TreePath) -> None: ...

    @staticmethod
    def new(model: TreeModel, path: TreePath) -> TreeRowReference: ...

    @staticmethod
    def new_proxy(proxy: GObject.Object, model: TreeModel, path: TreePath) -> TreeRowReference: ...

    def valid(self) -> builtins.bool: ...


class WidgetPath():

    def append_for_widget(self, widget: Widget) -> builtins.int: ...

    def append_type(self, type: GObject.GType) -> builtins.int: ...

    def append_with_siblings(self, siblings: WidgetPath, sibling_index: builtins.int) -> builtins.int: ...

    def copy(self) -> WidgetPath: ...

    def free(self) -> None: ...

    def get_object_type(self) -> GObject.GType: ...

    def has_parent(self, type: GObject.GType) -> builtins.bool: ...

    def is_type(self, type: GObject.GType) -> builtins.bool: ...

    def iter_add_class(self, pos: builtins.int, name: builtins.str) -> None: ...

    def iter_add_region(self, pos: builtins.int, name: builtins.str, flags: RegionFlags) -> None: ...

    def iter_clear_classes(self, pos: builtins.int) -> None: ...

    def iter_clear_regions(self, pos: builtins.int) -> None: ...

    def iter_get_name(self, pos: builtins.int) -> typing.Optional[builtins.str]: ...

    def iter_get_object_name(self, pos: builtins.int) -> typing.Optional[builtins.str]: ...

    def iter_get_object_type(self, pos: builtins.int) -> GObject.GType: ...

    def iter_get_sibling_index(self, pos: builtins.int) -> builtins.int: ...

    def iter_get_siblings(self, pos: builtins.int) -> WidgetPath: ...

    def iter_get_state(self, pos: builtins.int) -> StateFlags: ...

    def iter_has_class(self, pos: builtins.int, name: builtins.str) -> builtins.bool: ...

    def iter_has_name(self, pos: builtins.int, name: builtins.str) -> builtins.bool: ...

    def iter_has_qclass(self, pos: builtins.int, qname: builtins.int) -> builtins.bool: ...

    def iter_has_qname(self, pos: builtins.int, qname: builtins.int) -> builtins.bool: ...

    def iter_has_qregion(self, pos: builtins.int, qname: builtins.int) -> typing.Tuple[builtins.bool, RegionFlags]: ...

    def iter_has_region(self, pos: builtins.int, name: builtins.str) -> typing.Tuple[builtins.bool, RegionFlags]: ...

    def iter_list_classes(self, pos: builtins.int) -> typing.Sequence[builtins.str]: ...

    def iter_list_regions(self, pos: builtins.int) -> typing.Sequence[builtins.str]: ...

    def iter_remove_class(self, pos: builtins.int, name: builtins.str) -> None: ...

    def iter_remove_region(self, pos: builtins.int, name: builtins.str) -> None: ...

    def iter_set_name(self, pos: builtins.int, name: builtins.str) -> None: ...

    def iter_set_object_name(self, pos: builtins.int, name: typing.Optional[builtins.str]) -> None: ...

    def iter_set_object_type(self, pos: builtins.int, type: GObject.GType) -> None: ...

    def iter_set_state(self, pos: builtins.int, state: StateFlags) -> None: ...

    def length(self) -> builtins.int: ...

    @staticmethod
    def new() -> WidgetPath: ...

    def prepend_type(self, type: GObject.GType) -> None: ...

    def ref(self) -> WidgetPath: ...

    def to_string(self) -> builtins.str: ...

    def unref(self) -> None: ...


class WindowGeometryInfo():
    ...


class AccelFlags(GObject.GFlags, builtins.int):
    LOCKED = ...  # type: AccelFlags
    MASK = ...  # type: AccelFlags
    VISIBLE = ...  # type: AccelFlags


class ApplicationInhibitFlags(GObject.GFlags, builtins.int):
    IDLE = ...  # type: ApplicationInhibitFlags
    LOGOUT = ...  # type: ApplicationInhibitFlags
    SUSPEND = ...  # type: ApplicationInhibitFlags
    SWITCH = ...  # type: ApplicationInhibitFlags


class AttachOptions(GObject.GFlags, builtins.int):
    EXPAND = ...  # type: AttachOptions
    FILL = ...  # type: AttachOptions
    SHRINK = ...  # type: AttachOptions


class CalendarDisplayOptions(GObject.GFlags, builtins.int):
    NO_MONTH_CHANGE = ...  # type: CalendarDisplayOptions
    SHOW_DAY_NAMES = ...  # type: CalendarDisplayOptions
    SHOW_DETAILS = ...  # type: CalendarDisplayOptions
    SHOW_HEADING = ...  # type: CalendarDisplayOptions
    SHOW_WEEK_NUMBERS = ...  # type: CalendarDisplayOptions


class CellRendererState(GObject.GFlags, builtins.int):
    EXPANDABLE = ...  # type: CellRendererState
    EXPANDED = ...  # type: CellRendererState
    FOCUSED = ...  # type: CellRendererState
    INSENSITIVE = ...  # type: CellRendererState
    PRELIT = ...  # type: CellRendererState
    SELECTED = ...  # type: CellRendererState
    SORTED = ...  # type: CellRendererState


class DebugFlag(GObject.GFlags, builtins.int):
    ACTIONS = ...  # type: DebugFlag
    BASELINES = ...  # type: DebugFlag
    BUILDER = ...  # type: DebugFlag
    GEOMETRY = ...  # type: DebugFlag
    ICONTHEME = ...  # type: DebugFlag
    INTERACTIVE = ...  # type: DebugFlag
    KEYBINDINGS = ...  # type: DebugFlag
    LAYOUT = ...  # type: DebugFlag
    MISC = ...  # type: DebugFlag
    MODULES = ...  # type: DebugFlag
    MULTIHEAD = ...  # type: DebugFlag
    NO_CSS_CACHE = ...  # type: DebugFlag
    NO_PIXEL_CACHE = ...  # type: DebugFlag
    PIXEL_CACHE = ...  # type: DebugFlag
    PLUGSOCKET = ...  # type: DebugFlag
    PRINTING = ...  # type: DebugFlag
    RESIZE = ...  # type: DebugFlag
    SIZE_REQUEST = ...  # type: DebugFlag
    TEXT = ...  # type: DebugFlag
    TOUCHSCREEN = ...  # type: DebugFlag
    TREE = ...  # type: DebugFlag
    UPDATES = ...  # type: DebugFlag


class DestDefaults(GObject.GFlags, builtins.int):
    ALL = ...  # type: DestDefaults
    DROP = ...  # type: DestDefaults
    HIGHLIGHT = ...  # type: DestDefaults
    MOTION = ...  # type: DestDefaults


class DialogFlags(GObject.GFlags, builtins.int):
    DESTROY_WITH_PARENT = ...  # type: DialogFlags
    MODAL = ...  # type: DialogFlags
    USE_HEADER_BAR = ...  # type: DialogFlags


class EventControllerScrollFlags(GObject.GFlags, builtins.int):
    BOTH_AXES = ...  # type: EventControllerScrollFlags
    DISCRETE = ...  # type: EventControllerScrollFlags
    HORIZONTAL = ...  # type: EventControllerScrollFlags
    KINETIC = ...  # type: EventControllerScrollFlags
    NONE = ...  # type: EventControllerScrollFlags
    VERTICAL = ...  # type: EventControllerScrollFlags


class FileFilterFlags(GObject.GFlags, builtins.int):
    DISPLAY_NAME = ...  # type: FileFilterFlags
    FILENAME = ...  # type: FileFilterFlags
    MIME_TYPE = ...  # type: FileFilterFlags
    URI = ...  # type: FileFilterFlags


class FontChooserLevel(GObject.GFlags, builtins.int):
    FAMILY = ...  # type: FontChooserLevel
    FEATURES = ...  # type: FontChooserLevel
    SIZE = ...  # type: FontChooserLevel
    STYLE = ...  # type: FontChooserLevel
    VARIATIONS = ...  # type: FontChooserLevel


class IconLookupFlags(GObject.GFlags, builtins.int):
    DIR_LTR = ...  # type: IconLookupFlags
    DIR_RTL = ...  # type: IconLookupFlags
    FORCE_REGULAR = ...  # type: IconLookupFlags
    FORCE_SIZE = ...  # type: IconLookupFlags
    FORCE_SVG = ...  # type: IconLookupFlags
    FORCE_SYMBOLIC = ...  # type: IconLookupFlags
    GENERIC_FALLBACK = ...  # type: IconLookupFlags
    NO_SVG = ...  # type: IconLookupFlags
    USE_BUILTIN = ...  # type: IconLookupFlags


class InputHints(GObject.GFlags, builtins.int):
    EMOJI = ...  # type: InputHints
    INHIBIT_OSK = ...  # type: InputHints
    LOWERCASE = ...  # type: InputHints
    NONE = ...  # type: InputHints
    NO_EMOJI = ...  # type: InputHints
    NO_SPELLCHECK = ...  # type: InputHints
    SPELLCHECK = ...  # type: InputHints
    UPPERCASE_CHARS = ...  # type: InputHints
    UPPERCASE_SENTENCES = ...  # type: InputHints
    UPPERCASE_WORDS = ...  # type: InputHints
    VERTICAL_WRITING = ...  # type: InputHints
    WORD_COMPLETION = ...  # type: InputHints


class JunctionSides(GObject.GFlags, builtins.int):
    BOTTOM = ...  # type: JunctionSides
    CORNER_BOTTOMLEFT = ...  # type: JunctionSides
    CORNER_BOTTOMRIGHT = ...  # type: JunctionSides
    CORNER_TOPLEFT = ...  # type: JunctionSides
    CORNER_TOPRIGHT = ...  # type: JunctionSides
    LEFT = ...  # type: JunctionSides
    NONE = ...  # type: JunctionSides
    RIGHT = ...  # type: JunctionSides
    TOP = ...  # type: JunctionSides


class PlacesOpenFlags(GObject.GFlags, builtins.int):
    NEW_TAB = ...  # type: PlacesOpenFlags
    NEW_WINDOW = ...  # type: PlacesOpenFlags
    NORMAL = ...  # type: PlacesOpenFlags


class RcFlags(GObject.GFlags, builtins.int):
    BASE = ...  # type: RcFlags
    BG = ...  # type: RcFlags
    FG = ...  # type: RcFlags
    TEXT = ...  # type: RcFlags


class RecentFilterFlags(GObject.GFlags, builtins.int):
    AGE = ...  # type: RecentFilterFlags
    APPLICATION = ...  # type: RecentFilterFlags
    DISPLAY_NAME = ...  # type: RecentFilterFlags
    GROUP = ...  # type: RecentFilterFlags
    MIME_TYPE = ...  # type: RecentFilterFlags
    URI = ...  # type: RecentFilterFlags


class RegionFlags(GObject.GFlags, builtins.int):
    EVEN = ...  # type: RegionFlags
    FIRST = ...  # type: RegionFlags
    LAST = ...  # type: RegionFlags
    ODD = ...  # type: RegionFlags
    ONLY = ...  # type: RegionFlags
    SORTED = ...  # type: RegionFlags


class StateFlags(GObject.GFlags, builtins.int):
    ACTIVE = ...  # type: StateFlags
    BACKDROP = ...  # type: StateFlags
    CHECKED = ...  # type: StateFlags
    DIR_LTR = ...  # type: StateFlags
    DIR_RTL = ...  # type: StateFlags
    DROP_ACTIVE = ...  # type: StateFlags
    FOCUSED = ...  # type: StateFlags
    INCONSISTENT = ...  # type: StateFlags
    INSENSITIVE = ...  # type: StateFlags
    LINK = ...  # type: StateFlags
    NORMAL = ...  # type: StateFlags
    PRELIGHT = ...  # type: StateFlags
    SELECTED = ...  # type: StateFlags
    VISITED = ...  # type: StateFlags


class StyleContextPrintFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: StyleContextPrintFlags
    RECURSE = ...  # type: StyleContextPrintFlags
    SHOW_STYLE = ...  # type: StyleContextPrintFlags


class TargetFlags(GObject.GFlags, builtins.int):
    OTHER_APP = ...  # type: TargetFlags
    OTHER_WIDGET = ...  # type: TargetFlags
    SAME_APP = ...  # type: TargetFlags
    SAME_WIDGET = ...  # type: TargetFlags


class TextSearchFlags(GObject.GFlags, builtins.int):
    CASE_INSENSITIVE = ...  # type: TextSearchFlags
    TEXT_ONLY = ...  # type: TextSearchFlags
    VISIBLE_ONLY = ...  # type: TextSearchFlags


class ToolPaletteDragTargets(GObject.GFlags, builtins.int):
    GROUPS = ...  # type: ToolPaletteDragTargets
    ITEMS = ...  # type: ToolPaletteDragTargets


class TreeModelFlags(GObject.GFlags, builtins.int):
    ITERS_PERSIST = ...  # type: TreeModelFlags
    LIST_ONLY = ...  # type: TreeModelFlags


class UIManagerItemType(GObject.GFlags, builtins.int):
    ACCELERATOR = ...  # type: UIManagerItemType
    AUTO = ...  # type: UIManagerItemType
    MENU = ...  # type: UIManagerItemType
    MENUBAR = ...  # type: UIManagerItemType
    MENUITEM = ...  # type: UIManagerItemType
    PLACEHOLDER = ...  # type: UIManagerItemType
    POPUP = ...  # type: UIManagerItemType
    POPUP_WITH_ACCELS = ...  # type: UIManagerItemType
    SEPARATOR = ...  # type: UIManagerItemType
    TOOLBAR = ...  # type: UIManagerItemType
    TOOLITEM = ...  # type: UIManagerItemType


class Align(GObject.GEnum, builtins.int):
    BASELINE = ...  # type: Align
    CENTER = ...  # type: Align
    END = ...  # type: Align
    FILL = ...  # type: Align
    START = ...  # type: Align


class ArrowPlacement(GObject.GEnum, builtins.int):
    BOTH = ...  # type: ArrowPlacement
    END = ...  # type: ArrowPlacement
    START = ...  # type: ArrowPlacement


class ArrowType(GObject.GEnum, builtins.int):
    DOWN = ...  # type: ArrowType
    LEFT = ...  # type: ArrowType
    NONE = ...  # type: ArrowType
    RIGHT = ...  # type: ArrowType
    UP = ...  # type: ArrowType


class AssistantPageType(GObject.GEnum, builtins.int):
    CONFIRM = ...  # type: AssistantPageType
    CONTENT = ...  # type: AssistantPageType
    CUSTOM = ...  # type: AssistantPageType
    INTRO = ...  # type: AssistantPageType
    PROGRESS = ...  # type: AssistantPageType
    SUMMARY = ...  # type: AssistantPageType


class BaselinePosition(GObject.GEnum, builtins.int):
    BOTTOM = ...  # type: BaselinePosition
    CENTER = ...  # type: BaselinePosition
    TOP = ...  # type: BaselinePosition


class BorderStyle(GObject.GEnum, builtins.int):
    DASHED = ...  # type: BorderStyle
    DOTTED = ...  # type: BorderStyle
    DOUBLE = ...  # type: BorderStyle
    GROOVE = ...  # type: BorderStyle
    HIDDEN = ...  # type: BorderStyle
    INSET = ...  # type: BorderStyle
    NONE = ...  # type: BorderStyle
    OUTSET = ...  # type: BorderStyle
    RIDGE = ...  # type: BorderStyle
    SOLID = ...  # type: BorderStyle


class BuilderError(GObject.GEnum, builtins.int):
    DUPLICATE_ID = ...  # type: BuilderError
    INVALID_ATTRIBUTE = ...  # type: BuilderError
    INVALID_ID = ...  # type: BuilderError
    INVALID_PROPERTY = ...  # type: BuilderError
    INVALID_SIGNAL = ...  # type: BuilderError
    INVALID_TAG = ...  # type: BuilderError
    INVALID_TYPE_FUNCTION = ...  # type: BuilderError
    INVALID_VALUE = ...  # type: BuilderError
    MISSING_ATTRIBUTE = ...  # type: BuilderError
    MISSING_PROPERTY_VALUE = ...  # type: BuilderError
    OBJECT_TYPE_REFUSED = ...  # type: BuilderError
    TEMPLATE_MISMATCH = ...  # type: BuilderError
    UNHANDLED_TAG = ...  # type: BuilderError
    VERSION_MISMATCH = ...  # type: BuilderError

    @staticmethod
    def quark() -> builtins.int: ...


class ButtonBoxStyle(GObject.GEnum, builtins.int):
    CENTER = ...  # type: ButtonBoxStyle
    EDGE = ...  # type: ButtonBoxStyle
    END = ...  # type: ButtonBoxStyle
    EXPAND = ...  # type: ButtonBoxStyle
    SPREAD = ...  # type: ButtonBoxStyle
    START = ...  # type: ButtonBoxStyle


class ButtonRole(GObject.GEnum, builtins.int):
    CHECK = ...  # type: ButtonRole
    NORMAL = ...  # type: ButtonRole
    RADIO = ...  # type: ButtonRole


class ButtonsType(GObject.GEnum, builtins.int):
    CANCEL = ...  # type: ButtonsType
    CLOSE = ...  # type: ButtonsType
    NONE = ...  # type: ButtonsType
    OK = ...  # type: ButtonsType
    OK_CANCEL = ...  # type: ButtonsType
    YES_NO = ...  # type: ButtonsType


class CellRendererAccelMode(GObject.GEnum, builtins.int):
    GTK = ...  # type: CellRendererAccelMode
    OTHER = ...  # type: CellRendererAccelMode


class CellRendererMode(GObject.GEnum, builtins.int):
    ACTIVATABLE = ...  # type: CellRendererMode
    EDITABLE = ...  # type: CellRendererMode
    INERT = ...  # type: CellRendererMode


class CornerType(GObject.GEnum, builtins.int):
    BOTTOM_LEFT = ...  # type: CornerType
    BOTTOM_RIGHT = ...  # type: CornerType
    TOP_LEFT = ...  # type: CornerType
    TOP_RIGHT = ...  # type: CornerType


class CssProviderError(GObject.GEnum, builtins.int):
    DEPRECATED = ...  # type: CssProviderError
    FAILED = ...  # type: CssProviderError
    IMPORT = ...  # type: CssProviderError
    NAME = ...  # type: CssProviderError
    SYNTAX = ...  # type: CssProviderError
    UNKNOWN_VALUE = ...  # type: CssProviderError

    @staticmethod
    def quark() -> builtins.int: ...


class CssSectionType(GObject.GEnum, builtins.int):
    BINDING_SET = ...  # type: CssSectionType
    COLOR_DEFINITION = ...  # type: CssSectionType
    DECLARATION = ...  # type: CssSectionType
    DOCUMENT = ...  # type: CssSectionType
    IMPORT = ...  # type: CssSectionType
    KEYFRAMES = ...  # type: CssSectionType
    RULESET = ...  # type: CssSectionType
    SELECTOR = ...  # type: CssSectionType
    VALUE = ...  # type: CssSectionType


class DeleteType(GObject.GEnum, builtins.int):
    CHARS = ...  # type: DeleteType
    DISPLAY_LINES = ...  # type: DeleteType
    DISPLAY_LINE_ENDS = ...  # type: DeleteType
    PARAGRAPHS = ...  # type: DeleteType
    PARAGRAPH_ENDS = ...  # type: DeleteType
    WHITESPACE = ...  # type: DeleteType
    WORDS = ...  # type: DeleteType
    WORD_ENDS = ...  # type: DeleteType


class DirectionType(GObject.GEnum, builtins.int):
    DOWN = ...  # type: DirectionType
    LEFT = ...  # type: DirectionType
    RIGHT = ...  # type: DirectionType
    TAB_BACKWARD = ...  # type: DirectionType
    TAB_FORWARD = ...  # type: DirectionType
    UP = ...  # type: DirectionType


class DragResult(GObject.GEnum, builtins.int):
    ERROR = ...  # type: DragResult
    GRAB_BROKEN = ...  # type: DragResult
    NO_TARGET = ...  # type: DragResult
    SUCCESS = ...  # type: DragResult
    TIMEOUT_EXPIRED = ...  # type: DragResult
    USER_CANCELLED = ...  # type: DragResult


class EntryIconPosition(GObject.GEnum, builtins.int):
    PRIMARY = ...  # type: EntryIconPosition
    SECONDARY = ...  # type: EntryIconPosition


class EventSequenceState(GObject.GEnum, builtins.int):
    CLAIMED = ...  # type: EventSequenceState
    DENIED = ...  # type: EventSequenceState
    NONE = ...  # type: EventSequenceState


class ExpanderStyle(GObject.GEnum, builtins.int):
    COLLAPSED = ...  # type: ExpanderStyle
    EXPANDED = ...  # type: ExpanderStyle
    SEMI_COLLAPSED = ...  # type: ExpanderStyle
    SEMI_EXPANDED = ...  # type: ExpanderStyle


class FileChooserAction(GObject.GEnum, builtins.int):
    CREATE_FOLDER = ...  # type: FileChooserAction
    OPEN = ...  # type: FileChooserAction
    SAVE = ...  # type: FileChooserAction
    SELECT_FOLDER = ...  # type: FileChooserAction


class FileChooserConfirmation(GObject.GEnum, builtins.int):
    ACCEPT_FILENAME = ...  # type: FileChooserConfirmation
    CONFIRM = ...  # type: FileChooserConfirmation
    SELECT_AGAIN = ...  # type: FileChooserConfirmation


class FileChooserError(GObject.GEnum, builtins.int):
    ALREADY_EXISTS = ...  # type: FileChooserError
    BAD_FILENAME = ...  # type: FileChooserError
    INCOMPLETE_HOSTNAME = ...  # type: FileChooserError
    NONEXISTENT = ...  # type: FileChooserError

    @staticmethod
    def quark() -> builtins.int: ...


class IMPreeditStyle(GObject.GEnum, builtins.int):
    CALLBACK = ...  # type: IMPreeditStyle
    NONE = ...  # type: IMPreeditStyle
    NOTHING = ...  # type: IMPreeditStyle


class IMStatusStyle(GObject.GEnum, builtins.int):
    CALLBACK = ...  # type: IMStatusStyle
    NONE = ...  # type: IMStatusStyle
    NOTHING = ...  # type: IMStatusStyle


class IconSize(GObject.GEnum, builtins.int):
    BUTTON = ...  # type: IconSize
    DIALOG = ...  # type: IconSize
    DND = ...  # type: IconSize
    INVALID = ...  # type: IconSize
    LARGE_TOOLBAR = ...  # type: IconSize
    MENU = ...  # type: IconSize
    SMALL_TOOLBAR = ...  # type: IconSize

    @staticmethod
    def from_name(name: builtins.str) -> builtins.int: ...

    @staticmethod
    def get_name(size: builtins.int) -> builtins.str: ...

    @staticmethod
    def lookup(size: builtins.int) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...

    @staticmethod
    def lookup_for_settings(settings: Settings, size: builtins.int) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...

    @staticmethod
    def register(name: builtins.str, width: builtins.int, height: builtins.int) -> builtins.int: ...

    @staticmethod
    def register_alias(alias: builtins.str, target: builtins.int) -> None: ...


class IconThemeError(GObject.GEnum, builtins.int):
    FAILED = ...  # type: IconThemeError
    NOT_FOUND = ...  # type: IconThemeError

    @staticmethod
    def quark() -> builtins.int: ...


class IconViewDropPosition(GObject.GEnum, builtins.int):
    DROP_ABOVE = ...  # type: IconViewDropPosition
    DROP_BELOW = ...  # type: IconViewDropPosition
    DROP_INTO = ...  # type: IconViewDropPosition
    DROP_LEFT = ...  # type: IconViewDropPosition
    DROP_RIGHT = ...  # type: IconViewDropPosition
    NO_DROP = ...  # type: IconViewDropPosition


class ImageType(GObject.GEnum, builtins.int):
    ANIMATION = ...  # type: ImageType
    EMPTY = ...  # type: ImageType
    GICON = ...  # type: ImageType
    ICON_NAME = ...  # type: ImageType
    ICON_SET = ...  # type: ImageType
    PIXBUF = ...  # type: ImageType
    STOCK = ...  # type: ImageType
    SURFACE = ...  # type: ImageType


class InputPurpose(GObject.GEnum, builtins.int):
    ALPHA = ...  # type: InputPurpose
    DIGITS = ...  # type: InputPurpose
    EMAIL = ...  # type: InputPurpose
    FREE_FORM = ...  # type: InputPurpose
    NAME = ...  # type: InputPurpose
    NUMBER = ...  # type: InputPurpose
    PASSWORD = ...  # type: InputPurpose
    PHONE = ...  # type: InputPurpose
    PIN = ...  # type: InputPurpose
    TERMINAL = ...  # type: InputPurpose
    URL = ...  # type: InputPurpose


class Justification(GObject.GEnum, builtins.int):
    CENTER = ...  # type: Justification
    FILL = ...  # type: Justification
    LEFT = ...  # type: Justification
    RIGHT = ...  # type: Justification


class LevelBarMode(GObject.GEnum, builtins.int):
    CONTINUOUS = ...  # type: LevelBarMode
    DISCRETE = ...  # type: LevelBarMode


class License(GObject.GEnum, builtins.int):
    AGPL_3_0 = ...  # type: License
    AGPL_3_0_ONLY = ...  # type: License
    APACHE_2_0 = ...  # type: License
    ARTISTIC = ...  # type: License
    BSD = ...  # type: License
    BSD_3 = ...  # type: License
    CUSTOM = ...  # type: License
    GPL_2_0 = ...  # type: License
    GPL_2_0_ONLY = ...  # type: License
    GPL_3_0 = ...  # type: License
    GPL_3_0_ONLY = ...  # type: License
    LGPL_2_1 = ...  # type: License
    LGPL_2_1_ONLY = ...  # type: License
    LGPL_3_0 = ...  # type: License
    LGPL_3_0_ONLY = ...  # type: License
    MIT_X11 = ...  # type: License
    MPL_2_0 = ...  # type: License
    UNKNOWN = ...  # type: License


class MenuDirectionType(GObject.GEnum, builtins.int):
    CHILD = ...  # type: MenuDirectionType
    NEXT = ...  # type: MenuDirectionType
    PARENT = ...  # type: MenuDirectionType
    PREV = ...  # type: MenuDirectionType


class MessageType(GObject.GEnum, builtins.int):
    ERROR = ...  # type: MessageType
    INFO = ...  # type: MessageType
    OTHER = ...  # type: MessageType
    QUESTION = ...  # type: MessageType
    WARNING = ...  # type: MessageType


class MovementStep(GObject.GEnum, builtins.int):
    BUFFER_ENDS = ...  # type: MovementStep
    DISPLAY_LINES = ...  # type: MovementStep
    DISPLAY_LINE_ENDS = ...  # type: MovementStep
    HORIZONTAL_PAGES = ...  # type: MovementStep
    LOGICAL_POSITIONS = ...  # type: MovementStep
    PAGES = ...  # type: MovementStep
    PARAGRAPHS = ...  # type: MovementStep
    PARAGRAPH_ENDS = ...  # type: MovementStep
    VISUAL_POSITIONS = ...  # type: MovementStep
    WORDS = ...  # type: MovementStep


class NotebookTab(GObject.GEnum, builtins.int):
    FIRST = ...  # type: NotebookTab
    LAST = ...  # type: NotebookTab


class NumberUpLayout(GObject.GEnum, builtins.int):
    BTLR = ...  # type: NumberUpLayout
    BTRL = ...  # type: NumberUpLayout
    LRBT = ...  # type: NumberUpLayout
    LRTB = ...  # type: NumberUpLayout
    RLBT = ...  # type: NumberUpLayout
    RLTB = ...  # type: NumberUpLayout
    TBLR = ...  # type: NumberUpLayout
    TBRL = ...  # type: NumberUpLayout


class Orientation(GObject.GEnum, builtins.int):
    HORIZONTAL = ...  # type: Orientation
    VERTICAL = ...  # type: Orientation


class PackDirection(GObject.GEnum, builtins.int):
    BTT = ...  # type: PackDirection
    LTR = ...  # type: PackDirection
    RTL = ...  # type: PackDirection
    TTB = ...  # type: PackDirection


class PackType(GObject.GEnum, builtins.int):
    END = ...  # type: PackType
    START = ...  # type: PackType


class PadActionType(GObject.GEnum, builtins.int):
    BUTTON = ...  # type: PadActionType
    RING = ...  # type: PadActionType
    STRIP = ...  # type: PadActionType


class PageOrientation(GObject.GEnum, builtins.int):
    LANDSCAPE = ...  # type: PageOrientation
    PORTRAIT = ...  # type: PageOrientation
    REVERSE_LANDSCAPE = ...  # type: PageOrientation
    REVERSE_PORTRAIT = ...  # type: PageOrientation


class PageSet(GObject.GEnum, builtins.int):
    ALL = ...  # type: PageSet
    EVEN = ...  # type: PageSet
    ODD = ...  # type: PageSet


class PanDirection(GObject.GEnum, builtins.int):
    DOWN = ...  # type: PanDirection
    LEFT = ...  # type: PanDirection
    RIGHT = ...  # type: PanDirection
    UP = ...  # type: PanDirection


class PathPriorityType(GObject.GEnum, builtins.int):
    APPLICATION = ...  # type: PathPriorityType
    GTK = ...  # type: PathPriorityType
    HIGHEST = ...  # type: PathPriorityType
    LOWEST = ...  # type: PathPriorityType
    RC = ...  # type: PathPriorityType
    THEME = ...  # type: PathPriorityType


class PathType(GObject.GEnum, builtins.int):
    CLASS = ...  # type: PathType
    WIDGET = ...  # type: PathType
    WIDGET_CLASS = ...  # type: PathType


class PolicyType(GObject.GEnum, builtins.int):
    ALWAYS = ...  # type: PolicyType
    AUTOMATIC = ...  # type: PolicyType
    EXTERNAL = ...  # type: PolicyType
    NEVER = ...  # type: PolicyType


class PopoverConstraint(GObject.GEnum, builtins.int):
    NONE = ...  # type: PopoverConstraint
    WINDOW = ...  # type: PopoverConstraint


class PositionType(GObject.GEnum, builtins.int):
    BOTTOM = ...  # type: PositionType
    LEFT = ...  # type: PositionType
    RIGHT = ...  # type: PositionType
    TOP = ...  # type: PositionType


class PrintDuplex(GObject.GEnum, builtins.int):
    HORIZONTAL = ...  # type: PrintDuplex
    SIMPLEX = ...  # type: PrintDuplex
    VERTICAL = ...  # type: PrintDuplex


class PrintError(GObject.GEnum, builtins.int):
    GENERAL = ...  # type: PrintError
    INTERNAL_ERROR = ...  # type: PrintError
    INVALID_FILE = ...  # type: PrintError
    NOMEM = ...  # type: PrintError

    @staticmethod
    def quark() -> builtins.int: ...


class PrintOperationAction(GObject.GEnum, builtins.int):
    EXPORT = ...  # type: PrintOperationAction
    PREVIEW = ...  # type: PrintOperationAction
    PRINT = ...  # type: PrintOperationAction
    PRINT_DIALOG = ...  # type: PrintOperationAction


class PrintOperationResult(GObject.GEnum, builtins.int):
    APPLY = ...  # type: PrintOperationResult
    CANCEL = ...  # type: PrintOperationResult
    ERROR = ...  # type: PrintOperationResult
    IN_PROGRESS = ...  # type: PrintOperationResult


class PrintPages(GObject.GEnum, builtins.int):
    ALL = ...  # type: PrintPages
    CURRENT = ...  # type: PrintPages
    RANGES = ...  # type: PrintPages
    SELECTION = ...  # type: PrintPages


class PrintQuality(GObject.GEnum, builtins.int):
    DRAFT = ...  # type: PrintQuality
    HIGH = ...  # type: PrintQuality
    LOW = ...  # type: PrintQuality
    NORMAL = ...  # type: PrintQuality


class PrintStatus(GObject.GEnum, builtins.int):
    FINISHED = ...  # type: PrintStatus
    FINISHED_ABORTED = ...  # type: PrintStatus
    GENERATING_DATA = ...  # type: PrintStatus
    INITIAL = ...  # type: PrintStatus
    PENDING = ...  # type: PrintStatus
    PENDING_ISSUE = ...  # type: PrintStatus
    PREPARING = ...  # type: PrintStatus
    PRINTING = ...  # type: PrintStatus
    SENDING_DATA = ...  # type: PrintStatus


class PropagationPhase(GObject.GEnum, builtins.int):
    BUBBLE = ...  # type: PropagationPhase
    CAPTURE = ...  # type: PropagationPhase
    NONE = ...  # type: PropagationPhase
    TARGET = ...  # type: PropagationPhase


class RcTokenType(GObject.GEnum, builtins.int):
    ACTIVE = ...  # type: RcTokenType
    APPLICATION = ...  # type: RcTokenType
    BASE = ...  # type: RcTokenType
    BG = ...  # type: RcTokenType
    BG_PIXMAP = ...  # type: RcTokenType
    BIND = ...  # type: RcTokenType
    BINDING = ...  # type: RcTokenType
    CLASS = ...  # type: RcTokenType
    COLOR = ...  # type: RcTokenType
    ENGINE = ...  # type: RcTokenType
    FG = ...  # type: RcTokenType
    FONT = ...  # type: RcTokenType
    FONTSET = ...  # type: RcTokenType
    FONT_NAME = ...  # type: RcTokenType
    GTK = ...  # type: RcTokenType
    HIGHEST = ...  # type: RcTokenType
    IM_MODULE_FILE = ...  # type: RcTokenType
    IM_MODULE_PATH = ...  # type: RcTokenType
    INCLUDE = ...  # type: RcTokenType
    INSENSITIVE = ...  # type: RcTokenType
    INVALID = ...  # type: RcTokenType
    LAST = ...  # type: RcTokenType
    LOWEST = ...  # type: RcTokenType
    LTR = ...  # type: RcTokenType
    MODULE_PATH = ...  # type: RcTokenType
    NORMAL = ...  # type: RcTokenType
    PIXMAP_PATH = ...  # type: RcTokenType
    PRELIGHT = ...  # type: RcTokenType
    RC = ...  # type: RcTokenType
    RTL = ...  # type: RcTokenType
    SELECTED = ...  # type: RcTokenType
    STOCK = ...  # type: RcTokenType
    STYLE = ...  # type: RcTokenType
    TEXT = ...  # type: RcTokenType
    THEME = ...  # type: RcTokenType
    UNBIND = ...  # type: RcTokenType
    WIDGET = ...  # type: RcTokenType
    WIDGET_CLASS = ...  # type: RcTokenType
    XTHICKNESS = ...  # type: RcTokenType
    YTHICKNESS = ...  # type: RcTokenType


class RecentChooserError(GObject.GEnum, builtins.int):
    INVALID_URI = ...  # type: RecentChooserError
    NOT_FOUND = ...  # type: RecentChooserError

    @staticmethod
    def quark() -> builtins.int: ...


class RecentManagerError(GObject.GEnum, builtins.int):
    INVALID_ENCODING = ...  # type: RecentManagerError
    INVALID_URI = ...  # type: RecentManagerError
    NOT_FOUND = ...  # type: RecentManagerError
    NOT_REGISTERED = ...  # type: RecentManagerError
    READ = ...  # type: RecentManagerError
    UNKNOWN = ...  # type: RecentManagerError
    WRITE = ...  # type: RecentManagerError

    @staticmethod
    def quark() -> builtins.int: ...


class RecentSortType(GObject.GEnum, builtins.int):
    CUSTOM = ...  # type: RecentSortType
    LRU = ...  # type: RecentSortType
    MRU = ...  # type: RecentSortType
    NONE = ...  # type: RecentSortType


class ReliefStyle(GObject.GEnum, builtins.int):
    HALF = ...  # type: ReliefStyle
    NONE = ...  # type: ReliefStyle
    NORMAL = ...  # type: ReliefStyle


class ResizeMode(GObject.GEnum, builtins.int):
    IMMEDIATE = ...  # type: ResizeMode
    PARENT = ...  # type: ResizeMode
    QUEUE = ...  # type: ResizeMode


class ResponseType(GObject.GEnum, builtins.int):
    ACCEPT = ...  # type: ResponseType
    APPLY = ...  # type: ResponseType
    CANCEL = ...  # type: ResponseType
    CLOSE = ...  # type: ResponseType
    DELETE_EVENT = ...  # type: ResponseType
    HELP = ...  # type: ResponseType
    NO = ...  # type: ResponseType
    NONE = ...  # type: ResponseType
    OK = ...  # type: ResponseType
    REJECT = ...  # type: ResponseType
    YES = ...  # type: ResponseType


class RevealerTransitionType(GObject.GEnum, builtins.int):
    CROSSFADE = ...  # type: RevealerTransitionType
    NONE = ...  # type: RevealerTransitionType
    SLIDE_DOWN = ...  # type: RevealerTransitionType
    SLIDE_LEFT = ...  # type: RevealerTransitionType
    SLIDE_RIGHT = ...  # type: RevealerTransitionType
    SLIDE_UP = ...  # type: RevealerTransitionType


class ScrollStep(GObject.GEnum, builtins.int):
    ENDS = ...  # type: ScrollStep
    HORIZONTAL_ENDS = ...  # type: ScrollStep
    HORIZONTAL_PAGES = ...  # type: ScrollStep
    HORIZONTAL_STEPS = ...  # type: ScrollStep
    PAGES = ...  # type: ScrollStep
    STEPS = ...  # type: ScrollStep


class ScrollType(GObject.GEnum, builtins.int):
    END = ...  # type: ScrollType
    JUMP = ...  # type: ScrollType
    NONE = ...  # type: ScrollType
    PAGE_BACKWARD = ...  # type: ScrollType
    PAGE_DOWN = ...  # type: ScrollType
    PAGE_FORWARD = ...  # type: ScrollType
    PAGE_LEFT = ...  # type: ScrollType
    PAGE_RIGHT = ...  # type: ScrollType
    PAGE_UP = ...  # type: ScrollType
    START = ...  # type: ScrollType
    STEP_BACKWARD = ...  # type: ScrollType
    STEP_DOWN = ...  # type: ScrollType
    STEP_FORWARD = ...  # type: ScrollType
    STEP_LEFT = ...  # type: ScrollType
    STEP_RIGHT = ...  # type: ScrollType
    STEP_UP = ...  # type: ScrollType


class ScrollablePolicy(GObject.GEnum, builtins.int):
    MINIMUM = ...  # type: ScrollablePolicy
    NATURAL = ...  # type: ScrollablePolicy


class SelectionMode(GObject.GEnum, builtins.int):
    BROWSE = ...  # type: SelectionMode
    MULTIPLE = ...  # type: SelectionMode
    NONE = ...  # type: SelectionMode
    SINGLE = ...  # type: SelectionMode


class SensitivityType(GObject.GEnum, builtins.int):
    AUTO = ...  # type: SensitivityType
    OFF = ...  # type: SensitivityType
    ON = ...  # type: SensitivityType


class ShadowType(GObject.GEnum, builtins.int):
    ETCHED_IN = ...  # type: ShadowType
    ETCHED_OUT = ...  # type: ShadowType
    IN = ...  # type: ShadowType
    NONE = ...  # type: ShadowType
    OUT = ...  # type: ShadowType


class ShortcutType(GObject.GEnum, builtins.int):
    ACCELERATOR = ...  # type: ShortcutType
    GESTURE = ...  # type: ShortcutType
    GESTURE_PINCH = ...  # type: ShortcutType
    GESTURE_ROTATE_CLOCKWISE = ...  # type: ShortcutType
    GESTURE_ROTATE_COUNTERCLOCKWISE = ...  # type: ShortcutType
    GESTURE_STRETCH = ...  # type: ShortcutType
    GESTURE_TWO_FINGER_SWIPE_LEFT = ...  # type: ShortcutType
    GESTURE_TWO_FINGER_SWIPE_RIGHT = ...  # type: ShortcutType


class SizeGroupMode(GObject.GEnum, builtins.int):
    BOTH = ...  # type: SizeGroupMode
    HORIZONTAL = ...  # type: SizeGroupMode
    NONE = ...  # type: SizeGroupMode
    VERTICAL = ...  # type: SizeGroupMode


class SizeRequestMode(GObject.GEnum, builtins.int):
    CONSTANT_SIZE = ...  # type: SizeRequestMode
    HEIGHT_FOR_WIDTH = ...  # type: SizeRequestMode
    WIDTH_FOR_HEIGHT = ...  # type: SizeRequestMode


class SortType(GObject.GEnum, builtins.int):
    ASCENDING = ...  # type: SortType
    DESCENDING = ...  # type: SortType


class SpinButtonUpdatePolicy(GObject.GEnum, builtins.int):
    ALWAYS = ...  # type: SpinButtonUpdatePolicy
    IF_VALID = ...  # type: SpinButtonUpdatePolicy


class SpinType(GObject.GEnum, builtins.int):
    END = ...  # type: SpinType
    HOME = ...  # type: SpinType
    PAGE_BACKWARD = ...  # type: SpinType
    PAGE_FORWARD = ...  # type: SpinType
    STEP_BACKWARD = ...  # type: SpinType
    STEP_FORWARD = ...  # type: SpinType
    USER_DEFINED = ...  # type: SpinType


class StackTransitionType(GObject.GEnum, builtins.int):
    CROSSFADE = ...  # type: StackTransitionType
    NONE = ...  # type: StackTransitionType
    OVER_DOWN = ...  # type: StackTransitionType
    OVER_DOWN_UP = ...  # type: StackTransitionType
    OVER_LEFT = ...  # type: StackTransitionType
    OVER_LEFT_RIGHT = ...  # type: StackTransitionType
    OVER_RIGHT = ...  # type: StackTransitionType
    OVER_RIGHT_LEFT = ...  # type: StackTransitionType
    OVER_UP = ...  # type: StackTransitionType
    OVER_UP_DOWN = ...  # type: StackTransitionType
    SLIDE_DOWN = ...  # type: StackTransitionType
    SLIDE_LEFT = ...  # type: StackTransitionType
    SLIDE_LEFT_RIGHT = ...  # type: StackTransitionType
    SLIDE_RIGHT = ...  # type: StackTransitionType
    SLIDE_UP = ...  # type: StackTransitionType
    SLIDE_UP_DOWN = ...  # type: StackTransitionType
    UNDER_DOWN = ...  # type: StackTransitionType
    UNDER_LEFT = ...  # type: StackTransitionType
    UNDER_RIGHT = ...  # type: StackTransitionType
    UNDER_UP = ...  # type: StackTransitionType


class StateType(GObject.GEnum, builtins.int):
    ACTIVE = ...  # type: StateType
    FOCUSED = ...  # type: StateType
    INCONSISTENT = ...  # type: StateType
    INSENSITIVE = ...  # type: StateType
    NORMAL = ...  # type: StateType
    PRELIGHT = ...  # type: StateType
    SELECTED = ...  # type: StateType


class TextBufferTargetInfo(GObject.GEnum, builtins.int):
    BUFFER_CONTENTS = ...  # type: TextBufferTargetInfo
    RICH_TEXT = ...  # type: TextBufferTargetInfo
    TEXT = ...  # type: TextBufferTargetInfo


class TextDirection(GObject.GEnum, builtins.int):
    LTR = ...  # type: TextDirection
    NONE = ...  # type: TextDirection
    RTL = ...  # type: TextDirection


class TextExtendSelection(GObject.GEnum, builtins.int):
    LINE = ...  # type: TextExtendSelection
    WORD = ...  # type: TextExtendSelection


class TextViewLayer(GObject.GEnum, builtins.int):
    ABOVE = ...  # type: TextViewLayer
    ABOVE_TEXT = ...  # type: TextViewLayer
    BELOW = ...  # type: TextViewLayer
    BELOW_TEXT = ...  # type: TextViewLayer


class TextWindowType(GObject.GEnum, builtins.int):
    BOTTOM = ...  # type: TextWindowType
    LEFT = ...  # type: TextWindowType
    PRIVATE = ...  # type: TextWindowType
    RIGHT = ...  # type: TextWindowType
    TEXT = ...  # type: TextWindowType
    TOP = ...  # type: TextWindowType
    WIDGET = ...  # type: TextWindowType


class ToolbarSpaceStyle(GObject.GEnum, builtins.int):
    EMPTY = ...  # type: ToolbarSpaceStyle
    LINE = ...  # type: ToolbarSpaceStyle


class ToolbarStyle(GObject.GEnum, builtins.int):
    BOTH = ...  # type: ToolbarStyle
    BOTH_HORIZ = ...  # type: ToolbarStyle
    ICONS = ...  # type: ToolbarStyle
    TEXT = ...  # type: ToolbarStyle


class TreeViewColumnSizing(GObject.GEnum, builtins.int):
    AUTOSIZE = ...  # type: TreeViewColumnSizing
    FIXED = ...  # type: TreeViewColumnSizing
    GROW_ONLY = ...  # type: TreeViewColumnSizing


class TreeViewDropPosition(GObject.GEnum, builtins.int):
    AFTER = ...  # type: TreeViewDropPosition
    BEFORE = ...  # type: TreeViewDropPosition
    INTO_OR_AFTER = ...  # type: TreeViewDropPosition
    INTO_OR_BEFORE = ...  # type: TreeViewDropPosition


class TreeViewGridLines(GObject.GEnum, builtins.int):
    BOTH = ...  # type: TreeViewGridLines
    HORIZONTAL = ...  # type: TreeViewGridLines
    NONE = ...  # type: TreeViewGridLines
    VERTICAL = ...  # type: TreeViewGridLines


class Unit(GObject.GEnum, builtins.int):
    INCH = ...  # type: Unit
    MM = ...  # type: Unit
    NONE = ...  # type: Unit
    POINTS = ...  # type: Unit


class WidgetHelpType(GObject.GEnum, builtins.int):
    TOOLTIP = ...  # type: WidgetHelpType
    WHATS_THIS = ...  # type: WidgetHelpType


class WindowPosition(GObject.GEnum, builtins.int):
    CENTER = ...  # type: WindowPosition
    CENTER_ALWAYS = ...  # type: WindowPosition
    CENTER_ON_PARENT = ...  # type: WindowPosition
    MOUSE = ...  # type: WindowPosition
    NONE = ...  # type: WindowPosition


class WindowType(GObject.GEnum, builtins.int):
    POPUP = ...  # type: WindowType
    TOPLEVEL = ...  # type: WindowType


class WrapMode(GObject.GEnum, builtins.int):
    CHAR = ...  # type: WrapMode
    NONE = ...  # type: WrapMode
    WORD = ...  # type: WrapMode
    WORD_CHAR = ...  # type: WrapMode


AccelGroupActivate = typing.Callable[[AccelGroup, GObject.Object, builtins.int, Gdk.ModifierType], builtins.bool]
AccelGroupFindFunc = typing.Callable[[AccelKey, GObject.Closure, typing.Optional[builtins.object]], builtins.bool]
AccelMapForeach = typing.Callable[[typing.Optional[builtins.object], builtins.str, builtins.int, Gdk.ModifierType, builtins.bool], None]
AssistantPageFunc = typing.Callable[[builtins.int, typing.Optional[builtins.object]], builtins.int]
BuilderConnectFunc = typing.Callable[[Builder, GObject.Object, builtins.str, builtins.str, typing.Optional[GObject.Object], GObject.ConnectFlags, typing.Optional[builtins.object]], None]
CalendarDetailFunc = typing.Callable[[Calendar, builtins.int, builtins.int, builtins.int, typing.Optional[builtins.object]], typing.Optional[builtins.str]]
Callback = typing.Callable[[Widget, typing.Optional[builtins.object]], None]
CellAllocCallback = typing.Callable[[CellRenderer, Gdk.Rectangle, Gdk.Rectangle, typing.Optional[builtins.object]], builtins.bool]
CellCallback = typing.Callable[[CellRenderer, typing.Optional[builtins.object]], builtins.bool]
CellLayoutDataFunc = typing.Callable[[CellLayout, CellRenderer, TreeModel, TreeIter, typing.Optional[builtins.object]], None]
ClipboardClearFunc = typing.Callable[[Clipboard, typing.Optional[builtins.object]], None]
ClipboardGetFunc = typing.Callable[[Clipboard, SelectionData, builtins.int, typing.Optional[builtins.object]], None]
ClipboardImageReceivedFunc = typing.Callable[[Clipboard, GdkPixbuf.Pixbuf, typing.Optional[builtins.object]], None]
ClipboardReceivedFunc = typing.Callable[[Clipboard, SelectionData, typing.Optional[builtins.object]], None]
ClipboardRichTextReceivedFunc = typing.Callable[[Clipboard, Gdk.Atom, typing.Optional[builtins.str], builtins.int, typing.Optional[builtins.object]], None]
ClipboardTargetsReceivedFunc = typing.Callable[[Clipboard, typing.Optional[typing.Sequence[Gdk.Atom]], typing.Optional[builtins.object]], None]
ClipboardTextReceivedFunc = typing.Callable[[Clipboard, typing.Optional[builtins.str], typing.Optional[builtins.object]], None]
ClipboardURIReceivedFunc = typing.Callable[[Clipboard, typing.Sequence[builtins.str], typing.Optional[builtins.object]], None]
ColorSelectionChangePaletteFunc = typing.Callable[[typing.Sequence[Gdk.Color]], None]
ColorSelectionChangePaletteWithScreenFunc = typing.Callable[[Gdk.Screen, typing.Sequence[Gdk.Color]], None]
EntryCompletionMatchFunc = typing.Callable[[EntryCompletion, builtins.str, TreeIter, typing.Optional[builtins.object]], builtins.bool]
FileFilterFunc = typing.Callable[[FileFilterInfo, typing.Optional[builtins.object]], builtins.bool]
FlowBoxCreateWidgetFunc = typing.Callable[[GObject.Object, typing.Optional[builtins.object]], Widget]
FlowBoxFilterFunc = typing.Callable[[FlowBoxChild, typing.Optional[builtins.object]], builtins.bool]
FlowBoxForeachFunc = typing.Callable[[FlowBox, FlowBoxChild, typing.Optional[builtins.object]], None]
FlowBoxSortFunc = typing.Callable[[FlowBoxChild, FlowBoxChild, typing.Optional[builtins.object]], builtins.int]
FontFilterFunc = typing.Callable[[Pango.FontFamily, Pango.FontFace, typing.Optional[builtins.object]], builtins.bool]
IconViewForeachFunc = typing.Callable[[IconView, TreePath, typing.Optional[builtins.object]], None]
KeySnoopFunc = typing.Callable[[Widget, Gdk.EventKey, typing.Optional[builtins.object]], builtins.int]
ListBoxCreateWidgetFunc = typing.Callable[[GObject.Object, typing.Optional[builtins.object]], Widget]
ListBoxFilterFunc = typing.Callable[[ListBoxRow, typing.Optional[builtins.object]], builtins.bool]
ListBoxForeachFunc = typing.Callable[[ListBox, ListBoxRow, typing.Optional[builtins.object]], None]
ListBoxSortFunc = typing.Callable[[ListBoxRow, ListBoxRow, typing.Optional[builtins.object]], builtins.int]
ListBoxUpdateHeaderFunc = typing.Callable[[ListBoxRow, typing.Optional[ListBoxRow], typing.Optional[builtins.object]], None]
MenuDetachFunc = typing.Callable[[Widget, Menu], None]
MenuPositionFunc = typing.Callable[[Menu, builtins.int, builtins.int, typing.Optional[builtins.object]], typing.Tuple[builtins.int, builtins.int, builtins.bool]]
ModuleDisplayInitFunc = typing.Callable[[Gdk.Display], None]
ModuleInitFunc = typing.Callable[[typing.Optional[typing.Sequence[builtins.str]]], None]
PageSetupDoneFunc = typing.Callable[[PageSetup, typing.Optional[builtins.object]], None]
PrintSettingsFunc = typing.Callable[[builtins.str, builtins.str, typing.Optional[builtins.object]], None]
RcPropertyParser = typing.Callable[[GObject.ParamSpec, GLib.String, GObject.Value], builtins.bool]
RecentFilterFunc = typing.Callable[[RecentFilterInfo, typing.Optional[builtins.object]], builtins.bool]
RecentSortFunc = typing.Callable[[RecentInfo, RecentInfo, typing.Optional[builtins.object]], builtins.int]
StylePropertyParser = typing.Callable[[builtins.str, GObject.Value], builtins.bool]
TextBufferDeserializeFunc = typing.Callable[[TextBuffer, TextBuffer, TextIter, builtins.bytes, builtins.bool, typing.Optional[builtins.object]], builtins.bool]
TextBufferSerializeFunc = typing.Callable[[TextBuffer, TextBuffer, TextIter, TextIter, builtins.int, typing.Optional[builtins.object]], typing.Optional[builtins.int]]
TextCharPredicate = typing.Callable[[builtins.str, typing.Optional[builtins.object]], builtins.bool]
TextTagTableForeach = typing.Callable[[TextTag, typing.Optional[builtins.object]], None]
TickCallback = typing.Callable[[Widget, Gdk.FrameClock, typing.Optional[builtins.object]], builtins.bool]
TranslateFunc = typing.Callable[[builtins.str, typing.Optional[builtins.object]], builtins.str]
TreeCellDataFunc = typing.Callable[[TreeViewColumn, CellRenderer, TreeModelFilter, TreeIter, typing.Optional[builtins.object]], None]
TreeDestroyCountFunc = typing.Callable[[TreeView, TreePath, builtins.int, typing.Optional[builtins.object]], None]
TreeIterCompareFunc = typing.Callable[[TreeModel, TreeIter, TreeIter, typing.Optional[builtins.object]], builtins.int]
TreeModelFilterModifyFunc = typing.Callable[[TreeModel, TreeIter, builtins.int, typing.Optional[builtins.object]], GObject.Value]
TreeModelFilterVisibleFunc = typing.Callable[[TreeModel, TreeIter, typing.Optional[builtins.object]], builtins.bool]
TreeModelForeachFunc = typing.Callable[[TreeModel, TreePath, TreeIter, typing.Optional[builtins.object]], builtins.bool]
TreeSelectionForeachFunc = typing.Callable[[TreeModel, TreePath, TreeIter, typing.Optional[builtins.object]], None]
TreeSelectionFunc = typing.Callable[[TreeSelection, TreeModel, TreePath, builtins.bool, typing.Optional[builtins.object]], builtins.bool]
TreeViewColumnDropFunc = typing.Callable[[TreeView, TreeViewColumn, TreeViewColumn, TreeViewColumn, typing.Optional[builtins.object]], builtins.bool]
TreeViewMappingFunc = typing.Callable[[TreeView, TreePath, typing.Optional[builtins.object]], None]
TreeViewRowSeparatorFunc = typing.Callable[[TreeModel, TreeIter, typing.Optional[builtins.object]], builtins.bool]
TreeViewSearchEqualFunc = typing.Callable[[TreeModel, builtins.int, builtins.str, TreeIter, typing.Optional[builtins.object]], builtins.bool]
TreeViewSearchPositionFunc = typing.Callable[[TreeView, Widget, typing.Optional[builtins.object]], None]


def accel_groups_activate(object: GObject.Object, accel_key: builtins.int, accel_mods: Gdk.ModifierType) -> builtins.bool: ...


def accel_groups_from_object(object: GObject.Object) -> typing.Sequence[AccelGroup]: ...


def accelerator_get_default_mod_mask() -> Gdk.ModifierType: ...


def accelerator_get_label(accelerator_key: builtins.int, accelerator_mods: Gdk.ModifierType) -> builtins.str: ...


def accelerator_get_label_with_keycode(display: typing.Optional[Gdk.Display], accelerator_key: builtins.int, keycode: builtins.int, accelerator_mods: Gdk.ModifierType) -> builtins.str: ...


def accelerator_name(accelerator_key: builtins.int, accelerator_mods: Gdk.ModifierType) -> builtins.str: ...


def accelerator_name_with_keycode(display: typing.Optional[Gdk.Display], accelerator_key: builtins.int, keycode: builtins.int, accelerator_mods: Gdk.ModifierType) -> builtins.str: ...


def accelerator_parse(accelerator: builtins.str) -> typing.Tuple[builtins.int, Gdk.ModifierType]: ...


def accelerator_parse_with_keycode(accelerator: builtins.str) -> typing.Tuple[builtins.int, typing.Sequence[builtins.int], Gdk.ModifierType]: ...


def accelerator_set_default_mod_mask(default_mod_mask: Gdk.ModifierType) -> None: ...


def accelerator_valid(keyval: builtins.int, modifiers: Gdk.ModifierType) -> builtins.bool: ...


def alternative_dialog_button_order(screen: typing.Optional[Gdk.Screen]) -> builtins.bool: ...


def binding_entry_add_signal_from_string(binding_set: BindingSet, signal_desc: builtins.str) -> GLib.TokenType: ...


def binding_entry_add_signall(binding_set: BindingSet, keyval: builtins.int, modifiers: Gdk.ModifierType, signal_name: builtins.str, binding_args: typing.Sequence[BindingArg]) -> None: ...


def binding_entry_remove(binding_set: BindingSet, keyval: builtins.int, modifiers: Gdk.ModifierType) -> None: ...


def binding_entry_skip(binding_set: BindingSet, keyval: builtins.int, modifiers: Gdk.ModifierType) -> None: ...


def binding_set_find(set_name: builtins.str) -> typing.Optional[BindingSet]: ...


def bindings_activate(object: GObject.Object, keyval: builtins.int, modifiers: Gdk.ModifierType) -> builtins.bool: ...


def bindings_activate_event(object: GObject.Object, event: Gdk.EventKey) -> builtins.bool: ...


def builder_error_quark() -> builtins.int: ...


def cairo_should_draw_window(cr: cairo.Context, window: Gdk.Window) -> builtins.bool: ...


def cairo_transform_to_window(cr: cairo.Context, widget: Widget, window: Gdk.Window) -> None: ...


def check_version(required_major: builtins.int, required_minor: builtins.int, required_micro: builtins.int) -> typing.Optional[builtins.str]: ...


def css_provider_error_quark() -> builtins.int: ...


def device_grab_add(widget: Widget, device: Gdk.Device, block_others: builtins.bool) -> None: ...


def device_grab_remove(widget: Widget, device: Gdk.Device) -> None: ...


def disable_setlocale() -> None: ...


def distribute_natural_allocation(extra_space: builtins.int, n_requested_sizes: builtins.int, sizes: RequestedSize) -> builtins.int: ...


def drag_cancel(context: Gdk.DragContext) -> None: ...


def drag_finish(context: Gdk.DragContext, success: builtins.bool, del_: builtins.bool, time_: builtins.int) -> None: ...


def drag_get_source_widget(context: Gdk.DragContext) -> typing.Optional[Widget]: ...


def drag_set_icon_default(context: Gdk.DragContext) -> None: ...


def drag_set_icon_gicon(context: Gdk.DragContext, icon: Gio.Icon, hot_x: builtins.int, hot_y: builtins.int) -> None: ...


def drag_set_icon_name(context: Gdk.DragContext, icon_name: builtins.str, hot_x: builtins.int, hot_y: builtins.int) -> None: ...


def drag_set_icon_pixbuf(context: Gdk.DragContext, pixbuf: GdkPixbuf.Pixbuf, hot_x: builtins.int, hot_y: builtins.int) -> None: ...


def drag_set_icon_stock(context: Gdk.DragContext, stock_id: builtins.str, hot_x: builtins.int, hot_y: builtins.int) -> None: ...


def drag_set_icon_surface(context: Gdk.DragContext, surface: cairo.Surface) -> None: ...


def drag_set_icon_widget(context: Gdk.DragContext, widget: Widget, hot_x: builtins.int, hot_y: builtins.int) -> None: ...


def draw_insertion_cursor(widget: Widget, cr: cairo.Context, location: Gdk.Rectangle, is_primary: builtins.bool, direction: TextDirection, draw_arrow: builtins.bool) -> None: ...


def events_pending() -> builtins.bool: ...


def false() -> builtins.bool: ...


def file_chooser_error_quark() -> builtins.int: ...


def get_binary_age() -> builtins.int: ...


def get_current_event() -> typing.Optional[Gdk.Event]: ...


def get_current_event_device() -> typing.Optional[Gdk.Device]: ...


def get_current_event_state() -> typing.Tuple[builtins.bool, Gdk.ModifierType]: ...


def get_current_event_time() -> builtins.int: ...


def get_debug_flags() -> builtins.int: ...


def get_default_language() -> Pango.Language: ...


def get_event_widget(event: Gdk.Event) -> typing.Optional[Widget]: ...


def get_interface_age() -> builtins.int: ...


def get_locale_direction() -> TextDirection: ...


def get_major_version() -> builtins.int: ...


def get_micro_version() -> builtins.int: ...


def get_minor_version() -> builtins.int: ...


def get_option_group(open_default_display: builtins.bool) -> GLib.OptionGroup: ...


def grab_get_current() -> typing.Optional[Widget]: ...


def icon_size_from_name(name: builtins.str) -> builtins.int: ...


def icon_size_get_name(size: builtins.int) -> builtins.str: ...


def icon_size_lookup(size: builtins.int) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...


def icon_size_lookup_for_settings(settings: Settings, size: builtins.int) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...


def icon_size_register(name: builtins.str, width: builtins.int, height: builtins.int) -> builtins.int: ...


def icon_size_register_alias(alias: builtins.str, target: builtins.int) -> None: ...


def icon_theme_error_quark() -> builtins.int: ...


def init(argv: typing.Optional[typing.Sequence[builtins.str]]) -> typing.Sequence[builtins.str]: ...


def init_check(argv: typing.Optional[typing.Sequence[builtins.str]]) -> typing.Tuple[builtins.bool, typing.Sequence[builtins.str]]: ...


def init_with_args(argv: typing.Optional[typing.Sequence[builtins.str]], parameter_string: typing.Optional[builtins.str], entries: typing.Sequence[GLib.OptionEntry], translation_domain: typing.Optional[builtins.str]) -> typing.Tuple[builtins.bool, typing.Sequence[builtins.str]]: ...


def key_snooper_remove(snooper_handler_id: builtins.int) -> None: ...


def main() -> None: ...


def main_do_event(event: Gdk.Event) -> None: ...


def main_iteration() -> builtins.bool: ...


def main_iteration_do(blocking: builtins.bool) -> builtins.bool: ...


def main_level() -> builtins.int: ...


def main_quit() -> None: ...


def paint_arrow(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], arrow_type: ArrowType, fill: builtins.bool, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_box(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_box_gap(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, gap_side: PositionType, gap_x: builtins.int, gap_width: builtins.int) -> None: ...


def paint_check(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_diamond(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_expander(style: Style, cr: cairo.Context, state_type: StateType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, expander_style: ExpanderStyle) -> None: ...


def paint_extension(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, gap_side: PositionType) -> None: ...


def paint_flat_box(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_focus(style: Style, cr: cairo.Context, state_type: StateType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_handle(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, orientation: Orientation) -> None: ...


def paint_hline(style: Style, cr: cairo.Context, state_type: StateType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x1: builtins.int, x2: builtins.int, y: builtins.int) -> None: ...


def paint_layout(style: Style, cr: cairo.Context, state_type: StateType, use_text: builtins.bool, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, layout: Pango.Layout) -> None: ...


def paint_option(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_resize_grip(style: Style, cr: cairo.Context, state_type: StateType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], edge: Gdk.WindowEdge, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_shadow(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_shadow_gap(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, gap_side: PositionType, gap_x: builtins.int, gap_width: builtins.int) -> None: ...


def paint_slider(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int, orientation: Orientation) -> None: ...


def paint_spinner(style: Style, cr: cairo.Context, state_type: StateType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], step: builtins.int, x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_tab(style: Style, cr: cairo.Context, state_type: StateType, shadow_type: ShadowType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], x: builtins.int, y: builtins.int, width: builtins.int, height: builtins.int) -> None: ...


def paint_vline(style: Style, cr: cairo.Context, state_type: StateType, widget: typing.Optional[Widget], detail: typing.Optional[builtins.str], y1_: builtins.int, y2_: builtins.int, x: builtins.int) -> None: ...


def paper_size_get_default() -> builtins.str: ...


def paper_size_get_paper_sizes(include_custom: builtins.bool) -> typing.Sequence[PaperSize]: ...


def parse_args(argv: typing.Sequence[builtins.str]) -> typing.Tuple[builtins.bool, typing.Sequence[builtins.str]]: ...


def print_error_quark() -> builtins.int: ...


def print_run_page_setup_dialog(parent: typing.Optional[Window], page_setup: typing.Optional[PageSetup], settings: PrintSettings) -> PageSetup: ...


def print_run_page_setup_dialog_async(parent: typing.Optional[Window], page_setup: typing.Optional[PageSetup], settings: PrintSettings, done_cb: PageSetupDoneFunc, *data: typing.Optional[builtins.object]) -> None: ...


def propagate_event(widget: Widget, event: Gdk.Event) -> None: ...


def rc_add_default_file(filename: builtins.str) -> None: ...


def rc_find_module_in_path(module_file: builtins.str) -> builtins.str: ...


def rc_find_pixmap_in_path(settings: Settings, scanner: GLib.Scanner, pixmap_file: builtins.str) -> builtins.str: ...


def rc_get_default_files() -> typing.Sequence[builtins.str]: ...


def rc_get_im_module_file() -> builtins.str: ...


def rc_get_im_module_path() -> builtins.str: ...


def rc_get_module_dir() -> builtins.str: ...


def rc_get_style(widget: Widget) -> Style: ...


def rc_get_style_by_paths(settings: Settings, widget_path: typing.Optional[builtins.str], class_path: typing.Optional[builtins.str], type: GObject.GType) -> typing.Optional[Style]: ...


def rc_get_theme_dir() -> builtins.str: ...


def rc_parse(filename: builtins.str) -> None: ...


def rc_parse_color(scanner: GLib.Scanner) -> typing.Tuple[builtins.int, Gdk.Color]: ...


def rc_parse_color_full(scanner: GLib.Scanner, style: typing.Optional[RcStyle]) -> typing.Tuple[builtins.int, Gdk.Color]: ...


def rc_parse_priority(scanner: GLib.Scanner, priority: PathPriorityType) -> builtins.int: ...


def rc_parse_state(scanner: GLib.Scanner) -> typing.Tuple[builtins.int, StateType]: ...


def rc_parse_string(rc_string: builtins.str) -> None: ...


def rc_property_parse_border(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...


def rc_property_parse_color(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...


def rc_property_parse_enum(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...


def rc_property_parse_flags(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...


def rc_property_parse_requisition(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> builtins.bool: ...


def rc_reparse_all() -> builtins.bool: ...


def rc_reparse_all_for_settings(settings: Settings, force_load: builtins.bool) -> builtins.bool: ...


def rc_reset_styles(settings: Settings) -> None: ...


def rc_set_default_files(filenames: typing.Sequence[builtins.str]) -> None: ...


def recent_chooser_error_quark() -> builtins.int: ...


def recent_manager_error_quark() -> builtins.int: ...


def render_activity(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...


def render_arrow(context: StyleContext, cr: cairo.Context, angle: builtins.float, x: builtins.float, y: builtins.float, size: builtins.float) -> None: ...


def render_background(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...


def render_background_get_clip(context: StyleContext, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> Gdk.Rectangle: ...


def render_check(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...


def render_expander(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...


def render_extension(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float, gap_side: PositionType) -> None: ...


def render_focus(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...


def render_frame(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...


def render_frame_gap(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float, gap_side: PositionType, xy0_gap: builtins.float, xy1_gap: builtins.float) -> None: ...


def render_handle(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...


def render_icon(context: StyleContext, cr: cairo.Context, pixbuf: GdkPixbuf.Pixbuf, x: builtins.float, y: builtins.float) -> None: ...


def render_icon_pixbuf(context: StyleContext, source: IconSource, size: builtins.int) -> GdkPixbuf.Pixbuf: ...


def render_icon_surface(context: StyleContext, cr: cairo.Context, surface: cairo.Surface, x: builtins.float, y: builtins.float) -> None: ...


def render_insertion_cursor(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, layout: Pango.Layout, index: builtins.int, direction: Pango.Direction) -> None: ...


def render_layout(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, layout: Pango.Layout) -> None: ...


def render_line(context: StyleContext, cr: cairo.Context, x0: builtins.float, y0: builtins.float, x1: builtins.float, y1: builtins.float) -> None: ...


def render_option(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float) -> None: ...


def render_slider(context: StyleContext, cr: cairo.Context, x: builtins.float, y: builtins.float, width: builtins.float, height: builtins.float, orientation: Orientation) -> None: ...


def rgb_to_hsv(r: builtins.float, g: builtins.float, b: builtins.float) -> typing.Tuple[builtins.float, builtins.float, builtins.float]: ...


def selection_add_target(widget: Widget, selection: Gdk.Atom, target: Gdk.Atom, info: builtins.int) -> None: ...


def selection_add_targets(widget: Widget, selection: Gdk.Atom, targets: typing.Sequence[TargetEntry]) -> None: ...


def selection_clear_targets(widget: Widget, selection: Gdk.Atom) -> None: ...


def selection_convert(widget: Widget, selection: Gdk.Atom, target: Gdk.Atom, time_: builtins.int) -> builtins.bool: ...


def selection_owner_set(widget: typing.Optional[Widget], selection: Gdk.Atom, time_: builtins.int) -> builtins.bool: ...


def selection_owner_set_for_display(display: Gdk.Display, widget: typing.Optional[Widget], selection: Gdk.Atom, time_: builtins.int) -> builtins.bool: ...


def selection_remove_all(widget: Widget) -> None: ...


def set_debug_flags(flags: builtins.int) -> None: ...


def show_uri(screen: typing.Optional[Gdk.Screen], uri: builtins.str, timestamp: builtins.int) -> builtins.bool: ...


def show_uri_on_window(parent: typing.Optional[Window], uri: builtins.str, timestamp: builtins.int) -> builtins.bool: ...


def stock_add(items: typing.Sequence[StockItem]) -> None: ...


def stock_add_static(items: typing.Sequence[StockItem]) -> None: ...


def stock_list_ids() -> typing.Sequence[builtins.str]: ...


def stock_lookup(stock_id: builtins.str) -> typing.Tuple[builtins.bool, StockItem]: ...


def stock_set_translate_func(domain: builtins.str, func: TranslateFunc, *data: typing.Optional[builtins.object]) -> None: ...


def target_table_free(targets: typing.Sequence[TargetEntry]) -> None: ...


def target_table_new_from_list(list: TargetList) -> typing.Sequence[TargetEntry]: ...


def targets_include_image(targets: typing.Sequence[Gdk.Atom], writable: builtins.bool) -> builtins.bool: ...


def targets_include_rich_text(targets: typing.Sequence[Gdk.Atom], buffer: TextBuffer) -> builtins.bool: ...


def targets_include_text(targets: typing.Sequence[Gdk.Atom]) -> builtins.bool: ...


def targets_include_uri(targets: typing.Sequence[Gdk.Atom]) -> builtins.bool: ...


def test_create_simple_window(window_title: builtins.str, dialog_text: builtins.str) -> Widget: ...


def test_find_label(widget: Widget, label_pattern: builtins.str) -> Widget: ...


def test_find_sibling(base_widget: Widget, widget_type: GObject.GType) -> Widget: ...


def test_find_widget(widget: Widget, label_pattern: builtins.str, widget_type: GObject.GType) -> typing.Optional[Widget]: ...


def test_list_all_types() -> typing.Sequence[GObject.GType]: ...


def test_register_all_types() -> None: ...


def test_slider_get_value(widget: Widget) -> builtins.float: ...


def test_slider_set_perc(widget: Widget, percentage: builtins.float) -> None: ...


def test_spin_button_click(spinner: SpinButton, button: builtins.int, upwards: builtins.bool) -> builtins.bool: ...


def test_text_get(widget: Widget) -> builtins.str: ...


def test_text_set(widget: Widget, string: builtins.str) -> None: ...


def test_widget_click(widget: Widget, button: builtins.int, modifiers: Gdk.ModifierType) -> builtins.bool: ...


def test_widget_send_key(widget: Widget, keyval: builtins.int, modifiers: Gdk.ModifierType) -> builtins.bool: ...


def test_widget_wait_for_draw(widget: Widget) -> None: ...


def tree_get_row_drag_data(selection_data: SelectionData) -> typing.Tuple[builtins.bool, typing.Optional[TreeModel], typing.Optional[TreePath]]: ...


def tree_row_reference_deleted(proxy: GObject.Object, path: TreePath) -> None: ...


def tree_row_reference_inserted(proxy: GObject.Object, path: TreePath) -> None: ...


def tree_set_row_drag_data(selection_data: SelectionData, tree_model: TreeModel, path: TreePath) -> builtins.bool: ...


def true() -> builtins.bool: ...


BINARY_AGE: builtins.int
INPUT_ERROR: builtins.int
INTERFACE_AGE: builtins.int
LEVEL_BAR_OFFSET_FULL: builtins.str
LEVEL_BAR_OFFSET_HIGH: builtins.str
LEVEL_BAR_OFFSET_LOW: builtins.str
MAJOR_VERSION: builtins.int
MAX_COMPOSE_LEN: builtins.int
MICRO_VERSION: builtins.int
MINOR_VERSION: builtins.int
PAPER_NAME_A3: builtins.str
PAPER_NAME_A4: builtins.str
PAPER_NAME_A5: builtins.str
PAPER_NAME_B5: builtins.str
PAPER_NAME_EXECUTIVE: builtins.str
PAPER_NAME_LEGAL: builtins.str
PAPER_NAME_LETTER: builtins.str
PATH_PRIO_MASK: builtins.int
PRINT_SETTINGS_COLLATE: builtins.str
PRINT_SETTINGS_DEFAULT_SOURCE: builtins.str
PRINT_SETTINGS_DITHER: builtins.str
PRINT_SETTINGS_DUPLEX: builtins.str
PRINT_SETTINGS_FINISHINGS: builtins.str
PRINT_SETTINGS_MEDIA_TYPE: builtins.str
PRINT_SETTINGS_NUMBER_UP: builtins.str
PRINT_SETTINGS_NUMBER_UP_LAYOUT: builtins.str
PRINT_SETTINGS_N_COPIES: builtins.str
PRINT_SETTINGS_ORIENTATION: builtins.str
PRINT_SETTINGS_OUTPUT_BASENAME: builtins.str
PRINT_SETTINGS_OUTPUT_BIN: builtins.str
PRINT_SETTINGS_OUTPUT_DIR: builtins.str
PRINT_SETTINGS_OUTPUT_FILE_FORMAT: builtins.str
PRINT_SETTINGS_OUTPUT_URI: builtins.str
PRINT_SETTINGS_PAGE_RANGES: builtins.str
PRINT_SETTINGS_PAGE_SET: builtins.str
PRINT_SETTINGS_PAPER_FORMAT: builtins.str
PRINT_SETTINGS_PAPER_HEIGHT: builtins.str
PRINT_SETTINGS_PAPER_WIDTH: builtins.str
PRINT_SETTINGS_PRINTER: builtins.str
PRINT_SETTINGS_PRINTER_LPI: builtins.str
PRINT_SETTINGS_PRINT_PAGES: builtins.str
PRINT_SETTINGS_QUALITY: builtins.str
PRINT_SETTINGS_RESOLUTION: builtins.str
PRINT_SETTINGS_RESOLUTION_X: builtins.str
PRINT_SETTINGS_RESOLUTION_Y: builtins.str
PRINT_SETTINGS_REVERSE: builtins.str
PRINT_SETTINGS_SCALE: builtins.str
PRINT_SETTINGS_USE_COLOR: builtins.str
PRINT_SETTINGS_WIN32_DRIVER_EXTRA: builtins.str
PRINT_SETTINGS_WIN32_DRIVER_VERSION: builtins.str
PRIORITY_RESIZE: builtins.int
STOCK_ABOUT: builtins.str
STOCK_ADD: builtins.str
STOCK_APPLY: builtins.str
STOCK_BOLD: builtins.str
STOCK_CANCEL: builtins.str
STOCK_CAPS_LOCK_WARNING: builtins.str
STOCK_CDROM: builtins.str
STOCK_CLEAR: builtins.str
STOCK_CLOSE: builtins.str
STOCK_COLOR_PICKER: builtins.str
STOCK_CONNECT: builtins.str
STOCK_CONVERT: builtins.str
STOCK_COPY: builtins.str
STOCK_CUT: builtins.str
STOCK_DELETE: builtins.str
STOCK_DIALOG_AUTHENTICATION: builtins.str
STOCK_DIALOG_ERROR: builtins.str
STOCK_DIALOG_INFO: builtins.str
STOCK_DIALOG_QUESTION: builtins.str
STOCK_DIALOG_WARNING: builtins.str
STOCK_DIRECTORY: builtins.str
STOCK_DISCARD: builtins.str
STOCK_DISCONNECT: builtins.str
STOCK_DND: builtins.str
STOCK_DND_MULTIPLE: builtins.str
STOCK_EDIT: builtins.str
STOCK_EXECUTE: builtins.str
STOCK_FILE: builtins.str
STOCK_FIND: builtins.str
STOCK_FIND_AND_REPLACE: builtins.str
STOCK_FLOPPY: builtins.str
STOCK_FULLSCREEN: builtins.str
STOCK_GOTO_BOTTOM: builtins.str
STOCK_GOTO_FIRST: builtins.str
STOCK_GOTO_LAST: builtins.str
STOCK_GOTO_TOP: builtins.str
STOCK_GO_BACK: builtins.str
STOCK_GO_DOWN: builtins.str
STOCK_GO_FORWARD: builtins.str
STOCK_GO_UP: builtins.str
STOCK_HARDDISK: builtins.str
STOCK_HELP: builtins.str
STOCK_HOME: builtins.str
STOCK_INDENT: builtins.str
STOCK_INDEX: builtins.str
STOCK_INFO: builtins.str
STOCK_ITALIC: builtins.str
STOCK_JUMP_TO: builtins.str
STOCK_JUSTIFY_CENTER: builtins.str
STOCK_JUSTIFY_FILL: builtins.str
STOCK_JUSTIFY_LEFT: builtins.str
STOCK_JUSTIFY_RIGHT: builtins.str
STOCK_LEAVE_FULLSCREEN: builtins.str
STOCK_MEDIA_FORWARD: builtins.str
STOCK_MEDIA_NEXT: builtins.str
STOCK_MEDIA_PAUSE: builtins.str
STOCK_MEDIA_PLAY: builtins.str
STOCK_MEDIA_PREVIOUS: builtins.str
STOCK_MEDIA_RECORD: builtins.str
STOCK_MEDIA_REWIND: builtins.str
STOCK_MEDIA_STOP: builtins.str
STOCK_MISSING_IMAGE: builtins.str
STOCK_NETWORK: builtins.str
STOCK_NEW: builtins.str
STOCK_NO: builtins.str
STOCK_OK: builtins.str
STOCK_OPEN: builtins.str
STOCK_ORIENTATION_LANDSCAPE: builtins.str
STOCK_ORIENTATION_PORTRAIT: builtins.str
STOCK_ORIENTATION_REVERSE_LANDSCAPE: builtins.str
STOCK_ORIENTATION_REVERSE_PORTRAIT: builtins.str
STOCK_PAGE_SETUP: builtins.str
STOCK_PASTE: builtins.str
STOCK_PREFERENCES: builtins.str
STOCK_PRINT: builtins.str
STOCK_PRINT_ERROR: builtins.str
STOCK_PRINT_PAUSED: builtins.str
STOCK_PRINT_PREVIEW: builtins.str
STOCK_PRINT_REPORT: builtins.str
STOCK_PRINT_WARNING: builtins.str
STOCK_PROPERTIES: builtins.str
STOCK_QUIT: builtins.str
STOCK_REDO: builtins.str
STOCK_REFRESH: builtins.str
STOCK_REMOVE: builtins.str
STOCK_REVERT_TO_SAVED: builtins.str
STOCK_SAVE: builtins.str
STOCK_SAVE_AS: builtins.str
STOCK_SELECT_ALL: builtins.str
STOCK_SELECT_COLOR: builtins.str
STOCK_SELECT_FONT: builtins.str
STOCK_SORT_ASCENDING: builtins.str
STOCK_SORT_DESCENDING: builtins.str
STOCK_SPELL_CHECK: builtins.str
STOCK_STOP: builtins.str
STOCK_STRIKETHROUGH: builtins.str
STOCK_UNDELETE: builtins.str
STOCK_UNDERLINE: builtins.str
STOCK_UNDO: builtins.str
STOCK_UNINDENT: builtins.str
STOCK_YES: builtins.str
STOCK_ZOOM_100: builtins.str
STOCK_ZOOM_FIT: builtins.str
STOCK_ZOOM_IN: builtins.str
STOCK_ZOOM_OUT: builtins.str
STYLE_CLASS_ACCELERATOR: builtins.str
STYLE_CLASS_ARROW: builtins.str
STYLE_CLASS_BACKGROUND: builtins.str
STYLE_CLASS_BOTTOM: builtins.str
STYLE_CLASS_BUTTON: builtins.str
STYLE_CLASS_CALENDAR: builtins.str
STYLE_CLASS_CELL: builtins.str
STYLE_CLASS_CHECK: builtins.str
STYLE_CLASS_COMBOBOX_ENTRY: builtins.str
STYLE_CLASS_CONTEXT_MENU: builtins.str
STYLE_CLASS_CSD: builtins.str
STYLE_CLASS_CURSOR_HANDLE: builtins.str
STYLE_CLASS_DEFAULT: builtins.str
STYLE_CLASS_DESTRUCTIVE_ACTION: builtins.str
STYLE_CLASS_DIM_LABEL: builtins.str
STYLE_CLASS_DND: builtins.str
STYLE_CLASS_DOCK: builtins.str
STYLE_CLASS_ENTRY: builtins.str
STYLE_CLASS_ERROR: builtins.str
STYLE_CLASS_EXPANDER: builtins.str
STYLE_CLASS_FLAT: builtins.str
STYLE_CLASS_FRAME: builtins.str
STYLE_CLASS_GRIP: builtins.str
STYLE_CLASS_HEADER: builtins.str
STYLE_CLASS_HIGHLIGHT: builtins.str
STYLE_CLASS_HORIZONTAL: builtins.str
STYLE_CLASS_IMAGE: builtins.str
STYLE_CLASS_INFO: builtins.str
STYLE_CLASS_INLINE_TOOLBAR: builtins.str
STYLE_CLASS_INSERTION_CURSOR: builtins.str
STYLE_CLASS_LABEL: builtins.str
STYLE_CLASS_LEFT: builtins.str
STYLE_CLASS_LEVEL_BAR: builtins.str
STYLE_CLASS_LINKED: builtins.str
STYLE_CLASS_LIST: builtins.str
STYLE_CLASS_LIST_ROW: builtins.str
STYLE_CLASS_MARK: builtins.str
STYLE_CLASS_MENU: builtins.str
STYLE_CLASS_MENUBAR: builtins.str
STYLE_CLASS_MENUITEM: builtins.str
STYLE_CLASS_MESSAGE_DIALOG: builtins.str
STYLE_CLASS_MONOSPACE: builtins.str
STYLE_CLASS_NEEDS_ATTENTION: builtins.str
STYLE_CLASS_NOTEBOOK: builtins.str
STYLE_CLASS_OSD: builtins.str
STYLE_CLASS_OVERSHOOT: builtins.str
STYLE_CLASS_PANE_SEPARATOR: builtins.str
STYLE_CLASS_PAPER: builtins.str
STYLE_CLASS_POPOVER: builtins.str
STYLE_CLASS_POPUP: builtins.str
STYLE_CLASS_PRIMARY_TOOLBAR: builtins.str
STYLE_CLASS_PROGRESSBAR: builtins.str
STYLE_CLASS_PULSE: builtins.str
STYLE_CLASS_QUESTION: builtins.str
STYLE_CLASS_RADIO: builtins.str
STYLE_CLASS_RAISED: builtins.str
STYLE_CLASS_READ_ONLY: builtins.str
STYLE_CLASS_RIGHT: builtins.str
STYLE_CLASS_RUBBERBAND: builtins.str
STYLE_CLASS_SCALE: builtins.str
STYLE_CLASS_SCALE_HAS_MARKS_ABOVE: builtins.str
STYLE_CLASS_SCALE_HAS_MARKS_BELOW: builtins.str
STYLE_CLASS_SCROLLBAR: builtins.str
STYLE_CLASS_SCROLLBARS_JUNCTION: builtins.str
STYLE_CLASS_SEPARATOR: builtins.str
STYLE_CLASS_SIDEBAR: builtins.str
STYLE_CLASS_SLIDER: builtins.str
STYLE_CLASS_SPINBUTTON: builtins.str
STYLE_CLASS_SPINNER: builtins.str
STYLE_CLASS_STATUSBAR: builtins.str
STYLE_CLASS_SUBTITLE: builtins.str
STYLE_CLASS_SUGGESTED_ACTION: builtins.str
STYLE_CLASS_TITLE: builtins.str
STYLE_CLASS_TITLEBAR: builtins.str
STYLE_CLASS_TOOLBAR: builtins.str
STYLE_CLASS_TOOLTIP: builtins.str
STYLE_CLASS_TOP: builtins.str
STYLE_CLASS_TOUCH_SELECTION: builtins.str
STYLE_CLASS_TROUGH: builtins.str
STYLE_CLASS_UNDERSHOOT: builtins.str
STYLE_CLASS_VERTICAL: builtins.str
STYLE_CLASS_VIEW: builtins.str
STYLE_CLASS_WARNING: builtins.str
STYLE_CLASS_WIDE: builtins.str
STYLE_PROPERTY_BACKGROUND_COLOR: builtins.str
STYLE_PROPERTY_BACKGROUND_IMAGE: builtins.str
STYLE_PROPERTY_BORDER_COLOR: builtins.str
STYLE_PROPERTY_BORDER_RADIUS: builtins.str
STYLE_PROPERTY_BORDER_STYLE: builtins.str
STYLE_PROPERTY_BORDER_WIDTH: builtins.str
STYLE_PROPERTY_COLOR: builtins.str
STYLE_PROPERTY_FONT: builtins.str
STYLE_PROPERTY_MARGIN: builtins.str
STYLE_PROPERTY_PADDING: builtins.str
STYLE_PROVIDER_PRIORITY_APPLICATION: builtins.int
STYLE_PROVIDER_PRIORITY_FALLBACK: builtins.int
STYLE_PROVIDER_PRIORITY_SETTINGS: builtins.int
STYLE_PROVIDER_PRIORITY_THEME: builtins.int
STYLE_PROVIDER_PRIORITY_USER: builtins.int
STYLE_REGION_COLUMN: builtins.str
STYLE_REGION_COLUMN_HEADER: builtins.str
STYLE_REGION_ROW: builtins.str
STYLE_REGION_TAB: builtins.str
TEXT_VIEW_PRIORITY_VALIDATE: builtins.int
TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID: builtins.int
TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID: builtins.int
