/*
 * Copyright © 2004 Noah Levitt
 * Copyright © 2007, 2008 Christian Persch
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <config.h>

#include <stdlib.h>

#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include <mucharmap/mucharmap.h>
#include "mucharmap-window.h"
 
static gboolean option_version_cb(const gchar* option_name, const gchar* value, gpointer data, GError** error)
{
	g_print("%s %s\n", _("MATE Character Map"), VERSION);

	exit(EXIT_SUCCESS);
	return FALSE;
}

int main (int argc, char* argv[])
{
	GtkWidget* window;
	GdkScreen* screen;
	int monitor;
	GdkRectangle rect;
	GError* error = NULL;
	char* font = NULL;
	
	GOptionEntry goptions[] = {
		{ "font", 0, 0, G_OPTION_ARG_STRING, &font, N_("Font to start with; ex: 'Serif 27'"), N_("FONT") },
		{ "version", 0, G_OPTION_FLAG_HIDDEN | G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, option_version_cb, NULL, NULL },
		{ NULL }
	};

	bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);

	#ifdef HAVE_MATECONF
		/* MateConf uses MateCORBA2 which need GThread. See bug #565516 */
		g_thread_init(NULL);
	#endif

	if (!gtk_init_with_args(&argc, &argv, "", goptions, GETTEXT_PACKAGE, &error))
	{
		g_printerr("%s\n", error->message);
		g_error_free(error);

		exit(1);
	}

	g_set_application_name(_("Character Map"));
	gtk_window_set_default_icon_name(MUCHARMAP_ICON_NAME);

	window = mucharmap_window_new();
	g_signal_connect(window, "destroy", G_CALLBACK(gtk_main_quit), NULL);

	screen = gtk_window_get_screen(GTK_WINDOW(window));
	monitor = gdk_screen_get_monitor_at_point(screen, 0, 0);
	gdk_screen_get_monitor_geometry(screen, monitor, &rect);
	gtk_window_set_default_size(GTK_WINDOW(window), rect.width * 9/16, rect.height * 9/16);

	if (font)
	{
		mucharmap_window_set_font(MUCHARMAP_WINDOW(window), font);
		g_free(font);
	}

	gtk_window_present(GTK_WINDOW(window));

	gtk_main();

	return 0;
}
