# Copyright (C) 2003 Konstantin Korikov

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

importer_class = "WvdialImporter"
    
import ConfigParser
import re
import locale
import importer
import chestnut_dialer.account_set
from chestnut_dialer import _

try: default_encoding = locale.getpreferredencoding()
except: default_encoding = 'ASCII'

class Account(chestnut_dialer.account_set.Account):
  _acc_conf = None
  _sections = None
  _id = None
  _acc_name = None
  _wvdial_attrs = {
    "speed": "Baud",    
    "dial_cmd": "Dial Command",
    "chat_login_prompt": "Login Prompt",
    "passwd": "Password",
    "ask_passwd": "Ask Password",
    "chat_passwd_prompt": "Password Prompt",
    "ip": "Force Address",
    "remotename": "Remote Name",
    "redial_auto": "Auto Reconnect",
    "redial_attempts": "Dial Attempts",
    "dial_prefix": "Dial Prefix"}
  _encoding = None
  def __init__(self, acc_conf, sections, acc_id, acc_name, encoding):
    chestnut_dialer.account_set.Account.__init__(self)
    self._acc_conf = acc_conf
    self._id = acc_id
    self._sections = sections[:]
    self._sections.reverse()
    self._acc_name = acc_name
    self._encoding = encoding
  def _get_acc_attr(self, name):
    acc_conf = self._acc_conf
    sections = self._sections
    wvdial_attrs = self._wvdial_attrs
    def get_value(option):
      for s in sections:
        sec = (u"Dialer " + s).encode(self._encoding)
        op = option.encode(self._encoding)
        if acc_conf.has_option(sec, op):
	  return unicode(acc_conf.get(sec, op), self._encoding)
      return None
    def get_bool_value(option):
      v = get_value(option)
      if v == None: return None
      return (v.lower() in ("on", "yes", "true")) and 1 or 0
    def get_int_value(option):
      v = get_value(option)
      if v == None: return None
      return int(v)
    def get_str_value(option):
      v = get_value(option)
      return v
    if name == "id": return self._id
    if name == "name": return self._acc_name or sections[0]
    if name == "auth_type": return u"pap/chap"
    if name == "use_script":
      return (get_bool_value("Stupid Mode") and
          "predef-noterm" or "predef-auto")
    if name == "user":
      v = get_value("Username")
      if v == None: v = get_value("Login")
      if v == None: v = u""
      return v 
    if name == "phone_numbers":
      l = []
      for i in ("Phone", "Phone1", "Phone2", "Phone3", "Phone4"):
	v = get_value(i)
	if v: l.append(v)
      return l
    if name == "dns_servers":
      if get_bool_value("Auto DNS"): return []
      l = []
      for i in ("DNS Test1", "DNS Test2"):
	v = get_value(i)
	if v: l.append(v)
      return l or None
    if name == "init_cmd":
      for i in ("Init", "Init1"):
        v = get_value(i)
	if v != None: return v
      return None
    if name == "init2_cmd":
      for i in range(2, 9):
        v = get_value("Init%d" % i)
	if v != None: return v
      return None
    if wvdial_attrs.has_key(name):
      if name in ("redial_auto", "ask_passwd"):
        return get_bool_value(wvdial_attrs[name])
      if name == "redial_attempts":
        v = get_int_value(wvdial_attrs[name])
        return v == 0 and 99 or v      
      return get_str_value(wvdial_attrs[name])
    return None

class WvdialImporter(chestnut_dialer.account_set.AccountSet):
  __doc__ = _("Import accounts from wvdial")
  author = _("Konstantin Korikov")
  constructor_args = (
    { "name": "file_name",
      "type": "filename",
      "display": _("Source File"),
      "default":  "/etc/wvdial.conf"},
    { "name": "sections",
      "type": "string",
      "display": _("Join sections"),
      "default":  "",
      "description": _("""List of white space separated sections
for join to one account. If empty all sections will be displayed.""")},
    { "name": "encoding",
      "type": "string",
      "display": _("Encoding"),
      "default": default_encoding})
  program = "wvdial"
  acc_conf = None
  sections = None
  acc_sec_list = None
  encoding = None
  def __init__(self, file_name, sections, encoding):
    self.acc_conf = ConfigParser.ConfigParser()
    try: self.acc_conf.read(file_name)
    except: pass
    if not self.acc_conf.sections():
      raise importer.ConstructImporterException(
          _("The source file is empty or broken"))
    self.sections = []
    for s in sections.split(" "):
      if s == "": continue
      if not self.acc_conf.has_section(
          (u"Dialer " + s).encode(encoding)):
        raise importer.ConstructImporterException(
          _("No such section: %s") % s)
      self.sections.append(s)
    if not self.sections:
      self.acc_sec_list = []
      regexp = re.compile(r'^Dialer (\w+)$')
      for section in self.acc_conf.sections():
        sec = unicode(section, encoding)
	m = regexp.match(sec)
	if m:
	  self.acc_sec_list.append(m.group(1))
    self.encoding = encoding
  def ls_accounts(self):
    if not self.sections:
      accounts = []
      i = 0
      for s in self.acc_sec_list:
        accounts.append((s, i))
	i += 1
      return accounts
    return [(_("wvdial Account"), 0)]
  def get_account(self, account_id):
    if not self.sections:
      return Account(self.acc_conf, 
        [u"Defaults", self.acc_sec_list[account_id]], account_id,
        self.acc_sec_list[account_id], self.encoding)
    if account_id != 0: return None
    return Account(self.acc_conf, [u"Defaults"] + self.sections, 
      0, _("wvdial Account"), self.encoding)
