/*
 * Copyright (C) 1993-2008 the Wine project authors (see the file AUTHORS (in the
 * wine project) for a complete list).
 *
 * See the file LICENSE-wine for the license (GPL) details.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "gyachi_lib.h"

#include "theme_support.h"
#include "gyachi_lib.h"
#include "gy_config.h"


#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    g_object_ref (widget), (GDestroyNotify) g_object_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

static GList *voice_servers = NULL;
char *default_voice_server = NULL;
GtkWidget *gyv_chat_server;

/* read gyvoice configuration file */
void read_gyvoicerc () {
	FILE *f;
	int   max_len;
	char *line;
	char  *(pieces[3]);
	char *gyvoicerc_path;

	pieces[0]=GYACH_CFG_DIR;
	pieces[1]="/gyvoicerc";
	pieces[2]=NULL;
	gyvoicerc_path = gyachi_filename(pieces);

	/* Free old values. Set defaults */
	if (default_voice_server) {
		free(default_voice_server);
		default_voice_server=NULL;
	}

	f = fopen(gyvoicerc_path, "r");
	if (f == NULL) {
		/* no config available */
		free(gyvoicerc_path);
		return;
	}

	/* process config file */
	max_len = max_linelen(f);
	line=malloc(max_len);
	while (fgets(line, max_len, f)) {
		char *p, *key, *value;
				
		/* strip comments */
		if ( (p = strchr(line, '#'))) {
			*p='\n';
		}

		/* Skip empty lines */
		if (*line == '\n') {
			continue;
		}

		if ( (key = strtok(line, "=")) && (value = strtok(NULL, "\n"))) {
			if (strcmp(key,"default_voice_server")==0) {
				free(default_voice_server);
				default_voice_server = strdup(value);
			}
		} else {
			fprintf(stderr, "%s", line);
			fprintf(stderr, "Problems in configuration file %s\n", gyvoicerc_path);
		}		
	}
	fclose(f);
	free(gyvoicerc_path);
	free(line);
} /* read_gyvoicerc */


/* read capture configuration file - again, taken from Hoshy, by Z.Cs. */
void write_gyvoicerc() {
	FILE *f;
	char  *(pieces[3]);
	char *gyvoicerc_path;

	pieces[0]=GYACH_CFG_DIR;
	pieces[1]="/gyvoicerc";
	pieces[2]=NULL;
	gyvoicerc_path = gyachi_filename(pieces);
	
	if ((f = fopen(gyvoicerc_path, "w")) == NULL) {
		fprintf(stderr, "Problems when writing configuration to %s\n",
				gyvoicerc_path);
		free(gyvoicerc_path);
		return;
	}
	fprintf(f, "# Configuration file for gyvoice settings\n\n");
	fprintf(f, "# Default voice server\n");
	fprintf(f, "default_voice_server=%s\n", default_voice_server);
	
	free(gyvoicerc_path);
	fclose(f);
} /* write_gyvoicerc */


void my_exit()
{
	exit(1);
}

GtkWidget *create_gyv_mainwindow (void)
{
  GtkWidget *gyv_mainwindow;
  GtkWidget *gyv_vbox;
  GtkWidget *alignment4;
  GtkWidget *gyv_menu;
  GtkWidget *gyv_menu_file;
  GtkWidget *gyv_menu_file_menu;
  GtkWidget *gyv_menu_connect;
  GtkWidget *gyv_menu_disconnect;
  GtkWidget *separator1;
  GtkWidget *gyv_menu_debugging;
  GtkWidget *gyv_menu_quit;
  GtkWidget *gyv_menu_help;
  GtkWidget *gyv_menu_help_menu;
  GtkWidget *gyv_menu_about;
  GtkWidget *gyv_logo;
  GtkWidget *hbox1;
  GtkWidget *gyv_button_on;
  GtkWidget *alignment1;
  GtkWidget *hbox2;
  GtkWidget *image2;
  GtkWidget *label1;
  GtkWidget *gyv_button_off;
  GtkWidget *alignment2;
  GtkWidget *hbox3;
  GtkWidget *image3;
  GtkWidget *label2;
  GtkWidget *gyv_check_mute;
  GtkWidget *hseparator1;
  GtkWidget *gyv_scrollwindow;
  GtkWidget *gyv_viewport;
  GtkWidget *gyv_frame;
  GtkWidget *gyv_treeview;
  GtkWidget *gyv_button_talk;
  GtkWidget *alignment3;
  GtkWidget *hbox5;
  GtkWidget *image5;
  GtkWidget *label3;
  GtkWidget *hseparator3;
  GtkWidget *table1;
  GtkWidget *label14;
  GtkWidget *label15;
  GtkWidget *label16;
  GtkWidget *label17;
  GtkWidget *label18;
  GtkWidget *gyv_label_name;
  GtkWidget *gyv_label_alias;
  GtkWidget *gyv_label_room;
  GtkWidget *gyv_sbar_connected;
  GtkAccelGroup *accel_group;

  char  *(pieces[3]);
  char  *t_filename;
  struct stat sbuf;
  FILE  *fp;
  int   max_len;
  char *buf;
  char *t_start, *t_end;
  int   error;

  accel_group = gtk_accel_group_new ();

  gyv_mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (gyv_mainwindow, 300, 450);
  gtk_window_set_title (GTK_WINDOW (gyv_mainwindow), _("GYachI Voice Chat"));

  error =0;
  if (voice_servers == NULL) {
	pieces[0]=GYACH_CFG_DIR;
	pieces[1]="/voice_servers";
	pieces[2]=NULL;
	t_filename=gyachi_filename(pieces);

	if (stat(t_filename, &sbuf)) {
		pieces[0]=PACKAGE_DATA_DIR;

		free(t_filename);
		t_filename=gyachi_filename(pieces);
		if (stat(t_filename, &sbuf)) {
			error=1;		  
			show_ok_message(_("Cannot locate 'voice_servers' file"), gyv_mainwindow, NULL, 1, my_exit);
		}
	}
	
	fp = fopen( t_filename, "r" );
	if ( fp && (error == 0)) {
		max_len = max_linelen(fp);
		buf=malloc(max_len);

		/* load the new list */
		while (fgets(buf, max_len, fp)) {
			/* isolate the IP */
			buf[strlen(buf)-1] = '\0';
			t_end=strchr(buf, '#');
			if (t_end) *t_end = 0;
			t_start=buf;
			while (isspace(*t_start)) t_start++;
			t_end = t_start;
			while (isdigit(*t_end) || (*t_end == '.')) t_end++;
			*t_end=0;
			/* if line was blank, or white-space/comment, or doesn't have an ip, ignore */
			if (*t_start) {
				voice_servers = g_list_prepend(voice_servers, strdup(t_start));
			}
		}
		voice_servers = g_list_reverse(voice_servers);
		free(buf);
		fclose( fp );
	  
	}
	else {
		if (error == 0) {
			pieces[0]=_("Cannot open voice_server file ");;
			pieces[1]=t_filename;
			pieces[2]=NULL;
			buf = build_string(pieces);
			show_ok_message(buf, gyv_mainwindow, NULL, 1, my_exit);
			free(buf);
		}
	}
	free(t_filename);
  }

  read_gyvoicerc();	/* read default voice server */
  gyv_vbox = gtk_vbox_new (FALSE, 3);
  gtk_widget_show (gyv_vbox);
  gtk_container_add (GTK_CONTAINER (gyv_mainwindow), gyv_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (gyv_vbox), 3);

  alignment4 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment4);
  gtk_box_pack_start (GTK_BOX (gyv_vbox), alignment4, FALSE, FALSE, 0);

  gyv_menu = gtk_menu_bar_new ();
  gtk_widget_show (gyv_menu);
  gtk_container_add (GTK_CONTAINER (alignment4), gyv_menu);
  gtk_container_set_border_width (GTK_CONTAINER (gyv_menu), 1);

  gyv_menu_file = gtk_menu_item_new_with_mnemonic (_("_File"));
  gtk_widget_show (gyv_menu_file);
  gtk_container_add (GTK_CONTAINER (gyv_menu), gyv_menu_file);

  gyv_menu_file_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (gyv_menu_file), gyv_menu_file_menu);

  gyv_menu_connect = gtk_menu_item_new_with_mnemonic (_("_Connect"));
  gtk_widget_show (gyv_menu_connect);
  gtk_container_add (GTK_CONTAINER (gyv_menu_file_menu), gyv_menu_connect);

  gyv_menu_disconnect = gtk_menu_item_new_with_mnemonic (_("_Disconnect"));
  gtk_widget_show (gyv_menu_disconnect);
  gtk_container_add (GTK_CONTAINER (gyv_menu_file_menu), gyv_menu_disconnect);

  separator1 = gtk_separator_menu_item_new ();
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (gyv_menu_file_menu), separator1);
  gtk_widget_set_sensitive (separator1, FALSE);

  gyv_menu_debugging = gtk_check_menu_item_new_with_mnemonic (_("Debugging"));
  gtk_widget_show (gyv_menu_debugging);
  gtk_container_add (GTK_CONTAINER (gyv_menu_file_menu), gyv_menu_debugging);

  gyv_menu_quit = gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, accel_group);
  gtk_widget_show (gyv_menu_quit);
  gtk_container_add (GTK_CONTAINER (gyv_menu_file_menu), gyv_menu_quit);

  gyv_menu_help = gtk_menu_item_new_with_mnemonic (_("_Help"));
  gtk_widget_show (gyv_menu_help);
  gtk_container_add (GTK_CONTAINER (gyv_menu), gyv_menu_help);

  gyv_menu_help_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (gyv_menu_help), gyv_menu_help_menu);

  gyv_menu_about = gtk_menu_item_new_with_mnemonic (_("_About"));
  gtk_widget_show (gyv_menu_about);
  gtk_container_add (GTK_CONTAINER (gyv_menu_help_menu), gyv_menu_about);

  gyv_logo = gtk_image_new_from_stock(GYACHI_VOICE_LOGO, GYACHI_ICON_SIZE_VLOGO);
  gtk_widget_show (gyv_logo);
  gtk_box_pack_start (GTK_BOX (gyv_vbox), gyv_logo, FALSE, TRUE, 0);

  hbox1 = gtk_hbox_new (FALSE, 3);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (gyv_vbox), hbox1, FALSE, FALSE, 0);

  gyv_button_on = gtk_toggle_button_new ();
  gtk_widget_show (gyv_button_on);
  gtk_box_pack_start (GTK_BOX (hbox1), gyv_button_on, TRUE, TRUE, 0);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (gyv_button_on), alignment1);

  hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox2);

  image2 = gtk_image_new_from_stock(GYACHI_VOICE_ON, GTK_ICON_SIZE_MENU);
  gtk_widget_show (image2);
  gtk_box_pack_start (GTK_BOX (hbox2), image2, FALSE, FALSE, 0);

  label1 = gtk_label_new_with_mnemonic (_("On"));
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, FALSE, 0);

  gyv_button_off = gtk_button_new ();
  gtk_widget_show (gyv_button_off);
  gtk_box_pack_start (GTK_BOX (hbox1), gyv_button_off, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (gyv_button_off, FALSE);

  alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment2);
  gtk_container_add (GTK_CONTAINER (gyv_button_off), alignment2);

  hbox3 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox3);
  gtk_container_add (GTK_CONTAINER (alignment2), hbox3);

  image3 = gtk_image_new_from_stock(GYACHI_VOICE_OFF, GTK_ICON_SIZE_MENU);
  gtk_widget_show (image3);
  gtk_box_pack_start (GTK_BOX (hbox3), image3, FALSE, FALSE, 0);

  label2 = gtk_label_new_with_mnemonic (_("Off"));
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox3), label2, FALSE, FALSE, 0);

  gyv_check_mute = gtk_check_button_new_with_mnemonic (_("Mute"));
  gtk_widget_show (gyv_check_mute);
  gtk_box_pack_start (GTK_BOX (hbox1), gyv_check_mute, TRUE, TRUE, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (gyv_check_mute), FALSE);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (gyv_vbox), hseparator1, FALSE, FALSE, 3);

  gyv_scrollwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (gyv_scrollwindow);
  gtk_box_pack_start (GTK_BOX (gyv_vbox), gyv_scrollwindow, TRUE, TRUE, 0);

  gyv_viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (gyv_viewport);
  gtk_container_add (GTK_CONTAINER (gyv_scrollwindow), gyv_viewport);

  gyv_frame = gtk_frame_new (NULL);
  gtk_widget_show (gyv_frame);
  gtk_container_add (GTK_CONTAINER (gyv_viewport), gyv_frame);
  gtk_frame_set_label_align (GTK_FRAME (gyv_frame), 0, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (gyv_frame), GTK_SHADOW_NONE);

  gyv_treeview = gtk_tree_view_new ();
  gtk_widget_show (gyv_treeview);
  gtk_container_add (GTK_CONTAINER (gyv_frame), gyv_treeview);
  gtk_tree_view_set_reorderable (GTK_TREE_VIEW (gyv_treeview), TRUE);
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (gyv_treeview), FALSE);
//gtk_tree_view_set_headers_clickable(GTK_TREE_VIEW(gyv_treeview), TRUE);
  gtk_widget_set_sensitive(gyv_treeview, TRUE);

  gyv_button_talk = gtk_toggle_button_new ();
  gtk_widget_show (gyv_button_talk);
  gtk_widget_set_sensitive(gyv_button_talk, FALSE);
  gtk_box_pack_start (GTK_BOX (gyv_vbox), gyv_button_talk, FALSE, FALSE, 3);

  alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (gyv_button_talk), alignment3);

  hbox5 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox5);
  gtk_container_add (GTK_CONTAINER (alignment3), hbox5);

  image5 = gtk_image_new_from_stock(GYACHI_VOICE_TALK, GTK_ICON_SIZE_MENU);
  gtk_widget_show (image5);
  gtk_box_pack_start (GTK_BOX (hbox5), image5, FALSE, FALSE, 0);

  label3 = gtk_label_new_with_mnemonic (_("Talk"));
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (hbox5), label3, FALSE, FALSE, 0);

  hseparator3 = gtk_hseparator_new ();
  gtk_widget_show (hseparator3);
  gtk_box_pack_start (GTK_BOX (gyv_vbox), hseparator3, FALSE, FALSE, 3);

  table1 = gtk_table_new (5, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (gyv_vbox), table1, FALSE, FALSE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 3);

  label14 = gtk_label_new (_("Speaker:"));
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table1), label14, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label14), 0, 0.5);

  label15 = gtk_label_new (_("Name:"));
  gtk_widget_show (label15);
  gtk_table_attach (GTK_TABLE (table1), label15, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label15), 0, 0.5);

  label16 = gtk_label_new (_("Alias:"));
  gtk_widget_show (label16);
  gtk_table_attach (GTK_TABLE (table1), label16, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label16), 0, 0.5);

  label17 = gtk_label_new (_("Room:"));
  gtk_widget_show (label17);
  gtk_table_attach (GTK_TABLE (table1), label17, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label17), 0, 0.5);

  label18 = gtk_label_new (_("Server:"));
  gtk_widget_show (label18);
  gtk_table_attach (GTK_TABLE (table1), label18, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label18), 0, 0.5);

  gyv_label_name = gtk_label_new (_("Noone is speaking ?"));
  gtk_widget_show (gyv_label_name);
  gtk_table_attach (GTK_TABLE (table1), gyv_label_name, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_SET_FLAGS (gyv_label_name, GTK_CAN_FOCUS);
  gtk_label_set_selectable (GTK_LABEL (gyv_label_name), TRUE);
  gtk_misc_set_alignment (GTK_MISC (gyv_label_name), 0, 0.5);

  gyv_label_alias = gtk_label_new (_("Alias of noone ..."));
  gtk_widget_show (gyv_label_alias);
  gtk_table_attach (GTK_TABLE (table1), gyv_label_alias, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_SET_FLAGS (gyv_label_alias, GTK_CAN_FOCUS);
  gtk_label_set_selectable (GTK_LABEL (gyv_label_alias), TRUE);
  gtk_misc_set_alignment (GTK_MISC (gyv_label_alias), 0, 0.5);

  gyv_label_room = gtk_label_new (_("Any room .."));
  gtk_widget_show (gyv_label_room);
  gtk_table_attach (GTK_TABLE (table1), gyv_label_room, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (gyv_label_room), 0, 0.5);

  gyv_chat_server = gyachi_combobox_new(FALSE);
  gyachi_combobox_load_list(gyv_chat_server, voice_servers);
  if (default_voice_server) {
	gyachi_combobox_select_item(gyv_chat_server, default_voice_server);
  }
  gtk_table_attach (GTK_TABLE (table1), gyv_chat_server, 1, 2, 4, 5,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gyv_sbar_connected = gtk_statusbar_new ();
  gtk_widget_show (gyv_sbar_connected);
  gtk_box_pack_start (GTK_BOX (gyv_vbox), gyv_sbar_connected, FALSE, FALSE, 0);

  g_signal_connect ((gpointer) gyv_mainwindow, "destroy",
                    G_CALLBACK (on_gyv_mainwindow_destroy),
                    NULL);
  g_signal_connect ((gpointer) gyv_menu_connect, "activate",
                    G_CALLBACK (on_gyv_menu_connect_activate),
                    NULL);
  g_signal_connect ((gpointer) gyv_menu_disconnect, "activate",
                    G_CALLBACK (on_gyv_menu_disconnect_activate),
                    NULL);
  g_signal_connect ((gpointer) gyv_menu_debugging, "activate",
                    G_CALLBACK (on_gyv_menu_debugging_activate),
                    NULL);
  g_signal_connect ((gpointer) gyv_menu_quit, "activate",
                    G_CALLBACK (on_quit1_activate),
                    NULL);
  g_signal_connect ((gpointer) gyv_menu_about, "activate",
                    G_CALLBACK (on_about1_activate),
                    NULL);
  g_signal_connect ((gpointer) gyv_button_on, "clicked",
                    G_CALLBACK (on_gyv_button_on_clicked),
                    NULL);
  g_signal_connect ((gpointer) gyv_button_off, "clicked",
                    G_CALLBACK (on_gyv_button_off_clicked),
                    NULL);
  g_signal_connect ((gpointer) gyv_button_talk, "toggled",
                    G_CALLBACK (on_gyv_button_talk_clicked),
                    NULL);
  g_signal_connect ((gpointer) gyv_chat_server, "changed",
		    G_CALLBACK (on_gyv_chat_server_changed),
		    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (gyv_mainwindow, gyv_mainwindow, "gyv_mainwindow");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_vbox, "gyv_vbox");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, alignment4, "alignment4");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu, "gyv_menu");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu_file, "gyv_menu_file");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu_file_menu, "gyv_menu_file_menu");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu_connect, "gyv_menu_connect");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu_disconnect, "gyv_menu_disconnect");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, separator1, "separator1");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu_debugging, "gyv_menu_debugging");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu_quit, "gyv_menu_quit");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu_help, "gyv_menu_help");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu_help_menu, "gyv_menu_help_menu");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_menu_about, "gyv_menu_about");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_logo, "gyv_logo");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, hbox1, "hbox1");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_button_on, "gyv_button_on");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, alignment1, "alignment1");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, hbox2, "hbox2");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, image2, "image2");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, label1, "label1");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_button_off, "gyv_button_off");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, alignment2, "alignment2");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, hbox3, "hbox3");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, image3, "image3");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, label2, "label2");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_check_mute, "gyv_check_mute");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, hseparator1, "hseparator1");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_scrollwindow, "gyv_scrollwindow");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_viewport, "gyv_viewport");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_frame, "gyv_frame");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_treeview, "gyv_treeview");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_button_talk, "gyv_button_talk");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, alignment3, "alignment3");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, hbox5, "hbox5");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, image5, "image5");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, label3, "label3");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, hseparator3, "hseparator3");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, table1, "table1");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, label14, "label14");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, label16, "label16");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, label17, "label17");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_label_name, "gyv_label_name");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_label_alias, "gyv_label_alias");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_label_room, "gyv_label_room");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, label15, "label15");
  GLADE_HOOKUP_OBJECT (gyv_mainwindow, gyv_sbar_connected, "gyv_sbar_connected");

  gtk_window_add_accel_group (GTK_WINDOW (gyv_mainwindow), accel_group);

  return gyv_mainwindow;
}

