/*****************************************************************************
 * gyachi_lib.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2007 Greg Hosler
 * ghosler ['at'] users.sourceforge.net
 *****************************************************************************/

#ifndef _GYACHI_LIB_H
#define _GYACHI_LIB_H

#include <gtk/gtk.h>

/* For historical notes, protocol numbers */
/*  0x09000000 - old, YMSG-9                           */
/*  0x0A000000 - old YMSG10                            */ 
/*  0x0a00c800 - latest  'official' Linux Yahoo client */ 
/*  0x000B0000 - current: YMSG-11, Messenger 5.6       */
/*  0x000C0000 - current: YMSG-12, Messenger 6 Beta    */
/*  0x000D0000 - current: YMSG-13, Messenger 7.5 Beta  */
/*  0x000F0000 - current: YMSG-15, Messenger 9 Beta    */
/*  0x00100000 - current: YMSG-16, Messenger 9         */

#define YMSG_VER_11 0x000B0000
#define YMSG_VER_13 0x000D0000
#define YMSG_VER_15 0x000F0000
#define YMSG_VER_16 0x00100000

typedef struct YMSG_PROTOCOL_STRUCT {
	int protocol;
	const char *proto_name;
	const char *yahoo_client_version;
	const char *yahoo_client_version_id;
} YMSG_PROTOCOL;

typedef struct {
	char *room_name;
	char *room_id;
	int fav;
} YMSG_ROOM;

extern YMSG_PROTOCOL YMSG_PROTOCOLS[];


extern char *_(char *some);
extern gchar *_utf(char *some);    /* converts from the assumed locale to UTF */
extern gchar *_b2loc(char *some);  /* converts back from UTF to locale string */
extern void lower_str( char *str );
YMSG_PROTOCOL *yprotocol_from_proto_id(int proto);
int yprotocol_name_to_protocol(const char *proto);
const char *yprotocol_to_name(int proto);

/* room list management functions. These are in gyachi_lib because gy_config needs them */
extern YMSG_ROOM *find_room(char *room_name);
extern void add_room(char *room_name, char *room_id, int fav);

/* common routines needed by gyachi, gyachivoice, etc. */
extern void gyachi_set_tooltip(GtkWidget *somewid, char *somechar);

extern GtkWidget *gyachi_combobox_new(int editable);
extern void gyachi_combobox_load(GtkWidget *gy_combo_box, char *item_array[]);
extern void gyachi_combobox_load_list(GtkWidget *gy_combo_box, GList *item_list);
extern void gyachi_combobox_prepend_item(GtkWidget *gy_combo_box, const char *item);
extern void gyachi_combobox_append_item(GtkWidget *gy_combo_box, const char *item);
extern int  gyachi_combobox_select_item(GtkWidget *gy_combo_box, char *item);
extern void gyachi_combobox_select_itemno(GtkWidget *gy_combo_box, int selected_item_no);
extern const char *gyachi_combobox_get_selected_item(GtkWidget *gy_combo_box);
extern char *build_string(char **strngs);
extern char *gyachi_filename(char **filename_pieces);
extern int   max_linelen(FILE *fp);
extern void  show_ok_message(char *mymsg, GtkWidget *parent, char *ui_name, int error, void *callback);

/*
 * This function returns a widget in a component created by Glade.
 * Call it with the toplevel widget in the component (i.e. a window/dialog),
 * or alternatively any widget in the component, and the name of the widget
 * you want returned.
 */
GtkWidget*  lookup_widget(GtkWidget *widget, const gchar *widget_name);


#endif
