#!/bin/sh
#
# This script is run as root after installation of mint-fluxbox-default-settings.
# It copies the default system configurations for Linux Mint Fluxbox CE 
# to the system files.
# It creates a backup of previous configuration files in:
# /usr/lib/linuxmint/mint-fluxbox-default-settings/backup/
# The old files are stored in a folder named as the date and time of backup.
# Files are stored with their complete paths.

###############################################
#	VARIABLES
wdir=`pwd`
wdirforsed=`echo $wdir | sed -e 's/\//\\\\\//g'`
sedcmd="sed -e s/$wdirforsed\/system-configs//g"
datestamp=`date +%Y%m%d%H%M`
logfile=$wdir/logs/$datestamp
#	/VARIABLES
################################################

##############
#DEBUG
#echo $logfile
#echo "wdir is:
#$wdir"
#echo "wdirforsed is :
#$wdirforsed"
#echo "sedcmd is:
#$sedcmd"
#echo "datestamp is:
#$datestamp"
#/DEBUG
##############

##############
#SAFETY CATCH
if [ -z `ls $wdir | grep system-config.sh` ]
then
	echo "This script must be run from the directory containing system-config.sh
You are currently in $wdir
Exiting"
	exit 1
fi
#/SAFETY CATCH
###############

###############
#	LOG

startlog () {
mkdir -p $wdir/logs
touch $logfile

echo "
############################################
#	LOG CREATED BY $0
#	on `date`
############################################

" >> $logfile
}

endlog () {
echo "
############################################
#	SCRIPT TERMINATED ON
#	`date`
############################################
" >> $logfile
}
#	/LOG
###############


################################################
#	FUNCTIONS

#Get list of directories required
dirlist () {
find $wdir/system-configs/ -type d | $sedcmd
}

#Get list of files to be copied
filelist () {
find $wdir/system-configs/ -type f | $sedcmd
}

#Backup old files
backupfiles () {

	#For logs
	echo "
Starting backup
---------------
" >> $logfile

#create backup dir and subdirs
dirlist | while read line
do

	#debugs
	#line1="$line"
	#line="$HOME/testroot$line1"
	#echo "line is $line"
	#/debugs
	

	if [ -d $line ]
	then
		mkdir -p $wdir/backup/$datestamp/$line
	fi
done

#backup old config files
filelist | while read line
do

	#debugs
	#line1="$line"
	#line="$HOME/testroot$line1"
	#echo "line is $line"
	#/debugs
	

	if [ -f "$line" ]
	then
#		echo "file to copy is $line"
		echo "Backing up $line to $wdir/backup/$datestamp$line" >> $logfile		
		cp -p $line $wdir/backup/$datestamp$line
		
	#Quit if a backup fails
		if [ ! -f $wdir/backup/$datestamp$line ]
		then
			echo "Backup of $line failed!"
			echo "Exiting $0"
			echo "See log at $logfile"
			echo "
********************
Backup of $line failed!
Exiting $0
********************" >> $logfile
			endlog
			exit 1
		fi
		rm $line			
	fi
done
}

#Check for required directories and create of not present
dircheck () {
	echo "
Creating required directories
-----------------------------
" >> $logfile

dirlist | while read line
	do

	#debugs
	#line1="$line"
	#line="$HOME/testroot$line1"
	#echo "line is $line"
	#/debugs

	if [ ! -d $line ]
	then
		echo "Creating $line" >> $logfile
		mkdir -p $line
	
	fi
	done
}

#Copy new configs to system
copyfiles () {

	#For logs
	echo "
Copying new configs
-------------------
" >> $logfile

filelist | while read line
do

	#debugs
	#line1="$line"
	#line="$HOME/testroot$line1"
	#echo "line is $line"
	#/debugs

	#When above debugs are enabled, uncomment the following 2 line and comment out the next to for the variables to work. (Notice it is $line1 and not $line...)
	#echo "Copying $wdir/system-configs$line1 to $line" >> $logfile
	#cp --force -p $wdir/system-configs$line1 $line
	
	
	echo "Copying $wdir/system-configs$line to $line" >> $logfile
	cp --force -p $wdir/system-configs$line $line
	
	#check for copied file
	if [ ! -f "$line" ]
	then
		echo "Failed to copy $line"
		echo "
********************
Failed to copy $line" >> $logfile
		if [ -f "$wdir/backup/$datestamp$line" ]
		then
			echo "Restoring backup from $wdir/backup/$datestamp$line" >> $logfile
			cp --force -p $wdir/backup/$datestamp$line $line
	#check again for file		
			if [ -f "$line" ]
			then
				echo"Failed to restore backup!"
				echo"Failed to restore backup!" >> $logfile			
			fi
		fi
		echo "********************" >> $logfile
		echo "Continuing..."
		touch /tmp/system-config.err
	fi
done
}

checkerr () {

if [ -f /tmp/system-config.err ]
then
	echo "
*********************
An error has occured!
Please check the log located here:
$logfile

You may need to restore some configuration files.
*********************"
	rm /tmp/system-config.err
else
echo "System configurations updated successfully!"
echo "
System configurations updated successfully!" >> $logfile
fi
}
#	/FUNCTIONS
################################################

###############
#ACTION!

#dirlist
startlog
backupfiles
dircheck
copyfiles
checkerr
endlog

#/ACTION!
###############
