/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(C) 2025 Marvell.
 */

#ifndef __TEST_CRYPTODEV_ML_DSA_TEST_VECTORS_H__
#define __TEST_CRYPTODEV_ML_DSA_TEST_VECTORS_H__

#include "rte_crypto_asym.h"

struct crypto_testsuite_mldsa_params {
	const char *name;
	enum rte_crypto_ml_dsa_type type;
	enum rte_crypto_auth_algorithm hash;
	rte_crypto_param seed;
	rte_crypto_param privkey;
	rte_crypto_param pubkey;
	rte_crypto_param message;
	rte_crypto_param context;
	rte_crypto_param mu;
	rte_crypto_param sign;
	bool sign_deterministic;
};

/* Seed */
uint8_t mldsa_44_seed[] = {
	0xf4, 0x41, 0xc9, 0x62, 0x17, 0x32, 0x2c, 0xbc,
	0xcf, 0x05, 0xf7, 0x5b, 0xd5, 0xfb, 0x0a, 0x0a,
	0x78, 0xbf, 0xad, 0xab, 0x89, 0x6e, 0x88, 0xdb,
	0xb4, 0x08, 0x90, 0xe0, 0x16, 0x9b, 0xb6, 0x66,
};

/* Private key */
uint8_t mldsa_44_privkey[] = {
	0xcc, 0x2c, 0x93, 0xce, 0xfc, 0x0b, 0xf6, 0x74,
	0x93, 0x28, 0x95, 0xe8, 0xc0, 0xc8, 0x83, 0xb8,
	0xc9, 0x0c, 0x9a, 0x5c, 0x18, 0xd2, 0x79, 0x5c,
	0xf3, 0x58, 0xd8, 0x02, 0x6c, 0x5e, 0xad, 0x79,
	0xc1, 0xae, 0x0a, 0x97, 0x90, 0x41, 0x10, 0x32,
	0x59, 0x46, 0x12, 0x27, 0x0a, 0xa3, 0xc7, 0xf0,
	0x74, 0x54, 0x3d, 0xb2, 0x24, 0xc2, 0xa2, 0xec,
	0xaf, 0x31, 0xa0, 0xf4, 0x78, 0x97, 0x7c, 0x6a,
	0xdc, 0x91, 0x87, 0x60, 0x01, 0xa9, 0x19, 0x2d,
	0x0d, 0xca, 0xb4, 0x14, 0x9d, 0x41, 0xe3, 0x18,
	0x4b, 0x99, 0x31, 0xfa, 0xf4, 0xfa, 0xc4, 0x75,
	0x93, 0x87, 0xc7, 0x7a, 0x8f, 0x0e, 0xc6, 0xb2,
	0xfa, 0xf6, 0x48, 0x84, 0x17, 0x42, 0x01, 0xcb,
	0xd2, 0x55, 0x40, 0x2f, 0x23, 0x21, 0x91, 0x11,
	0x40, 0x00, 0xdc, 0x91, 0x3d, 0xf5, 0x96, 0xdb,
	0xb3, 0x6d, 0xd5, 0xf4, 0xc5, 0x11, 0x96, 0x8f,
	0x13, 0x25, 0x4a, 0x24, 0xb3, 0x90, 0x9b, 0x16,
	0x30, 0x20, 0x96, 0x10, 0x10, 0x97, 0x6c, 0xd0,
	0x26, 0x26, 0x61, 0x84, 0x85, 0x1b, 0xb2, 0x81,
	0x5c, 0x10, 0x88, 0x48, 0xc8, 0x8d, 0x1c, 0x42,
	0x61, 0x19, 0x32, 0x04, 0x81, 0xa6, 0x89, 0x98,
	0x42, 0x62, 0x14, 0xa3, 0x90, 0xc8, 0xc2, 0x4c,
	0x41, 0x04, 0x2c, 0x5b, 0x26, 0x2a, 0xd1, 0x30,
	0x12, 0x18, 0x40, 0x71, 0x08, 0x98, 0x70, 0x60,
	0x40, 0x09, 0x4a, 0x44, 0x0a, 0x24, 0x43, 0x92,
	0x04, 0x20, 0x06, 0x80, 0xa2, 0x01, 0x18, 0x47,
	0x12, 0x23, 0xc7, 0x6c, 0x50, 0x32, 0x61, 0xda,
	0x26, 0x40, 0x84, 0x98, 0x90, 0xd3, 0x04, 0x66,
	0x52, 0xb8, 0x70, 0x99, 0x02, 0x6c, 0x64, 0xb2,
	0x00, 0x1b, 0x35, 0x90, 0x23, 0x00, 0x92, 0x01,
	0x02, 0x20, 0x12, 0x89, 0x25, 0x62, 0xa6, 0x4d,
	0x1b, 0x29, 0x08, 0x08, 0x46, 0x72, 0xa1, 0x18,
	0x11, 0x03, 0x80, 0x60, 0xd4, 0x38, 0x80, 0x64,
	0x36, 0x4e, 0x23, 0x30, 0x8e, 0x23, 0x81, 0x60,
	0xd1, 0x84, 0x89, 0xe2, 0xa8, 0x2d, 0x80, 0x92,
	0x61, 0x8a, 0x22, 0x28, 0x0a, 0xc9, 0x50, 0xe3,
	0x96, 0x40, 0x84, 0xa0, 0x0d, 0xd8, 0xc2, 0x2c,
	0xd1, 0x30, 0x10, 0x18, 0xa0, 0x48, 0xe2, 0xb2,
	0x04, 0x00, 0xa8, 0x29, 0x19, 0x42, 0x68, 0xa3,
	0xa2, 0x71, 0xd9, 0xc0, 0x45, 0xa2, 0xc6, 0x4c,
	0x51, 0x36, 0x71, 0xc1, 0x40, 0x02, 0x08, 0x12,
	0x72, 0x90, 0x04, 0x2e, 0x80, 0x30, 0x24, 0x8b,
	0x90, 0x44, 0x82, 0x82, 0x68, 0xa2, 0x84, 0x2d,
	0x08, 0x00, 0x61, 0x23, 0x82, 0x48, 0x00, 0x33,
	0x29, 0x58, 0x48, 0x86, 0x01, 0x01, 0x21, 0x62,
	0xa8, 0x91, 0xe3, 0x10, 0x6c, 0x58, 0x24, 0x09,
	0x0c, 0x14, 0x02, 0x63, 0x22, 0x20, 0x12, 0x48,
	0x70, 0x81, 0x26, 0x6e, 0x00, 0x86, 0x31, 0x1a,
	0x22, 0x65, 0x40, 0x38, 0x00, 0x02, 0x47, 0x09,
	0xc9, 0x82, 0x8c, 0x82, 0xa0, 0x2c, 0xd3, 0x04,
	0x45, 0x50, 0xb0, 0x28, 0xd0, 0x10, 0x8d, 0x1c,
	0x10, 0x52, 0x4b, 0x00, 0x66, 0xc8, 0xc0, 0x08,
	0x9a, 0xa8, 0x2d, 0xd4, 0x02, 0x8a, 0x1b, 0x35,
	0x65, 0x04, 0xc7, 0x28, 0x84, 0x38, 0x50, 0x18,
	0x20, 0x4a, 0x91, 0x18, 0x8c, 0x9b, 0x20, 0x09,
	0x94, 0x08, 0x71, 0x64, 0x06, 0x25, 0x20, 0x23,
	0x09, 0xd8, 0x82, 0x68, 0x5a, 0xa6, 0x31, 0x63,
	0x36, 0x32, 0x5c, 0x12, 0x62, 0xdb, 0x32, 0x6e,
	0x14, 0x93, 0x68, 0x9a, 0x34, 0x80, 0x83, 0x44,
	0x4a, 0x18, 0x13, 0x49, 0x43, 0xb8, 0x0d, 0xda,
	0x92, 0x41, 0x42, 0xb8, 0x84, 0x52, 0x94, 0x91,
	0x04, 0x05, 0x4d, 0xa2, 0x38, 0x64, 0x01, 0x19,
	0x05, 0x18, 0xa2, 0x4d, 0x90, 0x34, 0x26, 0x91,
	0x30, 0x68, 0x1c, 0x14, 0x44, 0x4b, 0x18, 0x22,
	0x12, 0x90, 0x91, 0x42, 0x96, 0x91, 0x19, 0x48,
	0x4c, 0x24, 0x46, 0x80, 0xc3, 0xb8, 0x8c, 0x1c,
	0x80, 0x8d, 0x18, 0x45, 0x88, 0xd8, 0x94, 0x4c,
	0x13, 0x02, 0x65, 0xd3, 0x22, 0x29, 0x49, 0x04,
	0x82, 0x04, 0xc2, 0x40, 0x04, 0x34, 0x21, 0xe1,
	0x34, 0x46, 0x20, 0x90, 0x44, 0x93, 0x14, 0x44,
	0xdb, 0xc0, 0x4d, 0x1b, 0xa2, 0x24, 0x5a, 0x24,
	0x68, 0x10, 0x46, 0x66, 0x11, 0x43, 0x29, 0xd0,
	0x90, 0x0d, 0x49, 0x12, 0x4c, 0xc1, 0x96, 0x2c,
	0xdb, 0x22, 0x65, 0xe4, 0x16, 0x24, 0xd1, 0x24,
	0x26, 0x53, 0xb8, 0x45, 0x8a, 0xb4, 0x11, 0x04,
	0x96, 0x28, 0x80, 0x22, 0x8e, 0xd1, 0x10, 0x05,
	0x44, 0x44, 0x8a, 0x5c, 0xb4, 0x50, 0xdc, 0x10,
	0x02, 0xc1, 0xa2, 0x4c, 0x11, 0x05, 0x2c, 0x21,
	0x39, 0x6a, 0x64, 0x36, 0x01, 0x09, 0xc3, 0x0c,
	0x9a, 0x24, 0x52, 0x92, 0x20, 0x0a, 0xd2, 0xa8,
	0x49, 0x99, 0xc6, 0x8d, 0x50, 0x26, 0x62, 0x09,
	0x42, 0x05, 0x5b, 0xc0, 0x41, 0xd0, 0x22, 0x25,
	0x09, 0xb4, 0x2d, 0x98, 0xa2, 0x24, 0x12, 0x84,
	0x0d, 0xca, 0x98, 0x11, 0x22, 0x80, 0x21, 0x1b,
	0x00, 0x44, 0x84, 0xc6, 0x89, 0x92, 0x48, 0x42,
	0x50, 0xc8, 0x60, 0x24, 0x15, 0x69, 0xa2, 0x48,
	0x06, 0xc4, 0xb0, 0x24, 0x63, 0x14, 0x40, 0x12,
	0xc4, 0x61, 0x82, 0x30, 0x60, 0x88, 0x96, 0x89,
	0xc9, 0xc0, 0x89, 0x12, 0x36, 0x82, 0x8c, 0xc0,
	0x09, 0xc0, 0x88, 0x91, 0xdb, 0x10, 0x64, 0x08,
	0x36, 0x71, 0x94, 0x10, 0x46, 0x20, 0x83, 0x10,
	0x13, 0x13, 0x4c, 0x08, 0x28, 0x45, 0x24, 0xb9,
	0x64, 0x09, 0xb0, 0x48, 0x1c, 0x25, 0x50, 0x23,
	0x40, 0x90, 0xe0, 0x96, 0x50, 0x9a, 0x38, 0x41,
	0xcc, 0xb2, 0x2c, 0xdb, 0x04, 0x66, 0x61, 0x48,
	0x30, 0x02, 0x34, 0x4e, 0xd1, 0xc2, 0x85, 0xc9,
	0x06, 0x41, 0x19, 0x30, 0x69, 0xc8, 0x94, 0x68,
	0x1c, 0x83, 0x70, 0x03, 0x10, 0x4d, 0xc2, 0x16,
	0x4e, 0x64, 0x92, 0x30, 0x60, 0x16, 0x84, 0xa2,
	0xa8, 0x90, 0xa4, 0x38, 0x11, 0x0a, 0x88, 0x05,
	0x10, 0x93, 0x88, 0x43, 0x06, 0x10, 0x18, 0x10,
	0x70, 0x03, 0x28, 0x42, 0x89, 0x28, 0x8d, 0x8a,
	0xa8, 0x09, 0x94, 0x42, 0x85, 0xa3, 0x10, 0x61,
	0x0c, 0x45, 0x50, 0x04, 0x31, 0x4c, 0xd1, 0x10,
	0x12, 0x8b, 0x96, 0x05, 0x03, 0xa0, 0x89, 0x21,
	0xc4, 0x4d, 0x61, 0xc8, 0x61, 0x09, 0x99, 0x10,
	0x59, 0x96, 0x49, 0x00, 0x89, 0x08, 0x23, 0x00,
	0x10, 0xcc, 0xa4, 0x61, 0x01, 0x25, 0x80, 0x21,
	0x31, 0x09, 0x13, 0x28, 0x0d, 0x1c, 0x05, 0x85,
	0x62, 0x92, 0x44, 0x09, 0x10, 0x8a, 0x5a, 0xa6,
	0x20, 0x89, 0xb0, 0x20, 0x0c, 0xb3, 0x01, 0xc9,
	0x26, 0x61, 0x0b, 0x34, 0x6a, 0x8b, 0x44, 0x0e,
	0xf2, 0x47, 0x18, 0xf8, 0x4a, 0xfa, 0x45, 0x60,
	0x87, 0xeb, 0x0f, 0xff, 0x75, 0xa6, 0xba, 0x18,
	0x9a, 0x7d, 0x37, 0xc4, 0xc7, 0x7e, 0x1a, 0xc9,
	0x0d, 0x06, 0x53, 0xca, 0xf0, 0x2c, 0xe9, 0xe9,
	0x4b, 0x5f, 0x8b, 0xbc, 0x77, 0xc6, 0x71, 0x68,
	0x4f, 0x8c, 0x3b, 0x30, 0x59, 0x91, 0xf0, 0xb5,
	0x6d, 0xa6, 0x28, 0x2c, 0xd4, 0x0a, 0x00, 0x27,
	0x6a, 0x39, 0x17, 0x88, 0xa9, 0x93, 0xbb, 0x6e,
	0xda, 0x3e, 0x4b, 0xb7, 0x1b, 0x6a, 0xb2, 0xe2,
	0xc4, 0x6f, 0x21, 0x78, 0x74, 0xff, 0xa2, 0x02,
	0x65, 0x68, 0xa4, 0xce, 0xb4, 0xfe, 0x0c, 0x18,
	0x59, 0xb9, 0xc8, 0x33, 0x41, 0x27, 0xa1, 0x4b,
	0xcf, 0xe9, 0xa9, 0xd7, 0x2d, 0xf9, 0xcd, 0xc6,
	0xde, 0x4e, 0x1d, 0x7d, 0x07, 0xf4, 0xda, 0xed,
	0x89, 0xa1, 0xef, 0xbc, 0xec, 0x1b, 0xc3, 0x07,
	0xfd, 0xf5, 0x96, 0xa3, 0x6c, 0x70, 0xc8, 0xb9,
	0x9f, 0x46, 0x0a, 0xad, 0x46, 0x01, 0xa1, 0x92,
	0x7c, 0xd1, 0x12, 0x78, 0x89, 0x89, 0x98, 0x68,
	0x9e, 0xdd, 0xd9, 0x7b, 0x9f, 0x2b, 0x29, 0xc1,
	0x0e, 0x29, 0xb0, 0x44, 0x7c, 0x22, 0xd7, 0x67,
	0x47, 0x91, 0xf0, 0xf8, 0x56, 0x79, 0x89, 0x42,
	0x95, 0x60, 0x53, 0x32, 0xc1, 0x14, 0x48, 0x56,
	0x67, 0x00, 0x80, 0x86, 0xcd, 0x80, 0x21, 0x75,
	0xe8, 0xe2, 0x41, 0x6a, 0x5d, 0xb2, 0x12, 0x57,
	0x1e, 0x83, 0x34, 0xa4, 0x95, 0x4e, 0x0e, 0x71,
	0xac, 0xcb, 0x09, 0xef, 0xea, 0x4e, 0xe0, 0x4d,
	0x44, 0xb2, 0x67, 0xd2, 0x6e, 0x78, 0x01, 0xb5,
	0x09, 0x64, 0xa7, 0xdf, 0xe6, 0x16, 0x72, 0x6b,
	0x19, 0xe5, 0x88, 0x8a, 0x06, 0xae, 0x0a, 0x93,
	0xdb, 0xee, 0x0e, 0xf6, 0x52, 0x84, 0x95, 0x2b,
	0xf8, 0xf4, 0xcd, 0x5d, 0x8b, 0x3a, 0x86, 0x87,
	0x8e, 0x8b, 0x97, 0x65, 0xb1, 0xd6, 0x50, 0xbc,
	0xa7, 0xf0, 0x32, 0xb5, 0x39, 0x1e, 0x10, 0x7d,
	0x96, 0x11, 0xc1, 0xe8, 0x47, 0xfa, 0xdd, 0x24,
	0x22, 0xb6, 0x43, 0xb2, 0x41, 0x95, 0x98, 0x1a,
	0x3f, 0x0f, 0x9a, 0xd3, 0xc4, 0x10, 0x19, 0x85,
	0x0a, 0x0d, 0xde, 0xb7, 0x76, 0xec, 0xe3, 0x57,
	0x2e, 0x38, 0x4e, 0xb1, 0x2e, 0x4a, 0xaf, 0xc8,
	0x78, 0xa7, 0xb3, 0x1e, 0xaf, 0xe0, 0xe4, 0xbb,
	0xc8, 0x0b, 0x24, 0x04, 0x08, 0xd2, 0xbc, 0x91,
	0xca, 0x8e, 0x4e, 0x85, 0x39, 0x76, 0x20, 0xc9,
	0xa7, 0x47, 0x8b, 0x6a, 0xd9, 0xc8, 0xb7, 0xb0,
	0xa5, 0xa2, 0x85, 0x48, 0x4c, 0xcb, 0x16, 0xaf,
	0x45, 0x48, 0x00, 0xbe, 0x67, 0xef, 0x67, 0x65,
	0xa3, 0x9d, 0x43, 0x07, 0x59, 0x88, 0x9a, 0xad,
	0xe5, 0xad, 0x1e, 0xeb, 0xd5, 0xd4, 0xc7, 0xa4,
	0xb9, 0x40, 0x70, 0x2c, 0xe1, 0xcb, 0x5c, 0x3f,
	0x49, 0x6b, 0x51, 0xbf, 0xd3, 0xb7, 0xea, 0x33,
	0x52, 0x73, 0xcf, 0x26, 0x19, 0x54, 0x1d, 0xb6,
	0x33, 0x5d, 0x1a, 0x88, 0xdb, 0xd6, 0xfe, 0xae,
	0xf4, 0x45, 0x67, 0x80, 0x8a, 0xfc, 0xc4, 0xbe,
	0xfb, 0x6a, 0x4a, 0x75, 0x88, 0x35, 0x26, 0x1f,
	0x90, 0x65, 0x26, 0x5e, 0xb8, 0x0d, 0x15, 0x9d,
	0x70, 0x76, 0xf2, 0xfd, 0xed, 0x55, 0x71, 0x2b,
	0xe8, 0x2d, 0xc0, 0x28, 0xee, 0x53, 0x7c, 0xa1,
	0x3e, 0x86, 0x74, 0xa2, 0xd3, 0x9e, 0x2c, 0x70,
	0x15, 0x3a, 0x90, 0xfd, 0x1d, 0xac, 0x81, 0x2d,
	0xa6, 0x6a, 0xe6, 0xd7, 0x7f, 0xd9, 0x97, 0xc9,
	0x47, 0x7c, 0x07, 0xe6, 0x35, 0x45, 0xc9, 0x1f,
	0x08, 0xbc, 0x14, 0xdb, 0x12, 0x84, 0xc3, 0xc8,
	0xe2, 0x86, 0xa3, 0xa2, 0x1e, 0xfb, 0x3f, 0xca,
	0x92, 0x04, 0xe0, 0x6b, 0x29, 0xe0, 0xe0, 0x23,
	0x51, 0x40, 0x8e, 0xec, 0xf8, 0x87, 0xa2, 0x7a,
	0x2d, 0x8b, 0xc2, 0x62, 0x8c, 0x29, 0x82, 0x4b,
	0x86, 0x1a, 0xa7, 0xc6, 0xaa, 0x24, 0x5f, 0x24,
	0x03, 0x20, 0xa8, 0x3c, 0xa3, 0xcb, 0xd1, 0x60,
	0x64, 0x7d, 0x22, 0x9b, 0x07, 0x46, 0x1e, 0xff,
	0x43, 0xa9, 0x38, 0x34, 0x0f, 0x01, 0x00, 0x7f,
	0xc6, 0xcb, 0x0a, 0xed, 0x73, 0xc0, 0xfb, 0x77,
	0x80, 0x8c, 0x2c, 0x4c, 0xa5, 0x20, 0xe8, 0xcf,
	0x37, 0xf9, 0x00, 0x12, 0xe1, 0x6c, 0xb5, 0x9a,
	0x91, 0xbe, 0x1f, 0xaf, 0xf1, 0x8c, 0x6e, 0x09,
	0xea, 0xcf, 0xac, 0x43, 0x6e, 0x32, 0xd0, 0xf4,
	0x89, 0x4e, 0x42, 0xc2, 0xe7, 0x84, 0x7a, 0x66,
	0xb5, 0x2b, 0x5c, 0x7d, 0x83, 0x4b, 0xd4, 0x3d,
	0x81, 0x6d, 0x68, 0xb9, 0x72, 0xe5, 0xd5, 0xe5,
	0xf5, 0x9c, 0x4d, 0x95, 0xcd, 0xcd, 0x4d, 0x9a,
	0x4e, 0x69, 0xb9, 0x8a, 0x1e, 0x96, 0x69, 0xc0,
	0xe0, 0x39, 0x02, 0x21, 0x1c, 0x82, 0xd9, 0x5b,
	0xe5, 0xde, 0x34, 0xff, 0xf0, 0x15, 0xc7, 0x9a,
	0x62, 0x83, 0xca, 0xa3, 0x70, 0x15, 0xeb, 0x8f,
	0x73, 0x0e, 0xa9, 0x9c, 0xe9, 0xe3, 0xe7, 0xfc,
	0xb4, 0xcb, 0xac, 0xdf, 0x61, 0x91, 0xf3, 0x4b,
	0x87, 0xa6, 0x29, 0xea, 0x36, 0x81, 0x07, 0x3e,
	0xae, 0x69, 0xee, 0x87, 0x2a, 0x30, 0x1c, 0x97,
	0x96, 0x40, 0x08, 0x48, 0xcf, 0x5f, 0xfe, 0x57,
	0x23, 0xfd, 0xb7, 0x9a, 0x69, 0xef, 0xf5, 0x6e,
	0xc9, 0xdd, 0x95, 0x2b, 0x17, 0xd5, 0x2c, 0xad,
	0xa4, 0x49, 0x78, 0xb1, 0xd1, 0x00, 0xe7, 0xca,
	0xcb, 0x20, 0x9e, 0xba, 0xea, 0xc8, 0xd4, 0x9b,
	0x84, 0xac, 0x0b, 0xf0, 0x3b, 0x2c, 0xf0, 0x95,
	0x3b, 0x5b, 0xf8, 0xfe, 0xe5, 0xc6, 0xee, 0x7c,
	0x9e, 0x41, 0xf0, 0xef, 0xcf, 0x4d, 0xdd, 0xe8,
	0x63, 0x6b, 0xcf, 0xe9, 0xd2, 0x80, 0x98, 0xf9,
	0x7d, 0x22, 0x7e, 0xfc, 0xdd, 0x50, 0x6b, 0xa3,
	0x6d, 0x7c, 0xed, 0x35, 0xbc, 0x28, 0x64, 0x03,
	0xe6, 0x01, 0xac, 0x7c, 0xe1, 0x9b, 0x08, 0x6f,
	0xd8, 0xdc, 0xaf, 0xb6, 0x9d, 0x4c, 0xdf, 0xb1,
	0xde, 0xf4, 0x90, 0x5b, 0x46, 0xee, 0x7d, 0x28,
	0xfb, 0xaa, 0xa9, 0x69, 0x47, 0xf5, 0x52, 0x74,
	0x97, 0x9f, 0x8b, 0xbb, 0x26, 0x8f, 0x0d, 0x89,
	0x2f, 0xc9, 0x57, 0xac, 0x2f, 0x88, 0x12, 0xdd,
	0x12, 0x2f, 0x75, 0x97, 0xc7, 0x7b, 0x45, 0x46,
	0x3a, 0x52, 0x4b, 0xf6, 0x76, 0xe0, 0x99, 0xef,
	0xbe, 0xbf, 0xed, 0x0d, 0x32, 0xed, 0xc6, 0x5e,
	0x6a, 0xe6, 0x0e, 0x12, 0xd4, 0xce, 0xf8, 0x0c,
	0x7b, 0x4f, 0x1d, 0x3b, 0xf8, 0xaf, 0xdd, 0xd1,
	0x78, 0x74, 0x59, 0xc7, 0xe4, 0xbc, 0xe3, 0xdd,
	0x4a, 0xa7, 0x77, 0xa5, 0xcd, 0x80, 0x7c, 0x6b,
	0x19, 0x46, 0x3d, 0xbd, 0x0a, 0x75, 0x48, 0xfa,
	0x1c, 0xee, 0x02, 0xe9, 0x79, 0x10, 0x6c, 0xb4,
	0xb3, 0xb2, 0xbe, 0xc8, 0x5c, 0xd1, 0xa1, 0xe2,
	0xd5, 0x0a, 0xb5, 0xf3, 0x0c, 0x3f, 0x03, 0xb9,
	0x2f, 0x61, 0x44, 0x95, 0xe1, 0x16, 0xcb, 0xc1,
	0xee, 0xb3, 0xb8, 0x85, 0xd6, 0x1c, 0xf4, 0xfa,
	0x86, 0x73, 0xc5, 0xf3, 0xba, 0xb5, 0xe0, 0x95,
	0x34, 0x95, 0x72, 0xfa, 0xa7, 0xb8, 0x50, 0xba,
	0xfb, 0xa6, 0x3c, 0x0f, 0x3c, 0xe3, 0xaa, 0x56,
	0x05, 0xaf, 0x08, 0xec, 0x50, 0x12, 0x73, 0x25,
	0x29, 0x72, 0xf5, 0xf6, 0xee, 0x06, 0xe4, 0x05,
	0x1a, 0xe1, 0x1a, 0x13, 0x3f, 0xa3, 0x55, 0x16,
	0x12, 0x17, 0x88, 0xd2, 0xa7, 0xc1, 0xd0, 0xf2,
	0x7d, 0x51, 0x46, 0x36, 0x2e, 0x77, 0xa8, 0x02,
	0x67, 0xad, 0xe7, 0x63, 0xaa, 0xbf, 0xe5, 0xbf,
	0xa1, 0xab, 0xc4, 0xf6, 0x72, 0xae, 0xdf, 0x79,
	0x0e, 0x82, 0x47, 0xb5, 0xf4, 0x48, 0x39, 0x22,
	0xe3, 0x0a, 0x94, 0x5e, 0x3a, 0x4b, 0xa6, 0xa7,
	0x5c, 0xb8, 0xec, 0x3e, 0x10, 0xae, 0x94, 0x34,
	0x2c, 0xc0, 0x4b, 0xdd, 0xca, 0x4d, 0xc9, 0x7c,
	0xf8, 0x2e, 0x32, 0x4e, 0x00, 0x2c, 0x34, 0x71,
	0x28, 0xad, 0xd5, 0xcb, 0x19, 0xb8, 0x1d, 0xaa,
	0x85, 0xac, 0xec, 0x16, 0xb6, 0x1f, 0x95, 0xc5,
	0xa9, 0x4b, 0x8a, 0xfc, 0x70, 0xb7, 0x34, 0xb0,
	0x63, 0x55, 0xff, 0x15, 0xc2, 0x72, 0x74, 0xe0,
	0x6d, 0x01, 0x3d, 0xf0, 0x6a, 0xab, 0x4b, 0x8a,
	0x72, 0xdc, 0x2b, 0x0a, 0x8a, 0xf4, 0x02, 0x1b,
	0x0b, 0x51, 0xd8, 0xf7, 0x17, 0xcf, 0x48, 0xf0,
	0x97, 0xa0, 0xc2, 0x7a, 0xc4, 0x64, 0x59, 0x2a,
	0xa3, 0x27, 0xbe, 0x3b, 0xf7, 0xc5, 0x6d, 0x51,
	0x29, 0xe2, 0x68, 0x87, 0x75, 0x71, 0x72, 0xac,
	0xc8, 0xc1, 0xc8, 0xe5, 0xf6, 0x8a, 0x27, 0x8c,
	0x45, 0x03, 0x10, 0xf7, 0x1a, 0xff, 0x1b, 0x04,
	0x1c, 0xaf, 0x27, 0x7a, 0x57, 0xac, 0x0f, 0x57,
	0x2a, 0x74, 0xd0, 0x46, 0x64, 0xbf, 0xc9, 0xe8,
	0x35, 0x6b, 0x5c, 0x79, 0x9a, 0x51, 0xeb, 0xd1,
	0xb3, 0x1d, 0xfd, 0x2f, 0x83, 0x2e, 0x24, 0x95,
	0x94, 0xc7, 0x9d, 0x9f, 0x5d, 0x5c, 0x8e, 0x6c,
	0x8f, 0xfc, 0xce, 0x89, 0x67, 0x9b, 0x38, 0x4b,
	0x0d, 0x44, 0x9a, 0xb5, 0x74, 0xbf, 0x88, 0x90,
	0xa1, 0xf2, 0xc4, 0xd2, 0xb3, 0x07, 0xe5, 0x34,
	0x62, 0xc0, 0xfc, 0x3f, 0xdb, 0x77, 0x8e, 0x84,
	0x61, 0xc1, 0x15, 0xf6, 0x5f, 0x5d, 0x73, 0xbc,
	0x0c, 0x70, 0x32, 0xeb, 0x2c, 0xd3, 0x19, 0x83,
	0x22, 0xfa, 0x5b, 0xcc, 0x5f, 0xbf, 0xbe, 0xfc,
	0x3c, 0x28, 0x74, 0x2d, 0x33, 0x8f, 0x74, 0xe5,
	0xca, 0xc9, 0x84, 0x8f, 0xba, 0x48, 0x11, 0x84,
	0x33, 0xf0, 0x7d, 0x5c, 0xad, 0x47, 0x36, 0xf7,
	0x33, 0xb0, 0xbb, 0x44, 0x65, 0x72, 0x45, 0xd1,
	0x40, 0x4c, 0x39, 0x8b, 0x16, 0x90, 0x74, 0xa3,
	0xd2, 0x3c, 0xc6, 0x7a, 0xa4, 0x4f, 0x0d, 0x9a,
	0xe1, 0xfd, 0x49, 0x82, 0xc6, 0x69, 0xf7, 0xe7,
	0x3d, 0xeb, 0x2b, 0xbe, 0xfd, 0x1a, 0x73, 0x2c,
	0xf3, 0xbc, 0xd6, 0xaa, 0xaa, 0x54, 0x22, 0x5c,
	0x54, 0x92, 0x73, 0xe3, 0x79, 0x0a, 0x87, 0x20,
	0x82, 0xdb, 0x02, 0x42, 0x81, 0xb1, 0xf7, 0x0d,
	0xf0, 0xd8, 0x56, 0x0f, 0x74, 0x0c, 0x65, 0x7c,
	0x8c, 0x96, 0xb9, 0x9f, 0xfa, 0xb6, 0x48, 0x66,
	0xf1, 0xbe, 0xf8, 0x46, 0x70, 0xe5, 0x26, 0xc1,
	0x68, 0x7f, 0x81, 0x72, 0x14, 0x2f, 0x96, 0x22,
	0x05, 0xd1, 0xc0, 0xb8, 0x93, 0x9d, 0x02, 0x8b,
	0xff, 0x0b, 0x2d, 0xb9, 0x01, 0xaa, 0x61, 0x09,
	0x9d, 0x55, 0x21, 0xdd, 0xda, 0xec, 0x44, 0xce,
	0x00, 0x98, 0xf8, 0x34, 0x86, 0x49, 0xd4, 0x72,
	0x90, 0xfb, 0xd7, 0xb1, 0x33, 0xb9, 0xe5, 0xd3,
	0xc0, 0x27, 0x88, 0x4b, 0x6d, 0x84, 0x34, 0x7c,
	0x77, 0x7e, 0xcf, 0x27, 0x4d, 0x5f, 0x1d, 0xb4,
	0xb4, 0xac, 0xcc, 0x7d, 0x83, 0xc2, 0x89, 0x3d,
	0xeb, 0xb6, 0xa3, 0x57, 0x30, 0xbc, 0x94, 0x9f,
	0xe9, 0x63, 0xca, 0x7d, 0xa3, 0x9d, 0x0a, 0x43,
	0xed, 0x4a, 0xfd, 0xd3, 0x5e, 0x23, 0x97, 0x75,
	0x28, 0x97, 0xaa, 0x0c, 0xf9, 0xa1, 0x03, 0xb1,
	0x55, 0x82, 0xec, 0xcc, 0x91, 0x27, 0xf4, 0xcf,
	0x63, 0x10, 0xf3, 0xd3, 0x8b, 0x5c, 0xa8, 0xc2,
	0x58, 0x4d, 0xf5, 0x67, 0xe9, 0xe1, 0xc2, 0xf2,
	0x11, 0x5e, 0xf2, 0xe1, 0x1c, 0xf2, 0x0c, 0x50,
	0x71, 0x9f, 0xd1, 0x1c, 0xb8, 0x82, 0x7d, 0x3b,
	0x23, 0x90, 0x4e, 0x08, 0xbf, 0x51, 0xa1, 0xc9,
	0xe9, 0x90, 0x07, 0x4e, 0xb3, 0xcc, 0x72, 0xbf,
	0x2c, 0x87, 0x18, 0x3b, 0xc7, 0x29, 0x8a, 0x3b,
	0x0b, 0x4c, 0x55, 0x20, 0x08, 0xb0, 0xa3, 0x04,
	0xf9, 0x6b, 0x53, 0x84, 0x4c, 0xef, 0xc1, 0xc6,
	0xa4, 0xa9, 0xba, 0xe6, 0xb8, 0x72, 0x60, 0x6b,
	0x2d, 0x25, 0x08, 0xc1, 0xd4, 0x4e, 0x0b, 0xcb,
	0xe9, 0x71, 0x9b, 0x5a, 0x9a, 0x1e, 0x21, 0x9a,
	0x0a, 0xd0, 0x52, 0x82, 0xe9, 0x31, 0x45, 0x9e,
	0xe4, 0x85, 0x6b, 0xac, 0x8e, 0x7c, 0x73, 0x0c,
	0x0d, 0xd6, 0x54, 0x27, 0x5a, 0xce, 0xc8, 0x07,
	0x19, 0x84, 0x8b, 0xee, 0x0f, 0x6f, 0x8b, 0xbc,
	0x0c, 0x1b, 0xe0, 0x08, 0x64, 0xa6, 0xe6, 0xe1,
	0xf8, 0x56, 0x5e, 0xe8, 0x27, 0x7d, 0x26, 0xee,
	0x20, 0x5e, 0x3d, 0x2e, 0x84, 0xdc, 0x50, 0xb0,
	0x16, 0x3f, 0x8c, 0xec, 0xa9, 0xd3, 0x61, 0x85,
	0x5a, 0xba, 0x02, 0x82, 0x65, 0x30, 0xdb, 0x23,
	0x1c, 0xcb, 0xc3, 0xe6, 0x80, 0x5e, 0x4f, 0x6e,
	0xd8, 0x3b, 0x5e, 0xce, 0x67, 0xbb, 0xdb, 0x22,
	0xac, 0xf1, 0x32, 0x53, 0x6a, 0xd6, 0x43, 0x1a,
	0xf0, 0x11, 0xc5, 0x0f, 0xc5, 0x12, 0xdf, 0xe6,
	0x91, 0x8b, 0x15, 0xf4, 0x41, 0xd9, 0xe3, 0x51,
};

/* Public key */
uint8_t mldsa_44_pubkey[] = {
	0xcc, 0x2c, 0x93, 0xce, 0xfc, 0x0b, 0xf6, 0x74,
	0x93, 0x28, 0x95, 0xe8, 0xc0, 0xc8, 0x83, 0xb8,
	0xc9, 0x0c, 0x9a, 0x5c, 0x18, 0xd2, 0x79, 0x5c,
	0xf3, 0x58, 0xd8, 0x02, 0x6c, 0x5e, 0xad, 0x79,
	0xde, 0x77, 0x1a, 0xd3, 0x49, 0xc9, 0x12, 0xc9,
	0xff, 0xcf, 0xa2, 0x6c, 0x1d, 0x37, 0x91, 0xa2,
	0xf5, 0x43, 0xbc, 0xdb, 0x9e, 0xdb, 0xa5, 0xdb,
	0xd9, 0x87, 0xc5, 0xf2, 0xf7, 0x79, 0x58, 0x4c,
	0x08, 0x9f, 0x9c, 0xca, 0x9c, 0xef, 0xa8, 0x80,
	0x27, 0x31, 0xf1, 0xc5, 0x0e, 0x2b, 0x6d, 0xa1,
	0x53, 0x9e, 0x99, 0x1e, 0xc8, 0x75, 0x4a, 0x59,
	0x27, 0x33, 0x41, 0xdd, 0x39, 0xff, 0x37, 0xdf,
	0x5b, 0xb9, 0xe4, 0x56, 0x54, 0x28, 0x8e, 0xb1,
	0xfe, 0xd8, 0x4e, 0x60, 0xcd, 0x22, 0xd7, 0x30,
	0xe5, 0x73, 0xe4, 0xb1, 0x08, 0x0f, 0x0a, 0xbe,
	0x9a, 0x44, 0xfd, 0xb1, 0xed, 0xb1, 0x8e, 0x0d,
	0x7c, 0x3c, 0x3d, 0x04, 0x52, 0x4b, 0x93, 0xf4,
	0xa6, 0xce, 0x8d, 0xb0, 0xe4, 0xf6, 0xb1, 0x09,
	0xfc, 0xc3, 0x42, 0x3d, 0xff, 0x4c, 0x55, 0x3c,
	0x73, 0x75, 0x35, 0x9d, 0xe8, 0x68, 0x42, 0x09,
	0x14, 0x36, 0x91, 0x63, 0xfc, 0xc6, 0x23, 0x7c,
	0x25, 0x81, 0xd5, 0xc1, 0xfe, 0xca, 0xf6, 0x71,
	0x51, 0x8e, 0xab, 0x29, 0xa1, 0x86, 0xbb, 0x45,
	0x43, 0x67, 0x7f, 0xdf, 0x7e, 0x92, 0xff, 0x35,
	0x38, 0xd3, 0xea, 0x94, 0xc9, 0xa3, 0x0f, 0x46,
	0x25, 0xa6, 0x1e, 0x00, 0x60, 0x7b, 0xc0, 0xbc,
	0xe9, 0x5e, 0x16, 0x0e, 0x81, 0xf5, 0x4e, 0x98,
	0xa1, 0x64, 0xb0, 0xb7, 0x02, 0xec, 0x73, 0xad,
	0xf8, 0xc1, 0xce, 0x8b, 0x8f, 0xbd, 0x89, 0xbf,
	0x0f, 0x42, 0x31, 0x6d, 0x75, 0x42, 0xd7, 0x59,
	0x64, 0xad, 0x09, 0xd3, 0x7a, 0x00, 0x7b, 0xdd,
	0x12, 0x76, 0xb0, 0x00, 0x73, 0x5b, 0xbf, 0x44,
	0x54, 0x6e, 0x56, 0x26, 0xa5, 0x27, 0x4d, 0xff,
	0xe5, 0x8a, 0x04, 0x73, 0xd9, 0x75, 0x8c, 0xf7,
	0x06, 0x64, 0xfb, 0xa5, 0x00, 0x27, 0x39, 0x0e,
	0x48, 0x8f, 0x73, 0x29, 0x61, 0x5f, 0x15, 0xf5,
	0x08, 0x15, 0x33, 0xd1, 0x76, 0xba, 0xf3, 0x3e,
	0x28, 0xb8, 0x57, 0xcd, 0x9d, 0x61, 0x1f, 0xca,
	0xd7, 0xc3, 0x10, 0xdb, 0x68, 0xeb, 0xa4, 0x15,
	0x40, 0xd8, 0xe7, 0xa0, 0xd2, 0xd1, 0xd6, 0xb1,
	0xd3, 0x75, 0x8e, 0xc1, 0x60, 0x02, 0xb5, 0x69,
	0xf2, 0x8c, 0xf3, 0xc6, 0x2e, 0x9d, 0xf7, 0x8d,
	0xed, 0xb0, 0x01, 0xba, 0xb5, 0x62, 0x7e, 0x8f,
	0x91, 0xbd, 0x73, 0xc6, 0x35, 0xf9, 0xdb, 0xea,
	0x28, 0xce, 0x8a, 0x47, 0x74, 0x7c, 0x3d, 0x85,
	0x4d, 0x1e, 0x11, 0x7e, 0xa2, 0xaa, 0x04, 0x30,
	0x12, 0xce, 0xea, 0xc1, 0xc5, 0x1e, 0x62, 0x7a,
	0x21, 0x6a, 0xd5, 0xb8, 0x3c, 0xa0, 0xd6, 0xca,
	0xb4, 0x8d, 0xff, 0xc3, 0xfc, 0xf2, 0xf1, 0x3c,
	0x87, 0x23, 0xef, 0x68, 0xe4, 0x37, 0x96, 0xb0,
	0xbb, 0x78, 0xa3, 0x3a, 0xe0, 0xd0, 0x41, 0xeb,
	0x4c, 0x80, 0x55, 0x9b, 0x66, 0x5e, 0x33, 0xea,
	0x33, 0x35, 0x79, 0xda, 0x04, 0x81, 0x19, 0x22,
	0xb4, 0x4c, 0x7a, 0xef, 0x51, 0x50, 0x20, 0x6c,
	0xf8, 0xf7, 0x5f, 0x03, 0x74, 0x72, 0xda, 0x1f,
	0xe3, 0x0b, 0x82, 0x71, 0x50, 0x3d, 0x02, 0x61,
	0x16, 0x44, 0xeb, 0xcf, 0xe3, 0x23, 0x9d, 0xef,
	0xec, 0xce, 0xb3, 0xd0, 0xd2, 0x19, 0xd1, 0xe0,
	0x2e, 0x33, 0xde, 0x28, 0x4b, 0xde, 0x85, 0xc1,
	0xb2, 0x8a, 0xa5, 0x82, 0x0c, 0xa6, 0x9f, 0x23,
	0x53, 0xea, 0xef, 0x78, 0x60, 0x24, 0x3a, 0x40,
	0xc0, 0xc1, 0xac, 0xc9, 0x64, 0xd4, 0x03, 0x5f,
	0x61, 0xa5, 0xdf, 0x6f, 0x6b, 0x4e, 0xb2, 0xe7,
	0x1a, 0xc6, 0x69, 0x69, 0xd9, 0xc6, 0x6e, 0x5d,
	0xea, 0xd8, 0xc0, 0x29, 0xcc, 0x8f, 0x35, 0x7b,
	0xcb, 0x48, 0x3a, 0xfd, 0xba, 0x7a, 0x90, 0xc7,
	0x65, 0x55, 0xfc, 0x90, 0x98, 0x6c, 0x15, 0x38,
	0x0e, 0x88, 0x6e, 0x08, 0x49, 0x85, 0xc6, 0x6d,
	0x8f, 0x30, 0x37, 0xa1, 0x64, 0x79, 0xa1, 0x65,
	0x2d, 0x07, 0x38, 0x3e, 0x1c, 0xa6, 0x12, 0xee,
	0xc5, 0x16, 0x68, 0x5c, 0x93, 0x14, 0xda, 0x33,
	0x3d, 0x74, 0x62, 0xf1, 0xcf, 0x0e, 0x81, 0x80,
	0xda, 0xea, 0xa7, 0x08, 0xde, 0xf3, 0xdc, 0xfe,
	0x3a, 0xf5, 0x60, 0xe9, 0x35, 0x95, 0x52, 0x6c,
	0x7f, 0xef, 0x8b, 0xa7, 0x55, 0x3d, 0x42, 0xfd,
	0x39, 0x24, 0xd2, 0xfb, 0x28, 0x08, 0x83, 0x2b,
	0x44, 0xf1, 0x21, 0x73, 0x13, 0x88, 0xa7, 0xba,
	0x2d, 0xd6, 0xe9, 0x4e, 0xcb, 0xfe, 0x18, 0xe4,
	0xc7, 0x85, 0xf3, 0xb8, 0xab, 0xd0, 0xb9, 0xbe,
	0x5e, 0x8a, 0x62, 0x0e, 0x61, 0xa3, 0x29, 0x1d,
	0xef, 0x46, 0xe7, 0x70, 0x14, 0xb1, 0x9f, 0x07,
	0xbf, 0x3f, 0x1f, 0xc8, 0x11, 0xe4, 0x2c, 0x39,
	0x48, 0x0e, 0xcf, 0x92, 0x62, 0x4b, 0x1f, 0x0c,
	0x2e, 0x29, 0x61, 0xef, 0x29, 0x67, 0x7c, 0x0f,
	0xac, 0x99, 0xb2, 0x9a, 0x7d, 0xac, 0x7c, 0x54,
	0xae, 0xed, 0x4b, 0xf5, 0x4a, 0x4b, 0xb4, 0x14,
	0xad, 0x6d, 0xce, 0xce, 0xcc, 0x3f, 0xb8, 0x59,
	0x71, 0x7c, 0xd4, 0x76, 0x7c, 0xe4, 0x68, 0xc6,
	0x76, 0xa8, 0xe3, 0x03, 0x48, 0xb6, 0xe4, 0x11,
	0x6c, 0x5f, 0xd4, 0x76, 0x80, 0xdf, 0x2c, 0x67,
	0x00, 0x4c, 0xce, 0x22, 0x21, 0xff, 0xb0, 0x9b,
	0xcb, 0x72, 0xd1, 0xe3, 0xa2, 0x32, 0x5c, 0x12,
	0xda, 0x7c, 0x95, 0x5d, 0xb2, 0xae, 0x1b, 0x25,
	0x2e, 0x5f, 0xe6, 0xff, 0x4c, 0xbf, 0x00, 0x16,
	0xd0, 0x3c, 0xbf, 0x44, 0x92, 0x07, 0xa0, 0x0d,
	0x13, 0xba, 0xb8, 0x62, 0x66, 0x0b, 0x14, 0x0f,
	0x5a, 0x9d, 0x42, 0x19, 0xd7, 0xbe, 0xe3, 0x33,
	0x53, 0xa2, 0x60, 0x2d, 0xde, 0x43, 0x85, 0x03,
	0x96, 0x50, 0x83, 0x83, 0x25, 0x3c, 0x19, 0x20,
	0x44, 0x5f, 0x3b, 0x5a, 0xc2, 0x90, 0xe1, 0x2d,
	0x47, 0x53, 0x50, 0xeb, 0xf7, 0xc7, 0x46, 0x4c,
	0xf2, 0xad, 0xb2, 0x8f, 0x03, 0x4e, 0x82, 0x5d,
	0x0f, 0xa0, 0x3d, 0xde, 0x4d, 0x93, 0x34, 0xd0,
	0x1a, 0xe2, 0x5d, 0xbc, 0xe5, 0x8d, 0xfb, 0x5a,
	0xba, 0xe2, 0x24, 0xec, 0xc8, 0xd2, 0xa3, 0x91,
	0xa2, 0xa9, 0x0e, 0x0e, 0xf5, 0xfb, 0x9f, 0xed,
	0x69, 0x21, 0x9d, 0x00, 0x92, 0xb5, 0x94, 0x0f,
	0x38, 0x94, 0x29, 0xf9, 0xe7, 0xaa, 0xf1, 0xf7,
	0x20, 0x10, 0xf0, 0xeb, 0x26, 0x96, 0x5a, 0x0e,
	0x99, 0x8d, 0x71, 0xef, 0xb2, 0xa0, 0xf3, 0x38,
	0xce, 0xf9, 0x99, 0x6f, 0x96, 0xbb, 0xa5, 0x55,
	0x27, 0x5c, 0xf5, 0xf8, 0x63, 0xf7, 0xf8, 0x0a,
	0x31, 0xee, 0x01, 0xa8, 0xc9, 0x0c, 0xbd, 0x73,
	0x62, 0x21, 0xa7, 0x1c, 0xd1, 0x62, 0xe5, 0xdd,
	0x43, 0x95, 0x4d, 0x60, 0x11, 0x65, 0x6c, 0xfa,
	0x67, 0x9a, 0x2f, 0x24, 0x1e, 0xbd, 0x10, 0xc4,
	0xe5, 0x23, 0x6f, 0x02, 0x76, 0x51, 0xd6, 0xe3,
	0xad, 0x88, 0xda, 0xc4, 0xd9, 0x6a, 0x8f, 0xf7,
	0xd2, 0x50, 0xdf, 0x9a, 0xad, 0x21, 0xc7, 0x5b,
	0x47, 0x83, 0xf6, 0xc8, 0xcb, 0x0a, 0xd5, 0x28,
	0x91, 0x3f, 0x18, 0x44, 0x62, 0x81, 0xfb, 0xcf,
	0x51, 0x5d, 0xa1, 0xf5, 0x46, 0x74, 0x0d, 0x32,
	0x21, 0x55, 0x1b, 0x8a, 0xf3, 0xd0, 0x4f, 0x41,
	0x86, 0xc3, 0x55, 0x0b, 0x1c, 0xd9, 0x56, 0x2f,
	0xcf, 0xe7, 0x9f, 0x06, 0x73, 0x82, 0xc2, 0x30,
	0x7a, 0xc2, 0x01, 0xa2, 0x1e, 0xeb, 0x5d, 0x77,
	0x7f, 0xbe, 0xee, 0xf4, 0x8a, 0x1b, 0x3b, 0xe3,
	0x2d, 0xd5, 0x3e, 0x3b, 0x40, 0x82, 0xd6, 0x60,
	0x86, 0x2f, 0xe9, 0xac, 0xc3, 0x65, 0xa5, 0xa3,
	0x8c, 0x54, 0x51, 0x1f, 0x8e, 0x89, 0x19, 0xdd,
	0xc5, 0x4a, 0xc0, 0xa2, 0x8b, 0xe5, 0x80, 0xfd,
	0xa1, 0xd8, 0xe9, 0x15, 0xa0, 0x94, 0xd7, 0x9e,
	0xe2, 0xf1, 0x83, 0x52, 0xf3, 0x0e, 0x34, 0x2f,
	0x85, 0x67, 0x49, 0x73, 0x67, 0xb9, 0xb5, 0xd5,
	0x0c, 0x1d, 0x03, 0x8e, 0x68, 0x57, 0x8d, 0xd2,
	0x33, 0x44, 0x94, 0x28, 0x5b, 0xfa, 0xe0, 0x2b,
	0x80, 0xd9, 0x96, 0x85, 0x6e, 0x0a, 0x2a, 0xdd,
	0x9b, 0x5b, 0x55, 0x5a, 0x31, 0xb6, 0xfe, 0x3e,
	0x0a, 0x41, 0x28, 0x20, 0xa7, 0xde, 0x31, 0xbe,
	0x73, 0xcb, 0xbc, 0xbb, 0x50, 0xf8, 0x58, 0x74,
	0xb1, 0x6b, 0x3f, 0x9a, 0x6c, 0x5e, 0x02, 0x87,
	0x8d, 0x19, 0xa1, 0xd3, 0x6a, 0xc2, 0x91, 0x82,
	0x3e, 0x0c, 0x90, 0xb8, 0xa6, 0x95, 0x23, 0x4e,
	0xb9, 0x2d, 0x4d, 0x6c, 0xfb, 0xd7, 0x5e, 0xdf,
	0xca, 0x06, 0x9b, 0x94, 0xb7, 0xfc, 0xbc, 0xad,
	0x39, 0x5d, 0x43, 0xcb, 0x1c, 0x7d, 0x3c, 0x95,
	0x3f, 0xf4, 0x47, 0x04, 0x1f, 0xfc, 0x8b, 0x23,
	0xe7, 0xcf, 0x24, 0x6f, 0x40, 0x9b, 0xa5, 0x56,
	0xcd, 0x69, 0x9e, 0x1f, 0x5a, 0xa0, 0x3b, 0x8f,
	0x3e, 0x1c, 0xe7, 0x42, 0xc9, 0x66, 0xee, 0x99,
	0x13, 0xb1, 0x4f, 0x65, 0x86, 0xba, 0xf0, 0x87,
	0x81, 0x6f, 0x44, 0x08, 0xb4, 0x18, 0xac, 0xb6,
	0xd3, 0x96, 0x68, 0xd4, 0x88, 0x89, 0xf2, 0xa2,
	0xd6, 0x2f, 0xfe, 0x7e, 0x49, 0xb3, 0x9c, 0xc9,
	0xaf, 0xd9, 0x28, 0xa8, 0x96, 0xc9, 0x2d, 0x26,
	0x5b, 0xc7, 0xef, 0x66, 0x08, 0xd2, 0x38, 0x4f,
	0x10, 0xb3, 0x83, 0x15, 0xf6, 0x00, 0x83, 0x3f,
	0x20, 0xfe, 0xa8, 0x44, 0x6b, 0x62, 0x3b, 0x17,
	0x39, 0x2e, 0xec, 0x5e, 0x78, 0xbe, 0xec, 0x16,
	0x29, 0xa6, 0x79, 0x4c, 0x08, 0x75, 0xc8, 0x78,
	0x3e, 0xc0, 0x05, 0xe9, 0xbb, 0x47, 0x94, 0xae,
	0xaf, 0xa5, 0xbb, 0xb8, 0x47, 0x31, 0xf7, 0xe9,
	0xb8, 0x1e, 0x6c, 0xda, 0x26, 0xc5, 0xf3, 0x26,
	0x89, 0xd5, 0x04, 0x23, 0x0b, 0x11, 0x84, 0x8f,
};

/* Signature */
uint8_t mldsa_44_sign[] = {
	0x3E, 0xDD, 0xD2, 0x34, 0x62, 0x78, 0xEC, 0x19,
	0x9F, 0xAA, 0xEC, 0x89, 0x99, 0x78, 0x31, 0xCB,
	0x82, 0x0B, 0xE6, 0x46, 0x8D, 0x24, 0x9A, 0xD3,
	0x69, 0xB7, 0x01, 0x85, 0x93, 0x75, 0xD0, 0xBE,
	0xEA, 0x1F, 0x76, 0xFB, 0xB4, 0x6D, 0xC9, 0x64,
	0xD4, 0x44, 0x68, 0x5D, 0xAD, 0x09, 0x69, 0xFC,
	0x31, 0x2F, 0xD1, 0xFA, 0xEF, 0xF2, 0x1D, 0x2E,
	0xB6, 0xA5, 0xA9, 0xFD, 0x31, 0x04, 0x68, 0x1E,
	0x0B, 0xEC, 0xF4, 0x23, 0x4C, 0x9F, 0xC9, 0xD6,
	0x27, 0x8D, 0xE1, 0xAA, 0x29, 0x38, 0x16, 0x65,
	0x7E, 0x38, 0x5A, 0x30, 0xFC, 0xD9, 0xBF, 0x63,
	0x3B, 0x82, 0xFE, 0x0D, 0x68, 0xD4, 0x52, 0x55,
	0xBE, 0x86, 0x69, 0xCF, 0x75, 0x26, 0x2C, 0xB9,
	0x1D, 0x66, 0x39, 0x4C, 0x89, 0xAC, 0x36, 0xBF,
	0x34, 0x27, 0xCC, 0x7E, 0x6C, 0xC5, 0xBB, 0xFB,
	0x78, 0x03, 0x39, 0x61, 0xD8, 0x76, 0x63, 0x6E,
	0x6B, 0x68, 0x02, 0x43, 0x44, 0x57, 0x2E, 0x39,
	0x9E, 0x9D, 0x64, 0x77, 0x8E, 0x8B, 0x79, 0x36,
	0xCE, 0xE6, 0xBC, 0x6D, 0x80, 0xC8, 0x04, 0x81,
	0x2A, 0x04, 0xD4, 0xEF, 0x63, 0xE1, 0x3F, 0xC4,
	0xC1, 0x54, 0xD5, 0xAB, 0xE4, 0xEC, 0x65, 0xB0,
	0xF0, 0x1A, 0xB2, 0x32, 0x9A, 0xB8, 0x51, 0xD4,
	0x43, 0xFE, 0x81, 0x4F, 0xBD, 0x5D, 0xEE, 0xDE,
	0x24, 0xAC, 0xBC, 0x22, 0x9B, 0x80, 0xB7, 0xE8,
	0x22, 0x4B, 0x1B, 0x23, 0x89, 0x8C, 0xFE, 0xE3,
	0x30, 0x35, 0xA2, 0x0B, 0x4E, 0x66, 0x64, 0xFE,
	0x57, 0x68, 0xCF, 0xF5, 0xE5, 0x11, 0xB9, 0xB6,
	0x3A, 0x2B, 0x15, 0x0D, 0xA4, 0x11, 0xE1, 0x01,
	0x96, 0x06, 0x5D, 0x47, 0xCC, 0x04, 0x63, 0xB3,
	0xC7, 0xDD, 0x0F, 0x4A, 0x0A, 0x90, 0x9C, 0x0C,
	0x61, 0x1D, 0x4C, 0x21, 0x32, 0xD6, 0xE9, 0xDD,
	0x0F, 0x91, 0xA4, 0xD1, 0x30, 0x14, 0x1C, 0x48,
	0xEC, 0xF4, 0x4F, 0x02, 0x7B, 0x1E, 0x25, 0x3A,
	0x7C, 0x6B, 0x42, 0x13, 0xF7, 0xBC, 0xB5, 0x02,
	0xA9, 0x20, 0x85, 0x21, 0x01, 0x67, 0xC3, 0xDD,
	0x6C, 0x6D, 0xD3, 0xC9, 0x6F, 0x13, 0x75, 0xDD,
	0x1D, 0xD7, 0xE7, 0xF3, 0x34, 0x17, 0x37, 0xFF,
	0xE6, 0x3B, 0xB5, 0x1F, 0xEE, 0x51, 0x73, 0x6D,
	0x9E, 0xB7, 0xE2, 0xE7, 0xA1, 0x65, 0xE4, 0x29,
	0x8E, 0xBF, 0x66, 0xCE, 0x5E, 0xD4, 0xBA, 0x0C,
	0x18, 0x84, 0xBE, 0xAE, 0x9A, 0x17, 0x0D, 0xAE,
	0x55, 0x90, 0x7F, 0x72, 0x73, 0xAB, 0x9F, 0x87,
	0xCC, 0x3D, 0xCB, 0xE4, 0x38, 0x66, 0x92, 0xEE,
	0x6D, 0xE9, 0x0B, 0x8A, 0xE2, 0x5F, 0x68, 0x9D,
	0x06, 0xFD, 0xF3, 0x77, 0x4B, 0x50, 0xCD, 0x0E,
	0x2B, 0xE1, 0xD3, 0xB4, 0xF4, 0x02, 0xF5, 0x9B,
	0x5F, 0x3E, 0x59, 0xD7, 0x57, 0x9D, 0x87, 0x80,
	0x60, 0xEB, 0x70, 0xF5, 0x34, 0x56, 0x46, 0x5B,
	0xBA, 0x8F, 0x90, 0xAE, 0x9F, 0x6B, 0x43, 0x8C,
	0x51, 0x45, 0xD2, 0x16, 0x4C, 0xBA, 0x86, 0xF0,
	0xF4, 0xD5, 0x34, 0x6A, 0x3E, 0x5F, 0xAE, 0xBE,
	0x95, 0x40, 0xFE, 0x26, 0x4D, 0x5E, 0x60, 0x4E,
	0xD9, 0xEB, 0x47, 0x7D, 0x43, 0x63, 0x5F, 0x4B,
	0xB1, 0xCE, 0x7E, 0xA2, 0xF0, 0xC9, 0x30, 0x0C,
	0xB7, 0x13, 0x43, 0xC0, 0xF8, 0x02, 0x6C, 0xD2,
	0x5F, 0xCE, 0x25, 0xF3, 0xAE, 0xC3, 0x2D, 0xC3,
	0x13, 0xAE, 0x49, 0x8B, 0x82, 0x82, 0x44, 0xD0,
	0x50, 0xF8, 0x00, 0x5E, 0xAC, 0xDE, 0x4B, 0x88,
	0xC2, 0x38, 0x5C, 0xC3, 0x65, 0xF4, 0x25, 0x63,
	0x29, 0xC3, 0xB0, 0x7A, 0x45, 0x5D, 0x43, 0x89,
	0xCA, 0x5A, 0x12, 0x61, 0xD8, 0x92, 0x65, 0x1B,
	0x0F, 0xBF, 0x62, 0xB9, 0xA6, 0xF2, 0xA8, 0xA7,
	0x06, 0xAC, 0x02, 0xA4, 0xC6, 0x25, 0xD6, 0xC5,
	0xD2, 0xDE, 0x87, 0x88, 0x11, 0xBD, 0x7C, 0x87,
	0x91, 0xA9, 0x91, 0x60, 0x1F, 0x0F, 0xF0, 0x24,
	0xFE, 0xA0, 0xEB, 0xDC, 0x89, 0x68, 0x84, 0x10,
	0xD7, 0x55, 0xC1, 0x3A, 0xCA, 0x1F, 0xFF, 0x77,
	0x41, 0xA1, 0xDB, 0x13, 0x31, 0xEF, 0x9C, 0xA3,
	0xA2, 0x3A, 0x37, 0x1B, 0xF9, 0x46, 0xF8, 0x51,
	0x15, 0xB3, 0x0A, 0x12, 0x64, 0x3F, 0xE5, 0xA8,
	0x07, 0xA2, 0x57, 0x87, 0x2A, 0x3F, 0xD2, 0x87,
	0xDB, 0xC0, 0x33, 0xAC, 0xF5, 0x28, 0x42, 0xC5,
	0xD4, 0x20, 0x27, 0xAE, 0x57, 0xAF, 0x6C, 0x74,
	0x8A, 0xA0, 0x90, 0xEE, 0x34, 0xE9, 0x19, 0xB9,
	0x0E, 0xDF, 0x4D, 0xDE, 0x77, 0x66, 0xC4, 0xBC,
	0x99, 0x59, 0x14, 0xCB, 0x9D, 0xBF, 0xBC, 0x5F,
	0xFF, 0x2B, 0xA7, 0xED, 0x29, 0x49, 0x13, 0x6C,
	0x2B, 0x71, 0x58, 0xC2, 0xC4, 0x67, 0xCB, 0x6A,
	0x18, 0x6F, 0x4E, 0x88, 0xB9, 0x76, 0xC8, 0x6B,
	0xDC, 0x6A, 0x05, 0xA5, 0x22, 0x31, 0x15, 0xCE,
	0x54, 0xDA, 0xE8, 0x0E, 0xED, 0xDF, 0x46, 0x90,
	0x93, 0x9A, 0xE6, 0x2B, 0x45, 0xA4, 0x51, 0x42,
	0x29, 0x05, 0xA9, 0xFF, 0x29, 0xBE, 0x4F, 0x6E,
	0xE7, 0x52, 0x2C, 0x16, 0x3F, 0x95, 0x94, 0x7B,
	0xE6, 0xE1, 0xF7, 0x9F, 0x36, 0x1F, 0xEE, 0x46,
	0xA9, 0xE3, 0x71, 0x37, 0x08, 0xF7, 0x63, 0xAF,
	0x16, 0xB9, 0x43, 0x86, 0xAC, 0xC7, 0x5D, 0x5B,
	0x73, 0x38, 0x08, 0x2C, 0xC6, 0x65, 0x02, 0xC8,
	0x70, 0x71, 0x01, 0xA7, 0xD3, 0xA6, 0xB9, 0x74,
	0xAA, 0x71, 0x3B, 0x1B, 0xEF, 0x84, 0xA9, 0x77,
	0x91, 0x82, 0x7F, 0xB7, 0x3D, 0x2E, 0x8B, 0xD5,
	0x4D, 0xAD, 0x29, 0xAC, 0x51, 0x9E, 0xDB, 0xF0,
	0x4A, 0x1D, 0x29, 0x82, 0x04, 0x9E, 0x03, 0x8C,
	0x74, 0x66, 0x12, 0x75, 0xD0, 0x77, 0x07, 0xCC,
	0x7E, 0x8D, 0x19, 0x2F, 0x42, 0xFA, 0xB7, 0xBD,
	0x7E, 0x77, 0xEF, 0xF1, 0x35, 0xAF, 0x7C, 0xFF,
	0x52, 0x5F, 0xDB, 0x03, 0x99, 0x0D, 0x89, 0x8A,
	0x60, 0x61, 0x42, 0xC2, 0xE7, 0x33, 0x58, 0xE7,
	0x40, 0x90, 0x46, 0x84, 0xD5, 0x4B, 0x30, 0x88,
	0xA7, 0xBB, 0x25, 0xDE, 0x02, 0xFE, 0x57, 0x93,
	0xFD, 0xD0, 0x6E, 0xA2, 0xFE, 0x38, 0xA3, 0x5E,
	0x6C, 0x35, 0x06, 0xC4, 0xC6, 0x8C, 0x9C, 0x37,
	0x3B, 0x6A, 0x1D, 0x91, 0xCB, 0x84, 0x03, 0x47,
	0x85, 0xC7, 0x1D, 0x82, 0xEE, 0xB5, 0xF8, 0xEC,
	0x29, 0xDE, 0x30, 0x76, 0x32, 0x08, 0x6A, 0x75,
	0x43, 0x6A, 0xB8, 0x4C, 0x5D, 0x5A, 0x54, 0xC2,
	0xE3, 0x58, 0x43, 0x6E, 0x90, 0xCE, 0x51, 0xEB,
	0xE2, 0xFD, 0x68, 0xAE, 0xB3, 0xBA, 0x80, 0xB4,
	0x03, 0x84, 0x26, 0x4E, 0xAB, 0x7B, 0x15, 0x2D,
	0xDE, 0xB0, 0x7B, 0xF3, 0x4D, 0xFB, 0x6A, 0xFC,
	0xE3, 0x47, 0xFC, 0x9C, 0x34, 0xC8, 0xB2, 0x10,
	0x46, 0xCC, 0x5F, 0x0A, 0xC6, 0xEB, 0x48, 0x47,
	0xFF, 0x73, 0x75, 0xD0, 0x7C, 0xBF, 0x44, 0xCB,
	0xAE, 0x8A, 0x30, 0x0B, 0x3F, 0x58, 0x11, 0x51,
	0x32, 0xD5, 0x7C, 0xCC, 0xB5, 0xDB, 0xD9, 0x21,
	0xD0, 0x6C, 0x29, 0xE2, 0xD0, 0xE1, 0xB2, 0xC8,
	0x06, 0x29, 0xC0, 0xC8, 0x5B, 0xB2, 0x3A, 0x66,
	0x7A, 0x25, 0x13, 0x57, 0x80, 0x14, 0x5B, 0x31,
	0xC4, 0x7B, 0x21, 0xB5, 0x50, 0x9C, 0x76, 0x6B,
	0x8C, 0x16, 0xF7, 0x95, 0xA1, 0x79, 0x6B, 0xA8,
	0x22, 0x13, 0xD5, 0x32, 0x15, 0x3E, 0xFC, 0x55,
	0x80, 0xD2, 0x71, 0xD1, 0x59, 0x15, 0xDA, 0xFC,
	0x55, 0x75, 0xE7, 0x7E, 0x15, 0x48, 0xD9, 0x73,
	0x0D, 0x6A, 0x31, 0x8A, 0x1C, 0x86, 0x4A, 0x31,
	0x57, 0x5B, 0x0A, 0x9D, 0xE4, 0x8C, 0x80, 0x7F,
	0x0E, 0x07, 0x36, 0x38, 0x7C, 0xEA, 0x3C, 0xBD,
	0xBD, 0xD1, 0xAA, 0xE7, 0xE4, 0x43, 0xB2, 0xFC,
	0x26, 0x39, 0x4F, 0xCC, 0xE6, 0xB8, 0xD7, 0x90,
	0xC3, 0x5F, 0xAA, 0xEA, 0x78, 0xC6, 0xD7, 0x58,
	0x15, 0x7D, 0x27, 0xD0, 0x7E, 0x0F, 0x13, 0x0D,
	0x47, 0x49, 0x28, 0x5B, 0xD7, 0xBC, 0x41, 0xB5,
	0x66, 0x38, 0x29, 0xB4, 0x71, 0xEC, 0xA2, 0xDE,
	0xE3, 0xE0, 0x4C, 0x27, 0xB4, 0x2C, 0xEE, 0xF1,
	0x5F, 0x37, 0x81, 0xCE, 0x31, 0x42, 0x87, 0x44,
	0x39, 0x7B, 0x35, 0xCF, 0xE8, 0x7D, 0x5E, 0xD7,
	0xA3, 0x3D, 0xB9, 0x92, 0x95, 0x8C, 0x25, 0xC6,
	0xC9, 0xBC, 0x46, 0x4E, 0x03, 0x70, 0x29, 0x4B,
	0x79, 0xB8, 0xEF, 0x54, 0x98, 0x8B, 0x9A, 0x45,
	0x09, 0x8C, 0x43, 0xD1, 0x9B, 0x29, 0xEA, 0xDE,
	0xF2, 0x25, 0x10, 0xA6, 0xF9, 0x2C, 0xC8, 0x90,
	0x49, 0xA5, 0x3C, 0xDC, 0xCE, 0xA3, 0x98, 0xF1,
	0x4C, 0xC6, 0x3E, 0xE0, 0x21, 0x58, 0x1A, 0x39,
	0xDA, 0x50, 0x2A, 0x6A, 0x18, 0x49, 0xC9, 0xA1,
	0x9D, 0xF3, 0xF4, 0xFB, 0xDD, 0x6F, 0x8D, 0xF4,
	0xFE, 0x61, 0xA0, 0xC6, 0xF5, 0x58, 0x89, 0xAE,
	0xEC, 0xC6, 0xE0, 0x88, 0x4A, 0x07, 0x6F, 0x11,
	0x72, 0x5A, 0x6D, 0x3E, 0x08, 0x64, 0x3E, 0x23,
	0x7D, 0x9A, 0x74, 0xB3, 0xC3, 0xDA, 0xA7, 0x29,
	0x0E, 0xC1, 0x37, 0xB0, 0x04, 0x42, 0x47, 0x01,
	0x80, 0x4B, 0xC0, 0x35, 0x49, 0x19, 0xB1, 0xDB,
	0x51, 0x51, 0x09, 0x90, 0x08, 0xB2, 0xC4, 0x5C,
	0xA0, 0xD6, 0x6E, 0x09, 0xFF, 0xA0, 0xC6, 0x4F,
	0x32, 0x95, 0x84, 0xBE, 0xAA, 0x4A, 0x0A, 0x36,
	0x83, 0xD3, 0x0C, 0xB7, 0xE0, 0xD0, 0x24, 0xE9,
	0x0A, 0x2F, 0x0F, 0xB4, 0x3A, 0x2F, 0xCE, 0x34,
	0xE5, 0xF0, 0x67, 0x07, 0x72, 0x52, 0x24, 0xE9,
	0x9F, 0xBF, 0xDE, 0x40, 0x95, 0xAD, 0x74, 0x41,
	0x4A, 0x00, 0x07, 0xEB, 0x14, 0xDD, 0xC4, 0xA2,
	0x37, 0x72, 0x83, 0xE7, 0xD6, 0x20, 0xF5, 0xC6,
	0x86, 0x97, 0xC5, 0x64, 0x58, 0x1B, 0x57, 0x5F,
	0x9D, 0x06, 0x1D, 0xB5, 0x2D, 0x26, 0xBA, 0xE4,
	0x49, 0x71, 0x08, 0xBD, 0x21, 0xC4, 0xA9, 0xF3,
	0x26, 0x7A, 0x28, 0xD6, 0x81, 0x20, 0xCD, 0x9C,
	0xED, 0xB8, 0xDC, 0x45, 0x33, 0xC0, 0x54, 0x5C,
	0x3A, 0xF5, 0xC5, 0x1B, 0x19, 0x10, 0xCA, 0xDF,
	0x99, 0xD4, 0xEE, 0x25, 0xD6, 0x71, 0x24, 0x4D,
	0xFF, 0x14, 0x85, 0x58, 0x07, 0xC8, 0x3F, 0xD6,
	0x55, 0x1C, 0xBF, 0xF8, 0x94, 0x31, 0x04, 0x83,
	0xEC, 0xD1, 0xF5, 0x20, 0x72, 0xC3, 0xE9, 0xB1,
	0x8A, 0x00, 0x0B, 0x94, 0x53, 0x4C, 0x01, 0x8C,
	0xDE, 0x80, 0x59, 0x66, 0x72, 0x2D, 0xC5, 0x78,
	0xAC, 0x4A, 0xAD, 0x4F, 0x14, 0xC1, 0x78, 0x87,
	0x5F, 0xDF, 0xF2, 0x95, 0xCF, 0x8F, 0x3F, 0xA6,
	0xCC, 0xAA, 0x1E, 0xD8, 0xA8, 0x37, 0xAD, 0x5B,
	0xA5, 0x6D, 0xBC, 0x81, 0xAC, 0xCD, 0xFD, 0x56,
	0x9E, 0x8B, 0xB9, 0xEC, 0x7E, 0x82, 0x4E, 0x55,
	0x05, 0xFD, 0x9F, 0xDC, 0x0A, 0xF7, 0xBD, 0x3F,
	0xEA, 0x42, 0x9D, 0x7E, 0xAB, 0x09, 0xDF, 0x3D,
	0xA3, 0x8C, 0x63, 0x78, 0x81, 0x8F, 0x46, 0x9F,
	0x12, 0xB8, 0x8A, 0xA5, 0xE4, 0xE9, 0x73, 0x95,
	0x37, 0xD3, 0x39, 0xFE, 0x9B, 0x69, 0x58, 0x05,
	0x5B, 0x30, 0x09, 0x31, 0x8B, 0xD9, 0xDB, 0xAE,
	0x96, 0x93, 0x96, 0xDF, 0xC0, 0x70, 0x1D, 0xFF,
	0x5D, 0x60, 0x72, 0x5A, 0xDD, 0xC2, 0x3D, 0xCF,
	0x13, 0xA0, 0x36, 0x38, 0xF4, 0x3A, 0x03, 0x15,
	0x48, 0xF0, 0xB1, 0x4A, 0x12, 0x72, 0xBA, 0x6B,
	0xE2, 0xD6, 0x4E, 0x57, 0x22, 0x87, 0x2F, 0xE7,
	0x40, 0x1B, 0x22, 0xF3, 0x4A, 0xE7, 0xB1, 0xA4,
	0x28, 0xC7, 0xBB, 0x17, 0x5E, 0x0C, 0x03, 0xE3,
	0xF4, 0x67, 0x25, 0xB2, 0xBB, 0xE6, 0x4E, 0xCD,
	0x8A, 0x39, 0xC6, 0x05, 0xB7, 0x14, 0x10, 0xF4,
	0x36, 0xE9, 0x8A, 0xC3, 0x41, 0xD3, 0x30, 0xAD,
	0x79, 0x56, 0xE2, 0xC3, 0x55, 0xFC, 0x05, 0x3B,
	0xD0, 0x83, 0x31, 0xE7, 0xA1, 0x85, 0xBE, 0x6C,
	0xAF, 0x9D, 0xA6, 0x26, 0xC4, 0x7A, 0x4B, 0xD8,
	0x26, 0xA7, 0x59, 0xBB, 0x8D, 0x6E, 0x15, 0x96,
	0x84, 0x08, 0x0B, 0xDF, 0x29, 0x2D, 0x74, 0xD9,
	0xAD, 0xFE, 0xC1, 0x3A, 0x84, 0x4E, 0xCE, 0x8F,
	0x00, 0x9A, 0x50, 0xB8, 0x6F, 0x02, 0xE6, 0xEC,
	0xA9, 0xE6, 0x1F, 0x71, 0x6A, 0x48, 0x98, 0x61,
	0x3B, 0xC1, 0x37, 0x5A, 0x2E, 0xF3, 0xE0, 0xD6,
	0x11, 0x0C, 0x15, 0x39, 0x7B, 0xFB, 0x37, 0xAF,
	0x7A, 0xCA, 0xD6, 0x10, 0xDE, 0x95, 0x6A, 0xC6,
	0x19, 0xEC, 0x21, 0x51, 0xCE, 0xAE, 0x8F, 0x5A,
	0xEE, 0xEF, 0xB2, 0x9C, 0xF7, 0x4F, 0x5A, 0xB4,
	0x90, 0xED, 0xB0, 0x64, 0x59, 0x95, 0xC5, 0x32,
	0xC1, 0x85, 0xD7, 0x7E, 0x6C, 0xC6, 0x76, 0x11,
	0x4B, 0xB5, 0x17, 0x1D, 0xEE, 0x15, 0xFF, 0xD3,
	0xC7, 0xBB, 0xAA, 0x3C, 0x5D, 0x4D, 0x03, 0x82,
	0xC0, 0xC7, 0xEA, 0xD0, 0xD8, 0x1B, 0xFF, 0x3C,
	0x1D, 0x5A, 0x3F, 0xBD, 0x81, 0x66, 0x62, 0x6E,
	0xB3, 0xF5, 0x5F, 0xF0, 0x43, 0x90, 0x01, 0x71,
	0xDD, 0xB6, 0x0F, 0x60, 0xCE, 0xFB, 0x17, 0x21,
	0x5A, 0x7F, 0x0C, 0x69, 0x82, 0x9D, 0x4C, 0xF3,
	0x30, 0x1A, 0xF7, 0x1E, 0x85, 0x1A, 0x89, 0x84,
	0xF3, 0x4E, 0x8F, 0x15, 0x60, 0x43, 0x6D, 0x3A,
	0x5B, 0x07, 0xC0, 0x78, 0x6A, 0x02, 0xB4, 0x98,
	0x3D, 0xAB, 0xAC, 0x25, 0x55, 0xC8, 0x49, 0x7E,
	0xC9, 0x04, 0x73, 0xAF, 0x0D, 0x17, 0x1A, 0xA6,
	0xBE, 0xD8, 0x11, 0x69, 0x4F, 0x17, 0x39, 0xF3,
	0x57, 0x53, 0x1F, 0xD5, 0x1B, 0x15, 0x89, 0x53,
	0x54, 0xB1, 0x9F, 0xFD, 0x52, 0x92, 0xA8, 0x98,
	0xD4, 0x7B, 0xEE, 0x43, 0xC6, 0x31, 0xDE, 0xEC,
	0xDC, 0xE5, 0x1D, 0x90, 0x37, 0x63, 0xA1, 0xF8,
	0x42, 0x52, 0x8A, 0x73, 0x8B, 0x3D, 0x42, 0x85,
	0x64, 0x5C, 0xA9, 0xCC, 0xA1, 0xCD, 0xEB, 0x9E,
	0x2A, 0xF5, 0x21, 0x9E, 0x81, 0xC6, 0x2D, 0xD7,
	0x22, 0xC2, 0xEE, 0x47, 0x7E, 0xDA, 0x60, 0x26,
	0xFA, 0xE9, 0xB1, 0x81, 0x01, 0x77, 0xD3, 0x42,
	0xDD, 0x03, 0x65, 0x74, 0x2B, 0x85, 0x49, 0x9A,
	0xA5, 0x27, 0x76, 0x49, 0xF1, 0x72, 0x5E, 0xDF,
	0xB7, 0xAD, 0x19, 0x1A, 0x58, 0x89, 0x56, 0x5C,
	0x61, 0x03, 0xC7, 0x42, 0x84, 0xF2, 0x9E, 0x9E,
	0x09, 0x2A, 0x2D, 0x3B, 0xAE, 0x6A, 0x8E, 0x9A,
	0x87, 0x70, 0x16, 0x0A, 0xF1, 0xA9, 0xEA, 0xD2,
	0xF3, 0x2A, 0xA3, 0xB0, 0x32, 0xD3, 0x28, 0x92,
	0x19, 0x02, 0x77, 0xB2, 0x26, 0x1B, 0xC0, 0x59,
	0x1A, 0x67, 0x4B, 0x51, 0x04, 0x83, 0x25, 0xF6,
	0x4E, 0xA3, 0x92, 0x55, 0xCD, 0x74, 0xF5, 0x23,
	0x98, 0xB7, 0xB9, 0x75, 0xA6, 0xDC, 0x4E, 0xD2,
	0x93, 0x39, 0x94, 0xA3, 0xCD, 0xF8, 0xD5, 0xA4,
	0xA9, 0x3C, 0x97, 0xED, 0x18, 0x54, 0xBB, 0x59,
	0x7E, 0x75, 0xE3, 0xEE, 0x5A, 0x36, 0x53, 0x3D,
	0x02, 0xFB, 0x47, 0xE6, 0x10, 0x1D, 0xDF, 0x21,
	0xDA, 0x44, 0x66, 0x05, 0x81, 0xC4, 0xE9, 0x3B,
	0xD5, 0x56, 0xC5, 0xAD, 0x50, 0x7A, 0xE1, 0xAA,
	0x91, 0x7F, 0x7C, 0x4E, 0x85, 0xCC, 0xDC, 0x4A,
	0xBD, 0x72, 0x1F, 0x3F, 0x21, 0x93, 0x98, 0x21,
	0xB8, 0xCC, 0x21, 0x00, 0x24, 0x13, 0xAB, 0x63,
	0xC1, 0x31, 0xCA, 0x1C, 0x67, 0x0C, 0x0E, 0x5A,
	0x62, 0xC3, 0x1E, 0x6D, 0x63, 0x9B, 0xDA, 0x7F,
	0x92, 0xC4, 0x64, 0x8B, 0xC7, 0x80, 0x04, 0x05,
	0x36, 0x06, 0xCE, 0xF7, 0x37, 0x3A, 0xA8, 0xDF,
	0x2C, 0x61, 0x46, 0x48, 0x2A, 0x5C, 0xDC, 0xBB,
	0x34, 0x16, 0xDA, 0x59, 0x0D, 0x5B, 0xE5, 0x08,
	0x05, 0xAF, 0x59, 0x86, 0x34, 0x56, 0x88, 0x4F,
	0xAF, 0xA0, 0x28, 0xC4, 0xF2, 0x97, 0xC6, 0xF4,
	0x7C, 0xFD, 0xA4, 0x20, 0xE4, 0x20, 0x2C, 0xDA,
	0x98, 0xAD, 0x4A, 0x96, 0x9F, 0x62, 0xBB, 0x1C,
	0xB6, 0x28, 0xB0, 0xD0, 0xEA, 0x3B, 0xB8, 0x3C,
	0x8D, 0x4E, 0x97, 0xEA, 0x9E, 0x63, 0xAA, 0xAA,
	0x8D, 0x22, 0x61, 0x29, 0x1A, 0x82, 0x29, 0x86,
	0x87, 0x62, 0xA4, 0xE4, 0xC0, 0x03, 0x93, 0x55,
	0x7D, 0x40, 0xE9, 0x43, 0x14, 0x9C, 0xE2, 0xDA,
	0x0A, 0x00, 0x37, 0xEA, 0x80, 0xB8, 0x31, 0x66,
	0xAE, 0xD7, 0xF8, 0xB4, 0x24, 0xC7, 0x78, 0xDB,
	0x23, 0x66, 0x61, 0xA5, 0x47, 0x10, 0x4A, 0xE8,
	0x79, 0xB6, 0xBD, 0x6A, 0xB6, 0x22, 0x6C, 0x7B,
	0x19, 0xF3, 0x80, 0x35, 0x9A, 0x15, 0x36, 0x89,
	0x2A, 0x2C, 0xED, 0x26, 0xF1, 0x96, 0xFF, 0x30,
	0x4D, 0x03, 0x82, 0x2C, 0x69, 0x31, 0x40, 0x40,
	0x0C, 0xD1, 0x40, 0x3E, 0xE0, 0xB5, 0x37, 0xA8,
	0x6D, 0x68, 0x68, 0x8F, 0x9E, 0xC5, 0x12, 0x05,
	0xF5, 0x36, 0x85, 0x5F, 0x8A, 0x52, 0x7B, 0x60,
	0xA2, 0xC2, 0x39, 0xAF, 0x87, 0xC8, 0xC4, 0xF2,
	0x53, 0x1D, 0xF0, 0x84, 0x32, 0x8A, 0x04, 0x42,
	0xBF, 0xCA, 0x1A, 0x08, 0x89, 0x71, 0xCA, 0xC8,
	0x11, 0xA6, 0xDC, 0xED, 0x31, 0xFC, 0x41, 0xFC,
	0x84, 0x75, 0xA5, 0x98, 0x67, 0x9E, 0xE7, 0x69,
	0x9F, 0x3C, 0x42, 0x94, 0x69, 0xA5, 0x1D, 0xC2,
	0x55, 0x9D, 0x2E, 0xC9, 0x13, 0x3C, 0x68, 0x94,
	0xA9, 0x7E, 0x6A, 0xFC, 0x11, 0xE3, 0x97, 0x0D,
	0x59, 0x8F, 0x8D, 0x05, 0x01, 0x4A, 0x74, 0xB6,
	0x96, 0x6D, 0x1E, 0x7F, 0x63, 0xA5, 0x54, 0x39,
	0x5A, 0x6C, 0xB9, 0x9B, 0xC3, 0x79, 0xCB, 0xD3,
	0xC9, 0xE9, 0x37, 0x9E, 0xDC, 0x3B, 0xE2, 0xD2,
	0xE6, 0x07, 0x77, 0xFA, 0xD5, 0xCF, 0xD6, 0x42,
	0x45, 0x46, 0xFE, 0x06, 0x28, 0x0E, 0x4D, 0xA6,
	0x72, 0xE6, 0x6F, 0x39, 0xCD, 0xB9, 0xBF, 0x43,
	0xF7, 0xD9, 0x99, 0x9B, 0x46, 0xF1, 0x80, 0xBA,
	0x07, 0x4A, 0x0A, 0xC3, 0x9F, 0xD3, 0xCB, 0xA5,
	0x85, 0xF7, 0xEE, 0x9F, 0x6D, 0xC0, 0x52, 0xD7,
	0x17, 0x27, 0x81, 0x92, 0x98, 0xA0, 0xBB, 0xC9,
	0xD7, 0xE4, 0xF0, 0xF8, 0x25, 0x2C, 0x38, 0x3B,
	0x44, 0x4E, 0x55, 0x57, 0x5F, 0x86, 0x9A, 0xA1,
	0xB2, 0xBB, 0xBF, 0xE4, 0xF4, 0x04, 0x0D, 0x16,
	0x34, 0x48, 0x5A, 0x68, 0x72, 0x88, 0x8B, 0x97,
	0xA5, 0xAC, 0xBC, 0xC4, 0xC9, 0xCC, 0xF3, 0x03,
	0x12, 0x14, 0x2C, 0x3B, 0x3E, 0x3F, 0x4D, 0x52,
	0x79, 0x7A, 0x91, 0x96, 0xA8, 0xB3, 0xBB, 0xCC,
	0xCF, 0xD7, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0C, 0x1D, 0x2F, 0x43,
};

/* Deterministic Signature */
uint8_t mldsa_44_sign_dtrm[] = {
	0xC7, 0x9B, 0x98, 0x33, 0xEA, 0xCC, 0xCC, 0x47,
	0x51, 0x8F, 0xE1, 0xC0, 0xDA, 0x82, 0x9B, 0xAA,
	0x74, 0x0A, 0x14, 0x25, 0x73, 0x53, 0x27, 0x7C,
	0x4C, 0x4A, 0xD6, 0xB7, 0x7C, 0x71, 0x25, 0xD8,
	0xC5, 0xBA, 0xA8, 0x18, 0x59, 0xC7, 0x64, 0x2E,
	0x9A, 0x65, 0xE9, 0x63, 0x83, 0x3D, 0xB8, 0x2B,
	0x42, 0x0A, 0x6D, 0x7D, 0xCE, 0x6A, 0xA3, 0x11,
	0xD6, 0xB6, 0x54, 0x82, 0x36, 0x38, 0xF1, 0x84,
	0x01, 0x3E, 0x26, 0x66, 0xC7, 0x38, 0x6F, 0x41,
	0x4C, 0xC2, 0x42, 0xB5, 0xBF, 0xCE, 0x7B, 0x8B,
	0xD5, 0x4F, 0x9B, 0x9F, 0x0E, 0xFE, 0x52, 0xAF,
	0x6D, 0x39, 0xD8, 0x0A, 0x27, 0x4D, 0xDB, 0x9F,
	0x04, 0x25, 0x8C, 0xF5, 0x89, 0x5B, 0xEB, 0xDC,
	0x70, 0xBF, 0x23, 0x1D, 0x14, 0x73, 0x9E, 0xFC,
	0x41, 0xA0, 0xA2, 0xA5, 0xAA, 0xAB, 0x8E, 0xCD,
	0x5E, 0x29, 0xC5, 0x3E, 0xEC, 0x0A, 0xD9, 0x06,
	0xEB, 0x8C, 0x18, 0x41, 0x80, 0x91, 0x5D, 0xC9,
	0x28, 0xCE, 0xDB, 0x1C, 0x0E, 0x8F, 0xE3, 0xC0,
	0xE5, 0xB1, 0x0A, 0x38, 0x06, 0x43, 0x36, 0x0D,
	0xF8, 0xE6, 0x2E, 0xCB, 0xEB, 0x51, 0xC8, 0x82,
	0xE0, 0x3B, 0xCB, 0xCE, 0x62, 0xC8, 0xE0, 0x8A,
	0x2C, 0xE4, 0xC7, 0xD7, 0xC1, 0x8A, 0x64, 0x0D,
	0xE8, 0x5A, 0x52, 0x83, 0x58, 0x93, 0x2A, 0x25,
	0x92, 0x65, 0x19, 0x4F, 0x0F, 0x44, 0x1C, 0xCE,
	0x56, 0x91, 0xB4, 0xC9, 0x8D, 0x9E, 0x6A, 0xD5,
	0xCA, 0xE3, 0xA0, 0xE3, 0x46, 0x45, 0x0D, 0x59,
	0x14, 0x90, 0x72, 0x67, 0xC5, 0x95, 0xAC, 0x2A,
	0xC4, 0x70, 0xD2, 0xCA, 0x40, 0x1D, 0x62, 0x0E,
	0x2A, 0xA4, 0x3E, 0xAC, 0x45, 0x00, 0x96, 0xA4,
	0xF6, 0xAC, 0xEE, 0x01, 0x19, 0xEB, 0xCC, 0x8C,
	0x62, 0xE3, 0x26, 0x59, 0xB7, 0xB9, 0xBF, 0xBB,
	0x8D, 0x72, 0xAD, 0x1A, 0xA2, 0x8D, 0xB1, 0x1B,
	0xC1, 0xC1, 0xD8, 0xFF, 0x03, 0xAF, 0x74, 0xDF,
	0xC6, 0x3C, 0xCE, 0xBD, 0xA8, 0x12, 0xFA, 0xAC,
	0x83, 0x8C, 0x7E, 0x26, 0x8E, 0x0D, 0x03, 0xF3,
	0x02, 0x17, 0x23, 0x13, 0x25, 0x01, 0x1F, 0xB9,
	0x3B, 0x1C, 0x3E, 0xA7, 0xD9, 0xE4, 0xE6, 0xCA,
	0xD6, 0x0C, 0x91, 0xAC, 0xEE, 0xD4, 0x42, 0xA7,
	0xB1, 0x62, 0x70, 0xC8, 0xC9, 0x2F, 0x0A, 0xE0,
	0xA8, 0xC7, 0x22, 0xE5, 0x2C, 0x06, 0x1C, 0x09,
	0x4B, 0x45, 0x25, 0x02, 0x07, 0x8A, 0x86, 0xCC,
	0xF8, 0xF9, 0x36, 0x11, 0x67, 0x75, 0xEE, 0xD2,
	0xD4, 0x67, 0x09, 0xFD, 0x37, 0xB4, 0x3F, 0x7B,
	0x4A, 0x2B, 0x4E, 0x05, 0x37, 0x5E, 0xFD, 0x97,
	0x79, 0x95, 0x13, 0x95, 0x0D, 0x75, 0x15, 0x94,
	0x27, 0x36, 0xB3, 0x97, 0x03, 0xBE, 0x38, 0x14,
	0xCB, 0x4D, 0x16, 0x49, 0xFF, 0x36, 0xFA, 0xED,
	0x4D, 0x97, 0x45, 0xE4, 0xFB, 0xF9, 0x61, 0x7D,
	0x1F, 0xCE, 0xC3, 0xBF, 0xB3, 0xEA, 0x3C, 0xBC,
	0x13, 0x05, 0xBB, 0xAB, 0x44, 0x84, 0x80, 0x0F,
	0xB9, 0x1F, 0x6E, 0x88, 0x27, 0x4A, 0xFA, 0x17,
	0x83, 0x76, 0x5F, 0xC5, 0xE8, 0x85, 0xBC, 0xFF,
	0xD8, 0x48, 0x4A, 0x9F, 0xEB, 0xC3, 0xF8, 0x41,
	0x86, 0x4D, 0xC2, 0x75, 0x7B, 0x74, 0x71, 0x68,
	0x9C, 0xF8, 0x05, 0x8B, 0xB7, 0xFA, 0xE0, 0xA7,
	0xFA, 0xEC, 0x53, 0x91, 0xD0, 0xB4, 0x44, 0x7A,
	0x42, 0xAD, 0xD2, 0x17, 0x86, 0x8F, 0x96, 0xF0,
	0xF1, 0xD6, 0xC0, 0x26, 0x34, 0x83, 0x2E, 0x62,
	0x0D, 0x3F, 0x13, 0x5A, 0x8C, 0xBC, 0x6D, 0x8D,
	0x39, 0x05, 0x91, 0x10, 0x32, 0xBE, 0x17, 0x8A,
	0xC7, 0x23, 0xBE, 0x3F, 0xC5, 0x8A, 0xE0, 0x81,
	0xFC, 0x0D, 0x4C, 0x62, 0xE8, 0x67, 0xBA, 0x8B,
	0xBD, 0xA5, 0xCB, 0xE9, 0x34, 0x3D, 0x8D, 0x84,
	0x9D, 0x65, 0xBF, 0x9E, 0xC4, 0xB3, 0x16, 0x2E,
	0x12, 0xB9, 0x1F, 0x82, 0xA1, 0x46, 0x26, 0xD5,
	0xAB, 0x7D, 0x80, 0x4D, 0x9C, 0xD3, 0xEB, 0x77,
	0xFB, 0x67, 0xEA, 0xEE, 0xA8, 0x7B, 0x17, 0x02,
	0x2E, 0x6E, 0xF5, 0x11, 0x44, 0xFC, 0x31, 0x01,
	0xCC, 0x03, 0x94, 0x0A, 0xCF, 0x8D, 0x12, 0xCD,
	0x87, 0x66, 0x38, 0x62, 0x3C, 0xBB, 0x98, 0x2E,
	0xC5, 0x58, 0xD0, 0xF3, 0x06, 0xBD, 0x49, 0x7E,
	0x18, 0x7D, 0x64, 0xEF, 0x37, 0x71, 0x87, 0xD4,
	0xE6, 0x2C, 0xCC, 0x32, 0x59, 0x65, 0x05, 0x45,
	0xDE, 0xF3, 0x17, 0x62, 0x2C, 0x25, 0x62, 0x9C,
	0x67, 0xBD, 0x74, 0xF1, 0x54, 0x0E, 0x0B, 0x4A,
	0x01, 0x9F, 0x5E, 0x3B, 0x08, 0x57, 0xFA, 0x09,
	0x99, 0x11, 0x2C, 0x3E, 0x1D, 0x2D, 0xF7, 0x91,
	0x12, 0x14, 0xFF, 0x95, 0x6F, 0xCA, 0xBD, 0x25,
	0xEC, 0x3C, 0x98, 0xA7, 0xAB, 0x98, 0x0E, 0xFB,
	0x01, 0xE9, 0x5E, 0x58, 0x5A, 0x49, 0x3F, 0xB2,
	0xC4, 0xBC, 0xF3, 0xEC, 0xCA, 0x4C, 0x54, 0x27,
	0x66, 0x10, 0x60, 0x76, 0x5C, 0xFB, 0x9E, 0xAC,
	0xD2, 0x09, 0x75, 0xB3, 0x2B, 0x65, 0xE7, 0x93,
	0xAD, 0x2B, 0x08, 0x6F, 0x87, 0x73, 0x45, 0x2A,
	0x1B, 0xB1, 0x75, 0xE7, 0x02, 0x9B, 0xCB, 0x56,
	0x87, 0x6F, 0x66, 0x44, 0xED, 0xDC, 0x03, 0x92,
	0xD4, 0xF1, 0x07, 0x40, 0xD6, 0x86, 0xD5, 0x98,
	0x3D, 0x9B, 0x03, 0xD9, 0x0A, 0x58, 0x59, 0x54,
	0x06, 0x10, 0xFD, 0x15, 0xFB, 0xE0, 0x5B, 0x81,
	0x8D, 0x0C, 0xC0, 0xA6, 0x15, 0x94, 0x72, 0x5E,
	0xC8, 0x4A, 0x73, 0x59, 0x63, 0xF6, 0xCD, 0x8D,
	0xA4, 0xC2, 0xAF, 0x2E, 0xAE, 0xC1, 0x93, 0x89,
	0x08, 0x81, 0x10, 0xEC, 0x44, 0x81, 0x33, 0x96,
	0x88, 0xDC, 0x19, 0xDF, 0xD4, 0x2E, 0x5D, 0x52,
	0xD7, 0x6A, 0x02, 0x64, 0x11, 0x6B, 0x24, 0xCF,
	0x51, 0xD4, 0xC1, 0x85, 0x7D, 0xA3, 0x24, 0x6A,
	0x05, 0x13, 0x55, 0xC3, 0x64, 0x5A, 0xDF, 0x9A,
	0x23, 0x73, 0xEA, 0xD9, 0x48, 0x98, 0xBE, 0x1C,
	0xBD, 0x3A, 0x5D, 0x37, 0xDC, 0x18, 0xA8, 0x39,
	0x71, 0x67, 0xC4, 0x12, 0xF1, 0xE3, 0x53, 0x73,
	0xF1, 0xD8, 0xC4, 0x8B, 0xB3, 0x64, 0x03, 0xDD,
	0x6E, 0xFB, 0x4A, 0xEF, 0xA4, 0x37, 0xA8, 0xA5,
	0x2E, 0x86, 0x40, 0x73, 0x16, 0xBA, 0x3A, 0xF5,
	0x5E, 0x47, 0xD8, 0x13, 0x58, 0xB7, 0x73, 0xA2,
	0xDA, 0x00, 0x9F, 0x90, 0xE4, 0xF8, 0x0B, 0xB3,
	0x26, 0x0A, 0xD8, 0x46, 0x8A, 0x09, 0x55, 0xCB,
	0xCB, 0xA4, 0x89, 0x84, 0xF8, 0x35, 0xF0, 0xDF,
	0x45, 0x5B, 0x6A, 0xAF, 0xA8, 0x5F, 0xE4, 0xC2,
	0x03, 0x9B, 0x5B, 0x11, 0x21, 0xA7, 0xDE, 0xC5,
	0x71, 0x3D, 0x00, 0xF8, 0x6F, 0x13, 0x75, 0x4E,
	0x7B, 0x6B, 0x32, 0x95, 0xD3, 0x77, 0x82, 0xA2,
	0x70, 0x6A, 0x80, 0xC3, 0x0D, 0x53, 0xC4, 0x1C,
	0xF0, 0x1C, 0x5A, 0x54, 0xA4, 0xB2, 0x7A, 0x90,
	0x6E, 0x48, 0x39, 0x19, 0x4A, 0x70, 0x8E, 0xEB,
	0xF2, 0x94, 0x07, 0x45, 0xC0, 0x4B, 0xC1, 0x80,
	0xED, 0x87, 0x39, 0x6B, 0x5F, 0x7E, 0x63, 0x95,
	0x38, 0xFB, 0xF4, 0x6E, 0x3A, 0x6A, 0x78, 0x59,
	0x1E, 0x51, 0x45, 0x02, 0x14, 0xAC, 0xA1, 0xD1,
	0xC8, 0x44, 0x03, 0xB6, 0x3D, 0xA4, 0xB3, 0xC1,
	0xE0, 0x1C, 0x39, 0xA1, 0x87, 0x21, 0x7C, 0xBA,
	0x9A, 0x92, 0xA3, 0xAF, 0x37, 0xE8, 0x27, 0xA1,
	0xBE, 0x2D, 0x83, 0x0A, 0x46, 0xE7, 0x68, 0x44,
	0x9D, 0xB1, 0x57, 0x33, 0x9B, 0x57, 0xE3, 0x0C,
	0xE7, 0xDF, 0x7F, 0x15, 0xC0, 0xB5, 0x3A, 0x08,
	0x6C, 0xEF, 0xB3, 0xD3, 0xA2, 0x3C, 0x84, 0xC8,
	0x77, 0x46, 0xB8, 0xD0, 0x1E, 0x6D, 0x7A, 0x0B,
	0xD7, 0x25, 0x77, 0x74, 0xF6, 0xD8, 0xF4, 0x75,
	0x54, 0x6A, 0x91, 0x48, 0x98, 0xAC, 0x52, 0xA6,
	0x6C, 0xBC, 0x05, 0xA4, 0x92, 0x8F, 0x52, 0xAA,
	0x97, 0xCC, 0x23, 0xD8, 0x69, 0x01, 0xB0, 0xD2,
	0x1F, 0x22, 0xE8, 0xD1, 0xF7, 0x89, 0x8E, 0x40,
	0xF1, 0xD8, 0xCE, 0xB5, 0x26, 0x82, 0xBD, 0xD7,
	0x7C, 0x88, 0xB2, 0x6F, 0x16, 0x07, 0x67, 0x51,
	0x45, 0x6C, 0x90, 0x63, 0xBA, 0x58, 0xB6, 0x71,
	0xB8, 0x54, 0xA8, 0x4C, 0x54, 0xB3, 0xD7, 0x2B,
	0x9F, 0xEB, 0x1C, 0xC6, 0x9F, 0xFA, 0xD6, 0xD3,
	0xED, 0xA0, 0x99, 0x18, 0x99, 0x23, 0xB0, 0x1A,
	0xAA, 0x3A, 0x42, 0xCB, 0x4A, 0xFC, 0x54, 0x30,
	0x86, 0xD0, 0xFF, 0x44, 0x62, 0xAB, 0x94, 0xBD,
	0xA9, 0x95, 0x27, 0x22, 0xD6, 0x57, 0xE7, 0x26,
	0x94, 0x18, 0x0C, 0xDE, 0x10, 0x44, 0xE4, 0x1A,
	0x55, 0x15, 0x07, 0xDC, 0x33, 0xCF, 0x4D, 0x27,
	0x9D, 0xDD, 0x19, 0xF7, 0x81, 0xD5, 0x2A, 0xFA,
	0x52, 0xC5, 0xA3, 0xF9, 0x6A, 0x78, 0xE8, 0x95,
	0xE5, 0x00, 0x98, 0x46, 0xD0, 0xA5, 0x55, 0x23,
	0x0D, 0xED, 0xA3, 0x84, 0x87, 0xAF, 0xB5, 0xBC,
	0x10, 0x8B, 0x1F, 0x0A, 0x5E, 0x08, 0x5B, 0xC8,
	0x78, 0xBD, 0xBC, 0xB5, 0x29, 0x56, 0x3C, 0xFB,
	0x95, 0xC7, 0xFD, 0xDD, 0xB6, 0x2A, 0x66, 0x5A,
	0x2B, 0x86, 0xA2, 0x74, 0x33, 0x67, 0xA3, 0x48,
	0xE7, 0xFA, 0xCB, 0x08, 0x6B, 0x9D, 0x85, 0x8E,
	0x38, 0x14, 0xCB, 0xC2, 0xDA, 0xA7, 0x06, 0x3A,
	0x23, 0xE6, 0x80, 0x7D, 0x01, 0xA2, 0xA4, 0x1B,
	0x3C, 0xCF, 0x9C, 0xE8, 0x62, 0x4D, 0xF5, 0x81,
	0x8C, 0xB9, 0x11, 0x8A, 0x12, 0x07, 0x93, 0xDD,
	0xB9, 0x40, 0x32, 0xB4, 0x60, 0x6A, 0xC8, 0x76,
	0x95, 0x54, 0x0A, 0x48, 0xE2, 0xFF, 0x8A, 0x3C,
	0xA2, 0x17, 0x4A, 0xCF, 0xDF, 0x6A, 0xAF, 0xBE,
	0x7A, 0x62, 0x7A, 0x3A, 0x60, 0x0B, 0x64, 0x2D,
	0xF0, 0xF9, 0x9C, 0x0B, 0xB2, 0x1C, 0xFD, 0xB6,
	0x3F, 0x86, 0x9F, 0x4A, 0xA7, 0xA3, 0x8C, 0xC1,
	0xAD, 0xF3, 0xFA, 0x86, 0xEF, 0x3F, 0xD7, 0x86,
	0x05, 0xF0, 0x8D, 0xA6, 0xD1, 0xFE, 0xE0, 0xB4,
	0x12, 0xC6, 0x35, 0x88, 0xFE, 0x77, 0xDE, 0x4E,
	0x36, 0x4C, 0x8A, 0x81, 0x62, 0xC0, 0x30, 0x95,
	0xC9, 0x2E, 0xB5, 0xCD, 0x09, 0x8D, 0x14, 0xDF,
	0xED, 0x2E, 0x2D, 0xCE, 0x8A, 0x94, 0x7A, 0xC7,
	0x12, 0x51, 0x8B, 0xEF, 0x45, 0xE9, 0x7A, 0x5E,
	0x1E, 0x51, 0x73, 0x34, 0x51, 0x2B, 0xCB, 0x45,
	0x22, 0xE6, 0x6F, 0x62, 0x20, 0xBA, 0xD2, 0x4E,
	0xDC, 0x1F, 0xEE, 0x25, 0xFD, 0xA5, 0xD8, 0xD6,
	0x4A, 0x24, 0xEA, 0x5E, 0x36, 0xF5, 0x76, 0x76,
	0x27, 0x53, 0x99, 0xA1, 0xAF, 0x9E, 0x3C, 0x2A,
	0x4C, 0xB2, 0x26, 0x8C, 0xC4, 0x1D, 0x38, 0x0C,
	0x3F, 0xC6, 0x34, 0xA8, 0x5B, 0x96, 0x46, 0x4B,
	0xE4, 0x17, 0xB8, 0x91, 0xD8, 0x28, 0x43, 0x99,
	0xD8, 0xB5, 0x1D, 0x87, 0x66, 0x29, 0xC6, 0x8E,
	0x43, 0x07, 0xAE, 0xBC, 0x05, 0xBF, 0xE2, 0xED,
	0xDD, 0xCD, 0xDA, 0x65, 0xC9, 0x87, 0x95, 0xB6,
	0x4D, 0x64, 0x64, 0x23, 0x5D, 0x19, 0x9D, 0x47,
	0xC0, 0xED, 0x36, 0x03, 0x8C, 0x1E, 0xBA, 0xDE,
	0xB7, 0x5D, 0xB8, 0x2B, 0x10, 0x35, 0x6F, 0xCD,
	0x8E, 0xF8, 0xFA, 0xC0, 0x95, 0x34, 0x5C, 0x6A,
	0x49, 0xDB, 0x30, 0x4C, 0xEB, 0x61, 0x27, 0xF5,
	0x83, 0x5B, 0xBF, 0x05, 0x1F, 0x56, 0xF0, 0x4B,
	0x1C, 0x25, 0x29, 0xA2, 0xC5, 0xF2, 0x46, 0xF6,
	0xE9, 0x04, 0xDB, 0x7D, 0x01, 0xDE, 0xE0, 0x76,
	0xEC, 0xB0, 0x24, 0x61, 0x41, 0xA4, 0x53, 0x84,
	0x90, 0x1B, 0x96, 0x72, 0x00, 0x14, 0x26, 0xED,
	0x20, 0x31, 0x5A, 0x24, 0xC9, 0xB2, 0x2A, 0x75,
	0xD3, 0x94, 0xC1, 0xFE, 0xCE, 0xC1, 0x57, 0xDE,
	0x5E, 0xCD, 0xBE, 0xCB, 0x85, 0x4A, 0x6B, 0x85,
	0x28, 0xC3, 0x7B, 0x12, 0x7F, 0x61, 0xDD, 0x22,
	0x07, 0x37, 0xFF, 0x70, 0x7A, 0xA1, 0x56, 0xD4,
	0x5A, 0x3A, 0x59, 0xAB, 0xC3, 0x65, 0x09, 0x0E,
	0x3C, 0x9C, 0x52, 0x34, 0xB2, 0x5D, 0x89, 0x62,
	0x89, 0x3E, 0x22, 0x07, 0x56, 0xA2, 0x4D, 0x95,
	0xE8, 0x78, 0x15, 0x44, 0x6F, 0xA3, 0xB2, 0x2C,
	0x24, 0xF8, 0xA0, 0x54, 0x9E, 0x73, 0x25, 0x0C,
	0xB3, 0x2C, 0xFF, 0x2D, 0x9C, 0x2E, 0xE1, 0xD8,
	0x70, 0xF1, 0xCA, 0xA4, 0xB6, 0x6E, 0xDF, 0xE5,
	0xB4, 0x0F, 0xF7, 0x00, 0x8E, 0x4F, 0x6F, 0xBA,
	0x0D, 0x1F, 0x82, 0xF0, 0x7D, 0xC4, 0xED, 0x1E,
	0xB6, 0x61, 0xE2, 0x3C, 0xBF, 0x5F, 0x88, 0xE1,
	0x37, 0x5E, 0xE7, 0x7D, 0xE2, 0x13, 0xDF, 0x9A,
	0x59, 0x6D, 0x85, 0x87, 0x7D, 0xCD, 0x8A, 0x01,
	0xA1, 0xA7, 0x10, 0x63, 0xB5, 0xA4, 0xC4, 0xE0,
	0x1A, 0x45, 0x4E, 0x91, 0x07, 0x54, 0x62, 0xD6,
	0xC2, 0x3F, 0x96, 0x40, 0xF6, 0x8B, 0x12, 0x59,
	0xEF, 0x20, 0x9C, 0x35, 0x4E, 0x37, 0x1F, 0xAA,
	0x9C, 0x01, 0xA5, 0x59, 0x85, 0x37, 0x9E, 0x4F,
	0xDF, 0xFF, 0x40, 0x6E, 0xC2, 0xE6, 0xC6, 0x09,
	0x70, 0x1C, 0xC2, 0xCD, 0x11, 0x6B, 0x84, 0xC8,
	0xEE, 0x2B, 0xAE, 0xD5, 0x36, 0xFC, 0x83, 0x30,
	0xDD, 0x5E, 0x13, 0x6C, 0x49, 0xDB, 0x44, 0xDD,
	0x39, 0x58, 0xE7, 0x83, 0xD6, 0x1A, 0x5F, 0xE2,
	0xF7, 0x82, 0xDC, 0x1E, 0x80, 0x44, 0xDB, 0x48,
	0x62, 0x32, 0x75, 0x3E, 0x6A, 0x98, 0x1A, 0xB2,
	0x36, 0xBF, 0xDE, 0x35, 0x6B, 0x20, 0x9F, 0x83,
	0xB5, 0xA2, 0x1C, 0x0B, 0x99, 0x9B, 0x49, 0x43,
	0xEB, 0x5B, 0x67, 0x03, 0x8A, 0x24, 0x45, 0x8C,
	0x15, 0xEE, 0xD2, 0xB2, 0x35, 0xEB, 0xAF, 0x69,
	0x0E, 0x69, 0x3B, 0x4D, 0x80, 0x9B, 0x75, 0x43,
	0xB4, 0x40, 0x30, 0xCF, 0xD9, 0x76, 0xD4, 0x58,
	0xAC, 0x2B, 0x10, 0xE3, 0xF3, 0x48, 0x38, 0xAA,
	0x69, 0x18, 0x51, 0x5C, 0xD7, 0xB0, 0x9E, 0x5B,
	0x1E, 0x18, 0xD7, 0x59, 0x67, 0x80, 0x4F, 0xCB,
	0x40, 0x49, 0xB0, 0x27, 0xCD, 0x15, 0xF7, 0x56,
	0x34, 0x0F, 0x5D, 0xD9, 0xC4, 0xCB, 0xF7, 0x83,
	0x0D, 0x8B, 0xCF, 0x21, 0x13, 0x1A, 0x49, 0xE6,
	0x21, 0x49, 0x0F, 0x67, 0xFF, 0xE6, 0xE7, 0xF4,
	0xD7, 0x2C, 0xDA, 0xFD, 0xBD, 0x86, 0xC2, 0x40,
	0x6E, 0xB5, 0x05, 0xFC, 0x3E, 0x88, 0xB4, 0xB1,
	0xC1, 0x5C, 0x6D, 0x0F, 0x0F, 0x17, 0xE6, 0xE0,
	0x96, 0x4B, 0x45, 0xBD, 0x07, 0x20, 0x00, 0x3F,
	0xF0, 0xF2, 0xB9, 0xA1, 0x35, 0x01, 0x47, 0x81,
	0x1F, 0xA2, 0x0A, 0x66, 0xDB, 0xD7, 0x58, 0x51,
	0x88, 0x78, 0x24, 0x6F, 0x7E, 0x68, 0x46, 0xBD,
	0xEB, 0x5C, 0xA9, 0xDE, 0x30, 0x34, 0x2B, 0xA3,
	0xCF, 0x93, 0x82, 0x14, 0x3D, 0x96, 0x1E, 0xD7,
	0x6E, 0x9A, 0x2E, 0x72, 0xD0, 0x49, 0xDB, 0x24,
	0xA0, 0x6E, 0x8E, 0xBA, 0x4A, 0x36, 0xCB, 0xF6,
	0x9A, 0x46, 0x24, 0xEF, 0x18, 0xA8, 0xD9, 0xD5,
	0x93, 0xF0, 0x2B, 0xEC, 0x60, 0x0A, 0x8F, 0x1C,
	0xE8, 0x69, 0x56, 0x14, 0x6C, 0x8E, 0x30, 0xFB,
	0x8D, 0xCF, 0xE7, 0x92, 0x59, 0x2E, 0x32, 0xEB,
	0xAE, 0xA3, 0x99, 0x87, 0x98, 0x49, 0x03, 0xCD,
	0x5E, 0xBD, 0xDE, 0xB9, 0xF5, 0xD0, 0xB3, 0xB1,
	0x65, 0xAC, 0xC7, 0x42, 0xB4, 0xCF, 0x6A, 0x00,
	0x3E, 0x2E, 0xC1, 0x13, 0xDF, 0x5E, 0x2E, 0xEC,
	0x30, 0x00, 0xE2, 0xAB, 0xFD, 0x74, 0x06, 0x55,
	0x88, 0x07, 0xB0, 0xEF, 0x6D, 0x43, 0x81, 0x15,
	0xFC, 0xF6, 0x96, 0x91, 0x3D, 0x2F, 0xFE, 0xBD,
	0xB9, 0xC8, 0xB6, 0x81, 0x63, 0xE0, 0xA9, 0x20,
	0x93, 0xEC, 0x4B, 0x1E, 0xB9, 0xC2, 0xD0, 0x8C,
	0x2E, 0xCB, 0x18, 0x7D, 0x1F, 0x66, 0xA6, 0x96,
	0xA9, 0xB8, 0x66, 0x4F, 0xCF, 0xC9, 0xDA, 0x97,
	0xCA, 0x07, 0xF1, 0xC8, 0xFB, 0x56, 0x60, 0xA9,
	0x25, 0xDB, 0xFC, 0x2D, 0xB6, 0x0A, 0x42, 0x6A,
	0x7F, 0xCE, 0x70, 0x91, 0xFF, 0x3B, 0xAC, 0xAB,
	0xF2, 0x23, 0x4E, 0x50, 0xE9, 0xE6, 0x2F, 0xCB,
	0x98, 0xBA, 0x7D, 0xD2, 0x8A, 0xDE, 0x6E, 0x80,
	0x0C, 0xC6, 0xEB, 0xD9, 0x64, 0xD4, 0x59, 0xD5,
	0x75, 0x00, 0x18, 0x7F, 0xD6, 0x86, 0xC2, 0x25,
	0x98, 0xA9, 0x28, 0x1C, 0x40, 0x46, 0xC6, 0xA5,
	0xAF, 0x6E, 0x5D, 0x25, 0x3C, 0x77, 0xF9, 0x43,
	0xF3, 0x20, 0xFC, 0x43, 0xA0, 0x5E, 0xF1, 0x65,
	0x5D, 0x8B, 0x33, 0x5A, 0x94, 0xF0, 0x6F, 0xB6,
	0xD4, 0x4A, 0x48, 0x64, 0x31, 0x73, 0x17, 0x4E,
	0x88, 0x90, 0xA8, 0xE4, 0x7F, 0xCE, 0xD5, 0x7D,
	0xE3, 0x84, 0x3F, 0x38, 0x71, 0x4C, 0xB1, 0x18,
	0xAA, 0x46, 0xF2, 0xCF, 0x99, 0xF0, 0x24, 0xD7,
	0xFD, 0xFC, 0x2C, 0x81, 0x25, 0xC1, 0x8E, 0x0B,
	0x82, 0x4C, 0x14, 0x6C, 0x44, 0xB1, 0x78, 0x67,
	0x14, 0x47, 0xCA, 0x70, 0x0D, 0x13, 0xD1, 0xA8,
	0x73, 0xBC, 0x4E, 0xAA, 0x1E, 0xB7, 0x59, 0xC0,
	0xAC, 0xE3, 0x21, 0x2B, 0x55, 0x22, 0x6A, 0x53,
	0xA6, 0xF0, 0xE9, 0x56, 0x37, 0x3B, 0xD6, 0x1B,
	0x2E, 0x57, 0x98, 0x4D, 0x6A, 0x7E, 0xEB, 0x2E,
	0x9B, 0xB8, 0xE2, 0x27, 0x55, 0xE2, 0x2E, 0xFA,
	0x3C, 0xD2, 0x7A, 0xCC, 0xDB, 0x5C, 0x45, 0x85,
	0xA6, 0x92, 0x49, 0x79, 0x9D, 0x18, 0x20, 0x50,
	0x7B, 0xF4, 0x0F, 0x43, 0x2F, 0x7B, 0x3E, 0x90,
	0xEF, 0xF3, 0x29, 0x66, 0xDF, 0xD1, 0xE9, 0x44,
	0xC6, 0x28, 0xAA, 0x48, 0x00, 0x5F, 0x12, 0xEB,
	0xEC, 0x26, 0x7F, 0xB3, 0x83, 0xFB, 0x50, 0x5A,
	0x5F, 0x5A, 0x8E, 0x08, 0x4B, 0xF7, 0x50, 0x10,
	0xC8, 0x73, 0x8F, 0x9C, 0xF6, 0xCB, 0xDC, 0xEA,
	0x78, 0x07, 0x2C, 0x59, 0xAD, 0x66, 0x48, 0xFF,
	0x56, 0x7D, 0x99, 0xC9, 0xEA, 0x64, 0xE7, 0xD0,
	0x46, 0x88, 0x58, 0x46, 0x93, 0x37, 0x70, 0xC1,
	0x91, 0x40, 0x02, 0x46, 0x7F, 0x8D, 0xFE, 0x66,
	0x07, 0x1F, 0x3B, 0x56, 0x6A, 0x6E, 0x88, 0xB2,
	0xBB, 0xC0, 0xC8, 0xCD, 0xD9, 0xDC, 0x0A, 0x0C,
	0x1A, 0x27, 0x35, 0x48, 0x4C, 0x5B, 0x5D, 0x90,
	0xA0, 0xB2, 0xB4, 0xCE, 0xD6, 0xDD, 0x07, 0x13,
	0x7C, 0x93, 0x99, 0xA2, 0xA9, 0xAC, 0xC3, 0xC8,
	0xEF, 0x1D, 0x33, 0x3D, 0x3F, 0x42, 0x52, 0x57,
	0x6D, 0x72, 0x87, 0x8E, 0x96, 0xA8, 0xC6, 0xC8,
	0xD0, 0xD6, 0xE8, 0xEB, 0xF2, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0E, 0x1E, 0x29, 0x3D,
};

/* Message */
uint8_t mldsa_44_message[] = {
	0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x6D, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x20, 0x74, 0x6F, 0x20, 0x62,
	0x65, 0x20, 0x73, 0x69, 0x67, 0x6E, 0x65, 0x64,
	0x2E, 0x0A,
};

uint8_t mldsa_44_privkey_noseed[] = {
	0xBA, 0x71, 0xF9, 0xF6, 0x4E, 0x11, 0xBA, 0xEB,
	0x58, 0xFA, 0x9C, 0x6F, 0xBB, 0x6E, 0x14, 0xE6,
	0x1F, 0x18, 0x64, 0x3D, 0xAB, 0x49, 0x5B, 0x47,
	0x53, 0x9A, 0x91, 0x66, 0xCA, 0x01, 0x98, 0x13,
	0xC5, 0xC1, 0x61, 0x0A, 0x40, 0x77, 0x4F, 0x0E,
	0xBA, 0x33, 0x34, 0xF8, 0xB5, 0xBE, 0x56, 0xE8,
	0x78, 0x71, 0xB3, 0xC3, 0xA7, 0x72, 0xC0, 0x72,
	0x0F, 0xA3, 0x76, 0x66, 0xAE, 0x17, 0x35, 0xFD,
	0xE6, 0xBC, 0x38, 0xA1, 0xC3, 0x5F, 0x8C, 0xF0,
	0x8E, 0x44, 0x09, 0x24, 0xC9, 0x03, 0x71, 0x97,
	0xBB, 0x87, 0xFD, 0xC4, 0x64, 0x6B, 0x86, 0xDA,
	0x5A, 0x05, 0x89, 0xA3, 0x26, 0xCC, 0x0C, 0x0D,
	0x95, 0x0F, 0xF8, 0xB5, 0xA9, 0xEA, 0x41, 0x35,
	0xEA, 0xB8, 0xA9, 0x3F, 0x80, 0xF0, 0x92, 0x7E,
	0x12, 0x40, 0x46, 0xE2, 0x5B, 0x23, 0x66, 0xAE,
	0xA2, 0x5A, 0x6D, 0x1D, 0x0F, 0xEF, 0x98, 0x21,
	0x04, 0xB8, 0x09, 0xDA, 0x12, 0x48, 0xE1, 0x40,
	0x4C, 0x11, 0x03, 0x85, 0x99, 0xB0, 0x4D, 0x61,
	0x04, 0x0A, 0xC0, 0x34, 0x28, 0x23, 0x16, 0x80,
	0x08, 0x12, 0x45, 0x11, 0x49, 0x0C, 0xA0, 0x96,
	0x0D, 0xC2, 0xA8, 0x01, 0x5A, 0xA8, 0x65, 0x0B,
	0x30, 0x25, 0xD4, 0x94, 0x44, 0x8B, 0x38, 0x8C,
	0x10, 0x24, 0x41, 0x22, 0x40, 0x69, 0x8A, 0x04,
	0x04, 0x0C, 0x26, 0x90, 0xE3, 0x34, 0x69, 0xE2,
	0x24, 0x68, 0xD2, 0x44, 0x00, 0x0B, 0x84, 0x90,
	0xD9, 0x42, 0x30, 0x21, 0x91, 0x8D, 0x09, 0x99,
	0x64, 0x20, 0x39, 0x60, 0x82, 0x36, 0x21, 0x90,
	0xB8, 0x4C, 0x02, 0x12, 0x6E, 0x24, 0xB9, 0x70,
	0x84, 0x22, 0x01, 0xE1, 0xA8, 0x64, 0x44, 0x26,
	0x0E, 0x01, 0x17, 0x0E, 0x82, 0x40, 0x6C, 0x9B,
	0x38, 0x6D, 0x0A, 0x93, 0x50, 0x52, 0x22, 0x25,
	0xD2, 0xB8, 0x2C, 0x1A, 0x25, 0x70, 0x90, 0x12,
	0x22, 0xD1, 0xB2, 0x80, 0x22, 0x46, 0x52, 0x01,
	0x34, 0x80, 0x40, 0x34, 0x21, 0x41, 0x06, 0x60,
	0x41, 0x32, 0x82, 0x09, 0x45, 0x90, 0x52, 0x32,
	0x29, 0x83, 0xB8, 0x44, 0x93, 0x12, 0x21, 0x0A,
	0xC1, 0x89, 0x60, 0xB2, 0x71, 0x9C, 0x90, 0x69,
	0x90, 0x82, 0x90, 0x89, 0x12, 0x49, 0x40, 0x40,
	0x8A, 0x5C, 0x10, 0x48, 0x01, 0x87, 0x91, 0x03,
	0xB0, 0x40, 0xD8, 0x44, 0x05, 0xE4, 0xB0, 0x29,
	0x0A, 0x27, 0x90, 0x1C, 0xC9, 0x50, 0x58, 0x02,
	0x8C, 0x0C, 0x49, 0x72, 0x49, 0x84, 0x6D, 0x19,
	0xA7, 0x85, 0xE3, 0x00, 0x30, 0xCB, 0xB2, 0x21,
	0xE2, 0x08, 0x10, 0x4C, 0xA6, 0x64, 0x11, 0x43,
	0x68, 0x52, 0x94, 0x69, 0x09, 0x39, 0x32, 0x91,
	0xA2, 0x6D, 0xCA, 0x14, 0x84, 0xA3, 0x92, 0x11,
	0xDB, 0x94, 0x2C, 0x01, 0xC6, 0x64, 0x14, 0x24,
	0x8C, 0x1A, 0x15, 0x31, 0x0A, 0x23, 0x0E, 0xD8,
	0x14, 0x20, 0xA4, 0x26, 0x8D, 0x43, 0x40, 0x90,
	0xC1, 0x42, 0x86, 0xA4, 0x10, 0x85, 0x0C, 0x32,
	0x2D, 0xD0, 0x28, 0x60, 0x1B, 0xB5, 0x0C, 0x52,
	0x44, 0x61, 0x21, 0x15, 0x24, 0x21, 0xC6, 0x04,
	0xD8, 0x34, 0x31, 0xD9, 0x12, 0x71, 0xA2, 0x34,
	0x52, 0x03, 0x30, 0x89, 0x54, 0x32, 0x10, 0x83,
	0x94, 0x08, 0xA2, 0xA4, 0x70, 0xD2, 0x44, 0x8E,
	0x84, 0x02, 0x8D, 0x91, 0x46, 0x62, 0x0B, 0x00,
	0x0E, 0xA0, 0x80, 0x70, 0x22, 0xB5, 0x0D, 0x0B,
	0xC9, 0x01, 0x00, 0x26, 0x4D, 0xE2, 0x44, 0x80,
	0x93, 0x20, 0x65, 0xC9, 0x96, 0x8D, 0xDA, 0xA4,
	0x4C, 0x42, 0xA8, 0x00, 0x1A, 0x27, 0x6C, 0xC3,
	0x94, 0x4D, 0xA0, 0x30, 0x2C, 0xDA, 0xA8, 0x04,
	0x23, 0xA3, 0x8C, 0x63, 0x04, 0x0E, 0x59, 0xC8,
	0x00, 0x20, 0xA9, 0x6C, 0xC4, 0x06, 0x50, 0x82,
	0x00, 0x2E, 0x5C, 0xB2, 0x44, 0x61, 0x46, 0x51,
	0x0C, 0x18, 0x80, 0x18, 0x38, 0x82, 0x02, 0x25,
	0x90, 0xA2, 0xB2, 0x60, 0x21, 0xA0, 0x40, 0x20,
	0x49, 0x2A, 0x52, 0x28, 0x86, 0x93, 0xA6, 0x28,
	0x9B, 0x94, 0x71, 0x02, 0xB9, 0x6D, 0x49, 0xA0,
	0x2C, 0x09, 0x25, 0x28, 0x18, 0x93, 0x09, 0x10,
	0x49, 0x4C, 0x13, 0xC9, 0x91, 0xA3, 0x88, 0x2D,
	0x50, 0x12, 0x31, 0x63, 0xB4, 0x00, 0xA4, 0x00,
	0x4E, 0x04, 0xB6, 0x68, 0x12, 0x14, 0x26, 0x00,
	0x17, 0x00, 0x9B, 0x92, 0x0C, 0x51, 0xA8, 0x65,
	0x11, 0x44, 0x8D, 0x44, 0x42, 0x69, 0x00, 0xA5,
	0x6D, 0x04, 0xA9, 0x69, 0x43, 0x94, 0x69, 0x4C,
	0xB8, 0x60, 0x52, 0x26, 0x2D, 0xA1, 0x32, 0x11,
	0xCA, 0xB0, 0x11, 0x1B, 0x81, 0x90, 0x12, 0x11,
	0x64, 0x42, 0x86, 0x89, 0x9C, 0x12, 0x51, 0xDC,
	0xC0, 0x41, 0x13, 0x47, 0x68, 0x9B, 0x20, 0x92,
	0xD1, 0x26, 0x91, 0x23, 0x96, 0x50, 0x13, 0xB3,
	0x4C, 0x12, 0x45, 0x69, 0x21, 0xA1, 0x05, 0x0C,
	0x46, 0x65, 0x99, 0x38, 0x30, 0x99, 0x26, 0x2E,
	0x19, 0x15, 0x72, 0x11, 0x39, 0x8D, 0x89, 0x10,
	0x92, 0x50, 0x28, 0x11, 0x48, 0xA6, 0x49, 0x52,
	0xB6, 0x2D, 0xC9, 0x30, 0x4D, 0xD9, 0x32, 0x91,
	0x91, 0xA6, 0x44, 0x14, 0x34, 0x0E, 0x13, 0x39,
	0x41, 0x98, 0x06, 0x0C, 0x22, 0x25, 0x6C, 0x14,
	0x47, 0x70, 0x21, 0xB7, 0x60, 0x23, 0x98, 0x25,
	0xE4, 0x24, 0x6E, 0xD1, 0xB6, 0x44, 0x51, 0x44,
	0x2C, 0x41, 0x42, 0x85, 0xE0, 0x44, 0x42, 0x89,
	0x42, 0x42, 0xC2, 0x24, 0x2C, 0xCC, 0xC6, 0x68,
	0x13, 0x12, 0x69, 0x98, 0x30, 0x49, 0x23, 0x28,
	0x6A, 0x14, 0xC8, 0x11, 0x60, 0x92, 0x30, 0x11,
	0x26, 0x52, 0x92, 0xB0, 0x00, 0x5C, 0x84, 0x2C,
	0x4A, 0x14, 0x29, 0x0A, 0x95, 0x40, 0xE3, 0xC4,
	0x05, 0x0C, 0xC8, 0x89, 0xA1, 0x26, 0x62, 0x44,
	0x10, 0x04, 0x9A, 0xC8, 0x70, 0x0C, 0x93, 0x60,
	0x90, 0xB6, 0x30, 0x12, 0x17, 0x71, 0x23, 0x18,
	0x4E, 0xD4, 0x10, 0x85, 0x84, 0x20, 0x82, 0x5C,
	0x14, 0x48, 0x90, 0xB2, 0x51, 0xA0, 0x18, 0x92,
	0x93, 0x94, 0x80, 0x1A, 0x49, 0x72, 0xC0, 0x02,
	0x06, 0xE1, 0xA6, 0x8C, 0xA1, 0x80, 0x4D, 0x4A,
	0x26, 0x08, 0x18, 0x07, 0x62, 0x42, 0x12, 0x40,
	0x10, 0x41, 0x64, 0x44, 0x42, 0x4E, 0x94, 0x86,
	0x40, 0x9A, 0x84, 0x41, 0x21, 0xC5, 0x71, 0x01,
	0x96, 0x29, 0x19, 0x40, 0x4E, 0x94, 0x36, 0x22,
	0x24, 0xC3, 0x20, 0x22, 0x88, 0x71, 0x84, 0x20,
	0x4C, 0x64, 0x20, 0x69, 0xDB, 0x84, 0x24, 0x24,
	0x25, 0x46, 0x21, 0xC4, 0x71, 0x8A, 0x14, 0x64,
	0x01, 0x20, 0x65, 0x4C, 0x84, 0x24, 0x44, 0x24,
	0x30, 0x8A, 0x22, 0x70, 0xD3, 0x86, 0x30, 0x0B,
	0xB4, 0x6C, 0x21, 0x23, 0x0A, 0x8B, 0xB8, 0x4D,
	0x5C, 0xF7, 0xD7, 0xE6, 0x89, 0x30, 0x2B, 0xED,
	0xB1, 0xC5, 0x86, 0x7E, 0x7D, 0x26, 0x9B, 0x1C,
	0xDB, 0x07, 0xF8, 0x25, 0x64, 0x10, 0x82, 0xE1,
	0x9A, 0x8D, 0xA2, 0xF9, 0x30, 0x77, 0xE8, 0xB1,
	0xFC, 0x3D, 0x4E, 0x6B, 0x2D, 0x32, 0x58, 0x33,
	0x6B, 0x4F, 0x9C, 0x64, 0x55, 0x15, 0x3A, 0xC0,
	0x40, 0xA8, 0x47, 0xFB, 0x64, 0x7F, 0xBB, 0x6B,
	0x55, 0x2A, 0x40, 0x00, 0x71, 0xFE, 0x17, 0x72,
	0x48, 0x5B, 0x7A, 0x9D, 0x1F, 0x0D, 0x14, 0x7B,
	0xF3, 0x38, 0x8C, 0x56, 0x54, 0x71, 0xE4, 0xE6,
	0x2C, 0xC3, 0xCE, 0x0D, 0x0C, 0x0F, 0xC3, 0x60,
	0xDF, 0x92, 0x89, 0xED, 0x99, 0x18, 0x37, 0x6B,
	0x8B, 0x8B, 0x93, 0x14, 0x50, 0x47, 0xF8, 0xFE,
	0xA2, 0x98, 0x60, 0x07, 0xC2, 0xAA, 0x89, 0x92,
	0x2F, 0x69, 0xEB, 0x47, 0x5B, 0x59, 0x7B, 0x2B,
	0xBA, 0x23, 0x7B, 0x9C, 0x84, 0x2E, 0x3F, 0xF1,
	0xD3, 0x25, 0xE8, 0x2A, 0x1F, 0x23, 0xE9, 0x49,
	0x89, 0xD0, 0x06, 0xBC, 0x7C, 0xE4, 0x94, 0x6F,
	0x2E, 0x8B, 0x77, 0xE1, 0x08, 0x48, 0x46, 0x3C,
	0x47, 0xFE, 0x7B, 0x20, 0x9E, 0x2A, 0x61, 0x7D,
	0xDD, 0x41, 0x79, 0x6A, 0xE6, 0x14, 0x5E, 0x70,
	0x9C, 0xDA, 0x94, 0x06, 0xF2, 0x26, 0x12, 0x57,
	0xC2, 0x13, 0xB4, 0xB3, 0x0D, 0xA3, 0x0A, 0xC2,
	0x5B, 0x0D, 0x06, 0xCF, 0x79, 0xA8, 0x12, 0xC5,
	0xFC, 0xB0, 0xEF, 0x11, 0xD9, 0xFE, 0xDF, 0xE0,
	0x99, 0x4A, 0xFE, 0x3B, 0x69, 0xB0, 0x6A, 0x29,
	0x16, 0xCF, 0x69, 0x2B, 0x9D, 0xA7, 0x60, 0x28,
	0xE5, 0xF3, 0xA0, 0x48, 0x79, 0xE6, 0x96, 0xD2,
	0x1F, 0x73, 0x5C, 0x37, 0x83, 0x15, 0x36, 0x4D,
	0xB0, 0xA4, 0xE0, 0xAB, 0x6B, 0x53, 0xD3, 0x1E,
	0xFA, 0xF3, 0x0D, 0x65, 0xE3, 0x7A, 0x1B, 0x6A,
	0x77, 0x04, 0x6F, 0x04, 0xC6, 0x4B, 0xA1, 0x07,
	0x2A, 0x97, 0x80, 0xE0, 0xC5, 0x66, 0xC9, 0x43,
	0x39, 0xA4, 0xD1, 0x9D, 0x00, 0x68, 0xC5, 0x7D,
	0x6E, 0x6F, 0x0B, 0x51, 0x2D, 0xB7, 0x13, 0x4A,
	0x95, 0x0E, 0xAF, 0x4F, 0x7B, 0x01, 0xA5, 0xFD,
	0xD0, 0x65, 0xB9, 0x1B, 0xFA, 0x29, 0xE4, 0x42,
	0x36, 0x79, 0xCD, 0xE7, 0x4B, 0xC6, 0xA8, 0xF1,
	0xC8, 0x4C, 0x4D, 0xF7, 0x83, 0x87, 0x23, 0x1D,
	0xC8, 0x5C, 0xE3, 0x26, 0x70, 0x44, 0x59, 0x03,
	0xC4, 0xBE, 0xBE, 0xE3, 0xF5, 0x0C, 0x43, 0xE5,
	0x04, 0x49, 0x49, 0x69, 0x11, 0xAA, 0x93, 0xE7,
	0xE3, 0x95, 0x78, 0x74, 0x14, 0xD3, 0x17, 0x68,
	0xD9, 0x91, 0x25, 0x20, 0xF8, 0x3C, 0x02, 0xFF,
	0x01, 0x12, 0x4D, 0xCF, 0x0E, 0x12, 0x5F, 0xAF,
	0xD5, 0xB9, 0xD7, 0xE7, 0xDD, 0xA4, 0xF5, 0xB5,
	0x0C, 0x70, 0xAE, 0xBB, 0x85, 0x99, 0xA2, 0xE4,
	0x47, 0x6A, 0x0D, 0xE5, 0x31, 0xB0, 0x40, 0x26,
	0x72, 0xDF, 0x75, 0x75, 0x14, 0x2D, 0x86, 0x01,
	0x60, 0x5C, 0x94, 0x01, 0x79, 0x23, 0xF6, 0x4A,
	0xC5, 0x77, 0xC4, 0xBE, 0xD8, 0xD8, 0xE8, 0x9A,
	0x74, 0xCA, 0x9F, 0x38, 0x19, 0xCB, 0xF1, 0x42,
	0xA7, 0x2D, 0xEB, 0xE7, 0x7C, 0x4E, 0xFB, 0x71,
	0x27, 0xE2, 0xD8, 0xC1, 0xB7, 0xBF, 0xB6, 0x42,
	0x86, 0xC0, 0xBD, 0x52, 0x23, 0x3F, 0x43, 0xC6,
	0x7D, 0x57, 0x17, 0xF9, 0x7A, 0xD8, 0x28, 0x54,
	0x87, 0x3D, 0xDC, 0x7F, 0x71, 0xD6, 0x56, 0xAA,
	0xA6, 0xEF, 0x70, 0x70, 0x60, 0xAF, 0x28, 0x0B,
	0x9F, 0x45, 0x4B, 0x4F, 0xED, 0xB4, 0x77, 0x6E,
	0x83, 0xB2, 0xFD, 0xBA, 0x20, 0xA4, 0x5A, 0xEF,
	0xEB, 0x54, 0x9A, 0x1E, 0xD0, 0x38, 0x20, 0x21,
	0x89, 0x3C, 0xA9, 0xA6, 0xE7, 0x4C, 0xCC, 0x30,
	0xA2, 0x55, 0x39, 0x37, 0xCC, 0xEF, 0x34, 0x38,
	0x99, 0xB5, 0x02, 0xCF, 0x46, 0xDD, 0xB8, 0xDD,
	0x1D, 0x95, 0xFE, 0xFB, 0x60, 0xC9, 0xB2, 0x04,
	0x69, 0xA1, 0x50, 0x3B, 0x2A, 0x68, 0x75, 0x87,
	0x83, 0x0D, 0x33, 0xCE, 0xE9, 0xA7, 0x2D, 0x79,
	0x8F, 0xCF, 0x4A, 0x9B, 0x45, 0x2C, 0x85, 0x49,
	0xF5, 0x59, 0xC5, 0xD9, 0xFC, 0x6B, 0xFE, 0x08,
	0x3F, 0x44, 0x6C, 0x2D, 0x90, 0x39, 0x81, 0xD9,
	0xF2, 0x64, 0x92, 0x48, 0x3A, 0xB4, 0x52, 0xEA,
	0x5B, 0xB1, 0x00, 0x8F, 0xFE, 0xAC, 0x97, 0x5D,
	0xA0, 0x27, 0x59, 0x59, 0x3E, 0x7E, 0x06, 0x63,
	0x61, 0x07, 0x3A, 0x83, 0xB2, 0x7B, 0x53, 0x1A,
	0x3D, 0x0D, 0xDA, 0x51, 0x7C, 0xA9, 0x90, 0xEA,
	0x32, 0x35, 0xD1, 0xD7, 0xB5, 0xE0, 0x9D, 0xA5,
	0xF0, 0x2D, 0xC1, 0x52, 0x5B, 0x1D, 0xA6, 0x85,
	0x96, 0x5B, 0x54, 0xFC, 0x2A, 0x3A, 0x73, 0xA1,
	0x79, 0x0E, 0x0E, 0xFB, 0x69, 0xE7, 0x0A, 0x78,
	0xFA, 0x55, 0x03, 0x44, 0xEA, 0x8C, 0x75, 0x3D,
	0xBF, 0x18, 0x63, 0x9B, 0xAA, 0x8C, 0xB1, 0x25,
	0x9A, 0xA7, 0x4F, 0x68, 0xF9, 0x2A, 0xBA, 0x80,
	0x07, 0xC6, 0x18, 0xCC, 0xB6, 0xF5, 0x06, 0x9F,
	0xF4, 0x6B, 0x97, 0x51, 0xBB, 0xFF, 0xF3, 0x7D,
	0xF3, 0x21, 0x36, 0x0F, 0x0F, 0x5C, 0x0E, 0x7F,
	0x56, 0x26, 0xDD, 0x12, 0x9A, 0xE3, 0xAE, 0x2A,
	0x7C, 0x56, 0xCD, 0xB6, 0x11, 0xED, 0xA4, 0xC9,
	0x8F, 0xEC, 0x83, 0x16, 0x3C, 0xD5, 0x11, 0x68,
	0x78, 0xC1, 0xA9, 0x3E, 0xBA, 0xA2, 0x6D, 0xB4,
	0x05, 0xEA, 0xF4, 0xA7, 0xAB, 0xA2, 0x77, 0x83,
	0x7D, 0xE9, 0xA5, 0x15, 0x04, 0x70, 0x76, 0x24,
	0xEF, 0x2E, 0x1B, 0xBB, 0xCA, 0x29, 0x24, 0x11,
	0x16, 0x7F, 0x2E, 0x3D, 0x39, 0x0C, 0x0E, 0x51,
	0xF8, 0x4A, 0x2F, 0x13, 0x83, 0x90, 0xE3, 0x3F,
	0x85, 0x83, 0x5D, 0x38, 0xA9, 0x4D, 0xBB, 0xE7,
	0x1E, 0x6C, 0x82, 0x1E, 0x86, 0xB1, 0x1F, 0xFD,
	0x89, 0xEF, 0xF4, 0xBF, 0xE2, 0x08, 0xD6, 0x00,
	0x5D, 0x28, 0xF7, 0x04, 0xBA, 0xEA, 0xD1, 0xF2,
	0x5D, 0xE0, 0xEB, 0x24, 0x1B, 0x18, 0xFC, 0x7F,
	0xA0, 0xDD, 0xD9, 0x0D, 0xC1, 0x39, 0xBE, 0x7F,
	0xCB, 0xEB, 0x97, 0x30, 0xFA, 0xE4, 0xB5, 0xD1,
	0x72, 0x70, 0xCE, 0x4C, 0x67, 0x0C, 0x42, 0x57,
	0x0A, 0x9C, 0xF2, 0x5B, 0xC4, 0xFA, 0xE5, 0xCD,
	0x31, 0xE5, 0xD5, 0x5A, 0xD0, 0x22, 0x6A, 0x94,
	0xBE, 0x52, 0x94, 0x8C, 0x67, 0x02, 0xA9, 0x86,
	0xA0, 0xAD, 0xBF, 0xCD, 0x3A, 0xC4, 0x82, 0xBB,
	0x12, 0xAB, 0xBB, 0x79, 0xA2, 0xF6, 0x60, 0x28,
	0x42, 0x15, 0x3B, 0x2F, 0x82, 0xA3, 0xB3, 0xCD,
	0x16, 0x88, 0xE7, 0x4D, 0x36, 0x53, 0x4B, 0xFF,
	0x8C, 0x48, 0xD3, 0xC4, 0x51, 0xEB, 0x2C, 0x5F,
	0x98, 0xFE, 0xB9, 0xE7, 0x86, 0x4D, 0x60, 0xAF,
	0x96, 0xE8, 0x3B, 0x21, 0x62, 0x46, 0x74, 0x82,
	0xF0, 0x58, 0x63, 0x9C, 0x86, 0xA7, 0x85, 0xA9,
	0xA1, 0xD4, 0xB6, 0x9B, 0xC3, 0x0E, 0x77, 0xA6,
	0x4C, 0x3B, 0xBC, 0xD7, 0xDE, 0xB4, 0xE3, 0xD3,
	0x0F, 0x1A, 0x67, 0x21, 0x20, 0x3D, 0x87, 0xA8,
	0x8A, 0xB8, 0x5E, 0x02, 0x7A, 0x97, 0x42, 0xFC,
	0x68, 0x8F, 0x0A, 0xDF, 0x15, 0x72, 0x8E, 0x59,
	0x7E, 0x91, 0x0C, 0xFE, 0x5D, 0xF3, 0x3C, 0x56,
	0xA1, 0x36, 0xEF, 0x39, 0xC7, 0xCA, 0x5D, 0x65,
	0x0C, 0x2B, 0x9F, 0x90, 0x1C, 0x9B, 0x89, 0xE1,
	0xE0, 0x93, 0x54, 0x93, 0x61, 0xF3, 0x03, 0xBE,
	0x88, 0x39, 0xD1, 0x45, 0x4C, 0xCE, 0xB5, 0xFB,
	0xC4, 0x43, 0x5F, 0xA0, 0xDA, 0xB5, 0x8A, 0x8F,
	0xC2, 0x85, 0x36, 0x0E, 0xEA, 0x49, 0x1C, 0xA0,
	0x77, 0x96, 0x1C, 0x4A, 0xAA, 0x3E, 0x96, 0xDE,
	0x99, 0x71, 0xB9, 0x4F, 0xDF, 0xA5, 0x20, 0x7C,
	0xCF, 0x0D, 0x9D, 0xAB, 0x2C, 0x48, 0x96, 0xF0,
	0x7E, 0xB6, 0x77, 0x1A, 0x38, 0x3C, 0x65, 0x12,
	0xF4, 0x1E, 0xA2, 0x8D, 0xEE, 0xE4, 0x07, 0xFD,
	0xAE, 0x3C, 0x57, 0x4F, 0x5D, 0x41, 0x6A, 0x89,
	0x7A, 0x27, 0xEF, 0x7C, 0xF5, 0x96, 0xF0, 0x43,
	0x2D, 0x62, 0x4A, 0x2C, 0x4E, 0xAC, 0xE5, 0x2F,
	0x3C, 0xBF, 0x2C, 0x63, 0x31, 0xB8, 0x0C, 0x9C,
	0x91, 0x65, 0xBF, 0x13, 0x34, 0x24, 0x69, 0x32,
	0x02, 0x4E, 0xC0, 0xBE, 0x44, 0xB3, 0x21, 0x36,
	0xB4, 0xE4, 0x34, 0x27, 0x91, 0x35, 0x85, 0x03,
	0x64, 0xC7, 0x57, 0xF1, 0xDC, 0xFA, 0x63, 0x85,
	0xE2, 0x56, 0x33, 0x12, 0xC5, 0xF5, 0x53, 0xF0,
	0xC8, 0x44, 0xEA, 0xBB, 0x79, 0x11, 0xCE, 0xE7,
	0x60, 0xCA, 0xEB, 0x3E, 0x19, 0x3B, 0xF3, 0xA9,
	0xC3, 0x81, 0x14, 0x87, 0x23, 0x9A, 0xD2, 0xE0,
	0x14, 0x78, 0xF4, 0x6E, 0x41, 0x8A, 0x5D, 0xE5,
	0x6B, 0x7F, 0x17, 0x55, 0xBA, 0x68, 0xF9, 0xA3,
	0x74, 0x61, 0x3B, 0x5D, 0xE2, 0xED, 0x26, 0xC5,
	0x80, 0xC7, 0x72, 0xDB, 0xDB, 0xFA, 0xB1, 0xF7,
	0xE3, 0xF5, 0x7D, 0x94, 0xF8, 0x4E, 0x30, 0xDE,
	0xB2, 0x9D, 0x70, 0xA9, 0x1D, 0xF2, 0x88, 0xFC,
	0x43, 0xA2, 0x76, 0xDF, 0xED, 0x58, 0xE2, 0xB0,
	0xDB, 0x53, 0x83, 0xE5, 0x32, 0xB6, 0xEE, 0xDF,
	0xB3, 0x92, 0xE4, 0x3D, 0xC3, 0xDA, 0x72, 0x01,
	0xA0, 0x68, 0xF5, 0x23, 0x1E, 0xE5, 0x22, 0x09,
	0x8D, 0x68, 0x59, 0xB2, 0xD5, 0x64, 0x63, 0xA8,
	0x91, 0x7B, 0x3C, 0x25, 0x61, 0x65, 0x79, 0x66,
	0xDB, 0xC4, 0x78, 0x56, 0xB6, 0xFF, 0xC8, 0x2B,
	0xCC, 0x37, 0x9F, 0xFD, 0x08, 0xB2, 0x59, 0xF3,
	0xD9, 0xD7, 0x87, 0x3B, 0xA8, 0xFC, 0xBE, 0x4C,
	0x94, 0x13, 0xB6, 0x01, 0x15, 0x91, 0x60, 0x70,
	0x1D, 0xF0, 0x04, 0x70, 0xB1, 0x49, 0xBD, 0xF3,
	0x2F, 0x4D, 0x3C, 0xFC, 0xFB, 0x9D, 0xEB, 0xC7,
	0x72, 0x41, 0x71, 0x7D, 0x13, 0x06, 0x7A, 0xAE,
	0xD2, 0x3C, 0x7A, 0x26, 0x51, 0x18, 0x51, 0x69,
	0xF1, 0x26, 0x70, 0x61, 0xFB, 0x6B, 0x30, 0xE4,
	0xFE, 0xA7, 0x3F, 0x66, 0xF4, 0xF9, 0x27, 0x56,
	0xAC, 0x26, 0x23, 0x41, 0x8A, 0xF8, 0xB2, 0xA3,
	0x98, 0x71, 0x1B, 0x7C, 0x68, 0x07, 0xB4, 0x34,
	0x25, 0xE1, 0xD9, 0x9B, 0xFD, 0xCD, 0x5D, 0xF5,
	0x31, 0x95, 0x28, 0x79, 0x06, 0xA3, 0x32, 0xF5,
	0x99, 0x71, 0xA0, 0xC3, 0x43, 0x97, 0x5F, 0xC3,
	0x20, 0xAD, 0x13, 0x7C, 0x9E, 0x34, 0xCE, 0x7C,
	0xE8, 0x55, 0x20, 0xB2, 0x6C, 0xA1, 0x97, 0xA1,
	0xFA, 0x2D, 0xF2, 0xEC, 0xD4, 0xE3, 0xFA, 0x83,
	0x3B, 0x3B, 0xD2, 0xC2, 0x44, 0x82, 0x80, 0x42,
	0x52, 0xCF, 0x1D, 0xF6, 0xAD, 0xC6, 0x39, 0x8F,
	0x35, 0xE9, 0x8A, 0xB1, 0x87, 0x10, 0x40, 0x76,
	0x80, 0xC9, 0xC1, 0xDB, 0xAC, 0x8C, 0x7E, 0xDC,
	0x86, 0x46, 0xB9, 0x70, 0x82, 0xE2, 0xE1, 0x21,
	0xFA, 0xA7, 0xFA, 0xC2, 0x1E, 0x4A, 0x33, 0x83,
	0x84, 0xCB, 0x92, 0x20, 0x2C, 0x61, 0xBD, 0x12,
	0x6C, 0x5D, 0xDD, 0x45, 0x8B, 0x32, 0x7A, 0x18,
	0xBD, 0x71, 0x6F, 0x14, 0x2C, 0xA5, 0xCD, 0xB3,
	0xE4, 0x9D, 0x7E, 0xB8, 0xD9, 0x62, 0xB5, 0xB8,
	0x5A, 0x88, 0xF7, 0x99, 0xB6, 0x9A, 0x6A, 0x66,
	0xC7, 0xBD, 0x62, 0x9F, 0x56, 0xB4, 0x3C, 0x02,
	0x90, 0x62, 0x9B, 0x5E, 0x27, 0x4C, 0xDE, 0xC7,
	0xA0, 0x72, 0x29, 0xE7, 0x93, 0x9A, 0x77, 0xD3,
	0x2E, 0x8E, 0xF7, 0x30, 0xFC, 0xCE, 0xAD, 0x9C,
	0x4E, 0x06, 0x77, 0xA8, 0x3A, 0x03, 0x30, 0xAB,
	0x76, 0x5D, 0x33, 0x6D, 0xD2, 0xAA, 0x15, 0x5D,
	0xCD, 0x2A, 0xC7, 0xF3, 0x15, 0x29, 0x77, 0x4F,
	0x49, 0x36, 0xB0, 0x5D, 0x0B, 0x14, 0xB4, 0x8F,
	0xAA, 0x1E, 0x8C, 0xD4, 0x50, 0x56, 0xE5, 0x6C,
	0x13, 0x9B, 0x17, 0xF8, 0x90, 0x71, 0x5A, 0xD6,
	0x3D, 0x6C, 0x4A, 0x9F, 0x2D, 0x97, 0x6C, 0x8B,
	0x63, 0x5B, 0xDF, 0xE5, 0x86, 0x02, 0x81, 0x6F,
	0x61, 0x2C, 0x6E, 0x4B, 0x22, 0x53, 0x67, 0xCB,
	0x9A, 0x7B, 0xB7, 0x9C, 0x01, 0x8F, 0x1B, 0x8C,
	0x53, 0x15, 0x18, 0x0A, 0xAD, 0xBE, 0x3A, 0xB7,
	0x5A, 0xC3, 0x56, 0x20, 0x6F, 0xE2, 0x7C, 0x12,
	0xDF, 0x3B, 0x56, 0x97, 0x84, 0xE3, 0xA5, 0x38,
	0xFB, 0x05, 0x24, 0x18, 0x26, 0x6E, 0x72, 0xDB,
	0x40, 0x0D, 0x6F, 0x32, 0xC4, 0x29, 0x7F, 0x34,
	0xF9, 0xF1, 0xAF, 0x18, 0x6C, 0x37, 0x65, 0x65,
	0x5F, 0x11, 0xB3, 0xE5, 0xA3, 0xC8, 0x04, 0x9B,
	0x7D, 0xF1, 0x40, 0x11, 0xFF, 0x21, 0x5F, 0xBF,
	0x17, 0xBF, 0x89, 0xEE, 0x97, 0x6C, 0xF0, 0xDB,
	0xAB, 0x62, 0x70, 0x10, 0x4E, 0x7E, 0x31, 0x9D,
	0x1F, 0x64, 0xC5, 0x9E, 0x20, 0x9E, 0x35, 0x82,
};

uint8_t mldsa_44_pubkey_noseed[] = {
	0xBA, 0x71, 0xF9, 0xF6, 0x4E, 0x11, 0xBA, 0xEB,
	0x58, 0xFA, 0x9C, 0x6F, 0xBB, 0x6E, 0x14, 0xE6,
	0x1F, 0x18, 0x64, 0x3D, 0xAB, 0x49, 0x5B, 0x47,
	0x53, 0x9A, 0x91, 0x66, 0xCA, 0x01, 0x98, 0x13,
	0x1C, 0x44, 0xF8, 0x26, 0xBB, 0xD5, 0x6E, 0x34,
	0xE5, 0x5D, 0xB5, 0xE5, 0xE2, 0xD7, 0x33, 0x48,
	0x5E, 0x39, 0xEA, 0x26, 0x0F, 0xC6, 0x00, 0x0C,
	0x5E, 0xA4, 0xBA, 0x80, 0xD3, 0x45, 0x5C, 0xDE,
	0x53, 0xB4, 0x6F, 0x34, 0x48, 0x2A, 0xED, 0xFD,
	0x54, 0x50, 0xFC, 0x2E, 0x1B, 0xA4, 0xF2, 0x5D,
	0x15, 0xF9, 0xC1, 0x44, 0x24, 0x2F, 0xB3, 0x9B,
	0xB5, 0x22, 0x87, 0x18, 0x90, 0x30, 0xC5, 0x04,
	0x98, 0xE1, 0x71, 0x7B, 0x7C, 0x75, 0x8B, 0x19,
	0x0A, 0x67, 0x48, 0xEA, 0x9A, 0xA3, 0xF7, 0xAC,
	0xAA, 0xF2, 0xC7, 0xCB, 0x52, 0x6E, 0xD7, 0x17,
	0xC9, 0xF7, 0x9A, 0xEB, 0x84, 0x21, 0x4F, 0xA5,
	0xCD, 0x8D, 0xED, 0x92, 0xA0, 0xC3, 0xFA, 0x15,
	0x58, 0x81, 0x0F, 0x12, 0xC7, 0x05, 0x0A, 0x36,
	0x77, 0x08, 0xD1, 0x96, 0xCD, 0x24, 0xE5, 0xAF,
	0x97, 0x49, 0x04, 0xAE, 0xD8, 0xE4, 0xCE, 0x88,
	0x72, 0xE8, 0x69, 0x6B, 0x0B, 0x7B, 0xCA, 0x50,
	0xE4, 0x52, 0xCD, 0x7D, 0x30, 0xEA, 0x9A, 0x4A,
	0xDA, 0xC0, 0x31, 0x1D, 0x67, 0x2C, 0x6B, 0xDE,
	0x84, 0x96, 0x24, 0x0B, 0x07, 0x43, 0x14, 0x63,
	0x70, 0x88, 0x95, 0xCD, 0x9B, 0xAF, 0xC3, 0x16,
	0x32, 0xD7, 0x39, 0x76, 0x49, 0x38, 0x8F, 0xDA,
	0xFC, 0xBF, 0x7D, 0x30, 0x5A, 0x3D, 0xE9, 0xA4,
	0x95, 0xEC, 0xA7, 0x43, 0x3A, 0x8F, 0x83, 0xBA,
	0x0F, 0x0B, 0x25, 0xC4, 0x13, 0xC6, 0xE3, 0x9C,
	0x96, 0xEB, 0x7D, 0x69, 0x1B, 0x34, 0xD3, 0x7C,
	0xE3, 0x7F, 0x1E, 0xEA, 0xD1, 0xCF, 0x21, 0x7E,
	0x25, 0xEF, 0x34, 0xEE, 0xCF, 0x3F, 0x7C, 0x60,
	0xF8, 0x4B, 0x8E, 0xDF, 0xDD, 0xE8, 0x40, 0x5D,
	0x4F, 0x83, 0x25, 0x76, 0xC6, 0x1E, 0xF9, 0x8E,
	0x0A, 0x2F, 0x28, 0xDA, 0x18, 0x77, 0x00, 0x95,
	0x39, 0x24, 0xF6, 0x86, 0xB9, 0x46, 0x14, 0x70,
	0x5B, 0xCF, 0x53, 0xD3, 0x3F, 0xED, 0xD4, 0x34,
	0x8E, 0xDD, 0xDB, 0xDF, 0x28, 0xB5, 0x06, 0x5E,
	0x1F, 0x20, 0x77, 0x50, 0x43, 0xE8, 0x5C, 0xF9,
	0x31, 0xF8, 0x29, 0x17, 0x93, 0x63, 0xA1, 0xA7,
	0xE7, 0x40, 0x4A, 0x83, 0x8E, 0xC0, 0x00, 0x86,
	0xB0, 0x97, 0x63, 0x86, 0xFE, 0x63, 0x7C, 0x98,
	0x24, 0x47, 0x57, 0xE3, 0xF7, 0x69, 0xDD, 0xD4,
	0x46, 0x74, 0x71, 0xBF, 0xAD, 0x67, 0x0F, 0x9A,
	0x05, 0xF8, 0x24, 0x6E, 0xE5, 0x0A, 0x7B, 0x1E,
	0xAF, 0x87, 0xFC, 0x40, 0x69, 0xC3, 0xAE, 0x2A,
	0xA2, 0x03, 0x32, 0x58, 0x11, 0x77, 0x92, 0xF0,
	0xBC, 0xD4, 0x9E, 0x08, 0x3F, 0xD1, 0xBC, 0x74,
	0x96, 0xAB, 0xFF, 0x29, 0xCC, 0x94, 0xE4, 0x86,
	0x8B, 0x21, 0x21, 0x4E, 0xD3, 0x16, 0x52, 0x53,
	0x99, 0xA6, 0x10, 0xFB, 0xDD, 0x4A, 0x80, 0xE7,
	0xC8, 0x07, 0x15, 0xF2, 0x95, 0x78, 0xE2, 0xA8,
	0x4B, 0xB4, 0x0B, 0xDD, 0xDB, 0xD9, 0xF4, 0x7A,
	0x11, 0xB6, 0xE7, 0xDA, 0x11, 0x8A, 0x1B, 0x65,
	0x8D, 0x35, 0x9E, 0x8A, 0xEF, 0x55, 0xEB, 0x46,
	0xB5, 0x37, 0x6B, 0x5B, 0x65, 0x59, 0x79, 0x98,
	0x4A, 0x92, 0x2B, 0xEE, 0xBF, 0xC5, 0x9B, 0xCD,
	0x60, 0x0D, 0x53, 0x09, 0xDC, 0xCD, 0x72, 0xDB,
	0xF0, 0x78, 0x7D, 0xB8, 0xBA, 0x75, 0x7B, 0x53,
	0x7C, 0x1E, 0xAF, 0xD5, 0xC0, 0xF5, 0x0E, 0xA4,
	0xBC, 0x95, 0x83, 0x54, 0x9E, 0x28, 0x29, 0xA4,
	0x2C, 0x28, 0xCA, 0xC2, 0x48, 0xC9, 0x6D, 0x78,
	0x12, 0x4C, 0x47, 0x15, 0x9B, 0x18, 0xAE, 0xDD,
	0x75, 0x4A, 0xBA, 0x17, 0xB1, 0x9D, 0x43, 0x0F,
	0xB7, 0x8F, 0x63, 0x3E, 0xA9, 0xD2, 0x6F, 0x54,
	0xA9, 0xBD, 0x50, 0xF8, 0xD8, 0xF6, 0xB7, 0x35,
	0x94, 0xF8, 0x28, 0x97, 0x6E, 0x7E, 0xA0, 0x9C,
	0x53, 0xBB, 0xB9, 0xF1, 0x1A, 0x56, 0xC9, 0x50,
	0x7F, 0xB8, 0x9B, 0x9A, 0x5E, 0xBC, 0x03, 0x7A,
	0x37, 0x26, 0x7A, 0x95, 0xF8, 0x5B, 0x8D, 0x64,
	0xCA, 0x97, 0x19, 0x2B, 0x10, 0xA6, 0x6F, 0x41,
	0x7B, 0x3F, 0x61, 0xFE, 0x9C, 0xA5, 0x71, 0x30,
	0xA4, 0x8F, 0xD9, 0x25, 0xEA, 0xE2, 0xAB, 0x55,
	0x02, 0xD5, 0x71, 0xC8, 0xA5, 0x19, 0x03, 0xC1,
	0xD3, 0x98, 0xF4, 0xC1, 0xF7, 0x6A, 0x7E, 0x11,
	0x74, 0x39, 0x76, 0xAF, 0xDB, 0xC6, 0x97, 0xF2,
	0x30, 0x94, 0xA3, 0xCD, 0x76, 0x1F, 0xF9, 0x68,
	0x5D, 0xE3, 0x2E, 0x09, 0xFB, 0x3C, 0x28, 0xAD,
	0xD4, 0x53, 0x49, 0x03, 0x00, 0xBC, 0x7C, 0x89,
	0xDC, 0x01, 0x78, 0x00, 0x96, 0x07, 0x17, 0x22,
	0x94, 0x57, 0x75, 0xF2, 0x64, 0xE1, 0xB0, 0x62,
	0x3B, 0xCF, 0x46, 0x19, 0xC7, 0x12, 0xC8, 0x38,
	0x76, 0x12, 0x05, 0xD8, 0x76, 0x91, 0xB7, 0x5E,
	0xF3, 0x60, 0x19, 0x6C, 0xBB, 0x9E, 0x9B, 0x92,
	0xA0, 0xD4, 0xC4, 0xED, 0x62, 0x32, 0x6E, 0x50,
	0x24, 0xD7, 0x75, 0x10, 0xB8, 0xEE, 0x2C, 0x74,
	0x26, 0xCC, 0x22, 0xEA, 0xE2, 0x09, 0xDC, 0x9F,
	0x13, 0xBD, 0xE6, 0xBF, 0x08, 0xF5, 0xE7, 0x18,
	0x1B, 0xD3, 0xB4, 0x59, 0x45, 0x0B, 0x45, 0x1A,
	0x51, 0x53, 0x9A, 0x71, 0x5C, 0x21, 0xD6, 0x7D,
	0xD3, 0x30, 0xEB, 0x59, 0x70, 0xDB, 0x00, 0xD9,
	0xED, 0xBF, 0xB2, 0x82, 0x2B, 0x03, 0x6F, 0xA1,
	0x3B, 0xAF, 0xEB, 0x86, 0xD8, 0xDC, 0x78, 0x86,
	0x6E, 0x3F, 0x8D, 0x43, 0xE5, 0x3D, 0x78, 0xCC,
	0xA5, 0x59, 0x5A, 0x6F, 0xAF, 0x88, 0x6B, 0x5D,
	0xC1, 0x12, 0xF1, 0xCF, 0x4A, 0xDC, 0xFA, 0x87,
	0x58, 0x00, 0xD9, 0x0B, 0x48, 0x88, 0x3A, 0xF9,
	0x73, 0x16, 0xFE, 0x15, 0x06, 0x87, 0x3F, 0xC1,
	0x57, 0xE5, 0x70, 0xEA, 0xCB, 0xFD, 0x22, 0x28,
	0x68, 0xD1, 0x42, 0x34, 0x10, 0x19, 0x66, 0xAF,
	0xB6, 0xBF, 0x99, 0x40, 0x82, 0x92, 0x53, 0xA9,
	0x53, 0xAD, 0xA8, 0x9F, 0xC7, 0x56, 0xB6, 0xA8,
	0x49, 0xF7, 0x0A, 0xCB, 0x98, 0x38, 0xE6, 0x9F,
	0xAA, 0x50, 0xBB, 0xA7, 0x5E, 0x3E, 0x89, 0xC2,
	0xAD, 0xB5, 0x7E, 0x86, 0xD0, 0x88, 0xAB, 0x9B,
	0x04, 0xA2, 0x8E, 0x67, 0x07, 0x09, 0x17, 0x22,
	0x43, 0xEC, 0x5E, 0x00, 0x08, 0xA5, 0xCE, 0xAF,
	0x3F, 0x87, 0x22, 0xF4, 0x87, 0x30, 0x25, 0x96,
	0xFF, 0xD7, 0x55, 0xAD, 0x1B, 0x82, 0xA4, 0x9C,
	0x34, 0xB3, 0x46, 0x95, 0x15, 0xB4, 0x6A, 0xA2,
	0x90, 0xCD, 0x86, 0xEE, 0x38, 0xEA, 0x7A, 0x9B,
	0xE3, 0xF1, 0x03, 0x61, 0x03, 0x35, 0xB5, 0x31,
	0xCC, 0xA3, 0x33, 0xDD, 0xFE, 0x32, 0xB1, 0x45,
	0x10, 0xF4, 0xB0, 0x7E, 0xF9, 0x5F, 0xC6, 0x68,
	0x4E, 0x8C, 0x45, 0x4A, 0x92, 0xC1, 0x0D, 0xBB,
	0x5D, 0x59, 0xC7, 0xA7, 0xC6, 0x3F, 0xB3, 0x05,
	0xFE, 0x88, 0x19, 0x67, 0xD9, 0x9E, 0x66, 0x9E,
	0xB6, 0x32, 0x84, 0x05, 0x82, 0x56, 0x0B, 0xB4,
	0x03, 0x43, 0x1D, 0x40, 0xF7, 0x5A, 0x49, 0x54,
	0x90, 0x84, 0x82, 0x27, 0x82, 0x92, 0x82, 0x1F,
	0x4E, 0xA9, 0x1E, 0x42, 0xE7, 0x8F, 0xA4, 0x8C,
	0xAE, 0xE3, 0xC8, 0x36, 0x14, 0x6D, 0xCF, 0xD7,
	0x38, 0xD1, 0x17, 0xE9, 0x2E, 0x9A, 0x15, 0x13,
	0x7D, 0x28, 0xE8, 0xE6, 0xA4, 0xB4, 0x62, 0x26,
	0x50, 0xCB, 0x41, 0x35, 0x04, 0xCB, 0x3A, 0x33,
	0x5D, 0x44, 0xBE, 0xEC, 0x57, 0x46, 0xC1, 0xC2,
	0x94, 0xB1, 0xE8, 0xCB, 0x99, 0xCB, 0x60, 0x8D,
	0x92, 0x8F, 0x8C, 0xE3, 0x56, 0x36, 0x32, 0xC5,
	0x21, 0xF2, 0x3D, 0x13, 0xC6, 0x1A, 0x8F, 0x61,
	0xC0, 0x1D, 0xF8, 0xC9, 0x6C, 0x73, 0x60, 0xDB,
	0x4F, 0x3C, 0x68, 0xAA, 0x5D, 0x2F, 0xDD, 0x34,
	0x2A, 0x62, 0xFF, 0x34, 0x59, 0xC1, 0x16, 0x38,
	0x94, 0x21, 0xAB, 0x43, 0xE8, 0x58, 0x4C, 0x45,
	0x88, 0x2B, 0x50, 0xE6, 0xE4, 0xE9, 0x6D, 0xB6,
	0xF0, 0xB8, 0xFD, 0xE8, 0x90, 0xD5, 0xDB, 0xFA,
	0xDC, 0xD8, 0x86, 0x90, 0xB4, 0x49, 0xE6, 0x42,
	0x40, 0xDD, 0xB2, 0x02, 0x37, 0x47, 0xF3, 0x08,
	0x36, 0x3E, 0x30, 0x1A, 0xA7, 0x77, 0x57, 0x16,
	0x9F, 0xC6, 0x15, 0x06, 0x28, 0xD5, 0x92, 0x0B,
	0x5A, 0xA1, 0xAB, 0x1C, 0x8C, 0xBF, 0x44, 0xCB,
	0x00, 0xE0, 0x25, 0xD7, 0x87, 0x9D, 0x72, 0xB4,
	0x79, 0xE3, 0xAF, 0x53, 0x11, 0xC7, 0x85, 0x72,
	0x55, 0x90, 0xDA, 0x9C, 0x89, 0xB9, 0xFC, 0x3B,
	0x84, 0x50, 0x76, 0x95, 0x54, 0xEB, 0x44, 0xD2,
	0x03, 0xEB, 0xA2, 0xBB, 0xAE, 0xF9, 0xCA, 0xD2,
	0x23, 0x70, 0x11, 0xC2, 0xEA, 0x44, 0xEF, 0xF0,
	0x0F, 0x29, 0x9A, 0x48, 0xFF, 0xE2, 0x8C, 0xA9,
	0x3D, 0xDF, 0x85, 0xF7, 0x66, 0x08, 0x24, 0x2E,
	0xF8, 0xD6, 0xCC, 0x24, 0x61, 0x0A, 0x1E, 0x20,
	0x78, 0xFC, 0xAC, 0x4F, 0x93, 0x85, 0xC3, 0x14,
	0x90, 0x5E, 0xCA, 0xA8, 0x2E, 0x55, 0x39, 0x16,
	0xD9, 0x4D, 0x1A, 0x7C, 0x1E, 0xC6, 0x52, 0xAA,
	0x08, 0x89, 0x70, 0x83, 0xDA, 0xA2, 0xEB, 0xB1,
	0x77, 0x5F, 0xBC, 0x47, 0x1A, 0xE2, 0x77, 0x77,
	0xD7, 0x90, 0x4E, 0xA9, 0xF1, 0xB9, 0x2B, 0xCA,
	0xC3, 0xD8, 0xA3, 0x15, 0x84, 0x26, 0x08, 0x7B,
	0x64, 0x5B, 0x11, 0x08, 0xF0, 0xD6, 0x5F, 0xEC,
	0x93, 0x78, 0x9C, 0x05, 0x37, 0x43, 0xCA, 0x14,
	0xFD, 0x63, 0xD0, 0x5E, 0x98, 0xB6, 0x52, 0xDF,
	0x2B, 0x9C, 0x2F, 0xF9, 0xCE, 0x05, 0xF1, 0x94,
	0x07, 0x03, 0xFF, 0xB2, 0x73, 0xF8, 0x0E, 0x0E,
	0x27, 0x32, 0xEC, 0xA9, 0x96, 0x0D, 0x98, 0x1B,
	0x4C, 0xFD, 0x3B, 0x7B, 0xB8, 0x04, 0x5B, 0x3C,
	0x38, 0x30, 0x54, 0x6B, 0x9D, 0xD8, 0xDB, 0x0D,
};

uint8_t mldsa_44_extmu[] = {
	0x1B, 0x2A, 0xA5, 0xD5, 0xE3, 0xF3, 0xC1, 0xD4,
	0x8D, 0x7C, 0xE6, 0x8F, 0xE9, 0xE3, 0xD1, 0xF5,
	0x2E, 0x4B, 0x7C, 0xD6, 0x2A, 0xF4, 0x2E, 0xE5,
	0x8F, 0xC3, 0xB1, 0xA4, 0xB9, 0xD1, 0x2C, 0x8B,
	0x9E, 0x4D, 0x7A, 0xA9, 0x7C, 0xD3, 0xE6, 0x5A,
	0xF4, 0x1B, 0x2A, 0xA5, 0xD5, 0xE3, 0xF3, 0xC1,
	0xD4, 0x8D, 0x7C, 0xE6, 0x8F, 0xE9, 0xE3, 0xD1,
	0xF5, 0x2E, 0x4B, 0x7C, 0xD6, 0x2A, 0xF4, 0x2E,
};

struct crypto_testsuite_mldsa_params mldsa_keygen_test_vectors[] = {
	{
		.name = "mldsa_44_keygen",
		.type = RTE_CRYPTO_ML_DSA_44,
		.seed = {
			.data = mldsa_44_seed,
			.length = sizeof(mldsa_44_seed),
		},
	},
	{
		.name = "mldsa_44_keygen (deterministic)",
		.type = RTE_CRYPTO_ML_DSA_44,
		.seed = {
			.data = (uint8_t [32]) {0},
			.length = 32,
		},
		.privkey = {
			.data = mldsa_44_privkey_noseed,
			.length = sizeof(mldsa_44_privkey_noseed),
		},
		.pubkey = {
			.data = mldsa_44_pubkey_noseed,
			.length = sizeof(mldsa_44_pubkey_noseed),
		},
	},
};

struct crypto_testsuite_mldsa_params mldsa_sign_test_vectors[] = {
	{
		.name = "mldsa_44_sign",
		.type = RTE_CRYPTO_ML_DSA_44,
		.hash = 0,
		.seed = {
			.data = mldsa_44_seed,
			.length = sizeof(mldsa_44_seed),
		},
		.privkey = {
			.data = mldsa_44_privkey,
			.length = sizeof(mldsa_44_privkey),
		},
		.pubkey = {
			.data = mldsa_44_pubkey,
			.length = sizeof(mldsa_44_pubkey),
		},
		.message = {
			.data = mldsa_44_message,
			.length = sizeof(mldsa_44_message),
		},
		.context = {
			.data = NULL,
			.length = 0,
		},
		.mu = {
			.data = NULL,
			.length = 0,
		},
		.sign = {
			.data = mldsa_44_sign,
			.length = sizeof(mldsa_44_sign),
		},
		.sign_deterministic = false,
	},
	{
		.name = "mldsa_44_sign (deterministic)",
		.type = RTE_CRYPTO_ML_DSA_44,
		.hash = 0,
		.seed = {
			.data = (uint8_t [32]) {0},
			.length = 32,
		},
		.privkey = {
			.data = mldsa_44_privkey_noseed,
			.length = sizeof(mldsa_44_privkey_noseed),
		},
		.pubkey = {
			.data = mldsa_44_pubkey_noseed,
			.length = sizeof(mldsa_44_pubkey_noseed),
		},
		.message = {
			.data = mldsa_44_message,
			.length = sizeof(mldsa_44_message),
		},
		.context = {
			.data = NULL,
			.length = 0,
		},
		.mu = {
			.data = NULL,
			.length = 0,
		},
		.sign = {
			.data = mldsa_44_sign_dtrm,
			.length = sizeof(mldsa_44_sign_dtrm),
		},
		.sign_deterministic = true,
	},
	{
		.name = "mldsa_44_sign (sha3_256)",
		.type = RTE_CRYPTO_ML_DSA_44,
		.hash = RTE_CRYPTO_AUTH_SHA3_256,
		.seed = {
			.data = mldsa_44_seed,
			.length = sizeof(mldsa_44_seed),
		},
		.privkey = {
			.data = mldsa_44_privkey,
			.length = sizeof(mldsa_44_privkey),
		},
		.pubkey = {
			.data = mldsa_44_pubkey,
			.length = sizeof(mldsa_44_pubkey),
		},
		.message = {
			.data = mldsa_44_message,
			.length = sizeof(mldsa_44_message),
		},
		.context = {
			.data = NULL,
			.length = 0,
		},
		.mu = {
			.data = NULL,
			.length = 0,
		},
		.sign = {
			.data = mldsa_44_sign,
			.length = sizeof(mldsa_44_sign),
		},
		.sign_deterministic = false,
	},
	{
		.name = "mldsa_44_sign (ext mu)",
		.type = RTE_CRYPTO_ML_DSA_44,
		.hash = 0,
		.seed = {
			.data = (uint8_t [32]) {0},
			.length = 32,
		},
		.privkey = {
			.data = mldsa_44_privkey_noseed,
			.length = sizeof(mldsa_44_privkey_noseed),
		},
		.pubkey = {
			.data = mldsa_44_pubkey_noseed,
			.length = sizeof(mldsa_44_pubkey_noseed),
		},
		.mu = {
			.data = mldsa_44_extmu,
			.length = sizeof(mldsa_44_extmu),
		},
		.sign = {
			.data = mldsa_44_sign_dtrm,
			.length = sizeof(mldsa_44_sign_dtrm),
		},
		.sign_deterministic = false,
	},
};

struct crypto_testsuite_mldsa_params mldsa_verify_test_vectors[] = {
	{
		.name = "mldsa_44_verify",
		.type = RTE_CRYPTO_ML_DSA_44,
		.pubkey = {
			.data = mldsa_44_pubkey,
			.length = sizeof(mldsa_44_pubkey),
		},
		.message = {
			.data = mldsa_44_message,
			.length = sizeof(mldsa_44_message),
		},
		.context = {
			.data = NULL,
			.length = 0,
		},
		.mu = {
			.data = NULL,
			.length = 0,
		},
		.sign = {
			.data = mldsa_44_sign,
			.length = sizeof(mldsa_44_sign),
		},
	},
	{
		.name = "mldsa_44_verify (deterministic)",
		.type = RTE_CRYPTO_ML_DSA_44,
		.pubkey = {
			.data = mldsa_44_pubkey_noseed,
			.length = sizeof(mldsa_44_pubkey_noseed),
		},
		.message = {
			.data = mldsa_44_message,
			.length = sizeof(mldsa_44_message),
		},
		.context = {
			.data = NULL,
			.length = 0,
		},
		.mu = {
			.data = NULL,
			.length = 0,
		},
		.sign = {
			.data = mldsa_44_sign_dtrm,
			.length = sizeof(mldsa_44_sign_dtrm),
		},
	}
};
#endif /* __TEST_CRYPTODEV_ML_DSA_TEST_VECTORS_H__ */
