// Checks errors generated by passing a bad value for --cuda-gpu-arch.
// REQUIRES: clang-driver
// REQUIRES: x86-registered-target
// REQUIRES: nvptx-registered-target

// RUN: %clang -### -target x86_64-linux-gnu --cuda-gpu-arch=compute_20 -c %s 2>&1 \
// RUN: | FileCheck -check-prefix BAD %s
// RUN: %clang -### -target x86_64-linux-gnu --cuda-gpu-arch=sm20 -c %s 2>&1 \
// RUN: | FileCheck -check-prefix BAD %s
// RUN: %clang -### -target x86_64-linux-gnu --cuda-gpu-arch=sm_19 -c %s 2>&1 \
// RUN: | FileCheck -check-prefix BAD %s

// BAD: error: Unsupported CUDA gpu architecture

// RUN: %clang -### -target x86_64-linux-gnu --cuda-gpu-arch=sm_20 -c %s 2>&1 \
// RUN: | FileCheck -check-prefix OK %s
// RUN: %clang -### -target x86_64-linux-gnu --cuda-gpu-arch=sm_52 -c %s 2>&1 \
// RUN: | FileCheck -check-prefix OK %s
// RUN: %clang -### -target x86_64-linux-gnu -c %s 2>&1 \
// RUN: | FileCheck -check-prefix OK %s

// We don't allow using NVPTX for host compilation.
// RUN: %clang -### --cuda-host-only -target nvptx-nvidia-cuda -c %s 2>&1 \
// RUN: | FileCheck -check-prefix HOST_NVPTX %s

// OK-NOT: error: Unsupported CUDA gpu architecture
// HOST_NVPTX: error: unsupported use of NVPTX for host compilation.
