; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-apple-darwin -mattr=+aes,-avx -show-mc-encoding | FileCheck %s
; RUN: llc < %s -mtriple=i386-apple-darwin -mattr=+aes,+avx -show-mc-encoding | FileCheck %s --check-prefix=VCHECK

define <2 x i64> @test_x86_aesni_aesdec(<2 x i64> %a0, <2 x i64> %a1) {
; CHECK-LABEL: test_x86_aesni_aesdec:
; CHECK:       ## BB#0:
; CHECK-NEXT:    aesdec %xmm1, %xmm0 ## encoding: [0x66,0x0f,0x38,0xde,0xc1]
; CHECK-NEXT:    retl ## encoding: [0xc3]
;
; VCHECK-LABEL: test_x86_aesni_aesdec:
; VCHECK:       ## BB#0:
; VCHECK-NEXT:    vaesdec %xmm1, %xmm0, %xmm0 ## encoding: [0xc4,0xe2,0x79,0xde,0xc1]
; VCHECK-NEXT:    retl ## encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.aesni.aesdec(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesdec(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aesdeclast(<2 x i64> %a0, <2 x i64> %a1) {
; CHECK-LABEL: test_x86_aesni_aesdeclast:
; CHECK:       ## BB#0:
; CHECK-NEXT:    aesdeclast %xmm1, %xmm0 ## encoding: [0x66,0x0f,0x38,0xdf,0xc1]
; CHECK-NEXT:    retl ## encoding: [0xc3]
;
; VCHECK-LABEL: test_x86_aesni_aesdeclast:
; VCHECK:       ## BB#0:
; VCHECK-NEXT:    vaesdeclast %xmm1, %xmm0, %xmm0 ## encoding: [0xc4,0xe2,0x79,0xdf,0xc1]
; VCHECK-NEXT:    retl ## encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.aesni.aesdeclast(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesdeclast(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aesenc(<2 x i64> %a0, <2 x i64> %a1) {
; CHECK-LABEL: test_x86_aesni_aesenc:
; CHECK:       ## BB#0:
; CHECK-NEXT:    aesenc %xmm1, %xmm0 ## encoding: [0x66,0x0f,0x38,0xdc,0xc1]
; CHECK-NEXT:    retl ## encoding: [0xc3]
;
; VCHECK-LABEL: test_x86_aesni_aesenc:
; VCHECK:       ## BB#0:
; VCHECK-NEXT:    vaesenc %xmm1, %xmm0, %xmm0 ## encoding: [0xc4,0xe2,0x79,0xdc,0xc1]
; VCHECK-NEXT:    retl ## encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.aesni.aesenc(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesenc(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aesenclast(<2 x i64> %a0, <2 x i64> %a1) {
; CHECK-LABEL: test_x86_aesni_aesenclast:
; CHECK:       ## BB#0:
; CHECK-NEXT:    aesenclast %xmm1, %xmm0 ## encoding: [0x66,0x0f,0x38,0xdd,0xc1]
; CHECK-NEXT:    retl ## encoding: [0xc3]
;
; VCHECK-LABEL: test_x86_aesni_aesenclast:
; VCHECK:       ## BB#0:
; VCHECK-NEXT:    vaesenclast %xmm1, %xmm0, %xmm0 ## encoding: [0xc4,0xe2,0x79,0xdd,0xc1]
; VCHECK-NEXT:    retl ## encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.aesni.aesenclast(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesenclast(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aesimc(<2 x i64> %a0) {
; CHECK-LABEL: test_x86_aesni_aesimc:
; CHECK:       ## BB#0:
; CHECK-NEXT:    aesimc %xmm0, %xmm0 ## encoding: [0x66,0x0f,0x38,0xdb,0xc0]
; CHECK-NEXT:    retl ## encoding: [0xc3]
;
; VCHECK-LABEL: test_x86_aesni_aesimc:
; VCHECK:       ## BB#0:
; VCHECK-NEXT:    vaesimc %xmm0, %xmm0 ## encoding: [0xc4,0xe2,0x79,0xdb,0xc0]
; VCHECK-NEXT:    retl ## encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.aesni.aesimc(<2 x i64> %a0) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesimc(<2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aeskeygenassist(<2 x i64> %a0) {
; CHECK-LABEL: test_x86_aesni_aeskeygenassist:
; CHECK:       ## BB#0:
; CHECK-NEXT:    aeskeygenassist $7, %xmm0, %xmm0 ## encoding: [0x66,0x0f,0x3a,0xdf,0xc0,0x07]
; CHECK-NEXT:    retl ## encoding: [0xc3]
;
; VCHECK-LABEL: test_x86_aesni_aeskeygenassist:
; VCHECK:       ## BB#0:
; VCHECK-NEXT:    vaeskeygenassist $7, %xmm0, %xmm0 ## encoding: [0xc4,0xe3,0x79,0xdf,0xc0,0x07]
; VCHECK-NEXT:    retl ## encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.aesni.aeskeygenassist(<2 x i64> %a0, i8 7) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aeskeygenassist(<2 x i64>, i8) nounwind readnone
