// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/remoteworkers/v1test2/bots.proto

/*
Package remoteworkers is a generated protocol buffer package.

It is generated from these files:
	google/devtools/remoteworkers/v1test2/bots.proto
	google/devtools/remoteworkers/v1test2/command.proto
	google/devtools/remoteworkers/v1test2/tasks.proto

It has these top-level messages:
	BotSession
	Lease
	Worker
	Device
	AdminTemp
	CreateBotSessionRequest
	UpdateBotSessionRequest
	PostBotEventTempRequest
	CommandTask
	CommandOutputs
	CommandOverhead
	FileMetadata
	DirectoryMetadata
	Digest
	Directory
	Task
	TaskResult
	GetTaskRequest
	UpdateTaskResultRequest
	AddTaskLogRequest
	AddTaskLogResponse
*/
package remoteworkers

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/any"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A coarse description of the status of the bot that the server uses to
// determine whether to assign the bot new leases.
type BotStatus int32

const (
	// Default value; do not use.
	BotStatus_BOT_STATUS_UNSPECIFIED BotStatus = 0
	// The bot is healthy, and will accept leases as normal.
	BotStatus_OK BotStatus = 1
	// The bot is unhealthy and will not accept new leases. For example, the bot
	// may have detected that available disk space is too low. This situation may
	// resolve itself, but will typically require human intervention.
	BotStatus_UNHEALTHY BotStatus = 2
	// The bot has been asked to reboot the host. The bot will not accept new
	// leases; once all leases are complete, this session will no longer be
	// updated but the bot will be expected to establish a new session after the
	// reboot completes.
	BotStatus_HOST_REBOOTING BotStatus = 3
	// The bot has been asked to shut down. As with HOST_REBOOTING, once all
	// leases are completed, the session will no longer be updated and the bot
	// will not be expected to establish a new session.
	//
	// Bots are typically only asked to shut down if its host computer will be
	// modified in some way, such as deleting a VM.
	BotStatus_BOT_TERMINATING BotStatus = 4
)

var BotStatus_name = map[int32]string{
	0: "BOT_STATUS_UNSPECIFIED",
	1: "OK",
	2: "UNHEALTHY",
	3: "HOST_REBOOTING",
	4: "BOT_TERMINATING",
}
var BotStatus_value = map[string]int32{
	"BOT_STATUS_UNSPECIFIED": 0,
	"OK":              1,
	"UNHEALTHY":       2,
	"HOST_REBOOTING":  3,
	"BOT_TERMINATING": 4,
}

func (x BotStatus) String() string {
	return proto.EnumName(BotStatus_name, int32(x))
}
func (BotStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// The state of the lease. All leases start in the PENDING state. A bot can
// change PENDING to ACTIVE or (in the case of an error) COMPLETED, or from
// ACTIVE to COMPLETED. The server can change PENDING or ACTIVE to CANCELLED if
// it wants the bot to release its resources - for example, if the bot needs to
// be quarantined (it's producing bad output) or a cell needs to be drained.
type LeaseState int32

const (
	// Default value; do not use.
	LeaseState_LEASE_STATE_UNSPECIFIED LeaseState = 0
	// Pending: the server expects the bot to accept this lease. This may only be
	// set by the server.
	LeaseState_PENDING LeaseState = 1
	// Active: the bot has accepted this lease. This may only be set by the bot.
	LeaseState_ACTIVE LeaseState = 2
	// Completed: the bot is no longer leased. This may only be set by the bot,
	// and the status field must be populated iff the state is COMPLETED.
	LeaseState_COMPLETED LeaseState = 4
	// Cancelled: The bot should immediately release all resources associated with
	// the lease. This may only be set by the server.
	LeaseState_CANCELLED LeaseState = 5
)

var LeaseState_name = map[int32]string{
	0: "LEASE_STATE_UNSPECIFIED",
	1: "PENDING",
	2: "ACTIVE",
	4: "COMPLETED",
	5: "CANCELLED",
}
var LeaseState_value = map[string]int32{
	"LEASE_STATE_UNSPECIFIED": 0,
	"PENDING":                 1,
	"ACTIVE":                  2,
	"COMPLETED":               4,
	"CANCELLED":               5,
}

func (x LeaseState) String() string {
	return proto.EnumName(LeaseState_name, int32(x))
}
func (LeaseState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Possible administration actions.
type AdminTemp_Command int32

const (
	// Illegal value.
	AdminTemp_UNSPECIFIED AdminTemp_Command = 0
	// Download and run a new version of the bot. `arg` will be a resource
	// accessible via `ByteStream.Read` to obtain the new bot code.
	AdminTemp_BOT_UPDATE AdminTemp_Command = 1
	// Restart the bot without downloading a new version. `arg` will be a
	// message to log.
	AdminTemp_BOT_RESTART AdminTemp_Command = 2
	// Shut down the bot. `arg` will be a task resource name (similar to those
	// in tasks.proto) that the bot can use to tell the server that it is
	// terminating.
	AdminTemp_BOT_TERMINATE AdminTemp_Command = 3
	// Restart the host computer. `arg` will be a message to log.
	AdminTemp_HOST_RESTART AdminTemp_Command = 4
)

var AdminTemp_Command_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "BOT_UPDATE",
	2: "BOT_RESTART",
	3: "BOT_TERMINATE",
	4: "HOST_RESTART",
}
var AdminTemp_Command_value = map[string]int32{
	"UNSPECIFIED":   0,
	"BOT_UPDATE":    1,
	"BOT_RESTART":   2,
	"BOT_TERMINATE": 3,
	"HOST_RESTART":  4,
}

func (x AdminTemp_Command) String() string {
	return proto.EnumName(AdminTemp_Command_name, int32(x))
}
func (AdminTemp_Command) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4, 0} }

// Types of bot events.
type PostBotEventTempRequest_Type int32

const (
	// Illegal value.
	PostBotEventTempRequest_UNSPECIFIED PostBotEventTempRequest_Type = 0
	// Interesting but harmless event.
	PostBotEventTempRequest_INFO PostBotEventTempRequest_Type = 1
	// Error condition.
	PostBotEventTempRequest_ERROR PostBotEventTempRequest_Type = 2
)

var PostBotEventTempRequest_Type_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "INFO",
	2: "ERROR",
}
var PostBotEventTempRequest_Type_value = map[string]int32{
	"UNSPECIFIED": 0,
	"INFO":        1,
	"ERROR":       2,
}

func (x PostBotEventTempRequest_Type) String() string {
	return proto.EnumName(PostBotEventTempRequest_Type_name, int32(x))
}
func (PostBotEventTempRequest_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{7, 0}
}

// A bot session represents the state of a bot while in continuous contact with
// the server for a period of time. The session includes information about the
// worker - that is, the *worker* (the physical or virtual hardware) is
// considered to be a property of the bot (the software agent running on that
// hardware), which is the reverse of real life, but more natural from the point
// of the view of this API, which communicates solely with the bot and not
// directly with the underlying worker.
type BotSession struct {
	// The bot session name, as selected by the server. Output only during a call
	// to CreateBotSession.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A unique bot ID within the farm used to persistently identify this bot over
	// time (i.e., over multiple sessions). This ID must be unique within a
	// farm. Typically, the bot ID will be the same as the name of the primary
	// device in the worker (e.g., what you'd get from typing `uname -n` on *nix),
	// but this is not required since a single device may allow multiple bots to
	// run on it, each with access to different resources. What is important is
	// that this ID is meaningful to humans, who might need to hunt a physical
	// machine down to fix it.
	//
	// When CreateBotSession is successfully called with a bot_id, all prior
	// sessions with the same ID are invalidated. If a bot attempts to update an
	// invalid session, the server must reject that request, and may also
	// quarantine the other bot with the same bot IDs (ie, stop sending it new
	// leases and alert an admin).
	BotId string `protobuf:"bytes,2,opt,name=bot_id,json=botId" json:"bot_id,omitempty"`
	// The status of the bot. This must be populated in every call to
	// UpdateBotSession.
	Status BotStatus `protobuf:"varint,3,opt,name=status,enum=google.devtools.remoteworkers.v1test2.BotStatus" json:"status,omitempty"`
	// A description of the worker hosting this bot. The Worker message is used
	// here in the Status context (see Worker for more information).  If multiple
	// bots are running on the worker, this field should only describe the
	// resources accessible from this bot.
	//
	// During the call to CreateBotSession, the server may make arbitrary changes
	// to the worker's `server_properties` field (see that field for more
	// information). Otherwise, this field is input-only.
	Worker *Worker `protobuf:"bytes,4,opt,name=worker" json:"worker,omitempty"`
	// A list of all leases that are a part of this session. See the Lease message
	// for details.
	Leases []*Lease `protobuf:"bytes,5,rep,name=leases" json:"leases,omitempty"`
	// The time at which this bot session will expire, unless the bot calls
	// UpdateBotSession again. Output only.
	ExpireTime *google_protobuf4.Timestamp `protobuf:"bytes,6,opt,name=expire_time,json=expireTime" json:"expire_time,omitempty"`
	// The version of the bot code currently running. The server may use this
	// information to issue an admin action to tell the bot to update itself.
	Version string `protobuf:"bytes,7,opt,name=version" json:"version,omitempty"`
}

func (m *BotSession) Reset()                    { *m = BotSession{} }
func (m *BotSession) String() string            { return proto.CompactTextString(m) }
func (*BotSession) ProtoMessage()               {}
func (*BotSession) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *BotSession) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BotSession) GetBotId() string {
	if m != nil {
		return m.BotId
	}
	return ""
}

func (m *BotSession) GetStatus() BotStatus {
	if m != nil {
		return m.Status
	}
	return BotStatus_BOT_STATUS_UNSPECIFIED
}

func (m *BotSession) GetWorker() *Worker {
	if m != nil {
		return m.Worker
	}
	return nil
}

func (m *BotSession) GetLeases() []*Lease {
	if m != nil {
		return m.Leases
	}
	return nil
}

func (m *BotSession) GetExpireTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

func (m *BotSession) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

// A Lease is a lease that the scheduler has assigned to this bot. If the bot
// notices (by UpdateBotSession) that it has any leases in the PENDING state, it
// should call UpdateBotSession to put the leases into the ACTIVE state and
// start executing their assignments.
//
// All fields in this message are output-only, *except* the `state` and `status`
// fields. Note that repeated fields can only be updated as a unit, so on every
// update the bot must provide an update for *all* the leases the server expects
// it to report on.
//
// The scheduler *should* ensure that all leases scheduled to a bot can actually
// be accepted, but race conditions may occur. In such cases, the bot should
// attempt to accept the leases in the order they are listed by the server, to
// allow the server to control priorities.
//
// The server will remove COMPLETED leases from time to time, after which the
// bot shouldn't report on them any more (the server will ignore superfluous
// COMPLETED records).
type Lease struct {
	// The assignment, which is typically a resource that can be accessed through
	// some other services. The assignment must be meaningful to the bot based
	// solely on this name, either because the bot only understands one type of
	// assignment (e.g., tasks served through the Tasks interface) or through some
	// implementation-defined schema.
	//
	// For example, if the worker is executing a Task as defined by the Tasks
	// interface, this field might be projects/{projectid}/tasks/{taskid}.
	// However, it the worker is being assigned pull from a *queue* of tasks, the
	// resource would be the name of the queue, something like
	// projects/{projectid}/locations/{locationid}/queues/{queueid}. That queue
	// may then provide the bot with tasks through another interface, which the
	// bot then processes through the [Tasks]
	// [google.devtools.remoteworkers.v1test2.Tasks] interface.
	//
	// Note that the assignment may be a [full resource name]
	// [https://cloud.google.com/apis/design/resource_names#full_resource_name] if
	// it should be accessed through an endpoint that is not already known to the
	// bot.
	Assignment string `protobuf:"bytes,1,opt,name=assignment" json:"assignment,omitempty"`
	// The state of the lease. See LeaseState for more information.
	State LeaseState `protobuf:"varint,2,opt,name=state,enum=google.devtools.remoteworkers.v1test2.LeaseState" json:"state,omitempty"`
	// The final status of the lease (should be populated by the bot if the state
	// is completed). This is the status of the lease, not of any task represented
	// by the lease. For example, if the bot could not accept the lease because it
	// asked for some resource the bot didn't have, this status will be
	// FAILED_PRECONDITION. But if the assignment in the lease didn't execute
	// correctly, this field will be `OK` while the failure of the assignment must
	// be tracked elsewhere (e.g., through the Tasks interface).
	Status *google_rpc.Status `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	// The requirements that are being claimed by this lease. This field may be
	// omitted by the server if the lease is not pending.
	Requirements *Worker `protobuf:"bytes,4,opt,name=requirements" json:"requirements,omitempty"`
	// The time at which this lease expires. The server *may* extend this over
	// time, but due to race conditions, the bot is not *required* to respect any
	// expiry date except the first one.
	ExpireTime *google_protobuf4.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime" json:"expire_time,omitempty"`
	// While the `assignment` field is a resource name that allows the bot to
	// get the actual assignment, the server can also optionally include the
	// assignment itself inline in order to save a round trip to the server.
	//
	// This doesn't necessarily need to be the resource pointed to by
	// `assignment`. For example, if the assignment is a task, this field could
	// be task.description, not the entire task, since that's all the bot needs
	// to know to get started. As with `assignment` itself, all that's necessary
	// is that the bot knows how to handle the type of message received here.
	//
	// This field may be omitted by the server if the lease is not in the
	// `PENDING` state.
	InlineAssignment *google_protobuf1.Any `protobuf:"bytes,6,opt,name=inline_assignment,json=inlineAssignment" json:"inline_assignment,omitempty"`
}

func (m *Lease) Reset()                    { *m = Lease{} }
func (m *Lease) String() string            { return proto.CompactTextString(m) }
func (*Lease) ProtoMessage()               {}
func (*Lease) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Lease) GetAssignment() string {
	if m != nil {
		return m.Assignment
	}
	return ""
}

func (m *Lease) GetState() LeaseState {
	if m != nil {
		return m.State
	}
	return LeaseState_LEASE_STATE_UNSPECIFIED
}

func (m *Lease) GetStatus() *google_rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Lease) GetRequirements() *Worker {
	if m != nil {
		return m.Requirements
	}
	return nil
}

func (m *Lease) GetExpireTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

func (m *Lease) GetInlineAssignment() *google_protobuf1.Any {
	if m != nil {
		return m.InlineAssignment
	}
	return nil
}

// Describes a worker, which is a list of one or more devices and the
// connections between them. A device could be a computer, a phone, or even an
// accelerator like a GPU; it's up to the farm administrator to decide how to
// model their farm. For example, if a farm only has one type of GPU, the GPU
// could be modelled as a "has_gpu" property on its host computer; if it has
// many subproperties itself, it might be better to model it as a separate
// device.
//
// The first device in the worker is the "primary device" - that is, the device
// running a bot and which is responsible for actually executing commands. All
// other devices are considered to be attached devices, and must be controllable
// by the primary device.
//
// This message (and all its submessages) can be used in two contexts:
//
// * Status: sent by the bot to report the current capabilities of the device to
// allow reservation matching.
// * Request: sent by a client to request a device with certain capabilities in
// a reservation.
//
// Several of the fields in this message have different semantics depending on
// which of which of these contexts it is used. These semantics are described
// below.
//
// Several messages in Worker and its submessages have the concept of keys and
// values, such as `Worker.Property` and `Device.Property`. All keys are simple
// strings, but certain keys are "standard" keys and should be broadly supported
// across farms and implementations; these are listed below each relevant
// message. Bot implementations or farm admins may add *additional* keys, but
// these SHOULD all begin with an underscore so they do not conflict with
// standard keys that may be added in the future.
//
// Keys are not context sensitive.
//
// See http://goo.gl/NurY8g for more information on the Worker message.
type Worker struct {
	// A list of devices; the first device is the primary device. See the `Device`
	// message for more information.
	Devices []*Device `protobuf:"bytes,1,rep,name=devices" json:"devices,omitempty"`
	// A worker may contain "global" properties. For example, certain machines
	// might be reserved for certain types of jobs, like short-running compilation
	// versus long-running integration tests. This property is known as a "pool"
	// and is not related to any one device within the worker; rather, it applies
	// to the worker as a whole.
	//
	// The behaviour of repeated keys is identical to that of Device.Property.
	Properties []*Worker_Property `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty"`
}

func (m *Worker) Reset()                    { *m = Worker{} }
func (m *Worker) String() string            { return proto.CompactTextString(m) }
func (*Worker) ProtoMessage()               {}
func (*Worker) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Worker) GetDevices() []*Device {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *Worker) GetProperties() []*Worker_Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// A global property; see the `properties` field for more information.
type Worker_Property struct {
	// For general information on keys, see the documentation to `Worker`.
	//
	// The current set of standard keys are:
	//
	// * pool: different workers can be reserved for different purposes. For
	// example, an admin might want to segregate long-running integration tests
	// from short-running unit tests, so unit tests will always get some
	// throughput. To support this, the server can assign different values for
	// `pool` (such as "itest" and "utest") to different workers, and then have
	// jobs request workers from those pools.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// The property's value.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Worker_Property) Reset()                    { *m = Worker_Property{} }
func (m *Worker_Property) String() string            { return proto.CompactTextString(m) }
func (*Worker_Property) ProtoMessage()               {}
func (*Worker_Property) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

func (m *Worker_Property) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Worker_Property) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Any device, including computers, phones, accelerators (e.g. GPUs), etc. All
// names must be unique.
type Device struct {
	// The handle can be thought of as the "name" of the device, and must be
	// unique within a Worker.
	//
	// In the Status context, the handle should be some human-understandable name,
	// perhaps corresponding to a label physically written on the device to make
	// it easy to locate. In the Request context, the name should be the
	// *logical* name expected by the task. The bot is responsible for mapping the
	// logical name expected by the task to a machine-readable name that the task
	// can actually use, such as a USB address. The method by which this mapping
	// is communicated to the task is not covered in this API.
	Handle string `protobuf:"bytes,1,opt,name=handle" json:"handle,omitempty"`
	// Properties of this device that don't change based on the tasks that are
	// running on it, e.g. OS, CPU architecture, etc.
	//
	// Keys may be repeated, and have the following interpretation:
	//
	//    * Status context: the device can support *any* the listed values. For
	//    example, an "ISA" property might include "x86", "x86-64" and "sse4".
	//
	//    * Request context: the device *must* support *all* of the listed values.
	Properties []*Device_Property `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty"`
}

func (m *Device) Reset()                    { *m = Device{} }
func (m *Device) String() string            { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()               {}
func (*Device) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Device) GetHandle() string {
	if m != nil {
		return m.Handle
	}
	return ""
}

func (m *Device) GetProperties() []*Device_Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// A device property; see `properties` for more information.
type Device_Property struct {
	// For general information on keys, see the documentation to `Worker`.
	//
	// The current set of standard keys are:
	//
	// * os: a human-readable description of the OS. Examples include `linux`,
	// `ubuntu` and `ubuntu 14.04` (note that a bot may advertise itself as more
	// than one). This will be replaced in the future by more well-structured
	// keys and values to represent OS variants.
	//
	// * has-docker: "true" if the bot has Docker installed. This will be
	// replaced in the future by a more structured message for Docker support.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// The property's value.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Device_Property) Reset()                    { *m = Device_Property{} }
func (m *Device_Property) String() string            { return proto.CompactTextString(m) }
func (*Device_Property) ProtoMessage()               {}
func (*Device_Property) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 0} }

func (m *Device_Property) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Device_Property) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// AdminTemp is a prelimiary set of administration tasks. It's called "Temp"
// because we do not yet know the best way to represent admin tasks; it's
// possible that this will be entirely replaced in later versions of this API.
// If this message proves to be sufficient, it will be renamed in the alpha or
// beta release of this API.
//
// This message (suitably marshalled into a protobuf.Any) can be used as the
// inline_assignment field in a lease; the lease assignment field should simply
// be `"admin"` in these cases.
//
// This message is heavily based on Swarming administration tasks from the LUCI
// project (http://github.com/luci/luci-py/appengine/swarming).
type AdminTemp struct {
	// The admin action; see `Command` for legal values.
	Command AdminTemp_Command `protobuf:"varint,1,opt,name=command,enum=google.devtools.remoteworkers.v1test2.AdminTemp_Command" json:"command,omitempty"`
	// The argument to the admin action; see `Command` for semantics.
	Arg string `protobuf:"bytes,2,opt,name=arg" json:"arg,omitempty"`
}

func (m *AdminTemp) Reset()                    { *m = AdminTemp{} }
func (m *AdminTemp) String() string            { return proto.CompactTextString(m) }
func (*AdminTemp) ProtoMessage()               {}
func (*AdminTemp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *AdminTemp) GetCommand() AdminTemp_Command {
	if m != nil {
		return m.Command
	}
	return AdminTemp_UNSPECIFIED
}

func (m *AdminTemp) GetArg() string {
	if m != nil {
		return m.Arg
	}
	return ""
}

// Request message for CreateBotSession.
type CreateBotSessionRequest struct {
	// The farm resource.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The bot session to create. Server-assigned fields like name must be unset.
	BotSession *BotSession `protobuf:"bytes,2,opt,name=bot_session,json=botSession" json:"bot_session,omitempty"`
}

func (m *CreateBotSessionRequest) Reset()                    { *m = CreateBotSessionRequest{} }
func (m *CreateBotSessionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateBotSessionRequest) ProtoMessage()               {}
func (*CreateBotSessionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CreateBotSessionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateBotSessionRequest) GetBotSession() *BotSession {
	if m != nil {
		return m.BotSession
	}
	return nil
}

// Request message for UpdateBotSession.
type UpdateBotSessionRequest struct {
	// The bot session name. Must match bot_session.name.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The bot session resource to update.
	BotSession *BotSession `protobuf:"bytes,2,opt,name=bot_session,json=botSession" json:"bot_session,omitempty"`
	// The fields on the bot that should be updated. See the BotSession resource
	// for which fields are updatable by which caller.
	UpdateMask *google_protobuf3.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateBotSessionRequest) Reset()                    { *m = UpdateBotSessionRequest{} }
func (m *UpdateBotSessionRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateBotSessionRequest) ProtoMessage()               {}
func (*UpdateBotSessionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *UpdateBotSessionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateBotSessionRequest) GetBotSession() *BotSession {
	if m != nil {
		return m.BotSession
	}
	return nil
}

func (m *UpdateBotSessionRequest) GetUpdateMask() *google_protobuf3.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for PostBotEventTemp
type PostBotEventTempRequest struct {
	// The bot session name.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The type of bot event.
	Type PostBotEventTempRequest_Type `protobuf:"varint,2,opt,name=type,enum=google.devtools.remoteworkers.v1test2.PostBotEventTempRequest_Type" json:"type,omitempty"`
	// A human-readable message.
	Msg string `protobuf:"bytes,3,opt,name=msg" json:"msg,omitempty"`
}

func (m *PostBotEventTempRequest) Reset()                    { *m = PostBotEventTempRequest{} }
func (m *PostBotEventTempRequest) String() string            { return proto.CompactTextString(m) }
func (*PostBotEventTempRequest) ProtoMessage()               {}
func (*PostBotEventTempRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *PostBotEventTempRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PostBotEventTempRequest) GetType() PostBotEventTempRequest_Type {
	if m != nil {
		return m.Type
	}
	return PostBotEventTempRequest_UNSPECIFIED
}

func (m *PostBotEventTempRequest) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func init() {
	proto.RegisterType((*BotSession)(nil), "google.devtools.remoteworkers.v1test2.BotSession")
	proto.RegisterType((*Lease)(nil), "google.devtools.remoteworkers.v1test2.Lease")
	proto.RegisterType((*Worker)(nil), "google.devtools.remoteworkers.v1test2.Worker")
	proto.RegisterType((*Worker_Property)(nil), "google.devtools.remoteworkers.v1test2.Worker.Property")
	proto.RegisterType((*Device)(nil), "google.devtools.remoteworkers.v1test2.Device")
	proto.RegisterType((*Device_Property)(nil), "google.devtools.remoteworkers.v1test2.Device.Property")
	proto.RegisterType((*AdminTemp)(nil), "google.devtools.remoteworkers.v1test2.AdminTemp")
	proto.RegisterType((*CreateBotSessionRequest)(nil), "google.devtools.remoteworkers.v1test2.CreateBotSessionRequest")
	proto.RegisterType((*UpdateBotSessionRequest)(nil), "google.devtools.remoteworkers.v1test2.UpdateBotSessionRequest")
	proto.RegisterType((*PostBotEventTempRequest)(nil), "google.devtools.remoteworkers.v1test2.PostBotEventTempRequest")
	proto.RegisterEnum("google.devtools.remoteworkers.v1test2.BotStatus", BotStatus_name, BotStatus_value)
	proto.RegisterEnum("google.devtools.remoteworkers.v1test2.LeaseState", LeaseState_name, LeaseState_value)
	proto.RegisterEnum("google.devtools.remoteworkers.v1test2.AdminTemp_Command", AdminTemp_Command_name, AdminTemp_Command_value)
	proto.RegisterEnum("google.devtools.remoteworkers.v1test2.PostBotEventTempRequest_Type", PostBotEventTempRequest_Type_name, PostBotEventTempRequest_Type_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Bots service

type BotsClient interface {
	// CreateBotSession is called when the bot first joins the farm, and
	// establishes a session ID to ensure that multiple machines do not register
	// using the same name accidentally.
	CreateBotSession(ctx context.Context, in *CreateBotSessionRequest, opts ...grpc.CallOption) (*BotSession, error)
	// UpdateBotSession must be called periodically by the bot (on a schedule
	// determined by the server) to let the server know about its status, and to
	// pick up new lease requests from the server.
	UpdateBotSession(ctx context.Context, in *UpdateBotSessionRequest, opts ...grpc.CallOption) (*BotSession, error)
	// PostBotEventTemp may be called by the bot to indicate that some exceptional
	// event has occurred. This method is subject to change or removal in future
	// revisions of this API; we may simply want to replace it with StackDriver or
	// some other common interface.
	PostBotEventTemp(ctx context.Context, in *PostBotEventTempRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type botsClient struct {
	cc *grpc.ClientConn
}

func NewBotsClient(cc *grpc.ClientConn) BotsClient {
	return &botsClient{cc}
}

func (c *botsClient) CreateBotSession(ctx context.Context, in *CreateBotSessionRequest, opts ...grpc.CallOption) (*BotSession, error) {
	out := new(BotSession)
	err := grpc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Bots/CreateBotSession", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *botsClient) UpdateBotSession(ctx context.Context, in *UpdateBotSessionRequest, opts ...grpc.CallOption) (*BotSession, error) {
	out := new(BotSession)
	err := grpc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Bots/UpdateBotSession", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *botsClient) PostBotEventTemp(ctx context.Context, in *PostBotEventTempRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Bots/PostBotEventTemp", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Bots service

type BotsServer interface {
	// CreateBotSession is called when the bot first joins the farm, and
	// establishes a session ID to ensure that multiple machines do not register
	// using the same name accidentally.
	CreateBotSession(context.Context, *CreateBotSessionRequest) (*BotSession, error)
	// UpdateBotSession must be called periodically by the bot (on a schedule
	// determined by the server) to let the server know about its status, and to
	// pick up new lease requests from the server.
	UpdateBotSession(context.Context, *UpdateBotSessionRequest) (*BotSession, error)
	// PostBotEventTemp may be called by the bot to indicate that some exceptional
	// event has occurred. This method is subject to change or removal in future
	// revisions of this API; we may simply want to replace it with StackDriver or
	// some other common interface.
	PostBotEventTemp(context.Context, *PostBotEventTempRequest) (*google_protobuf2.Empty, error)
}

func RegisterBotsServer(s *grpc.Server, srv BotsServer) {
	s.RegisterService(&_Bots_serviceDesc, srv)
}

func _Bots_CreateBotSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBotSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BotsServer).CreateBotSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Bots/CreateBotSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BotsServer).CreateBotSession(ctx, req.(*CreateBotSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bots_UpdateBotSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBotSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BotsServer).UpdateBotSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Bots/UpdateBotSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BotsServer).UpdateBotSession(ctx, req.(*UpdateBotSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bots_PostBotEventTemp_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PostBotEventTempRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BotsServer).PostBotEventTemp(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Bots/PostBotEventTemp",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BotsServer).PostBotEventTemp(ctx, req.(*PostBotEventTempRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Bots_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteworkers.v1test2.Bots",
	HandlerType: (*BotsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBotSession",
			Handler:    _Bots_CreateBotSession_Handler,
		},
		{
			MethodName: "UpdateBotSession",
			Handler:    _Bots_UpdateBotSession_Handler,
		},
		{
			MethodName: "PostBotEventTemp",
			Handler:    _Bots_PostBotEventTemp_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteworkers/v1test2/bots.proto",
}

func init() { proto.RegisterFile("google/devtools/remoteworkers/v1test2/bots.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1083 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xdd, 0x8e, 0xdb, 0x44,
	0x14, 0xc6, 0xd9, 0xc4, 0x69, 0x4e, 0xda, 0xad, 0x3b, 0x94, 0x6e, 0x48, 0x11, 0x44, 0x96, 0x90,
	0x56, 0x51, 0xb1, 0xdb, 0x20, 0x10, 0x6a, 0x55, 0x24, 0x27, 0xf1, 0xee, 0x46, 0x64, 0x93, 0x30,
	0xf1, 0xb6, 0x82, 0x9b, 0xd4, 0xd9, 0x4c, 0x83, 0xb5, 0xb1, 0xc7, 0xf5, 0x4c, 0x02, 0x11, 0xea,
	0x0d, 0x12, 0x4f, 0xc0, 0x13, 0x70, 0xc7, 0x05, 0x8f, 0x80, 0xb8, 0xe4, 0x05, 0x7a, 0xcd, 0x1d,
	0x5c, 0xf3, 0x0a, 0x68, 0xc6, 0x76, 0xfe, 0xb6, 0x4b, 0xb3, 0x14, 0xee, 0xe6, 0xe7, 0x7c, 0xdf,
	0xf9, 0xfc, 0xcd, 0x39, 0xe3, 0x81, 0xbb, 0x63, 0x4a, 0xc7, 0x13, 0x62, 0x8e, 0xc8, 0x8c, 0x53,
	0x3a, 0x61, 0x66, 0x44, 0x7c, 0xca, 0xc9, 0xd7, 0x34, 0x3a, 0x23, 0x11, 0x33, 0x67, 0xf7, 0x38,
	0x61, 0xbc, 0x66, 0x0e, 0x29, 0x67, 0x46, 0x18, 0x51, 0x4e, 0xd1, 0xfb, 0x31, 0xc2, 0x48, 0x11,
	0xc6, 0x1a, 0xc2, 0x48, 0x10, 0xe5, 0x77, 0x12, 0x62, 0x37, 0xf4, 0x4c, 0x37, 0x08, 0x28, 0x77,
	0xb9, 0x47, 0x83, 0x84, 0xa4, 0xfc, 0x76, 0xb2, 0x2b, 0x67, 0xc3, 0xe9, 0x53, 0xd3, 0x0d, 0xe6,
	0xc9, 0xd6, 0xed, 0xcd, 0x2d, 0xe2, 0x87, 0x3c, 0xdd, 0xac, 0x6c, 0x6e, 0x3e, 0xf5, 0xc8, 0x64,
	0x34, 0xf0, 0x5d, 0x76, 0x96, 0x44, 0xbc, 0xb7, 0x19, 0xc1, 0x3d, 0x9f, 0x30, 0xee, 0xfa, 0x61,
	0x12, 0xb0, 0x97, 0x04, 0x44, 0xe1, 0xa9, 0xc9, 0xb8, 0xcb, 0xa7, 0x89, 0x26, 0xfd, 0xcf, 0x0c,
	0x40, 0x9d, 0xf2, 0x3e, 0x61, 0xcc, 0xa3, 0x01, 0x42, 0x90, 0x0d, 0x5c, 0x9f, 0x94, 0x94, 0x8a,
	0xb2, 0x5f, 0xc0, 0x72, 0x8c, 0xde, 0x02, 0x75, 0x48, 0xf9, 0xc0, 0x1b, 0x95, 0x32, 0x72, 0x35,
	0x37, 0xa4, 0xbc, 0x35, 0x42, 0x47, 0xa0, 0xc6, 0x4c, 0xa5, 0x9d, 0x8a, 0xb2, 0xbf, 0x5b, 0xbb,
	0x6b, 0x6c, 0xe5, 0x91, 0x21, 0xb2, 0x49, 0x1c, 0x4e, 0xf0, 0xc8, 0x06, 0x35, 0x0e, 0x2a, 0x65,
	0x2b, 0xca, 0x7e, 0xb1, 0xf6, 0xc1, 0x96, 0x4c, 0x8f, 0xe5, 0x1c, 0x27, 0x60, 0xd4, 0x04, 0x75,
	0x42, 0x5c, 0x46, 0x58, 0x29, 0x57, 0xd9, 0xd9, 0x2f, 0xd6, 0xee, 0x6c, 0x49, 0xd3, 0x16, 0x20,
	0x9c, 0x60, 0xd1, 0x03, 0x28, 0x92, 0x6f, 0x42, 0x2f, 0x22, 0x03, 0xe1, 0x61, 0x49, 0x95, 0x8a,
	0xca, 0x29, 0x55, 0x6a, 0xb0, 0xe1, 0xa4, 0x06, 0x63, 0x88, 0xc3, 0xc5, 0x02, 0x2a, 0x41, 0x7e,
	0x46, 0x22, 0xe1, 0x64, 0x29, 0x2f, 0xbd, 0x4a, 0xa7, 0xfa, 0x5f, 0x19, 0xc8, 0xc9, 0x44, 0xe8,
	0x5d, 0x00, 0x97, 0x31, 0x6f, 0x1c, 0xf8, 0x24, 0xe0, 0x89, 0xd1, 0x2b, 0x2b, 0xe8, 0x10, 0x72,
	0xc2, 0x17, 0x22, 0xdd, 0xde, 0xad, 0xdd, 0xbb, 0xcc, 0x57, 0x08, 0x63, 0x09, 0x8e, 0xf1, 0xa8,
	0xba, 0x76, 0x40, 0xc5, 0x1a, 0x4a, 0x99, 0xa2, 0xf0, 0xd4, 0xd8, 0x38, 0x82, 0xcf, 0xe1, 0x6a,
	0x44, 0x9e, 0x4d, 0xbd, 0x88, 0x08, 0x0d, 0xec, 0xdf, 0x1d, 0xc4, 0x1a, 0xc5, 0xa6, 0x91, 0xb9,
	0x4b, 0x19, 0x69, 0xc1, 0x0d, 0x2f, 0x98, 0x78, 0x01, 0x19, 0xac, 0x78, 0x15, 0x9f, 0xc5, 0xcd,
	0x73, 0x14, 0x56, 0x30, 0xc7, 0x5a, 0x1c, 0x6e, 0x2d, 0xa2, 0xf5, 0xdf, 0x15, 0x50, 0x63, 0x61,
	0xe8, 0x10, 0xf2, 0x23, 0x32, 0xf3, 0x4e, 0x09, 0x2b, 0x29, 0xb2, 0x34, 0xb6, 0xfd, 0xb0, 0xa6,
	0x44, 0xe1, 0x14, 0x8d, 0x1e, 0x01, 0x84, 0x11, 0x0d, 0x49, 0xc4, 0x3d, 0xc2, 0x4a, 0x19, 0xc9,
	0xf5, 0xf1, 0xa5, 0x4c, 0x32, 0x7a, 0x31, 0x7e, 0x8e, 0x57, 0x98, 0xca, 0x35, 0xb8, 0x92, 0xae,
	0x23, 0x0d, 0x76, 0xce, 0xc8, 0x3c, 0x29, 0x0c, 0x31, 0x44, 0x37, 0x21, 0x37, 0x73, 0x27, 0x53,
	0x92, 0xf6, 0x9f, 0x9c, 0xe8, 0x3f, 0x2b, 0xa0, 0xc6, 0xfa, 0xd0, 0x2d, 0x50, 0xbf, 0x72, 0x83,
	0xd1, 0x24, 0xed, 0xdb, 0x64, 0xf6, 0x5a, 0x72, 0x63, 0xea, 0xff, 0x4e, 0xee, 0x0b, 0x05, 0x0a,
	0xd6, 0xc8, 0xf7, 0x02, 0x87, 0xf8, 0x21, 0xc2, 0x90, 0x3f, 0xa5, 0xbe, 0xef, 0x06, 0x23, 0x89,
	0xdc, 0xad, 0x7d, 0xb2, 0xa5, 0xac, 0x05, 0x85, 0xd1, 0x88, 0xf1, 0x38, 0x25, 0x12, 0x4a, 0xdc,
	0x68, 0x9c, 0x64, 0x15, 0x43, 0xfd, 0x09, 0xe4, 0x93, 0x28, 0x74, 0x1d, 0x8a, 0x27, 0x9d, 0x7e,
	0xcf, 0x6e, 0xb4, 0x0e, 0x5a, 0x76, 0x53, 0x7b, 0x03, 0xed, 0x02, 0xd4, 0xbb, 0xce, 0xe0, 0xa4,
	0xd7, 0xb4, 0x1c, 0x5b, 0x53, 0x44, 0x80, 0x98, 0x63, 0xbb, 0xef, 0x58, 0xd8, 0xd1, 0x32, 0xe8,
	0x06, 0x5c, 0x13, 0x0b, 0x8e, 0x8d, 0x8f, 0x5b, 0x1d, 0x11, 0xb3, 0x83, 0x34, 0xb8, 0x7a, 0xd4,
	0xed, 0x2f, 0x83, 0xb2, 0xfa, 0xf7, 0x0a, 0xec, 0x35, 0x22, 0xe2, 0x72, 0xb2, 0xbc, 0x44, 0x31,
	0x79, 0x36, 0x25, 0x8c, 0x8b, 0x53, 0x09, 0xdd, 0x68, 0xd9, 0xe4, 0xc9, 0x0c, 0x61, 0x28, 0x8a,
	0xfb, 0x94, 0xc5, 0xd1, 0x52, 0x6f, 0x71, 0xeb, 0x36, 0x5f, 0x49, 0x03, 0xc3, 0xc5, 0x58, 0xff,
	0x55, 0x81, 0xbd, 0x93, 0x70, 0xf4, 0x52, 0x1d, 0x2f, 0xbb, 0xd3, 0xff, 0x07, 0x0d, 0xa2, 0xe1,
	0xa7, 0x52, 0x82, 0xfc, 0x33, 0x25, 0x97, 0xce, 0xf9, 0x86, 0x3f, 0x10, 0x3f, 0xaf, 0x63, 0x97,
	0x9d, 0x61, 0x88, 0xc3, 0xc5, 0x58, 0xff, 0x4d, 0x81, 0xbd, 0x1e, 0x65, 0xbc, 0x4e, 0xb9, 0x3d,
	0x23, 0x01, 0x17, 0x47, 0xfc, 0x4f, 0x1f, 0xf0, 0x18, 0xb2, 0x7c, 0x1e, 0xa6, 0x97, 0x64, 0x63,
	0x4b, 0xe5, 0x17, 0x64, 0x30, 0x9c, 0x79, 0x48, 0xb0, 0x24, 0x14, 0x55, 0xe4, 0xb3, 0xb1, 0x54,
	0x5f, 0xc0, 0x62, 0xa8, 0xdf, 0x81, 0xac, 0xd8, 0x3f, 0x5f, 0x42, 0x57, 0x20, 0xdb, 0xea, 0x1c,
	0x74, 0x35, 0x05, 0x15, 0x20, 0x67, 0x63, 0xdc, 0xc5, 0x5a, 0xa6, 0x3a, 0x86, 0xc2, 0xe2, 0x0f,
	0x87, 0xca, 0x70, 0x4b, 0xd4, 0x50, 0xdf, 0xb1, 0x9c, 0x93, 0xfe, 0x60, 0x1d, 0xad, 0x42, 0xa6,
	0xfb, 0x99, 0xa6, 0xa0, 0x6b, 0x50, 0x38, 0xe9, 0x1c, 0xd9, 0x56, 0xdb, 0x39, 0xfa, 0x42, 0xcb,
	0x20, 0x04, 0xbb, 0x49, 0x8d, 0xd5, 0xbb, 0x5d, 0xa7, 0xd5, 0x39, 0xd4, 0x76, 0xd0, 0x9b, 0x70,
	0x7d, 0xb5, 0x14, 0xc5, 0x62, 0xb6, 0xfa, 0x04, 0x60, 0x79, 0xe7, 0xa3, 0xdb, 0xb0, 0xd7, 0xb6,
	0xad, 0xbe, 0x2d, 0x73, 0xd9, 0x1b, 0xa9, 0x8a, 0x90, 0xef, 0xd9, 0x9d, 0xa6, 0xc0, 0x29, 0x08,
	0x40, 0xb5, 0x1a, 0x4e, 0xeb, 0x91, 0xad, 0x65, 0x44, 0xee, 0x46, 0xf7, 0xb8, 0xd7, 0xb6, 0x1d,
	0xbb, 0xa9, 0x65, 0xe5, 0xd4, 0xea, 0x34, 0xec, 0x76, 0xdb, 0x6e, 0x6a, 0xb9, 0xda, 0x4f, 0x59,
	0xc8, 0xd6, 0x29, 0x67, 0xe8, 0x17, 0x05, 0xb4, 0xcd, 0x2a, 0x47, 0x9f, 0x6e, 0xe9, 0xf9, 0x05,
	0xed, 0x51, 0xbe, 0x7c, 0xb5, 0xe9, 0x1f, 0x7d, 0xf7, 0xe2, 0x8f, 0x1f, 0x32, 0xa6, 0x5e, 0x59,
	0x3c, 0xd1, 0xbe, 0x8d, 0x7b, 0xea, 0x61, 0xb5, 0xfa, 0xdc, 0x5c, 0x96, 0x22, 0xbb, 0xbf, 0x5a,
	0xdd, 0x52, 0xfe, 0x66, 0x73, 0x6c, 0x2d, 0xff, 0x82, 0xae, 0x7a, 0x0d, 0xf9, 0xb5, 0x15, 0xf9,
	0xa2, 0x96, 0x1f, 0x56, 0xab, 0xab, 0xda, 0xcd, 0xea, 0xf3, 0x75, 0xf9, 0x3f, 0x2a, 0xa0, 0x6d,
	0x16, 0xee, 0xd6, 0xf2, 0x2f, 0xa8, 0xf8, 0xf2, 0xad, 0x73, 0x7d, 0x69, 0x8b, 0x17, 0xe7, 0xc2,
	0xe2, 0xea, 0x2b, 0x35, 0x86, 0x94, 0xc5, 0xb4, 0xf7, 0x95, 0x6a, 0xdd, 0xf9, 0x12, 0x27, 0x7c,
	0x63, 0x3a, 0x71, 0x83, 0xb1, 0x41, 0xa3, 0xb1, 0x39, 0x26, 0x81, 0x64, 0x37, 0xe3, 0x2d, 0x37,
	0xf4, 0xd8, 0x2b, 0x9e, 0xdc, 0x0f, 0xd6, 0x56, 0x87, 0xaa, 0x84, 0x7f, 0xf8, 0x77, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x7c, 0xc5, 0x7e, 0x38, 0xb0, 0x0b, 0x00, 0x00,
}
