# -*- encoding: UTF-8 -*-
import uno, re, sys, os, traceback
from com.sun.star.text.TextMarkupType import PROOFREADING
from com.sun.star.beans import PropertyValue

pkg = "pt_BR"
lang = "pt"
locales = {'pt-BR': ['pt', 'BR', '']}
version = "0.4.3"
author = "Raimundo Santos Moura"
name = "Lightproof grammar checker (Portuguese Brazilian)"

import lightproof_handler_pt_BR

# loaded rules (check for Update mechanism of the editor)
try:
    langrule
except NameError:
    langrule = {}

# ignored rules
ignore = {}

# cache for morphogical analyses
analyses = {}
stems = {}
suggestions = {}

# assign Calc functions
calcfunc = None

SMGR = None

# check settings
def option(lang, opt):
    return lightproof_handler_pt_BR.get_option(lang.Language + "_" + lang.Country, opt)

# filtering affix fields (ds, is, ts etc.)
def onlymorph(st):
    if st != None:
        st = re.sub(r"^.*(st:|po:)", r"\\1", st) # keep last word part
        st = re.sub(r"\\b(?=[dit][sp]:)","@", st) # and its affixes
        st = re.sub(r"(?<!@)\\b\w\w:\w+","", st).replace('@','').strip()
    return st

# if the pattern matches all analyses of the input word, 
# return the last matched substring
def _morph(rLoc, word, pattern, all, onlyaffix):
    global analyses
    if not word:
        return None
    if word not in analyses:
        x = spellchecker.spell(u"<?xml?><query type='analyze'><word>" + word + "</word></query>", rLoc, ())
        if not x:
            return None
        t = x.getAlternatives()
        if not t:
            t = [""]
        analyses[word] = t[0].split("</a>")[:-1]
    a = analyses[word]
    result = None
    p = re.compile(pattern)
    for i in a:
        if onlyaffix:
            i = onlymorph(i)
        result = p.search(i)
        if result:
            result = result.group(0)
            if not all:
                return result
        elif all:
            return None
    return result

def morph(rLoc, word, pattern, all=True):
    return _morph(rLoc, word, pattern, all, False)

def affix(rLoc, word, pattern, all=True):
    return _morph(rLoc, word, pattern, all, True)

def spell(rLoc, word):
    if not word:
        return None
    return spellchecker.isValid(word, rLoc, ())

# get the tuple of the stem of the word or an empty array
def stem(rLoc, word):
    global stems
    if not word:
        return []
    if not word in stems:
        x = spellchecker.spell(u"<?xml?><query type='stem'><word>" + word + "</word></query>", rLoc, ())
        if not x:
            return []
        t = x.getAlternatives()
        if not t:
            t = []
        stems[word] = list(t)
    return stems[word]

# get the tuple of the morphological generation of a word or an empty array
def generate(rLoc, word, example):
    if not word:
        return []
    x = spellchecker.spell(u"<?xml?><query type='generate'><word>" + word + "</word><word>" + example + "</word></query>", rLoc, ())
    if not x:
        return []
    t = x.getAlternatives()
    if not t:
        t = []
    return list(t)

# get suggestions
def suggest(rLoc, word):
    global suggestions
    if not word:
        return word
    if word not in suggestions:
        x = spellchecker.spell("_" + word, rLoc, ())
        if not x:
            return word
        t = x.getAlternatives()
        suggestions[word] = "\\n".join(t)
    return suggestions[word]

# get the nth word of the input string or None
def word(s, n):
    a = re.match("(?u)( [-.\w%%]+){" + str(n-1) + "}( [-.\w%%]+)", s)
    if not a:
        return ''
    return a.group(2)[1:]

# get the (-)nth word of the input string or None
def wordmin(s, n):
    a = re.search("(?u)([-.\w%%]+ )([-.\w%%]+ ){" + str(n-1) + "}$", s)
    if not a:
        return ''
    return a.group(1)[:-1]

def calc(funcname, par):
    global calcfunc
    global SMGR
    if calcfunc == None:
        calcfunc = SMGR.createInstance( "com.sun.star.sheet.FunctionAccess")
        if calcfunc == None:
                return None
    return calcfunc.callFunction(funcname, par)

def proofread( nDocId, TEXT, LOCALE, nStartOfSentencePos, nSuggestedSentenceEndPos, rProperties ):
    global ignore
    aErrs = []
    s = TEXT[nStartOfSentencePos:nSuggestedSentenceEndPos]
    for i in get_rule(LOCALE).dic:
        # 0: regex,  1: replacement,  2: message,  3: condition,  4: ngroup,  (5: oldline),  6: case sensitive ?
        if i[0] and not str(i[0]) in ignore:
            for m in i[0].finditer(s):
                try:
                    if not i[3] or eval(i[3]):
                        aErr = uno.createUnoStruct( "com.sun.star.linguistic2.SingleProofreadingError" )
                        aErr.nErrorStart        = nStartOfSentencePos + m.start(i[4]) # nStartOfSentencePos
                        aErr.nErrorLength       = m.end(i[4]) - m.start(i[4])
                        aErr.nErrorType         = PROOFREADING
                        aErr.aRuleIdentifier    = str(i[0])
                        iscap = (i[-1] and m.group(i[4])[0:1].isupper())
                        if i[1][0:1] == "=":
                            aErr.aSuggestions = tuple(cap(eval(i[1][1:]).replace('|', "\n").split("\n"), iscap, LOCALE))
                        elif i[1] == "_":
                            aErr.aSuggestions = ()
                        else:
                            aErr.aSuggestions = tuple(cap(m.expand(i[1]).replace('|', "\n").split("\n"), iscap, LOCALE))
                        comment = i[2]
                        if comment[0:1] == "=":
                            comment = eval(comment[1:])
                        else:
                            comment = m.expand(comment)
                        aErr.aShortComment      = comment.replace('|', '\n').replace('\\n', '\n').split("\n")[0].strip()
                        aErr.aFullComment       = comment.replace('|', '\n').replace('\\n', '\n').split("\n")[-1].strip()
                        if "://" in aErr.aFullComment:
                            p = PropertyValue()
                            p.Name = "FullCommentURL"
                            p.Value = aErr.aFullComment
                            aErr.aFullComment = aErr.aShortComment
                            aErr.aProperties        = (p,)
                        else:
                            aErr.aProperties        = ()
                        aErrs = aErrs + [aErr]
                except Exception as e:
                    if len(i) == 7:
                        raise Exception(str(e), i[5])
                    raise

    return tuple(aErrs)

def cap(a, iscap, rLoc):
    if iscap:
        for i in range(0, len(a)):
            if a[i][0:1] == "i":
                if rLoc.Language == "tr" or rLoc.Language == "az":
                    a[i] = u"\u0130" + a[i][1:]
                elif a[i][1:2] == "j" and rLoc.Language == "nl":
                    a[i] = "IJ" + a[i][2:]
                else:
                    a[i] = "I" + a[i][1:]
            else:
                a[i] = a[i].capitalize()
    return a

def compile_rules(dic):
    # compile regular expressions
    for i in dic:
        try:
            if re.compile("[(][?]iu[)]").match(i[0]):
                i += [True]
                i[0] = re.sub("[(][?]iu[)]", "(?u)", i[0])
            else:
                i += [False]
            i[0] = re.compile(i[0])
        except:
            if 'PYUNO_LOGLEVEL' in os.environ:
                print("Lightproof: bad regular expression: ", traceback.format_exc())
            i[0] = None

def get_rule(loc):
    try:
        return langrule[pkg]
    except:
        langrule[pkg] = __import__("lightproof_" + pkg)
        compile_rules(langrule[pkg].dic)
    return langrule[pkg]

def get_path():
    return os.path.join(os.path.dirname(sys.modules[__name__].__file__), __name__ + ".py")

# [code]

# Abreviacoes em Portugues - Brasil 
abbrev = re.compile("(?i)\\b([a-zA-Z]|it|\xedt|Jr|lb|ll|lr|mk|MM|Mr|ob|Ob|of|Of|op|Op|or|oz|pa|p\xE7|Pe|pf|pg|pl|pm|pp|pr|Pr|ql|Rd|rg|sc|sf|sg|sr|ss|SS|tr|TT|tv|un|vb|vc|vj|Vj|vl|vo|zo|abr|Abr|abs|adj|adm|adv|alt|ant|art|Art|ass|Ass|atm|Att|aux|Aux|bat|bbl|Bel|b\xedb|bim|biz|bol|bot|btl|bud|cab|ca\xE7|cad|caf|c\xe2m|can|cap|car|cat|Cat|cau|cav|cel|c\xean|cet|cfr|cid|cig|cin|cir|cit|civ|cob|c\xf3d|col|Col|con|c\xf4n|C\xf4n|cop|coq|cos|cot|c\xf4v|ctv|cul|cut|cvs|dad|dat|dec|Dec|ded|def|dem|dep|Dep|des|det|dev|dic|Dic|did|dif|Dif|dim|din|dir|doc|dog|d\xf3l|dom|d\xf3r|dra|Dra|Drs|dur|ecd|ecl|\xe9cl|edd|emb|Emb|emp|enc|End|enf|eng|Eng|ens|ent|enx|esc|Esc|esl|esp|Esp|esq|est|Est|etc|etn|\xe9tn|euf|eur|Exa|exe|exp|ext|f\xe1b|fac|fam|fed|fem|fen|fer|fev|Fev|fig|fil|fin|f\xeds|fls|fog|fol|fos|fot|fov|fss|fut|gal|Gal|gar|gat|gav|gen|Gen|g\xean|ger|gin|g\xedr|g\xf3t|gov|Gov|grd|guz|hab|hag|her|het|hib|h\xedb|hig|hip|h\xedp|hom|hon|hot|iat|ict|igr|imp|inc|ind|\xednd|inf|ing|ins|int|inv|iog|irl|irr|isl|isr|iug|jam|jan|jap|jav|jes|joc|jog|jud|jul|jun|jur|lab|lad|l\xe2m|lap|lat|leg|l\xe9g|let|lex|lib|lig|lim|lin|l\xedq|lit|Lit|liv|loc|log|l\xf3g|loq|Ltd|lug|lut|luv|ma\xE7|mad|mag|mai|Mai|maj|Maj|man|map|maq|m\xe1q|mat|Mat|m\xe1x|mct|mec|med|Med|m\xe9d|mem|mer|met|mex|m\xedn|mit|mob|mod|mon|mov|Mrs|mun|m\xfas|nac|nap|nat|n\xe1u|nav|naz|neg|nep|nig|nob|nom|nor|nov|Nov|n\xfam|obr|Obr|obs|Obs|oft|on\xE7|opp|\xf3pt|ord|org|orn|ort|our|out|pag|p\xe1g|P\xe1g|paq|p\xE7a|P\xE7a|pdl|pec|ped|pej|pel|pen|peq|p\xe9r|pes|pet|p\xedl|pol|Pol|pot|pov|Pov|pto|pts|pub|p\xfab|P\xfab|pug|qua|qui|qu\xed|rac|r\xe1d|rec|red|ref|reg|rel|rem|rep|res|ret|rev|rib|rit|rod|rot|rub|rur|sab|S\xe1b|sac|san|s\xe2n|sap|s\xe1t|sch|scr|sec|Sec|seg|sel|sen|Sen|sep|seq|s\xe9r|set|sex|sib|sid|s\xedl|sin|sir|s\xedr|sit|Snr|soc|Soc|s\xf3l|son|S\xf3r|sov|spp|sra|sto|suc|Suc|suf|suj|S\xfam|sup|S\xfav|tab|t\xe1b|tam|t\xe2m|tan|t\xe1t|tec|t\xe9c|tel|Tel|ten|Ten|ter|tes|tib|tip|tir|t\xedt|ton|t\xf4n|t\xf3p|tox|tun|tup|tur|ucr|ult|umb|urb|vad|veg|vel|ven|vet|vid|Vid|vig|Vig|vin|vit|Vit|viz|voc|vog|vol|vox|xin|adit|antr|arom|arts|at\xf4m|bact|b\xe1lt|b\xe1rb|basq|beir|beng|berb|bibl|b\xedbl|B\xedbl|bien|biol|biom|bioq|biot|birm|bisp|bitr|bo\xeam|bomb|bord|borg|borr|bras|Bras|bret|brig|Brig|brit|brom|Bros|b\xfalg|burl|cal\xE7|c\xe1lc|cald|calv|cant|caps|capt|card|carn|carp|carr|cart|cast|caus|celt|c\xe9lt|cent|c\xeant|cerv|cest|chap|chil|chin|chul|cicl|cien|cing|cinz|circ|c\xedrc|citt|clas|cl\xe1s|clim|cl\xedn|c\xf3ds|cogn|cols|comb|comp|conc|cond|conf|cong|conj|Conj|conq|cons|cont|corp|corr|corv|Corv|cosm|cost|cr\xe9d|crim|cr\xf4n|cult|curt|cyat|decl|decr|Decr|dens|depr|deps|dept|derm|desc|desp|di\xe1c|dial|dioc|dipl|disc|diss|docs|dogm|dpto|Dpto|dram|drav|ecol|econ|Econ|edif|Edif|educ|efem|eg\xedp|embr|emol|empr|epig|erud|escr|esgr|esot|estr|etim|etol|exag|excl|expl|expr|falc|farm|fasc|fauv|feit|feud|figd|finl|fisc|fisl|flam|flum|fluv|folc|folh|fols|form|f\xf3rm|fort|frac|frag|freg|freq|frig|frut|fulv|fund|futb|ga\xe9l|galv|gasc|gaul|geod|geof|geog|geol|geom|geon|ge\xf4n|germ|gl\xf3t|gnom|graf|gr\xe1f|grav|guat|guin|gutt|hast|hebd|hebr|helm|herb|herp|hibr|h\xedbr|hidr|hier|higr|hind|hisp|hist|hond|hort|h\xfang|ib\xe9r|ibid|idol|Ilmo|ilum|imit|impr|incs|infl|ingl|Insc|inst|intj|intr|inus|iran|iraq|iron|ir\xf4n|ital|it\xe1l|jard|jorn|just|lact|lanc|lan\xE7|larg|laud|l\xe9gs|leit|ling|l\xedng|livr|Livr|lomb|long|ltda|Ltda|lund|lunf|magn|malg|malh|marc|marg|marn|marr|marx|masc|medv|memo|mens|merc|metr|m\xe9tr|ming|minh|mist|m\xedst|mMin|moag|moed|mont|morf|mult|n\xe1ua|n\xe1ut|neur|n\xf3rd|norm|nucl|nutr|obed|obst|ocid|ocul|ofid|olig|onom|opos|orat|orig|orog|or\xf4n|ostr|pagg|p\xe1gg|p\xe1gs|pals|parl|parn|part|pass|past|patr|p\xe1tr|pedr|pent|perf|pern|pers|p\xe9rs|pesc|pesq|pess|petr|pgto|pint|pinx|pisc|pizz|plat|pleb|po\xe9t|port|poss|pr\xe1c|pr\xe1t|prec|pred|pref|Pref|prep|pres|Pres|pret|prev|prim|priv|proc|prod|prof|Prof|prom|pron|prop|prot|pr\xf3t|prov|prox|psic|psiq|p\xfabl|pulv|qu\xedm|rall|refl|Resp|RESP|rest|romn|russ|r\xfast|sagr|sals|s\xe2ns|Sarg|scul|secr|sect|segg|segs|sent|seqq|serg|serr|serv|s\xe9rv|sign|silv|simb|s\xedmb|sing|Sing|sint|s\xednt|sist|sost|Sras|Sres|srta|stac|subj|suec|suff|supl|surr|tail|tang|tard|taur|teat|tecn|t\xe9cn|tect|temp|teol|te\xf4n|teos|term|t\xe9rm|terr|test|t\xeaxt|tint|torp|tosc|trab|trad|tr\xe1f|trat|Trav|trib|trig|trim|trit|triv|trop|turc|unid|unif|univ|urol|urug|utop|vadm|vasc|vect|vend|verb|vern|vers|vidr|viol|vitr|voll|vols|vulc|vulg|zend|zool|zoot|abrev|Abrev|Admin|anton|apass|aprox|Aprox|autom|Autom|bimen|biogr|bispd|boliv|buroc|calig|canad|capac|capit|capix|catal|categ|Catol|cat\xf3l|cat\xf3p|cenog|centr|cer\xe2m|chanc|cienc|ci\xeanc|cient|cineg|cinem|cinol|citol|cl\xe1ss|clich|colet|compl|compr|compt|comte|concl|concr|confl|const|Const|contr|coord|Coord|copul|corog|cosec|cresc|cript|crist|crust|culin|cutel|dasim|decor|defin|democ|demog|depto|deriv|descr|desen|desin|desus|did\xe1t|dimin|dinam|din\xe2m|distr|docum|domin|dom\xedn|ecles|eletr|el\xe9tr|elipt|embal|emigr|emp\xedr|endoc|energ|entom|epigr|ep\xedst|equat|equit|equiv|escoc|escul|eslav|eslov|espec|espel|espet|espir|estad|estat|est\xe9t|estil|estim|eston|estud|eti\xf3p|etnog|etnol|eufem|euf\xeam|eufon|euf\xf4n|eufor|ex\xe9rc|exper|fascs|fenom|fen\xf4m|figur|filat|filol|fitog|folcl|fon\xe9t|fonol|fotom|fracc|franc|fr\xe2nc|futeb|futur|galic|gen\xe9t|genov|geogn|geogr|ginec|gloss|groen|Hares|heort|her\xe1l|hip\xe1l|hipoc|hipol|hipot|hip\xf3t|homof|homog|homon|hom\xf4n|idiot|Ilmos|imigr|imper|inc\xf3g|indef|indet|indiv|indon|indum|infan|infer|infin|inscr|insep|irreg|islam|joalh|lapid|latit|limit|liter|litog|litol|litur|ludol|lusit|ma\xE7on|malab|malac|manuf|march|marin|mar\xedt|matad|mater|mecan|mec\xe2n|memor|merid|metaf|met\xe1f|met\xe1t|meton|mexic|micol|miner|mitol|mit\xf4n|monog|natur|neerl|neutr|nobil|notic|numis|obsol|ocean|ocult|odont|oneol|optat|ordin|orign|ornit|orogr|ortop|otorr|ouriv|parag|par\xe1g|Par\xe1g|paran|par\xf4n|passm|passr|passt|patol|pedag|pedol|per\xedf|peruv|pirot|pol\xedc|polin|pol\xedt|popul|posit|potam|presc|prest|princ|probl|propr|prosc|prost|provb|provc|prov\xE7|pseud|quant|Quant|quart|quest|qu\xedch|quimb|quinz|recip|rec\xedp|regim|rela\xE7|relat|relig|reloj|rep\xfab|restr|ret\xf3r|Rio-S|sapat|semic|semin|semit|sem\xedt|seric|sider|sigil|silog|simpl|sin\xe9d|sinon|sin\xf4n|Srtas|subst|suprf|suprl|suprs|taxid|teatr|tecel|tecgo|tecna|telec|telef|teleg|telev|terap|terat|tibet|tipol|topog|topol|topon|top\xf4n|tunis|ucran|urban|ut\xf3pi|veloc|venat|venez|veros|veter|vinic|vitic|volat|xenof|xerog|xilog|advers|bacter|bal\xedst|biblog|biblol|biblon|biodim|biof\xeds|biogen|biog\xean|biogeo|biotip|birrel|bromat|calcog|caligr|calvin|casu\xeds|catacr|cat\xf3pt|cibern|cirurg|colomb|combin|comdor|comend|comerc|compar|condic|confed|Confed|confls|conhec|conjug|consec|consel|conseq|constr|contab|coreog|corogr|corrup|corrut|cosmog|cosmol|cronol|cronom|cron\xf4n|declin|defect|democr|demogr|deprec|desemb|Desemb|determ|dialet|dial\xe9t|diplom|disfem|dogm\xe1t|dualid|empr\xe9s|encicl|enc\xedcl|escand|escult|espect|esport|estrat|estrut|etimol|etnogr|exclam|excurs|explet|explor|explos|export|extens|extrat|farmac|ferrad|ferrov|fisioc|fisiol|fispat|fitogr|floric|flumin|formul|forrag|fotoan|fotogr|frenol|frut\xedf|geneal|geof\xeds|geomor|gin\xe1st|glotol|grafol|groenl|guatem|hagiog|hagiol|haplol|helmin|her\xe1ld|herpet|herp\xe9t|hibrid|hidrod|hidrog|hidrom|hidrot|hier\xf4n|hip\xe9rb|hipiat|hipnot|histol|homeop|homogr|hortic|hotent|iconog|iconol|idolol|ilustr|imperf|impess|import|impres|improp|impror|incoat|indian|indoch|indost|indust|ind\xfast|infant|inform|instit|integr|intens|interj|intern|interr|inven\xE7|invest|island|jardin|jurisp|labort|latoar|legisl|litogr|lituan|liturg|log\xedst|madeir|magnet|magnit|mai\xfasc|maomet|maranh|marinh|marroq|martin|mediev|mercad|meteor|metrif|metrol|microg|microl|microm|min\xfasc|mo\xE7amb|monogr|museol|neolog|neozel|normat|norueg|numism|obstet|oftalm|onomat|origin|ortogr|paleob|paleog|paleoz|paraib|parnas|partic|patron|patr\xf4n|pediat)\\.")

# pattern for paragraph checking
paralcap = re.compile(u"(?u)^[a-z].*[.?!] [A-Z].*[.?!][)\u201d]?$")

# Minhas Implementacoes

# Tenta corrigir erros de identificacao da regra de capiatizacao
# erroscap = re.compile("(?i)\\.([A-Z])")
erroscap = re.compile("((?i)\\.([A-Z\xc0\xc1\xc2\xc3\xc7\xc9\xca\xcd\xd3\xd4\xd5\xda])|\\.\\[|\\.\\(|\\.\\)|\\?\\)|\\!\\)|[a-z]\\))")
erroscapa = re.compile("((?i)[.?!]\\, ([a-z\xe1\xe2\xe3\xe7\xe9\xea\xf3\xf4\xf5\xfa]+))")
erroscapb = re.compile("((?i)[a-z]\\))")
erroscapc = re.compile("((?i)[.?!][\"\u2019\u201d])")

# Tenta corrigir erros de identificacao parentese de fechamento
errosprnt = re.compile(u"(?u)^([a-z]|[ivxl]+)\\)")

# Excecao da identificacao da regra Singular-plural - determinado periodo presos
excsingpl = re.compile("(?i)\\b(determinado per\xedodo [a-z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+s|sua [a-z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+[aeiolmrz] [a-z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+s|[a-z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+[aeiolmrz] outros)\\b")


# Excecao da identificacao da regra dah - dar
excparadah = re.compile("(?i)\\b([Pp]ara da (mesma|minha|sua|tua|nossa))")

# Excecao da identificacao da regra ha
excha = re.compile("(?i)(0 |1 |2 |3 |4 |5 |6 |7 |8 |9 |\\/)ha")

# Excecao da identificacao do para para - repeticao
excpPara = re.compile("(?i)\\b([Pp]ara para (lhe|lhes|lho|lha|me|nos|se|si|te|vos)) ")

# Identificacao do ou seja - entre virgulas
vOusejac = re.compile("(?i)\\b(([a-zA-Z0-9\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+) ou seja ([a-zA-Z0-9\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+)|([a-z0-9A-Z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+) ou seja ([a-zA-Z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+)-([mst]e|lhe|lhes|nos|vos|la|las|lo|los))\\b")
vOusejae = re.compile("(?i)\\b(([a-zA-Z0-9\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+), ou seja ([a-zA-Z0-9\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+)|([a-z0-9A-Z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+), ou seja ([a-zA-Z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+)-([mst]e|lhe|lhes|nos|vos|la|las|lo|los))\\b")
vOusejad = re.compile("(?i)\\b(([a-zA-Z0-9\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+) ou seja, ([a-zA-Z0-9\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+)|([a-z0-9A-Z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+) ou seja, ([a-zA-Z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+)-([mst]e|lhe|lhes|nos|vos|la|las|lo|los))\\b")
excOuseja = re.compile("(?i)\\b([Ss]eja ([a-zA-Z0-9\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+) ou seja|[Ss]eja ([a-z0-9A-Z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+) ([a-z0-9A-Z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+) ou seja|[Qq]uer seja|[Qq]ue seja|[Qq]ue ([a-zA-Z\xE1\xE2\xE7\xE9\xEA\xED\xF3\xF4\xFA\xE3]+) seja|[Cc]aso seja)\\b")

# Excecao da identificacao de todas a - 
excTodas = re.compile("(?i)\\b( a todas a | para todas a |todas a [a-z\xe7]+[ae]m | de todas a que | todas a mesma | todas a um| de todas a mais |entre todas a mais|[Tt]odas a dan\xe7ar|[Tt]odas a p\xe9|[Tt]odas a favor)")

# Excecao da identificacao de ambas a - 
excAmbas = re.compile("(?i)\\b( a ambas a | para ambas a |ambas a [a-z\xe7]+[ae]m | ambas a mesma | ambas a um|ambas a [a-z\xe7]+[aeio]r |[Aa]mbas a p\xe9|[Aa]mbas a favor)")

# Excecao da identificacao frases com concordancia verbal 
excfrvb = re.compile("(?i)\\b([Ss]e algum dia|[Tt]alvez algum dia)\\b")

# Excecao da identificacao do para para - repeticao
excMelhorq = re.compile("(?i)\\b([a-zA-Z\xe7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+)os melhor que (ningu\xe9m|todo|os)\\b")

# Excecao da identificacao a maioria - maneira 
excMaioria = re.compile("(?i)\\b((([Ss]ua [a-zA-Z\xe7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+|grande|absoluta|[Nn]a|[Nn]a [a-zA-Z\xe7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+|[Ss]ua) maioria [a-zA-Z\xe7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+s)|((alguma|certa|dessa|desta|mesma|outra|qual|qualquer|que|tal) maneira [a-z\xe7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+s))\\b")

# Excecao da identificacao a maior parte 
excMparte = re.compile("(?i)\\b([Bb]oa|[Dd]essa|[Dd]esta|[Ee]m|[Gg]rande|[Mm]aior|[Nn]essa|[Nn]esta|[Nn]uma|[Pp]equena|[Qq]ualquer|[Tt]oda|[Uu]ma) parte [a-zA-Z\xe7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+s\\b")
excFparte = re.compile("(?i)\\b([a-zA-Z\xe7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+es) (boa|dessa|desta|grande|maior|nessa|nesta|numa|pequena|qualquer|toda|uma) parte\\b")

# Excecao da identificacao de tal modo
excMmodo = re.compile("(?i)\\b([Aa]lgum|[Cc]erto|[Dd]esse|[Dd]este|[Mm]esmo|[Nn]enhum|[Oo]utro|[Pp]elo|[Tt]al) modo [a-zA-Z\xe7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+s\\b")

# Excecao da identificacao da regra divida - divda
excdivida = re.compile("(?i)\\b([Dd]ivida (a|as|o|os|em|por|com|pela|pelas|pelo|pelos|tudo|isto|isso))")

# Excecao da identificacao da regra noticia - notIcia
excnoticia = re.compile("(?i)\\b(noticia (a|as|o|os|tudo|isto|isso))")

# Excecao da identificacao da regra camisa 10 
excamisa = re.compile("(?i)\\b(camisa ([0-9]+|Verde|Alvo|Branco))")

# Excecao da identificacao da regra camisa 10 
exceapouco = re.compile("(?i)\\b(A pouco mais de ([0-9]+|um|uma|dois|duas|tr\xeas|quatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|catorze|quinze|dezesseis|dezessete|dezoito|dezenove|vinte) (ano|anos|m\xeas|meses|semana|semanas|dia|dias|hora|horas|minuto|minutos|segundo|segundos|volta|voltas) (para|de|da|das|do|dos))")

# Excecao da identificacao da regra palavras terminadas em ido - Ex. uma foto sua vestido de... 
excfido = re.compile("(?i)\\b(foto|fotos|imagem|imangens|caricatura|caricaturas|fotografia|fotografias) (minha|minhas|sua|suas) (vestido|vestidos)")

# Excecao de plural com anos Ex. em 1984 meu pai - 12/2014 processo
exckano = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+[aeioulmnrz]")

# Excecao de plural com horas Ex. as 00:00 horas 
exchora = re.compile("(?i)\\b(0[2-9]|[2-9]|[1-9][0-9]):[0-5][0-9] \\b")

# Excecao de plural com anos Ex. em 1984 meu pai - 12/2014 processo
exckano = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+[aeioulmnrz]")
excYmfoa = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)[oa]\\b")
excYmasco = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+o)\\b")
excYmasca = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+a)\\b")
excYnca = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([aeiou])n\xE7a\\b")
excYncia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([\xE2\xEA\xED\xF4\xFA])ncia\\b")
excYgrafia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([\xE2\xEA\xED\xF4\xFA])grafia\\b")
excYogia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+[gl])ogia\\b")
excYrgia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)rgia\\b")
excYlia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([\xE1\xE9\xED\xF3\xFA])lia\\b")
excYapia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)erapia\\b")
excYria = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([\xE1\xE9\xED\xF3\xFA])ria\\b")
excYsia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([\xE1\xE9\xED\xFA])sia\\b")
excYrsia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([\xE1\xE9\xED\xF3\xFA])rsia\\b")
excYssia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([\xe1\xe9\xED\xFA])ssia\\b")
excYrnia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([\xe1\xe9\xED\xFA])rnia\\b")
excYnia = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)([\xE2\xEA\xED\xF4\xFA])nia\\b")
excYmfeu = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+)u\\b")
excYmascu = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)u\\b")
excYfemu = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)u\\b")
excYmfei = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+)i\\b")
excYmasci = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)i\\b")
excYfemi = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)i\\b")
excYmfal = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+[a])l\\b")
excYmascal = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+[a])l\\b")
excYfemal = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+[a])l\\b")
excYmfel = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z]+)el\\b")
excYmascel = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)el\\b")
excYfemel = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)el\\b")
excYamscel = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+[e])l\\b")
excYmasces = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)\xeas\\b")
excYvel = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE7]+[\xe1\xe9\xed\xf3\xfa])vel\\b")
excYmfe = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+)e\\b")
excYmasce = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)e\\b")
excYfeme = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)e\\b")
excYinvaz = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z]+)z\\b")
excYmascz = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z]+)z\\b")
excYfemz = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z]+)z\\b")
excYmfm = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE7\xe1\xe9\xed\xf3\xfa\xe2\xea\xf4]+)m\\b")
excYmascm = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)m\\b")
excYfemm = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)m\\b")
excYfema = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+[a])\\b")
excYfdade = re.compile("(?i)\\b([Ee]m 19[0-9][0-9]|[Ee]m 20[0-9][0-9]|[Dd]e 19[0-9][0-9]|[Dd]e 20[0-9][0-9]|[Dd]esde 19[0-9][0-9]|[Dd]esde 20[0-9][0-9]|([0-9]+)[/:;]([0-9]+)) ([a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+)dade\\b")

# Excecao de plural - singular
excplSin = re.compile("(?i)\\b([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[s] [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmnrxz], [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmnrxz] e |[a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[s] [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmnrxz], [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmnrxz] e |[a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[s] [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmnrxz], [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmnrxz], [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmnrxz])\\b")

# Excecao de viu ele e viram eles
excviuEle = re.compile("(?i)\\b(viu el(a|e) que|viu el(a|e) (a|as|o|os)|viu el(a|e)[.;,]|o que viu el(a|e)|, viu el(a|e) [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+|viram el(a|e)s que|viram el(a|e)s (a|as|o|os)|viram el(a|e)s[.;,]|o que viram el(a|e)s|, viram el(a|e)s [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+)\\b")

# OUTROS  *-*-*-*-*-*-*-

# Identificacao de Nao a - Nao ha
vnaoHa = re.compile("(?i)\\b([Nn]\xe3o a ([a-z]+ade|[a-z\xe7]+\xe3o|[a-z]+eir[ao]|[a-z\xe7\xe1\xe9\xed\xf3\xfa]+ito|[a-z]+iv[ao]|[a-z\xe7]+\xf5es|[a-z]+nte|[a-z]+nto|[a-z\xea\xe2\xe1\xed\xf3]+ci[ao]|[a-z\xe7]+ras|[a-z\xe7]+res|[a-z\xe7\xe1\xe9\xed\xf3\xfa]+ri[ao][a-z\xe7\xe1\xe9\xed\xf3\xfa]+ri[ao]s|[a-z\xe7\xe1\xe9\xed\xf3\xfa]+tos|abertura|abrigo|academias|acordo|ac\xfamulo|admirar|aforismos|agenda|agricultura|\xe1gua|a\xed|ainda|ajuda|ajuste|alarme|\xe1lbum|alcaide|aldeias|alface|algas|algum|alguma|alguns|ali|alma|almo\xe7o|alta|alternativas|alvar\xe1|amanuense|amargura|ambulantes|amigos|amor|amplas|animais|\xe2nimo|anos|ao|apenas|apetite|aplausos|apoio|apoios|aposta|aquela|aquelas|aquele|aqueles|aqui|\xe1rea|aristocracias|arma|arte|artista|\xe1rvore|arvoredo|as|aspas|assadura|assim|assistentes|atalhos|ataque|ataques|at\xe9|ateus|atmosfera|atraso|atrasos|aulas|autom\xf3vel|autor|avan\xe7o|azar|azuis|bagatelas|baia|baile|balan\xe7a|balas|baliza|b\xe1lsamo|bananas|banco|bando|banheiros|banhos|banquetes|barco|barracas|base|beijo|bela|beleza|belos|bem|bernarda|bicho|birra|boa|bogas|bom|bombas|bonan\xe7a|bonde|bons|bonzo|borda|bota|botequim|bra\xe7o|bra\xe7os|bruxas|buracos|c\xe1|cabe\xe7a|cabotino|cabreiros|ca\xe7a|cacha\xe7a|cachorrinho|caga\xe7o|cal\xe7ado|c\xe1lculo|caldeiradas|calor|cama|camarada|camas|camelos|caminho|caminhos|camisas|campo|cantinho|caos|capas|capit\xe3es|capitais|capital|capricho|caprichos|car\xe1cter|caramujo|carne|carro|carros|carta|cartas|cartilha|casa|casas|casca|caso|casos|castelhanos|castelo|castigo|catarse|caudal|causas|cavalo|cavalos|cego|cegonha|centro|cerim\xf4nia|certas|certeza|certezas|c\xe9u|ch\xe1|chama|chamariz|chance|chaves|chefe|chefes|cheiros|cheques|choque|chuva|cinco|cineasta|cinema|cinemas|cip\xf3|ci\xfames|claro-escuro|classe|clientela|clima|clube|coadjutor|cobertura|cobra|cobran\xe7a|coiros|coisa|coisa-ruim|com|combate|comida|como|companhia|compromisso|comum|confian\xe7a|conforto|conselhos|consenso|contestar|contrabandistas|controle|cousa|cova|crase|criados|crian\xe7as|criatura|crime|crimes|criminoso|crise|culpado|cultura|cura|dados|data|de|decerto|dentro|den\xfancias|desar|descanso|desculpa|desculpas|desejar|desemprego|deserto|desgra\xe7ado|desleixo|desordem|despedida|dessas|destino|desvios|detalhes|deus|deuses|dever|dez|dia|diabos|di\xe1logo|dias|dieta|diferen\xe7a|diferen\xe7as|dificuldades|diploma|diretor|disfarce|disso|disto|diverg\xeancias|d\xedvida|dividendos|divina|divinas|do|doce|do\xe7ura|doen\xe7a|doen\xe7as|dois|dolo|domingo|dor|dormimos|dormir|dous|doutrina|doutros|drama|droga|duas|duques|d\xfavida|duvidar|d\xfavidas|e|\xe9|economia|ego\xedsmo|elefantes|em|embargo|empadas|empates|empatia|empenho|empenhos|emplastro|emprego|encarregados|encontro|energia|enfermidades|engano|enganos|entre|epidemia|epidemias|epis\xf3dio|\xe9poca|\xe9pocas|equipe|equipes|ermos|erro|erros|erva|esc\xe2ndalo|escapar|escolas|escolha|escravos|esfor\xe7os|espa\xe7o|espa\xe7os|esp\xe9cies|esperan\xe7a|essa|esse|esses|esta|estat\xedsticas|este|estes|est\xf4mago|estrat\xe9gias|est\xfadios|estudos|evid\xeancias|exagero|exemplo|falar|falta|fam\xedlia|fato|f\xe9|febre|f\xe9rias|festa|festas|fidalgos|fil\xf3sofo|fim|fome|for\xe7a|for\xe7as|forma|formas|f\xf3rmula|f\xf3rmulas|fortuna|fugir|fumo|futuro|garantia|garantias|gon\xe7alinho|gosto|governo|gra\xe7a|grades|grande|grandes|grupos|hip\xf3tese|hoje|homem|homens|honra|ideologias|igual|imagens|imposs\xedveis|ind\xedcios|inimigo|interesse|j\xe1|jogos|jornais|justi\xe7a|l\xe1|lei|leis|liames|limite|limites|linguagem|livro|livros|lixo|lua|lugar|luta|lutas|luz|m\xe1goa|maior|mais|mal|malandro|males|manh\xe3s|m\xe3os|margem|mas|m\xe1scara|m\xe9dico|m\xe9dicos|medida|medo|meio|meios|melhor|mendigo|menina|mesas|mesmo|m\xe9todo|m\xe9todos|milagre|mister|mo\xe7a|modelo|modelos|mol\xe9stia|molhos|morte|motivos|motorista|mudan\xe7as|muita|muitas|mulher|m\xfasica|na|nada|nas|nascentes|negar|negros|nela|nele|neles|nem|nenhum|nenhuma|nenhuns|nessa|nesta|neste|ningu\xe9m|nisso|no|noite|nome|nomes|nos|notas|not\xedcias|novidades|novos|n\xfameros|o|obst\xe1culos|ofensa|olhos|onde|ordem|ou|ouro|outra|outro|outros|pai|pa\xeds|palavra|papel|para|partido|partidos|passagem|peixe|penedos|perda|perigo|per\xedodos|perplexidades|perspectivas|pesar|pessoa|pessoal|pessoas|piolhos|pior|pistas|planos|poder|poesia|pois|pol\xedcias|pol\xedtica|pol\xedticas|por|por\xe9m|porque|portugueses|posse|pota|povo|praxe|prazer|prazo|pressa|pressas|princ\xedpio|princ\xedpios|problema|problemas|prod\xedgio|programa|progresso|protetor|prova|provas|p\xfablico|quaisquer|qualquer|quase|que|quem|ra\xe7as|racioc\xednios|racismo|rapaz|receio|receitas|recuos|recurso|recursos|refer\xeancias|reforma|refugiados|registo|registro|registros|regra|rei|rem\xe9dio|remorso|reservas|resposta|respostas|riqueza|risco|riscos|rosas|rua|sa\xedda|salas|sangue|segredo|segredos|segunda|seis|sempre|senador|sentido|sentir|sequer|ser|sereia|servi\xe7o|simpatia|sinais|sinal|s\xf3|sobre|social|sol|som|sono|subs\xeddios|subtilezas|surf|tal|talvez|tamb\xe9m|tanta|tarefa|tecnologia|temor|tempo|terap\xeautica|terra|testemunhas|tipo|todo|tolo|trabalho|tr\xe1fico|trag\xe9dia|tr\xeas|trevas|tristeza|tristezas|tropa|um|uma|umas|utopias|vacilar|vacina|vaga|vagas|vaidades|valor|vedetas|ver|verdadeiros|versos|vest\xedgio|v\xe9u|vida|vingan\xe7a|vinho|vislumbrar|vizinhos|volta|voltas|voz))\\b")
vdisNaoa = re.compile("(?i)\\b([Dd]iga|[Dd]igam|[Dd]igo|[Dd]ir\xe1|[Dd]ir\xe3o|[Dd]iremos|[Dd]iria|[Dd]iriam|[Dd]isse|[Dd]issemos|[Dd]isseram|[Dd]izem|[Dd]iz|[Dd]izer|[Dd]izia|[Dd]iziam|[Dd]o|[Ee]|[Nn]o|[Oo]|ou|[Pp]ara|[Pp]ro|[Ss]onoro|[Uu]m) n\xe3o a\\b")
vMaisNaoa = re.compile("(?i)\\b(\xe9 que|\xe9 o que|\xe9 a que|s\xe3o os que|s\xe3o as que|que n\xe3o a que)\\b")

# Excecao de tem sem acento
exctema = re.compile("(?i)\\b((das|de|dos|dessas|destas|nessas|nestas|desses|destes|nesses|nestes) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[s]) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[s])|[AaOo] [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmrz] entre [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmrz] [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[aeioulmrz] e [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[s] [a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[s]) tem\\b")
exctemb = re.compile("(?i)\\b(das|de|dos|dessas|destas|nessas|nestas|desses|destes|nesses|nestes) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[s]) tem\\b")

# Excecao de obedecer
excobdc = re.compile("(?i)\\b([Dd]eso|[Oo])bede([c\xE7])(\\w+) a ([0-9]+|[a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xf5\xFA]+[o]|algum|alguma|algumas|dez|dois|duas|ela|elas|ele|eles|essa|essas|esse|esses|esta|estas|este|estes|minha|minhas|ningu\xe9m|nossa|nossas|nove|seis|sete|sua|suas|toda|todas|todos|tr\xeas|um|uma|umas|uns|voc\xea|vossa)\\b")

# Excecao de compostos contra
exccontra = re.compile("(?i)\\b([Aa]berta|[Aa]bertamente|[Aa]bertos|[Aa]brigada|[Aa]brigo|[Aa]buso|[Aa]\xe7\xe3o|[Aa]cautelar-se|[Aa]\xe7\xf5es|[Aa]cordo|[Aa]cusa\xe7\xe3o|[Aa]cusa\xe7\xf5es|[Aa]dvertiu|[Aa]dvogado|[Aa]\xe9reos|[Aa]final|[Aa]gir|[Aa]gora|[Aa]gress\xe3o|[Aa]gress\xf5es|[Aa]inda|[Aa]juda|[Aa]lem\xe3es|[Aa]lerta|[Aa]lgo|[Aa]lguma|[Aa]lian\xe7a|[Aa]lma|[Aa]manha|[Aa]manh\xe3|[Aa]mea\xe7a|[Aa]mea\xe7as|[Aa]mistoso|[Aa]mistosos|[Aa]muleto|[Aa]n\xe1tema|[Aa]no|[Aa]nos|[Aa]ntes|[Aa]nticorpos|[Aa]nt\xeddoto|[Aa]penas|[Aa]pertadas|[Aa]pertado|[Aa]pertando|[Aa]pertando-a|[Aa]pertava|[Aa]pertava-a|[Aa]pertou|[Aa]pertou-a|[Aa]pertou-o|[Aa]poiado|[Aa]rgumentar|[Aa]rgumento|[Aa]rgumentos|[Aa]rma|[Aa]rmada|[Aa]rmado|[Aa]rmados|[Aa]rmas|[Aa]rremessavam|[Aa]rremesso|[Aa]rremessou|[Aa]rremete|[Aa]rremetendo|[Aa]rremeter|[Aa]rremeteu|[Aa]rremetia|[Aa]rremetidas|[Aa]rrojou-se|[Aa]rtigo|[Aa]rtigos|[Aa]ssalto|[Aa]ssim|[Aa]taque|[Aa]taques|[Aa]t\xe9|[Aa]tenta|[Aa]tentado|[Aa]tentados|[Aa]tentando|[Aa]tentar|[Aa]tentou|[Aa]tirada|[Aa]tiradas|[Aa]tirado|[Aa]tiram|[Aa]tirando|[Aa]tirar|[Aa]tirar-se|[Aa]tiraram|[Aa]tirou|[Aa]tirou-se|[Aa]to|[Aa]utoridade|[Aa]ux\xedlio|[Aa]van\xe7ando|[Aa]van\xe7ar|[Aa]van\xe7aram|[Aa]van\xe7ou|[Bb]aixa|[Bb]aixas|[Bb]andeira|[Bb]arreira|[Bb]arreiras|[Bb]atalha|[Bb]atalhas|[Bb]atendo|[Bb]ater|[Bb]ateram|[Bb]ateu|[Bb]em|[Bb]ilh\xf5es|[Bb]lasfemar|[Bb]loco|[Bb]oca|[Bb]oicote|[Bb]ola|[Bb]omba|[Bb]orracha|[Bb]ra\xe7o|[Bb]radar|[Bb]radava|[Bb]rancos|[Bb]rasil|[Bb]rasileira|[Bb]rigar|[Bb]rit\xe2nica|[Cc]abe\xe7a|[Cc]abo|[Cc]aiu|[Cc]al\xfania|[Cc]ampanha|[Cc]ampanhas|[Cc]ampo|[Cc]andidatura|[Cc]aptura|[Cc]ara|[Cc]asa|[Cc]asar|[Cc]ausa|[Cc]avalaria|[Cc]ensura|[Cc]ensuras|[Cc]ento|[Cc]errada|[Cc]errados|[Cc]hoque|[Cc]idadania|[Cc]idad\xe3o|[Cc]idad\xe3os|[Cc]idade|[Cc]igarro|[Cc]ilada|[Cc]ivil|[Cc]lama|[Cc]lamam|[Cc]lamando|[Cc]lamar|[Cc]l\xe1ssico|[Cc]oisa|[Cc]oisas|[Cc]\xf3lera|[Cc]oliga\xe7\xe3o|[Cc]olocar|[Cc]ombate|[Cc]ombatendo|[Cc]ombater|[Cc]ombateram|[Cc]ombates|[Cc]ombatiam|[Cc]ometida|[Cc]ometidas|[Cc]ometido|[Cc]ometidos|[Cc]omiss\xe3o|[Cc]omo|[Cc]ompl\xf4|[Cc]omprimidos|[Cc]omum|[Cc]oncedidas|[Cc]oncreto|[Cc]onforto|[Cc]onjura|[Cc]onsci\xeancia|[Cc]onspira|[Cc]onspira\xe7\xe3o|[Cc]onspirador|[Cc]onspiram|[Cc]onspirar|[Cc]onspirava|[Cc]onspiravam|[Cc]onstante|[Cc]ontos|[Cc]onven\xe7\xe3o|[Cc]ora\xe7\xe3o|[Cc]oroa|[Cc]orpo|[Cc]orre|[Cc]orrer|[Cc]orrida|[Cc]orrup\xe7\xe3o|[Cc]ostas|CPI|[Cc]r\xe2nio|[Cc]rian\xe7a|[Cc]riatura|[Cc]rime|[Cc]rimes|[Cc]riminal|[Cc]riminosa|[Cc]r\xedtica|[Cc]r\xedticas|[Cc]ruz|[Cc]ruzada|[Cc]ruzadas|[Dd]anos|[Dd]e|[Dd]ecis\xe3o|[Dd]ecisiva|[Dd]eclamam|[Dd]eclamando|[Dd]eclamar|[Dd]eclara\xe7\xf5es|[Dd]efend\xea-las|[Dd]efender|[Dd]efender-se|[Dd]efendido|[Dd]efesa|[Dd]efesas|[Dd]ele|[Dd]elito|[Dd]entes|[Dd]entro|[Dd]en\xfancia|[Dd]en\xfancias|[Dd]ep\xf5e|[Dd]epois|[Dd]epor|[Dd]eputados|[Dd]esconfian\xe7a|[Dd]esesperadamente|[Dd]esferir|[Dd]espeito|[Dd]espejar|[Dd]eus|[Dd]ifama\xe7\xe3o|[Dd]ignidade|[Dd]ireitos|[Dd]iretamente|[Dd]irigia-se|[Dd]irigida|[Dd]irigidas|[Dd]irigido|[Dd]irigidos|[Dd]iscrimina\xe7\xe3o|[Dd]iscurso|[Dd]isparado|[Dd]isparar|[Dd]ispararam|[Dd]isparou|[Dd]isputa|[Dd]ito|[Dd]izer|[Dd]o|[Dd]obrado|[Dd]ocumento|[Dd]ois|[Dd]omingo|[Dd]roga|[Dd]rogas|[Dd]ura|[Dd]uras|[Ee]|[\xc9\xe9]|[Ee]con\xf4mico|[Ee]feito|[Ee]ficaz|[Ee]ficazes|[Ee]l-rei|[Ee]la|[Ee]le|[Ee]lei\xe7\xf5es|[Ee]les|[Ee]m|[Ee]mbargo|[Ee]mbora|[Ee]mpate|[Ee]n\xe9rgica|[Ee]nergicamente|[Ee]nt\xe3o|[Ee]quipe|[Ee]ra|[Ee]ram|[Ee]rguer|[Ee]rguesse|[Ee]sbarrar|[Ee]sbarrou|[Ee]sbracejar|[Ee]sbravejar|[Ee]scala|[Ee]screveu|[Ee]scudo|[Ee]sfor\xe7os|[Ee]spada|Espanha|[Ee]special|[Ee]specialmente|[Ee]speculativo|[Ee]spingarda|[Ee]sp\xedrito|[Ee]st\xe1|[Ee]stado|[Ee]stamos|[Ee]st\xe3o|[Ee]star|[Ee]stava|[Ee]stavam|[Ee]steve|[Ee]stou|[Ee]strangeiro|[Ee]streia|[Ee]str\xe9ia|[Ee]streitou|[Ee]terno|[Ee]u|EUA|Europa|[Ee]uropeia|[Ee]uropeu|[Ee]xatamente|[Ee]xercida|[Ee]x\xe9rcito|[Ee]xpedi\xe7\xe3o|[Ee]xpedi\xe7\xf5es|[Ee]xpulso|[Ff]ace|[Ff]ala|[Ff]alam|[Ff]alando|[Ff]alar|[Ff]az|[Ff]azer|[Ff]ederal|[Ff]eita|[Ff]eitas|[Ff]eiti\xe7o|[Ff]eito|[Ff]erro|[Ff]ez|[Ff]ilha|[Ff]ilho|[Ff]inal|[Ff]inalmente|[Ff]ogo|[Ff]oi|[Ff]or|[Ff]ora|[Ff]oram|[Ff]or\xe7a|[Ff]or\xe7as|[Ff]ormais|[Ff]ormal|[Ff]ortaleza|[Ff]orte|[Ff]ortemente|[Ff]ortes|[Ff]osse|[Ff]raco|[Ff]ran\xe7a|[Ff]rancamente|[Ff]ranceses|[Ff]raude|[Ff]raudes|[Ff]rente|[Ff]rontalmente|[Ff]ui|[Ff]\xfaria|[Ff]uriosa|[Ff]urioso|[Ff]uror|[Gg]arantia|[Gg]arantidos|[Gg]ente|[Gg]eral|[Gg]ol|[Gg]olpe|[Gg]ols|[Gg]overno|[Gg]r\xeamio|[Gg]reve|[Gg]rito|[Gg]ritos|[Gg]ritou|[Gg]uarda|[Gg]uerra|[Gg]uerras|[Gg]uerrilha|[Gg]uerrilheiros|[Hh]\xe1|[Hh]avia|[Hh]oje|[Hh]omem|[Hh]omens|[Hh]omic\xeddio|[Hh]oras|[Hh]ostil|[Hh]ostilidade|[Hh]ostilidades|[Hh]ostis|[Ii]a|[Ii]am|[Ii]l\xedcito|[Ii]mp\xe9rio|[Ii]mplac\xe1vel|[Ii]mportante|[Ii]mpreca\xe7\xf5es|[Ii]mprensa|[Ii]munidade|[Ii]munizada|[Ii]nconstitucionalidade|[Ii]ncorrupt\xedveis|[Ii]nd\xedcios|[Ii]ndigna\xe7\xe3o|[Ii]ndignada|[Ii]ndignado|[Ii]ndignava|[Ii]ndividuais|[Ii]ndo|[Ii]nfra\xe7\xf5es|[Ii]ngleses|[Ii]niciada|[Ii]nj\xfarias|[Ii]nqu\xe9rito|[Ii]nqu\xe9ritos|[Ii]nsulto|[Ii]nsurge|[Ii]nsurge-se|[Ii]nsurgia|[Ii]nsurgia-se|[Ii]nsurgiam|[Ii]nsurgido|[Ii]nsurgindo-se|[Ii]nsurgir|[Ii]nsurgir-se|[Ii]nsurgiram|[Ii]nsurgiram-se|[Ii]nsurgiu|[Ii]nsurgiu-se|[Ii]nsurjo|[Ii]nsurrei\xe7\xe3o|[Ii]ntentada|[Ii]nternacionais|[Ii]nternacional|[Ii]nterpostos|[Ii]nvectivas|[Ii]nveste|[Ii]nvestem|[Ii]nvestia|[Ii]nvestiam|[Ii]nvestidas|[Ii]nvestindo|[Ii]nvestir|[Ii]nvestiram|[Ii]nvestirem|[Ii]nvestiu|[Ii]r|[Ii]ra|[II]raque|[Ii]rrita\xe7\xe3o|[Ii]rritada|[Ii]rritado|[Ii]rritou-se|[Ii]sso|[II]t\xe1lia|[Jj]\xe1|[Jj]aneiro|[Jj]oga|[Jj]ogadores|[Jj]ogam|[Jj]ogamos|[Jj]ogando|[Jj]ogar|[Jj]ogar\xe1|[Jj]ogava|[Jj]ogo|[Jj]ogos|[Jj]ogou|[Jj]ornais|[Jj]udiciais|[Jj]udicial|[Jj]udicialmente|[Jj]u\xedzo|[Jj]ulho|[Jj]usti\xe7a|[Ll]an\xe7ada|[Ll]an\xe7adas|[Ll]an\xe7ado|[Ll]an\xe7ar-se|[Ll]egal|[Ll]egisla\xe7\xe3o|[Ll]egislativo|[Ll]ei|[Ll]eis|[Ll]evanta|[Ll]evantadas|[Ll]evantam|[Ll]evantar|[Ll]evantava|[Ll]evante|[Ll]evantou|[Ll]ibelo|[Ll]iga|[Ll]iminar|[Ll]iminares|[Ll]\xedngua|[Ll]isboa|[Ll]ivros|[Ll]obby|[Ll]ocal|[Ll]ogo|[Ll]uta|[Ll]utador|[Ll]utam|[Ll]utando|[Ll]utar|[Ll]utar\xe1|[Ll]utaram|[Ll]utas|[Ll]utava|[Ll]utavam|[Ll]uto|[Ll]utou|[Mm]\xe3e|[Mm]ais|[Mm]aldi\xe7\xf5es|[Mm]anifesta\xe7\xe3o|[Mm]anifesta\xe7\xf5es|[Mm]anifestantes|[Mm]anifestar|[Mm]anifestar-se|[Mm]anifestaram|[Mm]anifestaram-se|[Mm]anifesto|[Mm]anifestou|[Mm]anifestou-se|[Mm]antinha|[Mm]\xe3o|[Mm]\xe3os|[Mm]archar|[Mm]archava|[Mm]as|[Mm]assacres|[Mm]assas|[Mm]aus-tratos|[Mm]e|[Mm]edicamentos|[Mm]\xe9dicos|[Mm]edida|[Mm]edidas|[Mm]elhor|[Mm]enina|[Mm]enos|[Mm]esmo|[Mm]ilitar|[Mm]ilitares|[Mm]im|[Mm]inutos|[Mm]ofinas|[Mm]olotov|[Mm]omento|[Mm]onarquia|[Mm]onteiro|[Mm]orte|[Mm]ostrou|[Mm]ove|[Mm]oveu|[Mm]ovida|[Mm]ovido|[Mm]ovimento|[Mm]ovimentos|[Mm]uito|[Mm]ulher|[Mm]ulheres|[Mm]undial|[Mm]undo|[Mm]urmurando|[Mm]urmurar|[Nn]acional|[Nn]acionalista|[Nn]ada|[Nn]\xe3o|[Nn]ariz|[Nn]aturais|[Nn]atureza|[Nn]azi|[Nn]egros|[Nn]em|[Nn]oite|[Nn]omeadamente|[Nn]orte|[Nn]ota|[Nn]ovo|[Nn]unca|[Oo]|[Oo]brar|[Oo]bras|[\xd3\xf3]dio|[\xd3\xf3]dios|[Oo]fensas|[Oo]fensiva|[Oo]fensivas|[Oo]ito|[Oo]lhos|[Oo]mbros|OMC|[Oo]ntem|ONU|[Oo]pera\xe7\xe3o|[Oo]pera\xe7\xf5es|[Oo]pini\xe3o|[Oo]posi\xe7\xe3o|[Oo]posicionista|[Oo]posi\xe7\xf5es|[Oo]ra\xe7\xf5es|[Oo]rdem|[Oo]rganismo|[Oo]u|[Oo]utros|[Pp]\xe1|[Pp]ai|[Pp]a\xeds|[Pp]a\xedses|[Pp]alavra|[Pp]arlamentares|[Pp]articular|[Pp]artida|[Pp]artido|[Pp]artiu|[Pp]assado|[Pp]aulista|[Pp]aulo|[Pp]\xe9|[Pp]ecado|[Pp]ecados|[Pp]edra|[Pp]eito|[Pp]ermanente|[Pp]essoal|[Pp]essoas|[Pp]ode|[Pp]odem|[Pp]oder|[Pp]odia|[Pp]ol\xedcia|[Pp]olicial|[Pp]ol\xedtica|[Pp]ontos|[Pp]opula\xe7\xe3o|[Pp]opular|[Pp]opulares|[Pp]ortuguesa|[Pp]osi\xe7\xe3o|[Pp]osso|[Pp]ouco|[Pp]ovo|[Pp]raguejando|[Pp]raguejar|[Pp]raticadas|[Pp]raticado|[Pp]raticados|[Pp]recau\xe7\xe3o|[Pp]recau\xe7\xf5es|[Pp]recaver|[Pp]recipitou-se|[Pp]reconceito|[Pp]reconceitos|[Pp]regar|[Pp]reservativo|[Pp]ress\xe3o|[Pp]reven\xe7\xe3o|[Pp]reven\xe7\xf5es|[Pp]revenido|[Pp]revenir|[Pp]revenir-se|[Pp]rincipalmente|[Pp]ris\xe3o|[Pp]roceder|[Pp]rocesso|[Pp]rocesso-crime|[Pp]rocessos|[Pp]roferida|[Pp]roferidas|[Pp]rograma|[Pp]ronunciado|[Pp]ropaganda|[Pp]rote\xe7\xe3o|[Pp]rotege|[Pp]roteg\xea-la|[Pp]roteg\xea-lo|[Pp]roteger|[Pp]rotegia|[Pp]rotegidas|[Pp]rotesta|[Pp]rotestado|[Pp]rotestam|[Pp]rotestando|[Pp]rotestar|[Pp]rotestaram|[Pp]rotestarem|[Pp]rotestava|[Pp]rotestavam|[Pp]roteste|[Pp]rotestei|[Pp]rotesto|[Pp]rotestos|[Pp]rotestou|[Pp]rotetor|[Pp]rova|[Pp]rovado|[Pp]rovas|[Pp]rovid\xeancias|[Pp]\xfablica|[Pp]ublicamente|[Pp]\xfablico|[Qq]uarta-feira|[Qq]uatro|[Qq]ue|[Qq]ueixa|[Qq]ueixa-crime|[Qq]ueixas|[Qq]uinta-feira|[Rr]acismo|[Rr]adicalmente|[Rr]aiva|[Rr]aivosos|[Rr]az\xe3o|[Rr]ea\xe7\xe3o|[Rr]eage|[Rr]eagia|[Rr]eagindo|[Rr]eagir|[Rr]eagiram|[Rr]eagiria|[Rr]eagiu|[Rr]eais|[Rr]eaja|[Rr]ebelada|[Rr]ebelado|[Rr]ebelados|[Rr]ebelando-se|[Rr]ebelar|[Rr]ebelar-se|[Rr]ebelaram|[Rr]ebelaram-se|[Rr]ebeldia|[Rr]ebeli\xe3o|[Rr]ebeli\xf5es|[Rr]ebelou-se|[Rr]eclamar|[Rr]eclamavam|[Rr]eclamou|[Rr]ecorrer|[Rr]ecrimina\xe7\xf5es|[Rr]ecurso|[Rr]ecursos|[Rr]ef\xfagio|[Rr]egressiva|[Rr]egresso|[Rr]emar|[Rr]em\xe9dio|[Rr]em\xe9dios|[Rr]epres\xe1lia|[Rr]epresenta\xe7\xe3o|[Rr]epresentar|[Rr]ep\xfablica|[Rr]eserva|[Rr]eservas|[Rr]esist\xeancia|[Rr]esmungando|[Rr]esmungar|[Rr]essentimento|[Rr]etalia\xe7\xe3o|[Rr]evolta|[Rr]evolta-se|[Rr]evoltada|[Rr]evoltado|[Rr]evoltam|[Rr]evoltam-se|[Rr]evoltando-se|[Rr]evoltar|[Rr]evoltar-se|[Rr]evoltaram|[Rr]evoltaram-se|[Rr]evoltaria|[Rr]evoltasse|[Rr]evoltava|[Rr]evoltava-me|[Rr]evoltava-se|[Rr]evoltei|[Rr]evoltei-me|[Rr]evolto-me|[Rr]evoltou|[Rr]evoltou-se|[Rr]evolu\xe7\xe3o|[Rr]evolucion\xe1rio|[Rr]osnando|[Rr]osto|[Rr]oupa|[Rr]ussa|[Rr]ussas|R\xfassia|[Rr]usso|[Rr]ussos|[Ss]abia|[Ss]an\xe7\xf5es|[Ss]anta|[Ss]\xe3o|[Ss]e|[Ss]ecreto|[Ss]eguinte|[Ss]eguran\xe7a|[Ss]eguro|[Ss]eguros|[Ss]eio|[Ss]eis|[Ss]eja|[Ss]ele\xe7\xe3o|[Ss]emana|[Ss]emifinais|[Ss]empre|[Ss]endo|[Ss]enhor|[Ss]enten\xe7a|[Ss]enten\xe7as|[Ss]entia|[Ss]equer|[Ss]er|[Ss]er\xe1|[Ss]erem|[Ss]erm\xe3o|[Ss]exual|[Ss]il\xeancio|[Ss]im|[Ss]\xf3|[Ss]oares|[Ss]ocial|[Ss]ociedade|[Ss]ofreu|[Ss]oldados|[Ss]omente|[Ss]omos|[Ss]ou|[Ss]ucessos|[Ss]ul|[Ss]urda|[Ss]uspeitas|[Tt]alvez|[Tt]amb\xe9m|[Tt]anto|[Tt]arde|[Tt]em|[Tt]empo|[Tt]enho|[Tt]ens|[Tt]entado|[Tt]entar|[Tt]er|[Tt]er\xe1|[Tt]erapia|[Tt]erra|[Tt]errit\xf3rio|[Tt]err\xedvel|[Tt]erroristas|[Tt]igre|[Tt]inha|[Tt]inham|[Tt]inta|[Tt]iro|[Tt]iros|[Tt]it\xe3s|[Tt]oda|[Tt]odas|[Tt]odo|[Tt]odos|[Tt]otalmente|[Tt]rabalhar|[Tt]rabalho|[Tt]rama|[Tt]ramada|[Tt]ramar|[Tt]ramavam|[Tt]ratado|[Tt]ratamentos|[Tt]ravada|[Tt]ribunal|[Tt]riunfante|[Tt]rovejou|[Tt]udo|[Uu]m|[Uu]ma|[Uu]mas|[Uu]ne|[Uu]nida|[Uu]nidas|[Uu]nidos|[Uu]nir|[Uu]ns|[Uu]sada|[Uu]sadas|[Uu]sado|[Uu]sados|[Uu]tilizados|[Vv]acina|[Vv]acina\xe7\xe3o|[Vv]acinadas|[Vv]acinado|[Vv]acinar|[Vv]acinas|[Vv]ai|[Vv]aler|[Vv]\xe3o|[Vv]elha|[Vv]erdadeiramente|[Vv]ez|[Vv]ezes|[Vv]\xedcios|[Vv]ida|[Vv]ingan\xe7a|[Vv]ingan\xe7as|[Vv]inha|[Vv]iol\xeancia|[Vv]iol\xeancias|[Vv]iolenta|[Vv]iolentamente|[Vv]iolentos|[Vv]irar|[Vv]irou-se|[Vv]ista|[Vv]it\xf3ria|[Vv]it\xf3rias|[Vv]itoriosa|[Vv]ociferando|[Vv]ociferar|[Vv]ociferava|[Vv]olta|[Vv]olta-se|[Vv]oltado|[Vv]oltam-se|[Vv]oltando|[Vv]oltar|[Vv]oltar-se|[Vv]oltaram-se|[Vv]oltasse|[Vv]oltava-se|[Vv]oltou-se|[Vv]ontade|[Vv]ota|[Vv]otado|[Vv]otam|[Vv]otando|[Vv]otar|[Vv]otar\xe1|[Vv]otaram|[Vv]otar\xe3o|[Vv]otava|[Vv]ote|[Vv]oto|[Vv]otos|[Vv]otou|[Vv]ou|[Vv]oz) contra\\b")

# Excecao de Esta em
excestaem = re.compile("(?i)\\b([a-z\xe7]+ndo|[a-z\xe7]+(-se|lhe|lhes|nos)|[Cc]om|[Cc]omo|[Cc]onsiste|[Cc]onsistia|[Cc]onsistindo|[Cc]onvertida|[Dd]isse|[Ee]|[\xc9\xe9]|[Mm]ais|[Qq]uanto|[Ss]eja|[Ss]en\xe3o|[Ss]obre|[Tt]erra|[Tt]ransformada|[Tt]ransitada) esta (de|em|no|na|nos|nas)\\b")

# Paronimos especiais *-*-*-*-*-*-*-


# Excecao de autentico - autentica sem acento
excauttic = re.compile("(?i)\\b([Ee]u|[Mm]e|[Ss]e|[Tt]e|[Ll]he|[Ll]hes) autentico\\b")
excauttix = re.compile("(?i)\\b[Aa]utentic[ao] (o|a|as|os|um|uma|uns|umas|todo|toda|todos|todas|apenas)\\b")

# Excecao de divorcio sem acento
excdivorc = re.compile("(?i)\\b(a|[Ee]u|[Mm]e|[Ss]e|[Tt]e|[Ll]he|[Ll]hes) divorcio\\b")

# Excecao de fotografo sem acento
excfotogra = re.compile("(?i)\\b(a|[Ee]u|[Mm]e|[Ss]e|[Tt]e|[Ll]he|[Ll]hes) fotografo\\b")
excfotogrx = re.compile("(?i)\\b[Ff]otograf[ao] (o|a|as|os|um|uma|uns|umas|todo|toda|todos|todas|tudo|apenas)\\b")

# Identificacao de tipos plural
vtipos = re.compile("(?i)\\b([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA\xf5]+s tipo (de|n\xe3o|j\xe1|t\xe9m)|[a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA\xf5]+s tipo [a-z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA\xf5]+s|[Tt]odos os tipo|[a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA\xf5]+s tipo s\xe3o|[a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA\xf5]+s tipo [a-z\xE7]+[ae]m)\\b")

# Identificacao de fabrica sem acento
vfabrica = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]lguma|[Aa]ntiga|[Aa]quela|[\xc0\xe0]quela|[Aa]ut\xeantica|[Cc]ada|[Cc]hamavam|[Cc]om|[Dd]a|[Dd]aquela|[Dd]e|[Dd]\xe9cima|[Dd]essa|[Dd]esta|[Dd]ita|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ssa|[Ee]sta|[Ee]studa|[Ee]xtensa|[Ff]echar|[Ff]oi|[Ff]utura|[Gg]rande|[Gg]rossa|[Gg]rosseira|[Hh]ist\xf3rica|[Ii]mensa|[Ii]mportante|[Ii]nternacional|[Mm]aior|[Mm]aravilhosa|[Mm]elhor|[Mm]esma|[Mm]ort\xedfera|[Mm]\xfaltipla|[Nn]a|[Nn]aquela|[Nn]esta|[Nn]ona|[Nn]ossa|[Nn]ova|[Nn]uma|[Oo]itava|[Oo]u|[Oo]utra|[Pp]ela|[Pp]equena|[Pp]rimeira|[Pp]r\xf3pria|[Qq]ualquer|[Qq]uarta|[Qq]ue|[Qq]uerem|[Qq]uinta|[Rr]eal|[Rr]ecente|[Rr]eferida|[Rr]ica|[Ss]egunda|[Ss]em|[Ss]\xe9tima|[Ss]exta|[Ss]ua|[Tt]anta|[Tt]enho|[Tt]er\xe1|[Tt]erceira|[\xda\xfa]ltima|[Uu]m|[Uu]ma|[\xda\xfa]nica|[Vv]elha|[Vv]erdadeira) fabrica\\b")

# Identificacao de inicio sem acento
vinicio = re.compile("(?i)\\b(a|[Aa]\xed|[Aa]o|[Aa]trasa|[Aa]trasaram|[Aa]trasou|[Bb]oicotam|[Bb]om|[Cc]ada|[Cc]om|[Cc]omo|[Cc]ujo|[Cc]urioso|[Dd]\xe1|[Dd]ado|[Dd]ando|[Dd]\xe3o|[Dd]ar|[Dd]ar\xe1|[Dd]aremos|[Dd]aria|[Dd]ava|[Dd]avam|[Dd]e|[Dd]\xea|[Dd]emos|[Dd]era|[Dd]eram|[Dd]esse|[Dd]este|[Dd]eu|[Dd]if\xedcil|[Dd]isse|[Dd]o|[Ee]|[Ee]m|[Ee]sse|[Ee]ste|[Ii]ndica|[Mm]ais|[Mm]arca|[Mm]arcam|[Mm]arcou|[Mm]au|[Mm]elhor|[Mm]esmo|[Mm]eu|[Nn]aquele|[Nn]esse|[Nn]este|[Nn]o|[Nn]os|[Nn]osso|[Nn]ovo|[Nn]um|[Oo]|[Oo]s|[\xf3\xf3]timo|[Oo]u|[Pp]ara|[Pp]elo|[Pp]ior|[Pp]leno|[Pp]r\xf3prio|[Qq]ualquer|[Rr]ecente|[Ss]eu|[Ss]imples|[Tt]ardio|[Tt]em|[Tt]\xeam|[Tt]endo|[Tt]enha|[Tt]er|[Tt]er\xe1|[Tt]er\xe3o|[Tt]eria|[Tt]eve|[Tt]ido|[Tt]inha|[Tt]inham|[Tt]iver|[Tt]ivera|[Tt]iveram|[Tt]odo|[Uu]m) inicio\\b")

# Identificacao de lastima sem acento 
vlastima = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Cc]ausa|[Cc]ausava|[Cc]erta|[Cc]om|[Dd]a|[Dd]ava|[Dd]e|[Dd]essa|[\xc9\xe9]|[Ee]m|[Ee]ra|[Ff]az|[Ff]azer|[Ff]azia|[Ff]oi|[Gg]rande|[Jj]ulgo|[Mm]enor|[Mm]erece|[Mm]ere\xe7o|[Mm]esma|[Mm]uita|[Nn]aquela|[Oo]u|[Pp]or|[Pp]rofunda|[Pp]r\xf3pria|[Qq]ue|[Ss]eria|[Ss]\xf3|[Ss]ua|[Tt]alvez|[Tt]anta|[Uu]ma|[Vv]erdadeira) lastima\\b")

# Identificacao de magoa sem acento
vmagoa = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]foga|[Aa]lguma|[Aa]penas|[Aa]quela|[Bb]astante|[Cc]ada|[Cc]ausou|[Cc]erta|[Cc]om|[Cc]uja|[Dd]a|[Dd]aquela|[Dd]e|[Dd]emonstrando|[Dd]essa|[Dd]oe|[Dd]olorosa|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ra|[Ee]ssa|[Ee]sta|[Ee]stranha|[Ee]terna|[Ff]ingida|[Ff]ingindo|[Ff]osse|[Ff]unda|[Gg]rande|[Gg]uarda|[Gg]uardo|[Hh]\xe1|[Hh]orr\xedvel|[Hh]umana|[Ii]mensa|[Ii]nfinda|[Ii]nfinita|[Ii]nterior|[\xcd\xed]ntima|[Jj]usta|[Ll]eve|[Mm]aior|[Mm]esma|[Mm]inha|[Mm]uita|[Nn]a|[Nn]aquela|[Nn]egra|[Nn]em|[Nn]enhuma|[Nn]essa|[Nn]ossa|[Nn]uma|[Oo]bscura|[Oo]culta|[Oo]u|[Pp]ara|[Pp]ela|[Pp]equena|[Pp]esada|[Pp]rimeira|[Pp]rofunda|[Pp]r\xf3pria|[Pp]ura|[Qq]ualquer|[Qq]ue|[Ss]em|[Ss]entia|[Ss]obra|[Ss]olene|[Ss]ua|[Ss]\xfabita|[Tt]al|[Tt]anta|[Tt]em|[Tt]ens|[Tt]inha|[Tt]raz|[Tt]ua|[Uu]ma|[\xda\xfa]nica|[Vv]erdadeira|[Vv]is\xedvel) magoa\\b")

# Identificacao de mascara sem acento
vmascara = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]lguma|[Aa]quela|[Aa]s|[Bb]ela|[Bb]oa|[Cc]ada|[Cc]\xe9lebre|[Cc]om|[Dd]a|[Dd]aquela|[Dd]e|[Dd]essa|[Dd]uma|[\xc9\xe9]|[Ee]legante|[Ee]m|[Ee]spessa|[Ee]ssa|[Ee]sta|[Ee]stupenda|[Ee]xpressiva|[Ff]eia|[Ff]ria|[Hh]\xe1|[Hh]edionda|[Ii]nteressante|[Mm]eia|[Mm]esma|[Mm]inha|[Mm]isteriosa|[Nn]a|[Nn]aquela|[Nn]em|[Nn]enhuma|[Nn]uma|[Pp]ela|[Pp]equena|[Pp]obre|[Pp]or|[Pp]\xf4r|[Pp]\xf4s|[Pp]rimeira|[Pp]unha|[Ss]em|[Ss]ob|[Ss]\xf3lida|[Ss]ua|[Tt]al|[Tt]razem|[Tt]razes|[Tt]raziam|[Tt]ua|[Uu]m|[Uu]ma|[Uu]sa|[Uu]sar\xe1|[Uu]sarei|[Uu]sava|[Uu]sei|[Uu]so|[Uu]sou) mascara\\b")

# Identificacao de negocio sem acento
vnegocio = re.compile("(?i)\\b([Aa]|[Aa]lgum|[Aa]o|[Aa]quele|[Bb]elo|[Bb]om|[Cc]ada|[Cc]erto|[Cc]om|[Cc]omo|[Dd]aquele|[Dd]e|[Dd]esse|[Dd]este|[Dd]o|[Dd]os|[\xc9\xe9]|[Ee]m|[Ee]mbrulhado|[Ee]ra|[Ee]sse|[Ee]ste|[Ee]xcelente|[Ff]az|[Ff]azer|[Ff]azia|[Ff]echado|[Ff]echar|[Ff]ez|[Ff]oi|[Ff]raco|[Ff]uturo|[Gg]igantesco|[Gg]rande|[Gg]rave|[Hh]\xe1|[Hh]aver\xe1|[Hh]avia|[Ii]gual|[Ii]menso|[Ii]mportante|[Ll]iquidado|[Mm]aior|[Mm]ais|[Mm]aldito|[Mm]au|[Mm]elhor|[Mm]esmo|[Mm]eu|[Mm]uito|[Nn]aquele|[Nn]enhum|[Nn]esse|[Nn]este|[Nn]o|[Nn]osso|[Nn]ovo|[Nn]um|[Oo]|[\xd3\xf3]timo|[Oo]utro|[Pp]ara|[Pp]arecer|[Pp]elo|[Pp]equeno|[Pp]or|[Pp]rincipal|[Pp]r\xf3prio|[Qq]ualquer|[Qq]ue|[Qq]uer|[Qq]uero|[Ss]emelhante|[Ss]er|[Ss]eu|[Ss]\xf3|[Tt]al|[Tt]em|[Tt]enho|[Tt]riste|[Tt]udo|[\xda\xfa]ltimo|[Uu]m) negocio\\b")

# Identificacao de pratica sem acento
vpratica = re.compile("(?i)\\b([A-Za-z]+dade|[A-Za-z]+mente|[A-Za-z\xea\xe2]+ncia|[A-Za-z]+\xe7\xe3o|[Aa]|[\xc0\xe0]|[Aa]cesa|[Aa]dquirir|[Aa]grad\xe1vel|[Aa]legada|[Aa]lguma|[Aa]lta|[Aa]lternativa|[Aa]n\xe1lise|[Aa]ntiga|[Aa]quela|[\xc0\xe0]quela|[Aa]rte|[Aa]ssim|[Aa]stronomia|[Aa]titude|[Aa]tiva|[Aa]tual|[Aa]ula|[Aa]videz|[Bb]astante|[Bb]oa|[Bb]reve|[Cc]ada|[Cc]erta|[Cc]oisa|[Cc]om|[Cc]omete|[Cc]omo|[Cc]omponente|[Cc]ompreens\xe3o|[Cc]onquista|[Cc]onsiderada|[Cc]onsiderado|[Cc]onstante|[Cc]ontra|[Cc]orreta|[Cc]ostumada|[Cc]ousa|[Cc]uja|[Dd]a|[Dd]e|[Dd]eficiente|[Dd]escolorida|[Dd]essa|[Dd]esta|[Dd]eterminada|[Dd]iscuss\xe3o|[Dd]oce|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ncetada|[Ee]nquanto|[Ee]nsino|[Ee]ra|[Ee]ram|[Ee]scola|[Ee]ssa|[Ee]sta|[Ee]stava|[Ee]ventual|[Ee]vidente|[Ee]xerceu|[Ee]xige|[Ee]xpress\xe3o|[Ee]xtensa|[Ff]az|[Ff]azem|[Ff]ervorosa|[Ff]ilosofia|[Ff]orma|[Ff]osse|[Ff]requente|[Gg]alante|[Gg]anhar|[Gg]ente|[Gg]eral|[Gg]est\xe3o|[Gg]l\xf3ria|[Gg]rande|[Hh]\xe1|[Hh]agiografia|[Hh]aja|[Hh]avido|[Hh]oje|[Ii]deia|[Ii]magem|[Ii]ncans\xe1vel|[Ii]ncitar|[Ii]ndiferen\xe7a|[Ii]ndigesta|[Ii]niciou|[Ii]ntoler\xe1vel|[Jj]ardinagem|[Ll]abuta|[Ll]inguagem|[Ll]inha|[Ll]iturgia|[Ll]\xf3gica|[Ll]onga|[Mm]\xe1|[Mm]ais|[Mm]alta|[Mm]aneira|[Mm]as|[Mm]ec\xe2nica|[Mm]edicina|[Mm]edida|[Mm]eio|[Mm]elhor|[Mm]enor|[Mm]esma|[Mm]etade|[Mm]inha|[Mm]isteriosa|[Mm]oral|[Mm]udar|[Mm]uita|[Mm]uito|[Nn]a|[Nn]em|[Nn]enhuma|[Nn]esta|[Nn]ossa|[Nn]ova|[Nn]uma|[Oo]bra|[Oo]rdem|[Oo]u|[Oo]utra|[Pp]ara|[Pp]arte|[Pp]atrocinar|[Pp]ela|[Pp]equena|[Pp]essoa|[Pp]oesia|[Pp]ol\xedtica|[Pp]or|[Pp]or\xe9m|[Pp]ouca|[Pp]ouco|[Pp]reciso|[Pp]regunta|[Pp]r\xf3pria|[Pp]rova|[Pp]rov\xe1vel|[Qq]ualquer|[Qq]ue|[Qq]uest\xe3o|[Rr]apariga|[Rr]az\xe3o|[Rr]eforma|[Rr]egra|[Rr]esposta|[Rr]evelava|[Rr]iqueza|[Ss]\xe1dica|[Ss]a\xedda|[Ss]alutar|[Ss]\xe3o|[Ss]ediciosa|[Ss]eja|[Ss]em|[Ss]emelhante|[Ss]er|[Ss]ido|[Ss]imples|[Ss]obre|[Ss]ofisticada|[Ss]ua|[Tt]al|[Tt]anta|[Tt]anto|[Tt]\xe3o|[Tt]em|[Tt]\xeam|[Tt]enho|[Tt]ens|[Tt]er|[Tt]ermo|[Tt]inha|[Tt]oda|[Tt]ornar|[Tt]ornou|[Uu]ma|[Vv]enerada|[Vv]ertente|[Vv]ida) pratica\\b")

# Identificacao de pratico sem acento
vpratico = re.compile("(?i)\\b([A-Za-z]+mente|[A-Za-z]+mento|[Aa]lcance|[Aa]lgum|[Aa]penas|[Aa]r|[Aa]specto|[Bb]astante|[Bb]em|[Cc]ampo|[Cc]ar\xe1ter|[Cc]ient\xedfico|[Cc]oeficiente|[Cc]omo|[Cc]ontrole|[Cc]urso|[Dd]e|[Dd]entista|[Dd]esempenho|[Dd]estino|[Dd]evasso|[Dd]o|[Dd]om\xednio|[Ee]|[\xc9\xe9]|[Ee]feito|[Ee]m|[Ee]nsino|[Ee]ra|[Ee]sp\xedrito|[Ee]ste|[Ee]stivesse|[Ee]studo|[Ee]xame|[Ee]xemplo|[Ee]xerc\xedcio|[Ff]ica|[Ff]il\xf3sofo|[Gg]\xeanio|[Gg]rande|[Gg]uia|[Hh]\xe1bito|[Hh]omem|[Ii]nteresse|[Ii]ntuito|[Ii]sso|[Jj]u\xedzo|[Ll]ado|[Mm]ais|[Mm]anejo|[Mm]anual|[Mm]arido|[Mm]eio|[Mm]enos|[Mm]\xe9todo|[Mm]odo|[Mm]uito|[Mm]undo|[Nn]ada|[Nn]avegante|[Nn]egociante|[Nn]\xedvel|[Oo]|[Oo]bjetivo|[Oo]lho|[Oo]utro|[Pp]a\xeds|[Pp]alavreado|[Pp]asso|[Pp]elo|[Pp]ouco|[Pp]rinc\xedpio|[Pp]roblema|[Pp]rocesso|[Pp]sic\xf3logo|[Rr]amo|[Rr]ealismo|[Rr]em\xe9dio|[Rr]espons\xe1vel|[Rr]esultado|[Rr]oteiro|[Ss]aber|[Ss]enso|[Ss]entido|[Ss]er|[Ss]er\xe1|[Ss]eria|[Ss]ignificado|[Ss]obretudo|[Ss]oldado|[Ss]ujeito|[Ss]uporte|[Tt]alento|[Tt]\xe3o|[Tt]erreno|[Tt]este|[Tt]ornar|[Tt]rabalho|[Tt]reino|[Uu]m|[Uu]so|[Vv]alor) pratico\\b")

# Identificacao de publica sem acento 
vpublica = re.compile("(?i)\\b([A-Za-z]+dade|[A-Za-z]+\xeancia|[A-Za-z]+[s\xE7]\xE3o|[A-Za-z]+\xe1ria|[A-Za-z]+mente|[\xc0\xe0]|[Aa]dvocacia|[Aa]genda|[Aa]legria|[Aa]lma|[Aa]ntipatia|[\xc1\xe1]rea|[Aa]rte|[Aa]ula|[Aa]ura|[Bb]astante|[Bb]em|[Bb]iblioteca|briga|[Cc]abine|[Cc]adeia|[Cc]adeira|[Cc]ampanha|[Cc]arreira|[Cc]arta|[Cc]asa|[Cc]ausa|[Cc]ena|[Cc]ensura|[Cc]erim\xf4nia|[Cc]i\xeancia|[Cc]isterna|[Cc]ivil|[Cc]oisa|[Cc]om|[Cc]onfian\xe7a|[Cc]onsulta|[Cc]onversa|[Cc]ousa|[Cc]r\xedtica|[Dd]a|[Dd]e|[Dd]efensora|[Dd]efensoria|[Dd]efesa|[Dd]emanda|[Dd]en\xfancia|[Dd]esgra\xe7a|[Dd]esonra|[Dd]esordem|[Dd]espedida|[Dd]espesa|[Dd]isputa|[Dd]\xedvida|\xe9|[Ee]conomia|[Ee]m|[Ee]missora|[Ee]mpresa|[Ee]ncomenda|\xeanfase|[Ee]ntrada|[Ee]ra|[Ee]scola|[Ee]scritura|[Ee]sfera|[Ee]st\xe1|[Ee]st\xe1tua|[Ee]steira|[Ee]stima|[Ee]vento|[Ee]xpectativa|[Ff]ace|[Ff]azem|[Ff]azenda|[Ff]\xe9|[Ff]eira|[Ff]esta|[Ff]ez|[Ff]igura|[Ff]inanceira|[Ff]ita|[Ff]onte|[Ff]ora|[Ff]oram|[Ff]or\xe7a|[Ff]orma|[Ff]ortuna|[Ff]osse|[Ff]otografia|[Gg]arantia|[Gg]astan\xe7a|[Hh]igiene|[Hh]ist\xf3ria|[Hh]omenagem|[Hh]onra|[Hh]ospitalar|[Ii]magem|[Ii]ncerteza|[Ii]ndiferen\xe7a|[Ii]nfraestrutura|[Ii]niciativa|[Ii]nseguran\xe7a|[Jj]usti\xe7a|[Ll]eitura|[Ll]impeza|[Ll]inguagem|[Ll]ivraria|[Ll]uz|[Mm]ais|[Mm]\xe1quina|[Mm]edicina|[Mm]em\xf3ria|[Mm]entira|[Mm]esa|[Mm]is\xe9ria|[Mm]issa|[Mm]od\xe9stia|[Mm]oral|[Mm]orte|[Mm]ulher|[Mm]useologia|[Nn]amorada|[Nn]atureza|[Nn]ot\xedcia|[Oo]bra|[Oo]ferta|[Oo]pini\xe3o|[Oo]rdem|[Oo]rgia|[Pp]alavra|[Pp]alestra|[Pp]arceria|[Pp]arte|[Pp]arvalheira|[Pp]asmaceira|[Pp]az|[Pp]ela|[Pp]enal|[Pp]erformance|[Pp]essoa|[Pp]ista|[Pp]ol\xeamica|[Pp]ol\xedtica|[Pp]osse|[Pp]oupan\xe7a|[Pp]ra\xe7a|[Pp]referissem|[Pp]regui\xe7a|[Pp]restando|[Pp]rofessora|[Pp]rofissional|[Pp]romessa|[Pp]romotora|[Pp]romotoria|[Pp]rova|[Qq]ueixa|[Qq]uest\xe3o|[Rr]az\xe3o|[Rr]eceita|[Rr]ede|[Rr]elev\xe2ncia|[Rr]epugn\xe2ncia|[Rr]et\xf3rica|[Rr]euni\xe3o|[Rr]iqueza|[Rr]uptura|[Ss]a\xfade|[Ss]ecretaria|[Ss]eguran\xe7a|[Ss]eja|[Ss]er|[Ss]er\xe1|[Ss]erventia|[Ss]ervidora|[Ss]ido|[Ss]impatia|[Ss]ocial|[Ss]olene|[Ss]uspeita|[Tt]anto|[Tt]\xe3o|[Tt]arifa|[Tt]elef\xf4nica|[Tt]irania|[Tt]oler\xe2ncia|[Tt]omada|[Tt]orna|[Tt]ornada|[Tt]ornado|[Tt]ornar|[Tt]ornasse|[Tt]ornava|[Tt]ornei|[Tt]ornou|[Tt]rajet\xf3ria|[Tt]ribuna|[Vv]enda|[Vv]ergonha|[Vv]ia|[Vv]iagem|[Vv]ida|[Vv]igil\xe2ncia|[Vv]irtude|[Vv]isita|[Vv]istoria|[Vv]oz) publica\\b")

# Identificacao de republica sem acento 
vrepub = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]ntiga|[Aa]quela|[Aa]tual|[Cc]ada|[Cc]omo|[Cc]omunista|[Cc]uriosa|[Dd]a|[Dd]aquela|[Dd]e|[Dd]emocr\xe1tica|[Dd]essa|[Dd]esta|[Dd]o|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]scola|[Ee]ssa|[Ee]sta|[Ff]amosa|[Ff]ez|[Ff]ormada|[Ff]ormosa|[Ff]osse|[Ff]utura|[Gg]loriosa|[Gg]rande|[Hh]aver\xe1|[Jj]\xe1|[Jj]ovem|[Jj]uvenil|[Mm]aldita|[Mm]inha|[Mm]iser\xe1vel|[Nn]a|[Nn]ascente|[Nn]em|[Nn]essa|[Nn]esta|[Nn]ossa|[Nn]ova|[Nn]uma|[Oo]u|[Oo]utra|[Pp]alavra|[Pp]ara|[Pp]ela|[Pp]equena|[Pp]obre|[Pp]or|[Pp]rimeira|[Qq]uarta|[Qq]ue|[Qq]uinta|[Ss]egunda|[Ss]ua|[Tt]erceira|[\xda\xfa]ltima|[Uu]ma|[Vv]elha|[Vv]erdadeira|[Vv]izinha) republica\\b")

# Identificacao de tabula sem acento
vtabula = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]lguma|[Aa]ntiga|[Aa]quela|[\xc0\xe0]quela|[Aa]ut\xeantica|[Cc]ada|[Cc]hamavam|[Cc]om|[Dd]a|[Dd]aquela|[Dd]e|[Dd]\xe9cima|[Dd]esta|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ssa|[Ee]sta|[Ff]az|[Ff]ez|[Gg]rande|[Gg]rossa|[Ii]mensa|[Mm]aior|[Mm]elhor|[Mm]esma|[Nn]a|[Nn]aquela|[Nn]esta|[Nn]ossa|[Nn]ova|[Nn]uma|[Oo]u|[Oo]utra|[Pp]ela|[Pp]equena|[Pp]r\xf3pria|[Qq]ualquer|[Qq]ue|[Rr]eferida|[Rr]ica|[Ss]em|[Ss]ua|[Tt]anta|[\xda\xfa]ltima|[Uu]ma|[\xda\xfa]nica|[Vv]elha|[Vv]erdadeira) tabula\\b")

# Identificacao de tabula com acento 
vtabulb = re.compile("(?i)\\b([A-Za-z]+or|[A-Za-z]+ora|[A-Za-z\xe1]+tico|[A-Za-z\xe9]+nico|[A-Za-z]+al|[A-Za-z]+dade|[A-Za-z]+\xeancia|[A-Za-z]+[s\xE7]\xE3o|[A-Za-z]+\xe1ria|[A-Za-z]+mente|[Aa]lun[ao]) t\xe1bula\\b")

# Identificacao de credito sem acento 
vcredito = re.compile("(?i)\\b([Aa]|[Aa]bonando|[Aa]bre|[Aa]brir|[Aa]cessar|[Aa]charia|[Aa]dmitem|[Aa]lcan\xe7arem|[Aa]lgum|[Aa]ltera|[Aa]mpliar|[Aa]ntigo|[Aa]o|[Aa]presente|[Aa]rranjou|[Bb]om|[Bb]onito|[Bb]uscando|[Bb]uscar|[Cc]olocou|[Cc]om|[Cc]omo|[Cc]oncedam|[Cc]oncede|[Cc]onceder|[Cc]oncedia|[Cc]onsegue|[Cc]onseguiram|[Cc]onsolidado|[Cc]onstar\xe3o|[Cc]onstituir\xe1|[Cc]ontratar|[Cc]ronista|[Cc]ujo|[Dd]ado|[Dd]ai|[Dd]ando|[Dd]ar|[Dd]aria|[Dd]ar\xedeis|[Dd]ava|[Dd]e|[Dd]ei|[Dd]era|[Dd]eram|[Dd]ermos|[Dd]esse|[Dd]esses|[Dd]este|[Dd]eterminado|[Dd]eu|[Dd]evido|[Dd]o|[\xc9\xe9]|[Ee]|[Ee]m|[Ee]mpresas|[Ee]ncontra|[Ee]scasso|[Ee]sse|[Ee]ste|[Ee]studa|[Ee]vento|[Ee]ventual|[Ff]itas|[Ff]ornecer|[Gg]anhara|[Gg]anhar\xe3o|[Gg]anhasse|[Gg]arante|[Gg]arantir|[Gg]rande|[Hh]\xe1|[Hh]aver\xe1|[Ii]menso|[Ii]mplicam|[Ii]mplicar\xe1|[Ii]nteiro|[Ll]argo|[Mm]aior|[Mm]ais|[Mm]ediante|[Mm]enor|[Mm]enos|[Mm]erece|[Mm]erecem|[Mm]erecerem|[Mm]esmo|[Mm]eu|[Mm]uda|[Mm]uito|[Mm]unicipal|[Nn]\xe3o|[Nn]egar|[Nn]em|[Nn]enhum|[Nn]o|[Nn]osso|[Nn]ovo|[Oo]|[Oo]bt\xe9m|[Oo]bter|[Oo]btinham|[Oo]btiveram|[Oo]corre|[Oo]ferecendo|[Oo]u|[Pp]ara|[Pp]ede|[Pp]elo|[Pp]equeno|[Pp]iano|[Pp]leno|[Pp]or|[Pp]ouco|[Pp]oupan\xe7a|[Pp]residente|[Pp]restar|[Pp]rimeiro|[Pp]r\xf3prio|[Qq]ualquer|[Qq]uer|[Qq]ueremos|[Rr]eceber|[Rr]eceberam|[Rr]egateavam|[Rr]espectivo|[Rr]estringem|[Rr]estringir|[Ss]egundo|[Ss]em|[Ss]eu|[Ss]implifica|[Ss]obre|[Ss]olicitar|[Tt]al|[Tt]anto|[Tt]em|[Tt]\xeam|[Tt]enho|[Tt]er|[Tt]er\xe1|[Tt]eu|[Tt]inha|[Tt]iveram|[Tt]ivessem|[Tt]ransferir|[\xda\xfa]ltimo|[Uu]m|[Uu]tilizado|[Vv]olume|[Vv]osso) credito\\b")

# Identificacao de debito sem acento 
vdebito = re.compile("(?i)\\b([Aa]|[Aa]lgum|[Aa]lto|[Aa]o|[Aa]presenta|[Aa]presente|[Aa]presentou|[Cc]om|[Cc]omo|[Dd]e|[Dd]esse|[Dd]o|[\xc9\xe9]|[Ee]|[Ee]m|[Ee]sse|[Hh]aja|[Hh]avia|[Ii]mportante|[Mm]aior|[Mm]ediante|[Mm]enor|[Mm]eu|[Nn]o|[Nn]ovo|[Oo]|[Oo]u|[Pp]agar|[Pp]ara|[Pp]rimeiro|[Qq]ualquer|[Ss]em|[Ss]eu|[Ss]\xf3|[Ss]omente|[Tt]eu|[Uu]m|[\xda\xfa]nico|[\xda\xfa]ltimo|[Vv]elho|[Zz]era|[Zz]erou|[Zz]eraram|[Zz]erei) debito\\b")

# Identificacao de exercito sem acento 
vexercito = re.compile("(?i)\\b([0-9]+\xba|[Aa]gora|[Aa]ntigo|[Aa]o|[Aa]poia|[Aa]quele|[Aa]utodenomina|[Bb]om|[Bb]rilhante|[Cc]ada|[Cc]hamado|[Cc]om|[Cc]ujo|[Dd]aquele|[Dd]e|[Dd]\xe9cimo|[Dd]enominada|[Dd]enominado|[Dd]esmobilizado|[Dd]esse|[Dd]este|[Dd]iminuto|[Dd]izer|[Dd]o|[Ee]|[Ee]lo|[Ee]m|[Ee]norme|[Ee]ntre|[Ee]quipado|[Ee]sse|[Ee]ste|[Ff]ormid\xe1vel|[Ff]orte|[Ff]uturo|[Gg]rande|[Gg]rupo|[Hh]umilde|[Ii]menso|[Ii]ra|[Ll]amuriento|[Ll]ento|[Ll]evantar|[Ll]evar\xe3o|[Mm]aior|[Mm]elhor|[Mm]esmo|[Mm]obiliza|[Mm]otivado|[Nn]em|[Nn]esse|[Nn]o|[Nn]ono|[Nn]osso|[Nn]ovo|[Nn]um|[Nn]umeroso|[Oo]|[Oo]itavo|[Oo]rdenado|[Oo]u|[Oo]utro|[Pp]ac\xedfico|[Pp]elo|[Pp]equeno|[Pp]oderoso|[Pp]otencial|[Pp]reparado|[Pp]rimeiro|[Pp]r\xf3prio|[Qq]ualquer|[Qq]uarto|[Qq]uinto|[Rr]ebelde|[Rr]estante|[Ss]egundo|[Ss]em|[Ss]\xe9timo|[Ss]eu|[Ss]exto|[Ss]\xf3|[Ss]obre|[Tt]erceiro|[Tt]\xednhamos|[Uu]m|[Uu]ma|[Vv]asto|[Vv]elho|[Vv]issem) [Ee]xercito\\b")

# Identificacao de interprete sem acento 
vinterprete = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]o|[Aa]penas|[Aa]quele|[Bb]rilhante|[Cc]abal|[Cc]ada|[Cc]arvalho|[Cc]omo|[Cc]ompetente|[Cc]ompleto|[Dd]a|[Dd]e|[Dd]epois|[Dd]o|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]nquanto|[Ee]ste|[Ee]xcelente|[Ff]amosa|[Ff]iel|[Ff]oi|[Gg]igante|[Gg]rande|[Gg]uia|[Ii]mportante|[Jj]ovem|[Ll]eg\xedtimo|[Mm]aior|[Mm]elhor|[Mm]inha|[Nn]o|[Oo]|[Pp]ara|[Pp]elo|[Pp]or|[Pp]rimeira|[Pp]rimeiro|[Pp]rincipal|[Pp]r\xf3prio|[Rr]espeitoso|[Ss]er|[Ss]eu|[Ss]ou|[Ss]ua|[Tt]em|[Tt]eria|[Tt]radutor|[Tt]ribunal|[Uu]m|[Uu]ma|[\xda\xfa]nico|[Vv]erboso|[Vv]irtual) interprete\\b")

# Identificacao de perpetua com acento 
vperpetua = re.compile("(?i)\\b([Ee]|[Ee]la|[Ee]le|[Qq]ue|[Ss]e|[Vv]oc\xea) perpetua\\b")

# Identificacao de replica sem acento 
vreplica = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]chou|[Aa]dmite|[Aa]dmitia|[Aa]dmito|[Aa]lguma|[Aa]quela|[Bb]oa|[Bb]reve|[Cc]om|[Cc]omo|[Cc]uja|[Dd]a|[Dd]ar|[Dd]ava|[Dd]e|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]xcelente|[Ee]xigem|[Hh]ouve|[Mm]inha|[Mm]\xednima|[Mm]uita|[Nn]a|[Nn]aquela|[Oo]ferecia|[Pp]ela|[Pp]rimeira|[Pp]rovocava|[Qq]ualquer|[Ss]em|[Ss]ua|[Tt]em|[Tt]ermos|[\xda\xfa]ltima|[Uu]m|[Uu]ma|[Vv]erdadeira) replica\\b")

# Identificacao de tremula sem acento 
vtremula = re.compile("(?i)\\b([Oo]) ([a-zA-Z\xE1\xE2\xE3\xE7\xE9\xEA\xED\xF3\xF4\xFA]+) tremula\\b")

# Identificacao de auxilio sem acento 
vauxilio = re.compile("(?i)\\b([Aa]inda|[Aa]lgum|[Aa]ntes|[Aa]o|[Aa]quele|[Aa]ssegurados|[Bb]elo|[Bb]om|[Bb]uscar|[Cc]\xe9u|[Cc]hamo|[Cc]hamou|[Cc]om|[Cc]omo|[Cc]onceder|[Cc]onsider\xe1vel|[Cc]ujo|[Dd]ava|[Dd]e|[Dd]ecisivo|[Dd]esse|[Dd]essem|[Dd]ispensando|[Dd]ispensar|[Dd]o|[\xc9\xe9]|[Ee]|[Ee]m|[Ee]ncontrar|[Ee]sperando|[Ee]sperar|[Ee]sse|[Ff]orneceu|[Gg]eneroso|[Gg]rande|[Gg]rave|[Ii]mplorando|[Ii]mportante|[Ii]nc\xf4modo|[Ii]nsignificante|[Jj]ustific\xe1vel|[Mm]aior|[Mm]ais|[Mm]enor|[Mm]eu|[Nn]ecessitando|[Nn]egar|[Nn]enhum|[Nn]o|[Nn]osso|[Oo]|[Oo]bter|[Oo]ferecer|[Oo]u|[Oo]utro|[Pp]ara|[Pp]e\xe7a|[Pp]e\xe7amos|[Pp]e\xe7as|[Pp]e\xe7o|[Pp]ede|[Pp]edido|[Pp]edia|[Pp]ediam|[Pp]ed\xedamos|[Pp]edimos|[Pp]edindo|[Pp]edir|[Pp]edira|[Pp]edir\xe1|[Pp]edir\xe3o|[Pp]ediram|[Pp]edirei|[Pp]ediremos|[Pp]ediria|[Pp]ediriam|[Pp]edisse|[Pp]ediu|[Pp]elo|[Pp]equeno|[Pp]ermanente|[Pp]oderoso|[Pp]or|[Pp]otente|[Pp]ouco|[Pp]recioso|[Pp]restam|[Pp]restando|[Pp]restar|[Pp]restaram|[Pp]restar\xe3o|[Pp]reste|[Pp]restou|[Pp]rocurando|[Pp]rocurar|[Pp]rocurassem|[Pp]rocurou|[Pp]rometeu|[Pp]rometeram|[Pp]rometiam|[Pp]ronto|[Qq]ualquer|[Rr]eceber|[Rr]eceberam|[Rr]ecebeu|[Rr]ecebido|[Rr]ecusavam|[Rr]equerendo|[Ss]em|[Ss]eu|[Ss]imples|[Ss]\xf3|[Ss]olicitar|[Ss]olicitou|[Ss]uplicaram|[Ss]uplicou|[Ss]ustentado|[Tt]amb\xe9m|[Tt]anto|[Tt]em|[Tt]\xeam|[Tt]emos|[Tt]enha|[Tt]enho|[Tt]er\xe1|[Tt]er\xe3o|[Tt]erei|[Tt]eria|[Tt]eriam|[Tt]eu|[Tt]eve|[Tt]ido|[Tt]inha|[Tt]inham|[Tt]ive|[Tt]ivera|[Tt]iveram|[Tt]r\xedplice|[Uu]m|[\xda\xfa]nico|[\xda\xfa]til|[Vv]alioso|[Vv]eio|[Vv]inha|[Vv]ir\xe1|[Vv]iria|[Vv]iriam) auxilio\\b")

# Identificacao de distancia sem acento 
vdistancia = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]brindo|[Aa]lguma|[Aa]parente|[Aa]quela|[\xc0\xe0]quela|[Bb]astante|[Bb]oa|[Bb]reve|[Cc]aso|[Cc]erta|[Cc]om|[Cc]onsider\xe1vel|[Cc]uja|[Cc]urta|[Dd]a|[Dd]ada|[Dd]aquela|[Dd]e|[Dd]enominada|[Dd]esconsoladora|[Dd]eseja|[Dd]essa|[Dd]esta|[Dd]eterminada|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ncurtar|[Ee]norme|[Ee]ssa|[Ee]sta|[Ee]xigia|[Ee]xiste|[Ee]xplorada|[Ff]irme|[Gg]anhar|[Gg]anhara|[Gg]\xe9lida|[Gg]rande|[Gg]uardando|[Gg]uardou|[Hh]\xe1|[Hh]abitual|[Hh]avia|[Hh]ouvera|[Ii]gual|[Ii]mensa|[Ii]mpercorr\xedvel|[Ii]mp\xf5e|[Ii]mpunha|[Ii]naceit\xe1vel|[Ii]ndicando|[Ii]nsond\xe1vel|[Ii]nt\xe9rmina|[Ii]nterpusesse|[Ii]ntranspon\xedvel|[Ll]arga|[Ll]onga|[Mm]aior|[Mm]ais|[Mm]antendo|[Mm]antenha|[Mm]anter|[Mm]arcando|[Mm]\xe9dia|[Mm]eia|[Mm]enor|[Mm]esma|[Mm]\xednima|[Mm]uita|[Nn]a|[Nn]aquela|[Nn]ecess\xe1ria|[Nn]enhuma|[Nn]essa|[Nn]esta|[Nn]ot\xe1vel|[Nn]uma|[Oo]u|[Pp]ela|[Pp]equena|[Pp]or|[Pp]ouca|[Pp]rimeira|[Pp]r\xf3pria|[Qq]ualquer|[Qq]ue|[Qq]uer|[Qq]uerem|[Qq]ueria|[Qq]uero|[Qq]uis|[Rr]azo\xe1vel|[Rr]elativa|[Rr]emovida|[Rr]epresentar|[Rr]espectiva|[Rr]espeit\xe1vel|[Rr]espeitosa|[Ss]egura|[Ss]em|[Ss]ua|[Tt]al|[Tt]anta|[Tt]inha|[Tt]omando|[Tt]omou|[\xda\xfa]ltima|[\xda\xfa]nica|[Uu]ma|[Vv]ence|[Vv]enceu[Aa]|[\xc0\xe0]|[Aa]brindo|[Aa]lguma|[Aa]parente|[Aa]quela|[\xc0\xe0]quela|[Bb]astante|[Bb]oa|[Bb]reve|[Cc]aso|[Cc]erta|[Cc]om|[Cc]onsider\xe1vel|[Cc]uja|[Cc]urta|[Dd]a|[Dd]ada|[Dd]aquela|[Dd]e|[Dd]enominada|[Dd]esconsoladora|[Dd]eseja|[Dd]essa|[Dd]esta|[Dd]eterminada|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ncurtar|[Ee]norme|[Ee]ssa|[Ee]sta|[Ee]xigia|[Ee]xiste|[Ee]xplorada|[Ff]irme|[Gg]anhar|[Gg]anhara|[Gg]\xe9lida|[Gg]rande|[Gg]uardando|[Gg]uardou|[Hh]\xe1|[Hh]abitual|[Hh]avia|[Hh]ouvera|[Ii]gual|[Ii]mensa|[Ii]mpercorr\xedvel|[Ii]mp\xf5e|[Ii]mpunha|[Ii]naceit\xe1vel|[Ii]ndicando|[Ii]nsond\xe1vel|[Ii]nt\xe9rmina|[Ii]nterpusesse|[Ii]ntranspon\xedvel|[Ll]arga|[Ll]onga|[Mm]aior|[Mm]ais|[Mm]antendo|[Mm]antenha|[Mm]anter|[Mm]arcando|[Mm]\xe9dia|[Mm]eia|[Mm]enor|[Mm]esma|[Mm]\xednima|[Mm]uita|[Nn]a|[Nn]aquela|[Nn]ecess\xe1ria|[Nn]enhuma|[Nn]essa|[Nn]esta|[Nn]ot\xe1vel|[Nn]uma|[Oo]u|[Pp]ela|[Pp]equena|[Pp]or|[Pp]ouca|[Pp]rimeira|[Pp]r\xf3pria|[Qq]ualquer|[Qq]ue|[Qq]uer|[Qq]uerem|[Qq]ueria|[Qq]uero|[Qq]uis|[Rr]azo\xe1vel|[Rr]elativa|[Rr]emovida|[Rr]epresentar|[Rr]espectiva|[Rr]espeit\xe1vel|[Rr]espeitosa|[Ss]egura|[Ss]em|[Ss]ua|[Tt]al|[Tt]anta|[Tt]inha|[Tt]omando|[Tt]omou|[\xda\xfa]ltima|[\xda\xfa]nica|[Uu]ma|[Vv]ence|[Vv]elha) distancia\\b")

# Identificacao de circulo sem acento 
vcirculo = re.compile("(?i)\\b([Aa]canhado|[Aa]legre|[Aa]mplo|[Aa]o|[Aa]pertado|[Aa]quele|[Aa]ristocr\xe1tico|[Bb]reve|[Cc]ada|[Cc]hamado|[Cc]omo|[Dd]aquele|[Dd]e|[Dd]enominado|[Dd]eplor\xe1vel|[Dd]esfecho|[Dd]esse|[Dd]este|[Dd]o|[Dd]um|[Dd]uplo|[Ee]m|[Ee]sse|[Ee]ste|[Ee]streit\xedssimo|[Ee]streito|[Ee]terno|[Ff]azer|[Ff]azia|[Ff]eito|[Ff]izemos|[Ff]ormando|[Ff]ormavam|[Gg]rande|[Ii]menso|[Ii]mplac\xe1vel|[Ii]mponder\xe1vel|[Ii]mportante|[Ll]argo|[Ll]eg\xedtimo|[Ll]imitado|[Ll]iter\xe1rio|[Mm]aior|[Mm]aldito|[Mm]eio|[Mm]esmo|[Mm]esquinho|[Mm]eu|[Mm]onstruoso|[Nn]aquele|[Nn]esse|[Nn]este|[Nn]o|[Nn]osso|[Nn]outro|[Nn]um|[Oo]|[Oo]itavo|[Oo]utro|[Pp]elo|[Pp]equen\xedssimo|[Pp]equeno|[Pp]or|[Pp]rimeiro|[Pp]rimitivo|[Pp]r\xf3prio|[Qq]ue|[Qq]uinto|[Rr]eduzido|[Rr]espeitoso|[Ss]egundo|[Ss]erviram|[Ss]eu|[Ss]uspeito|[Tt]err\xedvel|[Tt]inha|[Tt]razia|[\xda\xfa]ltimo|[Uu]m|[Uu]ni|[Vv]asto) circulo\\b")

# Identificacao de transito sem acento 
vtransito= re.compile("(?i)\\b([Aa]gravam|[Aa]lgum|[Aa]livia|[Aa]o|[Bb]astante|[Bb]om|[Cc]a\xf3tico|[Cc]om|[Cc]ontrolam|[Cc]ujo|[Dd]e|[Dd]o|[Ee]|[Ee]m|[Ee]nfrentou|[Ee]sse|[Ee]ste|[Ff]\xe1cil|[Ff]ar\xe1|[Gg]rande|[Hh]\xe1|[Hh]aver|[Hh]avia|[Ii]nferniza|[Ii]nfernizam|[Ii]ntermitente|[Ll]argo|[Ll]ento|[Ll]ivre|[Mm]aior|[Mm]ais|[Mm]uda|[Mm]uito|[Nn]este|[Nn]o|[Oo]|[Oo]ferecer|[Oo]rientam|[Pp]ara|[Pp]\xe1ra|[Pp]aram|[Pp]elo|[Pp]ior|[Pp]or|[Pp]rev\xea|[Pp]r\xf3prio|[Rr]ealizando|[Rr]eformula|[Ss]em|[Ss]eu|[Ss]imples|[Ss]obre|[Ss]ol|[Tt]anto|[Tt]em|[Tt]emeroso|[Tt]er|[Tt]inha|[Tt]iveram|[Tt]ivessem|[\xda\xfa]ltimo|[Uu]m) transito\\b")

# Identificacao de tramite sem acento 
vtramite= re.compile("(?i)\\b([Aa]lgum|[Aa]o|[Aa]quele|[Bb]om|[Cc]ada|[Cc]om|[Cc]ontrolam|[Cc]ujo|[Dd]e|[Dd]o|[Ee]|[Ee]m|[Ee]sse|[Ee]ste|[Hh]\xe1|[Hh]aver|[Hh]avia|[Ll]ivre|[Mm]aior|[Mm]ais|[Mm]uda|[Mm]uito|[Nn]ecess\xe1rio|[Nn]esse|[Nn]este|[Nn]o|[Oo]|[Pp]ara|[Pp]\xe1ra|[Pp]aram|[Pp]elo|[Pp]or|[Pp]rimeiro|[Rr]eferido|[Ss]em|[Ss]eu|[Ss]imples|[Ss]obre|[Tt]anto|[Tt]em|[Tt]er|[Tt]inha|[Tt]iveram|[Tt]ivessem|[\xda\xfa]ltimo|[Uu]m) tramite\\b")

# Identificacao de animo sem acento 
vanimo= re.compile("(?i)\\b([Aa]lgum|[Aa]o|[Aa]quele|[Bb]om|[Cc]ada|[Cc]om|[Cc]ujo|[Dd]e|[Dd]o|[\xc9\xe9]|[Ee]|[Ee]m|[Ee]sse|[Ee]ste|[Hh]\xe1|[Hh]aver|[Hh]avia|[Mm]aior|[Mm]ais|[Mm]elhor|[Mm]eu|[Mm]uda|[Mm]uito|[Nn]esse|[Nn]este|[Nn]o|[Nn]osso|[Oo]|[Pp]elo|[Pp]or|[Ss]em|[Ss]eu|[Ss]obre|[Tt]anto|[Tt]em|[Tt]er|[Tt]eu|[Tt]inha|[Tt]iveram|[Tt]ivessem|[Uu]m) animo\\b")

# Identificacao de parodia sem acento
vparodia = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]lguma|[Aa]quela|[Aa]trevida|[Bb]ela|[Bb]oa|[Cc]ada|[Cc]\xe9lebre|[Cc]erta|[Cc]om|[Dd]a|[Dd]aquela|[Dd]e|[Dd]essa|[Dd]esta|[Dd]ivertida|[Dd]uma|[\xc9\xe9]|[Ee]m|[Ee]ssa|[Ee]sta|[Ff]eia|[Ii]nteressante|[Mm]esma|[Mm]inha|[Nn]a|[Nn]aquela|[Nn]em|[Nn]enhuma|[Nn]uma|[Oo]utra|[Pp]ela|[Pp]equena|[Pp]obre|[Pp]or|[Pp]\xf4r|[Pp]rimeira|[Ss]em|[Ss]ua|[Tt]al|[Tt]razem|[Tt]raziam|[Tt]ua|[Uu]ma|[Vv]elha) parodia\\b")

# Identificacao de concilio sem acento 
vconcilio= re.compile("(?i)\\b([CILMXV]+|[Aa]lgum|[Aa]o|[Aa]quele|[Cc]ada|[Cc]ujo|[Dd]e|[Dd]o|[Ee]m|[Ee]sse|[Ee]ste|[Hh]\xe1|[Hh]aver|[Hh]avia|[Mm]aior|[Mm]ais|[Mm]elhor|[Mm]uda|[Mm]uito|[Nn]esse|[Nn]este|[Nn]o|[Nn]osso|[Nn]um|[Oo]|[Pp]elo|[Pp]or|[Pp]rimeiro|[Qq]uarto|[Qq]uinto|[Ss]agrado|[Ss]anto|[Ss]ecreto|[Ss]egundo|[Ss]em|[Ss]exto|[Ss]\xe9timo|[Ss]eu|[Tt]erceiro|[Uu]m) [Cc]oncilio\\b")

# Identificacao de continua sem acento 
vcontinua= re.compile("(?i)\\b([a-z]+[s\xe7]\xe3o|[Aa]|[\xc0\xe0]|[Aa]n\xe1lise|[Aa]prendizagem|[Aa]quela|[Cc]amada|[Cc]onectividade|[Cc]orreia|[Cc]orrente|[Dd]a|[Dd]e|[Dd]escarga|[Dd]essa|[Dd]iscursiva|[\xc9\xe9]|[Ee]m|[Ee]ra|[Ee]ssa|[Ee]scala|[Ee]spera|[Ee]ssa|[Ee]sta|[Ee]st\xe1|[Ee]strutura|[Ff]ase|[Ff]oi|[Ff]orma|[Ii]nconst\xe2ncia|[Ll]eitura|[Ll]ida|[Ll]inha|[Ll]uta|[Mm]ais|[Mm]alha|[Mm]aneira|[Mm]archa|[Mm]assa|[Mm]atriz|[Mm]edida|[Mm]elhoria|[Mm]oldagem|[Nn]a|[Nn]atureza|[Nn]ecessariamente|[Nn]essa|[Nn]uma|[Pp]arte|[Pp]ela|[Pp]or|[Pp]\xfablica|[Qq]ueda|[Rr]ajada|[Rr]eciclagem|[Ss]ai|[Ss]a\xedda|[Ss]er|[Ss]\xe9rie|[Ss]uperf\xedcie|[Tt]\xe3o|[Uu]ma|[Vv]igil\xe2ncia) continua\\b")

# Identificacao de continuo sem acento 
vcontinuo= re.compile("(?i)\\b([Aa]|[Aa]bandono|[Aa]buso|[Aa]cionamento|[Aa]\xe7oite|[Aa]companhamento|[Aa]fastamento|[Aa]lgo|[Aa]ntigo|[Aa]o|[Aa]rdor|[Aa]taque|[Aa]to|[Aa]trito|[Aa]umento|[Aa]ustero|[Bb]ailado|[Bb]aixo|[Bb]arateamento|[Bb]arulho|[Bb]om|[Bb]rado|[Cc]iclo|[Cc]ircular|[Cc]itoplasma|[Cc]om|[Cc]ombate|[Cc]om\xe9rcio|[Cc]onjunto|[Cc]rescendo|[Cc]rescer|[Cc]rescimento|[Cc]ultivo|[Dd]aquele|[Dd]e|[Dd]ecair|[Dd]eclive|[Dd]esde|[Dd]esdobramento|[Dd]esejo|[Dd]esencontro|[Dd]esenvolver|[Dd]esenvolvimento|[Dd]esgaste|[Dd]eslumbramento|[Dd]isparo|[Dd]o|[Dd]um|[\xc9\xe9]|[Ee]m|[Ee]mpobrecimento|[Ee]nfraquecimento|[Ee]ntre|[Ee]ra|[Ee]ros\xe3o|[Ee]sfor\xe7o|[Ee]spectro|[Ee]sse|[Ee]stado|[Ee]ste|[Ff]io|[Ff]lagelo|[Ff]luido|[Ff]luxo|[Ff]oco|[Ff]ogo|[Ff]oi|[Ff]ornecimento|[Ff]orno|[Ff]riso|[Ff]ui|[Gg]emido|[Gg]iro|[Gg]olpe|[Gg]ravitar|[Hh]\xe1bito|[Ii]nstrumento|[Ii]nterdisciplinar|[Ii]nteresse|[Ii]nvestimento|[Jj]ato|[Jj]ogo|[Ll]abor|[Ll]abutar|[Ll]evantamento|[Mm]ais|[Mm]ental|[Mm]odo|[Mm]onitoramento|[Mm]ontanhoso|[Mm]ovimento|[Mm]urm\xfario|[Nn]o|[Nn]ovo|[Nn]um|[Nn]um\xe9rico|[Oo]|[Oo]rdem|[Pp]adecer|[Pp]aralelo|[Pp]elo|[Pp]ensamento|[Pp]esar|[Pp]igarro|[Pp]or|[Pp]ovoamento|[Pp]rocesso|[Qq]uase|[Qq]uerer|[Rr]econhecimento|[Rr]egime|[Rr]egistador|[Rr]egisto|[Rr]esfriamento|[Rr]evezamento|[Rr]isco|[Rr]itmo|[Rr]odopiar|[Rr]olo|[Rr]u\xeddo|[Rr]umor|[Ss]eja|[Ss]ente|[Ss]er\xe1|[Ss]ervi\xe7o|[Ss]eu|[Ss]imples|[Ss]istema|[Ss]olu\xe7ar|[Ss]om|[Ss]onho|[Ss]ubconsciente|[Ss]ubir|[Ss]usto|[Tt]\xe3o|[Tt]empo|[Tt]\xe9rmico|[Tt]exto|[Tt]rabalho|[Tt]ra\xe7ado|[Tt]ra\xe7o|[Tt]rato|[Tt]rem|[Tt]remor|[Tt]ropear|[Tt]urbilh\xe3o|[Uu]m|[Uu]so|[Vv]aiv\xe9m|[Vv]elho|[Vv]ertia|[Vv]olver|[Vv]\xf4mito|[Vv]oo|[Vv]oz|[Zz]unido) continuo\\b")

# Identificacao de especifica sem acento 
vspecifa= re.compile("(?i)\\b([a-z]+nte|[a-z]+tar|[a-z]+o[nsrv]a|[a-z]+[s\xe7]\xe3o|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+ica|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+ria|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+tura|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+ral|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+ade|[a-z\xea\xe2]+ncia|[a-z]+gia|[a-z]+cial|[a-z]+iva|[a-z]+ional|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+ica|[Aa]bordagem|[Aa]n\xe1lise|[\xc1\xe1]rea|[Aa]rte|[Aa]ssembleia|[Aa]titude|[Bb]ase|[Bb]em|[Bb]iblioteca|[Cc]artilha|[Cc]ausa|[Cc]autelar|[Cc]lasse|[Cc]l\xe1usula|[Cc]oisa|[Cc]om|[Cc]onhecimento|[Cc]or|[Cc]ura|[Dd]a|[Dd]ata|[Dd]e|[Dd]ieta|[Dd]iferen\xe7a|[Dd]isciplina|[Dd]oen\xe7a|[Ee]|[\xc9\xe9]|[Ee]mpresa|[\xca\xea]nfase|[Ee]nzima|[\xc9\xe9]poca|[Ee]ra|[Ee]scala|[Ee]scolha|[Ee]tnia|[Ff]aixa|[Ff]erramenta|[Ff]obia|[Ff]oi|[Ff]olha|[Ff]orma|[Ff]ranja|[Gg]ama|[Ii]deia|[Ii]nterface|[Ll]egal|[Ll]ei|[Ll]\xedngua|[Ll]inguagem|[Ll]inha|[Mm]ais|[Mm]aneira|[Mm]arca|[Mm]assa|[Mm]edida|[Mm]ental|[Mm]eta|[Mm]udan\xe7a|[Mm]uito|[Mm]undo|[Mm]usical|[Nn]a|[Nn]eg\xf3cios|[Nn]enhuma|[Nn]orma|[Oo]rdem|[Oo]utra|[Pp]aix\xe3o|[Pp]arte|[Pp]esquisa|[Pp]essoa|[Pp]re\xe7o|[Pp]re\xe7os|[Pp]roposta|[Pp]rote\xedna|[Qq]ueixa|[Qq]uest\xe3o|[Rr]a\xe7a|[Rr]egi\xe3o|[Rr]egra|[Rr]eligi\xe3o|[Rr]esposta|[Rr]iqueza|[Ss]a\xedda|[Ss]ala|[Ss]er|[Ss]impatia|[Ss]intaxe|[Ss]ub\xe1rea|[Tt]\xe3o|[Tt]arefa|[Tt]ribal|[Tt]utela|[Tt]utelar|[Uu]ma|[Uu]rbana|[Vv]ari\xe1vel|[Vv]ia|[Vv]isual|[Vv]ocabular) especifica\\b")

# Identificacao de especifico sem acento 
vspecifo= re.compile("(?i)\\b([a-z]+nte|[a-z]+nto|[a-z]+sto|[a-z]+i[tv]o|[a-z]+ado|[a-z]+[s\xe7]\xe3o|[a-z]+[dt]or|[a-z]+eto|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+ico|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+rio|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+ulo|[a-z\xe1\xe2\xe9\xed\xf3\xf4\xfa]+ismo|[Aa]cordo|[Aa]lgo|[Aa]lgoritmo|[Aa]lvo|[\xc2\xe2]mbito|[Aa]nticorpo|[Aa]poio|[Aa]rranjo|[Aa]rtigo|[Aa]specto|[Aa]to|[Bb]em|[Cc]alor|[Cc]aminho|[Cc]ampo|[Cc]anal|[Cc]ar\xe1cter|[Cc]aso|[Cc]heiro|[Cc]onte\xfado|[Cc]ontexto|[Cc]orpo|[Cc]urso|[Dd]e|[Dd]eficit|[Dd]emanda|[Dd]esejo|[Dd]espacho|[Dd]iploma|[Dd]o|[Dd]olo|[Dd]om\xednio|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]mbora|[Ee]ndere\xe7o|[Ee]nergia|[Ee]stilo|[Ee]stresse|[Ee]studo|[Ee]xame|[Ee]xemplo|[Ff]en\xf4meno|[Ff]im|[Ff]oi|[Ff]ruto|[Ff]undo|[Gg]ene|[Gg]\xeanero|[Gg]rupo|[Hh]abitat|[\xcd\xed]ndice|[Ii]ndiv\xedduo|[Ii]nimigo|[Ii]nteresse|[Ii]ntervalo|[Jj]arg\xe3o|[Ll]imite|[Ll]ocal|[Ll]ugar|[Mm]ais|[Mm]andato|[Mm]arketing|[Mm]aterial|[Mm]\xe9todo|[Mm]eu|[Mm]odo|[Nn]ada|[Nn]\xe3o|[Nn]ome|[Nn]\xfamero|[Oo]|[Oo]nda|[\xd3\xf3]rg\xe3o|[Pp]adr\xe3o|[Pp]alco|[Pp]apel|[Pp]erigo|[Pp]eso|[Pp]esquisa|[Pp]razo|[Pp]reparo|[Pp]roblema|[Pp]rocesso|[Pp]roduto|[Pp]rograma|[Qq]uase|[Rr]egistro|[Rr]em\xe9dio|[Rr]isco|[Rr]itual|[Rr]oteiro|[Ss]eja|[Ss]ensor|[Ss]entido|[Ss]ervi\xe7o|[Ss]istema|[Ss]ite|[Ss]ocial|[Ss]om|[Ss]oro|[Ss]ubstrato|[Tt]\xe3o|[Tt]ecidular|[Tt]empo|[Tt]ermo|[Tt]exto|[Tt]ipo|[Tt]rabalho|[Tt]reino|[\xda\xfa]ltimo|[Uu]m|[Uu]so|[Vv]alor|[Vv]isual) especifico\\b")

# Identificacao de estimulo sem acento 
vestimulo= re.compile("(?i)\\b([Aa]|[Aa]lgum|[Aa]o|[\xc0\xe0]quele|[Aa]rdente|[Cc]ada|[Cc]laro|[Cc]om|[Cc]omo|[Cc]onfirma|[Dd]ado|[Dd]aquele|[Dd]ar|[Dd]ava|[Dd]avam|[Dd]e|[Dd]\xea|[Dd]efiniu|[Dd]esse|[Dd]eram|[Dd]eterminado|[Dd]eu|[Dd]o|[Dd]um|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ncontra|[Ee]ncontrava|[Ee]ncontravam|[Ee]ncontraram|[Ee]ncontrasse|[Ee]ncontrou|[Ee]ntre|[Ee]sse|[Ee]ste|[Ee]stranho|[Ee]xtrair|[Ee]xtremo|[Ff]ormar|[Ff]orte|[Gg]rande|[Hh]\xe1|[Hh]aja|[Hh]avia|[Hh]ouve|[Hh]ouvesse|[Hh]ouver|[Ii]mportante|[Jj]\xe1|[Ll]igeiro|[Ll]ubrificante|[Mm]aior|[Mm]ais|[Mm]elhor|[Mm]esmo|[Mm]eu|[Mm]\xednimo|[Nn]\xe3o|[Nn]atural|[Nn]em|[Nn]enhum|[Nn]o|[Nn]obre|[Nn]ovo|[Nn]osso|[Nn]um|[Oo]|[Oo]u|[Oo]utro|[Pp]alavra|[Pp]ara|[Pp]elo|[Pp]oderoso|[Pp]or|[Pp]rimeiro|[Pp]rincipal|[Pp]roduz|[Pp]roduza|[Pp]roduziu|[Pp]rover|[Qq]uente|[Rr]ecebe|[Rr]ecebeu|[Rr]ecebia|[Rr]econfortante|[Ss]\xe3o|[Ss]em|[Ss]emelhante|[Ss]eu|[Ss]imples|[Tt]al|[Tt]em|[Tt]ivesse|[Tt]odo|[Uu]m|[\xda\xfa]ltimo|[\xda\xfa]nico|[Uu]sava|[Vv]ivo) estimulo\\b")

# Identificacao de integra sem acento 
vintegra= re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Bb]astante|[Ee]|[Ee]mpresa|[Ee]stava|[Ff]am\xedlia|[Ff]irma|[Ff]orma|[Gg]arota|[Ii]nterna|[Ll]eia|[Mm]ais|[Mm]elhor|[Mm]enina|[Mm]o\xe7a|[Mm]uito|[Mm]ulher|[Nn]a|[Pp]ermanece|[Pp]essoa|[Ss]ua|[Vv]ida) integra\\b")

# Identificacao de integro sem acento 
vintegro= re.compile("(?i)\\b([Aa]bsolutamente|[Bb]astante|[Dd]e|[Dd]o|[Ee]|[Hh]omem|[Mm]agistrado|[Mm]ais|[Mm]antenha|[Mm]as|[Mm]enino|[Mm]uito|[Oo]|[Pp]ersonagem|[Rr]apaz|[Tt]udo) integro\\b")

# Identificacao de intimo sem acento
vintimo = re.compile("(?i)\\b([A-Za-z]+mente|[A-Za-z]+mento|[Aa]bandono|[Aa]fetivo|[Aa]gora|[Aa]gravo|[\xe1\xe1]lbum|[Aa]lgum|[Aa]liado|[Aa]lvoro\xe7o|[Aa]margor|[Aa]migo|[Aa]mor|[Aa]nelo|[Aa]ntagonismo|[Aa]o|[Aa]quele|[Aa]rrepio|[Bb]aile|[Bb]om|[Cc]aderno|[Cc]amarada|[Cc]aminho|[Cc]\xe2ntico|[Cc]anto|[Cc]ar\xe1cter|[Cc]ar\xe1ter|[Cc]asulo|[Cc]ausaria|[Cc]ausava|[Cc]hoque|[Cc]\xedrculo|[Cc]lima|[Cc]ol\xf3quio|[Cc]om|[Cc]ombate|[Cc]omo|[Cc]ompanheiro|[Cc]ompromisso|[Cc]onselheiro|[Cc]ontato|[Cc]onv\xedvio|[Cc]unho|[Dd]aquele|[Dd]e|[Dd]ebate|[Dd]ecoro|[Dd]esafio|[Dd]esejo|[Dd]esespero|[Dd]esgosto|[Dd]esprezo|[Dd]i\xe1logo|[Dd]i\xe1rio|[Dd]iscurso|[Dd]o|[Dd]rama|[Ee]|[\xc9\xe9]|[Ee]lo|[Ee]m|[Ee]ncanto|[Ee]nxoval|[Ee]ra|[Ee]st\xe1|[Ee]ste|[Ff]en\xf4meno|[Ff]icara|[Ff]icou|[Ff]oco|[Ff]oi|[Ff]oro|[Ff]ui|[Ff]uror|[Gg]emido|[Gg]overno|[Gg]ozo|[Gg]rito|[Hh]omem|[Hh]orr\xedvel|[Ii]deal|[Ii]mpulso|[Ii]ndicar|[Ii]nt\xe9rprete|[Jj]antar|[Jj]\xfabilo|[Jj]u\xedzo|[Ll]a\xe7o|[Ll]irismo|[Ll]ivro|[Ll]uto|[Mm]ais|[Mm]enos|[Mm]eu|[Mm]ist\xe9rio|[Mm]odelo|[Mm]olde|[Mm]on\xf3logo|[Mm]otivo|[Mm]uito|[Mm]undo|[Nn]eg\xf3cio|[Nn]o|[Nn]osso|[Nn]um|[Oo]|[Oo]lhar|[Oo]r\xe1culo|[Oo]rgulho|[Pp]adecer|[Pp]anorama|[Pp]apel|[Pp]ara|[Pp]arecia|[Pp]arente|[Pp]ede|[Pp]elo|[Pp]iano|[Pp]or|[Pp]ouco|[Pp]razer|[Pp]r\xf3prio|[Qq]ualquer|[Qq]uase|[Qq]ue|[Rr]apaz|[Rr]ecolho|[Rr]efeit\xf3rio|[Rr]elato|[Ss]\xe3o|[Ss]arau|[Ss]ecret\xe1rio|[Ss]endo|[Ss]enso|[Ss]entido|[Ss]er|[Ss]eria|[Ss]eu|[Ss]ido|[Ss]obressalto|[Ss]ol|[Ss]ossego|[Ss]uspiro|[Tt]amb\xe9m|[Tt]\xe3o|[Tt]erreno|[Tt]error|[Tt]eu|[Tt]odo|[Tt]om|[Tt]orna|[Tt]rato|[Uu]m|[Vv]erbo|[Vv]iver) intimo\\b")

# Identificacao de intima sem acento 
vintima= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[a-z\xea\xe2]+ncia|[a-z]+[dhistx\xe7]\xe3o|[Aa]|[Aa]gonia|[Aa]legria|[Aa]lma|[Aa]miga|[Aa]mizade|[Aa]nsiedade|[Aa]quela|[Aa]titude|[Aa]tividade|[Bb]em|[Bb]ondade|[Cc]alma|[Cc]arta|[Cc]ausa|[Cc]eia|[Cc]ena|[Cc]erteza|[Cc]om|[Cc]omo|[Cc]onfian\xe7a|[Cc]onsulta|[Cc]ontextura|[Cc]onversa|[Cc]r\xf4nica|[Cc]umplicidade|[Dd]a|[Dd]aquela|[Dd]e|[Dd]el\xedcia|[Dd]escoberta|[Dd]essa|[Dd]esta|[Dd]or|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]nergia|[Ee]ra|[Ee]sfera|[Ee]speran\xe7a|[Ee]ssa|[Ee]sta|[Ee]stante|[Ee]strutura|[Ff]alta|[Ff]azer|[Ff]elicidade|[Ff]esta|[Ff]ez|[Ff]oi|[Ff]or\xe7a|[Ff]orma|[Ff]osse|[Ff]raternidade|[Ff]rieza|[Gg]in\xe1stica|[Hh]igiene|[Hh]ist\xf3ria|[Ii]nimiga|[Ii]rlanda|[Jj]\xe1|[Ll]inguagem|[Ll]iter\xe1ria|[Ll]uta|[Ll]uz|[Mm]agoa|[Mm]\xe1goa|[Mm]ais|[Mm]ant\xe9m|[Mm]as|[Mm]enos|[Mm]esa|[Mm]esma|[Mm]inha|[Mm]oralidade|[Mm]ostrar|[Mm]uita|[Mm]uito|[Nn]a|[Nn]\xe3o|[Nn]atureza|[Nn]ecessidade|[Nn]ossa|[Nn]ota|[Nn]udez|[Nn]uma|[Oo]rdem|[Oo]u|[Pp]agina|[Pp]\xe1gina|[Pp]alavra|[Pp]alestra|[Pp]alpite|[Pp]arte|[Pp]az|[Pp]ela|[Pp]ergunta|[Pp]erspectiva|[Pp]essoa|[Pp]oesia|[Pp]ossuem|[Pp]r\xe1tica|[Qq]ue|[Qq]uem|[Rr]ealidade|[Rr]eviravolta|[Rr]evolta|[Rr]evolve|[Rr]oupa|[Ss]eguran\xe7a|[Ss]enhora|[Ss]er|[Ss]inceridade|[Ss]ociedade|[Ss]ombra|[Ss]ou|[Ss]ua|[Tt]amb\xe9m|[Tt]oda|[Tt]ornou|[Tt]ortura|[Tt]risteza|[Tt]\xfanica|[Uu]ma|[Vv]erdade|[Vv]ida|[Vv]oz|[Zz]ona) intima\\b")

# Identificacao de renuncia sem acento 
vrenuncia = re.compile("(?i)\\b([Aa]|[[\xc0\xe0]|[Aa]nuncia|[Aa]nunciava|[Aa]nunciam|[Aa]nunciou|[Cc]om|[Cc]omo|[Cc]oncedeu|[Cc]uja|[Dd]a|[Dd]e|[Dd]esaprova|[Dd]oce|[Dd]upla|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ssa|[Ee]st\xfapida|[Ee]ventual|[Ff]azer|[Ff]requente|[Gg]enerosa|[Hh]ouve|[Ii]mediata|[Ii]mpliquem|[Ii]mporta|[Ii]mportar\xe1|[Mm]inha|[Nn]a|[Nn]ega|[Nn]ossa|[Nn]uma|[Oo]u|[Pp]ela|[Pp]equena|[Pp]osterior|[Pp]resumir|[Pp]romove|[Pp]romover|[Pp]ura|[Rr]epresentaram|[Ss]ignifique|[Ss]ua|[Tt]ua|[\xda\xfa]ltima|[\xda\xfa]nica|[Uu]ma) renuncia\\b")

# Identificacao de denuncia sem acento 
vdenuncia = re.compile("(?i)\\b([Aa]|[[\xc0\xe0]|[Aa]lguma|[Aa]p\xf3s|[Aa]presenta|[Aa]presentam|[Aa]presentar|[Aa]presentaram|[Aa]presente|[Aa]presentem|[Aa]presentou|[Aa]pura|[Aa]purando|[Aa]purar|[Aa]quela|[Aa]purou|[Aa]ssunto|[Cc]lara|[Cc]om|[Cc]omo|[Cc]onfirma|[Cc]onfirmam|[Cc]onforme|[Cc]ovarde|[Cc]uja|[Dd]a|[Dd]ar|[Dd]as|[Dd]e|[Dd]esmente|[Dd]esmentem|[Dd]esmentiu|[Dd]essa|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ncaminha|[Ee]ncaminham|[Ee]ncaminhou|[Ee]ngolir|[Ee]spec\xedfica|[Ee]ssa|[Ee]sta|[Ee]xista|[Ee]xistiu|[Ee]xistindo|[Ff]alsa|[Ff]ormaliza|[Ff]ormalizando|[Ff]ormalizaram|[Ff]ormalizou|[Ff]ormulada|[Gg]rande|[Gg]rave|[Hh]\xe1|[Hh]avia|[Hh]ouve|[Hh]ouver|[Ii]nexplicada|[Ii]ng\xeanua|[Ii]nvestiga|[Ii]nvestigam|[Ii]nvestigar|[Ii]nvestigava|[Jj]ulga|[Jj]ulgam|[Jj]ulgou|[Ll]evar|[Mm]as|[Mm]ediante|[Mm]eia|[Mm]uita|[Nn]a|[Nn]\xe3o|[Nn]enhuma|[Nn]ova|[Nn]uma|[Oo]ferece|[Oo]ferecer|[Oo]fereceu|[Oo]u|[Oo]utra|[Pp]ela|[Pp]or|[Pp]oss\xedvel|[Pp]reciosa|[Pp]resente|[Pp]rimeira|[Qq]ualquer|[Rr]ecebe|[Rr]eceberam|[Rr]eceberem|[Rr]ecebeu|[Ss]egunda|[Ss]egundo|[Ss]imples|[Ss]obre|[Ss]ua|[Tt]em|[Tt]err\xedvel|[Tt]oda|[Tt]remenda|[Uu]ma|[Vv]elada) denuncia\\b")

# Identificacao de libero sem acento
vlibero = re.compile("(?i)\\b([Cc]omo|[Cc]opa|[Dd]e|[Dd]o|[\xc9\xe9]|[Ee]ducador|[Ff]oi|[Ff]ui|[Gg]rande|[Mm]aior|[Mm]elhor|[Nn]o|[Oo]|[Tt]ermo|[Uu]m) libero\\b")

# Identificacao de liquido sem acento
vliquido = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]|[Aa]\xe7o|[Aa]dorado|[Aa]lcatr\xe3o|[\xc1\xe1]lcool|[Aa]lgum|[Aa]mortecedor|[Aa]o|[Aa]quele|[Aa]r|[Aa]ro|[Aa]rtificioso|[Aa]tivo|[Aa]umento|[Aa]zoto|[Bb]arro|[Bb]astante|[Bb]atom|[Bb]eber|[Bb]exiga|[Bb]rilho|[Bb]ucho|[Cc]af\xe9|[Cc]arbono|[Cc]\xe9lebre|[Cc]erto|[Cc]\xe9u|[Cc]humbo|[Cc]imento|[Cc]intilador|[Cc]irculante|[Cc]lorof\xf3rmio|[Cc]om|[Cc]ombust\xedvel|[Cc]omo|[Cc]omposto|[Cc]ont\xeam|[Cc]onte\xfado|[Cc]ontribuinte|[Cc]or-de-rosa|[Cc]orretivo|[Cc]ristal|[Dd]aquele|[Dd]e|[Dd]enominado|[Dd]erramava|[Dd]esarranjo|[Dd]espenhadeiro|[Dd]esse|[Dd]este|[Dd]etergente|[Dd]iamante|[Dd]ireito|[Dd]o|[Ee]|[\xc9\xe9]|[Ee]feito|[Ee]fluente|[Ee]m|[Ee]mpr\xe9stimo|[Ee]ndividamento|[Ee]ndosperma|[Ee]nxofre|[Ee]spelho|[Ee]sse|[Ee]stado|[Ee]stados|[Ee]ste|[Ee]sturrinho|[Ee]tano|[Ee]xportador|[Ee]xterno|[Ff]ato|[Ff]aturamento|[Ff]icar|[Ff]io|[Ff]luxo|[Gg]anho|[Gg]\xe1s|[Gg]iz|[Gg]licerol|[Gg]licol|[Hh]\xe9lio|[Hh]idrocarboneto|[Hh]idrog\xeanio|[\xed\xed]m\xe3|[Ii]nvestimento|[Ii]ogurte|[Jj]uro|[Ll]en\xe7ol|[Ll]infa|[Ll]itro|[Ll]ucro|[Mm]ais|[Mm]aterial|[Mm]eio|[Mm]enos|[Mm]icrocosmos|[Mm]iraculoso|[Mm]onstro|[Mm]uito|[Nn]\xe9ctar|[Nn]enhum|[Nn]esse|[Nn]itrog\xeanio|[Nn]o|[Nn]\xfacleo|[Nn]um|[Oo]|[Oo]bjetivo|[\xd3\xf3]leo|OMO|[\xd3\xf3]pio|[Oo]rdenado|[Oo]u|[Oo]uro|[Oo]utro|[Oo]val|[Oo]xig\xeanio|[Pp]ara|[Pp]arece|[Pp]atrim\xf4nio|[Pp]elo|[Pp]eso|[Pp]or|[Pp]recioso|[Pp]reciso|[Pp]re\xe7o|[Pp]reju\xedzo|[Pp]r\xeamio|[Pp]resente|[Pp]roduto|[Pp]ropanona|[Pp]us|[Qq]ualquer|[Qq]ue|[Rr]eal|[Rr]egisto|[Rr]endimento|[Rr]esgate|[Rr]esultado|[Rr]etorno|[Rr]ubi|[Ss]ab\xe3o|[Ss]abonete|[Ss]al\xe1rio|[Ss]aldo|[Ss]empre|[Ss]er|[Ss]eu|[Ss]\xf3dio|[Ss]olda|[Ss]onho|[Ss]ubs\xeddio|[Tt]al|[Tt]alco|[Tt]amb\xe9m|[Tt]\xe3o|[Tt]em|[Tt]eto|[Tt]inta|[Tt]\xedtulo|[Tt]olueno|[Tt]orna-se|[Tt]otal|[Tt]ronco|[Tt]udo|[Uu]m|[Uu]rina|[Vv]alor|[Vv]encimento|[Vv]eneno|[Vv]enenoso|[Vv]inagre) liquido\\b")

# Identificacao de liquido sem acento
vliquida = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]|[\xc0\xe0]|[\xe1\xe1]gua|[Aa]lma|[Aa]presenta-se|[Bb]ala|[Cc]apta\xe7\xe3o|[Cc]era|[Cc]hama|[Cc]oca\xedna|[Cc]oisa|[Cc]omo|[Cc]ompletamente|[Cc]onsist\xeancia|[Cc]ontribui\xe7\xe3o|[Cc]orrente|[Cc]ria\xe7\xe3o|[Cc]romatografia|[Dd]a|[Dd]e|[Dd]escarga|[Dd]ieta|[Dd]\xedvida|[Dd]orsal|[Ee]|[\xc9\xe9]|[Ee]nergia|[Ee]ntrada|[Ee]xtens\xe3o|[Ee]xterna|[Ff]aixa|[Ff]ase|[Ff]orma|[Ff]ra\xe7\xf5es|[Gg]eralmente|[Gg]lucose|[Hh]eran\xe7a|[Ii]nterna|[Jj]oia|[Ll]\xe2mina|[Ll]iga\xe7\xe3o|[Mm]ais|[Mm]assa|[Mm]ontanha|[Mm]ulta|[Nn]asceu|[Nn]em|[Nn]uma|[Nn]uvem|[Oo]peracional|[Oo]u|[Pp]arecia|[Pp]arte|[Pp]erda|[Pp]lan\xedcie|[Pp]oeira|[Pp]olpa|[Pp]rata|[Pp]rodutividade|[Pp]r\xf3pria|[Pp]rosa|[Qq]uantidade|[Qq]uase|[Qq]ue|[Rr]eceita|[Rr]ede|[Rr]efulg\xeancia|[Rr]enda|[Rr]entabilidade|[Rr]ocha|[Ss]itua\xe7\xe3o|[Ss]olu\xe7\xe3o|[Ss]oma|[Ss]ubst\xe2ncia|[Ss]uperf\xedcie|[Ss]uspens\xe3o|[Tt]axa|[Tt]erra|[Tt]omador|[Tt]ribut\xe1ria|[Uu]ma) liquida\\b")

# Identificacao de liquido sem acento
vmalicia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]|[Aa]legre|[Aa]lguma|[Aa]quela|[Aa]visada|[Cc]erta|[Cc]om|[Cc]uja|[Dd]a|[Dd]e|[Dd]iscreta|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]nvolve|[Ee]ssa|[Ee]sta|[Ee]terna|[Ff]ina|[Gg]raciosa|[Hh]\xe1|[Ii]nocente|[Ii]nofensiva|[Ll]igeira|[Mm]ais|[Mm]enos|[Mm]inha|[Nn]a|[Nn]enhuma|[Nn]uma|[Oo]u|[Oo]utra|[Pp]ela|[Pp]etulante|[Pp]or|[Pp]\xf4s|[Pp]rofunda|[Pp]ura|[Qq]ue|[Rr]isonha|[Ss]anta|[Ss]em|[Ss]er\xe1|[Ss]ua|[Tt]anta|[Tt]em|[Tt]erna|[Tt]oda|[Tt]ua|[Uu]ma|[Vv]\xea|[Vv]eem|[Vv]i|[Vv]ia|[Vv]iu) malicia\\b")

# Identificacao de matricula sem acento
vmatricula = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]bra|[Aa]bre|[Aa]brir|[Aa]briu|[Cc]ada|[Cc]arro|[Cc]om|[Cc]onhecida|[Cc]uja|[Dd]a|[Dd]e|[Ee]|[Ee]ssa|[Ee]sta|[Ff]echa|[Ff]echou|[Mm]inha|[Nn]a|[Nn]ova|[Pp]ede|[Pp]ediu|[Pp]ela|[Pp]rimeira|[Rr]equereu|[Ss]egunda|[Ss]em|[Ss]ua|[Uu]ma) matricula\\b")

# Identificacao de participe sem acento
vparticipe = re.compile("(?i)\\b([Aa]\xe7\xe3o|[Aa]o|[Aa]ssassin[oa] e|[Aa]utor e|[Cc]oautor e|[Cc]om|[Cc]omo|[Cc]omo sujeito|[Dd]a|[Dd]e|[Dd]o|[\xc9\xe9]|[Ee]ntre|[Ff]oi|[Hh]aja mais de um|[Hh]ouvesse mais de um|[Oo]|[Pp]ara|[Pp]or|[Pp]oss\xedvel|[Ss]eja|[Ss]er|[Ss]er\xe1|[Ss]oldado|[Tt]estemunha e|[Vv]\xedtima ou) participe\\b")

# Identificacao de participes sem acento
vparticips = re.compile("(?i)\\b([Aa]\xe7\xf5es|[Aa]os|[Aa]s|[Aa]utor e|[Aa]utores e|[Cc]oautor e|[Cc]oautores e|[Cc]om|[Cc]omo|[Cc]omo sujeitos|[Dd]as|[Dd]e|[Dd]os|[Ee]ntre|[Nn]ovos|[Oo]s|[Pp]ara|[Pp]or|[Pp]oss\xedveis|[Ss]\xe3o|[Ss]ejam|[Ss]ejam|[Ss]er\xe3o|[Ss]erem|[Ss]oldados) participes\\b")

# Identificacao de pericia sem acento
vpericia = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]dmir\xe1vel|[Aa]rrojada|[Aa]ssombrosa|[Cc]om|[Cc]oncentram|[Cc]uja|[Dd]a|[Dd]e|[Dd]iz|[Ee]|[\xc9\xe9]|[Ee]stranha|[Ee]xige|[Ee]xigiu|[Ff]ator|[Ff]alsa|[Ff]azer|[Ff]eito|[Ff]izeram|[Gg]rande|[Hh]abitual|[Hh]aver|[Ii]gual|[Ii]nsuficiente|[Mm]uita|[Nn]a|[Oo]u|[Pp]ara|[Pp]ela|[Pp]or|[Pp]rimeira|[Pp]r\xf3pria|[Qq]uarta|[Qq]ue|[Rr]equer|[Rr]equerer|[Rr]equeria|[Rr]equisitar|[Ss]em|[Ss]ua|[Ss]uma|[Ss]urpreendente|[Tt]al|[Tt]anta|[\xda\xfa]ltima|[Uu]ma|[Vv]erdadeira) pericia\\b")

# Identificacao de prestigio sem acento
vprestigio = re.compile("(?i)\\b([Aa]balado|[Aa]dquirir|[Aa]dquiriu|[Aa]lcan\xe7ado|[Aa]lgum|[Aa]mericana|[Aa]ntigo|[Aa]o|[Aa]penas|[Aa]rranjar|[Aa]ssim|[Aa]ugusto|[Bb]astante|[Bb]elo|[Bb]rilhante|[Cc]atal\xedtico|[Cc]erto|[Cc]olhe|[Cc]om|[Cc]onferindo|[Cc]onquista|[Cc]onquistar|[Cc]onseguiram|[Cc]onsider\xe1vel|[Cc]ujo|[Dd]\xe1|[Dd]ando-lhe|[Dd]ar|[Dd]e|[Dd]\xea|[Dd]eem|[Dd]efinitivo|[Dd]esmedido|[Dd]esse|[Dd]iab\xf3lico|[Dd]o|[Ee]|[\xc9\xe9]|[Ee]les|[Ee]levado|[Ee]m|[Ee]norme|[Ee]sse|[Ee]u|[Ff]ascinante|[Ff]raco|[Ff]unesto|[Gg]anha|[Gg]anhar|[Gg]anhou|[Gg]enial|[Gg]rande|[Ii]menso|[Ii]mpressionante|[Ii]ncontestado|[Ii]n\xe9dito|[Ii]nsubstitu\xedvel|[Jj]usto|[Ll]argu\xedssimo|[Mm]aior|[Mm]ais|[Mm]ed\xedocre|[Mm]enor|[Mm]esmo|[Mm]eu|[Mm]uito|[Nn]em|[Nn]enhum|[Nn]esse|[Nn]o|[Nn]ovo|[Oo]|[Oo]bter|[Pp]ara|[Pp]articular|[Pp]elo|[Pp]erde|[Pp]erdendo|[Pp]erder|[Pp]erdeu|[Pp]erdia|[Pp]erdido|[Pp]or|[Pp]recioso|[Pp]rocurando|[Pp]r\xf3prio|[Qq]ue|[Rr]eal|[Rr]ecuperar|[Rr]\xe9gio|[Ss]eco|[Ss]em|[Ss]entia|[Ss]eu|[Ss]ignifica|[Ss]imples|[Ss]ingular|[Ss]inistro|[Ss]omente|[Tt]al|[Tt]anto|[Tt]em|[Tt]\xeam|[Tt]enho|[Tt]er|[Tt]eria|[Tt]err\xedvel|[Tt]eu|[Tt]inha|[Tt]inham|[Tt]iveram|[Uu]m|[Uu]ntado|[Vv]ago|[Vv]aleram|[Vv]enerando|[Vv]ulgar) prestigio\\b")

# Identificacao de retifica sem acento
vretifica = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Cc]om|[Cc]uja|[Dd]a|[Dd]e|[\xc9\xe9]|[Ee]xige|[Ee]xigiu|[Ff]alsa|[Ff]azer|[Ff]eito|[Ff]ez|[Ff]izeram|[Gg]rande|[Hh]aver|[Mm]uita|[Nn]a|[Oo]u|[Pp]ara|[Pp]ela|[Pp]or|[Pp]rimeira|[Pp]r\xf3pria|[Qq]uarta|[Qq]ue|[Rr]equer|[Rr]equisitar|[Ss]em|[Ss]ua|[Tt]al|[Tt]anta|[\xda\xfa]ltima|[Uu]ma|[Vv]erdadeira) retifica\\b")

# Identificacao de solicito sem acento
vsolicito = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]diantou|[Aa]guardava|[Aa]o|[Bb]uscar|[Cc]aixeiro|[Cc]omo|[Cc]riado|[Ee]|[\xc9\xe9]|[Ee]le|[Ee]sponjava|[Ee]studou|[Gg]esto|[Gg]uarda|[Ll]embrava|[Mm]ais|[Mm]esmo|[Mm]eu|[Mm]ostrava|[Mm]uito|[Oo]|[Oo]bservando|[Pp]astor|[Qq]ue|[Ss]empre|[Ss]eu|[Tt]\xe3o|[Tt]odo|[Uu]m|[Vv]ela) solicito\\b")

# Identificacao de vicio sem acento
vvicio = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]|[Aa]char|[Aa]che|[Aa]chou|[Aa]legre|[Aa]lgum|[Aa]o|[Aa]quele|[Bb]elo|[Cc]omo|[Cc]ujo|[Dd]aquele|[Dd]e|[Dd]esse|[Dd]este|[Dd]o|[Dd]um|[Ee]|[\xc9\xe9]|[Ee]l|[Ee]m|[Ee]ra|[Ee]sse|[Ee]ste|[Ee]xiste|[Ff]eio|[Gg]rande|[Hh]\xe1|[Hh]aja|[Ii]rresist\xedvel|[Mm]aldito|[Mm]au|[Mm]\xe1ximo|[Mm]enor|[Mm]esmo|[Mm]eu|[Mm]uito|[Nn]aquele|[Nn]enhum|[Nn]o|[Nn]oturno|[Oo]|[Oo]u|[Oo]utro|[Pp]arece|[Pp]elo|[Pp]\xe9ssimo|[Pp]ior|[Pp]leno|[Pp]or|[Pp]r\xf3prio|[Qq]uanto|[Qq]ue|[Rr]essudando|[Ss]eja|[Ss]em|[Ss]er|[Ss]eu|[Ss]\xf3|[Ss]ofre|[Ss]oturno|[Ss]up\xf4s|[Tt]al|[Tt]em|[Tt]eu|[Tt]ornando|[Tt]ornou|[Uu]m|[\xda\xfa]nico|[Vv]elho|[Vv]ira|[Vv]irando|[Vv]irou) vicio\\b")

# Identificacao de vinculo sem acento
vvinculo = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]lgum|[Aa]o|[Aa]pertado|[Aa]quele|[Cc]om|[Cc]ujo|[Dd]e|[Dd]esse|[Dd]este|[Dd]iferente|[Dd]iscute|[Dd]o|[Dd]oce|[Dd]uplo|[Ee]m|[\xc9\xe9]m|[Ee]sse|[Ee]stabelece|[Ee]stabelecer|[Ee]stabeleceram|[Ee]stabeleceu|[Ee]ste|[Ee]xiste|[Ff]orte|[Gg]anhou|[Gg]era|[Gg]erasse|[Gg]ere|[Mm]ais|[Mm]esmo|[Mm]eu|[Mm]uito|[Nn]ega|[Nn]enhum|[Oo]|[Oo]utro|[Pp]elo|[Pp]or|[Pp]ossuem|[Pp]ossui|[Pp]ossuia|[Pp]rimeiro|[Pp]ouco|[Qq]ualquer|[Ss]em|[Ss]eu|[Tt]al|[Tt]ampouco|[Tt]\xeam|[Tt]endo|[Tt]enha|[Tt]enho|[Tt]inha|[Tt]ivesse|[\xda\xfa]ltimo|[Uu]m|[\xda\xfa]nico|[Vv]ital) vinculo\\b")

# Identificacao de vitima sem acento
vvitima = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]|[\xc0\xe0\xc0\xe0]|[Aa]caba|[Aa]cabasse|[Aa]legadamente|[Aa]lguma|[Aa]luna|[Aa]nos|[Aa]ntiga|[Aa]parente|[Aa]parentemente|[Cc]ada|[Cc]air|[Cc]aiu|[Cc]ertamente|[Cc]om|[Cc]omo|[Cc]onsidera|[Cc]onsiderado|[Cc]onsiderar|[Cc]onsiderava|[Cc]riatura|[Cc]uja|[Dd]a|[Dd]e|[Dd]ela|[Dd]ele|[Dd]epois|[Dd]esapareceu|[Dd]esgra\xe7ada|[Dd]esignada|[Dd]ivina|[Dd]iz|[Dd]izes|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]la|[Ee]le|[Ee]m|[Ee]ntre|[Ee]ntregava|[Ee]ra|[\xc9\xe9]s|[Ee]scolhida|[Ee]scravid\xe3o|[Ee]ssa|[Ee]sta|[Ee]streada|[Ee]studante|[Ee]u|[Ff]\xe1cil|[Ff]acilmente|[Ff]aleceu|[Ff]atalmente|[Ff]az|[Ff]azer|[Ff]oi|[Ff]or|[Ff]ora|[Ff]oram|[Ff]osse|[Ff]osses|[Ff]oste|[Ff]ui|[Gg]rande|[Hh]\xe1|[Hh]ospitalizado|[Ii]mbele|[Ii]ndefesa|[Ii]nevitavelmente|[Ii]nfeliz|[Ii]nfelizmente|[Ii]ng\xeanua|[Ii]nocente|[Ll]ogo|[Mm]aior|[Mm]ais|[Mm]ansa|[Mm]inha|[Mm]\xedsera|[Mm]orre|[Mm]orrer|[Mm]orreu|[Mm]orrido|[Mm]ostra|[Mm]ulher|[Mm]usical|[Nn]a|[Nn]em|[Nn]enhuma|[Nn]obre|[Nn]oite|[Nn]ova|[Nn]ovamente|[Nn]uma|[Oo]itava|[Oo]ntem|[Oo]u|[Oo]utra|[Pp]adre|[Pp]ara|[Pp]arecia|[Pp]ela|[Pp]ereceu|[Pp]erp\xe9tua|[Pp]ersonagem|[Pp]obre|[Pp]opula\xe7\xe3o|[Pp]or|[Pp]raga|[Pp]rimeira|[Pp]rincipal|[Pp]r\xf3pria|[Pp]rovavelmente|[Pp]r\xf3xima|[Qq]ualquer|[Qq]uarta|[Qq]ue|[Qq]uerida|[Rr]ecente|[Ss]e|[Ss]egunda|[Ss]eja|[Ss]em|[Ss]empre|[Ss]endo|[Ss]ente|[Ss]entir|[Ss]entiu|[Ss]er|[Ss]er\xe1|[Ss]ereis|[Ss]eria|[Ss]ido|[Ss]\xf3|[Ss]ocial|[Ss]omos|[Ss]ou|[Ss]ua|[Ss]ucumbido|[Ss]uposta|[Tt]alvez|[Tt]amb\xe9m|[Tt]erceira|[Tt]inham|[Tt]orna|[Tt]ornar|[Tt]ornaria|[Tt]ornou|[Tt]ua|[\xda\xfa]ltima|[Uu]m|[Uu]ma|[\xda\xfa]nica|[Vv]ez|[Vv]ia|[Vv]isse|[Vv]olunt\xe1ria) vitima\\b")

# Identificacao de noticia sem acento
vnoticia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]cabrunhadora|[Aa]grad\xe1vel|[Aa]inda|[Aa]lguma|[Aa]pareceu|[Aa]quela|[\xc0\xe0]quela|[Aa]traente|[Bb]ela|[Bb]oa|[Bb]reve|[Cc]ada|[Cc]erta|[Cc]ertamente|[Cc]hamado|[Cc]hegasse|[Cc]hegou|[Cc]ircunstanciada|[Cc]om|[Cc]omprida|[Cc]onforme|[Cc]onsoladora|[Cc]onsta|[Cc]uja|[Cc]uriosa|[Dd]a|[Dd]\xe1|[Dd]ado|[Dd]ando|[Dd]\xe3o|[Dd]aquela|[Dd]ar|[Dd]ar\xe3o|[Dd]arem|[Dd]aremos|[Dd]armos|[Dd]ava|[Dd]avam|[Dd]e|[Dd]\xea|[Dd]ei|[Dd]eixasse|[Dd]ele|[Dd]er|[Dd]era|[Dd]eram|[Dd]esagrad\xe1vel|[Dd]esastrosa|[Dd]esgostosa|[Dd]esmentiu|[Dd]esoladora|[Dd]essa|[Dd]esse|[Dd]essem|[Dd]esta|[Dd]etalhada|[Dd]eu|[Dd]isseram|[Dd]olorosa|[Dd]ou|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]le|[Ee]ncontra|[Ee]ra|[Ee]ram|[Ee]ssa|[Ee]sta|[Ee]stupenda|[Ee]xata|[Ee]xistindo|[Ee]xtraordin\xe1ria|[Ff]alsa|[Ff]antasiosa|[Ff]atal|[Ff]azem|[Ff]eliz|[Ff]oi|[Ff]ora|[Ff]oram|[Ff]ossem|[Ff]raca|[Ff]unesta|[Ff]utura|[Gg]rande|[Gg]rata|[Gg]rave|[Hh]\xe1|[Hh]aja|[Hh]aver|[Hh]avia|[Hh]orr\xedvel|[Hh]ouve|[Hh]ouvera|[Hh]ouvesse|[Ii]a|[Ii]mpacta|[Ii]mportante|[Ii]nesperada|[Ii]ntempestiva|[Jj]ornais|[Ll]arga|[Ll]eve|[Ll]igeira|[Ll]isonjeira|[Ll]ogo|[Ll]\xfagubre|[Mm]\xe1|[Mm]ais|[Mm]andaria|[Mm]ande|[Mm]enor|[Mm]esma|[Mm]inha|[Mm]\xednima|[Mm]isteriosa|[Nn]a|[Nn]aquela|[Nn]em|[Nn]enhuma|[Nn]esta|[Nn]uma|[Oo]ntem|[\xd3\xf3]tima|[Oo]u|[Oo]utra|[Oo]utro|[Oo]uvidos|[Pp]avorosa|[Pp]ediu|[Pp]ela|[Pp]equena|[Pp]esco|[Pp]\xe9ssima|[Pp]ior|[Pp]obre|[Pp]or|[Pp]or\xe9m|[Pp]ortentosa|[Pp]ossui|[Pp]ouca|[Pp]ouco|[Pp]r\xe9via|[Pp]rimeira|[Pp]rincipal|[Pp]ronta|[Pp]r\xf3pria|[Pp]r\xf3prios|[Pp]r\xf3spera|[Qq]ual|[Qq]ualquer|[Qq]uanta|[Qq]ue|[Qq]uerer|[Rr]ara|[Rr]ecebemos|[Rr]eceber|[Rr]ecebera|[Rr]eceberam|[Rr]ecebeste|[Rr]eferida|[Ss]aber|[Ss]abia|[Ss]\xe3o|[Ss]eguinte|[Ss]egunda|[Ss]egundo|[Ss]ejam|[Ss]em|[Ss]emelhante|[Ss]er|[Ss]eriam|[Ss]ido|[Ss]imples|[Ss]\xf3|[Ss]obretudo|[Ss]omente|[Ss]oube|[Ss]ua|[Ss]urpreendente|[Tt]al|[Tt]anta|[Tt]em|[Tt]\xeam|[Tt]emos|[Tt]endenciosa|[Tt]endo|[Tt]enhamos|[Tt]enho|[Tt]ens|[Tt]er|[Tt]eriam|[Tt]err\xedvel|[Tt]eve|[Tt]ido|[Tt]inha|[Tt]inham|[Tt]\xednhamos|[Tt]ive|[Tt]ivemos|[Tt]iver|[Tt]ivera|[Tt]iveram|[Tt]ivesse|[Tt]iveste|[Tt]ornarem|[Tt]ornou|[Tt]r\xe1gica|[Tt]raz|[Tt]razer|[Tt]razido|[Tt]riste|[Tt]rouxe|[\xda\xfa]ltima|[Uu]ma|[\xda\xfa]nica|[Vv]er|[Vv]ez|[Vv]inha|[Vv]irar|[Vv]irou|[Tt]erei|[Tt]raga|[Tt]ragam|[Ee]spalhafatosa|[Ss]ensacional|[Mm]aravilhosa|[Ss]obre) noticia\\b")

# Identificacao de agencia sem acento
vagencia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]lguma|[Aa]penas|[Aa]quela|[Aa]s|[Cc]ada|[Cc]om|[Cc]ria|[Cc]uja|[Dd]a|[Dd]aquela|[Dd]e|[Dd]essa|[Dd]esta|[Dd]eterminada|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]ficiente|[Ee]m|[Ee]ntre|[Ee]ntrevista|[Ee]ssa|[Ee]sta|[Ee]xistindo|[Ff]utura|[Gg]igantesca|[Gg]rande|[Hh]aja|[Ii]mportante|[Ii]naugura|[Ii]nauguramos|[Ii]naugurar|[Ii]nauguraremos|[Ii]naugurou|[Jj]ovem|[Mm]aior|[Mm]esma|[Mm]inha|[Mm]oderna|[Mm]odesta|[Mm]ontam|[Nn]a|[Nn]enhuma|[Nn]esta|[Nn]ossa|[Nn]ot\xf3ria|[Nn]ova|[Nn]uma|[Oo]u|[Oo]utra|[Pp]ara|[Pp]ela|[Pp]equena|[Pp]ermanente|[Pp]obre|[Pp]or|[Pp]retendida|[Pp]revista|[Pp]rimeira|[Pp]rincipal|[Pp]roeminente|[Pp]r\xf3pria|[Pp]r\xf3xima|[Qq]ualquer|[Rr]ecente|[Ss]\xf3|[Ss]obre|[Ss]ofisticada|[Ss]omente|[Ss]oturna|[Ss]ua|[Tt]em|[Tt]er\xe1|[Tt]er\xe3o|[Tt]ipo|[\xda\xfa]ltima|[Uu]ma|[\xda\xfa]nica|[Vv]iagem) agencia\\b")
vagenciap = re.compile("(?i)\\bagencia ([\xc0\xe0]|[Aa]berta|[Aa]crescenta|[\xc1\xe1]gua|[Aa]lem\xe3|[Aa]mericana|[Aa]nat\xf3lia|[Aa]nsa|[Aa]ntara|[Aa]ntidrogas|[Aa]t\xf4mica|[Aa]ustr\xedaca|[Aa]utorizada|[Aa]valiar|[Bb]anc\xe1ria|[Bb]anc\xe1rias|[Bb]oca|[Bb]rasil|[Bb]rasileira|[Bb]rit\xe2nica|[Cc]ausado|[Cc]entral|[Cc]entro|[Cc]omprar|[Cc]ontinua|[Cc]orrespondente|[Cc]redenciada|[Cc]riou|[Dd]a|[Dd]as|[Dd]e|[Dd]eposit\xe1ria|[Dd]esigner|[Dd]essa|[Dd]esse|[Dd]ever\xe1|[Dd]inheiro|[Dd]isse|[Dd]istribuiu|[Dd]iz|[Dd]o|[Dd]os|[Ee]|[\xc9\xe9]|[Ee]fe|[Ee]m|[Ee]scala|[Ee]spacial|[Ee]spanhola|[Ee]special|[Ee]specializada|[Ee]spec\xedfica|[Ee]st\xe1|[Ee]stado|[Ee]stadual|[Ee]st\xe3o|[Ee]statal|[Ee]studa|[Ee]uropeia|[Ee]xistente|[Ff]echadas|[Ff]ederal|[Ff]icar|[Ff]inanceira|[Ff]oi|[Ff]olha|[Ff]otogr\xe1fica|[Ff]otogr\xe1ficas|[Ff]rancesa|[Ff]uner\xe1ria|[Gg]anhou|[Gg]a\xfacha|[Gg]overnamental|[Gg]uardaria|[Hh]\xe1|[Hh]umanit\xe1ria|[Ii]mobili\xe1ria|[Ii]ncendi\xe1ria|[Ii]ndepend\xeancia|[Ii]ndica|[Ii]nformativa|[Ii]nglesa|[Ii]nstalada|[Ii]nternacionais|[Ii]nternacional|[Ii]raniana|[Jj]\xe1|[Jj]udaica|[Ll]eva|[Ll]isboeta|[Ll]ocal|[Ll]ot\xe9rica|[Ll]usa|[Mm]agno|[Mm]as|[Mm]atrimonial|[Mm]atriz|[Mm]enino|[Mm]eridional|[Mm]eteorol\xf3gica|[Mm]undial|[Nn]a|[Nn]acional|[Nn]ada|[Nn]\xe3o|[Nn]o|[Nn]orte-americana|[Nn]os|[Nn]oticiosa|[Nn]ova|[Oo]|[Oo]ferece|[Oo]ficial|[Oo]nde|[Oo]u|[Pp]aga|[Pp]ara|[Pp]aranaense|[Pp]arece|[Pp]arisiense|[Pp]aulista|[Pp]ermanente|[Pp]orque|[Pp]ortuguesa|[Pp]rev\xea|[Pp]roponente|[Pp]ublicit\xe1ria|[Qq]ue|[Qq]uer|[Rr]ecebeu|[Rr]ecifense|[Rr]eferiu|[Rr]egional|[Rr]eguladora|[Rr]egulat\xf3ria|[Rr]espons\xe1vel|[Rr]odovi\xe1ria|[Rr]ussa|[Ss]acada|[Ss]afras|[Ss]antana|[Ss]\xe3o|[Ss]a\xfade|[Ss]e|[Ss]obre|[Ss]omar\xe1|[Ss]uperavit\xe1ria|[Tt]amb\xe9m|[Tt]anto|[Tt]elegr\xe1fica|[Tt]em|[Tt]inha|[Tt]raria|[Tt]ucana|[Uu]niversit\xe1ria|[Uu]sa|[Vv]ai|[Vv]enha|[Vv]inculada|[Vv]oltada)\\b")

# Identificacao de buque sem acento
vbuque = re.compile("(?i)\\b([Bb]uqu(e|es)) de ([Ff]lores|[Nn]oiva|[Nn]oivas|[Vv]ioleta|[Vv]ioletas|[Pp]\xe9rolas|[Pp]\xe9rola|[Rr]osas|[Cc]ravo|[Mm]inirrosas|[Mm]argaridas|[Mm]argarida|[Ss]anto|[Bb]roches|[Rr]oletes)\\b")

# Identificacao de evidencia sem acento
vevidencia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]bsurda|[Aa]chamos|[Aa]dquiriu|[Aa]lguma|[Aa]parente|[Aa]presenta|[Aa]presentam|[Cc]om|[Cc]omo|[Cc]rua|[Cc]uja|[Dd]a|[Dd]aquela|[Dd]e|[Dd]eclarada|[Dd]emonstrativa|[Dd]era|[Dd]esta|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]spantosa|[Ee]ssa|[Ee]sta|[Ee]xiste|[Ff]lagrante|[Ff]ornecendo|[Ff]orte|[Ff]ulgurante|[Gg]anhando|[Gg]anharam|[Gg]rande|[Hh]\xe1|[\xcd\xed]ntima|[Ii]rrecus\xe1vel|[Jj]usticeira|[Ll]ampejante|[Mm]aior|[Mm]ais|[Mm]enos|[Mm]inha|[Mm]uita|[Nn]a|[Nn]\xe3o|[Nn]enhuma|[Nn]essa|[Nn]ova|[Nn]uma|[Oo]utra|[Pp]ela|[Pp]lena|[Pp]orque|[Pp]reciosa|[Pp]rimeira|[Pp]rincipal|[Pp]rogressiva|[Pp]r\xf3pria|[Qq]ualquer|[Rr]esplandecente|[Ss]e|[Ss]emelhante|[Ss]er|[Ss]imples|[Ss]\xf3lida|[Ss]ua|[Ss]\xfabita|[Tt]al|[Tt]amanha|[Tt]anta|[Tt]oda|[Tt]odo|[Uu]ma) evidencia\\b")

# Identificacao de gerencia sem acento
vgerencia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]lguma|[Aa]lta|[Aa]penas|[Aa]quela|[Aa]s|[Aa]tual|[Cc]ada|[Cc]om|[Cc]ria|[Cc]uja|[Dd]a|[Dd]aquela|[Dd]e|[Dd]essa|[Dd]esta|[Dd]eterminada|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]ficiente|[Ee]m|[Ee]ntre|[Ee]ssa|[Ee]sta|[Ee]xistindo|[Ff]utura|[Gg]igantesca|[Gg]rande|[Hh]aja|[Ii]mportante|[Mm]aior|[Mm]esma|[Mm]inha|[Mm]oderna|[Mm]odesta|[Mm]ontam|[Nn]a|[Nn]enhuma|[Nn]essa|[Nn]esta|[Nn]ossa|[Nn]ot\xf3ria|[Nn]ova|[Nn]uma|[Oo]u|[Oo]utra|[Pp]ara|[Pp]ela|[Pp]equena|[Pp]ermanente|[Pp]obre|[Pp]or|[Pp]retendida|[Pp]rimeira|[Pp]rincipal|[Pp]roeminente|[Pp]r\xf3pria|[Pp]r\xf3xima|[Qq]ualquer|[Rr]ecente|[Ss]obre|[Ss]ofisticada|[Ss]ua|[Tt]em|[Tt]er\xe1|[Tt]er\xe3o|[Tt]ipo|[\xda\xfa]ltima|[Uu]ma|[\xda\xfa]nica) gerencia\\b")

# Identificacao de negligencia sem acento
vnegligencia = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]lega|[Aa]legada|[Aa]legaram|[Aa]legou|[Aa]pura|[Cc]om|[Cc]omo|[Cc]ontra|[Dd]a|[Dd]aquela|[Dd]e|[Dd]izer|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ssa|[Ee]ventual|[Ff]oi|[Hh]\xe1|[Hh]avia|[Hh]ouve|[Mm]enor|[Mm]era|[Mm]esma|[Mm]inha|[Nn]a|[Oo]u|[Pp]ela|[Pp]erfeita|[Pp]or|[Pp]ropositada|[Pp]ura|[Qq]ue|[Ss]em|[Ss]ua|[Tt]oda|[Tt]otal|[Tt]remenda|[Uu]ma) negligencia\\b")

# Identificacao de providencia sem acento
vprovidencia = re.compile("(?i)\\b([Aa]|[\xc0\xe0]|[Aa]ben\xe7oada|[Aa]certada|[Aa]dote|[Aa]guarda|[Aa]guardando|[Aa]lguma|[Aa]s|[Bb]ela|[Cc]hamamos|[Cc]hamava|[Cc]omo|[Cc]ruel|[Cc]uja|[Dd]a|[Dd]\xe1|[Dd]aquela|[Dd]ar|[Dd]e|[Dd]esta|[Dd]evida|[Dd]ivina|[Dd]ona|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]ntre|[Ee]spera|[Ee]sperando|[Ee]ssa|[Ee]sta|[Ee]terna|[Gg]rande|[Ii]mportante|[Mm]inha|[Nn]a|[Nn]enhuma|[Nn]ossa|[Nn]ova|[Oo]|[Oo]u|[Oo]utra|[Pp]articular|[Pp]ela|[Pp]rimeira|[Pp]rincipal|[Pp]r\xf3xima|[Qq]ualquer|[Ss]egunda|[Ss]ua|[Tt]al|[Tt]erceira|[Tt]oda|[Tt]omar|[Tt]omou|[Tt]ua|[Uu]ma|[\xda\xfa]nica|[Uu]rgente|[Vv]elha) providencia\\b")

# Identificacao de influencia sem acento
vinfluencia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-o|-me|-lo|-te)|[Aa]|[Aa]|[\xc0\xe0]|[Aa]ben\xe7oada|[Aa]centuada|[Aa]dmir\xe1vel|[Aa]dquirido|[Aa]gitadora|[Aa]\xed|[Aa]lguma|[Aa]li|[Aa]lta|[Aa]lucinadora|[Aa]luguer|[Aa]mericano|[Aa]presenta|[Aa]presentando|[Aa]presente|[Aa]presentou|[Aa]quela|[\xc0\xe0]quela|[\xc1\xe1]rea|[Aa]t\xe9|[Aa]tuais|[Aa]ut\xeantica|[Bb]astante|[Bb]em|[Bb]en\xe9fica|[Bb]en\xe9vola|[Bb]enigna|[Bb]oa|[Bb]randa|[Bb]reve|[Cc]erta|[Cc]hamarei|[Cc]hamava|[Cc]lara|[Cc]om|[Cc]omo|[Cc]onquistassem|[Cc]onsider\xe1vel|[Cc]rescente|[Cc]uja|[Dd]a|[Dd]e|[Dd]ebate|[Dd]ecidida|[Dd]ecisiva|[Dd]eclarada|[Dd]emasiada|[Dd]emonstra|[Dd]enotando|[Dd]essa|[Dd]esta|[Dd]izer|[Dd]oce|[Dd]upla|[Dd]uplicada|[Dd]uradoura|[Ee]|[\xc9\xe9]|[Ee]ficaz|[Ee]m|[Ee]norme|[Ee]ra|[Ee]ssa|[Ee]sta|[Ee]stranha|[Ee]ventual|[Ee]xcelente|[Ee]xcessiva|[Ee]xerce|[Ee]xercem|[Ee]xercendo|[Ee]xercer|[Ee]xercer\xe1|[Ee]xerceram|[Ee]xerceu|[Ee]xercia|[Ee]xercido|[Ee]xtraordin\xe1ria|[Ff]atal|[Ff]eliz|[Ff]irme|[Ff]orte|[Ff]osse|[Ff]ossem|[Ff]unda|[Ff]unesta|[Gg]anhar|[Gg]anhou|[Gg]eralmente|[Gg]igantesca|[Gg]rande|[Gg]rave|[Gg]rossa|[Hh]\xe1|[Hh]aja|[Hh]avia|[Ii]mportante|[Ii]ncontest\xe1vel|[Ii]ncr\xedvel|[Ii]ndeclin\xe1vel|[Ii]nexplic\xe1vel|[Ii]nsistente|[Ii]ntervenha|[Ii]rresist\xedvel|[Ii]sso|[Ll]arga|[Ll]eg\xedtima|[Ll]egitimamente|[Ll]eve|[Mm]\xe1|[Mm]\xe1gica|[Mm]aior|[Mm]ais|[Mm]al\xe9fica|[Mm]aligna|[Mm]arcada|[Mm]arcante|[Mm]as|[Mm]enor|[Mm]enos|[Mm]esma|[Mm]esquinha|[Mm]im|[Mm]inha|[Mm]\xednima|[Mm]isteriosa|[Mm]\xedstica|[Mm]oeda|[Mm]uita|[Mm]utua|[Mm]\xfatua|[Nn]a|[Nn]as|[Nn]atural|[Nn]efasta|[Nn]em|[Nn]enhuma|[Nn]esta|[Nn]isso|[Nn]\xedtida|[Nn]ossa|[Nn]ot\xe1vel|[Nn]ot\xf3ria|[Nn]ula|[Oo]bteve|[\xd3\xf3]bvia|[Oo]pressiva|[Oo]u|[Oo]utra|[Pp]articular|[Pp]ela|[Pp]equena|[Pp]erde|[Pp]erdendo|[Pp]erder|[Pp]erderam|[Pp]erniciosa|[Pp]lena|[Pp]oderosa|[Pp]or|[Pp]ositiva|[Pp]oss\xedvel|[Pp]ouca|[Pp]rimeira|[Pp]rimitiva|[Pp]rincipal|[Pp]rofunda|[Pp]r\xf3pria|[Qq]uaisquer|[Qq]ual|[Qq]ualquer|[Qq]ue|[Rr]\xe1pida|[Rr]eal|[Rr]ealidade|[Rr]ecebe|[Rr]ecebendo|[Rr]eceber|[Rr]eceberam|[Rr]ecebeu|[Rr]ecebia|[Rr]ecebiam|[Rr]ec\xedproca|[Rr]ecolhe|[Rr]eivindicar|[Rr]etirou|[Rr]evela|[Rr]evelam|[Rr]evelando|[Rr]om\xe2ntica|[Ss]alutar|[Ss]ecreta|[Ss]em|[Ss]er|[Ss]\xe9ria|[Ss]ignificativa|[Ss]imular|[Ss]ob|[Ss]ofre|[Ss]ofrem|[Ss]ofremos|[Ss]ofrendo|[Ss]ofrer|[Ss]ofreram|[Ss]ofreu|[Ss]ofri|[Ss]ofrido|[Ss]olo|[Ss]ou|[Ss]ua|[Ss]uav\xedssima|[Ss]uperior|[Tt]al|[Tt]alvez|[Tt]amanha|[Tt]amb\xe9m|[Tt]anta|[Tt]em|[Tt]\xeam|[Tt]endo|[Tt]enha|[Tt]enham|[Tt]enho|[Tt]er|[Tt]er\xe1|[Tt]er\xe3o|[Tt]erceira|[Tt]eria|[Tt]err\xedvel|[Tt]eve|[Tt]ido|[Tt]inha|[Tt]inham|[Tt]ive|[Tt]ivemos|[Tt]iveram|[Tt]otal|[Tt]remenda|[Tt]ua|[Uu]m|[Uu]ma|[\xda\xfa]nica|[Vv]asta|[Vv]endido|[Vv]erdadeira|[Vv]iagem) influencia\\b")

# Identificacao de referencia sem acento
vreferencia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]inda|[Aa]lguma|[Aa]nos|[Aa]ntiga|[Aa]quela|[Aa]t\xe9|[Bb]reve|[Cc]ada|[Cc]ena|[Cc]epa|[Cc]ertames|[Cc]idade|[Cc]lara|[Cc]om|[Cc]omo|[Cc]onstar\xe1|[Cc]onstitui|[Cc]rua|[Cc]uja|[Dd]a|[Dd]e|[Dd]estacada|[Dd]ireta|[Ee]|[\xc9\xe9]|[Ee]di\xe7\xe3o|[Ee]m|[Ee]mpresa|[Ee]ncontramos|[Ee]ncontravam|[Ee]ra|[Ee]special|[Ee]ssa|[Ee]sta|[Ee]stranha|[Ee]videncia|[Ff]a\xe7a|[Ff]a\xe7am|[Ff]a\xe7amos|[Ff]a\xe7o|[Ff]ar\xe1|[Ff]az|[Ff]az-se|[Ff]azem|[Ff]azendo|[Ff]azer|[Ff]azermos|[Ff]azia|[Ff]aziam|[Ff]ez|[Ff]izemos|[Ff]izeram|[Ff]oi|[Ff]orte|[Ff]ugitiva|[Gg]rande|[Hh]\xe1|[Hh]avia|[Hh]ouve|[Ii]dentificando|[Ii]gualmente|[Ii]mportante|[Ii]nclui|[Ii]ncontorn\xe1vel|[Ll]eve|[Ll]igeira|[Mm]aior|[Mm]ais|[Mm]elhor|[Mm]enor|[Mm]erece|[Mm]erecendo|[Mm]esma|[Mm]inha|[Nn]a|[Nn]\xe3o|[Nn]aquela|[Nn]enhuma|[Nn]ormalmente|[Nn]ova|[Nn]uma|[Oo]mitindo-se|[Oo]u|[Oo]utra|[Pp]ara|[Pp]ela|[Pp]equena|[Pp]eri\xf3dica|[Pp]or|[Pp]ossuindo|[Pp]rimeira|[Pp]rincipal|[Pp]rovidencial|[Pp]ura|[Qq]ualquer|[Ss]eguinte|[Ss]egunda|[Ss]em|[Ss]er|[Ss]imples|[Ss]obre|[Ss]ua|[Tt]al|[Tt]em|[Tt]\xeam|[Tt]enha|[Tt]\xedmida|[Tt]inha|[Tt]oda|[Tt]ornar|[Tt]ornaram|[\xda\xfa]ltima|[Uu]ma|[\xda\xfa]nica|[Uu]sei|[Vv]\xe1rias|[Vv]ejo|[Vv]erdadeira) referencia\\b")

# Identificacao de reverencia sem acento
vreverencia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Cc]om|[Dd]a|[Dd]e|[Dd]evida|[Ee]|[Ee]m|[Ee]nvolve|[Ff]az|[Ff]azem|[Ff]ez|[Ff]izeram|[Gg]alante|[Gg]rande|[Ii]lustre|[Ii]nvocando|[Ii]r\xf4nica|[Mm]agna|[Mm]\xe1xima|[Mm]enos|[Mm]esma|[Mm]ostre|[Nn]a|[Nn]egar|[Nn]ossa|[Nn]ova|[Nn]uma|[Pp]ensativa|[Pp]rofunda|[Pp]rovocar|[Rr]eligiosa|[Ss]e|[Ss]em|[Ss]ilenciosa|[Ss]ua|[Ss]ubmissa|[Tt]em|[Tt]erna|[Uu]ma|[Uu]niversal|[Vv]irtuosa|[Vv]ossa) reverencia\\b")

# Identificacao de sequencia sem acento
vsequencia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]bra|[Aa]bram|[Aa]bre|[Aa]brir|[Aa]briram|[Aa]briu|[Aa]dia|[Aa]diou|[Aa]lguma|[Aa]lucinante|[Aa]ntecipa|[Aa]ntecipou|[Aa]tingir|[Aa]quela|[Aa]ssombrosa|[Bb]oa|[Bb]usca|[Bb]uscam|[Cc]ada|[Cc]erta|[Cc]om|[Cc]omo|[Cc]uja|[Cc]urta|[Dd]a|[Dd]ada|[Dd]ado|[Dd]ando|[Dd]ar|[Dd]e|[Dd]\xea|[Dd]eram|[Dd]esignada|[Dd]essa|[Dd]esta|[Dd]eterminada|[Dd]eu|[Ee]|[Ee]m|[Ee]ncerra|[Ee]ncerrar|[Ee]ncerraram|[Ee]ncerre|[Ee]ncerrou|[Ee]norme|[Ee]ssa|[Ee]sta|[Ff]ant\xe1stica|[Hh]avia|[Ll]onga|[Mm]ais|[Mm]ediante|[Mm]elhor|[Mm]esma|[Mm]ira|[Mm]iram|[Mm]\xedsera|[Nn]a|[Nn]enhuma|[Nn]essa|[Nn]esta|[Nn]ova|[Nn]uma|[Oo]ferece|[Oo]ferecem|[Oo]ferecer|[Oo]fereceu|[Oo]ra|[\xd3\xf3]tima|[Oo]u|[Oo]utra|[Pp]ela|[Pp]or|[Pp]rimeira|[Pp]r\xf3pria|[Qq]ualquer|[Qq]uebra|[Qq]uebram|[Qq]uebrar|[Qq]uebraram|[Qq]uebrou|[Qq]uer|[Rr]\xe1pida|[Ss]eguinte|[Ss]em|[Ss]imples|[Ss]obre|[Ss]ua|[Tt]al|[Tt]em|[Tt]\xeam|[Tt]er\xe1|[Tt]er\xe3o|[Tt]eve|[Tt]iveram|[Tt]radicional|[\xda\xfa]ltima|[Uu]ma|[Uu]tilizar|[Vv]aloriza|[Vv]ira) sequencia\\b")

# Identificacao de vivencia sem acento
vvivencia = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]lguma|[Cc]asta|[Cc]om|[Cc]omo|[Dd]a|[Dd]aquela|[Dd]e|[Dd]essa|[Dd]upla|[Ee]|[Ee]m|[Ee]ssa|[Ee]sta|[Gg]rande|[Ii]ncipiente|[Ll]arga|[Ll]onga|[Mm]inha|[Mm]\xednima|[Mm]uita|[Nn]a|[Nn]aquela|[Nn]enhuma|[Nn]essa|[Nn]ossa|[Nn]ova|[Oo]u|[Pp]ela|[Pp]ermanente|[Pp]or|[Pp]r\xf3pria|[Qq]ue|[Ss]ua|[Tt]em|[Tt]ua|[Uu]ma) vivencia\\b")

# Identificacao de anuncio sem acento
vanuncio = re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]nimador|[Aa]o|[Aa]ntigo|[Aa]quele|[Bb]elo|[Bb]om|[Bb]onito|[Cc]olecionar|[Cc]om|[Cc]onsumo|[Cc]rescente|[Cc]ujo|[Dd]aquele|[Dd]ar|[Dd]e|[Dd]este|[Dd]o|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]sse|[Ee]ste|[Ee]xcelente|[Ff]az|[Ff]azer|[Ff]ez|[Gg]rande|[Gg]ravar|[Ii]minente|[Ll]indo|[Ll]uz|[Mm]au|[Mm]edonho|[Mm]elhor|[Mm]eu|[Mm]i|[Nn]aquele|[Nn]este|[Nn]o|[Nn]ovo|[Nn]um|[Oo]|[\xd3\xf3]timo|[Oo]utro|[Pp]ara|[Pp]elo|[Pp]equeno|[Pp]iedoso|[Pp]or|[Pp]\xf4r|[Pp]\xf4s|[Pp]rimeiro|[Pp]ublica|[Pp]ublicou|[Pp]us|[Qq]ualquer|[Qq]ue|[Ss]eguinte|[Ss]egundo|[Ss]em|[Ss]eria|[Ss]eu|[Ss]imp\xe1tico|[Ss]imples|[Tt]al|[Tt]err\xedvel|[Tt]eu|[Tt]riste|[Uu]m|[Vv]asto|[Vv]elho) anuncio\\b")

# Identificacao de duvida sem acento
vduvida= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]lguma|[Aa]quela|[Bb]oa|[Cc]erta|[Cc]omo|[Dd]a|[Dd]e|[Dd]eixa|[Dd]eixar|[Dd]essa|[Dd]esta|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ssa|[Ee]sta|[Ff]az|[Gg]rande|[Hh]a|[Hh]\xe1|[Hh]aja|[Hh]avendo|[Hh]aver|[Hh]aver\xe1|[Hh]avia|[Hh]ouve|[Hh]ouver|[Ll]evantar|[Ll]eve|[Ll]igeira|[Mm]ais|[Mm]enor|[Mm]esma|[Mm]inha|[Mm]\xednima|[Mm]uita|[Nn]a|[Nn]aquela|[Nn]enhuma|[Nn]essa|[Nn]esta|[Nn]ossa|[Nn]uma|[Oo]correr|[Oo]ferecia|[Oo]u|[Oo]utra|[Pp]adecia|[Pp]ara|[Pp]ela|[Pp]\xf5e|[Pp]onha|[Pp]onho|[Pp]or|[Pp]\xf4r|[Pp]or\xe1|[Pp]orei|[Pp]\xf4s|[Pp]rimeira|[Pp]rincipal|[Pp]r\xf3pria|[Pp]unha|[Qq]ualquer|[Qq]ue|[Rr]esta|[Rr]estava|[Ss]em|[Ss]imples|[Ss]ofria|[Ss]ua|[Tt]em|[Tt]\xeam|[Tt]emos|[Tt]enha|[Tt]enham|[Tt]enhas|[Tt]enho|[Tt]er|[Tt]eria|[Tt]eve|[Tt]inha|[Tt]ive|[Tt]iver|[Tt]ivessem|[Tt]oda|[Uu]ma|[\xda\xfa]nica) duvida\\b")

# Identificacao de duvidas sem acento
vduvids= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[Aa]dmite|[Aa]dmitia|[Aa]dmitindo|[Aa]gora|[Aa]lanceantes|[Aa]lguma|[Aa]lgumas|[Aa]limentar|[Aa]placava|[Aa]presentando|[Aa]quelas|[Aa]s|[\xc0\xe0]s|[Aa]ti\xe7avam|[Cc]ausam|[Cc]ausando|[Cc]ausar|[Cc]ertas|[Cc]erto|[Cc]olocam|[Cc]olocar|[Cc]om|[Cc]ompartilham|[Cc]ortar|[Cc]riar|[Cc]ultivar|[Dd]as|[Dd]e|[Dd]eixa|[Dd]eixado|[Dd]eixam|[Dd]eixando|[Dd]eixar|[Dd]eixara|[Dd]eixarei|[Dd]eixasse|[Dd]eixava|[Dd]eixavam|[Dd]eixou|[Dd]emais|[Dd]estas|[Dd]irimir|[Dd]iscute|[Dd]issipar|[Dd]iversas|[Dd]uas|[Ee]|[Ee]m|[Ee]ntre|[Ee]ra|[Ee]sclarecendo|[Ee]sclarecer|[Ee]spalhar|[Ee]sp\xedrito|[Ee]squecendo|[Ee]ssas|[Ee]stas|[Ee]ventuais|[Ee]vitar|[Ee]xistam|[Ee]xistem|[Ee]xistindo|[Ee]xistirem|[Ee]xplicar|[Ff]icam|[Ff]icaram|[Ff]icassem|[Ff]icavam|[Ff]iquem|[Ff]ortes|[Ff]requentes|[Ff]undadas|[Gg]erar|[Gg]randes|[Hh]\xe1|[Hh]aja|[Hh]avendo|[Hh]aver|[Hh]aver\xe1|[Hh]averia|[Hh]avia|[Hh]ouve|[Hh]ouver|[Hh]ouvesse|[Ii]nfindas|[Ii]njustas|[Ii]nsinuando|[Ii]ntermin\xe1veis|[Ii]n\xfameras|[Ii]sso|[Jj]\xe1|[Ll]an\xe7am|[Ll]an\xe7ar|[Ll]ancinantes|[Ll]an\xe7ou|[Ll]evanta|[Ll]evantadas|[Ll]evantam|[Ll]evantando|[Ll]evantar|[Ll]evantaram|[Ll]evantou|[Mm]aiores|[Mm]ais|[Mm]anifestou|[Mm]as|[Mm]enos|[Mm]esmas|[Mm]il|[Mm]inhas|[Mm]ostrando|[Mm]uitas|[Nn]as|[Nn]ossa|[Nn]ossas|[Nn]ovas|[Nn]ovo|[Nn]utria|[Nn]utrir|[Oo]ferece|[Oo]u|[Oo]utras|[Pp]airem|[Pp]ara|[Pp]are|[Pp]elas|[Pp]equenas|[Pp]ermanecem|[Pp]ermitem|[Pp]ermitiam|[Pp]ersistam|[Pp]ersistem|[Pp]erturbantes|[Pp]onho|[Pp]or|[Pp]\xf4r|[Pp]orque|[Pp]oucas|[Pp]rimeiras|[Pp]rincipais|[Pp]rinc\xedpio|[Pp]r\xf3prias|[Pp]rovocava|[Qq]uaisquer|[Qq]uantas|[Qq]ue|[Qq]ueria|[Qq]uero|[Rr]einam|[Rr]esolver|[Rr]estam|[Rr]estar|[Rr]estaram|[Rr]estarem|[Rr]estassem|[Rr]estavam|[Rr]estem|[Rr]esultaram|[Rr]evisor|[Ss]anar|[Ss]\xe3o|[Ss]e|[Ss]em|[Ss]emelhantes|[Ss]\xe9rias|[Ss]imples|[Ss]ob|[Ss]obraram|[Ss]obre|[Ss]obrevivem|[Ss]ofreu|[Ss]ofria|[Ss]uas|[Ss]ubsistam|[Ss]ubsistem|[Ss]ubsistiam|[Ss]ucessivas|[Ss]ugeriu|[Ss]urgem|[Ss]urgir|[Ss]urgiram|[Ss]urgirem|[Ss]uscita|[Ss]uscitam|[Ss]uscitar|[Ss]uscitou|[Tt]ais|[Tt]amb\xe9m|[Tt]antas|[Tt]em|[Tt]\xeam|[Tt]\xeam-se|[Tt]emos|[Tt]endo|[Tt]enha|[Tt]enham|[Tt]enhamos|[Tt]enhas|[Tt]enho|[Tt]ens|[Tt]er|[Tt]erei|[Tt]err\xedveis|[Tt]estassem|[Tt]eve|[Tt]inha|[Tt]inham|[Tt]ira|[Tt]irando|[Tt]irar|[Tt]ire|[Tt]ive|[Tt]iver|[Tt]ivera|[Tt]iveram|[Tt]iverem|[Tt]ivesse|[Tt]ransformou|[Tt]ransparecer|[Tt]uas|[\xda\xfa]ltimas|[Vv]\xe1rias|[Vv]arrer|[Vv]ez|[Vv]ezes|[Vv]inham) duvidas\\b")

# Identificacao de calunia sem acento
vcalunia= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]lguma|[Aa]pelidei|[Aa]quela|[Aa]troz|[Cc]om|[Dd]a|[Dd]e|[Dd]essa|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ra|[Ee]squisita|[Ee]ssa|[Ee]sta|[Ee]st\xfapida|[Ff]azendo|[Ff]azer|[Ff]ez|[Ff]osse|[Gg]rande|[Gg]randess\xedssima|[Gg]rand\xedssima|[Hh]orr\xedvel|[Ii]nfame|[Mm]ais|[Mm]inha|[Nn]a|[Nn]em|[Nn]essa|[Nn]ova|[Nn]uma|[Oo]u|[Pp]ela|[Pp]erversa|[Pp]or|[Qq]ual|[Qq]ualquer|[Qq]ue|[Ss]emelhante|[Ss]er|[Ss]imples|[Ss]ua|[Tt]err\xedvel|[Tt]orpe|[Tt]udo|[Uu]ma|[Vv]elha|[Vv]il) calunia\\b")

# Identificacao de refugio sem acento
vrefugio= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]ben\xe7oado|[Aa]cha|[Aa]charam|[Aa]chou|[Aa]o|[Aa]quele|[\xc0\xe0]quele|[Aa]vistavam|[Bb]usca|[Bb]uscamos|[Bb]uscando|[Bb]uscar|[Bb]uscarem|[Bb]uscasse|[Bb]uscava|[Bb]uscavam|[Bb]usquei|[Cc]eleste|[Cc]laro|[Cc]om|[Cc]omo|[Dd]aquele|[Dd]e|[Dd]erradeiro|[Dd]escobrira|[Dd]esencantado|[Dd]esse|[Dd]o|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ncontrar|[Ee]ncontrara|[Ee]ncontraram|[Ee]ncontrarem|[Ee]ncontraria|[Ee]ncontrava|[Ee]ncontrou|[Ee]sse|[Ee]ste|[Ff]oram|[Ff]resco|[Gg]lorioso|[Ii]gnorado|[Ii]ntelectual|[Mm]aior|[Mm]elhor|[Mm]eu|[Mm]odesto|[Mm]ortal|[Mm]urado|[Nn]aquele|[Nn]em|[Nn]esse|[Nn]este|[Nn]o|[Nn]osso|[Nn]um|[Oo]|[Oo]ferecer|[Oo]u|[Oo]utro|[Pp]ara|[Pp]ediu|[Pp]rocura|[Pp]rocuram|[Pp]rocurar|[Pp]rocuraram|[Pp]rocurarem|[Pp]rocurava|[Pp]rocurou|[Ss]eu|[Ss]imples|[Ss]ou|[Tt]amb\xe9m|[\xda\xfa]ltimo|[Uu]m|[\xda\xfa]nico) refugio\\b")

# Identificacao de suplica sem acento
vsuplica= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]flita|[Aa]ntiga|[\xc0\xe0]quela|[Bb]randa|[Bb]ruta|[Cc]ada|[Cc]om|[Cc]omo|[Dd]a|[Dd]aquela|[Dd]e|[Dd]essa|[Dd]esta|[Ee]|[Ee]m|[Ee]ssa|[Ee]sta|[Ff]azia|[Ff]ervente|[Gg]rande|[Hh]\xe1|[Hh]avia|[Hh]umilde|[Ll]igeira|[Mm]esma|[Mm]inha|[Mm]uda|[Nn]a|[Nn]ossa|[Nn]ova|[Nn]uma|[Oo]u|[Pp]ela|[Qq]uase|[Ss]ua|[Tt]anta|[Tt]riste|[\xda\xfa]ltima|[Uu]ma|[\xda\xfa]nica) suplica\\b")

# Identificacao de copia sem acento
vcopia= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]chara|[Aa]char\xe1|[Aa]lguma|[Aa]penas|[Aa]presenta\xe7\xe3o|[Aa]quela|[Aa]rg\xeantea|[Aa]rquivada|[Aa]tiram|[Aa]utos|[Bb]ela|[Bb]oa|[Cc]ada|[Cc]om|[Cc]omo|[Cc]onsider\xe1vel|[Cc]ontra|[Cc]uja|[Dd]a|[Dd]ar|[Dd]arei|[Dd]ava|[Dd]e|[Dd]eixar\xe1|[Dd]eixei|[Dd]esignavam|[Dd]essa|[Dd]ivulgou|[Dd]ou|[Ee]|[\xc9\xe9]|[Ee]duca\xe7\xe3o|[Ee]m|[Ee]ncaminhar|[Ee]ncontrou|[Ee]ntregar\xe1|[Ee]ntregue|[Ee]nviado|[Ee]nviar\xe1|[Ee]nvi\xe1vamos|[Ee]nviei|[Ee]nviem|[Ee]nviou|[Ee]ra|[\xc9\xe9]s|[Ee]sta|[Ee]xata|[Ff]amosa|[Ff]az|[Ff]ia|[Ff]lagrante|[Gg]lobo|[Gg]rande|[Gg]uardo|[Hh]avia|[Hh]umilde|[Ii]mperfeita|[Jj]untamos|[Ll]arga|[Ll]ibreto|[Mm]agn\xedfica|[Mm]aior|[Mm]ais|[Mm]andaram|[Mm]andei|[Mm]anter|[Mm]inha|[Mm]or|[Nn]a|[Nn]ele|[Nn]ot\xe1vel|[Nn]ova|[Oo]u|[Oo]utra|[Pp]aisagem|[Pp]ara|[Pp]ela|[Pp]equena|[Pp]\xe9ssima|[Pp]or|[Pp]ossuir|[Pp]reciosa|[Pp]rimeira|[Pp]rovidenciar\xe1|[Pp]\xfablico|[Qq]ue|[Rr]emetida|[Rr]emeto|[Rr]ender|[Ss]\xe3o|[Ss]e|[Ss]egunda|[Ss]em|[Ss]imples|[Ss]incera|[Ss]\xf3|[Ss]ua|[Tt]amanha|[Tt]anta|[Tt]em|[Tt]irar|[Tt]raga|[Tt]ragam|[Tt]ransbordante|[Tt]riste|[Tt]rouxe|[Tt]rouxeram|[Uu]m|[Uu]ma|[\xda\xfa]nica|[Vv]ariada|[Vv]elha|[Vv]elh\xedssima) copia\\b")

# Identificacao de acordao sem acento
vacordao= re.compile("(?i)\\b([Cc]\xe2mara|[Cc]onselho|[Cc]onstitucional|[Ee]leitoral|[Ee]ment\xe1ri|[Ii]nconstitucional|[Jj]uiz|[Jj]u\xedza|[Jj]ulgamento|[Jj]ur\xeddic|[Jj]urisprud\xeancia|[Jj]usti\xe7a|[Ll]egisla\xe7\xe3o|[Ll]ei|[Ll]eitura|[Mm]inistr|[Pp]arecer|[Pp]len\xe1rio|[Pp]ublicado|[Rr]egional|[Ss]ec\xe7\xe3o|[Ss]enten\xe7a|[Ss]upremo|[Tt]eor|[Tt]ribunal|MP|STF|STJ|SUPREMO|TCE|TCU|TNU|TRF|TRIBUNAL|TRT)")

# Identificacao de deposito sem acento
vdeposito= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[Aa]lgum|[Aa]o|[Aa]quele|[Aa]ut\xeantico|[Cc]m|[Cc]om|[Cc]omo|[Dd]e|[Dd]er|[Dd]o|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]norme|[Ee]scondido|[Ee]sse|[Ee]ste|[Ff]ez|[Gg]era|[Gg]erava|[Gg]rande|[Hh]avia|[Ii]mprudente|[Ii]nfinito|[Ii]nviolado|[Mm]aior|[Mm]ant\xe9m|[Mm]ediante|[Nn]enhum|[Nn]este|[Nn]o|[Nn]osso|[Nn]outro|[Nn]ovo|[Nn]um|[Oo]|[Oo]u|[Pp]agar|[Pp]ara|[Pp]elo|[Pp]equeno|[Pp]esado|[Pp]or|[Pp]recioso|[Pp]rimeiro|[Pp]rincipal|[Pp]ro|[Pp]rofundo|[Qq]ue|[Rr]eceber|[Rr]eferido|[Rr]equerer|[Rr]espectivo|[Rr]\xedgido|[Ss]agrado|[Ss]eu|[Ss]imples|[Ss]\xf3|[Ss]oturno|[Tt]al|[Uu]m|[Uu]m|[\xda\xfa]nico|[Vv]irou) deposito\\b")

# Identificacao de formula sem acento
vformula= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]certaram|[Aa]lguma|[Aa]mpla|[Aa]quela|[Aa]trav\xe9s|[Bb]oletim|[Cc]ampeonato|[Cc]\xe9lebre|[Cc]erta|[Cc]om|[Cc]omo|[Cc]omplexa|[Cc]oncisa|[Cc]onforme|[Cc]onhecida|[Cc]uja|[Dd]a|[Dd]e|[Dd]efendem|[Dd]escobre|[Dd]esta|[Dd]eterminada|[Dd]o|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]mpresa|[Ee]ncontrar|[Ee]ssa|[Ee]sta|[Ee]vita|[Ee]xclusivamente|[Hh]\xe1|[Ii]nvari\xe1vel|[Mm]ediante|[Mm]esma|[Mm]inha|[Nn]a|[Nn]aquela|[Nn]enhuma|[Nn]essa|[Nn]esta|[Nn]ossa|[Nn]ova|[Nn]uma|[Oo]|[Oo]s|[Oo]u|[Oo]utra|[Pp]ela|[Pp]or|[Pp]r\xf3pria|[Qq]ualquer|[Qq]uer|[Ss]eguinte|[Ss]egunda|[Ss]imples|[Ss]ua|[Tt]al|[Tt]ornam|[Uu]m|[Uu]ma|[Vv]elha) formula\\b")

# Identificacao de hospede sem acento
vhospede= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]caso|[Aa]nteriormente|[Aa]ntigo|[Aa]o|[Aa]quele|[Bb]ela|[Bb]om|[Cc]aro|[Cc]omo|[Dd]a|[Dd]e|[Dd]esalmado|[Dd]istinto|[Dd]o|[Dd]um|[Ee]|[\xc9\xe9]|[Ee]gr\xe9gio|[Ee]ra|[Ee]ras|[Ee]st\xe1|[Ee]stava|[Ee]ste|[Ee]stim\xe1vel|[Ee]terno|[Ff]oi|[Ff]ragrante|[Gg]rande|[Hh]avia|[Ii]lustre|[Ii]nteressante|[Ii]solo|[Ll]eviano|[Ll]inda|[Mm]aldito|[Mm]as|[Mm]au|[Mm]eu|[Mm]\xedsero|[Mm]isterioso|[Nn]enhum|[Nn]o|[Nn]obre|[Nn]ossa|[Nn]osso|[Nn]ova|[Nn]ovo|[Oo]|[Oo]dioso|[Oo]u|[Oo]utro|[Pp]arecia|[Pp]elo|[Pp]equeno|[Pp]rezado|[Pp]rimeiro|[Pp]r\xf3prio|[Qq]ue|[Qq]uerida|[Qq]uerido|[Ss]endo|[Ss]er|[Ss]er\xe1|[Ss]eu|[Ss]imples|[Ss]ingular|[Ss]ingular\xedssimo|[Ss]ou|[Ss]ua|[Tt]aciturno|[Tt]al|[Tt]err\xedvel|[Tt]eu|[Tt]inha|[Tt]rai\xe7oeira|[Tt]riste|[\xda\xfa]ltimo|[Uu]m|[Uu]ma|[Uu]ni|[\xda\xfa]nico|[Vv]elho|[Vv]osso) hospede\\b")

# Identificacao de opera sem acento
vopera= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]guardada|[Aa]lguma|[Bb]ela|[Bb]oa|[Cc]antar|[Cc]uja|[Dd]a|[Dd]aquela|[Dd]e|[Dd]essa|[Dd]esta|[Dd]uma|[Ee]|[\xc9\xe9]|[Ee]ntre|[Ee]ssa|[Ee]sta|[Ff]amosa|[Ff]azer|[Ff]utebol|[Ff]utura|[Gg]raciosa|[Gg]rande|[Ii]nclui|[Nn]a|[Nn]ossa|[Nn]uma|[Pp]ara|[Pp]ela|[Pp]or|[Pp]r\xf3xima|[Qq]ualquer|[Ss]em|[Ss]obre|[Ss]umptuosa|[\xda\xfa]ltima|[Vv]er) [Oo]pera\\b")

# Identificacao de orbita sem acento
vorbita= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[\xc0\xe0]|[Aa]lta|[Bb]aixa|[Cc]ada|[Cc]uja|[Dd]a|[Dd]e|[Dd]essa|[Dd]esta|[Dd]eterminada|[Ee]m|[Ee]ssa|[Ee]xc\xeantrica|[Ll]im\xedtrofe|[Mm]esma|[Mm]inha|[Nn]a|[Nn]esta|[Nn]uma|[Oo]utra|[Pp]ara|[Pp]ela|[Pp]equena|[Pp]rimeira|[Qq]uarta|[Ss]ua|[Tt]ranquila|[Uu]m|[Uu]ma|[Vv]ast\xedssima) orbita\\b")

# Identificacao de ovulo sem acento
vovulo= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[Aa]o|[Aa]quele|[Cc]ada|[Cc]hamadas|[Dd]e|[Dd]o|[Ee]|[Ee]m|[Ee]sse|[Ee]ste|[Nn]o|[Nn]um|[Oo]|[Oo]u|[Pp]rimeiro|[Pp]r\xf3prio|[Qq]ue|[Tt]ornam|[\xda\xfa]ltimo|[Uu]m|[\xda\xfa]nico|[\xda\xfa]ltimo) ovulo\\b")

# Identificacao de prospero sem acento
vprospero= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]inda|[Aa]no|[Aa]r|[Bb]astante|[Cc]olega|[Cc]olono|[Cc]om|[Cc]om\xe9rcio|[Cc]omo|[Dd]e|[Dd]o|[Ee]|[\xc9\xe9]|[Ee]m|[Ee]ra|[Ee]st\xe1|[Ee]stado|[Ff]oi|[Ff]uturo|[Gg]rau|[Mm]ais|[Mm]ilion\xe1rio|[Mm]isterioso|[Mm]uito|[Oo]|[Pp]a\xeds|[Pp]edag\xf3gico|[Rr]elativamente|[Rr]ubor|[Ss]eu|[Tt]\xe3o|[Tt]ornavam|[Uu]m|[Vv]i) prospero\\b")

# Identificacao de prospera sem acento
vprospera= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[Aa]li|[Aa]tividade|[Bb]arriguinha|[Bb]astante|[Bb]urguesia|[Cc]arreira|[Cc]idade|[Dd]a|[Dd]emocracia|[Ee]|[Ee]m|[Ee]mpresa|[Ee]ra|[Ee]ssa|[Ee]xtraordinariamente|[Ff]ace|[Ff]ortuna|[Mm]ais|[Mm]as|[Mm]enos|[Nn]a\xe7\xe3o|[Nn]esta|[Pp]rov\xedncia|[Ss]ociedade|[Ss]ua|[Tt]\xe3o|[Tt]ransi\xe7\xe3o|[Uu]ma|[Vv]iagem|[Vv]ida|[Zz]ona) prospera\\b")

# Identificacao de revolver sem acento
vrevolver= re.compile("(?i)\\b([A-Za-z\xe7\xe1\xea]+(-se|-lhe|-lhes|-o|-me|-nos|-la|-lo|-te)|[Aa]|[Aa]o|[Aa]t\xe9|[Cc]om|[Dd]e|[Dd]o|[Dd]um|[Ee]|[Ee]sse|[Ee]ste|[Gg]rande|[Ii]nsepar\xe1vel|[Mm]elhor|[Mm]encionei|[Mm]eu|[Nn]em|[Nn]o|[Nn]um|[Oo]|[Oo]u|[Pp]ara|[Pp]elo|[Ss]em|[Ss]eu|[Tt]enho|[Tt]eu|[Tt]oma|[Tt]omado|[Uu]m|[Vv]elho|[Vv]erdadeiro) revolver\\b")


# fim Paronimos especiais *-*-*-*-



punct = { "?": "do ponto de interroga"+u"\u00E7"+u"\u00E3"+"o", "!": "do ponto de exclama"+u"\u00E7"+u"\u00E3"+"o",
  ",": "da v"+u"\u00ED"+"rgula", ":": "do dois pontos", ";": "do ponto e v"+u"\u00ED"+"rgula",
  "(": "do par"+u"\u00EA"+"ntese de abertura", ")": "do par"+u"\u00EA"+"ntese de fechamento",
  "[": "do colchete de abertura", "]": "do colchete de fechamento",
  u"\u201c": "das aspas de abertura", u"\u201d": "das aspas de fechamento"}

aaVer = { "quando": "Quando", "Quando": "Quando",
  "que": "Que", "Que": "Que", "se": "Se",
  "Se": "Se"}

aacento = {"abada": "abad"+u"\u00E1",
"abobora": "ab"+u"\u00F3"+"bora",
"aboboras": "ab"+u"\u00F3"+"boras",
"abundancia": "abund"+u"\u00E2"+"ncia",
"abundancias": "abund"+u"\u00E2"+"ncias",
"acaro": u"\u00E1"+"caro",
"acida": u"\u00E1"+"cida",
"acidas": u"\u00E1"+"cidas",
"acido": u"\u00E1"+"cido",
"adverbio": "adv"+u"\u00E9"+"rbio",
"Adverbio": "Adv"+u"\u00E9"+"rbio",
"Africa": u"\u00C1"+"frica",
"africa": u"\u00E1"+"frica",
"Africas": u"\u00C1"+"fricas",
"africas": u"\u00E1"+"fricas",
"africo": u"\u00E1"+"frico",
"Agencia": "Ag"+u"\u00EA"+"ncia",
"Agencias": "Ag"+u"\u00EA"+"ncias",
"agencias": "ag"+u"\u00EA"+"ncias",
"agua": u"\u00E1"+"gua",
"aguas": u"\u00E1"+"guas",
"Agua": u"\u00C1"+"gua",
"Aguas": u"\u00C1"+"guas",
"alfandega": "alf"+u"\u00E2"+"ndega",
"alfandegas": "alf"+u"\u00E2"+"ndegas",
"alivio": "al"+u"\u00ED"+"vio",
"amago": u"\u00E2"+"mago",
"amilase": "am"+u"\u00ED"+"lase",
"angulo": u"\u00E2"+"ngulo",
"anonima": "an"+u"\u00F4"+"nima",
"anonimas": "an"+u"\u00F4"+"nimas",
"anonimo": "an"+u"\u00F4"+"nimo",
"antidoto": "ant"+u"\u00ED"+"doto",
"antiespirita": "antiesp"+u"\u00ED"+"rita",
"antifona": "ant"+u"\u00ED"+"fona",
"antifonas": "ant"+u"\u00ED"+"fonas",
"antifono": "ant"+u"\u00ED"+"fono",
"Anuncio": "An"+u"\u00FA"+"ncio",
"apostola": "ap"+u"\u00F3"+"stola",
"apostolas": "ap"+u"\u00F3"+"stolas",
"apostolo": "ap"+u"\u00F3"+"stolo",
"apostrofe": "ap"+u"\u00F3"+"strofe",
"apostrofes": "ap"+u"\u00F3"+"strofes",
"apostrofo": "ap"+u"\u00F3"+"strofo",
"apostrofos": "ap"+u"\u00F3"+"strofos",
"arabia": "Ar"+u"\u00E1"+"bia",
"Arabia": "Ar"+u"\u00E1"+"bia",
"arabias": "Ar"+u"\u00E1"+"bias",
"Arabias": "Ar"+u"\u00E1"+"bias",
"arbitro": u"\u00E1"+"rbitro",
"artificio": "artif"+u"\u00ED"+"cio",
"assedio": "ass"+u"\u00E9"+"dio",
"Assedio": "Ass"+u"\u00E9"+"dio",
"assuca": "a"+u"\u00E7"+u"\u00FA"+"car",
"assucar": "a"+u"\u00E7"+u"\u00FA"+"car",
"atico": u"\u00E1"+"tico",
"atona": u"\u00E1"+"tona",
"atonas": u"\u00E1"+"tonas",
"atono": u"\u00E1"+"tono",
"atoxica":  "at"+u"\u00F3"+"xica",
"atoxicas":  "at"+u"\u00F3"+"xicas",
"atoxico":  "at"+u"\u00F3"+"xico",
"auspicia": "ausp"+u"\u00ED"+"cia",
"auspicias": "ausp"+u"\u00ED"+"cias",
"auspicio": "ausp"+u"\u00ED"+"cio",
"Autenticas":  "Aut"+u"\u00EA"+"nticas",
"autenticas":  "aut"+u"\u00EA"+"nticas",
"Autografo": "Aut"+u"\u00F3"+"grafo",
"autografo": "aut"+u"\u00F3"+"grafo",
"autopsia":  "aut"+u"\u00F3"+"psia",
"autopsias":  "aut"+u"\u00F3"+"psias",
"avicola": "av"+u"\u00ED"+"cola",
"avicolas": "av"+u"\u00ED"+"colas",
"avicula": "av"+u"\u00ED"+"cola",
"aviculas": "av"+u"\u00ED"+"colas",
"avida": u"\u00E1"+"vida",
"avidas": u"\u00E1"+"vidas",
"avido": u"\u00E1"+"vido",
"babeis": "bab"+u"\u00E9"+"is",
"Babeis": "bab"+u"\u00E9"+"is",
"balaustre": "bala"+u"\u00FA"+"stre",
"balaustres": "bala"+u"\u00FA"+"stres",
"bau": "ba"+u"\u00FA",
"bibliografa": "bibli"+u"\u00F3"+"grafa",
"bibliografas": "bibli"+u"\u00F3"+"grafas",
"bibliografo": "bibli"+u"\u00F3"+"grafo",
"biopsia": "bi"+u"\u00F3"+"psia",
"biopsias": "bi"+u"\u00F3"+"psias",
"biotipo": "bi"+u"\u00F3"+"tipo",
"bordeis": "bord"+u"\u00E9"+"is",
"brecho": "brech"+u"\u00F3",
"bugues": "burgu"+u"\u00EA"+"s",
"bussola": "b"+u"\u00FA"+"ssola",
"bussolas": "b"+u"\u00FA"+"ssolas",
"buzio": "b"+u"\u00FA"+"zio",
"cadencia": "cad"+u"\u00EA"+"ncia",
"cafe": "caf"+u"\u00E9",
"cafes": "caf"+u"\u00E9"+"s",
"cafune": "cafun"+u"\u00E9",
"calorifica": "calor"+u"\u00ED"+"fica",
"calorificas": "calor"+u"\u00ED"+"ficas",
"calorifico": "calor"+u"\u00ED"+"fico",
"calunias": "cal"+u"\u00FA"+"nias",
"cambio": "c"+u"\u00E2"+"mbio",
"canada": "Canad"+u"\u00E1",
"Canada": "Canad"+u"\u00E1",
"canfora": "c"+u"\u00E2"+"nfora",
"capitulo": "cap"+u"\u00ED"+"tulo",
"Capitulo": "Cap"+u"\u00ED"+"tulo",
"CAPITULO": "CAP"+u"\u00CD"+"TULO",
"carate": "carat"+u"\u00EA",
"caricia": "car"+u"\u00ED"+"cia",
"caricias": "car"+u"\u00ED"+"cias",
"carie": "c"+u"\u00E1"+"rie",
"caries": "c"+u"\u00E1"+"ries",
"carreteis": "carret"+u"\u00E9"+"is",
"carteis": "cart"+u"\u00E9"+"is",
"catalogo": "cat"+u"\u00E1"+"logo",
"catimbo": "catimb"+u"\u00F3",
"caustica": "c"+u"\u00E1"+"ustica",
"causticas": "c"+u"\u00E1"+"usticas",
"caustico": "c"+u"\u00E1"+"ustico",
"centigrada": "cent"+u"\u00ED"+"grada",
"centigradas": "cent"+u"\u00ED"+"gradas",
"centigrado": "cent"+u"\u00ED"+"grado",
"centrifuga": "centr"+u"\u00ED"+"fuga",
"centrifugas": "centr"+u"\u00ED"+"fugas",
"centrifugo": "centr"+u"\u00ED"+"fugo",
"chines": "chin"+u"\u00EA"+"s",
"cientifica": "cient"+u"\u00ED"+"fica",
"cientificas": "cient"+u"\u00ED"+"ficas",
"cientifico": "cient"+u"\u00ED"+"fico",
"cinematografo": "cinemat"+u"\u00F3"+"grafo",
"cinzeis": "cinz"+u"\u00E9"+"is",
"cipo": "cip"+u"\u00F3",
"circunstancia": "circunst"+u"\u00E2"+"ncia",
"circunstancias": "circunst"+u"\u00E2"+"ncias",
"ciume": "ci"+u"\u00FA"+"me",
"ciumes": "ci"+u"\u00FA"+"mes",
"CLAUSULA": "CL"+u"\u00C1"+"USULA",
"clausula": "cl"+u"\u00E1"+"usula",
"Clausula": "Cl"+u"\u00E1"+"usula",
"CLAUSULAS": "CL"+u"\u00C1"+"USULAS",
"clausulas": "cl"+u"\u00E1"+"usulas",
"Clausulas": "Cl"+u"\u00E1"+"usulas",
"clemencia": "clem"+u"\u00EA"+"ncia",
"clemencias": "clem"+u"\u00EA"+"ncias",
"Clinica": "Cl"+u"\u00ED"+"nica",
"clinica": "cl"+u"\u00ED"+"nica",
"Clinicas": "Cl"+u"\u00ED"+"nicas",
"clinicas": "cl"+u"\u00ED"+"nicas",
"clinico": "cl"+u"\u00ED"+"nico",
"coagulo": "co"+u"\u00E1"+"gulo",
"cocega": "c"+u"\u00F3"+"cega",
"cocegas": "c"+u"\u00F3"+"cegas",
"confidencia": "confid"+u"\u00EA"+"ncia",
"confidencias": "confid"+u"\u00EA"+"ncias",
"colonia": "col"+u"\u00F4"+"nia",
"colonias": "col"+u"\u00F4"+"nias",
"coloquio": "col"+u"\u00F3"+"quio",
"comedia": "com"+u"\u00E9"+"dia",
"Comedia": "Com"+u"\u00E9"+"dia",
"comedias": "com"+u"\u00E9"+"dias",
"Comedias": "Com"+u"\u00E9"+"dias",
"comercio": "com"+u"\u00E9"+"rcio",
"Comercio": "Com"+u"\u00E9"+"rcio",
"comissaria": "comiss"+u"\u00E1"+"ria",
"comissarias": "comiss"+u"\u00E1"+"rias",
"comissario": "comiss"+u"\u00E1"+"rio",
"comoda": "c"+u"\u00F4"+"moda",
"comodas": "c"+u"\u00F4"+"modas",
"comodo": "c"+u"\u00F4"+"modo",
"compendio": "comp"+u"\u00EA"+"ndio",
"compito": "c"+u"\u00F4"+"mpito",
"concava": "c"+u"\u00F4"+"ncava",
"concavas": "c"+u"\u00F4"+"ncavas",
"concavo": "c"+u"\u00F4"+"ncavo",
"conferencia": "confer"+u"\u00EA"+"ncia",
"conferencias": "confer"+u"\u00EA"+"ncias",
"congenere": "cong"+u"\u00EA"+"nere",
"congeneres": "cong"+u"\u00EA"+"neres",
"consocio": "cons"+u"\u00F3"+"rcio",
"consorcio": "cons"+u"\u00F3"+"rcio",
"contingencia": "conting"+u"\u00EA"+"ncia",
"contingencias": "conting"+u"\u00EA"+"ncias",
"continuas": "cont"+u"\u00ED"+"nuas",
"convenio": "conv"+u"\u00EA"+"nio",
"Convenio": "Conv"+u"\u00EA"+"nio",
"Coparticipe": "Copart"+u"\u00ED"+"cipe",
"coparticipe": "copart"+u"\u00ED"+"cipe",
"Coparticipes": "Copart"+u"\u00ED"+"cipes",
"coparticipes": "copart"+u"\u00ED"+"cipes",
"Copia": "C"+u"\u00F3"+"pia",
"Copias": "C"+u"\u00F3"+"pias",
"copias": "c"+u"\u00F3"+"pias",
"Cranio": "Cr"+u"\u00E2"+"nio",
"cranio": "cr"+u"\u00E2"+"nio",
"cubica": "c"+u"\u00FA"+"bica",
"cubicas": "c"+u"\u00FA"+"bicas",
"cubico": "c"+u"\u00FA"+"bico",
"cumulo": "c"+u"\u00FA"+"mulo",
"curia": "c"+u"\u00FA"+"ria",
"Curia": "C"+u"\u00FA"+"ria",
"custodia": "cust"+u"\u00F3"+"dia",
"Custodia": "Cust"+u"\u00F3"+"dia",
"custodias": "cust"+u"\u00F3"+"dias",
"Custodio": "Cust"+u"\u00F3"+"dio",
"dadiva": "d"+u"\u00E1"+"diva",
"dadivas": "d"+u"\u00E1"+"divas",
"datilografo": "datil"+u"\u00F3"+"grafo",
"Debito": "D"+u"\u00E9"+"ebito",
"decima": "d"+u"\u00E9"+"cima",
"Decima": "D"+u"\u00E9"+"cima",
"decimas": "d"+u"\u00E9"+"cimas",
"Decimo": "D"+u"\u00E9"+"cimo",
"decimo": "d"+u"\u00E9"+"cimo",
"denuncias": "den"+u"\u00FA"+"ncias",
"Deposito": "Dep"+u"\u00F3"+"sito",
"Dicionario": "Dicion"+u"\u00E1"+"rio",
"dicionario": "dicion"+u"\u00E1"+"rio",
"diligencia": "dilig"+u"\u00EA"+"ncia",
"diligencias": "dilig"+u"\u00EA"+"ncias",
"distancias": "dist"+u"\u00E2"+"ncias",
"domestica": "dom"+u"\u00E9"+"stica",
"domesticas": "dom"+u"\u00E9"+"sticas",
"domestico": "dom"+u"\u00E9"+"stico",
"domicilio": "domic"+u"\u00ED"+"lio",
"duble": "dubl"+u"\u00EA",
"dubles": "dubl"+u"\u00EA"+"s",
"Duvidas": "D"+u"\u00FA"+"vidas",
"duzia": "d"+u"\u00FA"+"zia",
"duzias": "d"+u"\u00FA"+"zias",
"eclampsia": "ecl"+u"\u00E2"+"mpsia",
"eclampsias": "ecl"+u"\u00E2"+"mpsias",
"ecografo": "ec"+u"\u00F3"+"grafo",
"Efigie": "Ef"+u"\u00ED"+"gie",
"efigie": "ef"+u"\u00ED"+"gie",
"Efigies": "Ef"+u"\u00ED"+"gies",
"efigies": "ef"+u"\u00ED"+"gies",
"eletrolise": "eletr"+u"\u00F3"+"lise",
"eminencia": "emin"+u"\u00EA"+"ncia",
"Eminencia": "Emin"+u"\u00EA"+"ncia",
"eminencias": "emin"+u"\u00EA"+"ncias",
"empresaria": "empres"+u"\u00E1"+"ria",
"empresarias": "empres"+u"\u00E1"+"rias",
"empresario": "empres"+u"\u00E1"+"rio",
"enfase": u"\u00EA"+"nfase",
"enfases": u"\u00EA"+"nfases",
"EPIGRAFE": "EP"+u"\u00CD"+"GRAFE",
"epigrafe": "ep"+u"\u00ED"+"grafe",
"Epigrafe": "Ep"+u"\u00ED"+"grafe",
"EPIGRAFES": "EP"+u"\u00CD"+"GRAFES",
"epigrafes": "ep"+u"\u00ED"+"grafes",
"Epigrafes": "Ep"+u"\u00ED"+"grafes",
"epigrafo": "ep"+u"\u00ED"+"grafo",
"epigramatica": "epigram"+u"\u00E1"+"tica",
"epigramaticas": "epigram"+u"\u00E1"+"ticas",
"epigramatico": "epigram"+u"\u00E1"+"tico",
"episodio": "epis"+u"\u00F3"+"dio",
"equivoco": "equ"+u"\u00ED"+"voco",
"escambio": "esc"+u"\u00E2"+"mbio",
"escoria": "esc"+u"\u00F3"+"ria",
"escorias": "esc"+u"\u00F3"+"rias",
"espatula": "esp"+u"\u00E1"+"tula",
"espatulas": "esp"+u"\u00E1"+"tulas",
"especie": "esp"+u"\u00E9"+"cie",
"especies": "esp"+u"\u00E9"+"cies",
"especificas": "espec"+u"\u00ED"+"ficas",
"espectroscopio": "espectrosc"+u"\u00F3"+"pio",
"espirita": "esp"+u"\u00ED"+"rita",
"espiritas": "esp"+u"\u00ED"+"ritas",
"espirito": "esp"+u"\u00ED"+"rito",
"esplendida": "espl"+u"\u00EA"+"ndida",
"esplendidas": "espl"+u"\u00EA"+"ndidas",
"esplendido": "espl"+u"\u00EA"+"ndido",
"espolio": "esp"+u"\u00F3"+"lio",
"estabulo": "est"+u"\u00E1"+"bulo",
"estadio": "est"+u"\u00E1"+"dio",
"estancia": "est"+u"\u00E2"+"ncia",
"Estancia": "Est"+u"\u00E2"+"ncia",
"estancias": "est"+u"\u00E2"+"ncias",
"estatua": "est"+u"\u00E1"+"tua",
"estatuas": "est"+u"\u00E1"+"tuas",
"estomago": "est"+u"\u00F4"+"mago",
"estrategia": "estrat"+u"\u00E9"+"gia",
"estrategias": "estrat"+u"\u00E9"+"gias",
"estupida": "est"+u"\u00FA"+"pida",
"estupidas": "est"+u"\u00FA"+"pidas",
"estupido": "est"+u"\u00FA"+"pido",
"Exercito": "Ex"+u"\u00E9"+"rcito",
"exito": u"\u00EA"+"xito",
"experiencia": "experi"+u"\u00EA"+"ncia",
"experiencias": "experi"+u"\u00EA"+"ncias",
"explicitas": "expl"+u"\u00ED"+"citas",
"explicito": "expl"+u"\u00ED"+"cito",
"extravagancia": "extravag"+u"\u00E2"+"ncia",
"extravagancias": "extravag"+u"\u00E2"+"ncias",
"evidencias": "evid"+u"\u00EA"+"ncias",
"Fabrica": "f"+u"\u00E1"+"brica",
"Fabricas": "f"+u"\u00E1"+"bricas",
"fabricas": "f"+u"\u00E1"+"bricas",
"fabula": "f"+u"\u00E1"+"bula",
"fabulas": "f"+u"\u00E1"+"bulas",
"falacia": "fal"+u"\u00E1"+"cia",
"falacias": "fal"+u"\u00E1"+"cias",
"ferias": "f"+u"\u00E9"+"rias",
"fieis": "fi"+u"\u00E9"+"is",
"figado": "f"+u"\u00ED"+"gado",
"filosofa": "fil"+u"\u00F3"+"sofa",
"filosofas": "fil"+u"\u00F3"+"sofas",
"filosofo": "fil"+u"\u00F3"+"sofo",
"flamula": "fl"+u"\u00E2"+"mula",
"flamulas": "fl"+u"\u00E2"+"mulas",
"fonografo": "fon"+u"\u00F3"+"grafo",
"Formica": "F"+u"\u00F3"+"rmica",
"formica": "f"+u"\u00F3"+"rmica",
"formicas": "f"+u"\u00F3"+"rmicas",
"Formula": "F"+u"\u00F3"+"rmula",
"Formulas": "F"+u"\u00F3"+"rmulas",
"formulas": "f"+u"\u00F3"+"rmulas",
"fosforo": "f"+u"\u00F3"+"sforo",
"fotocopia": "fotoc"+u"\u00F3"+"pia",
"fotocopias": "fotoc"+u"\u00F3"+"pias",
"frigida": "fr"+u"\u00ED"+"gida",
"frigidas": "fr"+u"\u00ED"+"gidas",
"frigido": "fr"+u"\u00ED"+"gido",
"frigorifico": "frigor"+u"\u00ED"+"fico",
"fuba": "fub"+u"\u00E1",
"fubas": "fub"+u"\u00E1"+"s",
"fulgido": "f"+u"\u00FA"+"lgido",
"Galaxia": "Gal"+u"\u00E1"+"xia",
"galaxia": "gal"+u"\u00E1"+"xia",
"galaxias": "gal"+u"\u00E1"+"xias",
"gamba": "gamb"+u"\u00E1",
"gambas": "gamb"+u"\u00E1"+"s",
"Gambia": "G"+u"\u00E2"+"mbia",
"ganancia": "gan"+u"\u00E2"+"ncia",
"ganancias": "gan"+u"\u00E2"+"ncias",
"geografa": "ge"+u"\u00F3"+"grafa",
"geografas": "ge"+u"\u00F3"+"grafas",
"geografo": "ge"+u"\u00F3"+"grafo",
"georreferencia": "georrefer"+u"\u00EA"+"ncia",
"georreferencias": "georrefer"+u"\u00EA"+"ncias",
"Gerencia": "Ger"+u"\u00EA"+"ncia",
"Gerencias": "Ger"+u"\u00EA"+"ncias",
"gerencias": "ger"+u"\u00EA"+"ncias",
"ginastica": "gin"+u"\u00E1"+"stica",
"ginasticas": "gin"+u"\u00E1"+"sticas",
"ginastico": "gin"+u"\u00E1"+"stico",
"gloria": "gl"+u"\u00F3"+"ria",
"Gloria": "Gl"+u"\u00F3"+"ria",
"glorias": "gl"+u"\u00F3"+"rias",
"gondola": "g"+u"\u00F4"+"ndola",
"gondolas": "g"+u"\u00F4"+"ndolas",
"gramatica": "gram"+u"\u00E1"+"tica",
"gramaticas": "gram"+u"\u00E1"+"ticas",
"gramatico": "gram"+u"\u00E1"+"tico",
"gravida": "gr"+u"\u00E1"+"vida",
"gravidas": "gr"+u"\u00E1"+"vidas",
"gravido": "gr"+u"\u00E1"+"vido",
"guara": "guar"+u"\u00E1",
"guaras": "guar"+u"\u00E1"+"s",
"guarana": "guaran"+u"\u00E1",
"guaranas": "guaran"+u"\u00E1"+"s",
"halito": "h"+u"\u00E1"+"lito",
"hemodialise": "hemodi"+u"\u00E1"+"lise",
"hemodialises": "hemodi"+u"\u00E1"+"lises",
"hemodiastase": "hemodi"+u"\u00E1"+"stase",
"hemodiastases": "hemodi"+u"\u00E1"+"stases",
"heptafono": "hept"+u"\u00E1"+"fono",
"heptafonos": "hept"+u"\u00E1"+"fonos",
"hibrida": "h"+u"\u00ED"+"brida",
"hibridas": "h"+u"\u00ED"+"bridas",
"hibrido": "h"+u"\u00ED"+"brido",
"hidrogena": "hidr"+u"\u00F3"+"gena",
"hidrogenas": "hidr"+u"\u00F3"+"genas",
"hidrogeno": "hidr"+u"\u00F3"+"geno",
"hidrolise": "hidr"+u"\u00F3"+"lise",
"hidrolises": "hidr"+u"\u00F3"+"lises",
"hidrometro": "hidr"+u"\u00F4"+"metro",
"hilaria": "hil"+u"\u00E1"+"ria",
"hilarias": "hil"+u"\u00E1"+"rias",
"hilario": "hil"+u"\u00E1"+"rio",
"historia": "hist"+u"\u00F3"+"ria",
"historias": "hist"+u"\u00F3"+"rias",
"homofila": "hom"+u"\u00F3"+"fila",
"homofilas": "hom"+u"\u00F3"+"filas",
"homofilo": "hom"+u"\u00F3"+"filo",
"homofona": "hom"+u"\u00F3"+"fona",
"homofonas": "hom"+u"\u00F3"+"fonas",
"homofono": "hom"+u"\u00F3"+"fono",
"honorifica": "honor"+u"\u00ED"+"fica",
"honorificas": "honor"+u"\u00ED"+"ficas",
"honorifico": "honor"+u"\u00ED"+"fico",
"Horoscopo": "Hor"+u"\u00F3"+"scopo",
"horoscopo": "hor"+u"\u00F3"+"scopo",
"Hospede": "H"+u"\u00F3"+"spede",
"Hospedes": "H"+u"\u00F3"+"spedes",
"hospedes": "h"+u"\u00F3"+"spedes",
"ignominia": "ignom"+u"\u00ED"+"nia",
"ignominias": "ignom"+u"\u00ED"+"nias",
"ilegitima": "ileg"+u"\u00ED"+"tima",
"ilegitimas": "ileg"+u"\u00ED"+"timas",
"ilegitimo": "ileg"+u"\u00ED"+"timo",
"impar": u"\u00ED"+"mpar",
"impares": u"\u00ED"+"mpares",
"impertinencia": "impertin"+u"\u00EA"+"ncia",
"impertinencias": "impertin"+u"\u00EA"+"ncias",
"impeto": u"\u00ED"+"mpeto",
"impia": u"\u00ED"+"mpia",
"impias": u"\u00ED"+"mpias",
"impio": u"\u00ED"+"mpio",
"indicio": "ind"+u"\u00ED"+"cio",
"indulgencia": "indulg"+u"\u00EA"+"ncia",
"indulgencias": "indulg"+u"\u00EA"+"ncias",
"Industria": "Iind"+u"\u00FA"+"stria",
"industria": "ind"+u"\u00FA"+"stria",
"Industrias": "Ind"+u"\u00FA"+"strias",
"industrias": "ind"+u"\u00FA"+"strias",
"Influencia": "Influ"+u"\u00EA"+"ncia",
"influencias": "influ"+u"\u00EA"+"ncias",
"ingenua": "ing"+u"\u00EA"+"nua",
"ingenuas": "ing"+u"\u00EA"+"nuas",
"ingenuo": "ing"+u"\u00EA"+"nuo",
"Inicio": "In"+u"\u00ED"+"cio",
"INICIO": "IN"+u"\u00CD"+"CIO",
"insignia": "ins"+u"\u00ED"+"gnia",
"insignias": "ins"+u"\u00ED"+"gnias",
"insipida": "ins"+u"\u00ED"+"pida",
"insipidas": "ins"+u"\u00ED"+"pidas",
"insipido": "ins"+u"\u00ED"+"pido",
"insonia": "ins"+u"\u00F4"+"nia",
"insonias": "ins"+u"\u00F4"+"nias",
"instancia": "inst"+u"\u00E2"+"ncia",
"instancias": "inst"+u"\u00E2"+"ncias",
"integras": u"\u00ED"+"ntegras",
"inteligencia": "intelig"+u"\u00EA"+"ncia",
"inteligencias": "intelig"+u"\u00EA"+"ncias",
"intimas": u"\u00ED"+"ntimas",
"inventario": "invent"+u"\u00E1"+"rio",
"iridio": "ir"+u"\u00ED"+"dio",
"iris": u"\u00ED"+"ris",
"irreverencia": "irrever"+u"\u00EA"+"ncia",
"irreverencias": "irrever"+u"\u00EA"+"ncias",
"jatancia": "jat"+u"\u00E2"+"ncia",
"jatancias": "jat"+u"\u00E2"+"ncias",
"jornalistica": "jornal"+u"\u00ED"+"stica",
"jornalisticas": "jornal"+u"\u00ED"+"sticas",
"jornalistico": "jornal"+u"\u00ED"+"stico",
"juri": "j"+u"\u00FA"+"ri",
"Juri": "J"+u"\u00FA"+"ri",
"lagrima": "l"+u"\u00E1"+"grima",
"lagrimas": "l"+u"\u00E1"+"grimas",
"lamina": "l"+u"\u00E2"+"mina",
"laminas": "l"+u"\u00E2"+"minas",
"Lampada": "L"+u"\u00E2"+"mpada",
"lampada": "l"+u"\u00E2"+"mpada",
"Lampadas": "L"+u"\u00E2"+"mpadas",
"lampadas": "l"+u"\u00E2"+"mpadas",
"Lastima": "L"+u"\u00E1"+"stima",
"Lastimas": "L"+u"\u00E1"+"stimas",
"lastimas": "l"+u"\u00E1"+"stimas",
"legitimo": "leg"+u"\u00ED"+"timo",
"licitas": "l"+u"\u00ED"+"citas",
"licito": "l"+u"\u00ED"+"cito",
"Liquidas": "L"+u"\u00ED"+"quidas",
"liquidas": "l"+u"\u00ED"+"quidas",
"Liquido": "L"+u"\u00ED"+"quido",
"lirica": "l"+u"\u00ED"+"rica",
"liricas": "l"+u"\u00ED"+"ricas",
"lirico": "l"+u"\u00ED"+"rico",
"litigio": "lit"+u"\u00ED"+"gio",
"logica": "l"+u"\u00F3"+"gica",
"logicas": "l"+u"\u00F3"+"gicas",
"logico": "l"+u"\u00F3"+"gico",
"lucifero": "luc"+u"\u00ED"+"fero",
"ma": "m"+u"\u00E1",
"macunaima": "macuna"+u"\u00ED"+"ma",
"Macunaima": "Macuna"+u"\u00ED"+"ma",
"mafia": "m"+u"\u00E1"+"fia",
"mafias": "m"+u"\u00E1"+"fias",
"mafua": "mafu"+u"\u00E1",
"mafuas": "mafu"+u"\u00E1"+"s",
"magica": "m"+u"\u00E1"+"gica",
"magicas": "m"+u"\u00E1"+"gicas",
"magico": "m"+u"\u00E1"+"gico",
"magnifica": "magn"+u"\u00ED"+"fica",
"magnificas": "magn"+u"\u00ED"+"ficas",
"magnifico": "magn"+u"\u00ED"+"fico",
"Malaria": "Mal"+u"\u00E1"+"ria",
"malaria": "mal"+u"\u00E1"+"ria",
"malarias": "mal"+u"\u00E1"+"rias",
"maleficio": "malef"+u"\u00ED"+"cio",
"malicias": "mal"+u"\u00ED"+"cias",
"maluques": "maluqu"+u"\u00EA"+"s",
"maniaca": "man"+u"\u00ED"+"aca",
"maniacas": "man"+u"\u00ED"+"acas",
"maniaco": "man"+u"\u00ED"+"aco",
"manigancia": "manig"+u"\u00E2"+"ncia",
"manigancias": "manig"+u"\u00E2"+"ncias",
"maquina": "m"+u"\u00E1"+"quina",
"maquinas": "m"+u"\u00E1"+"quinas",
"Mascara": "M"+u"\u00E1"+"scara",
"Mascaras": "M"+u"\u00E1"+"scaras",
"mascaras": "m"+u"\u00E1"+"scaras",
"Matricula": "Matr"+u"\u00ED"+"cula",
"Matriculas": "Matr"+u"\u00ED"+"culas",
"matriculas": "matr"+u"\u00ED"+"culas",
"matrimonio": "matrim"+u"\u00F4"+"nio",
"Medica": "M"+u"\u00E9"+"dica",
"medica": "m"+u"\u00E9"+"dica",
"Medicas": "M"+u"\u00E9"+"dicas",
"medicas": "m"+u"\u00E9"+"dicas",
"Medico": "M"+u"\u00E9"+"dico",
"medico": "m"+u"\u00E9"+"dico",
"megametro": "meg"+u"\u00E2"+"metro",
"Memoria": "Mem"+u"\u00F3"+"ria",
"memoria": "mem"+u"\u00F3"+"ria",
"memorias": "mem"+u"\u00F3"+"rias",
"mercancia": "merc"+u"\u00E2"+"ncia",
"mercancias": "merc"+u"\u00E2"+"ncias",
"metafisica": "metaf"+u"\u00ED"+"sica",
"metafisicas": "metaf"+u"\u00ED"+"sicas",
"metafisico": "metaf"+u"\u00ED"+"sico",
"microbio": "micr"+u"\u00F3"+"bio",
"micrografo": "micr"+u"\u00F3"+"grafo",
"milicia": "mil"+u"\u00ED"+"cia",
"milicias": "mil"+u"\u00ED"+"cias",
"milimetro": "mil"+u"\u00ED"+"metro",
"mimeografo": "mime"+u"\u00F3"+"grafo",
"mimica": "m"+u"\u00ED"+"mica",
"mimicas": "m"+u"\u00ED"+"micas",
"mimico": "m"+u"\u00ED"+"mico",
"minudencia": "minud"+u"\u00EA"+"ncia",
"minudencias": "minud"+u"\u00EA"+"ncias",
"minuscula": "min"+u"\u00FA"+"scula",
"minusculas": "min"+u"\u00FA"+"sculas",
"minusculo": "min"+u"\u00FA"+"sculo",
"misera": "m"+u"\u00ED"+"sera",
"miseras": "m"+u"\u00ED"+"seras",
"misero": "m"+u"\u00ED"+"sero",
"monossilaba": "monoss"+u"\u00ED"+"laba",
"monossilabas": "monoss"+u"\u00ED"+"labas",
"monossilabo": "monoss"+u"\u00ED"+"labo",
"murmurio": "murm"+u"\u00FA"+"rio",
"musica": "m"+u"\u00FA"+"sica",
"musicas": "m"+u"\u00FA"+"sicas",
"musico": "m"+u"\u00FA"+"sico",
"naufrago": "n"+u"\u00E1"+"ufrago",
"necropsia": "necr"+u"\u00F3"+"psia",
"necropsias": "necr"+u"\u00F3"+"psias",
"negligencias": "neglig"+u"\u00EA"+"ncias",
"Negocio": "Neg"+u"\u00F3"+"cio",
"nevoa": "n"+u"\u00E9"+"voa",
"nevoas": "n"+u"\u00E9"+"voas",
"Noticia": "Not"+u"\u00ED"+"cia",
"Noticias": "Not"+u"\u00ED"+"cias",
"noticias": "not"+u"\u00ED"+"cias",
"noveis": "nov"+u"\u00E9"+"is",
"obliqua": "obl"+u"\u00ED"+"qua",
"obliquas": "obl"+u"\u00ED"+"quas",
"obliquo": "obl"+u"\u00ED"+"quo",
"obsequio": "obs"+u"\u00E9"+"quio",
"obstaculo": "obst"+u"\u00E1"+"culo",
"oficio": "of"+u"\u00ED"+"cio",
"omega": u"\u00F4"+"mega",
"oraculo": "or"+u"\u00E1"+"culo",
"Orbita": u"\u00D3"+"rbita",
"Orbitas": u"\u00D3"+"rbitas",
"orbitas": u"\u00F3"+"rbitas",
"osculo": u"\u00F3"+"sculo",
"Ovulo": u"\u00D3"+"vulo",
"pacifico": "pac"+u"\u00ED"+"fico",
"pagina": "p"+u"\u00E1"+"gina",
"paginas": "p"+u"\u00E1"+"ginas",
"paleofilo": "pale"+u"\u00F3"+"filo",
"paleografo": "pale"+u"\u00F3"+"grafo",
"paleto": "palet"+u"\u00F3",
"palmatoria": "palmat"+u"\u00F3"+"ria",
"palmatorias": "palmat"+u"\u00F3"+"rias",
"pandego": "p"+u"\u00E2"+"ndego",
"panico": "p"+u"\u00E2"+"nico",
"pantografo": "pant"+u"\u00F3"+"grafo",
"papeis": "pap"+u"\u00E9"+"is",
"pasteis": "past"+u"\u00E9"+"is",
"paralitica": "paral"+u"\u00ED"+"tica",
"paraliticas": "paral"+u"\u00ED"+"ticas",
"paralitico": "paral"+u"\u00ED"+"tico",
"Parana": "Paran"+u"\u00E1",
"Parodia": "Par"+u"\u00F3"+"dia",
"parodias": "par"+u"\u00F3"+"dias",
"Paroquia": "Par"+u"\u00F3"+"quia",
"paroquia": "par"+u"\u00F3"+"quia",
"Paroquias": "Par"+u"\u00F3"+"quias",
"paroquias": "par"+u"\u00F3"+"quias",
"pascoa": "p"+u"\u00E1"+"scoa",
"pascoas": "p"+u"\u00E1"+"scoas",
"Patio": "P"+u"\u00E1"+"tio",
"patio": "p"+u"\u00E1"+"tio",
"Patrimonio": "Patrim"+u"\u00F4"+"nio",
"patrimonio": "patrim"+u"\u00F4"+"nio",
"pavia": "p"+u"\u00E1"+"via",
"pavias": "p"+u"\u00E1"+"vias",
"pendencia": "pend"+u"\u00EA"+"ncia",
"pendencias": "pend"+u"\u00EA"+"ncias",
"pendulo": "p"+u"\u00EA"+"ndulo",
"penes": "p"+u"\u00EA"+"nis",
"penitencia": "penit"+u"\u00EA"+"ncia",
"penitencias": "penit"+u"\u00EA"+"ncias",
"perdulario": "perdul"+u"\u00E1"+"rio",
"perfei"+u"\u00E7"+"oes": "perfei"+u"\u00E7"+u"\u00F5"+"es",
"Pericia": "Per"+u"\u00ED"+"cia",
"Pericias": "Per"+u"\u00ED"+"cias",
"pericias": "per"+u"\u00ED"+"cias",
"perola": "p"+u"\u00E9"+"rola",
"perolas": "p"+u"\u00E9"+"rolas",
"perpetuas": "perp"+u"\u00E9"+"tuas",
"perpetuo": "perp"+u"\u00E9"+"tuo",
"pestilencia": "pestil"+u"\u00EA"+"ncia",
"pestilencias": "pestil"+u"\u00EA"+"ncias",
"pilula": "p"+u"\u00ED"+"lula",
"pilulas": "p"+u"\u00ED"+"lulas",
"piramide": "pir"+u"\u00E2"+"mide",
"piramides": "pir"+u"\u00E2"+"mides",
"pirografo": "pir"+u"\u00F3"+"grafo",
"placida": "pl"+u"\u00E1"+"cida",
"placidas": "pl"+u"\u00E1"+"cidas",
"placido": "pl"+u"\u00E1"+"cido",
"plagio": "pl"+u"\u00E1"+"gio",
"planteis": "plant"+u"\u00E9"+"is",
"plastica": "pl"+u"\u00E1"+"stica",
"plasticas": "pl"+u"\u00E1"+"sticas",
"plastico": "pl"+u"\u00E1"+"stico",
"polemica": "pol"+u"\u00EA"+"mica",
"polemicas": "pol"+u"\u00EA"+"micas",
"polemico": "pol"+u"\u00EA"+"mico",
"poligrafa": "pol"+u"\u00ED"+"grafa",
"poligrafas": "pol"+u"\u00ED"+"grafas",
"poligrafo": "pol"+u"\u00ED"+"grafo",
"porem": "por"+u"\u00E9"+"m",
"porno": "porn"+u"\u00F4",
"pornos": "porn"+u"\u00F4"+"s",
"potencia": "pot"+u"\u00EA"+"ncia",
"potencias": "pot"+u"\u00EA"+"ncias",
"preambulo": "pre"+u"\u00E2"+"mbulo",
"pre"+u"\u00E7"+"ario": "pre"+u"\u00E7"+u"\u00E1"+"rio",
"prefacio": "pref"+u"\u00E1"+"cio",
"preferencia": "prefer"+u"\u00EA"+"ncia",
"preferencias": "prefer"+u"\u00EA"+"ncias",
"premio": "pr"+u"\u00EA"+"mio",
"prenuncio": "pren"+u"\u00FA"+"ncio",
"presagio": "press"+u"\u00E1"+"gio",
"presidio": "pres"+u"\u00ED"+"dio",
"pressagio": "press"+u"\u00E1"+"gio",
"principio": "princ"+u"\u00ED"+"pio",
"Privilegio": "Privil"+u"\u00E9"+"gio",
"privilegio": "privil"+u"\u00E9"+"gio",
"prodiga": "pr"+u"\u00F3"+"diga",
"prodigas": "pr"+u"\u00F3"+"digas",
"prodigo": "pr"+u"\u00F3"+"digo",
"prologo": "pr"+u"\u00F3"+"logo",
"pronostico": "pron"+u"\u00F3"+"stico",
"prontuario": "prontu"+u"\u00E1"+"rio",
"propicio": "prop"+u"\u00ED"+"cio",
"proposito": "prop"+u"\u00F3"+"sito",
"Prospero": "Pr"+u"\u00F3"+"spero",
"Prospera": "Pr"+u"\u00F3"+"spera",
"Prosperas": "Pr"+u"\u00F3"+"speras",
"prosperas": "pr"+u"\u00F3"+"speras",
"proverbio": "prov"+u"\u00E9"+"rbio",
"Proverbio": "Prov"+u"\u00E9"+"rbio",
"Providencia": "Provid"+u"\u00EA"+"ncia",
"providencias": "provid"+u"\u00EA"+"ncias",
"prudencia": "prud"+u"\u00EA"+"ncia",
"prudencias": "prud"+u"\u00EA"+"ncias",
"psicanalise": "psican"+u"\u00E1"+"lise",
"psicanalises": "psican"+u"\u00E1"+"lises",
"psicoanalise": "psicoan"+u"\u00E1"+"lise",
"psicoanalises": "psicoan"+u"\u00E1"+"lises",
"psicologa": "psic"+u"\u00F3"+"loga",
"psicologas": "psic"+u"\u00F3"+"logas",
"psicologo": "psic"+u"\u00F3"+"logo",
"Publica": "P"+u"\u00FA"+"blica",
"Publicas": "P"+u"\u00FA"+"blicas",
"publicas": "p"+u"\u00FA"+"blicas",
"quadrupede": "quadr"+u"\u00FA"+"pede",
"quadrupedes": "quadr"+u"\u00FA"+"pedes",
"quadrupla": "qu"+u"\u00E1"+"drupla",
"quadruplas": "qu"+u"\u00E1"+"druplas",
"quadruplo": "qu"+u"\u00E1"+"druplo",
"quarteis": "quart"+u"\u00E9"+"is",
"querencia": "quer"+u"\u00EA"+"ncia",
"querencias": "quer"+u"\u00EA"+"ncias",
"quilometro": "quil"+u"\u00F4"+"metro",
"quintessencia": "quintess"+u"\u00EA"+"ncia",
"quintessencias": "quintess"+u"\u00EA"+"ncias",
"radio": "r"+u"\u00E1"+"dio",
"reciproca": "rec"+u"\u00ED"+"proca",
"reciprocas": "rec"+u"\u00ED"+"procas",
"reciproco": "rec"+u"\u00ED"+"proco",
"Referencia": "Refer"+u"\u00EA"+"ncia",
"referencias": "refer"+u"\u00EA"+"ncias",
"reminiscencia": "reminisc"+u"\u00EA"+"ncia",
"reminiscencias": "reminisc"+u"\u00EA"+"ncias",
"renuncias": "ren"+u"\u00FA"+"ncias",
"Replica": "R"+u"\u00E9"+"plica",
"Replicas": "R"+u"\u00E9"+"plicas",
"replicas": "r"+u"\u00E9"+"plicas",
"Republica": "Rep"+u"\u00FA"+"blica",
"Republicas": "Rep"+u"\u00FA"+"blicas",
"republicas": "rep"+u"\u00FA"+"blicas",
"residencia": "resid"+u"\u00EA"+"ncia",
"residencias": "resid"+u"\u00EA"+"ncias",
"reticencia": "retic"+u"\u00EA"+"ncia",
"reticencias": "retic"+u"\u00EA"+"ncias",
"retorica": "ret"+u"\u00F3"+"rica",
"retoricas": "ret"+u"\u00F3"+"ricas",
"retorico": "ret"+u"\u00F3"+"rico",
"retrograda": "retr"+u"\u00F3"+"grada",
"retrogradas": "retr"+u"\u00F3"+"gradas",
"retrogrado": "retr"+u"\u00F3"+"grado",
"retrogrado": "retr"+u"\u00F3"+"grado",
"reusa": "re"+u"\u00FA"+"sa",
"reusas": "re"+u"\u00FA"+"sas",
"reuso": "re"+u"\u00FA"+"so",
"Reverencia": "Rever"+u"\u00EA"+"ncia",
"reverencias": "rever"+u"\u00EA"+"ncias",
"Revolve": "Rev"+u"\u00F3"+"lver",
"revolve": "Rev"+u"\u00F3"+"lver",
"revolves": "rev"+u"\u00F3"+"lveres",
"Revolver": "Rev"+u"\u00F3"+"lver",
"Revolveres": "Rev"+u"\u00F3"+"lveres",
"revolveres": "rev"+u"\u00F3"+"lveres",
"rodizio": "rod"+u"\u00ED"+"zio",
"Romania": "Rom"+u"\u00E2"+"nia",
"rufio": "r"+u"\u00FA"+"fio",
"rustica": "r"+u"\u00FA"+"stica",
"rusticas": "r"+u"\u00FA"+"sticas",
"rustico": "r"+u"\u00FA"+"stico",
"sache": "sach"+u"\u00EA",
"saches": "sach"+u"\u00EA"+"s",
"salario": "sal"+u"\u00E1"+"rio",
"saltica": "s"+u"\u00E1"+"ltica",
"salticas": "s"+u"\u00E1"+"lticas",
"saltico": "s"+u"\u00E1"+"ltico",
"Secretario": "Secret"+u"\u00E1"+"rio",
"secretario": "secret"+u"\u00E1"+"rio",
"seculo": "s"+u"\u00E9"+"culo",
"Sequencia": "Sequ"+u"\u00EA"+"ncia",
"sequencias": "sequ"+u"\u00EA"+"ncias",
"sequio": "s"+u"\u00E9"+"quio",
"serie": "s"+u"\u00E9"+"rie",
"series": "s"+u"\u00E9"+"ries",
"serigrafo": "ser"+u"\u00ED"+"grafo",
"serio": "s"+u"\u00E9"+"rio",
"silaba": "s"+u"\u00ED"+"laba",
"silabas": "s"+u"\u00ED"+"labas",
"silabo": "s"+u"\u00ED"+"labo",
"Silencio": "Sil"+u"\u00EA"+"ncio",
"silencio": "sil"+u"\u00EA"+"ncio",
"simbolo": "s"+u"\u00ED"+"mbolo",
"sincope": "s"+u"\u00ED"+"ncope",
"sincopes": "s"+u"\u00ED"+"ncopes",
"sindica": "s"+u"\u00ED"+"ndica",
"sindicas": "s"+u"\u00ED"+"ndicas",
"sindico": "s"+u"\u00ED"+"ndico",
"sitio": "s"+u"\u00ED"+"tio",
"solida": "s"+u"\u00F3"+"lida",
"solidas": "s"+u"\u00F3"+"lidas",
"solido": "s"+u"\u00F3"+"lido",
"sonambula": "son"+u"\u00E2"+"mbula",
"sonambulas": "son"+u"\u00E2"+"mbulas",
"sonambulo": "son"+u"\u00E2"+"mbulo",
"soporifero": "sopor"+u"\u00ED"+"fero",
"subespecifica": "subespec"+u"\u00ED"+"fica",
"subespecificas": "subespec"+u"\u00ED"+"ficas",
"subespecifico": "subespec"+u"\u00ED"+"fico",
"Subsecretario": "Subsecret"+u"\u00E1"+"rio",
"subsecretario": "subsecret"+u"\u00E1"+"rio",
"subsidio": "subs"+u"\u00ED"+"dio",
"substancia": "subst"+u"\u00E2"+"ncia",
"substancias": "subst"+u"\u00E2"+"ncias",
"sudorifica": "sudor"+u"\u00ED"+"fica",
"sudorificas": "sudor"+u"\u00ED"+"ficas",
"sudorifico": "sudor"+u"\u00ED"+"fico",
"sumaria": "sum"+u"\u00E1"+"ria",
"sumarias": "sum"+u"\u00E1"+"rias",
"Sumario": "Sum"+u"\u00E1"+"rio",
"sumario": "sum"+u"\u00E1"+"rio",
"sumula": "s"+u"\u00FA"+"mula",
"sumulas": "s"+u"\u00FA"+"mulas",
"suplicas": "su"+u"\u00FA"+"plicas",
"suplicio": "supl"+u"\u00ED"+"cio",
"taboa": "t"+u"\u00E1"+"bua",
"taboas": "t"+u"\u00E1"+"buas",
"tabua": "t"+u"\u00E1"+"bua",
"tabuas": "t"+u"\u00E1"+"buas",
"Tabula": "T"+u"\u00E1"+"bula",
"Tabulas": "T"+u"\u00E1"+"bulas",
"tabulas": "t"+u"\u00E1"+"bulas",
"Telegrafo": "Tel"+u"\u00E9"+"grafo",
"telegrafo": "tel"+u"\u00E9"+"grafo",
"tendencia": "tend"+u"\u00EA"+"ncia",
"tendencias": "tend"+u"\u00EA"+"ncias",
"tipica": "t"+u"\u00ED"+"pica",
"tipicas": "t"+u"\u00ED"+"picas",
"tipico": "t"+u"\u00ED"+"pico",
"tipografo": "tip"+u"\u00F3"+"grafo",
"titulo": "t"+u"\u00ED"+"tulo",
"Titulo": "T"+u"\u00ED"+"tulo",
"tomografo": "tom"+u"\u00F3"+"grafo",
"toneis": "ton"+u"\u00E9"+"is",
"toner": "t"+u"\u00F4"+"ner",
"topografo": "top"+u"\u00F3"+"grafo",
"toxica": "t"+u"\u00F3"+"xica",
"toxicas": "t"+u"\u00F3"+"xicas",
"toxico": "t"+u"\u00F3"+"xico",
"trafico": "tr"+u"\u00E1"+"fico",
"tragedia": "trag"+u"\u00E9"+"dia",
"tragedias": "trag"+u"\u00E9"+"dias",
"tramites": "tr"+u"\u00E2"+"mites",
"Transito": "Tr"+u"\u00E2"+"nsito",
"translucida": "transl"+u"\u00FA"+"cida",
"translucidas": "transl"+u"\u00FA"+"cidas",
"translucido": "transl"+u"\u00FA"+"cido",
"Tremula": "Tr"+u"\u00EA"+"mula",
"tremulas": "tr"+u"\u00EA"+"mulas",
"Tremulo": "Tr"+u"\u00EA"+"mulo",
"tremulo": "tr"+u"\u00EA"+"mulo",
"triangulo": "tri"+u"\u00E2"+"ngulo",
"tripe": "trip"+u"\u00E9",
"tropega": "tr"+u"\u00F4"+"pega",
"tropegas": "tr"+u"\u00F4"+"pegas",
"tropego": "tr"+u"\u00F4"+"pego",
"tropico": "tr"+u"\u00F3"+"pico",
"tumulo": "t"+u"\u00FA"+"mulo",
"ulcera": u"\u00FA"+"lcera",
"ulceras": u"\u00FA"+"lceras",
"ultima": u"\u00FA"+"ltima",
"ultimas": u"\u00FA"+"ltimas",
"ultimo": u"\u00FA"+"ltimo",
"unanime": "un"+u"\u00E2"+"nime",
"unanimes": "un"+u"\u00E2"+"nimes",
"urticaria": "urtic"+u"\u00E1"+"ria",
"veiculo": "ve"+u"\u00ED"+"culo",
"vermifugo": "verm"+u"\u00ED"+"fugo",
"virgula": "v"+u"\u00ED"+"rgula",
"virgulas": "v"+u"\u00ED"+"rgulas",
"Vitima": "V"+u"\u00ED"+"tima",
"vitimas": "v"+u"\u00ED"+"timas",
"vitoria": "vit"+u"\u00F3"+"ria",
"vitorias": "vit"+u"\u00F3"+"rias",
"Vivencia": "Viv"+u"\u00F3"+"ncia",
"vivencias": "viv"+u"\u00F3"+"ncias",
"voluntaria": "volunt"+u"\u00E1"+"ria",
"voluntarias": "volunt"+u"\u00E1"+"rias",
"voluntario": "volunt"+u"\u00E1"+"rio",
"xilografo": "xil"+u"\u00F3"+"grafo",
"xoco": "xoc"+u"\u00F3",
"zoografo": "zo"+u"\u00F3"+"grafo"}


acAcento = set(["abada",
"abobora", "aboboras", "abundancia",
"abundancias", "acaro", "acida", "acidas", "acido",
"adverbio", "Adverbio", "Africa", "africa",
"Africas", "africas", "africo", "Agencia", "Agencias", "agencias",
"alfandega","alfandegas", "alivio", "amago", "amilase", "angulo",
"anonima", "anonimas", "anonimo",
"antidoto", "antiespirita", "antifona", "antifonas",
"antifono", "Anuncio", "apostola", "apostolas", "apostolo",
"apostrofe", "apostrofes", "apostrofo", "apostrofos",
"arabia", "Arabia", "arabias", "Arabias"
"arbitro", "artificio", "assedio", "Assedio",
"assuca", "assucar", "atico", "atona", "atonas", "atono",
"atoxica", "atoxicas", "atoxico", "auspicia",
"auspicias", "auspicio", "Autenticas", "autenticas", "Autografo", "autografo", "autopsia", "autopsias",
"avicola", "avicolas", "avicula", "aviculas",
"avida", "avidas", "avido", "babeis", "Babeis", "balaustre", "balaustres", "bau",
"bibliografa", "bibliografas", "bibliografo", "biopsia",
"biopsias", "biotipo", "bordeis", "brecho", "burgues", "bussola",
"bussolas", "buzio", "cadencia", "cafe",
"cafes", "cafune", "calorifica", "calorificas",
"calorifico", "calunias", "cambio", "canada", "Canada",
"canfora", "CAPITULO", "Capitulo", "capitulo", "carate",
"caricia", "caricias", "carie", "caries", "carreteis", "carteis", "catalogo", "catimbo",
"caustica", "causticas", "caustico", "centigrada",
"centigradas", "centigrado", "centrifuga", "centrifugas",
"centrifugo", "chines", "cientifica", "cientificas",
"cientifico", "cinematografo", "cinzeis", "cipo", "circunstancia",
"ciume", "ciumes", "CLAUSULA", "clausula",
"Clausula", "CLAUSULAS", "clausulas", "Clausulas",
"Clinica", "clinica", "Clinicas", "clinicas", "clinico", "coagulo",
"cocega", "cocegas", "colonia", "colonias",
"coloquio", "comedia", "Comedia", "comedias",
"Comedias", "comercio", "Comercio",
"comissaria", "comissarias", "comissario", "comoda",
"comodas", "comodo", "compendio", "compito",
"concava", "concavas", "concavo", "conferencia",
"conferencias", "confidencias", "congenere", "congeneres", "consocio",
"consorcio", "contingencia", "contingencias", "continuas", "convenio",
"Convenio", "Coparticipe", "coparticipe", "Coparticipes", "coparticipes",
"Copia", "Copias", "copias",
"Cranio", "cranio", "cubica", "cubicas", "cubico", "cumulo",
"curia", "Curia", "custodia", "Custodia",
"custodias", "Custodio", "datilografo", "Debito", "Decima",
"decima", "decimas", "Decimo", "decimo", "denuncias", "Deposito", "Dicionario", "dicionario",
"diligencia", "diligencias", "distancias",
"domestica", "domesticas", "domestico", "domicilio",
"duble", "dubles", "Duvidas", "duzia", "duzias", "eclampsia", "eclampsias",
"ecografo", "Efigie", "efigie", "Efigies",
"efigies", "eletrolise", "eminencia", "Eminencia",
"eminencias", "empresaria", "empresarias", "empresario",
"enfase", "enfases", "EPIGRAFE", "epigrafe",
"Epigrafe", "EPIGRAFES", "epigrafes", "Epigrafes",
"epigrafo", "epigramatica", "epigramaticas", "epigramatico",
"episodio", "equivoco", "escambio", "escoria", "escorias",
"espatula", "espatulas", "especie", "especies", "especificas",
"espectroscopio", "espirita", "espiritas", "espirito",
"esplendida", "esplendidas", "esplendido", "espolio",
"estabulo", "estadio", "estancia", "Estancia",
"estancias", "estatua", "estatuas", "estomago",
"estrategia", "estrategias", "extravagancia", "extravagancias",
"estupida", "estupidas", "estupido", "Exercito", "exito", "experiencia",
"experiencias", "explicita", "explicitas", "explicito", "evidencias",
"Fabrica", "Fabricas", "fabricas", "fabula",
"fabulas", "falacia", "falacias", "ferias", "fieis", "figado",
"filosofa", "filosofas", "filosofo", "flamula", "flamulas", "fonografo",
"Formica", "formica", "formicas", "Formula", "Formulas", "formulas", "fosforo",
"fotocopia", "fotocopias", "frigida", "frigidas",
"frigido", "frigorifico", "fuba", "fubas",
"fulgido", "Galaxia", "galaxia", "galaxias", "gamba",
"gambas", "Gambia", "ganancia", "ganancias", "geografa",
"geografas", "geografo", "georreferencia", "georreferencias",
"Gerencia", "Gerencias", "gerencias", "ginastica", "ginasticas", "ginastico", "gloria",
"Gloria", "glorias", "gondola", "gondolas",
"gramatica", "gramaticas", "gramatico", "gravida",
"gravidas", "gravido", "guara", "guaras", "guarana", "guaranas", "halito",
"hemodialise", "hemodialises", "hemodiastase", "hemodiastases",
"heptafono", "heptafonos", "hibrida", "hibridas",
"hibrido", "hidrogena", "hidrogenas", "hidrogeno",
"hidrolise", "hidrolises", "hidrometro", "hilaria",
"hilarias", "hilario", "historia", "historias",
"homofila", "homofilas", "homofilo", "homofona",
"homofonas", "homofono", "honorifica", "honorificas",
"honorifico", "Horoscopo", "horoscopo", "Hospede", "Hospedes", "hospedes", "ignominia",
"ignominias", "ilegitima", "ilegitimas",
"ilegitimo", "impar", "impares", "impeto",
"impia", "impias", "impio", "indicio",
"indulgencia", "indulgencias", "Industria", "industria",
"Industria", "industrias", "Influencia", "influencias",
"ingenua", "ingenuas", "ingenuo", "Inicio", "INICIO", "insignia",
"insignias", "insipida", "insipidas", "insipido",
"insonia", "insonias", "instancia", "instancias",
"inteligencia", "inteligencias", "intimas", "inventario", "iridio",
"iris", "irreverencia", "irreverencias", "jornalistica",
"jornalisticas", "jornalistico", "lagrima", "lagrimas",
"lamina", "laminas", "Lampada", "lampada", "Lampadas", "lampadas", "Lastima", "Lastimas",
"lastimas", "legitimo", "licitas",
"licito", "Liquidas", "liquidas", "Liquido", "lirica", "liricas", "lirico",
"litigio", "logica", "logicas", "logico",
"lucifero", "ma", "macunaima", "Macunaima", "mafia",
"mafias", "mafua", "mafuas", "magica",
"magicas", "magico", "magnifica", "magnificas",
"magnifico", "Malaria", "malaria", "malarias",
"maleficio", "malicias", "maluques", "maniaca",
"maniacas", "maniaco", "manigancia", "manigancias", "maquina",
"maquinas", "Mascara", "Mascaras", "mascaras",
"Matricula", "Matriculas", "matriculas", "matrimonio",
"Medica", "medica", "Medicas", "medicas",
"Medico", "medico", "megametro", "Memoria",
"memoria", "memorias", "metafisica", "metafisicas",
"metafisico", "microbio", "micrografo", "milicia",
"milicias", "milimetro", "mimeografo", "mimica",
"mimicas", "mimico", "minuscula", "minusculas",
"minusculo", "misera", "miseras", "misero",
"monossilaba", "monossilabas", "monossilabo", "murmurio",
"musica", "musicas", "musico", "naufrago",
"necropsia", "necropsias", "negligencias", "Negocio", "nevoa", "nevoas",
"Noticia", "Noticias", "noticias", "noveis",
"obsequio", "obstaculo", "oficio", "omega",
"oraculo", "Orbita", "Orbitas", "orbitas", "osculo", "Ovulo", "pacifico", "pagina",
"paginas", "paleofilo", "paleografo", "paleto",
"palmatoria", "palmatorias",
"pandego", "panico", "pantografo", "papeis", "paralitica",
"paraliticas", "paralitico", "Parana",
"Parodia", "parodias", "Paroquia", "paroquia",
"Paroquias", "paroquias", "pascoa", "pascoas", "pasteis",
"Patio", "patio", "Patrimonio", "patrimonio",
"pavia", "pavias", "pendencia", "pendencias",
"pendulo", "penes", "penitencia", "penitencias",
"perdulario", "perfei"+u"\u00E7"+"oes", "Pericia", "Pericias", "pericias",
"perola", "perolas", "perpetuas", "perpetuo", "piramide", "piramides",
"pirografo", "placida", "placidas", "placido",
"plagio", "planteis", "plastica", "plasticas", "plastico",
"polemica", "polemicas", "polemico", "poligrafa",
"poligrafas", "poligrafo", "porem", "porno",
"pornos", "potencia", "potencias", "preambulo", "pre"+u"\u00E7"+"ario",
"prefacio", "preferencia", "preferencias", "premio",
"prenuncio", "presagio", "presidio", "pressagio",
"principio", "prodiga", "prodigas", "prodigo",
"prologo", "pronostico", "prontuario", "propicio",
"proposito", "Prospero", "Prospera", "Prosperas", "prosperas",
"proverbio", "Proverbio", "Providencia", "providencias", "prudencia",
"prudencias", "psicanalise", "psicanalises", 
"psicoanalise", "psicoanalises", "psicologa",
"psicologas", "psicologo", "Publica", "Publicas", "publicas",
"quadrupla", "quadruplas",
"quadruplo", "quarteis", "quilometro", "radio", "reciproca",
"reciprocas", "reciproco", "Referencia", "referencias",
"renuncias", "Replica", "Replicas", "replicas",
"Republica", "Republicas", "republicas", "residencia", "residencias",
"reticencia", "reticencias", "retorica", "retoricas",
"retorico", "retrograda", "retrogradas",
"retrogrado", "retrogrado", "reusa", "reusas",
"reuso", "Reverencia", "reverencias", "Revolve", "revolve", "revolves", "Revolver", "Revolveres",
"revolveres", "rodizio", "Romania", "rufio",
"rustica", "rusticas", "rustico", "sache",
"saches", "salario", "saltica", "salticas",
"saltico", "Secretario", "secretario", "seculo",
"Sequencia", "sequencias", "sequio", "serie", "series", "serigrafo", "serio",
"silaba", "silabas", "silabo", "Silencio", "silencio", "simbolo",
"sincope", "sincopes", "sindica",
"sindicas", "sindico", "sitio", "solida",
"solidas", "solido", "sonambula", "sonambulas",
"sonambulo", "soporifero", "subespecifica", "subespecificas",
"subespecifico", "Subsecretario", "subsecretario", "subsidio",
"substancia", "substancias",
"sudorifica", "sudorificas", "sudorifico", "sumaria",
"sumarias", "Sumario", "sumario", "sumula",
"sumulas", "suplicio", "taboa", "taboas", "tabua",
"tabuas", "Tabula", "Tabulas", "tabulas", "Telegrafo", "telegrafo",
"tendencia", "tendencias", "tipica", "tipicas",
"tipico", "tipografo", "titulo", "Titulo",
"tomografo", "toneis", "toner", "topografo", "toxica",
"toxicas", "toxico", "trafico", "tragedia",
"tragedias", "tramites", "Transito", "translucida", "translucidas", "translucido",
"Tremula", "tremulas", "Tremulo", "tremulo",
"triangulo", "tripe", "tropega",
"tropegas", "tropego", "tropico", "tumulo",
"ulcera", "ulceras", "ultima", "ultimas",
"ultimo", "unanime", "unanimes", "urticaria",
"veiculo", "vermifugo", "virgula", "virgulas",
"Vitima", "vitimas",
"vitoria", "vitorias", "Vivencia", "vivencias", "voluntaria", "voluntarias",
"voluntario", "xilografo", "xoco", "zoografo"])


aaGrafia = {"abita": "habita",
"abitam": "habitam",
"abitar": "habitar",
"abitaram": "habitaram",
"abitarem": "habitarem",
"abitaria": "habitaria",
"abitariam": "habitariam",
"abitasse": "habitasse",
"abitassem": "habitassem",
"abitava": "habitava",
"abitavam": "habitavam",
"abite": "habite",
"abitei": "habitei",
"abitem": "habitem",
"abito": "habitou",
"abitou": "habitou",
"arroxa": "arrocha",
"arroxam": "arrocham",
"arroxar": "arrochar",
"arroxaram": "arrocharam",
"arroxarem": "arrocharem",
"arroxasse": "arrochasse",
"arroxassem": "arrochassem",
"arroxava": "arrochava",
"arroxavam": "arrochavam",
"arroxe": "arroche",
"arroxei": "arrochei",
"arroxem": "arrochem",
"arroxo": "arrocho",
"arroxou": "arrochou", 
"asar": "azar",
"Asar": "Azar",
"asia": "azia",
"Asia": u"\u00C1"+"sia",
"asseita": "aceita",
"asseitam": "aceitam",
"asseitar": "aceitar",
"asseitaram": "aceitaram",
"asseitarem": "aceitarem",
"asseitasse": "aceitasse",
"asseitassem": "aceitassem",
"asseitava": "aceitava",
"asseitavam": "aceitavam",
"asseite": "aceite",
"asseitei": "aceitei",
"asseitem": "aceitem",
"asseito": "aceito",
"asseitou": "aceitou", 
"asserta": "acerta",
"assertam": "acertam",
"assertar": "acertar",
"assertaram": "acertaram",
"assertarem": "acertarem",
"assertasse": "acertasse",
"assertassem": "acertassem",
"assertava": "acertava",
"assertavam": "acertavam",
"asserte": "acerte",
"assertei": "acertei",
"assertem": "acertem",
"asserto": "acerto",
"assertou": "acertou",
"aza": "asa",
"azas": "asas",
"azinha": "asinha",
"azinhas": "asinhas",
"cerra": "serra",
"cerrar": "serrar",
"cerras": "serras",
"estrema": "extrema",
"estremas": "extremas",
"estremo": "extremo",
"estremos": "extremos",
"facha": "faixa",
"fachas": "faixas",
"jia": "gia",
"jias": "gias",
"liza": "lisa",
"lizas": "lisas",
"lizo": "liso",
"mofina": "morfina",
"maz": "mas",
"n"+u"\u00ED"+"veo": "n"+u"\u00ED"+"vel",
"pence": "pense",
"pences": "penses",
"rezina": "resina",
"rezinas": "resinas",
"sega": "cega",
"segas": "cegas",
"sego": "cego",
"sine": "cine",
"treno": "treino",
"trocha": "trouxa",
"trochas": "trouxas",
"X"+u"\u00E1"+"cara": "Ch"+u"\u00E1"+"cara",
"x"+u"\u00E1"+"cara": "ch"+u"\u00E1"+"cara",
"x"+u"\u00E1"+"caras": "Ch"+u"\u00E1"+"caras"}

acGrafia = set(["abita", "abitam", "abitar", "abitaram", "abitarem",
"abitaria", "abitariam", "abitasse", "abitassem", "abitava", "abitavam",
"abite", "abitei", "abitem", "abito", "abitou", "arroxa", "arroxam",
"arroxar", "arroxaram", "arroxarem", "arroxasse", "arroxassem",
"arroxava", "arroxavam", "arroxe", "arroxei", "arroxem", "arroxo",
"arroxou", "asar", "Asar", "asia", "Asia", "asseita", "asseitam",
"asseitar", "asseitaram",
"asseitarem", "asseitasse", "asseitassem", "asseitava", "asseitavam",
"asseite", "asseitei", "asseitem", "asseito", "asseitou", "asserta",
"assertam", "assertar", "assertaram", "assertarem", "assertasse",
"assertassem", "assertava", "assertavam", "asserte", "assertei",
"assertem", "asserto", "assertou", "aza",  "azas", "azinha", "azinhas",
"cerra", "cerrar", "cerras", "estrema", "estremas", "estremo", "estremos",
"facha", "fachas", "jia", "jias", "liza", "lizas", "lizo", "maz", "mofina",
"n"+u"\u00ED"+"veo", "pence", "pences", "rezina", "rezinas", "sega", "segas",
"sego", "treno", "trocha", "trochas", "X"+u"\u00E1"+"cara",
"x"+u"\u00E1"+"cara", "x"+u"\u00E1"+"caras"])


# palavras terminadas em s - gas, pais
varpesse = {"antepa"+u"\u00ED"+"s": "antepa"+u"\u00ED"+"ses",
"conv"+u"\u00E9"+"s": "conveses",
"deus": "deuses",
"g"+u"\u00E1"+"s": "gases",
"obus": "obuses",
"pa"+u"\u00ED"+"s": "pa"+u"\u00ED"+"ses",
"satan"+u"\u00E1"+"s": "satanases",
"semideus": "semideuses",
"vi"+u"\u00E9"+"s": "vieses"}

# palavras terminadas em s - gas, pais
varsesse = {"antepa"+u"\u00ED"+"ses": "antepa"+u"\u00ED"+"s",
"conveses": "conv"+u"\u00E9"+"s",
"deuses": "deus",
"gases": "g"+u"\u00E1"+"s",
"obuses": "obus",
"pa"+u"\u00ED"+"ses": "pa"+u"\u00ED"+"s",
"satanases": "satan"+u"\u00E1"+"s",
"semideuses": "semideus",
"vieses": "vi"+u"\u00E9"+"s"}

# palavras terminadas em s - gas, pais
aapesse = set(["antepa"+u"\u00ED"+"s", "conv"+u"\u00E9"+"s", "deus", "g"+u"\u00E1"+"s",
"obus", "pa"+u"\u00ED"+"s", "satan"+u"\u00E1"+"s", "semideus", "vi"+u"\u00E9"+"s"])

# palavras terminadas em s - gas, pais
aasesse = set(["antepa"+u"\u00ED"+"ses", "conveses", "deuses", "gases", "obuses",
"pa"+u"\u00ED"+"ses", "satanases", "semideuses", "vieses"])






comCrase = set(["anterior", "anteriores", "compara", "comparada",
"comparadas", "equivale", "equivalente", "equivalentes",
"iguais", "igual", "inferior", "inferiores", "oposta",
"opostas", "paralela", "paralelas", "perpendicular", "perpendiculares", "posterior",
"posteriores", "semelhante", "semelhantes", "similar", "similares",
"superior", "superiores"])


semCrase = set(["acidente", "acidentes", "acolher", u"\u00E1"+"cool",
"algu"+u"\u00E9"+"m", "algum", "alguma", "algumas", "alguns", "ambas",
"ambiente", "ambientes", "bem", "bordoadas", "bra"+u"\u00E7"+"adas",
 "cabe"+u"\u00E7"+"adas", "cacetadas", "cada", "celular",
"celulares", "chibatadas", "convite", "convites", "crime", "crimes",
"cuja", "cujas", "Deus", "diesel", "dizem", "dois",
"ela", "elas", "ele", "eletricidade", "eles", "encher", "encolher",
"esc"+u"\u00E2"+"ncaras", "escolher", "essa",
"essas", "esse", "esses", "esta", "estas", "este",
"estes", "facadas", "faz", "fez", "filme", "filmes", "fim", "fiz", "galope",
"gasolina", "granel", "homem", "homens", "Jesus", "joelhadas", "jusante",
"l"+u"\u00E1"+"pis", "lenha", "leste", "lufadas", "lume", "mais", "mal",
"males",  "marteladas", "melhor", "mim", "montante", "nome",
"ningu"+u"\u00E9"+"m", "nomes", "noroeste", "nordeste", "norte",
"n"+u"\u00F3"+"s", "oeste", "outrem", "pauladas", "p"+u"\u00E3"+"o", "perfume",
"p"+u"\u00E9", "pilha", "pior", "pontap"+u"\u00E9"+"s", "porradas", "porretadas",
"preencher", "presta"+u"\u00E7"+u"\u00F5"+"es", "punhaladas", "querosene",
"recolher", "rigor", "rosas", "sangue", "sangues", "s"+u"\u00F3"+"s", "sudeste",
"sudoeste", "sul", "tem", "ti", "time", "times", "toda", "todas", "tolher",
"toque", "transporte", "transportes", "trote", "um", "uma", "vapor",
"volume", "volumes", "v"+u"\u00F3"+"s",
"vossa", "Vossa", "vossas", "Zeus"])


#femeCrase  - Palavras femininas terminadas em -o-
femeCrase = set(["acess"+u"\u00E3"+"o", "Acess"+u"\u00E3"+"o",
"acupress"+u"\u00E3"+"o", "Acupress"+u"\u00E3"+"o", "ades"+u"\u00E3"+"o", "Ades"+u"\u00E3"+"o",
"admiss"+u"\u00E3"+"o", "Admiss"+u"\u00E3"+"o", "adust"+u"\u00E3"+"o", "Adust"+u"\u00E3"+"o",
"agress"+u"\u00E3"+"o", "Agress"+u"\u00E3"+"o", "alus"+u"\u00E3"+"o", "Alus"+u"\u00E3"+"o",
"amarelid"+u"\u00E3"+"o", "Amarelid"+u"\u00E3"+"o", "amplid"+u"\u00E3"+"o", "Amplid"+u"\u00E3"+"o",
"animadvers"+u"\u00E3"+"o", "Animadvers"+u"\u00E3"+"o", "antevis"+u"\u00E3"+"o", "Antevis"+u"\u00E3"+"o",
"apreens"+u"\u00E3"+"o", "Apreens"+u"\u00E3"+"o", "aptid"+u"\u00E3"+"o", "Aptid"+u"\u00E3"+"o",
"ascens"+u"\u00E3"+"o", "Ascens"+u"\u00E3"+"o", "aspers"+u"\u00E3"+"o", "Aspers"+u"\u00E3"+"o",
"autogest"+u"\u00E3"+"o", "Autogest"+u"\u00E3"+"o", "avers"+u"\u00E3"+"o", "Avers"+u"\u00E3"+"o",
"bernard"+u"\u00E3"+"o", "Bernard"+u"\u00E3"+"o", "bioimpress"+u"\u00E3"+"o",
"Bioimpress"+u"\u00E3"+"o", "branquid"+u"\u00E3"+"o", "Branquid"+u"\u00E3"+"o",
"brusquid"+u"\u00E3"+"o", "Brusquid"+u"\u00E3"+"o", "certid"+u"\u00E3"+"o", "Certid"+u"\u00E3"+"o",
"cess"+u"\u00E3"+"o", "Cess"+u"\u00E3"+"o", "Cinco", "cinco", "circuncis"+u"\u00E3"+"o", "Circuncis"+u"\u00E3"+"o",
"cis"+u"\u00E3"+"o", "Cis"+u"\u00E3"+"o", "coaliz"+u"\u00E3"+"o", "Coaliz"+u"\u00E3"+"o",
"coes"+u"\u00E3"+"o", "Coes"+u"\u00E3"+"o", "colis"+u"\u00E3"+"o", "Colis"+u"\u00E3"+"o",
"combust"+u"\u00E3"+"o", "Combust"+u"\u00E3"+"o", "comich"+u"\u00E3"+"o", "Comich"+u"\u00E3"+"o",
"comiss"+u"\u00E3"+"o", "Comiss"+u"\u00E3"+"o", "compaix"+u"\u00E3"+"o", "Compaix"+u"\u00E3"+"o",
"compreens"+u"\u00E3"+"o", "Compreens"+u"\u00E3"+"o", "compress"+u"\u00E3"+"o", "Compress"+u"\u00E3"+"o",
"compuls"+u"\u00E3"+"o", "Compuls"+u"\u00E3"+"o", "comunh"+u"\u00E3"+"o", "Comunh"+u"\u00E3"+"o",
"concess"+u"\u00E3"+"o", "Concess"+u"\u00E3"+"o", "concis"+u"\u00E3"+"o", "Concis"+u"\u00E3"+"o",
"conclus"+u"\u00E3"+"o", "Conclus"+u"\u00E3"+"o", "concuss"+u"\u00E3"+"o", "Concuss"+u"\u00E3"+"o",
"conex"+u"\u00E3"+"o", "Conex"+u"\u00E3"+"o", "confiss"+u"\u00E3"+"o", "Confiss"+u"\u00E3"+"o",
"confus"+u"\u00E3"+"o", "Confus"+u"\u00E3"+"o", "congest"+u"\u00E3"+"o", "Congest"+u"\u00E3"+"o",
"contram"+u"\u00E3"+"o",  "Contarraz"+u"\u00E3"+"o", "contarraz"+u"\u00E3"+"o",
"contus"+u"\u00E3"+"o", "Contus"+u"\u00E3"+"o", "convers"+u"\u00E3"+"o",
"Convers"+u"\u00E3"+"o", "convex"+u"\u00E3"+"o", "Convex"+u"\u00E3"+"o", "convuls"+u"\u00E3"+"o",
"Convuls"+u"\u00E3"+"o", "corras"+u"\u00E3"+"o", "Corras"+u"\u00E3"+"o",
"corros"+u"\u00E3"+"o", "Corros"+u"\u00E3"+"o", "cosmovis"+u"\u00E3"+"o", "Cosmovis"+u"\u00E3"+"o",
"crucifix"+u"\u00E3"+"o", "Crucifix"+u"\u00E3"+"o", "Cubat"+u"\u00E3"+"o", "d"+u"\u00E3"+"o",
"D"+u"\u00E3"+"o", "decis"+u"\u00E3"+"o", "Decis"+u"\u00E3"+"o", "defens"+u"\u00E3"+"o",
"Defens"+u"\u00E3"+"o", "deflex"+u"\u00E3"+"o", "Deflex"+u"\u00E3"+"o", "demiss"+u"\u00E3"+"o",
"Demiss"+u"\u00E3"+"o", "densid"+u"\u00E3"+"o", "Densid"+u"\u00E3"+"o", "depress"+u"\u00E3"+"o",
"Depress"+u"\u00E3"+"o", "deris"+u"\u00E3"+"o", "Deris"+u"\u00E3"+"o", "descens"+u"\u00E3"+"o",
"Descens"+u"\u00E3"+"o", "descompress"+u"\u00E3"+"o", "Descompress"+u"\u00E3"+"o", "desconex"+u"\u00E3"+"o",
"Desconex"+u"\u00E3"+"o", "desilus"+u"\u00E3"+"o", "Desilus"+u"\u00E3"+"o", "Deso", "DESO",
"despretens"+u"\u00E3"+"o", "Despretens"+u"\u00E3"+"o", "desuni"+u"\u00E3"+"o",
"Desuni"+u"\u00E3"+"o", "devassid"+u"\u00E3"+"o", "Devassid"+u"\u00E3"+"o",
"Dezoito", "dezoito", "difus"+u"\u00E3"+"o", "Difus"+u"\u00E3"+"o", "digest"+u"\u00E3"+"o",
"Digest"+u"\u00E3"+"o", "digress"+u"\u00E3"+"o", "Digress"+u"\u00E3"+"o", "dimens"+u"\u00E3"+"o",
"Dimens"+u"\u00E3"+"o", "discuss"+u"\u00E3"+"o", "Discuss"+u"\u00E3"+"o", "dispers"+u"\u00E3"+"o",
"Dispers"+u"\u00E3"+"o", "dissens"+u"\u00E3"+"o", "dissuas"+u"\u00E3"+"o", "Dissuas"+u"\u00E3"+"o", "distens"+u"\u00E3"+"o",
"Distens"+u"\u00E3"+"o", "divers"+u"\u00E3"+"o", "Divers"+u"\u00E3"+"o", "divis"+u"\u00E3"+"o",
"Divis"+u"\u00E3"+"o", "do", "Do", "dos",
"Dos", "eclos"+u"\u00E3"+"o", "Eclos"+u"\u00E3"+"o", "efus"+u"\u00E3"+"o",
"Efus"+u"\u00E3"+"o", "egest"+u"\u00E3"+"o", "Egest"+u"\u00E3"+"o", "electrocuss"+u"\u00E3"+"o",
"Electrocuss"+u"\u00E3"+"o", "eletrofus"+u"\u00E3"+"o", "Eletrofus"+u"\u00E3"+"o", "emers"+u"\u00E3"+"o",
"Emers"+u"\u00E3"+"o", "emiss"+u"\u00E3"+"o", "Emiss"+u"\u00E3"+"o", "emuls"+u"\u00E3"+"o",
"Emuls"+u"\u00E3"+"o", "ent"+u"\u00E3"+"o", "entrevis"+u"\u00E3"+"o", "Entrevis"+u"\u00E3"+"o", "eros"+u"\u00E3"+"o",
"Eros"+u"\u00E3"+"o", "escans"+u"\u00E3"+"o", "Escans"+u"\u00E3"+"o",
"escravid"+u"\u00E3"+"o", "Escravid"+u"\u00E3"+"o", "escrupulid"+u"\u00E3"+"o",
"Escrupulid"+u"\u00E3"+"o", "escurid"+u"\u00E3"+"o", "Escurid"+u"\u00E3"+"o", "espessid"+u"\u00E3"+"o",
"Espessid"+u"\u00E3"+"o", "evas"+u"\u00E3"+"o", "Evas"+u"\u00E3"+"o", "Ex-pris"+u"\u00E3"+"o",
"exatid"+u"\u00E3"+"o", "Exatid"+u"\u00E3"+"o", "exaust"+u"\u00E3"+"o", "Exaust"+u"\u00E3"+"o",
"excis"+u"\u00E3"+"o", "Excis"+u"\u00E3"+"o", "exclus"+u"\u00E3"+"o", "Exclus"+u"\u00E3"+"o",
"excomunh"+u"\u00E3"+"o", "Excomunh"+u"\u00E3"+"o", "excurs"+u"\u00E3"+"o", "Excurs"+u"\u00E3"+"o",
"expans"+u"\u00E3"+"o", "Expans"+u"\u00E3"+"o", "explos"+u"\u00E3"+"o", "Explos"+u"\u00E3"+"o",
"express"+u"\u00E3"+"o", "Express"+u"\u00E3"+"o", "expuls"+u"\u00E3"+"o", "Expuls"+u"\u00E3"+"o",
"extens"+u"\u00E3"+"o", "Extens"+u"\u00E3"+"o", "extors"+u"\u00E3"+"o", "Extors"+u"\u00E3"+"o",
"extrovers"+u"\u00E3"+"o", "Extrovers"+u"\u00E3"+"o", "extrus"+u"\u00E3"+"o", "Extrus"+u"\u00E3"+"o",
"f"+u"\u00E3"+"o", "F"+u"\u00E3"+"o", "fiss"+u"\u00E3"+"o", "Fiss"+u"\u00E3"+"o",
"flex"+u"\u00E3"+"o", "Flex"+u"\u00E3"+"o", "fonofoto", "Fonofoto", "foto", "Foto",
"fotoemiss"+u"\u00E3"+"o", "Fotoemiss"+u"\u00E3"+"o", "fotofiss"+u"\u00E3"+"o", "Fotofiss"+u"\u00E3"+"o",
"fotos", "Fotos", "Fraz"+u"\u00E3"+"o", "fresquid"+u"\u00E3"+"o",
"Fresquid"+u"\u00E3"+"o", "frouxid"+u"\u00E3"+"o", "Frouxid"+u"\u00E3"+"o", "fus"+u"\u00E3"+"o",
"Fus"+u"\u00E3"+"o", "gest"+u"\u00E3"+"o", "Gest"+u"\u00E3"+"o", "gratid"+u"\u00E3"+"o",
"Gratid"+u"\u00E3"+"o", "hipertens"+u"\u00E3"+"o", "Hipertens"+u"\u00E3"+"o", "hipotens"+u"\u00E3"+"o",
"Hipotens"+u"\u00E3"+"o", "ilus"+u"\u00E3"+"o", "Ilus"+u"\u00E3"+"o", "imensid"+u"\u00E3"+"o",
"Imensid"+u"\u00E3"+"o", "imers"+u"\u00E3"+"o", "Imers"+u"\u00E3"+"o", "imiss"+u"\u00E3"+"o",
"Imiss"+u"\u00E3"+"o", "implos"+u"\u00E3"+"o", "Implos"+u"\u00E3"+"o", "imprecis"+u"\u00E3"+"o",
"Imprecis"+u"\u00E3"+"o", "impress"+u"\u00E3"+"o", "Impress"+u"\u00E3"+"o", "impuls"+u"\u00E3"+"o",
"Impuls"+u"\u00E3"+"o", "imunodepress"+u"\u00E3"+"o", "Imunodepress"+u"\u00E3"+"o", "inaptid"+u"\u00E3"+"o",
"Inaptid"+u"\u00E3"+"o", "incis"+u"\u00E3"+"o", "Incis"+u"\u00E3"+"o", "inclus"+u"\u00E3"+"o",
"Inclus"+u"\u00E3"+"o", "incompreens"+u"\u00E3"+"o", "Incompreens"+u"\u00E3"+"o", "incurs"+u"\u00E3"+"o",
"Incurs"+u"\u00E3"+"o", "indecis"+u"\u00E3"+"o", "Indecis"+u"\u00E3"+"o", "indigest"+u"\u00E3"+"o",
"Indigest"+u"\u00E3"+"o", "indivis"+u"\u00E3"+"o", "Indivis"+u"\u00E3"+"o", "inexatid"+u"\u00E3"+"o",
"Inexatid"+u"\u00E3"+"o", "inexpress"+u"\u00E3"+"o", "Inexpress"+u"\u00E3"+"o", "inflex"+u"\u00E3"+"o",
"Inflex"+u"\u00E3"+"o", "infus"+u"\u00E3"+"o", "Infus"+u"\u00E3"+"o", "ingest"+u"\u00E3"+"o",
"Ingest"+u"\u00E3"+"o", "ingratid"+u"\u00E3"+"o", "Ingratid"+u"\u00E3"+"o", "insubmiss"+u"\u00E3"+"o",
"Insubmiss"+u"\u00E3"+"o", "intens"+u"\u00E3"+"o", "Intens"+u"\u00E3"+"o", "intercess"+u"\u00E3"+"o",
"Intercess"+u"\u00E3"+"o", "interconex"+u"\u00E3"+"o", "Interconex"+u"\u00E3"+"o", "intromiss"+u"\u00E3"+"o",
"Intromiss"+u"\u00E3"+"o", "introvers"+u"\u00E3"+"o", "Introvers"+u"\u00E3"+"o", "intrus"+u"\u00E3"+"o",
"Intrus"+u"\u00E3"+"o", "invas"+u"\u00E3"+"o", "Invas"+u"\u00E3"+"o", "invers"+u"\u00E3"+"o",
"Invers"+u"\u00E3"+"o", "irreflex"+u"\u00E3"+"o", "Irreflex"+u"\u00E3"+"o", "irreligi"+u"\u00E3"+"o",
"Irreligi"+u"\u00E3"+"o", "irris"+u"\u00E3"+"o", "Irris"+u"\u00E3"+"o", "lassid"+u"\u00E3"+"o",
"Lassid"+u"\u00E3"+"o", "legi"+u"\u00E3"+"o", "Legi"+u"\u00E3"+"o", "lentid"+u"\u00E3"+"o",
"Lentid"+u"\u00E3"+"o", "les"+u"\u00E3"+"o", "Les"+u"\u00E3"+"o", "libido",
"Libido", "lipo", "Lipo", "lipos", "Lipos", "macro", "Macro", "macrorregi"+u"\u00E3"+"o",
"Macrorregi"+u"\u00E3"+"o", "macros", "Macros",
"mans"+u"\u00E3"+"o", "Mans"+u"\u00E3"+"o", "mansid"+u"\u00E3"+"o",
"Mansid"+u"\u00E3"+"o", "m"+u"\u00E3"+"o", "M"+u"\u00E3"+"o", "m"+u"\u00E3"+"os",
"M"+u"\u00E3"+"os", "micro", "Micro", "microrregi"+u"\u00E3"+"o", "Microrregi"+u"\u00E3"+"o", "micros", "Micros",
"miss"+u"\u00E3"+"o", "Miss"+u"\u00E3"+"o", "mornid"+u"\u00E3"+"o",
"Mornid"+u"\u00E3"+"o", "moto", "Moto", "motos", "Motos", "motos",
"multid"+u"\u00E3"+"o", "Multid"+u"\u00E3"+"o", "negrid"+u"\u00E3"+"o",
"Negrid"+u"\u00E3"+"o", "obsess"+u"\u00E3"+"o", "Obsess"+u"\u00E3"+"o", "ocasi"+u"\u00E3"+"o",
"Ocasi"+u"\u00E3"+"o", "oclus"+u"\u00E3"+"o", "Oclus"+u"\u00E3"+"o", "oito", "Oito", "omiss"+u"\u00E3"+"o",
"Omiss"+u"\u00E3"+"o", "opini"+u"\u00E3"+"o", "Opini"+u"\u00E3"+"o", "opress"+u"\u00E3"+"o",
"Opress"+u"\u00E3"+"o", "paix"+u"\u00E3"+"o", "Paix"+u"\u00E3"+"o", "pens"+u"\u00E3"+"o",
"Pens"+u"\u00E3"+"o", "percuss"+u"\u00E3"+"o", "Percuss"+u"\u00E3"+"o", "perdig"+u"\u00E3"+"o",
"Perdig"+u"\u00E3"+"o", "perfus"+u"\u00E3"+"o", "Perfus"+u"\u00E3"+"o", "permiss"+u"\u00E3"+"o",
"Permiss"+u"\u00E3"+"o", "perplex"+u"\u00E3"+"o", "Perplex"+u"\u00E3"+"o", "persuas"+u"\u00E3"+"o",
"Persuas"+u"\u00E3"+"o", "pervers"+u"\u00E3"+"o", "Pervers"+u"\u00E3"+"o", "podrid"+u"\u00E3"+"o",
"Podrid"+u"\u00E3"+"o", "possess"+u"\u00E3"+"o", "Possess"+u"\u00E3"+"o", "precess"+u"\u00E3"+"o",
"Precess"+u"\u00E3"+"o", "precis"+u"\u00E3"+"o", "Precis"+u"\u00E3"+"o", "preclus"+u"\u00E3"+"o",
"Preclus"+u"\u00E3"+"o", "preens"+u"\u00E3"+"o",
"Preens"+u"\u00E3"+"o", "press"+u"\u00E3"+"o", "Press"+u"\u00E3"+"o", "pretens"+u"\u00E3"+"o",
"Pretens"+u"\u00E3"+"o", "pretid"+u"\u00E3"+"o", "Pretid"+u"\u00E3"+"o", "previs"+u"\u00E3"+"o",
"Previs"+u"\u00E3"+"o", "pris"+u"\u00E3"+"o", "Pris"+u"\u00E3"+"o", "prociss"+u"\u00E3"+"o",
"Prociss"+u"\u00E3"+"o", "profiss"+u"\u00E3"+"o", "Profiss"+u"\u00E3"+"o", "profus"+u"\u00E3"+"o",
"Profus"+u"\u00E3"+"o", "progress"+u"\u00E3"+"o", "Progress"+u"\u00E3"+"o", "prontid"+u"\u00E3"+"o",
"Prontid"+u"\u00E3"+"o", "propens"+u"\u00E3"+"o", "Propens"+u"\u00E3"+"o", "propuls"+u"\u00E3"+"o",
"Propuls"+u"\u00E3"+"o", "provis"+u"\u00E3"+"o", "Provis"+u"\u00E3"+"o", "puls"+u"\u00E3"+"o",
"Puls"+u"\u00E3"+"o", "quatro", "Quatro", "quest"+u"\u00E3"+"o", "Quest"+u"\u00E3"+"o", 
"R"+u"\u00E1"+"dio", "r"+u"\u00E1"+"dio", "radiodifus"+u"\u00E3"+"o",
"Radiodifus"+u"\u00E3"+"o", "radiotelevis"+u"\u00E3"+"o", "Radiotelevis"+u"\u00E3"+"o", "ras"+u"\u00E3"+"o",
"Ras"+u"\u00E3"+"o", "raz"+u"\u00E3"+"o", "Raz"+u"\u00E3"+"o", "readmiss"+u"\u00E3"+"o",
"Readmiss"+u"\u00E3"+"o", "rebeli"+u"\u00E3"+"o", "Rebeli"+u"\u00E3"+"o", "recens"+u"\u00E3"+"o",
"Recens"+u"\u00E3"+"o", "recess"+u"\u00E3"+"o", "Recess"+u"\u00E3"+"o", "reclus"+u"\u00E3"+"o",
"Reclus"+u"\u00E3"+"o", "reconvers"+u"\u00E3"+"o", "Reconvers"+u"\u00E3"+"o", "reflex"+u"\u00E3"+"o",
"Reflex"+u"\u00E3"+"o", "regi"+u"\u00E3"+"o", "Regi"+u"\u00E3"+"o", "regress"+u"\u00E3"+"o",
"Regress"+u"\u00E3"+"o", "reimpress"+u"\u00E3"+"o", "Reimpress"+u"\u00E3"+"o", "reinvers"+u"\u00E3"+"o",
"Reinvers"+u"\u00E3"+"o", "religi"+u"\u00E3"+"o", "Religi"+u"\u00E3"+"o", "remiss"+u"\u00E3"+"o",
"Remiss"+u"\u00E3"+"o", "repercuss"+u"\u00E3"+"o", "Repercuss"+u"\u00E3"+"o", "repreens"+u"\u00E3"+"o",
"Repreens"+u"\u00E3"+"o", "repress"+u"\u00E3"+"o", "Repress"+u"\u00E3"+"o", "repuls"+u"\u00E3"+"o",
"Repuls"+u"\u00E3"+"o", "rescis"+u"\u00E3"+"o", "Rescis"+u"\u00E3"+"o", "retid"+u"\u00E3"+"o",
"Retid"+u"\u00E3"+"o", "retransmiss"+u"\u00E3"+"o", "Retransmiss"+u"\u00E3"+"o", "retrovers"+u"\u00E3"+"o",
"Retrovers"+u"\u00E3"+"o", "reuni"+u"\u00E3"+"o", "Reuni"+u"\u00E3"+"o", "revers"+u"\u00E3"+"o",
"Revers"+u"\u00E3"+"o", "revis"+u"\u00E3"+"o", "Revis"+u"\u00E3"+"o", "rez"+u"\u00E3"+"o",
"Rez"+u"\u00E3"+"o", "rouquid"+u"\u00E3"+"o", "Rouquid"+u"\u00E3"+"o", "saz"+u"\u00E3"+"o",
"sans"+u"\u00E3"+"o", "Saz"+u"\u00E3"+"o", "secess"+u"\u00E3"+"o", "Secess"+u"\u00E3"+"o", "sequid"+u"\u00E3"+"o",
"Sequid"+u"\u00E3"+"o", "servid"+u"\u00E3"+"o", "Servid"+u"\u00E3"+"o", "sess"+u"\u00E3"+"o",
"Sess"+u"\u00E3"+"o", "sobrefus"+u"\u00E3"+"o", "Sobrefus"+u"\u00E3"+"o", "sofreguid"+u"\u00E3"+"o",
"Sofreguid"+u"\u00E3"+"o", "soid"+u"\u00E3"+"o", "Soid"+u"\u00E3"+"o", "solid"+u"\u00E3"+"o",
"Solid"+u"\u00E3"+"o", "soliflux"+u"\u00E3"+"o", "Soliflux"+u"\u00E3"+"o", "su"+u"\u00E3"+"o",
"Su"+u"\u00E3"+"o", "suas"+u"\u00E3"+"o", "Suas"+u"\u00E3"+"o", "subcomiss"+u"\u00E3"+"o",
"Subcomiss"+u"\u00E3"+"o", "subdivis"+u"\u00E3"+"o", "Subdivis"+u"\u00E3"+"o", "submers"+u"\u00E3"+"o",
"Submers"+u"\u00E3"+"o", "submiss"+u"\u00E3"+"o", "Submiss"+u"\u00E3"+"o", "subpress"+u"\u00E3"+"o", "subvers"+u"\u00E3"+"o",
"Subvers"+u"\u00E3"+"o", "sucess"+u"\u00E3"+"o", "Sucess"+u"\u00E3"+"o", "sugest"+u"\u00E3"+"o",
"Sugest"+u"\u00E3"+"o", "superpress"+u"\u00E3"+"o", "supervis"+u"\u00E3"+"o",
"Supervis"+u"\u00E3"+"o", "supress"+u"\u00E3"+"o",
"Supress"+u"\u00E3"+"o", "suspens"+u"\u00E3"+"o", "Suspens"+u"\u00E3"+"o", "televis"+u"\u00E3"+"o",
"Televis"+u"\u00E3"+"o", "tens"+u"\u00E3"+"o", "Tens"+u"\u00E3"+"o", "transfus"+u"\u00E3"+"o",
"Transfus"+u"\u00E3"+"o", "transgress"+u"\u00E3"+"o", "Transgress"+u"\u00E3"+"o", "transmiss"+u"\u00E3"+"o",
"Transmiss"+u"\u00E3"+"o", "tribo", "Tribo", "tribos",
"Tribos", "uni"+u"\u00E3"+"o", "Uni"+u"\u00E3"+"o", "vaguid"+u"\u00E3"+"o",
"Vaguid"+u"\u00E3"+"o", "vastid"+u"\u00E3"+"o", "Vastid"+u"\u00E3"+"o", "vaz"+u"\u00E3"+"o",
"Vaz"+u"\u00E3"+"o", "vermelhid"+u"\u00E3"+"o", "Vermelhid"+u"\u00E3"+"o", "vers"+u"\u00E3"+"o",
"Vers"+u"\u00E3"+"o", "vis"+u"\u00E3"+"o", "Vis"+u"\u00E3"+"o"])



masAoCrase = set(["artes"+u"\u00E3"+"o", "Artes"+u"\u00E3"+"o",
"blus"+u"\u00E3"+"o", "Blus"+u"\u00E3"+"o",
"bras"+u"\u00E3"+"o", "Bras"+u"\u00E3"+"o",
"cabe"+u"\u00E7"+u"\u00E3"+"o", "Cabe"+u"\u00E7"+u"\u00E3"+"o",
"ca"+u"\u00E7"+u"\u00E3"+"o", "Ca"+u"\u00E7"+u"\u00E3"+"o",
"cal"+u"\u00E7"+u"\u00E3"+"o", "Cal"+u"\u00E7"+u"\u00E3"+"o",
"cora"+u"\u00E7"+u"\u00E3"+"o", "Cora"+u"\u00E7"+u"\u00E3"+"o",
"cortes"+u"\u00E3"+"o", "Cortes"+u"\u00E3"+"o",
"diapas"+u"\u00E3"+"o", "Diapas"+u"\u00E3"+"o",
"fais"+u"\u00E3"+"o", "Fais"+u"\u00E3"+"o",
"gar"+u"\u00E7"+u"\u00E3"+"o", "Gar"+u"\u00E7"+u"\u00E3"+"o",
"pis"+u"\u00E3"+"o", "Pis"+u"\u00E3"+"o",
"sals"+u"\u00E3"+"o", "Sals"+u"\u00E3"+"o",
"s"+u"\u00E3"+"o", "S"+u"\u00E3"+"o",
"ti"+u"\u00E7"+u"\u00E3"+"o", "Ti"+u"\u00E7"+u"\u00E3"+"o",
"travess"+u"\u00E3"+"o", "Travess"+u"\u00E3"+"o"])


malHifen = set(["acondicionada", "acondicionadas", "acondicionado",
"acondicionados", "aconselhada", "aconselhadas", "aconselhado",
"aconselhados", "acostumada", "acostumadas", "acostumado", "acostumados",
"adaptada", "adaptadas", "adaptado", "adaptados", "afamada", "afamadas",
"afamado", "afamados", "afortunada", "afortunadas", "afortunado", "afortunados",
"agourada", "agouradas", "agourado", "agourados", "agradecida", "agradecidas",
"agradecido", "agradecidos", "ajambrada", "ajambradas", "ajambrado",
"ajambrados", "ajeitada", "ajeitadas", "ajeitado", "ajeitados", "amada",
"amadas", "amado", "amados", "apessoada", "apessoadas", "apessoado",
"apessoados", "armada", "armadas", "armado", "armados", "arranjada",
"arranjadas", "arranjado", "arranjados", "assada", "assadas", "assado",
"assados", "assombrada", "assombradas", "assombrado", "assombrados",
"assombramento", "assombramentos", "assombro", "assombros", "aventurada",
"aventuradas", "aventurado", "aventurados", "avisada", "avisadas", "avisado",
"avisados", "educada", "educadas", "educado", "educados", "empregada",
"empregadas", "empregado", "empregado", "encarada", "encaradas", "encarado",
"encarados", "enganado", "ensinado", "entendido", "entendidos", "estar",
"executada", "executadas", "executado", "executados", "habituada",
"habituadas", "habituado", "habituados", "humorada", "humoradas", "humorado",
"humorados", "informada", "informadas", "informado", "informados",
"intencionada", "intencionadas", "intencionado", "intencionados", "limpo",
"limpos"])

malMau = set(["agouro", "aluno", "aspecto", "atendimento", "bocado",
"cheiro", "colesterol", "conselho", "costume", "desempenho", "elemento",
"estado", "exemplo", "gosto", "jeito", "momento", "motorista",
"negociante", "profissional", "resultado", "sinal", "tempo", "uso"])

# AosExcecao = excecao para os prefixos auto, super, inter, sub, pseudo etc 

AosExcecao = set(["a", "agora", "ante", "antes", "ao", "aos", "as", "cada",
"censura", "ciber", "citroque", "como", "comporta", "conditione", "da", "das", "de", "depois", "do", "dois",
"dos", "duas", "durante", "e", "eis", "ela", "elas", "em", "entre", "essa", "essas",
"esse", "esses", "esta", "estas", "este", "estes", "estava", "esteve",
"estive", "examine", "extra", "extras", "feita", "feitas", "feito", "feitos", "faz",
"fez", "fica", "foi", "funciona", "giga", "gosta", "gostamos", "gostaria",
"gostava", "goste", "gosto", "gostos", "hasta", "infra", 
"inter", "isso", "isto", "judice", "j"+u"\u00FA"+"dice", "junto",
"kb", "kbyte", "kbytes", "kilo", "kilobyte", "lege", "mais", "mas", "me", "mega",
"megas", "meia", "meio", "mesma", "mesmas", "mesmo", "mesmos", "minha",
"minhas", "muita", "muitas", "muito", "muitos", "na", "nas", "no", "nos",
"nossa", "nossas", "nosso", "nossos", "o", "os", "outra", "outras", "outro",
"outros", "para", "pare", "pede", "pode", "poderia", "pois", "posso",
"pouca", "poucas", "pouco", "poucos", "pra", "porque", "pros", "quaisquer",
"qual", "quando", "qualquer", "que", "quem", "quis", "quer", "saiba", "se", "seja",
"sejam", "sente", "sentem", "somente", "sua", "suas", "super", "suporta",
"supra", "tambem", "tamb"+u"\u00E9"+"m", "tem", "ter", "tera", "terreste", "terrestes",
"teus", "teve", "tinha", "tive", "toda", "todas",
"todo", "todos", "tua", "tuas", "tudo", "uma", "umas", "usa", "usam", "uso",
"vamos", "vem", "vez", "vinha", "vossa", "vossas", "vosso",
"vossos"])


meSes = set(["janeiro", "fevereiro", "mar"+u"\u00E7"+"o", "abril", "maio", "junho",
"julho", "agosto", "setembro", "outubro", "novemvro", "dezembro"])

seMana = set(["segunda", "ter"+u"\u00E7"+"a", "quarta", "quinta", "sexta",
"s"+u"\u00E1"+"bado", "segunda-feira", "ter"+u"\u00E7"+"a-feira",
"quarta-feira", "quinta-feira", "sexta-feira"])


preAnalise = set(["a", "alguma", "breve", "com", "cuja", "da", "de", "dessa",
"desta", "em", "essa", "esta", "esta", "farei", "faria", "fariam", "faz",
"fazem", "fazemos", "fazia", "faziam", "feita", "fez", "fiz", "fizemos",
"fizeram", "minha", "muita", "na", "nessa", "nesta", "nossa", "nova", "numa",
"outra", "para", "pela", "por", "posterior", "pouca", "primeira", "profunda",
"qualquer", "segunda", "segundo", "simples", "sob", "sua", "tamanha", "tanta",
"tem", "toda", "uma"])


posAnalise = set(["da", "das", "de", "dos", "farei", "faria", "fariam", "faz",
"fazem", "fazemos", "fazia", "faziam", "fez", "fiz", "fizemos", "fizeram",
"tem"])

preEsta = set(["agora", "ainda", "como", "e", "ela", "ele", "hoje",
"j"+u"\u00E1", "mas", "me", "te", "lhe", "n"+u"\u00E3"+"o", "que", "quem",
"se", "tamb"+u"\u00E9"+"m", "voc"+u"\u00EA"])

posEsta = set(["aberto", "aceito", "afeito", "afeto", "aflito", "agora",
"ali", "alto", "ao", "apronto", "apto", "atento", "aqui", "assim", "barato",
"benquisto", "bem", "bom", "bonito", "cada", "chato", "certo", "cheia",
"cheio", "circunscrito", "claro", "coberto", "com", "como", "completo",
"composto", "convicto", "correto", "curto", "decerto", "dentro", "deposto",
"descoberto", "descrito", "deserto", "desfeito", "disposta", "disposto",
"dito", "doente", "ela", "ele", "eleito", "em", "entre", "envolto", "enxuto",
"escrito", "esquisito", "exato", "exausto", "expl"+u"\u00ED"+"cito",
"exposto", "extinto", "extraposto", "faminto", "farto", "feita", "feito",
"fora", "frito", "funcionamento", "gasto", "hoje", "imperfeito",
"impl"+u"\u00ED"+"cito", "incerto", "incompleto", "indisposto", "inquieto",
"insatisfeito", "inscrito", "intato", "invicto", "isento", "isso", "isto",
"junto", "justo", "lento", "liberto", "longe", "mais", "mal", "manuscrito", "me",
"melhor", "mesmo", "meu", "morto", "muito", "na", "nas", "nisso", "nisto", "no", "nos",
"num", "numa", "o",  "obscuro", "obsoleto", "para", "perfeito", "perto",
"pior", "ponto", "portanto", "posto", "predisposto", "prescrito", "presente",
"preso", "preto", "prevista", "previsto", "pronto", "proposto", "quieto",
"recoberto", "repleto", "resoluto", "restrito", "revolto", "roto",
"satisfeito", "sendo", "seu", "solto", "sonolento", "sujeito", "tanto",
"teu", "todo", "tonto", "torto", "transposto", "tudo", "um", "visto", "vivo"])

excpreEsta = set(["el", "tod"])


excvelEsta = set(["abomin"+u"\u00E1"
"admir"+u"\u00E1", "ador"+u"\u00E1", "agrad"+u"\u00E1",
"am"+u"\u00E1", "apetec"+u"\u00ED", "desagrad"+u"\u00E1",
"desej"+u"\u00E1", "detest"+u"\u00E1", "formid"+u"\u00E1",
"horr"+u"\u00ED", "impag"+u"\u00E1", "imposs"+u"\u00ED",
"incans"+u"\u00E1", "incompar"+u"\u00E1", "incompreens"+u"\u00ED",
"inesgot"+u"\u00E1", "inexor"+u"\u00E1", "inexplic"+u"\u00E1",
"inqualific"+u"\u00E1", "intermin"+u"\u00E1", "invis"+u"\u00ED",
"irredut"+u"\u00ED", "lament"+u"\u00E1", "memor"+u"\u00E1",
"miser"+u"\u00E1", "not"+u"\u00E1", "poss"+u"\u00ED",
"prov"+u"\u00E1", "respeit"+u"\u00E1", "respons"+u"\u00E1",
"saud"+u"\u00E1", "terr"+u"\u00ED", "vari"+u"\u00E1",
"vulner"+u"\u00E1"])


proClise = set(["abafa", "abala", "abalei", "abalou", "abana",
"abandonei", "abandonou", "abateu", "abati", "abominei", "abominou",
"aborreceu", "aborreci", "aborrecia", "abracei", "abracou", "abria",
"abroquela", "absolveu", "absolvi", "absorvia", "acabrunha", "acalma",
"acanhava", "acariciei", "acariciou", "aceita", "aceitava",
"aceitei", "aceito", "aceitou", "acendeu", "acendi", "acendia", "acerta",
"acha", "achava", "achei", "acho", "achou", "aclama", "acolheu",
"acolhi", "acolhia", "acometeu", "acometia", "acompanha",
"acompanhava", "acompanhei", "acompanhou", "aconchega", "aconchegava",
"aconselha", "aconselhava", "aconselhei", "aconselhou",
"acorda", "acordava", "acordei", "acordou", "acuda", "acusa",
"adivinha", "adivinhei", "adivinhou", "admira", "admirava", "admita",
"admitia", "adora", "adorava", "adota", "advirta", "afaga",
"afagava", "afasta", "afastava", "afastei", "afastou",
"afligia", "afoga", "afugenta", "agarra", "agarrei",
"agarrou", "agasalha", "agita", "agitava", "aguardava", "aguenta", "ajeita",
"ajuda", "ajudava", "ajudei", "ajudou", "ajusta", "alcancei",
"alegrava", "alimenta", "alimentei", "alimentou", "alucina", "ama",
"amarra", "amava", "ameacei", "amei", "amo", "amou", "amparei",
"amparou", "anima", "animava", "animou", "aniquila", "anula",
"anulou", "apaga", "apagou", "apague", "apalpa", "apalpei", "apalpou",
"apanha", "apanhei", "apanhou", "aperta", "apertava", "apertei",
"apertou", "aplaudia", "apoiei", "apoiou", "apresenta",
"apresentei", "apresentou", "aproximou", "aqueceu", "arranca", "arrancou",
"arranquei", "arrasta", "arrastava", "arrastei", "arrastou",
"arrebata", "arrebatou", "arremessa", "arremessei", "arremessou", "arruma",
"arrumei", "arrumou", "assa", "assalta", "assaltou", "assombra", "assombrou",
"assou", "assusta", "assustava", "assustou", "atacou", "atendeu", "atendi",
"aterra", "atesta", "atira", "atirei", "atirou", "atormenta",
"atormentava", "autorizei", "autorizou", "avistei", "avistou",
"baixa", "bateu", "bati", "bebeu", "bebi", "beija", "beijava",
"beijei", "beijou", "bota", "botava", "botei", "botou", "buscou", "busquei",
"cansou", "caracteriza", "carrega", "carregava", "carregou", "carreguei",
"casei", "casou", "castiga", "castigava", "castigou", "castiguei", "cega",
"censurava", "cerca", "cercou", "chama", "chamava", "chamei",
"chamou", "chegou", "cheguei", "choca", "cobria", "cola",
"colheu", "colhi", "coloca", "colocou", "coloquei", "colou",
"coma", "comeu", "comi", "comia", "comoveu", "comovi", "comovia",
"completa", "comprei", "compro", "comprou", "comunica",
"concebeu", "concebi", "condenei", "condenou", "conduza",
"confirmou", "conheceu", "conheci", "conhecia", "conquista", "consagrei",
"consagrou", "conseguira", "conservei", "conservou",
"considerava", "considerei", "considero", "considerou", "consola",
"consolava", "consolei", "consolou", "constrangia", "contaminei",
"contaminou", "contava", "contempla", "contemplava",
"contemplei", "contemplou", "continha", "contorceu", "contrariava",
"convenceu", "convenci", "converteu", "converti", "convida",
"convidava", "convidei", "convidou", "copia", "correu", "corri",
"corta", "cortou", "cria", "criei", "criou", "cumprimenta",
"cumprimentei", "cumprimentou", "dava", "decorei", "decorou", "defendeu",
"defendi", "defendia", "dei", "deita", "deitei", "deitou", "deitou", "deixa",
"deixava", "deixei", "deixo", "deixou", "derrama", "derramou",
"desconhecia", "descreveu", "descrevi", "desejava", "desejei", "desejou",
"desenhou", "desequilibrou", "despejei", "despejou", "desperta", "despertei",
"despertou", "despreza", "desprezei", "desprezou", "detesta", "detestava",
"detinha", "deu", "devolveu", "devolvi", "devora", "devorava", "devorei",
"devorou", "dilacerou", "dispensou", "ditei", "doma", "domina", "dominava",
"dominei", "dominou", "dou", "edita", "editou", "educa", "educou", "eduquei",
"elegeu", "embala", "embalava", "embalou", "embrulha", "embrulhou", "empurra",
"empurrei", "empurrou", "encaminha", "encanta", "encantava",
"encarava", "encarei", "encarou", "encarrega", "encarregou",
"encarreguei", "enchei", "encheu", "enchi", "enchia", "encontra",
"encontrava", "encontrei", "encontrou", "encoraja", "encostei",
"encostou", "endireita", "enfia", "enfureceu", "enrolei", "enrolou",
"enterrei", "enterrou", "entrega", "entregava", "entregou",
"entreguei", "entretinha", "entristeceu", "entristeci", "entristecia",
"entusiasmava", "envolveu", "envolvi", "envolvia", "enxota",
"enxotou", "ergueu", "ergui", "erguia", "escolheu", "escolhi", "esconde",
"escondeu", "escondi", "escondia", "escorri", "escuta", "escutava",
"escutei", "escutou", "esfrega", "esfregou", "esmaga", "esmagava", "esmagou",
"esmurrei", "esmurrou", "espanca", "espanta", "esperava",
"esperei", "espero", "esperou", "espreita", "esqueceu", "esqueci", "estendeu",
"estendi", "estendia", "estimula", "estimulei", "estimulo", "estimulou",
"estrangula", "estuda", "estudei", "estudo", "estudou", "evita", "evitava",
"examina", "examinava", "examinei", "examinou", "excitava",
"exorta", "expulsa", "expulsou", "expunha", "fabricou", "fabriquei", "fareja",
"fascina", "fascinava", "fecha", "fechei", "fechou", "feriu",
"fita", "fitava", "fitei", "fitou", "fixei", "fixou", "folheei",
"folheou", "forcei", "fortaleceu", "fortaleci", "furei", "furou", "ganha",
"ganhei", "ganhou", "gastei", "gastou", "guarda", "guardava",
"guardei", "guardou", "humilhava", "ignora", "imaginava", "imita",
"imitei", "imitou", "imobiliza", "imortaliza", "impedia",
"impelia", "impugna", "impunha", "incomoda", "incomodava", "indenize",
"inibia", "inquietava", "instala", "instiga", "insulta", "interdizia",
"interessa", "interpela", "interpelei", "interpelou", "interpretei",
"interpretou", "interroga", "interrogava", "interrogou", "interroguei",
"interrompeu", "interrompi", "interrompia", "invadia",
"inveja", "invejava", "invejo", "invejou", "irrita", "irritava", "irritei",
"irritou", "isola", "joga", "jogou", "joguei", "julga", "julgava",
"julgou", "julguei", "junta", "junte", "jurei", "jurou", "lancei", "larga",
"largou", "larguei", "lavei", "lavou", "leu", "leva",
"levanta", "levantei", "levantou", "levava", "levei", "levo", "levou", "li",
"lia", "liberta", "liga", "limpa", "livrei", "livrou", "magoava",
"manda", "mandava", "mandei", "mandou", "maneja", "mata",
"matei", "mato", "matou", "meteu", "meti", "modifica", "modifico",
"modificou", "monta", "mordeu", "mordi", "mordia", "mostra", "mostrava",
"mostrei", "mostrou", "moveu", "movi", "movia", "movo", "nobilita", "nomeei",
"nomeia", "nomeou", "obriga", "obrigava", "obrigou", "obriguei",
"observava", "observei", "obtinha", "odiava", "odiei", "odiou",
"ofendeu", "ofendi", "olha", "olhava", "olhei", "olho", "olhou",
"oprimia", "ordena", "ouvia", "ouvira", "paga", "pagou", "paguei",
"parta", "partilha", "passa", "passava", "passei", "passou", "pega", "pegou",
"peguei", "percebeu", "percebi", "percebia", "percorreu", "percorri",
"percorria", "perdeu", "perdi", "perseguia", "perturba", "perturbava", "pica",
"pinta", "pisa", "planta", "plantei", "plantou", "ponha", "precedeu",
"precedi", "preencheu", "preenchi", "preferia", "prenda",
"prendeu", "prendi", "prendia", "preocupa", "preocupava", "pressentia",
"previa", "procura", "procurava", "procurei", "procurou",
"promoveu", "promovi", "protegeu", "protegi", "proteja", "prova", "provoca",
"publica", "publicou", "publiquei", "pungia", "punha", "puxa",
"puxava", "puxei", "puxou", "queima", "queira", "queria", "quero", "rasga",
"rasgou", "rasguei", "realiza", "receba", "recebeu", "recebi", "recebia",
"recolheu", "recolhi", "recoloca", "recomenda", "reconheceu",
"reconheci", "reconhecia", "recorda", "recordava", "reduzia", "reencontrei",
"reencontrou", "rejeita", "relega", "releu", "reli", "remeteu", "remeti",
"remoeu", "renomeei", "renomeou", "repassa", "repelia",
"repetia", "repito", "repreendeu", "repreendi", "repreendia", "representa",
"reproduzia", "resolveu", "resolvi", "respeita", "respeitei", "respeitou",
"retarda", "retenha", "retinha", "retirei", "retirou", "retrata",
"revela", "risca", "rompeu", "rompi", "roubei", "roubou",
"sacudia", "salvei", "salvou", "saudei", "saudou", "seduzia", "seguia",
"segura", "segurei", "segurou", "senta", "sentei",
"sentia", "sentou", "servia", "siga", "sinto", "solta", "soltei",
"soltou", "submeteu", "submeti", "substitua", "suga",
"sujeita", "suplanta", "suporta", "supunha", "surpreendeu", "surpreendi",
"suspendeu", "suspendi", "sustenta", "tangeu", "tangi", "tapei", "tapou",
"temia", "tenha", "tenho", "testa", "tinha", "tira", "tirava",
"tirei", "tirou", "toca", "tocava", "tolda", "tolheu", "tolhi", "toma",
"tomava", "tomba", "tomei", "tomou", "torna", "tornava", "tornei", "tornou",
"torturava", "trabalha", "traga", "trancou", "tranquei", "tranquilizei",
"tranquilizou", "transforma", "transformei", "transformou", "trata",
"tratava", "tratei", "tratou", "trazia", "trucida", "ultrapassa",
"utiliza", "veda", "veja", "vejo", "venceu", "venci", "vencia", "venda",
"vendeu", "vendi", "verteu", "vestia", "via", "vibrou", "vinga",
"vira", "virei", "virou", "visitava", "volta"]) 


aaPlural = set(["Do", "do", "Meu", "meu", "No", "no", "Nosso",
"nosso", "O", "o", "Outro", "outro", "Pelo", "pelo", "Seu", "seu", "Teu", "teu", "Todo",
"todo", "Vosso", "vosso"])

# aaSingular - Palavras no singular que possam ir para o plural com simples adicao de -s- para formacao do plural-singular com a palavra seguinte
aaSingular = set(["A", "Ao", "ao",
"Aquela", "aquela", "Aquele", "aquele", "Assunto", "assunto",
"Ato", "ato", "Baixa", "baixa", "Bela", "bela", "Belo",
"belo", "Bonita", "bonita", "Bonito", "bonito",
"Certa", "certa", "Certo", "certo", "Cuja", "cuja", "Cujo", "cujo",
"Da", "da", "Daquela", "daquela", "Daquele", "daquele",
"Derradeira", "derradeira", "Derradeiro", "derradeiro", "dessa",
"Dessa", "desta", "Desta", "deste", "Deste", "determinada",
"Determinada", "determinado", "Determinado", "Diversa",
"diversa", "Diverso", "diverso", "Do", "do",
"essa", "Essa", "esse", "Esse", "esta", "Esta", "este",
"Este", "Gasto", "gasto", "Guerreira", "guerreira", "Guerreiro", "guerreiro",
"Linda", "linda", "Lindo", "lindo", "Mesma",
"Meu", "meu", "Moderna", "moderna", "Moderno", "moderno", "Minha",
"minha", "Na", "na", "Naquela", "naquela", "Naquele", "naquele",
"nessa", "Nessa", "nesse", "Nesse", "nesta", "Nesta",
"neste", "Neste", "No", "no", "Nossa", "nossa", "Nosso", "nosso",
"O", "o", "Outra", "outra", "Outro", "outro", "Pela", "pela", "Pelo", "pelo", "Pequena",
"pequena", "Pequeno", "pequeno", "Primeira", "primeira", "Primeiro", "primeiro",
"profunda", "Profunda", "profundo", "Profundo",
"Seu", "seu", "Sua", "sua", "Tanta", "tanta", "Teu", "teu", "Tua", "tua",
"Vossa", "vossa", "Vosso",
"vosso"])

# abSingular - Palavras masculinas no singular  para formacao do plural-singular com adjetivos
abSingular = set(["Ao", "ao", "Aquele", "aquele",
"Ato", "ato", "Belo", "belo", "Bonito", "bonito",
"Certo", "certo", "Cujo", "cujo", "Daquele", "daquele", "Derradeiro", "derradeiro",
"Deste", "determinado", "Determinado", "Diverso", "diverso",
"Do", "do", "esse", "Esse", "este", "Este","Gasto", "gasto",
"Grupo", "grupo", "Guerreiro", "guerreiro", "Lindo", "lindo", "Meu",
"meu", "Moderno", "moderno", "Naquele", "naquele", "nesse",
"Nesse", "neste", "Neste", "No", "no", "Nosso", "nosso",
"O", "o", "Olho", "olho", "Organismo", "organismo", "Outro", "outro",
"Pelo", "pelo", "Pequeno", "pequeno", "Primeiro", "primeiro",
"profundo", "Profundo", "Seu",
"seu", "Teu", "teu", "Vosso", "vosso"])


# acSingular - Palavras femininas no singular  para formacao do plural-singular com a palavra seguinte
acSingular = set(["A", "Aquela", "aquela", "Baixa", "baixa", "Bela",
"bela", "Bonita", "bonita", "Carga", "carga",
"Certa", "certa", "Cuja", "cuja", "Da", "da", "Daquela", "daquela", "Derradeira", "derradeira",
"Dessa", "dessa", "Desta", "desta", "determinada", "Determinada",
"Diversa", "diversa", "essa", "Essa", "esta", "Esta", "Guerreira",
"guerreira", "Linda", "linda", "Mesma", "Minha",
"minha",  "Moderna", "moderna", "Na", "na", "Naquela", "naquela", "nessa", "Nessa",  "nesta",
"Nesta", "Nossa", "nossa", "Nova", "nova", "Outra", "outra", "Pela",
"pela", "Pequena", "pequena", "Primeira", "primeira", "profunda",
"Profunda", "Sua", "sua", "Tanta", "tanta",
"Tua", "tua", "Vossa", "vossa"])


# adSingular - Idem abSingular, mas sem o No - no
adSingular = set(["Ao",
"ao", "Aquele", "aquele", "Assunto", "assunto", "Ato", "ato",
"Belo", "belo", "Bonito", "bonito",
"Cargo", "cargo", "Certo", "certo", "Cujo", "cujo", "Daquele", "daquele", "Derradeiro", "derradeiro",
"Deste", "deste", "Determinado", "determinado",
"Diverso", "diverso", "Do", "do",
"Esse", "esse", "Este", "este", "Gasto", "gasto", "Grupo", "grupo", "Guerreiro", "guerreiro",
"Lindo", "lindo", "Meu", "meu", "Moderno", "moderno", "Naquele", "naquele",
"nesse", "Nesse", "neste", "Neste", "Nosso", "nosso", "Novo",
"novo", "O", "o", "Outro", "outro",
"Pelo", "pelo", "Pequeno", "pequeno", "Primeiro", "primeiro",
"profundo", "Profundo", "Seu", "seu", "Teu", "teu",
"Vosso", "vosso"])


# aeSingular - Palavras femininas no singular  para formacao do plural-singular  - terminadas em ado ido 
aeSingular = set(["Aquela", "aquela", "Baixa",
"baixa", "Bela", "bela", "Bonita", "bonita", "Certa", "certa",
"Cuja", "cuja", "Da", "da", "Daquela", "daquela", "Derradeira", "derradeira", "determinada",
"Determinada", "Diversa", "diversa", "Guerreira", "guerreira", "Linda",
"linda", "Minha", "minha",
"Moderna", "moderna", "Na", "na","Naquela", "naquela", "Nossa", "nossa", "Outra",
"outra", "Pela", "pela", "Pequena", "pequena", "pouca", "Pouca", "Primeira", "primeira",
"profunda", "Profunda",
"Sua", "sua",  "Tanta", "tanta", "Toda", "toda",
"Tua", "tua", "Vossa", "vossa"])

# agSingular - Palavras femininas no singular  para formacao do plural-singular com a palavra seguinte SEM o A
agSingular = set(["Aquela", "aquela", "Baixa", "baixa", "Bela", "bela", "Bonita", "bonita", "Carga", "carga",
"Certa", "certa", "Cuja", "cuja", "Da", "da", "Daquela", "daquela", "Derradeira", "derradeira",
"Dessa", "dessa", "Desta", "desta", "determinada", "Determinada",
"Diversa", "diversa", "essa", "Essa", "esta", "Esta", "Guerreira",
"guerreira", "Linda", "linda", "Longa", "longa", "Mesma", "Minha",
"minha",  "Moderna", "moderna", "Na", "na", "Naquela", "naquela", "nessa", "Nessa",  "nesta",
"Nesta", "Nossa", "nossa", "Outra", "outra", "Pela",
"pela", "Pequena", "pequena", "Primeira", "primeira",
"profunda", "Profunda", "Sua", "sua", "Tanta", "tanta",
"Tua", "tua", "Vossa", "vossa"])


# ahSingular - Palavras masculinas no singular iniciadas com maiusculas
ahSingular = set(["Aquele", "Baixo", "Belo", "Bonito",
"Certo", "Daquele", "Determinado", "Diverso",
"Esse", "Este", "Grande", "Grupo", "Guerreiro", "Lindo", "Meu",
"Moderno", "Naquele", "Nosso",
"O", "Outro", "Pequeno", "Primeiro", "Profundo", "Seu",
"Teu", "Vosso"])


# ajSingular - Palavras femininas no singular iniciadas com maiusculas
ajSingular = set(["A", "Aquela", "Baixa", "Bela", "Bonita",
"Certa", "Daquela", "Diversa", "Essa", "Esta", "Guerreira",
"Linda", "Minha",
"Moderna", "Naquela", "Nossa", "Outra", "Pela",
"Pequena", "Primeira", "Profunda", "Sua", "Tanta",
"Tua", "Vossa"])



# varGenero - Variacao de genero -  feminino - masculino - - - - - masculino - masculino
varGenero = {"a": "o", "A": "O", u"\u00C0": "Ao", u"\u00E0": "ao",
"alta": "alto", "Alta": "Alto", "alto": "alto", "Alto": "Alto",
"amiga": "amigo", "Amiga": "Amigo", "amigo": "amigo", "Amigo": "Amigo",
"antiga": "antigo", "Antiga": "Antigo", "antigo": "antigo", "Antigo": "Antigo",
"ao": "ao", "Ao": "Ao",
"aquela": "aquele", "Aquela": "Aquele",
"aquele": "aquele", "Aquele": "Aquele",
"artigo": "artigo", "Artigo": "Artigo",
"assunto": "assunto", "Assunto": "Assunto",
"ato": "ato", "Ato": "Ato",
"baixa": "baixo", "Baixa": "Baixo", "baixo": "baixo", "Baixo": "Baixo",
"bela": "belo", "Bela": "Belo", "belo": "belo", "Belo": "Belo",
"bonita": "bonito", "Bonita": "Bonito", "bonito": "bonito", "Bonito": "Bonito",
"carga": "cargo", "Carga": "Cargo", "cargo": "cargo", "Cargo": "Cargo",
"certa": "certo", "Certa": "Certo", "certo": "certo", "Certo": "Certo",
"cuja": "cujo", "Cuja": "Cujo",
"cujo": "cujo", "Cujo": "Cujo", "da": "do", "Da": "Do",
"daquela": "daquele", "Daquela": "Daquele",
"daquele": "daquele", "Daquele": "Daquele",
"Derradeira": "Derradeiro", "derradeira": "derradeiro",
"Derradeiro": "Derradeiro", "derradeiro": "derradeiro",
"dessa": "desse",
"Dessa": "Desse", "desse": "desse",  "Desse": "Desse", "desta": "deste",
"Desta": "Deste", "deste": "deste",  "Deste": "Deste",
"determinada": "determinado", "Determinada": "Determinado",
"determinado": "determinado",  "Determinado": "Determinado",
"Direito": "Direito", "direito": "direito",
"Diversa": "Diverso", "diversa": "diverso",
"Diverso": "Diverso", "diverso": "diverso",
"Do": "Do", "do": "do", "doi": "doi", "Doi": "Doi", "dua": "doi",
"Dua": "Doi", 
"Elemento": "Elemento", "elemento": "elemento",
"Erro": "Erro", "erro": "erro",
"essa": "esse", "Essa": "Esse", "esse": "esse",
"Esse": "Esse", "esta": "este", "Esta": "Este", "este": "este",
"Este": "Este",
"Gasto": "Gasto", "gasto": "gasto",
"Grupo": "Grupo", "grupo": "grupo",
"Guerreira": "Guerreiro", "guerreira": "guerreiro", 
"Guerreiro": "Guerreiro", "guerreiro": "guerreiro",
"Linda": "Lindo", "linda": "lindo",
"Lindo": "Lindo", "lindo": "lindo",
"Longa": "Longo", "longa": "longo",
"Longo": "Longo", "longo": "longo",
"mesma": "mesmo", "Mesma": "Mesmo",
"mesmo": "mesmo", "Mesmo": "Mesmo", "meu": "meu",
"Meu": "Meu", "minha": "meu", "Minha": "Meu",
"moderna": "moderno", "Moderna": "Moderno",
"moderno": "moderno", "Moderno": "Moderno", "muita": "muito",
"Muita": "Muito", "muito": "muito", "Muito": "Muito", "na": "no",
"Na": "No", 
"naquela": "naquele", "Naquela": "Naquele",
"naquele": "naquele", "Naquele": "Naquele",
"nessa": "nesse", "Nessa": "Nesse", "nesse": "nesse",
"Nesse": "Nesse", "nesta": "neste", "Nesta": "Neste", "neste": "neste",
"Neste": "Neste", "no": "no", "No": "No", "nossa": "nosso",
"Nossa": "Nosso", "nosso": "nosso", "Nosso": "Nosso",
"o": "o", "O": "O",
"Olho": "Olho", "olho": "olho",
"Organismo": "Organismo", "organismo": "organismo",
 "outra": "outro", "Outra": "Outro",
"outro": "outro", "Outro": "Outro",
"pela": "pelo", "Pela": "Pelo", "pelo": "pelo", "Pelo": "Pelo",
"pequena": "pequeno", "Pequena": "Pequeno", "pequeno": "pequeno", "Pequeno": "Pequeno",
"pouca": "pouco", "Pouca": "Pouco", "pouco": "pouco", "Pouco": "Pouco",
"primeira": "primeiro", "Primeira": "Primeiro", "primeiro": "primeiro",
"Primeiro": "Primeiro","profunda": "profundo", "Profunda": "Profundo",
"profundo": "profundo", "Profundo": "Profundo",
"seu": "seu", "Seu": "Seu", "sua": "seu", "Sua": "Seu", 
"Terceira": "Terceiro", "terceira": "terceiro",
"Terceiro": "Terceiro", "terceiro": "terceiro",
"teu": "teu", "Teu": "Teu", "tanta": "tanto", "Tanta": "Tanto", "toda": "todo", "Toda": "Todo", "todo": "todo",
"Todo": "Todo", "tua": "teu", "Tua": "Teu", "un": "um", "Un": "Um",
"um": "un", "Um": "Un", "uma": "um", "Uma": "Um", "vossa": "vosso",
"Vossa": "Vosso", "vosso": "vosso", "Vosso": "Vosso"}


# varGenera - Variacao de genero -  masculino - feminino - - - - feminino - feminino
varGenera = {"a": "a", "A": "A", u"\u00C0": u"\u00C0", u"\u00E0": u"\u00E0",
"alta": "alta", "Alta": "Alta", "alto": "alta", "Alto": "Alta",
"amiga": "amiga", "Amiga": "Amiga", "amigo": "amiga", "Amigo": "Amiga",
"antiga": "antiga", "Antiga": "Antiga", "antigo": "antiga", "Antigo": "Antiga",
"ao": u"\u00E0", "Ao": u"\u00C0",
"aquela": "aquela", "Aquela": "Aquela",
"aquele": "aquela", "Aquele": "Aquela",
"baixa": "baixa", "Baixa": "Baixa", "baixo": "baixa", "Baixo": "Baixa",
"bela": "bela", "Bela": "Bela", "belo": "bela", "Belo": "Bela",
"bonita": "bonita", "Bonita": "Bonita", "bonito": "bonita", "Bonito": "Bonita",
"carga": "carga", "Carga": "Carga", "cargo": "carga", "Cargo": "Carga",
"certa": "certa", "Certa": "Certa", "certo": "certa", "Certo": "Certa",
"cuja": "cuja", "Cuja": "Cuja",
"cujo": "cuja", "Cujo": "Cuja", "da": "da", "Da": "Da",
"daquela": "daquela", "Daquela": "Daquela",
"daquele": "daquela", "Daquele": "Daquela",
"Derradeira": "Derradeira", "derradeira": "derradeira",
"Derradeiro": "Derradeira", "derradeiro": "derradeira",
"dessa": "dessa",
"Dessa": "Dessa", "desse": "dessa",  "Desse": "Dessa", "desta": "desta",
"Desta": "Desta", "deste": "desta",  "Deste": "Desta",
"determinada": "determinada", "Determinada": "Determinada",
"determinado": "determinada",  "Determinado": "Determinada",
"Diversa": "Diversa", "diversa": "diversa",
"Diverso": "Diversa", "diverso": "diversa",
"do": "da", "Do": "Da", "doi": "dua", "Doi": "Dua", "dua": "dua",
"Dua": "Dua", "essa": "essa", "Essa": "Essa", "esse": "essa",
"Esse": "Essa", "esta": "esta", "Esta": "Esta", "este": "esta",
"Este": "Esta", 
"Guerreira": "Guerreira", "guerreira": "guerreira", 
"Guerreiro": "Guerreira", "guerreiro": "guerreira",
"Linda": "Linda", "linda": "linda",
"Lindo": "Linda", "lindo": "linda",
"Longa": "Longa", "longa": "longa",
"Longo": "Longa", "longo": "longa",
"mesma": "mesma", "Mesma": "Mesma",
"mesmo": "mesma", "Mesmo": "Mesma", "meu": "minha",
"Meu": "Minha", "minha": "minha", "Minha": "Minha",
"moderna": "moderna", "Moderna": "Moderna", "moderno": "moderna",
"Moderno": "Moderna", "muita": "muita",
"Muita": "Muita", "muito": "muita", "Muito": "Muita", "na": "na",
"Na": "Na",
"naquela": "naquela", "Naquela": "Naquela",
"naquele": "naquela", "Naquele": "Naquela",
"nessa": "nessa", "Nessa": "Nessa", "nesse": "nessa",
"Nesse": "Nessa", "nesta": "nesta", "Nesta": "Nesta", "neste": "nesta",
"Neste": "Nesta", "no": "na", "No": "Na", "nossa": "nossa",
"Nossa": "Nossa", "nosso": "nossa", "Nosso": "Nossa",
"o": "a", "O": "A", "outra": "outra", "Outra": "Outra",
"outro": "outra", "Outra": "Outra", "pela": "pela",
"Pela": "Pela", "pelo": "pela", "Pelo": "Pela", 
"pequena": "pequena", "Pequena": "Pequena", "pequeno": "pequena", "Pequeno": "Pequena",
"pouca": "pouca", "Pouca": "Pouca", "pouco": "pouca", "Pouco": "Pouca",
"primeira": "primeira", "Primeira": "Primeira", "primeiro": "primeira",
"Primeiro": "Primeira", "profunda": "profunda", "Profunda": "Profunda",
"profundo": "profunda", "Profundo": "Profunda",
"Pr"+u"\u00F3"+"pria": "Pr"+u"\u00F3"+"pria",
"pr"+u"\u00F3"+"pria": "pr"+u"\u00F3"+"pria",
"Pr"+u"\u00F3"+"prio": "Pr"+u"\u00F3"+"pria",
"pr"+u"\u00F3"+"prio": "pr"+u"\u00F3"+"pria",
"Pr"+u"\u00F3"+"xima": "Pr"+u"\u00F3"+"xima",
"pr"+u"\u00F3"+"xima": "pr"+u"\u00F3"+"xima",
"Pr"+u"\u00F3"+"ximo": "Pr"+u"\u00F3"+"xima",
"pr"+u"\u00F3"+"ximo": "pr"+u"\u00F3"+"xima",
"seu": "sua", "Seu": "Sua", "sua": "sua", "Sua": "Sua",
"tanta": "tanta", "Tanta": "Tanta",
"Terceira": "Terceira", "terceira": "terceira",
"Terceiro": "Terceira", "terceiro": "terceira",
"teu": "tua", "Teu": "Tua", "toda": "toda", "Toda": "Toda", "todo": "toda",
"Todo": "Toda", "tua": "tua", "Tua": "Tua", "un": "uma", "Un": "Uma",
"uma": "uma", "Uma": "Uma", "vossa": "vossa", "Vossa": "Vossa",
"vosso": "vossa", "Vosso": "Vossa"}


excExiste = set(["alfere", "Ante", "ante", "Ao", "ao", "apena", "Cai", "cai", "Cao", "cao", "Da", "da", "Dela",
"dela", "Dele", "dele", "Do", "do", "mai", "meno", "Na", "na", "naquela", "naquele", "No", "no", "noutra", "noutro", "simple"])

excDa = set(["carta", "curta", "d"+u"\u00E9"+"cada", "descoberta", "entrada",
"furada", "oferta", "porta", "tonelada"])

excEmFrente = set(["com", "de", "em", "minha", "nossa", "pela", "sua", "vossa"])

corPais = set(["algum", "antigo", "ao", "belo", "bom", "cada",
"cent"+u"\u00E9"+"simo", "certo", "d"+u"\u00E9"+"cimo", "daquele",
"desse", "deste", "distante", "do", "doce", "doutro", "esse", "este",
"extenso", "grande", "heptag"+u"\u00E9"+"simo", "hexag"+u"\u00E9"+"simo",
"igual", "imenso", "jovem", "maior",  "melhor", "mesmo", "meu", "naquele",
"nenhum", "nesse", "neste", "no", "nonag"+u"\u00E9"+"simo", "nono", "nosso",
"noutro", "num", "o", "octag"+u"\u00E9"+"simo", "oitavo", "outro",
"pelo", "pequeno", "p"+u"\u00E9"+"ssimo", "pior", "poderoso",
"pr"+u"\u00F3"+"ximo", "primeiro",
"quadrag"+u"\u00E9"+"simo", "quarto", "quinquag"+u"\u00E9"+"simo",
"quinto", "respectivo", "s"+u"\u00E9"+"timo", "segundo", "semelhante",
"seu", "sexto", "tanto", "terceiro", "teu", "todo", "trig"+u"\u00E9"+"simo",
"um", u"\u00FA"+"nico", "vasto", "velho", "vig"+u"\u00E9"+"simo",
"vosso"])


excRenun = set(["a", "ao", "aos", u"\u00E0", u"\u00E0"+"s", "ap"+u"\u00F3"+"s"])

excDenun = set(["a",  u"\u00E0", "alguma", "antiga", "ap"+u"\u00F3"+"s",
"apresenta",  "apresentar", "apresentou", "apura", "apurando", "apurar",
"aquela", "as", u"\u00E0"+"s", "bela", "boa", "cada", "certa", "clara",
"conforme", "confirma", "cuja", "da", "daquela", "de", "desmente",
"desmentem", "dessa", "desta", "doutra", "em", "encaminha", "encaminhar",
"encaminhou", "essa", "esta", "existe", "existia", "existindo", "falsa",
"formaliza", "formalizada", "formula", "formulada", "grande", "grave",
"h"+u"\u00E1", "houve", "houver", "igual", "investiga", "investigar",
"investigou", "julga", "julgar", "maior", "mais", "mediante", "meia",
"melhor", "mesma", "minha", "naquela", "nenhuma", "nessa", "nesta", "na",
"nossa", "noutra", "nova", "numa", "ofereceu", "outra", "pela", "pequena",
"pior", "por", "poss"+u"\u00ED"+"vel", "preciosa", "presente", "primeira",
"pr"+u"\u00F3"+"xima", "qualquer", "recebe", "recebem", "receber",
"receberam", "receberem", "recebeu", "recebia", "recebiam", "respectiva",
"segunda", "segundo", "semelhante", "sobre", "sexta", "simples", "sua",
"tanta", "tem", "terceira", "tua", "toda", "tremenda", "uma",
u"\u00FA"+"nica", "vossa"])


mauMal = set(["cabid", "casad", "cheiros", "comid",
"comportad", "conceit", "conceituad", "conduzid", "conservad",
"cozinhad", "criad", "cuidad", "dormid", "dotad", "falad",
"feit", "figurad", "furad", "grad", "jeitos", "mandad",
"parecid", "parid", "passad", "pecad", "pesad", "planejad",
"post", "procedid", "pront", "pronunciad",
"prop"+u"\u00ED"+"ci", "proporcionad", "pr"+u"\u00F3"+"pri",
"satisfeit", "servid", "sortead", "sucedid",
"trajad", "trapilh", "vestid", "vist"])

excVerbo = set(["estiv", "tiv"])

excGerundio = set(["deve", "devem", "pode", "podem", "vai", "Vamos", "vamos", "v"+u"\u00E3"+"o", "Vou", "vou"])

excGquando = set(["qua", "quando"])

excPosso = set(["quaisqu", "qualqu", "qu", "regul", "retangul", "tubul"])

# Palavras - terminados com a acento agudo - excecao para conjugacao de verbos Ex. babah
excvbah = set(["ag", "bab", "delir", "desacolher", "desencapar", "desvair",
"embeber", "encapar", "enfumar", "entrever", "equipar", "esfumar", "esgar",
"far", "feder", "filhar", "fumar", "ganz", "goi", "il", "ir", "jang", "jant",
"jat", "jurem", "lal", "lambar", "lap", "linguar", "macer", "mai", "man",
"mang", "mar", "marc", "marimb", "mascar", "mentir", "mir", "mur", "nan",
"oc", "Par", "paspalh", "pati", "pu", "reger", "remir", "revir",
"vir"])

# Palavras - terminados com a acento agudo - excecao para conjugacao de verbos Ex. bebeh
excvbeh = set(["anted", "beb", "desd", "trem"])

# Palavras - terminados com a acento agudo - excecao para conjugacao de verbos Ex. abeceh
excvbceh = set(["abe"])



# Substantivos - adjetivos confundidos com conjugacao verbal - Ex. abalo
excvbar = set(["abaf"+u"\u00E1"+"veis", "abafo", "abaix"+u"\u00E1"+"veis", "abaixo", "abal"+u"\u00E1"+"veis", "abaliz"+u"\u00E1"+"veis",
"abalo", "abano", "abarc"+u"\u00E1"+"veis", "abarrot"+u"\u00E1"+"veis", "abelhais", "abelhudo",
"aben"+u"\u00E7"+"o"+u"\u00E1"+"veis", "abesto", "abjudic"+u"\u00E1"+"veis", "abomin"+u"\u00E1"+"veis", "abon"+u"\u00E1"+"veis", "abono",
"abort"+u"\u00E1"+"veis", "aborto", "abra"+u"\u00E7"+u"\u00E1"+"veis", "abra"+u"\u00E7"+"o", "abrevi"+u"\u00E1"+"veis", "abrigo",
"abundanciais", "abuso", "acab"+u"\u00E1"+"veis", "acalent"+u"\u00E1"+"veis", "acalento", "acarinh"+u"\u00E1"+"veis",
"acat"+u"\u00E1"+"veis", "acato", "aceit"+u"\u00E1"+"veis", "aceito", "aceno", "acentuais",
"acentu"+u"\u00E1"+"veis", "acert"+u"\u00E1"+"veis", "acerto", "acesso", "achat"+u"\u00E1"+"veis", "ach"+u"\u00E1"+"veis",
"achego", "acidentais", "acident"+u"\u00E1"+"veis", "acidific"+u"\u00E1"+"veis", "acionais", "acion"+u"\u00E1"+"veis",
"aclar"+u"\u00E1"+"veis", "aclimat"+u"\u00E1"+"veis", "aclimatiz"+u"\u00E1"+"veis", "acomod"+u"\u00E1"+"veis", "acompanh"+u"\u00E1"+"veis", "aconchego",
"acondicion"+u"\u00E1"+"veis", "aconselh"+u"\u00E1"+"veis", "acopl"+u"\u00E1"+"veis", "acordais", "acord"+u"\u00E1"+"veis", "acordo",
"acost"+u"\u00E1"+"veis", "acosto", "acredit"+u"\u00E1"+"veis", "acrescent"+u"\u00E1"+"veis", "acrescento", "acumul"+u"\u00E1"+"veis",
"acuo", "acupunturais", "acus"+u"\u00E1"+"veis", "adapt"+u"\u00E1"+"veis", "adega", "adegas",
"adens"+u"\u00E1"+"veis", "adi"+u"\u00E1"+"veis", "adicionais", "adicion"+u"\u00E1"+"veis", "adit"+u"\u00E1"+"veis", "adivinh"+u"\u00E1"+"veis",
"adivinho", "adjetivais", "adjetiv"+u"\u00E1"+"veis", "adjetivo", "adjudic"+u"\u00E1"+"veis", "adjunto",
"administr"+u"\u00E1"+"veis", "admir"+u"\u00E1"+"veis", "admoest"+u"\u00E1"+"veis", "adnominais", "adnomin"+u"\u00E1"+"veis", "adorais",
"ador"+u"\u00E1"+"veis", "adot"+u"\u00E1"+"veis", "adub"+u"\u00E1"+"veis", "adubo", "adulter"+u"\u00E1"+"veis", "adverbiais",
"advers"+u"\u00E1"+"veis", "adverso", "aeromodelo", "aeroplano", "aeroporto", "afag"+u"\u00E1"+"veis",
"afago", "afast"+u"\u00E1"+"veis", "afetais", "afet"+u"\u00E1"+"veis", "afeto", "afiais",
"afian"+u"\u00E7"+u"\u00E1"+"veis", "afi"+u"\u00E1"+"veis", "afinais", "afinco", "afirm"+u"\u00E1"+"veis", "afixais",
"afix"+u"\u00E1"+"veis", "afixo", "afogo", "afronta", "afrontas", "afront"+u"\u00E1"+"veis",
"afugent"+u"\u00E1"+"veis", "afund"+u"\u00E1"+"veis", "agasalh"+u"\u00E1"+"veis", "agasalho", "agenci"+u"\u00E1"+"veis", "agenda",
"agendas", "agiliz"+u"\u00E1"+"veis", "agit"+u"\u00E1"+"veis", "aglomer"+u"\u00E1"+"veis", "aglutin"+u"\u00E1"+"veis", "agrav"+u"\u00E1"+"veis",
"agravo", "agreg"+u"\u00E1"+"veis", "agrup"+u"\u00E1"+"veis", "aguardo", "agulha", "agulhas",
"ajunt"+u"\u00E1"+"veis", "alavanca", "alavancas", "alberg"+u"\u00E1"+"veis", "alcan"+u"\u00E7"+u"\u00E1"+"veis", "alcooliz"+u"\u00E1"+"veis",
"alcunha", "alcunhas", "alegro", "aleij"+u"\u00E1"+"veis", "alento", "alfabetiz"+u"\u00E1"+"veis",
"ali"+u"\u00E1"+"veis", "alien"+u"\u00E1"+"veis", "alimentais", "alimento", "alinhavo", "alinho",
"alis"+u"\u00E1"+"veis", "alist"+u"\u00E1"+"veis", "almej"+u"\u00E1"+"veis", "almejo", "almo"+u"\u00E7"+"o", "almofada",
"almofadas", "aloc"+u"\u00E1"+"veis", "alter"+u"\u00E1"+"veis", "altern"+u"\u00E1"+"veis", "alterno", "altiva",
"altivas", "altivo", "alug"+u"\u00E1"+"veis", "aluviais", "alvej"+u"\u00E1"+"veis", "alvoro"+u"\u00E7"+"o",
"amaci"+u"\u00E1"+"veis", "amans"+u"\u00E1"+"veis", "amarela", "amarelas", "amarelo", "amarrot"+u"\u00E1"+"veis",
"amasio", "amasso", "am"+u"\u00E1"+"veis", "ambicion"+u"\u00E1"+"veis", "ambientais", "ambient"+u"\u00E1"+"veis",
"amea"+u"\u00E7"+u"\u00E1"+"veis", "amea"+u"\u00E7"+"o", "amedront"+u"\u00E1"+"veis", "amiga", "amigas", "amig"+u"\u00E1"+"veis",
"amigo", "amo", "amold"+u"\u00E1"+"veis", "amolg"+u"\u00E1"+"veis", "amonto"+u"\u00E1"+"veis", "amortiz"+u"\u00E1"+"veis",
"amostra", "amostrais", "amostras", "amostr"+u"\u00E1"+"veis", "amotin"+u"\u00E1"+"veis", "ampar"+u"\u00E1"+"veis",
"amparo", "ampli"+u"\u00E1"+"veis", "amplific"+u"\u00E1"+"veis", "amput"+u"\u00E1"+"veis", "amuo", "anaboliz"+u"\u00E1"+"veis",
"analis"+u"\u00E1"+"veis", "anarquiz"+u"\u00E1"+"veis", "andarilho", "and"+u"\u00E1"+"veis", "andejo", "anelo",
"anex"+u"\u00E1"+"veis", "anexo", "angeliz"+u"\u00E1"+"veis", "angliz"+u"\u00E1"+"veis", "anilho", "animais",
"animaliz"+u"\u00E1"+"veis", "anim"+u"\u00E1"+"veis", "anodiz"+u"\u00E1"+"veis", "anojais", "anta", "antais",
"antas", "antecip"+u"\u00E1"+"veis", "antedat"+u"\u00E1"+"veis", "anteparo", "anteposto", "anterioriz"+u"\u00E1"+"veis",
"anto", "anul"+u"\u00E1"+"veis", "anunci"+u"\u00E1"+"veis", "apag"+u"\u00E1"+"veis", "apaixon"+u"\u00E1"+"veis", "apalavr"+u"\u00E1"+"veis",
"apalp"+u"\u00E1"+"veis", "apalpo", "apanho", "aparelh"+u"\u00E1"+"veis", "aparelho", "aparo",
"aparvalh"+u"\u00E1"+"veis", "apassiv"+u"\u00E1"+"veis", "apassivo", "apedrejo", "apeg"+u"\u00E1"+"veis", "apego",
"apel"+u"\u00E1"+"veis", "apelido", "apelo", "apen"+u"\u00E1"+"veis", "apenso", "aperfei"+u"\u00E7"+"o"+u"\u00E1"+"veis",
"aperto", "apit"+u"\u00E1"+"veis", "apito", "aplac"+u"\u00E1"+"veis", "aplic"+u"\u00E1"+"veis", "apoder"+u"\u00E1"+"veis",
"apont"+u"\u00E1"+"veis", "aportugues"+u"\u00E1"+"veis", "aposent"+u"\u00E1"+"veis", "aposento", "aposta", "apostas",
"apostila", "apostilas", "aposto", "apraz"+u"\u00E1"+"veis", "apreci"+u"\u00E1"+"veis", "apresent"+u"\u00E1"+"veis",
"aprimor"+u"\u00E1"+"veis", "aprofund"+u"\u00E1"+"veis", "apront"+u"\u00E1"+"veis", "apronto", "apropri"+u"\u00E1"+"veis", "aproveit"+u"\u00E1"+"veis",
"aproxim"+u"\u00E1"+"veis", "aprumo", "aramo", "ar"+u"\u00E1"+"veis", "arbitrais", "arbitr"+u"\u00E1"+"veis",
"arboriz"+u"\u00E1"+"veis", "arca", "arcas", "arco", "arena", "arenais",
"arenas", "arenga", "arengas", "areno", "argola", "argolas",
"argumentais", "argumento", "arisco", "arma", "armas", "armazen"+u"\u00E1"+"veis",
"aro", "arquiteta", "arquitetas", "arquitet"+u"\u00E1"+"veis", "arquiteto", "arquivais",
"arquivo", "arranc"+u"\u00E1"+"veis", "arranco", "arranj"+u"\u00E1"+"veis", "arranjo", "arras"+u"\u00E1"+"veis",
"arrasto", "arrebito", "arrecad"+u"\u00E1"+"veis", "arrega"+u"\u00E7"+"o", "arreganho", "arregiment"+u"\u00E1"+"veis",
"arregr"+u"\u00E1"+"veis", "arremat"+u"\u00E1"+"veis", "arrepi"+u"\u00E1"+"veis", "arrepio", "arrocho", "arrolo",
"arroto", "arrufo", "articul"+u"\u00E1"+"veis", "asfalto", "asfixia", "asfixias",
"asneira", "asneiras", "asneiro", "aspir"+u"\u00E1"+"veis", "assalari"+u"\u00E1"+"veis", "assalt"+u"\u00E1"+"veis",
"assalto", "assanh"+u"\u00E1"+"veis", "assedi"+u"\u00E1"+"veis", "assegur"+u"\u00E1"+"veis", "assento", "asserto",
"assexualiz"+u"\u00E1"+"veis", "assimil"+u"\u00E1"+"veis", "assinal"+u"\u00E1"+"veis", "assin"+u"\u00E1"+"veis", "assoalho", "assobio",
"associais", "associ"+u"\u00E1"+"veis", "assombro", "assopro", "assunto", "atac"+u"\u00E1"+"veis",
"atalho", "atenta", "atentas", "atento", "atenu"+u"\u00E1"+"veis", "aterro",
"aterroriz"+u"\u00E1"+"veis", "atest"+u"\u00E1"+"veis", "atin"+u"\u00E1"+"veis", "atino", "atir"+u"\u00E1"+"veis", "ativ"+u"\u00E1"+"veis",
"ativo", "atocho", "atomiz"+u"\u00E1"+"veis", "atonais", "atordo"+u"\u00E1"+"veis", "atorment"+u"\u00E1"+"veis",
"atrai"+u"\u00E7"+"o"+u"\u00E1"+"veis", "atraso", "atrito", "atrofia", "atrofias", "atropel"+u"\u00E1"+"veis",
"atropelo", "atuais", "atualiz"+u"\u00E1"+"veis", "atu"+u"\u00E1"+"veis", "atur"+u"\u00E1"+"veis", "audit"+u"\u00E1"+"veis",
"augurais", "aument"+u"\u00E1"+"veis", "aumento", "autentic"+u"\u00E1"+"veis", "autentific"+u"\u00E1"+"veis", "automotivo",
"autoprogram"+u"\u00E1"+"veis", "autopropag"+u"\u00E1"+"veis", "autopsiais", "autoriz"+u"\u00E1"+"veis", "autorrevog"+u"\u00E1"+"veis", "avali"+u"\u00E1"+"veis",
"avaliz"+u"\u00E1"+"veis", "avan"+u"\u00E7"+"o", "avaria", "avarias", "avari"+u"\u00E1"+"veis", "aventura",
"aventuras", "averb"+u"\u00E1"+"veis", "avio", "avis"+u"\u00E1"+"veis", "aviso", "avist"+u"\u00E1"+"veis",
"azedo", "baba", "babais", "babas", "baga", "bagas",
"bago", "bail"+u"\u00E1"+"veis", "bainha", "bainhas", "baixa", "baixas",
"baixo", "balan"+u"\u00E7"+"a", "balan"+u"\u00E7"+"as", "balan"+u"\u00E7"+"o", "baliza", "balizas",
"baliz"+u"\u00E1"+"veis", "banca", "bancais", "bancas", "banco", "banha",
"banhas", "banh"+u"\u00E1"+"veis", "banho", "bardais", "bardo", "barganha",
"barganhas", "barra", "barrais", "barras", "barreira", "barreirais",
"barreiras", "barreiro", "barrica", "barricas", "barro", "basto",
"batalha", "batalhas", "batalh"+u"\u00E1"+"veis", "beijo", "beira", "beirais",
"beiras", "beneficiais", "benefici"+u"\u00E1"+"veis", "berro", "bestific"+u"\u00E1"+"veis", "bexiga",
"bexigais", "bexigas", "bifurc"+u"\u00E1"+"veis", "bimbais", "bingo", "biodegrad"+u"\u00E1"+"veis",
"bioensaio", "bisnaga", "bisnagas", "bitola", "bitolas", "bocejo",
"bochacro", "bochecha", "bochechas", "bochecho", "bochincho", "boda",
"bodas", "bofeto", "boga", "bogas", "bojo", "bola",
"bolacha", "bolachas", "bolas", "bolcheviz"+u"\u00E1"+"veis", "bolco", "boleta",
"boletas", "boleto", "bolha", "bolhas", "bolo", "bolsa",
"bolsas", "bolso", "bomba", "bombais", "bombarda", "bombardas",
"bombas", "bombo", "bondais", "boneca", "bonecas", "boneco",
"bonho", "bonific"+u"\u00E1"+"veis", "boquejo", "borboleta", "borboletas", "borborinho",
"borboto", "borbulha", "borbulhas", "borcelo", "borco", "borda",
"bordas", "bordo", "borra", "borra"+u"\u00E7"+"ais", "borras", "borrega",
"borregas", "borrego", "borrifo", "bosquejo", "bossa", "bossas",
"bosta", "bostais", "bostas", "bota", "botais", "botas",
"boteco", "boto", "brabo", "bradais", "brad"+u"\u00E1"+"veis", "brado",
"brama", "bramas", "branda", "brandais", "brandas", "brando",
"branquej"+u"\u00E1"+"veis", "brasa", "brasas", "brasilianiz"+u"\u00E1"+"veis", "brasilific"+u"\u00E1"+"veis", "brasiliz"+u"\u00E1"+"veis",
"brava", "bravais", "bravas", "bravo", "breca", "brecas",
"brecha", "brechas", "brejeira", "brejeirais", "brejeiras", "brejeiro",
"brevet"+u"\u00E1"+"veis", "brida", "bridas", "briga", "brigais", "brigas",
"brilho", "brinco", "brisa", "brisas", "brita", "britas",
"broca", "brocais", "brocas", "brocha", "brochas", "broco",
"brolho", "bromais", "bromo", "broncograf"+u"\u00E1"+"veis", "broto", "broxa",
"broxas", "bruma", "brumais", "brumas", "brumo", "brutaliz"+u"\u00E1"+"veis",
"brutific"+u"\u00E1"+"veis", "bruxa", "bruxas", "bruxo", "bufarinho", "bufo",
"bugia", "bugias", "bugio", "bula", "bulas", "bulha",
"bulhas", "bumbo", "bunda", "bundas", "bunho", "buraca",
"buracas", "buraco", "burburinho", "burga", "burgas", "burgo",
"burguesa", "burguesas", "burla", "burlas", "burl"+u"\u00E1"+"veis", "burocratiz"+u"\u00E1"+"veis",
"burra", "burras", "burricais", "burrico", "burro", "busc"+u"\u00E1"+"veis",
"buto", "buzina", "buzinas", "cabedais", "cabotino", "cabrito",
"cacarejo", "cachimbo", "cacho", "cachoeira", "cachoeiras", "cachoeiro",
"cachucho", "cacicais", "cacifo", "cacimba", "cacimbas", "cacofonia",
"cacofonias", "cadastrais", "cadastr"+u"\u00E1"+"veis", "cadastro", "cadela", "cadelas",
"cadelo", "cadenciais", "cadinho", "caduc"+u"\u00E1"+"veis", "caduco", "caibrais",
"caibro", "caixeirais", "caixeiro", "calaceiro", "calafrio", "cal"+u"\u00E7"+"a",
"cal"+u"\u00E7"+"as", "calcin"+u"\u00E1"+"veis", "calco", "cal"+u"\u00E7"+"o", "calcul"+u"\u00E1"+"veis", "calefrio",
"calej"+u"\u00E1"+"veis", "calemburgo", "calha", "calhas", "calibr"+u"\u00E1"+"veis", "caligraf"+u"\u00E1"+"veis",
"calma", "calmas", "calm"+u"\u00E1"+"veis", "calmo", "calo", "calorific"+u"\u00E1"+"veis",
"caluni"+u"\u00E1"+"veis", "calva", "calvas", "calvo", "camaradais", "cambaio",
"cambais", "cambalacho", "cambalhota", "cambalhotas", "cambiais", "cambi"+u"\u00E1"+"veis",
"cambito", "caminho", "campainha", "campainhas", "campais", "campanulais",
"campeiro", "campina", "campinas", "campino", "campo", "camufl"+u"\u00E1"+"veis",
"canaliz"+u"\u00E1"+"veis", "cancela", "cancelas", "cancel"+u"\u00E1"+"veis", "cancelo", "cancer"+u"\u00E1"+"veis",
"canceriz"+u"\u00E1"+"veis", "candiais", "candidata", "candidatas", "candidato", "candonga",
"candongas", "canela", "canelas", "caneta", "canetas", "canga",
"cangas", "canoniz"+u"\u00E1"+"veis", "cans"+u"\u00E1"+"veis", "cantais", "cantaridais", "cantarol"+u"\u00E1"+"veis",
"cant"+u"\u00E1"+"veis", "canto", "canudo", "canutilho", "capa", "capacit"+u"\u00E1"+"veis",
"capas", "capinais", "capitais", "capitaliz"+u"\u00E1"+"veis", "capitul"+u"\u00E1"+"veis", "capoeira",
"capoeirais", "capoeiras", "capoeiro", "capota", "capotas", "capot"+u"\u00E1"+"veis",
"capricho", "capt"+u"\u00E1"+"veis", "captura", "capturas", "captur"+u"\u00E1"+"veis", "capucho",
"caracteriz"+u"\u00E1"+"veis", "carambola", "carambolas", "carameliz"+u"\u00E1"+"veis", "caramelo", "carango",
"caranguejais", "caranguejo", "caranguejola", "caranguejolas", "carapetais", "carateriz"+u"\u00E1"+"veis",
"carbonato", "carbon"+u"\u00E1"+"veis", "carboneto", "carbonilo", "carboniz"+u"\u00E1"+"veis", "carbono",
"carboxilo", "cardais", "cardanho", "cardo", "carenais", "carepo",
"carga", "cargas", "cargo", "caricatura", "caricaturais", "caricaturas",
"caricatur"+u"\u00E1"+"veis", "carici"+u"\u00E1"+"veis", "carijo", "carimb"+u"\u00E1"+"veis", "carimbo", "carmin"+u"\u00E1"+"veis",
"carnais", "carneiro", "carpa", "carpais", "carpas", "carpento",
"carpinteirais", "carpinteiro", "carpo", "carrais", "carrapatais", "carrapato",
"carregais", "carrego", "carreta", "carretas", "carreto", "carrinho",
"carro", "carruaj"+u"\u00E1"+"veis", "carta", "cartais", "cartas", "carujo",
"caruncho", "casais", "casamento", "cas"+u"\u00E1"+"veis", "casca", "cascais",
"cascalho", "cascas", "cascata", "cascatas", "cascavelo", "casco",
"cascunho", "casmurrais", "casmurro", "caso", "caspacho", "casquilho",
"castanhola", "castanholas", "casti"+u"\u00E7"+"ais", "casti"+u"\u00E7"+"o", "castific"+u"\u00E1"+"veis", "castig"+u"\u00E1"+"veis",
"castigo", "catalis"+u"\u00E1"+"veis", "catalogais", "catalog"+u"\u00E1"+"veis", "catano", "catapulta",
"catapultas", "catecumeniz"+u"\u00E1"+"veis", "categoriz"+u"\u00E1"+"veis", "catequiz"+u"\u00E1"+"veis", "catinga", "catingais",
"catingas", "catita", "catitas", "cativo", "catracego", "catraio",
"catuc"+u"\u00E1"+"veis", "caucionais", "caucion"+u"\u00E1"+"veis", "caudilho", "causais", "causo",
"cautela", "cautelas", "cavaco", "cavalg"+u"\u00E1"+"veis", "caverna", "cavernais",
"cavernas", "cefaliz"+u"\u00E1"+"veis", "cega", "cegas", "cego", "ceifa",
"ceifas", "celebr"+u"\u00E1"+"veis", "celebriz"+u"\u00E1"+"veis", "celeuma", "celeumas", "censura",
"censuras", "censur"+u"\u00E1"+"veis", "centelha", "centelhas", "centrais", "centraliz"+u"\u00E1"+"veis",
"centr"+u"\u00E1"+"veis", "centrific"+u"\u00E1"+"veis", "centrifug"+u"\u00E1"+"veis", "centro", "cepilh"+u"\u00E1"+"veis", "cercais",
"cerco", "cerebelo", "cerimoniais", "cerrais", "cerro", "certa",
"certas", "certific"+u"\u00E1"+"veis", "certo", "cerveja", "cervejas", "cess"+u"\u00E1"+"veis",
"chabouco", "chacina", "chacinas", "chafalho", "chaga", "chagas",
"chala"+u"\u00E7"+"a", "chala"+u"\u00E7"+"as", "chaleira", "chaleiras", "chaleiro", "chalo",
"chambrego", "chamego", "chamusc"+u"\u00E1"+"veis", "chanasco", "chancela", "chancelas",
"chanco", "chanfro", "changueiro", "chantoais", "chapa", "chapas",
"chapinha", "chapinhas", "chapisco", "chapodo", "chapu"+u"\u00E7"+"o", "chaqui"+u"\u00E7"+"o",
"charango", "charaviscais", "charrua", "charruas", "charuto", "chasco",
"chavascais", "checo", "chefia", "chefias", "cheiro", "chibata",
"chibatas", "chican"+u"\u00E1"+"veis", "chichelo", "chichorrobio", "chilido", "china",
"chinas", "chincalho", "chinela", "chinelas", "chinelo", "chino",
"chiqueiro", "chisco", "chocalho", "chocho", "choco", "choito",
"chono", "choro", "chorro", "choto", "choupais", "choupo",
"chousais", "chouso", "chuch"+u"\u00E1"+"veis", "chu"+u"\u00E7"+"o", "chuma"+u"\u00E7"+"o", "chumbo",
"churdo", "churrio", "chusma", "chusmas", "chuvenisco", "chuvilho",
"chuvinha", "chuvinhas", "chuvisco", "cianeto", "cicatriz"+u"\u00E1"+"veis", "cicliz"+u"\u00E1"+"veis",
"cientific"+u"\u00E1"+"veis", "cifo", "cifra", "cifras", "cifr"+u"\u00E1"+"veis", "cigana",
"ciganas", "cigano", "cigarra", "cigarras", "cigarro", "cilha",
"cilhas", "cilindro", "cimento", "cinta", "cintas", "cinto",
"cintura", "cinturas", "cio", "cipoais", "circinais", "circuito",
"circunaveg"+u"\u00E1"+"veis", "circuncentrais", "circuncentro", "circunstanciais", "circunstanci"+u"\u00E1"+"veis", "circunvizinha",
"circunvizinhas", "circunvizinho", "cisco", "cisma", "cismas", "cit"+u"\u00E1"+"veis",
"civiliz"+u"\u00E1"+"veis", "clam"+u"\u00E1"+"veis", "clarific"+u"\u00E1"+"veis", "classific"+u"\u00E1"+"veis", "claustrais", "claustro",
"clausura", "clausurais", "clausuras", "clava", "clavas", "claveliz"+u"\u00E1"+"veis",
"clic"+u"\u00E1"+"veis", "climatiz"+u"\u00E1"+"veis", "clinqueriz"+u"\u00E1"+"veis", "cliv"+u"\u00E1"+"veis", "clonais", "clorais",
"cloro", "cloroderiv"+u"\u00E1"+"veis", "clorofila", "clorofilas", "clorofilo", "coabit"+u"\u00E1"+"veis",
"coact"+u"\u00E1"+"veis", "coacto", "coadun"+u"\u00E1"+"veis", "coaglutin"+u"\u00E1"+"veis", "coagment"+u"\u00E1"+"veis", "coagul"+u"\u00E1"+"veis",
"coalh"+u"\u00E1"+"veis", "coalho", "coaliz"+u"\u00E1"+"veis", "coanh"+u"\u00E1"+"veis", "coanho", "coapt"+u"\u00E1"+"veis",
"coarct"+u"\u00E1"+"veis", "coarrend"+u"\u00E1"+"veis", "coart"+u"\u00E1"+"veis", "coassoci"+u"\u00E1"+"veis", "co"+u"\u00E1"+"veis", "cobalto",
"cobi"+u"\u00E7"+"a", "cobi"+u"\u00E7"+"as", "cobi"+u"\u00E7"+u"\u00E1"+"veis", "cobr"+u"\u00E1"+"veis", "cocainiz"+u"\u00E1"+"veis", "cocais",
"coch"+u"\u00E1"+"veis", "cochich"+u"\u00E1"+"veis", "cochicho", "cochilo", "cocho", "coco",
"cocontrat"+u"\u00E1"+"veis", "cocontrato", "coculo", "codejo", "codemand"+u"\u00E1"+"veis", "codific"+u"\u00E1"+"veis",
"codilh"+u"\u00E1"+"veis", "codinho", "codiz"+u"\u00E1"+"veis", "coeduc"+u"\u00E1"+"veis", "cofi"+u"\u00E1"+"veis", "cofinho",
"cogit"+u"\u00E1"+"veis", "cognominais", "cognomin"+u"\u00E1"+"veis", "cogumelo", "coif"+u"\u00E1"+"veis", "coim"+u"\u00E1"+"veis",
"coincho", "coindic"+u"\u00E1"+"veis", "coiniciais", "coino", "coinquin"+u"\u00E1"+"veis", "cointegr"+u"\u00E1"+"veis",
"coiquinho", "coira"+u"\u00E7"+u"\u00E1"+"veis", "coisa", "coisas", "cois"+u"\u00E1"+"veis", "coisific"+u"\u00E1"+"veis",
"coiso", "coito", "coivarais", "colabor"+u"\u00E1"+"veis", "colacion"+u"\u00E1"+"veis", "colapso",
"colchet"+u"\u00E1"+"veis", "colecion"+u"\u00E1"+"veis", "colect"+u"\u00E1"+"veis", "colecto", "coleta", "coletas",
"colet"+u"\u00E1"+"veis", "coletiviz"+u"\u00E1"+"veis", "colg"+u"\u00E1"+"veis", "colig"+u"\u00E1"+"veis", "colim"+u"\u00E1"+"veis", "colimit"+u"\u00E1"+"veis",
"colma"+u"\u00E7"+"o", "colmo", "colo", "coloc"+u"\u00E1"+"veis", "coloniz"+u"\u00E1"+"veis", "colopliz"+u"\u00E1"+"veis",
"coloquiais", "coloqui"+u"\u00E1"+"veis", "color"+u"\u00E1"+"veis", "coloriz"+u"\u00E1"+"veis", "coltariz"+u"\u00E1"+"veis", "coluna",
"colunais", "colunas", "colun"+u"\u00E1"+"veis", "comanda", "comandas", "comando",
"comarca", "comarcas", "comarco", "combin"+u"\u00E1"+"veis", "combor"+u"\u00E7"+u"\u00E1"+"veis", "combor"+u"\u00E7"+"o",
"combusto", "come"+u"\u00E7"+u"\u00E1"+"veis", "come"+u"\u00E7"+"o", "comedi"+u"\u00E1"+"veis", "comemor"+u"\u00E1"+"veis", "comenda",
"comendas", "comend"+u"\u00E1"+"veis", "comensur"+u"\u00E1"+"veis", "coment"+u"\u00E1"+"veis", "comento", "comerciais",
"comercializ"+u"\u00E1"+"veis", "comerci"+u"\u00E1"+"veis", "comin"+u"\u00E1"+"veis", "coministro", "comisc"+u"\u00E1"+"veis", "comiser"+u"\u00E1"+"veis",
"comission"+u"\u00E1"+"veis", "comistur"+u"\u00E1"+"veis", "comocionais", "comoro", "compact"+u"\u00E1"+"veis", "compacto",
"compactu"+u"\u00E1"+"veis", "compagin"+u"\u00E1"+"veis", "compar"+u"\u00E1"+"veis", "comparticip"+u"\u00E1"+"veis", "compartilh"+u"\u00E1"+"veis", "compartimentais",
"compartimentaliz"+u"\u00E1"+"veis", "compartiment"+u"\u00E1"+"veis", "compartimento", "compass"+u"\u00E1"+"veis", "compasso", "compatibiliz"+u"\u00E1"+"veis",
"compe"+u"\u00E7"+"o", "compeg"+u"\u00E1"+"veis", "compendi"+u"\u00E1"+"veis", "compenetr"+u"\u00E1"+"veis", "compens"+u"\u00E1"+"veis", "compermut"+u"\u00E1"+"veis",
"compil"+u"\u00E1"+"veis", "complan"+u"\u00E1"+"veis", "complement"+u"\u00E1"+"veis", "complemento", "completa", "completas",
"completo", "complexa", "complexas", "complex"+u"\u00E1"+"veis", "complexifico", "complexo",
"complic"+u"\u00E1"+"veis", "comporta", "comportas", "comport"+u"\u00E1"+"veis", "compra", "compras",
"compr"+u"\u00E1"+"veis", "compromissais", "compromisso", "comprov"+u"\u00E1"+"veis", "compugn"+u"\u00E1"+"veis", "compuls"+u"\u00E1"+"veis",
"computadoriz"+u"\u00E1"+"veis", "computatoriz"+u"\u00E1"+"veis", "comput"+u"\u00E1"+"veis", "comud"+u"\u00E1"+"veis", "comung"+u"\u00E1"+"veis", "comunic"+u"\u00E1"+"veis",
"comuniz"+u"\u00E1"+"veis", "comut"+u"\u00E1"+"veis", "conapo", "conaturaliz"+u"\u00E1"+"veis", "concaten"+u"\u00E1"+"veis", "concav"+u"\u00E1"+"veis",
"conceito", "conceituais", "conceitualiz"+u"\u00E1"+"veis", "conceitu"+u"\u00E1"+"veis", "concelebr"+u"\u00E1"+"veis", "concentraliz"+u"\u00E1"+"veis",
"concentr"+u"\u00E1"+"veis", "conceptualiz"+u"\u00E1"+"veis", "concert"+u"\u00E1"+"veis", "concerto", "concha", "conchas",
"conchav"+u"\u00E1"+"veis", "conchavo", "concheg"+u"\u00E1"+"veis", "concili"+u"\u00E1"+"veis", "concionais", "concit"+u"\u00E1"+"veis",
"conclam"+u"\u00E1"+"veis", "concord"+u"\u00E1"+"veis", "concrecionais", "concrecion"+u"\u00E1"+"veis", "concret"+u"\u00E1"+"veis", "concretiz"+u"\u00E1"+"veis",
"concreto", "concri"+u"\u00E1"+"veis", "concubina", "concubinais", "concubinas", "concubin"+u"\u00E1"+"veis",
"concubino", "conculc"+u"\u00E1"+"veis", "conculturais", "concultur"+u"\u00E1"+"veis", "concursais", "concurs"+u"\u00E1"+"veis",
"concurso", "concurv"+u"\u00E1"+"veis", "condecor"+u"\u00E1"+"veis", "conden"+u"\u00E1"+"veis", "condens"+u"\u00E1"+"veis", "condessa",
"condessas", "condicionais", "condicion"+u"\u00E1"+"veis", "condigno", "condiment"+u"\u00E1"+"veis", "condimento",
"conduplic"+u"\u00E1"+"veis", "conduta", "condutas", "conduto", "conect"+u"\u00E1"+"veis", "conexion"+u"\u00E1"+"veis",
"confabul"+u"\u00E1"+"veis", "confeccion"+u"\u00E1"+"veis", "confederais", "confeder"+u"\u00E1"+"veis", "confeit"+u"\u00E1"+"veis", "confeito",
"conferenciais", "conferenci"+u"\u00E1"+"veis", "confess"+u"\u00E1"+"veis", "confesso", "confi"+u"\u00E1"+"veis", "confidenciais",
"confidenci"+u"\u00E1"+"veis", "configur"+u"\u00E1"+"veis", "confinais", "confin"+u"\u00E1"+"veis", "confirm"+u"\u00E1"+"veis", "confisc"+u"\u00E1"+"veis",
"confisco", "conflagr"+u"\u00E1"+"veis", "conflit"+u"\u00E1"+"veis", "conflito", "conflituais", "conformais",
"conformaliz"+u"\u00E1"+"veis", "conform"+u"\u00E1"+"veis", "confort"+u"\u00E1"+"veis", "conforto", "confraternais", "confratern"+u"\u00E1"+"veis",
"confraterniz"+u"\u00E1"+"veis", "confric"+u"\u00E1"+"veis", "confront"+u"\u00E1"+"veis", "confronto", "confusionais", "confut"+u"\u00E1"+"veis",
"congalardo"+u"\u00E1"+"veis", "congel"+u"\u00E1"+"veis", "congemin"+u"\u00E1"+"veis", "congener"+u"\u00E1"+"veis", "congestion"+u"\u00E1"+"veis", "conglobais",
"conglob"+u"\u00E1"+"veis", "conglomer"+u"\u00E1"+"veis", "conglutin"+u"\u00E1"+"veis", "congonhais", "congra"+u"\u00E7"+u"\u00E1"+"veis", "congraci"+u"\u00E1"+"veis",
"congratul"+u"\u00E1"+"veis", "congreg"+u"\u00E1"+"veis", "conjectura", "conjecturais", "conjecturas", "conjectur"+u"\u00E1"+"veis",
"conjetura", "conjeturais", "conjeturas", "conjetur"+u"\u00E1"+"veis", "conjugais", "conjug"+u"\u00E1"+"veis",
"conjunt"+u"\u00E1"+"veis", "conjurament"+u"\u00E1"+"veis", "conjuramento", "conjur"+u"\u00E1"+"veis", "conlui"+u"\u00E1"+"veis",
"conluio", "conot"+u"\u00E1"+"veis", "conquist"+u"\u00E1"+"veis", "consagr"+u"\u00E1"+"veis", "consciencializ"+u"\u00E1"+"veis", "conscienciz"+u"\u00E1"+"veis",
"conscientiz"+u"\u00E1"+"veis", "conselh"+u"\u00E1"+"veis", "conselheirais", "conselheiro", "conselho", "consert"+u"\u00E1"+"veis",
"conserto", "conserv"+u"\u00E1"+"veis", "conservo", "consider"+u"\u00E1"+"veis", "consign"+u"\u00E1"+"veis", "consignific"+u"\u00E1"+"veis",
"consoant"+u"\u00E1"+"veis", "conso"+u"\u00E1"+"veis", "consoci"+u"\u00E1"+"veis", "consogro", "consol"+u"\u00E1"+"veis", "consolid"+u"\u00E1"+"veis",
"consolo", "conspurc"+u"\u00E1"+"veis", "constat"+u"\u00E1"+"veis", "consubstanciais", "consulta", "consultas",
"consult"+u"\u00E1"+"veis", "consum"+u"\u00E1"+"veis", "consumo", "contabiliz"+u"\u00E1"+"veis", "contagi"+u"\u00E1"+"veis", "contamin"+u"\u00E1"+"veis",
"contat"+u"\u00E1"+"veis", "contato", "cont"+u"\u00E1"+"veis", "contempl"+u"\u00E1"+"veis", "contemporiz"+u"\u00E1"+"veis", "content"+u"\u00E1"+"veis",
"contento", "contentoriz"+u"\u00E1"+"veis", "contest"+u"\u00E1"+"veis", "contextuais", "contextualiz"+u"\u00E1"+"veis", "contextu"+u"\u00E1"+"veis",
"contingenciais", "conto", "contorn"+u"\u00E1"+"veis", "contorno", "contrabando", "contradit"+u"\u00E1"+"veis",
"contradito", "contramarco", "contrapeso", "contraponto", "contraprotesto", "contraprova",
"contraprovas", "contrari"+u"\u00E1"+"veis", "contrarraciocin"+u"\u00E1"+"veis", "contrarreform"+u"\u00E1"+"veis", "contrarregr"+u"\u00E1"+"veis", "contrarreplic"+u"\u00E1"+"veis",
"contrarrept"+u"\u00E1"+"veis", "contrarrevolta", "contrarrevoltas", "contrarrevolt"+u"\u00E1"+"veis", "contrassegur"+u"\u00E1"+"veis", "contrasseguro",
"contrassel"+u"\u00E1"+"veis", "contrasselo", "contrast"+u"\u00E1"+"veis", "contrat"+u"\u00E1"+"veis", "contrato", "contravento",
"control"+u"\u00E1"+"veis", "controlo", "contubernais", "conumer"+u"\u00E1"+"veis", "conurb"+u"\u00E1"+"veis", "convalid"+u"\u00E1"+"veis",
"convencionais", "convencionaliz"+u"\u00E1"+"veis", "convencion"+u"\u00E1"+"veis", "conveniais", "conversa", "conversalh"+u"\u00E1"+"veis",
"conversas", "convers"+u"\u00E1"+"veis", "converso", "convibr"+u"\u00E1"+"veis", "convid"+u"\u00E1"+"veis", "convizinh"+u"\u00E1"+"veis",
"convizinho", "convoc"+u"\u00E1"+"veis", "convol"+u"\u00E1"+"veis", "convuls"+u"\u00E1"+"veis", "convulsion"+u"\u00E1"+"veis", "convulso",
"coob"+u"\u00E1"+"veis", "coobrig"+u"\u00E1"+"veis", "coocup"+u"\u00E1"+"veis", "coofici"+u"\u00E1"+"veis", "coonest"+u"\u00E1"+"veis", "cooper"+u"\u00E1"+"veis",
"coopt"+u"\u00E1"+"veis", "coorden"+u"\u00E1"+"veis", "coossific"+u"\u00E1"+"veis", "copa", "copais", "coparticip"+u"\u00E1"+"veis",
"copas", "copeira", "copeiras", "copeir"+u"\u00E1"+"veis", "copeiro", "copej"+u"\u00E1"+"veis",
"copel"+u"\u00E1"+"veis", "copi"+u"\u00E1"+"veis", "copidesc"+u"\u00E1"+"veis", "copil"+u"\u00E1"+"veis", "copilot"+u"\u00E1"+"veis", "copiloto",
"copiograf"+u"\u00E1"+"veis", "coplana", "coplanas", "coplano", "copo", "copul"+u"\u00E1"+"veis",
"coqueific"+u"\u00E1"+"veis", "corais", "cor"+u"\u00E1"+"veis", "corcov"+u"\u00E1"+"veis", "corcovo", "corisco",
"cornais", "cornific"+u"\u00E1"+"veis", "corno", "cornud"+u"\u00E1"+"veis", "coro", "coroa",
"coroas", "coro"+u"\u00E1"+"veis", "corporaliz"+u"\u00E1"+"veis", "corporific"+u"\u00E1"+"veis", "corporiz"+u"\u00E1"+"veis", "corpusculiz"+u"\u00E1"+"veis",
"correlacionais", "correlacion"+u"\u00E1"+"veis", "correlat"+u"\u00E1"+"veis", "correlato", "corresponsabiliz"+u"\u00E1"+"veis", "correta",
"corretas", "corret"+u"\u00E1"+"veis", "correto", "corric"+u"\u00E1"+"veis", "corricho", "corripo",
"corrobor"+u"\u00E1"+"veis", "corrug"+u"\u00E1"+"veis", "corrupi"+u"\u00E1"+"veis", "cort"+u"\u00E1"+"veis", "cortej"+u"\u00E1"+"veis", "cortejo",
"cortina", "cortinas", "cortin"+u"\u00E1"+"veis", "coruja", "corujas", "corusc"+u"\u00E1"+"veis",
"coscorej"+u"\u00E1"+"veis", "coscoro", "cosipa", "cosipas", "cosmopoliz"+u"\u00E1"+"veis", "cossegur"+u"\u00E1"+"veis",
"cosseguro", "costela", "costelas", "costel"+u"\u00E1"+"veis", "costum"+u"\u00E1"+"veis", "costura",
"costuras", "costur"+u"\u00E1"+"veis", "cota", "cotanilho", "cotas", "cot"+u"\u00E1"+"veis",
"cotej"+u"\u00E1"+"veis", "cotia", "cotias", "cotiz"+u"\u00E1"+"veis", "coto", "coton"+u"\u00E1"+"veis",
"cotovel"+u"\u00E1"+"veis", "cotovelo", "cotulo", "cotutel"+u"\u00E1"+"veis", "coura"+u"\u00E7"+"a", "coura"+u"\u00E7"+"as",
"coura"+u"\u00E7"+u"\u00E1"+"veis", "courela", "courelas", "cousa", "cousas", "cous"+u"\u00E1"+"veis",
"cousific"+u"\u00E1"+"veis", "couto", "couvais", "covacho", "cozinh"+u"\u00E1"+"veis", "craniais",
"crani"+u"\u00E1"+"veis", "craticul"+u"\u00E1"+"veis", "cravais", "crav"+u"\u00E1"+"veis", "cravej"+u"\u00E1"+"veis", "cravo",
"credenciais", "credenci"+u"\u00E1"+"veis", "credit"+u"\u00E1"+"veis", "crem"+u"\u00E1"+"veis", "cremo", "cremoriz"+u"\u00E1"+"veis",
"creosotais", "creosot"+u"\u00E1"+"veis", "crepit"+u"\u00E1"+"veis", "cresp"+u"\u00E1"+"veis", "crespo", "crest"+u"\u00E1"+"veis",
"cretiniz"+u"\u00E1"+"veis", "cri"+u"\u00E1"+"veis", "criminais", "criminaliz"+u"\u00E1"+"veis", "crimin"+u"\u00E1"+"veis", "criocauteriz"+u"\u00E1"+"veis",
"crioconcentr"+u"\u00E1"+"veis", "criodessec"+u"\u00E1"+"veis", "criptanalis"+u"\u00E1"+"veis", "criptoanalis"+u"\u00E1"+"veis", "criptograf"+u"\u00E1"+"veis", "crisalid"+u"\u00E1"+"veis",
"crismais", "crism"+u"\u00E1"+"veis", "criso", "crisol"+u"\u00E1"+"veis", "crisp"+u"\u00E1"+"veis", "cristaliz"+u"\u00E1"+"veis",
"cristianiz"+u"\u00E1"+"veis", "critic"+u"\u00E1"+"veis", "critiquiz"+u"\u00E1"+"veis", "criv"+u"\u00E1"+"veis", "crivo", "cromatiz"+u"\u00E1"+"veis",
"cromatolis"+u"\u00E1"+"veis", "crom"+u"\u00E1"+"veis", "cromo", "cromofotograv"+u"\u00E1"+"veis", "cromofotolito", "cronic"+u"\u00E1"+"veis",
"croniquiz"+u"\u00E1"+"veis", "croniz"+u"\u00E1"+"veis", "cronogoniometr"+u"\u00E1"+"veis", "cronometr"+u"\u00E1"+"veis", "cronoprojet"+u"\u00E1"+"veis", "cronotaquimetr"+u"\u00E1"+"veis",
"cronotelemetr"+u"\u00E1"+"veis", "crotoniz"+u"\u00E1"+"veis", "cruciais", "cruci"+u"\u00E1"+"veis", "crucific"+u"\u00E1"+"veis", "crucifix"+u"\u00E1"+"veis",
"crucifixo", "cruent"+u"\u00E1"+"veis", "cruento", "crustific"+u"\u00E1"+"veis", "cruz"+u"\u00E1"+"veis", "cruzo",
"cuanho", "cuba", "cubais", "cubaniz"+u"\u00E1"+"veis", "cubas", "cub"+u"\u00E1"+"veis",
"cubic"+u"\u00E1"+"veis", "cubific"+u"\u00E1"+"veis", "cubo", "cucais", "cuco", "cucurbitais",
"cuid"+u"\u00E1"+"veis", "culatra", "culatrais", "culatras", "culmin"+u"\u00E1"+"veis", "culpabiliz"+u"\u00E1"+"veis",
"culp"+u"\u00E1"+"veis", "cultiv"+u"\u00E1"+"veis", "cultivo", "cultuais", "cultu"+u"\u00E1"+"veis", "culturaliz"+u"\u00E1"+"veis",
"cumplici"+u"\u00E1"+"veis", "cumpriment"+u"\u00E1"+"veis", "cumprimento", "cumul"+u"\u00E1"+"veis", "cunhais", "cunh"+u"\u00E1"+"veis",
"curariz"+u"\u00E1"+"veis", "curatel"+u"\u00E1"+"veis", "cur"+u"\u00E1"+"veis", "curet"+u"\u00E1"+"veis", "curiais", "curioso",
"currais", "curro", "curs"+u"\u00E1"+"veis", "curso", "curva", "curvais",
"curvas", "curv"+u"\u00E1"+"veis", "curvejo", "curvo", "custo", "custodiais",
"customiz"+u"\u00E1"+"veis", "cutil"+u"\u00E1"+"veis", "cutiniz"+u"\u00E1"+"veis", "cutis"+u"\u00E1"+"veis", "cutuc"+u"\u00E1"+"veis", "dana",
"danas", "dan"+u"\u00E7"+"arina", "dan"+u"\u00E7"+"arinas", "dan"+u"\u00E7"+"arino", "dan"+u"\u00E7"+u"\u00E1"+"veis", "daninho",
"dano", "dardo", "data", "datais", "datas", "dat"+u"\u00E1"+"veis",
"debilit"+u"\u00E1"+"veis", "debuxo", "decant"+u"\u00E1"+"veis", "decap"+u"\u00E1"+"veis", "decentraliz"+u"\u00E1"+"veis", "decepcion"+u"\u00E1"+"veis",
"decerto", "decifr"+u"\u00E1"+"veis", "decilitro", "decimais", "decim"+u"\u00E1"+"veis", "declar"+u"\u00E1"+"veis",
"declin"+u"\u00E1"+"veis", "decodific"+u"\u00E1"+"veis", "decor"+u"\u00E1"+"veis", "decoro", "decremento", "decretais",
"decreto", "decup"+u"\u00E1"+"veis", "decuplic"+u"\u00E1"+"veis", "dedais", "dedic"+u"\u00E1"+"veis", "dedilh"+u"\u00E1"+"veis",
"dedo", "defens"+u"\u00E1"+"veis", "deflacion"+u"\u00E1"+"veis", "deform"+u"\u00E1"+"veis", "defraud"+u"\u00E1"+"veis", "defunta",
"defuntas", "defunto", "degrad"+u"\u00E1"+"veis", "degredo", "degust"+u"\u00E1"+"veis", "dejeto",
"delat"+u"\u00E1"+"veis", "deleg"+u"\u00E1"+"veis", "deleit"+u"\u00E1"+"veis", "demanda", "demandas", "demand"+u"\u00E1"+"veis",
"demarc"+u"\u00E1"+"veis", "demasia", "demasias", "demonstr"+u"\u00E1"+"veis", "demora", "demoras",
"deneg"+u"\u00E1"+"veis", "denod"+u"\u00E1"+"veis", "denodo", "denominais", "densa", "densas",
"denso", "dentais", "dentelo", "denunci"+u"\u00E1"+"veis", "depar"+u"\u00E1"+"veis", "departamentaliz"+u"\u00E1"+"veis",
"deplor"+u"\u00E1"+"veis", "depopul"+u"\u00E1"+"veis", "deport"+u"\u00E1"+"veis", "depreci"+u"\u00E1"+"veis", "depresso", "deriv"+u"\u00E1"+"veis",
"derog"+u"\u00E1"+"veis", "derram"+u"\u00E1"+"veis", "derranc"+u"\u00E1"+"veis", "derrap"+u"\u00E1"+"veis", "derratiz"+u"\u00E1"+"veis", "derreng"+u"\u00E1"+"veis",
"derrib"+u"\u00E1"+"veis", "derri"+u"\u00E7"+u"\u00E1"+"veis", "derrisc"+u"\u00E1"+"veis", "derroc"+u"\u00E1"+"veis", "derrog"+u"\u00E1"+"veis", "derrota",
"derrotas", "derrot"+u"\u00E1"+"veis", "derrub"+u"\u00E1"+"veis", "desabaf"+u"\u00E1"+"veis", "desabafo", "desabal"+u"\u00E1"+"veis",
"desabaliz"+u"\u00E1"+"veis", "desabalro"+u"\u00E1"+"veis", "desab"+u"\u00E1"+"veis", "desabilit"+u"\u00E1"+"veis", "desabit"+u"\u00E1"+"veis", "desabitu"+u"\u00E1"+"veis",
"desabo"+u"\u00E7"+u"\u00E1"+"veis", "desabon"+u"\u00E1"+"veis", "desabord"+u"\u00E1"+"veis", "desabrig"+u"\u00E1"+"veis", "desabroch"+u"\u00E1"+"veis", "desabrolh"+u"\u00E1"+"veis",
"desabus"+u"\u00E1"+"veis", "desacam"+u"\u00E1"+"veis", "desa"+u"\u00E7"+"am"+u"\u00E1"+"veis", "desacamp"+u"\u00E1"+"veis", "desacanh"+u"\u00E1"+"veis", "desacasal"+u"\u00E1"+"veis",
"desacat"+u"\u00E1"+"veis", "desacato", "desacaval"+u"\u00E1"+"veis", "desaceit"+u"\u00E1"+"veis", "desaceler"+u"\u00E1"+"veis", "desacentu"+u"\u00E1"+"veis",
"desacer"+u"\u00E1"+"veis", "desacerb"+u"\u00E1"+"veis", "desacert"+u"\u00E1"+"veis", "desacerto", "desacheg"+u"\u00E1"+"veis", "desacidific"+u"\u00E1"+"veis",
"desacidul"+u"\u00E1"+"veis", "desaclimat"+u"\u00E1"+"veis", "desaclim"+u"\u00E1"+"veis", "desacobard"+u"\u00E1"+"veis", "desacoch"+u"\u00E1"+"veis", "desacoim"+u"\u00E1"+"veis",
"desacoit"+u"\u00E1"+"veis", "desacolchet"+u"\u00E1"+"veis", "desacolcho"+u"\u00E1"+"veis", "desacomod"+u"\u00E1"+"veis", "desacompanh"+u"\u00E1"+"veis", "desacompass"+u"\u00E1"+"veis",
"desaconcheg"+u"\u00E1"+"veis", "desaconselh"+u"\u00E1"+"veis", "desacopl"+u"\u00E1"+"veis", "desacor"+u"\u00E7"+"o"+u"\u00E1"+"veis", "desacord"+u"\u00E1"+"veis", "desacordo",
"desacoro"+u"\u00E7"+"o"+u"\u00E1"+"veis", "desacorrent"+u"\u00E1"+"veis", "desacost"+u"\u00E1"+"veis", "desacostum"+u"\u00E1"+"veis", "desacout"+u"\u00E1"+"veis", "desacovard"+u"\u00E1"+"veis",
"desacredit"+u"\u00E1"+"veis", "desacu"+u"\u00E1"+"veis", "desacumul"+u"\u00E1"+"veis", "desadapt"+u"\u00E1"+"veis", "desadens"+u"\u00E1"+"veis", "desadjetiv"+u"\u00E1"+"veis",
"desadministr"+u"\u00E1"+"veis", "desadmoest"+u"\u00E1"+"veis", "desador"+u"\u00E1"+"veis", "desadorn"+u"\u00E1"+"veis", "desadul"+u"\u00E1"+"veis", "desadvog"+u"\u00E1"+"veis",
"desafag"+u"\u00E1"+"veis", "desafaim"+u"\u00E1"+"veis", "desafam"+u"\u00E1"+"veis", "desafei"+u"\u00E7"+"o"+u"\u00E1"+"veis", "desafeit"+u"\u00E1"+"veis", "desafeito",
"desaferr"+u"\u00E1"+"veis", "desaferro"+u"\u00E1"+"veis", "desaferrolh"+u"\u00E1"+"veis", "desafervor"+u"\u00E1"+"veis", "desafet"+u"\u00E1"+"veis", "desafeto",
"desafi"+u"\u00E1"+"veis", "desafin"+u"\u00E1"+"veis", "desafio", "desafivel"+u"\u00E1"+"veis", "desafix"+u"\u00E1"+"veis", "desafog"+u"\u00E1"+"veis",
"desafogo", "desafolh"+u"\u00E1"+"veis", "desafor"+u"\u00E1"+"veis", "desaforo", "desaforro", "desafortun"+u"\u00E1"+"veis",
"desafrances"+u"\u00E1"+"veis", "desafregues"+u"\u00E1"+"veis", "desafront"+u"\u00E1"+"veis", "desafund"+u"\u00E1"+"veis", "desagalon"+u"\u00E1"+"veis", "desagarr"+u"\u00E1"+"veis",
"desagasalh"+u"\u00E1"+"veis", "desagast"+u"\u00E1"+"veis", "desaglomer"+u"\u00E1"+"veis", "desagoni"+u"\u00E1"+"veis", "desagour"+u"\u00E1"+"veis", "desagouro",
"desagrad"+u"\u00E1"+"veis", "desagrado", "desagrav"+u"\u00E1"+"veis", "desagravo", "desagreg"+u"\u00E1"+"veis", "desagrilho"+u"\u00E1"+"veis",
"desagu"+u"\u00E7"+u"\u00E1"+"veis", "desaguis"+u"\u00E1"+"veis", "desair"+u"\u00E1"+"veis", "desajeit"+u"\u00E1"+"veis", "desajud"+u"\u00E1"+"veis", "desajust"+u"\u00E1"+"veis",
"desalag"+u"\u00E1"+"veis", "desalap"+u"\u00E1"+"veis", "desalarg"+u"\u00E1"+"veis", "desalarm"+u"\u00E1"+"veis", "desalcan"+u"\u00E7"+u"\u00E1"+"veis", "desalegr"+u"\u00E1"+"veis",
"desaleit"+u"\u00E1"+"veis", "desalent"+u"\u00E1"+"veis", "desalento", "desalergiz"+u"\u00E1"+"veis", "desalfandeg"+u"\u00E1"+"veis", "desalgem"+u"\u00E1"+"veis",
"desali"+u"\u00E1"+"veis", "desalicer"+u"\u00E7"+u"\u00E1"+"veis", "desalinhav"+u"\u00E1"+"veis", "desalinh"+u"\u00E1"+"veis", "desalinho", "desalist"+u"\u00E1"+"veis",
"desalm"+u"\u00E1"+"veis", "desalmejo", "desalogen"+u"\u00E1"+"veis", "desalter"+u"\u00E1"+"veis", "desalug"+u"\u00E1"+"veis", "desamalgam"+u"\u00E1"+"veis",
"desamament"+u"\u00E1"+"veis", "desamarr"+u"\u00E1"+"veis", "desamarrot"+u"\u00E1"+"veis", "desamass"+u"\u00E1"+"veis", "desam"+u"\u00E1"+"veis", "desambicion"+u"\u00E1"+"veis",
"desambient"+u"\u00E1"+"veis", "desamealh"+u"\u00E1"+"veis", "desamig"+u"\u00E1"+"veis", "desamim"+u"\u00E1"+"veis", "desamin"+u"\u00E1"+"veis", "desamist"+u"\u00E1"+"veis",
"desamo", "desamoed"+u"\u00E1"+"veis", "desamoest"+u"\u00E1"+"veis", "desamolg"+u"\u00E1"+"veis", "desamonto"+u"\u00E1"+"veis", "desamortalh"+u"\u00E1"+"veis",
"desamortiz"+u"\u00E1"+"veis", "desamotin"+u"\u00E1"+"veis", "desamouc"+u"\u00E1"+"veis", "desampar"+u"\u00E1"+"veis", "desamparo", "desamu"+u"\u00E1"+"veis",
"desanalfabetiz"+u"\u00E1"+"veis", "desanc"+u"\u00E1"+"veis", "desancor"+u"\u00E1"+"veis", "desand"+u"\u00E1"+"veis", "desanel"+u"\u00E1"+"veis", "desanex"+u"\u00E1"+"veis",
"desangusti"+u"\u00E1"+"veis", "desanimaliz"+u"\u00E1"+"veis", "desanim"+u"\u00E1"+"veis", "desanimiz"+u"\u00E1"+"veis", "desaninh"+u"\u00E1"+"veis", "desaninho",
"desanisti"+u"\u00E1"+"veis", "desanoj"+u"\u00E1"+"veis", "desanuvi"+u"\u00E1"+"veis", "desapacient"+u"\u00E1"+"veis", "desapadrinh"+u"\u00E1"+"veis", "desapaixon"+u"\u00E1"+"veis",
"desaparafus"+u"\u00E1"+"veis", "desaparelh"+u"\u00E1"+"veis", "desaparent"+u"\u00E1"+"veis", "desapart"+u"\u00E1"+"veis", "desapavor"+u"\u00E1"+"veis", "desape"+u"\u00E7"+"onh"+u"\u00E1"+"veis",
"desapeg"+u"\u00E1"+"veis", "desapego", "desapert"+u"\u00E1"+"veis", "desapied"+u"\u00E1"+"veis", "desaplic"+u"\u00E1"+"veis", "desapoder"+u"\u00E1"+"veis",
"desapont"+u"\u00E1"+"veis", "desapoquent"+u"\u00E1"+"veis", "desaportugues"+u"\u00E1"+"veis", "desaposs"+u"\u00E1"+"veis", "desapre"+u"\u00E7"+u"\u00E1"+"veis", "desapreci"+u"\u00E1"+"veis",
"desapre"+u"\u00E7"+"o", "desapress"+u"\u00E1"+"veis", "desaprimor"+u"\u00E1"+"veis", "desapropri"+u"\u00E1"+"veis", "desaprov"+u"\u00E1"+"veis", "desaproveit"+u"\u00E1"+"veis",
"desaprovision"+u"\u00E1"+"veis", "desaprum"+u"\u00E1"+"veis", "desapuro", "desarboriz"+u"\u00E1"+"veis", "desarej"+u"\u00E1"+"veis", "desarest"+u"\u00E1"+"veis",
"desargentiz"+u"\u00E1"+"veis", "desarm"+u"\u00E1"+"veis", "desarmo", "desarmoniz"+u"\u00E1"+"veis", "desaromatiz"+u"\u00E1"+"veis", "desarom"+u"\u00E1"+"veis",
"desarraig"+u"\u00E1"+"veis", "desarranj"+u"\u00E1"+"veis", "desarranjo", "desarrazo"+u"\u00E1"+"veis", "desarredond"+u"\u00E1"+"veis", "desarroch"+u"\u00E1"+"veis",
"desarrolh"+u"\u00E1"+"veis", "desarrum"+u"\u00E1"+"veis", "desarterializ"+u"\u00E1"+"veis", "desarticul"+u"\u00E1"+"veis", "desasn"+u"\u00E1"+"veis", "desasselvaj"+u"\u00E1"+"veis",
"desassemelh"+u"\u00E1"+"veis", "desassimil"+u"\u00E1"+"veis", "desassis"+u"\u00E1"+"veis", "desassoci"+u"\u00E1"+"veis", "desassombr"+u"\u00E1"+"veis", "desassombro",
"desassosseg"+u"\u00E1"+"veis", "desassossego", "desassunto", "desatabaf"+u"\u00E1"+"veis", "desatac"+u"\u00E1"+"veis", "desatapet"+u"\u00E1"+"veis",
"desatarrax"+u"\u00E1"+"veis", "desat"+u"\u00E1"+"veis", "desatavi"+u"\u00E1"+"veis", "desatemor"+u"\u00E1"+"veis", "desatemoriz"+u"\u00E1"+"veis", "desatent"+u"\u00E1"+"veis",
"desatento", "desaterr"+u"\u00E1"+"veis", "desatest"+u"\u00E1"+"veis", "desatilh"+u"\u00E1"+"veis", "desatin"+u"\u00E1"+"veis", "desatino",
"desativ"+u"\u00E1"+"veis", "desativo", "desatocho", "desatol"+u"\u00E1"+"veis", "desatordo"+u"\u00E1"+"veis", "desatrac"+u"\u00E1"+"veis",
"desatravanc"+u"\u00E1"+"veis", "desatrel"+u"\u00E1"+"veis", "desatribul"+u"\u00E1"+"veis", "desautor"+u"\u00E1"+"veis", "desautoriz"+u"\u00E1"+"veis", "desavacalh"+u"\u00E1"+"veis",
"desavantaj"+u"\u00E1"+"veis", "desaventur"+u"\u00E1"+"veis", "desaverb"+u"\u00E1"+"veis", "desavergonh"+u"\u00E1"+"veis", "desavinho", "desazo",
"desbabeliz"+u"\u00E1"+"veis", "desbago"+u"\u00E1"+"veis", "desbalan"+u"\u00E7"+"o", "desbaliz"+u"\u00E1"+"veis", "desbanc"+u"\u00E1"+"veis", "desbando",
"desbarat"+u"\u00E1"+"veis", "desbarato", "desbastard"+u"\u00E1"+"veis", "desbast"+u"\u00E1"+"veis", "desbatiz"+u"\u00E1"+"veis", "desbei"+u"\u00E7"+u"\u00E1"+"veis",
"desbenzoil"+u"\u00E1"+"veis", "desbenzol"+u"\u00E1"+"veis", "desboc"+u"\u00E1"+"veis", "desbolin"+u"\u00E1"+"veis", "desbord"+u"\u00E1"+"veis", "desborr"+u"\u00E1"+"veis",
"desbot"+u"\u00E1"+"veis", "desbrag"+u"\u00E1"+"veis", "desbrasileir"+u"\u00E1"+"veis", "desbrav"+u"\u00E1"+"veis", "desbravej"+u"\u00E1"+"veis", "desbrec"+u"\u00E1"+"veis",
"desbri"+u"\u00E1"+"veis", "desbrid"+u"\u00E1"+"veis", "desbritaniz"+u"\u00E1"+"veis", "desbrot"+u"\u00E1"+"veis", "desbrutaliz"+u"\u00E1"+"veis", "desbund"+u"\u00E1"+"veis",
"desburric"+u"\u00E1"+"veis", "desburrific"+u"\u00E1"+"veis", "descaba"+u"\u00E7"+u"\u00E1"+"veis", "descabel"+u"\u00E1"+"veis", "descadeir"+u"\u00E1"+"veis", "descafein"+u"\u00E1"+"veis",
"descafeiniz"+u"\u00E1"+"veis", "descafelo", "descalabro", "descalavro", "descal"+u"\u00E7"+u"\u00E1"+"veis", "descalcific"+u"\u00E1"+"veis",
"descal"+u"\u00E7"+"o", "descali"+u"\u00E7"+u"\u00E1"+"veis", "descalv"+u"\u00E1"+"veis", "descam"+u"\u00E1"+"veis", "descamb"+u"\u00E1"+"veis", "descaminh"+u"\u00E1"+"veis",
"descaminho", "descamis"+u"\u00E1"+"veis", "descamp"+u"\u00E1"+"veis", "descanel"+u"\u00E1"+"veis", "descans"+u"\u00E1"+"veis", "descanso",
"descant"+u"\u00E1"+"veis", "descapacit"+u"\u00E1"+"veis", "descapitaliz"+u"\u00E1"+"veis", "descapot"+u"\u00E1"+"veis", "descapsul"+u"\u00E1"+"veis", "descaracteriz"+u"\u00E1"+"veis",
"descarateriz"+u"\u00E1"+"veis", "descar"+u"\u00E1"+"veis", "descarbonat"+u"\u00E1"+"veis", "descarbon"+u"\u00E1"+"veis", "descarbonet"+u"\u00E1"+"veis", "descarboniz"+u"\u00E1"+"veis",
"descarboxil"+u"\u00E1"+"veis", "descarbur"+u"\u00E1"+"veis", "descarburiz"+u"\u00E1"+"veis", "descarga", "descargas", "descargo",
"descarnais", "descarnaliz"+u"\u00E1"+"veis", "descarn"+u"\u00E1"+"veis", "descarniz"+u"\u00E1"+"veis", "descaro"+u"\u00E7"+u"\u00E1"+"veis", "descarol"+u"\u00E1"+"veis",
"descarr"+u"\u00E1"+"veis", "descarreg"+u"\u00E1"+"veis", "descarreir"+u"\u00E1"+"veis", "descarret"+u"\u00E1"+"veis", "descarreto", "descarri"+u"\u00E1"+"veis",
"descarril"+u"\u00E1"+"veis", "descart"+u"\u00E1"+"veis", "descarteliz"+u"\u00E1"+"veis", "descas"+u"\u00E1"+"veis", "descasc"+u"\u00E1"+"veis", "descaso",
"descasul"+u"\u00E1"+"veis", "descativ"+u"\u00E1"+"veis", "descatoliz"+u"\u00E1"+"veis", "descavalg"+u"\u00E1"+"veis", "descav"+u"\u00E1"+"veis", "descaveir"+u"\u00E1"+"veis",
"desceg"+u"\u00E1"+"veis", "descement"+u"\u00E1"+"veis", "descentraliz"+u"\u00E1"+"veis", "descentr"+u"\u00E1"+"veis", "descep"+u"\u00E1"+"veis", "descerebel"+u"\u00E1"+"veis",
"descerebr"+u"\u00E1"+"veis", "descerebriz"+u"\u00E1"+"veis", "descerr"+u"\u00E1"+"veis", "descicliz"+u"\u00E1"+"veis", "descimbr"+u"\u00E1"+"veis", "desciment"+u"\u00E1"+"veis",
"descimento", "descint"+u"\u00E1"+"veis", "descintr"+u"\u00E1"+"veis", "desciviliz"+u"\u00E1"+"veis", "descoagul"+u"\u00E1"+"veis", "descoc"+u"\u00E1"+"veis",
"descoch"+u"\u00E1"+"veis", "descoco", "descodific"+u"\u00E1"+"veis", "descofr"+u"\u00E1"+"veis", "descol"+u"\u00E1"+"veis", "descolm"+u"\u00E1"+"veis",
"descoloc"+u"\u00E1"+"veis", "descoloniz"+u"\u00E1"+"veis", "descolor"+u"\u00E1"+"veis", "descoloriz"+u"\u00E1"+"veis", "descompartimentais", "descompartiment"+u"\u00E1"+"veis",
"descompass"+u"\u00E1"+"veis", "descompasso", "descompatibiliz"+u"\u00E1"+"veis", "descompens"+u"\u00E1"+"veis", "descomplic"+u"\u00E1"+"veis", "descompromisso",
"desconceitu"+u"\u00E1"+"veis", "desconcentr"+u"\u00E1"+"veis", "desconcerto", "desconchavo", "desconfeito", "desconfi"+u"\u00E1"+"veis",
"desconfigur"+u"\u00E1"+"veis", "desconfort"+u"\u00E1"+"veis", "desconforto", "descongel"+u"\u00E1"+"veis", "desconsagr"+u"\u00E1"+"veis", "desconsol"+u"\u00E1"+"veis",
"desconsolo", "descontamin"+u"\u00E1"+"veis", "descont"+u"\u00E1"+"veis", "descontent"+u"\u00E1"+"veis", "descontextualiz"+u"\u00E1"+"veis", "desconto",
"descontrat"+u"\u00E1"+"veis", "descontrol"+u"\u00E1"+"veis", "desconvers"+u"\u00E1"+"veis", "descortin"+u"\u00E1"+"veis", "descrav"+u"\u00E1"+"veis", "descredit"+u"\u00E1"+"veis",
"descremo", "descriminaliz"+u"\u00E1"+"veis", "descrimin"+u"\u00E1"+"veis", "descristianiz"+u"\u00E1"+"veis", "descrom"+u"\u00E1"+"veis", "descruz"+u"\u00E1"+"veis",
"descuid"+u"\u00E1"+"veis", "descuido", "desculpa", "desculpas", "desculp"+u"\u00E1"+"veis", "descultiv"+u"\u00E1"+"veis",
"descultu"+u"\u00E1"+"veis", "descunh"+u"\u00E1"+"veis", "descur"+u"\u00E1"+"veis", "descurv"+u"\u00E1"+"veis", "desdemoniz"+u"\u00E1"+"veis", "desdenh"+u"\u00E1"+"veis",
"desdenomin"+u"\u00E1"+"veis", "desdent"+u"\u00E1"+"veis", "desdiferenci"+u"\u00E1"+"veis", "desdobr"+u"\u00E1"+"veis", "desdobro", "desdoir"+u"\u00E1"+"veis",
"desdoutrin"+u"\u00E1"+"veis", "desdramatiz"+u"\u00E1"+"veis", "deseclips"+u"\u00E1"+"veis", "deseconomiz"+u"\u00E1"+"veis", "desedific"+u"\u00E1"+"veis", "deseduc"+u"\u00E1"+"veis",
"desefemin"+u"\u00E1"+"veis", "deseix"+u"\u00E1"+"veis", "desej"+u"\u00E1"+"veis", "desejo", "deseletriz"+u"\u00E1"+"veis", "deselitiz"+u"\u00E1"+"veis",
"desemal"+u"\u00E1"+"veis", "desemba"+u"\u00E7"+u"\u00E1"+"veis", "desembaci"+u"\u00E1"+"veis", "desembainh"+u"\u00E1"+"veis", "desembal"+u"\u00E1"+"veis", "desembalsam"+u"\u00E1"+"veis",
"desembalsamo", "desembals"+u"\u00E1"+"veis", "desembandeir"+u"\u00E1"+"veis", "desembara"+u"\u00E7"+u"\u00E1"+"veis", "desembara"+u"\u00E7"+"o", "desembaralh"+u"\u00E1"+"veis",
"desembarc"+u"\u00E1"+"veis", "desembaul"+u"\u00E1"+"veis", "desembebed"+u"\u00E1"+"veis", "desembest"+u"\u00E1"+"veis", "desemboc"+u"\u00E1"+"veis", "desembol"+u"\u00E1"+"veis",
"desembols"+u"\u00E1"+"veis", "desembolso", "desemborc"+u"\u00E1"+"veis", "desembot"+u"\u00E1"+"veis", "desembrech"+u"\u00E1"+"veis", "desembrenh"+u"\u00E1"+"veis",
"desembrulh"+u"\u00E1"+"veis", "desembrux"+u"\u00E1"+"veis", "desembu"+u"\u00E7"+u"\u00E1"+"veis", "desembuch"+u"\u00E1"+"veis", "desemburr"+u"\u00E1"+"veis", "desemburric"+u"\u00E1"+"veis",
"desemoglobiniz"+u"\u00E1"+"veis", "desemoldur"+u"\u00E1"+"veis", "desempac"+u"\u00E1"+"veis", "desempach"+u"\u00E1"+"veis", "desempacot"+u"\u00E1"+"veis", "desempal"+u"\u00E1"+"veis",
"desempalh"+u"\u00E1"+"veis", "desempap"+u"\u00E1"+"veis", "desemparceir"+u"\u00E1"+"veis", "desempared"+u"\u00E1"+"veis", "desemparelh"+u"\u00E1"+"veis", "desempast"+u"\u00E1"+"veis",
"desempastel"+u"\u00E1"+"veis", "desempat"+u"\u00E1"+"veis", "desempedr"+u"\u00E1"+"veis", "desempen"+u"\u00E1"+"veis", "desempenh"+u"\u00E1"+"veis", "desempenho",
"desempeno", "desemperr"+u"\u00E1"+"veis", "desempest"+u"\u00E1"+"veis", "desemplasto", "desemplastr"+u"\u00E1"+"veis", "desemplum"+u"\u00E1"+"veis",
"desempo"+u"\u00E1"+"veis", "desempo"+u"\u00E7"+u"\u00E1"+"veis", "desempoeir"+u"\u00E1"+"veis", "desempol"+u"\u00E1"+"veis", "desempolg"+u"\u00E1"+"veis", "desempolh"+u"\u00E1"+"veis",
"desemposs"+u"\u00E1"+"veis", "desempreg"+u"\u00E1"+"veis", "desemprego", "desemprenh"+u"\u00E1"+"veis", "desempro"+u"\u00E1"+"veis", "desempunh"+u"\u00E1"+"veis",
"desemulsific"+u"\u00E1"+"veis", "desemulsion"+u"\u00E1"+"veis", "desenamor"+u"\u00E1"+"veis", "desencabe"+u"\u00E7"+u"\u00E1"+"veis", "desencabrest"+u"\u00E1"+"veis", "desencabul"+u"\u00E1"+"veis",
"desencacha"+u"\u00E7"+u"\u00E1"+"veis", "desencadern"+u"\u00E1"+"veis", "desencaix"+u"\u00E1"+"veis", "desencaixilh"+u"\u00E1"+"veis", "desencaixot"+u"\u00E1"+"veis", "desencalacr"+u"\u00E1"+"veis",
"desencalh"+u"\u00E1"+"veis", "desencalm"+u"\u00E1"+"veis", "desencamb"+u"\u00E1"+"veis", "desencaminh"+u"\u00E1"+"veis", "desencamp"+u"\u00E1"+"veis", "desencanalh"+u"\u00E1"+"veis",
"desencan"+u"\u00E1"+"veis", "desencant"+u"\u00E1"+"veis", "desencanto", "desencap"+u"\u00E1"+"veis", "desencapot"+u"\u00E1"+"veis", "desencaracol"+u"\u00E1"+"veis",
"desencarapu"+u"\u00E7"+u"\u00E1"+"veis", "desencarcer"+u"\u00E1"+"veis", "desencargo", "desencarn"+u"\u00E1"+"veis", "desencarquilh"+u"\u00E1"+"veis", "desencarr"+u"\u00E1"+"veis",
"desencarreg"+u"\u00E1"+"veis", "desencarreir"+u"\u00E1"+"veis", "desencart"+u"\u00E1"+"veis", "desencasc"+u"\u00E1"+"veis", "desencastel"+u"\u00E1"+"veis", "desencasto"+u"\u00E1"+"veis",
"desencav"+u"\u00E1"+"veis", "desencavilh"+u"\u00E1"+"veis", "desencer"+u"\u00E1"+"veis", "desencerr"+u"\u00E1"+"veis", "desencoira"+u"\u00E7"+u"\u00E1"+"veis", "desencoir"+u"\u00E1"+"veis",
"desencoleriz"+u"\u00E1"+"veis", "desencomend"+u"\u00E1"+"veis", "desencontr"+u"\u00E1"+"veis", "desencontro", "desencoraj"+u"\u00E1"+"veis", "desencordo"+u"\u00E1"+"veis",
"desencorp"+u"\u00E1"+"veis", "desencorpor"+u"\u00E1"+"veis", "desencost"+u"\u00E1"+"veis", "desencoura"+u"\u00E7"+u"\u00E1"+"veis", "desencour"+u"\u00E1"+"veis", "desencov"+u"\u00E1"+"veis",
"desencrav"+u"\u00E1"+"veis", "desencresp"+u"\u00E1"+"veis", "desencru"+u"\u00E1"+"veis", "desencurv"+u"\u00E1"+"veis", "desendeus"+u"\u00E1"+"veis", "desendivid"+u"\u00E1"+"veis",
"desenerv"+u"\u00E1"+"veis", "desenevo"+u"\u00E1"+"veis", "desenfad"+u"\u00E1"+"veis", "desenfard"+u"\u00E1"+"veis", "desenfarrusc"+u"\u00E1"+"veis", "desenfart"+u"\u00E1"+"veis",
"desenfasti"+u"\u00E1"+"veis", "desenfeit"+u"\u00E1"+"veis", "desenfeiti"+u"\u00E7"+u"\u00E1"+"veis", "desenfeix"+u"\u00E1"+"veis", "desenferm"+u"\u00E1"+"veis", "desenferruj"+u"\u00E1"+"veis",
"desenfest"+u"\u00E1"+"veis", "desenfeud"+u"\u00E1"+"veis", "desenfez"+u"\u00E1"+"veis", "desenfi"+u"\u00E1"+"veis", "desenfileir"+u"\u00E1"+"veis", "desenflor"+u"\u00E1"+"veis",
"desenfrasc"+u"\u00E1"+"veis", "desenfrech"+u"\u00E1"+"veis", "desenfronh"+u"\u00E1"+"veis", "desenfun"+u"\u00E1"+"veis", "desenfurn"+u"\u00E1"+"veis", "desenga"+u"\u00E7"+u"\u00E1"+"veis",
"desengaiol"+u"\u00E1"+"veis", "desengaj"+u"\u00E1"+"veis", "desengalfinh"+u"\u00E1"+"veis", "desengan"+u"\u00E1"+"veis", "desenganch"+u"\u00E1"+"veis", "desengano",
"desengarraf"+u"\u00E1"+"veis", "desengasg"+u"\u00E1"+"veis", "desengastalh"+u"\u00E1"+"veis", "desengast"+u"\u00E1"+"veis", "desengat"+u"\u00E1"+"veis", "desengatilh"+u"\u00E1"+"veis",
"desengavet"+u"\u00E1"+"veis", "desengelh"+u"\u00E1"+"veis", "desenglob"+u"\u00E1"+"veis", "desengod"+u"\u00E1"+"veis", "desengom"+u"\u00E1"+"veis", "desengon"+u"\u00E7"+u"\u00E1"+"veis",
"desengordur"+u"\u00E1"+"veis", "desengrad"+u"\u00E1"+"veis", "desengren"+u"\u00E1"+"veis", "desengril"+u"\u00E1"+"veis", "desengross"+u"\u00E1"+"veis", "desengui"+u"\u00E7"+u"\u00E1"+"veis",
"desenh"+u"\u00E1"+"veis", "desenho", "desenjaul"+u"\u00E1"+"veis", "desenlev"+u"\u00E1"+"veis", "desenloda"+u"\u00E7"+u"\u00E1"+"veis", "desenlod"+u"\u00E1"+"veis",
"desenodo"+u"\u00E1"+"veis", "desenquadr"+u"\u00E1"+"veis", "desenrasc"+u"\u00E1"+"veis", "desenred"+u"\u00E1"+"veis", "desenregel"+u"\u00E1"+"veis", "desenri"+u"\u00E7"+u"\u00E1"+"veis",
"desenrij"+u"\u00E1"+"veis", "desenrol"+u"\u00E1"+"veis", "desenrosc"+u"\u00E1"+"veis", "desenrug"+u"\u00E1"+"veis", "desensabo"+u"\u00E1"+"veis", "desensac"+u"\u00E1"+"veis",
"desensanguent"+u"\u00E1"+"veis", "desensarilh"+u"\u00E1"+"veis", "desensin"+u"\u00E1"+"veis", "desentabu"+u"\u00E1"+"veis", "desentabul"+u"\u00E1"+"veis", "desentaip"+u"\u00E1"+"veis",
"desental"+u"\u00E1"+"veis", "desentaramel"+u"\u00E1"+"veis", "desentedi"+u"\u00E1"+"veis", "desenterr"+u"\u00E1"+"veis", "desentes"+u"\u00E1"+"veis", "desentesoir"+u"\u00E1"+"veis",
"desentesour"+u"\u00E1"+"veis", "desentibi"+u"\u00E1"+"veis", "desento"+u"\u00E1"+"veis", "desentoc"+u"\u00E1"+"veis", "desentort"+u"\u00E1"+"veis", "desentralh"+u"\u00E1"+"veis",
"desentramel"+u"\u00E1"+"veis", "desentran"+u"\u00E7"+u"\u00E1"+"veis", "desentranh"+u"\u00E1"+"veis", "desentrav"+u"\u00E1"+"veis", "desentrela"+u"\u00E7"+u"\u00E1"+"veis", "desentrevero",
"desentronc"+u"\u00E1"+"veis", "desentroniz"+u"\u00E1"+"veis", "desentulh"+u"\u00E1"+"veis", "desenturv"+u"\u00E1"+"veis", "desentusiasm"+u"\u00E1"+"veis", "desentusiasmo",
"desenubl"+u"\u00E1"+"veis", "desenvas"+u"\u00E1"+"veis", "desenvasilh"+u"\u00E1"+"veis", "desenvencilh"+u"\u00E1"+"veis", "desenvenen"+u"\u00E1"+"veis", "desenvergonh"+u"\u00E1"+"veis",
"desenverniz"+u"\u00E1"+"veis", "desenvies"+u"\u00E1"+"veis", "desenvincilh"+u"\u00E1"+"veis", "desenvisc"+u"\u00E1"+"veis", "desenxofr"+u"\u00E1"+"veis", "desenxovalh"+u"\u00E1"+"veis",
"desequilibr"+u"\u00E1"+"veis", "desequip"+u"\u00E1"+"veis", "desequivoc"+u"\u00E1"+"veis", "deserd"+u"\u00E1"+"veis", "deserta", "desertas",
"desert"+u"\u00E1"+"veis", "desertific"+u"\u00E1"+"veis", "deserto", "desescal"+u"\u00E1"+"veis", "desescolariz"+u"\u00E1"+"veis", "desescud"+u"\u00E1"+"veis",
"desespant"+u"\u00E1"+"veis", "desespanto", "desesperan"+u"\u00E7"+u"\u00E1"+"veis", "desesper"+u"\u00E1"+"veis", "desespero", "desessenci"+u"\u00E1"+"veis",
"desestabiliz"+u"\u00E1"+"veis", "desestagn"+u"\u00E1"+"veis", "desestaliniz"+u"\u00E1"+"veis", "desestanh"+u"\u00E1"+"veis", "desestim"+u"\u00E1"+"veis", "desestimul"+u"\u00E1"+"veis",
"desestorv"+u"\u00E1"+"veis", "desestrutur"+u"\u00E1"+"veis", "desetaniz"+u"\u00E1"+"veis", "desevangeliz"+u"\u00E1"+"veis", "desexcomung"+u"\u00E1"+"veis", "desfabul"+u"\u00E1"+"veis",
"desfadig"+u"\u00E1"+"veis", "desfalca"+u"\u00E7"+u"\u00E1"+"veis", "desfalc"+u"\u00E1"+"veis", "desfanatiz"+u"\u00E1"+"veis", "desfard"+u"\u00E1"+"veis", "desfarel"+u"\u00E1"+"veis",
"desfarinh"+u"\u00E1"+"veis", "desfas"+u"\u00E1"+"veis", "desfataliz"+u"\u00E1"+"veis", "desfebr"+u"\u00E1"+"veis", "desfech"+u"\u00E1"+"veis", "desfecho",
"desfenestr"+u"\u00E1"+"veis", "desferr"+u"\u00E1"+"veis", "desferrolh"+u"\u00E1"+"veis", "desferruj"+u"\u00E1"+"veis", "desfertiliz"+u"\u00E1"+"veis", "desfi"+u"\u00E1"+"veis",
"desfibr"+u"\u00E1"+"veis", "desfibril"+u"\u00E1"+"veis", "desfibrin"+u"\u00E1"+"veis", "desfigur"+u"\u00E1"+"veis", "desfil"+u"\u00E1"+"veis", "desfileir"+u"\u00E1"+"veis",
"desfoc"+u"\u00E1"+"veis", "desfolg"+u"\u00E1"+"veis", "desfolh"+u"\u00E1"+"veis", "desfonologiz"+u"\u00E1"+"veis", "desfor"+u"\u00E7"+u"\u00E1"+"veis", "desfor"+u"\u00E7"+"o",
"desformato", "desform"+u"\u00E1"+"veis", "desforra", "desforras", "desforr"+u"\u00E1"+"veis", "desfortific"+u"\u00E1"+"veis",
"desfosfor"+u"\u00E1"+"veis", "desfrald"+u"\u00E1"+"veis", "desfraterniz"+u"\u00E1"+"veis", "desfrech"+u"\u00E1"+"veis", "desfris"+u"\u00E1"+"veis", "desfrouxo",
"desfrut"+u"\u00E1"+"veis", "desfuncionais", "desgalh"+u"\u00E1"+"veis", "desgalvaniz"+u"\u00E1"+"veis", "desgarr"+u"\u00E1"+"veis", "desgarro",
"desgasconiz"+u"\u00E1"+"veis", "desgaseific"+u"\u00E1"+"veis", "desgasific"+u"\u00E1"+"veis", "desgast"+u"\u00E1"+"veis", "desgel"+u"\u00E1"+"veis", "desgenitaliz"+u"\u00E1"+"veis",
"desgentiliz"+u"\u00E1"+"veis", "desgeometriz"+u"\u00E1"+"veis", "desgermaniz"+u"\u00E1"+"veis", "desgliceriniz"+u"\u00E1"+"veis", "desglobuliz"+u"\u00E1"+"veis", "desgoel"+u"\u00E1"+"veis",
"desgordur"+u"\u00E1"+"veis", "desgorj"+u"\u00E1"+"veis", "desgost"+u"\u00E1"+"veis", "desgosto", "desgovern"+u"\u00E1"+"veis", "desgoverno",
"desgra"+u"\u00E7"+"a", "desgra"+u"\u00E7"+"as", "desgra"+u"\u00E7"+u"\u00E1"+"veis", "desgraci"+u"\u00E1"+"veis", "desgraduais", "desgradu"+u"\u00E1"+"veis",
"desgravid"+u"\u00E1"+"veis", "desgraviz"+u"\u00E1"+"veis", "desgrax"+u"\u00E1"+"veis", "desgreg"+u"\u00E1"+"veis", "desgrilho"+u"\u00E1"+"veis", "desgrud"+u"\u00E1"+"veis",
"desgrum"+u"\u00E1"+"veis", "desguard"+u"\u00E1"+"veis", "desidealiz"+u"\u00E1"+"veis", "desidrat"+u"\u00E1"+"veis", "desidrogeniz"+u"\u00E1"+"veis", "desigual"+u"\u00E1"+"veis",
"desilusion"+u"\u00E1"+"veis", "desimagin"+u"\u00E1"+"veis", "desimaniz"+u"\u00E1"+"veis", "desimant"+u"\u00E1"+"veis", "desimpregn"+u"\u00E1"+"veis", "desimpression"+u"\u00E1"+"veis",
"desincentivo", "desinch"+u"\u00E1"+"veis", "desinclin"+u"\u00E1"+"veis", "desincompatibiliz"+u"\u00E1"+"veis", "desincorpor"+u"\u00E1"+"veis", "desincrust"+u"\u00E1"+"veis",
"desindic"+u"\u00E1"+"veis", "desindici"+u"\u00E1"+"veis", "desinfam"+u"\u00E1"+"veis", "desinfect"+u"\u00E1"+"veis", "desinfern"+u"\u00E1"+"veis", "desinfest"+u"\u00E1"+"veis",
"desinfet"+u"\u00E1"+"veis", "desinficion"+u"\u00E1"+"veis", "desinflacionais", "desinflam"+u"\u00E1"+"veis", "desinflamo", "desinfl"+u"\u00E1"+"veis",
"desinfluenci"+u"\u00E1"+"veis", "desingles"+u"\u00E1"+"veis", "desingurgit"+u"\u00E1"+"veis", "desinjuri"+u"\u00E1"+"veis", "desinquiet"+u"\u00E1"+"veis", "desinset"+u"\u00E1"+"veis",
"desinsetiz"+u"\u00E1"+"veis", "desinstitucionaliz"+u"\u00E1"+"veis", "desintegr"+u"\u00E1"+"veis", "desinteir"+u"\u00E1"+"veis", "desinteiri"+u"\u00E7"+u"\u00E1"+"veis", "desinteressais",
"desinteress"+u"\u00E1"+"veis", "desinternacionaliz"+u"\u00E1"+"veis", "desintern"+u"\u00E1"+"veis", "desintimid"+u"\u00E1"+"veis", "desintoxic"+u"\u00E1"+"veis", "desintric"+u"\u00E1"+"veis",
"desintrinc"+u"\u00E1"+"veis", "desinvagin"+u"\u00E1"+"veis", "desioniz"+u"\u00E1"+"veis", "desipotec"+u"\u00E1"+"veis", "desirman"+u"\u00E1"+"veis", "desislamiz"+u"\u00E1"+"veis",
"desjunt"+u"\u00E1"+"veis", "deslacr"+u"\u00E1"+"veis", "desladrilh"+u"\u00E1"+"veis", "deslanch"+u"\u00E1"+"veis", "deslapid"+u"\u00E1"+"veis", "deslarv"+u"\u00E1"+"veis",
"deslaud"+u"\u00E1"+"veis", "deslavr"+u"\u00E1"+"veis", "desleald"+u"\u00E1"+"veis", "desleg"+u"\u00E1"+"veis", "deslegitim"+u"\u00E1"+"veis", "desleit"+u"\u00E1"+"veis",
"desleix"+u"\u00E1"+"veis", "desleixo", "deslembr"+u"\u00E1"+"veis", "desli"+u"\u00E1"+"veis", "deslig"+u"\u00E1"+"veis", "deslignific"+u"\u00E1"+"veis",
"deslind"+u"\u00E1"+"veis", "deslinhific"+u"\u00E1"+"veis", "deslis"+u"\u00E1"+"veis", "deslivr"+u"\u00E1"+"veis", "desliz"+u"\u00E1"+"veis", "desloc"+u"\u00E1"+"veis",
"deslustrais", "desmacul"+u"\u00E1"+"veis", "desmagnetiz"+u"\u00E1"+"veis", "desmaio", "desmam"+u"\u00E1"+"veis", "desmanch"+u"\u00E1"+"veis",
"desmancho", "desmand"+u"\u00E1"+"veis", "desmando", "desmaranh"+u"\u00E1"+"veis", "desmarc"+u"\u00E1"+"veis", "desmarchet"+u"\u00E1"+"veis",
"desmarcializ"+u"\u00E1"+"veis", "desmargin"+u"\u00E1"+"veis", "desmascar"+u"\u00E1"+"veis", "desmat"+u"\u00E1"+"veis", "desmaterializ"+u"\u00E1"+"veis", "desmazelo",
"desmedr"+u"\u00E1"+"veis", "desmelhor"+u"\u00E1"+"veis", "desmelindr"+u"\u00E1"+"veis", "desmembr"+u"\u00E1"+"veis", "desmensur"+u"\u00E1"+"veis", "desmesmeriz"+u"\u00E1"+"veis",
"desmesur"+u"\u00E1"+"veis", "desmetaliz"+u"\u00E1"+"veis", "desmetodiz"+u"\u00E1"+"veis", "desmieliniz"+u"\u00E1"+"veis", "desmilitariz"+u"\u00E1"+"veis", "desmineraliz"+u"\u00E1"+"veis",
"desmitific"+u"\u00E1"+"veis", "desmiud"+u"\u00E1"+"veis", "desmobil"+u"\u00E1"+"veis", "desmobilh"+u"\u00E1"+"veis", "desmobiliz"+u"\u00E1"+"veis", "desmoder"+u"\u00E1"+"veis",
"desmodul"+u"\u00E1"+"veis", "desmoed"+u"\u00E1"+"veis", "desmoit"+u"\u00E1"+"veis", "desmold"+u"\u00E1"+"veis", "desmonetiz"+u"\u00E1"+"veis", "desmonopoliz"+u"\u00E1"+"veis",
"desmonotoniz"+u"\u00E1"+"veis", "desmont"+u"\u00E1"+"veis", "desmoraliz"+u"\u00E1"+"veis", "desmorfiniz"+u"\u00E1"+"veis", "desmoron"+u"\u00E1"+"veis", "desmotiv"+u"\u00E1"+"veis",
"desmudo", "desmultiplic"+u"\u00E1"+"veis", "desmunhec"+u"\u00E1"+"veis", "desmuscul"+u"\u00E1"+"veis", "desnaturais", "desnudo",
"desonesto", "desonra", "desonras", "desorden"+u"\u00E1"+"veis", "desova", "desovas",
"despach"+u"\u00E1"+"veis", "despacho", "despacient"+u"\u00E1"+"veis", "despagin"+u"\u00E1"+"veis", "despais"+u"\u00E1"+"veis", "despalataliz"+u"\u00E1"+"veis",
"despalatiz"+u"\u00E1"+"veis", "desparafin"+u"\u00E1"+"veis", "desparafus"+u"\u00E1"+"veis", "desparcel"+u"\u00E1"+"veis", "desparram"+u"\u00E1"+"veis", "desparramo",
"desparr"+u"\u00E1"+"veis", "despeda"+u"\u00E7"+u"\u00E1"+"veis", "despeg"+u"\u00E1"+"veis", "despeito", "despej"+u"\u00E1"+"veis", "despejo",
"despenh"+u"\u00E1"+"veis", "despenho", "desperdi"+u"\u00E7"+u"\u00E1"+"veis", "despersonaliz"+u"\u00E1"+"veis", "desperto", "despesa",
"despesas", "despeso", "despetal"+u"\u00E1"+"veis", "despetrech"+u"\u00E1"+"veis", "despigment"+u"\u00E1"+"veis", "despint"+u"\u00E1"+"veis",
"despist"+u"\u00E1"+"veis", "despoj"+u"\u00E1"+"veis", "despojo", "despolariz"+u"\u00E1"+"veis", "despolimeriz"+u"\u00E1"+"veis", "despolp"+u"\u00E1"+"veis",
"despont"+u"\u00E1"+"veis", "despontuais", "despontu"+u"\u00E1"+"veis", "despopulariz"+u"\u00E1"+"veis", "despopul"+u"\u00E1"+"veis", "desportugues"+u"\u00E1"+"veis",
"despos"+u"\u00E1"+"veis", "despovo"+u"\u00E1"+"veis", "desprecat"+u"\u00E1"+"veis", "despreg"+u"\u00E1"+"veis", "despreocup"+u"\u00E1"+"veis", "desprepar"+u"\u00E1"+"veis",
"despreparo", "desprestigi"+u"\u00E1"+"veis", "despreza", "desprezas", "desprez"+u"\u00E1"+"veis", "desprezo",
"desprivilegi"+u"\u00E1"+"veis", "desprogram"+u"\u00E1"+"veis", "despronunci"+u"\u00E1"+"veis", "despropaniz"+u"\u00E1"+"veis", "desproporcionais", "desproporcion"+u"\u00E1"+"veis",
"desproposit"+u"\u00E1"+"veis", "despropri"+u"\u00E1"+"veis", "desprum"+u"\u00E1"+"veis", "desprussianiz"+u"\u00E1"+"veis", "despurific"+u"\u00E1"+"veis", "desqualific"+u"\u00E1"+"veis",
"desquit"+u"\u00E1"+"veis", "desram"+u"\u00E1"+"veis", "desratiz"+u"\u00E1"+"veis", "desrecalc"+u"\u00E1"+"veis", "desregulamento", "desremedi"+u"\u00E1"+"veis",
"desrespeito", "desresponsabiliz"+u"\u00E1"+"veis", "desromantiz"+u"\u00E1"+"veis", "desrussific"+u"\u00E1"+"veis", "dessa", "dessacraliz"+u"\u00E1"+"veis",
"dessacr"+u"\u00E1"+"veis", "dessagr"+u"\u00E1"+"veis", "dessalg"+u"\u00E1"+"veis", "dessalific"+u"\u00E1"+"veis", "dessalinific"+u"\u00E1"+"veis", "dessaliniz"+u"\u00E1"+"veis",
"dessalitr"+u"\u00E1"+"veis", "dessangr"+u"\u00E1"+"veis", "dessas", "dessec"+u"\u00E1"+"veis", "dessedent"+u"\u00E1"+"veis", "dessegred"+u"\u00E1"+"veis",
"dessegreg"+u"\u00E1"+"veis", "dessegur"+u"\u00E1"+"veis", "dessemelh"+u"\u00E1"+"veis", "dessensibiliz"+u"\u00E1"+"veis", "dessepult"+u"\u00E1"+"veis", "dessexualiz"+u"\u00E1"+"veis",
"dessexu"+u"\u00E1"+"veis", "dessilic"+u"\u00E1"+"veis", "dessilicific"+u"\u00E1"+"veis", "dessimpatiz"+u"\u00E1"+"veis", "dessinal"+u"\u00E1"+"veis", "dessintoniz"+u"\u00E1"+"veis",
"dessoc"+u"\u00E1"+"veis", "dessolidariz"+u"\u00E1"+"veis", "dessor"+u"\u00E1"+"veis", "dessosseg"+u"\u00E1"+"veis", "dessoterr"+u"\u00E1"+"veis", "dessud"+u"\u00E1"+"veis",
"dessulfur"+u"\u00E1"+"veis", "dessulfuriz"+u"\u00E1"+"veis", "destac"+u"\u00E1"+"veis", "destalho", "destaniz"+u"\u00E1"+"veis", "destap"+u"\u00E1"+"veis",
"destelh"+u"\u00E1"+"veis", "destelo", "destemper"+u"\u00E1"+"veis", "destempero", "desterraplen"+u"\u00E1"+"veis", "desterr"+u"\u00E1"+"veis",
"desterro", "destil"+u"\u00E1"+"veis", "destin"+u"\u00E1"+"veis", "destino", "destipific"+u"\u00E1"+"veis", "desto"+u"\u00E1"+"veis",
"destoc"+u"\u00E1"+"veis", "destrago", "destram"+u"\u00E1"+"veis", "destrambelh"+u"\u00E1"+"veis", "destranc"+u"\u00E1"+"veis", "destran"+u"\u00E7"+u"\u00E1"+"veis",
"destrat"+u"\u00E1"+"veis", "destravanc"+u"\u00E1"+"veis", "destrav"+u"\u00E1"+"veis", "destrein"+u"\u00E1"+"veis", "destribaliz"+u"\u00E1"+"veis", "destrinc"+u"\u00E1"+"veis",
"destrin"+u"\u00E7"+u"\u00E1"+"veis", "destrinch"+u"\u00E1"+"veis", "destrip"+u"\u00E1"+"veis", "destro"+u"\u00E7"+u"\u00E1"+"veis", "destro"+u"\u00E7"+"o", "destron"+u"\u00E1"+"veis",
"destronc"+u"\u00E1"+"veis", "destroniz"+u"\u00E1"+"veis", "destrunf"+u"\u00E1"+"veis", "destutel"+u"\u00E1"+"veis", "desultraj"+u"\u00E1"+"veis", "desumana",
"desumanais", "desumanas", "desuman"+u"\u00E1"+"veis", "desumaniz"+u"\u00E1"+"veis", "desumano", "desumidific"+u"\u00E1"+"veis",
"desunific"+u"\u00E1"+"veis", "desurbaniz"+u"\u00E1"+"veis", "desus"+u"\u00E1"+"veis", "desuso", "desvair"+u"\u00E1"+"veis", "desvairo",
"desvalia", "desvalias", "desvalid"+u"\u00E1"+"veis", "desvalido", "desvalor"+u"\u00E1"+"veis", "desvaloriz"+u"\u00E1"+"veis",
"desvari"+u"\u00E1"+"veis", "desvario", "desvasculariz"+u"\u00E1"+"veis", "desvassal"+u"\u00E1"+"veis", "desvel"+u"\u00E1"+"veis", "desvelej"+u"\u00E1"+"veis",
"desvelo", "desvencilh"+u"\u00E1"+"veis", "desvend"+u"\u00E1"+"veis", "desvener"+u"\u00E1"+"veis", "desventr"+u"\u00E1"+"veis", "desventura",
"desventuras", "desvergonh"+u"\u00E1"+"veis", "desvi"+u"\u00E1"+"veis", "desvigor"+u"\u00E1"+"veis", "desvigoriz"+u"\u00E1"+"veis", "desvinc"+u"\u00E1"+"veis",
"desvincul"+u"\u00E1"+"veis", "desvio", "desvirgin"+u"\u00E1"+"veis", "desvirginiz"+u"\u00E1"+"veis", "desviriliz"+u"\u00E1"+"veis", "desvirtu"+u"\u00E1"+"veis",
"desviscer"+u"\u00E1"+"veis", "desvitaliz"+u"\u00E1"+"veis", "desvitamin"+u"\u00E1"+"veis", "desvitaminiz"+u"\u00E1"+"veis", "desvitrific"+u"\u00E1"+"veis", "desvocaliz"+u"\u00E1"+"veis",
"desvulcaniz"+u"\u00E1"+"veis", "desvulgariz"+u"\u00E1"+"veis", "detalh"+u"\u00E1"+"veis", "detard"+u"\u00E1"+"veis", "detect"+u"\u00E1"+"veis", "deterior"+u"\u00E1"+"veis",
"determin"+u"\u00E1"+"veis", "detest"+u"\u00E1"+"veis", "detet"+u"\u00E1"+"veis", "deton"+u"\u00E1"+"veis", "detrat"+u"\u00E1"+"veis", "deturp"+u"\u00E1"+"veis",
"devassa", "devassas", "devass"+u"\u00E1"+"veis", "devasso", "devast"+u"\u00E1"+"veis", "devel"+u"\u00E1"+"veis",
"deventr"+u"\u00E1"+"veis", "devis"+u"\u00E1"+"veis", "devor"+u"\u00E1"+"veis", "devota", "devotas", "devot"+u"\u00E1"+"veis",
"devoto", "devulcaniz"+u"\u00E1"+"veis", "dezincific"+u"\u00E1"+"veis", "diaboliz"+u"\u00E1"+"veis", "diaclas"+u"\u00E1"+"veis", "diafaniz"+u"\u00E1"+"veis",
"diagnostic"+u"\u00E1"+"veis", "diagonaliz"+u"\u00E1"+"veis", "diagram"+u"\u00E1"+"veis", "dialectais", "dialect"+u"\u00E1"+"veis", "dialecto",
"dialetais", "dialet"+u"\u00E1"+"veis", "dialeto", "dialis"+u"\u00E1"+"veis", "dialogais", "dialog"+u"\u00E1"+"veis",
"diamantiz"+u"\u00E1"+"veis", "diatermocoagul"+u"\u00E1"+"veis", "diazotiz"+u"\u00E1"+"veis", "dica", "dicas", "dicionari"+u"\u00E1"+"veis",
"dicionariz"+u"\u00E1"+"veis", "dicotomiz"+u"\u00E1"+"veis", "dies"+u"\u00E1"+"veis", "dieseliz"+u"\u00E1"+"veis", "difam"+u"\u00E1"+"veis", "diferen"+u"\u00E7"+"ais",
"diferen"+u"\u00E7"+u"\u00E1"+"veis", "diferenciais", "diferenci"+u"\u00E1"+"veis", "dificult"+u"\u00E1"+"veis", "difrat"+u"\u00E1"+"veis", "digitais",
"digitaliniz"+u"\u00E1"+"veis", "digitaliz"+u"\u00E1"+"veis", "digit"+u"\u00E1"+"veis", "digladi"+u"\u00E1"+"veis", "dign"+u"\u00E1"+"veis", "dignific"+u"\u00E1"+"veis",
"digno", "digress"+u"\u00E1"+"veis", "digression"+u"\u00E1"+"veis", "digresso", "dilacer"+u"\u00E1"+"veis", "dilapid"+u"\u00E1"+"veis",
"dilat"+u"\u00E1"+"veis", "diligenci"+u"\u00E1"+"veis", "dilucid"+u"\u00E1"+"veis", "diluviais", "diman"+u"\u00E1"+"veis", "dimensionais",
"dimension"+u"\u00E1"+"veis", "dimidi"+u"\u00E1"+"veis", "dinamit"+u"\u00E1"+"veis", "dinamitiz"+u"\u00E1"+"veis", "dinamiz"+u"\u00E1"+"veis", "dinda",
"dindas", "dindo", "dinumer"+u"\u00E1"+"veis", "diplomacia", "diplomacias", "diplomatiz"+u"\u00E1"+"veis",
"diplom"+u"\u00E1"+"veis", "direcionais", "direcion"+u"\u00E1"+"veis", "discais", "disciplina", "disciplinas",
"disciplin"+u"\u00E1"+"veis", "disco", "discord"+u"\u00E1"+"veis", "discrep"+u"\u00E1"+"veis", "discriminais", "discrimin"+u"\u00E1"+"veis",
"discursais", "discurs"+u"\u00E1"+"veis", "discurso", "diseliz"+u"\u00E1"+"veis", "disfar"+u"\u00E7"+u"\u00E1"+"veis", "disform"+u"\u00E1"+"veis",
"disgreg"+u"\u00E1"+"veis", "disjunt"+u"\u00E1"+"veis", "disjunto", "disparat"+u"\u00E1"+"veis", "disparo", "dispens"+u"\u00E1"+"veis",
"dispers"+u"\u00E1"+"veis", "disperso", "disputais", "disput"+u"\u00E1"+"veis", "dissec"+u"\u00E1"+"veis", "dissemelh"+u"\u00E1"+"veis",
"dissemin"+u"\u00E1"+"veis", "dissert"+u"\u00E1"+"veis", "dissidi"+u"\u00E1"+"veis", "dissimetriz"+u"\u00E1"+"veis", "dissimil"+u"\u00E1"+"veis", "dissimul"+u"\u00E1"+"veis",
"dissip"+u"\u00E1"+"veis", "dissociais", "dissoci"+u"\u00E1"+"veis", "disson"+u"\u00E1"+"veis", "distais", "distanci"+u"\u00E1"+"veis",
"distrat"+u"\u00E1"+"veis", "distrato", "distrofic"+u"\u00E1"+"veis", "disturb"+u"\u00E1"+"veis", "dita", "ditas",
"dit"+u"\u00E1"+"veis", "dito", "ditongais", "ditong"+u"\u00E1"+"veis", "ditongo", "diuturniz"+u"\u00E1"+"veis",
"divag"+u"\u00E1"+"veis", "divaric"+u"\u00E1"+"veis", "diversific"+u"\u00E1"+"veis", "diviniz"+u"\u00E1"+"veis", "divisa", "divisas",
"divis"+u"\u00E1"+"veis", "diviso", "divorciais", "divorci"+u"\u00E1"+"veis", "divulg"+u"\u00E1"+"veis", "dizim"+u"\u00E1"+"veis",
"do"+u"\u00E1"+"veis", "dobra", "dobrais", "dobras", "dobr"+u"\u00E1"+"veis", "dobro",
"do"+u"\u00E7"+"ais", "do"+u"\u00E7"+u"\u00E1"+"veis", "dociliz"+u"\u00E1"+"veis", "documentais", "document"+u"\u00E1"+"veis", "documento",
"doest"+u"\u00E1"+"veis", "dogmatiz"+u"\u00E1"+"veis", "doidej"+u"\u00E1"+"veis", "doir"+u"\u00E1"+"veis", "doirej"+u"\u00E1"+"veis", "doloriz"+u"\u00E1"+"veis",
"dom"+u"\u00E1"+"veis", "domestic"+u"\u00E1"+"veis", "domicili"+u"\u00E1"+"veis", "domific"+u"\u00E1"+"veis", "domin"+u"\u00E1"+"veis", "domingais",
"domingo", "domo", "dop"+u"\u00E1"+"veis", "dorminhoco", "dormit"+u"\u00E1"+"veis", "dorsaliz"+u"\u00E1"+"veis",
"dos"+u"\u00E1"+"veis", "dotais", "dot"+u"\u00E1"+"veis", "doudej"+u"\u00E1"+"veis", "dour"+u"\u00E1"+"veis", "dourej"+u"\u00E1"+"veis",
"doutora", "doutorais", "doutoras", "doutor"+u"\u00E1"+"veis", "doutrina", "doutrinais",
"doutrinas", "doutrin"+u"\u00E1"+"veis", "draga", "dragas", "dren"+u"\u00E1"+"veis", "dreno",
"droga", "drogas", "drog"+u"\u00E1"+"veis", "dualiz"+u"\u00E1"+"veis", "dubl"+u"\u00E1"+"veis", "ducha",
"duchais", "duchas", "duch"+u"\u00E1"+"veis", "ductiliz"+u"\u00E1"+"veis", "duel"+u"\u00E1"+"veis", "duelo",
"dueto", "dulcific"+u"\u00E1"+"veis", "dupla", "duplas", "dupl"+u"\u00E1"+"veis", "duplic"+u"\u00E1"+"veis",
"duplo", "durais", "dur"+u"\u00E1"+"veis", "duro", "duvid"+u"\u00E1"+"veis", "echacorvo",
"eclipsais", "eclips"+u"\u00E1"+"veis", "eco", "eco"+u"\u00E1"+"veis", "ecocardiograf"+u"\u00E1"+"veis", "ecoencefalograf"+u"\u00E1"+"veis",
"ecolocaliz"+u"\u00E1"+"veis", "ecoloc"+u"\u00E1"+"veis", "ecossistematiz"+u"\u00E1"+"veis", "ectomorfiz"+u"\u00E1"+"veis", "ecumeniz"+u"\u00E1"+"veis", "edafostratigraf"+u"\u00E1"+"veis",
"edafostratograf"+u"\u00E1"+"veis", "edematiz"+u"\u00E1"+"veis", "edific"+u"\u00E1"+"veis", "editais", "edit"+u"\u00E1"+"veis", "edito",
"editorais", "editor"+u"\u00E1"+"veis", "editoria", "editoriais", "editorias", "educ"+u"\u00E1"+"veis",
"efabul"+u"\u00E1"+"veis", "efeitu"+u"\u00E1"+"veis", "efemin"+u"\u00E1"+"veis", "efeminiz"+u"\u00E1"+"veis", "efervent"+u"\u00E1"+"veis", "efetiv"+u"\u00E1"+"veis",
"efetivo", "efetu"+u"\u00E1"+"veis", "eficaciais", "egipcianiz"+u"\u00E1"+"veis", "egocentraliz"+u"\u00E1"+"veis", "egocentr"+u"\u00E1"+"veis",
"egoidealiz"+u"\u00E1"+"veis", "eixo", "eject"+u"\u00E1"+"veis", "ejecto", "ejet"+u"\u00E1"+"veis", "elabor"+u"\u00E1"+"veis",
"electrific"+u"\u00E1"+"veis", "electriz"+u"\u00E1"+"veis", "electrocut"+u"\u00E1"+"veis", "electrodiagnostic"+u"\u00E1"+"veis", "electrolis"+u"\u00E1"+"veis", "elenco",
"eletrific"+u"\u00E1"+"veis", "eletriz"+u"\u00E1"+"veis", "eletrolis"+u"\u00E1"+"veis", "elev"+u"\u00E1"+"veis", "elimin"+u"\u00E1"+"veis", "elitiz"+u"\u00E1"+"veis",
"elo", "elogiais", "elogi"+u"\u00E1"+"veis", "elogio", "elong"+u"\u00E1"+"veis", "elucid"+u"\u00E1"+"veis",
"emancip"+u"\u00E1"+"veis", "embaci"+u"\u00E1"+"veis", "embalsamo", "embara"+u"\u00E7"+"o", "embarg"+u"\u00E1"+"veis", "embargo",
"embasbac"+u"\u00E1"+"veis", "embelec"+u"\u00E1"+"veis", "embelez"+u"\u00E1"+"veis", "embira", "embiras", "embo"+u"\u00E7"+"o",
"emboliz"+u"\u00E1"+"veis", "embols"+u"\u00E1"+"veis", "embolso", "embrionais", "embrulh"+u"\u00E1"+"veis", "embrulho",
"emenda", "emendas", "emend"+u"\u00E1"+"veis", "ementa", "ementas", "eminenciais",
"emocionais", "emocion"+u"\u00E1"+"veis", "empalamo", "empanado", "empanemo", "emparamento",
"empecilho", "empe"+u"\u00E7"+"o", "empelamo", "empelo", "empenh"+u"\u00E1"+"veis", "empenho",
"empeno", "empeso", "empilh"+u"\u00E1"+"veis", "emplastro", "emplum"+u"\u00E1"+"veis", "empolamo",
"empolg"+u"\u00E1"+"veis", "empostemo", "empreg"+u"\u00E1"+"veis", "emprego", "empresa", "empresariais",
"empresas", "emprestado", "empupo", "empuxo", "emulsific"+u"\u00E1"+"veis", "emulsion"+u"\u00E1"+"veis",
"enamor"+u"\u00E1"+"veis", "enastro", "encabreimo", "encabul"+u"\u00E1"+"veis", "enca"+u"\u00E7"+"ap"+u"\u00E1"+"veis", "encaga"+u"\u00E7"+u"\u00E1"+"veis",
"encaix"+u"\u00E1"+"veis", "encal"+u"\u00E7"+"o", "encalho", "encanho", "encant"+u"\u00E1"+"veis", "encanto",
"encarboniz"+u"\u00E1"+"veis", "encarcer"+u"\u00E1"+"veis", "encargo", "encarn"+u"\u00E1"+"veis", "encart"+u"\u00E1"+"veis", "encastr"+u"\u00E1"+"veis",
"encen"+u"\u00E1"+"veis", "encet"+u"\u00E1"+"veis", "enchimento", "encinho", "enclausur"+u"\u00E1"+"veis", "encoberto",
"encoito", "encoleriz"+u"\u00E1"+"veis", "encomenda", "encomendas", "encomi"+u"\u00E1"+"veis", "encontr"+u"\u00E1"+"veis",
"encontro", "encosto", "encouto", "enculturais", "encultur"+u"\u00E1"+"veis", "endere"+u"\u00E7"+u"\u00E1"+"veis",
"endere"+u"\u00E7"+"o", "endeus"+u"\u00E1"+"veis", "endireit"+u"\u00E1"+"veis", "endocruz"+u"\u00E1"+"veis", "endoss"+u"\u00E1"+"veis", "endosso",
"enduro", "enfado", "enfart"+u"\u00E1"+"veis", "enfatiz"+u"\u00E1"+"veis", "enfeiti"+u"\u00E7"+u"\u00E1"+"veis", "enferma",
"enfermas", "enfermo", "enfoc"+u"\u00E1"+"veis", "enforro", "enfum"+u"\u00E1"+"veis", "enfun"+u"\u00E1"+"veis",
"enfurn"+u"\u00E1"+"veis", "engaj"+u"\u00E1"+"veis", "engaldrapo", "engano", "engaranho", "engasgo",
"engenho", "engo", "engobo", "engui"+u"\u00E7"+"o", "enigmatiz"+u"\u00E1"+"veis", "enjeit"+u"\u00E1"+"veis",
"enjoo", "enla"+u"\u00E7"+u"\u00E1"+"veis", "enlevo", "enod"+u"\u00E1"+"veis", "enquadr"+u"\u00E1"+"veis", "enrab"+u"\u00E1"+"veis",
"enredo", "enrug"+u"\u00E1"+"veis", "ensai"+u"\u00E1"+"veis", "ensaio", "enseio", "ensejo",
"ensin"+u"\u00E1"+"veis", "ensino", "ensosso", "entabul"+u"\u00E1"+"veis", "entalh"+u"\u00E1"+"veis", "enterr"+u"\u00E1"+"veis",
"enterro", "entest"+u"\u00E1"+"veis", "ento"+u"\u00E1"+"veis", "entolho", "enton"+u"\u00E1"+"veis", "entorno",
"entramo", "entran"+u"\u00E7"+u"\u00E1"+"veis", "entranh"+u"\u00E1"+"veis", "entravais", "entredevor"+u"\u00E1"+"veis", "entrefolho",
"entrelinha", "entrelinhas", "entreoculto", "entreolho", "entrevero", "entrevist"+u"\u00E1"+"veis",
"entroco", "entro"+u"\u00E7"+"o", "entroniz"+u"\u00E1"+"veis", "entrope"+u"\u00E7"+"o", "entrudais", "entrudo",
"entub"+u"\u00E1"+"veis", "entulho", "enturm"+u"\u00E1"+"veis", "entusiasm"+u"\u00E1"+"veis", "entusiasmo", "enumer"+u"\u00E1"+"veis",
"enunci"+u"\u00E1"+"veis", "envenen"+u"\u00E1"+"veis", "enverg"+u"\u00E1"+"veis", "envergonh"+u"\u00E1"+"veis", "enverniz"+u"\u00E1"+"veis", "envi"+u"\u00E1"+"veis",
"envinhadalho", "envio", "envisgo", "enxabelho", "enxada", "enxadas",
"enxal"+u"\u00E7"+"o", "enxaqueca", "enxaquecas", "enxaugo", "enxeco", "enxerto",
"enxovais", "enxurro", "epidemia", "epidemiais", "epidemias", "epil"+u"\u00E1"+"veis",
"epilogais", "equacionais", "equacion"+u"\u00E1"+"veis", "equaliz"+u"\u00E1"+"veis", "equidimensionais", "equifinaliz"+u"\u00E1"+"veis",
"equilibr"+u"\u00E1"+"veis", "equipar"+u"\u00E1"+"veis", "equip"+u"\u00E1"+"veis", "ermais", "ermo", "ero",
"eros"+u"\u00E1"+"veis", "eroso", "erradic"+u"\u00E1"+"veis", "erro", "erudito", "erva",
"ervais", "ervas", "ervilha", "ervilhais", "ervilhas", "esbalho",
"esbarrunto", "esbelta", "esbeltas", "esbelto", "esbirro", "esbo"+u"\u00E7"+"o",
"esboroo", "esbulho", "escabelo", "escabro", "escacilho", "escafandro",
"escafelo", "escalado", "escalambro", "escal"+u"\u00E1"+"veis", "escalavro", "escaldo",
"escalon"+u"\u00E1"+"veis", "escalpo", "escama", "escamas", "escambo", "escambro",
"escamosais", "escamoso", "escancar"+u"\u00E1"+"veis", "escandaliz"+u"\u00E1"+"veis", "escanho"+u"\u00E1"+"veis", "escaninho",
"escap"+u"\u00E1"+"veis", "escapo", "escarafuncho", "escarambo", "escaravelho", "escarda"+u"\u00E7"+"o",
"escarmento", "escarninho", "escarpa", "escarpas", "escarrinho", "escarro",
"escassilho", "escleros"+u"\u00E1"+"veis", "escocho", "escoi"+u"\u00E7"+"o", "escolariz"+u"\u00E1"+"veis", "escoldrinh"+u"\u00E1"+"veis",
"escombro", "esconjur"+u"\u00E1"+"veis", "esconjuro", "escopeta", "escopetas", "escoriais",
"escorreg"+u"\u00E1"+"veis", "escorricho", "escorva", "escorvas", "escoucinho", "escou"+u"\u00E7"+"o",
"escova", "escovalho", "escovas", "escovinha", "escovinhas", "escravelho",
"escraviz"+u"\u00E1"+"veis", "escritura", "escriturais", "escrituras", "escrucho", "escrut"+u"\u00E1"+"veis",
"escrutin"+u"\u00E1"+"veis", "escud"+u"\u00E1"+"veis", "escudeiro", "escudo", "escultura", "esculturais",
"esculturas", "escuma", "escumas", "escumilha", "escumilhas", "escura",
"escuras", "escurento", "escuro", "escusa", "escusas", "escus"+u"\u00E1"+"veis",
"escuso", "escuta", "escutas", "escut"+u"\u00E1"+"veis", "esfarel"+u"\u00E1"+"veis", "esfarinh"+u"\u00E1"+"veis",
"esfoiro", "esfor"+u"\u00E7"+"o", "esfreg"+u"\u00E1"+"veis", "esfregulho", "esfri"+u"\u00E1"+"veis", "esfumilho",
"esfuminho", "esgalho", "esgar"+u"\u00E7"+u"\u00E1"+"veis", "esgot"+u"\u00E1"+"veis", "esgoto", "esgrafito",
"esgrima", "esgrimas", "esguia", "esguias", "esguicho", "esguio",
"eslaviz"+u"\u00E1"+"veis", "esmalt"+u"\u00E1"+"veis", "esmero", "esmicho", "esmola", "esmolas",
"esmor"+u"\u00E7"+"o", "esmordic"+u"\u00E1"+"veis", "espa"+u"\u00E7"+u"\u00E1"+"veis", "espacej"+u"\u00E1"+"veis", "espaciais", "espacializ"+u"\u00E1"+"veis",
"espa"+u"\u00E7"+"o", "espada", "espadais", "espadana", "espadanais", "espadanas",
"espadas", "espadela", "espadelas", "espadilha", "espadilhas", "espalda",
"espaldas", "espalhafato", "espalh"+u"\u00E1"+"veis", "espalm"+u"\u00E1"+"veis", "espan"+u"\u00E1"+"veis", "espanc"+u"\u00E1"+"veis",
"espanco", "espanhola", "espanholas", "espanholiz"+u"\u00E1"+"veis", "espant"+u"\u00E1"+"veis", "espanto",
"esparram"+u"\u00E1"+"veis", "esparramo", "esparrimo", "esparrinho", "esparro", "esparsa",
"esparsas", "esparso", "espartilho", "espasmo", "espatif"+u"\u00E1"+"veis", "espatul"+u"\u00E1"+"veis",
"especiais", "especializ"+u"\u00E1"+"veis", "especi"+u"\u00E1"+"veis", "especific"+u"\u00E1"+"veis", "espect"+u"\u00E1"+"veis", "espelh"+u"\u00E1"+"veis",
"espelho", "esper"+u"\u00E1"+"veis", "esperta", "espertas", "esperto", "espessa",
"espessas", "espesso", "espet"+u"\u00E1"+"veis", "espeto", "espi"+u"\u00E1"+"veis", "espica"+u"\u00E7"+u"\u00E1"+"veis",
"espiga", "espigas", "espincho", "espingarda", "espingardas", "espinha",
"espinhais", "espinhas", "espinho", "espirais", "espirita", "espiritais",
"espiritas", "espiritualiz"+u"\u00E1"+"veis", "espirro", "espoli"+u"\u00E1"+"veis", "esponja", "esponjas",
"espora", "esporas", "esporo", "esporul"+u"\u00E1"+"veis", "espos"+u"\u00E1"+"veis", "esposo",
"espritais", "espuma", "espumas", "esquadra", "esquadras", "esquadria",
"esquadrias", "esquadrinha", "esquadrinhas", "esquadrinh"+u"\u00E1"+"veis", "esquadrinho", "esquadro",
"esquematiz"+u"\u00E1"+"veis", "esquent"+u"\u00E1"+"veis", "esquerda", "esquerdas", "esquerdo", "esqui"+u"\u00E7"+"o",
"esquilo", "esquina", "esquinais", "esquinas", "esquistific"+u"\u00E1"+"veis", "esquiva",
"esquivas", "esquivo", "estabiliz"+u"\u00E1"+"veis", "estaca", "estacais", "estacas",
"estacionais", "estacion"+u"\u00E1"+"veis", "estadia", "estadiais", "estadias", "estafeta",
"estafetas", "estagflacionais", "estagn"+u"\u00E1"+"veis", "estaleiro", "estalido", "estalo",
"estaminais", "estampa", "estampas", "estamp"+u"\u00E1"+"veis", "estanc"+u"\u00E1"+"veis", "estanco",
"estandardiz"+u"\u00E1"+"veis", "estanh"+u"\u00E1"+"veis", "estardalha"+u"\u00E7"+"o", "estatiz"+u"\u00E1"+"veis", "estatuais", "esteira",
"esteiras", "esteiro", "estenograf"+u"\u00E1"+"veis", "estenos"+u"\u00E1"+"veis", "esterco", "estereofotograf"+u"\u00E1"+"veis",
"esterific"+u"\u00E1"+"veis", "esteriliz"+u"\u00E1"+"veis", "esternut"+u"\u00E1"+"veis", "estero", "estesia", "estesias",
"estevais", "estic"+u"\u00E1"+"veis", "estigmatiz"+u"\u00E1"+"veis", "estilha"+u"\u00E7"+u"\u00E1"+"veis", "estilha"+u"\u00E7"+"o", "estiliz"+u"\u00E1"+"veis",
"estilo", "estim"+u"\u00E1"+"veis", "estimul"+u"\u00E1"+"veis", "estinho", "estio", "estiol"+u"\u00E1"+"veis",
"estipendi"+u"\u00E1"+"veis", "estipul"+u"\u00E1"+"veis", "estivais", "estoc"+u"\u00E1"+"veis", "estofo", "estoirais",
"estojo", "estola", "estolas", "estopa", "estopas", "estorn"+u"\u00E1"+"veis",
"estorno", "estorvo", "estourais", "estourinho", "estouro", "estra"+u"\u00E7"+"alh"+u"\u00E1"+"veis",
"estrada", "estradais", "estradas", "estrado", "estrago", "estrais",
"estralo", "estrambelho", "estrampalho", "estrangeira", "estrangeiras", "estrangeiro",
"estrangul"+u"\u00E1"+"veis", "estranha", "estranhas", "estranh"+u"\u00E1"+"veis", "estranho", "estratific"+u"\u00E1"+"veis",
"estrebuch"+u"\u00E1"+"veis", "estreita", "estreitas", "estreit"+u"\u00E1"+"veis", "estreito", "estrela",
"estrelas", "estrelico", "estrelou"+u"\u00E7"+"o", "estrema", "estremadura", "estremaduras",
"estremas", "estrem"+u"\u00E1"+"veis", "estribilho", "estribo", "estriga", "estrigas",
"estrimo", "estro", "estrobiliz"+u"\u00E1"+"veis", "estroixo", "estrombo", "estrondo",
"estrumais", "estrupido", "estrutura", "estruturais", "estruturas", "estrutur"+u"\u00E1"+"veis",
"estud"+u"\u00E1"+"veis", "estudo", "estufa", "estufas", "estultific"+u"\u00E1"+"veis", "estupida",
"estupidas", "estuprais", "estupr"+u"\u00E1"+"veis", "estupro", "esturrinho", "eteriz"+u"\u00E1"+"veis",
"eterna", "eternais", "eternas", "eterniz"+u"\u00E1"+"veis", "eterno", "eticiz"+u"\u00E1"+"veis",
"etilais", "etil"+u"\u00E1"+"veis", "etilo", "etiqueta", "etiquetas", "eufemiz"+u"\u00E1"+"veis",
"eva", "evacu"+u"\u00E1"+"veis", "evagin"+u"\u00E1"+"veis", "evais", "evangeliz"+u"\u00E1"+"veis", "evapor"+u"\u00E1"+"veis",
"evaporiz"+u"\u00E1"+"veis", "evapotranspir"+u"\u00E1"+"veis", "evas", "evidenciais", "evidenci"+u"\u00E1"+"veis", "evit"+u"\u00E1"+"veis",
"evo", "evoc"+u"\u00E1"+"veis", "evolucionais", "evolucion"+u"\u00E1"+"veis", "exager"+u"\u00E1"+"veis", "exagero",
"exal"+u"\u00E7"+u"\u00E1"+"veis", "exalo", "examin"+u"\u00E1"+"veis", "exar"+u"\u00E1"+"veis", "exaspero", "exausto",
"excecionais", "excecion"+u"\u00E1"+"veis", "excelsa", "excelsas", "excelso", "excepcionais",
"excepcion"+u"\u00E1"+"veis", "exceptu"+u"\u00E1"+"veis", "excetu"+u"\u00E1"+"veis", "excit"+u"\u00E1"+"veis", "exclam"+u"\u00E1"+"veis", "excogit"+u"\u00E1"+"veis",
"excomung"+u"\u00E1"+"veis", "excomunhais", "excomunh"+u"\u00E1"+"veis", "excremento", "exculp"+u"\u00E1"+"veis", "excurso",
"execr"+u"\u00E1"+"veis", "execut"+u"\u00E1"+"veis", "exemplariz"+u"\u00E1"+"veis", "exemplific"+u"\u00E1"+"veis", "exemplo", "exercit"+u"\u00E1"+"veis",
"exoner"+u"\u00E1"+"veis", "exor"+u"\u00E1"+"veis", "exorbit"+u"\u00E1"+"veis", "exorcism"+u"\u00E1"+"veis", "exorcismo", "exorciz"+u"\u00E1"+"veis",
"exordiais", "exorn"+u"\u00E1"+"veis", "exort"+u"\u00E1"+"veis", "expatri"+u"\u00E1"+"veis", "expect"+u"\u00E1"+"veis", "experienciais",
"experimentais", "experiment"+u"\u00E1"+"veis", "experimento", "expet"+u"\u00E1"+"veis", "expi"+u"\u00E1"+"veis", "expiro",
"explan"+u"\u00E1"+"veis", "explant"+u"\u00E1"+"veis", "explic"+u"\u00E1"+"veis", "explicit"+u"\u00E1"+"veis", "explor"+u"\u00E1"+"veis", "exponenciais",
"export"+u"\u00E1"+"veis", "express"+u"\u00E1"+"veis", "expresso", "exprobr"+u"\u00E1"+"veis", "expropri"+u"\u00E1"+"veis", "expugn"+u"\u00E1"+"veis",
"expuls"+u"\u00E1"+"veis", "expulso", "expurg"+u"\u00E1"+"veis", "expurgo", "exsic"+u"\u00E1"+"veis", "exsud"+u"\u00E1"+"veis",
"extenu"+u"\u00E1"+"veis", "exterioriz"+u"\u00E1"+"veis", "extermin"+u"\u00E1"+"veis", "externa", "externas", "externo",
"extirp"+u"\u00E1"+"veis", "extracto", "extradit"+u"\u00E1"+"veis", "extrapol"+u"\u00E1"+"veis", "extrato", "extravaso",
"extravio", "extrema", "extremais", "extremas", "extrem"+u"\u00E1"+"veis", "extremo",
"extric"+u"\u00E1"+"veis", "extrofi"+u"\u00E1"+"veis", "exult"+u"\u00E1"+"veis", "exurbaniz"+u"\u00E1"+"veis", "fabric"+u"\u00E1"+"veis", "faccionais",
"faceira", "faceiras", "faceiro", "faceta", "facetas", "facha",
"fachas", "facho", "facilit"+u"\u00E1"+"veis", "facult"+u"\u00E1"+"veis", "fada", "fadas",
"fadiga", "fadigas", "fadistais", "fado", "fagais", "fago",
"fagulha", "fagulhas", "faia", "faiais", "faias", "fajuto",
"fala"+u"\u00E7"+"o", "falado", "falco", "falho", "falo", "falsa",
"falsas", "falsific"+u"\u00E1"+"veis", "falto", "familiariz"+u"\u00E1"+"veis", "fanais", "fanatiz"+u"\u00E1"+"veis",
"fandango", "fanfarra", "fanfarras", "fanfarronais", "fanicho", "fanico",
"fantasia", "fantasias", "fantasmais", "fanuco", "farda", "fardas",
"fardo", "farelo", "farfalha", "farfalhas", "farinha", "farinhas",
"faro", "farpa", "farpas", "farra", "farrapo", "farras",
"farta", "fartas", "fart"+u"\u00E1"+"veis", "farto", "fasquia", "fasquias",
"fastigiais", "fasto", "fatig"+u"\u00E1"+"veis", "fatura", "faturas", "fatur"+u"\u00E1"+"veis",
"fava", "favais", "favas", "favo", "favorita", "favoritas",
"favorito", "faxina", "faxinas", "fechais", "fecho", "fecund"+u"\u00E1"+"veis",
"fecundo", "fedelha", "fedelhas", "fedelho", "federais", "fedonho",
"feira", "feirais", "feiras", "feita", "feitais", "feitas",
"feitio", "feito", "feitoria", "feitorias", "felicit"+u"\u00E1"+"veis", "felpa",
"felpas", "feltro", "feminiliz"+u"\u00E1"+"veis", "feminiz"+u"\u00E1"+"veis", "fenais", "fendrelho",
"fenestrais", "feno", "fenomenaliz"+u"\u00E1"+"veis", "feriais", "feri"+u"\u00E1"+"veis", "fermentais",
"ferment"+u"\u00E1"+"veis", "fermento", "ferrais", "ferramenta", "ferramentais", "ferramentas",
"ferro", "ferrolho", "fertiliz"+u"\u00E1"+"veis", "festa", "festas", "festej"+u"\u00E1"+"veis",
"festejo", "festina", "festinas", "festino", "fi"+u"\u00E1"+"veis", "ficha",
"fichas", "fich"+u"\u00E1"+"veis", "figa", "figas", "figo", "figura",
"figurais", "figuras", "figur"+u"\u00E1"+"veis", "fila", "filas", "filha",
"filhas", "filhastro", "filho", "filiais", "fili"+u"\u00E1"+"veis", "film"+u"\u00E1"+"veis",
"filo", "filosofais", "filtr"+u"\u00E1"+"veis", "filtro", "fina", "finais",
"finaliz"+u"\u00E1"+"veis", "financiais", "financi"+u"\u00E1"+"veis", "finas", "fin"+u"\u00E1"+"veis", "find"+u"\u00E1"+"veis",
"findo", "fino", "finta", "fintas", "fio", "firma",
"firmais", "firmas", "firm"+u"\u00E1"+"veis", "firro", "fiscaliz"+u"\u00E1"+"veis", "fissionais",
"fission"+u"\u00E1"+"veis", "fissura", "fissurais", "fissuras", "fistuliz"+u"\u00E1"+"veis", "fita",
"fitas", "fito", "fix"+u"\u00E1"+"veis", "fixo", "flagel"+u"\u00E1"+"veis", "flagelo",
"flaino", "flamej"+u"\u00E1"+"veis", "flauta", "flautas", "flavortiz"+u"\u00E1"+"veis", "flecha",
"flechais", "flechas", "flexionais", "flexion"+u"\u00E1"+"veis", "floco", "flora",
"florais", "floras", "floresta", "florestais", "florestas", "fluidais",
"fluidific"+u"\u00E1"+"veis", "fluidiz"+u"\u00E1"+"veis", "fluido", "flutu"+u"\u00E1"+"veis", "foca", "focais",
"focaliz"+u"\u00E1"+"veis", "focas", "focinho", "foco", "fofa", "fofas",
"fofo", "fofoca", "fofocas", "fogacho", "foicinho", "folcloriz"+u"\u00E1"+"veis",
"foleco", "folga", "folgas", "folha", "folhais", "folhas",
"folho", "folia", "folias", "fomento", "fonocardiograf"+u"\u00E1"+"veis", "forca",
"forcas", "forja", "forjas", "forj"+u"\u00E1"+"veis", "forjic"+u"\u00E1"+"veis", "formais",
"formaliz"+u"\u00E1"+"veis", "formato", "form"+u"\u00E1"+"veis", "formiga", "formigais", "formigas",
"formo", "formol"+u"\u00E1"+"veis", "formul"+u"\u00E1"+"veis", "forquilha", "forquilhas", "forra",
"forras", "forro", "forta"+u"\u00E7"+"o", "fortaleza", "fortalezas", "fortific"+u"\u00E1"+"veis",
"fortuna", "fortunas", "fosca", "foscas", "fosco", "fosfato",
"fossa", "fossas", "fosso", "fotoativo", "fotocopi"+u"\u00E1"+"veis", "fotodissoci"+u"\u00E1"+"veis",
"fotograv"+u"\u00E1"+"veis", "fotolito", "fotomultiplic"+u"\u00E1"+"veis", "fotossensibiliz"+u"\u00E1"+"veis", "foucinho", "fraca",
"fracas", "fracasso", "fraccion"+u"\u00E1"+"veis", "fracion"+u"\u00E1"+"veis", "fraco", "fragment"+u"\u00E1"+"veis",
"fragmento", "fralda", "fraldas", "francesa", "francesas", "frangalho",
"franja", "franjais", "franjas", "franquia", "franquias", "frasquinho",
"fraterniz"+u"\u00E1"+"veis", "fratura", "fraturas", "fratur"+u"\u00E1"+"veis", "fraud"+u"\u00E1"+"veis", "frauta",
"frautas", "frecha", "frechais", "frechas", "freira", "freirais",
"freiras", "frenais", "frequent"+u"\u00E1"+"veis", "frescais", "fresco", "freso",
"frevo", "friccionais", "friccion"+u"\u00E1"+"veis", "frigorific"+u"\u00E1"+"veis", "frisa", "frisas",
"friso", "frito", "froco", "froixo", "frontais", "fronteira",
"fronteiras", "fronteiro", "frouxa", "frouxas", "frouxo", "frulho",
"frustr"+u"\u00E1"+"veis", "fruta", "frutais", "frutas", "frutific"+u"\u00E1"+"veis", "fruto",
"fu"+u"\u00E7"+"a", "fu"+u"\u00E7"+"as", "fueiro", "fuga", "fugas", "fulgurais",
"fulmin"+u"\u00E1"+"veis", "fuma"+u"\u00E7"+"a", "fuma"+u"\u00E7"+"as", "fumais", "fum"+u"\u00E1"+"veis", "fumo",
"funcionais", "funcionaliz"+u"\u00E1"+"veis", "funda", "fundais", "fundalho", "fundamentais",
"fundament"+u"\u00E1"+"veis", "fundamento", "fundas", "fund"+u"\u00E1"+"veis", "fundilho", "fundo",
"funesta", "funestas", "funesto", "funfo", "fungo", "furais",
"fur"+u"\u00E1"+"veis", "furo", "furto", "fusco", "fuso", "fustig"+u"\u00E1"+"veis",
"futric"+u"\u00E1"+"veis", "futura", "futuras", "futur"+u"\u00E1"+"veis", "futuriz"+u"\u00E1"+"veis", "futuro",
"fuzil"+u"\u00E1"+"veis", "gabarito", "gadanho", "gadi"+u"\u00E7"+"o", "gaia", "gaiais",
"gaias", "gaiata", "gaiatas", "gaiato", "gaio", "gaita",
"gaitas", "gaja", "gajas", "gajo", "gala", "galas",
"galgais", "galgo", "galhofa", "galhofas", "galicismo", "galimo",
"galinha", "galinhas", "galinho", "galo", "galricho", "galvaniz"+u"\u00E1"+"veis",
"gamenho", "gancho", "gan"+u"\u00E7"+"o", "gandaia", "gandaias", "gangorra",
"gangorras", "gangrena", "gangrenas", "ganh"+u"\u00E1"+"veis", "ganho", "garatuja",
"garatujas", "garfo", "gargais", "gargalejo", "gargarejo", "garimp"+u"\u00E1"+"veis",
"garimpo", "garino", "garota", "garotais", "garotas", "garoto",
"garra", "garramo", "garrancho", "garras", "garrido", "garro",
"garrocha", "garrochas", "garrota", "garrotas", "garrucha", "garruchas",
"garrula", "garrulas", "garrulejo", "gaseific"+u"\u00E1"+"veis", "gasific"+u"\u00E1"+"veis", "gast"+u"\u00E1"+"veis",
"gasto", "gata", "gatafunho", "gatais", "gatas", "gatinho",
"gato", "gatuno", "gaudero", "geba", "gebas", "gelatina",
"gelatinas", "gelatiniz"+u"\u00E1"+"veis", "geleific"+u"\u00E1"+"veis", "gelific"+u"\u00E1"+"veis", "gelo", "gema",
"gemas", "gemelgo", "gemin"+u"\u00E1"+"veis", "generaliz"+u"\u00E1"+"veis", "gerais", "gerenciais",
"gerenci"+u"\u00E1"+"veis", "germana", "germanais", "germanas", "germaniz"+u"\u00E1"+"veis", "germano",
"germinais", "germin"+u"\u00E1"+"veis", "gessais", "gesso", "gestion"+u"\u00E1"+"veis", "gesto",
"gingro", "giro", "glicerina", "glicerinas", "globaliz"+u"\u00E1"+"veis", "gloriais",
"glorific"+u"\u00E1"+"veis", "glos"+u"\u00E1"+"veis", "goela", "goelas", "goio", "gola",
"golas", "golfo", "golo", "goma", "gomais", "gomas",
"gom"+u"\u00E1"+"veis", "gomo", "gongo", "gorais", "gordura", "gordurais",
"gorduras", "gorgorejo", "gorra", "gorras", "gorro", "gost"+u"\u00E1"+"veis",
"gosto", "governais", "govern"+u"\u00E1"+"veis", "governicho", "governo", "goz"+u"\u00E1"+"veis",
"gozo", "gracejo", "graduais", "gradu"+u"\u00E1"+"veis", "grafo", "graio",
"gralha", "gralhas", "gramais", "gramaticais", "gramaticaliz"+u"\u00E1"+"veis", "gramatic"+u"\u00E1"+"veis",
"gramofono", "grampo", "grana", "granais", "granas", "granido",
"granito", "granizo", "gratific"+u"\u00E1"+"veis", "grav"+u"\u00E1"+"veis", "graveto", "gravitais",
"gravit"+u"\u00E1"+"veis", "gravura", "gravuras", "grelha", "grelhas", "grelh"+u"\u00E1"+"veis",
"grelo", "greta", "gretas", "grifo", "grila", "grilas",
"grilheta", "grilhetas", "grilo", "grimpa", "grimpas", "grinalda",
"grinaldas", "grinfo", "gripais", "grisalha", "grisalhas", "grisalho",
"grito", "grogolejo", "gromo", "grumo", "grupais", "grupo",
"guard"+u"\u00E1"+"veis", "guarita", "guaritas", "guasca", "guascas", "guedelha",
"guedelhas", "guedelho", "guerrilha", "guerrilhas", "guida", "guidas",
"guilhotina", "guilhotinas", "guinais", "guincho", "guisa", "guisas",
"guizo", "gulosa", "gulosas", "guloseima", "guloseimas", "guloso",
"guto", "habilit"+u"\u00E1"+"veis", "habit"+u"\u00E1"+"veis", "habituais", "halito", "halogen"+u"\u00E1"+"veis",
"halogenoderiv"+u"\u00E1"+"veis", "harmoniz"+u"\u00E1"+"veis", "harpa", "harpas", "heliporto", "hemaglutin"+u"\u00E1"+"veis",
"hemossedimentais", "herd"+u"\u00E1"+"veis", "heresia", "heresias", "herniais", "heteroaglutin"+u"\u00E1"+"veis",
"heterocarreg"+u"\u00E1"+"veis", "heteroimuniz"+u"\u00E1"+"veis", "heteropolimeriz"+u"\u00E1"+"veis", "heterossugestionais", "heterossugestion"+u"\u00E1"+"veis", "heterotransplant"+u"\u00E1"+"veis",
"hibernais", "hibrid"+u"\u00E1"+"veis", "hibridiz"+u"\u00E1"+"veis", "hidrat"+u"\u00E1"+"veis", "hidrato", "hidrocarbon"+u"\u00E1"+"veis",
"hidrocarbono", "hidrolis"+u"\u00E1"+"veis", "hidroport"+u"\u00E1"+"veis", "hidroporto", "hidroxideriv"+u"\u00E1"+"veis", "hierarquiz"+u"\u00E1"+"veis",
"hiperajust"+u"\u00E1"+"veis", "hiperaplic"+u"\u00E1"+"veis", "hiperativo", "hiperboliz"+u"\u00E1"+"veis", "hipercomplexo", "hiperestrutur"+u"\u00E1"+"veis",
"hiperexplor"+u"\u00E1"+"veis", "hiperimpregn"+u"\u00E1"+"veis", "hiperimuniz"+u"\u00E1"+"veis", "hiperindustriais", "hiperindustrializ"+u"\u00E1"+"veis", "hiperirrit"+u"\u00E1"+"veis",
"hiperocup"+u"\u00E1"+"veis", "hiperpigmentais", "hiperpigmento", "hipersensibiliz"+u"\u00E1"+"veis", "hipertrofia", "hipertrofiais",
"hipertrofias", "hiperurbaniz"+u"\u00E1"+"veis", "hipervasculariz"+u"\u00E1"+"veis", "hipnotiz"+u"\u00E1"+"veis", "hipossensibiliz"+u"\u00E1"+"veis", "hipoteca",
"hipotecas", "hipotec"+u"\u00E1"+"veis", "hirta", "hirtas", "hirto", "histocompatibiliz"+u"\u00E1"+"veis",
"histodiferenciais", "historiais", "historiciz"+u"\u00E1"+"veis", "holocausto", "homeotransplant"+u"\u00E1"+"veis", "homilia",
"homilias", "homolog"+u"\u00E1"+"veis", "homopolimeriz"+u"\u00E1"+"veis", "homotransplant"+u"\u00E1"+"veis", "honesta", "honestas",
"honesto", "honor"+u"\u00E1"+"veis", "honra", "honras", "honr"+u"\u00E1"+"veis", "hora",
"horais", "horas", "horizontais", "horripil"+u"\u00E1"+"veis", "horroriz"+u"\u00E1"+"veis", "horta",
"hortas", "hortejo", "horto", "hospedais", "hosped"+u"\u00E1"+"veis", "hostiliz"+u"\u00E1"+"veis",
"hulhific"+u"\u00E1"+"veis", "humana", "humanais", "humanas", "humaniz"+u"\u00E1"+"veis", "humano",
"humilh"+u"\u00E1"+"veis", "iberiz"+u"\u00E1"+"veis", "ichacorvo", "idealiz"+u"\u00E1"+"veis", "identific"+u"\u00E1"+"veis", "ideologiz"+u"\u00E1"+"veis",
"idolatr"+u"\u00E1"+"veis", "idolatriz"+u"\u00E1"+"veis", "ignific"+u"\u00E1"+"veis", "ignor"+u"\u00E1"+"veis", "igual"+u"\u00E1"+"veis", "igualiz"+u"\u00E1"+"veis",
"ilegitim"+u"\u00E1"+"veis", "ilha", "ilhais", "ilhas", "ilib"+u"\u00E1"+"veis", "ilimit"+u"\u00E1"+"veis",
"ilumin"+u"\u00E1"+"veis", "ilustr"+u"\u00E1"+"veis", "iluviais", "imaginais", "imagin"+u"\u00E1"+"veis", "imanentiz"+u"\u00E1"+"veis",
"imant"+u"\u00E1"+"veis", "imaterializ"+u"\u00E1"+"veis", "imbondo", "imediata", "imediatas", "imediato",
"imerso", "imit"+u"\u00E1"+"veis", "imobiliz"+u"\u00E1"+"veis", "imol"+u"\u00E1"+"veis", "imortaliz"+u"\u00E1"+"veis", "impacto",
"impermeabiliz"+u"\u00E1"+"veis", "impetr"+u"\u00E1"+"veis", "implant"+u"\u00E1"+"veis", "implement"+u"\u00E1"+"veis", "implemento", "implic"+u"\u00E1"+"veis",
"implor"+u"\u00E1"+"veis", "import"+u"\u00E1"+"veis", "importun"+u"\u00E1"+"veis", "importuno", "imposto", "impostura",
"imposturas", "imprec"+u"\u00E1"+"veis", "imprecis"+u"\u00E1"+"veis", "impreciso", "impregn"+u"\u00E1"+"veis", "impremedit"+u"\u00E1"+"veis",
"imprensa", "imprensas", "imprens"+u"\u00E1"+"veis", "impression"+u"\u00E1"+"veis", "impronto", "impronunci"+u"\u00E1"+"veis",
"improporcionais", "improporcion"+u"\u00E1"+"veis", "improv"+u"\u00E1"+"veis", "improvis"+u"\u00E1"+"veis", "improviso", "impugn"+u"\u00E1"+"veis",
"impulsionais", "impulsivo", "impulso", "imput"+u"\u00E1"+"veis", "imunda", "imundas",
"imundo", "imuniz"+u"\u00E1"+"veis", "imut"+u"\u00E1"+"veis", "inabit"+u"\u00E1"+"veis", "inadapt"+u"\u00E1"+"veis", "inal"+u"\u00E1"+"veis",
"inalien"+u"\u00E1"+"veis", "inalter"+u"\u00E1"+"veis", "inanimo", "inativo", "inaugurais", "inaugur"+u"\u00E1"+"veis",
"incapacit"+u"\u00E1"+"veis", "incapsul"+u"\u00E1"+"veis", "incaracteriz"+u"\u00E1"+"veis", "incenso", "incentiv"+u"\u00E1"+"veis", "incentivo",
"incerta", "incertas", "incerto", "incesto", "incidentais", "inciner"+u"\u00E1"+"veis",
"inciso", "incit"+u"\u00E1"+"veis", "inclin"+u"\u00E1"+"veis", "incoloro", "incomod"+u"\u00E1"+"veis", "incompatibiliz"+u"\u00E1"+"veis",
"incomunic"+u"\u00E1"+"veis", "inconform"+u"\u00E1"+"veis", "inconfort"+u"\u00E1"+"veis", "inconsolid"+u"\u00E1"+"veis", "incontest"+u"\u00E1"+"veis", "incorporais",
"incorpor"+u"\u00E1"+"veis", "incrementais", "increment"+u"\u00E1"+"veis", "incremento", "increp"+u"\u00E1"+"veis", "incrimin"+u"\u00E1"+"veis",
"incrust"+u"\u00E1"+"veis", "incub"+u"\u00E1"+"veis", "inculc"+u"\u00E1"+"veis", "inculp"+u"\u00E1"+"veis", "indag"+u"\u00E1"+"veis", "indelimit"+u"\u00E1"+"veis",
"indemniz"+u"\u00E1"+"veis", "indeniz"+u"\u00E1"+"veis", "indetect"+u"\u00E1"+"veis", "indetermin"+u"\u00E1"+"veis", "index"+u"\u00E1"+"veis", "indigesta",
"indigestas", "indigesto", "indigit"+u"\u00E1"+"veis", "indigna", "indignas", "indign"+u"\u00E1"+"veis",
"indigno", "indisciplina", "indisciplinas", "indisciplin"+u"\u00E1"+"veis", "indiscrimin"+u"\u00E1"+"veis", "individuais",
"indocument"+u"\u00E1"+"veis", "indult"+u"\u00E1"+"veis", "indulto", "indumento", "industriais", "industrializ"+u"\u00E1"+"veis",
"industri"+u"\u00E1"+"veis", "inebri"+u"\u00E1"+"veis", "inequacionais", "inequacion"+u"\u00E1"+"veis", "inerciais", "inespoli"+u"\u00E1"+"veis",
"infam"+u"\u00E1"+"veis", "infart"+u"\u00E1"+"veis", "infarto", "infecunda", "infecundas", "infecundo",
"inferioriz"+u"\u00E1"+"veis", "infernais", "inferno", "infertiliz"+u"\u00E1"+"veis", "infiltr"+u"\u00E1"+"veis", "infirm"+u"\u00E1"+"veis",
"infix"+u"\u00E1"+"veis", "inflacionais", "inflacion"+u"\u00E1"+"veis", "inflam"+u"\u00E1"+"veis", "inflamo", "infl"+u"\u00E1"+"veis",
"inflexionais", "inflexion"+u"\u00E1"+"veis", "influenciais", "influenci"+u"\u00E1"+"veis", "informais", "informatiz"+u"\u00E1"+"veis",
"infundament"+u"\u00E1"+"veis", "infusa", "infusas", "infuso", "inglesa", "inglesas",
"ingresso", "ingurgit"+u"\u00E1"+"veis", "iniciais", "inicializ"+u"\u00E1"+"veis", "inici"+u"\u00E1"+"veis", "inigual"+u"\u00E1"+"veis",
"inimit"+u"\u00E1"+"veis", "inimiz"+u"\u00E1"+"veis", "injet"+u"\u00E1"+"veis", "injusti"+u"\u00E7"+"a", "injusti"+u"\u00E7"+"as", "injustific"+u"\u00E1"+"veis",
"inobserv"+u"\u00E1"+"veis", "inocent"+u"\u00E1"+"veis", "inocul"+u"\u00E1"+"veis", "inov"+u"\u00E1"+"veis", "inquieta", "inquietas",
"inquiet"+u"\u00E1"+"veis", "inquieto", "inquilina", "inquilinas", "inquilino", "inquin"+u"\u00E1"+"veis",
"insatur"+u"\u00E1"+"veis", "insemin"+u"\u00E1"+"veis", "insensibiliz"+u"\u00E1"+"veis", "inserto", "insinu"+u"\u00E1"+"veis", "insosso",
"inspecion"+u"\u00E1"+"veis", "inspir"+u"\u00E1"+"veis", "instabiliz"+u"\u00E1"+"veis", "instal"+u"\u00E1"+"veis", "inst"+u"\u00E1"+"veis", "instig"+u"\u00E1"+"veis",
"instil"+u"\u00E1"+"veis", "institucionaliz"+u"\u00E1"+"veis", "instrumentais", "instrumentaliz"+u"\u00E1"+"veis", "instrument"+u"\u00E1"+"veis", "instrumento",
"insubordin"+u"\u00E1"+"veis", "insufl"+u"\u00E1"+"veis", "insul"+u"\u00E1"+"veis", "insult"+u"\u00E1"+"veis", "insulto", "insumo",
"insurrecionais", "integrais", "integraliz"+u"\u00E1"+"veis", "integr"+u"\u00E1"+"veis", "inteira", "inteiras",
"inteir"+u"\u00E1"+"veis", "inteiri"+u"\u00E7"+"a", "inteiri"+u"\u00E7"+"as", "inteiri"+u"\u00E7"+"o", "inteiro", "intelectualiz"+u"\u00E1"+"veis",
"inteligenci"+u"\u00E1"+"veis", "intemper"+u"\u00E1"+"veis", "intemperiz"+u"\u00E1"+"veis", "intencionais", "intencion"+u"\u00E1"+"veis", "intensa",
"intensas", "intensific"+u"\u00E1"+"veis", "intensivo", "intenso", "intent"+u"\u00E1"+"veis", "intento",
"interatu"+u"\u00E1"+"veis", "intercal"+u"\u00E1"+"veis", "intercambiais", "intercambi"+u"\u00E1"+"veis", "intercept"+u"\u00E1"+"veis", "intercomunic"+u"\u00E1"+"veis",
"intercruz"+u"\u00E1"+"veis", "interdigitais", "interdigit"+u"\u00E1"+"veis", "interdimensionais", "interdit"+u"\u00E1"+"veis", "interdito",
"interessais", "interesterific"+u"\u00E1"+"veis", "interestratific"+u"\u00E1"+"veis", "interinfluenci"+u"\u00E1"+"veis", "interino", "interioriz"+u"\u00E1"+"veis",
"interjeccionais", "interjecionais", "interjectivo", "interjetivo", "intermigr"+u"\u00E1"+"veis", "interna",
"internacionaliz"+u"\u00E1"+"veis", "internais", "internas", "interno", "interoper"+u"\u00E1"+"veis", "interpel"+u"\u00E1"+"veis",
"interpenetr"+u"\u00E1"+"veis", "interpret"+u"\u00E1"+"veis", "interrog"+u"\u00E1"+"veis", "interseccionais", "intersect"+u"\u00E1"+"veis", "intertransform"+u"\u00E1"+"veis",
"interturb"+u"\u00E1"+"veis", "intervalo", "intestinais", "intestino", "intim"+u"\u00E1"+"veis", "intimid"+u"\u00E1"+"veis",
"intitul"+u"\u00E1"+"veis", "intoxic"+u"\u00E1"+"veis", "intranquiliz"+u"\u00E1"+"veis", "intransitivo", "introject"+u"\u00E1"+"veis", "introjet"+u"\u00E1"+"veis",
"intruido", "inum"+u"\u00E1"+"veis", "inund"+u"\u00E1"+"veis", "inutiliz"+u"\u00E1"+"veis", "invagin"+u"\u00E1"+"veis", "invalid"+u"\u00E1"+"veis",
"invari"+u"\u00E1"+"veis", "invectivo", "invej"+u"\u00E1"+"veis", "inventariais", "inventari"+u"\u00E1"+"veis", "invent"+u"\u00E1"+"veis",
"invento", "invernais", "invern"+u"\u00E1"+"veis", "inverno", "investig"+u"\u00E1"+"veis", "invetivo",
"inviabiliz"+u"\u00E1"+"veis", "invido", "invitais", "invoc"+u"\u00E1"+"veis", "involucrais", "iod"+u"\u00E1"+"veis",
"iodeto", "iodin"+u"\u00E1"+"veis", "iodo", "ioniz"+u"\u00E1"+"veis", "iriais", "irman"+u"\u00E1"+"veis",
"irracionaliz"+u"\u00E1"+"veis", "irradiais", "irrealiz"+u"\u00E1"+"veis", "irreconcili"+u"\u00E1"+"veis", "irresponsabiliz"+u"\u00E1"+"veis", "irrig"+u"\u00E1"+"veis",
"irrit"+u"\u00E1"+"veis", "irrog"+u"\u00E1"+"veis", "isca", "iscas", "isent"+u"\u00E1"+"veis", "isento",
"islamiz"+u"\u00E1"+"veis", "isola", "isolas", "isol"+u"\u00E1"+"veis", "italianiz"+u"\u00E1"+"veis", "iter"+u"\u00E1"+"veis",
"jana", "janais", "janas", "janela", "janelas", "janelo",
"jango", "jano", "janota", "janotas", "janta", "jantas",
"japonesa", "japonesas", "japoniz"+u"\u00E1"+"veis", "jardo", "jarreta", "jarretas",
"jarundo", "jato", "jeito", "jeremiais", "joelho", "jog"+u"\u00E1"+"veis",
"jogo", "jorro", "judia", "judias", "judiciais", "jugado",
"jugais", "jugo", "jugul"+u"\u00E1"+"veis", "julg"+u"\u00E1"+"veis", "juncais", "junco",
"junta", "juntas", "junt"+u"\u00E1"+"veis", "junto", "jura", "jurament"+u"\u00E1"+"veis",
"juramento", "juras", "jurema", "juremais", "juremas", "juremo",
"juridiciz"+u"\u00E1"+"veis", "jurisdicionais", "juro", "justa", "justas", "justi"+u"\u00E7"+"a",
"justi"+u"\u00E7"+"as", "justi"+u"\u00E7"+u"\u00E1"+"veis", "justific"+u"\u00E1"+"veis", "justo", "juveniliz"+u"\u00E1"+"veis", "labanot"+u"\u00E1"+"veis",
"labelo", "labirinto", "laborais", "labor"+u"\u00E1"+"veis", "labrego", "labresto",
"labuta", "labutas", "laca", "lacaio", "lacas", "lacer"+u"\u00E1"+"veis",
"la"+u"\u00E7"+"o", "lacramo", "lacrimais", "lacrim"+u"\u00E1"+"veis", "lacuna", "lacunas",
"ladeira", "ladeiras", "ladeiro", "ladra", "ladrais", "ladras",
"ladrilho", "ladripo", "ladroeira", "ladroeiras", "lagrimais", "lagrim"+u"\u00E1"+"veis",
"laivo", "laja", "lajas", "lamba", "lambarisco", "lambas",
"lameirais", "lameiro", "lament"+u"\u00E1"+"veis", "lamento", "laminais", "lamin"+u"\u00E1"+"veis",
"lamino", "lampa", "lampas", "lampejo", "lampo", "lan"+u"\u00E7"+u"\u00E1"+"veis",
"lanceta", "lancetas", "lancet"+u"\u00E1"+"veis", "lanchais", "lancissond"+u"\u00E1"+"veis", "lan"+u"\u00E7"+"o",
"lanh"+u"\u00E1"+"veis", "lanterna", "lanternas", "lapa", "lapas", "lapid"+u"\u00E1"+"veis",
"larga", "largas", "largo", "laringograf"+u"\u00E1"+"veis", "larva", "larvais",
"larvas", "lasca", "lascas", "lassa", "lassas", "lastim"+u"\u00E1"+"veis",
"lastro", "latejo", "latina", "latinas", "latiniz"+u"\u00E1"+"veis", "latino",
"latitudinais", "lavajo", "lav"+u"\u00E1"+"veis", "lavego", "lavor"+u"\u00E1"+"veis", "lavoura",
"lavouras", "lavra", "lavras", "lavr"+u"\u00E1"+"veis", "lavujo", "lazeira",
"lazeiras", "leccionais", "leccion"+u"\u00E1"+"veis", "lecionais", "lecion"+u"\u00E1"+"veis", "legais",
"legaliz"+u"\u00E1"+"veis", "legenda", "legendas", "legifer"+u"\u00E1"+"veis", "legisl"+u"\u00E1"+"veis", "legitim"+u"\u00E1"+"veis",
"leigais", "leigo", "leilo"+u"\u00E1"+"veis", "leitais", "leito", "lembo",
"lembr"+u"\u00E1"+"veis", "lengalenga", "lengalengas", "lenha", "lenhais", "lenhas",
"lenho", "lenific"+u"\u00E1"+"veis", "lenimento", "lenta", "lentas", "lento",
"les"+u"\u00E1"+"veis", "lesionais", "lesma", "lesmas", "letra", "letras",
"letro", "lev"+u"\u00E1"+"veis", "lexicaliz"+u"\u00E1"+"veis", "li"+u"\u00E1"+"veis", "lib"+u"\u00E1"+"veis", "libelo",
"liberais", "liberaliz"+u"\u00E1"+"veis", "liberto", "libra", "libras", "libr"+u"\u00E1"+"veis",
"licenciais", "licenci"+u"\u00E1"+"veis", "licit"+u"\u00E1"+"veis", "lida", "lidas", "lider"+u"\u00E1"+"veis",
"lidim"+u"\u00E1"+"veis", "lido", "ligais", "lig"+u"\u00E1"+"veis", "lima", "limas",
"lim"+u"\u00E1"+"veis", "limit"+u"\u00E1"+"veis", "limo", "limp"+u"\u00E1"+"veis", "limpo", "linco",
"linda", "lindas", "lindo", "linfa", "linfangiograf"+u"\u00E1"+"veis", "linfas",
"linfoangiograf"+u"\u00E1"+"veis", "linfolis"+u"\u00E1"+"veis", "linguarais", "linimento", "linotipo", "liofiliz"+u"\u00E1"+"veis",
"liquenific"+u"\u00E1"+"veis", "liquid"+u"\u00E1"+"veis", "liquidific"+u"\u00E1"+"veis", "lismo", "lisonja", "lisonjas",
"lista", "listas", "literariz"+u"\u00E1"+"veis", "literat"+u"\u00E1"+"veis", "literatiz"+u"\u00E1"+"veis", "literato",
"literatura", "literaturas", "litific"+u"\u00E1"+"veis", "litig"+u"\u00E1"+"veis", "livr"+u"\u00E1"+"veis", "livro",
"lixo", "lo"+u"\u00E1"+"veis", "loca", "locais", "localiz"+u"\u00E1"+"veis", "locas",
"loc"+u"\u00E1"+"veis", "locucionais", "locuplet"+u"\u00E1"+"veis", "logica", "logicais", "logicas",
"logo", "logr"+u"\u00E1"+"veis", "loira", "loiras", "loiro", "loisa",
"loisas", "lombilho", "lombriga", "lombrigas", "lorota", "lorotas",
"loto", "loura", "louras", "louro", "lousa", "lousas",
"louv"+u"\u00E1"+"veis", "lubrific"+u"\u00E1"+"veis", "lucila", "lucilas", "lucro", "lucubr"+u"\u00E1"+"veis",
"ludibri"+u"\u00E1"+"veis", "lupa", "lupas", "lupo", "lusco", "lusitaniz"+u"\u00E1"+"veis",
"lustrais", "lustr"+u"\u00E1"+"veis", "lustro", "lut"+u"\u00E1"+"veis", "luteiniz"+u"\u00E1"+"veis", "luto",
"luxo", "ma"+u"\u00E7"+"a", "macaca", "macacais", "macacas", "macaco",
"ma"+u"\u00E7"+"ais", "ma"+u"\u00E7"+"aneta", "ma"+u"\u00E7"+"anetas", "ma"+u"\u00E7"+"aroca", "ma"+u"\u00E7"+"arocas", "ma"+u"\u00E7"+"as",
"macavenco", "macer"+u"\u00E1"+"veis", "machado", "machiais", "machuc"+u"\u00E1"+"veis", "macia",
"macias", "macio", "ma"+u"\u00E7"+"o", "maconha", "maconhas", "macrossegmento",
"macuco", "macul"+u"\u00E1"+"veis", "madeira", "madeirais", "madeiras", "madeir"+u"\u00E1"+"veis",
"madeiro", "madeixa", "madeixas", "madra"+u"\u00E7"+"ais", "madraceiro", "madurais",
"madur"+u"\u00E1"+"veis", "maduro", "magia", "magias", "magica", "magicas",
"magnetiz"+u"\u00E1"+"veis", "magnifica", "magnificas", "magnific"+u"\u00E1"+"veis", "mago"+u"\u00E1"+"veis", "magulho",
"maio", "majorais", "major"+u"\u00E1"+"veis", "mala", "malabariz"+u"\u00E1"+"veis", "malandro",
"malas", "malbarat"+u"\u00E1"+"veis", "maleabiliz"+u"\u00E1"+"veis", "malha", "malhais", "malhas",
"malho", "malici"+u"\u00E1"+"veis", "maligna", "malignas", "maligniz"+u"\u00E1"+"veis", "maligno",
"maloca", "malocas", "malogr"+u"\u00E1"+"veis", "malogro", "malseguro", "malsin"+u"\u00E1"+"veis",
"malta", "maltas", "maltoso", "maluca", "malucas", "maluco",
"malvers"+u"\u00E1"+"veis", "mama", "mamais", "mamas", "mana", "manas",
"mancais", "manco", "mancomun"+u"\u00E1"+"veis", "mand"+u"\u00E1"+"veis", "mandinga", "mandingas",
"mando", "manduca", "manducas", "manduc"+u"\u00E1"+"veis", "maneira", "maneiras",
"maneir"+u"\u00E1"+"veis", "manej"+u"\u00E1"+"veis", "manejo", "manga", "mangaba", "mangabais",
"mangabas", "mangais", "mangas", "manhento", "manhoso", "manifest"+u"\u00E1"+"veis",
"manifesto", "manilha", "manilhas", "maninho", "manipul"+u"\u00E1"+"veis",
"manivela", "manivelas", "manj"+u"\u00E1"+"veis", "manjerico", "mano", "manobr"+u"\u00E1"+"veis",
"manufacto", "manufactur"+u"\u00E1"+"veis", "manufato", "manufatur"+u"\u00E1"+"veis", "maqui"+u"\u00E1"+"veis", "maquinais",
"maquin"+u"\u00E1"+"veis", "marafo", "marasmo", "maravilha", "maravilhas", "maravilh"+u"\u00E1"+"veis",
"marca", "marcas", "marceneiro", "marcha", "marchais", "marchas",
"marchet"+u"\u00E1"+"veis", "marco", "marfolho", "marginais", "marginaliz"+u"\u00E1"+"veis", "maridais",
"marido", "marina", "marinas", "marinheiro", "marinho", "mariola",
"mariolas", "marisco", "marmelo", "marmo", "marmoriz"+u"\u00E1"+"veis", "marquesa",
"marquesais", "marquesas", "marrancho", "marreta", "marretas", "marroquino",
"marruco", "martel"+u"\u00E1"+"veis", "martelo", "martiriz"+u"\u00E1"+"veis", "maruja", "marujais",
"marujas", "marujo", "masca", "mascabo", "mascar"+u"\u00E1"+"veis", "mascas",
"mascavo", "masculiniz"+u"\u00E1"+"veis", "massa", "massacr"+u"\u00E1"+"veis", "massais", "massas",
"massific"+u"\u00E1"+"veis", "mastig"+u"\u00E1"+"veis", "masturb"+u"\u00E1"+"veis", "matais", "materializ"+u"\u00E1"+"veis", "maticais",
"matilha", "matilhas", "matinais", "matiz"+u"\u00E1"+"veis", "mato", "matraca",
"matracas", "matreiro", "matricul"+u"\u00E1"+"veis", "matrimoniais", "matrimoni"+u"\u00E1"+"veis", "matur"+u"\u00E1"+"veis",
"matuto", "maximiz"+u"\u00E1"+"veis", "maxixais", "mazurca", "mazurcas", "mealho",
"meandro", "mecaniz"+u"\u00E1"+"veis", "mecha", "mechas", "medalha", "medalhas",
"mediatiz"+u"\u00E1"+"veis", "medicais", "medicamento", "medic"+u"\u00E1"+"veis", "medicina", "medicinais",
"medicinas", "medievaliz"+u"\u00E1"+"veis", "medit"+u"\u00E1"+"veis", "meiga", "meigas", "meigo",
"meirinho", "melhor"+u"\u00E1"+"veis", "melific"+u"\u00E1"+"veis", "melindr"+u"\u00E1"+"veis", "melodia", "melodias",
"melodiz"+u"\u00E1"+"veis", "memor"+u"\u00E1"+"veis", "memoriais", "memori"+u"\u00E1"+"veis", "memoriz"+u"\u00E1"+"veis", "mencion"+u"\u00E1"+"veis",
"mendic"+u"\u00E1"+"veis", "mendiga", "mendigas", "mendig"+u"\u00E1"+"veis", "mendigo", "meno",
"menoscab"+u"\u00E1"+"veis", "menoscabo", "menosprez"+u"\u00E1"+"veis", "menosprezo", "menstruais", "mensurais",
"mensur"+u"\u00E1"+"veis", "mentais", "mentaliz"+u"\u00E1"+"veis", "ment"+u"\u00E1"+"veis", "mentira", "mentiras",
"mercadej"+u"\u00E1"+"veis", "mercadiz"+u"\u00E1"+"veis", "mercantiliz"+u"\u00E1"+"veis", "merc"+u"\u00E1"+"veis", "merenda", "merendais",
"merendas", "mergulh"+u"\u00E1"+"veis", "mergulho", "merujo", "mescais", "mesmeriz"+u"\u00E1"+"veis",
"mesquinho", "mesti"+u"\u00E7"+u"\u00E1"+"veis", "mesti"+u"\u00E7"+"o", "metaboliz"+u"\u00E1"+"veis", "metacomunic"+u"\u00E1"+"veis", "metaconglomer"+u"\u00E1"+"veis",
"metaforiz"+u"\u00E1"+"veis", "metalific"+u"\u00E1"+"veis", "metaliz"+u"\u00E1"+"veis", "metamorfiz"+u"\u00E1"+"veis", "metassediment"+u"\u00E1"+"veis", "metassedimento",
"metast"+u"\u00E1"+"veis", "metilais", "metil"+u"\u00E1"+"veis", "metodiz"+u"\u00E1"+"veis", "metralha", "metralhas",
"metralh"+u"\u00E1"+"veis", "metrific"+u"\u00E1"+"veis", "metro", "metrocistograf"+u"\u00E1"+"veis", "metropoliz"+u"\u00E1"+"veis", "mexerico",
"mexilho", "micho", "microbiais", "microcircul"+u"\u00E1"+"veis", "microcoagul"+u"\u00E1"+"veis", "microcopi"+u"\u00E1"+"veis",
"microfossiliz"+u"\u00E1"+"veis", "micromanipul"+u"\u00E1"+"veis", "micrometr"+u"\u00E1"+"veis", "micropotencializ"+u"\u00E1"+"veis", "microprocesso", "mieliniz"+u"\u00E1"+"veis",
"migalha", "migalhas", "migmatiz"+u"\u00E1"+"veis", "migr"+u"\u00E1"+"veis", "mijo", "milimetrais",
"militariz"+u"\u00E1"+"veis", "milit"+u"\u00E1"+"veis", "milonitiz"+u"\u00E1"+"veis", "mim"+u"\u00E1"+"veis", "mimetiz"+u"\u00E1"+"veis", "mimo",
"mina", "minas", "min"+u"\u00E1"+"veis", "minerais", "mineraliz"+u"\u00E1"+"veis", "miner"+u"\u00E1"+"veis",
"mingo", "minhoca", "minhocais", "minhocas", "miniatura", "miniaturais",
"miniaturas", "miniaturiz"+u"\u00E1"+"veis", "minific"+u"\u00E1"+"veis", "minimiz"+u"\u00E1"+"veis", "ministra", "ministrais",
"ministras", "ministr"+u"\u00E1"+"veis", "ministro", "minor"+u"\u00E1"+"veis", "minotauro", "minuta",
"minutas", "minuto", "mira", "miras", "mir"+u"\u00E1"+"veis", "mirra",
"mirras", "miser"+u"\u00E1"+"veis", "misgalho", "missa", "missais", "missas",
"mistific"+u"\u00E1"+"veis", "mistura", "misturas", "mistur"+u"\u00E1"+"veis", "mitific"+u"\u00E1"+"veis", "mitig"+u"\u00E1"+"veis",
"mitiz"+u"\u00E1"+"veis", "mitra", "mitrais", "mitras", "mix"+u"\u00E1"+"veis", "mixo",
"mnemoniz"+u"\u00E1"+"veis", "mobiliz"+u"\u00E1"+"veis", "moca", "mo"+u"\u00E7"+"a", "mocas", "mo"+u"\u00E7"+"as",
"mocho", "mo"+u"\u00E7"+"o", "modaliz"+u"\u00E1"+"veis", "model"+u"\u00E1"+"veis", "modelo", "moder"+u"\u00E1"+"veis",
"moderna", "modernas", "moderniz"+u"\u00E1"+"veis", "moderno", "modific"+u"\u00E1"+"veis", "modorra",
"modorrais", "modorras", "modul"+u"\u00E1"+"veis", "mofa", "mofas", "mofo",
"mofumbais", "moinho", "moira", "moirais", "moiras", "moiro",
"moita", "moitais", "moitas", "mojo", "mold"+u"\u00E1"+"veis", "moldura",
"molduras", "moleca", "molecas", "molejo", "molengo", "molest"+u"\u00E1"+"veis",
"molesto", "molh"+u"\u00E1"+"veis", "molho", "molific"+u"\u00E1"+"veis", "molinha", "molinhas",
"molinho", "momo", "monarquia", "monarquias", "monco", "mond"+u"\u00E1"+"veis",
"monetiz"+u"\u00E1"+"veis", "monidrat"+u"\u00E1"+"veis", "monidrato", "monitor"+u"\u00E1"+"veis", "monitoriz"+u"\u00E1"+"veis", "monoclor"+u"\u00E1"+"veis",
"monocloro", "monogramo", "monopoliz"+u"\u00E1"+"veis", "monossilaba", "monossilabas", "monotongo",
"mont"+u"\u00E1"+"veis", "morais", "moraliz"+u"\u00E1"+"veis", "morangais", "morango", "morcegais",
"morcego", "morda"+u"\u00E7"+"a", "morda"+u"\u00E7"+"as", "mordomo", "morfina", "morfinas",
"morfino", "morfo", "morfodiferenci"+u"\u00E1"+"veis", "moriger"+u"\u00E1"+"veis", "morna", "mornais",
"mornas", "morno", "morra"+u"\u00E7"+"ais", "morrinho", "mortalha", "mortalhas",
"mortific"+u"\u00E1"+"veis", "mosca", "moscas", "mosquito", "mostr"+u"\u00E1"+"veis", "motejo",
"moteto", "motiv"+u"\u00E1"+"veis", "motivo", "mouco", "moura", "mourais",
"mouras", "mourisco", "mouro", "moviment"+u"\u00E1"+"veis", "movimento", "moxamo",
"muda", "mudas", "mud"+u"\u00E1"+"veis", "mudo", "mufico", "mufumbo",
"mujimbo", "multiarticul"+u"\u00E1"+"veis", "multiplic"+u"\u00E1"+"veis", "multivari"+u"\u00E1"+"veis", "multivibr"+u"\u00E1"+"veis", "mumific"+u"\u00E1"+"veis",
"mundana", "mundanais", "mundanas", "mundano", "mundiais", "mundific"+u"\u00E1"+"veis",
"mungango", "munheca", "munhecas", "murais", "muralha", "muralhas",
"murcho", "murmurinho", "muro", "musgo", "musicais", "musicaliz"+u"\u00E1"+"veis",
"music"+u"\u00E1"+"veis", "mutarrot"+u"\u00E1"+"veis", "mutuais", "muxoxo", "nacionaliz"+u"\u00E1"+"veis", "nada", "nadais",
"nado", "namor"+u"\u00E1"+"veis", "namoricho", "namorico", "namoro", "nana",
"nanais", "nanas", "narciso", "narcotiz"+u"\u00E1"+"veis", "narr"+u"\u00E1"+"veis", "nasaliz"+u"\u00E1"+"veis",
"nastro", "natura", "naturais", "naturaliz"+u"\u00E1"+"veis", "naturas", "natur"+u"\u00E1"+"veis",
"naufrag"+u"\u00E1"+"veis", "navalha", "navalhas", "naveg"+u"\u00E1"+"veis", "neblina", "neblinas",
"nebrina", "nebrinas", "nebuliz"+u"\u00E1"+"veis", "necessit"+u"\u00E1"+"veis", "necros"+u"\u00E1"+"veis", "necrotiz"+u"\u00E1"+"veis",
"negativa", "negativas", "negativiz"+u"\u00E1"+"veis", "negativo", "neg"+u"\u00E1"+"veis", "negligenci"+u"\u00E1"+"veis",
"negociais", "negoci"+u"\u00E1"+"veis", "negrito", "neoform"+u"\u00E1"+"veis", "neologismo", "nesga",
"nesgas", "neuros"+u"\u00E1"+"veis", "neurotiz"+u"\u00E1"+"veis", "neutraliz"+u"\u00E1"+"veis", "nevoais", "nevoento",
"nicho", "nicotina", "nicotinas", "nicotin"+u"\u00E1"+"veis", "nicotino", "nicto",
"nimbo", "nina", "ninas", "ninhais", "ninho", "niponiz"+u"\u00E1"+"veis",
"nitrais", "nitrato", "nitreto", "nitroderiv"+u"\u00E1"+"veis", "nitros"+u"\u00E1"+"veis", "nitroso",
"nitruro", "nivel"+u"\u00E1"+"veis", "nobeliz"+u"\u00E1"+"veis", "nobilit"+u"\u00E1"+"veis", "nobiliz"+u"\u00E1"+"veis", "noca",
"nocas", "nodais", "nodo", "noiva", "noivais", "noivas",
"noivo", "nojo", "nomenclatura", "nomenclaturais", "nomenclaturas", "nominais",
"nomin"+u"\u00E1"+"veis", "normaliz"+u"\u00E1"+"veis", "notabiliz"+u"\u00E1"+"veis", "notais", "not"+u"\u00E1"+"veis", "notici"+u"\u00E1"+"veis",
"notific"+u"\u00E1"+"veis", "nova", "novais", "novas", "novela", "novelas",
"novelo", "novo", "nucleariz"+u"\u00E1"+"veis", "nulific"+u"\u00E1"+"veis", "numerais", "numer"+u"\u00E1"+"veis",
"nupciais", "obcec"+u"\u00E1"+"veis", "objeccionais", "objeccion"+u"\u00E1"+"veis", "objecionais", "objecion"+u"\u00E1"+"veis",
"objectific"+u"\u00E1"+"veis", "objectiv"+u"\u00E1"+"veis", "objetais", "objet"+u"\u00E1"+"veis", "objetific"+u"\u00E1"+"veis", "objetiv"+u"\u00E1"+"veis",
"objetivo", "objeto", "obliter"+u"\u00E1"+"veis", "obnubil"+u"\u00E1"+"veis", "obra", "obrada",
"obradas", "obrado", "obras", "obr"+u"\u00E1"+"veis", "obrig"+u"\u00E1"+"veis", "obsed"+u"\u00E1"+"veis",
"obsedi"+u"\u00E1"+"veis", "observ"+u"\u00E1"+"veis", "obsession"+u"\u00E1"+"veis", "obsoleta", "obsoletas", "obsoleto",
"obst"+u"\u00E1"+"veis", "obtemper"+u"\u00E1"+"veis", "obtur"+u"\u00E1"+"veis", "obvi"+u"\u00E1"+"veis", "oca", "ocas",
"ocasionais", "ocasion"+u"\u00E1"+"veis", "oc"+u"\u00E1"+"veis", "oco", "octanais", "octan"+u"\u00E1"+"veis",
"octano", "oculta", "ocultas", "ocult"+u"\u00E1"+"veis", "oculto", "ocup"+u"\u00E1"+"veis",
"oferenda", "oferendas", "ofert"+u"\u00E1"+"veis", "oficiais", "oficio", "ofusc"+u"\u00E1"+"veis",
"ogiva", "ogivais", "ogivas", "ogivo", "oiro", "oitava",
"oitavas", "oitavo", "ojeriza", "ojerizas", "oleado", "olfacto",
"olfato", "olhais", "olh"+u"\u00E1"+"veis", "olho", "oliva", "olivais",
"olivas", "olvid"+u"\u00E1"+"veis", "olvido", "onda", "ondas", "ondul"+u"\u00E1"+"veis",
"oner"+u"\u00E1"+"veis", "onzeneiro", "opaca", "opacas", "opaco", "opais",
"opalino", "op"+u"\u00E1"+"veis", "operacionaliz"+u"\u00E1"+"veis", "oper"+u"\u00E1"+"veis", "opin"+u"\u00E1"+"veis", "optimiz"+u"\u00E1"+"veis",
"opugn"+u"\u00E1"+"veis", "opulenta", "opulentas", "opulento", "ora", "orais",
"orbitais", "orbit"+u"\u00E1"+"veis", "or"+u"\u00E7"+"amentais", "or"+u"\u00E7"+"amento", "or"+u"\u00E7"+u"\u00E1"+"veis", "orden"+u"\u00E1"+"veis",
"orelha", "orelhas", "organific"+u"\u00E1"+"veis", "organiz"+u"\u00E1"+"veis", "organoform"+u"\u00E1"+"veis", "organofosfor"+u"\u00E1"+"veis",
"orgulho", "orientais", "orient"+u"\u00E1"+"veis", "originais", "originaliz"+u"\u00E1"+"veis", "origin"+u"\u00E1"+"veis",
"orla", "orlas", "ornamentais", "ornament"+u"\u00E1"+"veis", "ornamento", "orquestra",
"orquestrais", "orquestras", "ortiga", "ortigas", "ortopantomograf"+u"\u00E1"+"veis", "orvalho",
"oscil"+u"\u00E1"+"veis", "ostent"+u"\u00E1"+"veis", "otimiz"+u"\u00E1"+"veis", "ourela", "ourelas", "ouri"+u"\u00E7"+"o",
"ouro", "ous"+u"\u00E1"+"veis", "ousio", "outonais", "outono", "outorga",
"outorgas", "outorg"+u"\u00E1"+"veis", "ova", "ovais", "ovas", "ovo",
"oxid"+u"\u00E1"+"veis", "oxigen"+u"\u00E1"+"veis", "oxigeniz"+u"\u00E1"+"veis", "ozoniz"+u"\u00E1"+"veis", "pacific"+u"\u00E1"+"veis", "pacto",
"pactuais", "pactu"+u"\u00E1"+"veis", "padrais", "padrinho", "padroniz"+u"\u00E1"+"veis", "paganiz"+u"\u00E1"+"veis",
"pag"+u"\u00E1"+"veis", "pagin"+u"\u00E1"+"veis", "pago", "pair"+u"\u00E1"+"veis", "paivo", "paladino",
"palanco", "palataliz"+u"\u00E1"+"veis", "palatiz"+u"\u00E1"+"veis", "palavra", "palavras", "palestra",
"palestras", "paleta", "paletas", "palha", "palhais", "palhas",
"palheta", "palhetas", "palhi"+u"\u00E7"+"o", "paliais", "pali"+u"\u00E1"+"veis", "palito",
"palma", "palmais", "palmas", "palmo", "paloma", "palomas",
"palp"+u"\u00E1"+"veis", "palpo", "pana"+u"\u00E7"+"o", "panais", "pandais", "pando",
"panegiricais", "panfleto", "pango", "panific"+u"\u00E1"+"veis", "pano", "pantograf"+u"\u00E1"+"veis",
"pantomima", "pantomimas", "pantomim"+u"\u00E1"+"veis", "pantomimo", "papagaiais", "papagaio",
"papais", "paparico", "pap"+u"\u00E1"+"veis", "papo", "papoilais", "papouco",
"papoulais", "para", "paradoxais", "paradoxo", "parafuso", "parais",
"paraleliz"+u"\u00E1"+"veis", "paralis"+u"\u00E1"+"veis", "parament"+u"\u00E1"+"veis", "paramento", "parametriz"+u"\u00E1"+"veis", "paraninfo",
"parapeito", "parasito", "par"+u"\u00E1"+"veis", "parcela", "parcelas", "parcel"+u"\u00E1"+"veis",
"pardais", "pardejo", "pardo", "parelha", "parelhas", "parelho",
"parenta", "parentais", "parentas", "parlamento", "parolo", "paroquiais",
"parro", "parrono", "participais", "particip"+u"\u00E1"+"veis", "particulariz"+u"\u00E1"+"veis", "partilh"+u"\u00E1"+"veis",
"pascoais", "pasmo", "paspalho", "passais", "passarinho", "pass"+u"\u00E1"+"veis",
"passinho", "passivo", "passo", "pasta", "pastas", "pasteuriz"+u"\u00E1"+"veis",
"pastilha", "pastilhas", "pastinha", "pastinhas", "pasto", "pastorais",
"patego", "patin"+u"\u00E1"+"veis", "patinho", "patoilo", "patroa", "patroas",
"patrocinais", "patrocin"+u"\u00E1"+"veis", "patrulh"+u"\u00E1"+"veis", "paula", "paulas", "paulific"+u"\u00E1"+"veis",
"paurometaboliz"+u"\u00E1"+"veis", "pautais", "paut"+u"\u00E1"+"veis", "paviment"+u"\u00E1"+"veis", "pavimento", "pec"+u"\u00E1"+"veis",
"pecha", "pechas", "pe"+u"\u00E7"+"onhento", "peculiariz"+u"\u00E1"+"veis", "pedicelo", "pediment"+u"\u00E1"+"veis",
"pedimento", "pediplan"+u"\u00E1"+"veis", "pediplano", "pedra", "pedrais", "pedras",
"pega", "peganho", "pegas", "pego", "peido", "peito",
"pejo", "pela", "pelas", "peleja", "pelejas", "pelej"+u"\u00E1"+"veis",
"peletiz"+u"\u00E1"+"veis", "pelo", "pelotiz"+u"\u00E1"+"veis", "pena", "penacho", "penais",
"penas", "pen"+u"\u00E1"+"veis", "pendorais", "pendurais", "pendur"+u"\u00E1"+"veis", "pendurico",
"peneira", "peneiras", "peneir"+u"\u00E1"+"veis", "penetr"+u"\u00E1"+"veis", "penhor"+u"\u00E1"+"veis", "penico",
"penitenciais", "pensamento", "pens"+u"\u00E1"+"veis", "penso", "pentelho", "penumbra",
"penumbrais", "penumbras", "pepinais", "pepino", "pequinho", "peralvilho",
"perambul"+u"\u00E1"+"veis", "percais", "percal"+u"\u00E7"+"o", "percepcionais", "perceptualiz"+u"\u00E1"+"veis", "percevejo",
"percol"+u"\u00E1"+"veis", "perderiv"+u"\u00E1"+"veis", "perdigoto", "perdo"+u"\u00E1"+"veis", "perdur"+u"\u00E1"+"veis", "peregrina",
"peregrinais", "peregrinas", "peregrin"+u"\u00E1"+"veis", "peregrino", "perereca", "pererecas",
"perfilh"+u"\u00E1"+"veis", "perfur"+u"\u00E1"+"veis", "pergaminho", "pergunta", "perguntas", "pergunt"+u"\u00E1"+"veis",
"periciais", "perigo", "periodiz"+u"\u00E1"+"veis", "periquito", "perito", "perjur"+u"\u00E1"+"veis",
"perjuro", "perlong"+u"\u00E1"+"veis", "permineraliz"+u"\u00E1"+"veis", "permud"+u"\u00E1"+"veis", "permuta", "permutas",
"permut"+u"\u00E1"+"veis", "perorais", "peror"+u"\u00E1"+"veis", "perpass"+u"\u00E1"+"veis", "perpetr"+u"\u00E1"+"veis", "perpetuais",
"perpetu"+u"\u00E1"+"veis", "perscrut"+u"\u00E1"+"veis", "persever"+u"\u00E1"+"veis", "persign"+u"\u00E1"+"veis", "personaliz"+u"\u00E1"+"veis", "personific"+u"\u00E1"+"veis",
"perspectiva", "perspectivas", "perspectiv"+u"\u00E1"+"veis", "perspectivo", "perspetiv"+u"\u00E1"+"veis", "perspir"+u"\u00E1"+"veis",
"pertucho", "perturba", "perturbas", "perturb"+u"\u00E1"+"veis", "perua", "peruas",
"pes"+u"\u00E1"+"veis", "pesca", "pescais", "pescas", "peso", "pesquisa",
"pesquisas", "pessoaliz"+u"\u00E1"+"veis", "pestilenciais", "peta", "petais", "petanisco",
"petas", "peteca", "petecas", "petisco", "petrechais", "petrecho",
"petrific"+u"\u00E1"+"veis", "pezunho", "pia", "piacho", "piais", "pialo",
"pias", "picais", "picardia", "picardias", "pi"+u"\u00E7"+"arrais", "picirico",
"pico", "picuais", "pielograf"+u"\u00E1"+"veis", "pigais", "pigarro", "pigmento",
"pilha", "pilhas", "pilot"+u"\u00E1"+"veis", "piloto", "pimpolho", "pincho",
"pinga", "pingalho", "pingas", "pingo", "pino", "pinoco",
"pinta", "pintainho", "pintas", "pint"+u"\u00E1"+"veis", "pinto", "pio",
"piolho", "pior"+u"\u00E1"+"veis", "pipa", "pipais", "pipas", "pirais",
"piramidais", "piramid"+u"\u00E1"+"veis", "piramido", "pirilampo", "pirolis"+u"\u00E1"+"veis", "piso",
"pista", "pistas", "pita", "pitas", "piteira", "piteiras",
"piteiro", "pito", "plaino", "planej"+u"\u00E1"+"veis", "planetiz"+u"\u00E1"+"veis", "planific"+u"\u00E1"+"veis",
"planilha", "planilhas", "plano", "planta", "plantais", "plantas",
"plasm"+u"\u00E1"+"veis", "plasmolis"+u"\u00E1"+"veis", "plasticiz"+u"\u00E1"+"veis", "plastific"+u"\u00E1"+"veis", "platina", "platinas",
"plebiscito", "pleito", "plic"+u"\u00E1"+"veis", "pliss"+u"\u00E1"+"veis", "plot"+u"\u00E1"+"veis", "plug"+u"\u00E1"+"veis",
"pluma", "plumas", "plumbaginais", "pluraliz"+u"\u00E1"+"veis", "pluriestratific"+u"\u00E1"+"veis", "pluristratific"+u"\u00E1"+"veis",
"poda", "podais", "podas", "poeira", "poeiras", "poento",
"poiso", "polariz"+u"\u00E1"+"veis", "polca", "polcas", "polemica", "polemicas",
"policiais", "polici"+u"\u00E1"+"veis", "policit"+u"\u00E1"+"veis", "polimento", "poliniz"+u"\u00E1"+"veis", "polirramific"+u"\u00E1"+"veis",
"politiz"+u"\u00E1"+"veis", "politonais", "polpa", "polpas", "polvilhais", "pombeiro",
"ponderais", "ponder"+u"\u00E1"+"veis", "pontais", "pontificais", "pontinho", "ponto",
"pontuais", "pontu"+u"\u00E1"+"veis", "populariz"+u"\u00E1"+"veis", "pormenoriz"+u"\u00E1"+"veis", "pororoca", "pororocas",
"porta", "portais", "portas", "port"+u"\u00E1"+"veis", "porto", "portucho",
"portuguesa", "portuguesas", "posicionais", "posicion"+u"\u00E1"+"veis", "positiva", "positivas",
"positiv"+u"\u00E1"+"veis", "positivo", "possibilit"+u"\u00E1"+"veis", "postais", "post"+u"\u00E1"+"veis", "postemo",
"posterg"+u"\u00E1"+"veis", "posti"+u"\u00E7"+"o", "posto", "postul"+u"\u00E1"+"veis", "postura", "posturais",
"posturas", "potenciais", "potencializ"+u"\u00E1"+"veis", "potenci"+u"\u00E1"+"veis", "pousais", "pouso",
"povo"+u"\u00E1"+"veis", "praga", "pragais", "pragas", "pragmatiz"+u"\u00E1"+"veis", "praguej"+u"\u00E1"+"veis",
"prancha", "pranchas", "pranto", "pratic"+u"\u00E1"+"veis", "preamo", "prebendais",
"precal"+u"\u00E7"+"o", "precaucionais", "preceito", "preceituais", "precipit"+u"\u00E1"+"veis", "precisa",
"precisas", "preciso", "preconceituais", "precondicionais", "precondicion"+u"\u00E1"+"veis", "preconiz"+u"\u00E1"+"veis",
"predestin"+u"\u00E1"+"veis", "predetermin"+u"\u00E1"+"veis", "predicais", "predicamentais", "predicamento", "predic"+u"\u00E1"+"veis",
"predito", "prefaciais", "preferenciais", "prefigur"+u"\u00E1"+"veis", "prefiltro", "prefixais",
"prefixo", "prefoli"+u"\u00E1"+"veis", "pregalho", "preg"+u"\u00E1"+"veis", "pregn"+u"\u00E1"+"veis", "prego",
"prego"+u"\u00E1"+"veis", "pregui"+u"\u00E7"+"a", "pregui"+u"\u00E7"+"as", "preito", "prejudic"+u"\u00E1"+"veis", "prelaciais",
"prelaziais", "prelecion"+u"\u00E1"+"veis", "prelib"+u"\u00E1"+"veis", "preludiais", "prematuro", "premedit"+u"\u00E1"+"veis",
"prenda", "prendas", "prenominais", "prens"+u"\u00E1"+"veis", "prenunci"+u"\u00E1"+"veis", "prepar"+u"\u00E1"+"veis",
"preparo", "preponder"+u"\u00E1"+"veis", "preposicionais", "presa", "presas", "pres"+u"\u00E1"+"veis",
"prescruto", "presenciais", "presentific"+u"\u00E1"+"veis", "preserv"+u"\u00E1"+"veis", "presidiais", "presigo",
"presilha", "presilhas", "preso", "pressionais", "pression"+u"\u00E1"+"veis", "pressuriz"+u"\u00E1"+"veis",
"prestacionais", "prestais", "prest"+u"\u00E1"+"veis", "pretexto", "prevaric"+u"\u00E1"+"veis", "prez"+u"\u00E1"+"veis",
"prima", "primais", "primas", "primavera", "primaverais", "primaveras",
"primitivo", "primo", "principi"+u"\u00E1"+"veis", "priorais", "prisco", "pristin"+u"\u00E1"+"veis",
"privatiz"+u"\u00E1"+"veis", "privilegi"+u"\u00E1"+"veis", "proa", "proais", "proas", "problematiz"+u"\u00E1"+"veis",
"processais", "process"+u"\u00E1"+"veis", "processionais", "processo", "proclam"+u"\u00E1"+"veis", "procrastin"+u"\u00E1"+"veis",
"procri"+u"\u00E1"+"veis", "procur"+u"\u00E1"+"veis", "prodigaliz"+u"\u00E1"+"veis", "prodig"+u"\u00E1"+"veis", "proemiais", "profa"+u"\u00E7"+"o",
"profan"+u"\u00E1"+"veis", "profano", "professo", "professorais", "profetiz"+u"\u00E1"+"veis", "profilo",
"profissionaliz"+u"\u00E1"+"veis", "proflig"+u"\u00E1"+"veis", "profunda", "profundas", "profund"+u"\u00E1"+"veis", "profundo",
"prognostic"+u"\u00E1"+"veis", "program"+u"\u00E1"+"veis", "progresso", "projet"+u"\u00E1"+"veis", "projeto", "proletariz"+u"\u00E1"+"veis",
"prolifer"+u"\u00E1"+"veis", "prologais", "prolong"+u"\u00E1"+"veis", "proman"+u"\u00E1"+"veis", "promulg"+u"\u00E1"+"veis", "pronomiais",
"pronominais", "pronominaliz"+u"\u00E1"+"veis", "pronunci"+u"\u00E1"+"veis", "propag"+u"\u00E1"+"veis", "propal"+u"\u00E1"+"veis", "propici"+u"\u00E1"+"veis",
"propina", "propinas", "propolis"+u"\u00E1"+"veis", "proporcionais", "proporcion"+u"\u00E1"+"veis", "propositais",
"propugn"+u"\u00E1"+"veis", "propulsionais", "prorrog"+u"\u00E1"+"veis", "prosa", "prosas", "prosific"+u"\u00E1"+"veis",
"prospecto", "prosper"+u"\u00E1"+"veis", "prosternais", "prostern"+u"\u00E1"+"veis", "prostr"+u"\u00E1"+"veis", "protagoniz"+u"\u00E1"+"veis",
"protecionais", "protel"+u"\u00E1"+"veis", "protest"+u"\u00E1"+"veis", "protesto", "protocol"+u"\u00E1"+"veis", "protocolo",
"prova", "provas", "prov"+u"\u00E1"+"veis", "proven"+u"\u00E7"+"aliz"+u"\u00E1"+"veis", "proverbiais", "providenciais",
"provisionais", "prudenciais", "prumo", "pseudojustific"+u"\u00E1"+"veis", "psicanalis"+u"\u00E1"+"veis", "psicologiz"+u"\u00E1"+"veis",
"public"+u"\u00E1"+"veis", "publicit"+u"\u00E1"+"veis", "pugilo", "pugn"+u"\u00E1"+"veis", "pulinho", "pulo",
"puls"+u"\u00E1"+"veis", "pulsionais", "pulso", "pulul"+u"\u00E1"+"veis", "pulveriz"+u"\u00E1"+"veis", "punt"+u"\u00E1"+"veis",
"punto", "pupais", "pup"+u"\u00E1"+"veis", "pupila", "pupilas", "pupilo",
"purg"+u"\u00E1"+"veis", "purific"+u"\u00E1"+"veis", "purpurais", "putrific"+u"\u00E1"+"veis", "puxo", "quadra",
"quadras", "quadr"+u"\u00E1"+"veis", "quadricul"+u"\u00E1"+"veis", "quadrilha", "quadrilhas", "quadriniz"+u"\u00E1"+"veis",
"quadro", "quadrupedais", "quadruplic"+u"\u00E1"+"veis", "qualific"+u"\u00E1"+"veis", "quantific"+u"\u00E1"+"veis", "quantiz"+u"\u00E1"+"veis",
"quarentena", "quarentenas", "quaresma", "quaresmais", "quaresmas", "quarta",
"quartais", "quartas", "quartilho", "quarto", "quebra", "quebrant"+u"\u00E1"+"veis",
"quebranto", "quebras", "quebr"+u"\u00E1"+"veis", "queda", "quedas", "quedo",
"queijo", "queim"+u"\u00E1"+"veis", "queixa", "queixais", "queixas", "queixo",
"quel"+u"\u00E1"+"veis", "querela", "querelas", "querel"+u"\u00E1"+"veis", "question"+u"\u00E1"+"veis", "quico",
"quieta", "quietas", "quieto", "quilha", "quilhas", "quimbo",
"quimiossintetiz"+u"\u00E1"+"veis", "quina", "quinais", "quinas", "quincha", "quinchas",
"quinta", "quintais", "quintas", "quintessenciais", "quintessenci"+u"\u00E1"+"veis", "quinto",
"quintuplic"+u"\u00E1"+"veis", "quitanda", "quitandas", "quota", "quotas", "quotiz"+u"\u00E1"+"veis",
"rabanais", "rabano", "rabeira", "rabeiras", "rabeiro", "rabioso",
"rabisc"+u"\u00E1"+"veis", "rabisco", "rabona", "rabonas", "rabusco", "racemiz"+u"\u00E1"+"veis",
"raciocinais", "raciocin"+u"\u00E1"+"veis", "racionais", "racionaliz"+u"\u00E1"+"veis", "racion"+u"\u00E1"+"veis", "radiais",
"radiativ"+u"\u00E1"+"veis", "radiativo", "radicais", "radicaliz"+u"\u00E1"+"veis", "radioativ"+u"\u00E1"+"veis", "radioativo",
"radiocromatograf"+u"\u00E1"+"veis", "radiofoniz"+u"\u00E1"+"veis", "radiolocaliz"+u"\u00E1"+"veis", "radiomarc"+u"\u00E1"+"veis", "radionaveg"+u"\u00E1"+"veis", "radiotransistoriz"+u"\u00E1"+"veis",
"raia", "raiais", "raias", "raio", "raiva", "raivais",
"raivas", "ral"+u"\u00E1"+"veis", "ralho", "ralo", "rama", "ramais",
"ramalha", "ramalhais", "ramalhas", "ramalho", "ramas", "ramific"+u"\u00E1"+"veis",
"ramo", "ran"+u"\u00E7"+"o", "randomiz"+u"\u00E1"+"veis", "ranfo", "rango", "ranguinho",
"rapa", "rapas", "rapigo", "rapilho", "rapina", "rapinas",
"rapin"+u"\u00E1"+"veis", "rapinha", "rapinhas", "raposa", "raposas", "raposinha",
"raposinhas", "raposo", "rapto", "rara", "raras", "raro",
"rasa", "rasas", "rascunh"+u"\u00E1"+"veis", "rascunho", "rasgo", "raso",
"rasoira", "rasoiras", "raspan"+u"\u00E7"+"o", "rasteira", "rasteiras", "rasteiro",
"rastej"+u"\u00E1"+"veis", "rastelo", "rastilho", "rastinho", "rastolho", "rasur"+u"\u00E1"+"veis",
"rata", "ratas", "ratazana", "ratazanas", "ratific"+u"\u00E1"+"veis", "ratinho",
"ratino", "rato", "ravina", "ravinas", "ravin"+u"\u00E1"+"veis", "razo"+u"\u00E1"+"veis",
"razon"+u"\u00E1"+"veis", "reabilit"+u"\u00E1"+"veis", "reacionais", "reacopl"+u"\u00E1"+"veis", "readapt"+u"\u00E1"+"veis", "reajunt"+u"\u00E1"+"veis",
"reajust"+u"\u00E1"+"veis", "realejo", "realiment"+u"\u00E1"+"veis", "realiz"+u"\u00E1"+"veis", "realoc"+u"\u00E1"+"veis", "reambul"+u"\u00E1"+"veis",
"reanalis"+u"\u00E1"+"veis", "reaperto", "reapreci"+u"\u00E1"+"veis", "reaproveit"+u"\u00E1"+"veis", "rearranj"+u"\u00E1"+"veis", "rearranjo",
"reaterro", "reativ"+u"\u00E1"+"veis", "reativo", "reatocho", "reaumento", "reavali"+u"\u00E1"+"veis",
"rebaix"+u"\u00E1"+"veis", "rebaixo", "rebalan"+u"\u00E7"+"o", "rebanho", "rebarba", "rebarbas",
"rebel"+u"\u00E1"+"veis", "rebent"+u"\u00E1"+"veis", "rebento", "rebimbalho", "reboco", "rebojo",
"rebolais", "reboli"+u"\u00E7"+"o", "rebolo", "reboo", "rebordo", "rebu"+u"\u00E7"+"o",
"rebufo", "rebuli"+u"\u00E7"+"o", "rebumbo", "rebusc"+u"\u00E1"+"veis", "reca", "recado",
"recalc"+u"\u00E1"+"veis", "recalcific"+u"\u00E1"+"veis", "recalcitr"+u"\u00E1"+"veis", "recalcul"+u"\u00E1"+"veis", "recambi"+u"\u00E1"+"veis", "recamo",
"recandidato", "recanto", "recapacit"+u"\u00E1"+"veis", "recapitaliz"+u"\u00E1"+"veis", "recapitul"+u"\u00E1"+"veis", "recarga",
"recargas", "recarreg"+u"\u00E1"+"veis", "recas", "recato", "recaucion"+u"\u00E1"+"veis", "receita",
"receitas", "recepcionais", "recepcion"+u"\u00E1"+"veis", "rechino", "recibo", "recicl"+u"\u00E1"+"veis",
"reciclo", "recidivo", "recinto", "reciproc"+u"\u00E1"+"veis", "recitais", "reclam"+u"\u00E1"+"veis",
"reclamo", "reclassific"+u"\u00E1"+"veis", "reclin"+u"\u00E1"+"veis", "reclusa", "reclusas", "recluso",
"reco", "recobr"+u"\u00E1"+"veis", "recogit"+u"\u00E1"+"veis", "recolo", "recoloc"+u"\u00E1"+"veis", "recoloniz"+u"\u00E1"+"veis",
"recombin"+u"\u00E1"+"veis", "recome"+u"\u00E7"+"o", "recomend"+u"\u00E1"+"veis", "recompartimentais", "recompartiment"+u"\u00E1"+"veis", "recompens"+u"\u00E1"+"veis",
"recompromisso", "reconcentr"+u"\u00E1"+"veis", "reconcili"+u"\u00E1"+"veis", "recondicion"+u"\u00E1"+"veis", "reconfess"+u"\u00E1"+"veis", "reconfigur"+u"\u00E1"+"veis",
"reconfort"+u"\u00E1"+"veis", "reconforto", "recongra"+u"\u00E7"+u"\u00E1"+"veis", "reconsagr"+u"\u00E1"+"veis", "reconsolid"+u"\u00E1"+"veis", "reconstitucionaliz"+u"\u00E1"+"veis",
"reconsult"+u"\u00E1"+"veis", "recont"+u"\u00E1"+"veis", "recontrat"+u"\u00E1"+"veis", "recontrato", "reconvoc"+u"\u00E1"+"veis", "record"+u"\u00E1"+"veis",
"recort"+u"\u00E1"+"veis", "recosto", "recredenciais", "recri"+u"\u00E1"+"veis", "recrimin"+u"\u00E1"+"veis", "recristaliz"+u"\u00E1"+"veis",
"recristianiz"+u"\u00E1"+"veis", "recrut"+u"\u00E1"+"veis", "recuo", "recuper"+u"\u00E1"+"veis", "recursais", "recurso",
"recurv"+u"\u00E1"+"veis", "recurvo", "recus"+u"\u00E1"+"veis", "redamo", "redatoriais", "redecor"+u"\u00E1"+"veis",
"redemocratiz"+u"\u00E1"+"veis", "redemoinho", "redescont"+u"\u00E1"+"veis", "redesconto", "redesenho", "redestin"+u"\u00E1"+"veis",
"redimension"+u"\u00E1"+"veis", "redobr"+u"\u00E1"+"veis", "reedific"+u"\u00E1"+"veis", "reedit"+u"\u00E1"+"veis", "reeditor"+u"\u00E1"+"veis", "reeduc"+u"\u00E1"+"veis",
"reelabor"+u"\u00E1"+"veis", "reembols"+u"\u00E1"+"veis", "reembolso", "reemend"+u"\u00E1"+"veis", "reencontr"+u"\u00E1"+"veis", "reencontro",
"reendoss"+u"\u00E1"+"veis", "reenquadr"+u"\u00E1"+"veis", "reensino", "reenverniz"+u"\u00E1"+"veis", "reenvio", "reenxerto",
"reestrutur"+u"\u00E1"+"veis", "reexager"+u"\u00E1"+"veis", "reexagero", "reexpatri"+u"\u00E1"+"veis", "reexpi"+u"\u00E1"+"veis", "reexport"+u"\u00E1"+"veis",
"refarto", "referenciais", "referenda", "referendas", "referendo", "referto",
"refluxo", "refolego", "refolho", "refor"+u"\u00E7"+"o", "reformato", "reform"+u"\u00E1"+"veis",
"refotograf"+u"\u00E1"+"veis", "refracto", "refrat"+u"\u00E1"+"veis", "refresco", "refriger"+u"\u00E1"+"veis", "refrito",
"refrulho", "refugo", "refund"+u"\u00E1"+"veis", "refunfo", "refut"+u"\u00E1"+"veis", "rega"+u"\u00E7"+"o",
"regais", "regalo", "regata", "regatas", "regatinha", "regatinhas",
"regato", "regel"+u"\u00E1"+"veis", "regener"+u"\u00E1"+"veis", "regimentais", "regimento", "regina",
"reginas", "regino", "regist"+u"\u00E1"+"veis", "registo", "registrais", "registr"+u"\u00E1"+"veis",
"registro", "rego", "regozij"+u"\u00E1"+"veis", "regra", "regras", "regrav"+u"\u00E1"+"veis",
"regr"+u"\u00E1"+"veis", "regresso", "reguardo", "regueiro", "regulamento", "regulariz"+u"\u00E1"+"veis",
"reific"+u"\u00E1"+"veis", "reimport"+u"\u00E1"+"veis", "reinais", "reinerv"+u"\u00E1"+"veis", "reingresso", "reinjet"+u"\u00E1"+"veis",
"reino", "reinocul"+u"\u00E1"+"veis", "reintegr"+u"\u00E1"+"veis", "reinternacionaliz"+u"\u00E1"+"veis", "reinterpret"+u"\u00E1"+"veis", "reiter"+u"\u00E1"+"veis",
"reiuno", "reivindic"+u"\u00E1"+"veis", "rejeit"+u"\u00E1"+"veis", "rejeito", "rejubil"+u"\u00E1"+"veis", "rejunt"+u"\u00E1"+"veis",
"relacionais", "relacion"+u"\u00E1"+"veis", "relampado", "relampo", "relan"+u"\u00E7"+u"\u00E1"+"veis", "relan"+u"\u00E7"+"o",
"relat"+u"\u00E1"+"veis", "relativ"+u"\u00E1"+"veis", "relativiz"+u"\u00E1"+"veis", "relativo", "relato", "relax"+u"\u00E1"+"veis",
"releg"+u"\u00E1"+"veis", "relembr"+u"\u00E1"+"veis", "relento", "relev"+u"\u00E1"+"veis", "relevo", "relho",
"relig"+u"\u00E1"+"veis", "relojo", "relvais", "remais", "remanej"+u"\u00E1"+"veis", "remanso",
"remarc"+u"\u00E1"+"veis", "rematerializ"+u"\u00E1"+"veis", "rememor"+u"\u00E1"+"veis", "remendo", "remessa", "remessas",
"remimo", "remistur"+u"\u00E1"+"veis", "remo", "remodel"+u"\u00E1"+"veis", "remoinho", "remolgo",
"remont"+u"\u00E1"+"veis", "remuner"+u"\u00E1"+"veis", "renda", "rendas", "rend"+u"\u00E1"+"veis", "renegoci"+u"\u00E1"+"veis",
"renormaliz"+u"\u00E1"+"veis", "renov"+u"\u00E1"+"veis", "renovo", "rent"+u"\u00E1"+"veis", "renunci"+u"\u00E1"+"veis", "reoficializ"+u"\u00E1"+"veis",
"reorden"+u"\u00E1"+"veis", "reorient"+u"\u00E1"+"veis", "reorquestr"+u"\u00E1"+"veis", "repairo", "reparametriz"+u"\u00E1"+"veis", "repar"+u"\u00E1"+"veis",
"reparo", "repasto", "repatri"+u"\u00E1"+"veis", "repens"+u"\u00E1"+"veis", "repes"+u"\u00E1"+"veis", "repeso",
"repint"+u"\u00E1"+"veis", "replaino", "repleto", "replic"+u"\u00E1"+"veis", "repolhais", "repolho",
"reponder"+u"\u00E1"+"veis", "report"+u"\u00E1"+"veis", "reposicion"+u"\u00E1"+"veis", "reposta", "repostas", "reposto",
"repouso", "represa", "represas", "repres"+u"\u00E1"+"veis", "represent"+u"\u00E1"+"veis", "reprimenda",
"reprimendas", "reprocess"+u"\u00E1"+"veis", "reprogram"+u"\u00E1"+"veis", "reprojeto", "reprov"+u"\u00E1"+"veis", "repto",
"repudi"+u"\u00E1"+"veis", "repulsa", "repulsas", "repuxo", "requadro", "requalific"+u"\u00E1"+"veis",
"requebr"+u"\u00E1"+"veis", "requebro", "requeim"+u"\u00E1"+"veis", "requent"+u"\u00E1"+"veis", "requestion"+u"\u00E1"+"veis", "requint"+u"\u00E1"+"veis",
"requisito", "rescaldo", "resenha", "resenhas", "resenh"+u"\u00E1"+"veis", "reserva", "reservas", "reserv"+u"\u00E1"+"veis",
"resfri"+u"\u00E1"+"veis", "resgat"+u"\u00E1"+"veis", "resgo", "resguard"+u"\u00E1"+"veis", "resguardo", "residenciais",
"resign"+u"\u00E1"+"veis", "resina", "resinas", "resinific"+u"\u00E1"+"veis", "resmungo", "respaldo",
"respeit"+u"\u00E1"+"veis", "respeito", "respig"+u"\u00E1"+"veis", "resping"+u"\u00E1"+"veis", "respingo", "respirais",
"respir"+u"\u00E1"+"veis", "respiro", "responsabiliz"+u"\u00E1"+"veis", "respons"+u"\u00E1"+"veis", "responto", "resposta",
"respostas", "ressaca", "ressacas", "ressac"+u"\u00E1"+"veis", "ressaibo", "ressalto",
"ressalva", "ressalvas", "resseguro", "ressintetiz"+u"\u00E1"+"veis", "ressolto", "resson"+u"\u00E1"+"veis",
"ressoo", "ressuscit"+u"\u00E1"+"veis", "restaur"+u"\u00E1"+"veis", "restauro", "rest"+u"\u00E1"+"veis", "restito",
"restivo", "resto", "restolhais", "restolho", "restrelo", "resvalo",
"reta", "retaco", "retais", "retalho", "retali"+u"\u00E1"+"veis", "retard"+u"\u00E1"+"veis",
"retardo", "retas", "retemper"+u"\u00E1"+"veis", "retento", "retes"+u"\u00E1"+"veis", "retific"+u"\u00E1"+"veis",
"retipific"+u"\u00E1"+"veis", "retir"+u"\u00E1"+"veis", "retiro", "reto", "retoc"+u"\u00E1"+"veis", "retonho",
"retorn"+u"\u00E1"+"veis", "retorno", "retrabalh"+u"\u00E1"+"veis", "retrabalho", "retra"+u"\u00E7"+"o", "retranca",
"retrancas", "retrat"+u"\u00E1"+"veis", "retrato", "retroaliment"+u"\u00E1"+"veis", "retroalimento", "retroativo",
"retrocarreg"+u"\u00E1"+"veis", "retrocruz"+u"\u00E1"+"veis", "retrograda", "retrogradas", "reumaniz"+u"\u00E1"+"veis", "reunific"+u"\u00E1"+"veis",
"reus"+u"\u00E1"+"veis", "reuso", "reutiliz"+u"\u00E1"+"veis", "revacin"+u"\u00E1"+"veis", "revalid"+u"\u00E1"+"veis", "revaloriz"+u"\u00E1"+"veis",
"revasculariz"+u"\u00E1"+"veis", "revel"+u"\u00E1"+"veis", "reverber"+u"\u00E1"+"veis", "reverenciais", "reverenci"+u"\u00E1"+"veis", "reverific"+u"\u00E1"+"veis",
"reversais", "reverso", "revez"+u"\u00E1"+"veis", "revigor"+u"\u00E1"+"veis", "revigoriz"+u"\u00E1"+"veis", "revir"+u"\u00E1"+"veis",
"revis"+u"\u00E1"+"veis", "revisit"+u"\u00E1"+"veis", "revista", "revistas", "revist"+u"\u00E1"+"veis", "revisto",
"revitaliz"+u"\u00E1"+"veis", "revivific"+u"\u00E1"+"veis", "revoc"+u"\u00E1"+"veis", "revolt"+u"\u00E1"+"veis", "revolto", "revoo",
"riba", "ribas", "ribeira", "ribeiras", "ribeiro", "ridiculariz"+u"\u00E1"+"veis",
"ridiculiz"+u"\u00E1"+"veis", "rifa", "rifas", "rif"+u"\u00E1"+"veis", "rigo", "rija",
"rijais", "rijas", "rijo", "rilo", "rim"+u"\u00E1"+"veis", "rimo",
"rincho", "ripais", "ripan"+u"\u00E7"+"o", "risco", "ritm"+u"\u00E1"+"veis", "ritmo",
"rivaliz"+u"\u00E1"+"veis", "rixa", "rixas", "robor"+u"\u00E1"+"veis", "robotiz"+u"\u00E1"+"veis", "rocais",
"rocinais", "roda", "rodais", "rodas", "rod"+u"\u00E1"+"veis", "rodilha",
"rodilhas", "rodo", "rodopi"+u"\u00E1"+"veis", "rodopio", "rodrigo", "rogais",
"rog"+u"\u00E1"+"veis", "rogo", "rola", "rolas", "rolda", "roldas",
"roleta", "roletas", "rolha", "rolhas", "roli"+u"\u00E7"+"o", "rolo",
"romanesco", "romaniz"+u"\u00E1"+"veis", "romantiz"+u"\u00E1"+"veis", "ronca", "roncais", "roncas",
"ronc"+u"\u00E1"+"veis", "ronco", "roreja", "rorejas", "rosa", "rosais",
"rosas", "rosca", "roscas", "rosc"+u"\u00E1"+"veis", "roseta", "rosetas",
"rosmaninhais", "rosmaninho", "rota", "rotacionais", "rotas", "rotativo",
"rotiniz"+u"\u00E1"+"veis", "roto", "rotul"+u"\u00E1"+"veis", "roub"+u"\u00E1"+"veis", "roubo", "roufenho",
"roupa", "roupas", "rousso", "rua", "ruais", "ruas",
"rubific"+u"\u00E1"+"veis", "ruboriz"+u"\u00E1"+"veis", "rubrica", "rubricas", "rubric"+u"\u00E1"+"veis", "ru"+u"\u00E7"+"a",
"ru"+u"\u00E7"+"as", "rufo", "ruga", "rugas", "ruma", "rumas",
"rumba", "rumbas", "ruminais", "rumo", "rurbaniz"+u"\u00E1"+"veis", "rusga",
"rusgas", "russa", "russas", "russific"+u"\u00E1"+"veis", "russo", "rutais",
"sabatina", "sabatinas", "sabot"+u"\u00E1"+"veis", "sabugais", "sabugo", "sabujo",
"saburrais", "saca", "sacais", "sacarific"+u"\u00E1"+"veis", "sacas", "sacha",
"sachas", "sacho", "sacholo", "saci"+u"\u00E1"+"veis", "saco", "sacola",
"sacolas", "sacraliz"+u"\u00E1"+"veis", "sacramentais", "sacrament"+u"\u00E1"+"veis", "sacramento", "sacrificais",
"sacrific"+u"\u00E1"+"veis", "safano", "safiriz"+u"\u00E1"+"veis", "safo", "sagitais", "sagorro",
"sagr"+u"\u00E1"+"veis", "salariais", "saldo", "salg"+u"\u00E1"+"veis", "salicilo", "salient"+u"\u00E1"+"veis",
"salific"+u"\u00E1"+"veis", "salin"+u"\u00E1"+"veis", "salino", "salitrais", "saliva", "salivais",
"salivas", "salmejo", "salmoeiro", "salmoira", "salmoiras", "salmoura",
"salmouras", "salpic"+u"\u00E1"+"veis", "salpico", "salsa", "salsas", "salso",
"saltinho", "salto", "salv"+u"\u00E1"+"veis", "salvo", "sambenito", "sambl"+u"\u00E1"+"veis",
"san"+u"\u00E1"+"veis", "sancion"+u"\u00E1"+"veis", "sanfona", "sanfonas", "sanfon"+u"\u00E1"+"veis", "sangr"+u"\u00E1"+"veis",
"sanguento", "sanguinhais", "sanguinho", "sanitiz"+u"\u00E1"+"veis", "santific"+u"\u00E1"+"veis", "sapa",
"sapais", "sapas", "sapato", "sapo", "sapoilo", "saponific"+u"\u00E1"+"veis",
"sapoulo", "saraiva", "saraivas", "sarapico", "sarda", "sardas",
"sardo", "sarilho", "sarna", "sarnas", "saro", "sarrafa"+u"\u00E7"+"ais",
"sarrafo", "sarro", "sartais", "satelitiz"+u"\u00E1"+"veis", "sateliz"+u"\u00E1"+"veis", "satur"+u"\u00E1"+"veis",
"sazonais", "sazon"+u"\u00E1"+"veis", "seca", "secais", "secas", "sec"+u"\u00E1"+"veis",
"seccionais", "seccion"+u"\u00E1"+"veis", "secessionais", "secionais", "secion"+u"\u00E1"+"veis", "seco",
"secreta", "secretaria", "secretariais", "secretarias", "secretas", "secreto",
"seculariz"+u"\u00E1"+"veis", "secund"+u"\u00E1"+"veis", "seda", "sedais", "sedas", "sedentariz"+u"\u00E1"+"veis",
"sedi"+u"\u00E1"+"veis", "sedimento", "segmentais", "segment"+u"\u00E1"+"veis", "segmento", "segred"+u"\u00E1"+"veis",
"segredo", "segreg"+u"\u00E1"+"veis", "segunda", "segundas", "segundo", "segura",
"seguras", "segur"+u"\u00E1"+"veis", "seguro", "seita", "seitas", "seiva",
"seivais", "seivas", "seivo", "sela", "selas", "selecionais",
"selecion"+u"\u00E1"+"veis", "seleto", "selo", "semantiz"+u"\u00E1"+"veis", "semelh"+u"\u00E1"+"veis", "sementais",
"semiajust"+u"\u00E1"+"veis", "semiaplic"+u"\u00E1"+"veis", "semicadastrais", "semicolo", "semidomestic"+u"\u00E1"+"veis", "semiformato",
"semimanufatur"+u"\u00E1"+"veis", "seminormais", "seminorm"+u"\u00E1"+"veis", "semitiz"+u"\u00E1"+"veis", "sensibiliz"+u"\u00E1"+"veis", "sent"+u"\u00E1"+"veis",
"sentenciais", "sentenci"+u"\u00E1"+"veis", "separ"+u"\u00E1"+"veis", "septais", "sept"+u"\u00E1"+"veis", "septo",
"sepulcrais", "sepulcro", "sepult"+u"\u00E1"+"veis", "sepulto", "sequela", "sequelas",
"sequenciais", "sequestr"+u"\u00E1"+"veis", "sequestro", "serena", "serenas", "seren"+u"\u00E1"+"veis",
"sereno", "seriais", "serigraf"+u"\u00E1"+"veis", "seringa", "seringais", "seringas",
"seringonho", "seriograf"+u"\u00E1"+"veis", "serra", "serras", "serrino", "serro",
"sertaneja", "sertanejas", "sertanejo", "seta", "setas", "seteiro",
"setino", "seto", "setoriz"+u"\u00E1"+"veis", "sevici"+u"\u00E1"+"veis", "sexo", "sextuplic"+u"\u00E1"+"veis",
"sexuais", "siais", "sibila", "sibilas", "sibil"+u"\u00E1"+"veis", "sibilo",
"siderais", "sider"+u"\u00E1"+"veis", "sifiliz"+u"\u00E1"+"veis", "sifonais", "sigil"+u"\u00E1"+"veis", "sigilo",
"sigla", "siglas", "signa", "signas", "signific"+u"\u00E1"+"veis", "signo",
"silab"+u"\u00E1"+"veis", "silenciais", "silenci"+u"\u00E1"+"veis", "silhueta", "silhuetas", "silicato",
"silicific"+u"\u00E1"+"veis", "silogismo", "silva", "silvas", "silvo", "simboliz"+u"\u00E1"+"veis",
"simetriz"+u"\u00E1"+"veis", "simpatiz"+u"\u00E1"+"veis", "simplific"+u"\u00E1"+"veis", "simul"+u"\u00E1"+"veis", "sina", "sinais",
"sinaliz"+u"\u00E1"+"veis", "sinapiz"+u"\u00E1"+"veis", "sinas", "sincelo", "sincopais", "sincretiz"+u"\u00E1"+"veis",
"sincroniz"+u"\u00E1"+"veis", "sindicais", "sindicaliz"+u"\u00E1"+"veis", "sindicatais", "sindicato", "sindic"+u"\u00E1"+"veis",
"sineta", "sinetas", "sinfoniz"+u"\u00E1"+"veis", "singulariz"+u"\u00E1"+"veis", "sinistra", "sinistras",
"sinistro", "sino", "sinonimiz"+u"\u00E1"+"veis", "sinteriz"+u"\u00E1"+"veis", "sintetiz"+u"\u00E1"+"veis", "sintoniz"+u"\u00E1"+"veis",
"sinuco", "sinuoso", "sirena", "sirenas", "sirigaita", "sirigaitas",
"sisa", "sisais", "sisas", "sismais", "sismo", "siso",
"sistematiz"+u"\u00E1"+"veis", "sitiais", "situ"+u"\u00E1"+"veis", "soalhais", "soalho", "sobejo",
"soberba", "soberbas", "soberbo", "sobrado", "sobrais", "sobr"+u"\u00E1"+"veis",
"sobreaviso", "sobrecabo", "sobrecasaca", "sobrecasacas", "sobrecasaco", "sobrecifr"+u"\u00E1"+"veis",
"sobreleito", "sobrenad"+u"\u00E1"+"veis", "sobrepasso", "sobrepuj"+u"\u00E1"+"veis", "sobrerroldo", "sobrescrito",
"sobressalto", "sobresselo", "sobreuso", "sobrevoo", "socalco", "sociabiliz"+u"\u00E1"+"veis",
"socializ"+u"\u00E1"+"veis", "soco", "socresto", "sofism"+u"\u00E1"+"veis", "sofistic"+u"\u00E1"+"veis", "sogra",
"sogras", "sogro", "sola", "solas", "solavanco", "solda",
"soldas", "sold"+u"\u00E1"+"veis", "soldo", "soletr"+u"\u00E1"+"veis", "solfejo", "solha",
"solhas", "solicit"+u"\u00E1"+"veis", "solo", "solta", "soltas", "solto",
"solucion"+u"\u00E1"+"veis", "solu"+u"\u00E7"+"o", "sombra", "sombrais", "sombras", "somo",
"sonda", "sondas", "sond"+u"\u00E1"+"veis", "soneto", "sonh"+u"\u00E1"+"veis", "sonho",
"sono", "sopapo", "sopes"+u"\u00E1"+"veis", "sopit"+u"\u00E1"+"veis", "sopro", "sorais",
"soro", "soroneutraliz"+u"\u00E1"+"veis", "sorvais", "sorvo", "soslaio", "sospitais",
"sosseg"+u"\u00E1"+"veis", "sossego", "soterr"+u"\u00E1"+"veis", "soto", "soturna", "soturnas",
"soturno", "souto", "sova", "sovas", "sovela", "sovelas",
"sua", "suas", "suaviz"+u"\u00E1"+"veis", "subajust"+u"\u00E1"+"veis", "subalterno", "subaplic"+u"\u00E1"+"veis",
"subaproveit"+u"\u00E1"+"veis", "subarrend"+u"\u00E1"+"veis", "subcandidato", "subcontrat"+u"\u00E1"+"veis", "subenxert"+u"\u00E1"+"veis", "subenxerto",
"subequip"+u"\u00E1"+"veis", "suberiz"+u"\u00E1"+"veis", "subespecific"+u"\u00E1"+"veis", "subestim"+u"\u00E1"+"veis", "subfatur"+u"\u00E1"+"veis", "subformato",
"subgrupo", "subjetivo", "subjug"+u"\u00E1"+"veis", "sublim"+u"\u00E1"+"veis", "subministr"+u"\u00E1"+"veis", "subnivel"+u"\u00E1"+"veis",
"suborbitais", "subordin"+u"\u00E1"+"veis", "suborn"+u"\u00E1"+"veis", "suborno", "subscrito", "subsequenciais",
"subsequenci"+u"\u00E1"+"veis", "subsolo", "substanciais", "substancializ"+u"\u00E1"+"veis", "substanci"+u"\u00E1"+"veis", "substantific"+u"\u00E1"+"veis",
"substantivais", "substantiv"+u"\u00E1"+"veis", "substantivo", "suburbaniz"+u"\u00E1"+"veis", "subutiliz"+u"\u00E1"+"veis", "subvencionais",
"subvencion"+u"\u00E1"+"veis", "sucata", "sucatas", "suco", "sud"+u"\u00E1"+"veis", "sufixais",
"sufixo", "sufoc"+u"\u00E1"+"veis", "sufoco", "sugestion"+u"\u00E1"+"veis", "suja", "sujas",
"suj"+u"\u00E1"+"veis", "sujeita", "sujeitas", "sujeit"+u"\u00E1"+"veis", "sujeito", "sujo",
"sulavento", "sulc"+u"\u00E1"+"veis", "sulco", "sulfato", "sulfeto", "sulfito",
"sulfonais", "sulfon"+u"\u00E1"+"veis", "sulfur"+u"\u00E1"+"veis", "sulfureto", "sulfuriz"+u"\u00E1"+"veis", "sumagrais",
"sumari"+u"\u00E1"+"veis", "sumariz"+u"\u00E1"+"veis", "superajunt"+u"\u00E1"+"veis", "superajust"+u"\u00E1"+"veis", "superaliment"+u"\u00E1"+"veis", "superalimento",
"superaplic"+u"\u00E1"+"veis", "superativo", "super"+u"\u00E1"+"veis", "supercandidato", "superciviliz"+u"\u00E1"+"veis", "supercompacto",
"supercompens"+u"\u00E1"+"veis", "supercomplexo", "superconcentr"+u"\u00E1"+"veis", "superconfort"+u"\u00E1"+"veis", "superdimension"+u"\u00E1"+"veis", "superestruturais",
"superestrutur"+u"\u00E1"+"veis", "superexcit"+u"\u00E1"+"veis", "superexplor"+u"\u00E1"+"veis", "superformato", "superimpregn"+u"\u00E1"+"veis", "superindustriais",
"superindustrializ"+u"\u00E1"+"veis", "superinterpret"+u"\u00E1"+"veis", "superlativo", "superocup"+u"\u00E1"+"veis", "superselecion"+u"\u00E1"+"veis", "suplant"+u"\u00E1"+"veis",
"suplemento", "suport"+u"\u00E1"+"veis", "suput"+u"\u00E1"+"veis", "surdina", "surdinas", "surf"+u"\u00E1"+"veis",
"surpresa", "surpresas", "surpreso", "surra", "surras", "surr"+u"\u00E1"+"veis",
"surrealiz"+u"\u00E1"+"veis", "surrupio", "surto", "suscit"+u"\u00E1"+"veis", "suspeita", "suspeitas",
"suspeit"+u"\u00E1"+"veis", "suspeito", "suspir"+u"\u00E1"+"veis", "suspiro", "sussurr"+u"\u00E1"+"veis", "sussurro",
"sust"+u"\u00E1"+"veis", "sustent"+u"\u00E1"+"veis", "sustento", "susto", "suturais", "sutur"+u"\u00E1"+"veis",
"tabardilho", "tabela", "tabelas", "tabelionais", "tabica", "tabicas",
"tabul"+u"\u00E1"+"veis", "tabuleta", "tabuletas", "taburno", "tacha", "tachas",
"tach"+u"\u00E1"+"veis", "tacho", "taco", "taino", "taipais", "talha",
"talhas", "talho", "talo", "tamanco", "tampa", "tampas",
"tamp"+u"\u00E1"+"veis", "tampo", "tampon"+u"\u00E1"+"veis", "tanais", "tan"+u"\u00E1"+"veis", "tancamo",
"tanga", "tangas", "tangenciais", "tango", "tanino", "tap"+u"\u00E1"+"veis",
"taramela", "taramelas", "tardo", "tarefa", "tarefas", "tarifa",
"tarifas", "tarja", "tarjas", "taroco", "tarola", "tarolas",
"tarolo", "tarouco", "tarrafa", "tarrafas", "tarrinco", "tarugo",
"tasca", "tascas", "tasco", "tasquinha", "tasquinhas", "tassalho",
"taxa", "taxais", "taxas", "tax"+u"\u00E1"+"veis", "teca", "tecais",
"tecas", "tecla", "teclas", "tecniciz"+u"\u00E1"+"veis", "teima", "teimas",
"teimosia", "teimosias", "tela", "telas", "telecomando", "telecomunic"+u"\u00E1"+"veis",
"telecurso", "teledetect"+u"\u00E1"+"veis", "telefon"+u"\u00E1"+"veis", "telegraf"+u"\u00E1"+"veis", "teleporto", "telerradiograf"+u"\u00E1"+"veis",
"teletrabalho", "televisa", "televisas", "televis"+u"\u00E1"+"veis", "televisionais", "telha",
"telhais", "telhas", "telomeriz"+u"\u00E1"+"veis", "tematiz"+u"\u00E1"+"veis", "temper"+u"\u00E1"+"veis", "tempero",
"templo", "temporiz"+u"\u00E1"+"veis", "tendenciais", "tensionais", "tent"+u"\u00E1"+"veis", "tento",
"teoriz"+u"\u00E1"+"veis", "ter"+u"\u00E7"+"a", "ter"+u"\u00E7"+"as", "terceira", "terceiras", "terceiriz"+u"\u00E1"+"veis",
"terceiro", "terceto", "ter"+u"\u00E7"+"o", "terebintina", "terebintinas", "tergivers"+u"\u00E1"+"veis",
"terlado", "terminais", "termin"+u"\u00E1"+"veis", "termistoriz"+u"\u00E1"+"veis", "termorregul"+u"\u00E1"+"veis", "terna",
"ternais", "ternas", "terno", "terra", "terrais", "terramoto",
"terras", "terrific"+u"\u00E1"+"veis", "terroriz"+u"\u00E1"+"veis", "teso", "tesoiro", "tesoura",
"tesouras", "tesouro", "testamentais", "testamento", "test"+u"\u00E1"+"veis", "testemunha",
"testemunhais", "testemunhas", "testemunh"+u"\u00E1"+"veis", "testemunho", "testico", "testific"+u"\u00E1"+"veis",
"teta", "tetas", "teto", "textualiz"+u"\u00E1"+"veis", "textura", "texturais",
"texturas", "texturiz"+u"\u00E1"+"veis", "tibiro", "ticais", "tijolo", "tilo",
"timbalejo", "timbr"+u"\u00E1"+"veis", "tingo", "tinta", "tintas", "tinto",
"tipific"+u"\u00E1"+"veis", "tipograf"+u"\u00E1"+"veis", "tiraniz"+u"\u00E1"+"veis", "tiriricais", "tiro", "tisn"+u"\u00E1"+"veis",
"titil"+u"\u00E1"+"veis", "titul"+u"\u00E1"+"veis", "tocaia", "tocaias", "toc"+u"\u00E1"+"veis", "toco",
"toga", "togas", "toi"+u"\u00E7"+"o", "toirais", "toiro", "tolda",
"toldas", "told"+u"\u00E1"+"veis", "toldo", "toler"+u"\u00E1"+"veis", "tombo", "tomo",
"tomograf"+u"\u00E1"+"veis", "tona", "tonais", "tonas", "tonific"+u"\u00E1"+"veis", "tonsura",
"tonsuras", "tonsur"+u"\u00E1"+"veis", "topo", "tora", "torais", "toras",
"torcicolo", "tormenta", "tormentas", "tormento", "torno", "toro",
"torpedo", "torr"+u"\u00E1"+"veis", "tortura", "torturas", "tortur"+u"\u00E1"+"veis", "torva",
"torvas", "torvelinho", "torvo", "tosca", "toscas", "tosco",
"tosquia", "tosquias", "tosqui"+u"\u00E1"+"veis", "tost"+u"\u00E1"+"veis", "totaliz"+u"\u00E1"+"veis", "touca",
"tou"+u"\u00E7"+"a", "toucas", "tou"+u"\u00E7"+"as", "tou"+u"\u00E7"+"o", "tourais", "touro",
"toxica", "toxicas", "trabalh"+u"\u00E1"+"veis", "trabalho", "trabelho", "trabuco",
"trabulo", "tra"+u"\u00E7"+"a", "tra"+u"\u00E7"+"as", "tra"+u"\u00E7"+"o", "tracolejo", "trado",
"trafeg"+u"\u00E1"+"veis", "trafic"+u"\u00E1"+"veis", "trag"+u"\u00E1"+"veis", "tragedia", "tragedias", "trago",
"trajo", "tralha", "tralhas", "trama", "tramas", "tram"+u"\u00E1"+"veis",
"trambolha", "trambolhas", "trambolho", "tramela", "tramelas", "tramelo",
"tramo", "tranca", "trancafi"+u"\u00E1"+"veis", "trancas", "tranc"+u"\u00E1"+"veis", "tran"+u"\u00E7"+u"\u00E1"+"veis",
"tranco", "tranqueira", "tranqueiras", "tranquiliz"+u"\u00E1"+"veis", "transacionais", "transacion"+u"\u00E1"+"veis",
"transbord"+u"\u00E1"+"veis", "transcodific"+u"\u00E1"+"veis", "transculturais", "transcultur"+u"\u00E1"+"veis", "transcur"+u"\u00E1"+"veis", "transcurso",
"transfigur"+u"\u00E1"+"veis", "transfinaliz"+u"\u00E1"+"veis", "transform"+u"\u00E1"+"veis", "transfuso", "transignific"+u"\u00E1"+"veis", "transistoriz"+u"\u00E1"+"veis",
"transit"+u"\u00E1"+"veis", "transitivo", "translad"+u"\u00E1"+"veis", "translado", "transliterais", "transliter"+u"\u00E1"+"veis",
"translocais", "transloc"+u"\u00E1"+"veis", "transmigr"+u"\u00E1"+"veis", "transmud"+u"\u00E1"+"veis", "transmut"+u"\u00E1"+"veis", "transnacionaliz"+u"\u00E1"+"veis",
"transnad"+u"\u00E1"+"veis", "transpir"+u"\u00E1"+"veis", "transplant"+u"\u00E1"+"veis", "transport"+u"\u00E1"+"veis", "transtorno", "transubstanciais",
"transud"+u"\u00E1"+"veis", "transumano", "transvi"+u"\u00E1"+"veis", "transvoo", "trapa"+u"\u00E7"+"a", "trapa"+u"\u00E7"+"as",
"traquejo", "traquitana", "traquitanas", "traslad"+u"\u00E1"+"veis", "traslado", "traspass"+u"\u00E1"+"veis",
"trastempo", "trat"+u"\u00E1"+"veis", "trato", "traulito", "traumatiz"+u"\u00E1"+"veis", "trava",
"travais", "travas", "trav"+u"\u00E1"+"veis", "travej"+u"\u00E1"+"veis", "travessa", "travessas",
"travesso", "travessura", "travessuras", "travo", "trefil"+u"\u00E1"+"veis", "trein"+u"\u00E1"+"veis",
"treino", "treito", "trejeito", "treli"+u"\u00E7"+"a", "treli"+u"\u00E7"+"as", "tremelais",
"tremelejo", "tremo"+u"\u00E7"+"ais", "tremo"+u"\u00E7"+"o", "tremul"+u"\u00E1"+"veis", "treno", "trep"+u"\u00E1"+"veis",
"trepid"+u"\u00E1"+"veis", "treplic"+u"\u00E1"+"veis", "treslado", "trespass"+u"\u00E1"+"veis", "trevisco", "triais",
"triangul"+u"\u00E1"+"veis", "tributais", "tribut"+u"\u00E1"+"veis", "tributo", "tricalho", "tricot"+u"\u00E1"+"veis",
"trifurc"+u"\u00E1"+"veis", "trigais", "trigo", "trilaterais", "tril"+u"\u00E1"+"veis", "trilha",
"trilhas", "trilh"+u"\u00E1"+"veis", "trilho", "trinca", "trincais", "trincas",
"trinc"+u"\u00E1"+"veis", "trinch"+u"\u00E1"+"veis", "trincheira", "trincheiras", "trinco", "trino",
"trio", "tripa", "tripas", "triplic"+u"\u00E1"+"veis", "tripo", "tripudi"+u"\u00E1"+"veis",
"tripul"+u"\u00E1"+"veis", "trissais", "trissec"+u"\u00E1"+"veis", "trissecto", "trissulco", "trito",
"tritur"+u"\u00E1"+"veis", "triunfais", "triunfo", "trocadilho", "trocais", "tro"+u"\u00E7"+"ais",
"troc"+u"\u00E1"+"veis", "tro"+u"\u00E7"+u"\u00E1"+"veis", "troco", "tro"+u"\u00E7"+"o", "tromba", "trombas",
"trombeta", "trombetas", "trombo", "trompa", "trompas", "troncais",
"troncho", "tronco", "trono", "tropa", "tropas", "trope"+u"\u00E7"+"o",
"tropicais", "tropo", "trotejo", "trova", "trovas", "trov"+u"\u00E1"+"veis",
"troviscais", "trovisco", "trucid"+u"\u00E1"+"veis", "truco", "trufa", "trufais",
"trufas", "trunc"+u"\u00E1"+"veis", "trunfa", "trunfas", "trunfo", "trustific"+u"\u00E1"+"veis",
"tuba", "tubais", "tubas", "tuberculiz"+u"\u00E1"+"veis", "tubo", "tucano",
"tuf"+u"\u00E1"+"veis", "tufo", "tumba", "tumbais", "tumbas", "tumultu"+u"\u00E1"+"veis",
"tuna", "tunais", "tunas", "tunda", "tundas", "turba",
"turbas", "turb"+u"\u00E1"+"veis", "turbina", "turbinais", "turbinas", "turbo",
"turbolejo", "turiferais", "turific"+u"\u00E1"+"veis", "turma", "turmas", "turra",
"turras", "turro", "turturejo", "turturinho", "turva", "turvas",
"turvo", "tutela", "tutelas", "uberais", "ufano", "ugalho",
"uiva", "uivas", "uivo", "ulcer"+u"\u00E1"+"veis", "ultim"+u"\u00E1"+"veis", "ultraciviliz"+u"\u00E1"+"veis",
"ultracolapso", "ultraestruturais", "ultraestrutur"+u"\u00E1"+"veis", "ultrafiltr"+u"\u00E1"+"veis", "ultrafiltro", "ultrapass"+u"\u00E1"+"veis",
"ultrapurific"+u"\u00E1"+"veis", "ultrassonograf"+u"\u00E1"+"veis", "umidific"+u"\u00E1"+"veis", "undo", "unguento", "unific"+u"\u00E1"+"veis",
"uniform"+u"\u00E1"+"veis", "uniformiz"+u"\u00E1"+"veis", "universaliz"+u"\u00E1"+"veis", "uno", "unt"+u"\u00E1"+"veis", "upa",
"upas", "uralitiz"+u"\u00E1"+"veis", "urano", "urbaniz"+u"\u00E1"+"veis", "urina", "urinas",
"urro", "urtiga", "urtigais", "urtigas", "us"+u"\u00E1"+"veis", "usina",
"usinas", "usin"+u"\u00E1"+"veis", "uso", "ustul"+u"\u00E1"+"veis", "usura", "usuras",
"usurp"+u"\u00E1"+"veis", "utiliz"+u"\u00E1"+"veis", "vaca", "vacais", "vacas", "vacil"+u"\u00E1"+"veis",
"vacilo", "vacinais", "vacin"+u"\u00E1"+"veis", "vacuoliz"+u"\u00E1"+"veis", "vadia", "vadias",
"vadio", "vagabunda", "vagabundas", "vagabundo", "vagais", "vagamundo",
"vago", "vaia", "vaias", "valid"+u"\u00E1"+"veis", "valido", "valo",
"valoriz"+u"\u00E1"+"veis", "valsa", "valsas", "vampira", "vampiras", "vampiro",
"vanglori"+u"\u00E1"+"veis", "vapor"+u"\u00E1"+"veis", "vaporiz"+u"\u00E1"+"veis", "vaqueiro", "varais", "var"+u"\u00E1"+"veis",
"vareja", "varejas", "varejo", "vari"+u"\u00E1"+"veis", "varicela", "varicelas",
"vasca", "vascas", "vasco", "vasculh"+u"\u00E1"+"veis", "vasoativ"+u"\u00E1"+"veis", "vasoativo",
"vasodilat"+u"\u00E1"+"veis", "vassala", "vassalas", "vassalo", "vassoira", "vassoirais",
"vassoiras", "vassoura", "vassouras", "vasta", "vastas", "vasto",
"vaticin"+u"\u00E1"+"veis", "vavuco", "vazia", "vazias", "vazio", "vecejo",
"vedais", "ved"+u"\u00E1"+"veis", "vegetais", "veget"+u"\u00E1"+"veis", "veia", "veias",
"veio", "vela", "velas", "velej"+u"\u00E1"+"veis", "velhaca", "velhacas",
"velhaco", "velo", "veludo", "venaliz"+u"\u00E1"+"veis", "vencelho", "vend"+u"\u00E1"+"veis",
"vendo", "veneno", "venerais", "vener"+u"\u00E1"+"veis", "veniaga", "veniagas",
"venta", "ventanejo", "ventas", "vento", "ventura", "venturas",
"verbaliz"+u"\u00E1"+"veis", "verber"+u"\u00E1"+"veis", "verdasca", "verdascas", "verga", "vergais",
"vergas", "vergasta", "vergastas", "verg"+u"\u00E1"+"veis", "vergonha", "vergonhas",
"verific"+u"\u00E1"+"veis", "vermelha", "vermelhais", "vermelhas", "vermelho", "vermina",
"verminais", "verminas", "vernaculiz"+u"\u00E1"+"veis", "vernais", "verno", "verrina",
"verrinas", "verruga", "verrugais", "verrugas", "verruma", "verrumas",
"versais", "vers"+u"\u00E1"+"veis", "versejais", "versej"+u"\u00E1"+"veis", "versific"+u"\u00E1"+"veis", "verso",
"verticaliz"+u"\u00E1"+"veis", "vertiginais", "vesicais", "vestais", "vet"+u"\u00E1"+"veis", "veto",
"vex"+u"\u00E1"+"veis", "viabiliz"+u"\u00E1"+"veis", "viaj"+u"\u00E1"+"veis", "vianda", "viandas", "viatic"+u"\u00E1"+"veis",
"vicejo", "vici"+u"\u00E1"+"veis", "vida", "vidas", "vidrais", "vidro",
"viga", "vigas", "vigor"+u"\u00E1"+"veis", "vigoriz"+u"\u00E1"+"veis", "vilegiatura", "vilegiaturas",
"vilico", "vimo", "vincilho", "vinco", "vincul"+u"\u00E1"+"veis", "vindic"+u"\u00E1"+"veis",
"vindima", "vindimais", "vindimas", "ving"+u"\u00E1"+"veis", "vinhais", "vinho",
"vinific"+u"\u00E1"+"veis", "violais", "viol"+u"\u00E1"+"veis", "violenta", "violentas", "violent"+u"\u00E1"+"veis",
"violento", "virais", "virgul"+u"\u00E1"+"veis", "viriliz"+u"\u00E1"+"veis", "virtuais", "visco",
"visgo", "visibiliz"+u"\u00E1"+"veis", "visit"+u"\u00E1"+"veis", "vislumbro", "viso", "visto",
"vistoria", "vistorias", "vistori"+u"\u00E1"+"veis", "visualiz"+u"\u00E1"+"veis", "vitaliz"+u"\u00E1"+"veis", "vitamina",
"vitaminas", "vitaminiz"+u"\u00E1"+"veis", "vitim"+u"\u00E1"+"veis", "vitrific"+u"\u00E1"+"veis", "vituper"+u"\u00E1"+"veis", "vivenciais",
"vivenci"+u"\u00E1"+"veis", "vivific"+u"\u00E1"+"veis", "vivo", "vizinha", "vizinhais", "vizinhas",
"vizinho", "vocabulariz"+u"\u00E1"+"veis", "vocacionais", "vocaliz"+u"\u00E1"+"veis", "vocifer"+u"\u00E1"+"veis", "vogais",
"volatiliz"+u"\u00E1"+"veis", "volatiz"+u"\u00E1"+"veis", "voltej"+u"\u00E1"+"veis", "voluto", "voo", "vot"+u"\u00E1"+"veis",
"voto", "vozeira", "vozeiras", "vulcaniz"+u"\u00E1"+"veis", "vulgariz"+u"\u00E1"+"veis", "vulnerais",
"vulner"+u"\u00E1"+"veis", "vulto", "vurmo", "xabouco", "xanto", "xaveco",
"xeno", "zabumba", "zabumbas", "zangarilho", "zaragata", "zaragatas",
"zaragatoa", "zaragatoas", "zebra", "zebrais", "zebras", "zelo",
"zero", "zicho", "zimbrais", "zimbro", "zinco", "zirro",
"zona", "zonais", "zonas", "zoncho", "zonza", "zonzas",
"zonzo", "zoo", "zornais", "zuco", "zulo", "zumbeiro",
"zurro"])


posMas = set(["afinal", "agora",
"a"+u"\u00ED", "amanh"+u"\u00E3", "antes", "assim",
"claro", "coitada", "coitado", "confesso", "depois", "enfim",
"entretanto", "hoje", "sim", "sobretudo", "talvez"])


excMas = set(["a", "as", "com", "da", "das", "de", "do", "dos",
"em", "n"+u"\u00E3"+"o", "o", "os", "que", "sem", "um",
"uma"])

# excUgeral  - excecao Plural U Geral - para palavras terminadas em u 
excUgeral = set(["adeu", "campu", "corpu", "ilheu", "juventu", "manau",
"marcu", "mateu", "onibu", "onu", "plu", "pu", "statu", "venu", "viniciu",
"viru", "zeu"])


# excAos = Execao para palavras que nao variam em determinadas situacoes - regra do plural para o singular
excAos = set(["a", "ao", "agora", "amba", "ambo", "ante", "ao", "as", "cada",
"catorze", "cerca", "cinco", "cinquenta", "como", "da", "daquela", "daquele",
"daquilo", "de", "dela", "dele", "dessa", "desse", "desta", "deste",
"dezanove", "dezassete", "dezenove", "dezessete", "dezoito", "do", "doze",
"e", "ela", "entre", "exclusivamente", "extra", "giga", "gravemente",
"infelizmente", "infinitamente", "inter", "injustamente", "me", "mega", "meia",
"meio", "meno", "mini", "muito", "na", "nada", "nessa", "nesse", "nesta",
"neste", "no", "nove", "noventa", "numa", "nunca", "oitenta", "oito", "onze",
"outrora", "perpetuamente", "para", "pouca", "pouco", "pura", "quanta",
"quarenta", "quase", "quatorze", "quatro", "que", "quinze", "sessenta",
"sete", "setenta", "sua", "suas", "treze", "todo", "trinta", "vinte", "zero"])

# aacCao = Concordancia Feminino - masculino - substantivos - adjetivos  terminados em -a-  e  -o-
aacCao = {"a": "o", "A": "O"}

# aacCrase = Concordancia Feminino - masculino - substantivos - adjetivos  terminados em -a-  e  -o-
aacCrase = {u"\u00E0": "a", u"\u00C0": "A"}



# aacCfm = Concordancia Feminino - masculino - substantivos - adjetivos  terminados em or
aacCfm = {"alguma": "algum",
"Amiga": "Amigo",
"amiga": "amigo",
"antiga": "antigo",
"aquela": "aquele",
"boa": "bom",
"Cara": "Caro",
"cara": "caro",
"Da": "Do",
"da": "do",
"digna": "digno",
"Distinta": "Distinto",
"distinta": "distinto",
"Essa": "Esse",
"essa": "esse",
"Esta": "Este",
"esta": "este",
"futura": "futuro",
"leg"+u"\u00ED"+"tima": "leg"+u"\u00ED"+"timo",
"m"+u"\u00E0": "mau",
"mesma": "mesmo",
"minha": "meu",
"muita": "muito",
"Na": "No",
"na": "no",
"nenhuma": "nenhum",
"nona": "nono",
"nossa": "nosso",
"nova": "novo",
"oitava": "oitavo",
"outra": "outro",
"pela": "pelo",
"pouca": "pouco",
"Prezada": "Prezado",
"prezada": "prezado",
"primeira": "primeiro",
"pr"+u"\u00F3"+"pria": "pr"+u"\u00F3"+"prio",
"pr"+u"\u00F3"+"xima": "pr"+u"\u00F3"+"ximo",
"quarta": "quarto",
"quinta": "quinto",
"segunda": "segundo",
"Senhora": "Senhor",
"senhora": "senhor",
"s"+u"\u00E9"+"tima": "s"+u"\u00E9"+"timo",
"sexta": "sexto",
"sua": "seu",
"terceira": "terceiro",
"Uma": "Um",
"uma": "um",
"velha": "velho",
"vossa": "vosso"}

# aacPfas = Concordancia Plural Feminino -  substantivos - adjetivos  terminados em or
aacPfas = {"alguma": "algumas",
"Amiga": "Amigas",
"amiga": "amigas",
"antiga": "antigas",
"aquela": "aquelas",
"boa": "boas",
"Cara": "Caras",
"cara": "caras",
"Da": "Das",
"da": "das",
"digna": "dignas",
"Distinta": "Distintas",
"distinta": "distintas",
"Essa": "Essas",
"essa": "essas",
"Esta": "Estas",
"esta": "estas",
"futura": "futuras",
"leg"+u"\u00ED"+"tima": "leg"+u"\u00ED"+"timas",
"m"+u"\u00E0": "m"+u"\u00E0"+"s",
"mesma": "mesmas",
"minha": "minhas",
"muita": "muitas",
"Na": "Nas",
"na": "nas",
"nenhuma": "nenhumas",
"nona": "nonas",
"nossa": "nossas",
"nova": "novas",
"oitava": "oitavas",
"outra": "outras",
"pela": "pelas",
"pouca": "poucas",
"Prezada": "Prezadas",
"prezada": "prezadas",
"primeira": "primeiras",
"pr"+u"\u00F3"+"pria": "pr"+u"\u00F3"+"prias",
"pr"+u"\u00F3"+"xima": "pr"+u"\u00F3"+"ximas",
"quarta": "quartas",
"quinta": "quintas",
"segunda": "segundas",
"Senhora": "Senhoras",
"senhora": "senhoras",
"s"+u"\u00E9"+"tima": "s"+u"\u00E9"+"timas",
"sexta": "sextas",
"sua": "suas",
"terceira": "terceiras",
"Uma": "Umas",
"uma": "umas",
"velha": "velhas",
"vossa": "vossas"}

# aacPfsa = Concordancia Plural Feminino -  substantivos - adjetivos  terminados em or
aacPfsa = {"alguma": "algumas",
"Amigas": "Amiga",
"amigas": "amiga",
"antigas": "antiga",
"aquelas": "aquela",
"boas": "boa",
"Caras": "Cara",
"caras": "cara",
"Das": "Da",
"das": "da",
"dignas": "digna",
"Distintas": "Distinta",
"distintas": "distinta",
"Essas": "Essa",
"essas": "essa",
"Estas": "Esta",
"estas": "esta",
"futuras": "futura",
"leg"+u"\u00ED"+"timas": "leg"+u"\u00ED"+"tima",
"m"+u"\u00E0"+"s": "m"+u"\u00E0",
"mesmas": "mesma",
"minhas": "minha",
"muitas": "muita",
"Nas": "Na",
"nas": "na",
"nenhumas": "nenhuma",
"nonas": "nona",
"nossas": "nossa",
"novas": "nova",
"oitavas": "oitava",
"outras": "outra",
"pelas": "pela",
"poucas": "pouca",
"Prezadas": "Prezada",
"prezadas": "prezada",
"primeiras": "primeira",
"pr"+u"\u00F3"+"prias": "pr"+u"\u00F3"+"pria",
"pr"+u"\u00F3"+"ximas": "pr"+u"\u00F3"+"xima",
"quartas": "quarta",
"quintas": "quinta",
"segundas": "segunda",
"Senhoras": "Senhora",
"senhoras": "senhora",
"s"+u"\u00E9"+"timas": "s"+u"\u00E9"+"tima",
"sextas": "sexta",
"suas": "sua",
"terceiras": "terceira",
"Umas": "Uma",
"umas": "uma",
"velhas": "velha",
"vossas": "vossa"}



# conCfm = Concordancia Feminino - masculino - substantivos - adjetivos
conCfm = set(["alguma", "Amiga",  "amiga", "antiga", "aquela", "boa", "Cara",
"cara", "Da", "da", "digna", "Essa", "essa", "Esta", "esta", "futura",
"leg"+u"\u00ED"+"tima", "m"+u"\u00E0", "mesma", "minha", "muita", "Na", "na",
"nenhuma", "nona", "nossa", "nova", "oitava", "outra", "pela", "pouca",
"Prezada", "prezada", "primeira", "pr"+u"\u00F3"+"pria", "pr"+u"\u00F3"+"xima",
"quarta", "quinta", "segunda", "s"+u"\u00E9"+"tima", "sexta", "sua",
"terceira", "Uma", "uma", "velha", "vossa"])

# conPf = Concordancia Plural Feminino - substantivos - adjetivos
conPf = set(["algumas", "Amigas",  "amigas", "antigas", "aquelas", "boas", "Caras",
"caras", "Das", "das", "dignas", "Essas", "essas", "Estas", "estas", "futuras",
"leg"+u"\u00ED"+"timas", "m"+u"\u00E0"+"s", "mesmas", "minhas", "muitas", "Nas",
"nas", "nenhumas", "nonas", "nossas", "novas", "oitavas", "outras", "pelas",
"poucas", "Prezadas", "prezadas", "primeiras", "pr"+u"\u00F3"+"prias",
"pr"+u"\u00F3"+"ximas", "quartas", "quintas", "segundas",
"s"+u"\u00E9"+"timas", "sextas", "suas",
"terceiras", "Umas", "umas", "velhas", "vossas"])


# aacCmf = Concordancia  Masculino - feminino substantivos - adjetivos
aacCmf = {"algum": "alguma",
"Amigo": "Amiga",
"amigo": "amiga",
"antigo": "antiga",
"aquele": "aquela",
"bom": "boa",
"Caro": "Cara",
"caro": "cara",
"Do": "Da",
"do": "da",
"digno": "digna",
"Distinto": "Distinta",
"distinto": "distinta",
"Esse": "Essa",
"esse": "essa",
"Este": "Esta",
"este": "esta",
"futuro": "futura",
"leg"+u"\u00ED"+"timo": "leg"+u"\u00ED"+"tima",
"mau": "m"+u"\u00E0",
"meu": "minha",
"nenhum": "nenhuma",
"No": "Na",
"no": "na",
"nono": "nona",
"nosso": "nossa",
"novo": "nova",
"oitavo": "oitava",
"outro": "outra",
"pelo": "pela",
"Prezado": "Prezada",
"prezado": "prezada",
"pr"+u"\u00F3"+"prio": "pr"+u"\u00F3"+"pria",
"pr"+u"\u00F3"+"ximo": "pr"+u"\u00F3"+"xima",
"quarto": "quarta",
"quinto": "quinta",
"Senhor": "Senhora",
"senhor": "senhora",
"s"+u"\u00E9"+"timo": "s"+u"\u00E9"+"tima",
"seu": "sua",
"sexto": "sexta",
"terceiro": "terceira",
"Um": "Uma",
"um": "uma",
"velho": "velha",
"vosso": "vossa"}

# aacPmos = Concordancia  Plural Masculino - substantivos - adjetivos
aacPmos = {"algum": "alguns",
"Amigo": "Amigos",
"amigo": "amigos",
"antigo": "antigos",
"aquele": "aqueles",
"bom": "bons",
"Caro": "Caros",
"caro": "caros",
"Do": "Dos",
"do": "dos",
"digno": "dignos",
"Distinto": "Distintos",
"distinto": "distintos",
"Esse": "Esses",
"esse": "esses",
"Este": "Estes",
"este": "estes",
"futuro": "futuros",
"leg"+u"\u00ED"+"timo": "leg"+u"\u00ED"+"timos",
"mau": "maus",
"meu": "meus",
"nenhum": "nenhuns",
"No": "Nos",
"no": "nos",
"nono": "nonos",
"nosso": "nossos",
"novo": "novos",
"oitavo": "oitavos",
"outro": "outros",
"pelo": "pelos",
"Prezado": "Prezados",
"prezado": "prezados",
"pr"+u"\u00F3"+"prio": "pr"+u"\u00F3"+"prios",
"pr"+u"\u00F3"+"ximo": "pr"+u"\u00F3"+"ximos",
"quarto": "quartos",
"quinto": "quintos",
"Senhor": "Senhores",
"senhor": "senhores",
"s"+u"\u00E9"+"timo": "s"+u"\u00E9"+"timos",
"seu": "seus",
"sexto": "sextos",
"terceiro": "terceiros",
"Um": "Uns",
"um": "uns",
"velho": "velhos",
"vosso": "vossos"}

# aacPmso = Concordancia  Plural Masculino - substantivos - adjetivos
aacPmso = {"algum": "alguns",
"Amigos": "Amigo",
"amigos": "amigo",
"antigos": "antigo",
"aqueles": "aquele",
"bons": "bom",
"Caros": "Caro",
"caros": "caro",
"Dos": "Do",
"dos": "do",
"dignos": "digno",
"Distintos": "Distinto",
"distintos": "distinto",
"Esses": "Esse",
"esses": "esse",
"Estes": "Este",
"estes": "este",
"futuros": "futuro",
"leg"+u"\u00ED"+"timos": "leg"+u"\u00ED"+"timo",
"maus": "mau",
"meus": "meu",
"nenhuns": "nenhum",
"Nos": "No",
"nos": "no",
"nonos": "nono",
"nossos": "nosso",
"novos": "novo",
"oitavos": "oitavo",
"outros": "outro",
"pelos": "pelo",
"Prezados": "Prezado",
"prezados": "prezado",
"pr"+u"\u00F3"+"prios": "pr"+u"\u00F3"+"prio",
"pr"+u"\u00F3"+"ximos": "pr"+u"\u00F3"+"ximo",
"quartos": "quarto",
"quintos": "quinto",
"Senhores": "Senhor",
"senhores": "senhor",
"s"+u"\u00E9"+"timos": "s"+u"\u00E9"+"timo",
"seus": "seu",
"sextos": "sexto",
"terceiros": "terceiro",
"Uns": "Um",
"uns": "um",
"velhos": "velho",
"vossos": "vosso"}


# conCmf = Concordancia Masculino - Feminino - substantivos - adjetivos
conCmf = set(["algum", "Amigo", "amigo", "antigo", "aquele", "bom", "Caro",
"caro", "Do", "do", "digno", "Distinto", "distinto", "Esse", "esse", "Este", "este",
"futuro", "leg"+u"\u00ED"+"timo", "mau", "meu", "nenhum", "No", "no", "nono",
"nosso", "novo", "oitavo", "outro", "pelo", "Prezado", "prezado",
"pr"+u"\u00F3"+"prio", "pr"+u"\u00F3"+"ximo", "quarto", "quinto", "Senhor",
"senhor", "s"+u"\u00E9"+"timo", "seu", "sexto", "terceiro", "Um", "um",
"velho", "vosso"])

# conPm = Concordancia Plural Masculino - substantivos - adjetivos
conPm = set(["alguns", "Amigos", "amigos", "antigos", "aqueles", "bons",
"Caros", "caros", "Dos", "dos", "dignos", "Distintos", "distintos", "Esses",
"esses", "Estes", "estes", "futuros", "leg"+u"\u00ED"+"timos", "maus",
"meus", "nenhuns", "Nos", "nos", "nonos", "nossos", "novos", "oitavos",
"outros", "pelos", "Prezados", "prezados", "pr"+u"\u00F3"+"prios",
"pr"+u"\u00F3"+"ximos", "quartos", "quintos", "Senhores", "senhor",
"s"+u"\u00E9"+"timo", "seu", "sexto", "terceiro", "Uns", "uns",
"velhos", "vossos"])


# excMentes = Execao para palavras com - mente - que admitem plural -s-
excMentes = set(["acampamentense", "alimenteira", "alimenteiro",
"casamenteira", "casamenteiro", "cimenteira", "cimenteiro", "clemente",
"demente", "deprimente", "dormente", "entremente", "fermentelense",
"fremente", "gemente", "inclemente", "juramenteira", "juramenteiro",
"livramentense", "mente", "mentecapta", "mentecapto", "moimentense",
"monumentense", "movimentense", "pimenteiralense", "pimenteira",
"pimenteirense", "pimenteiro", "pimentense",  "premente", "pseudodemente",
"semente", "sementeira", "sementeiro", "temente", "testamenteira",
"testamenteiro", "tremente", "veemente", "vestimenteira", "vestimenteiro"])


# excMento palavras terminadas em mento - excecao a regra
excMento = set(["a", "aci", "ador", "aju", "ajura", "ali", "ama", "apara",
"api", "ator", "autola", "bisseg", "ce", "co", "coag", "comparti",
"comple", "conjura", "cumpri", "de", "decre", "des", "desci",
"desma", "desor"+u"\u00E7"+"a", "despara", "despavi", "despig",
"desseg", "dor", "e", "empara", "ense", "escar", "escra",
"esto", "experi", "ferra", "fo", "frag", "funda", "hemossedi",
"imple", "incre", "la", "leni", "lini", "macrosseg", "metassedi",
"movi", "orna", "para", "pedi", "predica", "reali", "reimple",
"repavi", "retroali", "sacra", "salpi", "se", "seg", "suple",
"transcomple"])


# excIsta palavras terminadas em ista que nao admitem variacao de genero
excIsta = set(["Avista", "avista", "Boavista", "Consista", "consista",
"Desista", "desista", "Exista", "exista", "Entrevista", "entrevista",
"Insista", "insista", "Invista", "invista", "Lista", "lista", "Mista", "mista",
"Persista", "persista", "Pista", "pista", "Prevista", "prevista",
"Resista", "resista", "Revista", "revista", "Vista", "vista"])


# excAdo palavras terminadas em ado e ido  que nao admitem variacao de genero ou com variacao rara
excAdo = set(["almoxarif", "arcebisp", "atent", "c", "cade", "c"+u"\u00E1"+"g",
"caj", "calif", "cond", "consul", "c"+u"\u00F4"+"vado", "cup", "d", "duc",
"eleitor", "emir", "episcop", "euromerc", "f"+u"\u00ED"+"g", "g",
"hipermerc", "hortomerc", "juiz", "mar", "merc", "microd",
"miniatent", "minigram", "minimerc", "minitecl",
"multialmoxarif", "multimerc", "n", "operari", "pr", "presbiter",
"princip", "proletari", "protetor",
"reitori", "s"+u"\u00E1"+"b", "s", "sample", "sen", "servoacion",
"superfadig", "supermerc", "supersold", "t", "tecl", "xax"])

# excFeMfoa palavras femininas terminadas em a e masculinas mfoa
excFeMfoa = set(["maioria"])




# plMascovb - substantivos masculinos tambem encontrados em conjugacoes verbais. Ex. roubo, acerto, conserto
plMascovb = set(["ababalho", "abafo", "abalo", "abano", "abanico",
"abelhudo", "abono", "abordo", "aborto", "abra"+u"\u00E7"+"o",
"abrigo", "abrolho", "abrunho", "a"+u"\u00E7"+"aimo", "acalanto",
"acalento", "a"+u"\u00E7"+"almo", "acato", "aceiro", "aceno",
"acerbo", "acerto", "acervo", "achego", "acolheito",
"aconchego", "acosto", "acrescento", "adejo", "adere"+u"\u00E7"+"o",
"adestro", "adjunto", "adunco", "afeito", "afixo",
"afogo", "afoito", "agasalho", "agoiro", "agoirento",
"agouro", "agourento", "agravio", "aio", "ajoujo",
"alanco", "aldrabo", "aldravo", "alegro", "alfabeto",
"algarvio", "algueiro", "alimento", "alinhavo", "almejo",
"alquino", "alterno", "alvacento", "alveiro", "alvoro"+u"\u00E7"+"o",
"amanho", "amarelento", "amasio", "amasso", "amea"+u"\u00E7"+"o",
"amuo", "ancho", "andarilho", "andejo", "anelo",
"anexo", "anilho", "antolho", "anzolo", "apanho",
"aparato", "apedrejo", "apeiro", "aperto", "apoceiro", "apoio",
"aquaplano", "arcaboi"+u"\u00E7"+"o", "arcabou"+u"\u00E7"+"o", "argueiro", "armadilho",
"arneiro", "arpejo", "arquejo", "arranco", "arrasto",
"arrastro", "arrebito", "arrega"+u"\u00E7"+"o", "arreganho", "arreneiro",
"arrepio", "arrocho", "arrolho", "arrufo", "arrulho", "artefato",
"asneiro", "assento", "asserto", "assombro", "assopro",
"assovio", "atafego", "aterro", "atilho", "atino",
"atocho", "atraso", "atulho", "avan"+u"\u00E7"+"o", "avio",
"azulejo", "bacelo", "bacorejo", "bafejo", "bafordo",
"balbucio", "baldo", "bambino", "bamburro", "banzo",
"barafundo", "barbelo", "bardo", "barreno", "barulho",
"basto", "batouro", "bedelho", "bei"+u"\u00E7"+"o", "beijo",
"belisco", "beloiro", "belouro", "benquisto", "besoiro",
"bibico", "bicarpelo", "bichano", "bicromato", "bilro",
"bimbalho", "bingo", "birro", "biscato", "biscoito",
"bispo", "bloco", "boato", "bocanho", "bocejo",
"bochacro", "bochecho", "bochincho", "bofeto", "boquejo",
"borboto", "borco", "borcelo", "bordo", "borrego",
"borrifo", "bosquejo", "boteco", "brejeiro", "brilho",
"brinco", "broco", "brolho", "broto", "bufo", "bugalho",
"bumbo", "bunho", "burgo", "burrico", "cabotino",
"cabrito", "cacarejo", "cachimbo", "cacho", "cachoeiro", "cachucho",
"cacifo", "cadastro", "cadelo", "caduco", "caibro",
"calaceiro", "calo", "calco", "cal"+u"\u00E7"+"o", "calefrio",
"calemburgo", "cambaio", "cambalacho", "cambito", "campeiro",
"campino", "cancelo", "canto", "canudo", "canutilho",
"capoeiro", "capricho", "capucho", "caramelo", "carango",
"carbono", "carbonato", "carboneto", "carbonilo", "carboxilo",
"cardanho", "carepo", "cargo", "carijo", "carneiro",
"carpento", "carpinteiro", "carrego", "carreto", "carujo",
"caruncho", "cascalho", "cascavelo", "cascunho", "casmurro",
"caspacho", "casquilho", "casti"+u"\u00E7"+"o", "castigo", "catano",
"catracego", "catraio", "caudilho", "causo", "cavaco",
"cerco", "cerebelo", "cerro", "chabouco", "chafalho",
"chaleiro", "chambrego", "chamego", "chanasco", "chanfro",
"changueiro", "chapisco", "chapodo", "chapu"+u"\u00E7"+"o", "chaqui"+u"\u00E7"+"o",
"charango", "charuto", "chasco", "checo", "chichelo",
"chichorrobio", "chino", "chincalho", "chiqueiro", "chisco",
"chocalho", "choco", "chocho", "choito", "chono",
"choro", "chorro", "choto", "chouso", "chu"+u"\u00E7"+"o",
"chuma"+u"\u00E7"+"o", "chumbo", "churdo", "churrio", "chuvenisco",
"chuvilho", "chuvisco", "cianeto", "circuito", "cisco",
"claustro", "coalho", "cochilo", "coculo", "codejo",
"cogumelo", "coino", "coiso", "colapso", "colo",
"colma"+u"\u00E7"+"o", "colmo", "comarco", "combusto", "come"+u"\u00E7"+"o",
"comento", "comoro", "compacto", "compe"+u"\u00E7"+"o", "complemento",
"compromisso", "conapo", "conceito", "conchavo", "concreto",
"confeito", "conforto", "conserto", "conservo", "consogro", "consolo",
"consumo", "conto", "contorno", "contrasseguro", "contrasselo", "contrato",
"controlo", "convulso", "corcovo", "corisco", "corricho",
"corripo", "coscoro", "cotanilho", "coto", "couto",
"covacho", "cromo", "cromofotolito", "cuanho", "curro", "curso",
"curto-circuito", "curvo", "curvejo", "custo", "dardo",
"debuxo", "decerto", "decoro", "decremento", "decreto",
"dedo", "degredo", "dejeto", "denodo", "descalabro",
"descalavro", "desconto", "descoberto", "desenho", "desgosto", "desnudo", "desonesto", "despenho",
"desperto", "destino", "desvairo", "dialecto", "dialeto",
"disperso", "direto", "domo", "domingo", "dorminhoco", "dreno",
"echacorvo", "edito", "eixo", "elenco", "embara"+u"\u00E7"+"o",
"embo"+u"\u00E7"+"o", "embolso", "embrulho", "emparamento", "empe"+u"\u00E7"+"o",
"empecilho", "empelo", "empeno", "empenho", "empeso", "emprego",
"empupo", "empuxo", "enastro", "encabreimo", "encal"+u"\u00E7"+"o",
"encalho", "encanho", "encargo", "encoberto", "encoito",
"encontro", "encosto", "encouto", "endere"+u"\u00E7"+"o", "enduro",
"enforro", "engaldrapo", "engo", "engaranho", "engasgo",
"engenho", "engui"+u"\u00E7"+"o", "enlevo", "enredo", "enseio",
"ensejo", "ensino", "ensosso", "entolho", "entorno",
"entrefolho", "entreoculto", "entreolho", "entrevero", "entro"+u"\u00E7"+"o",
"entrope"+u"\u00E7"+"o", "entrudo", "entulho", "entusiasmo", "envio", "envinhadalho",
"envisgo", "enxabelho", "enxal"+u"\u00E7"+"o", "enxaugo", "enxeco",
"enxerto", "enxurro", "ero", "erro", "erudito",
"esbalho", "esbarrunto", "esbirro", "esbo"+u"\u00E7"+"o", "esbulho",
"escabelo", "escacilho", "escafelo", "escalambro", "escalavro",
"escaldo", "escalpo", "escambo", "escambro", "escapo",
"escarafuncho", "escarda"+u"\u00E7"+"o", "escarmento", "escarro", "escassilho",
"escocho", "esconjuro", "escorricho", "escou"+u"\u00E7"+"o", "escovalho",
"escravelho", "escrucho", "escudo", "escurento", "escuso", "esfoiro",
"esfor"+u"\u00E7"+"o", "esfregulho", "esfumilho", "esgalho", "esgrafito",
"esguicho", "esmero", "esmicho", "esmor"+u"\u00E7"+"o", "espalhafato",
"esparro", "esparrimo", "espartilho", "espasmo", "espincho",
"espirro", "esquadro", "esqui"+u"\u00E7"+"o", "estalo", "estaleiro",
"estanco", "estardalha"+u"\u00E7"+"o", "esteiro", "estilha"+u"\u00E7"+"o", "estofo",
"estojo", "estorvo", "estouro", "estrago", "estralo",
"estrambelho", "estrampalho", "estribo", "estribilho", "estroixo",
"estudo", "exagero", "exalo", "exaspero", "exausto",
"excurso", "experimento", "expiro", "extracto", "extravaso",
"extravio", "facho", "fajuto", "falho", "falto",
"fandango", "fanico", "fanicho", "fanuco", "fardo",
"farelo", "fasto", "fecho", "fecundo", "fedelho",
"fedonho", "feltro", "fendrelho", "ferrolho", "festino",
"filo", "filhastro", "findo", "firro", "flaino",
"floco", "fogacho", "foleco", "folho", "fomento",
"formato", "forta"+u"\u00E7"+"o", "fracasso", "fragmento", "frangalho",
"freso", "frito", "froco", "froixo", "fronteiro",
"frulho", "fueiro", "fundalho", "fundilho", "fundo", "funfo",
"furto", "fuso", "gabarito", "gadanho", "gadi"+u"\u00E7"+"o",
"gaio", "gaiato", "galgo", "galimo", "galricho",
"gamenho", "gan"+u"\u00E7"+"o", "garfo", "gargalejo", "gargarejo",
"garrancho", "garro", "garrulejo", "gatafunho", "gatuno",
"gemelgo", "gesso", "gingro", "golfo", "gongo",
"gorgorejo", "gosto", "governicho", "gracejo", "grampo", "graveto",
"grelo", "grifo", "grinfo", "grisalho", "grito",
"grogolejo", "grumo", "guedelho", "guincho", "guizo",
"heliporto", "hidrocarbono", "hirto", "ichacorvo", "implemento",
"importuno", "improviso", "incesto", "incremento", "indulto",
"ingresso", "insosso", "insulto", "interdito", "interino",
"intestino", "inverno", "iodo", "isento", "janelo",
"jorro", "jugo", "junco", "labelo", "lacaio",
"ladrilho", "lamento", "lamino", "lampo", "lampejo",
"lan"+u"\u00E7"+"o", "largo", "lastro", "latejo", "leigo",
"leito", "lenho", "libelo", "linimento", "linotipo",
"lixo", "lombilho", "lucro", "lustro", "luxo", "macavenco",
"macio", "macrossegmento", "macuco", "madeiro", "madraceiro",
"maduro", "magulho", "malandro", "malho", "malogro",
"malseguro", "manco", "mando", "manejo", "manhento",
"manifesto", "marco", "marroquino", "mascavo", "matreiro",
"matuto", "menoscabo", "menosprezo", "mergulho", "mesti"+u"\u00E7"+"o",
"metassedimento", "mexerico", "mijo", "mixo", "mocho",
"mofo", "moiro", "molengo", "molesto", "molho",
"monco", "mordomo", "motejo", "muro", "murcho",
"namoro", "namorico", "namoricho", "narciso", "nastro",
"negrito", "nevoento", "nicho", "nicotino", "nicto",
"nimbo", "nitrato", "nitreto", "nitruro", "nodo",
"nojo", "novelo", "octano", "oficio", "olfacto",
"olfato", "onzeneiro", "opalino", "orgulho", "orvalho",
"ouri"+u"\u00E7"+"o", "ousio", "outono", "pacto", "pago",
"paladino", "palanco", "palhi"+u"\u00E7"+"o", "palito", "palmo",
"palpo", "pana"+u"\u00E7"+"o", "pano", "pando", "panfleto",
"pango", "pantomimo", "paparico", "papouco", "paradoxo",
"parafuso", "paraninfo", "parapeito", "parasito", "pardejo",
"parelho", "parolo", "parro", "parrono", "pasmo",
"paspalho", "passo", "patego", "patoilo", "pe"+u"\u00E7"+"onhento", "pedicelo",
"pediplano", "peganho", "pejo", "penacho", "pendurico",
"penico", "penso", "pentelho", "pepino", "peralvilho",
"percal"+u"\u00E7"+"o", "perdigoto", "perigo", "perito", "perjuro",
"pertucho", "peso", "petanisco", "petisco", "petrecho",
"pezunho", "piacho", "pialo", "pio", "picirico",
"pigarro", "piloto", "pimpolho", "pino", "pincho",
"pingalho", "pingo", "pinoco", "pirilampo", "piteiro",
"plaino", "plebiscito", "pleito", "poento", "poio",
"poiso", "pombeiro", "portucho", "posti"+u"\u00E7"+"o", "pouso",
"pranto", "preceito", "predicamento", "prefixo", "prego",
"preito", "preparo", "prescruto", "presigo", "pretexto",
"prisco", "profa"+u"\u00E7"+"o", "profano", "professo", "prospecto",
"protesto", "prumo", "pugilo", "pulo", "pulso",
"punto", "puxo", "quartilho", "quebranto", "quedo",
"queijo", "quimbo", "rabeiro", "rabisco", "rabusco",
"ralo", "ralho", "ran"+u"\u00E7"+"o", "ranfo", "rango",
"rapigo", "rapilho", "rapto", "rascunho", "rasgo",
"raspan"+u"\u00E7"+"o", "rastelo", "rastilho", "rastolho", "ratino",
"realejo", "rebento", "reboli"+u"\u00E7"+"o", "rebu"+u"\u00E7"+"o", "rebuli"+u"\u00E7"+"o",
"reco", "reciclo", "recosto", "recuo", "referto",
"refluxo", "refracto", "rega"+u"\u00E7"+"o", "rego", "regino",
"registo", "regresso", "regueiro", "reino", "reiuno",
"relato", "relho", "relojo", "remanso", "remo",
"remendo", "repleto", "repolho", "repto", "requisito",
"rescaldo", "resgo", "resguardo", "resmungo", "respaldo",
"respeito", "respingo", "respiro", "responto", "ressaibo",
"resto", "restauro", "restito", "restolho", "restrelo",
"resvalo", "retonho", "retorno", "retroalimento", "rigo", "rilo",
"rincho", "ripan"+u"\u00E7"+"o", "risco", "ritmo", "rodopio",
"rodrigo", "rogo", "roli"+u"\u00E7"+"o", "ronco", "roto",
"roubo", "roufenho", "rousso", "rufo", "rumo",
"sabugo", "sabujo", "sacho", "sacholo", "sacramento",
"safano", "safo", "sagorro", "saldo", "salicilo",
"salino", "salmejo", "salmoeiro", "salpico", "salso", "salto",
"salvo", "sambenito", "sanguento", "sapoilo", "sapoulo",
"sarapico", "saro", "sardo", "sarilho", "sarrafo",
"sarro", "segmento", "segredo", "seleto", "septo",
"sepulcro", "sepulto", "sequestro", "seringonho", "serrino",
"seto", "seteiro", "setino", "sexo", "sibilo",
"sigilo", "silicato", "silvo", "sincelo", "sinuco",
"soalho", "sobejo", "soberbo", "sobrecabo", "sobrecasaco",
"sobrerroldo", "sobressalto", "socalco", "socresto", "solavanco",
"solfejo", "solu"+u"\u00E7"+"o", "soneto", "sonho", "sopapo",
"sopro", "soro", "sorvo", "soslaio", "sossego",
"souto", "suco", "sufixo", "sufoco", "sulavento",
"sulco", "sulfato", "sulfeto", "sulfito", "sulfureto",
"suplemento", "surrupio", "surto", "suspiro", "sussurro",
"susto", "sustento", "tabardilho", "taburno", "taco",
"tacho", "taino", "talo", "tamanco", "tanino",
"tardo", "taroco", "tarolo", "tarouco", "tarrinco",
"tarugo", "tasco", "tassalho", "telecomando", "telecurso",
"teleporto", "teletrabalho", "tempero", "templo", "tento",
"terceto", "terramoto", "teso", "tesoiro", "testico",
"tibiro", "tijolo", "tilo", "timbalejo", "tingo",
"tiro", "toco", "toi"+u"\u00E7"+"o", "toiro", "tomo",
"tombo", "topo", "toro", "torcicolo", "torno",
"torpedo", "torvo", "tou"+u"\u00E7"+"o", "touro", "trabalho",
"trabelho", "trabuco", "trabulo", "tracolejo", "trago",
"trajo", "tramo", "trambolho", "tramelo", "transumano",
"traquejo", "trastempo", "trato", "traulito", "travo",
"treino", "treito", "trejeito", "tremelejo", "tremo"+u"\u00E7"+"o",
"treno", "trevisco", "trio", "tributo", "tricalho",
"trino", "tripo", "trissecto", "trissulco", "trito",
"triunfo", "trocadilho", "troco", "tro"+u"\u00E7"+"o", "trombo",
"trono", "tronco", "troncho", "tropo", "trope"+u"\u00E7"+"o",
"trotejo", "truco", "tucano", "tufo", "turbolejo",
"turro", "turturejo", "ufano", "ugalho", "uno",
"undo", "unguento", "urano", "urro", "uso",
"vacilo", "vagamundo", "vago", "valo", "vaqueiro",
"varejo", "vavuco", "vecejo", "veio", "velo",
"vencelho", "vendo", "veneno", "ventanejo", "verno",
"verso", "veto", "vicejo", "vidro", "vilico",
"vinco", "vincilho", "viso", "visco", "visgo",
"vislumbro", "visto", "voo", "voluto", "vulto",
"vurmo", "xabouco", "xanto", "xaveco", "xeno",
"zangarilho", "zelo", "zero", "zicho", "zimbro",
"zinco", "zirro", "zoo", "zoncho", "zonzo",
"zuco", "zulo", "zumbeiro", "zurro"])



# excplMfoa - excecao preposicao A - palavras masculinas terminadas em -o- Ex.: A outros
excplMfoa = set(["cert","outr"])

# excddMfoa - excecao - palavras masculinas terminadas em -o- Ex.: A outros
excddMfoa = set(["mesm", "pr"+u"\u00F3"+"xim", "junt"])

# excplMasco - excecao preposicao A - palavras masculinas terminadas em -o- que nao possui correspondente feminino- Ex.: A principio
excplMasco = set(["crit"+u"\u00E9"+"rio", "exemplo", "longo", "pedido", "ponto", "pretexto", "princ"+u"\u00ED"+"pio", "prop"+u"\u00F3"+"sito", "tempo", "t"+u"\u00ED"+"tulo"])

# exMuiMasco - excecao plural MUITOS - palavras masculinas terminadas em -o- que nao possui correspondente feminino- Ex.: Muito longos
exMuiMasco = set(["longo"])

# plvrMasxo - ESPECIAL - palavras masculinas terminadas em -o- que nao possui correspondente feminino- ano e auto
plvrMasxo = set(["ano", "auto"])

# plvrMasco - palavras masculinas terminadas em -o- que nao possui correspondente feminino-
plvrMasco = set(["abuso", "acento", "ac"+u"\u00F3"+"rd"+u"\u00E3"+"o", "acr"+u"\u00E9"+"scimo",
"actinomiceto", "adult"+u"\u00E9"+"rio", "adv"+u"\u00E9"+"rbio", "af"+u"\u00ED"+"dio",
"alabardeiro", "alde"+u"\u00E3"+"o", "alelo", "alfarr"+u"\u00E1"+"bio",
"algoritmo", "al"+u"\u00ED"+"vio", "almoxarifado", "alt"+u"\u00ED"+"metro",
"amentilho", "amper"+u"\u00ED"+"metro", "amuleto",
"anci"+u"\u00E3"+"o", "anda"+u"\u00E7"+"o", "andanho", "andrajo",
"anfiteatro", u"\u00E2"+"ngulo", "anho", "animalejo",
"anteprojeto", "anticorpo", "antig"+u"\u00EA"+"nio",
"antro", "an"+u"\u00FA"+"ncio", "anuro", "aparelho",
"apedido", "aplauso", "aposento", "aqueduto",
"arauto", "arb"+u"\u00ED"+"trio", "arbusto", "arcebispado",
"arcebispo", "arenito", "arilho", "arm"+u"\u00E1"+"rio",
"arqueg"+u"\u00F4"+"nio", "arqu"+u"\u00E9"+"tipo", "arquip"+u"\u00E9"+"lago",
"arquivo", "arranjo", "arreio", "artelho", "artes"+u"\u00E3"+"o",
"artif"+u"\u00ED"+"cio", "artigo", "arvoredo", "aspecto",
"assassinato", "assass"+u"\u00ED"+"nio", "assunto", "atentado", u"\u00E1"+"tomo",
"atributo", "ausp"+u"\u00ED"+"cio", "autocarro",
"autoconsumo", "autodom"+u"\u00ED"+"nio", "autogiro", "autogoverno", "aut"+u"\u00F3"+"grafo",
"autorretrato", "aux"+u"\u00ED"+"lio", "ax"+u"\u00F4"+"nio", "babu"+u"\u00ED"+"no",
"bacano", "baf"+u"\u00F4"+"metro", "bairro", "balcedo", "b"+u"\u00E1"+"lsamo", "balsero",
"bamb"+u"\u00FA"+"rrio", "b"+u"\u00E1"+"ratro", "barbit"+u"\u00FA"+"rico", "bardino",
"baronato", "basalto", "bas"+u"\u00ED"+"dio", "basidiocarpo",
"basidiomiceto", "bat"+u"\u00F3"+"lito", "bebedouro", "benef"+u"\u00ED"+"cio",
"benzopireno", "ber"+u"\u00E7"+u"\u00E1"+"rio", "bicampeonato", "bicoco",
"bin"+u"\u00F3"+"culo", "bin"+u"\u00F4"+"mio", "biombo", "biorritmo",
"bi"+u"\u00F3"+"topo", "bi"+u"\u00F3"+"xido", "bloco", "b"+u"\u00F3"+"cio", "bolbilho",
"bolbo", "bolero", "borato", "bororo",
"borrelho", "braco", "brinquedo", "brometo",
"br"+u"\u00F4"+"nquio", "bruxedo", "bu"+u"\u00E7"+"o", "bulbo",
"busto", "buxo", "b"+u"\u00FA"+"zio", "cabelo", "cabo",
"cabrestilho", "cabresto", "cacareco", "cacto",
"cadeado", "caderno", "c"+u"\u00E1"+"gado", "caixilho", "cajado",
"calabou"+u"\u00E7"+"o", "calafrio", "calangro", "c"+u"\u00E1"+"lculo", "calend"+u"\u00E1"+"rio",
"calhama"+u"\u00E7"+"o", "califado", "c"+u"\u00E2"+"mbio", "campeonato", "campo",
"camundongo", "candelabro", "c"+u"\u00E2"+"ntico", "carboidrato",
"carb"+u"\u00FA"+"nculo", "carro", "cartap"+u"\u00E1"+"cio", "cartucho",
"cat"+u"\u00E1"+"logo", "cavalheiro", "cedro", "celacanto", "cemit"+u"\u00E9"+"rio",
"cen"+u"\u00E1"+"rio", "censo", "cent"+u"\u00ED"+"metro", "c"+u"\u00E9"+"rebro",
"cet"+u"\u00E1"+"ceo", "chaparro", "cesto", "cestinho",
"chimango", "chuvisqueiro", "ciclamato", "cidad"+u"\u00E3"+"o",
"c"+u"\u00ED"+"lio", "cincerro", "circo", "c"+u"\u00ED"+"rculo",
"c"+u"\u00ED"+"rio", "cirro", "clad"+u"\u00F3"+"dio", "clorofluorcarboneto",
"co"+u"\u00E1"+"gulo", "c"+u"\u00F3"+"digo", "coentro", "col"+u"\u00E9"+"gio",
"colmilho", "colonato", "colono", "col"+u"\u00F3"+"quio",
"colosso", "comando", "com"+u"\u00ED"+"cio", "c"+u"\u00F4"+"moro",
"comp"+u"\u00EA"+"ndio",
"concelho", "condado", "condom"+u"\u00ED"+"nio", "congresso", "conjunto",
"conselho", "consenso", "cons"+u"\u00F3"+"cio", "cons"+u"\u00F3"+"rcio",
"consulado", "conte"+u"\u00FA"+"do", "contexto", "contrabando", 
"contrassenso", "contratempo",
"contributo", "conv"+u"\u00EA"+"nio", "convento", "coradouro",
"corimbo", "cormo", "corniso", "corpo", "corp"+u"\u00FA"+"sculo",
"cors"+u"\u00E1"+"rio", "cotovelo", "c"+u"\u00F4"+"vado", "cr"+u"\u00E9"+"dito",
"crep"+u"\u00FA"+"sculo", "crist"+u"\u00E3"+"o", "crit"+u"\u00E9"+"rio",
"crocodilo", "cron"+u"\u00F4"+"metro", "cruzeiro",
"cub"+u"\u00ED"+"culo", "c"+u"\u00FA"+"mulo", "cupido", "curr"+u"\u00ED"+"culo", "damasco",
"dec"+u"\u00E2"+"metro", "dec"+u"\u00EA"+"nviro", "dec"+u"\u00ED"+"metro", "decl"+u"\u00ED"+"nio",
"defeito", "defluxo", "defumadoiro", "del"+u"\u00ED"+"rio", "delito", "dem"+u"\u00E9"+"rito",
"demiurgo", "dem"+u"\u00F4"+"nio", "dent"+u"\u00ED"+"culo", "dep"+u"\u00F3"+"sito",
"desafio", "des"+u"\u00E1"+"gio", "des"+u"\u00E2"+"nimo", "desequil"+u"\u00ED"+"brio", "desiderato",
"des"+u"\u00ED"+"gnio", "densit"+u"\u00F4"+"metro", "desmando", "despenhadeiro", "desperd"+u"\u00ED"+"cio", "desporto",
"desprop"+u"\u00F3"+"sito", "desv"+u"\u00E3"+"o", "detrito", "diacho",
"di"+u"\u00E1"+"cono", "di"+u"\u00E1"+"logo", "di"+u"\u00E2"+"metro", "dieno",
"diestro", "diferendo", "d"+u"\u00ED"+"gito", "dil"+u"\u00FA"+"vio",
"d"+u"\u00ED"+"namo", "dinheiro", "dinoss"+u"\u00E1"+"urio", "dinossauro",
"diodo", "dipept"+u"\u00ED"+"dio", "dipolo", "d"+u"\u00ED"+"scolo",
"disp"+u"\u00EA"+"ndio", "dispens"+u"\u00E1"+"rio", "diss"+u"\u00ED"+"dio", "distrito",
"dist"+u"\u00FA"+"rbio", "dit"+u"\u00E9"+"rio", "ditirambo", "dividendo",
"div"+u"\u00F3"+"rcio", "dolo", "domic"+u"\u00ED"+"lio", "dom"+u"\u00ED"+"nio",
"dorso", "ducado", "ducto", "duto",
"edif"+u"\u00ED"+"cio", "educando", "efeito", "efl"+u"\u00FA"+"vio",
"eleitorado","eletrodo", "eletr"+u"\u00F3"+"lito", "elmo", "eloendro",
"emirado", "emirato", "empr"+u"\u00E9"+"stimo", "enc"+u"\u00F4"+"mio",
"end"+u"\u00F3"+"sporo", "enteropneusto", "entretanto", "e"+u"\u00F3"+"lito",
"epicentro", "episcopado", "epis"+u"\u00F3"+"dio", "epit"+u"\u00E1"+"fio", "epital"+u"\u00E2"+"mio",
"ep"+u"\u00ED"+"teto", "ep"+u"\u00F3"+"xido", "equil"+u"\u00ED"+"brio", "equin"+u"\u00F3"+"cio",
"er"+u"\u00E1"+"rio", "eri"+u"\u00F3"+"foro", "eritr"+u"\u00F3"+"cito", "esc"+u"\u00E2"+"ndalo",
"escapul"+u"\u00E1"+"rio", "esc"+u"\u00E1"+"rnio", "esconderijo", "escopro",
"escr"+u"\u00FA"+"pulo", "espa"+u"\u00E7"+"o", "espantalho", "espargo", "espectro",
"espectr"+u"\u00F4"+"metro", "espet"+u"\u00E1"+"culo", "espir"+u"\u00E1"+"culo", "espirilo",
"esp"+u"\u00F3"+"lio", "espor"+u"\u00E2"+"ngio", "espor"+u"\u00F3"+"filo", "ess"+u"\u00EA"+"nio",
"est"+u"\u00E1"+"bulo", "est"+u"\u00E1"+"gio", "estatuto", "estearato",
"estegossauro", "estendedoiro", "estere"+u"\u00F3"+"tipo", "est"+u"\u00ED"+"mulo",
"est"+u"\u00F4"+"mago", "est"+u"\u00F4"+"mato", "estrato", "estr"+u"\u00E9"+"pito",
"estr"+u"\u00F3"+"bilo", "estrog"+u"\u00EA"+"nio", "estrondo", "est"+u"\u00FA"+"dio", "eucalipto",
"eunuco", "euro", "euromercado", "evangelho", "evento",
"excesso","exemplo", "exerc"+u"\u00ED"+"cio", "ex"+u"\u00E9"+"rcito", "externato",
"fag"+u"\u00F3"+"cito", "falhan"+u"\u00E7"+"o", "falucho", "faniquito",
"fanisco", "fasc"+u"\u00ED"+"culo", "fast"+u"\u00ED"+"gio", "fastio",
"feiti"+u"\u00E7"+"o", "feldspato", "fen"+u"\u00F4"+"meno", "fen"+u"\u00F3"+"tipo",
"ferom"+u"\u00F4"+"nio", "feto", "fiapo", "fiasco",
"ficomiceto", "fideicomisso", "f"+u"\u00ED"+"gado", "f"+u"\u00ED"+"garo",
"figueiredo", "filantropo", "fil"+u"\u00F3"+"sofo", "filtro", "flag"+u"\u00ED"+"cio",
"flamingo", "flanco", "fl"+u"\u00F3"+"culo", "fl"+u"\u00F3"+"sculo",
"fluorcarboneto", "fluoreto", "fluxo", "fogo",
"folguedo", "folhelho", "fol"+u"\u00ED"+"culo", "f"+u"\u00F3"+"lio",
"fol"+u"\u00ED"+"olo", "formul"+u"\u00E1"+"rio", "f"+u"\u00F3"+"sforo", "fotod"+u"\u00ED"+"odo",
"fot"+u"\u00F3"+"foro", "fraguedo", "freixo", "frontisp"+u"\u00ED"+"cio",
"fruto", "fulcro", "fulereno", "funcho", "fundo", "fur"+u"\u00FA"+"nculo",
"fuzo", "gabro", "gado", "gafanhoto",
"g"+u"\u00E1"+"lago", "galfarro", "gambozino", "gamet"+u"\u00F3"+"foro",
"gancho", "g"+u"\u00E2"+"nglio", "garbo", "garraio", "g"+u"\u00E1"+"rrulo",
"gastr"+u"\u00F3"+"lito", "gat"+u"\u00E1"+"zio", "gatilho", "geco",
"g"+u"\u00EA"+"nero", "g"+u"\u00EA"+"nio", "genoc"+u"\u00ED"+"dio", "gen"+u"\u00F3"+"tipo",
"genro", "gentio", "ger"+u"\u00E2"+"nio", "gerbo",
"german"+u"\u00F3"+"fono", "gibelino", "gin"+u"\u00E1"+"sio", "girino",
"girondino", "girosc"+u"\u00F3"+"pio", "gl"+u"\u00E1"+"dio", "glasto",
"gliceralde"+u"\u00ED"+"do", "gl"+u"\u00ED"+"cido", "glicos"+u"\u00ED"+"deo", "gl"+u"\u00F3"+"bulo",
"goliardo", "gonzo", "granda"+u"\u00E7"+"o", "gr"+u"\u00E3"+"o",
"gravan"+u"\u00E7"+"o", "gravitino", "gr"+u"\u00EA"+"mio", "gringo",
"grupo", "guardanapo", "guelfo", "haleto", "h"+u"\u00E1"+"lito", "halogeneto",
"hausto", "hecatonquiro", "hem"+u"\u00ED"+"ptero", "hemisf"+u"\u00E9"+"rio",
"hemist"+u"\u00ED"+"quio", "hepat"+u"\u00F3"+"cito", "heterocisto", "hex"+u"\u00E2"+"metro",
"hiato", "hibisco", "hid"+u"\u00E1"+"todo", "hidreto",
"hidrocarboneto", "hidrof"+u"\u00F3"+"lio", "hidroper"+u"\u00F3"+"xido", "hidr"+u"\u00F3"+"xido",
"hieroglifo", "hier"+u"\u00F3"+"glifo", "hipermercado", "hipn"+u"\u00F3"+"sporo", "hip"+u"\u00F3"+"dromo",
"hipogrifo", "hirsuto", "hol"+u"\u00F3"+"tipo", "homic"+u"\u00ED"+"dio",
"homopol"+u"\u00ED"+"mero", "hor"+u"\u00F3"+"scopo", "hosp"+u"\u00ED"+"cio",
"hortomercado", "hussardo",
"ictiossauro", "idioblasto", "imbr"+u"\u00F3"+"glio", "imp"+u"\u00E9"+"rio",
"improp"+u"\u00E9"+"rio", "imunocomplexo", "inc"+u"\u00EA"+"ndio", "incens"+u"\u00E1"+"rio",
"incha"+u"\u00E7"+"o", "ind"+u"\u00ED"+"geno", "inferno", "influxo", "inf"+u"\u00F3"+"lio",
"infort"+u"\u00FA"+"nio", "in"+u"\u00ED"+"cio", "inqu"+u"\u00E9"+"rito", "instinto", "insucesso",
"insurrecto", "intelecto", "interc"+u"\u00E2"+"mbio", "interl"+u"\u00FA"+"dio",
"internato", "intuito", "invent"+u"\u00E1"+"rio", "inv"+u"\u00F3"+"lucro",
"is"+u"\u00F3"+"topo", "jambo", "jan"+u"\u00ED"+"zaro", "jato",
"jazigo", "jeito", "joelho", "jornaleco",
"j"+u"\u00FA"+"bilo", "juizado", "lac"+u"\u00F3"+"lito", "lactic"+u"\u00ED"+"nio",
"lajedo", "lanif"+u"\u00ED"+"cio", "lari"+u"\u00E7"+"o", "l"+u"\u00E1"+"tego",
"latic"+u"\u00ED"+"nio", "latif"+u"\u00FA"+"ndio", "latroc"+u"\u00ED"+"nio", "lavabo",
"len"+u"\u00E7"+"o", "lepidodendro", "letargo", "leuc"+u"\u00F3"+"cito",
"leucotrieno", "libreto", "licop"+u"\u00F3"+"dio", "l"+u"\u00ED"+"dio",
"linf"+u"\u00F3"+"cito", "linfonodo", "lip"+u"\u00ED"+"dio", "l"+u"\u00ED"+"pido",
"lit"+u"\u00ED"+"gio", "litro", "livreco", "livreto", "livro", "lobato",
"l"+u"\u00F3"+"bulo", "l"+u"\u00F3"+"culo", "lodo", "logaritmo",
"logogrifo", "logotipo", "logradouro", "lombelo", "longo",
"longu"+u"\u00ED"+"ssimo", "loranto", "lugarejo", "lusito",
"mabeco", "malacopter"+u"\u00ED"+"gio", "malef"+u"\u00ED"+"cio", "manaixo",
"mandato", "man"+u"\u00F4"+"metro", "maremoto", "maribondo", "marimbondo",
"marido", "mart"+u"\u00ED"+"rio", "mastro", "mastru"+u"\u00E7"+"o",
"matadouro", "matrim"+u"\u00F4"+"nio", "medo", "medinho",
"meg"+u"\u00E1"+"lito", "megaquir"+u"\u00F3"+"ptero", "melan"+u"\u00F3"+"cito", "membro",
"memorando", "meningococo", "mentastro", "mercado", "merc"+u"\u00FA"+"rio",
"m"+u"\u00E9"+"rito", "metab"+u"\u00F3"+"lito", "meteorito", "meteoro",
"m"+u"\u00E9"+"todo", "metro", "micr"+u"\u00F3"+"bio", "microcircuito", "microdado",
"micr"+u"\u00F4"+"metro", "microprotalo",
"microsc"+u"\u00F3"+"pio", "microt"+u"\u00FA"+"bulo", "mijolo", "m"+u"\u00ED"+"ldio",
"mil"+u"\u00ED"+"metro", "miniatentado", "min"+u"\u00E9"+"rio", "miniconcurso", "minigramado",
"minimercado", "minist"+u"\u00E9"+"rio", "miniteclado", "minuto",
"miradouro", "mist"+u"\u00E9"+"rio", "m"+u"\u00F3"+"dulo", "molosso",
"molusco", "mon"+u"\u00F3"+"lito", "monop"+u"\u00F3"+"lio", "monturo",
"mortic"+u"\u00ED"+"nio", "moscardo", "mostru"+u"\u00E1"+"rio", "motociclo",
"motreco", "mult"+u"\u00ED"+"metro", "mundo", "munic"+u"\u00ED"+"pio", "munirmo",
"murm"+u"\u00FA"+"rio", "musaranho", "m"+u"\u00FA"+"sculo", 
"multialmoxarifado", "multimercado", "nababo",
"nabuco", "nan"+u"\u00F4"+"metro", "nasuto", "naufr"+u"\u00E1"+"gio", "n"+u"\u00E1"+"utilo",
"navio", "necrol"+u"\u00F3"+"gio", "nefro", "neg"+u"\u00F3"+"cio",
"nematocisto", "nervo", "neur"+u"\u00F4"+"nio", "neutrino",
"nexo", "n"+u"\u00ED"+"scaro", "nitrito", "n"+u"\u00F3"+"dulo",
"notici"+u"\u00E1"+"rio", "n"+u"\u00FA"+"cleo", "nucle"+u"\u00F3"+"tido", "n"+u"\u00FA"+"mero",
"nuno", "obelisco", "obst"+u"\u00E1"+"culo", "ocaso",
"ocean"+u"\u00E1"+"rio", "oceano", "ocelo", "of"+u"\u00ED"+"cio",
"oleoduto", "oligop"+u"\u00F3"+"lio", "olivedo",
"olmedo", "olmo", "ombro", "op"+u"\u00E9"+"rculo", "operariado",
"opiato", "op"+u"\u00FA"+"sculo", "or"+u"\u00E1"+"culo", "orago",
"orango", "orangotango", "orfanato", "organito",
"orif"+u"\u00ED"+"cio", "ornato", "oss"+u"\u00ED"+"culo", "ot"+u"\u00F3"+"lito",
"ouvido","ov"+u"\u00E1"+"rio", "ov"+u"\u00F3"+"cito", "ovo", "oxi"+u"\u00FA"+"ro",
"pa"+u"\u00E7"+"o", "pag"+u"\u00E3"+"o", "pal"+u"\u00E1"+"cio", "palco", "p"+u"\u00E1"+"lio",
"palmito", "pandeiro", "paneg"+u"\u00ED"+"rico", "p"+u"\u00E2"+"ntano", "paqu"+u"\u00ED"+"metro",
"par"+u"\u00E1"+"grafo", "para"+u"\u00ED"+"so", "paralelep"+u"\u00ED"+"pedo", "par"+u"\u00E2"+"metro",
"par"+u"\u00E1"+"tipo", "p"+u"\u00E1"+"roco", "passatempo", "pat"+u"\u00ED"+"bulo",
"p"+u"\u00E1"+"tio", "patrim"+u"\u00F4"+"nio", "pecadilho", "pec"+u"\u00ED"+"olo",
"peda"+u"\u00E7"+"o", "pedregulho", "pedroi"+u"\u00E7"+"o", "pedrou"+u"\u00E7"+"o",
"ped"+u"\u00FA"+"nculo", "peitilho", "penduricalho", "penhasco",
"pequerrucho", "percurso", "per"+u"\u00ED"+"metro", "per"+u"\u00ED"+"odo",
"pesadelo", "pesco"+u"\u00E7"+"o", "petr"+u"\u00F3"+"leo", "p"+u"\u00ED"+"ncaro",
"pinheiro", "planalto", "plantio", "pol"+u"\u00ED"+"gono", "pol"+u"\u00ED"+"mero",
"polin"+u"\u00F4"+"mio", "p"+u"\u00F3"+"lipo", "p"+u"\u00F4"+"mulo", "ponto", "poro",
"portento", "postigo", "povo", "prado",
"prazo", "pre"+u"\u00E2"+"mbulo", "presbiterado", "precip"+u"\u00ED"+"cio", "preciso", "pre"+u"\u00E7"+"o",
"preconceito", "pr"+u"\u00E9"+"dio", "pref"+u"\u00E1"+"cio", "preju"+u"\u00ED"+"zo",
"prelo", "prel"+u"\u00FA"+"dio", "pr"+u"\u00EA"+"mio", "pren"+u"\u00FA"+"ncio",
"pres"+u"\u00E9"+"pio", "pres"+u"\u00ED"+"dio", "press"+u"\u00E1"+"gio", "prest"+u"\u00ED"+"gio",
"pr"+u"\u00E9"+"stimo", "presunto", "prim"+u"\u00F3"+"rdio", "principado",
"princ"+u"\u00ED"+"pio", "privil"+u"\u00E9"+"gio", "processo", "prod"+u"\u00ED"+"gio", "pr"+u"\u00F3"+"dromo",
"produto", "proleg"+u"\u00F4"+"meno", "proletariado", "prop"+u"\u00F3"+"sito", "pros"+u"\u00E9"+"lito",
"prost"+u"\u00ED"+"bulo", "protalo", "protetorado", "prot"+u"\u00F3"+"tipo",
"proveito", "provento", "prov"+u"\u00E9"+"rbio", "pseud"+u"\u00F3"+"podo",
"p"+u"\u00FA"+"lpito", "quartzo", "quelato", "quesito",
"question"+u"\u00E1"+"rio", "quiabo", "qu"+u"\u00ED"+"cio", "quilo",
"quilombo", "quil"+u"\u00F4"+"metro", "quinteto", "quisto",
"rabino", "rabo", "racimo", "r"+u"\u00E1"+"cio",
"racioc"+u"\u00ED"+"nio", "radiano", "radiois"+u"\u00F3"+"topo",
"radiotelesc"+u"\u00F3"+"pio", "rapazito", "rebotalho", "recept"+u"\u00E1"+"culo",
"recesso", "redenho", "r"+u"\u00E9"+"dito", "reduto",
"refrig"+u"\u00E9"+"rio", "ref"+u"\u00FA"+"gio", "r"+u"\u00E9"+"gulo", "reixelo",
"reitoriado", "rel"+u"\u00E2"+"mpago", "relic"+u"\u00E1"+"rio", "rel"+u"\u00F3"+"gio",
"rem"+u"\u00E9"+"dio", "re"+u"\u00F3"+"stato",
"resfolgadouro", "res"+u"\u00ED"+"duo", "respiradouro", "resqu"+u"\u00ED"+"cio",
"ret"+u"\u00E1"+"bulo", "rev"+u"\u00E9"+"rbero", "riacho", "ricto",
"robalo", "rochedo", "rododendro", "rofo",
"romancero", "rombo", "ros"+u"\u00E1"+"rio", "rostro",
"rubicundo", "rublo", "s"+u"\u00E1"+"bado", "sacerd"+u"\u00F3"+"cio",
"sacr"+u"\u00E1"+"rio", "sacrif"+u"\u00ED"+"cio", "safio", "salmo",
"santiago", "saquito", "sarcodino",
"sarrabulho", "seculo", "s"+u"\u00E9"+"culo",
"seio", "sem"+u"\u00E1"+"foro", "seman"+u"\u00E1"+"rio", "semin"+u"\u00E1"+"rio",
"senado", "senso", "sequilho", "seresteiro",
"servi"+u"\u00E7"+"o", "shampoo", "sic"+u"\u00E1"+"rio", "sic"+u"\u00F4"+"moro",
"sil"+u"\u00EA"+"ncio", "silfo", "siltito", "silvedo",
"s"+u"\u00ED"+"mbolo", "simulacro", "Sindicato", "sindicato", "sin"+u"\u00E9"+"drio", "s"+u"\u00ED"+"ntipo",
"sipaio", "s"+u"\u00ED"+"tio", "sobretudo", "sobrolho",
"solil"+u"\u00F3"+"quio", "solo", "sorriso", "sortil"+u"\u00E9"+"gio", "sovaco",
"sublan"+u"\u00E7"+"o", "subm"+u"\u00F3"+"dulo", "subproduto", "subs"+u"\u00ED"+"dio",
"substrato", "subterf"+u"\u00FA"+"gio", "sub"+u"\u00FA"+"rbio", "sucesso",
"sud"+u"\u00E1"+"rio", "sufr"+u"\u00E1"+"gio", "suic"+u"\u00ED"+"dio", "sultanato",
"sumi"+u"\u00E7"+"o", "sumidouro", "superc"+u"\u00ED"+"lio", "supermercado",
"supersoldado", "supertalento", "supl"+u"\u00ED"+"cio", "suspiradouro",
"sustent"+u"\u00E1"+"culo", "tabuleiro", "tajasno", "talento", "tamarindo",
"tamoio", "taqu"+u"\u00ED"+"grafo", "tarro", "tartufo",
"taumaturgo", "tax"+u"\u00ED"+"metro", "teatro", "teclado", "t"+u"\u00E9"+"dio", "teixo",
"telecentro", "teledisco", "tel"+u"\u00E9"+"grafo", "tele"+u"\u00F3"+"steo",
"telesc"+u"\u00F3"+"pio", "teli"+u"\u00F3"+"sporo", "tel"+u"\u00F4"+"mero", "tempo",
"tent"+u"\u00E1"+"culo", "teodolito", "term"+u"\u00F4"+"metro", "term"+u"\u00F3"+"stato",
"terra"+u"\u00E7"+"o", "terremoto", "test"+u"\u00ED"+"culo", "texto",
"texugo", "tilito", "t"+u"\u00ED"+"mpano", "tirso",
"t"+u"\u00ED"+"tulo", "tojo", "tom"+u"\u00F3"+"grafo", "top"+u"\u00E1"+"zio",
"t"+u"\u00F3"+"rculo", "tornozelo", "torresmo", "tortulho",
"touti"+u"\u00E7"+"o", "trajeto", "trambelho", "trecho",
"tri"+u"\u00E2"+"ngulo", "triciclo", "tr"+u"\u00ED"+"duo", "triglicer"+u"\u00ED"+"dio",
"triglic"+u"\u00E9"+"rido", "tri"+u"\u00FA"+"nviro", "tub"+u"\u00E9"+"rculo", "t"+u"\u00FA"+"bulo",
"tug"+u"\u00FA"+"rio", "t"+u"\u00FA"+"mulo", "tumulto", "tur"+u"\u00ED"+"bulo",
"ultimato", "universo", "utens"+u"\u00ED"+"lio", "v"+u"\u00E1"+"cuo",
"vac"+u"\u00FA"+"olo", "vatic"+u"\u00ED"+"nio", "vedonho", "ve"+u"\u00ED"+"culo",
"veloc"+u"\u00ED"+"metro", "veludilho", "vencilho", "ventr"+u"\u00ED"+"culo",
"ventr"+u"\u00ED"+"loquo", "verbo", "verdugo", "veredicto", "vesti"+u"\u00E1"+"rio",
"vest"+u"\u00ED"+"gio", "vestu"+u"\u00E1"+"rio", "ves"+u"\u00FA"+"vio", "viaduto",
"v"+u"\u00ED"+"deo", "videojogo", "vidrilho", "vilarejo",
"v"+u"\u00ED"+"nculo", "vinhedo", "violino", "vitup"+u"\u00E9"+"rio",
"viveiro", "voc"+u"\u00E1"+"bulo", "v"+u"\u00F4"+"mito",
"voto", "xaxado", "xerimbabo",
"xifosuro", "xisto", "zagalejo", "z"+u"\u00E9"+"firo",
"zoilo", "zuavo"])

# plvrMasca - palavras masculinas terminadas em -a- que nao possui correspondente feminino-
plvrMasca = set(["anacronauta", "aneurisma", "angioma", "aroma", "ateroma", "axioma",
"bioma", "bumba", "carcinoma", "carisma", "celoma",
"cinema", "clima", "c"+u"\u00F3"+"lera", "cometa",
"condroma", "cromossoma", "cronograma", "delta", "dia",
"diadema", "diafragma", "dilema", "diploma",
"DNA", "dogma", "drama", "druida", "ecossistema",
"ectoplasma", "eczema", "edema", "endosperma",
"enfisema", "enigma", "epigrama", "escriba",
"esperma", "esquema", "estigma", "estoma", "estratagema",
"estroma", "exoplaneta", "fac"+u"\u00ED"+"nora", "feocromocitoma", "fliperama", "floema",
"fluxograma", "fusca", "gameta", "g"+u"\u00E2"+"meta",
"genoma", "glaucoma", "harmonograma", "hematoma", "hemograma",
"histograma", "histoplasma", "holograma", "ideograma",
"idioma",  "inseticida", "jota",
"lema", "lexema", "linfogranuloma", "linfoma",
"macrocromossoma", "magma", "mantra", "mapa",
"mega", "melanoma", "melodrama", "mesotelioma", "microclima",
"microgameta", "mieloma", "mimodrama", "moma",
"monograma", "neuroblastoma", "neuroplasma", "organograma",
"pampa", "panorama", "paradigma",
"parricida", "patriarca", "pederasta", "periodograma", "perisperma",
"pesticida", "pijama", "planeta", "plasma",
"poema", "poeminha", "prisma", "problema",
"programa", "protoplasma", "psicodrama", "psicoplasma",
"puma", "quediva", "quilograma", "rapazola", "ritidoma", "rizoma", "samba",
"sarcoma", "sintoma", "sismograma", "sistema",
"sofisma", "subprograma", "subsistema", "superatleta",
"sutra", "tapa", "teledrama", "telefonema",
"telegrama", "teorema", "tracoma", "trauma", "trema",
"videograma", "zabumba"])

# plvrFemo - palavras femininas terminadas em -o- 
plvrFemo = set(["fonofoto", "Fonofoto", "foto", "Foto", "libido", "Libido", "lipo", "Lipo", "moto", "Moto", "tribo", "Tribo"])

# excplFema - palavras femininas/masculinas que podem ser usadas com os artigos a / o 
excplFema = set(["camisa"])

# excplVirg - evita o dois virgula cinco 
excplVirg = set(["sua", "v"+u"\u00ED"+"rgula"])

# plFemavb -  - substantivos femininos tambem encontrados em conjugacoes verbais.
plFemavb = set(["abelha", "agrura", "ajuda", "al"+u"\u00E7"+"a", "alfaia", "algema", "amarra",
"amea"+u"\u00E7"+"a", "anexa", "anilha", "arrua"+u"\u00E7"+"a", "avenca", "baixa", "bicha", "cata",
"causa", "chama", "cobra", "compra", "conserva", "conta", "cria", "culpa", "cunha",
"cura", "custa", "cava", "cozinha", "dan"+u"\u00E7"+"a", "descoberta", "disputa", "dura", "eira",
"elegia", "empena", "encosta", "entranha", "entrega", "entrevista",
"era", "escala", "escolha", "escolta", "escora", "escusa", "espera", "estampa", "fala", "falha",
"falta", "fatia", "for"+u"\u00E7"+"a", "forma", "funda", "marca", "pergunta", "prova", "quebra", "saia", "volta"])

# plvrFema - palavras femininas terminadas em -a- que nao possuem correspondente masculino- a-o
plvrFema = set(["aba", "abertura", "abcissa", "ab"+u"\u00F3"+"bada", "ab"+u"\u00F3"+"bora",
"abra"+u"\u00E7"+"adeira", "abreviatura", "absolutinha", "ac"+u"\u00E1"+"cia", "academia",
"academiazinha", "a"+u"\u00E7"+"ailandesa", "acetilcolina", "achinesa",
"acrobacia", "actina", "a"+u"\u00E7"+"ucena", "acupunctura", "acur"+u"\u00E1"+"cia",
"adaga", "adega", "adrenalina", "advocacia", "adufa",
"aeromo"+u"\u00E7"+"a", "africanesa", "afronta", "agenda",
"agendinha", "agonia", "agorafobia", "agricultura",
"agroind"+u"\u00FA"+"stria", "agrovila", u"\u00E1"+"gua", "agulha", "agulhinha",
"alambresa", "alameda", "alavanca", "albanesa",
"al"+u"\u00E7"+"ada", "alcachofra", "alcateia", "alcova", "alcunha", "aldeia",
"aldeola", "aldeota", "aldeiazinha", "alegada", "alegoria", "alegria",
"alegriazinha", "aleluia", "alf"+u"\u00E2"+"ndega", "alfazema",
"alforreca", "alforria", "alga", "algazarra",
u"\u00E1"+"lgebra", "algibeira", "alguma", "alhambresa",
"alheira", "al"+u"\u00ED"+"nea", "al"+u"\u00ED"+"quota", "alma", "alm"+u"\u00E1"+"dena",
"almalaguesa", "almanjarra", "alminha", "almofada",
"almofadinha", "alopatia", "alpaca", "alparca", "alparcata", "alpendrada",
"alpercata", "alpercatinha", "alquimia", "als"+u"\u00E1"+"cia",
"altiva", "altura", "alva", "alvenaria",
"alverca", "alvinha", "alvorada", "alvoradinha",
"alvura", "amarantesa", "amargura", "amazona", "ambrosia",
"ambrosina", "ameba", "am"+u"\u00EA"+"ijoa", "ameixa", "ameixinha",
"am"+u"\u00EA"+"ndoa", "amendoeira", "amesterdanesa", "ametista",
"am"+u"\u00ED"+"dala", "am"+u"\u00ED"+"gdala", "amilopectina", "amnistia", "amora",
"amoreira", "amostra", "amostrinha", "ampola",
"ampulheta", "amsterdamesa", "anacleta", "anaconda", "an"+u"\u00E1"+"gua",
"analandesa", "analgesia", "anamesa", "anarquia",
"anatomia", "anaurilandesa", "anca", "andadura", "andaluza",
"andamanesa", "andorinha", "anedota", "anemia", "an"+u"\u00E9"+"mona", "an"+u"\u00EA"+"mona",
"anestesia", "anfetamina", "anf"+u"\u00ED"+"bola", "angina", "angiosperma", "angolesa", "ang"+u"\u00FA"+"stia",
"anilina", "anistia", "anita", "anomalia", "anorexia",
"anquinha", "anta", "antec"+u"\u00E2"+"mara", "antena",
"antera", "antessala", "antipart"+u"\u00ED"+"cula", "antipatia",
"antiportuguesa", "antropofagia", "aorta", "apalpadela", "apalpadinha", "apatia",
"apoplexia", "aposentadoria", "aposta", "apostila", "apostinha",
"aquarela", "ar"+u"\u00E1"+"bia", "aragoesa", "aragonesa",
"aramesa", "arandela", "aranha", "aranhinha", "arapuca", "arara",
"ararinha", "arca", "arcada", "arc"+u"\u00E1"+"dia",
"arcadinha", "ardenesa", "ard"+u"\u00F3"+"sia", u"\u00E1"+"rea", "areia",
"areiinha", "arena", "arenga", "aresta",
"argamassa", "argila", "argola", "argolinha",
"arg"+u"\u00FA"+"cia", "arguesa", "aristocracia", "arma",
"armadilha", "armadura", "arminha", "arnesa",
"aroeira", "aroeirinha", "arouquesa", "arquibancada",
"arquitetura", "arr"+u"\u00E1"+"bida", "arraia", "arraiada",
"arrelia", "arritmia", "arroba", "arruda", "arr"+u"\u00FA"+"dia",
"arrumadeira", "artilharia", "artimanha", "asa", "ascuma",
"asfixia", "asinha", "asma", "asneira", "aspa",
"aspereza", "aspirina", "assamesa", "assembleia",
"assessoria", "assimetria", "assinatura", "assinaturazinha",
"assuanesa", "astronomia", "ast"+u"\u00FA"+"cia", "ata",
"atmosfera", "atonia", "atrofia", "aud"+u"\u00E1"+"cia",
"auditoria", "aula", "aulinha", "aura",
"aur"+u"\u00E9"+"ola", "aur"+u"\u00ED"+"cula", "aurilandesa", "aurora",
"austera", "australesa", "autarquia", "autobiografiazinha", "autodefesa",
"autoescola", "autoestima", "autoestrada", "autofagia", "autoforma", "automaca",
"autonomia", "aut"+u"\u00F3"+"psia", "autoria", "avaitanhesa", "avareza", "avaria",
"aveia", "aven"+u"\u00E7"+"a", "avenida", "avenidinha", "aventura",
"aventurazinha", "avezinha", "avicultura", "avilesa", "avioneta", "axila",
"aza", "az"+u"\u00E1"+"fama", "azaleia", "azambuja", "azambujinha",
"azeitona", "azeitoninha", "azenha", "azerbaidjanesa",
"azia", "baamesa", "baba", "baba"+u"\u00E7"+"ulandesa",
"babosa", "baboseira", "babosinha", "ba"+u"\u00E7"+"a",
"bacalhoa", "bacharela", "bacia", "baciazinha",
"badalada", "badaladinha", "baderna", "baeta",
"baforada", "baforadinha", "baga", "bagaceira",
"bagatela", "bagresa", "baia", "ba"+u"\u00ED"+"a",
"baianinha", "baiona", "baionesa", "baioneta", "bainha",
"baixela", "baixeza", "baixinha", "bala", "balada",
"baladinha", "balaiada", "balaustrada",
"balaustradinha", "balb"+u"\u00FA"+"rdia", "baleia", "balela",
"balinesa", "balinha", "baliza", "balsa",
"balsinha", "baltistanesa", "bambina", "bambinela",
"bananeirinha", "bananinha", "bancarrota", "bandalheira",
"bandanesa", "bandeira", "bandeirada", "bandeiradinha",
"bandeirola", "bandeja", "bandejinha", "bandurra",
"bandurrinha", "bangladesa", "banqueta", "banquinha",
"banquetinha", "baqueta", "barafunda", "barateza", "baratinha",
"bara"+u"\u00FA"+"na", "barba", "barbaria", "barbatana", "barbearia",
"barbela", "barbicha", "barbinha", "barca"+u"\u00E7"+"a",
"barcarola", "barcelonesa", "bardana", "baremesa",
"barganha", "baronesa", "baronesinha",
"barreira", "barrela",
"barretina", "barrica", "barricada", "barricadinha",
"barriga", "barrigueira", "barrinha", "barroca",
"barulhada", "barulheira", "basca", "bas"+u"\u00ED"+"lica",
"bastilha", "batalha", "batalhinha", "batata", "batatinha",
"b"+u"\u00E1"+"tega", "bateia", "bateria", "batina",
"batota", "batotinha", "batuta", "baunilha",
"bauxita", "baz"+u"\u00F3"+"fia", "bazuca", "bearnesa",
"beataria", "bebedeira", "bei"+u"\u00E7"+"ola", "beijoca",
"beira", "beirada", "beiradinha", "beirinha",
"beladona", "belbutina", "belda", "beleza",
"belezinha", "belida", "bemposta",
"benem"+u"\u00E9"+"rita", "benfeitoria", "bengala", "bengalesa",
"bengalinha", "benguela", "benguelinha",
"benzedura", "beripoconesa", "berlinda", "berlinesa",
"berma", "bermuda", "bermudesa", "bernarda", "bernardina",
"bernardinha", "bernesa", "besteira", "besteirinha",
"bestiaga", "beterraba", "b"+u"\u00E9"+"tula",
"bexiga", "bezerrinha", "bia", "b"+u"\u00ED"+"blia", "biblioteca",
"biboca", "bicharada", "bicicleta", "bifada",
"bifadinha", "bigamia", "bigorna", "bilha",
"bilharda", "bilheteria", "bilirrubina", "binda",
"bintanesa", "biof"+u"\u00E1"+"brica", "biomassa", "biosfera",
"biqueira", "birmanesa", "birosca", "birra",
"birrinha", "bisarma", "bisca",
"biscaia", "bitola", "bichinha", "bi"+u"\u00F3"+"psia",
"bisnaga", "blasf"+u"\u00EA"+"mia", "blusa", "blusinha",
"boa", "boataria", "bobina", "boca",
"bocada", "bocadinha", "bocarra", "boceta",
"bochecha", "bochechinha", "boda", "bodega",
"boemia", "bofetada", "bofetadinha", "boga",
"boiada", "boiadinha", "boicininga",
"boina", "boinha", "boininha", "bojuda",
"bojudinha", "bolacha", "bolachinha",
"bolada", "boladinha", "boleia", "boleta",
"bolha", "bolhinha", "bolonhesa",
"bolota", "bolsinha", "bomba",
"bombarda", "bombinha", "bonecra", "bonina",
"boniteza", "bonomia", "boquilha", "boquinha",
"borboleta", "borboletinha", "borbulha", "borda", "bordadura",
"bordalesa", "bordelesa", "bordinha", "bordoada",
"borga", "borgonha", "borgonhesa", "borla",
"borneira", "boroa", "borra", "borracha",
"borracheira", "borrachinha", "borradela", "borralheira",
"borrasca", "borrega", "bossa", "bosta", "bostela",
"bostinha", "bota",
"botelha", "botica", "botija", "botina",
"botinha", "botoeira", "botulina", "brabantesa",
"bra"+u"\u00E7"+"ada", "bragancesa", "braguesa",
"braguilha", "brama", "brancura",
"brandeburguesa", "brandemburguesa", "brandura",
"braquesa", "brasa", "brasilandesa", "brasilesa",
"brasinha", "bravata", "braveza",
"bravura", "breca", "brecha", "breda",
"brejeira", "brenha", "bretanha", "brida",
"briga", "brigada", "briguinha", "brilhantina",
"brincadeira", "brincadeirinha", "bri"+u"\u00F3"+"fita","brisa", "brita",
"broa", "broca", "brocha", "brochura",
"broinha", "bromocriptina", "bronca", "broncopneumonia",
"broxa", "bruaca", "bruaquinha", "bruma",
"brusca", "bruteza", "bruxaria", "bruxariazinha",
"bruxelesa", "bruzundanga", "bucha", "buchada",
"buchinha", "buda", "buenolandesa",
"bula", "bulgaresa", "bulha", "bunda",
"bundinha", "buraca", "burbonesa", "burga",
"burgalesa", "burguesa", "burguesia",
"burla", "burocracia", "burocratesa",
"burundinesa", "b"+u"\u00FA"+"ssola",
"butanesa", "buzina", "caatinga", "caba"+u"\u00E7"+"a",
"cabacinha", "cabana", "cabe"+u"\u00E7"+"ada",
"cabeceira", "cabecinha", "cabeleira", "caboclinha",
"cabrinha", "ca"+u"\u00E7"+"ada",
"ca"+u"\u00E7"+"adinha", "ca"+u"\u00E7"+"arola", "cacha"+u"\u00E7"+"a", "cachacinha",
"cachoeira", "cachoeirinha", "cachopa", "ca"+u"\u00E7"+"oada", "cacimba", "cacimbinha",
"cacofonia", "cadeia", "cadeiazinha", "cadeira", "cadeirinha",
"cadela", "cadelinha", "caderneta", "cadernetinha",
"cafelandesa", "cai"+u"\u00E7"+"ara", "caimanesa", "calabresa",
"cal"+u"\u00E7"+"a", "caixinha", "cajazeira", "calcesa", "calcinha",
"caldeira", "caldeirinha", "calha", "cali"+u"\u00E7"+"a",
"calmaria", "calota", "cama", "camada", "camadinha", "c"+u"\u00E2"+"mara",
"camaronesa", "cambada", "cambadinha", "cambalhota", "cambraia",
"c"+u"\u00E2"+"mera", "camila", "camioneta", "camisa",
"camiseta", "camisetinha", "camisinha", "camisola",
"camisolinha", "camoesa", "campainha", "campanha",
"campidanesa", "campina", "camponesa",
"canaresa", "canastra", "canavesa", "cancela",
"cancelinha", "candidatura", "candonga", "candura",
"canela", "canelinha", "caneta", "canetinha",
"canga", "cangalha", "cangalhinha", "caninha", "canoa",
"canoinha", "canseira", "cantata", "cantatinha",
"canja", "cantiga", "cantilena", "cantina", "cantonesa", "cantoria",
"canzoada", "capa", "capela", "capelinha",
"capinha", "capitania", "capivara", "capoeira",
"capoeirinha", "capota", "c"+u"\u00E1"+"psula", "captura",
"carabina", "carambola", "caranguejola", "carapa"+u"\u00E7"+"a", "carapu"+u"\u00E7"+"a",
"carapucinha", "caravana", "caravela", "carca"+u"\u00E7"+"a",
"carcacinha", "carestia", "carga", "caricatura",
"car"+u"\u00ED"+"cia", "carlota", "carlotinha", "carna"+u"\u00FA"+"ba", "carnaubeira",
"carni"+u"\u00E7"+"a", "carnificina", "carranca", "carranquinha", "carreira",
"carreirinha", "carreta", "carri"+u"\u00E7"+"a", "carricinha",
"carro"+u"\u00E7"+"a", "carroceria", "carrocinha", "carta",
"cartada", "cartadinha", "cartaginesa", "carteirinha", "cartilha",
"cartinha", "cartola", "cartucheira", "carvoeira",
"casadinha", "cascata", "cascatinha", "caserna", "casimira", "casinha",
"caspa", "cassilandesa", "casta", "castanha", "castanhinha",
"castanhola", "castinha", "catacumba", "catalanesa", "catanguesa", "catapora",
"catapulta", "catarata", "catarina", "categoria", "catinga", "catingueira",
"catita", "cauda", "caudinha", "cautela", "cavalaria", "cavalgada",
"cavalgadinha", "cavalgadura", "cavalgata", "cavalhada",
"caveira", "caveirinha", "caverna", "caverninha",
"cazaquistanesa", "cebola", "cebolinha", "c"+u"\u00E9"+"dula",
"cegonha", "cegueira", "ceia", "ceifa", "cela",
"celeuma", "c"+u"\u00E9"+"lula", "c"+u"\u00E9"+"lulazinha", "cena",
"cenoura", "censura", "centelha", "centelhinha", "centena", "cepa",
"cera", "cerda", "cereja", "cerejeira", "cerejinha", "ceroula", "certeza",
"certezinha", "cerveja", "cervejaria", "cervejinha",
"cesta", "cevada", "ch"+u"\u00E1"+"cara", "chacina",
"chacota", "chaga", "chala"+u"\u00E7"+"a", "chaleira",
"chamadinha", "champanhesa", "chancela",
"chancelaria", "chapa", "chapada", "chapinha",
"charada", "charadinha", "charolesa", "charrua", "charutaria",
"charuteira", "chatinha", "ch"+u"\u00E1"+"vena", "chefia", "chegada",
"chegadinha", "cheiinha", "chibata", "chibatinha", "china", "chinesa",
"chita", "cho"+u"\u00E7"+"a", "choradeira", "choupana", "chula",
"chusma", "chuteira", "chuva", "chuvinha", "cidadania",
"cidadela", "cifra", "cigarreira", "cilada",
"cilha", "cimalha", "cimeira", "cimenteira", "cinemateca", "cingalesa",
"cintura", "cinturinha", "circunvizinha",
"cisterna", "clareira", "clareza", "cl"+u"\u00E1"+"usula",
"clausura", "clava", "clav"+u"\u00ED"+"cula", "clavina", "clavinha",
"clientela", "clorofila", "coalhada", "coalhadinha", "cobaia",
"cobardia", "cobertura", "cobi"+u"\u00E7"+"a", "cobrinha",
"coca"+u"\u00ED"+"na", "c"+u"\u00F3"+"cega", "coelha",
"coelhinha", "cocheira", "cochinchinesa", "cochinesa",
"coimbresa", "coisa", "coisinha", "colcha",
"coleta", "colet"+u"\u00E2"+"nea", "coletinha", "colheita",
"c"+u"\u00F3"+"lica", "colina", "colinha", "colmeia",
"coluna", "comarca", "com"+u"\u00E9"+"dia", "comenda",
"comendadeira", "comidela", "comidinha", "comitiva", "companhia",
"comporta", "compostura", "compota", "compoteira", "compreendia",
"compressa", "comprinha", "comuna", "concha", "conchinha", "conc"+u"\u00F3"+"rdia",
"concubina", "condessa", "condessinha", "conduta", "confeitaria", "confraria",
"congolesa", "conjectura", "conjetura", "conjuntura", "consulta", "consultoria",
"contenda", "contrafaixa", "contrafor"+u"\u00E7"+"a", "contraoferta",
"contrapartida", "contraproposta", "contraporca",
"contraprova", "contrarrevolta", "contrassenha", "conversa", "conversinha",
"cooperativa", "coordenadoria", "c"+u"\u00F3"+"pia",
"c"+u"\u00F3"+"piazinha", "c"+u"\u00F3"+"pula", "cor"+u"\u00E7"+"a", "corda",
"cordilheira", "cordinha", "cordisburguesa", "cordislandesa",
"cordofanesa", "cordovesa", "corina", "corneta",
"cornetinha", "corninglesa", "cornualhesa", "cornuc"+u"\u00F3"+"pia",
"coroa", "cor"+u"\u00F4"+"a", "coroinha", "corola",
"coronha", "corregedoria", "correia", "correnteza",
"correntezinha", "correria", "correta", "corrida",
"corridinha", "cortesia", "cortina", "cortininha",
"coruja", "corujinha", "corunhesa", "corveta",
"cosipa", "costa", "costela", "costeleta", "costinha", "costura",
"costureirinha", "cota", "cotanesa", "cotia",
"cotinha", "cotovia", "coura"+u"\u00E7"+"a", "courela",
"cousa", "cova", "covardia", "covinha",
"coxa", "coxia", "coxinha", "cozedura", "cracovesa",
"craonesa", "cratera", "crian"+u"\u00E7"+"a", "crian"+u"\u00E7"+"ada",
"criancinha", "criatura", "criaturinha", "crina", "cripta", "cris"+u"\u00E1"+"lida",
"cristalandesa", "crixalandesa", "crosta", "crua", "crucilandesa", "crueza",
"cruzadinha", "cruzelandesa", "cueca",
"cuequinha", "cuia", "culatra", "culpadinha", "cultura",
"cupromanganesa", "c"+u"\u00FA"+"pula", "curadoria",
"curva", "curvatura", "curvinha", "cust"+u"\u00F3"+"dia",
"d"+u"\u00E1"+"diva", "dama", "danceteria", "dancinha",
"danesa", "daroesa", "data", "debandada",
"debulhadeira", "d"+u"\u00E9"+"cada", "defensoria", "defesa",
"delegacia", "delfina", "delfinesa", "delicadeza",
"del"+u"\u00ED"+"cia", "demanda", "demandinha", "demasia",
"democracia", "demora", "dentada",
"dentadinha", "dentadura", "derrocada", "derrota",
"derrotinha", "desarmonia", "descarga", "descida",
"descidinha", "descompostura", "descortesia", "desculpa",
"desdita", "desembocadura", "desenvoltura", "desfeita",
"desfilada", "desfiladinha", "desforra", "desgra"+u"\u00E7"+"a",
"desgraceira", "desonra",
"desova", "despensa", "despenseira", "despesa",
"despesinha", "despreza", "destilaria", "destreza",
"desvalia", "desventura", "deusa", "devassa",
"dezena", "diabrura", "di"+u"\u00E1"+"fana", "diarreia",
"di"+u"\u00E1"+"spora", "diatom"+u"\u00E1"+"cea", "dica", "dicotomia", "diepesa",
"dieta", "difteria", "dinamarquesa", "dinamarquesinha",
"dinastia", "dinheirama", "dioptria", "diplomacia", "direta",
"diretoria", "disciplina", "disc"+u"\u00F3"+"rdia", "discoteca",
"disenteria", "dislexia", "dispneia",
"distrofia", "ditadura", "diva",
"d"+u"\u00ED"+"vida", "divinolandesa",
"divisa", "dobra", "doca", "do"+u"\u00E7"+"aria", "do"+u"\u00E7"+"ura",
"doencinha", "dominiquesa", "donzelinha",
"dopamina", "d"+u"\u00F3"+"rica", "dormida", "dormidinha", "dorna",
"dosimetria", "douradura", "doutora", "doutrina",
"draga", "droga", "drogaria", "drupa",
"ducha", "duchinha", "duna", "duplicata",
"duquesa", "dureza", "d"+u"\u00FA"+"vida", "d"+u"\u00FA"+"zia",
"economesa", "economia", "editoria", "efic"+u"\u00E1"+"cia",
"elvira", "ema", "embaixada", "embaixadinha",
"embira", "embocadura", "emenda", "ementa",
"empada", "empadinha", "emp"+u"\u00E1"+"fia", "empatia",
"empresa", "encefalopatia", "enciclop"+u"\u00E9"+"dia", "encomenda",
"encruzilhada", "encruzilhadinha", "endorfina", "endoscopia", "enfermaria",
"engenharia", "engomadeira", "enguia", "enseada",
"enseadinha", "entrada", "entradinha", "entrelinha", "entremesa",
"entressafra", "envergadura", "enxada", "enxadinha",
"enxaqueca", "enxurrada", "enxurradinha", "enzima",
"epidemia", "epifania", "ep"+u"\u00ED"+"stola", "epopeia",
"ergonomia", "eritreia", "errata", "erva", "ervilha",
"ervilheira", "ervinha", "esbelteza", "escada",
"escadaria", "escadinha", "escaleira", "escama",
"escapada", "escapadinha", "esc"+u"\u00E1"+"pula", "escarcela",
"escarlatina", "escarpa", "escherichia", "escocesa",
"esc"+u"\u00F3"+"cia", "escola", "escolinha", "escondia",
"escopeta", "escopeteira", "escorva", "escotilha",
"escova", "escovinha", "escravaria", "escravatura",
"escritura", "escuderia", "escultura", "esculturinha",
"escuma", "escumilha", "escuta", "esfera",
"esgrima", "esmeralda", "esmeraldinha", "esmola",
"esmolinha", "espada", "espadana", "espadela",
"espadilha", "espadinha", "esp"+u"\u00E1"+"dua", "espalda",
"espanhola", "esp"+u"\u00E1"+"tula", "especiaria", "espectrometria",
"espectroscopia", "espertalhona", "esperteza",
"espessura", "espiga", "espingarda", "espinhela",
"esplanada", "esplanadinha", "esponja", "esponjinha",
"espora", "esporinha", "esp"+u"\u00F3"+"rtula", "espuma",
"esquadra", "esquadria", "esquadrinha", "esquina",
"esquiva", "esquizofrenia", "estaca", "estacada",
"estacadinha", "estadia", "estafeta", "estamenha",
"estampinha", "estanqueira", "estaquinha",
"est"+u"\u00E1"+"tua", "estatuazinha", "estatueta", "estatura", "estearina",
"esteira", "estesia", "estola", "estopa",
"estopinha", "estrada", "estradinha", "estrangeirada",
"estrangeiradinha", "estranheza", "estrasburguesa", "estrat"+u"\u00E9"+"gia",
"estratosfera", "estrebaria", "estreia",
"estreiteza", "estreitinha", "estrela", "estrelinha",
"estrema", "estremadura", "estreptomicina", "estriga",
"estrutura", "estufa", "estult"+u"\u00ED"+"cia", "etapa",
"etapinha", "etiopesa", "etiqueta", "etnia",
"eucaristia", "euforia", "eugenia", "europeia",
"eva", "evasiva", "f"+u"\u00E1"+"brica", "f"+u"\u00E1"+"bula",
"faca", "facada", "facadinha", "fa"+u"\u00E7"+"anha",
"faceta", "facha", "fachada", "fachadinha",
"fac"+u"\u00FA"+"ndia", "fada", "fadiga", "fadinha",
"fagulha", "fagulhinha", "faia", "fa"+u"\u00ED"+"sca",
"fal"+u"\u00E1"+"cia", "falcoaria", "falda",
"faltinha", "fama", "familiazinha", "familinha",
"fanfarra", "fanga", "fantasia", "fantasmagoria",
"faquinha", "farda", "fardeta", "fardetinha",
"fardinha", "farfalha", "far"+u"\u00ED"+"ngea", "farm"+u"\u00E1"+"cia",
"farinha", "farmacopeia", "farofa", "farofinha", "farpa", "farpela",
"farpinha", "farra", "farroupeira", "farroupilha",
"farrusca", "farsa", "fartura", "farturinha",
"fasc"+u"\u00ED"+"ola", "fasquia", "fat"+u"\u00ED"+"dica", "fatiota",
"fatura", "fa"+u"\u00FA"+"lha", "fauna", "fausta",
"faustina", "fava", "faveira", "favela",
"favinha", "faxina", "fazenda", "fazendinha",
"fazendola", "fechadura", "f"+u"\u00E9"+"cula", "fedelha",
"fedentina", "fedra", "feijoada", "feira",
"feirinha", "feita", "feiti"+u"\u00E7"+"aria", "feitoria", "feitura",
"feiura", "feiurinha", "fel"+u"\u00ED"+"cia", "felpa",
"f"+u"\u00EA"+"mea", "fenciclidina", "fenda",
"fen"+u"\u00ED"+"cia", "fera", "fereza", "feroesa",
"ferradura", "ferradurinha", "ferramenta", "ferrenha",
"ferroada", "ferroadinha", "ferromanganesa", "ferrovia",
"f"+u"\u00E9"+"rula", "fervura", "fervurinha", "festa",
"festina", "festinha", "fiandeira", "fibra",
"fibrina", "fibromialgia", "f"+u"\u00ED"+"bula", "ficha",
"fichinha", "fida", "fidalguia", "figueira",
"figueirinha", "figura", "figurinha", "fila",
"filantropia", "filatelia", "fil"+u"\u00E1"+"ucia", "fileira",
"filharada", "filipinesa", "filogenia", "filomena",
"filosofia", "filoxera", "f"+u"\u00ED"+"mbria", "finesa",
"fineza", "finlandesa", "finlandesinha", "finta",
"finura", "firma", "firmeza", "firmezinha",
"firminha", "fisionomia", "fissura", "f"+u"\u00ED"+"stula",
"fita", "fiteira", "fitinha", "fivela",
"fivelinha", "fl"+u"\u00E2"+"mula", "flanela",
"flanelinha", "flauta", "flecha", "flechinha",
"fleuma", "flora", "fl"+u"\u00F3"+"rea", "florentina",
"floresta", "floricultura", "florinha", "flotilha",
"fobia", "focinheira", "foda", "fodinha",
"fofoca", "fofoquinha", "foga"+u"\u00E7"+"a", "fogueira",
"fogueirinha", "foi"+u"\u00E7"+"ada", "foi"+u"\u00E7"+"adinha", "folga",
"folha", "folhinha", "folia", "forca",
"forcinha", "formanda", "formatura", "f"+u"\u00F3"+"rmica",
"formiga", "forminha", "formosura", "f"+u"\u00F3"+"rmula",
"fornada", "fornalha", "forneira", "forneirinha", "forquilha",
"forrinha", "fortaleza", "fortuna", "fotoc"+u"\u00F3"+"pia",
"fotografiazinha", "fotogrametria", "fotonovela", "fotosfera",
"f"+u"\u00F3"+"vea", "fraga", "fragata", "fralda", "fraldinha",
"frama", "francela", "francesa", "francesinha",
"franja", "franjinha", "franqueza",
"franquia", "fraqueza", "fratura", "frauta",
"frecha", "freguesa", "freguesia", "freguesinha",
"freiberguesa", "freima", "freira", "freirinha",
"frescura", "fresquinha", "fressura", "fresta",
"frestinha", "fria", "frieira", "frieza", "fr"+u"\u00ED"+"gia",
"frigideira", "fritura", "fronha", "frontaria",
"fronteira", "frota", "fruta", "frutaria", "fruteira",
"fruticultura", "fuampa", "fuba", "fu"+u"\u00E7"+"a",
"fuga", "fugidia", "fujona", "fulva",
"fuma"+u"\u00E7"+"a", "fumaceira", "fumacinha", "fundura",
"fun"+u"\u00E9"+"rea", "f"+u"\u00FA"+"rcula", "furna", "fuzilaria",
"gabardina", "gabela", "g"+u"\u00E1"+"bia", "gabonesa",
"gadelha", "gaeta", "gaforina", "gagueira",
"gaia", "gaiata", "gaiola", "gaiolinha",
"gaita", "gaitinha", "gaivota", "gaivotinha",
"gajeira", "gala", "galantaria", "galanteria", "gal"+u"\u00E1"+"xia",
"galba", "galeota", "galera", "galeria",
"galerinha", "galesa", "galinha", "galhada",
"galharda", "galhardia", "galharia", "galheta",
"galhofa", "gal"+u"\u00ED"+"cia", "galileia", "galinhola",
"galinicultura", "galocha", "galopada", "galopadinha",
"galuresa", "galvanoplastia", "gamaglobulina", "gamba",
"g"+u"\u00E2"+"mbia", "gambiarra", "gamboa", "gamela", "gamet"+u"\u00F3"+"fita",
"gana", "ganapada", "gandaia", "g"+u"\u00E2"+"ndara",
"gandaresa", "gandra", "gandresa", "ganesa",
"ganga", "gangorra", "gangorrinha", "gangrena",
"garantia", "garapa", "garatuja",
"gar"+u"\u00E7"+"a", "garcesa", "garcinha", "gardunha",
"garfada", "garfadinha", "gargalhada", "gargalhadinha",
"gargalheira", "garganta", "gargantilha", "g"+u"\u00E1"+"rgula", "garnacha",
"garoa", "garonesa", "garotada", "garotadinha", "garotinha",
"garoupa", "garoupinha", "garra", "garrafa",
"garrafeira", "garrafinha", "garraiada", "garrana",
"garrincha", "garrocha", "garrota", "garrucha", "garrula",
"garupa", "garvonesa", "gasista", "gasolina",
"gastromancia", "gastronomia", "gateira", "gatinesa",
"gauchada", "gaulesa", "g"+u"\u00E1"+"vea", "gavela",
"gaveta", "gavetinha", "gavota", "gaza",
"gazela", "gazeta", "gazetilha", "geada",
"geadinha", "geba", "geesa",
"geladeira", "gelara", "gelatina",
"geleia", "gelosia", "gema", "genebra",
"genebresa", "generala", "geneta", "gengiva",
"genoesa", "genovesa", "gentalha", "gentamicina",
"gentileza", "genuesa", "geometria", "geriatria",
"giba", "gibiteca", "giesta", "giganta",
"gigantinha", "gincana", "ginecomastia", "gineta",
"ginja", "gipsofila", "girafa", "gir"+u"\u00E2"+"ndola",
"gitana", "gl"+u"\u00E2"+"ndula", "glicerina", "glicina",
"gliptoteca", "glor"+u"\u00ED"+"ola", "goa", "goanesa",
"goela", "goesa", "goiaba", "goiabada", "gola",
"goleada", "goleadinha", "golfada", "golfadinha",
"golinha", "golpelha", "goma", "gonadotrofina", "g"+u"\u00F4"+"ndola",
"gonorreia", "gordinha", "gordura", "gordurinha", "g"+u"\u00F3"+"rgona",
"gorja", "gorjeta", "gorjetinha", "gostosura",
"gota", "goteira", "gotinha", "governanta", "gra"+u"\u00E7"+"a",
"gracinha", "gradezinha", "gradinha", "grafia", "grafiazinha", "gralha",
"gralhada", "gralhadinha", "gram"+u"\u00ED"+"nea", "grana", "granada",
"granadinha", "grandeza", "grandura", "graninha",
"granja", "granjinha", "granulometria", "grapa",
"gra"+u"\u00FA"+"na", "gravata", "gravatinha", "gravimetria",
"gravura", "gravurinha", "graxa", "graxinha",
"greda", "greguesa", "grelha", "grenha",
"greta", "grilheta", "grimpa", "grinalda",
"griolandesa", "grisalha", "griseta", "gritaria",
"groenlandesa", "gronelandesa", "groselha", "grosseria",
"grossura", "grota", "grua", "grulhada",
"grulhadinha", "gruta", "grutinha", "guabiroba", "guadramilesa",
"guaiaca", "guajaratuba", "guamesa", "guampa",
"guampada", "guanina", "guarita", "guarnecia",
"guasca", "guedelha", "gueira", "guelra", "guerra",
"guerrilha", "guerrinha", "guiana", "guianesa",
"guida", "guiga", "guilhotina", "guinada",
"guinadinha", "guitarra", "gula", "guloseima",
"gurguesa", "guria", "gurizada", "gurupema",
"gusa", "hamburguesa", "harmonia", "harpa",
"harpia", "hasta", "h"+u"\u00E1"+"stea", "h"+u"\u00E1"+"stia",
"havanesa", "hegemonia", "h"+u"\u00E9"+"gira", "helena",
"heliosfera", "hemeralopia", "hemiplegia", "hemocultura",
"hemofilia", "hemoglobina", "hemolinfa", "hemorragia",
"hena", "heparina", "hepatoscopia", "hera",
"heran"+u"\u00E7"+"azinha", "herbicida", "hercogamia", "herculandesa",
"herc"+u"\u00FA"+"lea", "heresia", "hero"+u"\u00ED"+"na", "hetaira",
"heterodoxia", "heterogenia", "heteromorfia", "heterosfera",
"hialina", "hica", "hidra", "hidrazina",
"hidrocefalia", "hidrocortisona", "hidrofilia", "hidrofobia",
"hidrolandesa", "hidromancia", "hidropisia", "hidrosfera",
"hidrovia", "hidroxizina", "hiena", "hierarquia",
"hifa", "hinterlandesa", "hioscina", "hipercolesterolemia",
"hiperestesiada", "hipergamia", "hipermetropia", "hiperon"+u"\u00ED"+"mia",
"hipertermia", "hipertrofia", "hipervolemia", "hipocondria",
"hipocrisia", "hipoteca", "hipotenusa", "hipotermia",
"hipovalva", "hirta", "hirudina", "histamina",
"histerectomia", "histeria", "historieta", "hola",
"holanda", "holandesa", "holandesinha", "holandilha",
"homeopatia", "homeostasia", "homeotermia", "homilia",
"homofobia", "homogenia", "homon"+u"\u00ED"+"mia", "honconguesa",
"honra", "hora", "horda", "horinha",
"hormona", "horneblenda", "horrenda", "h"+u"\u00F3"+"rrida",
"horsa", "horta", "hortali"+u"\u00E7"+"a", "hortalicinha",
"hort"+u"\u00EA"+"nsia", "horticultura", "hortinha", "h"+u"\u00F3"+"speda",
"hospedaria", "h"+u"\u00F3"+"stia", "hua", "hula",
"hulha", "hum"+u"\u00ED"+"lima", "hungaresa", "iara",
"icter"+u"\u00ED"+"cia", "ideia", "ideiazinha", "idiossincrasia",
"idiotia", "idolatria", "igreja",
"igrejinha", "iguaria", "ilha", "ilhota",
"il"+u"\u00ED"+"ada", "iliteracia", "imbituba", "imod"+u"\u00E9"+"stia",
"imper"+u"\u00ED"+"cia", "impostura", "imprensa", "imprimadura",
"impureza", "imunoglobulina", "incerteza",
"incultura", "indelicadeza", "indisciplina", "indochina",
"indochinesa", "ind"+u"\u00FA"+"stria", "inefic"+u"\u00E1"+"cia", "in"+u"\u00E9"+"pcia",
"in"+u"\u00E9"+"rcia", "inf"+u"\u00E2"+"mia", "infanta", "infantaria",
"influenza", "infraestrutura", "inglesa", "inglesinha",
"inhaca", "injusti"+u"\u00E7"+"a", "in"+u"\u00F3"+"pia", "ins"+u"\u00ED"+"dia",
"inspetoria", "insulina", "inteireza", "intemerata",
"interferometria", "interl"+u"\u00ED"+"ngua", "internetesa", "in"+u"\u00FA"+"bia",
"invernada", "inverneira", "investidura", "ionosfera",
"ipueira", "ira"+u"\u00FA"+"na", "irlandesa", "irlandesinha",
"irma", "ironia", "iroquesa", "isca",
"islandesa", "is"+u"\u00F3"+"bata", "isoc"+u"\u00F3"+"rica",
"isoloma", "isomorfia", "isoniazida", "isonomia",
"isostasia", "isoterma", "isotropia",
"itacoatiara", "ivolandesa", "jabuticaba", "jabuticabeira",
"jaca", "jacobina", "jacuba", "jacutinga",
"jaguatirica", "jagun"+u"\u00E7"+"ada", "jaleca", "jamanta",
"jamba", "jana"+u"\u00ED"+"na", "jandaia", "janela",
"janelinha", "jangada", "jangadinha", "janianesa",
"janota", "janta", "jantarola", "japa",
"japana", "japonesa", "japonesinha", "jaqueta",
"jaquetinha", "jaquiranaboia", "jararaca", "jararaquinha",
"jarreta", "jarreteira", "jaula",
"javanesa", "jazida", "jazidinha", "jeira",
"jerarquia", "jeremiada", "jeropiga", "jetica",
"jia", "jiboia", "jinguba", "joalharia",
"joalheria", "joana", "joaninha", "joanita",
"joelhada", "joelhadinha", "jogatina",
"joia", "joiazinha", "jornada", "jornalesa",
"jota", "jotinha", "juba", "ju"+u"\u00E7"+"ara",
"jucunda", "judeia", "judia",
"judicatura", "ju"+u"\u00ED"+"za", "juncinha", "jungia",
"juntura", "jura", "jurema", "jureminha",
"jurubeba", "jurujuba", "justeza", "justi"+u"\u00E7"+"a",
"juta", "jutlandesa", "labareda", "labuta",
"laca", "lacuna", "ladeira", "ladeirinha",
"ladina", "ladra", "ladrona", "lagartixa",
"lagoa", "lagoinha", "lagosta", "lagostinha",
"l"+u"\u00E1"+"grima", "laguna", "laia", "laja",
"l"+u"\u00E1"+"jea", "lajinha", "lama", "lamba",
"lambada", "lambadinha", "l"+u"\u00E2"+"mina", "lamivudina",
"lampa", "l"+u"\u00E2"+"mpada", "lamparina", "lampinha",
"lampreia", "lampreiinha", "lan"+u"\u00E7"+"adeira", "lanceta",
"landesa", "langonha", "lanolina", "lanterna",
"lanterninha", "lapa", "lapela", "lapinha",
"lapiseira", "laqueadura", "laranjeira", "laranjeirinha",
"lareira", "lareirinha", "larga", "largada",
"largadinha", "largueza", "largura", "larva",
"lasanha", "lasca", "lasc"+u"\u00ED"+"via", "lasquinha",
"lassa", "l"+u"\u00E1"+"stima", "lata", "latada",
"lataria", "latinaria", "latinha",
"latrina", "lavandaria", "lavanderia", "lavareda",
"lavoura", "lavra", "lavratura", "lazarina",
"lazeira", "leandra", "lectina", "leda",
"legenda", "legislatura", "l"+u"\u00E9"+"gua", "leitaria",
"leitura", "leiva", "lembrancinha", "lemna",
"lena", "len"+u"\u00E7"+"aria", "lenda", "lengalenga",
"lenha", "lenhina", "lentilha", "leoa",
"leonesa", "leonina", "leopoldina", "lepra",
"lesma", "letra", "letrinha", "leucemia",
"leucena", "levadi"+u"\u00E7"+"a", "levedura", "leveza",
"leviana", "lev"+u"\u00ED"+"tica", "lexia", "lhama",
"lhaneza", "lhanura", "liamba", "liana",
"libanesa", "libanesinha", "lib"+u"\u00E2"+"nia", "lib"+u"\u00E9"+"lula",
"libra", "li"+u"\u00E7"+"a",
"licenciatura", "licencinha", "lichia", "lida",
"l"+u"\u00ED"+"dima", "lidoca"+u"\u00ED"+"na", "ligadura", "ligaresa",
"ligeireza", "lignina", "l"+u"\u00ED"+"gula", "lila",
"lima", "limburguesa", "limeira", "limonada",
"limpeza", "limpezinha", "lina", "lindeza",
"linfa", "lingala", "l"+u"\u00ED"+"ngua", "lingueta",
"linguetinha", "lingui"+u"\u00E7"+"a", "linguicinha",
"linha"+u"\u00E7"+"a", "lionesa", "liornesa", "lira",
"lisboesa", "lisbonesa", "lisinha",
"lisonja", "lisozima", "lista", "listeria",
"listinha", "lisura", "liteira", "literatura",
"litosfera", "l"+u"\u00ED"+"via", "lixeirinha",
"lix"+u"\u00ED"+"via", "lobotomia", "l"+u"\u00F4"+"brega", "loca",
"locanda", "locandeira", "logomarca",
"logudoresa", "loisa", "loja", "lojeca",
"lojinha", "lombada", "lombeira", "lombriga",
"lona", "lonca", "londresa", "londrina",
"longura", "lonjura", "lontra",
"lontrinha", "loquela", "loratadina", "lorena",
"lorenesa", "loriga", "lorota", "lotar"+u"\u00ED"+"ngia",
"loteria", "lou"+u"\u00E7"+"a", "lou"+u"\u00E7"+"ania", "lou"+u"\u00E7"+"aria",
"loucura", "loucurinha", "loureira", "lousa",
"Lua", "lua", "luanda", "luandesa", "lubina",
"l"+u"\u00FA"+"brica", "lucarna", "lucena", "lucila",
"lucr"+u"\u00E9"+"cia", "l"+u"\u00FA"+"dica", "ludomania", "ludoteca",
"lufada", "luisita", "lula", "lulinha",
"luna", "lunda", "lundesa", "luneta",
"lupa", "l"+u"\u00FA"+"rida", "lusa", "lus"+u"\u00E1"+"cia",
"lus"+u"\u00ED"+"ada", "lusofonia", "lutulenta", "luva",
"luveira", "luvinha", "luxemburguesa", "luzilandesa",
"maca", "maca"+u"\u00E7"+"aresa", "ma"+u"\u00E7"+"ada",
"ma"+u"\u00E7"+"adinha", "ma"+u"\u00E7"+"aneta", "ma"+u"\u00E7"+"aroca", "macaxeira",
"macega", "machadada", "machona", "machorra",
"macia", "macieira", "macieirinha", "ma"+u"\u00E7"+"onaria",
"maconha", "macroeconomia", "macroestrutura", "m"+u"\u00E1"+"cula",
"madalena", "madama", "madeira", "madeirinha",
"madeixa", "madona", "madrasta", "madrep"+u"\u00E9"+"rola",
"madressilva", "madrilesa", "madrugada", "madrugadinha",
"maduresa", "madureza", "m"+u"\u00E1"+"fia", "mafra",
"magda", "magia", "magistratura", "magnetosfera",
"m"+u"\u00E1"+"goa",
"magreza", "maioria",
"mala", "malaguesa", "malaquesa", "maleta",
"malga", "malha", "malhinha", "mal"+u"\u00ED"+"cia",
"malinesa", "malinha", "maloca", "malta",
"maltesa", "maltesia", "maltinha", "maluqueira",
"maluquesa", "malva", "malvina", "malvinesa",
"malvinha", "mama", "mamadeira", "maminha",
"manada", "manadinha", "man"+u"\u00E1"+"pula", "mancheia",
"mandala", "mand"+u"\u00ED"+"bula", "mandinga", "mandioca",
"mandioquinha", "mandolinata", "mandr"+u"\u00E1"+"gora", "manduca",
"maneira", "maneirinha", "manesa", "manga",
"mangaba", "mangabinha", "manganesa", "mangueira",
"mangueirinha", "manha", "mania", "manica",
"manilha", "maniota", "maniotinha", "manivela",
"manjedoura", "manjerona", "manopla", "manquesa",
"mansarda", "manteiga", "mantilha", "m"+u"\u00E1"+"quina",
"maquinaria", "maragota", "maragotinha", "maranduba",
"maratona", "maravilha", "marcenaria", "marcha",
"marchinha", "maresia", "margarida", "margaridinha",
"margarina", "margarita", "marianesa", "marina",
"mariola", "marmelada", "marmeladinha", "marm"+u"\u00F3"+"rea",
"maroca", "maronesa", "marosca", "maroteira",
"marquesa", "marquesinha", "marreta", "marretinha",
"marselhesa", "marta", "maruja", "marujada",
"marujinha", "masca", "m"+u"\u00E1"+"scara", "m"+u"\u00E1"+"scula",
"masmorra", "massa", "masseira", "massinha",
"matadeira", "matilha", "mat"+u"\u00E9"+"ria", "matinada", "matinadinha",
"matraca", "matriarca", "matr"+u"\u00ED"+"cula", "matrona",
"matula", "maura", "maur"+u"\u00ED"+"cia", "mazorca",
"mazurca", "meada", "meadinha", "mealhada",
"meca", "mecha", "medalha",
"medalhinha", "m"+u"\u00E9"+"dia", "mediania", "medicina",
"medula", "medusa", "megalomania", "megera",
"melancia", "melancolia", "melanina", "melatonina",
"melena", "melhoria", "melodia", "membrana",
"menesa", "meninada", "menopausa", "mentira",
"mentirinha", "mercadoria", "mercearia", "merda",
"merdinha", "merenda", "merendinha", "mesa",
"mesada", "mescalina", "meseta", "mesinha",
"mesnada", "mesquita", "messalina", "mestra",
"mestria", "met"+u"\u00E1"+"fora", "metralha", "mica",
"microempresa", "microestrutura", "m"+u"\u00ED"+"dia", "migalha",
"migalhinha", "milanesa", "mil"+u"\u00ED"+"cia", "mina",
"minerva", "minha", "minhoca", "miniatura",
"minoria", "min"+u"\u00FA"+"cia", "minuta", "mioleira", "miopia",
"miosina", "miquelina", "mira", "mirada",
"miradinha", "mirandelesa", "mirandesa", "mirra",
"misantropia", "miseric"+u"\u00F3"+"rdia", "missa",
"missinha", "mistura", "misturinha", "mitra",
"miu"+u"\u00E7"+"alha", "moca",
"mo"+u"\u00E7"+"ada", "mocetona", "mochila", "mochilinha",
"mo"+u"\u00E7"+"oila", "mod"+u"\u00E9"+"stia",
"modorra", "moeda", "moedinha",
"moega", "moela", "moelinha", "moenda",
"mofa", "mofina", "moira", "moirama",
"moita", "mola", "mold"+u"\u00E1"+"via", "moldura",
"moleca", "molecada", "molecadinha", "mol"+u"\u00E9"+"cula",
"moleira", "moleirinha", "molequinha", "mol"+u"\u00E9"+"stia",
"moleza", "molezinha", "molhadura", "molinha",
"mona", "monarquia", "monja", "monocultura",
"monotonia", "montanha", "montanhesa",
"montearia", "montesa", "montmartresa", "montra",
"montureira", "morada", "moradia", "moradinha",
"mor"+u"\u00E1"+"via", "morcela", "morda"+u"\u00E7"+"a",
"mordedura", "moreia", "moreira", "morfina",
"morquesa", "mortalha", "morvandesa",
"morvanesa", "mosca", "mosquinha", "mosquitada",
"mostarda", "mostardinha", "mota",
"motocicleta", "motocicletinha", "movia",
"mucama", "mudancinha",
"mula", "muleta", "mulherada", "mulinha",
"multim"+u"\u00ED"+"dia", "m"+u"\u00FA"+"mia", "munheca", "muralha",
"mur"+u"\u00E7"+"a", "murceira", "murta", "musa",
"musculatura", "nabi"+u"\u00E7"+"a", "naca", "nadadeira",
"n"+u"\u00E1"+"dega", "nafta", "naftalina", "naifa",
"naja", "namoradeira", "nana", "nantesa",
"napolesa", "narbonesa", "narina", "nata",
"natinha", "natura", "natureza", "naturopatia",
"n"+u"\u00E1"+"usea", "nauseabunda", "navalha", "navalhada",
"navalhinha", "navarra", "navarresa", "neandertalesa",
"neblina", "nebrina", "necromancia", "necr"+u"\u00F3"+"psia", "nectarina",
"n"+u"\u00E9"+"dia", "neerlandesa", "nefelina", "nefelometria",
"negociata", "neoconcreta", "neoplasia", "neozelandesa", "nepalesa",
"neptunina", "nereida", "nervura", "n"+u"\u00E9"+"scia",
"nesga", "nespereira", "netiqueta", "neuma",
"neurastenia", "neuroanatomia", "n"+u"\u00EA"+"ustria",
"nevada", "nevadinha", "nevasca",
"n"+u"\u00E9"+"voa", "nevralgia", "nevropatia", "nexina",
"nhandirova", "niacina", "nicesa", "nicobaresa",
"nicotina", "nicotinamida", "nifedipina", "nigromancia",
"n"+u"\u00ED"+"mia", "nina", "ninfa", "ninfomania",
"ninhada", "ninhadinha", "ninharia", "nitreira",
"nitroglicerina", "n"+u"\u00ED"+"vea", "nivernesa", "niza",
"nobreza", "noca", "noctiluca", "n"+u"\u00F3"+"doa",
"nogueira", "nogueirinha", "noitada", "nomenclatura",
"n"+u"\u00F4"+"mina", "nona", "nora", "noradrenalina",
"norinha", "norlandesa", "norma", "norminha",
"nortada", "norueguesa", "norueguesinha", "nostalgia",
"not"+u"\u00ED"+"cia", "notocorda", "novela", "novelinha",
"novena", "novilhada", "nua", "nuca",
"nuinha", "nunciatura", "oba",
"obra", "obrada", "obrinha", "ocarina",
"odalisca", "odisseia",
"odrada", "oferenda", "oficina",
"ogiva", "oitiva", "ojeriza", "olaia",
"olaria", "oldemburguesa", "oleogravura", "olga",
"oligarquia", "ol"+u"\u00ED"+"mpia", "olimp"+u"\u00ED"+"ada", "olindesa",
"oliva", "oliveira", "oliveirinha", "olivina",
"ombreira", "omoplata", "on"+u"\u00E7"+"a", "oncinha",
"onda", "ondina", "ondinha", "ondurmanesa",
"onomatopeia", "ontogenia", "oogamia", "oosfera",
"opala", "opereta", "oranesa", "orca",
"orchata", "orelha", "orelhinha", "or"+u"\u00E9"+"stia",
"organela", "orla", "orleanesa", "orlinha",
"orquestra", "orqu"+u"\u00ED"+"dea", "ortiga",
"ortodoxia", "orvalhada", "orvalhadinha", "orvalheira",
"osga", "ossada", "ossadura", "ossamenta",
"ossatura", "osteossarcoma", "ostra", "otomana",
"ourama", "ourela", "ousadia", "outonada",
"outorga", "ouvidoria", "ova",
"ovelha", "ovelhinha", "ovinha", "oxitocina",
"paca", "pachorra", "pa"+u"\u00E7"+"oca", "pa"+u"\u00E7"+"oquinha",
"padaria", "p"+u"\u00E1"+"gina", "pala", "palavra",
"palavrinha", "palestra", "palestrinha", "paleta",
"palha", "palheta", "palhinha", "palho"+u"\u00E7"+"a",
"palma", "palmeira", "palmeirinha", "palminha",
"palmira", "paloma", "p"+u"\u00E1"+"lpebra", "pampa",
"pamplonesa", "pancada", "pancadaria", "p"+u"\u00E2"+"ndega",
"panela", "panelinha", "pantera", "pantomima",
"papelada", "papelaria", "paquistanesa", "par"+u"\u00E1"+"bola",
"paralisia", "parcela", "parceria", "pardela",
"pardesa", "parelha", "parenta", "parentela",
"parna"+u"\u00ED"+"ba", "par"+u"\u00F3"+"dia", "par"+u"\u00F3"+"quia", "parreira",
"parreirinha", "parta", "partenesa", "part"+u"\u00ED"+"cula",
"partitura", "parvonesa", "p"+u"\u00E1"+"scoa", "pasmaceira",
"passarada", "passarela", "passeata", "pasta",
"pastilha", "pastilhinha", "pastinha", "pastor"+u"\u00ED"+"cia",
"pataca", "pataquinha", "pateada", "patifaria",
"patilha", "patroa", "patroinha", "patuscada",
"paula", "paulada", "paulina", "pavana",
"paveia", "pe"+u"\u00E7"+"a", "pecha", "pecinha",
"pe"+u"\u00E7"+"onha", "pediatria", "pedofilia", "pedra",
"pedrada", "pedrenesa", "pedresa",
"pedrinha", "pega", "pegada", "pegadinha",
"peia", "peleja", "peli"+u"\u00E7"+"a", "pel"+u"\u00ED"+"cula",
"pena", "penedia", "peneira", "peneirinha",
"penha", "penicilina", "peninha", "pen"+u"\u00ED"+"nsula",
"penteadeira", "penumbra", "peonada", "pepsina",
"pequenada", "pequinesa", "pera", "perda",
"pereira", "pereirinha", "perereca", "perf"+u"\u00ED"+"dia",
"perfumaria", "perguntinha", "per"+u"\u00ED"+"cia",
"periferia", "perinha", "perip"+u"\u00E9"+"cia", "permuta",
"perna", "perninha", "p"+u"\u00E9"+"rola", "perp"+u"\u00E9"+"tua",
"perspectiva", "perspic"+u"\u00E1"+"cia", "pertin"+u"\u00E1"+"cia",
"perua", "peruana", "peruca",
"pesca", "pescada", "pescadinha", "pescaria",
"peseta", "pesquisa", "pessoa", "pessoinha",
"peta", "p"+u"\u00E9"+"tala", "peteca", "petersburguesa",
"petinga", "petinha", "petiza", "petizinha",
"pia", "piada", "piadinha", "picardia",
"piemontesa", "pilha", "p"+u"\u00ED"+"lula", "pimenta",
"pimentinha", "pinacoteca", "pinga", "pintura",
"piovesa", "pipa", "piranha",
"pirataria", "piroga", "piscina", "piscininha",
"pista", "pistola", "pita", "pitada",
"pitadinha", "piteira", "pitinha", "pitombeira",
"pizza", "placa", "placenta", "placentinha",
"planilha", "planta", "plantinha", "planura",
"plaquinha", "plataforma", "plateia", "platina",
"pleura", "pluma", "pneumonia", "pobreza",
"pocema", "pocilga", "poda",
"poeira", "poeirada", "poeirinha", "poesia",
"poetisa", "poia", "poiaresa", "polca",
"poliandria", "pol"+u"\u00ED"+"cia", "policromia", "polifonia",
"poligamia", "polissemia", "polonesa", "polpa",
"poltrona", "p"+u"\u00F3"+"lvora", "pomada", "pompa",
"pontada", "pontadinha", "pontaria", "popa",
"popinha", "popula"+u"\u00E7"+"a", "porcaria", "porcelana",
"pororoca", "portaria", "portela",
"portinha", "portinhola", "portugalesa", "portuguesa",
"portuguesinha", "postura", "pota", "pouca", "poupancinha",
"pousada", "pousadinha", "p"+u"\u00F3"+"voa", "pra"+u"\u00E7"+"a",
"pracinha", "praga", "praia", "prancha",
"pranchada", "pranchinha", "prataria", "prateleira",
"prateleirinha", "precisa", "pr"+u"\u00E9"+"dica", "prefeitura", "pregui"+u"\u00E7"+"a",
"preguicinha", "preia", "preitesa", "prelada",
"premissa", "prenda", "prendinha",
"presilha", "pressa", "pressinha", "presteza",
"pretensa", "pret"+u"\u00F3"+"ria", "primavera", "primazia",
"princesa", "princesinha", "prioresa", "proa",
"procuradoria", "proeza", "profecia", "profilaxia",
"profundeza", "promessa", "promotoria", "propaganda",
"propagandinha", "propina", "prosa", "pros"+u"\u00E1"+"pia",
"prosinha", "pros"+u"\u00F3"+"dia", "pr"+u"\u00F3"+"stata", "prote"+u"\u00ED"+"na",
"provedoria", "psicologuesa", "publicitesa",
"pudic"+u"\u00ED"+"cia", "pulga", "pulseira", "pulseirinha",
"pureza", "quadraria", "quadratura", "quadrela",
"quadricomia", "quadriga", "quadrilha", "quadrilhinha",
"quadrissemana", "quantia", "quaresma",
"quebradura", "quebrantada", "quebreira", "queda",
"quedinha", "queimadura", "queiroga", "quelha",
"quenga", "quentura", "queratina", "queratomal"+u"\u00E1"+"cia",
"quercinesa", "querela", "quietura", "quilha",
"quimbanda", "quimera", "quimioprofilaxia", "quimiotaxia",
"quimiotripsina", "quina", "quincha", "quinina",
"quininha", "quinquilharia", "quintana", "quinzena",
"quirguistanesa", "quiromancia", "quitanda", "quitina",
"quixaba", "quota", "quotinha", "rabeca",
"rabeira", "rabona", "ra"+u"\u00E7"+"a",
"racinha", "radioastronomia", "r"+u"\u00E1"+"dula", "rainha",
"rainhazinha", "raiva", "raivinha", "rajada",
"rajadinha", "ramaria", "rampa", "rampinha",
"ranchada", "rapa", "rapadura", "rapariga",
"rapaziada", "rapina", "rapinha", "raposa",
"raposinha", "rasoira", "raspadura", "ratazana",
"ratoeira", "ravina", "reabertura", "realeza",
"rebarba", "rebarbativa", "rebeca", "rebeldia",
"reboleira", "rebu"+u"\u00E7"+"ada", "reca", "recandidatura",
"recarga", "recebedoria", "receita", "receitinha",
"recoveira", "r"+u"\u00E9"+"dea", "redoma", "redondeza",
"reengenharia", "reentrada", "reentradinha", "refinaria",
"regalia", "regata", "regatinha", "r"+u"\u00E9"+"gia",
"regina", "regra", "regrinha", "r"+u"\u00E9"+"gua",
"reitoria", "rel"+u"\u00ED"+"quia", "relojoaria", "remessa",
"rena", "renda", "rendinha",
"reninha", "rentesa", "r"+u"\u00E9"+"plica", "reposta",
"represa", "reprimenda", "rep"+u"\u00FA"+"blica", "resenha",
"resina", "resinga", "resposta",
"respostinha", "ressaca", "ressalva", "r"+u"\u00E9"+"stia",
"restinga", "retaguarda", "retina", "retinopatia",
"retorta", "retranca", "revelia", "revenda",
"reviravolta", "revista", "revistinha", "revoada",
"revoadinha", "reza", "rezina", "rezinha",
"riba", "ribaldeira", "ribalta", "ricina",
"rifa", "rifampicina", "rijeza", "riodonoresa",
"rionoresa", "riqueza", "risada", "risadinha",
"risota", "rixa", "rizicultura", "rocha",
"rochinha", "rociada", "rodela", "rodelinha",
"rodilha", "rodopsina", "rodovia", "rolada",
"roladinha", "rolda", "roldana", "roleta",
"rolha", "romanhesa", "romaria",
"romena", "ronca", "ronceira",
"rondinha", "ronha", "roreja", "rosa",
"ros"+u"\u00E1"+"cea", "rosalina", "rosaria", "rosca",
"r"+u"\u00F3"+"sea", "roseira", "roseta", "rosilha",
"rosina", "rosinha", "rosita", "rosquilha",
"rosquinha", "rota", "roterdamesa", "rotina",
"rotunda", "rotura", "roubalheira", "roupa",
"rouparia", "roupeta", "roupinha", "rua",
"ruana", "ruanda", "ruandesa", "rub"+u"\u00E9"+"ola",
"r"+u"\u00FA"+"bida", "rubra", "rubrica", "ru"+u"\u00E7"+"a",
"rudeza", "ruela", "ruelinha", "ruga",
"ru"+u"\u00ED"+"na", "ruinha", "ruma", "rumba",
"rupia", "ruptura", "rusga", "r"+u"\u00FA"+"tila",
"sabatina", "sabedoria", "sabinada", "saboneteira",
"sacha", "sacola", "sacolinha", "sacrista",
"sacristia", "sadia", "safadeza", "safena",
"safira", "safra", "saga", "sageza",
"saiaguesa", "saiinha", "sala",
"salada", "saladinha", "salamandra", "salema",
"saleta", "salinha", "saliva", "salmoira",
"salmonela", "salmoura", "saloia", "salsa",
"salsicha", "salsinha", "samarinesa", "samarra",
"sanfona", "sanfoninha", "sanga", "sangalhesa",
"sangesa", "sangria", "sangueira", "sanhuda",
"sanita", "santana", "santiaguesa", "sanzala",
"sapataria", "sapucaia", "sarabanda", "saracura",
"saraiva", "sar"+u"\u00E7"+"a", "sarda", "sardenha",
"sardinha", "sarjeta", "sarna", "sassaresa",
"s"+u"\u00E1"+"tira", "sauna", "sa"+u"\u00FA"+"va", "savana",
"savelha", "seara", "sebastiana", "sebenta",
"secretaria", "secretina", "secura", "seda",
"segadeira",  "segunda", "segundona", "segurelha",
"seira", "seita", "seiva", "selaginela", "selha",
"selva", "selvageria", "selvajaria", "semana",
"s"+u"\u00EA"+"mea", "semeadura", "sena", "senda",
"sendinesa", "senegalesa", "senha",
"senhorita", "seninha", "senzala", "s"+u"\u00E9"+"pia",
"septicemia", "sepultura", "sequanesa", "sequeira",
"sequela", "serapilheira", "sereia", "serenata",
"seringa", "serotonina", "serpa", "serpentina",
"serra", "serrania", "serrinha",
"serventia", "s"+u"\u00E9"+"rvia", "sesmaria", "sesta",
"seta", "setemesa", "siamesa", "sibila",
"sienesa", "sigla", "signa", "silhueta",
"silicomanganesa", "silva", "silveira", "s"+u"\u00ED"+"lvia",
"silvicultura", "silvinha", "simetria", "simonia",
"simpatia", "simpleza", "sina", "sinagoga",
"sincronia", "s"+u"\u00ED"+"ndroma", "sineta", "sinfonia",
"singalesa", "singeleza", "sintonia", "sirena",
"sirigaita", "siroquesa", "sirventesa", "soalheira",
"soberania", "soberba", "sobrancelha",
"sobrancelhinha", "sobranceria", "sobrecarga", "sobrecarta",
"sobrecasaca", "sobremesa", "sobrevida", "sobrevidinha",
"sobrinha", "sociologuesa", "sodomia", "sofia",
"soja", "sola", "soldadura", "soleira",
"sol"+u"\u00E9"+"rcia", "solha", "solteirona", "soltura",
"sombra", "sombria", "sombrinha", "sonata",
"sonda", "soneca", "sonoplastia", "sopa",
"sopinha", "sorveteria", "sotaina", "sousa",
"souza", "sova", "sovela",
"sovinha", "sua", "suazilandesa", "subcl"+u"\u00E1"+"via",
"subdelegacia", "subida", "subidinha", "subtileza",
"sucata", "s"+u"\u00FA"+"cia", "su"+u"\u00E7"+"uarana", "sudanesa",
"sudanesinha", "sujeira", "sujeirinha", "sultana",
"s"+u"\u00FA"+"mula", "sundanesa", "supercopa", "superempresa",
"superfina", "superfininha", "superliga", "superta"+u"\u00E7"+"a",
"s"+u"\u00FA"+"plica", "supremacia", "surdina", "surinamesa",
"surra", "surriada", "surriadinha", "susana",
"suserania", "sutileza", "taba", "tabacaria",
"tabaqueira", "tabatinga", "tabela", "tabelinha",
"taberna", "taberninha", "tabica", "tablatura",
"tablita", "t"+u"\u00E1"+"bua", "tabuada", "tabuleta",
"tabuletinha", "ta"+u"\u00E7"+"a", "tacada", "tacadinha",
"tacha", "tachinha", "tacinha", "taenia",
"tailandesa", "taiwanesa", "tajiquistanesa", "talagar"+u"\u00E7"+"a",
"taleira", "talidomida", "talisca", "tamareira",
"tamaresa", "tangapema", "tangerina", "tape"+u"\u00E7"+"aria",
"tapera", "taperinha", "tapioca", "taprobana",
"tapuia", "taquara", "taquarinha", "tarambola",
"taramela", "tarantela", "tarasconesa", "tarbesa",
"tardeza", "tarefa", "tarentesa", "tarifa",
"tarja", "tarjinha", "tarola", "tarouquesa",
"tarrafa", "tarragonesa", "tartaruga", "tasca",
"tascinha", "tasquinha", "tauromaquia", "tavanesa",
"taverna", "t"+u"\u00E1"+"vola", "taxa", "taxonomia",
"teada", "tebaida", "teca", "tecla",
"tecnocracia", "teia", "teima", "teimosia",
"tela", "telefonia", "telemetria", "telenovela",
"telepatia", "televisa", "telha", "telhinha",
"telinha", "telitoquia", "t"+u"\u00EA"+"mpera",
"temperatura", "t"+u"\u00EA"+"mpora",
"tempura", "tenda", "tendinha", "tenra",
"teocracia", "teoria", "teoriazinha",
"tequila", "terapiazinha", "terebintina", "teresa",
"teresinha", "terna", "ternatesa", "ternura",
"ternurinha", "Terra", "terra", "terracota", "terrantesa",
"terrina", "terrinha", "tesouraria", "tessitura",
"testosterona", "teutoburguesa", "textura", "tiara",
"tiazinha", "t"+u"\u00ED"+"bia", "tibieza", "tigela",
"tigelinha", "tigresa", "tijuca", "tintura",
"tipoia", "tirada", "tirania", "tire"+u"\u00F3"+"idea",
"tirolesa", "tiroxina", "tisana", "toada",
"toalha", "toalhinha", "tocaia", "tocha",
"toga", "togolesa", "toguesa", "toleima",
"toleteira", "tona", "tonelada", "tonganesa",
"tonina", "tonquinesa", "tonsila", "tonsura",
"tonteira", "tontura", "tora", "tordilha",
"torga", "torinha", "tornesa", "torpeza",
"torquesa", "torrada", "torradinha", "torrantesa",
"torreira", "tortura", "torva", "tosquia",
"touca", "tou"+u"\u00E7"+"a", "toupeira", "toupeirinha",
"tourada", "touradinha", "toxina", "toxinazinha",
"trabalheira", "tr"+u"\u00E1"+"cia", "trag"+u"\u00E9"+"dia", "tragicom"+u"\u00E9"+"dia",
"traineira", "tralha", "trama",
"trambolha", "tramela", "traminha", "tramoia",
"trancinha", "tranqueta", "trapa"+u"\u00E7"+"a", "trapalhada",
"traparia", "trapassaria", "trapeira", "traqueia",
"traquitana", "trava", "travadoira", "travessia",
"travessura", "travinha", "tr"+u"\u00E9"+"gua", "trela",
"treli"+u"\u00E7"+"a", "tremedeira", "tremelga", "tremesa",
"tremoceira", "tr"+u"\u00E9"+"plica", "tribuna", "trigonometria",
"trincadeira", "trincheira", "tripa", "tripe"+u"\u00E7"+"a",
"tripecinha", "tripinha", "tripla", "tripsina",
"tristeza", "tristezinha", "tristura", "trofa",
"troia", "trolha", "tromba", "trombeta",
"trompa", "tronqueira", "tropa", "tropeada",
"tropilha", "tropomiosina", "troponina", "tropopausa",
"troposfera", "trova", "trovoada", "trovoadinha",
"trufa", "truncadura", "truncatura", "truta",
"tua", "tuatara", "t"+u"\u00FA"+"bara", "tugandesa",
"tulha", "tulipa", "tulonesa", "tumba",
"tuna", "tunda", "tundra", "t"+u"\u00FA"+"nica",
"tuquianesa", "turbamulta", "turbina", "turca",
"turfa", "turinesa", "turma", "turmalina",
"turminha", "turquesa", "turquia", "turra",
"turrinha", "tutela", "tuvalesa",
"uberlandesa", "ucha", "ufania", "ugandesa",
"uiva", "ulna", "umbanda",
"umbela", "umbuzada", "unha", "unhada",
"unhagata", "unhinha", "upa", "urca",
"urdideira", "urdidura", "ureia", "uremia",
"uretra", "urgueira", "urina",
"urtiga", "urubuzada", "usbequistanesa",
"usina", "usura", "utopia",
"utopiazinha", "ut"+u"\u00F3"+"pica", "uva", "uvinha",
"uzbequistanesa", "vaca", "vacaria", "vacatura",
"vagareza", "vagina", "vagoneta", "vagueira",
"vaia", "vaiamontesa", "val"+u"\u00E1"+"quia", "valeira",
"valentia", "valentona", "valeta", "valetinha",
"valsa", "valsinha", "v"+u"\u00E1"+"lvula", "vanessa",
"vanguarda", "vaqueirama", "vaquejada", "vaquejadinha",
"vaquinha", "varanda", "varandinha", "vareja",
"vareta", "varga", "varicela", "variegada",
"var"+u"\u00ED"+"ola", "varredura", "v"+u"\u00E1"+"rzea", "vasectomia",
"vasilha", "vasilhinha", "vasopressina", "vassoira",
"vassoirinha", "vassoura", "vassourada", "vassourinha",
"vedeta", "veia", "veiazinha", "veiga",
"vela", "velada", "velhacaria", "velhada",
"velharia", "velhota", "velhusca", "velinha",
"veneta", "veniaga", "ventania", "ventura",
"verbena", "verbinha", "verborragia", "verdasca",
"verdelha", "verdura", "verdurinha", "vereda",
"veredinha", "verga", "vergasta", "vergonha",
"verg"+u"\u00F4"+"ntea", "veria",
"vermina", "veronesa", "verrina", "verruga",
"verruma", "versalhada", "versalhesa", "v"+u"\u00E9"+"rtebra",
"vesga", "ves"+u"\u00ED"+"cula", "vespa", "v"+u"\u00E9"+"spera",
"vespinha", "v"+u"\u00E9"+"stia", "vestidura", "vestimenta",
"vetusta", "vexada", "vexadinha", "vezeira",
"viana", "vianda", "vianesa", "vianinha",
"viatura", "v"+u"\u00ED"+"bora", "vicunha", "vida",
"videira", "videirinha", "videoendoscopia", "videoteca",
"vidinha", "vidra"+u"\u00E7"+"a", "vidra"+u"\u00E7"+"aria", "vieira",
"viela", "vienesa", "vietnamesa", "viga",
"viguesa", "vila", "vilafrancada", "vilania",
"vilari"+u"\u00E7"+"a", "vilegiatura", "vileza", "vilinha",
"vilta", "vina", "vincelha", "vindicta",
"vindima", "vindimadeira", "vindita", "v"+u"\u00ED"+"nea",
"vingancinha", "vinha"+u"\u00E7"+"a", "vinhada",
"vinheta", "vinhetinha", "vin"+u"\u00ED"+"cola", "vintena",
"viol"+u"\u00E1"+"cea", "violinha", "virada",
"viradeira", "viradinha", "virginiana", "virgolandesa",
"v"+u"\u00ED"+"rgula", "virilha", "visada", "visadinha",
"v"+u"\u00ED"+"scera", "viscondessa", "viseira", "v"+u"\u00ED"+"spora",
"vistoria", "vita", "vitamina", "vitaminazinha",
"vitela", "vitelinha", "viticultura", "v"+u"\u00ED"+"tima",
"vitinha", "vitivinicultura", "vitrina", "vitrola",
"vivenda", "vivendinha", "viveza", "v"+u"\u00ED"+"vida",
"vizeira", "vodca",
"voltinha", "volumetria", "vol"+u"\u00FA"+"pia", "vossenhoria",
"vozearia", "vozeira", "vozeria", "vulgata",
"vulva", "vurtemberguesa", "xangaiesa", "xaputa",
"xenofobia", "x"+u"\u00ED"+"cara", "xilogravura", "zabumba",
"zabumbada", "zaga", "zaida", "zalcitabina",
"zambujeira", "zana", "zaragata", "zaragatoa",
"zarolha", "zarzuela", "zebra", "zelandesa",
"zeugma", "zibelina", "zidovudina", "zina",
"zoada", "zoadinha", "zoeira", "zoidiogamia",
"zoina", "zombaria", "zona", "zonza",
"zoolatria", "zostera", "zura", "zurrapa",
"zurzia"])


# plvrMfoa - palavras masculinas - femininas apenas com alteracao do o-a menin[o] menin[a] 
plvrMfoa = set(["abecedarian", "abelan", "abelian", "abelonian",
"abert", "abevilian", "abian", "abirian",
"abiscan", "ablut"+u"\u00F4"+"man", "abraamian", "abraquian",
"abretan", "abr"+u"\u00F3"+"tan", "absolut", "absurd",
"abul"+u"\u00F4"+"man", "abziritan", "acacian", "acadian",
"acaiacan", "acaian", "acanian", "acantodian",
"acantopterigian", "acaridian", "acarnan", "acarnanian",
"acarnean", "acarnian", "accian", "accipitrian",
"acefalian", "acerran", "acheulian", "acian",
"acidalian", u"\u00E1"+"cid", "acipitrian", "acistan", "acleidian",
"aclidian", "acolalan", "a"+u"\u00E7"+"orian", "acorizan",
"acormian", "acrian", "acridian", "acromiocoracoidian",
"act"+u"\u00E9"+"an", "adamastorian", "adamian", "addisonian",
"adept", "adi"+u"\u00E1"+"fan", "adisonian", "adlerian",
"admir"+u"\u00F4"+"man", "adonian", "adotian", "adrastian",
"adrianopolitan", "adrumetan", "ad"+u"\u00FA"+"lter", "aerian",
"aer"+u"\u00F3"+"fan", "aer"+u"\u00F4"+"man", "afifan", "african",
"agalisian", "agamian", "agarenian", "aginian",
"agonian", "agor"+u"\u00E2"+"man", "agostinian", "agrarian",
"agrian", "agripinian", "aguaian", "agud",
"aladian", "alagoan", "alaman", "alan",
"alantoidian", "alarician", "alasquian", "alban",
"albarran", "albertogalvan", "albian", "albigensian",
"albionian", "albitan", "albuquerquian", "alcan",
"alcmanian", "alcochetan", "alcool"+u"\u00F4"+"man", "aldean",
"alectorian", "alectoromancian", "alencarian", "alentejan",
"aleuromancian", "alexandrin", "alexian", "alfierian",
"algaravian", "algerian", "alg"+u"\u00F4"+"man", "algomanian",
"algonquian", "alhei", "aliban", "alifan",
"alofan", "alogian", "alpinopolitan", "alsacian",
"alt", "althusserian", "altinopolitan", "alun",
"aluvian", "alv", "alvesian", "alvinopolitan",
"alvitan", "amalfitan", "amarel", "amarelinh",
"amarg", "amastrian", "amazonian", "ambian",
"ambilian", "ambrosian", "amebian", "ameliopolitan",
"american", "american"+u"\u00F4"+"man", "amibian", "amidalian",
"amig", "amigdalian", "amonian", "amorian",
"amorinopolitan", "amorosian", "amorrean", "ampl",
"amsterdamian", "anacoret"+u"\u00F4"+"man", "anafrodisian", "analantoidian",
"anamnian", "anan", "anarian", "anastacian",
"anastasian", "anatolian", "anaxagorian", "anchietan",
"ancian", "anciran", "anconitan", "andaman",
"andorian", "andorran", "andorrian", "anedot"+u"\u00F4"+"man",
"anencefalian", "anfibian", "anficelian", "angarian",
"angatuban", "angelian", "angican", "angimacurian",
"anglican", "angl"+u"\u00F4"+"man", "angolan", "anguilan",
"angust"+u"\u00ED"+"man", "anibalian", "animiquian", "anomian",
"an"+u"\u00F4"+"nim", "anopenian", "ansarian", "anselmian", "antarian",
"antelian", "antelicotragian", "antelitragian", "anterian",
"antessignan", "antic"+u"\u00F4"+"man", "ant"+u"\u00ED"+"fon", "antig",
"antigenidian", "antilian", "antilopian", "antinomian",
"antioquian", "antipodian", "antipolitan", "antirrepublican",
"antirrobertian", "antiultramontan", "antocian", "ant"+u"\u00F4"+"man",
"antonian", "antoninian", "antuerpian", "apalachian",
"apelician", "apexian", "apician", "ap"+u"\u00F3"+"fan",
"ap"+u"\u00F3"+"stol", "aprustan", "apuan", "apulean",
"apulian", "aquarian", "aquenian", "aquilean",
"aquilian", "aquilitan", "aquitan", "aquitanian",
"aracajuan", "ara"+u"\u00E7"+"atiban", "aracnean", "aracnian",
"aracnoidian", "aradian", "aragan", "araguaian",
"aralian", "aranean", "araucan", u"\u00E1"+"rbitr", "arc",
"arcadian", "arcan", "ardian", "arduinian",
"areiopolitan", "arenapolitan", "arenopolitan", "argan",
"argelian", "argentin", "argian", "argiletan",
"arguesian", "arian", "arissantorinian", "aristofanian",
"aristoxenian", "aritenoidian", "aritm"+u"\u00F4"+"man", "arlesian",
"arm"+u"\u00EA"+"ni", "armenian", "arminian", "armorican",
"arnopolitan", "arocelitan", "arquean", "arquiloquian",
"arquitet", "arsenomelan", "artejan", "artemonian",
"artesian", "arubian", "asbolan", "ascanian",
"ascaridian", "ascetan", "ascidian", "asclepitan",
"asc"+u"\u00F3"+"fan", "ascrian", "asculan", "asgardian",
"asian", "asmonian", u"\u00E1"+"sper", "aspidian", "assassin",
"assidian", "ass"+u"\u00ED"+"du", "assirian", "assisian", "assotan",
"astecan", "asten"+u"\u00F4"+"man", "astian", "astigitan",
"astorgan", "astragalian", "astromancian", "asturian",
"astut", "ataman", "atelan", "atelorraquidian",
"atent", "aterian", "at"+u"\u00E9"+"rman", "atibaian",
"atilian", "atlasian", "atletican", "atloidian",
"atran", "aturian", "auburnian", "audian", "august",
"augustan", "augustinian", "aulican", "aurelian",
"aurignacian", "ausentan", "ausetan", "ausonian",
"australasian", "australian", "austrasian", "austr"+u"\u00ED"+"ac",
"aut"+u"\u00E1"+"rquic", "autocaricat", "autodian", "autopian", "autoplan",
"autunian", "auxitan", "avan", "avan"+u"\u00E7"+"ad",
"avelinopolitan", "averan", "avidian", "axinian",
"azerbaidjan", "azoian", "baamian", "babiruss",
"bacalaurean", "bachelardian", "bachian",
"bacian", "baconian", "bacterian", "bacteridian",
"bactrian", "bactromancian", "badarian", "baenossaurian",
"bagageir", "bahamian", "baian", "baianopolitan",
"bailadeir", "bailarin", "bajan",
"bajocian", "b"+u"\u00E1"+"lan", "balan"+u"\u00E7", "balancinh",
"balantidian", "baleeir", "balet"+u"\u00F4"+"man", "balseir", "baltasarian",
"balzacian", "balzaquian", "bananeir",
"banc", "band", "bandoleir", "banezian", "bangladechian",
"bangladeshian", "banh", "banheir", "banian",
"banqueir", "baquean", "baquian", "barat", "barateir",
"barbadian", "b"+u"\u00E1"+"rbar", "barbian", "barbican",
"barbudan", "barbuzan", "barc", "barcan",
"bardesan", "bardesanian", "bardisan", "barician",
"barqueir", "barquinh", "barr", "barrac",
"barran", "barranc", "barraquinh", "barremian",
"barsanian", "bartonian", "basanomelan", "basanom"+u"\u00E9"+"lan",
"bashkirian", "basilian", "basilidian", "basoquian",
"bastard", "batan", "batesian", "baudelairian",
"baudrillardian", "bauhausian", "baxterian", "beat",
"b"+u"\u00EA"+"bad", "bebian", "bechuan", "becquerian",
"beethovenian", "bel", "belasian", "belitan",
"bellinian", "belomancian", "belost"+u"\u00EA"+"man", "beltian",
"beltran", "bempostan", "bendit", "benedit",
"beneventan", "bengasian", "benign", "benossaurian",
"bent", "benthamian", "bentopolitan", "benzedeir",
"bercian", "beregran", "bergistan", "bergitan",
"bergmanian", "bergsonian", "berkelian", "berman",
"bernardian", "bertopolitan", "bessdian", "betabacterian",
"betican", "betinian", "bezerr", "biafran",
"biamerican", "bibian", "biblioclept"+u"\u00F4"+"man", "bibli"+u"\u00F4"+"man",
"bibliomancian", "bic", "bicheir", "bicotidian",
"bigodeir", "bigodud", "bigua"+u"\u00E7"+"uan", "biguan", "bilaquian",
"bilheteir", "b"+u"\u00ED"+"man", "biplan", "biquotidian",
"birman", "birmanian", "bisaian", "bisbilhoteir",
"biscargitan", "bisgargitan", "bismarckian", "bismarquian",
"bisonh", "bisonheri", "bizarr", "bob",
"bobinh", "bocacian", "bocagian", "boccaccian",
"bodian", "bodonian", "bo"+u"\u00EA"+"mi", "bogomilian",
"bogotan", "boituvan", "bol", "bolan",
"bolborraquidian", "bolet", "bolinh", "bolivarian",
"bolivian", "bols", "bonec", "bonfinopolitan",
"bonifacian", "bonit", "bononian", "bonosian",
"boolean", "boolian", "bopian", "boppian",
"boran", "borbonian", "borborian", "borcan",
"bornean", "boschiman", "bosforan", "b"+u"\u00F3"+"sni",
"bosnian", "bosporan", "bosquiman", "bostonian",
"botafogan", "boticelian", "botnian", "botsuan",
"boximan", "box"+u"\u00ED"+"man", "bozonian", "bracaraugustan",
"bragan", "bragan"+u"\u00E7"+"an", "branc", "brancaran",
"brand", "brandesian", "branquinh", "braquist"+u"\u00E9"+"fan",
"braseir", "brasileir", "brasilian", "brasitan",
"brasopolitan", "braunian", "brav", "brechtian",
"brentanian", "bric"+u"\u00F4"+"man", "brigadian", "brigian",
"britan", "brixian", "brodosquian", "bromoetan",
"bromopentan", "brownian", "brucian", "brunean",
"brut", "brutian", "brux", "brux"+u"\u00F4"+"man",
"buan", "bubetan", "buenopolitan", "bugeran",
"bugi", "bulboclitoridian", "bulbopenian", "burdigalian",
"burguesinh", "burr", "burrinh", "burundian",
"busan", "butan", "byronian", "caba"+u"\u00E7"+"uan",
"caban", "cabocl", "cabriuvan", "cabu"+u"\u00E7"+"uan",
"cachoeiran", "cachorr", "cacodemon"+u"\u00F4"+"man",
"cacofat"+u"\u00F4"+"man", "cacofon"+u"\u00F4"+"man",
"cadmian", "caetan", "caetanopolitan", "cafezopolitan",
"caiaponian", "caicavian", "caietan", "cainian",
"cajan", "calaarian", "calabrian", "calan",
"cal"+u"\u00E7"+"ad", "cal"+u"\u00E7"+"adinh", "calcanean", "caledonian",
"californian", "calm", "calomelan", "calom"+u"\u00E9"+"lan",
"calovian", "calv", "camapuan", "camarajiban",
"camaran", "cambaratiban", "camberran", "cambojan",
"cambojian", "cambrian", "cameleonian", "camelian",
"cameronian", "camilian", "camonian", "campanian",
"campian", "campichan", "can", "canadian",
"canapolitan", "cancerian", "c"+u"\u00E2"+"ndid", "candidat",
"canec", "canfan", "canisian", "canossian",
"canovian", "cantaridian", "cantorian", "canzianopolitan",
"confeiteir", "cont"+u"\u00ED"+"gu", "caparican", "caparitan", "capetian", "capinopolitan",
"capivarian", "capixaban", "capoeiran",
"caprelian", "caprian", "capricornian", "capsitan",
"capuan", "caralitan", "caramban", "caramulan",
"caran", "carapicuiban", "caravaggian", "carboran",
"carcaman", "cardan", "carelian", "carian",
"caribian", "cariguan", "carlopolitan", "carlostadian",
"carlovingian", "carlylian", "carman", "carmanian",
"carmelitan", "carmelopolitan", "carmopolitan", "carnacian",
"carnaiban", "carolingian", "carolstadian", "carontian",
"carotidian", "carp", "carpetan", "carpian",
"carpocracian", "carpometacarpian", "carpopterigian", "carquesian",
"carranchan", "carrapitan", "carrilan", "carroceir",
"carseolan", "carsitan", "carteir", "cartesian",
"cartimitan", "cartorian", "cartusian", "carvalhopolitan",
"cas", "casac", "casc", "caseir",
"casimirian", "caspian", "casquivan", "cassinian",
"castelhan", "castelperronian", "casterlian", "castilian",
"castrinopolitan", "cataban", "cataclismian", "catalan",
"catapan", "catarian", "catarquean", "catarrinian",
"c"+u"\u00E1"+"tedr", "catian", "catolician", "catonian",
"catruman", "caucasian", "caud"+u"\u00ED"+"man", "cauranan",
"caval", "cavalarian", "cavalari"+u"\u00E7", "cavalerian", "cavian",
"caxemirian", "cebian", "cebuan", "cefaleditan",
"cefalodian", "cefal"+u"\u00F4"+"man", "cefalorraquian", "cefalorraquidian",
"ceg", "ceifeir", "celestian", "celestin", "celossomian", "celsian",
"celt"+u"\u00F4"+"man", "cenoman", "cenomanian", "cent"+u"\u00ED"+"man",
"cent"+u"\u00F4"+"man", "centrafrican", "cerafan", "cerban",
"cercan", "cercinitan", "cerdonian", "cerebrorraquidian",
"ceresopolitan", "cerretan", "cert", "cervicoacronian",
"cesarian", "cest"+u"\u00F3"+"plan", "cetan", "cevian",
"c"+u"\u00E9"+"zannian", "chabacan", "chabian", "chadian",
"chamusan", "chandlerian", "chaplinian", "charabilhan",
"charad"+u"\u00F4"+"man", "charian", "charmutian", "charran",
"chassidian", "chat", "chatelperronian", "chatian", "chavelhan",
"chavian", "chei", "chelean", "chic", "chilen",
"chiman", "chinel", "chinelinh", "chiquitan", "chiraquian",
"chiriguan", "chopinian", "churchillian", "cian",
"c"+u"\u00ED"+"an", "cianocetan", "cianomelan", "cianom"+u"\u00E9"+"lan",
"cibilitan", "cicendelian", "ciceronian", "cicindelian",
"ciclan", "cicloalcan", "ciclobutan", "ciclocefalian",
"cicloexan", "ciclopentan", "ciclopian", "ciconian",
"cigan", "cigarr", "cilician", "cim"+u"\u00F3"+"fan",
"cimolian", "cin"+u"\u00E9"+"fil", "cin"+u"\u00F3"+"fil",
"cingaporean", "cingapurian", "cint", "cinzent",
"circadian", "circameridian", "circassian", "circatejan",
"circunfaringian", "cisfretan", "cisjuran", "cisleitan",
"cispadan", "cistarian", "cistebutan", "cistidian",
"cistigritan", "cisuranian", "citopolitan", "clactonian",
"clar", "clarian", "clast"+u"\u00F4"+"man", "claudelian",
"claudiopolitan", "clazomenian", "cle"+u"\u00F3"+"fan", "clept"+u"\u00F4"+"man",
"clet"+u"\u00F4"+"man", "clidoepitroclian", "clin"+u"\u00F4"+"man", "clismian",
"clit"+u"\u00F4"+"man", "clitorian", "clitoridian", "clitr"+u"\u00F4"+"man",
"clop"+u"\u00EA"+"man", "clop"+u"\u00F4"+"man", "cloral"+u"\u00F4"+"man", "cloraluretan",
"cloretan", "clor"+u"\u00F3"+"fan", "clorofilian", "clorometan",
"clunisian", "c"+u"\u00F3"+"an", "cobert", "coblencian",
"cocain"+u"\u00F4"+"man", "coccigian", "cocigean", "c"+u"\u00F3"+"dan",
"coestaduan", "colapian", "colarian", "colcozian",
"colectan", "coler"+u"\u00F4"+"man", "colestan", "coletan",
"colheitan", "colhetan", "colombian", "colonian",
"coman", "comanchian", "comblanchian", "combonian",
"c"+u"\u00F4"+"mod", "comorian", "companheir", "comparoquian",
"complex", "comp"+u"\u00F3"+"sit", "compostelan", "compost", "comprovincian",
"comtean", "comtian", "c"+u"\u00F4"+"ncan", "concis", "concordian",
"condilian", "condilotroclian", "condistritan", "condrocoracoidian",
"condroepitroclian", "condrostibian", "confucian", "coniacian",
"conidian", "conquilian", "consistorian", "constantinian",
"constantinopolitan", "contan", "cont"+u"\u00ED"+"nu", "conurban",
"convertiplan", "cop", "copan", "copeir",
"copernican", "copernician", "coplan", "copr"+u"\u00F4"+"man",
"coracoidian", "coralian", "coran", "cordeiropolitan",
"cordilheiran", "cord"+u"\u00ED"+"man", "cordofanian", "corean",
"core"+u"\u00F4"+"man", "corguinhan", "corimbacterian", "corinebacterian",
"corintian", "coriorretinian", "coritan", "cormarian",
"c"+u"\u00F3"+"rne", "cornean", "cornelian", "cornian",
"coroidean", "coronarian", "coronoidean", "correggian",
"correntezan", "corrigan", "corti"+u"\u00E7", "cortonian",
"corumbaiban", "cosan", "cosmopolitan", "cossetan",
"costepitroclian", "costocoracoidian", "costopubian", "costotraquelian",
"costureir", "cotejipan", "cotian", "cotidian",
"cotiloidian", "coulombian", "couperinian", "courbetian",
"coveitian", "cozinheir", "crabilhan", "cracoian",
"cracovian", "cramulhan", "cranachian", "cranian",
"cravilhan", "cr"+u"\u00E9"+"dul", "cremasterian", "cremonian", "cricaritenoidian",
"cricoaritenoidian", "crioul", "criptomelan", "crisamebian",
"crisob"+u"\u00E1"+"lan", "crisopolitan", "cristalinian", "cristalofilian",
"cristianapolitan", "cristianopolitan", "cristinapolitan", "cristopolitan",
"crivellian", "croacian", "crocian", "crocodilian",
"cromagnonian", "cromerian", "cromobacterian", "crotopod"+u"\u00F4"+"man",
"cruc"+u"\u00ED"+"fer", "cru"+u"\u00F4"+"man", "ctonian", "cuaitian", "cub",
"cuban", "cubitocarpian", "cubitofalangian", "cuboidocunian",
"cudan", "cuiaban", "cuiauan", "cuisian",
"culicidian", "culteran", "cult"+u"\u00F4"+"man", "cuman",
"cumberlandian", "cunean", "cuproasbolan", "curilian",
"curitiban", "curituban", "curvelan", "curvian",
"cutchian", "cutian", "cuuaitian", "cuvaitian",
"d'alembertian", "dacn"+u"\u00F4"+"man", "dacnomon"+u"\u00F4"+"man", "dactil"+u"\u00F3"+"graf",
"dalinian", "daltonian", "dan", "dan"+u"\u00E7"+"arin",
"dantian", "danubian", "daomean", "darwinian", "datil"+u"\u00F3"+"graf",
"decan", "d"+u"\u00E9"+"cim", "decr"+u"\u00E9"+"pit", "decuman",
"dec"+u"\u00FA"+"man", "defunt", "deleuzian", "dens",
"dentu"+u"\u00E7", "derradeir", "descobert", "desembara"+u"\u00E7"+"ad",
"desert", "desgra"+u"\u00E7"+"ad", "desgra"+u"\u00E7"+"adinh", "des"+u"\u00ED"+"di",
"deslandesian", "deslandian", "desmobacterian", "destr",
"destr"+u"\u00ED"+"man", "desuman", "detent", "deucalian", "deuterostomian",
"devonian", "devot", "deximontan", "dextran",
"dextr"+u"\u00ED"+"man", "dextr"+u"\u00F4"+"man", "dextrorfan", "dezembran",
"diab", "diaconian", "diacranian", "diacrian",
"di"+u"\u00E1"+"fan", "dianopolitan", "dianteir", "diat"+u"\u00E9"+"rman",
"diazometan", "dibenziletan", "dibenzilometan", "diboran",
"dibrometan", "dibromopropan", "dicerian", "dicloretan",
"diclorometan", "dicondilian", "dicran", "dicresiletan",
"dicresilofenilometan", "dicresilometan", "diderotian", "diditan",
"didonian", "difenan", "difeniletan", "difenilmetan",
"difenilobutan", "difenilodicloretan", "difenilodiclorometan", "difenilodimetiletan",
"difenilometan", "difenilopropan", "difenoletan", "diiodetan",
"diiodometan", "diluvian", "diminut", "dinaftilometan",
"dinancian", "dinarian", "dind", "dinitropropan",
"diocesan", "dionisian", "dioscorian", "diospolitan",
"dioxan", "dipirrilmetan", "diplantidian", "diplectan",
"diplobacterian", "dips"+u"\u00F4"+"man", "direit", "dirian",
"disc"+u"\u00ED"+"pul", "discret", "discurseir", "dispost", "dissan",
"dissilan", "dissilican", "dissilicoetan", "dissolut", "distint",
"distomian", "dit", "dit"+u"\u00E9"+"rman", "divers", "divin",
"divinopolitan", "divisopolitan", "d"+u"\u00ED"+"zim", "djibutian",
"dobradi"+u"\u00E7", "doceir", "dodecan", "dodecapolitan",
"domazan", "domerian", "dominican", "don",
"donatian", "doninh", "donzel", "dordonian",
"dorisopolitan", "dormideir", "dorsiepitroclian", "dorsimedian",
"dorsoepitroclian", "dorsomedian", "dox"+u"\u00F4"+"man", "draconian",
"dragoman", "dramaturg", "drogoman", "drummondian",
"d"+u"\u00FA"+"bi", "dulcinopolitan", "dulian", "duodecan",
"duod"+u"\u00E9"+"cim", "dupl", "durkheimian",
"eberthian", "eb"+u"\u00FA"+"rne", "ebusitan", "e"+u"\u00E7"+"anian",
"ecavian", "ecetran", "ecian", "eclesian",
"eclus", "ectocranian", "ectorraquidian", "eculan",
"edetan", "edipian", "efedrin", "ef"+u"\u00EA"+"mer",
"egban", "egelestan", "egestan", "egipan",
"eg"+u"\u00ED"+"pci", "egipcian", "egitan", "egnacian",
"eicosan", "eifelian", "einstanian", "einsteinian",
"einstenian", "eisensteinian", "elafian", "elan",
"elean", "eleit", "eletrotr"+u"\u00E9"+"pan", "eleuter"+u"\u00F4"+"man",
"eleuteropolitan", "eliotian", "elisabetan", "elisabetian",
"elisian", "elizabethan", "elpinian", "elusan",
"elzevirian", "emeritan", "emilian", "emilianopolitan",
"empedoclian", "emporitan", "empreiteir", "enan",
"encefalorraquian", "encefalorraquidian", "enc"+u"\u00FA"+"man", "endaspidian",
"enderodan", "endocranian", "endorraquian", "endorraquidian",
"eneaboran", "enferm", "enfermeir", "engra"+u"\u00E7"+"ad",
"enose"+u"\u00F4"+"man", "ente"+u"\u00F4"+"man", "enterobacterian", "enterocelomian",
"entremontan", "entrepan", "entrerrian", "enxabregan",
"eocambrian", "eodevonian", "eolian", "eperlan",
"epicondilian", "epicranian", "epictonian", "epidauritan",
"ep"+u"\u00ED"+"fan", "episcopalian", "epitacian", "epitauritan",
"epitet"+u"\u00F4"+"man", "epitroclean", "epitrocleoolecranian", "epoxietan",
"equatorian", "equiculan", "equinean", "equinian",
"equinocian", "eranian", "erasmian", "erastian",
"ergasi"+u"\u00F4"+"man", "erg"+u"\u00F4"+"man", "er"+u"\u00ED"+"dan", "erot"+u"\u00F4"+"man",
"ervan", "esbelt", "escafoiducunean", "escafoldoastragalian",
"escalabitan", "escapulotroquiterian", "escardonitan", "escass",
"esclerocornean", "escorpian", "escrav", "escrib"+u"\u00F4"+"man",
"escrit", "escur", "esfenovomerian",
"esferorradian", "esfincterian", "esgui", "eslov"+u"\u00E1"+"qui",
"esmitian", "esofagian", "esopian", "esparnacian",
"espars", "espartan", "espencerian", "espenglerian",
"esperantinopolitan", "espert", "espess", "espinh",
"espintrian", "espiran", "espiritan", "espiropentan",
"espl"+u"\u00EA"+"ndid", "espoletan", "espont"+u"\u00E2"+"ne", "esquerd",
"esquilian", "esquisit", "esquizocelomian", "esquizotripan",
"estabian", "estalian", "estalinian", "estampian",
"estancarian", "estancian", "estapedian", "estatan",
"estatuderian", "est"+u"\u00E9"+"fan", "estefanian", "est"+u"\u00E9"+"gan",
"estendalian", "estenost"+u"\u00E9"+"fan", "estereorradian", "esternomasseterian",
"esternotroquinian", "esterradian", "estesicorian", "estesi"+u"\u00F4"+"man",
"estilocoplan", "estilpnocloran", "estilpnomelan", "estonian",
"estrabonian", "estramontan", "estrangeir", "estranh",
"estreit", "estricn"+u"\u00F4"+"man", "estrit", "estr"+u"\u00F4"+"man",
"estrombolian", "estrumeir", "estupend", "esubian",
"etan", "et"+u"\u00E9"+"re", "etern", "eter"+u"\u00F4"+"man",
"etiluretan", "etiopian", "etolian", "euclidean",
"euclidian", "eudoxian", "eugenopolitan", "eulerian",
"eunapolitan", "eunomian", "eurafrican", "euralian",
"euramerican", "eurasian", "euriapolitan", "euripidian",
"euritan", "euscarian", "eustaquian", "eust"+u"\u00E9"+"fan",
"eutiquian", "eutireoidian", "evangelistan", "exaspidian",
"exat", "excels", "ex"+u"\u00ED"+"gu", "exocranian",
"extens", "extern", "extint", "extrem",
"exurban", "fabian", "fabrician", "faceir",
"fagifulan", "faisqueir", "falangean", "falangian", "falanginian",
"falansterian", "faloidian", "falopian", "fals",
"famenian", "familisterian", "faquirian", "faringian",
"farinheir", "farmac"+u"\u00F4"+"man", "fart", "fasian",
"fat"+u"\u00ED"+"can", "faunian", "faustian", "favorit",
"faxineir", "fazendeir", "feacian", "febronian",
"fedrian", "fei", "feiticeir",
"felin", "felizard", "feminin", "fenectan",
"fenian", "fenilcroman", "fenilmetan", "feniluretan",
"feretrian", "fernandopolitan", "f"+u"\u00E9"+"rre", "ferrialofan",
"ferroestilpnomelan", "ferromagnesian", "fichtian", "ficocian",
"fidalg", "fidian", "fidiculan", "fidjian",
"fieldingian", "fig", "fijian", "filadelfian",
"filantrop"+u"\u00F4"+"man", "filh", "filintian", "filipin", "filipopolitan",
"filolusitan", "fil"+u"\u00F4"+"man", "filonian", "fil"+u"\u00F3"+"sof",
"fin", "financeir", "fingid", "fioropolitan",
"firman", "firminopolitan", "f"+u"\u00ED"+"sic", "flacian", "flacourtian",
"flacurtian", "flagel"+u"\u00F4"+"man", "flameng", "flandrian",
"flaubertian", "flaviopolitan", "fleminguian", "flenusian",
"florestopolitan", "florian", "florianopolitan", "fluoran",
"fluormetan", "fluvian", "foc", "fof",
"fogueteir", "fon"+u"\u00F4"+"man", "fontan", "forasteir",
"for"+u"\u00E7"+"ad", "forentan", "foretan", "formian",
"formosan", "forr", "forrageir", "forulan", "fosc",
"fosforan", "foss", "fotinian", "fot"+u"\u00F3"+"graf",
"fotoplan", "frac", "franc", "francan",
"francian", "francinopolitan", "franciscan", "franciscopolitan",
"franc"+u"\u00F4"+"man", "franconian", "frang", "frangipan",
"franklinian", "frase"+u"\u00F4"+"man", "frasnian", "franzin", "frebelian",
"fregelan", "freirean", "freirian", "frentan",
"freudian", "fri", "fris", "frisian",
"friulan", "fr"+u"\u00ED"+"vol", "froebelian",
"froux", "fuchsian", "fucsian",
"fulan", "f"+u"\u00FA"+"lgid", "fulian",
"fundan", "funest", "furan", "furfuran",
"furian", "fusan", "fusc"+u"\u00ED"+"man", "futur",
"gabalitan", "gabian", "gaditan", "gaian",
"gaj", "g"+u"\u00E1"+"lban", "galecian", "galeg",
"galen", "galerian", "galh", "galhan", "galheir",
"galhoban", "galhofeir", "galican", "galician",
"galilean", "galinheir", "galizian", "galoisian",
"gal"+u"\u00F4"+"man", "galopolitan", "galvan", "gambian",
"gameleir", "gandhian", "gans", "garaban",
"garapeir", "garavan", "gardonian", "gargantuan",
"gargasian", "garot", "garran", "garrettian",
"garumnian", "gastresofagian", "gastrodi"+u"\u00E1"+"fan", "gat",
"ga"+u"\u00FA"+"ch", "gaulitan", "gaurian", "gaussian",
"gavelan", "gavieir", "gazan", "gedinian",
"gedrosian", "gefirian", "geiserian", "geladinh",
"geleir", "g"+u"\u00EA"+"me", "geminian", "genetlian",
"genian", "genovevan", "genu"+u"\u00ED"+"n", "geoplan",
"georgian", "georgin", "geran", "gercinopolitan",
"geresan", "geresian", "german", "gessnerian",
"getulian", "gidian", "ginasian", "ginec"+u"\u00F4"+"man",
"giroplan", "giscardian", "gitan", "givetian",
"givfitan", "gladstonian", "glauc"+u"\u00F3"+"fan", "gliceran",
"gliciltriptofan", "glicosaminoglican", "glossian", "glozelian",
"goan", "gobinian", "goelan", "goethian",
"goiabeir", "goian", "goianapolitan", "goianian",
"goisian", "goldonian", "gomarian", "gomesian",
"gongan", "gonzaguian", "gord", "gordian",
"gorduch", "gorgian", "gorr", "gorutuban",
"gotlandian", "gouvean", "graban", "gracianopolitan",
"graf"+u"\u00F4"+"man", "gramadeir", "grat", "gravan",
"gravetian", "graviscan", "grecian", "grec"+u"\u00F4"+"man",
"greg", "gregorian", "gril", "gritadeir",
"grocian", "groselheir", "gross", "grosseir",
"gua"+u"\u00E7"+"uan", "guaiuban", "gualterian", "guan",
"guanaban", "guarapuavan", "guaraque"+u"\u00E7"+"aban", "guaratuban",
"guaxupean", "guerreir", "guerrilheir",
"guinean", "guipuscoan", "guiratingan", "guis",
"guitan", "gunzian", "gurutuban", "gusan",
"gutembergian", "gutemberguian", "gutenbergian", "hadranitan",
"hahnemannian", "haitian", "halafian", "hallstattian",
"halomancian", "halstatian", "hamidian", "hamiltonian",
"hamletian", "handelian", "hanoverian", "hanovrian",
"hansean", "hansenian", "harm"+u"\u00F3"+"fan", "hartmanian",
"hassidian", "hastensian", "hatorian", "hauterivian",
"havaian", "havan", "haxix"+u"\u00F4"+"man", "hebraic",
"hediond", "hegelian", "heideggerian", "h"+u"\u00E9"+"li",
"heliconian", "heli"+u"\u00F3"+"fan", "heli"+u"\u00F3"+"man", "heliopolitan",
"helopian", "helvecian", "helvidian", "hemasian",
"hematot"+u"\u00ED"+"mpan", "hemimontan", "hendecan", "henrican",
"hentriacontan", "hequelian", "heraclitian", "herban",
"herbartian", "herciliopolitan", "hercinian", "herculan",
"herculanian", "herdeir", "herderian", "heredian",
"heriban", "hermesian", "hermian", "hermitian",
"hermogenian", "herodian", "herodotian", "heroic",
"heroin"+u"\u00F4"+"man", "hertzian", "hesbaian", "hesper"+u"\u00F3"+"fan",
"hessian", "heteralian", "heteroplan", "heterosoounian",
"heterost"+u"\u00E9"+"fan", "heterousian", "hexaclorocicloexan", "hexacloroetan",
"h"+u"\u00ED"+"brid", "hidraeroplan", "hidrelitan", "hidroaeroplan",
"hidrobiplan", "hidroboran", "hidrobrasileir", "hidrodips"+u"\u00F4"+"man",
"hidr"+u"\u00F3"+"fan", "hidr"+u"\u00F4"+"man", "hidromonoplan", "hidrot"+u"\u00ED"+"mpan",
"hierapolitan", "hierosolimitan", "higr"+u"\u00F3"+"fan", "hilbertian",
"hilean", "hileian", "hindustan", "hipolitan",
"hip"+u"\u00F4"+"man", "hipovarian", "hipsistarian", "hircan",
"hirt"+u"\u00ED"+"man", "hispan", "hister"+u"\u00F4"+"man", "hitlerian",
"hjelmslevian", "hobbesian", "hoffmannian", "holaspidian",
"holbachian", "holbaquian", "hollywoodian", "holocranian",
"homeousian", "hominian", "homoplan", "homousian",
"honest", "horacian", "hospedeir", "hospitaleir",
"hudsonian", "hugoan", "hullian",
"human", "humaniformian", "humanitarian", "humboldtian",
"humian", "h"+u"\u00FA"+"ngar", "hunterian", "huronian",
"husserlian", "hutchinsonian", "huterian", "huttonian",
"iacrian", "iamnotan", "iau"+u"\u00E1"+"can", "ibaran",
"ibaretan", "ibegean", "ibgean", "ibitigua"+u"\u00E7"+"uan",
"ibsenian", "icon"+u"\u00F4"+"man", "icosan", "icositan",
"idiocicl"+u"\u00F3"+"fan", "ienissean", "ienisseian", "igacian",
"igara"+u"\u00E7"+"uan", "igeditan", "igua"+u"\u00E7"+"uan", "iguan",
"iguanian", "iliberitan", "iliopretrocanterian", "iliopretrocantinian",
"iliorrotulian", "iliotrocanterian", "iliotrocantinian", "iliturgitan",
"illinoisian", "ilocan", "ilopolitan", "ilorcitan",
"imediat", "imens", "imorredour", "imperfeit",
"impolut", "imprevist", "imund", "inat",
"inaudit", "incaut", "incert", "inclus",
"inc"+u"\u00F3"+"gnit", "inc"+u"\u00F4"+"mod", "incr"+u"\u00E9"+"dul",
"inculcadeir", "incult", "indaiatuban", "indecis", "indian",
"indigest", "indign", "indiret", "indiscret",
"indisfar"+u"\u00E7"+"ad", "ind"+u"\u00F4"+"mit", "indon"+u"\u00E9"+"si", "indostan",
"industan", "in"+u"\u00E9"+"dit", "inequ"+u"\u00ED"+"voc", "inesian",
"infecund", "infinit", "infravermelh", "infus",
"ing"+u"\u00EA"+"nu", "ingrat", "ingrian", "inimig",
"iniodimian", "injust", "in"+u"\u00F3"+"cu", "inquiet",
"inquilin", "insan", "insensat", "ins"+u"\u00F3"+"lit",
"instant"+u"\u00E2"+"ne",
"insulindian", "inteir", "inteiri"+u"\u00E7", "intens",
"intercuspidian", "interioran", "intern", "internetian",
"interplan", "intrarraquidian", "intrus", "inuman",
"in"+u"\u00FA"+"mer", "invers", "invict", "invitatorian",
"iodometan", "iolopolitan", "ioruban", "ipojucan",
"ipresian", "ipuan", "iracemapolitan", "iranian",
"iraquian", "irian", "iridian", "iridocornean",
"irineopolitan", "irinotecan", "irituian", "irrequiet",
"irriquiet", "irvingian", "isidorian", "ismaelian",
"ismailian", "isobritan", "isobutan", "isoctan",
"is"+u"\u00F3"+"fan", "isofluoran", "isopentan", "isquiointertrocanterian",
"isquiopenian", "isquiopubian", "isquiopubitrocanterian", "isquiotrocanterian",
"israelian", "istrian", "itabiran", "itainopolitan",
"itaiopolitan", "italian", "italian"+u"\u00F4"+"man", "italician",
"ital"+u"\u00F4"+"man", "itamarandiban", "itamontan", "itan",
"itaocan", "itaparican", "itapecerican", "itapetingan",
"itapolitan", "itaquaquecetuban", "itatiban", "itibiran",
"itiquiran", "ituan", "ituiutaban", "iucatan",
"jabutian", "jacksonian", "jacobian", "jacsonian",
"jaguariban", "jaguaruan", "jalesian", "jamaican",
"jambolan", "jan", "jandaian", "jangan",
"jardineir", "jardinopolitan", "jarr", "jassidian",
"jau"+u"\u00E1"+"can", "jeceaban", "jeffersonian", "jenerian",
"jennerian", "jerezan", "jerezian", "jernean",
"jeronimian", "jerosolimitan", "jeruzan", "jesenopolitan",
"jessean", "jibutian", "joalheir", "joanesian",
"joanopolitan", "jobinian", "jordan", "jordanian",
"jovian", "jovinian", "judaic", "judean",
"julian", "juliopolitan", "jument", "jundiaian",
"junguian", "junqueir", "junqueiropolitan", "junquerian",
"junt", "jupiterian", "juquerinan", "juquerionan",
"juquirionan", "jurassian", "juruban", "jusan",
"just", "justiceir", "justinian", "justinopolitan",
"juvenalian", "kandorian", "kelvinian", "kemalian",
"keynesian", "kiribatian", "kryptonian", "kuwaitian",
"l"+u"\u00E1"+"bdan", "l"+u"\u00E1"+"bi", "labican", "labortan",
"la"+u"\u00E7"+"ad", "lacanian", "lacerdopolitan", "lacetan",
"lactametan", "lactovegetarian", "ladan", "l"+u"\u00E1"+"dan",
"ladroeir", "l"+u"\u00E1"+"gan", "lagart", "lagean",
"lagiran", "lagoan", "lagrangian", "laian",
"lajean", "lajian", "laletan", "lal"+u"\u00F4"+"man",
"lamarckian", "lamartinian", "lambran", "lamean",
"lamian", "laminitan", "lancasterian", "lancastrian",
"landenian", "landrinopolitan", "languedocian", "l"+u"\u00E2"+"nguid",
"lantan", "l"+u"\u00E2"+"ntan", "laocian", "laodicean",
"laosian", "laostan", "laotian", "lapachan",
"lapian", "laplacian", "laramian", "larendan",
"laringian", "lasciv", "lassalian", "lassallian",
"laterculian", "lat"+u"\u00ED"+"man", "latin", "laud",
"l"+u"\u00E1"+"udan", "lauran", "laurencian", "laurentian",
"lauretan", "lausanian", "lausannian", "lausian",
"lavadeir", "lavandeir", "lavaterian", "lecontian",
"legendrian", "legerian", "leg"+u"\u00ED"+"tim", "leibnitzian",
"leibnizian", "leiteir", "leman", "lemurian",
"lenan", "leninian", "lent", "leodoman",
"leoflorestan", "leonian", "leopardian", "leopolitan",
"lepidomelan", "leptitan", "leptocardian", "lesbian",
"lesotian", "let"+u"\u00F4"+"man", "leuc"+u"\u00F3"+"fan", "leucopetrian",
"levalloistan", "levaloisian", "levian", "levinopolitan",
"lhan", "liberian", "libertin", "l"+u"\u00ED"+"bi",
"libisosan", "librian", "liburnian", "licean",
"licopolitan", "liechtensteinian", "ligeir", "ligerian",
"ligitan", "ligorian", "liguorian", "ligurian",
"liliputean", "liliputian", "lilliputian", "liman",
"limian", "l"+u"\u00ED"+"mpid", "lind", "linean",
"linguedocian", "linh", "linnean", "li"+u"\u00F3"+"cran",
"liparitan", "l"+u"\u00ED"+"quid", "lis", "lisboan",
"lisonjeir", "listenstainian", "listentainian", "lisztian",
"liter"+u"\u00F4"+"man", "litrean", "littrean", "lituan",
"litu"+u"\u00E2"+"ni", "liuran", "livonian", "livramentan",
"lixeir", "lob", "lobatian", "lobeir",
"locarnian", "locustian", "loflucarban", "logaritm"+u"\u00F4"+"man",
"log"+u"\u00F4"+"man", "loir", "loira"+u"\u00E7", "lomb",
"lombocostotraquelian", "lombodorsotraquelian", "lombotrocantinian", "lombrosian",
"londinian", "longev", "long"+u"\u00ED"+"man",
"longinian", "long"+u"\u00ED"+"nqu", "longulan", "lopan",
"loretan", "lorman", "lorquian", "lotaringian",
"lotoman", "louc", "louletan", "lour",
"lourencian", "louretan", "lovelacian", "luan",
"lucaian", "lucan", "lucanian", "lucasian",
"lucianopolitan", "luc"+u"\u00ED"+"fer", "luciferian", "lucilian",
"lucopetrian", "lucrecian", "luculian", "ludian",
"ludovician", "luhmannian", "luisian", "lulian",
"lumberitan", "lupinan", "lupinopolitan", "lusacian",
"lusitan", "lusit"+u"\u00E2"+"ni", "lusitanian", "lus"+u"\u00F3"+"fon",
"lutecian", "luteran", "lutevan", "lutjan",
"ma"+u"\u00E7", "macac", "macacuan", "macatuban",
"macedonian", "machadian", "macian", "maci"+u"\u00E7",
"madeireir", "madimamuan", "maestrichtian", "mafometan",
"magan", "magdalean", "magdalenian", "magdalian",
"maglemosian", "magn", "magnesian", "magoadinh",
"magosian", "magr", "magrebian", "magrinh",
"maian", "maimonidian", "maioran", "malacitan",
"malacopterigian", "malasian", "malauian", "malavian",
"malawian", "maldan", "maldichan", "maldit",
"maldivan", "maldivian", "malian", "malign",
"mallarmean", "malpighian", "malthusian", "maluc",
"malucan", "malvernian", "mambucan", "mameluc",
"man", "manchesterian", "manchurian", "mancian",
"mancunian", "mandchurian", "mandean", "mandian",
"mandibulomentonian", "mandruan", "manducan", "mangan",
"manganomelan", "mangaratiban", "manitan", "mans",
"mansfieldian", "mant", "mantenopolitan", "mantovan",
"mantuan", "maometan", "maracajuan", "maracian",
"maragogipan", "maragojipan", "maran", "marangatuan",
"mar"+u"\u00E7"+"an", "marcelian", "marceneir", "marchan",
"marcian", "marcianopolitan", "marcoman", "marcosian",
"marcovian", "marculian", "mardan", "marfinian",
"mariamitan", "marian", "marianopolitan", "mariapolitan",
"marijuan", "marinettian", "marinopolitan", "mariopolitan",
"marisopolitan", "marlian", "marlowian", "marmontelian",
"marmulan", "marran", "marrec", "marsilian",
"martaban", "martinican", "martinopolitan", "marxian",
"m"+u"\u00E1"+"scul", "masculin", "massangan", "massilian",
"massilitan", "matarruan", "mateolan", "matutin",
"maupassantian", "maurian", "maurician", "mauritan",
"maurit"+u"\u00E2"+"ni", "mauritanian", "maurrasian", "m"+u"\u00E1"+"xim",
"maximilian", "maxwellian", "mazovian", "mazurian",
"mean", "meclenburgian", "m"+u"\u00E9"+"dan", "median",
"mediocarpian", "mediotarsian", "mediterran", "mediterranian",
"medonh", "megal"+u"\u00F4"+"man", "megalopolitan", "megapolitan",
"megarian", "meig", "melan",
"melanchthonian", "melanostibian", "melcoman", "melecian",
"melfalan", "melgacian", "melian", "melindan",
"melitan", "melitonian", "mel"+u"\u00F4"+"man", "melquisedecian",
"menalian", "menandrian", "mendelian", "mendelssohnian",
"mendig", "menian", "menin", "mensageir",
"mentan", "mentesan", "mentonian", "menuccian",
"meonian", "mer", "mercaptan", "mercesan",
"mercurian", "merfian", "merian", "meridian",
"meringian", "meroitan", "merovingian", "meruocan",
"mesm", "mesmerian", "mesmer"+u"\u00F4"+"man", "mesoamerican",
"mesocarpian", "mesocordilheiran", "mesodevonian", "mesometatarsian",
"mesopot"+u"\u00E2"+"mi", "mesotarsian", "mesovarian", "messalian",
"messianopolitan", "mesvinian", "metacarpian", "metacarpofalangian",
"metafisic"+u"\u00F4"+"man", "metamelfalan", "metan", "metastasian",
"metatarsian", "metatarsofalangian", "metiluretan", "metonian",
"metoxietan", "metoxifluoran", "metr"+u"\u00F4"+"man", "metropolitan",
"mexican", "micenian", "michan", "micoquian",
"micran", "microbian", "mididitan", "migecian",
"miguelopolitan", "milenarian", "milesian", "miletan",
"milevetan", "milevitan", "milhan", "milian",
"milician", "miliradian", "millian", "miltonian",
"mimosean", "mindelian", "minean", "mineir",
"minian", "m"+u"\u00ED"+"nim", "ministr", "minoan",
"minuan", "min"+u"\u00FA"+"scul", "mirab"+u"\u00E1"+"lan",
"mirab"+u"\u00F3"+"lan", "mirandolan", "mirandopolitan", "mirianopolitan",
"mirmeleonian", "mirob"+u"\u00E1"+"lan", "m"+u"\u00ED"+"ser", "missianopolitan",
"mississipian", "mississippian", "mistralian", "misulan",
"mitanian", "mitchurinian", "mit"+u"\u00F4"+"man", "mi"+u"\u00FA"+"d",
"moametan", "mo"+u"\u00E7", "mo"+u"\u00E7"+"ambican", "mocan",
"mocinh", "mococan", "mod", "modern",
"modest", "modinh", "moican", "mojian",
"molibduran", "molucan", "moment"+u"\u00E2"+"ne", "monasterian",
"mongolian", "monjolan", "monocarpian", "monocefalian",
"mon"+u"\u00F4"+"man", "mononfalian", "monoplan", "monossilan",
"mon"+u"\u00F3"+"ton", "monovarian", "monozonian", "monroean",
"montan", "montemuran", "montessorian", "monteverdian",
"montevidean", "montian", "montijan", "m"+u"\u00F3"+"rbid",
"mordovian", "moren", "morfin"+u"\u00F4"+"man", "morgean",
"morgian", "moribund", "morn", "morretian",
"mort", "mosan", "mosassaurian", "motan",
"mour", "mousterian", "mozartian", "mucan",
"mu"+u"\u00E7"+"ulman", "mud", "mudinh", "mu"+u"\u00E9"+"dan",
"muensterian", "muentzerian", "muggletonian", "mugletonian",
"mulat", "multan", "multiplan", "muncausenian", "munchhausenian",
"mundan", "muratorian", "murcian", "murexan", "muribecan",
"murilhan", "muritiban", "muse"+u"\u00F4"+"man", "musican",
"music"+u"\u00F4"+"man", "mussetian", "mussolinian", "musterian",
"mutan", "m"+u"\u00FA"+"tu", "mutunopolitan", "mutustratan",
"naalian", "nabantian", "nabocovian", "nabuquian",
"naftalan", "naft"+u"\u00F4"+"man", "namibian", "namurian",
"nantuan", "napolitan", "narandiban", "narcoguerrilh",
"narc"+u"\u00F4"+"man", "nasocian", "nasofaringian", "nasogenian",
"nasserian", "nassovian", "natalin", "natercian",
"natinian", "natinopolitan", "nativan", "nativitan",
"n"+u"\u00E1"+"ufrag", "nauran", "nauruan", "naxian",
"nazarean", "neandertalian", "neapolitan", "necisian",
"necissian", "neditan", "nefand", "nefast",
"nefridian", "nefrocelian", "negr", "negreir",
"nemean", "nemertian", "nemetan", "nemian",
"neocomanian", "neocomian", "neonomian", "neopolitan",
"neorrepublican", "neorroman", "neperian", "nepotian",
"neptunian", "neronian", "neropolitan", "nerulan",
"nestorian", "net", "netunian", "neur",
"neustrian", "neutr", "newtonian", "nhangua"+u"\u00E7"+"uan",
"nhungua"+u"\u00E7"+"uan", "nicaraguan", "nicerocian", "nicerotian",
"nicomelan", "nicopolitan", "nietzschian", "nigerian",
"nilopolitan", "ninf"+u"\u00F4"+"man", "nitrofuran", "nitrometan",
"noecian", "noemian", "noetan", "noetian",
"noiv", "nojent", "nolan", "nomentan",
"nonan", "norban", "norcaran", "nordestan",
"norian", "norman", "normand", "norpinan", "nos"+u"\u00F4"+"man",
"noss", "nost"+u"\u00F4"+"man", "noterian", "not"+u"\u00ED"+"dan",
"noturn", "nov", "novacian", "novat",
"novgorodian", "novi"+u"\u00E7", "novilh", "n"+u"\u00FA"+"bi",
"nubian", "nuculan", "numestran", "numidian",
"numistran", "nunalvarian", "oasian", "obes",
"obreir", "obscen", "obscur", "obsidian",
"obsolet", "obstetrican", "obstetr"+u"\u00ED"+"ci", "oc",
"ocan", "ocau"+u"\u00E7"+"uan", "occipitatloidian", "occipitomentonian",
"ocean"+u"\u00F3"+"graf", "ocipitatloidian", "ocipitomentonian", "ocitan",
"ocran", "ocriculan", "octacosan", "octadecan",
"octavian", "octazan", "ocult", "offenbachian",
"ofidian", "ogan", "oitav", "oiticican",
"olbian", "ol"+u"\u00E9"+"cran", "olecranian", "oleir",
"ol"+u"\u00ED"+"ban", "oliculan", "olig"+u"\u00F4"+"man", "olimpian",
"olisiponian", "oliven"+u"\u00E7"+"an", "olmedan", "olulan",
"omacefalian", "omalian", "oman", "omanian",
"omocefalian", "omotraquelian", "omotroquinian", "omotroquiterian",
"one"+u"\u00F4"+"man", "oni"+u"\u00F4"+"man", "onomat"+u"\u00F4"+"man", "onquestian",
"ontarian", "onusian", "opac", "opidan",
"opimian", "opi"+u"\u00F4"+"man", "oportun", "opost",
"ops"+u"\u00F4"+"man", "opulent", "oran", "oratorian",
"orbibarian", "orcian", "orcistan", "ordovician",
"orelhan", "orelheir", "oretan", "orex"+u"\u00ED"+"man",
"organomagnesian", "or"+u"\u00ED"+"gan", "oritan", "oriund", "ormuzian",
"ornitisquian", "ornit"+u"\u00F4"+"man", "orquest"+u"\u00F4"+"man", "orquidian",
"ort"+u"\u00F3"+"dan", "ortodox", "osirian", "oslerian",
"ossean", "ossenian", "ossiandrian", "ostran",
"otaian", "otavian", "otoman", "otomian",
"outr", "ovarian", "ovidian", "ovolactovegetarian",
"oxfordian", "oxican", "oxonian", "pacatuban",
"padovan", "padroeir", "paduan", "paisan",
"palacian", "palauan", "paleoamerican", "paleochadian",
"paleodevonian", "paleossiberian", "paleoterian", "palepolitan",
"palermitan", "palestin", "palestinian", "palestrinian",
"palican", "palm", "palmean", "palmeiropolitan", "palmian",
"palmifalangian", "palminopolitan", "palmiplan", "palmirian",
"palmitopolitan", "palmopolitan", "palonzan", "palouzan",
"palp"+u"\u00ED"+"man", "paludan", "paludian", "pambotan",
"p"+u"\u00E2"+"mpan", "pampangan", "pampean", "pampian",
"panamian", "pandan", "p"+u"\u00E2"+"ndan", "panfilian",
"panglossian", "panonian", "panopolitan", "panormitan",
"pantopelagian", "panurgian", "papeir", "papinian",
"papuan", "paquilemurian", "parabolan", "paracalan",
"paracefalian", "paracelsian", "paracian", "paradoxian",
"paradoxidian", "paragolcian", "paraguaian", "paraiban",
"paraisopolitan", "paralel", "paralian", "paran",
"paranaiban", "paranapolitan", "parapian", "paratireoidian",
"paratucan", "parentan", "parian", "parican",
"parisian", "parkinsonian", "parman", "parmigian",
"parnaiban", "parnasian", "paroquian", "parotian",
"parotidean", "parotidian", "parran", "parrascan",
"parsan", "parsian", "parteir", "partenian",
"partenopolitan", "parvatan", "pascalian", "pascoan",
"passagian", "past", "pasteuranian", "pasteurian",
"pastorean", "pastorian", "pastran", "pat",
"patalitan", "pataran", "paternian", "pat"+u"\u00F4"+"man",
"patrasan", "p"+u"\u00E1"+"tri", "patr"+u"\u00ED"+"ci", "patrician",
"patripassian", "patron", "pauletian", "paulian",
"paulician", "paulistan", "paulopolitan", "pausulan",
"pavan", "pavlovian", "pechuran", "peciolean",
"peciolian", "pecuran", "pedan", "pedestrian",
"ped"+u"\u00ED"+"man", "pedreir", "pedrinopolitan", "pedunculian",
"p"+u"\u00E9"+"gan", "pegasian", "peguan", "peircian",
"peixeir", "pelagian", "pelasgian", "pelean",
"pelican", "pelusian", "pelvian", "pelvitrocanterian",
"peman", "penapolitan", "pendencian", "p"+u"\u00EA"+"ndul",
"penean", "penian", "pensilvanian", "pentapolitan",
"pen"+u"\u00FA"+"ltim", "pepucian", "pepuzian", "pequen",
"pequenin", "peregrin", "perfeit", "p"+u"\u00E9"+"rfid",
"periamigdalian", "periecian", "periesofagian", "perineoclitoridian",
"perioecian", "peripenian", "periurban", "permian",
"pernambucan", "perosian", "perrian", "persepolitan",
"persian", "peruan", "peruiban", "perusian",
"peruvian", "pervers", "p"+u"\u00E9"+"ssim", "pessoan",
"pestalozzian", "pestan", "petrarquian", "petrobrucian",
"petrobrusian", "petrol"+u"\u00ED"+"fer", "petropolitan", "peuc"+u"\u00E9"+"dan",
"pfaffian", "piagetian", "pian", "picassian",
"p"+u"\u00ED"+"fan", "pilan", "pinan", "pint",
"pioneir", "pioran", "piracicaban", "piracurucan",
"piran", "pirandellian", "piratiningan", "piratuban",
"pirauban", "pirenopolitan", "piritiban", "pir"+u"\u00F3"+"fan",
"pir"+u"\u00F4"+"man", "piromelan", "pirom"+u"\u00EA"+"lan", "pironeptunian",
"pisan", "piscian", "p"+u"\u00ED"+"tan", "pitecian",
"pitopolitan", "pitulan", "placencian", "plantinian",
"pl"+u"\u00E1"+"tan", "platician", "platicran", "platonian",
"plautian", "pleban", "plen", "plesiometacarpian",
"plinian", "plumban", "plutarquian", "plutonian",
"pluvian", "pneumot"+u"\u00ED"+"mpan", "pobrezinh", "pojucan",
"polandian", "poliactinian", "polian", "poliglican",
"polinesian", "polinopolitan", "poliplan", "politic"+u"\u00F4"+"man",
"poliuretan", "polonian", "polovtsian", "pomb",
"pomeran", "pomeranian", "pompadourian", "pompean",
"pompeian", "poncian", "ponteir",
"pontian", "pontif"+u"\u00ED"+"ci", "pontocaspian", "popelican",
"poplican", "popperian", "porc", "pori"+u"\u00F4"+"man",
"port", "porteir", "portlandian", "portulan",
"potician", "potirendaban", "pot"+u"\u00F4"+"man", "potsdamian",
"poundian", "poxorean", "pracean",
"pracian", "pradopolitan", "praian", "prasian",
"prastran", "prat", "pratapolitan", "pratian",
"praxean", "praxilian", "praxitelian",
"prefeit", "preparatorian", "pres", "presbiteran",
"presbiterian", "prestilian", "prest"+u"\u00ED"+"man", "pretan",
"pretorian", "pretucan", "pr"+u"\u00E9"+"vi", "previst",
"priabonian", "priam"+u"\u00F4"+"man", "prim", "primeir",
"principan", "priscilian", "proboscidian", "procelian",
"proclian", "proculian", "procustian", "profund",
"prolan", "pront", "propan", "propost",
"pr"+u"\u00F3"+"pri", "proran", "prossifonian", "prossimian",
"prostitut", "proteinoglican", "proteoglican", "prototerian",
"proudhonian", "proustian", "provincian", "pr"+u"\u00F3"+"xim",
"prudentopolitan", "prudhommian", "prussian", "pruss"+u"\u00F4"+"man",
"psatirian", "psilomelan", "pterigian", "pterocerian",
"pubian", "publican", "puccinian", "pudian",
"pupil", "pur", "puritan", "p"+u"\u00FA"+"rpur",
"pursarian", "put", "puteolan", "quacrian",
"quadr", "quadr"+u"\u00ED"+"man", "quadr"+u"\u00FA"+"man", "qu"+u"\u00E1"+"drupl",
"quadrurban", "quaquerian", "quarenten", "quarenton",
"quart", "quartadeciman", "quartan", "quarteir",
"quartodeciman", "quatriduan", "quatruman", "quebradeir",
"quebradi"+u"\u00E7", "quedan", "queirosian", "queix",
"quelonian", "quenian", "queplerian", "querencian",
"quer"+u"\u00F4"+"man", "querquetulan", "quevedian", "quiban",
"quiet", "quiluran", "quiman", "quimeridgian",
"quin", "quinan", "quinquegencian", "quint",
"quintadeciman", "quintan", "quintilian", "quinzopolitan",
"quiribatian", "quirinopolitan", "quir"+u"\u00F3"+"fan", "quironian",
"quitandeir", "quotidian", "r"+u"\u00E1"+"ban", "rabd"+u"\u00F3"+"fan",
"rabelaisian", "rabelian", "rabican", "rabichan",
"rabosan", "rabud", "racinian", "rad"+u"\u00ED"+"cul",
"radiocarpian", "radi"+u"\u00F4"+"man", "rafaelian", "r"+u"\u00E1"+"fan",
"rafardan", "ragusan", "rai", "raian",
"rajaputan", "rajputan", "ram", "ramalh",
"rameir", "rapan", "raquidian", "rar",
"ras", "raspadeir", "rastafarian", "rasteir",
"rat", "ratzelian", "rauracian", "ravelian",
"rechan", "rechonchud", "rec"+u"\u00ED"+"proc", "reclus",
"recobert", "redavian", "redescobert", "redonian", "reduvian",
"reescrit", "referend", "regadeir", "regalian",
"regan", "regateir", "regatian", "regian",
"reginopolitan", "reichian", "religi"+u"\u00F4"+"man", "remot",
"renan", "renanian", "repentin", "repolhud",
"reptilian", "republican", "repuls", "ret",
"retilian", "retinian", "retorian", "retroestilian",
"retrogasserian", "retroiridian", "retrossifonian", "reuchlinian",
"ri", "rianapolitan", "ribacudan", "ribagorzan",
"ribanceir", "ribatejan", "ribeir", "ribeiropolitan",
"ric", "rica"+u"\u00E7", "ricardian", "ricardin",
"ricinian", "rid"+u"\u00ED"+"cul", "riemannian", "rifan",
"rij", "rinopolitan", "riojan", "riquetsian",
"risonh", "r"+u"\u00ED"+"spid", "rissian", "ritterian",
"rizoplan", "robenhausian", "robercian", "robertian",
"robervalian", "robespierrian", "robinsonian", "robust",
"ro"+u"\u00E7"+"ad", "roceir", "rod", "rodanian",
"rodarsenian", "rodelan", "rodendran", "rodesian",
"rodoarsenian", "rod"+u"\u00F3"+"fan", "rodriguian", "roemerian",
"rogacian", "rol", "rolandian", "roldonian",
"roman", "romeir", "rondonian", "rondonopolitan",
"ronsardian", "rooseveltian", "roqueir", "roquian",
"rosapolitan", "rosian", "rosman", "rosminian",
"rossinian", "rotarian", "roteiran", "rotineir",
"rotoplan", "r"+u"\u00F3"+"tul", "rotulian", "rouc",
"rousseaunian", "rox", "roxolan", "ruan",
"ruban", "rubelitan", "rubiacean", "rubican",
"rudolfian", "ruian", "ruivan", "rupelian",
"rurban", "ruselan", "rusquinian", "russ",
"russan", "russelian", "russellian", "russian",
"rustican", "rutilian", "saadian", "saarian",
"sabacian", "s"+u"\u00E1"+"ban", "sabatarian", "sabatian",
"sabean", "sabelian", "s"+u"\u00E1"+"bi", "sabin",
"sabinan", "sabinian", "sabinopolitan", "saboian",
"sac", "sacassan", "sacoman", "sacr",
"sacramentan", "sacran", "sacr"+u"\u00ED"+"leg", "sacrococcigian",
"sacroprofan", "sacrorraquian", "sacrorraquidian", "sacrossant",
"sacrotrocanterian", "saelian", "saferian", "sagitarian",
"sahelian", "saian", "salacian", "salapitan",
"salernitan", "salesian", "salesopolitan", "salgadeir",
"saliferian", "salinopolitan", "salman", "salonitan",
"salpesan", "salpingian", "salsetan", "saltimbanc", "salvaterrian",
"salvatorian", "salveterran", "samanian", "samaritan",
"sambaetiban", "sambaquian", "samian", "samoan",
"samoran", "samosatian", "sampsean", "sanchesian",
"sandemanian", "sanfranciscan", "sanoisian", "sansimonian",
"sant", "santanopolitan", "santonian", "santopolitan",
"santorian", "santorinian", "sap", "sarafan",
"sarago"+u"\u00E7"+"an", "sarapuian", "sarcocarpian", "sarcofagian",
"sardian", "sarian", "sarmacian", "sartrian",
"satanian", "saticulan", "satrican", "saturnian",
"saumurian", "saurisquian", "saussurian", "saxonian",
"schillerian", "schlegelian", "schoenbergian",
"schopenhauerian", "schubertian", "scottian", "seabranan",
"sebastianopolitan", "sebusian", "sec", "secan",
"secret", "secundan", "secundian", "sedetan",
"segarelian", "segestan", "segovian",
"segur", "sel", "selepitan", "seleucian",
"selimbrian", "semelitan", "sementeir", "semiprofan",
"semisserran", "semisshakespearian", "semissoberan", "senegalian",
"senegambian", "senhori", "senonian", "septempedan",
"sept"+u"\u00ED"+"man", "sequacian", "s"+u"\u00E9"+"quan", "sequanian",
"sequardian", "serapidian", "seren", "sergipan",
"seringueir", "sernancelhan", "serran", "serranopolitan",
"serravalian", "sertanej", "sertanopolitan", "sertolian",
"sertorian", "serv", "servian", "sesquiplan",
"setabitan", "setempedan", "setian", "setican",
"s"+u"\u00E9"+"tim", "set"+u"\u00ED"+"man", "sevatian", "sever",
"severian", "sevilhan", "sext", "sextadeciman",
"shakespearian", "siablesian", "siagitan", "sibaritan",
"siberian", "sican", "sicelitan", "sicilian",
"sicran", "sideromelan", "siderom"+u"\u00E9"+"lan", "sideropolitan",
"sidonian", "siegenian", "sifilid"+u"\u00F4"+"man", "sifil"+u"\u00ED"+"man",
"sifil"+u"\u00F4"+"man", "sifonian", "sigl"+u"\u00F4"+"man", "siguitan",
"s"+u"\u00ED"+"lab", "silan", "silbian", "silesian",
"silican", "silicobutan", "silicoetan", "silicometan",
"silicopentan", "silicopropan", "siloxan", "silurian",
"silvan", "silvian", "silvianopolitan", "simedian",
"simelian", "simian", "simonian", "simonsenian",
"simplician", "sincefalian", "sincer", "sincranian",
"sinemurian", "s"+u"\u00ED"+"nfan", "sinfisian", "singel",
"sinian", "sinistr", "sinistr"+u"\u00F4"+"man", "sinocarotidian",
"siracusan", "sirenian", "sis", "siscian",
"sissomian", "sisud", "sitian", "siti"+u"\u00F4"+"man",
"smithian", "smithsonian", "soberan", "sobrean",
"sobredit", "sobreir", "sobressan", "s"+u"\u00F3"+"bri",
"s"+u"\u00F3"+"ci", "socinian", "socioamerican", "sofoclian",
"sof"+u"\u00F4"+"man", "sogaban", "sogdian", "sogr",
"solan", "solarian", "sold",
"soletan", "solt", "solteir", "somalian",
"son"+u"\u00E2"+"mbul", "sonor", "sons", "sopeir",
"soran", "s"+u"\u00F3"+"rdid", "sorelian", "sorian",
"sorocaban", "sorraian", "sortud", "sorveteir",
"sosan", "sosian", "soteropolitan", "soturn",
"sousean", "sousian", "sovcozian", "spencerian",
"spenglerian", "spinozian", "stahlian", "stancarian",
"stendhalian", "stenonian", "sternian", "straussian",
"strindbergian", "suan", "suarezian", "suasan",
"subacetan", "subcoracodian", "suberan", "subertan",
"s"+u"\u00FA"+"bit", "sublapsarian", "subpericranian", "subsaharian",
"subsignan", "substitut", "subuman", "suburitan",
"suculent", "sudertan", "suec", "suelitan",
"suessan", "suessetan", "suessonian", "suessulan",
"sufetulan", "sufolquian", "su"+u"\u00ED"+u"\u00E7", "suicid"+u"\u00F4"+"man",
"suj", "sujeit", "sulan", "sulcitan",
"sulfatarian", "sulfonetilmetan", "sumatriptan", "sumenian",
"sumerian", "supost", "supramundan", "surd",
"surian", "surpres", "susan", "susanopolitan",
"suseran", "susian", "suspeit", "tabac"+u"\u00F4"+"man",
"taban", "tabatingan", "tabelian", "taberneir",
"tabordian", "tacian", "t"+u"\u00E1"+"cit", "tafian",
"tagan", "tagorian", "tainian", "tairetan",
"taitian", "talaveran", "talh", "talip"+u"\u00F4"+"man",
"tamacan", "tamanh", "tamarineir", "tamian",
"tamp", "tanat"+u"\u00F4"+"man", "tanetan", "tang",
"t"+u"\u00E2"+"ngan", "tangitan", "tanzanian", "tapetorretinian",
"tapiocan", "tapiratiban", "taproban", "tapsitan",
"taquarituban", "tardenosian", "tarituban", "tarsian",
"tarsofalangian", "tarsometatarsian", "tartessian", "tarvisan",
"tasian", "tasmanian", "tatuian", "taubatean",
"taunusian", "taurian", "taurisan", "tauromiritan",
"tavastian", "taxaspidian", "taylorian", "tchacavian",
"tchadian", "tean", "teban", "tebasan", "t"+u"\u00E9"+"cnic",
"tege"+u"\u00F3"+"cran", "tejan", "telemetacarpian", "telian",
"telurian", "temesan", "temnospondilian", "temperadinh",
"tenitan", "teodosian", "te"+u"\u00F4"+"man", "ter"+u"\u00E7",
"terceir", "terencian", "teresian", "teresopolitan",
"tergilan", "termidorian", "termopolitan", "tern",
"tertulian", "tesour", "tessalian", "testeir",
"testemunh", "tet", "tetraboran", "tetrabromoetan",
"tetracloralcan", "tetracloretan", "tetraclorometan", "tetracontan",
"tetracosan", "tetradecan", "tetraetilplumban", "tetrafenilfuran",
"tetraidrofuran", "tetraidropiran", "tetraiodoetan", "tetrametilometan",
"tetrametilosilan", "tetranitrometan", "tetrassilan", "teut"+u"\u00F4"+"man",
"teverian", "texan", "texian", "ti",
"tian", "tibaran", "tiberian", "tibetan",
"tibiocalcanean", "tibiotarsian", "tiburcian", "tietean",
"tijucan", "tilestonian", "timboteuan", "timbrian",
"timelician", "timicitan", "tin", "tindaritan",
"tingitan", "tint", "tintureir", "tiofan",
"tiofuran", "tiran", "tiran"+u"\u00F4"+"man", "tireoidian",
"tiroidian", "tirolean", "tironian", "tirrenian",
"t"+u"\u00ED"+"san", "tisdritan", "titan", "titi",
"titil"+u"\u00F4"+"man", "titonian", "tlandrian", "toan",
"toarcian", "tobaguian", "tobian",
"tocantinopolitan", "tocarian", "tol",
"tolan", "told", "toledan", "tolentinian",
"toletan", "tolosan", "tolstoian", "tom"+u"\u00F4"+"man",
"tomosvarian", "tongan", "tongrian", "tont",
"torcularian", "torguian", "torment", "torneir",
"torrean", "torrejan", "torrian", "tort",
"tortonian", "tosc", "toscan", "totan",
"tra"+u"\u00E7", "tractarian", "traducian", "tragan",
"tragian", "traianapolitan", "trai"+u"\u00E7"+"oeir", "tralian",
"tramontan", "tramp", "tranc", "trancosan",
"tranqueir", "tranquil", "transamerican", "transarian",
"transbaicalian", "transbrasilian", "transcranian", "transerran",
"transfretan", "transiberian", "transilvan", "transilvanian",
"transjuran", "transleitan", "transmundan", "transpadan",
"transtigritan", "transuranian", "transvaalian", "transvalian",
"trapezometacarpian", "traquean", "traquelian", "traqueoesofagian",
"traseir", "trasmontan", "trasserran", "trastagan",
"travess", "travesseir", "treban", "trebian",
"trebulan", "trecorian", "tr"+u"\u00EA"+"feg", "tremend",
"tr"+u"\u00EA"+"mul", "trentonian", "trepadeir", "tr"+u"\u00E9"+"pan",
"trespan", "trev", "trevisan", "triacontan",
"trian", "tribrometan", "tribromoetan", "tribromometan",
"tribromopropan", "tribun", "trican", "tricloroetan",
"triclorometan", "tricloronitrometan", "tricloropropan", "tric"+u"\u00F4"+"man",
"tricordian", "tricosan", "tricotonan", "tricuspidian",
"tridecan", "triduan", "tr"+u"\u00ED"+"fan", "trifenilalquilidenofosforan",
"trifenilmetan", "trifluorometan", "trigueir", "trilh",
"trimarian", "trimetafan", "trimetilmetan", "trinc",
"trinitarian", "trinitrometan", "trioctubrian", "trioxan",
"triplan", "tripolitan", "triptofan", "tript"+u"\u00F3"+"fan",
"trisormian", "trissilan", "trist"+u"\u00ED"+"man", "tritetracontan",
"tritonian", "triunfan", "tro"+u"\u00E7"+"ad", "trocan",
"trocanterian", "trocantinian", "troian", "tromboxan",
"trom"+u"\u00F4"+"man", "tropan", "troquinian", "troquiscan",
"troquiterian", "trunf", "tub", "tubian",
"tucitan", "tucuman", "tufican", "tujan",
"tulian", "tunapolitan", "tunetan", "tungomelan",
"tunisian", "tupian", "turanian", "turb",
"turbulent", "turcoman", "turdetan", "turduletan",
"turingian", "turnesian", "turonian", "turquestan",
"turv", "tuscan", "tusculan", "tuvaluan",
"tzigan", "uadaian", "ubanguian", "ubatuban",
"ucecian", "ucranian", "uf"+u"\u00F4"+"man", "ugrian",
"ulan", "ulfilan", "ulissiponian", "ulsterian", u"\u00FA"+"ltim",
"ultrarrepublican", "umbilican", "umbrian", "umbr"+u"\u00ED"+"man",
"umbr"+u"\u00F4"+"man", "umerolecranian", "umeroolecranian", "unamunian",
"undecan", "und"+u"\u00E9"+"cim", "undeciman", "undecuman",
"undevicesiman", u"\u00FA"+"nic", "un"+u"\u00ED"+"man", "uquedan",
"uralian", "uran"+u"\u00F3"+"fan", "urartuan", "urban", "urs",
"ursinh", "uruguaian", "usalitan", "usidican",
"usineir", "usuan", "uter"+u"\u00F4"+"man", "uterovarian",
"uxian", "uxorian", "uzalitan", "vacan",
"vacarian", "vacean", "vadi",
"vagabund", "valangian", "valanginian", "valencian",
"valentin", "valentinian", "valerian", "valesian",
"valinginian", "valisoletan", "valombrosian", "valquirian",
"valsorcian", "valtonian", "valverdian", "vampir",
"vandean", "varan", "varangian", "varatojan",
"varcian", "varejeir", "vargian", "variscan",
"variscanian", "varronian", "varsovian", "varuan",
"varzean", "varzian", "vasc", "vassal",
"vast", "vatelian", "vaterian", "vaterladian",
"vatican", "vauclusian", "vazi", "vealdian",
"vegetalian", "vegetalin", "vegetarian", "veientan",
"vejentan", "velazquian", "velh", "velhac",
"veloc"+u"\u00ED"+"man", "vemelian", "venafran", "vendean",
"venecian", "venerand", "venetulan", "venezian",
"venezolan", "venezuelan", "venloquian", "vent",
"ventaneir", "venusian", "veragran", "veranopolitan",
"verb"+u"\u00F4"+"man", "verdadeir", "verdian", "vergestan",
"vergilian", "verlainian", "vermelh", "vermelhinh",
"vermian", "vermidian", "verneian", "verrocchian",
"verulan", "verumontan", "vesalian", "vesan",
"vescelan", "vesgueir", "vespian", "vespuccian",
"vespucian", "vestinian", "vesulian", "vesuvian",
"veteran", "vianopolitan", "vibrionian", "vicencian",
"vicentopolitan", "vidian", "vieirian", "vietnamian",
"vigilancian", "vila"+u"\u00E7"+"oran", "vilanovian", "vilpian",
"vincian", "vind", "vindian", "vindobonian",
"violeir", "violent", "virchovian", "virgilian",
"virginian", "virginopolitan", "virglorian", "virgulian",
"virsungian", "virtonian", "visaian", "visanian",
"visean", "vistulian", "vitamin"+u"\u00F4"+"man", "vitelian",
"vitian", "vitizan", "vitorian", "vitorin",
"v"+u"\u00ED"+"tre", "vi"+u"\u00FA"+"v", "viventan", "vivian",
"vizinh", "volan", "volapuc"+u"\u00F4"+"man", "volapuquian",
"volaterran", "volcentan", "volgian", "volscian",
"voltairian", "vomerian", "voprinian", "vormian",
"voss", "vulcanian", "vulfilan", "vulfilian",
"vulpian", "wagnerian", "washingtonian", "weberian",
"wildian", "xabregan", "xantitan", "xifoidian",
"xinguan", "zabian", "zairian", "zambian",
"zamoran", "z"+u"\u00E2"+"ngan", "zeugitan", "zimbabuan",
"zombeteir", "zoroastrian", "zorr", "zuinglian",
"zwinglian"])

# plInvavb -  - substantivos de dois generos tambem encontrados em conjugacoes verbais.
plInvavb = set(["recruta", "reserva"])

# plvrInva - palavras de dois generos terminadas em -a- 
plvrInva = set(["acrobata", "ala", "alfa", "aristocrata", "artista",
"atalaia", "atleta", "autarca", "autocrata", "bacana", "banana", "bandeirinha", "belga",
"besta", "beta", "burocrata", "cabe"+u"\u00E7"+"a", "cabra",
"cabrinha", "ca"+u"\u00E7"+"a", "caixa", "camarada", "canalha", "capixaba",
"cara", "careca", "carioca", "carinha", "carmelita", "cestinha", "cineasta", "cinza", "cisma", "colega",
"crista", "democrata", "desavergonhada", "d"+u"\u00E9"+"spota",
"digna", "diplomata", "dourada", "extra",
"faixa", "fantasma", "ginasta", "gorila", "grama",
"grama", "guarda", "hip"+u"\u00F3"+"crita",
"idiota",  "id"+u"\u00F3"+"latra",
"impala", "ind"+u"\u00ED"+"gena", "infanticida", "israelita", "japona", "java",
"jeca", "judoca", "laranja", "laranja",
"lhama", "longa", "magnata", "maia",
"maiorca", "maneta", "meia", "metropolita",
"monarca", "musicoterapeuta", "obstetra", "oligarca",
"ordenan"+u"\u00E7"+"a", "papa", "palerma", "paquera", "para"+u"\u00ED"+"ba",
"parasita", "parasita", "pateta", "patola",
"patriota", "pediatra", "penetra", "peralta",
"perneta", "picareta", "pilantra",
"pindoba", "pirata", "plutocrata", "poliglota",
"ponta", "porra", "porta", "prata", "primata",
"psicopata", "psiquiatra", "quilombola", "r"+u"\u00E1"+"bula",
"sacana", "salvaguarda", "salvaterra", "sanguessuga", "santista",
"sarcasta", "seguran"+u"\u00E7"+"a", "sentinela",
"sentinela", "silv"+u"\u00ED"+"cola", "s"+u"\u00F3"+"sia", "sovina",
"suicida", "sulamita", "suprema",
"tagarela", "tanta", "taramela", "tecnocrata",
"terapeuta", "terapeuta", "triatleta", "troglodita",
"trouxa", "ultravioleta", "vigia", "violeta"])


# plvrMfr - palavras de dois generos terminadas em -r- 
plvrMfr = set(["agricolar", "agroalimentar", "algar", "anterior", "antirradar",
"antissolar", "arquissecular", "arquivulgar", "atriovascular",
"atrioventricular", "auricular", "auriculoventricular", "autossimilar",
"auxiliar", "axilar", "bacelar", "bicolor", "biliar", "bilinear",
"bipolar", "bissecular", "capilar", "capitular", "cardiopulmonar",
"cardiovascular", "cavalar", "caviar", "cedular",
"cefaloauricular", "celular", "chanceler", "chofer", "circular", "col"+u"\u00ED"+"der",
"complementar", "consular", "curricular", "designer", "dipolar", "disciplinar",
"discipular", "diverticular", "elementar", "epistolar", "escolar",
"espetacular", "estelar", "exemplar", "extracurricular", "exterior",
"familiar", "halter", u"\u00ED"+"mpar", "incolor", "inferior", "interior", "irregular",
"l"+u"\u00ED"+"der", "lunar", "maior", "Major", "major", "malmequer",
"m"+u"\u00E1"+"rtir", "medular", "melhor", "menor", "milhar",
"militar", "Mor", "mor", "muladar", "multicapsular",
"multicarpelar", "multidisciplinar", "multifamiliar", "multifilar",
"multilinear", "multilobular", "multilocular", "multimilenar",
"multinodular", "multinucelar", "multinuclear", "multiocular",
"muscular","nuclear", "ocular", "par", "paramilitar", "parlamentar",
"particular", "pelicular", "peninsular", "perpendicular", "pior", "polar",
"pomar", "popular", "posterior", "preliminar", "prostibular",
"protocolar","protossolar", "pulmonar", "quadrangular", "quatrissecular",
"regular", "rep"+u"\u00F3"+"rter", "retangular", "reticular",
"retilinear", "salutar", "secular", "semiangular",
"semianular", "semicircular", "semipopular", "semirregular",
"semissecular", "similar", "singular", "solar",
"subcircular", "subintervalar", "subliminar", "submandibular",
"superior", "testicular", "titular",
"transcelular", "transecular", "tricolor", "tripolar", "trissecular",
"tubercular", "tubular", "tutelar", "ultrassolar",
"uniangular", "unianular", "uniarticular", "unicapsular",
"unicarpelar", "unicelular", "uniciliar", "unifamiliar",
"unifilar", "uniglandular", "unilaminar", "unilinear",
"unilobar", "unilobular", "unimolecular", "unimuscular",
"uninuclear", "uninucleolar", "uniocular", "uniovular",
"unipolar", "unitegumentar", "univalvular", "univesicular",
"univocabular", "urceolar", "uterolombar", "utricular",
"uvular", "vaginovulvar", "valecular", "valspodar",
"valvar", "valvular", "variolar", "vascular",
"ventricular", "verticilar", "vesicular", "vestibular",
"vocabular", "volar", "vulgar", "vulvar",
"zanzibar"])

# plvrFemr - palavras femininas terminadas em -r- 
plvrFemr = set(["colher", "liminar", "mulher", "multimulher",
"supermulher"])

# excPlvrmr - excecoes palavras terminadas em -r- Exemplo: rigor 
excPlvrmr = set(["favor","rigor"])

# plvrMascr - palavras masculinas terminadas em -r- 
plvrMascr = set(["abajur", "a"+u"\u00E7"+"or", "a"+u"\u00E7"+u"\u00FA"+"car", "afazer",
"afric"+u"\u00E2"+"nder", "alamar", "albor", "algar",
"alguidar", "altar", "alter", "alvor",
"amanhecer", "amargor", "amor", "andor",
"ar", "ardor", "ator", "avatar",
"azar", "bar", "bastidor", "bazar",
"bilhar", "biopoder", "bolor", "cad"+u"\u00E1"+"ver",
"calcanhar", "calor", "c"+u"\u00E2"+"ncer", "capacitor",
"capitular", "car"+u"\u00E1"+"cter", "car"+u"\u00E1"+"ter", "castor",
"casuar", "cateter", "celular", "c"+u"\u00E9"+"sar",
"clamor", "clangor", "cobertor",
"cocar", "colar", "cont"+u"\u00EA"+"iner", "contrapoder",
"cultor", "czar", "desamor",
"despertar", "desprazer", "dissabor", "d"+u"\u00F3"+"lar",
"emir", "equador", "esc"+u"\u00E2"+"ner", "esf"+u"\u00ED"+"ncter",
"esgar", "espaldar", "esplendor", "estupor",
"eurod"+u"\u00F3"+"lar", "familiar", "faquir", "fator",
"favor", "fedor", "f"+u"\u00E9"+"mur", "f"+u"\u00EA"+"mur",
"fervor", "flexor", "fl"+u"\u00FA"+"or", "folar",
"folgar", "fragor", "freezer", "fulgor",
"fulmar", "funicular", "furor", "glaciar",
"hangar", "horror", "hospitalar", "humor",
"insular", "jaguar", "jantar", "labor",
"lagar", "langor", "lar", "lavor",
"lazer", "l"+u"\u00EA"+"mur", "licor", "limiar",
"logar", "louvor", "luar", "lugar",
"luminar", "lupanar", "magiar", "malar",
"manjar", "mar", "m"+u"\u00E1"+"rtir", "maxilar",
"menir", "mester", "microcomputador", "minicomputador",
"mister", "molar", "motor", "monsenhor", "muar",
"n"+u"\u00E9"+"ctar", "nen"+u"\u00FA"+"far", "odor", "olhar",
u"\u00F4"+"mer", u"\u00F3"+"scar", "paladar", "palmar",
"palor", "par", "patamar",
"pavor", "pendor", "pendular", "penhor",
"pilar", "placar", "polegar",
"pomar", "pormenor", "p"+u"\u00F4"+"ster", "prazer",
"primor", "prior", "pudor", "pundonor",
"quasar", "quefazer", "radar", "rancor",
"reator", "rev"+u"\u00F3"+"lver", "rigor", "rubor",
"rumor", "sabor", "setor", "silhar",
"souvenir", "subpoder", "su"+u"\u00E9"+"ter", "suor",
"supercomputador", "superpoder", "superser", "suvenir",
"talher", "tambor", "tear", "teleprompter",
"televisor", "temor", "tenor", "teor",
"terror", "timor", "t"+u"\u00F4"+"ner", "torpor",
"transistor", "transp"+u"\u00F4"+"nder", "trator", "travor",
"tremor", "tu"+u"\u00ED"+"ter", "tumor", "ureter",
"valor", "vapor", "vedor",
"vetiver", "viajor", "vigor", "vizir",
"z"+u"\u00ED"+"per"])

# plvrMfal - palavras masculinas/femininas terminadas em -al- 
plvrMfal = set(["acidenta", "adiciona", "adverbia", "agricultura",
"algodoa", "amara", "ambulatoria", "amia",
"ancestra", "angelica", "anticoncepciona", "antimonia",
"anua", "area", "arena", "argumenta",
"armoria", "aroma", "arquitetura", "astra",
"atona", "atua", "audiovisua", "avena",
"azinha", "bagua", "bambua", "bamburra",
"bana", "barroca", "basa", "bestia", "bica", "Biena", "biena",
"boa", "bo"+u"\u00E7"+"a", "borea", "bra"+u"\u00E7"+"a",
"braga", "braquia", "breja", "bria",
"bruma", "bruta", "buca", "bu"+u"\u00E7"+"a",
"caba", "cadeira", "caga"+u"\u00E7"+"a", "cama",
"camaraza", "caniba", "Capita", "capita",
"carna", "carrasca", "carrega", "casua",
"catarra", "catua", "caucha", "cauda",
"celestia", "cenda", "centea", "centra",
"cerimonia", "cipoa", "circunstancia", "clora",
"colegia", "colonia", "coloquia", "colossa",
"comensa", "comercia", "comportamenta", "conceitua",
"condiciona", "confessiona", "conjuga", "continenta",
"convenciona", "cora", "cordia", "corna",
"corpora", "couva", "cova", "credencia", "crimina",
"crucia", "cua", "cuba", "cultura", "descomuna",
"desigua", "deslea", "diferencia", "digita",
"distrita", "diagona", "ditatoria", "divina", "documenta",
"dominica", "dorsa", "editoria", "emociona",
"empresaria", "erva"+u"\u00E7"+"a", "esparga", "especia",
"espinha", "espiritua", "essencia", "estadua", "estata",
"estenda", "esteva", "etana", "eterna",
"eucalipta", "eventua", "excepciona", "existencia",
"experimenta", "factoria", "faia", "fana",
"fata", "fatoria", "fava", "fecha",
"federa", "fenomena", "fera", "ferragia",
"filia", "fina", "financia", "firma", "fisca",
"flora", "fluvia", "fora", "forma",
"frasca", "frecha", "freixia", "fronta",
"fruga", "funcha", "fundamenta", "gaia",
"gavia", "genia", "genita", "gera",
"gestua", "glioxa", "globa", "graa",
"gradua", "grama", "gramatica", "gutura", "habitua",
"hexagona", "hipertextua", "historia", "homossexua",
"horizonta", "idea", "igua", "ilega",
"imateria", "imora", "imorta", "imparcia",
"imperia", "impessoa", "inaugura", "incidenta", "individua",
"industria", "inferna", "informa", "inicia",
"instrumenta", "integra", "intelectua", "intempora",
"intenciona", "internaciona", "interna", "irraciona",
"irrea", "jovia", "judicia", "juvena",
"latera", "lea", "lega", "lexica", "libera",
"liga", "litera", "loca", "loda"+u"\u00E7"+"a", "logica",
"lustra", "macambira", "macega", "madriga", "magistra",
"maiora", "manua", "marcia", "margina", "marita",
"mataga", "materna", "materia", "matina", "matorra",
"matricia", "medica", "medieva", "medronha", "mensa",
"menstrua", "menta", "mercuria", "meridiona", "mesca",
"metana", "milha", "minera", "missa",
"mistra", "moira", "monumenta", "mora",
"morta", "mundia", "municipa", "mura", "multinaciona",
"musica", "naciona", "nata", "natura",
"neanderta", "neolibera", "nepa", "nomina",
"norma", "numera", "nupcia", "occipita",
"ocidenta", "oficia", "ogiva", "oliva", "orienta",
"ora", "orbita", "origina", "ova", "oven"+u"\u00E7"+"a", "pacova",
"pactua", "pasti"+u"\u00E7"+"a", "pastora", "paterna", "patriarca",
"peda", "pedesta", "peitora", "pentagona",
"pentobarbita", "pessoa", "pinha", "plura",
"poia", "policia", "pontua", "porcentua",
"porta", "posta", "potencia", "prejudicia", "presidencia",
"primordia", "principa", "profissiona", "proporciona",
"proven"+u"\u00E7"+"a", "proverbia", "providencia", "provincia",
"provisiona", "qua", "raciona", "radica",
"rea", "recita", "referencia", "rega",
"regiona", "representaciona", "residencia", "reviva",
"ria", "ritua", "riva", "rosa",
"roseira", "rotaciona", "rura", "sabuga",
"sacramenta", "sapa", "sar"+u"\u00E7"+"a", "sarrafa"+u"\u00E7"+"a",
"saturna", "semana", "semestra", "semifina", "senda",
"senega", "sensaciona", "sensua", "sentimenta",
"sercia", "seria", "seringa", "servi"+u"\u00E7"+"a",
"sexua", "sia", "sidera", "sindica",
"sisa", "situaciona", "sobrenatura", "socia",
"substancia", "sucursa", "superpolicia", "supraespinha",
"surrea", "taboca", "taipa", "ta", "teatra",
"temperamenta", "tempora", "tenda", "termina",
"terra", "tetragona", "tiopenta", "torrencia",
"tota", "tradiciona", "tramaga", "transnaciona", "transexua",
"transversa", "tremeda", "triba", "triga",
"trigona", "triunfa", "trivia", "tropica",
"tutoria", "umbra", "universa", "ura",
"urgueira", "urogenita", "usua", "va",
"vegeta", "vena", "verba", "verdea",
"vertica", "virgina", "virtua", "viscera",
"visua", "vita", "vitra", "voca", "voga",
"vorta"])

# plvrMascal - palavras masculinas terminadas em -al- 
plvrMascal = set(["anima", "arraia", "arroza", "arsena",
"ava", "aventa", "banana", "beira",
"boca", "borna", "cabeda", "cacaua",
"cadava", "cafeza", "cajueira", "camba",
"cana", "canavia", "candea", "capinza",
"carda", "cardea", "cardia", "Carnava",
"carnava", "carvalha", "casa", "castanha",
"casti"+u"\u00E7"+"a", "cerea", "cereja", "chaca",
"chaparra", "chavasca", "choupa", "colmea",
"coqueira", "crista", "curra", "deda",
"Edita", "edita", "enxova", "escoria",
"feijoa", "fenobarbita", "festiva", "feuda",
"figueira", "funera", "genera", "hospita", "Hospita",
"jogra", "jorna", "lama"+u"\u00E7"+"a", "laranja",
"litora", "loca", "manancia", "manantia",
"manca", "mandioca", "mangua", "mangueza",
"marecha", "materia", "memoria",
"meta", "milhara", "milheira", "palha",
"palmita", "pana", "pantana", "parda",
"parieta", "pascoa", "percentua", "pinheira",
"pomba", "ponta", "pontifica", "punha",
"quinta", "raba"+u"\u00E7"+"a", "rama", "sa",
"salgueira", "seixa", "sina", "sobra", "subtota", "telejorna",
"Tribuna", "tribuna", "vara", "vendava"])

# excPlvral - excecoes palavras terminadas em -ais- Exemplo: cais, demais, jamais, mais 
excPlvral = set(["c", "dem", "jam", "m"])


# plvrMascel - palavras masculinas terminadas em -el- 
plvrMascel = set(["bachar", "broqu", "bur", "capit", "carret",
"carross", "cart", "cinz", "coquet",
"corc", "cord", "coron", "coud",
"decib", "dies", "donz",
"doss", "espinh", "farn", "f",
"fun", "furri", "g", "hidrom",
"hot", "lamb", "laur", "man",
"manu", "m", "menestr", "migu",
"moscat", "mot", "neb", "ourop",
"pain", "pap", "parc", "past",
"penafi", "pich", "pinc", "pinh",
"pix", "plant", "quart", "rap",
"rang", "redond", "rodoan", "saquit",
"sarapat", "ton", "trop", "verg",
"xair", "xar"])

# plvrAmascel - palavras Acentuadas masculinas terminadas em -el- 
plvrAmascel = set(["arr"+u"\u00E1"+"te", "b"+u"\u00E9"+"te", "corom"+u"\u00E2"+"nde",
"cromon"+u"\u00ED"+"que", "c"+u"\u00FA"+"me", "cupron"+u"\u00ED"+"que",
"d"+u"\u00ED"+"se", "esn"+u"\u00F3"+"rque", "f"+u"\u00E1"+"rte", "ferron"+u"\u00ED"+"que",
"f"+u"\u00FA"+"se", "galvanon"+u"\u00ED"+"que", "gu"+u"\u00ED"+"me", "l"+u"\u00ED"+"nge",
"misp"+u"\u00ED"+"que", "r"+u"\u00ED"+"ge", "r"+u"\u00ED"+"me", "rod"+u"\u00F4"+"me",
"sa"+u"\u00ED"+"me", "s"+u"\u00ED"+"me", "t"+u"\u00FA"+"ne"])

# excPlvrel - excecoes palavras terminadas em -eis- Exemplo: anegalheis, reis (com acenteo no e) 
excPlvrel = set(["anegalh", "el", "fart", "r"])


# plvrMfel - palavras de dois generos terminadas em -el- 
plvrMfel = set(["cru", "fi", "infi", "isab", "isra", "nob", "no"])


# plvrFemel - palavras femininas terminadas em -el- 
plvrFemel = set(["cascav"])

# excplMascu - excecao preposicao A - palavras masculinas terminadas em -u- - Ex.: A meu, A seu, A teu
excplMascu = set(["me", "se", "te"])

# plvrMascu - palavras masculinas terminadas em -u- 
plvrMascu = set(["abane", "abante", "abapor", "ab",
"acap", "acar", "aceste", "ac",
"aganipe", "agele", "agre", "ain",
"alifire", "alise", "amade", "amate",
"amebe", "amicle", "amorre", "anamburuc",
"anance", "ance", "androce", "ang",
"Ante", "antisse", "an", "apame",
"apoge", "aque", "aquile", "aracnoide",
"arame", "ara", "ardie", "arinfe",
"Ariste", "aritenoide", "armoze", "arque",
"arvade", "asaque", "asclepiade", "ascre",
"asdode", "asmode", "asmone", "asquelone",
"asside", "atamante", "atene", "ate",
"atiade", "atiroide", "at", "aule",
"baba"+u"\u00E7", "baba", "bab", "bacalha",
"bacura", "bacurub", "bagua"+u"\u00E7", "baiac",
"bail"+u"\u00E9", "baj", "balandra", "bali",
"bamb", "bang", "barce", "barde",
"bartolome", "bar", "barzab", "Basile",
"ba", "baur", "beij", "bela",
"belel"+u"\u00E9", "belope", "berimba", "betsile",
"b"+u"\u00E9", "bij", "bisna", "biz",
"bla", "boigua"+u"\u00E7", "bol"+u"\u00E9", "Borrome",
"botar"+u"\u00E9", "botie", "brace", "braquicore",
"bresla", "bre", "briare", "briar"+u"\u00E9",
"bronte", "br", "bub", "burea",
"bur", "caagua"+u"\u00E7", "cabu"+u"\u00E7", "cacar"+u"\u00E9",
"caca", "cadme", "cadmone", "caduce",
"caduve", "cafarne", "cafu"+u"\u00E7", "cagua"+u"\u00E7",
"caitit", "caj", "cajur", "cala",
"calde", "calha", "cal", "camafe",
"camar", "camba", "canaane", "canane",
"cancle", "cande", "candir", "cangu"+u"\u00E7",
"cangur", "canoide", "canope", "carac",
"caramur", "carapa", "carapic", "carib",
"carne", "car", "caruar", "carur",
"cassiope", "catagua"+u"\u00E7", "catarre", "catata",
"catech", "cauch", "ceratoioide", "c"+u"\u00E9",
"chab"+u"\u00E9", "chande", "chap"+u"\u00E9", "char"+u"\u00E9",
"charte", "cha", "chibe", "chichisb"+u"\u00E9",
"chim", "chir", "ch", "chuch",
"churre", "ciadopitioide", "cifioide", "cilace",
"cilene", "cile", "circe", "cirene",
"Cirine", "cirsoide", "citere", "cite",
"citofaringe", "cla", "clidocoracoide", "clidomastoide",
"codie", "coip", "colipe", "colise",
"colone", "colora", "conope", "corcire",
"core", "corife", "coroide", "corone",
"coronoide", "cor", "coruch"+u"\u00E9", "cossie",
"costocoracoide", "costocoracoroide", "costoxifoide", "cotiloide",
"crajur", "cretche", "cricaritenoide", "cricoaritenoide",
"cricoide", "cricotireoide", "cricotiroide", "criptojude",
"cr", "c", "cuc", "culde",
"cunauar", "cupua"+u"\u00E7", "cura"+u"\u00E7"+"a", "cura",
"curur", "curuz", "dacriope", "degra",
"dia", "ec", "embiru"+u"\u00E7", "em",
"enx", "eorde", "epicure", "epidafne",
"epidaure", "epige", "epistrofe", "eque",
"erimante", "erine", "erite", "eritre",
"eritrofle", "er", "escarabe", "escarc"+u"\u00E9",
"esminte", "esmirne", "espale", "espele",
"espermatope", "esponde", "estilioide", "estiloide",
"estomode", "estratonice", "estubere", "ete",
"etope", "eube", "euripide", "europe",
"eve", "faetonte", "falane", "falante",
"falasarne", "fane", "fare", "farise",
"farrumpe", "febe", "feloide", "fere",
"fereze", "fich", "filace", "filiste",
"filobasile", "firmide", "flie", "floresce",
"foce", "fogar"+u"\u00E9", "frise", "frixe",
"gabir", "gaib"+u"\u00E9", "galile", "gate",
"ga", "gaze", "gebade", "gergese",
"gete", "gigante", "gimnobelide", "ginece",
"gire", "girgase", "girre", "gite",
"glenoide", "gogiare", "goiam", "gomorre",
"gordie", "grabe", "grage", "gra",
"gregue", "gris"+u"\u00E9", "gris", "guabir",
"guaicur", "guarib", "guatamb", "gua",
"guigrateute", "gur", "hamate", "hamire",
"hebre", "hecate", "hecatombe", "hemoperitone",
"heracle", "heraclite", "herie", "herme",
"hermione", "hesiode", "hete", "he",
"heve", "hialoide", "hible", "hierope",
"hilocere", "himene", "hioide", "hiotiroide",
"hipate", "hipofle", "hipoge", "hore",
"hut", "iatre", "ic", "idume",
"igara"+u"\u00E7", "igua"+u"\u00E7", "ilh"+u"\u00E9", "il",
"imb", "imp", "inamb", "incr"+u"\u00E9",
"ingranz"+u"\u00E9", "inhamb", "iola", "iridocoroide",
"isse", "ita", "itone", "iture",
"jabir", "jabur", "jacobe", "jac",
"jacurut", "jaguaru"+u"\u00E7", "jamb", "jap",
"ja", "jaze", "jebuse", "jenisse",
"jes", "jinze", "jira", "jube",
"jubile", "jude", "juj", "jungi",
"jurur", "justiniane", "lab"+u"\u00E9", "lacra",
"lala", "lamb", "landa", "landr",
"lapite", "lara", "larisse", "lebr"+u"\u00E9",
"lene", "lepidoste", "lerne", "lete",
"l"+u"\u00E9", "lice", "licre", "lige",
"liofloe", "lipare", "lorditome",
"lua", "lul", "lumar"+u"\u00E9", "macabe",
"macac", "macar"+u"\u00E9", "maca", "mac",
"madiane", "majaque", "maj", "malacoste",
"mal", "mana", "manch", "mandacar",
"mande", "mang", "manib",
"manique", "mani", "mant"+u"\u00E9", "man",
"manumiti", "marab", "maracat", "mara",
"marimba", "marip", "marone", "maruce",
"masde", "mase", "masore", "massile",
"mastar"+u"\u00E9", "mastoide", "matate", "mat",
"ma", "mausol"+u"\u00E9", "maze", "meduse",
"melibe", "melite", "menandre", "mene",
"menipe", "men", "mesenquitre", "mesofle",
"metimne", "me", "meze", "mia",
"micene", "mide", "miiofone", "milase",
"mile", "milhare", "milhere", "milhe",
"milre", "mindana", "mine", "minga",
"ming", "mitilene", "mitre", "mit",
"mize", "mocama", "molung", "monte",
"mor", "m", "muie", "mule",
"mulung", "mund"+u"\u00E9", "munduruc", "mung",
"murna", "mur", "murucutut", "murur",
"muse", "mutusce", "nabate", "nadaba",
"nal", "namb", "nape", "nasore",
"natabe", "natine", "naumaque", "nazare",
"nazire", "nazore", "nda", "nemee",
"neme", "nese", "nhamb", "nicola",
"ninfe", "nise", "n", "nube",
"odontoide", "omb", "omoioide", "omumbe",
"ore", "orse", "otrione", "ot",
"oxe", "ozue", "pacat", "paca",
"pac", "pade", "page", "palene",
"panac", "panage", "pange", "panque",
"pante", "panticape", "papanicola", "pap",
"paquifle", "parafle", "paragua"+u"\u00E7", "parale",
"parda", "parore", "partenope", "par",
"patare", "pata", "pa", "peg",
"pelebre", "pelene", "pele", "pelope",
"pelorne", "pera", "pergame", "perge",
"peridere", "perige", "perine", "peritone",
"perize", "perone", "Perse", "per",
"petre", "peucale", "peucane", "pia",
"pidne", "pige", "pigme", "pimple",
"pin"+u"\u00E9", "pint"+u"\u00E9", "piracat", "piramb",
"piraruc", "pirene", "pire", "pise",
"pissele", "pitane", "pit"+u"\u00E9", "pit",
"pitua"+u"\u00E7", "platea", "plebe", "plesiopene",
"pne", "pneumoperitone", "policne", "polidesmoide",
"Pompe", "pontine", "porne", "pot",
"povar"+u"\u00E9", "povil"+u"\u00E9", "povol"+u"\u00E9", "prestiloide",
"priape", "pritane", "procoracoide", "propile",
"proscarabe", "proteocefaloide", "prote", "pr",
"psamoscafe", "pseudofle", "psi", "pterigoide",
"pure", "purupur", "putumuj", "quante",
"quarta", "quatipur", "quene", "queneze",
"quiloperitone", "quina", "quincaj", "quinguing",
"quixexe", "radame", "ragoide", "raguse",
"rame", "ra", "reb", "recr",
"retroestiloide", "retromastoide", "r"+u"\u00E9", "rife",
"ripe", "rodope", "rome", "sabe",
"saduce", "sag", "sal", "same",
"sande", "sanha"+u"\u00E7", "sapule", "saquit"+u"\u00E9",
"sara", "sasse", "satarque", "semin",
"sens", "septogle", "serape", "sesamoide",
"se", "sicurij", "sige", "sigmoide",
"siloge", "sine", "sinimb", "sit",
"sobe", "sobrec"+u"\u00E9", "sobrec", "sola",
"solid"+u"\u00E9", "sotade", "sov"+u"\u00E9", "subatloide",
"subaxoide", "sucurij", "sucuruj", "surucuc",
"surur", "suss", "tabar"+u"\u00E9", "tab",
"tacur", "Tade", "taja"+u"\u00E7", "tange",
"tapir", "tapur", "taquara"+u"\u00E7", "taquaru"+u"\u00E7",
"tata", "tat", "ta", "taumatope",
"tcha", "tebe", "tegee", "terapne",
"tere", "terine", "tespie", "tetartope",
"tet"+u"\u00E9", "te", "tiane", "tife",
"tifoide", "timane", "timb", "timele",
"tinfe", "tip", "tireoide", "tirisse",
"tiroide", "tof", "tol", "tomabe",
"torone", "tor", "tre", "trocoide",
"trof"+u"\u00E9", "trogofle", "troque", "troussea",
"tucana"+u"\u00E7", "tur", "turu"+u"\u00E7", "tut",
"ua", "ub", "ubu"+u"\u00E7", "uira"+u"\u00E7",
"uirapur", "ulisse", "umb", "upene",
"ur", "urub", "uruc", "uruta",
"urut", "uscarde", "vace", "vade",
"vagana", "varapa", "varde", "vasse",
"va", "v"+u"\u00E9", "vile", "vit",
"xamp", "xelel"+u"\u00E9", "xere", "xex"+u"\u00E9",
"xilre", "zaibats", "zancle", "za",
"zemare"])



# plvrMfeu - palavras de dois generos terminadas em -u- 
plvrMfeu = set(["amad", "bid", "calund", "coand", "cuand", "cud", "hind",
"land", "lund", "mandch", "mand", "murund", "nand", "nhand", "urd",
"vod", "vud", "zeb", "zul"])


# plvrFemu - palavras femininas terminadas em -u- 
plvrFemu = set(["bant", "na"])


# plvrMasci - palavras masculinas terminadas em -i-
plvrMasci = set(["abacax", "bacur", "b"+u"\u00E2"+"mb", "berib"+u"\u00E9"+"r", "biqu"+u"\u00ED"+"n", "bir", "biribir", "birigu",
"bistur", "bo", "bonsa", "canic"+u"\u00E2"+"n", "carir", "caxix", "chass", "cob"+u"\u00F3",
"confre", "Dav", "dicur", "ep"+u"\u00F3"+"x", "esqu", "fre", "futev"+u"\u00F4"+"le", "gib",
"guaran", "gur", "her"+u"\u00F3", "h"+u"\u00F3"+"que", "jabut", "jac"+u"\u00FA"+"z", "javal", "j"+u"\u00F3"+"que",
"j"+u"\u00FA"+"r", "jurit", "miss"+u"\u00FA"+"r", "mitir", "muzumb", "oitch", "oit", "pa","papa",
"parat", "p"+u"\u00EA"+"nalt", "pip", "piqu", "pit", "p"+u"\u00F4"+"ne", "pot", "ravi"+u"\u00F3"+"l",
"re", "rub", "sac", "sagu", "samura", "sanse", "sapot", "sir", "sirir",
"tambaqu", "tambur", "t"+u"\u00E1"+"x", "tsunam", "tucup", "v"+u"\u00F4"+"le", "xix"])


# plvrMfei - palavras de dois generos terminadas em -i-
plvrMfei = set(["dod"+u"\u00F3", "faqu", "gar", "ianom"+u"\u00E2"+"m", "naz", "n"+u"\u00E1"+"z", "nisse", "paparazz", "travest", "zumb"])


# plvrFemi - palavras femininas terminadas em -i-
plvrFemi = set(["le", "sucur"])



# plvrMfcao - palavras dois generos terminadas em -cao- cedilha til a o 
plvrMfcao = set(["lota"+u"\u00E7"])

# plvrMascao - palavras masculinas terminadas em -cao- cedilha til a o 
plvrMascao = set(["ar"+u"\u00E7", "bal"+u"\u00E7",
"cabe"+u"\u00E7", "cal"+u"\u00E7",
"carro"+u"\u00E7", "Cora"+u"\u00E7",  "cora"+u"\u00E7",
"crian"+u"\u00E7", "escan"+u"\u00E7",
"infan"+u"\u00E7", "ti"+u"\u00E7",
"trope"+u"\u00E7"])

# excPlvrao - palavras terminadas em -ao- cujo plural eh diferente de -oes-, nao tem plural ou admite outras formacoes 
excPlvrao = set(["afeg", "alde", "alem", "amont", "anci", "bang", "bordeg",
"borguinh", "c", "capel", "capit", "catal", "ch", "charlat", "cibercidad", "cidad", "coirm", "concidad",
"concrist", "crist", "de", "engatat", "ent", "escriv", "est", "estrab", "fo"+u"\u00E7", "fugi",
"garnach", "geres", "goz", "gr", "guardi", "h",  "hortel", "ignorant",
"irm", u"\u00F3"+"rf", u"\u00F3"+"rg", u"\u00D5"+"rg", "p", "pag", "pardal", "repont",
"s", "sen", "solim", "t", "tabeli", "tintur", "usucapi", "zombeir", "zorn", "zorr"])

# excPlvrnasce - excecoes palavras masculinas terminadas em -E- Exemplo: convite 
excPlvrnasce = set(["convit", "toqu"])


# plvrNfemcao - palavras nao femininas terminadas em -cao- cedilha til a o 
plvrNfemcao = set(["almo"+u"\u00E7", "ar"+u"\u00E7", "bal"+u"\u00E7",
"cabe"+u"\u00E7", "cadar"+u"\u00E7", "cal"+u"\u00E7",
"carro"+u"\u00E7", "Cora"+u"\u00E7",  "cora"+u"\u00E7",
"crian"+u"\u00E7", "escan"+u"\u00E7",
"infan"+u"\u00E7", "lota"+u"\u00E7",
"peda"+u"\u00E7", "pesco"+u"\u00E7", "ti"+u"\u00E7",
"trope"+u"\u00E7"])

#plvrFemao  - Palavras femininas terminadas em -ao-
plvrFemao = set(["acess", "Acess",
"acupress", "Acupress", "ades", "Ades",
"admiss", "Admiss", "adust", "Adust",
"agress", "Agress", "alus", "Alus",
"amarelid", "Amarelid", "amplid", "Amplid",
"animadvers", "Animadvers", "antevers", "Antevers",
"antevis", "Antevis", "apreens", "Apreens", "aptid", "Aptid",
"ascens", "Ascens", "aspers", "Aspers",
"autogest", "Autogest", "avers", "Avers", "avuls", "Avuls"
"bernard", "Bernard", "bioimpress", "Bioimpress",
"branquid", "Branquid",
"brusquid", "Brusquid", "certid", "Certid",
"cess", "Cess", "circuncis", "Circuncis",
"cis", "Cis", "coaliz", "Coaliz",
"coes", "Coes", "colis", "Colis",
"combust", "Combust", "comich", "Comich",
"comiss", "Comiss", "compaix", "Compaix",
"compreens", "Compreens", "compress", "Compress",
"compuls", "Compuls", "comunh", "Comunh",
"concess", "Concess", "concis", "Concis",
"conclus", "Conclus", "concuss", "Concuss",
"conex", "Conex", "confiss", "Confiss",
"confus", "Confus", "congest", "Congest",
"contram", "contrarraz", "Contrarraz",
"contus", "Contus", "convers", "Convers",
"convex", "Convex", "convuls", "Convuls",
"corras", "Corras",
"corros", "Corros", "cosmovis", "Cosmovis",
"crucifix", "Crucifix", "Cubat", "d",
"D", "decis", "Decis", "defens",
"Defens", "deflex", "Deflex", "dem", "Dem", "demiss", "Demiss",
"densid", "Densid", "depress",
"Depress", "deris", "Deris", "descens",
"Descens", "descompress", "Descompress", "desconex",
"Desconex", "desilus", "Desilus",
"despretens", "Despretens", "desuni",
"Desuni", "devassid",
"Devassid", "difus", "Difus", "digest",
"Digest", "digress", "Digress", "dimens",
"Dimens", "discuss", "Discuss", "dispers",
"Dispers", "dissens", "Dissens", "dissuas",
"Dissuas", "distens", "Distens", "divers",
"Divers", "divis", "Divis",
"eclos", "Eclos", "efus",
"Efus", "egest", "Egest", "electrocuss",
"Electrocuss", "eletrofus", "Eletrofus", "emers",
"Emers", "emiss", "Emiss", "emuls",
"Emuls", "entrevis", "Entrevis", "eros",
"Eros", "escans", "Escans",
"escravid", "Escravid", "escrupulid",
"Escrupulid", "escurid", "Escurid", "espessid",
"Espessid", "evas", "Evas", "Ex-pris",
"exatid", "Exatid", "exaust", "Exaust",
"excis", "Excis", "exclus", "Exclus",
"excomunh", "Excomunh", "excurs", "Excurs",
"expans", "Expans", "explos", "Explos",
"express", "Express", "expuls", "Expuls",
"extens", "Extens", "extors", "Extors",
"extrovers", "Extrovers", "extrus", "Extrus",
"f", "F", "fiss", "Fiss",
"flex", "Flex",
"fotoemiss", "Fotoemiss", "fotofiss", "Fotofiss",
"Fraz", "fresquid",
"Fresquid", "frouxid", "Frouxid", "fus",
"Fus", "gest", "Gest", "gratid",
"Gratid", "hipertens", "Hipertens", "hipotens",
"Hipotens", "ilus", "Ilus", "imensid",
"Imensid", "imers", "Imers", "imiss",
"Imiss", "implos", "Implos", "imprecis",
"Imprecis", "impress", "Impress", "impuls",
"Impuls", "imunodepress", "Imunodepress", "inaptid",
"Inaptid", "incis", "Incis", "inclus",
"Inclus", "incompreens", "Incompreens", "incurs",
"Incurs", "indecis", "Indecis", "indigest",
"Indigest", "indivis", "Indivis", "inexatid",
"Inexatid", "inexpress", "Inexpress", "inflex",
"Inflex", "infus", "Infus", "ingest",
"Ingest", "ingratid", "Ingratid", "insubmiss",
"Insubmiss", "intens", "Intens", "intercess",
"Intercess", "interconex", "Interconex", "intromiss",
"Intromiss", "introvers", "Introvers", "intrus",
"Intrus", "invas", "Invas", "invers",
"Invers", "irreflex", "Irreflex", "irreligi",
"Irreligi", "irris", "Irris", "lassid",
"Lassid", "legi", "Legi", "lentid",
"Lentid", "les", "Les", "maloclus",
"Maloclus", "macrogest", "Macrogest", "macrorregi", "Macrorregi",
"mans", "Mans", "mansid",
"Mansid", "m", "M", "m"+u"\u00E3"+"os",
"M"+u"\u00E3"+"os", "microgest", "Microgest", "microrregi", "Microrregi",
"miss", "Miss", "mornid", "Mornid",
"Motos", "multid", "Multid", "negrid",
"Negrid", "obsess", "Obsess", "ocasi",
"Ocasi", "oclus", "Oclus", "omiss",
"Omiss", "opini", "Opini", "opress",
"Opress", "paix", "Paix", "pens",
"Pens", "percuss", "Percuss", "perdig",
"Perdig", "perfus", "Perfus", "permiss",
"Permiss", "perplex", "Perplex", "persuas",
"Persuas", "pervers", "Pervers", "podrid",
"Podrid", "possess", "Possess", "precess",
"Precess", "precis", "Precis", 
"Preclus", "preclus", "preens",
"Preens", "press", "Press", "pretens",
"Pretens", "pretid", "Pretid", "previs",
"Previs", "pris", "Pris", "prociss",
"Prociss", "profiss", "Profiss", "profus",
"Profus", "progress", "Progress", "prontid",
"Prontid", "propens", "Propens", "propuls",
"Propuls", "provis", "Provis", "puls",
"Puls", "quest", "Quest", "radiodifus",
"Radiodifus", "radiotelevis", "Radiotelevis", "ras",
"Ras", "raz", "Raz", "readmiss",
"Readmiss", "rebeli", "Rebeli", "recens",
"Recens", "recess", "Recess", "reclus",
"Reclus", "reconvers", "Reconvers", "reflex",
"Reflex", "regi", "Regi", "regress",
"Regress", "reimpress", "Reimpress", "reinvers",
"Reinvers", "religi", "Religi", "remiss",
"Remiss", "repercuss", "Repercuss", "repreens",
"Repreens", "repress", "Repress", "repuls",
"Repuls", "rescis", "Rescis", "retid",
"Retid", "retransmiss", "Retransmiss", "retrovers",
"Retrovers", "reuni", "Reuni", "revers",
"Revers", "revis", "Revis", "rez",
"Rez", "rouquid", "Rouquid", "sans", "saz",
"Saz", "secess", "Secess", "sequid",
"Sequid", "servid", "Servid", "sess",
"Sess", "sobrefus", "Sobrefus", "sofreguid",
"Sofreguid", "soid", "Soid", "solid",
"Solid", "soliflux", "Soliflux", "su",
"Su", "suas", "Suas", "subcomiss",
"Subcomiss", "subdivis", "Subdivis", "submers",
"Submers", "submiss", "Submiss", "subpress", "subvers",
"Subvers", "sucess", "Sucess", "sugest",
"Sugest",  "superpress", "supervis", "Supervis", "supress",
"Supress", "suspens", "Suspens", "televis",
"Televis", "tens", "Tens", "transfus",
"Transfus", "transgress", "Transgress", "transmiss",
"Transmiss", "uni", "Uni", "vaguid",
"Vaguid", "vastid", "Vastid", "vaz",
"Vaz", "vermelhid", "Vermelhid", "vers",
"Vers", "vis", "Vis"])

#excPlvrio  - Excecao palavras masculinas terminadas em ario - erio - irio - orio.
excPlvrio = set(["crit"+u"\u00E9"])


#plvrFmenta  - Palavras femininas terminadas em -menta-
plvrFmenta = set(["ciu", "curti", "e", "escara",
"farda", "ferra", "frege", "frigi", "hipono",
"impedi", "ju", "multiferra", "nanoferra",
"ossa", "pala", "pi", "superferra", "superpi",
"tor", "travesti", "urdi", "varri", "vesti"])


# plvrFemal - palavras femininas terminadas em -al- 
plvrFemal = set(["bacana", "catedra", "Catedra", "espira", "vesta"])

# plvrMasces - palavras masculinas terminadas em -es- frances, ingles 
plvrMasces = set(["a"+u"\u00E7"+"ailand", "african", "alambr", "alban", "alhambr", "almalagu", "amarant",
"amesterdan", "amsterdam", "analand", "anam", "anauriland", "andaman",
"angol", "antiportugu", "arago", "aragon", "aram", "arden", "argu", "arn",
"arouqu", "assam", "assuan", "auriland", "austral", "avaitanh", "avil",
"azerbaidjan", "baam", "baba"+u"\u00E7"+"uland", "bagr", "baion", "balin", "baltistan",
"bandan", "banglad", "barcelon", "barem", "baron", "bearn", "bengal",
"beripocon", "berlin", "bermud", "bern", "bintan", "birman", "bolonh",
"bordal", "bordel", "borgonh", "brabant", "braganc", "bragu", "brandeburgu",
"brandemburgu", "braqu", "brasiland", "brasil", "bruxel", "buenoland", "bulgar",
"burbon", "burgal", "burgu", "burocrat", "burundin", "butan", "cafeland",
"caiman", "calabr", "calc", "camaron", "camo", "campidan", "campon", "canar",
"canav", "canton", "cartagin", "cassiland", "catalan", "catangu", "cazaquistan",
"cercoschampanh", "charol", "chin", "cingal", "cochinchin", "cochin", "coimbr",
"ongol", "cordisburgu", "cordisland", "cordofan", "cordov", "corningl",
"cornualh", "corunh", "cort", "cotan", "cracov", "craon", "cristaland",
"crixaland", "cruciland", "cruzeland", "cupromangan", "dan", "daro", "delfin",
"descort", "diep", "dinamarqu", "divinoland", "dominiqu", "econom", "entrem",
"escoc", "estrasburgu", "etiop", "fero", "ferromangan", "filipin", "fin",
"finland", "franc", "fregu", "freibergu", "gabon", "gal", "galur", "gandar",
"gandr", "gan", "garc", "garon", "garvon", "gatin", "gaul", "ge", "genebr",
"geno", "genov", "genu", "goan", "go", "gregu", "grioland", "groenland",
"groneland", "guadramil", "guam", "guian", "gurgu", "hamburgu", "havan",
"herculand", "hidroland", "hinterland", "holand", "honcongu", "hungar",
"indochin", "ingl", "internet", "irland", "iroqu", "island", "ivoland",
"janian", "japon", "javan", "jornal", "jutland", "land", "leon", "liban",
"ligar", "limburgu", "lion", "liorn", "lisbo", "lisbon", "logudor", "londr",
"loren", "luand", "lund", "luxemburgu", "luziland", "maca"+u"\u00E7"+"ar", "madril",
"madur", "malagu", "malaqu", "malin", "malt", "maluqu", "malvin", "man",
"mangan", "manqu", "marian", "maron", "marqu", "marselh", "m", "men",
"milan", "mirandel", "mirand", "m", "montanh", "mont", "montmartr",
"morqu", "morvand", "morvan", "nant", "napol", "narbon", "navarr",
"neandertal", "neerland", "neoportugu", "neozeland", "nepal", "nic",
"nicobar", "nivern", "norland", "noruegu", "oldemburgu", "olind", "ondurman",
"oran", "orlean", "pamplon", "paquistan", "pard", "parten", "parvon",
"pedren", "pedr", "pequin", "petersburgu", "piemont", "piov", "poiar",
"polon", "portugal", "preit", "psicologu", "publicit", "quercin",
"quirguistan", "rent", "r", "riodonor", "rionor", "romanh", "roterdam",
"ruand", "saiagu", "samarin", "sangalh", "sang", "santiagu", "sassar",
"sendin", "senegal", "sequan", "setem", "siam", "sien", "silicomangan",
"singal", "siroqu", "sirvent", "sociologu", "suaziland", "sudan", "sundan",
"surinam", "tailand", "taiwan", "tajiquistan", "tamar", "tarascon", "tarb",
"tarent", "tarouqu", "tarragon", "tavan", "ternat", "terrant", "teutoburgu",
"tirol", "togol", "togu", "tongan", "tonquin", "torn", "torqu", "torrant",
"trem", "tugand", "tulon", "tuquian", "turin", "turqu", "tuval", "uberland",
"ugand", "usbequistan", "uzbequistan", "vaiamont", "veron", "versalh", "vian",
"vien", "vietnam", "vigu", "virgoland", "vurtembergu", "xangai", "zeland"])


# aacpNos = Concordancia  com o pronome Nos (com acento)  
aacpNos = {"abandona": "abandonamos",
"abandonou": "abandonamos",
"abdica": "abdicamos",
"abdicasse": "abdic"+u"\u00E1"+"ssemos",
"abdicou": "abdicamos",
"abra"+u"\u00E7"+"a": "abra"+u"\u00E7"+"amos",
"abra"+u"\u00E7"+"ou": "abra"+u"\u00E7"+"amos",
"abre": "abrimos",
"abriu": "abrimos",
"acaba": "acabamos",
"acabou": "acabamos",
"aceita": "aceitamos",
"aceitaria": "aceitar"+u"\u00ED"+"amos",
"aceitou": "aceitamos",
"acha": "achamos",
"achava": "ach"+u"\u00E1"+"vamos",
"achou": "achamos",
"acolhe": "acolhemos",
"acompanha": "acompanhamos",
"acompanhou": "acompanhamos",
"acorda": "acordamos",
"acordou": "acordamos",
"acredita": "acreditamos",
"acreditava": "acredit"+u"\u00E1"+"vamos",
"acreditou": "acreditamos",
"acrescenta": "acrescentamos",
"acrescentou": "acrescentamos",
"adivinha": "adivinhamos",
"adivinhou": "adivinhamos",
"admira": "admiramos",
"admirou": "admiramos",
"admitir": "admitirmos",
"adora": "adoramos",
"adorou": "adoramos",
"adota": "adotamos",
"adote": "adotemos",
"adotou": "adotamos",
"adquire": "adquirimos",
"adquiriu": "adquirimos",
"adulterar": "adulterarmos",
"adverte": "advertimos",
"advertiu": "advertimos",
"advoga": "advogamos",
"advogou": "advogamos",
"age": "agimos",
"agiu": "agimos",
"agradece": "agradecemos",
"agradeceu": "agradecemos",
"ajuda": "ajudamos",
"ajudar"+u"\u00E1": "ajudaremos",
"ajudou": "ajudamos",
"ajunta": "ajuntamos",
"ajuntou": "ajuntamos",
"ajusta": "ajustamos",
"ajustou": "ajustamos",
"alcan"+u"\u00E7"+"ava": "alcan"+u"\u00E7"+u"\u00E1"+"vamos",
"alimenta": "alimentamos",
"alimentou": "alimentamos",
"aliviava": "alivi"+u"\u00E1"+"vamos",
"almo"+u"\u00E7"+"a": "almo"+u"\u00E7"+"amos",
"almo"+u"\u00E7"+"ou": "almo"+u"\u00E7"+"amos",
"alugasse": "alug"+u"\u00E1"+"ssemos",
"ama": "amamos",
"amarra": "amarramos",
"amarrou": "amarramos",
"amava": "am"+u"\u00E1"+"vamos",
"amou": "amamos",
"analisa": "analisamos",
"analisasse": "analis"+u"\u00E1"+"ssemos",
"analisou": "analisamos",
"anda": "andamos",
"andava": "and"+u"\u00E1"+"vamos",
"andou": "andamos",
"anuncia": "anunciamos",
"apanha": "apanhamos",
"apanhou": "apanhamos",
"apare"+u"\u00E7"+"a": "apare"+u"\u00E7"+"amos",
"aparece": "aparecemos",
"apareceu": "aparecemos",
"aplaude": "aplaudimos",
"aplaudiu": "aplaudimos",
"aplicaria": "aplicar"+u"\u00ED"+"amos",
"apodrece": "apodrecemos",
"apodreceu": "apodrecemos",
"apoia": "apoiamos",
"apoiou": "apoiamos",
"aprende": "aprendemos",
"aprendeu": "aprendemos",
"apresenta": "apresentamos",
"apresentar"+u"\u00E1": "apresentaremos",
"apresentou": "apresentamos",
"apresta": "aprestamos",
"aprestou": "aprestamos",
"aprova": "aprovamos",
"aprovasse": "aprov"+u"\u00E1"+"ssemos",
"aproveita": "aproveitamos",
"aprovou": "aprovamos",
"arranjar"+u"\u00E1": "arranjaremos",
"arranjasse": "arranj"+u"\u00E1"+"ssemos",
"arrasta": "arrastamos",
"arrastou": "arrastamos",
"arromba": "arrombamos",
"arrombou": "arrombamos",
"aspira": "aspiramos",
"aspirou": "aspiramos",
"assina": "assinamos",
"assinar": "assinarmos",
"assinou": "assinamos",
"assiste": "assistimos",
"assistir": "assistirmos",
"assistiu": "assistimos",
"associa": "associamos",
"assume": "assumimos",
"assumiu": "assumimos",
"ataca": "atacamos",
"atacou": "atacamos",
"atiraria": "atirar"+u"\u00ED"+"amos",
"atravessa": "atravessamos",
"atravessava": "atravess"+u"\u00E1"+"vamos",
"atravessou": "atravessamos",
"aumentar": "aumentarmos",
"avalia": "avaliamos",
"avaliar": "avaliarmos",
"avaliou": "avaliamos",
"avan"+u"\u00E7"+"a": "avan"+u"\u00E7"+"amos",
"avan"+u"\u00E7"+"ou": "avan"+u"\u00E7"+"amos",
"bate": "batemos",
"bateu": "batemos",
"batia": "bat"+u"\u00ED"+"amos",
"batiza": "batizamos",
"batizou": "batizamos",
"bebe": "bebemos",
"beneficia": "beneficiamos",
"beneficiou": "beneficiamos",
"bota": "botamos",
"botou": "botamos",
"brada": "bradamos",
"bradou": "bradamos",
"briga": "brigamos",
"brigou": "brigamos",
"brinca": "brincamos",
"brincava": "brinc"+u"\u00E1"+"vamos",
"brincou": "brincamos",
"busca": "buscamos",
"buscou": "buscamos",
"cabe": "cabemos",
"ca"+u"\u00E7"+"oa": "ca"+u"\u00E7"+"oamos",
"ca"+u"\u00E7"+"oou": "ca"+u"\u00E7"+"oamos",
"cai": "ca"+u"\u00ED"+"mos",
"cairia": "cair"+u"\u00ED"+"amos",
"ca"+u"\u00ED"+"sse": "ca"+u"\u00ED"+"ssemos",
"caiu": "ca"+u"\u00ED"+"mos",
"cala": "calamos",
"calcula": "calculamos",
"calculou": "calculamos",
"calou": "calamos",
"caminha": "caminhamos",
"caminhou": "caminhamos",
"cantar"+u"\u00E1": "cantaremos",
"carece": "carecemos",
"careceu": "carecemos",
"carrega": "carregamos",
"carregava": "carreg"+u"\u00E1"+"vamos",
"carregou": "carregamos",
"casa": "casamos",
"casou": "casamos",
"cavalga": "cavalgamos",
"cavalgou": "cavalgamos",
"celebra": "celebramos",
"celebrou": "celebramos",
"chama": "chamamos",
"chamava": "cham"+u"\u00E1"+"vamos",
"chamou": "chamamos",
"checa": "checamos",
"checou": "checamos",
"chega": "chegamos",
"chegar": "chegarmos",
"chegar"+u"\u00E1": "chegaremos",
"chegava": "cheg"+u"\u00E1"+"vamos",
"chegou": "chegamos",
"chegue": "cheguemos",
"chora": "choramos",
"chorava": "chor"+u"\u00E1"+"vamos",
"chore": "choremos",
"chorou": "choramos",
"cita": "citamos",
"citou": "citamos",
"cobra": "cobramos",
"cobrou": "cobramos",
"colabora": "colaboramos",
"colaborou": "colaboramos",
"coloca": "colocamos",
"colocou": "colocamos",
"combater"+u"\u00E1": "combateremos",
"combina": "combinamos",
"combinava": "combin"+u"\u00E1"+"vamos",
"combinou": "combinamos",
"come": "comemos",
"come"+u"\u00E7"+"a": "come"+u"\u00E7"+"amos",
"come"+u"\u00E7"+"ar": "come"+u"\u00E7"+"armos",
"come"+u"\u00E7"+"ou": "come"+u"\u00E7"+"amos",
"comenta": "comentamos",
"comentou": "comentamos",
"comer": "comermos",
"comete": "cometemos",
"cometeu": "cometemos",
"comeu": "comemos",
"comia": "com"+u"\u00ED"+"amos",
"compara": "comparamos",
"comparou": "comparamos",
"completa": "completamos",
"completou": "completamos",
"compra": "compramos",
"compraria": "comprar"+u"\u00ED"+"amos",
"comprava": "compr"+u"\u00E1"+"vamos",
"compreende": "compreendemos",
"compreendeu": "compreendemos",
"comprou": "compramos",
"comunga": "comungamos",
"comungou": "comungamos",
"concorda": "concordamos",
"concordar"+u"\u00E1": "concordaremos",
"concordou": "concordamos",
"concorria": "concorr"+u"\u00ED"+"amos",
"condena": "condenamos",
"condenou": "condenamos",
"confeccionaria": "confeccionar"+u"\u00ED"+"amos",
"confiava": "confi"+u"\u00E1"+"vamos",
"confirmar": "confirmarmos",
"congelaria": "congelar"+u"\u00ED"+"amos",
"conhece": "conhecemos",
"conheceu": "conhecemos",
"conhecia": "conhec"+u"\u00ED"+"amos",
"conjetura": "conjeturamos",
"conjeturou": "conjeturamos",
"conquista": "conquistamos",
"conquistou": "conquistamos",
"consegue": "conseguimos",
"conseguia": "consegu"+u"\u00ED"+"amos",
"conseguir": "conseguirmos",
"conseguir"+u"\u00E1": "conseguiremos",
"conseguiria": "conseguir"+u"\u00ED"+"amos",
"conseguiu": "conseguimos",
"conservar": "conservarmos",
"conserve": "conservemos",
"considera": "consideramos",
"considerar": "considerarmos",
"considerava": "consider"+u"\u00E1"+"vamos",
"considerou": "consideramos",
"consiga": "consigamos",
"constata": "constatamos",
"constatou": "constatamos",
"constr"+u"\u00F3"+"i": "constru"+u"\u00ED"+"mos",
"construiu": "constru"+u"\u00ED"+"mos",
"conta": "contamos",
"continua": "continuamos",
"continuar"+u"\u00E1": "continuaremos",
"continuava": "continu"+u"\u00E1"+"vamos",
"continuou": "continuamos",
"contou": "contamos",
"contratasse": "contrat"+u"\u00E1"+"ssemos",
"contratava": "contrat"+u"\u00E1"+"vamos",
"controla": "controlamos",
"controlou": "controlamos",
"conversa": "conversamos",
"conversar"+u"\u00E1": "conversaremos",
"conversava": "convers"+u"\u00E1"+"vamos",
"conversou": "conversamos",
"convida": "convidamos",
"convidou": "convidamos",
"coopera": "cooperamos",
"cooperou": "cooperamos",
"corre": "corremos",
"correr"+u"\u00E1": "correremos",
"correu": "corremos",
"costuma": "costumamos",
"costumava": "costum"+u"\u00E1"+"vamos",
"costumou": "costumamos",
"cota": "cotamos",
"cotou": "cotamos",
"cr"+u"\u00EA": "cremos",
"credencia": "credenciamos",
"credenciou": "credenciamos",
"cresce": "crescemos",
"cresceu": "crescemos",
"crescia": "cresc"+u"\u00ED"+"amos",
"creu": "cremos",
"cria": "criamos",
"criar": "criarmos",
"criava": "cri"+u"\u00E1"+"vamos",
"criou": "criamos",
"critica": "criticamos",
"criticou": "criticamos",
"cruza": "cruzamos",
"cuida": "cuidamos",
"cuidou": "cuidamos",
"culpa": "culpamos",
"culpou": "culpamos",
"cultiva": "cultivamos",
"cultivou": "cultivamos",
"cumpre": "cumprimos",
"cumpriu": "cumprimos",
"d"+u"\u00E1": "damos",
"dan"+u"\u00E7"+"a": "dan"+u"\u00E7"+"amos",
"dan"+u"\u00E7"+"asse": "dan"+u"\u00E7"+u"\u00E1"+"ssemos",
"dan"+u"\u00E7"+"ava": "dan"+u"\u00E7"+u"\u00E1"+"vamos",
"dava": "d"+u"\u00E1"+"vamos",
"debitar"+u"\u00E1": "debitaremos",
"decide": "decidimos",
"decidir"+u"\u00E1": "decidiremos",
"decidiu": "decidimos",
"defende": "defendemos",
"defendeu": "defendemos",
"defendia": "defend"+u"\u00ED"+"amos",
"define": "definimos",
"definiu": "definimos",
"deita": "deitamos",
"deitou": "deitamos",
"deixa": "deixamos",
"deixaria": "deixar"+u"\u00ED"+"amos",
"deixou": "deixamos",
"demonstra": "demonstramos",
"demonstrou": "demonstramos",
"denomina": "denominamos",
"denominou": "denominamos",
"denuncia": "denunciamos",
"denunciou": "denunciamos",
"deposita": "depositamos",
"depositou": "depositamos",
"derrubar": "derrubarmos",
"desce": "descemos",
"descende": "descendemos",
"desceu": "descemos",
"descobre": "descobrimos",
"descobrir": "descobrirmos",
"descobrir"+u"\u00E1": "descobriremos",
"descobriu": "descobrimos",
"desconfiava": "desconfi"+u"\u00E1"+"vamos",
"descoroa": "descoroamos",
"deseja": "desejamos",
"desejaria": "desejar"+u"\u00ED"+"amos",
"desejava": "desej"+u"\u00E1"+"vamos",
"desejou": "desejamos",
"desempenha": "desempenhamos",
"desempenhou": "desempenhamos",
"desentranha": "desentranhamos",
"desentranhou": "desentranhamos",
"desenvolve": "desenvolvemos",
"desenvolveu": "desenvolvemos",
"desenvolvia": "desenvolv"+u"\u00ED"+"amos",
"designa": "designamos",
"designou": "designamos",
"despachava": "despach"+u"\u00E1"+"vamos",
"despreza": "desprezamos",
"desprezou": "desprezamos",
"desrespeitar": "desrespeitarmos",
"desviava": "desvi"+u"\u00E1"+"vamos",
"detesta": "detestamos",
"detestou": "detestamos",
"deu": "demos",
"deva": "devamos",
"deve": "devemos",
"deveria": "dever"+u"\u00ED"+"amos",
"devia": "dev"+u"\u00ED"+"amos",
"diagnosticar"+u"\u00E1": "diagnosticaremos",
"diga": "digamos",
"dir"+u"\u00E1": "diremos",
"diria": "dir"+u"\u00ED"+"amos",
"discutia": "discut"+u"\u00ED"+"amos",
"disp"+u"\u00F5"+"e": "dispomos",
"dispor": "dispormos",
"disputa": "disputamos",
"disputou": "disputamos",
"disse": "dissemos",
"dissesse": "diss"+u"\u00E9"+"ssemos",
"divaga": "divagamos",
"divagou": "divagamos",
"diverge": "divergimos",
"divergiu": "divergimos",
"divide": "dividimos",
"dividia": "divid"+u"\u00ED"+"amos",
"dividiu": "dividimos",
"diz": "dizemos",
"dizia": "diz"+u"\u00ED"+"amos",
"dobra": "dobramos",
"dobrou": "dobramos",
"dormia": "dorm"+u"\u00ED"+"amos",
"dormir"+u"\u00E1": "dormiremos",
"dormiu": "dormimos",
"dubla": "dublamos",
"duplica": "duplicamos",
"duplicou": "duplicamos",
u"\u00E9": "somos",
"elabora": "elaboramos",
"elaborou": "elaboramos",
"elege": "elegemos",
"elegeu": "elegemos",
"embarga": "embargamos",
"embargou": "embargamos",
"embirra": "embirramos",
"embirrou": "embirramos",
"emprega": "empregamos",
"empregou": "empregamos",
"encara": "encaramos",
"encarou": "encaramos",
"enche": "enchemos",
"encheu": "enchemos",
"encolhia": "encolh"+u"\u00ED"+"amos",
"encontra": "encontramos",
"encontrar": "encontrarmos",
"encontrar"+u"\u00E1": "encontraremos",
"encontrou": "encontramos",
"enjeita": "enjeitamos",
"entende": "entendemos",
"entendesse": "entend"+u"\u00EA"+"ssemos",
"entra": "entramos",
"entrar": "entrarmos",
"entrava": "entr"+u"\u00E1"+"vamos",
"entrega": "entregamos",
"entregou": "entregamos",
"entrevista": "entrevistamos",
"entrevistou": "entrevistamos",
"entrou": "entramos",
"envia": "enviamos",
"enviaria": "enviar"+u"\u00ED"+"amos",
"enviou": "enviamos",
"enxuga": "enxugamos",
"enxugar"+u"\u00E1": "enxugaremos",
"enxugou": "enxugamos",
"era": u"\u00E9"+"ramos",
"ergue": "erguemos",
"ergueu": "erguemos",
"erra": "erramos",
"errou": "erramos",
"escapa": "escapamos",
"escapou": "escapamos",
"escolhe": "escolhemos",
"escolheu": "escolhemos",
"escolhia": "escolh"+u"\u00ED"+"amos",
"escondia": "escond"+u"\u00ED"+"amos",
"escorrega": "escorregamos",
"escorregou": "escorregamos",
"escrevia": "escrev"+u"\u00ED"+"amos",
"escutava": "escut"+u"\u00E1"+"vamos",
"esgota": "esgotamos",
"esgotou": "esgotamos",
"especifica": "especificamos",
"especificou": "especificamos",
"espera": "esperamos",
"esperava": "esper"+u"\u00E1"+"vamos",
"esperou": "esperamos",
"esquece": "esquecemos",
"est"+u"\u00E1": "estamos",
"estabelece": "estabelecemos",
"estabelecer": "estabelecermos",
"estabeleceu": "estabelecemos",
"estar": "estarmos",
"estar"+u"\u00E1": "estaremos",
"estaria": "estar"+u"\u00ED"+"amos",
"estava": "est"+u"\u00E1"+"vamos",
"esteja": "estejamos",
"estima": "estimamos",
"estimou": "estimamos",
"estive": "estivemos",
"estiver": "estivermos",
"estivesse": "estiv"+u"\u00E9"+"ssemos",
"estornar"+u"\u00E1": "estornaremos",
"estoura": "estouramos",
"estourou": "estouramos",
"estraga": "estragamos",
"estragou": "estragamos",
"estranha": "estranhamos",
"estranhasse": "estranh"+u"\u00E1"+"ssemos",
"estranhe": "estranhemos",
"estranhou": "estranhamos",
"estudar"+u"\u00E1": "estudaremos",
"estudava": "estud"+u"\u00E1"+"vamos",
"exerce": "exercemos",
"exerceu": "exercemos",
"exige": "exigimos",
"exigiu": "exigimos",
"existe": "existimos",
"existiu": "existimos",
"exp"+u"\u00F5"+"e": "expomos",
"exportava": "export"+u"\u00E1"+"vamos",
"expressa": "expressamos",
"expressou": "expressamos",
"fa"+u"\u00E7"+"a": "fa"+u"\u00E7"+"amos",
"fala": "falamos",
"falar": "falarmos",
"falar"+u"\u00E1": "falaremos",
"falava": "fal"+u"\u00E1"+"vamos",
"falou": "falamos",
"falta": "faltamos",
"faltou": "faltamos",
"far"+u"\u00E1": "faremos",
"faria": "far"+u"\u00ED"+"amos",
"faz": "fazemos",
"fazer": "fazermos",
"fazia": "faz"+u"\u00ED"+"amos",
"fechar": "fecharmos",
"fechava": "fech"+u"\u00E1"+"vamos",
"fez": "fizemos",
"fica": "ficamos",
"ficar": "ficarmos",
"ficar"+u"\u00E1": "ficaremos",
"ficasse": "fic"+u"\u00E1"+"ssemos",
"ficava": "fic"+u"\u00E1"+"vamos",
"ficou": "ficamos",
"filma": "filmamos",
"filmou": "filmamos",
"finge": "fingimos",
"fingiu": "fingimos",
"fiscaliza": "fiscalizamos",
"fiscalizou": "fiscalizamos",
"fizer": "fizermos",
"fizesse": "fiz"+u"\u00E9"+"ssemos",
"flartava": "flart"+u"\u00E1"+"vamos",
"foge": "fugimos",
"foi": "fomos",
"folgava": "folg"+u"\u00E1"+"vamos",
"for": "formos",
"forma": "formamos",
"formava": "form"+u"\u00E1"+"vamos",
"formou": "formamos",
"fornece": "fornecemos",
"forneceu": "fornecemos",
"fosse": "fossemos",
"frequentava": "frequent"+u"\u00E1"+"vamos",
"fugisse": "fug"+u"\u00ED"+"ssemos",
"fugiu": "fugimos",
"fumava": "fum"+u"\u00E1"+"vamos",
"funda": "fundamos",
"fundava": "fund"+u"\u00E1"+"vamos",
"fundou": "fundamos",
"furta": "furtamos",
"furtou": "furtamos",
"ganha": "ganhamos",
"ganhar"+u"\u00E1": "ganharemos",
"ganhava": "ganh"+u"\u00E1"+"vamos",
"ganhou": "ganhamos",
"garantir"+u"\u00E1": "garantiremos",
"gasta": "gastamos",
"gastou": "gastamos",
"gosta": "gostamos",
"gostaria": "gostar"+u"\u00ED"+"amos",
"gostava": "gost"+u"\u00E1"+"vamos",
"gostou": "gostamos",
"goza": "gozamos",
"gozou": "gozamos",
"gradua": "graduamos",
"graduou": "graduamos",
"guarda": "guardamos",
"guardou": "guardamos",
"h"+u"\u00E1": "havemos",
"habita": "habitamos",
"habitou": "habitamos",
"havia": "hav"+u"\u00ED"+"amos",
"ia": u"\u00ED"+"amos",
"ignorava": "ignor"+u"\u00E1"+"vamos",
"imagina": "imaginamos",
"imaginava": "imagin"+u"\u00E1"+"vamos",
"imita": "imitamos",
"imitaria": "imitar"+u"\u00ED"+"amos",
"imitou": "imitamos",
"implanta": "implantamos",
"implantou": "implantamos",
"imp"+u"\u00F5"+"e": "impomos",
"importa": "importamos",
"importou": "importamos",
"imp"+u"\u00F4"+"s": "impusemos",
"impregna": "impregnamos",
"impregnou": "impregnamos",
"indica": "indicamos",
"insistia": "insist"+u"\u00ED"+"amos",
"insistiu": "insistimos",
"instala": "instalamos",
"instalou": "instalamos",
"interfere": "interferimos",
"interferiu": "interferimos",
"interpreta": "interpretamos",
"interpretou": "interpretamos",
"interviesse": "intervi"+u"\u00E9"+"ssemos",
"invejava": "invej"+u"\u00E1"+"vamos",
"inventa": "inventamos",
"inventou": "inventamos",
"investiu": "investimos",
"invocar"+u"\u00E1": "invocaremos",
"ir": "irmos",
"ir"+u"\u00E1": "iremos",
"iria": "ir"+u"\u00ED"+"amos",
"janta": "jantamos",
"jantasse": "jant"+u"\u00E1"+"ssemos",
"jantava": "jant"+u"\u00E1"+"vamos",
"jantou": "jantamos",
"joga": "jogamos",
"jogou": "jogamos",
"julga": "julgamos",
"julgou": "julgamos",
"jura": "juramos",
"jurou": "juramos",
"labora": "laboramos",
"lamenta": "lamentamos",
"lan"+u"\u00E7"+"ar": "lan"+u"\u00E7"+"armos",
"lava": "lavamos",
"lavar": "lavarmos",
"lavou": "lavamos",
"l"+u"\u00EA": "lemos",
"legalizaria": "legalizar"+u"\u00ED"+"amos",
"lembra": "lembramos",
"lembrou": "lembramos",
"lesse": "l"+u"\u00EA"+"ssemos",
"leva": "levamos",
"levanta": "levantamos",
"levantou": "levantamos",
"levar"+u"\u00E1": "levaremos",
"levava": "lev"+u"\u00E1"+"vamos",
"levou": "levamos",
"lia": "l"+u"\u00ED"+"amos",
"liberte": "libertemos",
"ligava": "lig"+u"\u00E1"+"vamos",
"localiza": "localizamos",
"localizou": "localizamos",
"lustrava": "lustr"+u"\u00E1"+"vamos",
"luta": "lutamos",
"lutou": "lutamos",
"machuca": "machucamos",
"machucou": "machucamos",
"manda": "mandamos",
"mandou": "mandamos",
"mant"+u"\u00E9"+"m": "mantemos",
"marca": "marcamos",
"marcha": "marchamos",
"marchar"+u"\u00E1": "marcharemos",
"marchou": "marchamos",
"marcou": "marcamos",
"mata": "matamos",
"matara": "mat"+u"\u00E1"+"ramos",
"matava": "mat"+u"\u00E1"+"vamos",
"matou": "matamos",
"mente": "mentimos",
"mentiu": "mentimos",
"merece": "merecemos",
"mereceu": "merecemos",
"merecia": "merec"+u"\u00ED"+"amos",
"meter": "metermos",
"mistura": "misturamos",
"misturou": "misturamos",
"molda": "moldamos",
"moldou": "moldamos",
"montaria": "montar"+u"\u00ED"+"amos",
"mora": "moramos",
"morar"+u"\u00E1": "moraremos",
"morava": "mor"+u"\u00E1"+"vamos",
"more": "moremos",
"morou": "moramos",
"morrer": "morrermos",
"morresse": "morr"+u"\u00EA"+"ssemos",
"mostra": "mostramos",
"mostrou": "mostramos",
"muda": "mudamos",
"mudou": "mudamos",
"nasce": "nascemos",
"nascer": "nascermos",
"nasceu": "nascemos",
"necessita": "necessitamos",
"necessitasse": "necessit"+u"\u00E1"+"ssemos",
"necessitou": "necessitamos",
"nota": "notamos",
"notar": "notarmos",
"notou": "notamos",
"observa": "observamos",
"observar": "observarmos",
"observou": "observamos",
"obteve": "obtivemos",
"oferece": "oferecemos",
"ofereceu": "oferecemos",
"olha": "olhamos",
"olhar": "olharmos",
"olhava": "olh"+u"\u00E1"+"vamos",
"olhou": "olhamos",
"opta": "optamos",
"optou": "optamos",
"organizava": "organiz"+u"\u00E1"+"vamos",
"ouve": "ouvimos",
"ouvia": "ouv"+u"\u00ED"+"amos",
"ouviria": "ouvir"+u"\u00ED"+"amos",
"ouviu": "ouvimos",
"paga": "pagamos",
"pagar"+u"\u00E1": "pagaremos",
"pagava": "pag"+u"\u00E1"+"vamos",
"pagou": "pagamos",
"parar": "pararmos",
"parava": "par"+u"\u00E1"+"vamos",
"parece": "parecemos",
"pareceu": "parecemos",
"parte": "partimos",
"participa": "participamos",
"participou": "participamos",
"partir"+u"\u00E1": "partiremos",
"partiu": "partimos",
"passa": "passamos",
"passar": "passarmos",
"passasse": "pass"+u"\u00E1"+"ssemos",
"passava": "pass"+u"\u00E1"+"vamos",
"passear": "passearmos",
"passou": "passamos",
"pede": "pedimos",
"pediu": "pedimos",
"pega": "pegamos",
"pegar": "pegarmos",
"pegou": "pegamos",
"pensa": "pensamos",
"pensar": "pensarmos",
"pensava": "pens"+u"\u00E1"+"vamos",
"percebe": "percebemos",
"percebeu": "percebemos",
"percebia": "perceb"+u"\u00ED"+"amos",
"percorre": "percorremos",
"percorreu": "percorremos",
"perde": "perdemos",
"perder": "perdermos",
"perder"+u"\u00E1": "perderemos",
"perdeu": "perdemos",
"perdoa": "perdoamos",
"perdoou": "perdoamos",
"pergunta": "perguntamos",
"perguntou": "perguntamos",
"pertence": "pertencemos",
"pertenceu": "pertencemos",
"pode": "podemos",
"poder"+u"\u00E1": "poderemos",
"poderia": "poder"+u"\u00ED"+"amos",
"podia": "pod"+u"\u00ED"+"amos",
"p"+u"\u00F5"+"e": "pomos",
"poria": "por"+u"\u00ED"+"amos",
"possa": "possamos",
"possui": "possu"+u"\u00ED"+"mos",
"possuiu": "possu"+u"\u00ED"+"mos",
"poupa": "poupamos",
"pouparia": "poupar"+u"\u00ED"+"amos",
"poupou": "poupamos",
"precisa": "precisamos",
"precisar": "precisarmos",
"precisaria": "precisar"+u"\u00ED"+"amos",
"precisava": "precis"+u"\u00E1"+"vamos",
"predisse": "predissemos",
"prefere": "preferimos",
"preferia": "prefer"+u"\u00ED"+"amos",
"preferiu": "preferimos",
"prende": "prendemos",
"prepara": "preparamos",
"prepararia": "preparar"+u"\u00ED"+"amos",
"preparava": "prepar"+u"\u00E1"+"vamos",
"preparou": "preparamos",
"presencia": "presenciamos",
"presenciou": "presenciamos",
"presta": "prestamos",
"prestou": "prestamos",
"pretende": "pretendemos",
"pretendeu": "pretendemos",
"pretendia": "pretend"+u"\u00ED"+"amos",
"processa": "processamos",
"processou": "processamos",
"procura": "procuramos",
"procurou": "procuramos",
"produz": "produzimos",
"produziu": "produzimos",
"profere": "proferimos",
"proferiu": "proferimos",
"projetava": "projet"+u"\u00E1"+"vamos",
"promete": "prometemos",
"prop"+u"\u00F5"+"e": "propomos",
"provar"+u"\u00E1": "provaremos",
"providencia": "providenciamos",
"publicaria": "publicar"+u"\u00ED"+"amos",
"puder": "pudermos",
"punha": "p"+u"\u00FA"+"nhamos",
"pus": "pusemos",
"puxa": "puxamos",
"puxou": "puxamos",
"quebrava": "quebr"+u"\u00E1"+"vamos",
"quer": "queremos",
"querer": "querermos",
"queria": "quer"+u"\u00ED"+"amos",
"quis": "quisemos",
"quiser": "quisermos",
"quisera": "quis"+u"\u00E9"+"ramos",
"quisesse": "quis"+u"\u00E9"+"ssemos",
"rebolava": "rebol"+u"\u00E1"+"vamos",
"receava": "rece"+u"\u00E1"+"vamos",
"recebe": "recebemos",
"receber"+u"\u00E1": "receberemos",
"recebeu": "recebemos",
"recebia": "receb"+u"\u00ED"+"amos",
"reconhece": "reconhecemos",
"reconheceu": "reconhecemos",
"recorde": "recordemos",
"reduziu": "reduzimos",
"registra": "registramos",
"registrou": "registramos",
"regrava": "regravamos",
"reivindica": "reivindicamos",
"reivindicou": "reivindicamos",
"rema": "remamos",
"reparar": "repararmos",
"repete": "repetimos",
"repetiu": "repetimos",
"representa": "representamos",
"representou": "representamos",
"requere": "requeremos",
"resiste": "resistimos",
"resistiu": "resistimos",
"resolve": "resolvemos",
"resolveria": "resolver"+u"\u00ED"+"amos",
"resolveu": "resolvemos",
"resolvia": "resolv"+u"\u00ED"+"amos",
"respeita": "respeitamos",
"respeitou": "respeitamos",
"respira": "respiramos",
"respirava": "respir"+u"\u00E1"+"vamos",
"respirou": "respiramos",
"responder": "respondermos",
"respondia": "respond"+u"\u00ED"+"amos",
"responsabiliza": "responsabilizamos",
"responsabilizou": "responsabilizamos",
"retesou": "retesamos",
"retoma": "retomamos",
"retomou": "retomamos",
"retribuiu": "retribu"+u"\u00ED"+"mos",
"retroceder": "retrocedermos",
"re"+u"\u00FA"+"ne": "reunimos",
"reuniu": "reunimos",
"revivia": "reviv"+u"\u00ED"+"amos",
"reza": "rezamos",
"reze": "rezemos",
"rezou": "rezamos",
"roeu": "roemos",
"r"+u"\u00F3"+"i": "roemos",
"rola": "rolamos",
"rolava": "rol"+u"\u00E1"+"vamos",
"rolou": "rolamos",
"rouba": "roubamos",
"roubou": "roubamos",
"sabe": "sabemos",
"saber": "sabermos",
"saber"+u"\u00E1": "saberemos",
"saberia": "saber"+u"\u00ED"+"amos",
"sabia": "sab"+u"\u00ED"+"amos",
"saboreia": "saboreamos",
"sacrifica": "sacrificamos",
"sai": "sa"+u"\u00ED"+"mos",
"sa"+u"\u00ED"+"a": "sa"+u"\u00ED"+"amos",
"saiba": "saibamos",
"sair": "sairmos",
"sair"+u"\u00E1": "sairemos",
"sa"+u"\u00ED"+"sse": "sa"+u"\u00ED"+"ssemos",
"sanciona": "sancionamos",
"saudava": "saud"+u"\u00E1"+"vamos",
"segue": "seguimos",
"seguiu": "seguimos",
"segura": "seguramos",
"segurar"+u"\u00E1": "seguraremos",
"segurou": "seguramos",
"seja": "sejamos",
"selecionar"+u"\u00E1": "selecionaremos",
"sente": "sentimos",
"sentia": "sent"+u"\u00ED"+"amos",
"sentir": "sentirmos",
"ser": "sermos",
"ser"+u"\u00E1": "seremos",
"seria": "ser"+u"\u00ED"+"amos",
"serve": "servimos",
"serviu": "servimos",
"sinta": "sintamos",
"sofre": "sofremos",
"sofreu": "sofremos",
"sonha": "sonhamos",
"sonhava": "sonh"+u"\u00E1"+"vamos",
"sonhou": "sonhamos",
"sorri": "sorrimos",
"sorria": "sorr"+u"\u00ED"+"amos",
"sorriu": "sorrimos",
"soube": "soubemos",
"souber": "soubermos",
"soubesse": "soub"+u"\u00E9"+"ssemos",
"supera": "superamos",
"superou": "superamos",
"suplica": "suplicamos",
"supomos": "supomos",
"suprir"+u"\u00E1": "supriremos",
"surpreende": "surpreendemos",
"suspeitava": "suspeit"+u"\u00E1"+"vamos",
"suspira": "suspiramos",
"suspirava": "suspir"+u"\u00E1"+"vamos",
"sustenta": "sustentamos",
"ta": "tamos",
"teimava": "teim"+u"\u00E1"+"vamos",
"tem": "temos",
"teme": "tememos",
"temia": "tem"+u"\u00ED"+"amos",
"tenciona": "tencionamos",
"tenha": "tenhamos",
"tenta": "tentamos",
"tentaria": "tentar"+u"\u00ED"+"amos",
"tentasse": "tent"+u"\u00E1"+"ssemos",
"tentou": "tentamos",
"ter": "termos",
"ter"+u"\u00E1": "teremos",
"teria": "ter"+u"\u00ED"+"amos",
"termina": "terminamos",
"terminava": "termin"+u"\u00E1"+"vamos",
"testar": "testarmos",
"tinha": "t"+u"\u00ED"+"nhamos",
"tira": "tiramos",
"tirava": "tir"+u"\u00E1"+"vamos",
"tire": "tiremos",
"tive": "tivemos",
"tiver": "tivermos",
"tivesse": "tiv"+u"\u00E9"+"ssemos",
"toca": "tocamos",
"tocou": "tocamos",
"toma": "tomamos",
"tomar": "tomarmos",
"tomar"+u"\u00E1": "tomaremos",
"tomava": "tom"+u"\u00E1"+"vamos",
"tomou": "tomamos",
"topa": "topamos",
"torna": "tornamos",
"trabalha": "trabalhamos",
"trabalhava": "trabalh"+u"\u00E1"+"vamos",
"trabalhou": "trabalhamos",
"traja": "trajamos",
"transpirava": "transpir"+u"\u00E1"+"vamos",
"trata": "tratamos",
"tratar"+u"\u00E1": "trataremos",
"tratava": "trat"+u"\u00E1"+"vamos",
"traz": "trazemos",
"trazia": "traz"+u"\u00ED"+"amos",
"treina": "treinamos",
"tremia": "trem"+u"\u00ED"+"amos",
"trepasse": "trep"+u"\u00E1"+"ssemos",
"trilha": "trilhamos",
"trouxe": "trouxemos",
"usa": "usamos",
"usava": "us"+u"\u00E1"+"vamos",
"usou": "usamos",
"usufru"+u"\u00ED"+"a": "usufru"+u"\u00ED"+"amos",
"utiliza": "utilizamos",
"utilizasse": "utiliz"+u"\u00E1"+"ssemos",
"utilizou": "utilizamos",
"vai": "vamos",
"vale": "valemos",
"valorizava": "valoriz"+u"\u00E1"+"vamos",
"vaticina": "vaticinamos",
"v"+u"\u00EA": "vemos",
"veio": "viemos",
"vem": "vimos",
"vence": "vencemos",
"venceu": "vencemos",
"vende": "vendemos",
"vendeu": "vendemos",
"ver": "vermos",
"ver"+u"\u00E1": "veremos",
"verifica": "verificamos",
"verificou": "verificamos",
"vestia": "vest"+u"\u00ED"+"amos",
"via": "v"+u"\u00ED"+"amos",
"viaja": "viajamos",
"viajou": "viajamos",
"vinha": "v"+u"\u00ED"+"nhamos",
"vir": "virmos",
"vira": "viramos",
"vire": "viremos",
"visite": "visitemos",
"visse": "v"+u"\u00ED"+"ssemos",
"visualiza": "visualizamos",
"visualizar": "visualizarmos",
"vive": "vivemos",
"vivencia": "vivenciamos",
"viver": "vivermos",
"viver"+u"\u00E1": "viveremos",
"vivesse": "viv"+u"\u00EA"+"ssemos",
"vivia": "viv"+u"\u00ED"+"amos",
"voa": "voamos",
"volta": "voltamos",
"voltar": "voltarmos",
"voltar"+u"\u00E1": "voltaremos",
"voltaria": "voltar"+u"\u00ED"+"amos",
"volte": "voltemos",
"voltou": "voltamos",
"vota": "votamos",
"votou": "votamos"}


# concNos - concordancia com o pronome Nos (com acento) - Nos vai
concNos = set(["abandona", "abandonou", "abdica", "abdicasse",
"abdicou", "abra"+u"\u00E7"+"a", "abra"+u"\u00E7"+"ou", "abre",
"abriu", "acaba", "acabou", "aceita",
"aceitaria", "aceitou", "acha", "achava",
"achou", "acolhe", "acompanha", "acompanhou",
"acorda", "acordou", "acredita", "acreditava",
"acreditou", "acrescenta", "acrescentou", "adivinha",
"adivinhou", "admira", "admirou", "admitir",
"adora", "adorou", "adota", "adote",
"adotou", "adquire", "adquiriu", "adulterar",
"adverte", "advertiu", "advoga", "advogou",
"age", "agiu", "agradece", "agradeceu",
"ajuda", "ajudar"+u"\u00E1", "ajudou", "ajunta",
"ajuntou", "ajusta", "ajustou", "alcan"+u"\u00E7"+"ava",
"alimenta", "alimentou", "aliviava", "almo"+u"\u00E7"+"a",
"almo"+u"\u00E7"+"ou", "alugasse", "ama", "amarra",
"amarrou", "amava", "amou", "analisa",
"analisasse", "analisou", "anda", "andava",
"andou", "anuncia", "apanha", "apanhou",
"apare"+u"\u00E7"+"a", "aparece", "apareceu", "aplaude",
"aplaudiu", "aplicaria", "apodrece", "apodreceu",
"apoia", "apoiou", "aprende", "aprendeu",
"apresenta", "apresentar"+u"\u00E1", "apresentou", "apresta",
"aprestou", "aprova", "aprovasse", "aproveita",
"aprovou", "arranjar"+u"\u00E1", "arranjasse", "arrasta",
"arrastou", "arromba", "arrombou", "aspira",
"aspirou", "assina", "assinar", "assinou",
"assiste", "assistir", "assistiu", "associa",
"assume", "assumiu", "ataca", "atacou",
"atiraria", "atravessa", "atravessava", "atravessou",
"aumentar", "avalia", "avaliar", "avaliou",
"avan"+u"\u00E7"+"a", "avan"+u"\u00E7"+"ou", "bate", "bateu",
"batia", "batiza", "batizou", "bebe",
"beneficia", "beneficiou", "bota", "botou",
"brada", "bradou", "briga", "brigou",
"brinca", "brincava", "brincou", "busca",
"buscou", "cabe", "ca"+u"\u00E7"+"oa", "ca"+u"\u00E7"+"oou",
"cai", "cairia", "ca"+u"\u00ED"+"sse", "caiu",
"cala", "calcula", "calculou", "calou",
"caminha", "caminhou", "cantar"+u"\u00E1", "carece",
"careceu", "carrega", "carregava", "carregou",
"casa", "casou", "cavalga", "cavalgou",
"celebra", "celebrou", "chama", "chamava",
"chamou", "checa", "checou", "chega",
"chegar", "chegar"+u"\u00E1", "chegava", "chegou",
"chegue", "chora", "chorava", "chore",
"chorou", "cita", "citou", "cobra",
"cobrou", "colabora", "colaborou", "coloca",
"colocou", "combater"+u"\u00E1", "combina", "combinava",
"combinou", "come", "come"+u"\u00E7"+"a", "come"+u"\u00E7"+"ar",
"come"+u"\u00E7"+"ou", "comenta", "comentou", "comer",
"comete", "cometeu", "comeu", "comia",
"compara", "comparou", "completa", "completou",
"compra", "compraria", "comprava", "compreende",
"compreendeu", "comprou", "comunga", "comungou",
"concorda", "concordar"+u"\u00E1", "concordou", "concorria",
"condena", "condenou", "confeccionaria", "confiava",
"confirmar", "congelaria", "conhece", "conheceu",
"conhecia", "conjetura", "conjeturou", "conquista",
"conquistou", "consegue", "conseguia", "conseguir",
"conseguir"+u"\u00E1", "conseguiria", "conseguiu", "conservar",
"conserve", "considera", "considerar", "considerava",
"considerou", "consiga", "constata", "constatou",
"constr"+u"\u00F3"+"i", "construiu", "conta", "continua",
"continuar"+u"\u00E1", "continuava", "continuou", "contou",
"contratasse", "contratava", "controla", "controlou",
"conversa", "conversar"+u"\u00E1", "conversava", "conversou",
"convida", "convidou", "coopera", "cooperou",
"corre", "correr"+u"\u00E1", "correu", "costuma",
"costumava", "costumou", "cota", "cotou",
"cr"+u"\u00EA", "credencia", "credenciou", "cresce",
"cresceu", "crescia", "creu", "cria",
"criar", "criava", "criou", "critica",
"criticou", "cruza", "cuida", "cuidou",
"culpa", "culpou", "cultiva", "cultivou",
"cumpre", "cumpriu", "d"+u"\u00E1", "dan"+u"\u00E7"+"a",
"dan"+u"\u00E7"+"asse", "dan"+u"\u00E7"+"ava", "dava", "debitar"+u"\u00E1",
"decide", "decidir"+u"\u00E1", "decidiu", "defende",
"defendeu", "defendia", "define", "definiu",
"deita", "deitou", "deixa", "deixaria",
"deixou", "demonstra", "demonstrou", "denomina",
"denominou", "denuncia", "denunciou", "deposita",
"depositou", "derrubar", "desce", "descende",
"desceu", "descobre", "descobrir", "descobrir"+u"\u00E1",
"descobriu", "desconfiava", "descoroa", "deseja",
"desejaria", "desejava", "desejou", "desempenha",
"desempenhou", "desentranha", "desentranhou", "desenvolve",
"desenvolveu", "desenvolvia", "designa", "designou",
"despachava", "despreza", "desprezou", "desrespeitar",
"desviava", "detesta", "detestou", "deu",
"deva", "deve", "deveria", "devia",
"diagnosticar"+u"\u00E1", "diga", "dir"+u"\u00E1", "diria",
"discutia", "disp"+u"\u00F5"+"e", "dispor", "disputa",
"disputou", "disse", "dissesse", "divaga",
"divagou", "diverge", "divergiu", "divide",
"dividia", "dividiu", "diz", "dizia",
"dobra", "dobrou", "dormia", "dormir"+u"\u00E1",
"dormiu", "dubla", "duplica", "duplicou",
u"\u00E9", "elabora", "elaborou", "elege",
"elegeu", "embarga", "embargou", "embirra",
"embirrou", "emprega", "empregou", "encara",
"encarou", "enche", "encheu", "encolhia",
"encontra", "encontrar", "encontrar"+u"\u00E1", "encontrou",
"enjeita", "entende", "entendesse", "entra",
"entrar", "entrava", "entrega", "entregou",
"entrevista", "entrevistou", "entrou", "envia",
"enviaria", "enviou", "enxuga", "enxugar"+u"\u00E1",
"enxugou", "era", "ergue", "ergueu",
"erra", "errou", "escapa", "escapou",
"escolhe", "escolheu", "escolhia", "escondia",
"escorrega", "escorregou", "escrevia", "escutava",
"esgota", "esgotou", "especifica", "especificou",
"espera", "esperava", "esperou", "esquece",
"est"+u"\u00E1", "estabelece", "estabelecer", "estabeleceu",
"estar", "estar"+u"\u00E1", "estaria", "estava",
"esteja", "estima", "estimou", "estive",
"estiver", "estivesse", "estornar"+u"\u00E1", "estoura",
"estourou", "estraga", "estragou", "estranha",
"estranhasse", "estranhe", "estranhou", "estudar"+u"\u00E1",
"estudava", "exerce", "exerceu", "exige",
"exigiu", "existe", "existiu", "exp"+u"\u00F5"+"e",
"exportava", "expressa", "expressou", "fa"+u"\u00E7"+"a",
"fala", "falar", "falar"+u"\u00E1", "falava",
"falou", "falta", "faltou", "far"+u"\u00E1",
"faria", "faz", "fazer", "fazia",
"fechar", "fechava", "fez", "fica",
"ficar", "ficar"+u"\u00E1", "ficasse", "ficava",
"ficou", "filma", "filmou", "finge",
"fingiu", "fiscaliza", "fiscalizou", "fizer",
"fizesse", "flartava", "foge", "foi",
"folgava", "for", "forma", "formava",
"formou", "fornece", "forneceu", "fosse",
"frequentava", "fugisse", "fugiu", "fumava",
"funda", "fundava", "fundou", "furta",
"furtou", "ganha", "ganhar"+u"\u00E1", "ganhava",
"ganhou", "garantir"+u"\u00E1", "gasta", "gastou",
"gosta", "gostaria", "gostava", "gostou",
"goza", "gozou", "gradua", "graduou",
"guarda", "guardou", "h"+u"\u00E1", "habita",
"habitou", "havia", "ia", "ignorava",
"imagina", "imaginava", "imita", "imitaria",
"imitou", "implanta", "implantou", "imp"+u"\u00F5"+"e",
"importa", "importou", "imp"+u"\u00F4"+"s", "impregna",
"impregnou", "indica", "insistia", "insistiu",
"instala", "instalou", "interfere", "interferiu",
"interpreta", "interpretou", "interviesse", "invejava",
"inventa", "inventou", "investiu", "invocar"+u"\u00E1",
"ir", "ir"+u"\u00E1", "iria", "janta",
"jantasse", "jantava", "jantou", "joga",
"jogou", "julga", "julgou", "jura",
"jurou", "labora", "lamenta", "lan"+u"\u00E7"+"ar",
"lava", "lavar", "lavou", "l"+u"\u00EA",
"legalizaria", "lembra", "lembrou", "lesse",
"leva", "levanta", "levantou", "levar"+u"\u00E1",
"levava", "levou", "lia", "liberte",
"ligava", "localiza", "localizou", "lustrava",
"luta", "lutou", "machuca", "machucou",
"manda", "mandou", "mant"+u"\u00E9"+"m", "marca",
"marcha", "marchar"+u"\u00E1", "marchou", "marcou",
"mata", "matara", "matava", "matou",
"mente", "mentiu", "merece", "mereceu",
"merecia", "meter", "mistura", "misturou",
"molda", "moldou", "montaria", "mora",
"morar"+u"\u00E1", "morava", "more", "morou",
"morrer", "morresse", "mostra", "mostrou",
"muda", "mudou", "nasce", "nascer",
"nasceu", "necessita", "necessitasse", "necessitou",
"nota", "notar", "notou", "observa",
"observar", "observou", "obteve", "oferece",
"ofereceu", "olha", "olhar", "olhava",
"olhou", "opta", "optou", "organizava",
"ouve", "ouvia", "ouviria", "ouviu",
"paga", "pagar"+u"\u00E1", "pagava", "pagou",
"parar", "parava", "parece", "pareceu",
"parte", "participa", "participou", "partir"+u"\u00E1",
"partiu", "passa", "passar", "passasse",
"passava", "passear", "passou", "pede",
"pediu", "pega", "pegar", "pegou",
"pensa", "pensar", "pensava", "percebe",
"percebeu", "percebia", "percorre", "percorreu",
"perde", "perder", "perder"+u"\u00E1", "perdeu",
"perdoa", "perdoou", "pergunta", "perguntou",
"pertence", "pertenceu", "pode", "poder"+u"\u00E1",
"poderia", "podia", "p"+u"\u00F5"+"e", "poria",
"possa", "possui", "possuiu", "poupa",
"pouparia", "poupou", "precisa", "precisar",
"precisaria", "precisava", "predisse", "prefere",
"preferia", "preferiu", "prende", "prepara",
"prepararia", "preparava", "preparou", "presencia",
"presenciou", "presta", "prestou", "pretende",
"pretendeu", "pretendia", "processa", "processou",
"procura", "procurou", "produz", "produziu",
"profere", "proferiu", "projetava", "promete",
"prop"+u"\u00F5"+"e", "provar"+u"\u00E1", "providencia", "publicaria",
"puder", "punha", "pus", "puxa",
"puxou", "quebrava", "quer", "querer",
"queria", "quis", "quiser", "quisera",
"quisesse", "rebolava", "receava", "recebe",
"receber"+u"\u00E1", "recebeu", "recebia", "reconhece",
"reconheceu", "recorde", "reduziu", "registra",
"registrou", "regrava", "reivindica", "reivindicou",
"rema", "reparar", "repete", "repetiu",
"representa", "representou", "requere", "resiste",
"resistiu", "resolve", "resolveria", "resolveu",
"resolvia", "respeita", "respeitou", "respira",
"respirava", "respirou", "responder", "respondia",
"responsabiliza", "responsabilizou", "retesou", "retoma",
"retomou", "retribuiu", "retroceder", "re"+u"\u00FA"+"ne",
"reuniu", "revivia", "reza", "reze",
"rezou", "roeu", "r"+u"\u00F3"+"i", "rola",
"rolava", "rolou", "rouba", "roubou",
"sabe", "saber", "saber"+u"\u00E1", "saberia",
"sabia", "saboreia", "sacrifica", "sai",
"sa"+u"\u00ED"+"a", "saiba", "sair", "sair"+u"\u00E1",
"sa"+u"\u00ED"+"sse", "sanciona", "saudava", "segue",
"seguiu", "segura", "segurar"+u"\u00E1", "segurou",
"seja", "selecionar"+u"\u00E1", "sente", "sentia",
"sentir", "ser", "ser"+u"\u00E1", "seria",
"serve", "serviu", "sinta", "sofre",
"sofreu", "sonha", "sonhava", "sonhou",
"sorri", "sorria", "sorriu", "soube",
"souber", "soubesse", "supera",
"superou", "suplica", "supomos", "suprir"+u"\u00E1",
"surpreende", "suspeitava", "suspira", "suspirava",
"sustenta", "ta", "teimava", "tem",
"teme", "temia", "tenciona", "tenha",
"tenta", "tentaria", "tentasse", "tentou",
"ter", "ter"+u"\u00E1", "teria", "termina",
"terminava", "testar", "tinha", "tira",
"tirava", "tire", "tive", "tiver",
"tivesse", "toca", "tocou", "toma",
"tomar", "tomar"+u"\u00E1", "tomava", "tomou",
"topa", "torna", "trabalha", "trabalhava",
"trabalhou", "traja", "transpirava", "trata",
"tratar"+u"\u00E1", "tratava", "traz", "trazia",
"treina", "tremia", "trepasse", "trilha",
"trouxe", "usa", "usava", "usou",
"usufru"+u"\u00ED"+"a", "utiliza", "utilizasse", "utilizou",
"vai", "vale", "valorizava", "vaticina",
"v"+u"\u00EA", "veio", "vem", "vence",
"venceu", "vende", "vendeu", "ver",
"ver"+u"\u00E1", "verifica", "verificou", "vestia",
"via", "viaja", "viajou", "vinha",
"vir", "vira", "vire", "visite",
"visse", "visualiza", "visualizar", "vive",
"vivencia", "viver", "viver"+u"\u00E1", "vivesse",
"vivia", "voa", "volta", "voltar",
"voltar"+u"\u00E1", "voltaria", "volte", "voltou",
"vota", "votou"])


# aacpEle = Concordancia  com o pronome Ele  
aacpEle = {"abandonamos": "abandonou",
"abdic"+u"\u00E1"+"ssemos": "abdicasse",
"abdicamos": "abdicou",
"abra"+u"\u00E7"+"amos": "abra"+u"\u00E7"+"ou",
"abrimos": "abriu",
"acabamos": "acabou",
"aceitamos": "aceitou",
"aceitar"+u"\u00ED"+"amos": "aceitaria",
"ach"+u"\u00E1"+"vamos": "achava",
"achamos": "achou",
"acolhemos": "acolhe",
"acompanhamos": "acompanhou",
"acordamos": "acordou",
"acredit"+u"\u00E1"+"vamos": "acreditava",
"acreditamos": "acreditou",
"acrescentamos": "acrescentou",
"adivinhamos": "adivinhou",
"admiramos": "admirou",
"admitirmos": "admitir",
"adoramos": "adorou",
"adotamos": "adotou",
"adotemos": "adote",
"adquirimos": "adquiriu",
"adulterarmos": "adulterar",
"advertimos": "advertiu",
"advogamos": "advogou",
"agimos": "agiu",
"agradecemos": "agradeceu",
"ajudamos": "ajudou",
"ajudaremos": "ajudar"+u"\u00E1",
"ajuntamos": "ajuntou",
"ajustamos": "ajustou",
"alcan"+u"\u00E7"+u"\u00E1"+"vamos": "alcan"+u"\u00E7"+"ava",
"alimentamos": "alimentou",
"alivi"+u"\u00E1"+"vamos": "aliviava",
"almo"+u"\u00E7"+"amos": "almo"+u"\u00E7"+"ou",
"alug"+u"\u00E1"+"ssemos": "alugasse",
"am"+u"\u00E1"+"vamos": "amava",
"amamos": "amou",
"amarramos": "amarrou",
"analis"+u"\u00E1"+"ssemos": "analisasse",
"analisamos": "analisou",
"and"+u"\u00E1"+"vamos": "andava",
"andamos": "andou",
"anunciamos": "anuncia",
"apanhamos": "apanhou",
"apare"+u"\u00E7"+"amos": "apare"+u"\u00E7"+"a",
"aparecemos": "apareceu",
"aplaudimos": "aplaudiu",
"aplicar"+u"\u00ED"+"amos": "aplicaria",
"apodrecemos": "apodreceu",
"apoiamos": "apoiou",
"aprendemos": "aprendeu",
"apresentamos": "apresentou",
"apresentaremos": "apresentar"+u"\u00E1",
"aprestamos": "aprestou",
"aprov"+u"\u00E1"+"ssemos": "aprovasse",
"aprovamos": "aprovou",
"aproveitamos": "aproveita",
"arranj"+u"\u00E1"+"ssemos": "arranjasse",
"arranjaremos": "arranjar"+u"\u00E1",
"arrastamos": "arrastou",
"arrombamos": "arrombou",
"aspiramos": "aspirou",
"assinamos": "assinou",
"assinarmos": "assinar",
"assistimos": "assistiu",
"assistirmos": "assistir",
"associamos": "associa",
"assumimos": "assumiu",
"atacamos": "atacou",
"atirar"+u"\u00ED"+"amos": "atiraria",
"atravess"+u"\u00E1"+"vamos": "atravessava",
"atravessamos": "atravessou",
"aumentarmos": "aumentar",
"avaliamos": "avaliou",
"avaliarmos": "avaliar",
"avan"+u"\u00E7"+"amos": "avan"+u"\u00E7"+"ou",
"bat"+u"\u00ED"+"amos": "batia",
"batemos": "bateu",
"batizamos": "batizou",
"bebemos": "bebe",
"beneficiamos": "beneficiou",
"botamos": "botou",
"bradamos": "bradou",
"brigamos": "brigou",
"brinc"+u"\u00E1"+"vamos": "brincava",
"brincamos": "brincou",
"buscamos": "buscou",
"ca"+u"\u00E7"+"oamos": "ca"+u"\u00E7"+"oou",
"ca"+u"\u00ED"+"mos": "caiu",
"ca"+u"\u00ED"+"ssemos": "ca"+u"\u00ED"+"sse",
"cabemos": "cabe",
"cair"+u"\u00ED"+"amos": "cairia",
"calamos": "calou",
"calculamos": "calculou",
"caminhamos": "caminhou",
"cantaremos": "cantar"+u"\u00E1",
"carecemos": "careceu",
"carreg"+u"\u00E1"+"vamos": "carregava",
"carregamos": "carregou",
"casamos": "casou",
"cavalgamos": "cavalgou",
"celebramos": "celebrou",
"cham"+u"\u00E1"+"vamos": "chamava",
"chamamos": "chamou",
"checamos": "checou",
"cheg"+u"\u00E1"+"vamos": "chegava",
"chegamos": "chegou",
"chegaremos": "chegar"+u"\u00E1",
"chegarmos": "chegar",
"cheguemos": "chegue",
"chor"+u"\u00E1"+"vamos": "chorava",
"choramos": "chorou",
"choremos": "chore",
"citamos": "citou",
"cobramos": "cobrou",
"colaboramos": "colaborou",
"colocamos": "colocou",
"com"+u"\u00ED"+"amos": "comia",
"combateremos": "combater"+u"\u00E1",
"combin"+u"\u00E1"+"vamos": "combinava",
"combinamos": "combinou",
"come"+u"\u00E7"+"amos": "come"+u"\u00E7"+"ou",
"come"+u"\u00E7"+"armos": "come"+u"\u00E7"+"ar",
"comemos": "comeu",
"comentamos": "comentou",
"comermos": "comer",
"cometemos": "cometeu",
"comparamos": "comparou",
"completamos": "completou",
"compr"+u"\u00E1"+"vamos": "comprava",
"compramos": "comprou",
"comprar"+u"\u00ED"+"amos": "compraria",
"compreendemos": "compreendeu",
"comungamos": "comungou",
"concordamos": "concordou",
"concordaremos": "concordar"+u"\u00E1",
"concorr"+u"\u00ED"+"amos": "concorria",
"condenamos": "condenou",
"confeccionar"+u"\u00ED"+"amos": "confeccionaria",
"confi"+u"\u00E1"+"vamos": "confiava",
"confirmarmos": "confirmar",
"congelar"+u"\u00ED"+"amos": "congelaria",
"conhec"+u"\u00ED"+"amos": "conhecia",
"conhecemos": "conheceu",
"conjeturamos": "conjeturou",
"conquistamos": "conquistou",
"consegu"+u"\u00ED"+"amos": "conseguia",
"conseguimos": "conseguiu",
"conseguir"+u"\u00ED"+"amos": "conseguiria",
"conseguiremos": "conseguir"+u"\u00E1",
"conseguirmos": "conseguir",
"conservarmos": "conservar",
"conservemos": "conserve",
"consider"+u"\u00E1"+"vamos": "considerava",
"consideramos": "considerou",
"considerarmos": "considerar",
"consigamos": "consiga",
"constatamos": "constatou",
"constru"+u"\u00ED"+"mos": "construiu",
"contamos": "contou",
"continu"+u"\u00E1"+"vamos": "continuava",
"continuamos": "continuou",
"continuaremos": "continuar"+u"\u00E1",
"contrat"+u"\u00E1"+"ssemos": "contratasse",
"contrat"+u"\u00E1"+"vamos": "contratava",
"controlamos": "controlou",
"convers"+u"\u00E1"+"vamos": "conversava",
"conversamos": "conversou",
"conversaremos": "conversar"+u"\u00E1",
"convidamos": "convidou",
"cooperamos": "cooperou",
"corremos": "correu",
"correremos": "correr"+u"\u00E1",
"costum"+u"\u00E1"+"vamos": "costumava",
"costumamos": "costumou",
"cotamos": "cotou",
"credenciamos": "credenciou",
"cremos": "creu",
"cresc"+u"\u00ED"+"amos": "crescia",
"crescemos": "cresceu",
"cri"+u"\u00E1"+"vamos": "criava",
"criamos": "criou",
"criarmos": "criar",
"criticamos": "criticou",
"cruzamos": "cruza",
"cuidamos": "cuidou",
"culpamos": "culpou",
"cultivamos": "cultivou",
"cumprimos": "cumpriu",
"d"+u"\u00E1"+"vamos": "dava",
"damos": "d"+u"\u00E1",
"dan"+u"\u00E7"+"amos": "dan"+u"\u00E7"+"a",
"dan"+u"\u00E7"+u"\u00E1"+"ssemos": "dan"+u"\u00E7"+"asse",
"dan"+u"\u00E7"+u"\u00E1"+"vamos": "dan"+u"\u00E7"+"ava",
"debitaremos": "debitar"+u"\u00E1",
"decidimos": "decidiu",
"decidiremos": "decidir"+u"\u00E1",
"defend"+u"\u00ED"+"amos": "defendia",
"defendemos": "defendeu",
"definimos": "definiu",
"deitamos": "deitou",
"deixamos": "deixou",
"deixar"+u"\u00ED"+"amos": "deixaria",
"demonstramos": "demonstrou",
"demos": "deu",
"denominamos": "denominou",
"denunciamos": "denunciou",
"depositamos": "depositou",
"derrubarmos": "derrubar",
"descemos": "desceu",
"descendemos": "descende",
"descobrimos": "descobriu",
"descobriremos": "descobrir"+u"\u00E1",
"descobrirmos": "descobrir",
"desconfi"+u"\u00E1"+"vamos": "desconfiava",
"descoroamos": "descoroa",
"desej"+u"\u00E1"+"vamos": "desejava",
"desejamos": "desejou",
"desejar"+u"\u00ED"+"amos": "desejaria",
"desempenhamos": "desempenhou",
"desentranhamos": "desentranhou",
"desenvolv"+u"\u00ED"+"amos": "desenvolvia",
"desenvolvemos": "desenvolveu",
"designamos": "designou",
"despach"+u"\u00E1"+"vamos": "despachava",
"desprezamos": "desprezou",
"desrespeitarmos": "desrespeitar",
"desvi"+u"\u00E1"+"vamos": "desviava",
"detestamos": "detestou",
"dev"+u"\u00ED"+"amos": "devia",
"devamos": "deva",
"devemos": "deve",
"dever"+u"\u00ED"+"amos": "deveria",
"diagnosticaremos": "diagnosticar"+u"\u00E1",
"digamos": "diga",
"dir"+u"\u00ED"+"amos": "diria",
"diremos": "dir"+u"\u00E1",
"discut"+u"\u00ED"+"amos": "discutia",
"dispomos": "disp"+u"\u00F5"+"e",
"dispormos": "dispor",
"disputamos": "disputou",
"diss"+u"\u00E9"+"ssemos": "dissesse",
"dissemos": "disse",
"divagamos": "divagou",
"divergimos": "divergiu",
"divid"+u"\u00ED"+"amos": "dividia",
"dividimos": "dividiu",
"diz"+u"\u00ED"+"amos": "dizia",
"dizemos": "diz",
"dobramos": "dobrou",
"dorm"+u"\u00ED"+"amos": "dormia",
"dormimos": "dormiu",
"dormiremos": "dormir"+u"\u00E1",
"dublamos": "dubla",
"duplicamos": "duplicou",
"elaboramos": "elaborou",
"elegemos": "elegeu",
"embargamos": "embargou",
"embirramos": "embirrou",
"empregamos": "empregou",
"encaramos": "encarou",
"enchemos": "encheu",
"encolh"+u"\u00ED"+"amos": "encolhia",
"encontramos": "encontrou",
"encontraremos": "encontrar"+u"\u00E1",
"encontrarmos": "encontrar",
"enjeitamos": "enjeita",
"entend"+u"\u00EA"+"ssemos": "entendesse",
"entendemos": "entende",
"entr"+u"\u00E1"+"vamos": "entrava",
"entramos": "entrou",
"entrarmos": "entrar",
"entregamos": "entregou",
"entrevistamos": "entrevistou",
"enviamos": "enviou",
"enviar"+u"\u00ED"+"amos": "enviaria",
"enxugamos": "enxugou",
"enxugaremos": "enxugar"+u"\u00E1",
u"\u00E9"+"ramos": "era",
"erguemos": "ergueu",
"erramos": "errou",
"escapamos": "escapou",
"escolh"+u"\u00ED"+"amos": "escolhia",
"escolhemos": "escolheu",
"escond"+u"\u00ED"+"amos": "escondia",
"escorregamos": "escorregou",
"escrev"+u"\u00ED"+"amos": "escrevia",
"escut"+u"\u00E1"+"vamos": "escutava",
"esgotamos": "esgotou",
"especificamos": "especificou",
"esper"+u"\u00E1"+"vamos": "esperava",
"esperamos": "esperou",
"esquecemos": "esquece",
"est"+u"\u00E1"+"vamos": "estava",
"estabelecemos": "estabeleceu",
"estabelecermos": "estabelecer",
"estamos": "est"+u"\u00E1",
"estar"+u"\u00ED"+"amos": "estaria",
"estaremos": "estar"+u"\u00E1",
"estarmos": "estar",
"estejamos": "esteja",
"estimamos": "estimou",
"estiv"+u"\u00E9"+"ssemos": "estivesse",
"estivemos": "estive",
"estivermos": "estiver",
"estornaremos": "estornar"+u"\u00E1",
"estouramos": "estourou",
"estragamos": "estragou",
"estranh"+u"\u00E1"+"ssemos": "estranhasse",
"estranhamos": "estranhou",
"estranhemos": "estranhe",
"estud"+u"\u00E1"+"vamos": "estudava",
"estudaremos": "estudar"+u"\u00E1",
"exercemos": "exerceu",
"exigimos": "exigiu",
"existimos": "existiu",
"expomos": "exp"+u"\u00F5"+"e",
"export"+u"\u00E1"+"vamos": "exportava",
"expressamos": "expressou",
"fa"+u"\u00E7"+"amos": "fa"+u"\u00E7"+"a",
"fal"+u"\u00E1"+"vamos": "falava",
"falamos": "falou",
"falaremos": "falar"+u"\u00E1",
"falarmos": "falar",
"faltamos": "faltou",
"far"+u"\u00ED"+"amos": "faria",
"faremos": "far"+u"\u00E1",
"faz"+u"\u00ED"+"amos": "fazia",
"fazemos": "faz",
"fazermos": "fazer",
"fech"+u"\u00E1"+"vamos": "fechava",
"fecharmos": "fechar",
"fic"+u"\u00E1"+"ssemos": "ficasse",
"fic"+u"\u00E1"+"vamos": "ficava",
"ficamos": "ficou",
"ficaremos": "ficar"+u"\u00E1",
"ficarmos": "ficar",
"filmamos": "filmou",
"fingimos": "fingiu",
"fiscalizamos": "fiscalizou",
"fiz"+u"\u00E9"+"ssemos": "fizesse",
"fizemos": "fez",
"fizermos": "fizer",
"flart"+u"\u00E1"+"vamos": "flartava",
"folg"+u"\u00E1"+"vamos": "folgava",
"fomos": "foi",
"form"+u"\u00E1"+"vamos": "formava",
"formamos": "formou",
"formos": "for",
"fornecemos": "forneceu",
"fossemos": "fosse",
"frequent"+u"\u00E1"+"vamos": "frequentava",
"fug"+u"\u00ED"+"ssemos": "fugisse",
"fugimos": "fugiu",
"fum"+u"\u00E1"+"vamos": "fumava",
"fund"+u"\u00E1"+"vamos": "fundava",
"fundamos": "fundou",
"furtamos": "furtou",
"ganh"+u"\u00E1"+"vamos": "ganhava",
"ganhamos": "ganhou",
"ganharemos": "ganhar"+u"\u00E1",
"garantiremos": "garantir"+u"\u00E1",
"gastamos": "gastou",
"gost"+u"\u00E1"+"vamos": "gostava",
"gostamos": "gostou",
"gostar"+u"\u00ED"+"amos": "gostaria",
"gozamos": "gozou",
"graduamos": "graduou",
"guardamos": "guardou",
"habitamos": "habitou",
"hav"+u"\u00ED"+"amos": "havia",
"havemos": "h"+u"\u00E1",
u"\u00ED"+"amos": "ia",
"ignor"+u"\u00E1"+"vamos": "ignorava",
"imagin"+u"\u00E1"+"vamos": "imaginava",
"imaginamos": "imagina",
"imitamos": "imitou",
"imitar"+u"\u00ED"+"amos": "imitaria",
"implantamos": "implantou",
"impomos": "imp"+u"\u00F5"+"e",
"importamos": "importou",
"impregnamos": "impregnou",
"impusemos": "imp"+u"\u00F4"+"s",
"indicamos": "indica",
"insist"+u"\u00ED"+"amos": "insistia",
"insistimos": "insistiu",
"instalamos": "instalou",
"interferimos": "interferiu",
"interpretamos": "interpretou",
"intervi"+u"\u00E9"+"ssemos": "interviesse",
"invej"+u"\u00E1"+"vamos": "invejava",
"inventamos": "inventou",
"investimos": "investiu",
"invocaremos": "invocar"+u"\u00E1",
"ir"+u"\u00ED"+"amos": "iria",
"iremos": "ir"+u"\u00E1",
"irmos": "ir",
"jant"+u"\u00E1"+"ssemos": "jantasse",
"jant"+u"\u00E1"+"vamos": "jantava",
"jantamos": "jantou",
"jogamos": "jogou",
"julgamos": "julgou",
"juramos": "jurou",
"l"+u"\u00EA"+"ssemos": "lesse",
"l"+u"\u00ED"+"amos": "lia",
"laboramos": "labora",
"lamentamos": "lamenta",
"lan"+u"\u00E7"+"armos": "lan"+u"\u00E7"+"ar",
"lavamos": "lavou",
"lavarmos": "lavar",
"legalizar"+u"\u00ED"+"amos": "legalizaria",
"lembramos": "lembrou",
"lemos": "l"+u"\u00EA",
"lev"+u"\u00E1"+"vamos": "levava",
"levamos": "levou",
"levantamos": "levantou",
"levaremos": "levar"+u"\u00E1",
"libertemos": "liberte",
"lig"+u"\u00E1"+"vamos": "ligava",
"localizamos": "localizou",
"lustr"+u"\u00E1"+"vamos": "lustrava",
"lutamos": "lutou",
"machucamos": "machucou",
"mandamos": "mandou",
"mantemos": "mant"+u"\u00E9"+"m",
"marcamos": "marcou",
"marchamos": "marchou",
"marcharemos": "marchar"+u"\u00E1",
"mat"+u"\u00E1"+"ramos": "matara",
"mat"+u"\u00E1"+"vamos": "matava",
"matamos": "matou",
"mentimos": "mentiu",
"merec"+u"\u00ED"+"amos": "merecia",
"merecemos": "mereceu",
"metermos": "meter",
"misturamos": "misturou",
"moldamos": "moldou",
"montar"+u"\u00ED"+"amos": "montaria",
"mor"+u"\u00E1"+"vamos": "morava",
"moramos": "morou",
"moraremos": "morar"+u"\u00E1",
"moremos": "more",
"morr"+u"\u00EA"+"ssemos": "morresse",
"morrermos": "morrer",
"mostramos": "mostrou",
"mudamos": "mudou",
"nascemos": "nasceu",
"nascermos": "nascer",
"necessit"+u"\u00E1"+"ssemos": "necessitasse",
"necessitamos": "necessitou",
"notamos": "notou",
"notarmos": "notar",
"observamos": "observou",
"observarmos": "observar",
"obtivemos": "obteve",
"oferecemos": "ofereceu",
"olh"+u"\u00E1"+"vamos": "olhava",
"olhamos": "olhou",
"olharmos": "olhar",
"optamos": "optou",
"organiz"+u"\u00E1"+"vamos": "organizava",
"ouv"+u"\u00ED"+"amos": "ouvia",
"ouvimos": "ouviu",
"ouvir"+u"\u00ED"+"amos": "ouviria",
"p"+u"\u00FA"+"nhamos": "punha",
"pag"+u"\u00E1"+"vamos": "pagava",
"pagamos": "pagou",
"pagaremos": "pagar"+u"\u00E1",
"par"+u"\u00E1"+"vamos": "parava",
"pararmos": "parar",
"parecemos": "pareceu",
"participamos": "participou",
"partimos": "partiu",
"partiremos": "partir"+u"\u00E1",
"pass"+u"\u00E1"+"ssemos": "passasse",
"pass"+u"\u00E1"+"vamos": "passava",
"passamos": "passou",
"passarmos": "passar",
"passearmos": "passear",
"pedimos": "pediu",
"pegamos": "pegou",
"pegarmos": "pegar",
"pens"+u"\u00E1"+"vamos": "pensava",
"pensamos": "pensa",
"pensarmos": "pensar",
"perceb"+u"\u00ED"+"amos": "percebia",
"percebemos": "percebeu",
"percorremos": "percorreu",
"perdemos": "perdeu",
"perderemos": "perder"+u"\u00E1",
"perdermos": "perder",
"perdoamos": "perdoou",
"perguntamos": "perguntou",
"pertencemos": "pertenceu",
"pod"+u"\u00ED"+"amos": "podia",
"podemos": "pode",
"poder"+u"\u00ED"+"amos": "poderia",
"poderemos": "poder"+u"\u00E1",
"pomos": "p"+u"\u00F5"+"e",
"por"+u"\u00ED"+"amos": "poria",
"possamos": "possa",
"possu"+u"\u00ED"+"mos": "possuiu",
"poupamos": "poupou",
"poupar"+u"\u00ED"+"amos": "pouparia",
"precis"+u"\u00E1"+"vamos": "precisava",
"precisamos": "precisa",
"precisar"+u"\u00ED"+"amos": "precisaria",
"precisarmos": "precisar",
"predissemos": "predisse",
"prefer"+u"\u00ED"+"amos": "preferia",
"preferimos": "preferiu",
"prendemos": "prende",
"prepar"+u"\u00E1"+"vamos": "preparava",
"preparamos": "preparou",
"preparar"+u"\u00ED"+"amos": "prepararia",
"presenciamos": "presenciou",
"prestamos": "prestou",
"pretend"+u"\u00ED"+"amos": "pretendia",
"pretendemos": "pretendeu",
"processamos": "processou",
"procuramos": "procurou",
"produzimos": "produziu",
"proferimos": "proferiu",
"projet"+u"\u00E1"+"vamos": "projetava",
"prometemos": "promete",
"propomos": "prop"+u"\u00F5"+"e",
"provaremos": "provar"+u"\u00E1",
"providenciamos": "providencia",
"publicar"+u"\u00ED"+"amos": "publicaria",
"pudermos": "puder",
"pusemos": "pus",
"puxamos": "puxou",
"quebr"+u"\u00E1"+"vamos": "quebrava",
"quer"+u"\u00ED"+"amos": "queria",
"queremos": "quer",
"querermos": "querer",
"quis"+u"\u00E9"+"ramos": "quisera",
"quis"+u"\u00E9"+"ssemos": "quisesse",
"quisemos": "quis",
"quisermos": "quiser",
"rebol"+u"\u00E1"+"vamos": "rebolava",
"rece"+u"\u00E1"+"vamos": "receava",
"receb"+u"\u00ED"+"amos": "recebia",
"recebemos": "recebeu",
"receberemos": "receber"+u"\u00E1",
"reconhecemos": "reconheceu",
"recordemos": "recorde",
"reduzimos": "reduziu",
"registramos": "registrou",
"regravamos": "regrava",
"reivindicamos": "reivindicou",
"remamos": "rema",
"repararmos": "reparar",
"repetimos": "repetiu",
"representamos": "representou",
"requeremos": "requere",
"resistimos": "resistiu",
"resolv"+u"\u00ED"+"amos": "resolvia",
"resolvemos": "resolveu",
"resolver"+u"\u00ED"+"amos": "resolveria",
"respeitamos": "respeitou",
"respir"+u"\u00E1"+"vamos": "respirava",
"respiramos": "respirou",
"respond"+u"\u00ED"+"amos": "respondia",
"respondermos": "responder",
"responsabilizamos": "responsabilizou",
"retesamos": "retesou",
"retomamos": "retomou",
"retribu"+u"\u00ED"+"mos": "retribuiu",
"retrocedermos": "retroceder",
"reunimos": "reuniu",
"reviv"+u"\u00ED"+"amos": "revivia",
"rezamos": "rezou",
"rezemos": "reze",
"roemos": "r"+u"\u00F3"+"i",
"rol"+u"\u00E1"+"vamos": "rolava",
"rolamos": "rolou",
"roubamos": "roubou",
"sa"+u"\u00ED"+"amos": "sa"+u"\u00ED"+"a",
"sa"+u"\u00ED"+"mos": "saiu",
"sa"+u"\u00ED"+"ssemos": "sa"+u"\u00ED"+"sse",
"sab"+u"\u00ED"+"amos": "sabia",
"sabemos": "sabe",
"saber"+u"\u00ED"+"amos": "saberia",
"saberemos": "saber"+u"\u00E1",
"sabermos": "saber",
"saboreamos": "saboreia",
"sacrificamos": "sacrifica",
"saibamos": "saiba",
"sairemos": "sair"+u"\u00E1",
"sairmos": "sair",
"sancionamos": "sanciona",
"saud"+u"\u00E1"+"vamos": "saudava",
"seguimos": "seguiu",
"seguramos": "segurou",
"seguraremos": "segurar"+u"\u00E1",
"sejamos": "seja",
"selecionaremos": "selecionar"+u"\u00E1",
"sent"+u"\u00ED"+"amos": "sentia",
"sentimos": "sentiu",
"sentirmos": "sentir",
"ser"+u"\u00ED"+"amos": "seria",
"seremos": "ser"+u"\u00E1",
"sermos": "ser",
"servimos": "serviu",
"sintamos": "sinta",
"sofremos": "sofreu",
"somos": u"\u00E9",
"sonh"+u"\u00E1"+"vamos": "sonhava",
"sonhamos": "sonhou",
"sorr"+u"\u00ED"+"amos": "sorria",
"sorrimos": "sorriu",
"soub"+u"\u00E9"+"ssemos": "soubesse",
"soubemos": "soube",
"soubermos": "souber",
"superamos": "superou",
"suplicamos": "suplica",
"supomos": "supomos",
"supriremos": "suprir"+u"\u00E1",
"surpreendemos": "surpreendeu",
"suspeit"+u"\u00E1"+"vamos": "suspeitava",
"suspir"+u"\u00E1"+"vamos": "suspirava",
"suspiramos": "suspira",
"sustentamos": "sustenta",
"t"+u"\u00ED"+"nhamos": "tinha",
"tamos": "ta",
"teim"+u"\u00E1"+"vamos": "teimava",
"tem"+u"\u00ED"+"amos": "temia",
"tememos": "teme",
"temos": "tem",
"tencionamos": "tenciona",
"tenhamos": "tenha",
"tent"+u"\u00E1"+"ssemos": "tentasse",
"tentamos": "tentou",
"tentar"+u"\u00ED"+"amos": "tentaria",
"ter"+u"\u00ED"+"amos": "teria",
"teremos": "ter"+u"\u00E1",
"termin"+u"\u00E1"+"vamos": "terminava",
"terminamos": "termina",
"termos": "ter",
"testarmos": "testar",
"tir"+u"\u00E1"+"vamos": "tirava",
"tiramos": "tira",
"tiremos": "tire",
"tiv"+u"\u00E9"+"ssemos": "tivesse",
"tivemos": "tive",
"tivermos": "tiver",
"tocamos": "tocou",
"tom"+u"\u00E1"+"vamos": "tomava",
"tomamos": "tomou",
"tomaremos": "tomar"+u"\u00E1",
"tomarmos": "tomar",
"topamos": "topa",
"tornamos": "torna",
"trabalh"+u"\u00E1"+"vamos": "trabalhava",
"trabalhamos": "trabalhou",
"trajamos": "traja",
"transpir"+u"\u00E1"+"vamos": "transpirava",
"trat"+u"\u00E1"+"vamos": "tratava",
"tratamos": "trata",
"trataremos": "tratar"+u"\u00E1",
"traz"+u"\u00ED"+"amos": "trazia",
"trazemos": "traz",
"treinamos": "treina",
"trem"+u"\u00ED"+"amos": "tremia",
"trep"+u"\u00E1"+"ssemos": "trepasse",
"trilhamos": "trilha",
"trouxemos": "trouxe",
"us"+u"\u00E1"+"vamos": "usava",
"usamos": "usou",
"usufru"+u"\u00ED"+"amos": "usufru"+u"\u00ED"+"a",
"utiliz"+u"\u00E1"+"ssemos": "utilizasse",
"utilizamos": "utilizou",
"v"+u"\u00ED"+"amos": "via",
"v"+u"\u00ED"+"nhamos": "vinha",
"v"+u"\u00ED"+"ssemos": "visse",
"valemos": "vale",
"valoriz"+u"\u00E1"+"vamos": "valorizava",
"vamos": "vai",
"vaticinamos": "vaticina",
"vemos": "v"+u"\u00EA",
"vencemos": "venceu",
"vendemos": "vendeu",
"veremos": "ver"+u"\u00E1",
"verificamos": "verificou",
"vermos": "ver",
"vest"+u"\u00ED"+"amos": "vestia",
"viajamos": "viajou",
"viemos": "veio",
"vimos": "vem",
"viramos": "vira",
"viremos": "vire",
"virmos": "vir",
"visitemos": "visite",
"visualizamos": "visualiza",
"visualizarmos": "visualizar",
"viv"+u"\u00EA"+"ssemos": "vivesse",
"viv"+u"\u00ED"+"amos": "vivia",
"vivemos": "vive",
"vivenciamos": "vivencia",
"viveremos": "viver"+u"\u00E1",
"vivermos": "viver",
"voamos": "voou",
"voltamos": "voltou",
"voltar"+u"\u00ED"+"amos": "voltaria",
"voltaremos": "voltar"+u"\u00E1",
"voltarmos": "voltar",
"voltemos": "volte",
"votamos": "votou"}

# concEle - concordancia com o pronome Ele  - Nenhum de nos vamos
concEle = set(["abandonamos", "abdic"+u"\u00E1"+"ssemos", "abdicamos", "abra"+u"\u00E7"+"amos", "abrimos",
"acabamos", "aceitamos", "aceitar"+u"\u00ED"+"amos", "ach"+u"\u00E1"+"vamos", "achamos",
"acolhemos", "acompanhamos", "acordamos", "acredit"+u"\u00E1"+"vamos", "acreditamos",
"acrescentamos", "adivinhamos", "admiramos", "admitirmos", "adoramos",
"adotamos", "adotemos", "adquirimos", "adulterarmos", "advertimos",
"advogamos", "agimos", "agradecemos", "ajudamos", "ajudaremos",
"ajuntamos", "ajustamos", "alcan"+u"\u00E7"+u"\u00E1"+"vamos", "alimentamos", "alivi"+u"\u00E1"+"vamos",
"almo"+u"\u00E7"+"amos", "alug"+u"\u00E1"+"ssemos", "am"+u"\u00E1"+"vamos", "amamos", "amarramos",
"analis"+u"\u00E1"+"ssemos", "analisamos", "and"+u"\u00E1"+"vamos", "andamos", "anunciamos",
"apanhamos", "apare"+u"\u00E7"+"amos", "aparecemos", "aplaudimos", "aplicar"+u"\u00ED"+"amos",
"apodrecemos", "apoiamos", "aprendemos", "apresentamos", "apresentaremos",
"aprestamos", "aprov"+u"\u00E1"+"ssemos", "aprovamos", "aproveitamos", "arranj"+u"\u00E1"+"ssemos",
"arranjaremos", "arrastamos", "arrombamos", "aspiramos", "assinamos",
"assinarmos", "assistimos", "assistirmos", "associamos", "assumimos",
"atacamos", "atirar"+u"\u00ED"+"amos", "atravess"+u"\u00E1"+"vamos", "atravessamos", "aumentarmos",
"avaliamos", "avaliarmos", "avan"+u"\u00E7"+"amos", "bat"+u"\u00ED"+"amos", "batemos",
"batizamos", "bebemos", "beneficiamos", "botamos", "bradamos",
"brigamos", "brinc"+u"\u00E1"+"vamos", "brincamos", "buscamos", "ca"+u"\u00E7"+"oamos",
"ca"+u"\u00ED"+"mos", "ca"+u"\u00ED"+"ssemos", "cabemos", "cair"+u"\u00ED"+"amos", "calamos",
"calculamos", "caminhamos", "cantaremos", "carecemos", "carreg"+u"\u00E1"+"vamos",
"carregamos", "casamos", "cavalgamos", "celebramos", "cham"+u"\u00E1"+"vamos",
"chamamos", "checamos", "cheg"+u"\u00E1"+"vamos", "chegamos", "chegaremos",
"chegarmos", "cheguemos", "chor"+u"\u00E1"+"vamos", "choramos", "choremos",
"citamos", "cobramos", "colaboramos", "colocamos", "com"+u"\u00ED"+"amos",
"combateremos", "combin"+u"\u00E1"+"vamos", "combinamos", "come"+u"\u00E7"+"amos", "come"+u"\u00E7"+"armos",
"comemos", "comentamos", "comermos", "cometemos", "comparamos",
"completamos", "compr"+u"\u00E1"+"vamos", "compramos", "comprar"+u"\u00ED"+"amos", "compreendemos",
"comungamos", "concordamos", "concordaremos", "concorr"+u"\u00ED"+"amos", "condenamos",
"confeccionar"+u"\u00ED"+"amos", "confi"+u"\u00E1"+"vamos", "confirmarmos", "congelar"+u"\u00ED"+"amos", "conhec"+u"\u00ED"+"amos",
"conhecemos", "conjeturamos", "conquistamos", "consegu"+u"\u00ED"+"amos", "conseguimos",
"conseguir"+u"\u00ED"+"amos", "conseguiremos", "conseguirmos", "conservarmos", "conservemos",
"consider"+u"\u00E1"+"vamos", "consideramos", "considerarmos", "consigamos", "constatamos",
"constru"+u"\u00ED"+"mos", "contamos", "continu"+u"\u00E1"+"vamos", "continuamos", "continuaremos",
"contrat"+u"\u00E1"+"ssemos", "contrat"+u"\u00E1"+"vamos", "controlamos", "convers"+u"\u00E1"+"vamos", "conversamos",
"conversaremos", "convidamos", "cooperamos", "corremos", "correremos",
"costum"+u"\u00E1"+"vamos", "costumamos", "cotamos", "credenciamos", "cremos",
"cresc"+u"\u00ED"+"amos", "crescemos", "cri"+u"\u00E1"+"vamos", "criamos", "criarmos",
"criticamos", "cruzamos", "cuidamos", "culpamos", "cultivamos",
"cumprimos", "d"+u"\u00E1"+"vamos", "damos", "dan"+u"\u00E7"+"amos", "dan"+u"\u00E7"+u"\u00E1"+"ssemos",
"dan"+u"\u00E7"+u"\u00E1"+"vamos", "debitaremos", "decidimos", "decidiremos", "defend"+u"\u00ED"+"amos",
"defendemos", "definimos", "deitamos", "deixamos", "deixar"+u"\u00ED"+"amos",
"demonstramos", "demos", "denominamos", "denunciamos", "depositamos",
"derrubarmos", "descemos", "descendemos", "descobrimos", "descobriremos",
"descobrirmos", "desconfi"+u"\u00E1"+"vamos", "descoroamos", "desej"+u"\u00E1"+"vamos", "desejamos",
"desejar"+u"\u00ED"+"amos", "desempenhamos", "desentranhamos", "desenvolv"+u"\u00ED"+"amos", "desenvolvemos",
"designamos", "despach"+u"\u00E1"+"vamos", "desprezamos", "desrespeitarmos", "desvi"+u"\u00E1"+"vamos",
"detestamos", "dev"+u"\u00ED"+"amos", "devamos", "devemos", "dever"+u"\u00ED"+"amos",
"diagnosticaremos", "digamos", "dir"+u"\u00ED"+"amos", "diremos", "discut"+u"\u00ED"+"amos",
"dispomos", "dispormos", "disputamos", "diss"+u"\u00E9"+"ssemos", "dissemos",
"divagamos", "divergimos", "divid"+u"\u00ED"+"amos", "dividimos", "diz"+u"\u00ED"+"amos",
"dizemos", "dobramos", "dorm"+u"\u00ED"+"amos", "dormimos", "dormiremos",
"dublamos", "duplicamos", "elaboramos", "elegemos", "embargamos",
"embirramos", "empregamos", "encaramos", "enchemos", "encolh"+u"\u00ED"+"amos",
"encontramos", "encontraremos", "encontrarmos", "enjeitamos", "entend"+u"\u00EA"+"ssemos",
"entendemos", "entr"+u"\u00E1"+"vamos", "entramos", "entrarmos", "entregamos",
"entrevistamos", "enviamos", "enviar"+u"\u00ED"+"amos", "enxugamos", "enxugaremos",
u"\u00E9"+"ramos", "erguemos", "erramos", "escapamos", "escolh"+u"\u00ED"+"amos",
"escolhemos", "escond"+u"\u00ED"+"amos", "escorregamos", "escrev"+u"\u00ED"+"amos", "escut"+u"\u00E1"+"vamos",
"esgotamos", "especificamos", "esper"+u"\u00E1"+"vamos", "esperamos", "esquecemos",
"est"+u"\u00E1"+"vamos", "estabelecemos", "estabelecermos", "estamos", "estar"+u"\u00ED"+"amos",
"estaremos", "estarmos", "estejamos", "estimamos", "estiv"+u"\u00E9"+"ssemos",
"estivemos", "estivermos", "estornaremos", "estouramos", "estragamos",
"estranh"+u"\u00E1"+"ssemos", "estranhamos", "estranhemos", "estud"+u"\u00E1"+"vamos", "estudaremos",
"exercemos", "exigimos", "existimos", "expomos", "export"+u"\u00E1"+"vamos",
"expressamos", "fa"+u"\u00E7"+"amos", "fal"+u"\u00E1"+"vamos", "falamos", "falaremos",
"falarmos", "faltamos", "far"+u"\u00ED"+"amos", "faremos", "faz"+u"\u00ED"+"amos",
"fazemos", "fazermos", "fech"+u"\u00E1"+"vamos", "fecharmos", "fic"+u"\u00E1"+"ssemos",
"fic"+u"\u00E1"+"vamos", "ficamos", "ficaremos", "ficarmos", "filmamos",
"fingimos", "fiscalizamos", "fiz"+u"\u00E9"+"ssemos", "fizemos", "fizermos",
"flart"+u"\u00E1"+"vamos", "folg"+u"\u00E1"+"vamos", "fomos", "form"+u"\u00E1"+"vamos", "formamos",
"formos", "fornecemos", "fossemos", "frequent"+u"\u00E1"+"vamos", "fug"+u"\u00ED"+"ssemos",
"fugimos", "fum"+u"\u00E1"+"vamos", "fund"+u"\u00E1"+"vamos", "fundamos", "furtamos",
"ganh"+u"\u00E1"+"vamos", "ganhamos", "ganharemos", "garantiremos", "gastamos",
"gost"+u"\u00E1"+"vamos", "gostamos", "gostar"+u"\u00ED"+"amos", "gozamos", "graduamos",
"guardamos", "habitamos", "hav"+u"\u00ED"+"amos", "havemos", u"\u00ED"+"amos",
"ignor"+u"\u00E1"+"vamos", "imagin"+u"\u00E1"+"vamos", "imaginamos", "imitamos", "imitar"+u"\u00ED"+"amos",
"implantamos", "impomos", "importamos", "impregnamos", "impusemos",
"indicamos", "insist"+u"\u00ED"+"amos", "insistimos", "instalamos", "interferimos",
"interpretamos", "intervi"+u"\u00E9"+"ssemos", "invej"+u"\u00E1"+"vamos", "inventamos", "investimos",
"invocaremos", "ir"+u"\u00ED"+"amos", "iremos", "irmos", "jant"+u"\u00E1"+"ssemos",
"jant"+u"\u00E1"+"vamos", "jantamos", "jogamos", "julgamos", "juramos",
"l"+u"\u00EA"+"ssemos", "l"+u"\u00ED"+"amos", "laboramos", "lamentamos", "lan"+u"\u00E7"+"armos",
"lavamos", "lavarmos", "legalizar"+u"\u00ED"+"amos", "lembramos", "lemos",
"lev"+u"\u00E1"+"vamos", "levamos", "levantamos", "levaremos", "libertemos",
"lig"+u"\u00E1"+"vamos", "localizamos", "lustr"+u"\u00E1"+"vamos", "lutamos", "machucamos",
"mandamos", "mantemos", "marcamos", "marchamos", "marcharemos",
"mat"+u"\u00E1"+"ramos", "mat"+u"\u00E1"+"vamos", "matamos", "mentimos", "merec"+u"\u00ED"+"amos",
"merecemos", "metermos", "misturamos", "moldamos", "montar"+u"\u00ED"+"amos",
"mor"+u"\u00E1"+"vamos", "moramos", "moraremos", "moremos", "morr"+u"\u00EA"+"ssemos",
"morrermos", "mostramos", "mudamos", "nascemos", "nascermos",
"necessit"+u"\u00E1"+"ssemos", "necessitamos", "notamos", "notarmos", "observamos",
"observarmos", "obtivemos", "oferecemos", "olh"+u"\u00E1"+"vamos", "olhamos",
"olharmos", "optamos", "organiz"+u"\u00E1"+"vamos", "ouv"+u"\u00ED"+"amos", "ouvimos",
"ouvir"+u"\u00ED"+"amos", "p"+u"\u00FA"+"nhamos", "pag"+u"\u00E1"+"vamos", "pagamos", "pagaremos",
"par"+u"\u00E1"+"vamos", "pararmos", "parecemos", "participamos", "partimos",
"partiremos", "pass"+u"\u00E1"+"ssemos", "pass"+u"\u00E1"+"vamos", "passamos", "passarmos",
"passearmos", "pedimos", "pegamos", "pegarmos", "pens"+u"\u00E1"+"vamos",
"pensamos", "pensarmos", "perceb"+u"\u00ED"+"amos", "percebemos", "percorremos",
"perdemos", "perderemos", "perdermos", "perdoamos", "perguntamos",
"pertencemos", "pod"+u"\u00ED"+"amos", "podemos", "poder"+u"\u00ED"+"amos", "poderemos",
"pomos", "por"+u"\u00ED"+"amos", "possamos", "possu"+u"\u00ED"+"mos", "poupamos",
"poupar"+u"\u00ED"+"amos", "precis"+u"\u00E1"+"vamos", "precisamos", "precisar"+u"\u00ED"+"amos", "precisarmos",
"predissemos", "prefer"+u"\u00ED"+"amos", "preferimos", "prendemos", "prepar"+u"\u00E1"+"vamos",
"preparamos", "preparar"+u"\u00ED"+"amos", "presenciamos", "prestamos", "pretend"+u"\u00ED"+"amos",
"pretendemos", "processamos", "procuramos", "produzimos", "proferimos",
"projet"+u"\u00E1"+"vamos", "prometemos", "propomos", "provaremos", "providenciamos",
"publicar"+u"\u00ED"+"amos", "pudermos", "pusemos", "puxamos", "quebr"+u"\u00E1"+"vamos",
"quer"+u"\u00ED"+"amos", "queremos", "querermos", "quis"+u"\u00E9"+"ramos", "quis"+u"\u00E9"+"ssemos",
"quisemos", "quisermos", "rebol"+u"\u00E1"+"vamos", "rece"+u"\u00E1"+"vamos", "receb"+u"\u00ED"+"amos",
"recebemos", "receberemos", "reconhecemos", "recordemos", "reduzimos",
"registramos", "regravamos", "reivindicamos", "remamos", "repararmos",
"repetimos", "representamos", "requeremos", "resistimos", "resolv"+u"\u00ED"+"amos",
"resolvemos", "resolver"+u"\u00ED"+"amos", "respeitamos", "respir"+u"\u00E1"+"vamos", "respiramos",
"respond"+u"\u00ED"+"amos", "respondermos", "responsabilizamos", "retesamos", "retomamos",
"retribu"+u"\u00ED"+"mos", "retrocedermos", "reunimos", "reviv"+u"\u00ED"+"amos", "rezamos",
"rezemos", "roemos", "rol"+u"\u00E1"+"vamos", "rolamos", "roubamos",
"sa"+u"\u00ED"+"amos", "sa"+u"\u00ED"+"mos", "sa"+u"\u00ED"+"ssemos", "sab"+u"\u00ED"+"amos", "sabemos",
"saber"+u"\u00ED"+"amos", "saberemos", "sabermos", "saboreamos", "sacrificamos",
"saibamos", "sairemos", "sairmos", "sancionamos", "saud"+u"\u00E1"+"vamos",
"seguimos", "seguramos", "seguraremos", "sejamos", "selecionaremos",
"sent"+u"\u00ED"+"amos", "sentimos", "sentirmos", "ser"+u"\u00ED"+"amos", "seremos",
"sermos", "servimos", "sintamos", "sofremos", "somos",
"sonh"+u"\u00E1"+"vamos", "sonhamos", "sorr"+u"\u00ED"+"amos", "sorrimos", "soub"+u"\u00E9"+"ssemos",
"soubemos", "soubermos", "superamos", "suplicamos", "supomos",
"supriremos", "surpreendemos", "suspeit"+u"\u00E1"+"vamos", "suspir"+u"\u00E1"+"vamos", "suspiramos",
"sustentamos", "t"+u"\u00ED"+"nhamos", "tamos", "teim"+u"\u00E1"+"vamos", "tem"+u"\u00ED"+"amos",
"tememos", "temos", "tencionamos", "tenhamos", "tent"+u"\u00E1"+"ssemos",
"tentamos", "tentar"+u"\u00ED"+"amos", "ter"+u"\u00ED"+"amos", "teremos", "termin"+u"\u00E1"+"vamos",
"terminamos", "termos", "testarmos", "tir"+u"\u00E1"+"vamos", "tiramos",
"tiremos", "tiv"+u"\u00E9"+"ssemos", "tivemos", "tivermos", "tocamos",
"tom"+u"\u00E1"+"vamos", "tomamos", "tomaremos", "tomarmos", "topamos",
"tornamos", "trabalh"+u"\u00E1"+"vamos", "trabalhamos", "trajamos", "transpir"+u"\u00E1"+"vamos",
"trat"+u"\u00E1"+"vamos", "tratamos", "trataremos", "traz"+u"\u00ED"+"amos", "trazemos",
"treinamos", "trem"+u"\u00ED"+"amos", "trep"+u"\u00E1"+"ssemos", "trilhamos", "trouxemos",
"us"+u"\u00E1"+"vamos", "usamos", "usufru"+u"\u00ED"+"amos", "utiliz"+u"\u00E1"+"ssemos", "utilizamos",
"v"+u"\u00ED"+"amos", "v"+u"\u00ED"+"nhamos", "v"+u"\u00ED"+"ssemos", "valemos", "valoriz"+u"\u00E1"+"vamos",
"vamos", "vaticinamos", "vemos", "vencemos", "vendemos",
"veremos", "verificamos", "vermos", "vest"+u"\u00ED"+"amos", "viajamos",
"viemos", "vimos", "viramos", "viremos", "virmos",
"visitemos", "visualizamos", "visualizarmos", "viv"+u"\u00EA"+"ssemos", "viv"+u"\u00ED"+"amos",
"vivemos", "vivenciamos", "viveremos", "vivermos", "voamos",
"voltamos", "voltar"+u"\u00ED"+"amos", "voltaremos", "voltarmos", "voltemos",
"votamos"])

# NUMERAIS DOIS GENEROS PARA COMPLEMENTAR COM == E UM ===
numEmfoa  = set(["Bilh"+u"\u00E3"+"o", "bilh"+u"\u00E3"+"o",
"Bilh"+u"\u00F5"+"es", "bilh"+u"\u00F5"+"es", "Cento", "cento", "Cinquenta", "cinquenta",
"Duzentas", "duzentas", "Duzentos", "duzentos", "Mil", "mil", "Milh"+u"\u00E3"+"o", "milh"+u"\u00E3"+"o",
"Milh"+u"\u00F5"+"es", "milh"+u"\u00F5"+"es", "Novecentas", "novecentas", "Novecentos", "novecentos",
"Noventa", "noventa", "Oitenta", "oitenta", "Oitocentas", "oitocentas", "Oitocentos", "oitocentos", "Quarenta", "quarenta",
"Quatrilh"+u"\u00E3"+"o", "quatrilh"+u"\u00E3"+"o", "Quatrilh"+u"\u00F5"+"es", "quatrilh"+u"\u00F5"+"es",
"Quatrocentas", "quatrocentas", "Quatrocentos", "quatrocentos", "Quinhentas", "quinhentas",
"Quinhentos", "quinhentos", "Quintilh"+u"\u00E3"+"o",
"quintilh"+u"\u00E3"+"o", "Quintilh"+u"\u00F5"+"es", "quintilh"+u"\u00F5"+"es",
"Seiscentas", "seiscentas", "Seiscentos", "seiscentos",
"Sessenta", "sessenta", "Setecentas", "setecentas", "Setecentos", "setecentos",
"Setenta", "setenta", "Trezentas", "trezentas", "Trezentos", "trezentos",
"Trilh"+u"\u00E3"+"o", "trilh"+u"\u00E3"+"o", "Trilh"+u"\u00F5"+"es", "trilh"+u"\u00F5"+"es",
"Trinta", "trinta", "Vinte", "vinte"])



# NUMERAIS MASCULINO PARA COMPLEMENTAR COM == E UM ===
numEmasc  = set(["Bilh"+u"\u00E3"+"o", "bilh"+u"\u00E3"+"o",
"Bilh"+u"\u00F5"+"es", "bilh"+u"\u00F5"+"es", "Cento", "cento", "Cinquenta", "cinquenta",
"Duzentos", "duzentos", "Mil", "mil", "Milh"+u"\u00E3"+"o", "milh"+u"\u00E3"+"o",
"Milh"+u"\u00F5"+"es", "milh"+u"\u00F5"+"es", "Novecentos", "novecentos",
"Noventa", "noventa", "Oitenta", "oitenta", "Oitocentos", "oitocentos", "Quarenta", "quarenta",
"Quatrilh"+u"\u00E3"+"o", "quatrilh"+u"\u00E3"+"o", "Quatrilh"+u"\u00F5"+"es", "quatrilh"+u"\u00F5"+"es",
"Quatrocentos", "quatrocentos", "Quinhentos", "quinhentos", "Quintilh"+u"\u00E3"+"o",
"quintilh"+u"\u00E3"+"o", "Quintilh"+u"\u00F5"+"es", "quintilh"+u"\u00F5"+"es", "Seiscentos", "seiscentos",
"Sessenta", "sessenta", "Setecentos", "setecentos", "Setenta", "setenta", "Trezentos", "trezentos",
"Trilh"+u"\u00E3"+"o", "trilh"+u"\u00E3"+"o", "Trilh"+u"\u00F5"+"es", "trilh"+u"\u00F5"+"es",
"Trinta", "trinta", "Vinte", "vinte"])



# NUMERAIS FEMININO PARA COMPLEMENTAR COM == E UMA ====
numEfem  = set(["Bilh"+u"\u00E3"+"o", "bilh"+u"\u00E3"+"o",
"Bilh"+u"\u00F5"+"es", "bilh"+u"\u00F5"+"es", "Cento", "cento", "Cinquenta", "cinquenta",
"Duzentas", "duzentas", "Mil", "mil", "Milh"+u"\u00E3"+"o", "milh"+u"\u00E3"+"o",
"Milh"+u"\u00F5"+"es", "milh"+u"\u00F5"+"es", "Novecentas", "novecentas",
"Noventa", "noventa", "Oitenta", "oitenta", "Oitocentas", "oitocentas", "Quarenta", "quarenta",
"Quatrilh"+u"\u00E3"+"o", "quatrilh"+u"\u00E3"+"o", "Quatrilh"+u"\u00F5"+"es", "quatrilh"+u"\u00F5"+"es",
"Quatrocentas", "quatrocentas", "Quinhentas", "quinhentas", "Quintilh"+u"\u00E3"+"o",
"quintilh"+u"\u00E3"+"o", "Quintilh"+u"\u00F5"+"es", "quintilh"+u"\u00F5"+"es", "Seiscentas", "seiscentas",
"Sessenta", "sessenta", "Setecentas", "setecentas", "Setenta", "setenta", "Trezentas", "trezentas",
"Trilh"+u"\u00E3"+"o", "trilh"+u"\u00E3"+"o", "Trilh"+u"\u00F5"+"es", "trilh"+u"\u00F5"+"es",
"Trinta", "trinta", "Vinte", "vinte"])


# NUMERAIS FEMININO == duzentas canetas ==============
numFem  = set(["Catorze", "catorze", "Cem", "cem", "Cinco", "cinco",
"Cinquenta", "cinquenta", "Dez", "dez", "Dezenove", "dezenove", "Dezesseis", "dezesseis",
"Dezessete", "dezessete", "Dezoito", "dezoito", "Doze", "doze",  "Duas", "duas",
"Duzentas","duzentas", "Mil", "mil", "Nove", "nove", "Novecentas", "novecentas",
"Noventa", "noventa", "Oitenta", "oitenta", "Oito", "oito", "Oitocentas", "oitocentas",
"Onze", "onze", "Quarenta", "quarenta", "Quatorze", "quatorze", "Quatro", "quatro",
"Quatrocentas", "quatrocentas", "Quinhentas", "quinhentas", "Quinze", "quinze",
"Seis", "seis", "Seiscentas", "seiscentas", "Sessenta",  "sessenta",
"Sete", "sete", "Setecentas", "setecentas", "Setenta", "setenta",
"Tr"+u"\u00EA"+"s", "tr"+u"\u00EA"+"s", "Treze", "treze",
"Trezentas", "trezentas", "Trinta", "trinta",
"Vinte", "vinte"])



# NUMERAIS MASCULINO == duzentas canetas ==============
numMasc  = set(["Catorze", "catorze", "Cem", "cem", "Cinco", "cinco",
"Cinquenta", "cinquenta", "Dez", "dez", "Dezenove", "dezenove", "Dezesseis", "dezesseis",
"Dezessete", "dezessete", "Dezoito", "dezoito", "Dois", "dois", "Doze", "doze",
"Duzentos","duzentos", "Mil", "mil", "Nove", "nove", "Novecentos", "novecentos",
"Noventa", "noventa", "Oitenta", "oitenta", "Oito", "oito", "Oitocentos", "oitocentos",
"Onze", "onze", "Quarenta", "quarenta", "Quatorze", "quatorze", "Quatro", "quatro",
"Quatrocentos", "quatrocentos", "Quinhentos", "quinhentos", "Quinze", "quinze",
"Seis", "seis", "Seiscentos", "seiscentos", "Sessenta",  "sessenta",
"Sete", "sete", "Setecentos", "setecentos", "Setenta", "setenta",
"Tr"+u"\u00EA"+"s", "tr"+u"\u00EA"+"s", "Treze", "treze",
"Trezentos", "trezentos", "Trinta", "trinta",
"Vinte", "vinte"])


# NUMERAIS FEMININO-MASCULINO == duzentos canetas == trezentas carros =======
nuMfmoas  = set(["Duzent","duzent", "Novecent", "novecent",
"Oitocentas", "oitocent", "Quatrocent", "quatrocent", "Quinhent",
"quinhentas", "Seiscent", "seiscent", "Setecent",
"setecent", "Trezent", "trezent"])

# NUMERAIS FEMININO-MASCULINO == sem os ENTOS e ENTAS = duzentos trezentas
numMfmoa  = set(["Catorze", "catorze", "Cem", "cem", "Cento", "cento", "Cinco", "cinco",
"Cinquenta", "cinquenta","Dez", "dez", "Dezenove", "dezenove", "Dezesseis", "dezesseis",
"Dezessete", "dezessete", "Dezoito", "dezoito", "Dois", "dois", "Doze", "doze",
"Mil", "mil", "Nove", "nove", "Noventa", "noventa", "Oitenta", "oitenta", "Oito", "oito",
"Onze", "onze", "Quarenta", "quarenta",  "Quatorze", "quatorze", "Quatro", "quatro",
"Quinze", "quinze", "Seis", "seis","Sessenta", "sessenta", "Sete", "sete", "Setenta", "setenta",
"Tr"+u"\u00EA"+"s", "tr"+u"\u00EA"+"s", "Treze", "treze",
"Trinta", "trinta", "Vinte", "vinte"])

# PALAVRAS MASCULINAS == terminadas em [aeiou]rao =til ao= mulherao, caldeirao, = calorao ==
plvrMrao  = set(["abeir", "ailer", "air", "albacor",
"albardeir", "alcatr", "alcor","alfarrobeir",
"algir", "almeir", "alpalheir", "alqueir", "alvador",
"alvadur", "amir", "angular", "ar", "arur", "asneir", "azar","bafor",
"bair", "baleeir", "bandeir", "bar", "beir", "beltr", "besour", "betatr",
"biar", "biber", "biqueir", "bonacheir", "boqueir", "botir", "brancar",
"Brasileir", "brasileir", "brejeir", "bur", "butir", "cadeir", "Caldeir",
"caldeir", "calmeir", "calor", "camar", "cambur", "canastr", "cangueir",
"canjir", "cantimar", "capeir", "capoeir", "caracanir", "car", "carreir",
"casar", "cavaleir", "caveir", "cavir", "centr", "chamborreir",
"champorreir", "chapeir", "chapeleir", "chaporreir", "char", "charqueir",
"chaveir", "cheir", "chor", "choror", "chuveir", "ciclotr", "ciger",
"cintur", "cir", "cisir", "citeropter", "cizir", "clar", "coentr", "coer",
"coir", "companheir", "congueir", "contempor", "convier", "cor", "cormor",
"coscor", "costur", "cour", "cur", "deuter", "diamor", "diatessar", "dinheir",
"doutor", "dur", "ebur", "electr", "eler", "encontr", "eriger", "escadeir",
"escaleir", "escor", "escur", "esgueir", "espadeir", "espor", "esteir",
"estir", "estupor", "estur", "faceir", "fachar", "falastr", "faveir", "feir",
"fever", "figur", "flaqueir", "flor", "fortalheir", "fraqueir", "frieir",
"fur", "galeir", "galer", "gar", "gaspar", "gir", "gizir", "gor", "gorgor",
"goteir", "grossalheir", "grosseir", "har", "hiper", "hor", "interfer",
"jacatir", "jaguar", "jaguatir", "jangueir", "jeir", "jur", "labor", "ladeir",
"lafar", "lagueir", "lamar", "lambeir", "lameir", "lampar", "langueir",
"largueir", "lazar", "leir", "lezir", "ligueir", "linguar", "lingueir",
"linhar", "lir", "liseir", "listr", "longeir", "longer", "longueir", "lumar",
"maceir", "macor", "madraceir", "madur", "magreir", "malheir", "manguar",
"mangueir", "manjer", "mar", "martir", "masseir", "matir", "mazorreir",
"megafeir", "milhar", "milheir", "milher", "Mineir", "mir", "moir",
"molangueir", "molanqueir", "moleir", "mor", "mour", "mulher", "muquir",
"mutir", "muxir", "napeir", "naper", "neutr", "olheir", "palheir", "palmeir",
"pandeir", "par", "parreir", "parvoeir", "patr", "pecador", "peir", "peneir",
"pequir", "percher", "perchur", "piapar", "piquir", "pir", "plasteir",
"plastr", "plastreir", "poceir", "poeir", "polar", "poleir", "poltr", "por",
"positr", "potir", "punxir", "putir", "puxir", "quarteir", "quarter",
"quinteir", "rafeir", "regueir", "ribeir", "salmoir", "salmour", "sanhar",
"sapir", "sar", "satir", "sear", "seir", "sendeir", "sensabor", "simplacheir",
"simplalheir", "simpleir", "sincrotr", "solteir", "sopeir", "superver",
"taleir", "tambolar", "tambur", "taper", "tar", "tempor", "tesoir", "tesour",
"tinhor", "tintur", "tir", "toir", "toleir", "tor", "toupeir", "tour",
"trigueir", "tronqueir", "tubar", "tucur", "vair", "valdur", "valeir",
"vaner", "var", "vaseir", "vassoir", "vazeir", "ver", "verber", "vibor",
"votur", "vozeir", "zar", "zombeir"])


# PALAVRAS MASCULINAS == terminadas em IDA = inseticida, pesticida
excplvrIda  = set(["alme", "almor"+u"\u00E1"+"v", "Ant"+u"\u00E1"+"rt", "ap"+u"\u00E1"+"tr",
"aquem"+u"\u00EA"+"n", u"\u00E1"+"r", "ars"+u"\u00E1"+"c", "Atl"+u"\u00E2"+"nt",
"aven", u"\u00E1"+"v", "bacteric", "bel", "bioc", "br", "br"+u"\u00ED"+"g",
"cant"+u"\u00E1"+"r", "car"+u"\u00F3"+"t", "cefe", "cianam", "ciclofosfam",
"coinc", "col", "consol", "contrapart", "conv", "cris"+u"\u00E1"+"l", "cu",
"dec", "div", "d"+u"\u00ED"+"v", "dru", "duv", "d"+u"\u00FA"+"v", "el", "eluc",
"endiv", "endo", "engrav", "enegrec", "env", "erm", "espermic",
"estup", "filic", "f"+u"\u00F3"+"c", "formam", "formic", "fratric", "fungic",
"genoc", "germic", "grav", "gu", "herbic", "homic", "inc", "infantic",
"insectic", "insetic", "intim", "inval", "isoniaz", "lap", "l"+u"\u00E1"+"p",
"liqu", "liv", "luc", "maldorm", "margar", "m", "nere", "n", "ox",
"par"+u"\u00F3"+"t", "parric", "pestic", "plac", "poliacrilam", "pres",
"progr", "quir", "ratic", "regic", "reinc", "res", "sass"+u"\u00E2"+"n",
"sel"+u"\u00EA"+"uc", "selj"+u"\u00FA"+"c", "sol", "subdiv", "suic",
"sulfam", "talidom", "t"+u"\u00E1"+"ur", "teba", "tiranic", "transgr",
"transluc", "trep", "tropicam", "truc", "uxoric", "ven", "v", "za"])


# PALAVRAS REPETIDAS == EXCECAO
excpLvrep  = set(["PARA", "Para", "para", "PELA", "Pela", "pela", "PELAS", "Pelas", "pelas",
"PELO", "Pelo", "pelo", "PELOS", "Pelos", "pelos"])


# PALAVRAS MASCULINAS TERMINADAS EM  IVA == EXCECAO
excpLvriva  = set(["adject", "adjet", "alque", "arqu", "at", "av", "cat",
"conv", "cr", "cult", "der", "desarqu", "desat", "desmot", "efet", "e",
"enra", "esqu", "incent", "invect", "mot", "Ne", "no", "object", "objet",
"pa", "pr", "qued", "reat", "reav", "rev", "sara", "Sara", "u", "v"])

# PALAVRAS TERMINADAS EM  ADA == EXCECAO
excpLvrada  = set(["Andr", "c", "Camar", "camar", "Can", "Lus"+u"\u00ED",
"lus"+u"\u00ED", "n", "n"+u"\u00F4"+"m"])

# PALAVRAS FEMININAS TERMINADAS EM  NC,A == EXCECAO = venc,a - presenc,a - ananc,a
excpLvrnca  = set(["acarr", "acri", "ader", "afi", "agrav", "alc", "am",
"ape", "aquer", "arrom", "av", "av", "bag", "bal", "bon", "b", "ca",
"c", "conv", "d", "desconv", "destr", "det", "detr", "el", "embal",
"eng", "enj", "enr", "entr", "entr", "esbal", "esbr", "esc", "escarv",
"escarv", "esfr", "esfreg", "esmi", "esp", "estr", "estr",
"estr", "ev", "fem", "furd", "g", "gar", "inj", "l", "nu", "parr",
"pert", "perv", "pi", "p", "p", "p", "r", "rasp", "reconv", "resp",
"r", "rip", "segur", "sobr", "tr", "v"])

# plMfevb - substantivos dois generos terminados em -e- tambem encontrados em conjugacoes verbais.
plMfevb = set(["corte"])

# excplMfe - excecao ao artigo A em palavras de dois generos terminadas em - e - exemplo: A requintes de crueldade
excplMfe = set(["requint"])

# PALAVRAS DE DOIS GENEROS TERMINADAS EM  E == paranaense - elegante - galante
plvrMfe = set(["aaleniens", "aalens", "aaquenens", "abacatens",
"abacaxiens", "abacens", "abadens", "abadianens",
"abadiens", "abadinens", "abaeteens", "abaetetubens",
"abaetezinhens", "abaiarens", "abaibens", "abairens",
"abaitinguens", "abambresens", "abapanens", "abareens",
"abatiaens", "abderens", "abdonens", "abecedens",
"abelardens", "abelens", "abelhens", "aberrant",
"abertanens", "abevilens", "abicens", "abismens",
"abitinens", "abitureirens", "abiulens", "ablitens",
"aboborens", "abor"+u"\u00ED"+"gen", "abor"+u"\u00ED"+"gin", "abraamens",
"abra"+u"\u00E3"+"ozens", "abranchens", "abrangent", "abrantens",
"abr"+u"\u00E3"+"oens", "abrasant", "abreuens", "absorvent",
"abstinent", "abufariens", "abulens", "abun"+u"\u00E3"+"ens",
"abunanens", "abundanciens", "abundant", "abuniens",
"aca"+u"\u00E3"+"ens", "acaciens", "acadiens", "acaiacens",
"acaiaquens", "a"+u"\u00E7"+"aiens", "a"+u"\u00E7"+"ailandens", "a"+u"\u00E7"+"ailandiens",
"a"+u"\u00E7"+"aitubens", "a"+u"\u00E7"+"aizalens", "acajutibens", "acampamentens",
"acan"+u"\u00E3"+"ens", "acananens", "acaraens", "acarapens",
"acarauens", "a"+u"\u00E7"+"areens", "acariens", "aceguaens",
"acesitens", "acheulens", "aciolens", "acmonens",
"acompanhant", "aconchegant", "a"+u"\u00E7"+"orens", "a"+u"\u00E7"+"oriens",
"acrens", "acreunens", "a"+u"\u00E7"+"ucenens", "a"+u"\u00E7"+"uens",
"adamantinens", "adelaidens", "adelandens", "aderent",
"adjacent", "adolescent", "adotant", "adrianopolens",
"adstringent", "adustinens", "afifens", "afogadens",
"afraniens", "afrodescendent", "afrodisiens", "afuaens",
"agaunens", "agent", "aginens", "agirinens",
"agitant", "agonens", "agonizant", "agravant",
"agrest", "agrestinens", "agricolandens", "agridoc",
"agripens", "agripinens", "agrolandens", "aguanilens",
"agudens", "aguiarens", "aimoreens", "aiquarens",
"air"+u"\u00E3"+"oens", "aiuabens", "aiuruoquens", "ajudant",
"ajuricabens", "alabandens", "alabanens", "alanceant",
"alandroalens", "alantens", "alarmant", "alasquens",
"alavens", "albacetens", "albanens", "albens",
"albergariens", "albertinens", "albicastrens", "albicens",
"albigens", "albingaunens", "albinitens", "albintimiliens",
"albufeirens", "albuquerquens", "alcacerens", "alcalarens",
"alcanenens", "alcantarens", "alcantilens", "alceciens",
"alcetiens", "alcobacens", "alcoutenens", "alcoutinens",
"aldeens", "aldegalens", "aldematens", "alecrinens",
"alegrens", "alegret", "alegretens", "alegriens",
"alenquerens", "aletriniens", "alexandriens", "alexanens",
"alfamens", "alfandeguens", "alfenens", "alfredens",
"algarbiens", "algarviens", "algidens", "algonquiens",
"algonquinens", "alhadens", "alhandrens", "aliancens",
"aliciant", "alijoens", "aliterant", "aljezurens",
"aljubarrotens", "aljustrelens", "almadens", "almeidens",
"almeiriens", "almeirinens", "almenarens", "almens",
"almescarens", "almesquinhens", "almocens", "almodovarens",
"almofadens", "aloandiens", "alpalhoens", "alpens",
"alpercatens", "alpestrens", "alpiarcens", "alpinopolens",
"alsiens", "altairens", "altamirens", "altaneirens",
"alteadens", "altens", "alterens", "alterosens",
"altinens", "altinopolens", "altissonant", "altoens",
"altoniens", "altuens", "alucinant", "alunens",
"alurens", "alutrens", "alutriens", "alva"+u"\u00E7"+u"\u00E3"+"ozens",
"alvaiazerens", "alvaranens", "alvarelhens", "alvarelitens",
"alvarenguens", "alvarens", "alvarinens", "alvejant",
"alvens", "alverquens", "alvesens", "alvilandiens",
"alvinitent", "alvinlandens", "alvinlandiens", "alvinopolens",
"alvinopolitens", "alvitens", "alvoradens", "amacianens",
"amadorens", "amananens", "amandabens", "amandens",
"amanhecens", "amaniuens", "amant", "amanuens",
"amapaens", "amaporanens", "amaporens", "amarajiens",
"amaralens", "amarantens", "amarantinens", "amarelens",
"amarens", "amargosens", "amatariens", "amatauraens",
"amaturaens", "amazonens", "amazoniens", "ambianens",
"ambivalent", "ambl"+u"\u00ED"+"op", "ambraciens", "ambrosiens",
"ambulant", "amedarens", "ameixens", "ameliens",
"ameliopolens", "americanens", "amienens", "amiens",
"amiternens", "amitinens", "amizadens", "amocens",
"amolarens", "amoniens", "amontadens", "amorescens",
"amorinopolens", "amorosens", "amparens", "amperens",
"amuamuaipens", "anabolizant", "anacletens", "anadiens",
"anajaens", "anajasens", "anajatenens", "anajatubens",
"anajens", "analandens", "analandiens", "anamanens",
"anamariens", "ananasens", "ananatubens", "ananidens",
"ananindeuens", "anapuens", "anapuruens", "anarquizant",
"anastaciens", "anatiens", "anauaens", "anaurilandens",
"ancarens", "anchietens", "ancianens", "ancoriens",
"andant", "andaraiens", "andaricens", "andesens",
"andiraens", "andirens", "andirobalens", "andirobens",
"andologens", "andorrens", "andradens", "andradinens",
"andreens", "andrelandens", "anelant", "aneliens",
"anemuriens", "anemutuens", "angaiarens", "angaiens",
"angatubens", "angaturamens", "angejens", "angelens",
"angelicens", "angelinens", "angicalens", "angicanens",
"angic"+u"\u00E3"+"ozens", "angicens", "angiquens", "angolens",
"angrens", "anguerataens", "anguerens", "angusturens",
"anhanduiens", "anhanduizinhens", "anhangaens", "anhangaiens",
"anhanguens", "anhanguerens", "anhembiens", "anhumens",
"anicunens", "aninhens", "anisiens", "anitapolens",
"aniversariant", "anoria"+u"\u00E7"+"uens", "anoriens", "anseriform",
"ansianens", "antecedent", "antens", "anticariens",
"anticirens", "anticoagulant", "anticongelant", "antigen",
"antigonens", "antilhens", "antinhens", "antioquens",
"antioquiens", "antioxidant", "antofagastens", "antoninens",
"antuerpiens", "anunciant", "anutibens", "apach",
"apaixonant", "apajatubens", "aparecidens", "apavorant",
"aperibens", "apeuens", "apiaiens", "apinajeens",
"apodiens", "apoiant", "apolinariens", "apolonidens",
"apolonidiens", "aporaens", "aporeens", "aporemens",
"aprazibilens", "aprazivelens", "aproagens", "aproaguens",
"apuaens", "apuaremens", "apucaranens", "apucaraninhens",
"apuiens", "apuliens", "apurimaens", "aquabonens",
"aquaplatens", "aquens", "aquicaldens", "aquidabanens",
"aquidauanens", "aquileens", "aquinens", "aquirabens",
"aquirasens", "aquitanens", "arabelens", "arabricens",
"arabrigens", "arabutanens", "ara"+u"\u00E7"+"a"+u"\u00E7"+"uens", "ara"+u"\u00E7"+"aens",
"ara"+u"\u00E7"+"aibens", "ara"+u"\u00E7"+"aiens", "ara"+u"\u00E7"+"ajiens", "aracajuens",
"ara"+u"\u00E7"+"ariguamens", "aracatia"+u"\u00E7"+"uens", "aracatiarens", "aracatiens",
"ara"+u"\u00E7"+"atubens", "aracatuens", "araciens", "aracitabens",
"aracoiabens", "aracrucens", "aracruzens", "aragarcens",
"aragoianens", "aragonens", "araguacemens", "araguaciens",
"aragua"+u"\u00E7"+"uens", "araguaiarens", "araguaiens", "araguainens",
"araguainhens", "araguananens", "araguapacens", "araguariens",
"araguatinens", "arainens", "araiosens", "arajarens",
"aramariens", "arambareens", "araminens", "arananens",
"aranauens", "aranduens", "aranhens", "arant",
"arantinens", "arapaens", "arapariens", "arapeiens",
"arapiracens", "arapiraquens", "arapirens", "arapoemens",
"araponguens", "araporanens", "arapotiens", "arapuaens",
"araquaens", "araquariens", "araquenens", "araraiens",
"araranguaens", "ararapirens", "araraquarens", "ararendaens",
"ararens", "araricaens", "arariens", "araripens",
"araripinens", "arariusens", "araruamens", "araruens",
"ararunaquarens", "ararunens", "araruvens", "aratacens",
"aratamens", "aratibens", "araticuens", "aratingaubens",
"aratubens", "aratuipens", "arauaens", "araucariens",
"arauens", "araujens", "araunens", "araxaens",
"arborescent", "arcadens", "arceburguens", "arcelinens",
"arcens", "arcobotant", "arcobrigens", "arcoens",
"arcoverdens", "arcozelens", "arcuens", "ardenens",
"ardent", "areadens", "arealvens", "areanens",
"are"+u"\u00E3"+"ozens", "areens", "areinhens", "areiopolens",
"arembepens", "arenalens", "arenapolens", "arequembauens",
"arerens", "aresens", "arfant", "arganilens",
"argenitens", "argentens", "argiritens", "argoimens",
"argoinens", "argolens", "argoncilhens", "ariauens",
"aricanduvens", "aricanguens", "ariciens", "aricorens",
"arimanens", "ariminens", "arinens", "aripibriens",
"aripuanens", "ariquemens", "ariranhens", "aririens",
"aristeuzens", "aristidens", "arisuelens", "aritagnaens",
"arizonens", "arma"+u"\u00E7"+u"\u00E3"+"ozens", "armamarens", "armazenens",
"arneirosens", "arnoniens", "aroasens", "aroeirens",
"aromatizant", "arouquens", "arpoarens", "arquejant",
"arquens", "arraialens", "arraiolens", "arreens",
"arrematant", "arrependidens", "arrepiant", "arrogant",
"arrojadens", "arronchens", "arrozalens", "arrozeirens",
"arrozens", "arrudens", "arrulhant", "artemisens",
"art"+u"\u00ED"+"fic", "aruajaens", "aruananens", "aruaruens",
"aruasens", "aruauens", "aruens", "arujaens",
"arumandubens", "arumanens", "aruminens", "aruntens",
"arutiens", "arvens", "arvernens", "arvoredens",
"arvorezinhens", "ascendent", "asclep"+u"\u00ED"+"ad", "asconens",
"ascurrens", "asdrubalens", "asfixiant", "asidonens",
"aspasiens", "aspirant", "assaltant", "assiens",
"assinant", "assisens", "assistenciens", "assistent",
"assistuens", "assoant", "assuncionens", "astapens",
"astartiens", "astens", "astiens", "astipalens",
"astolfens", "astorguens", "astrapeens", "asturicens",
"atacant", "atafonens", "atalaiens", "atalantens",
"ataleens", "atalens", "atalhens", "ataquens",
"ataubens", "atendent", "ateniens", "atenuant",
"aternens", "aterradens", "aterradinhens", "atia"+u"\u00E7"+"uens",
"atibaiens", "atiliens", "atimirinens", "atimirinzens",
"atinent", "atiradens", "atlant", "atoladeirens",
"atoleirens", "atorment", "atraent", "atriens",
"atuant", "atubens", "aturiaiens", "augustobrigens",
"augustodunens", "aurelianens", "aurens", "auriens",
"auriflamens", "aurignacens", "aurilandens", "aurilandiens",
"aurinhacens", "auriverdens", "aurizonens", "auroens",
"aurorens", "ausent", "ausentens", "ausonens",
"autasasens", "autazens", "autocolant", "aut"+u"\u00F3"+"cton",
"autoimun", "automedont", "autossuficient", "avaiens",
"avanhandavens", "avareens", "avaricens", "avatinquarens",
"avelarens", "avencens", "avens", "aviacionens",
"aviltant", "avisens", "avoant", "axininens",
"axininzens", "axixaens", "azambujens", "azauriens",
"azeitonens", "azevedens", "azilens", "azuritens",
"baamens", "baba"+u"\u00E7"+"uens", "baba"+u"\u00E7"+"ulandiens", "baba"+u"\u00E7"+"uzens",
"babanens", "babiens", "babiloniens", "bacabalens",
"bacabens", "bacadens", "bacaetavens", "bacainens",
"bacatubens", "bacatuens", "bacaubens", "bacaxaens",
"bacelaens", "bacelarens", "bacuriens", "bacuriteuens",
"bacuritiens", "bacuritubens", "bacurizinhens", "badajozens",
"badenens", "baependiens", "baetens", "bageens",
"bagrens", "bagua"+u"\u00E7"+"uens", "baguariens", "bahamens",
"baianens", "bai"+u"\u00E3"+"ozens", "baiens", "baiepanens",
"bailens", "bailiquens", "baionens", "bajeens",
"bajulant", "balaiadens", "balaieirens", "balan"+u"\u00E7"+"ant",
"balbuciant", "baleens", "baleiens", "balens",
"baliniens", "balizens", "baliziens", "balneariens",
"baloi"+u"\u00E7"+"ant", "balou"+u"\u00E7"+"ant", "balsamens", "balsens",
"baltasarens", "baluartens", "bambeant", "bamboant",
"bamboleant", "bambuiens", "banabuinens", "bananalens",
"bananeirens", "bananens", "bandarrens", "bandeirant",
"bandeirantens", "bandeirens", "bangladens", "banguens",
"bannaquens", "banquetens", "banzaens", "baracajaens",
"baraunens", "barbacenens", "barbadens", "barbalhens",
"barbarens", "barbosens", "barcadens", "barcarenens",
"barcelens", "barcelonens", "barcinonens", "bardariens",
"baremens", "bargant", "baririens", "baritens",
"baronens", "barquens", "barquinhens", "barrac"+u"\u00E3"+"ozens",
"barracens", "barraconens", "barradens", "barragenens",
"barranceirens", "barranquens", "barraquens", "barraquinhens",
"barreir"+u"\u00E3"+"ozens", "barreirens", "barreirinhens", "barrens",
"barrentens", "barrestivens", "barretens", "barretinens",
"barrigadens", "barrigudens", "barrinhens", "barro"+u"\u00E7"+u"\u00E3"+"ozens",
"barrocassalens", "barrolandens", "barroquens", "barroquinhens",
"barrosens", "baruens", "barueriens", "baruriens",
"basculant", "basiliens", "bassanens", "bastens",
"bastianens", "basti"+u"\u00E3"+"ozens", "bastosens", "batagua"+u"\u00E7"+"uens",
"bataiporanens", "batalhens", "batataens", "batataiens",
"batatalens", "batateirens", "batatubens", "bateens",
"bateiens", "batel"+u"\u00E3"+"ozens", "bateriens", "batinguens",
"batoquens", "batoviens", "bauens", "bauinens",
"baunilhens", "bauruens", "bautens", "bauxiens",
"bearnens", "beatificant", "bebedourens", "beberibens",
"beculonens", "beirens", "bejens", "bejuens",
"belchiorens", "belemens", "belenens", "belezens",
"beligerant", "belisariens", "belizens", "belmontens",
"belterrens", "belunens", "belvederens", "bempostens",
"benacens", "benaventens", "bendizent", "beneditens",
"beneditinens", "beneficent", "beneleitens", "benemerent",
"benevenutens", "benevolent", "benfazent", "benfiquens",
"bengalens", "benguelens", "beninens", "bentabreuens",
"bentens", "bentinhens", "bequimoens", "bequimonens",
"berilens", "beriquiens", "beritens", "berlinens",
"bermudens", "bernardens", "bernardinens", "bernens",
"bertinhens", "bertioguens", "bertolinens", "beruriens",
"besourens", "bestificant", "betabloqueant", "betaniens",
"beterrens", "betimens", "betinens", "betuliens",
"betulonens", "beverniens", "bexiguens", "bezerrens",
"biafrens", "bibarrens", "biboquens", "bicanquens",
"bicaquens", "bicasens", "bicudens", "bicuibens",
"bidens", "bien", "biform", "bifront",
"bifurqu", "bigua"+u"\u00E7"+"uens", "biguazinhens", "bilacens",
"bilaquens", "bilhostr", "bilidens", "biliens",
"bil"+u"\u00ED"+"ngu", "biltr", "binguens", "biocenos",
"bioluminescent", "bipen", "biquens", "biquinhens",
"birbant", "biribeirens", "biribiriens", "biriguiens",
"biririquens", "biritibens", "biritinguens", "birmanens",
"biscaiens", "bissanens", "bissauens", "bitupitaens",
"bituranens", "bituriens", "biturunens", "bivalent",
"bixopaens", "bizarrens", "bloqueant", "boaciquens",
"boa"+u"\u00E7"+"uens", "boapabens", "boavianens", "bocainens",
"bocaiuvens", "bocejant", "bo"+u"\u00E7"+"oroquens", "bodincomagens",
"bodocoens", "bodocongoens", "bodoens", "bodoquenens",
"bodotens", "boegua"+u"\u00E7"+"uens", "bofetens", "bogua"+u"\u00E7"+"uens",
"boia"+u"\u00E7"+"uens", "boiant", "boiarucens", "boiaruquens",
"boinens", "boiteuxburguens", "boituvens", "bojuruens",
"bolachens", "bolamens", "bolcheviqu", "bolichens",
"bombarralens", "bonaerens", "bonens", "bonfinens",
"bonhuens", "bonifaciens", "boninalens", "bonitens",
"bonjesuens", "bononiens", "bonretirens", "bonsucessens",
"boqueir"+u"\u00E3"+"ozens", "boqueirens", "boquiens", "boquinens",
"boquirens", "boraceens", "boraens", "borbens",
"borboletens", "borboremens", "borbulhant", "bordalens",
"bordelens", "born", "bosens", "bosnens",
"bosniens", "bosquens", "bosqu"+u"\u00ED"+"man", "bostonens",
"botafoguens", "botelhens", "botens", "botiquens",
"botocudens", "botucatuens", "bovilens", "boximan",
"bracarens", "bracejant", "bracens", "bragancens",
"bragantinens", "braguens", "br"+u"\u00E2"+"man", "bram",
"branacens", "brancens", "brandonens", "brandurens",
"branquens", "branquinhens", "brasabrantens", "brasens",
"brasilandens", "brasilandiens", "brasileens", "brasileiens",
"brasileirens", "brasilens", "brasiliens", "brasinens",
"brasiolens", "brasitanens", "brasopolens", "braunens",
"bravens", "brej"+u"\u00E3"+"ozens", "brejatubens", "brejaubens",
"brejauvens", "brejens", "brejetubens", "brejinhens",
"brejoens", "brejonens", "bresciens", "bressanens",
"bretens", "brev", "brevens", "brigadens",
"brigant", "brigidens", "briguens", "brilhant",
"brilhantens", "brilhantinens", "brincant", "britanens",
"britaniens", "britens", "brixiens", "brococoens",
"brodosquiens", "brotens", "brumadens", "brumadiens",
"brumadinhens", "brumalens", "brundueens", "brusquens",
"brutamont", "bruxelens", "bruxuleant", "buarens",
"bucarestens", "bucuitubens", "budapestens", "buenairens",
"buenens", "buenolandens", "buenopolens", "bueraremens",
"bufadeirens", "bufant", "bugrens", "buiquens",
"bujaruens", "bulhonens", "bulidens", "bupevens",
"buquinens", "buracicens", "buraciquens", "buranhenens",
"buraramens", "burdegalens", "burdigalens", "burichens",
"buriens", "burietaens", "buritamens", "buritiens",
"buritiramens", "buritiranens", "buritizalens", "buritizeirens",
"buritizinhens", "burizeirens", "burquinens", "bursaonens",
"burundiens", "butanens", "butiaens", "caagua"+u"\u00E7"+"uens",
"caapiranguens", "caaporanens", "caatibens", "caatinguens",
"cabaceirens", "cabacens", "cabalianens", "cabanens",
"cabe"+u"\u00E7"+"anens", "cabeceirens", "cabecens", "cabe"+u"\u00E7"+"udens",
"cabedelens", "cabeleirens", "cabens", "cabilonens",
"cabiunens", "cabixiens", "caboclens", "cabralens",
"cabraliens", "cabreuvens", "cabriuvens", "cabroboens",
"cabu"+u"\u00E7"+"uens", "caburanens", "cabureens", "cacaiens",
"cacatuens", "cacebuens", "cacequiens", "cacerens",
"cacetens", "cachimbens", "cachoeirens", "cachoeirinhens",
"cachorrens", "cacimbens", "cacimbinhens", "cacoalens",
"cacondens", "caculeens", "cadavalens", "cadeens",
"cadent", "cadet", "cadoriens", "cadozens",
"cadurcens", "caenens", "caenzens", "caetanens",
"caeteens", "caetiteens", "cafarnaunens", "cafearens",
"cafeeirens", "cafeens", "cafelandens", "cafezalens",
"cafezalzinhens", "cafezens", "cafufaens", "cafundoens",
"cagadens", "cagua"+u"\u00E7"+"uens", "caiabuens", "caiacuens",
"caiadens", "caianens", "caiaponiens", "caibateens",
"caibiens", "cai"+u"\u00E7"+"arens", "caicoens", "caieirens",
"caienens", "caiens", "caiguataens", "caipirens",
"caiporens", "caipuens", "cairariens", "caireens",
"cairiens", "cairuens", "caitaens", "caitauens",
"caitauzens", "caiteens", "caititeens", "caitituens",
"caiuaens", "caiubens", "caiubiens", "caiuens",
"cajaens", "cajaibens", "cajamarens", "cajapioens",
"cajariens", "cajatiens", "cajazeirens", "cajobiens",
"cajubiens", "cajubinens", "cajueirens", "cajuiens",
"cajuriens", "cajuruens", "cajuzeirens", "calabacens",
"calaboucens", "calambauens", "calamens", "calanaquens",
"calatravens", "calcedonens", "calcutaens", "caldens",
"calens", "calheirens", "calhetens", "caliciform",
"californiens", "calipolens", "calmant", "calmonens",
"calogerens", "calojiens", "calpens", "calubrigens",
"calumbiens", "cama"+u"\u00E7"+"ajiens", "cama"+u"\u00E7"+"andiens", "camacanens",
"camacaocens", "cama"+u"\u00E7"+"ariens", "camac"+u"\u00E3"+"zens", "camachens",
"camacupens", "camaipiens", "camalauens", "camaldulens",
"camaleonens", "camamuens", "camanducaiens", "camapuanens",
"camapuens", "camaquanens", "camaquens", "camaradens",
"camaraens", "camarajibens", "camaratubens", "camarens",
"camarguens", "camaronens", "cambaiens", "cambaleant",
"cambaquarens", "cambaraens", "cambaratibens", "cambarazinhens",
"cambaubens", "cambeens", "camberrens", "cambiant",
"cambiascens", "cambiasquens", "cambirens", "cambiuens",
"camboapinens", "camboataens", "camboinens", "camboriuens",
"cambrens", "cambucaens", "cambuciens", "cambu"+u"\u00E7"+"uens",
"cambuiens", "cambuizens", "cambuquirens", "camburiens",
"camelens", "cametaens", "caminhant", "caminhens",
"camobiens", "camocinens", "camolenguens", "camopiens",
"campanariens", "campanens", "campanhens", "campaniens",
"campechens", "campeirens", "campelens", "campens",
"campestr", "campestrens", "campina"+u"\u00E7"+"uens", "campinens",
"campomaiorens", "camuciens", "camucinens", "camurujiens",
"camurupinens", "camuscadens", "camutanguens", "camutiens",
"canaanens", "canabarrens", "canabravens", "cana"+u"\u00E7"+"uens",
"canacuriens", "canadens", "canadiens", "canaens",
"canafistulens", "canalens", "canamanens", "canamariens",
"cananeens", "canaranens", "canarianens", "canariens",
"canastr"+u"\u00E3"+"ozens", "canastrens", "canatibens", "canauaniens",
"canavialens", "canavieirens", "cancanens", "cancel"+u"\u00E3"+"ozens",
"cancelens", "cancheens", "candealens", "candeens",
"candelariens", "candent", "candialens", "candibens",
"candoiens", "candombens", "candumbens", "caneapens",
"canecens", "canedens", "caneleirens", "canelens",
"canelinhens", "canens", "cangalhens", "cangatens",
"cangatiens", "cangotens", "canguaretamens", "cangu"+u"\u00E7"+"uens",
"canguens", "canguerens", "canhemborens", "canhobens",
"canhotinhens", "canhumanens", "canindeens", "canindezinhens",
"canitarens", "canivetens", "canjaranens", "canjiquens",
"canoananens", "canoanens", "canoeirens", "canoens",
"canoinhens", "cansan"+u"\u00E7"+u"\u00E3"+"ozens", "cantagalens", "cantanhedens",
"cantant", "cant"+u"\u00E3"+"ozens", "cantens", "cantinhens",
"cantonens", "cantoriens", "cantuariens", "canudens",
"canumanens", "canutamens", "canzens", "capacetens",
"capadens", "capaneens", "capanemens", "capanens",
"cap"+u"\u00E3"+"ozens", "caparaozens", "capatariens", "cape"+u"\u00E7"+"uens",
"capelens", "capelinens", "capelinhens", "caperens",
"capetinguens", "capiaens", "capibaribens", "capinalens",
"capinens", "capintubens", "capinzalens", "capistranens",
"capitanens", "capitariens", "capitoliens", "capitulens",
"capituvens", "capivarens", "capivariens", "capivaritens",
"capixabens", "capoeiranens", "capoeirens", "caponguens",
"caporanguens", "caprariens", "caprichens", "capsens",
"capuavens", "capubinens", "capuens", "capumbens",
"caputirens", "caquemonens", "caquendens", "caraaens",
"carabu"+u"\u00E7"+"uens", "caracaraens", "caracaraiens", "caracolens",
"caraguataiens", "caraguatatubens", "caraibalens", "caraibeirens",
"caraibens", "caraibunens", "caraiens", "caraipens",
"caraivens", "carajaens", "carajazinhens", "carajuvens",
"carambeiens", "caramuruens", "caranaibens", "caranandinens",
"caranandubens", "carananens", "caranapatubens", "carandaiens",
"carandazalens", "caranens", "carangolens", "carapajoens",
"caraparuens", "carapebens", "carapebuens", "carapevens",
"carapicuibens", "carapiens", "carapinens", "carapoens",
"carapotoens", "caratacens", "caratatenens", "caratatinens",
"caratinguens", "caratuvens", "caravelens", "carazinhens",
"carbonitens", "carburant", "carcanhens", "carcassonens",
"carcavelens", "cardealens", "cardosens", "carea"+u"\u00E7"+"uens",
"careirens", "carent", "cariacens", "cariacicens",
"cariaciquens", "carib", "cariceens", "caridadens",
"carimanens", "carimataens", "carinhanhens", "carmens",
"carmesiens", "carmonens", "carmopoliens", "carnaibens",
"carnaubaens", "carnaubalens", "carnaubeirens", "carnaubens",
"carnaubinhens", "carneirens", "carneirinhens", "carnicens",
"carnobiens", "carnoioens", "caroarens", "carolinens",
"caroviens", "carpinens", "carquejens", "carranquens",
"carrapateirens", "carrapatens", "carrapatinhens", "carrapichelens",
"carrarens", "carrazedens", "carregadorens", "carregalens",
"carreirens", "cartaginens", "cartaxens", "cartomant",
"caruaens", "carualinens", "caruarens", "caruaruens",
"caruataiens", "carubinhens", "carumbeens", "carutaperens",
"caruzuens", "carvalhens", "carvoalens", "carvoalzinhens",
"carvoeirens", "casablanquens", "cascalens", "cascalheirens",
"cascalhens", "cascantens", "cascatens", "cascatinhens",
"cascavelens", "cascudens", "caseirens", "casevelens",
"casimirens", "casinhens", "casquens", "cassens",
"cassianens", "cassiens", "cassilandens", "cassilandiens",
"cassinens", "cassiteritens", "cassuens", "castanhalens",
"castanheirens", "castanhens", "castelandens", "castelandiens",
"castelens", "castelhanens", "castelinhens", "castilhens",
"castraleucens", "castrens", "casualidadens", "catabanens",
"cataguarinens", "cataguasens", "catalanens", "catanduvens",
"catanhedens", "catarens", "catarinens", "catauarens",
"catendens", "catequesens", "cateriangonguens", "catetens",
"catiarens", "catiboabens", "catiguaens", "catiguens",
"catimbauens", "catingalens", "catingueirens", "catinguens",
"catitens", "cativant", "catolandens", "catolandiens",
"catoleens", "catolezinhens", "catrimaniens", "catuanens",
"catu"+u"\u00E7"+"abens", "catuens", "catuipens", "catuleens",
"catulezinhens", "catumbiens", "catundens", "catuneens",
"catuniens", "catupiens", "caturaiens", "caturambens",
"caturamens", "caturiaens", "caturiteens", "caubiens",
"caucaiens", "cauipens", "caurens", "cavalcantens",
"cavaleirens", "cavalheirens", "cavalinens", "cavalinhens",
"cavaquens", "caveirens", "cavens", "caxambuens",
"caxanguens", "caxeens", "caxemirens", "caxiens",
"caxitoreens", "cazaqu", "cearens", "cebedens",
"ceboleirens", "ceciens", "cedralens", "cedreirens",
"cedrens", "cedrolandens", "cedrolandiens", "cefal"+u"\u00F3"+"pod",
"ceilonens", "celebrant", "c"+u"\u00E9"+"lebr", "celejens",
"celens", "celest", "celinens", "celoricens",
"celsens", "cemoabens", "centenariens", "centralens",
"centralinens", "centroavant", "ceraimens", "ceramicens",
"cercadens", "cercalens", "cerens", "cernachens",
"cerqueirens", "cerquilhens", "cerquinhens", "cerradinhens",
"cerrens", "cerritens", "cerveirens", "cervens",
"cervinhens", "cesariens", "cessant", "ceutens",
"chacarens", "chadiens", "chafarizens", "chaguens",
"chaleens", "chamejant", "champanhens", "chamusquens",
"chancens", "chapad"+u"\u00E3"+"ozens", "chapadens", "chapadinhens",
"chapecoens", "charqueadens", "charruens", "chavalens",
"chavens", "chaviens", "chef", "chegant",
"chelens", "chiadorens", "chiapetens", "chibant",
"chibens", "chilens", "chimarronens", "chiqu",
"chiqueirens", "chiquitens", "chocant", "choninens",
"chopinzinhens", "chor"+u"\u00E3"+"ozens", "choroens", "chorozinhens",
"chorrochoens", "chumbens", "chunens", "cianortens",
"cibaumens", "cicatrizant", "cicladens", "cidreirens",
"cient", "ciganens", "ciliciens", "cilopolandiens",
"cimbrens", "cinaniens", "cinfanens", "cintilant",
"cipoalens", "cipoens", "cipolandens", "circeens",
"circeiens", "circens", "circulant", "circundant",
"circunjacent", "circunstant", "cirtens", "cisneirens",
"cisteciens", "cisterciens", "citaniens", "cizicens",
"claraibens", "clarananens", "claravalens", "clarens",
"clariniens", "classicizant", "claudicant", "claudiens",
"clazomenens", "clementinens", "clevelandens", "client",
"cluniacens", "cluniens", "coadjuvant", "coariens",
"cobard", "cobrens", "cocaens", "cocalinhens",
"cocauens", "cochinchinens", "cochinens", "cocociens",
"codajacens", "codajaens", "codoens", "coeficient",
"coerent", "coexistent", "coimbrens", "coincident",
"coirens", "coiteens", "coivarens", "colant",
"colarens", "colatinens", "coleant", "colegiens",
"colident", "colimbriens", "colinens", "coliponens",
"colombens", "colombiens", "coloniens", "coloradens",
"colorant", "colossens", "colunens", "comanch",
"comandant", "comandatubens", "comanens", "combatent",
"combinadens", "comediant", "comendens", "comerciant",
"comerciens", "comercinhens", "cometens", "comodorens",
"comorens", "comovent", "comparecent", "competent",
"complacent", "complutens", "component", "comprovant",
"comunens", "comunicant", "comurens", "concei"+u"\u00E7"+u"\u00E3"+"onens",
"concei"+u"\u00E7"+u"\u00E3"+"ozens", "conceicionens", "concei"+u"\u00E7"+"oens", "concepcionens",
"concernent", "concertant", "conchalens", "conchens",
"concludent", "concomitant", "concordant", "concordiens",
"concorrent", "concupiscent", "condadens", "condeixens",
"condescendent", "condeubens", "condicionant", "condizent",
"condorens", "conducent", "conduruens", "conferent",
"confiant", "confident", "confinant", "confinens",
"conflitant", "confluent", "cong"+u"\u00EA"+"ner", "congolens",
"congonhalens", "congonhens", "congonhinhens", "congruent",
"conguens", "conimbricens", "conimbrigens", "conivent",
"conquistens", "conradens", "conscient", "consent",
"consequent", "conservant", "consistent", "consoant",
"consort", "constanciens", "constant", "constituint",
"contagens", "contagiant", "contaminant", "contendens",
"content", "contestadens", "continent", "contingent",
"contraent", "contrafort", "contramestr", "contraproducent",
"contrastant", "contratant", "contribuint", "contundent",
"convalescent", "convenient", "conventens", "convergent",
"convincent", "convivent", "cooperant", "copacabanens",
"copatanens", "copenhaguens", "copinalens", "coqueiralens",
"coqueirens", "coquens", "coquinhens", "corant",
"corcirens", "corcovadens", "cordeirens", "cordeiropolens",
"cordens", "cordiform", "cordijesuens", "cordilheirens",
"cordimariens", "cordisburguens", "cordislandens", "cordobens",
"cordofon", "coreauens", "coreens", "coremens",
"corfinens", "corfiniens", "corguinhens", "coribens",
"corinens", "coriniens", "corintens", "coriposens",
"coririens", "coriuvens", "corixens", "corjesuens",
"cormariens", "coroaciens", "coroadens", "coroataens",
"coroens", "coromandelens", "coronelens", "corredeirens",
"corregourens", "correguens", "corrent", "correntens",
"correntinens", "correntinhens", "correspondent", "cortant", "Cort",
"cortesens", "cortonens", "coruchens", "corumbaens",
"corumbaibens", "corumbataiens", "corupaens", "coruripens",
"coruscant", "corvens", "cosmopolens", "cosmoramens",
"cossurens", "costarricens", "costarriquens", "costens",
"cotaxeens", "cotejipens", "cotiens", "cotiporanens",
"courens", "coutens", "coutinhens", "covalent",
"covard", "covilhanens", "covilhens", "covoens",
"coxilhens", "coxinens", "craibens", "craolandens",
"craqu", "crastumiens", "cratens", "crateusens",
"cravinhens", "cravolandens", "cremens", "cremerens",
"cremonens", "crent", "crepitant", "crescent",
"cretens", "criciumalens", "criciumens", "crioulens",
"crisoliens", "crisolitens", "crisopolens", "cristalandens",
"cristalandiens", "cristalens", "cristaliens", "cristalinens",
"cristianopolens", "cristinens", "cristinopolens", "cristovens",
"critens", "criuvens", "crixaens", "crixalandens",
"crixalandiens", "crixasens", "croataens", "crocant",
"croiatens", "crominiens", "crotoniens", "cruanjiens",
"crubixaens", "cru"+u"\u00E7"+"aiens", "cru"+u"\u00E7"+"almens", "cruciant",
"crucilandens", "crucilandiens", "crustuminens", "cruxatiens",
"cruzaliens", "cruzaltens", "cruzeirens", "cruzeirinhens",
"cruzelandens", "cruzelandiens", "cruzens", "cruzetens",
"cruziliens", "cubatanens", "cubat"+u"\u00E3"+"ozens", "cubatens",
"cubatiens", "cubens", "cucuiens", "cuiabaens",
"cuiabens", "cuiambuquens", "cuiariens", "cuieirens",
"cuipiranguens", "cuiranens", "cuiteens", "cuitejiens",
"cuitezeirens", "culminant", "cumariens", "cumaruens",
"cumbens", "c"+u"\u00FA"+"mplic", "cumuruxatibens", "cunaniens",
"cundinamarquens", "cunduruens", "cunhambebens", "cunhanjiens",
"cunhens", "cunquens", "cuparaquens", "cupinens",
"cupirens", "cura"+u"\u00E7"+"aens", "curariaens", "curariens",
"curarizinhens", "curatiens", "curens", "curet",
"curicuriariens", "curimataens", "curimataiens", "curionopolens",
"curitibanens", "curitibens", "curitubens", "curiuvens",
"curralens", "curralinhens", "cursant", "curuaens",
"curuaiens", "curuataiens", "curucaens", "curu"+u"\u00E7"+"aens",
"curu"+u"\u00E7"+"ambabens", "curuens", "curumuens", "curupaens",
"curupaitiens", "curupirens", "cururipens", "cururupuens",
"curuzuens", "curvelens", "custodiens", "cutiens",
"cutilant", "cutiporanens", "dacarens", "damanens",
"dan"+u"\u00E7"+"ant", "debilitant", "debutant", "decadent",
"dec"+u"\u00E1"+"pod", "decent", "decepcionant", "declarant",
"declinant", "decliv", "decorrent", "decrescent",
"deferent", "deficient", "degradant", "deliberant",
"delinquent", "deliquescent", "delirant", "deltoid",
"demandant", "dement", "democratizant", "denunciant",
"dependent", "depoent", "depositant", "depriment",
"derribadinhens", "derrubadens", "desamparadens", "desarmant",
"desbordant", "descalvadens", "descampadens", "descansens",
"descarretens", "descendent", "descobertens", "desconcertant",
"descongestionant", "descontent", "descrent", "deselegant",
"desemboquens", "desencorajant", "desequilibrant", "desertens",
"desfigurant", "desfilant", "desfolhant", "desgastant",
"desideriens", "desidratant", "designiens", "desinfectant",
"desinfetant", "desinteressant", "deslizant", "deslumbrant",
"desobedient", "desodorant", "desolant", "desoxidant",
"despachant", "desparasitant", "despenhadens", "dessemelhant",
"destoant", "desviant", "desviens", "detectiv",
"detergent", "determinant", "detetiv", "detonant",
"devassant", "devorant", "diademens",
"dialogant", "diamantens", "diamantinens", "dianens",
"diasens", "dibionens", "diceriens", "diens",
"diferent", "dignificant", "dilacerant", "diletant",
"diligent", "diluent", "dimanant", "diniens",
"dinisiens", "diocleciens", "diodens", "diodorens",
"dioens", "diolandens", "dionisiens", "dioramens",
"diplost"+u"\u00EA"+"mon", "dirceuens", "dirigent", "diriment",
"discent", "discernent", "discordant", "discrepant",
"discriminant", "discursant", "disform", "displicent",
"disputant", "dissemelhant", "dissident", "dissolvent",
"dissonant", "distant", "diuens", "divagant",
"divalent", "divergent", "divinens", "divinesiens",
"divinolandens", "divionens", "divisens", "divisopolens",
"divitens", "djibutiens", "doberiens", "dobradens",
"dobradinhens", "doc", "docent", "doent", "doidejant",
"doiradens", "dolcinopolens", "dolearinens", "dolent",
"domeliens", "dominant", "domingadens", "dominguens",
"dominiquens", "dopant", "dorandiens", "dorens",
"dorilens", "dorizonens", "dorment", "dormidens",
"doudejant", "douradinhens", "douradoquarens", "dresdens",
"duartens", "duartinens", "dublinens", "duereens",
"dumiens", "dumontens", "dumontinens", "duobarrens",
"duocorreguens", "duplavilens", "d"+u"\u00FA"+"plic", "durandeens",
"duriens", "dutrens", "eandens", "ebaubens",
"eboracens", "eborens", "eburodunens", "echaporens",
"ecoporanguens", "edealinens", "edeens", "edeiens",
"edenens", "edificant", "edulcorant", "eferent",
"efervescent", "eficient", "efluent", "egesteniens",
"egidiens", "egiens", "eginens", "eginiens",
"egiptanens", "egiptens", "egitanens", "egitaniens",
"eirens", "eirunepeens", "elatens", "elbens",
"eldoradens", "eleens", "elegant", "elesbanens",
"elesbonens", "eletrens", "eleuteriens", "elidens",
"eliens", "elisiariens", "eloiens", "eloquent",
"elusens", "elvens", "ematubens", "emazens",
"embaraiens", "embiralens", "embiru"+u"\u00E7"+"uens", "emboabens",
"embriagant", "embuens", "embugua"+u"\u00E7"+"uens", "emburradens",
"emens", "emergent", "emeritens", "emidiens",
"emigrant", "emiliens", "eminent", "emitent",
"emocionant", "emolient", "emparedadens", "empestant",
"empo"+u"\u00E7"+"adens", "empolgant", "emulsionant", "encaixant",
"encantadens", "encantens", "encarnacionens", "enchentens",
"encruzilhadens", "endossant", "eneidens", "enemutuens",
"enens", "enervant", "enganens", "engenhens",
"engraxat", "eniens", "enorm", "enseadens",
"ensiform", "entebens", "entorpecent", "entradens",
"entredent", "entrefolhens", "entrement", "entrepeladens",
"entrerriens", "entroncamentens", "entusiasmant", "envirens",
"envolvent", "enxuens", "eordens", "epidamniens",
"epifanens", "epirens", "epitaciens", "eporens",
"equadorens", "equ"+u"\u00E2"+"nim", "equestr", "equetliens",
"equidistant", "equivalent", "erbessens", "ercavicens",
"erebanguens", "eremitens", "erereens", "eretriens",
"erexinens", "ergavicens", "ericeirens", "ermens",
"ermensidens", "ermesindens", "ermidens", "ernaginens",
"ernestinens", "errant", "ervalens", "ervaliens",
"erveirens", "esbravejant", "escadens", "escaldant",
"escalvadens", "escamiform", "escapant", "escapciens",
"escodrens", "escondidens", "escorchant", "escouralens",
"escrevent", "escurialens", "esfuziant", "esgotant",
"esmeraldens", "esmerilens", "esminens", "esnob",
"espectant", "espelhant", "esperancens", "esperantinens",
"esperens", "espessant", "espinescent", "espinhens",
"espinilhens", "espinosens", "espinozens", "esplanadens",
"esplendent", "espongitiens", "esponjitiens", "esposendens",
"espumant", "espumosens", "estabilizant", "estacadens",
"estacielens", "estadunidens", "estafant", "estalant",
"estanciens", "estandartens", "estarrejens", "estatizant",
"esteens", "estefaniens", "esteiens", "esteirens", "estep",
"esterilizant", "estilha"+u"\u00E7"+"ant", "estimulant", "estivens",
"estobens", "estonteant", "estorilens", "estradens",
"estratonicens", "estreant", "estrebuchant", "estreitens",
"estrelens", "estrem", "estremens", "estremocens",
"estremozens", "estrepitant", "estressant", "estrident",
"estrombiens", "estruturant", "estuant", "estudant",
"estupefacient", "esvoa"+u"\u00E7"+"ant", "et"+u"\u00ED"+"op", "eucariont",
"euclidens", "euromens", "eusebiens", "euxenitens",
"evanescent", "evangelistens", "evident", "exalant",
"exaltant", "exaporanens", "exasperant", "excedent",
"excelent", "excitant", "excludent", "excrescent",
"excruciant", "executant", "exercent", "exigent",
"existent", "exorbitant", "expectorant", "expedient",
"expeditens", "experient", "expirant",
"expoent", "exponent", "extasiant", "extenuant",
"extracionens", "extraterrestr", "extravagant", "extremens",
"exuberant", "exuens", "exultant", "ezequielens",
"fabiens", "fabricant", "fabricens", "fabricianens",
"facheant", "fadistens", "fafens", "fagulhant",
"fagundens", "faialens", "fainens", "faiscant",
"falant", "falciform", "falconiform", "faleriens",
"falerionens", "faltant", "famalicens", "famens",
"f"+u"\u00E3"+"ozens", "farejant", "farens", "farfalhant",
"fariens", "farinhens", "fariscant", "farnient",
"faroens", "farolens", "farpant", "farrapens",
"farroupilhens", "farsant", "farturens", "fascinant",
"fatigant", "fatimens", "faustianens", "faustiniens",
"favalens", "favaniens", "faveirens", "favoniens",
"faxinalens", "fazendens", "febricitant", "fecundant",
"feijoens", "feirant", "feirens", "feitoriens",
"feitosens", "felgarens", "felgueirens", "felicens",
"felipens", "felisburguens", "felixlandens", "felizens",
"feltriens", "felup", "fenaens", "fenicens",
"ferent", "ferentinens", "fermedens", "fermentelens",
"fernandopolens", "feroc", "ferrazens", "ferreirens",
"ferrens", "ferruginhens", "fertilizant", "fervedourens",
"fervent", "fervilhant", "ficant", "ficobiont",
"ficulens", "fidelandens", "fidelens", "figueirens",
"figueiroens", "figurant", "filadelfens", "filadelfiens",
"filant", "filipens", "filomeliens", "filomenens",
"filtrant", "finciens", "finens", "firmens",
"firminens", "fiss"+u"\u00ED"+"ped", "fixant", "flagelant",
"flageliform", "flagrant", "flamant", "flamejant",
"flamonens", "flamoniens", "flandrens", "flaviens",
"flechalens", "flecheirens", "flexeirens", "floraiens",
"floraliens", "floranens", "floraniens", "florarriquens",
"florealens", "florejant", "florencens", "florens",
"florent", "florentinens", "florescent", "florestalens",
"florestens", "florestinens", "florianens", "floridens",
"florineens", "florinens", "floriniens", "fluent",
"fluminens", "fluorescent", "flutuant", "foceens",
"focens", "folquens", "fondu", "font",
"fontourens", "foralens", "forens", "formigant",
"formigueirens", "formiguens", "formosens", "fornens",
"forquilhens", "forquilinhens", "fortalexiens", "fortalezens",
"fort", "fortens", "fortificant", "fortunens",
"foscoens", "fosfolipas", "fosfol"+u"\u00ED"+"pas", "fosfol"+u"\u00ED"+"pid",
"fosforescent", "fotossintetizant", "fradens", "fragosens",
"fragrant", "fraiburguens", "francens", "francisquens",
"franquens", "fraquejant", "fravasonens", "frecheirens",
"frecheirinhens", "freitens", "freixiens", "frement",
"frequent", "friburguens", "frisant", "frondent",
"fronteant", "fronteirens", "frustrant", "frutalens",
"fucens", "fugent", "fuldens", "fulgent",
"fulgurant", "fulminant", "fumant", "fumegant",
"funchalens", "funcionant", "fundanens", "fund"+u"\u00E3"+"ozens",
"fundens", "fundent", "fundonens", "f"+u"\u00FA"+"nebr",
"fungiform", "furant", "furent", "furfonens",
"furnens", "fusiform", "fustigant", "fuzilant",
"fuzilens", "gabiarrens", "gabiens", "gabirobens",
"gabonens", "gabrielens", "gadens", "gaguejant",
"gaiabalens", "gaiens", "gaivotens", "galant",
"galantens", "galdinens", "galeanens", "galenens",
"galens", "galheirens", "galiens", "galileens",
"galinens", "galinhens", "galopant", "galvanens",
"gamaleirens", "gambiens", "gamboens", "gameleirens",
"gamelens", "gamens", "ganchens", "gandariens",
"gandhiens", "gandrens", "ganduens", "ganens",
"gangorrens", "ganguens", "gantens", "garajubens",
"garanhuens", "garanhunens", "garapuavens",
"garapuens", "gararuens", "garcens", "garcezens",
"garciens", "gardeniens", "gardoniens", "gargantens",
"gargasiens", "gargauens", "garibaldens", "garibaldinens",
"garimpens", "garopabens", "garrafaens", "garrotens",
"garruchens", "garuvens", "gasparens", "gaspariens",
"gastr"+u"\u00F3"+"pod", "gatens", "gauchens", "gauerens",
"gaupoens", "gauramens", "gavianens", "gavionens",
"gazeens", "gazens", "gefirens", "gelens",
"gemelens", "gement", "genabens", "genebrens",
"generalizant", "generosens", "genovens", "genuens",
"genuinens", "geolandens", "geometrizant", "georginens",
"gerent", "germaniens", "geront", "gertrudens",
"gestant", "getulandens", "getuliens", "getulinens",
"gezehens", "gigant", "gigantens", "gilbueens",
"gilens", "girant", "girvasens", "glaucilandens",
"glaucilandiens", "glaurens", "glicerens", "gliceriens",
"globiform", "gloriens", "glorinhens", "gluciniens",
"godinens", "godoens", "godoiens", "goens",
"goiabalens", "goiabeirens", "goianaens", "goianasens",
"goiandirens", "goianens", "goianesiens", "goianiens",
"goianinhens", "goianirens", "goianortens", "goiasens",
"goiatinens", "goiatubens", "goiens", "goipabens",
"goitacasens", "goitaens", "goleganens", "golpeant",
"gon"+u"\u00E7"+"alens", "gon"+u"\u00E7"+"alvens", "gondidens", "gondirens",
"gondomarens", "gonfens", "gongojiens", "gonzaguens",
"goroboens", "gorutubens", "gotardens", "gotejant",
"goticizant", "goulartens", "gouveens", "governant",
"gracens", "graciens", "graciosens", "gra"+u"\u00E7"+"uiens",
"gradauens", "gradient", "grajauens", "gramachens",
"gramadens", "gramadinhens", "gramalens", "gramamens",
"gramens", "graminens", "graminhens", "granadens",
"granatens", "grand", "grandens", "grandiloquent",
"grandolens", "granitens", "granjeirens", "granjens",
"granzatens", "gratificant", "gravataens", "gravataiens",
"gravatalens", "grav", "gregoriens", "gremiens",
"grijoens", "grilant", "grilens", "grinincens",
"gritant", "groairens", "grogu", "grossens",
"grotanens", "grotens", "gruiform", "guabijuens",
"guabirabens", "guabirubens", "guachens", "guaciens",
"guacoceens", "gua"+u"\u00E7"+"uboiens", "gua"+u"\u00E7"+"uens", "gua"+u"\u00E7"+"uiens",
"guadalupens", "guaiacens", "guaianaens", "guaianasens",
"guaibens", "guaibinens", "guai"+u"\u00E7"+"arens", "guaicuiens",
"guaiens", "guaimbeens", "guaipavens", "guaiquicens",
"guairacaens", "guaira"+u"\u00E7"+"aens", "guairens", "guaiubens",
"guajaaens", "guajaraens", "guajaratubens", "guajaratubinhens",
"guajeruens", "guajuvirens", "guamaens", "guamaranguens",
"guamareens", "guampadens", "guanabarens", "guanaceens",
"guanambiens", "guananasens", "guanandiens", "guanduens",
"guanhanens", "guanumbiens", "guapeens", "guapia"+u"\u00E7"+"uens",
"guapiarens", "guapimiriens", "guapiramens", "guapiranguens",
"guapirens", "guapoens", "guaporanguens", "guaporeens",
"guaporemens", "guaporens", "guapuanens", "guarabirens",
"guara"+u"\u00E7"+"aiens", "guaraciabens", "guaraciamens", "guaraciens",
"guaraens", "guaraiens", "guaraipens", "guaraitubens",
"guarajiens", "guaramiranguens", "guaramiriens", "guaramirinens",
"guaranesiens", "guarania"+u"\u00E7"+"uens", "guaraniens", "guarant"+u"\u00E3"+"ens",
"guarantanens", "guarapariens", "guarapiranguens", "guarapuanens",
"guarapuavens", "guarapuavinhens", "guaraque"+u"\u00E7"+"abens", "guararaens",
"guararapens", "guararemens", "guararens", "guararuens",
"guarataiens", "guaratinguens", "guaratinguetaens", "guaratubens",
"guarauens", "guaraunens", "guaraverens", "guaraxainens",
"guardens", "guardinhens", "guareiens", "guarens",
"guaribens", "guaricanguens", "guariguariens", "guarinens",
"guariramanens", "guarirobens", "guaritens", "guarizinhens",
"guartelens", "guaruens", "guarujaens", "guarulhens",
"guataens", "guatambuens", "guataparaens", "guatemalens",
"guavirens", "guaxens", "guaxiens", "guaximens",
"guaxindibens", "guaxupeens", "guedens", "guianens",
"guidens", "guidovalens", "guiens", "guimaranens",
"guimaraniens", "guindant", "guineens", "guiomaens",
"guirapaens", "guiratinguens", "guiricemens", "guizalhant",
"gulosens", "gundens", "gundianens", "guraitubens",
"gurinhat"+u"\u00E3"+"ens", "gurinhatanens", "gurinheens", "gurinhenens",
"guriuens", "gurjanens", "gurj"+u"\u00E3"+"oens", "gurupaens",
"gurupiens", "guzolandens", "habitant", "halicarnassens",
"haliciens", "halidiens", "hamaniens", "hamburguens",
"hamondens", "haplost"+u"\u00EA"+"mon", "harmoniens", "havaiens",
"hebridens", "heimatens", "heitoraiens", "helenens",
"heliodorens", "heliopoliens", "helmodens", "helveciens",
"hematitens", "hemonens", "heracleens", "heracliens",
"herbitens", "herbulens", "herciniens", "herculandens",
"herculandiens", "herculanens", "herdoniens", "hereg",
"herviens", "hesitant", "hesp"+u"\u00E9"+"rid", "hexacord",
"hiant", "hibernant", "hiblens", "hidissens",
"hidratant", "hidrolandens", "hidrolinens", "hienipens",
"hierapolens", "hierolofiens", "hilariant", "hinterlandiens",
"hipoglicemiant", "hiponens", "hippi", "hipsodont",
"hispalens", "hispaliens", "hispaniens", "histoniens",
"holandens", "hollywoodens", "holmiens", "holofotens",
"homenageant", "homogeneizant", "homonadens", "homotransplant",
"hondurens", "horaciens", "horens", "horizontens",
"horizontinens", "hormens", "horripilant", "horrorens",
"horrorizant", "hortens", "hortolandens", "hortolandiens",
"h"+u"\u00F3"+"sped", "hospiciens", "host", "hostiens", "hostiliens",
"hotentot", "hugonapolens", "huguenot", "huitanaanens",
"humaitaens", "humbertuens", "humild", "humildens",
"iacaiaens", "iacanguens", "iaciarens", "iacriens",
"ia"+u"\u00E7"+"uens", "ianatamens", "iandareens", "ianqu",
"iapiens", "iapuens", "iaqu", "iaquiranens",
"iaramontens", "iarens", "iaripens", "iassens",
"iatecaens", "iatiens", "iauacanaens", "iauareteens",
"iaunariens", "iavaritens", "ibaitiens", "ibaramens",
"ibareens", "ibaretamens", "ibateens", "ibateguarens",
"ibatibens", "ibatuiens", "ibemens", "ibertioguens",
"ibia"+u"\u00E7"+"aens", "ibiaciens", "ibia"+u"\u00E7"+"uceens", "ibia"+u"\u00E7"+"uens",
"ibiaens", "ibiaguiens", "ibiaiens", "ibiajarens",
"ibianens", "ibiapabens", "ibiapinens", "ibiaporanens",
"ibiarens", "ibicabens", "ibicaraiens", "ibicareens",
"ibicatuens", "ibicuanens", "ibicuiens", "ibicuitabens",
"ibicuitinguens", "ibiens", "ibimirinens", "ibipebens",
"ibipetubens", "ibipetunens", "ibipirens", "ibipitanguens",
"ibiporanens", "ibiporanguens", "ibiquarens", "ibiquerens",
"ibirabens", "ibiracatuens", "ibiraciens", "ibira"+u"\u00E7"+"uens",
"ibiraens", "ibiraiarens", "ibirajaens", "ibirajubens",
"ibiramens", "ibiranguens", "ibiranhenens", "ibirapaens",
"ibirapitanguens", "ibirapu"+u"\u00E3"+"ens", "ibirapuitanens", "ibiraremens",
"ibirataiens", "ibiratinguens", "ibiriteens", "ibirocaiens",
"ibirubaens", "ibirubens", "ibitiarens", "ibitigua"+u"\u00E7"+"uens",
"ibitiguaiens", "ibitiguirens", "ibitinguens", "ibitiocens",
"ibitioquens", "ibitipocens", "ibitipoquens", "ibitiramens",
"ibitiranguens", "ibitirens", "ibitirunens", "ibititaens",
"ibitiurens", "ibitiuvens", "ibitubens", "ibituens",
"ibitunanens", "ibitupanens", "ibituporanguens", "ibiturunens",
"ibiunens", "iboens", "iborepiens", "ibotiramens",
"ibua"+u"\u00E7"+"uens", "ibugua"+u"\u00E7"+"uens", "icai"+u"\u00E7"+"arens", "icai"+u"\u00E7"+"arinhens",
"icapoaens", "icapuiens", "icaraiens", "icaraimens",
"icariens", "icatuens", "icemens", "icenens",
"icens", "icenzens", "icoens", "iconhens",
"iconiens", "icoraciens", "icozeirens", "icozinhens",
"idanhens", "idealens", "ideologizant", "idiolandens",
"idomenens", "iemenens", "ienisseens", "ienisseiens",
"iepeens", "iepens", "iersonens", "ietens",
"iga"+u"\u00E7"+"abens", "igaciens", "igapoens", "igaporanens",
"igara"+u"\u00E7"+"uens", "igaraiens", "igarapavens", "igarapebens",
"igarapeens", "igarassuens", "igarataens", "igaratens",
"igaratinguens", "igarauens", "igarens", "igariteens",
"igaroiens", "igatiens", "igatiquirens", "igatuens",
"ignorant", "igrapiunens", "igrejens", "igrejinhens",
"iguabens", "igua"+u"\u00E7"+"uens", "iguaens", "iguaibens",
"iguaiens", "igualdadens", "iguapens", "iguaraciens",
"iguara"+u"\u00E7"+"uens", "iguatamens", "iguatemiens", "iguatiens",
"iguatuens", "iguirens", "iguituens", "ijaciens",
"ijucapiramens", "ijuiens", "ildefonsens", "ilercaonens",
"ilerdens", "ilergavonens", "ilhabelens", "ilhavens",
"ilheens", "ilhenens", "ilheuens", "ilhotens",
"iliberitens", "ilicens", "iliciniens", "iliens",
"ilipens", "ilipulens", "iliturgens", "ilurconens",
"ilurgavonens", "iluronens", "ilustr", "imacarens",
"imaculadens", "imanent", "imaruiens", "imbarieens",
"imbaubens", "imbauvalens", "imbauzinhens", "imbeens",
"imbel", "imberb", "imbiru"+u"\u00E7"+"uens", "imbitubens",
"imbituvens", "imboiarens", "imbuens", "imbugua"+u"\u00E7"+"uens",
"imbuiens", "imbuirens", "imburanens", "imbuzalens",
"imigrant", "iminent", "imitant", "impacient",
"impactant", "impant", "impenitent", "imperant",
"imperatricens", "imperatrizens", "imperiens", "impermanent",
"impermeabilizant", "impersistent", "impertinent", "impetrant",
"implant", "implicant", "implorant", "imponent",
"important", "impotent", "impressionant", "imprevident",
"improcedent", "imprudent", "imp"+u"\u00FA"+"ber", "impudent",
"impun", "imun", "imunizant", "imunocompetent",
"imunodeficient", "inaciens", "inadimplent", "inajaens",
"inalant", "inambuens", "in"+u"\u00E2"+"nim", "inaparent",
"incandescent", "incapacitant", "incessant", "incident",
"incipient", "inclement", "incoerent", "inc"+u"\u00F3"+"lum",
"incombent", "incompetent", "inconcludent", "inconfidenciens",
"inconfident", "inconfidentens", "incongruent", "inconscient",
"inconsequent", "inconsistent", "inconstant", "incontinent",
"inconvenient", "indagant", "indaiabirens", "indaiaens",
"indaialens", "indaiatubens", "indaiens", "indecent",
"indeiscent", "independenciens", "independent", "indianopolens",
"indiaporanens", "indiarobens", "indiferent", "indigent",
"indignificant", "individualizant", "indolent", "indulgent",
"industrialens", "inebriant", "ineficient", "inerent",
"inerm", "inert", "inesens", "inexistent",
"inexperient", "infamant", "infam", "infant",
"infectant", "infestant", "influent", "informant",
"infren", "infringent", "ingaens", "ingazeirens",
"ingent", "ingratens", "ingredient", "ingressant",
"inhacoraens", "inhaiens", "inhambupens", "inhamunens",
"inhanduiens", "inhangapiens", "inhapiens", "inhapinens",
"inhapinhens", "inhataens", "inhatiunens", "inhaumens",
"inhobinens", "inhomirinens", "inhu"+u"\u00E7"+"uens", "inhumens",
"inhuporanguens", "iniciant", "inimatubens", "inimutabens",
"inoanens", "inobservant", "inocenciens", "inocent",
"inoens", "inoperant", "inquietant", "insalubr",
"inscient", "insign", "insignificant", "insinuant",
"insipient", "insistent", "insolent", "insolvent",
"inson", "instant", "instigant", "insubsistent",
"insuficient", "insultant", "insurgent", "intanens",
"integrant", "inteligent", "intemperant", "intendenciens",
"intendent", "interagent", "interamnens", "intercaciens",
"intercadent", "intercedent", "intercomunicant", "intercruzant",
"interdependent", "interessant", "interferent", "interfoliens",
"interlandens", "interlandiens", "intermitent", "int"+u"\u00E9"+"rpret",
"intervenient", "intolerant", "intoxicant", "intransigent",
"intrigant", "intumescent", "inubiens", "invaginant",
"invariant", "invernadens", "iogu", "iomereens",
"ionizant", "ipabens", "ipagua"+u"\u00E7"+"uens", "ipameriens",
"ipamorotiens", "ipandreens", "ipaneens", "ipanemens",
"ipangua"+u"\u00E7"+"uens", "ipaporanguens", "ipargens", "ipatinguens",
"ipau"+u"\u00E7"+"uens", "ipaumirinens", "ipaunens", "ipecaetaens",
"ipe"+u"\u00E7"+"uens", "ipeens", "ipeguens", "iperabens",
"iperoens", "ipeuatens", "ipeunens", "ipiabens",
"ipiauens", "ipiauiens", "ipiguaens", "ipiibens",
"ipiracens", "ipiraens", "ipiranguens", "ipiraquens",
"ipitanguens", "ipiunens", "ipixunens", "ipoemens",
"ipoiens", "ipojucens", "ipojuquens", "ipomeens",
"ipomeiens", "iporaens", "iporanens", "iporanguens",
"iporcens", "iprens", "ipua"+u"\u00E7"+"uens", "ipuanens",
"ipubiens", "ipu"+u"\u00E7"+"abens", "ipucens", "ipueirens",
"ipuens", "ipuiunens", "ipumirinens", "ipupiarens",
"ipuquens", "iracemapolens", "iracemens", "iraceminhens",
"iraciens", "iragua"+u"\u00E7"+"uens", "iraiens", "iraitiens",
"irajaens", "irajaiens", "irajubens", "iramaiens",
"iraniens", "irapeens", "iraporanguens", "irapuaens",
"irapuanens", "irapuens", "irapuiens", "irapuruens",
"iraput"+u"\u00E3"+"zens", "iraquarens", "iraquitanens", "iraraens",
"irarens", "iratamens", "iratiens", "iratinguens",
"irau"+u"\u00E7"+"ubens", "ireceens", "irereens", "iretamens",
"iriant", "iridescent", "iriens", "iriranens",
"iririens", "iririteuens", "iriritibens", "iritreens",
"iritreiens", "irituiens", "iroiens", "irradiant",
"irrelevant", "irreverent", "irritant", "irundiarens",
"irundiens", "irupiens", "isabelens", "isaiens",
"isidorens", "isindens", "isiodens", "isiondens",
"islandens", "isolant", "is"+u"\u00F3"+"pod", "is"+u"\u00F3"+"scel",
"isost"+u"\u00EA"+"mon", "isotransplant", "israelandens", "israelens",
"issens", "itaarens", "itabaianens", "itabaianinhens",
"itabapoanens", "itaberabens", "itaberaens", "itaberaiens",
"itaberens", "itabiens", "itabirens", "itabirinhens",
"itabiritens", "itabocens", "itaboquens", "itaboraiens",
"itabunens", "itacajaens", "itacambirens", "itacarambiens",
"itacareens", "itacatuens", "itacavens", "itacens",
"itaciens", "itaciramens", "itacoatiarens", "itacolomiens",
"ita"+u"\u00E7"+"uceens", "ita"+u"\u00E7"+"uens", "itacurubens", "itacuru"+u"\u00E7"+"aens",
"itaens", "itaeteens", "itagua"+u"\u00E7"+"uens", "itaguaens",
"itaguaiens", "itaguajeens", "itaguandibens", "itaguarens",
"itaguaruens", "itaguatinens", "itaguirens", "itaiacoquens",
"itaiaens", "itaianopolens", "itaibens", "itaiboens",
"itai"+u"\u00E7"+"abens", "itaiciens", "itaiens", "itaimbeens",
"itaimbezinhens", "itainens", "itainopolens", "itaiococens",
"itaioens", "itaiopolens", "itaipabens", "itaipavens",
"itaipeens", "itaipuens", "itaitubens", "itaituens",
"itaiubens", "itaiuens", "itaja"+u"\u00E7"+"uens", "itajaens",
"itajaiens", "itajarens", "itajibens", "itajiens",
"itajimirinens", "itajobiens", "itajubaens", "itajubaquarens",
"itajubatibens", "itajubens", "itajuens", "itajuipens",
"itajuruens", "itajutibens", "italegrens", "italicens",
"italvens", "itamanariens", "itamaracaens", "itamarajuens",
"itamarandibens", "itamarateens", "itamaratiens", "itamariens",
"itamataiens", "itambacuriens", "itambaracaens", "itambeens",
"itambiens", "itamirens", "itamirinens", "itamojiens",
"itamontens", "itamotiaguens", "itamuriens", "itanagrens",
"itanajeens", "itanens", "itanguaens", "itanhaenens",
"itanhaens", "itanhanduens", "itanheens", "itanhenens",
"itanhiens", "itanhomiens", "itaobinens", "itaocarens",
"itaocens", "itaoquens", "itapa"+u"\u00E7"+"arocens", "itapa"+u"\u00E7"+"aroquens",
"itapaciens", "itapacuraens", "itapajeens", "itapajipens",
"itapanhoacanguens", "itaparaens", "itaparicens", "itapariquens",
"itapebiens", "itapebu"+u"\u00E7"+"uens", "itapecericens", "itapeceriquens",
"itapecuruens", "itapecurumirinens", "itapeens", "itapeinens",
"itapeipuens", "itapejarens", "itapemens", "itapemirinens",
"itapequaens", "itaperens", "itaperiuens", "itaperunens",
"itapeteiuens", "itapetinens", "itapetinguens", "itapetinguiens",
"itapetininguens", "itapeuaens", "itapeunens", "itapevens",
"itapeviens", "itapi"+u"\u00E7"+"umens", "itapicuruens", "itapicurumirinens",
"itapinens", "itapinimens", "itapipocens", "itapipoquens",
"itapiranguens", "itapirapuanens", "itapiraremens", "itapirens",
"itapiru"+u"\u00E7"+"uens", "itapiruens", "itapirunens", "itapitocaiens",
"itapiunens", "itapixeens", "itapixunens", "itapoaens",
"itapoens", "itapolens", "itaporanens", "itaporanguens",
"itaporeens", "itapororocens", "itapororoquens", "itapuanens",
"itapucens", "itapucuens", "itapulens", "itapuquens",
"itapuranguens", "itapurens", "itaquaens", "itaquaquecetubens",
"itaquaraiens", "itaquarens", "itaquariens", "itaquatiarens",
"itaquerens", "itaquiens", "itaquirens", "itaquitinguens",
"itaranens", "itarantinens", "itarareens", "itaremens",
"itaririens", "itaroqueens", "itaroquenens", "itarumanens",
"itarumens", "itassuceens", "itataens", "itatiaiens",
"itatiaiu"+u"\u00E7"+"uens", "itatibens", "itatiens", "itatinens",
"itatinguens", "itatinguiens", "itatirens", "itatubens",
"itatupanens", "itaubelens", "itaubens", "itau"+u"\u00E7"+"uens",
"itaueirens", "itauens", "itaunens", "itauninhens",
"itauzens", "itaveraens", "itaveravens", "itaxamens",
"iterereens", "itibirens", "itinerant", "itinguens",
"itiquirens", "itirapinens", "itirapuanens", "itirens",
"itiru"+u"\u00E7"+"uens", "itiubens", "itiucens", "itiuquens",
"itobiens", "itororoens", "itoupavens", "itua"+u"\u00E7"+"uens",
"ituberaens", "ituens", "ituetens", "itugua"+u"\u00E7"+"uens",
"ituiens", "ituinens", "ituiutabens", "itumbiarens",
"itumirinens", "itupararanguens", "itupavens", "itupevens",
"itupiranguens", "ituporanguens", "ituquiens", "ituramens",
"itutinguens", "ituveravens", "iuaens", "iubatinguens",
"iucaiens", "iucatanens", "iuiraens", "iuiteporanens",
"iuiuens", "iunens", "iuniens", "iunzens",
"iupebens", "iuruens", "iuticens", "iutiquens",
"ivaiens", "ivaiporanens", "ivaitinguens", "ivatens",
"ivatubens", "ivinheimens", "ivitiens", "ivoiriens",
"ivolandens", "ivoraens", "ivotiens", "ixuens",
"ixuzinhens", "izarens", "jabaeteens", "jabaquarens",
"jabitacaens", "jaboatanens", "jaboat"+u"\u00E3"+"ozens", "jaboraens",
"jaborandiens", "jaboticabalens", "jabotiens", "jaburizinhens",
"jaburuens", "jaburunens", "jabuticabalens", "jabuticabeirens",
"jabuticabens", "jabuticatubens", "jabutiens", "jacamaens",
"jacampariens", "ja"+u"\u00E7"+"anens", "jacaquaens", "jacaraciens",
"jacaraipens", "jacarandaens", "jacarandirens", "jacarauens",
"jacareacanguens", "jacarecicens", "jacareciens", "jacareciquens",
"jacareens", "jacareiens", "jacarequarens", "jacaretinguens",
"jacarezinhens", "jacatanens", "jacaunens", "jaceabens",
"jacent", "jacerendiens", "jacerubens", "jaciabens",
"jaciarens", "jaciens", "jaciguaens", "jacintens",
"jaciobens", "jaciparanaens", "jaciporanens", "jaciremens",
"jacitarens", "jacksoniens", "jacobinens", "jaconeens",
"jacruaruens", "jacsoniens", "jacubens", "jacuecanguens",
"jacuens", "jacuiens", "jacuipens", "jacuizinhens",
"jacumanens", "jacundaens", "jacundazinhens", "jacupembens",
"jacupiranguens", "jacuriciens", "jacuriens", "jacurunens",
"jacururuens", "jacurutuens", "jacutinguens", "jadibaruens",
"jaeteuens", "jafens", "jagod", "jaguapitanens",
"jaguaquarens", "jaguaraciens", "jaguara"+u"\u00E7"+"uens", "jaguaraens",
"jaguaranens", "jaguarariens", "jaguareens", "jaguarembeens",
"jaguarens", "jaguaretamens", "jaguariaivens", "jaguaribarens",
"jaguaribens", "jaguaricatuens", "jaguariens", "jaguarinhens",
"jaguaripens", "jaguaritens", "jaguaritirens", "jaguariunens",
"jaguaronens", "jaguaruanens", "jaguarunens", "jaguatiricens",
"jaguatiriquens", "jaibarens", "jaibens", "jaicoens",
"jald", "jalens", "jalesens", "jamacaruens",
"jamaicens", "jamaparaens", "jamaparens", "jamariens",
"jamaxinzinhens", "jambeirens", "jambruquens", "jambua"+u"\u00E7"+"uens",
"jamprucens", "jampruquens", "janaubens", "jandaiens",
"jandairens", "jandirens", "jandiritiuens", "janduiens",
"janduissens", "jangadens", "janguens", "jansenens",
"jantant", "januarens", "januariens", "japaraibens",
"japaratinguens", "japaratubens", "japecanguens", "japeinens",
"japericens", "japeriens", "japeriquens", "japiens",
"japiinens", "japiinzens", "japirens", "japiubens",
"japoatanens", "japonens", "japuatanens", "japueens",
"japuens", "japuibens", "japumirinens", "japuraens",
"jaqueirens", "jaquiranens", "jaracatiaens", "jaraguaens",
"jaraguariens", "jaraguens", "jaramataiens", "jaraquiens",
"jararacens", "jararaquens", "jardimirinens", "jardineirens",
"jardinens", "jardinesiens", "jardinopolens", "jariens",
"jarinuens", "jarmelens", "jarudorens", "jaruens",
"jassens", "jataiens", "jataizinhens", "jataubens",
"jatiens", "jatimanens", "jatiucens", "jatiuquens",
"jatobaens", "jatobalens", "jatobazinhens", "jatuaranens",
"jauarauens", "jauariens", "jauatoens", "jaudilandens",
"jaudilandiens", "jauens", "jaupaciens", "jauquarens",
"jauruens", "jauzinhens", "javariens", "javens",
"jazent", "jeceabens", "jeitosens", "jejuiens",
"jenipabuens", "jenipapeirens", "jenipapens", "jenipaubens",
"jequeriens", "jequieens", "jequiens", "jequiezinhens",
"jequiri"+u"\u00E7"+"aens", "jequiricens", "jequitaiens", "jequitibaens",
"jequitinhonhens", "jeremiens", "jeremoabens", "jeremunens",
"jeremunzens", "jererauens", "jeria"+u"\u00E7"+"uens", "jeribaens",
"jeribatubens", "jericoaquarens", "jericoens", "jerimatalhens",
"jeriquaquarens", "jeriquarens", "jeritacoens", "jerivaens",
"jeroaquarens", "jeromenhens", "jeronimens", "jersonens",
"jeruens", "jerumenhens", "jerumirinens", "jesuanens",
"jesuaniens", "jesuens", "jesuitens", "jetens",
"jetibaens", "jiboiens", "jijuens", "jiloens",
"jinimbuens", "jiparanaens", "jipubens", "jiquiri"+u"\u00E7"+"aens",
"jiquitaiens", "jirauens", "jiribatubens", "jiruaens",
"jiruens", "jitaunens", "jitiranens", "joa"+u"\u00E7"+"abens",
"joa"+u"\u00E7"+"ubens", "joaimens", "joan", "joanens",
"joanesens", "joanesiens", "joanetens", "joanicens",
"joaninens", "joanopolens", "joaquimens", "joaquinens",
"joarizinhens", "joatubens", "joeiranens", "joiens",
"joinvilens", "jojocens", "jojoquens", "joniens",
"jordanens", "jordaniens", "jord"+u"\u00E3"+"ozinhens", "jorgens",
"joseens", "josefens", "joselandens", "joselandiens",
"jovianiens", "juabens", "jua"+u"\u00E7"+"abens", "juacemens",
"juaciens", "juaens", "juatamens", "juatubens",
"juazeirens", "juazeirinhens", "juazens", "jubaiens",
"jubilant", "jubirens", "jucaens", "ju"+u"\u00E7"+"aralens",
"ju"+u"\u00E7"+"arens", "ju"+u"\u00E7"+"ariens", "jucatiens", "juciapens",
"jucuens", "jucumanens", "jucumpemens", "jucuru"+u"\u00E7"+"uens",
"jucururiens", "jucururuens", "jucurutuens", "judaizant",
"jueranens", "juira"+u"\u00E7"+"uens", "julianens", "julianiens",
"juliens", "juliobrigens", "jumens", "jumirinens",
"juncens", "juncionens", "jundiaens", "jundiaiens",
"jundiapebens", "junens", "junqueirens", "junqueiropolens",
"junquens", "jupaguaens", "juparens", "juparitenens",
"jupiaens", "jupiens", "jupiranguens", "juquiaens",
"juquiquerens", "juquiratibens", "juquitibens", "juraciens",
"juramentens", "jurandens", "jurapaitens", "juraraens",
"jureens", "juremalens", "juremens", "juriciens",
"juripiranguens", "juritianhens", "juritiens", "juruaens",
"juruaiens", "jurubebens", "juruceens", "juruenens",
"juruens", "jurumiriens", "jurupariens", "jurupebens",
"jurupemens", "jurutiens", "juruvalhens", "juscelandens",
"juscelandiens", "juscelinens", "jutaiens", "juticens",
"jutiens", "jutiquens", "jutlandens", "jutlandiens",
"juturnaibens", "juvenciens", "juventinens", "labreens",
"lacens", "lacerant", "lacerdens", "laciens",
"laciniens", "lacobricens", "lacobrigens", "lacrimejant",
"lactant", "lactent", "lacustr", "lacustrens",
"ladainhens", "ladarens", "ladariens", "ladeirens",
"laetiens", "lafaietens", "lafonens", "lagamarens",
"lagartens", "lagoadens", "lagoanens", "lagoens",
"lagoinhens", "lagonens", "lag"+u"\u00F3"+"pod", "laguens",
"laguinhens", "lagunens", "lagunitens", "lajeadens",
"lajeadinhens", "lajed"+u"\u00E3"+"oens", "lajedens", "lajedinhens",
"lajedonens", "lajeirens", "lajens", "lajiens",
"lajinhens", "lalimens", "lamaronens", "lambariens",
"lambasens", "lambedorens", "lambedourens", "lambesens",
"lamecens", "lameirens", "laminens", "lamounierens",
"lampejant", "l"+u"\u00E2"+"mur", "lan"+u"\u00E7"+"ant", "lanciens",
"lancinant", "landrinopolens", "langu", "languipnens",
"lanhadens", "lanhelens", "lanhonens", "lanhosens",
"lantejoulant", "lantunens", "lanuens", "laodicens",
"laosens", "laozens", "lapelens", "lapens",
"lapinhens", "laplatens", "laponenens", "lapurdens",
"laranjaiens", "laranjalens", "laranjeirens", "larens",
"larguens", "larissens", "larnens", "lassancens",
"lastrens", "latejant", "latent", "lateranens",
"latoratens", "laurbanens", "laurentinens", "lausanens",
"lausperen", "lavagant", "lavinens", "laviniens",
"lavourens", "lavrant", "lavrens", "lavrinhens",
"laxant", "leandrens", "leblonens", "legent",
"legorn", "leiriens", "leitens", "leixonens",
"lemens", "lemniens", "lemovicens", "lenciens",
"len"+u"\u00E7"+"oens", "len"+u"\u00E7"+"oiens", "len"+u"\u00E7"+"olens", "lentiens",
"leodiens", "leonicens", "leopoldens", "leopoldinens",
"leopolens", "leptimagnens", "lesotens", "levalloisens",
"levaloisens", "levergerens", "levinopolens", "libarnens",
"liberalizant", "liberatens", "liberdanens", "libertens",
"libriform", "licitant", "licuriens", "lidianopolens",
"lidiens", "liechtensteinens", "liechtensteiniens", "ligant",
"l"+u"\u00ED"+"gur", "limarens", "limeirens", "limiens",
"limitant", "lim"+u"\u00ED"+"trof", "limoeirens", "lind",
"lindoestens", "lindoiens", "linens", "linharens",
"liparens", "lipsiens", "liquidant", "lirinens",
"lisbonens", "lisimaquiens", "litigant", "litisconsort",
"lituaniens", "livramentens", "lixiviant", "lizardens",
"loandens", "lobatens", "lobelens", "lobens",
"locrens", "loirejant", "lombardiens", "londinens",
"londoniens", "londrinens", "longaens", "lontrens",
"lordelens", "lorenens", "loretens", "loronens",
"lourdens", "lourencens", "lourens", "lourinhanens",
"lourinhanhens", "lousadens", "lousanens", "lousonens",
"louveirens", "lovaniens", "luandens", "lubiens",
"lubrificant", "lucaiens", "lucelburgens", "luceliens",
"lucenens", "lucens", "lucerens", "lucianopolens",
"lucilant", "lucoferonens", "lucrinens", "ludovicens",
"lufens", "lugdunens", "l"+u"\u00FA"+"gubr", "luisburguens",
"luisens", "luisianens", "luisianiens", "luizens",
"lumbricoid", "lumiarens", "luminariens", "luminescent",
"luminosens", "lundens", "lupercens", "luperciens",
"lupiens", "lupinopolens", "luquens", "lursens",
"lusitaniens", "lustosens", "luteciens", "luxemburguens",
"luxoviens", "luxuriant", "luzens", "luzent",
"luzernens", "luzianens", "luzianiens", "luziens",
"luzilandens", "luzilandiens", "mabens", "mabideriens",
"macabuens", "macabuzinhens", "ma"+u"\u00E7"+"acaraens", "macaeens",
"macaens", "ma"+u"\u00E7"+"aens", "macaibens", "macaiens",
"macajatubens", "macajubens", "macambirens", "macanareens",
"ma"+u"\u00E7"+"ant", "macaocens", "macaoquens", "macapaens",
"macaparanens", "macapuanens", "macaquens", "macaraniens",
"macarauens", "macarens", "macataens", "macatubens",
"macauariens", "macaubalens", "macaubens", "macauens",
"macedens", "macedinens", "macedoniens", "maceioens",
"machacaliens", "machacalizens", "machadens", "machadiens",
"machadinhens", "machiquens", "machorrens", "macieirens",
"macielens", "macond", "macronutrient", "macucens",
"macuens", "macuinens", "macujeens", "macupinens",
"macuquens", "macuripariens", "macurureens", "macuxixiriens",
"madagascarens", "madailens", "madalenens", "madeirens",
"madiens", "madragoens", "madrilens", "madureirens",
"maetinguens", "mafrens", "mafrensens", "magalhens",
"magdalenens", "magdens", "mageens", "magnat",
"magnet", "magnificent", "maguariens", "maiauataens",
"maiens", "maiobens", "maiquiniquens", "mairiens",
"mairiporanens", "mairipotabens", "majeens", "majorens",
"majorlandens", "majorlandiens", "majurianens", "malabarens",
"malacachetens", "malaquiens", "malaripens", "malauiens",
"maldivens", "maldizent", "maledicent", "maletens",
"malgax", "malhadens", "malhadorens", "maliciens",
"maliens", "malinens", "malletens", "malocens",
"maloquens", "maltens", "maluens", "malvinens",
"mamanacaraiens", "mamanguapens", "mambaiens", "mambemb",
"mamboreens", "mambucabens", "mambuquens", "mamedens",
"mamens", "mamiaens", "mamoeirens", "mamonens",
"mamoriaens", "mamparrens", "manacaens", "manacapuruens",
"managuens", "manairens", "manaquiriens", "manariens",
"manauens", "manda"+u"\u00E7"+"aiens", "mandacaruens", "mandagua"+u"\u00E7"+"uens",
"mandaguariens", "mandant", "mandembens", "mandiquiens",
"mandiritubens", "mandirobens", "mandiuens", "mandivens",
"manducens", "manduquens", "manduriens", "mangabeirens",
"mangabens", "mangalens", "mangaraiens", "mangarataiens",
"mangaratibens", "mangaratuens", "mangualdens", "manguariens",
"mangueirens", "mangueirinhens", "manguens", "manguinhens",
"manguncens", "manhanens", "manhua"+u"\u00E7"+"uens", "manhumirinens",
"mania"+u"\u00E7"+"uens", "manicens", "mani"+u"\u00E7"+"obens", "manicoreens",
"manifestant", "manimbuens", "manitubens", "manivens",
"mansens", "mansid"+u"\u00E3"+"oens", "mansinhens", "mansuetudinens",
"manteiguens", "mantenens", "manteniens", "mantenopolens",
"mapanens", "mapangapens", "mapiaens", "mapirenens",
"mapixiens", "mapuaens", "maquineens", "mara"+u"\u00E3"+"ens",
"maraanens", "mara"+u"\u00E3"+"zens", "marabaens", "maraca"+u"\u00E7"+"umeens",
"maracaens", "maracaiens", "maracajaens", "maracajauens",
"maracajuens", "maracananens", "maracanauens", "maracanens",
"maracasens", "maracatubens", "maracoeirens", "maracujaens",
"maragogiens", "maragojiens", "maragojipens", "maragojipinhens",
"maraguaens", "maraialens", "marajaens", "marajoarens",
"marajoens", "marambainhens", "marangatuens", "maranguapens",
"maranhens", "marapaniens", "marapaninens", "marapeens",
"marapuamens", "marariens", "mararupaens", "marataens",
"marataizens", "marauaens", "marauens", "marav",
"maravilhens", "marcant", "marcelandens", "marcelens",
"marcelinens", "marcens", "marcescent", "marchant",
"marcoens", "marcolinens", "marcondens", "marcondesiens",
"marcosiens", "marcuens", "mareant", "maremens",
"maresiens", "marfinens", "margaridens", "marialvens",
"marianens", "mariantens", "mariapolens", "maribondens",
"maricaens", "maricoabens", "mariens", "marientalens",
"marilacens", "marilandens", "marilandiens", "marilenens",
"marilens", "mariliens", "mariluzens", "marimbens",
"marimbondens", "marinens", "maringaens", "marinheirens",
"marinhens", "marinopolens", "maripaens", "mariquitens",
"mariricuens", "maristelens", "maritubens", "marizens",
"marlieriens", "marmelandens", "marmelandiens", "marmelarens",
"marmeleirens", "marmelens", "marojalens", "marombens",
"marotens", "marovens", "marquens", "marquinhens",
"marrequens", "marroquens", "marruaens", "martinens",
"martinesiens", "martinhens", "martinopolens", "martiriens",
"maruanunens", "marudaens", "maruinens", "marumbiens",
"marupiarens", "marvanens", "marzaganens", "marzaganiens",
"marzagonens", "mascotens", "massapeens", "massarelens",
"massiliens", "massilitanens", "mastaurens", "matabel",
"matanens", "matapajipens", "matapiens", "matapiquarens",
"mataracens", "matarandibens", "mataraquens", "mataripens",
"mataripuanens", "mateens", "mateirens", "matens",
"materlandens", "matiens", "matildens", "matinens",
"matinhens", "matintinens", "matipoens", "matoens",
"matonens", "matoqueimadens", "matosinhens", "matotuiens",
"matozinhens", "matrinxaens", "matritens", "matuens",
"matupaens", "maturucens", "maturuquens", "matutinens",
"mauaens", "maueens", "mauens", "mauesens",
"mauriens", "mauritiens", "maustrarens", "maxacalens",
"maxacaliens", "maxaranguapens", "maximens", "mazaganens",
"mazagonens", "mealhadens", "mearinens", "mecejanens",
"medeirens", "medens", "medianeirens", "medicilandens",
"medievalizant", "medinens", "med"+u"\u00ED"+"ocr", "mediolanens",
"mediquens", "meditacionens", "medubrigens", "meens",
"megarens", "meladens", "meladinhens", "melanciens",
"melariens", "meldens", "meleirens", "melens",
"melgacens", "meliant", "melibeens", "melissens",
"melitens", "melosens", "melquiadens", "memoriens",
"mencheviqu", "mendac", "mendanhens", "mendens",
"mendesens", "mendicant", "mendoncens", "mercant",
"mercedens", "mercesens", "mergulhant", "meridens",
"meridianens", "merirumanens", "meritiens", "merobrigens",
"mertolens", "meruocens", "meruoquens", "mesquitens",
"messanens", "messiens", "messinens", "metalinens",
"metaurens", "metelandens", "metens", "metuapirens",
"mevanionens", "mianmarens", "micaelens", "micenens",
"micuiens", "migrant", "miguelens", "miguelopens",
"milagrens", "milanens", "milasens", "milfontens",
"milharens", "mil"+u"\u00ED"+"ped", "militant", "milliarens",
"mimosens", "mindens", "minduriens", "mineirens",
"mineirolandens", "minens", "minervens", "minodunens",
"minoens", "minorens", "minturnens", "m"+u"\u00ED"+"op",
"mipibuens", "mirabelens", "mirabolant", "miracatuens",
"miracemens", "miracicens", "miraciquens", "miradorens",
"miradourens", "miragaiens", "miraginens", "miraguaiens",
"miraiens", "miraimens", "miraltens", "miralucens",
"miraluzens", "miramantens", "mirambeens", "mirandelens",
"mirandens", "mirandibens", "mirandopolens", "mirangabens",
"miranguens", "mirantens", "mirantonens", "mirapinimens",
"miraporanguens", "mirariens", "mirasselvens", "mirassolandens",
"mirassolens", "mirens", "miri"+u"\u00E1"+"pod", "mirinens",
"mirinzalens", "miritiens", "miritizalens", "miritubens",
"mirizalens", "mirobrigens", "miroroens", "misenens",
"misericordiens", "missionariens", "missionens", "mit",
"mitilenens", "mitilens", "miudezens", "moacirens",
"m"+u"\u00F3"+"bil", "mobralens", "mocajubens", "mocambeirens",
"mocambens", "mocambinhens", "mo"+u"\u00E7"+"ambiquens", "mo"+u"\u00E7"+u"\u00E2"+"med",
"mo"+u"\u00E7"+"amedens", "mo"+u"\u00E7"+u"\u00E1"+"rab", "mococens", "mocoens",
"mocoquens", "mocotoens", "modelens", "modenens",
"modernens", "modernizant", "modestens", "moedens",
"moemens", "moendens", "mogadourens", "mogeirens",
"mogonciacens", "moibandens", "moimentens", "moinant",
"moinhens", "moiporaens", "moirabens", "moitens",
"moitinhens", "mojeirens", "mojigua"+u"\u00E7"+"uens", "mojigui"+u"\u00E7"+"abens",
"mojimirinens", "mojuens", "mojutaperens", "mol",
"molequens", "molheirens", "molhens", "moloquens",
"molumbens", "momanaens", "momatens", "mombacens",
"mombejens", "mombucens", "mombuquens", "mon"+u"\u00E7"+"anens",
"monchiquens", "moncionens", "mon"+u"\u00E7"+"onens", "moncorvens",
"mondaiens", "mond", "mondeguens", "mondinens",
"mondubinens", "moneraens", "monerens", "monetens",
"monfortens", "mongaguaens", "mongubens", "monicens",
"monjolandens", "monjolens", "monjoliens", "monsanens",
"montalegrens", "montalvanens", "montalvaniens", "montanhens",
"montant", "montargilens", "montauriens", "monteirens",
"montemorens", "montenegrens", "montens", "montesens",
"montevideuens", "montezumens", "montijens", "montmartrens",
"montoitens", "montrealens", "monumentens", "moquenzens",
"moradens", "moralens", "morangabens", "moraujens",
"morceguens", "mordent", "moreirens", "morenens",
"morens", "morgantens", "moriruens", "mormacens",
"mororoens", "morparaens", "mortaguens", "mortugabens",
"morumbiens", "morungabens", "morungavens", "mosqueirens",
"mossoroens", "mostardens", "mosteirens", "motens",
"motiens", "motivant", "mouranens", "mourens",
"mouronens", "mousteriens", "movent", "movimentens",
"moxotoens", "mozarlandens", "mozarlandiens", "mozondoens",
"muanaens", "muanens", "mucajaens", "mucajaiens",
"mucambens", "mucuens", "mucujeens", "mucuratens",
"mucuriciens", "mucuriens", "mucuripens", "mudancens",
"mudanciens", "muiraneuens", "muladens", "mulatens",
"muliternens", "multiform", "multiplex", "mult"+u"\u00ED"+"plic",
"multirresistent", "mulunguens", "mumbabens", "mumbucens",
"mumbuquens", "mumificant", "mundauens", "munduriens",
"mundurucuens", "mungubens", "munhozens", "municipalens",
"mun"+u"\u00ED"+"cip", "muniens", "muniquens", "muqui"+u"\u00E7"+"abens",
"muquiens", "murajaens", "murcens", "murens",
"muriaeens", "muribecens", "muribequens", "muriciens",
"muricizalens", "muri"+u"\u00E7"+"oquens", "muriens", "muritibens",
"muritiens", "muriuens", "murmurant", "murmurejant",
"murtinhens", "murtosens", "murucupiens", "murunduens",
"murupeens", "mururuens", "murutinguens", "musticens",
"mustierens", "mutaens", "mutambeirens", "mutambens",
"mutanens", "mutant", "mut"+u"\u00E3"+"zens", "muticens",
"mutinens", "mutucens", "mutucumens", "mutuens",
"mutuipens", "mutumparanaens", "mutunens", "mutunzens",
"mutuquens", "muzambinhens", "myanmens", "nabuquens",
"nacamurens", "nacipens", "nadant", "nadens",
"nagadiens", "najeens", "nantens", "nanuquens",
"napocens", "naquens", "narandibens", "naraniuens",
"narbonens", "narcotraficant", "narniens", "narrant",
"naruens", "nascenciens", "nascent", "nascentens",
"nassadens", "natalens", "natant", "naterciens",
"natinguiens", "nativens", "natividadens", "natividens",
"nativitatens", "natubens", "nauariens", "nauruens",
"nauseant", "navarrens", "navegant", "navegantens",
"naviens", "naviraiens", "nazareens", "nazarenens",
"nazarezinhens", "nazariens", "neandertalens", "neblinant",
"necromant", "neerlandens", "negerens", "negligent",
"negociant", "negr"+u"\u00E3"+"oens", "negrejant", "negrens",
"negromant", "nelens", "nemausens", "nemausiens",
"nemetacens", "nemetens", "nemorens", "neocomiens",
"neocrucens", "neoerens", "neolimens", "neorresendens",
"neorrussens", "neossantarenens", "neossourens", "neozelandens",
"neozelandiens", "nepalens", "nepanens", "nepomucenens",
"neriens", "neropolens", "nertobrigens", "nerulonens",
"nescaniens", "netinens", "neustriens", "nevens",
"nhambiquarens", "nhamundaens", "nhandearens", "nhandutibens",
"nhecolandens", "nhecolandiens", "nhonhepens", "nhungua"+u"\u00E7"+"uens",
"nicaraguens", "niceens", "nicens", "niciens",
"nicolandens", "nicolandiens", "nicolauens", "nicomedens",
"nidificant", "nigerens", "nigromant", "nilens",
"nioaquens", "nipoanens", "nipoens", "niponens",
"niquelandens", "niquelandiens", "nisens", "nitent",
"niteroiens", "nitrificant", "nivernens", "nizens",
"nobilitant", "nobr", "nogueirens", "nolens",
"n"+u"\u00F4"+"mad", "nonatens", "nonoaiens", "nonsens",
"norbanens", "norbens", "nordestens", "nordestinens",
"norens", "noronhens", "nortelandens", "nortelandiens",
"nortens", "northamptonens", "norueguens", "novalens",
"novariens", "novens", "novilhonens", "novocomens",
"nubent", "nubiens", "nugua"+u"\u00E7"+"uens", "numiniens",
"nupebens", "nuporanguens", "nutrient", "oacariens",
"oasiens", "obdiplost"+u"\u00EA"+"mon", "obedient", "obidens",
"objetivant", "obrant", "obsedant", "obsediant",
"observant", "obstant", "obulconens", "ocarens",
"ocau"+u"\u00E7"+"uens", "oceaniens", "ocelens", "ocidentalizant",
"ocidentens", "ocorrent", "ocr", "octodurens",
"ocultens", "ocunens", "ocupant", "odemirens",
"odivelens", "odorant", "oduciens", "oeirens",
"oestens", "ofegant", "oferent", "ofertant",
"oficiant", "oficinens", "ofuscant", "oiapoquens",
"oiteirens", "oitiuens", "oitizeirens", "olariens",
"olarionens", "olbiens", "olbonens", "oleastrens",
"oleens", "olegariens", "oleirens", "olent",
"olhanens", "olifant", "oligost"+u"\u00EA"+"mon", "olimpens",
"olimpiens", "olindens", "olindinens", "olisiponens",
"olissiponens", "olivalens", "olivedens", "oliveirens",
"olivencens", "olivenciens", "olivens", "oliviens",
"omanens", "omelet", "omnipotent", "omniscient",
"oncens", "ondeant", "ondinens", "ondulant",
"onens", "onhens", "onipotent", "onipresent",
"oniscient", "onofrens", "onubens", "operant",
"opinant", "oponent", "optant", "oradens",
"oratoriens", "or"+u"\u00E7"+"ant", "ordinarot", "ordoviciens",
"oricoens", "orientalens", "orient", "orientens",
"orindiuvens", "oriolens", "orionens", "oriximinaens",
"orizaniens", "orizonens", "orlandiens", "orleanens",
"oroandens", "oroboens", "orocoens", "orosens",
"ortigueirens", "ortonens", "ortroniens", "osasquens",
"oscens", "oscilant", "osoriens", "ossonobens",
"ostiens", "ostrens", "otroniens", "ouguelens",
"ouraniens", "oureens", "ouremens", "ourenens",
"ourens", "ourenzens", "ouricanens", "ouricuriens",
"ouriens", "ourinhens", "ouriquens", "ourivens",
"ourizonens", "outeirens", "outorgant", "ouvidorens",
"ouvint", "ovant", "ovarens", "ovetens",
"ovitens", "oxidant", "pacaembuens", "pacajaens",
"pacajuens", "pacatubens", "pacatuens", "pacens",
"pachequens", "pacienciens", "paciens", "pacient",
"pa"+u"\u00E7"+"oquens", "pacotiens", "pacotubens", "pacovalens",
"pacovalzinhens", "pacuens", "pacuiens", "pacujaens",
"pacuriens", "pacutiens", "pacutubens", "padecent",
"padilhens", "paduens", "pagant", "paiaguaens",
"paiaiaens", "paialens", "paineirens", "painelens",
"painens", "paiolens", "paiolinhens", "paiquereens",
"paivens", "pajauens", "pajeens", "pajeuens",
"paju"+u"\u00E7"+"arens", "palamens", "palapoutens", "palauens",
"palenens", "palens", "paleomanens", "palermens",
"palestinens", "palestrant", "palhalens", "palhanenens",
"palhens", "palhetens", "palhocens", "palhocinhens",
"palionens", "palmarens", "palmatoriens", "palmeiralens",
"palmeirandens", "palmeirens", "palmeirinens", "palmeirinhens",
"palmelens", "palmens", "palm"+u"\u00ED"+"ped", "palmirens",
"palmitalens", "palmitens", "palmitinhens", "palmopolens",
"palomens", "palotinens", "palpitant", "paltonens",
"paluens", "pamonhens", "pampanens", "pampeirens",
"pampilhosens", "panacuiens", "panamaens", "panambiens",
"panamens", "panaripens", "pancens", "panelens",
"panfiliens", "pangareens", "panoiens", "panoramens",
"panquens", "pantanalens", "pantanalzinhens", "pantanens",
"panteens", "panticapens", "papagaiens", "papanduvens",
"papariens", "papoulens", "papuriens", "paquens",
"paquequerens", "paquetaens", "paquet", "paquevirens",
"paquicamens", "paquiderm", "paquistanens", "paracambiens",
"paracambuquens", "paracatuens", "paracuaens", "paracuruens",
"paradens", "paradisens", "paraens", "parafusens",
"paragua"+u"\u00E7"+"uens", "paraguaiens", "paraguariens", "paraibanens",
"paraibens", "paraibunens", "paraiens", "paraipabens",
"paraisens", "paraisolandens", "paraisolandiens", "paraisopolens",
"paraitinguens", "paraiuvens", "parajuens", "parajuruens",
"paralisant", "paralissens", "paramanens", "parambuens",
"paramirinens", "paramirinhens", "paramotiens", "paranabiens",
"paranacitens", "paranacityens", "paranaens", "paran"+u"\u00E3"+"ens",
"paranagua"+u"\u00E7"+"uens", "paranaguaens", "paranaibens", "paranaiens",
"paranajiens", "parananens", "paranapanemens", "paranapoemens",
"paranapuanens", "paranariens", "paranatamens", "paranavaiens",
"paran"+u"\u00E3"+"zens", "parangabens", "paranhens", "paraopebens",
"parapeumens", "parapuanens", "parapuens", "paraquemens",
"parariens", "paratariens", "parateiens", "paratibens",
"paratiens", "paratijiens", "paratinguens", "paratudalens",
"parauaraens", "parauens", "paraunens", "parazinhens",
"parceirens", "pardalens", "pardilhoens", "pardinhens",
"pareciens", "paredens", "paredonens", "parelheirens",
"parelhens", "parent", "paricaens", "paricatubens",
"pariconhens", "parijoens", "parintinens", "paripiens",
"paripiranguens", "paripueirens", "pariquerens", "paririens",
"parisiens", "parmens", "parnaguaens", "parnaguens",
"parnaibens", "parnaiuicavens", "parnamirinens", "parnaramens",
"parnasens", "parobeens", "parodiant", "pars",
"participant", "part"+u"\u00ED"+"cip", "parturient", "paruruens",
"pascoalens", "pascoens", "passabenens", "passabenzens",
"passagenens", "passagens", "passagenzens", "passant",
"passarinhens", "passaunens", "passavant", "passeant",
"passeens", "passens", "passeriform", "passirens",
"pastens", "pastilhens", "pastinhens", "pastorens",
"pataibens", "patamuteens", "patavicens", "pateant",
"pateironens", "patens", "patiens", "patif",
"patizalens", "patracens", "patrens", "patriarquens",
"patriciens", "patrimoniens", "patrocinens", "patrociniens",
"patrulhens", "patuens", "pauapixunens", "pauiniens",
"paulens", "pauliceens", "pauliceiens", "paulinens",
"pauliniens", "paulistanens", "paulistaniens", "paulistens",
"paulivens", "pausulens", "pauxiens", "paveramens",
"paviens", "pavoens", "pavonens", "pavu"+u"\u00E7"+"uens",
"pavunens", "paxiuens", "paxuens", "pazens",
"peabiruens", "pebens", "pe"+u"\u00E7"+"anhens", "pecenens",
"pecenzens", "pedant", "pederneirens", "pedestr",
"pedint", "pedralvens", "pedrariens", "pedregulhens",
"pedreirens", "pedrens", "pedrinhens", "pedritens",
"pedroguens", "pedronens", "pedrosens", "peixens",
"peixinhens", "peixotens", "peju"+u"\u00E7"+"arens", "peladens",
"pelenens", "pelens", "peloponens", "pelotens",
"penacovens", "penafidelens", "penafortens", "penaguiens",
"penalvens", "penamacorens", "penamarens", "penant",
"penapolens", "pendanguens", "pendenciens", "pendent",
"penedens", "penediens", "penedonens", "penelens",
"penetrant", "penichens", "penitent", "pensant",
"pepitalens", "pequeriens", "pequiaens", "pequiens",
"pequiriens", "pequizeirens", "perapeunens", "percevejens",
"perciform", "percucient", "perdicens", "perdicionens",
"perdigonens", "perdiguens", "perdizens", "perdonens",
"peregrinens", "pereirens", "pereirinhens", "peren",
"perequeens", "perfurant", "pergens", "pergunt",
"periclitant", "pericoens", "perigarens", "perigosens",
"perimboens", "perimiriens", "perimirinens", "periquarens",
"periquitens", "peritoroens", "permanent", "pernambuquens",
"pernambuquinhens", "perobalens", "perobens", "perolens",
"perpetuens", "perrengu", "perrexilens", "perscrutant",
"perseveranciens", "perseverant", "persistent", "pertencent",
"pertilens", "pertinent", "perturbant", "peruanens",
"peruens", "peruibens", "pervagant", "pescadorens",
"pesqueirens", "pesqueirinhens", "pessanhens", "pessegueirens",
"pessoens", "pest", "pestilent", "petavionens",
"petavoniens", "petinens", "petragoricens", "petrens",
"petrogradens", "petrolandens", "petrolandiens", "petrolinens",
"petrovinens", "petulant", "petuniens", "piabanhens",
"piabens", "piacabu"+u"\u00E7"+"uens", "pia"+u"\u00E7"+"abu"+u"\u00E7"+"uens", "piacaens",
"piacatubens", "piacatuens", "pia"+u"\u00E7"+"uens", "piancoens",
"piassabu"+u"\u00E7"+"uens", "piat"+u"\u00E3"+"ens", "piatanens", "piat"+u"\u00E3"+"zens",
"piauens", "piauiens", "piaunens", "piavorens",
"picadens", "picadinhens", "picant", "pichens",
"piciform", "picinguabens", "picoens", "pictavens",
"picuens", "picuiens", "piedadens", "piedens",
"pienens", "piens", "pietatens", "pilarens",
"pilens", "piliens", "pilonens", "pimenteiralens",
"pimenteirens", "pimentelens", "pimentens", "pinareens",
"pincens", "pindaibens", "pindaiens", "pindaivens",
"pindamonhangabens", "pindareens", "pindens", "pindoba"+u"\u00E7"+"uens",
"pindobalens", "pindobens", "pindoguabens", "pindoramens",
"pindoretamens", "pindotibens", "pindovalens", "pinens",
"pingadorens", "pingant", "pingent", "pinhalens",
"pinhalitens", "pinhalonens", "pinhalzinhens", "pinh"+u"\u00E3"+"oens",
"pinh"+u"\u00E3"+"ozens", "pinh"+u"\u00E3"+"ozinhens", "pinheiralens", "pinheirens",
"pinheirinhens", "pinhelens", "pinhonens", "pinhotibens",
"pin"+u"\u00ED"+"ped", "pintadens", "pintens", "pinturilant",
"pioneirens", "pionens", "pipeirens", "pipens",
"pipilant", "pipinuquens", "piquens", "piquerobiens",
"piquetens", "piquiriens", "pirabeirabens", "pirabens",
"pirabibuens", "piracaibens", "piracaiens", "piracanjubens",
"piracauaens", "piracemens", "piracicabens", "pira"+u"\u00E7"+"ununguens",
"piracurucens", "piracuruquens", "piraguarens", "piraiens",
"pirainhens", "piraiuarens", "pirajaens", "pirajibens",
"pirajubens", "pirajuens", "pirajuiens", "piramboiens",
"pirambuens", "pirangaiens", "pirangu"+u"\u00E7"+"uens", "piranguens",
"piranguinhens", "piranguitens", "piranhens", "piranjiens",
"piranjinens", "pirapanemens", "pirapemens", "pirapetinguens",
"pirapitinguiens", "pirapoens", "piraporens", "pirapozens",
"pirapozinhens", "piraputanguens", "piraquarens", "piratabens",
"piratiniens", "piratininguens", "piratubens", "pirauaens",
"piraubens", "pirens", "pirgens", "piriaens",
"piriens", "piriform", "piripaens", "piripiriens",
"piritibens", "piritubens", "pirizalens", "pirizeirens",
"pirpiritubens", "pisaurens", "pisauriens", "piscambens",
"pistoriens", "pitangueirens", "pitanguens", "pitanguiens",
"pitimbuens", "pititinguens", "pitombeirens", "pitubens",
"pitunens", "piuens", "piuiens", "piumens",
"piunens", "piunzens", "piuvens", "pixainens",
"pixainzens", "planaltens", "planaltinens", "planetens",
"plangens", "plangent", "planinens", "planurens",
"plastificant", "plateens", "platelmint", "platens",
"platinens", "pleninens", "pleuronectiform", "poaens",
"poaiens", "pobr", "po"+u"\u00E7"+"anens", "po"+u"\u00E7"+u"\u00E3"+"oens",
"po"+u"\u00E7"+u"\u00E3"+"ozens", "pocens", "pochiquens", "pocinhens",
"pocionens", "po"+u"\u00E7"+"oens", "poconeens", "po"+u"\u00E7"+"oneens",
"pocranens", "podimirinens", "podr", "poeirens",
"poent", "poiarens", "poiriens", "pojuquens",
"polens", "policarpens", "politizant", "polivalent",
"poloniens", "poluent", "polvorens", "pombalens",
"pombens", "pombinhens", "pomeranens", "pomerodens",
"pometinens", "pompeens", "pompelonens", "pompeuens",
"poncianens", "pongaiens", "pontalens", "pontaletens",
"pontalindens", "pontalinens", "pontalzinhens", "pontens",
"pontevilens", "pontezinhens", "pontiens", "pontinens",
"pontinhens", "pontonens", "populinens", "populoniens",
"porangabens", "porangatuens", "poranguens", "porciunculens",
"porecatuens", "porfiriens", "poronguens", "pororoquens",
"portaginens", "portalegrens", "porteirens", "porteirinhens",
"portelens", "portens", "portimonens", "portinhens",
"portlandiens", "portonens", "portucalens", "portuens",
"portugalens", "porvirens", "possant", "possens",
"possident", "postulant", "poteens", "potenjiens",
"potent", "potiens", "potiraguaens", "potiraguarens",
"potiraguens", "potirendabens", "potirens", "potiretamens",
"potreirens", "potreiritens", "potunduvens", "pousens",
"povens", "povoacens", "povoens", "poxorens",
"poxoreuens", "pracinhens", "pradens", "pradinhens",
"pradosens", "praguens", "praiens", "prainhens",
"pranchadens", "pranchitens", "prataniens", "pratapolens",
"pratens", "praticant", "pratinhens", "prazerens",
"precedent", "prec"+u"\u00ED"+"pit", "precoc", "predisponent",
"predominant", "preeminent", "preexcelent", "preexistent",
"preguens", "preguicens", "prement", "premonstratens",
"prensens", "preocupant", "preponderant", "preponent",
"prepotent", "present", "president", "presidiens",
"presidutrens", "pressionant", "prestant", "prestens",
"pretendent", "pretoriens", "prevalecent", "prevalent",
"prevenidens", "prevident", "prienens", "primaiens",
"primaverens", "primorens", "princesens", "principiant",
"privatizant", "probidadens", "procariont", "procedent",
"procopiens", "proeminent", "proencens", "profetens",
"profissionalizant", "progressens", "promissens", "propagant",
"propelent", "proponent", "propriaens", "prosperidadens",
"protecionens", "proteiform", "protestant", "provenient",
"providenciens", "provident", "provocant", "prudent",
"prudentens", "prusens", "prusiens", "puanens",
"pu"+u"\u00E3"+"zens", "pubent", "pubescent", "pu"+u"\u00E7"+"aens",
"pucalpens", "puguens", "puira"+u"\u00E7"+"uens", "pujant",
"puladorens", "pulsant", "puluens", "punens",
"pungent", "puntiform", "pupiniens", "purezens",
"purgant", "purilandens", "purilandiens", "pusil"+u"\u00E2"+"nim",
"putinguens", "putiriens", "puxavant", "puxinan"+u"\u00E3"+"ens",
"puxinan"+u"\u00E3"+"zens", "quadrant", "quadrens", "quadriburgens",
"quadr"+u"\u00FA"+"ped", "quajaraens", "quara"+u"\u00E7"+"uens", "quaraiens",
"quarentens", "quariens", "quartelens", "quataens",
"quati"+u"\u00E7"+"abens", "quatiens", "quatiguabens", "quatiguaens",
"quatiguens", "quatipuruens", "quatiquanens", "quatitubens",
"quebequens", "queboens", "quebrachens", "quebrangulens",
"quebrant", "que"+u"\u00E7"+"abens", "quedens", "queimadens",
"queirosens", "queixadens", "queluzens", "queluzitens",
"quent", "queremens", "querenciens", "querent",
"querronens", "quersonens", "quevedens", "qui"+u"\u00E7"+"amaens",
"qui"+u"\u00E7"+"am"+u"\u00E3"+"ens", "qui"+u"\u00E7"+"amanens", "quiceens", "quiescent",
"quietens", "quijinguens", "quilombens", "quil"+u"\u00F3"+"pod",
"quimamiens", "quimiossintetizant", "quincoeens", "quincuncaens",
"quintanens", "quintens", "quintinens", "quipaens",
"quipapaens", "quiririens", "quiririnens", "quiriritiuens",
"quiromant", "quitandinhens", "quiterianopolens", "quiteriens",
"quitimbuens", "quitundens", "quitunguens", "quixabeirens",
"quixabens", "quixadaens", "quixariuens", "quixeloens",
"quixeramobiens", "quixeramobinens", "quixereens", "quixoaens",
"quizotens", "rabdomant", "rabecens", "rabequens",
"rabichens", "rabugic", "rabulic", "raciarens",
"raciocinant", "radiadorens", "radiant", "radiouvint",
"rafaelens", "rafardens", "raimundens", "raizalens",
"raizamens", "raizens", "rajadens", "ramadens",
"ramalhens", "ramalhetens", "ramens", "ramirens",
"ramnens", "ramonens", "ranchariens", "ranchens",
"ranchinhens", "rangent", "rapac", "rapant",
"rapinant", "raposens", "rareant", "rarescent",
"rasant", "rascant", "rasens", "raspadorens",
"rastejant", "rateens", "ratens", "ratic",
"ratit", "ratonens", "ravenatens", "ravenens",
"reafirmant", "reagent", "realens", "realezens",
"rebeld", "rebent", "reboant", "rebojens",
"rebordosens", "reboucens", "rebrilhant", "recalcitrant",
"recendent", "recent", "reciens", "recifens",
"recipient", "reclamant", "reconfortant", "recorrent",
"recreens", "recuperadens", "recursens", "recusant",
"recusens", "redencens", "redencionens", "reden"+u"\u00E7"+"onens",
"redent", "redentorens", "redinhens", "redolent",
"redondens", "redundant", "redutens", "referent",
"refervent", "reformens", "refrigerant", "refugiadens",
"refulgent", "regant", "regenciens", "regeneracionens",
"regenera"+u"\u00E7"+"onens", "regenerens", "regent", "regentens",
"regiens", "reginens", "reginopolens", "registrens",
"regrant", "reguenguens", "reguens", "regurgitant",
"reinant", "reincident", "relampejant", "relaxant",
"relevant", "reliquiens", "relumbrant", "relutant",
"reluzent", "relvadens", "remanescent", "remansonens",
"remediens", "remens", "r"+u"\u00EA"+"mig", "remigens",
"remigiens", "reminiscent", "remont", "renascencens",
"renascent", "renitent", "renqu", "rent",
"repartimenens", "repelent", "repent", "repetent",
"replicant", "repont", "repousant", "representant",
"reptant", "repugnant", "requerent", "requint",
"reriutabens", "rescendent", "resendens", "reservens",
"resfolegant", "residenciens", "resident", "resistent",
"respeitant", "resplandecent", "resplandens", "resplandescent",
"resplendent", "resplendorens", "respondent", "ressaltant",
"ressaquens", "ressoant", "ressonant", "restant",
"restauracionens", "restaurant", "restinguens", "restringent",
"resultant", "resvalant", "retardant", "reticent",
"retiens", "retirant", "retirolandens", "retirolandiens",
"retumbant", "reumatoid", "reverberant", "reverent",
"revoltant", "riach"+u"\u00E3"+"oens", "riachens", "riachinhens",
"riachonens", "riachuelens", "rialmens", "rialtens",
"riazulens", "ribacudens", "ribaduriens", "ribamarens",
"ribatejens", "ribeir"+u"\u00E3"+"oens", "ribeirens", "ribeirinhens",
"ribeironens", "ribeiropolens", "ricinens", "rident",
"riens", "rifainens", "rinareens", "rinconens",
"rinoceront", "rinopolens", "rioclarens", "riograndens",
"riolandens", "riozinhens", "riquezens", "ritapolens",
"ritens", "rivens", "riversulens", "robenhausiens",
"robertens", "ro"+u"\u00E7"+"adens", "ro"+u"\u00E7"+"agant", "rochedens",
"rochedinhens", "rocinant", "rodaniens", "rodant",
"rodeens", "rodeiens", "rodeirens", "rodens",
"rodiens", "rodopiant", "roladorens", "rolandens",
"rolandiens", "rolant", "rolantens", "rolimorens",
"rom"+u"\u00E3"+"oens", "romarens", "romariens", "romelandens",
"romelandiens", "rompant", "rompent", "roncadens",
"roncadorens", "rondant", "rondinhens", "rondonens",
"rondoniens", "ronflant", "roquens", "roraimens",
"rorejant", "rosalandens", "rosalens", "rosaliens",
"rosalindens", "rosanens", "rosarens", "rosariens",
"roseiralens", "roseirens", "roteirens", "rotomagens",
"rotundens", "ruandens", "rubelitens", "rubescent",
"rubiaceens", "rubiacens", "rubiatabens", "rubiens",
"rubineens", "rubinens", "rud", "rugent",
"ruilandens", "ruinens", "ruminant", "rumorejant",
"rupestr", "russens", "rutenens", "rutilant",
"saarens", "sabaens", "sabaraens", "sabarens",
"sabaudiens", "sabaunens", "sabiaens", "sabiaguabens",
"sabinens", "sabinopolens", "saboeirens", "saboguens",
"saboiens", "sabonetens", "saborens", "sabratens",
"sabrosens", "sabugalens", "sabugueirens", "sabujiens",
"sacadens", "sacambuens", "sacavenens", "sacerdot",
"sacoiens", "sacramentens", "sacripant", "sacrocordiens",
"sadens", "saens", "safarens", "safirens",
"sagradens", "sagrens", "saibrens", "saic"+u"\u00E3"+"zens",
"saiens", "sainaumens", "saireens", "sajens",
"salaciens", "salamanquens", "salamanticens", "salariens",
"salavessens", "saldanhens", "salens", "salesens",
"salesopolens", "saletens", "salgadaliens", "salgadens",
"salgadinhens", "salgueirens", "salient", "salinadens",
"salinens", "saliniens", "salininhens", "salitrens",
"salmanticens", "salmouranens", "saloaens", "salobinhens",
"salobrens", "salomeens", "salonens", "salonicens",
"salsens", "saltant", "saltens", "saltinhens",
"saltitant", "salubr", "salutariens", "salvacionens",
"salvadorens", "salvaterrens", "salvens", "salzedens",
"samambaiens", "samaumens", "sambaetibens", "sambaibatubens",
"sambaibens", "sambaquiens", "sambarnabens", "sambeens",
"sambeneditens", "sambernardens", "sambertens", "sambonaventurens",
"samoens", "samorens", "samosatens", "samuelens",
"sanagens", "sananduvens", "sancandidens", "sanderens",
"sandesideriens", "sandominicens", "sandovalens", "sandovalinens",
"sandumonens", "sanens", "sanestefanens", "sanfelicens",
"sanfirminens", "sanfranciscens", "sangalhens", "sanganens",
"sanganhanens", "sangonens", "sanguessuguens", "sanharoens",
"sanjoanens", "sanjosefens", "sanludovicens", "sansimoniens",
"santanderiens", "santanens", "santanesiens", "santareens",
"santarenens", "santarens", "santelmens", "santens",
"santiaguens", "santomens", "santuens", "s"+u"\u00E3"+"omarinhens",
"sapatariens", "sapea"+u"\u00E7"+"uens", "sapecadens", "sapeens",
"sapens", "sapezalens", "sapient", "sapiranguens",
"sapopemens", "sapucaiens", "sapucaranens", "sapuparens",
"saquaremens", "saquinhens", "saracurens", "saracuruens",
"saraivens", "sarandiens", "sarandirens", "sarapuiens",
"sararaens", "sardiens", "sardinhens", "sardoaens",
"sardoalens", "sarens", "sargentens", "sarutaiaens",
"sarzedens", "sat"+u"\u00E9"+"lit", "satanens", "satens", "satubens",
"satubinens", "satubinzens", "saturnens", "saubarens",
"saudadens", "saudavelens", "saudens", "saueens",
"sauiaens", "sauraurens", "saur"+u"\u00F3"+"pod", "sauvens",
"seabrens", "searens", "sebalens", "sebastianens",
"sebastopolens", "seberiens", "secadorens", "secanens",
"secant", "sedens", "segestens", "segiens",
"segisamajuliens", "segisamonens", "segobrigens", "segontinens",
"segredens", "seguint", "segundens", "segurens",
"segusiens", "seichelens", "seivalens", "seixalens",
"selbachens", "sel", "seleucens", "seleuciens",
"selmens", "selvens", "semelhant", "semovent",
"senadorens", "senegalens", "senegambiens", "senens",
"senhoritens", "sentinelens", "separacionens", "sepetibens",
"sepotubens", "sepulturens", "sequens", "sequent",
"serenens", "sergiens", "sergipens", "seribinhens",
"sericitens", "seridoens", "seriens", "seritinguens",
"serjiens", "sernachens", "sernancelhens", "serpeant",
"serpens", "serpenteant", "serralitrens", "serranens",
"serraniens", "serrariens", "serrazens", "serrens",
"serrinhens", "serritens", "serrolandens", "serrolandiens",
"serrotens", "sertaginens", "sertanejens", "sertanens",
"sertaniens", "sertanopolens", "sert"+u"\u00E3"+"ozinhens", "servens",
"servent", "sesimbrens", "setubalens",
"setubinhens", "severens", "severinens", "severiniens",
"seychellens", "siamens", "siariens", "sibilant",
"siboens", "sicens", "sicilens", "siciliens",
"sidens", "sidrolandens", "sidrolandiens", "sienens",
"significant", "silenciens", "silens", "silent",
"silvadens", "silvaldens", "silvanectens", "silvanens",
"silvaniens", "silvant", "silveiraniens", "silveirens",
"silvens", "silveriens", "silvestr", "silvestrens",
"silvianopolens", "silviens", "simbiont", "s"+u"\u00ED"+"mil",
"simonens", "simonesiens", "simonsenens", "simpatiens",
"simpatizant", "simpliciens", "sinadens", "sincoraens",
"sindens", "sineens", "sinfanens", "singapurens",
"singidunens", "singlet", "singrant", "siniens",
"sinimbuens", "sinopens", "sintrens", "sipicueens",
"siqu", "siqueirens", "siquimens", "siriens",
"sirigadens", "sirijiens", "sirinhaenens", "siririens",
"sirmiens", "sisaponens", "sisolens", "sitiaens",
"sitiant", "sitiens", "sitionovens", "siupeens",
"soajens", "soant", "soarens", "sobejant",
"soberanens", "sobradens", "sobradinhens", "sobralens",
"sobraliens", "sobrant", "sobreirens", "sobrejacent",
"sobrelevant", "sobressalent", "sobrevivent", "socamirinens",
"socavanens", "sociedadens", "socorrens", "sodrelandens",
"sodrelandiens", "sodreliens", "sofalens", "solaneens",
"solanens", "soledadens", "solemarens", "solen",
"solert", "solicitant", "solimariacens", "solu"+u"\u00E7"+"ant",
"solvens", "solvent", "sonant", "sopens",
"soquens", "sorocabanens", "sorocabens", "sororoens",
"sorrident", "sosseguens", "soteiens", "sourens",
"sousaniens", "souselens", "sousens", "soutens",
"stevensonens", "sua"+u"\u00E7"+"uiens", "sua"+u"\u00E7"+"uranens", "suanens",
"suav", "suazilandens", "suazilandiens", "subaiens",
"subaumens", "subchef", "subcomponent", "subconscient",
"subidens", "subjacent", "sublim", "sublimizant",
"subsequent", "subservient", "subsistent", "substituint",
"subtenent", "suburanens", "sucatinguens", "sucessens",
"suciant", "sucubens", "sucupirens", "sucureens",
"sucuriens", "sucurijuens", "sucuriuens", "sucurizinhens",
"sucuruens", "sucurujuens", "sudanens", "sudoest",
"suessiens", "suezens", "sufetulens", "suficient",
"sufocant", "sugant", "suicens", "sulcens",
"sulinens", "sulmonens", "sumareens", "sumaumens",
"sumeens", "sumidourens", "sumuriens", "superaguiens",
"supergigant", "superimportant", "superintendent", "superpotent",
"supervenient", "suplent", "suplicant", "s"+u"\u00FA"+"plic",
"supurant", "surfactant", "surinamens", "surpreendent",
"surpresens", "surrealizant", "surrinens", "surubinens",
"suruiens", "susanens", "suspens", "suspirant",
"suspirens", "sussurrant", "sustinens", "tabacens",
"tabaiens", "tabainhens", "tabajarens", "tabapuanens",
"tabaquens", "tabatinguens", "tabaunens", "tabenens",
"taberoeens", "tabirens", "taboadens", "tabocalens",
"taboquens", "taboquinhens", "tabosens", "tabracens",
"tabuacens", "tabuadens", "tabualens", "tabuanens",
"tabudens", "tabuens", "tabuinhens", "tabuleirens",
"tabuleironens", "tacaimboens", "tacaleens", "tacaratuens",
"tachens", "taciateuens", "tacibens", "tacimens",
"tacimirinens", "taciuanens", "tacteant", "tacuiquenens",
"tacuruens", "tadeuens", "tagant", "tagastens",
"taguaiens", "taguatinguens", "taia"+u"\u00E7"+"uens", "taia"+u"\u00E7"+"upebens",
"taiamanens", "taibens", "tainens", "tainhens",
"taiobeirens", "taipens", "taipinhens", "taipuens",
"tairetaens", "taiuvens", "tajatubens", "tajiens",
"tajuabens", "talabricens", "talabrigens", "talarens",
"talhadens", "talhant", "talimanens", "tamandareens",
"tamanduaens", "tamaniquaens", "tamanqueirens", "tamaquariens",
"tamaranens", "tamarineirens", "tambaquiens", "tambauens",
"tambeens", "tamboarens", "tamboataens", "tamborilens",
"tamborilzinhens", "tamburiens", "tameguens", "tamequens",
"tamoiens", "tamulens", "tanabiens", "tanariens",
"tancredinhens", "tanetiens", "tangaraens", "tangent",
"tangilens", "tanguaens", "tanha"+u"\u00E7"+"uens", "tanquens",
"tanquinhens", "tapaiunens", "taparaens", "taparubens",
"tapauaens", "tapejarens", "tapens", "taperens",
"taperiens", "taperinhens", "taperoaens", "taperuabens",
"tapinens", "tapiracanguens", "tapiraiens", "tapirainens",
"tapiraipens", "tapiramens", "tapiramutaens", "tapiranguens",
"tapirapuanens", "tapiratibens", "tapirens", "taporens",
"tapuiens", "tapuiramens", "tapuruens", "tapuruquarens",
"taquapiriens", "taquara"+u"\u00E7"+"uens", "taquaralens", "taquarandiens",
"taquaremboens", "taquarens", "taquariens", "taquarilens",
"taquarinhens", "taquaritinguens", "taquaritubens", "taquarivaiens",
"taquarixinens", "taquaru"+u"\u00E7"+"uens", "tarabaiens", "taraens",
"taraguaens", "taramens", "taraquaens", "tarauacaens",
"tardenens", "tardenoisens", "tardenoisiens", "targinens",
"tarianens", "taritubens", "tarouquens", "tarquiniens",
"tarracens", "tarracinens", "tarraconens", "tarrafens",
"tarragens", "tarsens", "tartamudeant", "tartaruguens",
"tarua"+u"\u00E7"+"uens", "tarumanens", "tarumirinens", "tarumirinhens",
"tarusconiens", "tasmaniens", "tatairens", "tatajubens",
"tate/ment", "tateant", "tatuamunhens", "tatuens",
"tatuiens", "tatuquarens", "tauaens", "tauape"+u"\u00E7"+"a"+u"\u00E7"+"uens",
"tauapens", "tauapiranguens", "tauarianens", "tauari"+u"\u00E3"+"zinhens",
"tauariens", "tauaruanens", "taubateens", "taumataens",
"taumaturgens", "taumaturguens", "taunayens", "taunens",
"tauoaens", "tauriniens", "taurunens", "tavarens",
"tavirens", "tavorens", "teanens", "tebaidens",
"tebens", "te"+u"\u00E7"+"aindaens", "tefeens", "tegianens",
"teixeirens", "teju"+u"\u00E7"+"uoquens", "tejucupapens", "tejupaens",
"telheirens", "telhens", "telmessens", "telonens",
"tement", "temerantens", "temperens", "tendent",
"tenent", "tens", "tentugalens", "t"+u"\u00EA"+"nu",
"tenuipens", "teodorens", "teotonens", "teotoniens",
"terceirens", "terebrant", "terenens", "terereens",
"teresens", "teresinens", "teresinhens", "termens",
"termessens", "terminant", "ter"+u"\u00F3"+"pod", "terracinens",
"terratenent", "terreirens", "terrens", "terrestr",
"terrinhens", "tesourens", "tesourinhens", "tespiens",
"tessalonicens", "tetaniform", "tetens", "tetr"+u"\u00E1"+"pod",
"tetravalent", "teudalens", "teuiniens", "teutoburgiens",
"teutoniens", "tiaguens", "tianguaens", "tiarajuens",
"tibajiens", "tibauens", "tibiens", "tibiri"+u"\u00E7"+"aens",
"tibiriens", "tibunens", "ticiens", "ticinens",
"tieteens", "tigr", "tigrens", "tigrinhens",
"tijipioens", "tijocens", "tijoquens", "tijua"+u"\u00E7"+"uens",
"tijucalens", "tijucens", "tijucu"+u"\u00E7"+"uens", "tijuquens",
"tijuquinhens", "tilintant", "timacens", "timbaubens",
"timbeens", "timbirens", "timboens", "timboraens",
"timboreens", "timboteuens", "timbozalens", "timbozinhens",
"timbuens", "timbuiens", "timburiens", "timiadens",
"timorens", "tinguaens", "tinguatibens", "tipiens",
"tipitiens", "tipl", "tiquaru"+u"\u00E7"+"uens", "tiraciens",
"tiracinens", "tiradentens", "tirant", "tirens",
"tiriens", "tiriricalens", "tiririquens", "tiritant",
"tirocinant", "tirsens", "tissanens", "tissens",
"titeens", "titiaens", "titiarrens", "titilant",
"titubeant", "tiuiens", "toant", "tobatiens",
"tobiarens", "tobiens", "tocaiens", "tocandirens",
"tocanquirens", "tocant", "tocantinens", "tocantiniens",
"togiens", "togolens", "toguens", "toldens",
"toledens", "tolerant", "toleriens", "toloiriens",
"tolosens", "tomarens", "tomarutemens", "tomasiens",
"tomasinens", "tomazinens", "tombadorens", "tombant",
"tombens", "tomens", "tonant", "tonantinens",
"tondelens", "tondens", "tonificant", "toniolens",
"tonitroant", "tonitruant", "tonteant", "tontens",
"topaziens", "topens", "torcidens", "toriparuens",
"toritamens", "torixoreuens", "tormentinhens", "tornacens",
"torneirens", "tornejant", "tornens", "toropiens",
"toroquaens", "torp", "torranens", "torreant", "torreens",
"torrens", "torrent", "torreonens", "torriens",
"torrinhens", "torronens", "tortens", "torturant",
"totalizant", "tourens", "tourinhens", "toxicodependent",
"trabijuens", "tracens", "tracuaens", "tracuateuens",
"tracunhaenens", "tracupaens", "traficant", "traianens",
"traipuens", "trairens", "trairiens", "traironens",
"traituens", "trajanens", "tral", "tralens",
"tramandaiens", "trancosens", "tranqueirens", "tranquilizant",
"transbordant", "transcendent", "transeunt", "transformant",
"transient", "transigent", "transparent", "transplant",
"transudant", "trapiaens", "trapichens", "trapipens",
"trasbordant", "trast", "tratant", "traumatizant",
"travesseirens", "travessens", "travessiens", "travessonens",
"treiens", "trejens", "trelens", "tremant",
"tremecens", "tremedalens", "tremeluzent", "tremembeens",
"trement", "tremulant", "trepidant", "trescalant",
"tressuant", "trevisens", "triacens", "triangulens",
"triarroiens", "tribarrens", "tribiquens", "tribiuens",
"triboboens", "triboquens", "tribracens", "tributant",
"tricachoeirens", "tricasens", "triciens", "tricoronens",
"tricorreguens", "tricrucens", "trident", "tridivisens",
"trifigueirens", "triforquilhens", "trifraternens", "trifronteirens",
"triladeirens", "trilagoens", "trilagunens", "trimaiens",
"trimariens", "trimontens", "trimorrens", "trinchant",
"trindadens", "tripassens", "tripetrens", "tripinens",
"tripinheirens", "tr"+u"\u00ED"+"plic", "tripocens", "tripontens",
"tripudiant", "tripulant", "trirranchens", "trirriens",
"trirrivens", "trist", "tristradens", "tritiens",
"triturant", "triunfant", "triunfens", "trivalent",
"trivendens", "troant", "trofens", "troiens",
"trombens", "trombudens", "trombuquens", "tronquens",
"trovejant", "tru"+u"\u00E7"+"uens", "tuaregu", "tubaronens",
"tubendubens", "tubuliform", "tubunens", "tucanens",
"tuciens", "tucumadeuens", "tucumaens", "tucunareens",
"tucundubens", "tucunduvens", "tucunens", "tucunzens",
"tucupareens", "tucuribens", "tucuruiens", "tucuruviens",
"tudens", "tuguriens", "tuinens", "tuiueens",
"tuiuiuens", "tuiutiens", "tuiutinguens", "tularens",
"tumbens", "tumiritinguens", "tunant", "tuneirens",
"tunens", "tungus", "tuntuens", "tuntumens",
"tuntunens", "tupaciguarens", "tup"+u"\u00E3"+"ens", "tupanaciens",
"tupanatinguens", "tupanciretanens", "tupandiens", "tupanens",
"tupantubens", "tupaocens", "tupaoquens", "tuparaceens",
"tuparaiens", "tuparandiens", "tuparendiens", "tuparetamens",
"tup"+u"\u00E3"+"zens", "tupeens", "tupiens", "tupinambaens",
"tupinens", "tupira"+u"\u00E7"+"abens", "tupiramens", "tupiratinens",
"tupitinguens", "turbant", "turbilhonant", "turia"+u"\u00E7"+"uens",
"turiassonens", "turielens", "turinens", "turiubens",
"turmalinens", "turonens", "turonicens", "turtuveant",
"turumanens", "tururuens", "turvaniens", "turvelandens",
"turvens", "turviniens", "turvolandens", "tusculandens",
"tutiens", "tutoiens", "uacananens", "uacariens",
"uacociens", "uacurizalens", "uanaracens", "uapeens",
"uaraens", "uariens", "uarinens", "uarirambaens",
"uarumens", "uatum"+u"\u00E3"+"ens", "uauaens", "uaupeens",
"ubaens", "ubaiens", "ubairens", "ubaitabens",
"ubajarens", "ubaporanguens", "ubaranens", "ubariens",
"ubatanens", "ubatens", "ubatibens", "ubatubens",
"ubaunens", "ubazinhens", "uberabens", "uberlandens",
"uberlandiens", "ubira"+u"\u00E7"+"abens", "ubira"+u"\u00E7"+"uens", "ubiraitaens",
"ubirajarens", "ubirataiens", "ubiratanens", "ubiretamens",
"ubiretens", "uburanens", "uchoens", "ucraniens",
"ugandens", "uibaiens", "uiraponguens", "uiraunens",
"uivant", "ulbiens", "ulianopolens", "uliens",
"ulissiponens", "ulsteriens", "ultrajant", "ultralev",
"ultravident", "ulubrens", "ululant", "umanens",
"umariens", "umaritubens", "umarizalens", "umbaraens",
"umbaubens", "umbeliform", "umbelinens", "umbuens",
"umburanens", "umburaninhens", "umburatibens", "umburetamens",
"umbuzeirens", "umiriens", "umirinens", "umuaramens",
"unaiens", "un"+u"\u00E2"+"nim", "unciform", "undant",
"unens", "unidens", "uniflorens", "uniform",
"unionens", "univalent", "univalv", "universalizant",
"universens", "uomaloliens", "upacaraiens", "upamirinens",
"upanemens", "upatininguens", "upgrad", "uraiens",
"urandiens", "uraniens", "urariquerens", "urent",
"urgent", "urticant", "usbequ", "uscanens",
"uscens", "usinens", "uspens", "utariens",
"utent", "utiaritiens", "uticens", "utinguens",
"uvaens", "uvaiens", "uvalens", "uxamens",
"uxitubens", "uzalens", "uzbequ", "uzitens",
"vacacaiens", "vacaricens", "vacariens", "vacens",
"vacilant", "vacinant", "vadens", "vagant",
"vagens", "vaguens", "vaiamontens", "valadarens",
"valanens", "valanginens", "valboens", "valcovens",
"valdelandens", "valdens", "valdigens", "valencens",
"valenciens", "valens", "valent", "valentens",
"valentinens", "valerianens", "valeriens", "valinhens",
"valonguens", "valpacens", "valparaisens", "valsant",
"valverdens", "vandeens", "vanderleiens", "vanens",
"vangloriens", "vanuatens", "vanuatuens", "vapicens",
"vapincens", "vaquejadorens", "vardagatens", "varganens",
"vargeanens", "vargedens", "varginhens", "vargitens",
"varguens", "variant", "varjanens", "varjotens",
"varpens", "varsoviens", "vartens", "varzeanens",
"varzeariens", "varzedens", "varzeens", "varzelandens",
"varzelandiens", "varzinhens", "vasconcelens", "vascuens",
"vasiens", "vasquesens", "vassourens", "vastens",
"vaudens", "vauens", "vauthierens", "vauzinhens",
"vazamorens", "vazant", "vazantens", "vazlandens",
"vazlandiens", "veadeirens", "veadens", "veadinhens",
"vedant", "veement", "veiguens", "veimarens",
"veirens", "velabrens", "velanens", "velaniens",
"velens", "veliens", "venanciens", "venceslauens",
"venceslauzens", "vendeens", "vendens", "venenens",
"venens", "venetens", "venezens", "ventaniens",
"ventripotent", "veraneant", "veranens", "veravens",
"vercelens", "verd", "verdejant", "verdejantens",
"verdens", "verdunens", "veredens", "veredinhens",
"vereens", "verens", "vergiliens", "verissimens",
"vermelhens", "vermiform", "vermoilens", "verodunens",
"veronens", "verruguens", "vertent", "vertentens",
"vesicant", "vesonciens", "vespasianens", "vestiens",
"veterocretens", "vetonens", "vetuloniens", "viaciens",
"viadutens", "viajant", "viamanens", "viamonens",
"viandant", "vianens", "vianopolens", "viatens",
"viboniens", "vibrant", "vic", "vicejant", "vicelens",
"vicenciens", "vicentadens", "vicent", "vicentens",
"vicentinens", "viciant", "vidalens", "videirens",
"vident", "vidigalens", "vidigueirens", "vidinhens",
"vieguens", "vieirens", "vienens", "vietcongu",
"vietnamens", "vigariens", "vigent", "vigiens",
"vigilant", "vilacondens", "vilafranquens", "vilanovens",
"vilhenens", "vimaranens", "vimeirens", "vimieirens",
"vimiosens", "vinciens", "vinculant", "vindobonens",
"vindonissens", "vinhaens", "vinhalens", "vinhaticens",
"vinhedens", "violetens", "viracionens", "viradourens",
"virent", "virgiliens", "virginens", "virginiens",
"virgolandens", "virmondens", "virodunens", "virunens",
"viscens", "viseens", "viseuens", "visiens",
"visitant", "vistant", "vitelens", "vitodurens",
"vitorianens", "vitoriens", "vitorinens", "vitudurens",
"vivac", "vivariens", "vivent", "vivificant",
"vizelens", "voant", "vociferant", "volant",
"volateant", "volcens", "volitant", "volsiniens",
"voltens", "voltiniens", "vorac", "voraens",
"vordens", "votant", "votorantinens", "votourens",
"votuporanguens", "voturunens", "votuveravens", "vouzelens",
"vozeant", "vulgiens", "vurtemberguens", "wagneriens",
"xambioaens", "xambioazens", "xambioens", "xambreens",
"xambrens", "xangaiens", "xanxerens", "xapuriens",
"xavant", "xavantens", "xavantinens", "xavierens",
"xaxiens", "xaxinens", "xinguarens", "xinguens",
"xiquexiquens", "zacariens", "zairens", "zambiens",
"zamens", "zanatens", "zandavalens", "zargunchant",
"zelot", "zeolit", "zigurat", "zimbabuens",
"zot", "zuriquens"])


# PALAVRAS MASCULINAS TERMINADAS EM  E == abacate - chocolate
plvrMasce = set(["abacat", "abat", "acident", "a"+u"\u00E7"+"ougu",
"a"+u"\u00E7"+"ud", "afluent", "alambiqu", "alard",
"alarm", "albergu", "alfaiat", "alfinet",
"alicat", "alicerc", "almanaqu", "almirant",
"alp", "altifalant", "ambient", "andaim",
"anticiclon", "ant"+u"\u00ED"+"lop", "apart", "ap"+u"\u00EA"+"ndic",
"apetit", "aram", "arrabald", "arrebit",
"arrecif", "arremat", "artr"+u"\u00F3"+"pod", "atabaqu",
"ata"+u"\u00FA"+"d", "aug", "azedum", "azeit",
"azimut", "bacamart", "badulaqu", "bagarot",
"bagr", "bail", "balancet", "bala"+u"\u00FA"+"str",
"bald", "baldram", "baleot", "balot",
"baluart", "banquet", "baqu", "barbant",
"barit", "baronet", "barret", "barrot",
"bastonet", "bataqu", "batent", "batuqu",
"bazulaqu", "belich", "bequ", "berloqu",
"berrant", "besant", "betum", "bib",
"bicam", "bich", "bicorn", "bident",
"bif", "bigod", "bilhet", "b"+u"\u00ED"+"ped",
"biscat", "bisont", "bispot", "bitat",
"bit", "bivaqu", "blagu", "blecaut",
"bobech", "bocet", "bod", "bof",
"bofet", "boicot", "boiot",
"bond", "bonifrat", "bosqu", "bosquet",
"bot", "botoqu", "box", "bracelet",
"brand", "breloqu", "brequ", "bricabraqu",
"brilharet", "brioch", "bris", "broch",
"bronz", "brulot", "bucr", "bufet",
"bugr", "bul", "buqu", "byt",
"cabid", "cacet", "cachalot", "caciqu",
"cacoet", "cad", "cafajest", "caid",
"caingangu", "caixot", "calafat", "calhambequ",
"c"+u"\u00E1"+"lic", "calot", "camalot", "camarot",
"candomb", "canivet", "c"+u"\u00E2"+"non", "capacet",
"capot", "caracter", "carbon", "cardum",
"carm", "carpet", "cart", "casebr",
"cassetet", "caul", "cavalet", "certam",
"chal", "chantr", "chequ", "chern",
"cheviot", "chicot", "chifr", "chisp",
"chist", "chocolat", "chop", "choqu",
"chut", "ciceron", "ciclon", "ciclop",
"cineclub", "cisn", "ci"+u"\u00FA"+"m", "clarinet",
"clavinot", "clip", "cliqu", "clon",
"club", "coch", "cocot", "c"+u"\u00F3"+"dic",
"cofr", "cognom", "coic", "coiot",
"colchet", "coldr", "colet", "coliform",
"combat", "compadr", "conclav", "cond",
"con", "confet", "confrad", "conhaqu",
"c"+u"\u00F4"+"njug", "contrachequ", "contrast", "control",
"convit", "coqu", "corpet",
"corticoesteroid", "corticosteroid", "cortum", "costum",
"cotil"+u"\u00E9"+"don", "couc", "covilhet",
"coxot", "crem", "crep", "creton",
"crim", "croqu", "croquet", "cual",
"cum", "cuneiform", "cunhet", "curtum",
"debat", "debiqu", "deboch", "decalqu",
"decot", "d"+u"\u00E9"+"fic", "deleit", "dent",
"dervix", "desair", "desastr", "desplant", "deuteromicet",
"diabret", "diamant", "dichot", "dicinodont",
"dinamit", "diplont", "diqu", "disparat",
"disquet", "ditam", "dog", "dogu",
"dolomit", "drinqu", "driv", "duend",
"duqu", "eclips", "eland",
"elefant", "eletrochoqu", "embat", "enclav",
"enfart", "enfeit", "enlac", "entalh",
"ent", "envelop", "enxam", "escadot",
"escalop", "escalp", "escaparat", "escarlat",
"escroqu", "esmalt", "espadart", "esp"+u"\u00E9"+"cim",
"espermatozoid", "espinafr", "espongiform", "esport",
"esquif", "estam", "estandart", "estand",
"esteroid", "estilet", "estip",
"est"+u"\u00ED"+"pit", "estress", "estrum", "estuqu",
"eunect", "exam", "factoid", "fad",
"fagot", "falset", "fantoch",
"fanzin", "faroest", "farolet", "fat",
"fedelhot", "feix", "ferret", "fetich",
"fiacr", "fiambr", "fidalgot", "filet",
"filhot", "filiform", "filip", "film",
"filmet", "fiord", "fland", "flandr",
"flet", "floret", "fogon", "foguet",
"fol", "fon", "frad", "franchinot",
"frand", "frangot", "franquisqu", "fraqu",
"freg", "freir", "frem", "frescalhot",
"fret", "front", "fust", "fut",
"gabinet", "galeot", "galhardet", "galop",
"garrot", "gendarm", "gen", "geod",
"gerifalt", "germ", "gibanet", "gigabyt",
"ginet", "glid", "gneiss", "god",
"godem", "gol", "golp", "grafit",
"gramofon", "gravam", "grud", "grumet",
"guach", "guant", "gud", "gued",
"gum", "halter", "haplobiont", "hectar",
"heteroterm", "heterotransplant", "hidrant", "hierofant",
"holofot", "horizont", "iat",
"icebergu", "ien", "ilhot", "infart",
"ingr", "inguch", "inham", "interclub",
"interfon", "invit", "iogurt", "ipr",
"jab", "jardinet", "jarret", "jegu",
"jip", "joanet", "joguet", "joul",
"jul", "labrost", "la"+u"\u00E7"+"arot", "lacet",
"lacr", "lanch", "larot", "laud",
"lazaron", "legum", "leit", "lembret",
"l"+u"\u00EA"+"mur", "lequ", "liam", "licorn",
"liern", "limonet", "linc", "linet",
"lingot", "lipot", "livret", "lord",
"lot", "lovelac", "lugr", "lum",
"lustr", "macadam", "mac", "macet",
"machet", "magaref", "magazin", "magot",
"mainfram", "malamut", "malot", "mamut",
"mangot", "mantelet", "mapuch", "margrav",
"mascat", "massacr", "massam",
"mastodont", "matalot", "mavort", "maxil"+u"\u00ED"+"ped",
"maxix", "megabyt", "meiot", "melcatref",
"membranofon", "mendengu", "meninot", "mentastr",
"mequetref", "mestr", "microfilm", "microfon",
"micronutrient", "milagr", "mil", "milhafr",
"minaret", "minuet", "mirant", "miron",
"mixomicet", "molecot", "molequ", "monandengu",
"mong", "monovolum", "moringu", "morrot",
"mosquet", "mot", "motet", "mouch",
"mous", "mouss", "mucequ", "mujiqu",
"mussequ", "naip", "nair", "negrum",
"nepent", "nom", "nort", "novilhot",
"num", "nun", "odr", "ogr",
"optimat", "orat", "origon", "pacot",
"padr", "pagod", "palacet", "palanqu",
"palet", "palpit", "palud", "palustr",
"papelot", "parch", "par"+u"\u00EA"+"ntes", "parqu",
"passaman", "passaport", "pechisbequ", "peix",
"pelam", "pelot", "pen", "pent",
"pep", "pequenot", "perendengu", "perfum",
"pern", "pernoit", "pesadum", "p"+u"\u00EA"+"sam",
"petimetr", "petit", "pexot", "picl",
"pilot", "pinot", "pintalegr", "pintalegret",
"piparot", "pipelin", "pipot", "piqueniqu",
"piquet", "pistolet", "pivet", "ponch",
"pont"+u"\u00ED"+"fic", "porr", "porret", "post",
"pot", "potich", "prenom", "pr"+u"\u00ED"+"ncip",
"pronom", "pseud"+u"\u00F3"+"pod", "puf", "quacr",
"queixum", "quep", "quequ", "quib",
"quilat", "quilobit", "quiosqu", "quir",
"qu"+u"\u00ED"+"ri", "quirit", "quitut", "quixot",
"quocient", "rabanet", "radiotelefon", "raid",
"ralhet", "ramalhet", "ramilhet", "ran",
"rapazot", "rebenqu", "rebit", "reboqu",
"rebot", "recalqu", "recif", "reclam",
"record", "recort", "redingot", "regim",
"remoqu", "repeniqu", "repiquet", "reproch",
"requif", "requifif", "retoqu", "retrofoguet",
"reviret", "ricochet", "rifl", "ringu",
"riz"+u"\u00F3"+"pod", "rob", "robl", "rodet",
"rolet", "romanc", "romancet", "roqu",
"roquet", "rosbif", "roug", "sabonet",
"sabr", "sainet", "saiot", "salamalequ",
"salmonet", "salmoniform", "sandu"+u"\u00ED"+"ch", "sangu",
"saqu", "sax", "saxofon",
"semblant", "semestr", "serrot", "sil",
"silicon", "sinet", "sit", "skat",
"slid", "sobrenom", "soquet", "sorvet",
"sotaqu", "sub"+u"\u00ED"+"ndic", "tabef", "tablet",
"tacap", "tal", "talh", "talip", "talud",
"talvegu", "tamboret", "tanqu", "tapet",
"tapum", "tarambot", "tatam", "teatrofon",
"telefilm", "telefon", "tentam", "test",
"timbal", "timbr", "tim", "tiqu",
"t"+u"\u00ED"+"quet", "tiranet", "toalet", "toalhet",
"toilet", "told", "tolet", "tomat",
"topet", "torniquet", "t"+u"\u00F3"+"tem", "tr"+u"\u00E2"+"mit",
"transport", "traqu", "traquet", "trimestr",
"trombon", "trompet", "truqu", "trust",
"tul", "ubr", "u"+u"\u00ED"+"squ", "upanixad",
"vagonet", "valet", "vasilham", "velam",
"velhot", "veloc"+u"\u00ED"+"ped", "ventr", "verbet",
"verdet", "verm", "vernissag", "versalet",
"vexam", "videocasset", "videoclip", "videofon",
"videogam", "vilancet", "vim", "vinagr",
"vindim", "vinhet", "virot", "viscond",
"voltaret", "volum", "vombat", "v"+u"\u00F3"+"rtic",
"xail", "xal", "xarop", "xenotransplant",
"xerif", "xilofon", "xiquexiqu", "zagalot",
"ziguezagu"])



# PALAVRAS FEMININAS TERMINADAS EM  E == alface - comadre
plvrFeme = set(["aeronav", "aguardent", "alfac", "altitud",
"amiloidos", "amizad", "amplitud", "an"+u"\u00E1"+"lis",
"ant"+u"\u00ED"+"tes", "ap"+u"\u00F3"+"lic", "ap"+u"\u00F3"+"strof", "apoteos",
"art", "artrit", "artros", u"\u00E1"+"rvor",
"atitud", "autoclav", "avalanch", "av",
"bacant", "bacilos", "bacinet", "bacoric",
"bacterios", "barb"+u"\u00E1"+"ri", "bas", "basidiomicet",
"beatic", "bebedic", "b"+u"\u00E9"+"rber", "bernardic",
"bipatent", "bipir"+u"\u00E2"+"mid", "bisbilhotic", "bizarric",
"boat", "b"+u"\u00F3"+"lid", "borboletic", "boutiqu",
"brejeiric", "bronquit", "bront", "burric",
"bursit", "butiqu", "cabin", "calech",
"caminhonet", "camionet", "cari"+u"\u00E1"+"tid", "c"+u"\u00E1"+"ri",
"carn", "carolic", "casset", "cat"+u"\u00E1"+"strof",
"caturric", "celulas", "celulos", "chanc",
"charg", "charret", "chatic", "chav",
"chican", "chochic", "c"+u"\u00ED"+"clad", "cl"+u"\u00E2"+"mid",
"claqu", "class", "clav", "comadr",
"commoditi", "coort", "coqueluch", "c"+u"\u00F4"+"rt",
"cortesanic", "couv", "crech", "crendic", "cretinic",
"criancic", "cris", "c"+u"\u00FA"+"spid", "danaid",
"deb"+u"\u00EA"+"ntur", "d"+u"\u00E9"+"march", "dendrit", "dengu",
"denguic", "dermatit", "dermatos", "diaclas",
"di"+u"\u00E1"+"lis", "di"+u"\u00E1"+"stol", "di"+u"\u00E1"+"tes", "diatrib",
"dies", "dioces", "doidic", "dos",
"doutoric", "dr"+u"\u00ED"+"ad", "echarp", "ef"+u"\u00ED"+"gi", "efem"+u"\u00E9"+"rid",
"elips", "elit", "enchent", u"\u00EA"+"nfas", "enfiteus",
"enquet", "enqu"+u"\u00EA"+"t", "epiderm", "ep"+u"\u00ED"+"fis",
"ep"+u"\u00ED"+"graf", "epistax", "equimos", "equinoderm",
"equip", "esfing", "esofagit", "espa"+u"\u00E7"+"onav",
"esp"+u"\u00E1"+"dic", "esp"+u"\u00E9"+"ci", "esquisitic", "estalactit",
"estalagmit", "estant", "estenos", "estirp",
"estouvic", "estrangeiric", "estrig", "estrof",
"estroinic", "estultic", "eum"+u"\u00EA"+"nid", "exeges",
"exopeptidas", "fac", "faceiric", "falang", "fanfarronic",
"fanfreluch", "farfalhic", "fas", "fauc",
"febr", "fidalguet", "filel", "finitud",
"foic", "fom", "fosfatas", "fouc",
"francesic", "fras", "fraud", "frent",
"frol", "frond", "furunculos", "gabardin",
"gabolic", "gad", "gaf", "gaiatic",
"galanic", "galeguic", "gangu", "garag",
"gar"+u"\u00E7"+"onet", "garotic", "garridic", "garrulic",
"gastrit", "gastroenterit", "gatunic", "g"+u"\u00EA"+"nes",
"gengivit", "gent", "gland", "glicogenos",
"glomerulonefrit", "glot", "gnaiss", "g"+u"\u00F3"+"rgon",
"grad", "grev", "grif", "grip",
"gulodic", "gulosic", "habitud", "hast",
"hecatomb", "h"+u"\u00E9"+"lic", "hemap"+u"\u00F3"+"fis", "hematos",
"hemodi"+u"\u00E1"+"lis", "hemoptis", "hepatit", "hexos",
"hidrocel", "hidrolas", "hidr"+u"\u00F3"+"lis", "hip"+u"\u00E9"+"rbol",
"hip"+u"\u00F3"+"tes", "hipotipos", "idiotic", "imposturic",
"imundic", "imund"+u"\u00ED"+"ci", "incompletud", "infinitud",
"inimizad", "inquietud", "intemp"+u"\u00E9"+"ri", "interfac",
"interfas", "intrujic", "invencionic", "jambacoss",
"janotic", "jogralic", "jubart", "judit",
"juventud", "ladro"+u"\u00ED"+"c", "lag", "laj",
"lambaric", "lamechic", "lanchonet", "land",
"l"+u"\u00E1"+"pid", "laring", "lassitud", "latitud",
"lebr", "leishmanios", "lent", "leptomital",
"limousin", "limusin", "linfatit", "lingeri",
"lipas", "literatic", "lit"+u"\u00F3"+"clas", "longitud",
"louvaminhic", "macaquic", "madam", "madracic",
"madr", "magnitud", "maiones", "majestad",
"majoret", "malandret", "malandric", "malaquit",
"malcriadic", "maluquet", "maluquic", "manchet",
"mandalet", "mandaret", "manhosic", "mapl",
"maquet", "maquiavelic", "maquillag", "marinet",
"marionet", "mariquic", "maritorn", "marotic",
"marquis", "martinet", "mascot", "mastit", "matrafic",
"megal"+u"\u00F3"+"pol", "meiguic", "m"+u"\u00E9"+"nad", "m"+u"\u00EA"+"nad",
"mening", "meningit", "meninic", "merc",
"mesmic", "mes"+u"\u00F3"+"clis", "metad", "metamorfos",
"met"+u"\u00E1"+"stas", "metempsicos", "m"+u"\u00E9"+"top", "metr"+u"\u00F3"+"pol",
"mexeriquic", "micos", "miniss"+u"\u00E9"+"ri", "mir"+u"\u00ED"+"ad",
"miten", "modernic", "molenguic", "momic",
"mort", "multitud", "muss", "n"+u"\u00E1"+"iad",
"nav", "necr"+u"\u00F3"+"pol", "necros", "nefelibatic",
"nereid", "neuros", "nev", "nevros",
"niquic", "noit", "nout", "nuanc",
"nucleas", "nucleoss"+u"\u00ED"+"ntes", "oceanit", "olimp"+u"\u00ED"+"ad",
"onzenic", "ordinaric", "or"+u"\u00E9"+"ad", "osteoartros",
"overdos", "palermic", "pan", "pantomimic",
"par"+u"\u00E1"+"fras", "pared", "parlapatic", "part",
"parvo"+u"\u00ED"+"c", "patent", "patetic", "penc",
"pen"+u"\u00E9"+"lop", "pentos", "peptidas", "peraltic",
"performanc", "per"+u"\u00ED"+"fras", "perliquitet", "perric",
"pevid", "picap", "pieguic", "pios",
"pir"+u"\u00E2"+"mid", "pirit", "plan"+u"\u00ED"+"ci", "pleb",
"pl"+u"\u00EA"+"iad", "ple"+u"\u00F3"+"pod", "pol", "politiquic",
"pont", "popelin", "potestad", "prax",
"prec", "progl"+u"\u00F3"+"tid", "prol", "proteas",
"pr"+u"\u00F3"+"tes", "psicos", "quermess", "quietud",
"quimas", "quitinet", "raqu", "raquet",
"red", "repris", "retret", "revanch",
"rosal", "sabujic", "sandic", "sa"+u"\u00FA"+"d",
"sed", "seg", "sement", "s"+u"\u00E9"+"ri",
"serp", "serpent", "s"+u"\u00ED"+"lfid", "simbios",
"similitud", "s"+u"\u00ED"+"mplic", "sinaps", "s"+u"\u00ED"+"ncop",
"s"+u"\u00ED"+"ndrom", "sinops", "sintax", "s"+u"\u00ED"+"ntes",
"siren", "sirt", "sobrevest", "socialit",
"solicitud", "sort", "soviet", "sovinic",
"subclass", "subenfiteus", "subesp"+u"\u00E9"+"ci", "subpart",
"su"+u"\u00ED"+"t", "superclass", "superf"+u"\u00ED"+"ci", "sutach",
"tab", "tagarelic", "talmud",
"tard", "tart", "tempestad", "tendinit",
"tes", "teslinic", "t"+u"\u00E9"+"trad", "tirit",
"toilett", "tolic", "tontic", "torpitud",
"toss", "trafulhic", "trampolinic", "transaminas",
"trapalhic", "traquinic", "tratantic", "tremeliqu",
"trios", "tripartit", "trombos", "truanic",
"trud", "trup", "tub", "tuberal",
"tuberculos", "turbo"+u"\u00E9"+"lic", "turpitud", "urb",
"valis", "vedet", "velhic",
"vicissitud", "vigaric", "viros",
"virtud", "vitrin", "voltair", "vontad",
"zoonos"])

# PALAVRAS MASCULINAS TERMINADAS EM  Z == CARTAZ
plvrMascz = set(["albatro", "alborno", "alcatra", "alcatru", "alfo",
"algero", "algo", "almofari", "andalu", "antra",
"arcabu", "arca", "arroa", "bissetri", "caba",
"capata", "capu", "carta", "chafari", "chamari",
"entreme", "gilva", "gora", "jae", "ja",
"machaca", "mati", "ma", "nari", "pratarra",
"rapa", "reve", "ri", "verni", "xadre"])



# PALAVRAS FEMININAS TERMINADAS EM  Z == cruz - gravidez
plvrFemz = set(["atri", "avestru", "cicatri", "codorni", "cru",
"diretri", "eletromotri", "gravide", "imperatri", "languide",
"lu", "matri", "meretri", "motri", "no",
"nude", "nutri", "operatri", "pa", "pequene",
"perdi", "polide", "rectri", "sordide", "tamari",
"tectri", "timide", "ve", "vo"])



# PALAVRAS DE DOIS GENEROS TERMINADAS EM  Z == CAPAZ
plvrInvaz = set(["alfara", "aprendi", "atro", "auda", "bre",
"camba", "capa", "contuma", "efica", "fala",
"famana", "feli", "fero", "fuga", "incapa",
"inefica", "infeli", "lamba", "loqua", "menda",
"mina", "morda", "ori", "perspica", "pertina",
"peti", "prima", "pugna", "roa", "saga",
"sequa", "soe", "suspica", "tena", "torqua",
"velo", "vera", "viva", "vora"])





# EXCECAO PARA PALAVRAS TERMINADAS EM  inho == Carlinhos - Marquinhos
excInho = set(["Carl", "carl", "Marqu", "marqu"])

# EXCECAO PARA PALAVRAS MASCULINAS TERMINADAS  o == MESMO
excMist = set(["Cas", "cas", "Junt", "junt", "Mesm", "mesm"])

# EXCECAO PARA PALAVRAS MASCULINAS TERMINADAS  a == MESMA
excMista = set(["Casa", "casa", "Larga", "larga", "Mesma", "mesma", "Minha", "minha", "Sua", "sua", "Tua", "tua"])

# PALAVRAS QUE ATRAEM A PROCLISE
aProclise = set(["abaixo", "acaso", "acima", "acinte", "acol"+u"\u00E1", "adentro", "adiante",
"afinal", "afora", "agora", "a"+u"\u00ED", "al"+u"\u00E9"+"m", "algo",
"algu"+u"\u00E9"+"m", "algum", "ali", "amanh"+u"\u00E3", "ami"+u"\u00FA"+"de",
"antes", "aquela", "aquelas", "aquele", "aqueles", "aqu"+u"\u00E9"+"m", "aqui",
"aquilo", "assaz", "assim", "atr"+u"\u00E1"+"s", "bastante", "bem", "breve",
"c"+u"\u00E1", "cedo", "certa", "certo", "como", "conforme", "debalde", "decerto",
"demais", "demasiado", "dentro", "depois", "depressa", "devagar",
"diversas", "diversos", "embaixo", "enfim", "essa", "essas", "esse",
"esses", "esta", "estas", "este", "estes", "hoje", "imenso", "isso",
"isto", "l"+u"\u00E1", "longe", "mais", "mal", "melhor", "menos", "muita",
"muitas", "muito", "muitos", "ningu"+u"\u00E9"+"m", "ontem", "ora", "outra", "outras",
"outro", "outrora", "outros",
"perto", "pior", "porque", "porventura", "pouca", "poucas", "pouco", "pouco",
"poucos", "quando", "quanto", "qu"+u"\u00E3"+"o", "quase", "quer", "qui"+u"\u00E7"+u"\u00E1", "sempre",
"sim", "s"+u"\u00F3", "talvez", "tampouco", "tanto", "tarde", "tem", "t"+u"\u00EA"+"m", "temos",
"tenha", "tenham",  "tenho", "teria", "teremos", "teriam", "teve", "tinha", "tinham", "tiveram", "toda",
"todas", "todo", "todos", "tudo", "v"+u"\u00E1"+"rias", "v"+u"\u00E1"+"rios"])

# ATRAI PROCLISE
mProclise = {"abaixo": "Abaixo",
"acaso": "Acaso",
"acima": "Acima",
"acinte": "Acinte",
"acol"+u"\u00E1": "Acol"+u"\u00E1",
"adentro": "Adentro",
"adiante":"Adiante",
"afinal": "Afinal",
"afora": "Afora",
"agora": "Agora",
"a"+u"\u00ED": "A"+u"\u00ED",
"al"+u"\u00E9"+"m": "Al"+u"\u00E9"+"m",
"algo": "Algo",
"algu"+u"\u00E9"+"m": "Algu"+u"\u00E9"+"m",
"algum": "Algum",
"ali": "Ali",
"amanh"+u"\u00E3": "Amanh"+u"\u00E3",
"ami"+u"\u00FA"+"de": "Ami"+u"\u00FA"+"de",
"antes": "Antes",
"aquela": "Aquela",
"aquelas": "Aquelas",
"aquele": "Aquele",
"aqueles": "Aqueles",
"aqu"+u"\u00E9"+"m": "Aqu"+u"\u00E9"+"m",
"aqui": "Aqui",
"aquilo": "Aquilo",
"assaz": "Assaz",
"assim": "Assim",
"atr"+u"\u00E1"+"s": "Atr"+u"\u00E1"+"s",
"bastante": "Bastante",
"bem": "Bem",
"breve": "Breve",
"c"+u"\u00E1": "C"+u"\u00E1",
"cedo": "Cedo",
"certa": "Certa",
"certo": "Certo",
"como": "Como",
"conforme": "Conforme",
"debalde": "Debalde",
"decerto": "Decerto",
"demais": "Demais",
"demasiado": "Demasiado",
"dentro": "Dentro",
"depois": "Depois",
"depressa": "Depressa",
"devagar": "Devagar",
"diversas": "Diversas",
"diversos": "Diversos",
"embaixo": "Embaixo",
"enfim": "Enfim",
"essa": "Essa",
"essas": "Essas",
"esse": "Esse",
"esses": "Esses",
"esta": "Esta",
"estas": "Estas",
"este": "Este",
"estes": "Estes",
"hoje": "Hoje",
"imenso": "Imenso",
"isso": "Isso",
"isto": "Isto",
"l"+u"\u00E1": "L"+u"\u00E1",
"longe": "Longe",
"mais": "Mais",
"mal": "Mal",
"melhor": "Melhor",
"menos": "Menos",
"muita": "Muita",
"muitas": "Muitas",
"muito": "Muito",
"muitos": "Muitos",
"ningu"+u"\u00E9"+"m": "Ningu"+u"\u00E9"+"m",
"ontem": "Ontem",
"ora": "Ora",
"ou": "Ou",
"outra": "Outra",
"outras": "Outras",
"outro": "Outro",
"outrora": "Outrora",
"outros": "Outros",
"perto": "Perto",
"pior": "Pior",
"porque": "Porque",
"porventura": "Porventura",
"pouca": "Pouca",
"poucas": "Poucas",
"pouco": "Pouco",
"pouco": "Pouco",
"poucos": "Poucos",
"quando": "Quando",
"quanto": "Quanto",
"qu"+u"\u00E3"+"o": "Qu"+u"\u00E3"+"o",
"quase": "Quase",
"quer": "Quer",
"qui"+u"\u00E7"+u"\u00E1": "Qui"+u"\u00E7"+u"\u00E1",
"sempre": "Sempre",
"sim": "Sim",
"s"+u"\u00F3": "S"+u"\u00F3",
"talvez": "Talvez",
"tampouco": "Tampouco",
"tanto": "Tanto",
"tarde": "Tarde",
"tem": "Tem",
"t"+u"\u00EA"+"m": "T"+u"\u00EA"+"m",
"temos": "Temos",
"tenha": "Tenha",
"tenham": "Tenham",
"tenho": "Tenho",
"teria": "Teria",
"teremos": "Teremos",
"teriam": "Teriam",
"teve": "Teve",
"tinha": "Tinha",
"tinham":"Tinham",
"tiveram": "Tiveram",
"toda": "Toda",
"todas": "Todas",
"todo": "Todo",
"todos": "Todos",
"tudo": "Tudo",
"v"+u"\u00E1"+"rias": "V"+u"\u00E1"+"rias",
"v"+u"\u00E1"+"rios": "V"+u"\u00E1"+"rios"}



# VERBOS REGULARES TERMINADOS EM AR - RADICAL
plvrVbrar = set(["abaf", "abaix", "abal", "abaliz", "abalo", "aban",
"abarc", "abarrot", "abasm", "abast", "abelg", "abelh",
"abelhud", "aben"+u"\u00E7"+"o", "abest", "abgreg", "abilol", "abjudic",
"abjug", "abjurg", "ableg", "abneg", "aboc", "abodeg",
"abomin", "abon", "aborbot", "abort", "aboug", "abra"+u"\u00E7",
"abrand", "abrasileir", "abrevi", "abrig", "abrilhant", "abund",
"abundanci", "abus", "acab", "acalent", "acalm", "acam",
"acamp", "acanel", "acarici", "acarinh", "acarret", "acartol",
"acasal", "acastel", "acat", "acaval", "acebol", "aceit",
"acen", "acentu", "acerc", "acert", "acess", "acetin",
"ach", "achancel", "achat", "acheg", "achocalh", "achocolat",
"acident", "acidific", "aciment", "acinzent", "acion", "acirolog",
"acirr", "aclam", "aclar", "aclimat", "aclimatiz", "aco",
"acobert", "acocor", "acoit", "a"+u"\u00E7"+"oit", "acomod", "acompanh",
"aconch", "aconchav", "aconcheg", "acondicion", "acondiment", "aconselh",
"aconsonant", "acopl", "acorcov", "acorcund", "acord", "acorrent",
"acortin", "acoss", "acost", "acostum", "acotovel", "acovard",
"acredit", "acrescent", "acrian"+u"\u00E7", "acristan", "acu", "a"+u"\u00E7"+"ucar",
"acumul", "acunh", "acupuntur", "acur", "acus", "acutel",
"adapt", "adarg", "adeg", "adelg", "adeng", "adens",
"adentr", "aderg", "adi", "adiant", "adicion", "adinheir",
"adit", "adivinh", "adjetiv", "adjetiviz", "adjudic", "adjunt",
"adjur", "adjutor", "adjuv", "adlig", "administr", "admir",
"admoest", "admonest", "adnomin", "adnot", "adnumer", "ado"+u"\u00E7",
"adocic", "adoent", "ador", "adot", "adreg", "adub",
"adul", "adulter", "adun", "adverbi", "advers", "advincul",
"advoc", "advog", "advult", "aerific", "aeriz", "aerofotograf",
"aeromodel", "aeroplan", "aeroport", "aerossoliz", "aerossond", "aerotransport",
"afag", "afam", "afan", "afarinh", "afast", "afei"+u"\u00E7"+"o",
"afeijo", "afemin", "afet", "afezo", "afi", "afian"+u"\u00E7",
"afidalg", "afili", "afin", "afinc", "afirm", "afivel",
"afix", "aflameng", "afob", "afof", "afog", "afrescalh",
"afront", "afroux", "afugent", "afund", "afunil", "ag",
"agach", "agaleg", "agarr", "agasalh", "agenci", "agend",
"agigant", "agiliz", "agit", "aglomer", "aglutin", "agoniz",
"agrav", "agreg", "agrup", "aguard", "agu"+u"\u00E7", "aguent",
"agulh", "ajeit", "ajindung", "ajoelh", "ajud", "ajudeng",
"ajunt", "alag", "alambr", "alaranj", "alarg", "alastr",
"alaud", "alavanc", "alberg", "al"+u"\u00E7", "alcan"+u"\u00E7", "alcooliz",
"alcovit", "alcunh", "aldeag", "alegr", "aleij", "aleit",
"alent", "alert", "aletarg", "alevant", "alfabetiz", "alfandeg",
"algem", "alguerg", "ali", "alian"+u"\u00E7", "alicer"+u"\u00E7", "alici",
"alien", "alij", "aliment", "alinh", "alinhav", "alis",
"alist", "alivi", "almeceg", "almej", "almo"+u"\u00E7", "almofad",
"almondeg", "aloc", "aloj", "along", "alter", "altern",
"altiv", "alu", "alucin", "alug", "alum", "alumbr",
"alumi", "aluvi", "alvej", "alverg", "alvor", "alvorat",
"alvorej", "alvori"+u"\u00E7", "alvoro"+u"\u00E7", "alvorot", "alvot", "am",
"amaci", "amag", "amaldi"+u"\u00E7"+"o", "amans", "amanteig", "amarel",
"amarr", "amarrot", "amartel", "amasi", "amass", "amatung",
"amatut", "ambicion", "ambient", "amea"+u"\u00E7", "amealh", "amedront",
"amenin", "amig", "amim", "amineir", "amofin", "amoit",
"amol", "amold", "amoldur", "amolec", "amoleg", "amolent",
"amolest", "amolg", "amonto", "amoquec", "amoraliz", "amorda"+u"\u00E7",
"amoren", "amorfanh", "amorfiz", "amorisc", "amorn", "amortiz",
"amoss", "amostr", "amotin", "amour", "ampar", "ampli",
"amplific", "amput", "amu", "amulat", "amulher", "amulhereng",
"amumi", "anaboliz", "anafrag", "analgiz", "analis", "anarcis",
"anarquiz", "ancor", "and", "andaim", "andarilh", "andej",
"anedotiz", "anegr", "anegralh", "anel", "anex", "angari",
"angeliz", "angliz", "angul", "angusti", "anilh", "anim",
"animaliz", "aniversari", "anodiz", "anoit", "anoj", "anot",
"anov", "anovel", "anoxi", "ant", "antecip", "antedat",
"antepar", "antepass", "antepost", "anterioriz", "anualiz", "anul",
"anumer", "anunci", "anuvi", "apacific", "apadrinh", "apadro",
"apag", "apaixon", "apalavr", "apalm", "apalp", "apanh",
"apar", "aparament", "aparcel", "aparelh", "aparent", "aparentel",
"aparoqui", "aparreir", "apart", "aparv", "aparvalh", "aparvej",
"aparvo", "apascent", "apasco", "apassiv", "apastor", "apatron",
"apatrulh", "apaulist", "apaut", "apavor", "apavoriz", "apedr",
"apedrej", "apeg", "apej", "apel", "apelid",
"apenh", "apenhor", "apens", "apension", "apequen", "aperfei"+u"\u00E7"+"o",
"aperr", "apert", "aperu", "apesent", "apespont", "apesso",
"apincel", "apinh", "apit", "aplac", "aplain", "aplan",
"aplic", "aplum", "apoder", "apont", "apoquent", "aport",
"aportinh", "aportugues", "aposent", "aposs", "apost", "apostil",
"apostilh", "apostol", "apostrof", "apostur", "apotec", "apotent",
"apraz", "apreci", "apresent", "apresilh", "apress", "aprimor",
"aprocheg", "aprofund", "apront", "apropri", "aproveit", "aproxim",
"aprum", "aquartel", "aquebrant", "aqued", "aquiet", "ar",
"aram", "arbitr", "arboriz", "arc", "ardig", "arej",
"aren", "areng", "argol", "argument", "arisc", "arm",
"armazen", "armeng", "arquitet", "arquiv", "arraig", "arranc",
"arran"+u"\u00E7", "arranch", "arranh", "arranj", "arras", "arrast",
"arrebanh", "arrebat", "arrebent", "arrebic", "arrebit", "arrecad",
"arredr", "arrega"+u"\u00E7", "arregal", "arreganh", "arregiment", "arregr",
"arregueir", "arreig", "arremang", "arremat", "arreneg", "arreng",
"arrepi", "arrepic", "arrig", "arrisc", "arroch", "arrog",
"arrol", "arromb", "arrot", "arrox", "arru", "arrua"+u"\u00E7",
"arruf", "arrug", "arrum", "arrupi", "articul", "arvor",
"arvorej", "asfalt", "asfixi", "asneir", "aspir", "ass",
"assalari", "assalt", "assanh", "assedi", "assegur", "asseit",
"assent", "assert", "assexualiz", "assimil", "assin", "assinal",
"asso", "assoalh", "assobi", "associ", "assol", "assombr",
"assopr", "assosseg", "assunt", "assust", "atabalho", "atabern",
"atabu", "atac", "atalh", "atanaz", "ataref", "atartarug",
"atenaz", "atent", "atenu", "aterr", "aterriss", "aterriz",
"aterroriz", "atest", "ati"+u"\u00E7", "atin", "atir", "ativ",
"ato", "atoalh", "atocai", "atoch", "atoi"+u"\u00E7", "atol",
"atomiz", "aton", "atordo", "atorment", "atrac", "atrai"+u"\u00E7"+"o",
"atras", "atrel", "atribul", "atricul", "atrit", "atrofi",
"atropel", "atu", "atualiz", "atur", "aturg", "audit",
"auditor", "aug", "augur", "aument", "ausent", "auspici",
"autentic", "autentific", "autodeslig", "autograf", "autolig", "automedic",
"automotiv", "autoproclam", "autoprogram", "autopropag", "autopsi", "autoriz",
"autorrevog", "auxili", "avacalh", "avali", "avaliz", "avan"+u"\u00E7",
"avancarg", "avarg", "avari", "avassal", "aventur", "averb",
"averdug", "averdung", "avergonh", "avermelh", "avex", "avi",
"avis", "avist", "aviv", "avo", "avult", "azar",
"azed", "azeit", "azoug", "bab", "bafor", "bag",
"bagun"+u"\u00E7", "bail", "bainh", "baix", "bajog", "bajul",
"balan"+u"\u00E7", "balang", "baliz", "banc", "banh", "bard",
"barganh", "barr", "barreg", "barreir", "barric", "bast",
"batalh", "batiz", "batuc", "beberic", "beij", "beir",
"benefici", "berr", "berreg", "bestific", "betum", "bexig",
"bibliograf", "bifurc", "bimb", "bin", "bing", "biodegrad",
"biodiversific", "bioensai", "biofilosof", "biofortific", "biograf", "bisbilhot",
"bisnag", "bitol", "blef", "blog", "bocej", "bocel",
"boch", "bochacr", "bochech", "bochinch", "bod", "bodej",
"bof", "bofej", "bofet", "bog", "boi"+u"\u00E7", "boicot",
"boir", "boj", "bol", "bolach", "bolc", "bol"+u"\u00E7",
"bolcheviz", "bolet", "bolh", "bolich", "bolin",
"bomb", "bombard", "bombej", "bombi", "bombic", "bonan"+u"\u00E7",
"bon"+u"\u00E7", "bond", "bonderiz", "bonec", "bong", "bonh",
"bonific", "boquej", "boquiz", "borbolet", "borborej", "borborinh",
"borbot", "borboto", "borboton", "borbulh", "borc", "borcel",
"bord", "bordej", "borr", "borra"+u"\u00E7", "borrat", "borreg",
"borri"+u"\u00E7", "borrif", "borrisc", "bosquej", "bosquerej", "boss",
"bost", "bostej", "bot", "botec", "boto", "botoc",
"bou"+u"\u00E7", "bouch", "bour", "bovariz", "box", "brab",
"bracej", "bracteol", "brad", "bradej", "bralh", "bram",
"bramaniz", "brand", "branquej", "braquicefaliz", "bras", "brasilianiz",
"brasilific", "brasiliz", "braso", "brason", "brav", "bravej",
"brec", "brech", "breganh", "brejeir", "bretanhiz", "bretech",
"bretes", "bretess", "brevet", "brevi", "brid", "brig",
"brilh", "brilhant", "brinc", "brincalh", "brincalhot", "brind",
"brioc", "briquet", "briquit", "bris", "brit", "britaniz",
"broc", "broch", "brol", "brolh", "brom", "broncograf",
"broquel", "brosl", "bross", "brot", "brotoej", "brox",
"brum", "brumaliz", "brutaliz", "brutific", "brux", "bubui",
"bubuluc", "bu"+u"\u00E7"+"al", "bucoliz", "budo", "buf", "bufarinh",
"bugi", "bugigang", "buibil", "bul", "bulat", "bulev",
"bulh", "bumb", "bund", "bung", "bungul", "bunh",
"buquin", "burac", "burburej", "burburij", "burburinh", "burg",
"burgues", "buril", "burl", "burocratiz", "burr", "burric",
"burrific", "busc", "buscul", "bussol", "but", "butuc",
"buzeg", "buzi", "buzin", "buzul", "cabal", "cabed",
"cabl", "cabograf", "caboroc", "cabort", "cabot", "cabotin",
"cabouc", "cabraz", "cabrej", "cabriol", "cabrit", "cabroc",
"cabruc", "cabuet", "cabul", "ca"+u"\u00E7", "ca"+u"\u00E7"+"amb", "cacarej",
"cacet", "cach", "cachet", "cachimb", "cachin", "cacho",
"cachoeir", "cachuch", "cacic", "cacif", "cacimb", "ca"+u"\u00E7"+"o",
"cacofoni", "cacofoniz", "cacograf", "cacuminaliz", "cadastr", "cadaveriz",
"cadel", "cadenci", "cadinh", "cadmi", "cadmium", "caduc",
"cafang", "cafein", "cafel", "cafif", "caftin", "caftiniz",
"cafulet", "cafumb", "cafun", "cafung", "cag", "cagaliz",
"caguet", "cai", "caibr", "cain"+u"\u00E7", "cairel", "caititu",
"caixeir", "Cajam", "cal", "calabariz", "calabrot", "calaceir",
"calafet", "calafri", "calamistr", "calamoc", "calandr", "calapult",
"calc", "cal"+u"\u00E7", "calcet", "calcific", "calcin", "calcitr",
"calcograf", "calcul", "calefri", "calej", "calembur", "calemburg",
"calemburiz", "calendariz", "calh", "calhanc", "calibr", "calicul",
"caligin", "caligraf", "calm", "calorific", "caloriz", "caluni",
"calv", "calvej", "camarad", "camarinh", "camb", "cambai",
"cambalach", "cambalhot", "cambi", "cambit", "cambo", "cambr",
"cambul", "camburil", "caminh", "camoniz", "campainh",
"campan", "campanul", "campean", "campeir", "campin", "camufl",
"canaliz", "cancaniz", "cancel", "cancer", "canceriz", "candi",
"candidat", "candidiz", "candil", "candol", "candong", "canel",
"canet", "canfor", "cang", "canguerej", "canguinh", "canhon",
"canibaliz", "canoniz", "canoriz", "cans", "cant", "cantacant",
"cantarej", "cantaric", "cantarid", "cantarol", "cantorinh", "canud",
"canutilh", "caotiz", "cap", "capacit", "capang", "caparazon",
"capataz", "capeng", "capiang", "capin", "capisc", "capit",
"capitaliz", "capitul", "capoeir", "capot", "caprich", "caprific",
"capsul", "capt", "captur", "capuch", "caquerej", "caquin",
"caracol", "caracolej", "caracteriz", "carambol", "caramel", "carameliz",
"caraminhol", "caramunh", "carang", "caranguej", "caranguejol", "carantonh",
"carapet", "carateriz", "carbon", "carbonat", "carbonet", "carbonific",
"carbonil", "carbonitrogen", "carboniz", "carboret", "carboxil", "carbur",
"carburiz", "carcach", "carcav", "carcer", "card", "cardanh",
"cardiovasculariz", "cardiovasculiz", "cardu"+u"\u00E7", "caren", "carep", "carg",
"carguej", "cari", "caric", "caricatur", "carici", "carij",
"carimb", "carmesin", "carmin", "carn", "carnaliz", "carnavaliz",
"carneir", "carnific", "caroc", "carop", "carp", "carpent",
"carpet", "carpinteir", "carpintej", "carr", "carrameliz", "carrapat",
"carreg", "carrej", "carret", "carril", "carrilh", "carrilhon",
"carrinh", "carruaj", "cart", "cartabux", "carteliz", "cartilaginific",
"cartograf", "carton", "cartorializ", "caruj", "carunch", "carvej",
"carvoej", "cas", "casal", "casamat", "casament", "casbi",
"casc", "cascabulh", "cascalh", "cascat", "cascavel", "cascavilh",
"cascunh", "caseific", "casmurr", "caspach", "casquej", "casquilh",
"casquin", "cass", "cassumbul", "castanhol", "castelhaniz", "casti"+u"\u00E7",
"castific", "castig", "castr", "castramet", "castrin", "cat",
"cataboliz", "catadupej", "catalis", "cataliz", "catalog", "catalogiz",
"catan", "cataplasm", "catapult", "catecumeniz", "catedratiz", "categoriz",
"catequiz", "cateteriz", "catimb", "cating", "catit", "cativ",
"catoliciz", "catoliz", "catoniz", "catraceg", "catrafi", "catrafil",
"catrai", "catrapisc", "catuc", "caturr", "caturrit", "cauchut",
"caucion", "caudilh", "caulific", "caulin", "cauliniz", "caurin",
"caus", "causaliz", "caustic", "caustific", "cautel", "cauteri",
"cauteriz", "cav", "cavac", "cavalg", "cavalo", "cavatin",
"cavern", "cavid", "cavil", "cavilh", "cavit", "cavoc",
"cavouc", "cavuc", "cavumbul", "caxing", "cedilh", "cefaliz",
"ceg", "ceif", "ceiv", "celebr", "celebriz", "celeum",
"celific", "celticiz", "celtiz", "celulariz", "celv", "cement",
"cendr", "censoriz", "censur", "censuriz", "centelh", "centissecul",
"centoniz", "centr", "centraliz", "centrific", "centrifug", "centupl",
"centuplic", "ceot", "cepilh", "cer", "cerabel", "cerabol",
"ceramoplasm", "ceratiniz", "cerc", "cercilh", "cerebel", "cerebraliz",
"ceresit", "cerific", "cerimoni", "cerimonializ", "ceringonh", "cern",
"cerr", "cert", "certific", "cervej", "cesariz", "cespit",
"cess", "cesur", "cetoderiv", "cetoniz", "cev", "chaba"+u"\u00E7",
"chabouc", "cha"+u"\u00E7", "chacin", "chacoalh", "chacolh", "chafalh",
"chafund", "chafurd", "chag", "chair", "chal", "chala"+u"\u00E7",
"chaldr", "chaleir", "chalr", "cham", "chamalot", "chamboc",
"chambreg", "chameg", "chamej", "champ", "champanhiz", "chamusc",
"chanasc", "chanc", "chancel", "chanel", "chanfalh", "chanfr",
"chang", "changueir", "chanquelh", "chant", "chantaj", "chanto",
"chap", "chapej", "chapi"+u"\u00E7", "chapilh", "chapin", "chapinh",
"chapisc", "chapod", "chapolet", "chapot", "chapu"+u"\u00E7", "chapuj",
"chapulh", "chapuz", "chaqui"+u"\u00E7", "charabald", "charamel", "charang",
"charavisc", "charing", "charivariz", "charl", "charo", "charol",
"charond", "charrisc", "charru", "charut", "chasc", "chasquin",
"chatin", "chauviniz", "chavanisc", "chavasc", "chavet", "chec",
"chefi", "cheg", "cheir", "cheiret", "cheiric", "cheirin",
"cheld", "chelindr", "cheravasc", "chi", "chiang", "chiat",
"chib", "chibat", "chi"+u"\u00E7", "chicalh", "chican", "chich",
"chichel", "chichi", "chichil", "chichorrobi", "chicot", "chifr",
"chileniz", "chilid", "chilr", "chimbi", "chimp", "chin",
"chinc", "chincalh", "chinch", "chinel", "chinfr", "chinfrin",
"chiniz", "chiqueir", "chisc", "chisn", "chisp", "choc",
"chocalej", "chocalh", "choch", "chocolat", "chofer", "chofr",
"choin", "choit", "chon", "chor", "choramig", "choraming",
"chorinc", "chorococ", "chorr", "chorrilh", "chorrisc", "chot",
"choup", "chous", "chouss", "chout", "chu"+u"\u00E7", "chuch",
"chuchu", "chuet", "chuf", "chuma"+u"\u00E7", "chumb", "chumbreg",
"chumbut", "chup", "chupinh", "chupist", "chupit", "churd",
"churin", "churri", "chusm", "chut", "chuvenisc", "chuverisc",
"chuvilh", "chuvinh", "chuvisc", "ci", "cianet", "cianiz",
"cianogen", "cianos", "cianur", "cib", "cibernetiz", "cicatriz",
"cicer", "ciceronianiz", "ciceroniz", "cici", "cicliz", "cientific",
"cif", "cifr", "cigan", "cigarr", "cilh", "cilici",
"cilindr", "cimbr", "ciment", "cinc", "cinch", "cinchoniz",
"cincunval", "cineangiocardiograf", "cineangiocoronariograf", "cinecoronariograf", "cinefic", "cinegraf",
"cinematiz", "cinematograf", "cinemiz", "ciner", "cingul", "cint",
"cintil", "cintur", "cinz", "cinzel", "cipo", "cirand",
"circi", "circin", "circuit", "circunaveg", "circuncentr", "circuncid",
"circuncircul", "circund", "circundut", "circungir", "circunrod", "circunson",
"circunspeccion", "circunspecion", "circunst", "circunstanci", "circunstancializ", "circunstancion",
"circuntorn", "circunvag", "circunval", "circunvizinh", "circunvo", "ciriliz",
"cis", "cisalh", "cisc", "cisel", "cism", "cisp",
"cistorradiograf", "cit", "citariz", "citograf", "citol", "citolis",
"cium", "civiliz", "cizan", "cizani", "cizel", "clam",
"clangor", "clangorej", "claraboi", "clarej", "clarific", "clarimostr",
"clarin", "classiciz", "classific", "claudic", "claustr", "clausul",
"clausur", "clav", "claveliz", "clemenci", "cleopatriz", "clericaliz",
"clic", "climatiz", "clinic", "clinqueriz", "clip", "clis",
"clisteriz", "cliv", "cloc", "clon", "clor", "cloraliz",
"cloretiliz", "cloritiz", "cloriz", "cloroderiv", "clorofil", "cloroform",
"cloroformiz", "clorossulfon", "clorovaporiz", "co", "coabit", "coacerv",
"coact", "coadapt", "coadat", "coadjuv", "coadministr", "coadun",
"coagit", "coaglutin", "coagment", "coagul", "coalh", "coaliz",
"coangust", "coanh", "coapostol", "coapt", "coarct", "coarrend",
"coart", "coassin", "coassoci", "coat", "coax", "cobalt",
"cobaltiz", "cobi"+u"\u00E7", "cobr", "cobrej", "coc", "co"+u"\u00E7",
"cocainiz", "coch", "cochich", "cochil", "cochin", "cocient",
"cocontrat", "cocor", "cocori", "cocoric", "cocri", "cocul",
"codej", "codemand", "codific", "codilh", "codinh", "codiz",
"codomin", "coedit", "coeduc", "coelabor", "coerd", "coestrel",
"cofi", "cofinanci", "cofinh", "cofund", "cogi", "cogit",
"cognomin", "cogul", "cogumel", "coicinh", "coif", "coigual",
"coim", "coimper", "coin", "coinch", "coinciner", "coindic",
"coinfect", "coinici", "coinquin", "cointegr", "cointeress", "coiquinh",
"coira"+u"\u00E7", "coirman", "cois", "coisific", "coit", "coivar",
"col", "colabor", "colacion", "colapis", "colaps", "colchet",
"colcho", "colecion", "colecistograf", "colect", "coleg", "colet",
"coletiviz", "colg", "colider", "colig", "colim", "colimit",
"colitig", "colm", "colma"+u"\u00E7", "colmat", "coloc", "colodion",
"coloniz", "colopliz", "coloqui", "color", "coloriz", "colostomiz",
"colquiciniz", "colt", "coltariz", "colubrej", "colui", "colun",
"comand", "comandit", "comarc", "combin", "combor"+u"\u00E7", "combust",
"come"+u"\u00E7", "comedi", "comemor", "comend", "comensur", "coment",
"comerci", "comercializ", "comich", "comil", "comin", "coministr",
"comir", "comisc", "comiser", "comissari", "comission", "comistur",
"comocion", "comod", "comonomeriz", "comor", "compact", "compactu",
"compadr", "compagin", "companh", "compar", "comparticip", "compartilh",
"compartiment", "compartimentaliz", "compass", "compatibiliz", "compe"+u"\u00E7", "compeg",
"compendi", "compenetr", "compens", "compermut", "compil", "complain",
"complan", "complei"+u"\u00E7"+"o", "complement", "complet", "complex", "complexific",
"complic", "complici", "compliz", "complot", "comport", "compr",
"compromiss", "comprov", "compugn", "compuls", "compurg", "comput",
"computadoriz", "computatoriz", "computoriz", "comud", "comung", "comunic",
"comunitariz", "comuniz", "comut", "conap", "conaturaliz", "con"+u"\u00E7",
"concaniz", "concaten", "concav", "conceitu", "conceitualiz",
"concelebr", "concentr", "concentraliz", "conceptualiz", "concert", "concession",
"conch", "conchav", "concheg", "concili", "concion", "concit",
"conclam", "concomit", "concord", "concrecion", "concret", "concretiz",
"concri", "concubin", "conculc", "concultur", "concurs", "concurv",
"condecor", "conden", "condens", "condess", "condici", "condicion",
"condign", "condiment", "condo", "condrific", "conduplic", "condut",
"conect", "conectoriz", "conet", "conexion", "confabul", "confeccion",
"confeder", "confei"+u"\u00E7"+"o", "confeit", "conferenci", "confess", "confi",
"conficion", "confidenci", "configur", "confin", "confirm", "confisc",
"conflagr", "conflit", "conflitu", "conform", "conformaliz", "confort",
"confratern", "confraterniz", "confric", "confront", "confusion", "confut",
"congalardo", "congel", "congemin", "congener", "congestion", "conglob",
"conglomer", "conglutin", "congonh", "congra"+u"\u00E7", "congraci", "congratul",
"congreg", "conhaquiz", "conjectur", "conjeitur", "conjetur", "conjug",
"conjumin", "conjunt", "conjur", "conjurament", "conlui", "conomin",
"conot", "conquist", "consagr", "consarcin", "consciencializ", "conscienciz",
"conscientiz", "consecr", "conselh", "conselheir", "consensualiz", "consert",
"conserv", "consider", "consign", "consignific", "conso", "consoant",
"consoci", "consogr", "consol", "consolid", "conson", "consonantiz",
"consorci", "conspir", "conspurc", "const", "constat", "constel",
"constern", "constip", "constitucionaliz", "consubstanci", "consult", "consum",
"consumeriz", "cont", "contabiliz", "contact", "contagi", "contamin",
"contat", "conteir", "contempl", "contemporiz", "content", "contentoriz",
"contest", "contextu", "contextualiz", "contingenci", "continu", "contorcion",
"contorn", "contorv", "contrabalan"+u"\u00E7", "contraband", "contracambi", "contracen",
"contracol", "contracunh", "contradan"+u"\u00E7", "contradeclar", "contradit", "contraestimul",
"contrafort", "contraindic", "contrainform", "contramalh", "contramand", "contramanifest",
"contramanobr", "contramarc", "contramarch", "contramin", "contraminut", "contramold",
"contramur", "contranivel", "contraorden", "contrapedal", "contrapes", "contrapont",
"contraprotest", "contraprov", "contrapun"+u"\u00E7"+"o", "contrari", "contrarraciocin", "contrarreform",
"contrarregr", "contrarreplic", "contrarrept", "contrarrevolt", "contrarrevolucion", "contrassalv",
"contrassegur", "contrassel", "contrast", "contrat", "contratel", "contratestemunh",
"contratir", "contratualiz", "contraval", "contravent", "contrist", "control",
"contubern", "conturb", "conumer", "conurb", "convalid", "convencion",
"convencionaliz", "conveni", "conventicul", "convers", "conversalh", "convibr",
"convid", "convizinh", "convoc", "convol", "convuls", "convulsion",
"coob", "coobrig", "coocup", "coofici", "coonest", "cooper",
"coopt", "coorden", "coorient", "coossific", "cop", "coparticip",
"copatrocin", "copeir", "copej", "copel", "copi", "copidesc",
"copil", "copilot", "copiograf", "coplan", "copod", "copolimeriz",
"coprocess", "coptiz", "copul", "coqueific", "cor", "coraliz",
"corandel", "corc", "corcov", "cordo", "coreograf", "corisc",
"corn", "cornach", "cornej", "cornific", "cornitromb", "cornud",
"coro", "corograf", "coronariograf", "corporaliz", "corporific", "corporiz",
"corpusculiz", "correlacion", "correlat", "corresponsabiliz", "corret", "correx",
"corric", "corrich", "corrip", "corrobor", "corroteiriz", "corruchi",
"corrug", "corrupi", "cort", "cortej", "cortilh", "cortin",
"coruj", "corunh", "corusc", "corvej", "coscor", "coscorej",
"coscuvilh", "cosic", "cosip", "cosmin", "cosmopolitiz", "cosmopoliz",
"cossegur", "costel", "costum", "costur", "cot", "cotanilh",
"cotej", "coti", "cotidianiz", "cotiz", "coton", "cotovel",
"cotul", "cotutel", "cou"+u"\u00E7", "coucinh", "coudel", "coura"+u"\u00E7",
"courel", "cous", "cousific", "cout", "couv", "covach",
"covend", "cozinh", "craion", "crani", "craquej", "craticul",
"crav", "cravej", "cravin", "credenci", "credibiliz", "credit",
"crel", "crem", "cremoriz", "cren", "creolin", "creosot",
"crepit", "crepusculej", "crepusculiz", "cresp", "crest", "cretific",
"cretiniz", "cri", "cricril", "crimin", "criminaliz", "crimp",
"criocauteriz", "crioconcentr", "criodessec", "criptanalis", "criptoanalis", "criptograf",
"cris", "crisalid", "crism", "crisol", "crisp", "cristaliz",
"cristianiz", "cristologiz", "critic", "critiquiz", "criv", "crocidiz",
"crocit", "crom", "cromatiz", "cromatolis", "cromiz", "cromofotograv",
"cromofotolit", "cromofototipograv", "cromofotozincograv", "cromograv", "cromolitograv", "cromotipi",
"cromotipograv", "cromoxilograf", "cromoxilograv", "cromozincograv", "cromozincolitograv", "cromozincotipograv",
"cronic", "croniquiz", "croniz", "cronogoniometr", "cronometr", "cronoprojet",
"cronotaquimetr", "cronotelemetr", "crotoniz", "cruci", "crucific", "crucifix",
"crucigi", "cruent", "crustific", "cruz", "cuanh", "cuarl",
"cub", "cubaniz", "cubic", "cubific", "cuc", "cucul",
"cucurbit", "cucuric", "cucurit", "cuf", "cugi", "cuid",
"cuil", "cuinch", "cuinh", "cuji", "culap", "culatr",
"culc", "culim", "culmin", "culp", "culpabiliz", "cultiv",
"cultu", "culturaliz", "cumplici", "cumpriment", "cumul", "cungugut",
"cunh", "cuoz", "cur", "curariz", "curatel", "curet",
"curi", "curiband", "curibot", "curios", "curr", "curs",
"cursometr", "curuc", "curv", "curvej", "curvet", "curvigraf",
"cuspilh", "cuspinh", "cust", "custodi", "customiz", "cutil",
"cutiniz", "cutis", "cutivacin", "cutuc", "dactilograf", "dadiv",
"daguerreotip", "daltoniz", "damasquin", "damej", "dan", "dan"+u"\u00E7",
"dan"+u"\u00E7"+"aric", "dan"+u"\u00E7"+"arin", "dandin", "danific", "daninh", "dard",
"dardej", "dat", "datilograf", "dealb", "dealv", "deambul",
"dearticul", "deaur", "deb", "debac", "debag", "deband",
"debang", "debel", "debentur", "debic", "debilit", "debit",
"deblater", "deboch", "deboi"+u"\u00E7", "deborc", "debord", "debot",
"debou"+u"\u00E7", "debras", "debrid", "debru", "debru"+u"\u00E7", "debulh",
"debut", "debux", "decalc", "decalv", "decamp", "decant",
"decap", "decapit", "decein", "decemplic", "decentraliz", "decep",
"decepcion", "decert", "decifr", "decilitr", "decim", "decimaliz",
"declam", "declar", "declin", "decliv", "deco", "decodific",
"decol", "decor", "decortic", "decot", "decrement", "decrepit",
"decret", "decript", "decru", "decup", "decupl", "decuplic",
"decuri", "decurs", "decuss", "ded", "dedecor", "dedetiz",
"dedic", "dedign", "dedilh", "dedur", "defas", "defec",
"defenestr", "defens", "defibril", "definh", "deflacion", "deflag",
"deflagr", "deflegm", "deflexion", "deflor", "deform", "defraud",
"defront", "defum", "defunt", "degas", "degast", "degel",
"degener", "deglobuliz", "degol", "degot", "degrad", "degran",
"degred", "degringol", "degust", "deific", "deioniz", "deit",
"deix", "dejarret", "dejeju", "dejet", "delagrimej", "delapid",
"delat", "deleg", "deleit", "delet", "delga"+u"\u00E7", "delib",
"deliber", "delici", "delig", "delimit", "deling", "delir",
"delivr", "delong", "demand", "demarc", "demasi", "dement",
"demitiz", "democratiz", "demodul", "demograf", "demolh", "demonetiz",
"demoniz", "demonstr", "demor", "demostr", "demud", "deneg",
"denerv", "denod", "denomin", "denot", "dens", "densific",
"dent", "dentel", "denticul", "denud", "denunci", "depar",
"departamentaliz", "depauper", "depen", "dependur", "depenic", "depil",
"deplor", "deplum", "depolariz", "depolm", "depopul", "deport",
"deposit", "deprav", "deprec", "depreci", "depred", "depress",
"depur", "deput", "dequit", "deriv", "derog", "derrab",
"derraig", "derram", "derranc", "derrap", "derratiz", "derreg",
"derreig", "derrelh", "derreng", "derrepast", "derrib", "derri"+u"\u00E7",
"derrisc", "derroc", "derro"+u"\u00E7", "derroch", "derrog", "derronch",
"derrot", "derrub", "dervirg", "des", "desab", "desabaf",
"desabal", "desabaliz", "desabalro", "desabanc", "desabast", "desabeir",
"desabelh", "desaben"+u"\u00E7"+"o", "desabez", "desabilit", "desabit", "desabitu",
"desaboc", "desabo"+u"\u00E7", "desabon", "desaborc", "desabord", "desabotin",
"desaboto", "desabra"+u"\u00E7", "desabragal", "desabrasileir", "desabrig", "desabroch",
"desabrolh", "desabus", "desacadel", "desa"+u"\u00E7"+"aim", "desacam", "desa"+u"\u00E7"+"am",
"desacamarad", "desacamp", "desacanalh", "desacanh", "desacaravelh", "desacasal",
"desacat", "desacaudel", "desacaudilh", "desacautel", "desacaval", "desaceit",
"desaceler", "desacentu", "desacer", "desacerb", "desacert", "desacheg",
"desachorum", "desacident", "desacidific", "desacidul", "desacism", "desaclim",
"desaclimat", "desacobard", "desacoch", "desacoim", "desacoit", "desacolchet",
"desacolcho", "desacolher", "desacomod", "desacompanh", "desacompass", "desaconcheg",
"desaconselh", "desacopl", "desacora"+u"\u00E7"+"o", "desacor"+u"\u00E7"+"o", "desacord", "desacoro"+u"\u00E7"+"o",
"desacorrent", "desacost", "desacostum", "desacoto", "desacout", "desacovard",
"desacrav", "desacravelh", "desacredit", "desacu", "desacumul", "desacunh",
"desacur", "desadapt", "desadens", "desadere"+u"\u00E7", "desadestr", "desadjetiv",
"desadministr", "desadmoest", "desador", "desadorment", "desadorn", "desaduch",
"desadul", "desadun", "desadvog", "desaer", "desafag", "desafaim",
"desafam", "desafast", "desafei"+u"\u00E7"+"o", "desafeit", "desaferr", "desaferro",
"desaferrolh", "desaferrolho", "desafervor", "desafet", "desafi", "desafigur",
"desafilh", "desafin", "desafiuz", "desafivel", "desafix", "desafog",
"desafolh", "desafor", "desaforr", "desafortun", "desafrances", "desafregues",
"desafreim", "desafront", "desafu", "desafueir", "desafum", "desafund",
"desafusc", "desagalardo", "desagalinh", "desagalo", "desagalon", "desagarr",
"desagasalh", "desagast", "desagend", "desaglomer", "desagoir", "desagoni",
"desagour", "desagrad", "desagrav", "desagreg", "desagrilho", "desagrup",
"desaguach", "desaguax", "desagu"+u"\u00E7", "desaguis", "desain", "desair",
"desajeit", "desajouj", "desajud", "desajunt", "desajust",
"desalag", "desalap", "desalarg", "desalarm", "desalastr", "desalbard",
"desalcaliz", "desalcan"+u"\u00E7", "desalcatro", "desalcoil", "desaleald", "desalegr",
"desaleit", "desalent", "desalergiz", "desalfai", "desalfandeg", "desalforj",
"desalgem", "desali", "desalicer"+u"\u00E7", "desalij", "desalinh", "desalinhav",
"desalist", "desalivi", "desalm", "desalmej", "desaloc", "desalogen",
"desaloj", "desalquil", "desalter", "desalug", "desalumbr", "desalvor",
"desam", "desamachuc", "desamain", "desamalgam", "desamament", "desamanceb",
"desamaneir", "desamanh", "desamant", "desamantilh", "desamarinh", "desamarinheir",
"desamarr", "desamarrot", "desamartel", "desamass", "desambicion", "desambient",
"desambigu", "desambiguiz", "desamealh", "desamedront", "desamid", "desamig",
"desamim", "desamin", "desaminiz", "desamist", "desamnisti", "desamodorr",
"desamoed", "desamoest", "desamofin", "desamolg", "desamont", "desamonto",
"desamortalh", "desamortiz", "desamotin", "desamouc", "desampar", "desamu",
"desamur", "desamuriz", "desanacroniz", "desanalfabetiz", "desanc", "desancor",
"desand", "desanel", "desanex", "desangeliz", "desangusti", "desanich",
"desanil", "desanim", "desanimaliz", "desanimiz", "desaninh", "desanisti",
"desanoj", "desanul", "desanuvi", "desapacient", "desapadrinh", "desapadro",
"desapag", "desapaixon", "desaparafus", "desaparelh", "desaparent", "desapart",
"desapassion", "desapavor", "desape"+u"\u00E7"+"onh", "desape"+u"\u00E7"+"onhent", "desapeg", "desapeir",
"desapen", "desapendo", "desapens", "desaperr", "desapert", "desapiad",
"desapied", "desaplic", "desapoder", "desapolvilh", "desapont", "desapoquent",
"desaportugues", "desaposent", "desaposs", "desapre"+u"\u00E7", "desapreci", "desapresilh",
"desapress", "desaprest", "desaprimor", "desaproposit", "desapropri", "desaprov",
"desaproveit", "desaprovision", "desaproxim", "desaprum", "desapur", "desaquartel",
"desaqueren"+u"\u00E7", "desaquerenci", "desaquinho", "desar", "desaranh", "desarboriz",
"desarc", "desarej", "desarest", "desargent", "desargentiz", "desarist",
"desarm", "desarmadilh", "desarmoniz", "desarom", "desaromaliz", "desaromatiz",
"desarquitet", "desarquiv", "desarraig", "desarranc", "desarranch", "desarranh",
"desarranj", "desarrazo", "desarreat", "desarrebit", "desarred", "desarredond",
"desarrega"+u"\u00E7", "desarreig", "desarremedi", "desarreneg", "desarrest", "desarreves",
"desarrig", "desarrim", "desarrinc", "desarrisc", "desarroch", "desarrolh",
"desarrot", "desarroup", "desarru", "desarruf", "desarrug", "desarrulh",
"desarrum", "desarterializ", "desarticul", "desartilh", "desarvor", "desas",
"desasn", "desaspir", "desassanh", "desassazo", "desassazon", "desassel",
"desasselvaj", "desassemelh", "desassent", "desassest", "desassimil", "desassimilh",
"desassinal", "desassis", "desassoci", "desassolv", "desassom", "desassombr",
"desassosseg", "desassunt", "desassust", "desastr", "desat", "desatabaf",
"desatac", "desatafulh", "desatapet", "desatapulh", "desatarrax", "desatasc",
"desataud", "desatavi", "desatedi", "desatemor", "desatemoriz", "desatent",
"desaterr", "desatest", "desatilh", "desatin", "desativ", "desatoch",
"desatol", "desatordo", "desatrac", "desatranc", "desatravanc", "desatravess",
"desatrel", "desatrem", "desatribul", "desatualiz", "desaug", "desautor",
"desautoriz", "desauxili", "desavacalh", "desavag", "desavantaj", "desaventur",
"desaverb", "desavergonh", "desavex", "desavez", "desavi", "desavigor",
"desavilt", "desavinc", "desavinh", "desavis", "desavist", "desaviv",
"desavolum", "desavult", "desaz", "desazinhavr", "desazot", "desbab",
"desbabeliz", "desbadal", "desbag", "desbago", "desbagulh", "desbalan"+u"\u00E7",
"desbal"+u"\u00E7", "desbalis", "desbaliz", "desbals", "desbamb", "desbanaliz",
"desbanc", "desband", "desbandalh", "desbandeir", "desbar", "desbarat",
"desbarb", "desbarbariz", "desbarr", "desbarranc", "desbarret", "desbarrig",
"desbast", "desbastard", "desbatiz", "desbatoc", "desbei"+u"\u00E7", "desbenzoil",
"desbenzol", "desbestializ", "desbic", "desbitol", "desbobin", "desboc",
"desbolin", "desbolot", "desboqueir", "desborc", "desborcel", "desborcin",
"desbord", "desboro", "desborr", "desbot", "desboto", "desbrag",
"desbrasileir", "desbrav", "desbravej", "desbrec", "desbri", "desbrid",
"desbrinc", "desbritaniz", "desbro", "desbroch", "desbrot", "desbrum",
"desbrutaliz", "desbuch", "desbulh", "desbund", "desburocratiz", "desburric",
"desburrific", "desbutaniz", "descaba"+u"\u00E7", "descabel", "desca"+u"\u00E7", "descacha"+u"\u00E7",
"descachel", "descachol", "descadastr", "descadeir", "descafein", "descafeiniz",
"descafel", "descal", "descalabr", "descalavr", "descal"+u"\u00E7", "descalcet",
"descalcific", "descalcin", "descalho", "descalibr", "descali"+u"\u00E7", "descalv",
"descam", "descamb", "descambimb", "descambulh", "descaminh", "descamis",
"descamp", "descan", "descancar", "descancel", "descanch", "descandaliz",
"descanel", "descang", "descangalh", "descangot", "descanhot", "descanjic",
"descans", "descant", "descap", "descapacit", "descapel", "descapitaliz",
"descapot", "descapsul", "descar", "descaracteriz", "descarapu"+u"\u00E7", "descarateriz",
"descarbon", "descarbonat", "descarbonet", "descarboniz", "descarboxil", "descarbur",
"descarburiz", "descarg", "descarn", "descarnaliz", "descarnardesenterr", "descarniz",
"descaro"+u"\u00E7", "descarol", "descarr", "descarreg", "descarreir", "descarret",
"descarri", "descarril", "descarrilh", "descart", "descarteliz", "descartorializ",
"descas", "descasal", "descasc", "descasp", "descasquej", "descasul",
"descatequiz", "descativ", "descatoliz", "descaud", "descautel", "descav",
"descavalg", "descaveir", "descaxel", "descefaliz", "desceg", "descelulariz",
"descement", "descentr", "descentraliz", "descep", "descerc", "descerebel",
"descerebr", "descerebriz", "descerr", "deschancel", "deschapel", "deschumb",
"descicliz", "descifr", "descimbr", "desciment", "desciminaliz", "descint",
"descintr", "desciviliz", "desclassific", "desclor", "descloret", "descloroformiz",
"descoagul", "descoalh", "descoc", "descoch", "descodific", "descofr",
"descogot", "descoif", "descoim", "descoit", "descoivar", "descol",
"descolg", "descolm", "descoloc", "descoloniz", "descolor", "descoloriz",
"descomand", "descombin", "descomission", "descompact", "descompadr", "descompagin",
"descompanh", "descomparticip", "descompartiment", "descompartimentaliz", "descompass", "descompatibiliz",
"descompens", "descompil", "descomplic", "descompromiss", "descomung", "desconceitu",
"desconcentr", "desconcert", "desconchav", "desconcheg", "desconcili", "desconcord",
"descondens", "descondicion", "desconect", "desconfeit", "desconfess", "desconfi",
"desconfigur", "desconform", "desconfort", "desconfront", "descongel", "descongestion",
"desconjug", "desconjunt", "desconjur", "desconsagr", "desconsert", "desconsider",
"desconsol", "desconstitucionaliz", "descont", "descontagi", "descontamin", "descontent",
"descontentoriz", "descontextualiz", "descontingenci", "descontinu", "descontrat", "descontrol",
"desconturb", "desconvers", "desconvid", "desconvoc", "descoorden", "descop",
"descor", "descorch", "descor"+u"\u00E7"+"o", "descord", "descorn", "descoro",
"descoro"+u"\u00E7"+"o", "descorporiz", "descorrelacion", "descorrent", "descortej", "descortic",
"descorti"+u"\u00E7", "descortin", "descoruch", "descost", "descostum", "descostur",
"descoto", "descout", "descrav", "descraveir", "descravej", "descraviz",
"descredenci", "descredibiliz", "descredit", "descrem", "descrimin", "descriminaliz",
"descriptograf", "descrist", "descristianiz", "descrom", "descruz", "descuid",
"desculatr", "desculp", "desculpabiliz", "descultiv", "descultu", "descultur",
"descunh", "descupiniz", "descur", "descurv", "descuscut", "desdeix",
"desdemoniz", "desdenh", "desdenomin", "desdent", "desdiagram", "desdiferenci",
"desdob", "desdobr", "desdoir", "desdour", "desdoutrin", "desdramatiz",
"deseclips", "deseconomiz", "desedific", "deseduc", "desefemin", "deseiv",
"deseix", "desej", "deseletriz", "deselimin", "deselitiz", "desema"+u"\u00E7",
"desemadeir", "desemal", "desemalh", "desemalhet", "desemaranh", "desematilh",
"desemba"+u"\u00E7", "desembaci", "desembainh", "desembal", "desembals", "desembalsam",
"desembandeir", "desembara"+u"\u00E7", "desembaralh", "desembarc", "desembarg", "desembarr",
"desembarranc", "desembarrig", "desembarril", "desembati", "desembaul", "desembebed",
"desembei"+u"\u00E7", "desembest", "desembezerr", "desembirr", "desemblinh", "desemboc",
"desembol", "desembols", "desemborc", "desemborr", "desemborrach", "desemborrasc",
"desembosc", "desembot", "desembra"+u"\u00E7", "desembrai", "desembram", "desembrech",
"desembrenh", "desembriag", "desembrid", "desembrion", "desembrom", "desembrulh",
"desembrum", "desembrusc", "desembrux", "desembu"+u"\u00E7", "desembuch", "desemburilh",
"desemburr", "desemburric", "desemed", "desemend", "desemetiniz", "desemo"+u"\u00E7",
"desemoglobiniz", "desemoinh", "desemoldur", "desemp", "desempac", "desempacavir",
"desempach", "desempacot", "desempadralh", "desempal", "desempalh", "desempalm",
"desempan", "desempandeir", "desempanturr", "desempap", "desempapel", "desempar",
"desemparceir", "desempared", "desemparelh", "desempast", "desempastel", "desempat",
"desempaves", "desempe"+u"\u00E7", "desempecilh", "desempe"+u"\u00E7"+"onh", "desempedr", "desempeflig",
"desempeg", "desempen", "desempenc", "desempenh", "desempern", "desemperr",
"desempertig", "desempest", "desempilh", "desempin", "desemplast", "desemplastr",
"desemplum", "desempo", "desempo"+u"\u00E7", "desempoeir", "desempol", "desempoleir",
"desempolg", "desempolh", "desemposs", "desempreg", "desemprenh", "desempro",
"desempunh", "desemulsific", "desemulsion", "desenamor", "desenastr", "desenat",
"desencab", "desencabe"+u"\u00E7", "desencabel", "desencabrest", "desencabrit", "desencabul",
"desencach", "desencacha"+u"\u00E7", "desencadern", "desencadilh", "desencafif", "desencafu",
"desencaipor", "desencaix", "desencaixilh", "desencaixot", "desencalacr", "desencalh",
"desencalm", "desencamarad", "desencamb", "desencaminh", "desencamis", "desencamp",
"desencan", "desencanalh", "desencanastr", "desencang", "desencangalh", "desencant",
"desencanto", "desencap", "desencapar", "desencapel", "desencapoeir", "desencapot",
"desencapsul", "desencaracol", "desencaralh", "desencarang", "desencarapel", "desencarapinh",
"desencarapu"+u"\u00E7", "desencarcer", "desencarg", "desencarn", "desencarquilh", "desencarr",
"desencarranc", "desencarrapit", "desencarreg", "desencarreir", "desencarret", "desencarril",
"desencarrilh", "desencart", "desencas", "desencasac", "desencasc", "desencasquet",
"desencastel", "desencasto", "desencatarr", "desencatarro", "desencav", "desencavac",
"desencavalg", "desencavern", "desencavilh", "desencep", "desencer", "desencerr",
"desencharc", "desencilh", "desenclaustr", "desenclavinh", "desencobr", "desencoc",
"desencofr", "desencoif", "desencoir", "desencoira"+u"\u00E7", "desencoiv", "desencoivar",
"desencol", "desencoleriz", "desencomend", "desenconch", "desencontr", "desencor",
"desencoraj", "desencordo", "desencorp", "desencorpor", "desencorti"+u"\u00E7", "desencoscor",
"desencost", "desencostal", "desencour", "desencoura"+u"\u00E7", "desencout", "desencov",
"desencovil", "desencovilh", "desencrav", "desencravelh", "desencravilh", "desencrenc",
"desencresp", "desencrost", "desencru", "desencruz", "desencub", "desencuc",
"desenculatr", "desencurral", "desencurv", "desendemoninh", "desendeus", "desendireit",
"desendivid", "desenergiz", "desenerv", "desenevo", "desenfad", "desenfaix",
"desenfard", "desenfardel", "desenfarpel", "desenfarrusc", "desenfart", "desenfasti",
"desenfeit", "desenfeiti"+u"\u00E7", "desenfeix", "desenferm", "desenferruj", "desenfest",
"desenfeud", "desenfez", "desenfi", "desenfileir", "desenflech", "desenflor",
"desenfoc", "desenforc", "desenforj", "desenform", "desenforn", "desenfrasc",
"desenfrech", "desenfren", "desenfronh", "desenfueir", "desenfun", "desenfurn",
"desenfusc", "desenga"+u"\u00E7", "desengaiol", "desengaj", "desengalap", "desengalfinh",
"desengami", "desengan", "desenganch", "desengaranh", "desengarraf", "desengarranch",
"desengasg", "desengast", "desengastalh", "desengat", "desengatilh", "desengavet",
"desengelh", "desenglob", "desengod", "desengolf", "desengom", "desengon"+u"\u00E7",
"desengord", "desengordur", "desengorgit", "desengra"+u"\u00E7", "desengrad", "desengrainh",
"desengralh", "desengranz", "desengravat", "desengravit", "desengrax", "desengraz",
"desengren", "desengrenh", "desengril", "desengrimp", "desengrinald", "desengrip",
"desengross", "desengrum", "desengrun", "desenguaranch", "desengui"+u"\u00E7", "desengulh",
"desengurgit", "desengurunh", "desenh", "desenjaul", "desenjo", "desenjorc",
"desenla"+u"\u00E7", "desenlambuz", "desenlap", "desenlev", "desenli"+u"\u00E7", "desenlod",
"desenloda"+u"\u00E7", "desenlut", "desenluv", "desenodo", "desenoj", "desenovel",
"desenquadr", "desenqueix", "desenrai", "desenraiv", "desenram", "desenrasc",
"desenred", "desenregel", "desenri"+u"\u00E7", "desenrij", "desenrist", "desenriz",
"desenrodilh", "desenrol", "desenrolh", "desenrosc", "desenroup", "desenrug",
"desensabo", "desensaburr", "desensac", "desensanguent", "desensarilh", "desensart",
"desenseb", "desensil", "desensin", "desensoc", "desensolv", "desensombr",
"desensop", "desensurr", "desentabu", "desentabul", "desentaip", "desental",
"desentalisc", "desentalo", "desentaramel", "desentarrax", "desentedi", "desenterr",
"desenterro", "desentes", "desentesoir", "desentesour", "desentibi", "desento",
"desentoc", "desenton", "desentorro", "desentort", "desentralh", "desentramel",
"desentran"+u"\u00E7", "desentranh", "desentrap", "desentrav", "desentrela"+u"\u00E7", "desentrelinh",
"desentressolh", "desentrev", "desentrever", "desentrincheir", "desentroix", "desentronc",
"desentroniz", "desentropilh", "desentros", "desentroux", "desentub", "desentulh",
"desenturm", "desenturv", "desentusiasm", "desenubl", "desenvas", "desenvasilh",
"desenvencilh", "desenvenen", "desenvered", "desenverg", "desenvergonh", "desenverniz",
"desenvies", "desenvincilh", "desenviol", "desenvisc", "desenxarci", "desenxerg",
"desenxofr", "desenxov", "desenxovalh", "desequilibr", "desequip", "desequivoc",
"deserd", "deserotiz", "desert", "desertific", "desescal", "desescolariz",
"desescud", "desespant", "desespartilh", "desesper", "desesperan"+u"\u00E7", "desespinh",
"desespiraliz", "desespiritualiz", "desesquip", "desessenci", "desestabiliz", "desestagn",
"desestaliniz", "desestanh", "desestatiz", "desesteir", "desestim", "desestimul",
"desestiv", "desestorv", "desestr", "desestrelej", "desestrib", "desestrutur",
"desestud", "desetaniz", "desevangeliz", "desexcit", "desexcomung", "desfabric",
"desfabul", "desfa"+u"\u00E7", "desfadig", "desfai", "desfalc", "desfalca"+u"\u00E7",
"desfalco", "desfanatiz", "desfantasi", "desfard", "desfarel", "desfarinh",
"desfas", "desfascistiz", "desfataliz", "desfatan", "desfavel", "desfaz",
"desfebr", "desfech", "desfeminiz", "desfenestr", "desferr", "desferrolh",
"desferruj", "desfertiliz", "desfi", "desfibr", "desfibril", "desfibrilh",
"desfibrin", "desfigur", "desfil", "desfileir", "desfilh", "desfili",
"desfilipiz", "desfit", "desfivel", "desflegm", "desflor", "desflorest",
"desfoc", "desfocaliz", "desfoleg", "desfolg", "desfolh", "desfoli",
"desfonologiz", "desfor"+u"\u00E7", "desform", "desformat", "desforn", "desforr",
"desfortific", "desfosfor", "desfosforil", "desfrad", "desfragment", "desfrald",
"desfranj", "desfraterniz", "desfrech", "desfrequent", "desfris", "desfroux",
"desfrunch", "desfrut", "desfunch", "desfuncion", "desfund", "desfurfur",
"desgab", "desgadelh", "desgaf", "desgaiv", "desgalg", "desgalh",
"desgalvaniz", "desgargal", "desgarr", "desgarron", "desgas", "desgasconiz",
"desgaseific", "desgasific", "desgast", "desgavel", "desgel", "desgenitaliz",
"desgentiliz", "desgeometriz", "desgermaniz", "desgermin", "desglabr", "desglamouriz",
"desgliceriniz", "desglobuliz", "desglos", "desgoel", "desgordur", "desgorgomil",
"desgorj", "desgost", "desgovern", "desgovernamentaliz", "desgra"+u"\u00E7", "desgraci",
"desgradu", "desgram", "desgramaticaliz", "desgran", "desgrav", "desgravid",
"desgravit", "desgraviz", "desgrax", "desgreg", "desgrenh", "desgret",
"desgrilho", "desgrinald", "desgrud", "desgrum", "desguamp", "desguard",
"desguarit", "desguedelh", "desgui", "desidealiz", "desidentific", "desideologiz",
"desidrat", "desidrogen", "desidrogeniz", "design", "desigual", "desilumin",
"desilusion", "desilustr", "desimagin", "desiman", "desimaniz", "desimant",
"desimobiliz", "desimplant", "desimplic", "desimpossibilit", "desimpossibiliz", "desimpregn",
"desimprens", "desimpression", "desin"+u"\u00E7", "desincentiv", "desinch", "desinclin",
"desincompatibiliz", "desincorpor", "desincrimin", "desincrust", "desincub", "desindex",
"desindic", "desindici", "desindividualiz", "desindustrializ", "desinfam", "desinfeccion",
"desinfecion", "desinfect", "desinfern", "desinfest", "desinfet", "desinficion",
"desinfl", "desinflacion", "desinflam", "desinfluenci", "desinform", "desingles",
"desingurgit", "desinjuri", "desinquiet", "desinset", "desinsetiz", "desinstal",
"desinstitucionaliz", "desinsufl", "desintegr", "desinteir", "desinteiri"+u"\u00E7", "desinterdit",
"desinteress", "desinterlig", "desintern", "desinternacionaliz", "desinterpret", "desintestin",
"desintimid", "desintoxic", "desintric", "desintrinc", "desinvagin", "desinvern",
"desinviol", "desioniz", "desipnotiz", "desipotec", "desirman", "desisc",
"desislamiz", "desjarret", "desjeju", "desjunt", "deslabializ", "desla"+u"\u00E7",
"deslacr", "desladrilh", "deslan", "deslanch", "deslap", "deslapid",
"deslarg", "deslarv", "deslass", "deslastr", "deslat", "deslaud",
"deslav", "deslavr", "desleald", "desleg", "deslegitim", "desleig",
"desleit", "desleix", "deslembr", "desli", "deslig", "deslignific",
"deslim", "deslind", "deslinhific", "deslint", "deslis", "deslivr",
"desliz", "desloc", "deslocaliz", "deslod", "deslogr", "deslomb",
"deslouc", "deslouv", "deslumbr", "deslustr", "desmacul", "desmadeir",
"desmagin", "desmagnetiz", "desmai", "desmain", "desmalencoliz", "desmalh",
"desmalhet", "desmalici", "desmam", "desmament", "desman", "desmanch",
"desmand", "desmang", "desmangalh", "desmanganes", "desmanilh", "desmaninh",
"desmaniv", "desmantel", "desmantilh", "desmaquil", "desmaquilh", "desmaranh",
"desmarc", "desmarchet", "desmarcializ", "desmargariniz", "desmargin", "desmarisc",
"desmascar", "desmassaj", "desmastr", "desmat", "desmaterializ", "desmatricul",
"desmazel", "desmazorr", "desmedr", "desmedul", "desmelancoliz", "desmelen",
"desmelhor", "desmelindr", "desmembr", "desmemori", "desmensur", "desment",
"desmergulh", "desmescl", "desmesmeriz", "desmesur", "desmetaliz", "desmetodiz",
"desmielin", "desmieliniz", "desmilitariz", "desmin", "desmineraliz", "desmiol",
"desmistific", "desmitific", "desmiud", "desmobil", "desmobilh", "desmobiliz",
"desmo"+u"\u00E7", "desmoch", "desmoder", "desmodul", "desmoed", "desmoir",
"desmoit", "desmold", "desmond", "desmonetiz", "desmonopoliz", "desmonotoniz",
"desmont", "desmonto", "desmoraliz", "desmorfiniz", "desmoron", "desmortalh",
"desmortific", "desmotiv", "desmour", "desmout", "desmud", "desmultiplic",
"desmunhec", "desmunici", "desmunicion", "desmur", "desmurch", "desmuscul",
"desmusg", "desnacionaliz", "desnalg", "desnarig", "desnasal", "desnasaliz",
"desnastr", "desnat", "desnatur", "desnaturaliz", "desnazific", "desnecessit",
"desneg", "desnegoci", "desnerv", "desnev", "desninh", "desniquel",
"desnivel", "desnoc", "desnodo", "desnoit", "desnoiv", "desnot",
"desnovel", "desnu", "desnubl", "desnuc", "desnucleariz", "desnud",
"desobrig", "desobumbr", "desocult", "desocup", "desodor", "desodoriz",
"desoficializ", "desofusc", "desol", "desoleific", "desolh", "desoner",
"desonest", "desonr", "desopil", "desopress", "desorbit", "desor"+u"\u00E7"+"ament",
"desorden", "desorelh", "desorganiz", "desorient", "desorn", "desoss",
"desoug", "desov", "desoxid", "desoxigen", "despach", "despacient",
"despadr", "despaganiz", "despagin", "despais", "despalataliz", "despalatiz",
"despalet", "despalh", "despalhet", "despalm", "despalmilh", "despamp",
"despampan", "despancreatiz", "despap", "desparafin", "desparafus", "desparament",
"desparasit", "desparceir", "desparcel", "desparelh", "desparr", "desparram",
"despartidariz", "desparv", "despass", "despast", "despatri", "despatrocin",
"despaulific", "despavil", "despaviment", "despe"+u"\u00E7", "despecuni", "despeda"+u"\u00E7",
"despedr", "despeg", "despeit", "despeitor", "despej", "despel",
"despelh", "despen", "despenaliz", "despenc", "despendur", "despenh",
"despenitenci", "despentaniz", "desperdi"+u"\u00E7", "desperfil", "despersonaliz", "despersonific",
"despert", "despes", "despesc", "despestan", "despetal", "despetrech",
"despic", "despied", "despigment", "despilch", "despin"+u"\u00E7", "desping",
"despinhaliz", "despinic", "despint", "despiolh", "despiroc", "despist",
"desplant", "desplum", "despoeir", "despoetiz", "despoj", "despolariz",
"despolet", "despoli", "despolimeriz", "despoliniz", "despolitiz", "despoloniz",
"despolp", "despolvilh", "desponder", "despong", "despont", "despontu",
"despopul", "despopulariz", "desportilh", "desportugues", "despos", "desposs",
"desposti"+u"\u00E7", "despostig", "despotiz", "despovo", "despraguej", "desprecat",
"despreci", "despreg", "despregui"+u"\u00E7", "despremi", "desprenh", "despreocup",
"desprepar", "despresilh", "despressuriz", "desprestigi", "desprez", "desprimor",
"desprior", "despriv", "desprivatiz", "desprivilegi", "desprocess", "desprofan",
"desprogram", "desproletariz", "despronunci", "despropaniz", "desproporcion", "desproposit",
"despropri", "desproteiniz", "desprotoniz", "desprum", "desprussianiz", "despucel",
"despudor", "despueriliz", "despum", "despurific", "desquadr", "desquadrilh",
"desquadrinh", "desqualific", "desquam", "desquart", "desquartin", "desquebr",
"desqueix", "desqueixol", "desqui", "desquici", "desquiet", "desquit",
"desrab", "desraig", "desram", "desrat", "desratiz", "desrecalc",
"desrefolh", "desregionaliz", "desregr", "desregulament", "desrelv", "desremedi",
"desrend", "desrepublicaniz", "desresin", "desrespeit", "desresponsabiliz", "desretrat",
"desri"+u"\u00E7", "desrisc", "desrisonh", "desriz", "desroch", "desrolh",
"desromaniz", "desromantiz", "desrosc", "desroup", "desrug", "desrum",
"desrussific", "dessabor", "dessaburr", "dessacr", "dessacraliz",
"dessagr", "dessaibr", "dessain", "dessalg", "dessalific", "dessalinific",
"dessaliniz", "dessalitr", "dessamouc", "dessangr", "dessarr", "dessarro",
"dessazon", "dessazonaliz", "dessec", "dessedent", "dessegment", "dessegred",
"dessegreg", "dessegur", "dessein", "desseiv", "dessel", "dessemelh",
"dessensibiliz", "dessepult", "dessesm", "dessexu", "dessexualiz", "dessilic",
"dessilicat", "dessilicific", "dessimpatiz", "dessinal", "dessincroniz", "dessintoniz",
"dessiti", "desso", "dessoalh", "dessobra"+u"\u00E7", "dessoc", "desso"+u"\u00E7"+"obr",
"dessol", "dessold", "dessolh", "dessolidariz", "dessolvat", "dessor",
"dessosseg", "dessoterr", "dessu", "dessubjug", "dessubstanci", "dessud",
"dessuj", "dessulfon", "dessulfur", "dessulfuriz", "dessurr", "destabiliz",
"destaboc", "destac", "destal", "destalh", "destaling", "destamp",
"destanch", "destaniniz", "destaniz", "destap", "destar", "destaramel",
"destarrach", "destel", "destelh", "destemper", "desterneir", "desterr",
"desterraplen", "desterritorializ", "desterro", "destet", "destil", "destin",
"destipific", "destiraniz", "destisn", "desto", "destoc", "destoiti"+u"\u00E7",
"destold", "destomb", "deston", "destor", "destornilh", "destorro",
"destorv", "destouc", "destouti"+u"\u00E7", "destoutu"+u"\u00E7", "destoxific", "destra"+u"\u00E7",
"destrag", "destraj", "destram", "destrambelh", "destramel", "destranc",
"destran"+u"\u00E7", "destrat", "destrav", "destravanc", "destravess", "destrein",
"destrel", "destrep", "destrib", "destribaliz", "destri"+u"\u00E7", "destrig",
"destrinc", "destrin"+u"\u00E7", "destrinch", "destrip", "destripul", "destroc",
"destro"+u"\u00E7", "destron", "destronc", "destroniz", "destropilh", "destrunf",
"desturv", "destutel", "desug", "desultraj", "desuman", "desumaniz",
"desumect", "desumidific", "desunh", "desunific", "desuniform", "desurbaniz",
"desus", "desvac", "desvair", "desvali", "desvalid", "desvalij",
"desvalis", "desvalor", "desvaloriz", "desvalvul", "desvar", "desvari",
"desvasculariz", "desvassal", "desvel", "desvelej", "desvencelh", "desvencilh",
"desvend", "desvener", "desventr", "desventur", "desvergonh", "desvermin",
"desvertebr", "desverticaliz", "desvez", "desvi", "desvidr", "desvidra"+u"\u00E7",
"desvig", "desvigi", "desvigor", "desvigoriz", "desvinc", "desvincilh",
"desvincul", "desvir", "desvirg", "desvirgin", "desvirginiz", "desvirgul",
"desviriliz", "desvirtu", "desviscer", "desvisg", "desvitaliz", "desvitamin",
"desvitaminiz", "desvitrific", "desvizinh", "desvocaliz", "desvolum", "desvoluntari",
"desvulcaniz", "desvulgariz", "desxadrez", "desxaret", "deszel", "deszinc",
"deszip", "detalh", "detard", "detect", "deten"+u"\u00E7", "deterior",
"determin", "detest", "detet", "deton", "detor", "detram",
"detrat", "detrect", "detrin"+u"\u00E7", "detron", "detrunc", "deturb",
"deturp", "devass", "devast", "devel", "deventr", "devis",
"devitrific", "devor", "devot", "devulcaniz", "devulg", "dezinc",
"dezincific", "diaboliz", "diaclas", "diadem", "diafaniz", "diafragm",
"diagnostic", "diagonaliz", "diagram", "dialect", "dialet", "dialis",
"dialog", "diamantiz", "diariz", "diatermocoagul", "diazot", "diazotiz",
"dic", "dicionari", "dicionariz", "dicotomiz", "dies", "dieseliz",
"difam", "diferen"+u"\u00E7", "diferenci", "dificult", "difrat", "digit",
"digitaliniz", "digitaliz", "digladi", "dign", "dignific", "digress",
"digression", "dilacer", "dilani", "dilapid", "dilarg", "dilat",
"diligenci", "dilucid", "diluvi", "diman", "dimension", "dimeriz",
"dimidi", "dinamit", "dinamitiz", "dinamiz", "dind", "dinumer",
"diploidiz", "diplom", "diplomaci", "diplomatiz", "direcion", "dirradic",
"disc", "discant", "disciplin", "discord", "discrep", "discretiz",
"discrimin", "discurs", "discus", "discutinh", "diseliz", "disfar"+u"\u00E7",
"disform", "disgram", "disgreg", "disjunt", "dispar", "disparat",
"dispens", "dispers", "disponibiliz", "disput", "dissec", "dissemelh",
"dissemin", "dissert", "dissidi", "dissimetriz", "dissimil", "dissimul",
"dissip", "dissoci", "disson", "dist", "distanci", "distension",
"distil", "distrat", "distrofic", "disturb", "dit", "ditong",
"diuturniz", "divag", "divaric", "diversific", "diviniz", "divis",
"divorci", "divulg", "dizim", "do", "dob", "dobr",
"do"+u"\u00E7", "dociliz", "document", "doest", "dogmatiz", "doidej",
"doidivan", "doir", "doirej", "dolariz", "dolomitiz", "dolomiz",
"doloriz", "dom", "domestic", "domicili", "domific", "domin",
"doming", "dop", "dorment", "dorminh", "dorminhoc", "dormit",
"dorsaliz", "dos", "dosific", "dossel", "dot", "dotaliz",
"doudej", "doudivan", "dour", "dourej", "douti", "doutor",
"doutrin", "drag", "drain", "dramatiz", "drapej", "dren",
"dribl", "drog", "dualiz", "dubl", "duch", "ductiliz",
"duel", "dueliz", "duet", "dulcific", "dul"+u"\u00E7"+"or", "dupl",
"duplic", "dur", "durb", "duvid", "ealm", "earc",
"ebaniz", "eburn", "eburnific", "ec", "echacorv", "eclips",
"eco", "ecocardiograf", "ecoencefalograf", "ecograf", "ecoloc", "ecolocaliz",
"economiz", "ecossistematiz", "ectomorfiz", "ecumeniz", "edafostratigraf", "edafostratograf",
"edemaci", "edematiz", "edeniz", "edent", "edicion", "edicul",
"edific", "edit", "editor", "editori", "educ", "educomunic",
"edul"+u"\u00E7", "edulcor", "edul"+u"\u00E7"+"or", "eequacion", "efabul", "efeitu",
"efemeriz", "efemin", "efeminiz", "efervent", "efetiv", "efetu",
"eficaci", "efigi", "egipcianiz", "egocentr", "egocentraliz", "egoidealiz",
"egoism", "ei"+u"\u00E7", "eim", "eiv", "eix", "ejacul",
"eject", "ejet", "el", "elabor", "elan"+u"\u00E7", "elastific",
"elastiz", "eleboriz", "electrific", "electriz", "electrocortigraf", "electrocut",
"electrodeposit", "electrodiagnostic", "electrolis", "electromedic", "electron", "electrotip",
"elegantiz", "elenc", "eletrific", "eletriz", "eletrocortigraf", "eletrocut",
"eletrodeposit", "eletrolis", "eletromedic", "eletron", "eletroniz", "eletrotip",
"elev", "elici", "elicit", "elimin", "elips", "elitiz",
"elogi", "elong", "elucid", "elucubr", "elutri", "ema"+u"\u00E7",
"ema"+u"\u00E7"+"aroc", "emaci", "emacul", "emadeir", "emadeix", "emagazin",
"emagot", "emagr", "emagrent", "emal", "emalh", "emalhet",
"eman", "emanch", "emancip", "emanding", "emangueir", "emanhu"+u"\u00E7",
"emanilh", "emanjeric", "emanoc", "emant", "emantilh", "emar",
"emaranh", "emarj", "emarlot", "emartilh", "emascar", "emascul",
"emass", "emassilh", "emastr", "ematilh", "embabac", "embabad",
"emba"+u"\u00E7", "embacel", "embaci", "embag", "embaga"+u"\u00E7", "embainh",
"embal", "embalan"+u"\u00E7", "embal"+u"\u00E7", "embaloi"+u"\u00E7", "embalou"+u"\u00E7", "embals",
"embalsam", "emban", "embanan", "emband", "embandeir", "embara"+u"\u00E7",
"embarafust", "embaralh", "embarb", "embarbasc", "embarbel", "embarbilh",
"embarc", "embard", "embarg", "embarr", "embarrac", "embarranc",
"embarreir", "embarrel", "embarret", "embarric", "embarrig", "embarril",
"embarulh", "embas", "embasbac", "embast", "embasti", "embastilh",
"embatin", "embatoc", "embatuc", "embatum", "embauc", "embaul",
"embebec", "embebed", "embeber", "embebor", "embei"+u"\u00E7", "embelec",
"embelen", "embelez", "embelg", "embelinh", "embeloir", "embelour",
"embelout", "embern", "emberrinch", "embesilh", "embesoir", "embesour",
"embespinh", "embest", "embetesg", "embetum", "embezerr", "embiboc",
"embic", "embicheir", "embigot", "embilh", "embiloc", "embing",
"embioc", "embiot", "embir", "embirich", "embiroc", "embirr",
"embirrinch", "embirut", "embisc", "embitesg", "embizug", "emblem",
"emblematiz", "embob", "embobin", "emboc", "embo"+u"\u00E7", "embo"+u"\u00E7"+"al",
"embocet", "embochech", "embodalh", "embodeg", "embodoc", "emboit",
"emboj", "embol", "embolat", "emboldreg", "emboldri", "embolet",
"embolig", "embolinh", "emboliz", "emboloir", "embolor", "embolot",
"embolour", "embols", "embon", "embonec", "embonecr", "embonic",
"emboquilh", "emborbet", "emborc", "embornal", "emborquilh", "emborr",
"emborrach", "emborralh", "emborrasc", "embosc", "embosn", "embost",
"embostel", "embot", "embotelh", "embotij", "embotilh", "emboug",
"embout", "embrab", "embra"+u"\u00E7", "embraceir", "embrag", "embrai",
"embram", "embranc", "embrech", "embrenh", "embret", "embriag",
"embric", "embrid", "embrigad", "embrinc", "embrion", "embroc",
"embroch", "embrom", "embruac", "embrulh", "embrum", "embrusc",
"embrut", "embrux", "embu"+u"\u00E7", "embu"+u"\u00E7"+"al", "embuch", "embud",
"emburac", "emburel", "emburgues", "emburilh", "emburr", "emburric",
"emburrisc", "emburulh", "embuzi", "embuzin", "emech", "emed",
"emedoi"+u"\u00E7", "emedoich", "emedou"+u"\u00E7", "emedouch", "emel", "emend",
"emendic", "emenin", "ement", "emeroi"+u"\u00E7", "emerou"+u"\u00E7", "emeruj",
"emetiz", "emezi", "emigr", "eminenci", "eminhoc", "emocion",
"emoir", "emoit", "emold", "emoldur", "emoleir", "emolh",
"emon", "emorda"+u"\u00E7", "emoroi"+u"\u00E7", "emorou"+u"\u00E7", "emorrinh", "emosc",
"emosqueir", "emost", "emour", "emp", "empac", "empacavir",
"empach", "empa"+u"\u00E7"+"oc", "empacot", "empades", "empadilh", "empadro",
"empaiol", "empal", "empalam", "empalet", "empalh", "empalhasc",
"empalheir", "empali", "empalit", "empalm", "empalud", "empampan",
"empan", "empanad", "empanc", "empandeir", "empandilh", "empandin",
"empando", "empaneir", "empanem", "empang", "empangin", "empanh",
"empantan", "empantuf", "empanturr", "empanzin", "empap", "empapel",
"empapoil", "empapoul", "empapu"+u"\u00E7", "empaquet", "empar", "emparament",
"emparc", "emparceir", "emparcel", "empard", "empared", "emparelh",
"emparent", "emparr", "emparreir", "emparv", "emparvat", "emparvo",
"empasm", "empast", "empastel", "empat", "empaturr", "empaupic",
"empaves", "empavo", "empavon", "empe"+u"\u00E7", "empecad", "empecilh",
"empe"+u"\u00E7"+"onh", "empe"+u"\u00E7"+"onhent", "empedern", "empedr", "empeg", "empeir",
"empeireir", "empeitic", "empej", "empel", "empelam", "empelic",
"empelicul", "empelot", "empen", "empenach", "empenc", "empendo",
"empenetr", "empenh", "empenhor", "empenuj", "empeol", "empepin",
"empequenit", "empereir", "emperiquit", "emperl", "empern", "empernic",
"emperol", "emperr", "empertig", "empes", "empesg", "empesso",
"empest", "empetec", "empetelec", "empez", "empezinh", "empic",
"empicot", "empilch", "empilec", "empilh", "empin", "empinhoc",
"empinoc", "empiol", "empiolh", "empior", "empip", "empipoc",
"empisc", "empistol", "empiteir", "emplac", "emplanch", "emplasm",
"emplast", "emplastr", "emplum", "empo", "empobr", "empo"+u"\u00E7",
"empocilg", "empoder", "empoeir", "empoit", "empol", "empolam",
"empolasm", "empoleir", "empolg", "empolh", "empolm", "empolv",
"empolvilh", "empomad", "empomb", "emponch", "emponder", "empont",
"empop", "emporc", "emporcalh", "emposs", "empost", "empostem",
"empostig", "emprateleir", "empraz", "empreg", "empregui"+u"\u00E7", "empreit",
"emprenh", "empres", "empresari", "emprest", "emprestad", "emprision",
"empro", "emprum", "empulg", "empulh", "empunh", "empup",
"empurpur", "empurr", "empux", "emul", "emulsific", "emulsion",
"emund", "emuralh", "emurch", "enagen", "enaif", "enaip",
"enalt", "enamor", "enarr", "enastr", "enat", "enateir",
"encab", "encabe"+u"\u00E7", "encabeir", "encabel", "encabeliz", "encabreim",
"encabrest", "encabrit", "encabrun", "encabul", "encabulh", "enca"+u"\u00E7"+"ap",
"encach", "encacha"+u"\u00E7", "encachapu"+u"\u00E7", "encachi", "encachoeir", "encachol",
"encadarro", "encadeir", "encadern", "encafif", "encafu", "encafurn",
"encaga"+u"\u00E7", "encaibr", "encaieir", "encaipor", "encairel", "encaix",
"encaixilh", "encaixot", "encal", "encalacr", "encalamech", "encalamistr",
"encalamouc", "encalburd", "encalc", "encal"+u"\u00E7", "encald", "encaldeir",
"encaleir", "encalg", "encalh", "encalic", "encali"+u"\u00E7", "encalist",
"encalistr", "encalm", "encalmurr", "encalomb", "encalor", "encalung",
"encam", "encama"+u"\u00E7", "encamarad", "encamarinh", "encamarot", "encamb",
"encambeir", "encambich", "encambit", "encambo", "encambon", "encambuc",
"encambulh", "encamel", "encamer", "encaminh", "encamis", "encamoroi"+u"\u00E7",
"encamorou"+u"\u00E7", "encamp", "en"+u"\u00E7"+"amp", "encampan", "encampesin", "encamur"+u"\u00E7",
"encan", "encanalh", "encanastr", "encancel", "encancer", "encandil",
"encandol", "encanel", "encanfinf", "encang", "encangalh", "encangot",
"encanh", "encanic", "encani"+u"\u00E7", "encanit", "encaniz", "encano",
"encant", "encanteir", "encantin", "encantinh", "encanto", "encanton",
"encanut", "encanzin", "encanzo", "encap", "encapach", "encapar",
"encapel", "encapet", "encapoeir", "encapot", "encaprich", "encapsul",
"encapuch", "encapuz", "encar", "encaracol", "encaramanch", "encaramel",
"encaramon", "encaramuj", "encarang", "encaranguej", "encarant", "encarantonh",
"encarapel", "encarapinh", "encarapit", "encarapu"+u"\u00E7", "encaravelh", "encarboniz",
"encarcad", "encarcer", "encarch", "encardum", "encarent", "encaret",
"encarg", "encarij", "encarioc", "encarn", "encarneir", "encarni"+u"\u00E7",
"encaro"+u"\u00E7", "encaroch", "encarol", "encarquilh", "encarr", "encarramon",
"encarranc", "encarrapi"+u"\u00E7", "encarrapit", "encarrasc", "encarraspan", "encarreg",
"encarreir", "encarret", "encarril", "encarrilh", "encarrisc", "encart",
"encartalh", "encartaz", "encarteir", "encartol", "encartuch", "encarvo",
"encarvoej", "encarvoi"+u"\u00E7", "encas", "encasac", "encasal", "encasc",
"encascalh", "encascor", "encasmurr", "encasquet", "encasquilh", "encastalh",
"encastel", "encasto", "encastr", "encasul", "encataplasm", "encatarr",
"encatarro", "encatrafi", "encatramon", "encatravilh", "encatrin", "encauch",
"encaud", "encaustic", "encav", "encavac", "encaval", "encavaleir",
"encavalg", "encavalit", "encavern", "encavilh", "encazuc", "encebol",
"encedr", "encegueir", "enceir", "encel", "enceleir", "encen",
"encendr", "encensori", "encentr", "encep", "encer", "encerebr",
"enceroil", "enceroul", "encerr", "encert", "encervej", "encest",
"encet", "enceved", "enchacot", "enchafurd", "enchamarr", "enchambo",
"enchambr", "enchamej", "enchampanh", "enchapel", "enchapot", "enchapour",
"enchapu"+u"\u00E7", "encharc", "encharol", "enchavet", "enchi"+u"\u00E7"+"ar", "enchicharr",
"enchimarr", "enchiment", "enchiqueir", "encho"+u"\u00E7", "enchocalh", "enchoiri"+u"\u00E7",
"enchombr", "enchouri"+u"\u00E7", "enchous", "enchuma"+u"\u00E7", "enchumarr", "enchumb",
"enchumbeir", "enchusm", "encieir", "encilh", "encim", "encimalh",
"encinch", "encinh", "encint", "encinz", "encinzeir", "encirr",
"encisc", "encist", "encium", "enclaustr", "enclausur", "enclavinh",
"encloac", "encobard", "encobert", "encobilh", "encobr", "encoch",
"encocurut", "encod", "encodo", "encof", "encofr", "encoif",
"encoim", "encoir", "encoira"+u"\u00E7", "encoit", "encoivar", "encol",
"encoleir", "encoleriz", "encoloc", "encomend", "encomi", "encomiss",
"encomoro"+u"\u00E7", "encomoroi"+u"\u00E7", "encomorou"+u"\u00E7", "encomprid", "encomunh", "encon",
"enconap", "enconc", "enconch", "encond", "encondiz", "enconformiz",
"enconhac", "enconic", "enconteir", "enconto", "encontr", "encontro",
"encop", "encoquin", "encoquinh", "encor", "encoraj", "encorc",
"encorcund", "encordel", "encordo", "encorn", "encornet", "encornich",
"encoronh", "encorp", "encorpor", "encorquilh", "encorrelh", "encorrent",
"encorri", "encorric", "encorrilh", "encorrovilh", "encortelh", "encorti"+u"\u00E7",
"encortin", "encoruj", "encoscor", "encospi", "encost", "encostal",
"encostel", "encostr", "encotinh", "encouch", "encour", "encoura"+u"\u00E7",
"encout", "encov", "encovard", "encovil", "encovilh", "encovit",
"encramoio"+u"\u00E7", "encramou"+u"\u00E7", "encrass", "encrav", "encraveir", "encravelh",
"encravilh", "encrenc", "encresp", "encript", "encris", "encrist",
"encristin", "encroc", "encrost", "encru", "encruent", "encrust",
"encruz", "encruzilh", "encub", "encuc", "encucharr", "encueir",
"enculp", "encultur", "encunh", "encurral", "encurrelh", "encurric",
"encurrich", "encurrilh", "encurt", "encurv", "encutinh", "endech",
"endeflux", "endej", "endemiz", "endemoninh", "endent", "endere"+u"\u00E7",
"endeus", "endiabr", "endilg", "endinh", "endinheir", "endireit",
"endivid", "endocardiograf", "endocit", "endocruz", "endoid", "endoming",
"endors", "endoss", "endoud", "endoutrin", "endrag", "endromin",
"endur", "endurent", "enebri", "energiz", "enerv", "enesg",
"enev", "enevo", "enfaceir", "enfachoc", "enfad", "enfaix",
"enfang", "enfanic", "enfar", "enfard", "enfardel", "enfardo",
"enfardon", "enfarel", "enfarfalh", "enfarinh", "enfarn", "enfaro",
"enfarp", "enfarpel", "enfarrap", "enfarrusc", "enfart", "enfas",
"enfascal", "enfasti", "enfatiot", "enfatiz", "enfatu", "enfebr",
"enfechel", "enfedilh", "enfei", "enfeir", "enfeit", "enfeiti"+u"\u00E7",
"enfeix", "enfelp", "enfeltr", "enfeluj", "enfen", "enferm",
"enferr", "enferret", "enferrolh", "enferruj", "enfest", "enfesto",
"enfeston", "enfeud", "enfez", "enfezin", "enfi", "enfieir",
"enfileir", "enfinc", "enfirm", "enfistul", "enfit", "enfiteutic",
"enfivel", "enfix", "enflait", "enflanel", "enfleim", "enflor",
"enfobi", "enfoc", "enfog", "enfoi"+u"\u00E7", "enfol", "enfolech",
"enfolh", "enfolip", "enforc", "enforj", "enform", "enformos",
"enforn", "enforquilh", "enforr", "enfort", "enfou"+u"\u00E7", "enfrac",
"enfrag", "enfraldic", "enfranj", "enfraquent", "enfrasc", "enfrech",
"enfren", "enfrenesi", "enfrenis", "enfrent", "enfrest", "enfri",
"enfrond", "enfronh", "enfront", "enfrut", "enfu", "enfueir",
"enfuleim", "enfulij", "enfum", "enfuma"+u"\u00E7", "enfumar", "enfun",
"enfuner", "enfunil", "enfunisc", "enfurd", "enfuri", "enfurn",
"enfus", "enfusc", "enfust", "enfuzil", "eng", "engabel",
"engabrich", "enga"+u"\u00E7", "engadanh", "engadelh", "engai", "engaifon",
"engaiol", "engaj", "engajat", "engal", "engalan", "engalap",
"engaldrap", "engaldrip", "engalfinh", "engalg", "engalh", "engalhardet",
"engalhop", "engalhot", "engali", "engalic", "engalicism", "engalinh",
"engalisp", "engalop", "engalri"+u"\u00E7", "engambel", "engambit", "engamel",
"engan", "enganch", "engangorr", "engangren", "engaramp", "engaranh",
"engarant", "engarap", "engaravit", "engarbon", "engarf", "engargant",
"engarguel", "engarnach", "engarr", "engarraf", "engarrafon", "engarup",
"engasg", "engasgalh", "engasgat", "engast", "engastalh", "engasto",
"engat", "engatalh", "engatanh", "engati"+u"\u00E7", "engatilh", "engatinh",
"engavel", "engavet", "engavinh", "engazofil", "engazop", "engazup",
"engelh", "engemin", "engendr", "engenh", "engeroc", "engess",
"engig", "englob", "englobul", "engob", "engod", "engodilh",
"engolf", "engolip", "engom", "engon"+u"\u00E7", "engonh", "engoni",
"engord", "engordur", "engorgit", "engorr", "engra"+u"\u00E7", "engrad",
"engrambel", "engramp", "engrampon", "engranz", "engravat", "engravid",
"engravit", "engrax", "engraz", "engrazul", "engrel", "engren",
"engrenh", "engrif", "engril", "engrim", "engrimp", "engrimpin",
"engrimpon", "engrinald", "engrip", "engriquilh", "engrol", "engross",
"engrum", "engrunh", "enguedelh", "engui"+u"\u00E7", "enguirland", "enguizalh",
"engulh", "engulip", "engulosin", "engunh", "enigm", "enigmatiz",
"enjaez", "enjalg", "enjambr", "enjang", "enjangr", "enjaul",
"enjeir", "enjeit", "enjeriz", "enjic", "enjo", "enjoi",
"enjoin", "enjon", "enjorc", "enjorg", "enjouj", "enjuan",
"enjug", "enjun"+u"\u00E7", "enlabared", "enlabi", "enlabirint", "enlabrusc",
"enlabuz", "enla"+u"\u00E7", "enla"+u"\u00E7"+"arot", "enlacr", "enladeir", "enlag",
"enlaiv", "enlam", "enlambuj", "enlambuz", "enlamin", "enlanz",
"enlap", "enlaru"+u"\u00E7", "enlat", "enleiv", "enlerd", "enlev",
"enli"+u"\u00E7", "enloc", "enlod", "enloda"+u"\u00E7", "enloi"+u"\u00E7", "enloir",
"enlois", "enloj", "enlomb", "enlouc", "enlou"+u"\u00E7", "enlour",
"enlous", "enluar", "enludr", "enlur", "enlut", "enluv",
"enod", "enodo", "enog", "enoiri"+u"\u00E7", "enoit", "enoj",
"enoliz", "enosilh", "enouri"+u"\u00E7", "enout", "enov", "enovel",
"enquadr", "enquadrilh", "enquart", "enqueij", "enqueix", "enquezil",
"enquilh", "enquist", "enquit", "enquizil", "enrab", "enrabeir",
"enrabich", "enrabit", "enra"+u"\u00E7", "enrai", "enraiv", "enram",
"enramalh", "enramalhet", "enramel", "enramilhet", "enran"+u"\u00E7", "enranch",
"enrapos", "enrasc", "enrastilh", "enred", "enredoi"+u"\u00E7", "enredom",
"enredou"+u"\u00E7", "enreg", "enregel", "enregist", "enregistr", "enregueir",
"enreix", "enrelh", "enrelheir", "enrelv", "enremel", "enremin",
"enremiss", "enrend", "enrepolh", "enresin", "enresm", "enrest",
"enresti", "enreves", "enri", "enric", "enri"+u"\u00E7", "enricon",
"enrif", "enrij", "enrilh", "enrilheir", "enrim", "enrincon",
"enrip", "enriquent", "enrist", "enristr", "enrix", "enriz",
"enroc", "enroch", "enrod", "enrodel", "enrodilh", "enrodrig",
"enrol", "enrolh", "enrosc", "enroup", "enrox", "enru"+u"\u00E7",
"enruf", "enrug", "enrumin", "ensabo", "ensaburr", "ensac",
"ensacol", "ensai", "ensaibr", "ensainh", "ensal"+u"\u00E7", "ensaliv",
"ensalm", "ensalmoir", "ensalmour", "ensalsich", "ensamarr", "ensambenit",
"ensambl", "ensamp", "ensanch", "ensandal", "ensandol", "ensanduich",
"ensanef", "ensangu", "ensanguent", "ensanguinh", "ensanh", "ensanzor",
"ensapez", "ensarapulh", "ensardinh", "ensarilh", "ensarjet", "ensarraf",
"ensarranh", "ensart", "ensartilh", "enseb", "ensec", "ensed",
"ensei", "enseir", "enseiv", "ensej", "enselv", "ensement",
"enserralh", "ensesg", "ensev", "ensil", "ensilv", "ensilveir",
"ensimesm", "ensin", "enso", "ensoalh", "ensoalheir", "ensoberb",
"ensobrad", "ensoc", "ensod", "ensofreg", "ensog", "ensoiss",
"ensoleir", "ensolv", "ensombr", "enson", "ensop", "ensopi",
"ensorn", "ensoss", "ensovac", "ensuj", "ensujent", "ensumagr",
"ensurr", "ensurraip", "ensurro", "entabic", "entaboc", "entabu",
"entabul", "entaburr", "entach", "entafulh", "entaip", "ental",
"entaleig", "entaleir", "entalh", "entalic", "entaling", "entalisc",
"entalo", "entam", "entanc", "entang", "entani"+u"\u00E7", "entap",
"entapet", "entapi"+u"\u00E7", "entapig", "entapiz", "entaramel", "entarrax",
"entartalh", "entavol", "entec", "entedi", "enteix", "entej",
"entejol", "entejuc", "entel", "entelh", "entelheir", "entendi",
"entenebr", "entenx", "enterr", "enterreir", "enterro", "enterturb",
"entes", "enteso", "entesoir", "entesoiris", "entesour", "entesouriz",
"entest", "entesteferr", "entibi", "entic", "entijol", "entijuc",
"entint", "entirit", "entisic", "entisn", "entiv", "ento",
"entoalh", "entoc", "entocai", "entog", "entoi"+u"\u00E7", "entoiceir",
"entoir", "entoj", "entol", "entold", "entolh", "enton",
"entont", "entorn", "entorp", "entorro", "entort", "entouc",
"entou"+u"\u00E7", "entouceir", "entoupeir", "entour", "entourinh", "entr",
"entraj", "entralh", "entram", "entrambelic", "entrambic", "entran"+u"\u00E7",
"entranh", "entranqueir", "entrap", "entrast", "entravess",
"entravisc", "entreadivinh", "entreajud", "entream", "entrearremess", "entrebeij",
"entrecerr", "entrech", "entrechoc", "entrecort", "entrecruz", "entredevor",
"entredilacer", "entredisput", "entrefal", "entrefech", "entrefestej", "entrefi",
"entrefigur", "entrefolh", "entreg", "entrela"+u"\u00E7", "entrelembr", "entrelh",
"entrelig", "entrelinh", "entreloi"+u"\u00E7", "entrelou"+u"\u00E7", "entremescl", "entremistur",
"entremostr", "entremurmur", "entrenubl", "entreocult", "entreolh", "entrepar",
"entrepass", "entrepelej", "entrepens", "entrepern", "entrepic", "entrepigait",
"entrepil", "entreplic", "entrerreclam", "entrerreg", "entrescut", "entresilh",
"entressac", "entressach", "entressolh", "entressonh", "entressufoc", "entretalh",
"entretel", "entretoc", "entretrucid", "entreturb", "entrev", "entrevaz",
"entrevel", "entrever", "entrevist", "entrez", "entrezilh", "entrilh",
"entrin"+u"\u00E7", "entrincheir", "entriz", "entroc", "entro"+u"\u00E7", "entroix",
"entromb", "entron", "entronc", "entronch", "entroniz", "entrope"+u"\u00E7",
"entropic", "entropigait", "entropilh", "entros", "entroux", "entrovisc",
"entrud", "entruj", "entrunf", "entrunfinh", "entrupic", "entrupigait",
"entub", "entuch", "entuf", "entujuc", "entulh", "entupigait",
"enturb", "enturm", "enturv", "enturvisc", "entusiasm", "enubl",
"enumer", "enunci", "enuvi", "envagin", "envaid", "enval",
"envalenton", "envar", "envaret", "envarot", "envas", "envasilh",
"envaz", "envelhac", "envelhent", "envelop", "envencelh", "envencilh",
"envenen", "enventan", "enver", "enverdej", "envered", "enverg",
"envergonh", "envermelh", "enverniz", "enverrug", "enves", "envesg",
"envess", "envi", "envi"+u"\u00E7", "envid", "envidilh", "envidra"+u"\u00E7",
"envieir", "envies", "envig", "envigor", "envigot", "envinagr",
"envincilh", "envinh", "envinhadalh", "enviper", "envisc", "envisg",
"enviveir", "envol", "envolucr", "envolut", "envult", "enxabelh",
"enxad", "enxadrez", "enxalavi", "enxal"+u"\u00E7", "enxalm", "enxambl",
"enxambr", "enxamelh", "enxampo", "enxampu", "enxaquec", "enxaquet",
"enxarci", "enxarop", "enxaug", "enxec", "enxelh", "enxequet",
"enxerc", "enxerg", "enxert", "enxi", "enxilh", "enxofr",
"enxog", "enxogalh", "enxombr", "enxor", "enxot", "enxov",
"enxovalh", "enxudr", "enxug", "enxumbr", "enxundi", "enxurd",
"enxurr", "enxurri", "enzamp", "enzamparin", "enzampon", "enzin",
"enzon", "enzonz", "eoliz", "epicuriz", "epidemi", "epigeniz",
"epigraf", "epigram", "epigramatic", "epigramatiz", "epil", "epilepsi",
"epileptiz", "epilog", "episodi", "epist", "epistoliz", "epitet",
"epitom", "equacion", "equaliz", "equidimension", "equidist", "equifinaliz",
"equilibr", "equimos", "equip", "equipar", "equiponder", "equivoc",
"ergastul", "ergotiz", "eri"+u"\u00E7", "erisipel", "erm",
"eros", "erotiz", "err", "erradic", "erri"+u"\u00E7", "eruct",
"erudit", "erv", "ervilh", "ervo", "esamp", "esbabac",
"esbaga"+u"\u00E7", "esbagach", "esbaganh", "esbago", "esbagulh", "esbalan"+u"\u00E7",
"esbald", "esbalh", "esbaliz", "esbalouc", "esbamb", "esbambo",
"esbandalh", "esbandeir", "esbandulh", "esbang", "esbanj", "esbanzalh",
"esbar", "esbarafust", "esbaralh", "esbarb", "esbarbot", "esbard",
"esbardalh", "esbarr", "esbarranc", "esbarreg", "esbarrel", "esbarrig",
"esbarro", "esbarroc", "esbarrond", "esbarrot", "esbarru", "esbarrunt",
"esbeat", "esbei"+u"\u00E7", "esbeij", "esbeir", "esbelt", "esbeltific",
"esbeltiz", "esbenair", "esbenic", "esberra"+u"\u00E7", "esberri", "esbic",
"esbich", "esbij", "esbilhot", "esbilit", "esbirr", "esbo"+u"\u00E7",
"esbocel", "esbodeg", "esbodel", "esbof", "esbofet", "esboi"+u"\u00E7",
"esboicel", "esbol", "esbombard", "esborcel", "esborcin", "esbord",
"esbordo", "esborni", "esboro", "esborol", "esborr", "esborra"+u"\u00E7",
"esborrach", "esborralh", "esborrat", "esborreg", "esborret", "esborrif",
"esborrot", "esboten", "esbou"+u"\u00E7", "esboucel", "esbrabej", "esbra"+u"\u00E7",
"esbracej", "esbram", "esbranqui"+u"\u00E7", "esbravej", "esbrech", "esbrin"+u"\u00E7",
"esbrit", "esbriz", "esbro", "esbronc", "esbrucin", "esbrug",
"esbrum", "esbugalh", "esbulh", "esburac", "esburg", "esbux",
"escabe"+u"\u00E7", "escabech", "escabel", "escabeleir", "escabeliz", "escabich",
"escabr", "escabuf", "escabuj", "escabulh", "escac", "escach",
"escacho", "escachol", "escachou"+u"\u00E7", "escacilh", "esca"+u"\u00E7"+"o", "escadabulh",
"escadeir", "escadra"+u"\u00E7", "escadrilh", "escafandr", "escafel", "escafon",
"escaful", "escafun", "escaga"+u"\u00E7", "escaganit", "escagarrinh", "escaiol",
"escal", "escalad", "escalamanc", "escalambr", "escalamouc", "escalavr",
"escald", "escaldeir", "escalf", "escali"+u"\u00E7", "escalmorr", "escalon",
"escalp", "escalpel", "escalpeliz", "escalpirr", "escalrach", "escalv",
"escalvej", "escam", "escamalh", "escamalho", "escamb", "escambi",
"escambich", "escambr", "escamech", "escamel", "escamis", "escamond",
"escamos", "escamot", "escamp", "escamuj", "escamur"+u"\u00E7", "escamurreng",
"escan", "escan"+u"\u00E7", "escancar", "escancel", "escanch", "escand",
"escandaliz", "escanec", "escaneriz", "escang", "escangalh", "escanganh",
"escangot", "escanho", "escanhot", "escanifr", "escaninh", "escantilh",
"escanto", "escanzel", "escanzi", "escanzurr", "escap", "escapel",
"escapolitiz", "escaqueir", "escaraban", "escarafol", "escarafunch", "escaramb",
"escaramel", "escaramu"+u"\u00E7", "escarapel", "escarapu"+u"\u00E7", "escaravelh", "escar"+u"\u00E7",
"escarcalh", "escarcavel", "escarch", "escarchol", "escard", "escarda"+u"\u00E7",
"escardi"+u"\u00E7", "escardich", "escardilh", "escardu"+u"\u00E7", "escarfunch", "escarg",
"escari", "escarific", "escarlat", "escarment", "escarmou"+u"\u00E7", "escarn",
"escarnefuch", "escarni", "escarnic", "escarnific", "escarninh", "escarnitiz",
"escaro"+u"\u00E7", "escarol", "escarou"+u"\u00E7", "escarp", "escarpel", "escarpi",
"escarpilh", "escarquej", "escarr", "escarrach", "escarraman", "escarranch",
"escarrapach", "escarrapanch", "escarrapat", "escarrapi"+u"\u00E7", "escarrapich", "escarrinh",
"escarum", "escarv", "escarvan"+u"\u00E7", "escarvo", "escarvun"+u"\u00E7", "escasal",
"escasc", "escassilh", "escasul", "escatel", "escatim", "escatin",
"escatoliz", "escav", "escavac", "escava"+u"\u00E7", "escavach", "escavalo",
"escaveir", "escavin", "escavinh", "escaxel", "eschamej", "esclamouc",
"esclerific", "escleros", "esco", "escobilh", "escoc", "escoch",
"escochin", "escod", "escogi", "escoi"+u"\u00E7", "escoicinh", "escoim",
"escolariz", "escoldrinh", "escoli", "escolm", "escolt", "escombr",
"escongemin", "esconjunt", "esconjur", "escons", "escopet", "escor",
"escor"+u"\u00E7", "escorcemel", "escorch", "escor"+u"\u00E7"+"omel", "escord", "escori",
"escorific", "escorj", "escorn", "escornich", "escoro", "escorra"+u"\u00E7",
"escorrach", "escorreg", "escorrich", "escorrima"+u"\u00E7", "escorripich", "escorropich",
"escortic", "escortin", "escortinh", "escoruj", "escorv", "escosip",
"escoti", "escotomiz", "escou"+u"\u00E7", "escoucemel", "escoucepinh", "escoucinh",
"escov", "escovalh", "escovilh", "escovinh", "escozic", "escrach",
"escrachet", "escrachin", "escrafunch", "escramalh", "escramel", "escrament",
"escramouc", "escramu"+u"\u00E7", "escravelh", "escraviz", "escresp", "escrevinh",
"escritur", "escriv", "escrofulariz", "escrofuliz", "escruch", "escruci",
"escrunch", "escrupuliz", "escrut", "escrutin", "escud", "escudeir",
"escudel", "escudrinh", "esculach", "esculc", "esculhamb", "escult",
"escultur", "escum", "escumilh", "escur", "escurej", "escurent",
"escus", "escut", "esdruxul", "esdruxuliz", "esfacel", "esfagunt",
"esfaim", "esfalc", "esfalca"+u"\u00E7", "esfalf", "esfalrip", "esfandeg",
"esfango", "esfanic", "esfard", "esfarel", "esfarfalh", "esfarinh",
"esfarp", "esfarpel", "esfarrap", "esfarrip", "esfarrunc", "esfatach",
"esfatan", "esfatech", "esfateix", "esfati", "esfavel", "esfelg",
"esfergulh", "esfervilh", "esfi", "esfiamp", "esfiap", "esfibr",
"esfloc", "esflor", "esfocinh", "esfoeir", "esfogueir", "esfoi"+u"\u00E7",
"esfoir", "esfol", "esfoleg", "esfolh", "esfolha"+u"\u00E7", "esfoli",
"esfor"+u"\u00E7", "esforfalh", "esforgulh", "esformig", "esforneir", "esfornic",
"esfornig", "esforquilh", "esforric", "esfoss", "esfossiliz", "esfossinh",
"esfou"+u"\u00E7", "esfrald", "esfran"+u"\u00E7", "esfrandelh", "esfrangalh", "esfreg",
"esfregon"+u"\u00E7", "esfregulh", "esfri", "esfrol", "esfrunh", "esfueir",
"esfugant", "esfugent", "esfulinh", "esfum", "esfuma"+u"\u00E7", "esfumar",
"esfumilh", "esfuminh", "esfundilh", "esfurac", "esfuranc", "esfurgalh",
"esfuri", "esfurinh", "esfuro", "esfutric", "esfuzi", "esfuzil",
"esg", "esga"+u"\u00E7", "esgadanh", "esgadelh", "esgadunh", "esgaiv",
"esgaldrip", "esgalg", "esgalh", "esgalinh", "esgalrich", "esgamo",
"esgamp", "esgan", "esganch", "esgani"+u"\u00E7", "esganif", "esganifr",
"esganit", "esgar", "esgarabanh", "esgarabulh", "esgarafunch", "esgarafunh",
"esgaratuj", "esgaravan", "esgaravat", "esgaravunch", "esgaravunh", "esgar"+u"\u00E7",
"esgardunh", "esgarg", "esgargal", "esgargalh", "esgarn", "esgarnach",
"esgarr", "esgarrabunh", "esgarrafunch", "esgarranch", "esgarranh", "esgasgalh",
"esgatanh", "esgati"+u"\u00E7", "esgod", "esgoel", "esgoldrej", "esgorj",
"esgot", "esgrabulh", "esgrafi", "esgrafit", "esgraminh", "esgravan",
"esgravat", "esgravelh", "esgravulh", "esgrelh", "esgril", "esgrim",
"esgrouvi", "esgrouvinh", "esgrovinh", "esguard", "esguarit", "esguedelh",
"esgueir", "esguelh", "esgui", "esguich", "esguilh", "esguit",
"esgurej", "esladro", "eslag", "eslagart", "eslaviz", "eslavoir",
"eslavour", "esling", "esm", "esmadrig", "esmag", "esmagach",
"esmagalh", "esmagunch", "esmai", "esmaleit", "esmalh", "esmalm",
"esmalt", "esmamon", "esmani", "esmanj", "esmantel", "esmaranh",
"esmaravalh", "esmarc", "esmarmoir", "esmarmour", "esmarnec", "esmarnoc",
"esmarro", "esmarrot", "esmartu"+u"\u00E7", "esmatru"+u"\u00E7", "esmech", "esmelm",
"esmelodr", "esmen", "esmer", "esmeril", "esmerilh", "esmerm",
"esmeti", "esmich", "esmifr", "esmigalh", "esmija"+u"\u00E7", "esmilh",
"esmiol", "esmirr", "esmiud", "esmiun"+u"\u00E7", "esmoc", "esmoch",
"esmoic", "esmoit", "esmol", "esmolamb", "esmon", "esmonc",
"esmond", "esmor"+u"\u00E7", "esmorda"+u"\u00E7", "esmordel", "esmordic", "esmordi"+u"\u00E7",
"esmorm", "esmoron", "esmorr", "esmorra"+u"\u00E7", "esmorrat", "esmorz",
"esmoss", "esmouc", "esmouquel", "esmout", "esmur", "esmurr",
"esmurra"+u"\u00E7", "esmurreg", "esmurreng", "esnac", "esnob", "esnoc",
"esnu", "espa"+u"\u00E7", "espacej", "espaci", "espacializ", "espad",
"espadachin", "espadag", "espadan", "espadeir", "espadel", "espadi",
"espadilh", "espadu", "espajeg", "espald", "espaldeir", "espalh",
"espalhafat", "espalhag", "espalit", "espalm", "espalomb", "espampan",
"espampar", "espan", "espanasc", "espanc", "espandong", "espanej",
"espanhol", "espanholiz", "espant", "espantarol", "espap", "espapa"+u"\u00E7",
"espaparr", "esparcel", "espardalh", "espargel", "esparr", "esparrach",
"esparralh", "esparram", "esparranh", "esparreg", "esparrel", "esparrim",
"esparrinh", "esparrod", "espars", "espartej", "espartilh", "esparv",
"esparvo", "espasm", "espassaric", "espassarot", "espatarr", "espatif",
"espatilh", "espatul", "espavent", "espavil", "espavit", "espavoriz",
"espec", "espe"+u"\u00E7", "especi", "especializ", "especific", "espect",
"espectraliz", "espectrific", "especul", "espeda"+u"\u00E7", "espedar"+u"\u00E7", "espedreg",
"espeit", "espeitor", "espelh", "espendur", "espenej", "espenic",
"espenifr", "espenuj", "esper", "esperan"+u"\u00E7", "esperanci", "esperdi"+u"\u00E7",
"esperdigot", "esperjur", "esperlux", "espermatiz", "espermeg", "esperneg",
"esperrinch", "espert", "espertin", "espesco"+u"\u00E7", "espess", "espet",
"espetaculiz", "espetal", "espetraliz", "espetrific", "espevit", "espezinh",
"espi", "espiant", "espica"+u"\u00E7", "espica"+u"\u00E7"+"o", "espich", "espicoi"+u"\u00E7",
"espicou"+u"\u00E7", "espicul", "espif", "espig", "espigait", "espiguilh",
"espildr", "espilr", "espinafr", "espin"+u"\u00E7", "espinch", "espingalh",
"espingard", "espinh", "espinic", "espinot", "espiolh", "espion",
"espip", "espipoc", "espir", "espiral", "espiraliz", "espirantiz",
"espirit", "espiritiz", "espiritualiz", "espirr", "espirrich", "esplain",
"esplendor", "esplenectomiz", "espo", "espoc", "espoj", "espojinh",
"espoldr", "espoldrinh", "espolet", "espoli", "espolin", "espolinh",
"espolp", "esponj", "espont", "esponteir", "esponto", "espor",
"esporific", "esporo", "esporr", "esporteir", "esportul", "esporul",
"espos", "espostej", "espot", "espotrej", "espotric", "espouc",
"espragat", "esprai", "espregui"+u"\u00E7", "espreit", "espremeg", "esprit",
"espulg", "espum", "espuma"+u"\u00E7", "espumarej", "espumej", "espupin",
"esput", "esquadr", "esquadra"+u"\u00E7", "esquadrej", "esquadri", "esquadrilh",
"esquadrinh", "esquadron", "esquartej", "esquartel", "esquartilh", "esquematiz",
"esquent", "esquerd", "esquerdiz", "esqui", "esqui"+u"\u00E7", "esquif",
"esquil", "esquin", "esquip", "esquirol", "esquiss", "esquistific",
"esquit", "esquiv", "estaban", "estabilit", "estabiliz", "estaboug",
"estabul", "estac", "esta"+u"\u00E7", "estacion", "estadi", "estadiz",
"estadualiz", "estaf", "estafeg", "estaferm", "estafet", "estafon",
"estagflacion", "estagi", "estagn", "estai", "estal", "estaleir",
"estalej", "estalic", "estalid", "estalon", "estambr", "estamin",
"estamp", "estampilh", "estanc", "estanci", "estandardiz",
"estanh", "estard", "estardalh", "estardalha"+u"\u00E7", "estarel", "estarrific",
"estarrinc", "estarro", "estartal", "estasi", "estassalh", "estatel",
"estatistific", "estatiz", "estatu", "estaz", "esteanaz", "esteatiz",
"esteir", "estelic", "estenaz", "estenodactilograf", "estenodatilograf", "estenofotolitograf",
"estenograf", "estenos", "estenotip", "ester", "esterc", "ester"+u"\u00E7",
"estereofotograf", "estereograf", "estereotip", "estereotomiz", "esterific", "esteriliz",
"esterlic", "esternic", "esternud", "esternut", "esterotomiz", "esterr",
"esterro", "estertor", "estertoriz", "estesi", "estesilh", "estesoir",
"estesour", "esteticiz", "estetiz", "estev", "esti", "estic",
"estigm", "estigmatiz", "estilet", "estiletiz", "estilh",
"estilha"+u"\u00E7", "estilicid", "estiliz", "estim", "estimul", "esting",
"estinh", "estiol", "estiomen", "estipendi", "estipul", "estir",
"estira"+u"\u00E7", "estiv", "estoc", "esto"+u"\u00E7", "estof", "estoir",
"estoirinh", "estoj", "estol", "estomag", "estomeg", "estoment",
"eston", "estonh", "estont", "estop", "estopet", "estoqueir",
"estorceg", "estorcic", "estordeg", "estorn", "estorneg", "estornic",
"estorrej", "estorric", "estorro", "estorteg", "estortur", "estorv",
"estorved", "estour", "estourinh", "estoutin", "estouv", "estov",
"estr", "estrab", "estrabouc", "estrabouch", "estra"+u"\u00E7"+"alh", "estracinh",
"estra"+u"\u00E7"+"o", "estrad", "estradul", "estrafeg", "estrag", "estral",
"estralej", "estramalh", "estrambalh", "estrambelh", "estramont", "estramp",
"estrampalh", "estramunh", "estran"+u"\u00E7", "estrancilh", "estrancinh", "estranfeni",
"estranfoli", "estranfolinh", "estranfoni", "estrangalh", "estrangul",
"estranh", "estrapa"+u"\u00E7", "estrapilh", "estraquej", "estrategi", "estratific",
"estrav", "estravir", "estrebang", "estrebord", "estrebuch", "estrefeg",
"estreg", "estreit", "estrel", "estrelej", "estrelic", "estrelou"+u"\u00E7",
"estrem", "estremadur", "estremalh", "estremud", "estremulh", "estremunh",
"estrenoit", "estrenout", "estrep", "estrepass", "estrepit", "estress",
"estressalh", "estretal", "estri", "estrib", "estribilh", "estri"+u"\u00E7",
"estrich", "estricniniz", "estricniz", "estridul", "estrig", "estril",
"estrim", "estrinc", "estrin"+u"\u00E7", "estrinch", "estrip", "estrobiliz",
"estro"+u"\u00E7", "estrocic", "estroin", "estroix", "estromb", "estromp",
"estronc", "estron"+u"\u00E7", "estrond", "estrondej", "estronf", "estrongalh",
"estropeli", "estropi", "estrotej", "estrouvinh", "estroux", "estrovinh",
"estrufeg", "estrum", "estrumbic", "estrupid", "estrutur", "estruturaliz",
"estu", "estuc", "estuch", "estud", "estuf", "estug",
"estuliz", "estultific", "estum", "estupefic", "estupid", "estupidific",
"estupigait", "estupor", "estupr", "esturdi", "esturr", "esturric",
"esturrinh", "esvali", "esvalij", "esvar", "esvaz", "esvazi",
"esvent", "esventr", "esver"+u"\u00E7", "esverdinh", "esvid", "esvidig",
"esvinh", "esviscer", "esvoa"+u"\u00E7", "esvoej", "esvurm", "eterific",
"eteriz", "etern", "eterniz", "eticiz", "etil", "etiliz",
"etimologiz", "etiquet", "eufemiz", "eufoniz", "euforiz", "eugeniz",
"eutrofiz", "ev", "evacu", "evagin", "evangeliz", "evapor",
"evaporiz", "evapotranspir", "evaz", "eventr", "evermin", "evidenci",
"evir", "eviscer", "evit", "evoc", "evol", "evolucion",
"exabund", "exacerb", "exager", "exagit", "exal", "exal"+u"\u00E7",
"exalt", "examin", "exar", "exarticul", "exasper", "exatific",
"exaust", "exautor", "excarcer", "excardin", "excarnific", "excecion",
"excels", "excepcion", "exceptu", "excetu", "excis", "excit",
"exclam", "exclaustr", "exclausur", "excogit", "excomung", "excomunh",
"excorpor", "excrement", "excret", "excruci", "exculp", "excurs",
"excursion", "excurv", "execr", "execut", "exempl", "exemplariz",
"exemplific", "exempt", "exercit", "exerd", "exgreg", "exiguific",
"exil", "exit", "exoner", "exor", "exorbit", "exorcism",
"exorciz", "exordi", "exorn", "exort", "expatri", "expect",
"expector", "expedr", "expeitor", "experienci", "experiment", "expet",
"expetor", "expi", "expil", "expir", "explan", "explant",
"explic", "explicit", "explor", "explot", "exponenci", "export",
"expostul", "express", "exprob", "exprobr", "expropri", "expugn",
"expuls", "expurg", "exsic", "exst", "exsu", "exsud",
"extasi", "extenu", "exterioriz", "extermin", "extern", "externaliz",
"externiz", "extirp", "extrabord", "extract", "extradicion", "extradit",
"extrafoli", "extrapass", "extrapol", "extrat", "extravaganci", "extravas",
"extravi", "extrem", "extric", "extrofi", "extub", "exuber",
"exul", "exulcer", "exult", "exum", "exund", "exurbaniz",
"exventr", "fabric", "fabul", "fabuliz", "faccion", "faceci",
"faceir", "facej", "facet", "fach", "fachol", "facilit",
"facion", "factor", "facult", "facundi", "fad", "fadej",
"fadig", "fadist", "fadistocratiz", "fag", "fagulh", "fai",
"fain", "fair", "faix", "fajut", "fal", "fala"+u"\u00E7",
"falaci", "faladr", "falaz", "falc", "falca"+u"\u00E7",
"falcatru", "falco", "falej", "falh", "falhoc", "faloc",
"falporri", "falquej", "fals", "falsific", "falt", "faluc",
"fambiss", "familiariz", "familot", "famul", "fan", "fanatiz",
"fandang", "fanding", "fanf", "fanfarr", "fanfarron", "fanfurri",
"fangan", "fangarel", "fanic", "fanich", "fantasi", "fantasm",
"fantasmagoriz", "fantasmiz", "fantoch", "fantochin", "fanuc", "faquiriz",
"far", "faradiz", "farandol", "fard", "farej", "farel",
"faretr", "farfalh", "farfalhej", "farfalin", "farin", "faringaliz",
"farinh", "farisc", "farofi", "farol", "faroliz", "farp",
"farpo", "farr", "farrap", "farrasc", "farronc", "farsol",
"fart", "farung", "fascin", "fascistiz", "fasqui", "fast",
"fastigi", "fataliz", "fatan", "fatej", "fati", "fatig",
"fator", "fatoriz", "fatuej", "fatur", "faul", "faulh",
"fautoriz", "fav", "faveliz", "favoni", "favorit", "favoriz",
"faxin", "febricit", "febriliz", "fech", "fecund", "fecundiz",
"fedanh", "fedelh", "feder", "federaliz", "fedinch", "fedonh",
"fefet", "feitori",
"feitoriz", "fel", "feldspatiz", "felicit", "feloni", "felp",
"feltr", "femb", "femen"+u"\u00E7", "feminiliz", "feminiz", "fen",
"fendilh", "fendrelh", "fendrilh", "fenestr", "fenoliz", "fenomenaliz",
"feri", "ferment", "ferr", "ferrament", "ferrej", "ferret",
"ferreto", "ferro", "ferrob", "ferrolh", "fertiliz", "fervelh",
"fervent", "fervilh", "fervor", "fescoliz", "fest", "festej",
"festin", "festo", "feston", "feudaliz", "fi", "fiamp",
"fibril", "fic", "fich", "fideliz", "figur",
"fil", "filagran", "filet", "filhar", "filhastr",
"fili", "filigran", "filip", "filipiz", "filistri", "film",
"filmograf", "filoidin", "filosof", "filtr", "fimbri", "fin",
"finaliz", "financi", "finc", "find", "findaliz", "finf",
"fint", "firm", "firr", "fiscaliz", "fiscel", "fisg",
"fisiologiz", "fissiliz", "fission", "fissur", "fistul", "fistuliz",
"fit", "fituc", "fix", "flabel", "flafl", "flagel",
"flagici", "flagr", "flain", "flam", "flamb", "flamej",
"flamispir", "flamul", "flan", "flart", "flaut", "flavortiz",
"flebotomiz", "flech", "flegmasi", "flert", "flexibiliz", "flexion",
"flexu", "flim", "flip", "flirt", "flit", "floc",
"flocon", "flocul", "flogistic", "flogos", "flor", "florej",
"florest", "flostri", "flot", "fluid", "fluidific", "fluidiz",
"fluor", "flutu", "fob", "fobit", "foc", "fo"+u"\u00E7",
"focaliz", "focinh", "fof", "fofoc", "fofuenh", "fogach",
"foi"+u"\u00E7", "foicinh", "folcloriz", "folec", "foleg", "folerp",
"folestri", "folg", "folgaz", "folh", "folhec", "folhetiniz",
"foli", "foment", "fonetiz", "fonfon", "fonocardiograf", "fonocinematograf",
"fonofilm", "fonograf", "fonologiz", "forc", "for"+u"\u00E7", "forcej",
"forj", "forjic", "form", "formaliz", "format", "formic",
"formicid", "formig", "formiguej", "formilh", "formol", "formoliz",
"formosent", "formul", "formulariz", "fornej", "fornic", "fornig",
"fornizi", "forquilh", "forr", "forraj", "forrej", "forric",
"forta"+u"\u00E7", "fortaleg", "fortalez", "fortific", "fortun", "fosc",
"fosfat", "fosfor", "fosforej", "fosforil", "fosforit", "fosforiz",
"foss", "fossang", "fossilific", "fossiliz", "fotoativ", "fotocopi",
"fotodissoci", "fotofosforiliz", "fotograf", "fotograv", "fotointerpret", "fotolit",
"fotolitograf", "fotometr", "fotominiaturiz", "fotomont", "fotomultiplic", "fotosforil",
"fotossensibiliz", "fotossintetiz", "fototip", "fototipi", "fou"+u"\u00E7", "foucinh",
"frac", "fracass", "fraccion", "fracion", "fractur", "frad",
"fradej", "fragiliz", "fragment", "fragor", "frald", "fraldej",
"fraldic", "frama"+u"\u00E7"+"oniz", "frances", "francesi", "franciuz", "francofoniz",
"frangalh", "franj", "franqui", "fraquej", "fraquent", "frasquej",
"frasquinh", "fraterniz", "fratur", "fraud", "fraut", "frech",
"freg", "freir", "frejuc", "fren", "frenesi", "frequent",
"fres", "fresc", "fresquej", "fret", "fretej", "frev",
"fricatiz", "friccion", "frigorific", "frinch", "fris", "frit",
"froc", "froix", "frol", "frond", "frondej", "front",
"fronteir", "froux", "frufrulh", "frufrut", "frulh", "frustr",
"fruteg", "frutific", "fubec", "fu"+u"\u00E7", "fueir",
"fug", "fujic", "fulaniz", "fulec", "fulgent", "fulgur",
"fulguraresfuzi", "fulmin", "fulo", "fum", "fuma"+u"\u00E7", "fumar",
"fumeg", "fumig", "fun", "funambul", "funcion", "funcionaliz",
"fund", "fundalh", "fundament", "fundilh", "funest", "funf",
"funfi", "fung", "fur", "furac", "furdun"+u"\u00E7", "furfunh",
"furifun", "furo", "furri", "furt", "furtic", "furunf",
"furung", "fus", "fusc", "fusg", "fusion", "fustig",
"futic", "futiliz", "futret", "futric", "futuc",
"futuriz", "fuxic", "fuzil", "gab", "gabarit", "gabarol",
"gabi", "gabion", "gadanh", "gadi"+u"\u00E7", "gadunh", "gaf",
"gafeir", "gafej", "gaguej", "gai", "gaiat", "gaifon",
"gaimo", "gait", "gaiv", "gaj", "gal", "galan",
"galantiz", "galardi", "galardo", "galderi", "galdrop", "galeguiz",
"galg", "galhof", "galic", "galiciparl", "galicism", "galiciz",
"galim", "galimatiz", "galinh", "galiv", "galo", "galomaniz",
"galon", "galop", "galopin", "galr", "galrej", "galrich",
"galroch", "galvaniz", "galvanotip", "gam", "gambel", "gambi",
"gamenh", "gananci", "gan"+u"\u00E7", "ganch", "gandai", "gandul",
"ganf", "gangorr", "gangren", "ganguiss", "ganh", "gani"+u"\u00E7",
"ganiz", "ganz", "gapin", "gapui", "garabulh", "garalh",
"garan"+u"\u00E7", "garatuj", "garavet", "garf", "garfej", "garfi",
"garg", "gargada"+u"\u00E7", "gargala"+u"\u00E7", "gargalej", "gargalh", "gargantu",
"gargarej", "gargolej", "gargorej", "garguel", "garimb", "garimp",
"garin", "garn", "garo", "garot", "garr", "garram",
"garranch", "garrid", "garroch", "garrot", "garrotearestrangul", "garruch",
"garrul", "garrulej", "garu", "gasalh", "gasconiz", "gaseific",
"gasguit", "gasific", "gasm", "gast", "gastrofotograf", "gastrul",
"gat", "gatafunh", "gatanh", "gatinh", "gatun", "gatunh",
"gatur", "gaturr", "gaud", "gauder", "gauderi", "gaudi",
"gaudin", "gav", "gavion", "gazil", "gazilh", "gazin",
"gazofil", "gazol", "gazu", "gazul", "gazup", "geb",
"gebr", "gegadelh", "gel", "gelatin", "gelatinific", "gelatiniz",
"geleific", "gelific", "gem", "gemelg", "gemelhic", "gemi",
"gemic", "gemin", "gemul", "generaliz", "gentiliz", "geocentr",
"geograf", "geometriz", "georreferenci", "ger", "gerenci", "german",
"germaniz", "germin", "gess", "gest", "gesticul", "gestion",
"gestualiz", "gigantiz", "ginastic", "ging", "gingr", "gir",
"giraldin", "girandol", "girassol", "girogir", "girovag", "giz",
"gla"+u"\u00E7", "gladi", "glamoriz", "glanduliz", "glicerin", "glicuroniz",
"gliss", "globaliz", "globuliz", "glomer", "glori", "glorific",
"glos", "gloss", "gloter", "glotiz", "glotor", "glugluej",
"gluglurej", "gluglut", "glutin", "godemiz", "goder", "godi",
"goel", "gofr", "goi", "goit", "goiv", "gol",
"golej", "golelh", "golf", "golfej", "golip", "golp",
"gom", "gombel", "gomific", "gomit", "gomo", "gon",
"gondol", "gong", "gongor", "gongoriz", "gor", "gordur",
"gorgol", "gorgolej", "gorgolh", "gorgorej", "gorr", "gosm",
"gosmilh", "gost", "gotej", "goticiz", "goug", "govern",
"governamentaliz", "governich", "goz", "gracej", "gracit", "gra"+u"\u00E7"+"ol",
"grad", "gradearesterro", "gradej", "gradin", "gradu", "graf",
"grafil", "grafit", "grafitiz", "grai", "gralh", "gram",
"gramaticaliz", "gramaticiz", "graminh", "gramofon", "gramp",
"gran", "granid", "granit", "granitific", "graniz", "granul",
"granzin", "grasn", "grass", "grassit", "gratific", "gratin",
"gratul", "grav", "gravet", "gravid", "gravit", "gravunh",
"gravur", "grazin", "greciz", "greguej", "grel", "grelh",
"gret", "grif", "gril", "grilhet", "grimp", "grinald",
"grinf", "grip", "gris", "grisalh", "grit", "griv",
"grogolej", "grol", "grom", "grong", "gros", "grosm",
"grossul", "grud", "grugrulej", "grugrulh", "grugulej", "grugunz",
"grulh", "grum", "gruzi", "guaguax", "guai",
"gualdrip", "guard", "guarit", "guasc", "guaz", "guedelh",
"gueng", "guerram", "guerrilh", "gueviss", "gugluej", "gui",
"guid", "guilhoch", "guilhotin", "guiloch", "guin", "guinch",
"guind", "guinh", "guirland", "guis", "guiz", "guizalh",
"gulaim", "gulap", "gulaz", "guleim", "gulos", "guloseim",
"gulosin", "gunf", "gungun", "gurgit", "gust", "gut",
"guturaliz", "habilit", "habit", "habitu", "hachur", "halit",
"halogen", "halogenoderiv", "haragan", "hariol", "harmoniz", "harp",
"harpej", "harpeji", "hastilh", "hausmaniz", "haussemaniz", "haussmanniz",
"hebet", "hebetiz", "hectometr", "hegemoniz", "heleboriz", "heleniz",
"heliport", "helitransport", "hemaglutin", "hematiz", "hematos", "hemoaglutin",
"hemoconcentr", "hemodialis", "hemolis", "hemossediment", "hepatectomiz", "hepatiz",
"herboriz", "herd", "heresi", "hermetific", "herni", "heroiciz",
"heroific", "heroiz", "hesit", "het", "heteroaglutin", "heterocarreg",
"heterocromatiz", "heterogeneiz", "heteroimuniz", "heteropolimeriz", "heterossugestion", "heterotransplant",
"hialiniz", "hiatiz", "hibern", "hibrid", "hibridiz", "hidrat",
"hidrobor", "hidrocarbon", "hidrocut", "hidrodessulfuriz", "hidroextrat", "hidrofobiz",
"hidrogen", "hidrolis", "hidrometr", "hidroport", "hidrotomiz", "hidroxideriv",
"hiemaliz", "hierarquiz", "hieratiz", "hifeniz", "higieniz", "hilari",
"hilariz", "hiperadapt", "hiperafirm", "hiperajust", "hiperaliment", "hiperaplic",
"hiperaprimor", "hiperativ", "hiperbenefici", "hiperboliz", "hipercapacit", "hipercaricatur",
"hipercomplex", "hiperdimension", "hiperdos", "hiperemi", "hiperequip", "hiperestesi",
"hiperestrutur", "hiperexager", "hiperexplor", "hiperglicemi", "hiperimpregn", "hiperimuniz",
"hiperindustri", "hiperindustrializ", "hiperinfeccion", "hiperinflacion", "hiperirrit", "hiperliterariz",
"hiperocup", "hiperofert", "hiperorden", "hiperorganiz", "hiperotimiz", "hiperoxid",
"hiperoxigen", "hiperpigment", "hiperpolariz", "hipersemantiz", "hipersensibiliz", "hipertrofi",
"hiperurbaniz", "hipervaloriz", "hipervasculariz", "hiperventil", "hipnotiz", "hipocratiz",
"hipofisectomiz", "hipoglicemi", "hipossensibiliz", "hipostasi", "hiposteniz", "hipotec",
"hipotrofi", "hipoxi", "hirt", "hirudiniz", "hisp", "hispanific",
"hispaniz", "hispid", "hissop", "histeriz", "histocompatibiliz", "histodiferenci",
"histori", "historializ", "historiciz", "historiz", "histrion", "holandiz",
"holocaust", "holofotiz", "holograf", "homeotransplant", "homicid", "homili",
"hominiz", "homizi", "homogeniz", "homolog", "homopolimeriz", "homostimul",
"homotransplant", "honest", "honestiz", "honor", "honorific", "honr",
"honrific", "hor", "horej", "horizont", "horizontaliz", "hormoniz",
"horoscop", "horoscopiz", "horrific", "horripil", "horroriz", "hort",
"hortej", "horticult", "hosped", "hospitaliz", "hostiliz", "hulhific",
"human", "humaniz", "humet", "humific", "humild", "humilh",
"humoriz", "ianquiz", "iarovis", "iberiz", "i"+u"\u00E7", "ichacorv",
"iconiz", "icterici", "idealiz", "identific", "ideograf", "ideologiz",
"idiliz", "idiot", "idiotific", "idiotiz", "idolatr", "idolatriz",
"ignific", "ignifug", "igniz", "ignobiliz", "ignomini", "ignor",
"igual", "iguald", "igualh", "igualiz", "il", "ilegaliz",
"ilegitim", "ilh", "ilib", "ili"+u"\u00E7", "ilig", "ilimit",
"ilumin", "ilusion", "ilustr", "ilut", "iluvi", "imagin",
"iman", "imanentiz", "imaniz", "imant", "imantiz", "imaterializ",
"imbecilit", "imbeciliz", "imbelic", "imbelinh", "imbic",
"imbond", "imbram", "imbric", "imedi", "imediat", "imers",
"imigr", "imit", "imobiliz", "imoir", "imol", "imortaliz",
"imot", "imour", "imp", "impacient", "impact", "impalud",
"impan", "imparcializ", "impassibiliz", "impelg", "imper", "imperfei"+u"\u00E7"+"o",
"imperializ", "imperl", "impermeabiliz", "impersonaliz", "impersonific", "impertinenci",
"impessoaliz", "impet", "impetilh", "impetr", "impinim", "implant",
"implement", "implic", "implor", "impont", "impopulariz", "import",
"importun", "impossibilit", "impost", "impostur", "imprec", "imprecat",
"imprecis", "impregn", "impremedit", "imprens", "impression", "imprestabiliz",
"imprim", "improb", "impront", "impronunci", "improper", "improporcion",
"impropri", "improv", "improvis", "impugn", "impuls", "impulsion",
"impulsiv", "impurific", "imput", "imund", "imuniz", "imut",
"imutabiliz", "inabilit", "inabit", "inadapt", "inadat", "inadestr",
"inadun", "inal", "inalien", "inalter", "inambul", "inanim",
"inativ", "inaugur", "in"+u"\u00E7", "incamer", "incapacit", "incapsul",
"incaracteriz", "incardin", "incarn", "incens", "incentiv", "incert",
"incest", "incestu", "inch", "inci", "incident", "inciner",
"incis", "incit", "inclin", "inco", "incolor", "incomod",
"incompatibiliz", "incomunic", "inconform", "inconfort", "inconsolid", "inconst",
"inconstitucionaliz", "incontest", "incorpor", "incrass", "increment", "increp",
"incrimin", "incris", "incruent", "incrust", "incub", "inculc",
"inculp", "incurric", "incursion", "indag", "indegr", "indelimit",
"indemniz", "indeniz", "independentiz", "independiz", "indetect", "indetermin",
"index", "indianiz", "indic", "indici", "indicific", "indigeniz",
"indigest", "indigit", "indign", "indignific", "indilg", "indinh",
"indisciplin", "indiscrimin", "individu", "individualiz", "indociliz", "indocument",
"indolent", "indoutrin", "indromin", "indulgenci", "indult", "indument",
"industri", "industrializ", "indut", "inebri", "ineptiz", "inequacion",
"inerci", "inertiz", "inerv", "inespoli", "infam", "infantiliz",
"infart", "infeccion", "infecion", "infect", "infecund", "infelicit",
"inferioriz", "infern", "inferniz", "infertiliz", "infest", "infet",
"infibul", "inficion", "infiltr", "infinc", "infirm", "infix",
"infl", "inflacion", "inflam", "inflexion", "inflor", "influenci",
"infon", "inform", "informaliz", "informatiz", "infortun", "infrond",
"infuleim", "infundament", "infunic", "infus", "ingenu", "ingles",
"ingress", "ingund", "ingurgit", "inici", "inicializ", "inigual",
"inimist", "inimit", "inimiz", "injeriz", "injet", "injun"+u"\u00E7",
"injuri", "injusti"+u"\u00E7", "injustific", "inlernaliz", "inli"+u"\u00E7", "inobserv",
"inocent", "inocul", "inor", "inoscul", "inov", "inquart",
"inquezil", "inquiet", "inquilin", "inquin", "inquizil", "insacul",
"insaliv", "insatur", "insemin", "insensibiliz", "insert", "insidi",
"insigni", "insimul", "insinu", "insipid", "insol", "insolubiliz",
"insoni", "insonoriz", "insoss", "inspecion", "inspet", "inspir",
"inspiss", "inst", "instabiliz", "instal", "instanci", "instantaniz",
"instaur", "instig", "instil", "institucionaliz", "instrument", "instrumentaliz",
"insubordin", "insufl", "insul", "insult", "insum", "insurreccion",
"insurrecion", "integr", "integraliz", "inteig", "inteir", "inteiri"+u"\u00E7",
"inteleccion", "intelecion", "intelectualiz", "inteligenci", "intemper", "intemperiz",
"intencion", "intens", "intensific", "intensiv", "intent", "interatu",
"intercal", "intercambi", "intercept", "intercomunic", "interconect", "intercruz",
"interdigit", "interdimension", "interdit", "interespacej", "interess", "interesterific",
"interestratific", "interfoli", "interfon", "interi"+u"\u00E7", "interinfluenci",
"interioriz", "interjeccion", "interjecion", "interjectiv", "interjeicion", "interjetiv",
"interla"+u"\u00E7", "interlig", "interm", "intermigr", "intermistur", "intermostr",
"intern", "internacionaliz", "internaliz", "interoper", "interpel", "interpenetr",
"interpic", "interpol", "interpolimeriz", "interpres", "interpret", "interrog",
"intersach", "intersec", "interseccion", "intersect", "interset", "intertransform",
"intertrav", "interturb", "interval", "intervencion", "intestel", "intestin",
"intic", "intim", "intimid", "intitul", "inton", "intoxic",
"intranquiliz", "intransitiv", "intrassel", "intrech", "intric", "intrigalh",
"intrinc", "introject", "introjet", "intrors", "intruid", "intruj",
"intub", "intuicion", "inum", "inund", "inutiliz", "invagin",
"invalid", "invari", "invas", "invect", "invectiv", "invej",
"invencion", "invent", "inventari", "invern", "invespr", "investig",
"invet", "inveter", "invetiv", "inviabiliz", "inviccion", "invid",
"invidi", "inviolabiliz", "inviper", "inviscer", "invisibiliz", "invit",
"invoc", "involucr", "invulg", "inzon", "iob", "iod",
"iodet", "iodin", "ioniz", "iontiz", "iotiz", "ir",
"iri", "iridi", "iris", "iriz", "irman", "ironiz",
"irracionaliz", "irradi", "irrealiz", "irreconcili", "irresponsabiliz", "irreverenci",
"irrig", "irrit", "irrog", "irror", "isc", "isent",
"islamiz", "isoacentu", "isoaglutin", "isocroniz", "isol", "isomeriz",
"israeliz", "italianiz", "italiciz", "itemiz", "iter", "jacobiniz",
"jact", "jactit", "jacul", "jaez", "jan", "janel",
"jang", "janot", "jant", "jantaric", "jantarinh", "japones",
"japoniz", "Japonv", "jard", "jardin", "jaroviz", "jarret",
"jarund", "jat", "jatanci", "jatit", "javeliz", "javr",
"jazzific", "jeit", "jeju", "jerarquiz", "jeremi", "jeremin",
"jesuitiz", "jimbr", "job", "joeir", "joelh", "jog",
"jogalh", "jogat", "jogatilh", "jogral", "jograliz", "joguet",
"jol", "jong", "jonj", "jornalistic", "jornaliz", "jorr",
"jovializ", "jubil", "judi", "judic", "judici", "judicializ",
"jug", "jugad", "jugul", "julg", "junc", "junt",
"jur", "jurament", "jurem", "jurg", "juridiciz", "jurisdicion",
"jurisdicionaliz", "just", "justi"+u"\u00E7", "justific", "juveniliz", "labanot",
"labefact", "label", "labializ", "labiovelariz", "labirint", "labor",
"labreg", "labrest", "labut", "labuz", "lac", "la"+u"\u00E7",
"lacai", "lacer", "laconiz", "lacr", "lacram", "lacran",
"lacrim", "lacrimej", "lact", "lactoniz", "lacun", "ladeir",
"ladr", "ladrej", "ladrilh", "ladrinch", "ladrinh", "ladrip",
"ladro", "ladroeir", "lagrim", "lagrimej", "laicific", "laiciz",
"laiv", "laj", "lal", "lamb", "lambar", "lambarej",
"lambarisc", "lambaz", "lambic", "lambisc", "lambit", "lambrec",
"lambreg", "lambrequinej", "lambris", "lambriz", "lambu"+u"\u00E7", "lambuj",
"lambuz", "lamech", "lameir", "lamel", "lament", "lamin",
"lamp", "lampadej", "lamparej", "lampej", "lampi", "lamuri",
"lamurinh", "lan", "lan"+u"\u00E7", "lanceol", "lancet", "lanch",
"lancin", "lancissond", "langu"+u"\u00E7", "lanh", "lantejoil", "lantejoul",
"lantern", "lanzo", "lap", "laparotomiz", "lapias", "lapid",
"lapidific", "lapij", "lapis", "lapislazul", "larach", "larapi",
"larapin", "larg", "laringograf", "larp", "larunj", "larv",
"larvej", "lasc", "lass", "lastim", "lastr", "latanh",
"lateg", "latej", "lateraliz", "latic", "latin", "lating",
"latiniz", "latitudin", "latrocin", "laudaniz", "lav", "lavaj",
"lavarej", "lavarisc", "lavasc", "laveg", "lavoir", "lavor",
"lavour", "lavr", "lavuj", "lax", "lazar", "lazeir",
"lazer", "leald", "leccion", "lecion", "legaliz",
"legend", "legifer", "legisl", "legitim", "legr", "leiaut",
"leig", "leilo", "leir", "leit", "leix", "lematiz",
"lemb", "lembr", "leng", "lengaleng", "lenh", "lenhific",
"lenific", "leniment", "lent", "lentej", "lentejoil", "lentejoul",
"leri", "les", "lesion", "lesm", "lest", "letargi",
"letific", "letr", "letriz", "lev", "levant", "leved",
"levi", "levig", "levit", "lexicaliz", "lexicograf", "li",
"lib", "libel", "liber", "liberaliz", "libert", "libr",
"librin", "licenci", "licit", "lid", "lidair", "lider",
"lidim", "lig", "lignific", "ligul", "lilliputianiz", "lim",
"limit", "limp", "linc", "linch", "lind", "lineariz",
"linf", "linfangiograf", "linfatiz", "linfoangiograf", "linfolis", "ling",
"lingot", "linguaj", "linguar", "linguarej", "linific", "liniment",
"linotip", "liofiliz", "lipoaspir", "lipolis", "liquenific", "liquid",
"liquidific", "liric", "liriciz", "lisboetiz", "lisc", "lism",
"lisogeniz", "lisonj", "list", "listr", "lit", "literariz",
"literat", "literatej", "literatiz", "literatur", "litic", "litific",
"litig", "litigi", "litograf", "livel", "livid", "livr",
"lix", "lixivi", "liz", "lo", "lobol", "lobotomiz",
"lobreg", "lobreguej", "lobrig", "loc", "localiz", "locion",
"locucion", "locuplet", "logic", "logiciz", "logorr",
"logr", "loir", "loirej", "lois", "lombaliz", "lombariz",
"lombi", "lombilh", "lombrig", "lorc", "lord", "lorg",
"lorot", "losangol", "lot", "lotej", "lou"+u"\u00E7"+"ainh", "louquej",
"lour", "lourej", "lous", "louv", "louvaminh", "luademel",
"luarej", "luariz", "lubric", "lubrific", "lucej", "lucern",
"luch", "lucid", "lucifer", "lucil", "luciol", "lucr",
"lucubr", "ludibri", "luf", "lug", "lumi", "lumpesin",
"lungul", "lunul", "lup", "lupan", "lupuliz", "lur",
"lusc", "luscofusc", "lusific", "lusitaniz", "lustr", "lut",
"luteiniz", "lux", "luxuri", "ma"+u"\u00E7", "macac", "macadamiz",
"macambuzi", "ma"+u"\u00E7"+"anet", "ma"+u"\u00E7"+"aroc", "macarron", "macavenc", "macer",
"macet", "machad", "machi", "machic", "machin", "machuc",
"maci", "maconh", "ma"+u"\u00E7"+"oniz", "macrodimension", "macroequip", "macrograf",
"macrossegment", "macuc", "macul", "macumb", "madefic", "madeir",
"madeiriz", "madeix", "madgi", "madoniz", "madorn", "madorr",
"madra"+u"\u00E7", "madraceir", "madrigaliz", "madrinh", "madrug", "madur",
"mafi", "magi", "magic", "magin", "magnetiz", "magnific",
"mago", "magulh", "mai", "maiusculiz", "major", "mal",
"malabariz", "malacachet", "malandr", "malax", "malbarat", "malconfi",
"mald", "maldi"+u"\u00E7"+"o", "maleabiliz", "malefici", "maleiniz", "malfad",
"malform", "malgast", "malgovern", "malh", "malhet", "malici",
"malign", "maligniz", "malin", "malingu", "maloc", "malogr",
"malpar", "malquist", "malsegur", "malsin", "malt", "maltos",
"maltrabalh", "maltrat", "maluc", "malvers", "malvez", "mam",
"mamaen", "mambemb", "mamp", "mamparr", "mamuj", "man",
"manc", "manch", "mancip", "mancolit", "mancomun", "mancorn",
"mand", "manding", "mandjol", "mandri", "mandrian", "mandril",
"mandrion", "manduc", "manduqui", "maneir", "manej", "mang",
"mangab", "mangol", "mangon", "mangonh", "mangr", "manguinh",
"manheir", "manhent", "manhos", "maniat", "maniet", "manifest",
"maniganci", "manilh", "maninh", "manipul", "manisfest",
"manivel", "manj", "manjeric", "manobr", "manoc", "manquej",
"manquit", "manquitol", "manualiz", "manufact", "manufactur", "manufat",
"manufatur", "manzanz", "maometaniz", "mapi", "maqui", "maquiaveliz",
"maquil", "maquilh", "maquin", "maquiniz", "mar", "maraf",
"marambai", "marangol", "maranh", "marasm", "maratiz", "maravilh",
"marc", "marcej", "marceneir", "march", "marchet", "marcializ",
"marechaliz", "marej", "marf", "marfiniz", "marfolh", "marg",
"margin", "marginaliz", "marid", "marimb", "marin", "marinh",
"marinheir", "mariol", "maripos", "marisc", "marlot", "marm",
"marmel", "marmoriz", "maromb", "marques", "marr", "marralh",
"marranch", "marret", "marric", "marro", "marroquin", "marruc",
"marteir", "martel", "martelej", "martilh", "martiriz", "maruj",
"marulh", "masc", "mascab", "mascar", "mascarr", "mascav",
"mascot", "masculiniz", "mass", "massacr", "massaj", "massific",
"masteriz", "mastig", "mastuc", "masturb", "mat", "matabich",
"matalot", "matej", "matematiz", "materializ", "matic", "matilh",
"matin", "matiz", "matrac", "matracolej", "matraquej", "matreir",
"matri", "matricul", "matrimoni", "matriz", "matruc", "matur",
"maturrang", "matut", "maximaliz", "maximiz", "maxix", "mazanz",
"mazel", "mazurc", "mealh", "meandr", "mecaniz", "mecanograf",
"mech", "medalh", "medianiz", "mediatiz", "medic", "medicament",
"medicin", "medievaliz", "mediocriz", "medit", "medr", "mefitiz",
"meig", "meirinh", "mel", "melancoliz", "melaniz", "melhor",
"melific", "melifluent", "melindr", "melingr", "melodi", "melodiz",
"melodram", "melodramatiz", "melotipograf", "memor", "memori", "memoriz",
"men", "mencion", "mendic", "mendig", "meng", "menoriz",
"menoscab", "menospre"+u"\u00E7", "menospreci", "menosprez", "mensaliz", "menstru",
"mensur", "ment", "mentaliz", "mentir", "mentirol", "merc",
"mercadej", "mercadiz", "mercanci", "mercantiliz", "merceriz", "mercurializ",
"mercurific", "merej", "merend", "merenduc", "meretrici", "merg",
"mergulh", "merm", "meruj", "merunh", "mesc", "mescab",
"mescl", "mesmeriz", "mesquinh", "mess", "messianiz", "mesti"+u"\u00E7",
"mesticiz", "mesur", "metaboliz", "metacomunic", "metaconglomer", "metafisic",
"metaforiz", "metagraf", "metalific", "metaliz", "metameriz", "metamorfiz",
"metassediment", "metast", "metatetiz", "metatiz", "meteoriz", "metil",
"metodific", "metodiz", "metr", "metralh", "metrific", "metrocistograf",
"metronomiz", "metropoliz", "mexelh", "mexeric", "mexeruc", "mexilh",
"mezinh", "mi", "miasm", "mich", "microbi", "microcinematograf",
"microcircul", "microcoagul", "microcopi", "microdimension", "microequip", "microfilm",
"microfossiliz", "microfotograf", "micrograf", "microgranul", "micrograv", "micromanipul",
"micrometr", "micropotencializ", "microprocess", "microscop", "microsserrilh", "mict",
"midiatiz", "mieliniz", "mig", "migalh", "migmatiz", "migr",
"mij", "milici", "milimetr", "milionariz", "milit", "militariz",
"milonitiz", "mim", "mimeograf", "mimetiz", "mimic", "min",
"miner", "mineraliz", "ming", "minhoc", "mini", "miniatur",
"miniaturiz", "minific", "minimaliz", "miniminiz", "minimiz", "ministr",
"ministrific", "minor", "minoriz", "minotaur", "minotauriz", "minuci",
"minud", "minudenci", "minuscul", "minusculiz", "minut", "mir",
"miracul", "mirific", "miron", "mirr", "misc", "miscigen",
"miscr", "miser", "miserabiliz", "misgalh", "miss", "mission",
"misticiz", "mistific", "mistur", "mitific", "mitig", "mitiz",
"mitr", "mitridatiz", "mix", "mixorof", "mnemoniz", "mobil",
"mobilh", "mobiliz", "moc", "mo"+u"\u00E7", "moch", "modaliz",
"model", "modeliz", "moder", "moderniz", "modic",
"modific", "modilh", "modorn", "modorr", "modul", "modulariz",
"moest", "mof", "mofumb", "mofund", "mogang", "mogic",
"moin", "moinh", "moir", "moirej", "moiriz", "moit",
"moj", "mojic", "mold", "moldur", "molec", "moleculariz",
"molej", "moleng", "molest", "molg", "molh", "molific",
"molin", "molinh", "molism", "mom", "monaquiz", "monarqui",
"monarquiz", "monc", "mond", "monetiz", "mongoliz", "monidrat",
"monilh", "monitor", "monitoriz", "monoclor", "monoculiz", "monodi",
"monograf", "monogram", "monolocul", "monolog", "monopoliz", "monossilab",
"monotip", "monotiz", "monotong", "monotoniz", "mont", "monumentaliz",
"moquec", "mor", "moraliz", "morang", "morbidiz", "morceg",
"morchet", "morda"+u"\u00E7", "mordic", "mordisc", "mordom", "mordomiz",
"morej", "morf", "morfil", "morfin", "morfiniz", "morfodiferenci",
"morg", "moriger", "morn", "morra"+u"\u00E7", "morrinh", "morseg",
"mortalh", "mortaliz", "mortific", "mosc", "mosquit", "moss",
"mossec", "mosseg", "mostr", "mostreng", "motej", "motet",
"motin", "motiv", "motomecaniz", "motoriz", "mouc", "mouf",
"moum", "mour", "mourej", "mourisc", "mouriz", "moviment",
"mox", "moxam", "muchic", "mu"+u"\u00E7"+"ulmaniz", "mud", "muem",
"muen", "mufic", "mufumb", "mugang", "mujimb", "mujin",
"mulad", "mult", "multangul", "multiangul", "multiarticul", "multicelul",
"multicit", "multigraf", "multinund", "multiplex", "multiplic", "multiprocess",
"multivari", "multivibr", "mumific", "mumiz", "mundan", "mundaniz",
"mundi", "mundializ", "mundific", "mungang", "munhec", "munici",
"municion", "municipaliz", "mupic", "mupuc", "muquinh", "mur",
"muralh", "murch", "murjin", "murmulh", "murmur", "murmurej",
"murmuri", "murmurinh", "muruj", "musealiz", "musg", "music",
"musicaliz", "mussit", "mutarrot", "mutil", "mutr", "mutreit",
"mutret", "mutu", "muxic", "muxim", "muxox", "muxurund",
"nacar", "nacariz", "nacionaliz", "nad", "nadific", "nag",
"naip", "namor", "namoric", "namorich", "namorisc", "nan",
"narcis", "narcotiz", "narr", "nasal", "nasaliz", "nastr",
"natur", "naturaliz", "naufrag", "navalh", "naveg", "navel",
"nazific", "neblin", "nebrin", "nebuliz", "necessit", "necrologi",
"necropsi", "necros", "necrotiz", "nectariz", "nefanalis", "nefeliniz",
"neg", "nega"+u"\u00E7", "negativ", "negativiz", "neglicenci", "negligenci",
"negoci", "negraliz", "negrej", "negrit", "nenec", "neocoloniz",
"neoform", "neologism", "neologiz", "nervosiz", "nesg", "neurasteniz",
"neuros", "neurotiz", "neutraliz", "nev", "nevisc", "nevo",
"nevoa"+u"\u00E7", "nevoent", "nic", "nich", "nicotin", "nicotiz",
"nict", "nid", "nidific", "nigel", "niilific", "nili",
"nimb", "nin", "ninain", "ninh", "niponiz", "niquel",
"niqueliz", "niquil", "nirvan", "nirvaniz", "nitidific", "nitidiz",
"nitr", "nitragin", "nitrat", "nitret", "nitrific", "nitroderiv",
"nitros", "nitrur", "nivel", "nobeliz", "nobilific", "nobilit",
"nobiliz", "noc", "noctambul", "noctivag", "nod", "nodo",
"noiv", "noj", "nomadiz", "nomencl", "nomenclatur", "nomin",
"nominaliz", "normaliz", "normatiz", "nosograf", "nostalgiz", "not",
"notabiliz", "notambul", "notici", "notific", "noturniz", "nov",
"novel", "novici", "nuan"+u"\u00E7", "nubel", "nubl", "nucleariz",
"nulific", "numer", "nunci", "nupci", "nut", "nutrific",
"nuverinh", "obcec", "obdur", "ober", "obfirm", "objeccion",
"objecion", "objectific", "objectiv", "objetific", "objetiv",
"objurg", "oblat", "obliter", "obnubil", "obnunci", "obr",
"obrad", "obrej", "obrig", "obsceniz", "obscurantiz", "obsecr",
"obsed", "obsedi", "obsequi", "observ", "obsession", "obsidi",
"obsolet", "obst", "obstacul", "obstaculiz", "obstin", "obstinarporfi",
"obstip", "obtemper", "obtest", "obtur", "obumbr", "obvi",
"oc", "ocasion", "ocidentaliz", "octan", "octangul", "octuplic",
"ocult", "ocup", "ocurs", "odor", "odoriz", "ofeg",
"oferend", "ofert", "ofici", "oficializ", "ofusc", "og",
"ogiv", "oig", "oir", "oirej", "oiri"+u"\u00E7", "oitav",
"ojeriz", "olead", "oleagin", "olfact", "olfat", "olh",
"oligarquiz", "oliv", "olivel", "oloriz", "olvid", "omin",
"onaniz", "ond", "ondej", "ondo", "ondul", "oner",
"onzen", "onzeneir", "op", "opac", "opacific", "opalin",
"opaliniz", "opaliz", "oper", "operacionaliz", "opi", "opil",
"opin", "oportuniz", "opt", "optimiz", "opugn", "opulent",
"opuscul", "or", "oracul", "oraculiz", "oraliz", "orbit",
"or"+u"\u00E7", "or"+u"\u00E7"+"ament", "orden", "ordenh", "ordinh", "orelh",
"orfan", "organific", "organiz", "organoform", "organofosfor", "organsin",
"orgi", "orgulh", "orient", "orientaliz", "origin", "originaliz",
"orl", "orladur", "orn", "ornament", "ornej", "orograf",
"orquestr", "orquiectomiz", "ortig", "ortocromatiz", "ortogonaliz", "ortograf",
"ortonormaliz", "ortopantomograf", "ortorretific", "orvalh", "oscil", "oscit",
"oscul", "osleriz", "osseaniz", "ossianiz", "ossific", "ostent",
"ostraciz", "oteeniz", "oteniz", "otimiz", "oug", "our",
"ourej", "ourel", "ouri"+u"\u00E7", "ourin", "ous", "ousi",
"out", "outav", "outon", "outorg", "ov", "ovacion",
"oval", "ovaliz", "ovul", "oxid", "oxigen", "oxigeniz",
"oxitoniz", "ozon", "ozonific", "ozoniz", "pabul", "pacej",
"pachol", "pacient", "pacific", "pact", "pactu", "padej",
"padr", "padrinh", "padroniz", "paduc", "pag", "pagai",
"paganiz", "pagin", "pair", "paiv", "paladin", "palanc",
"palataliz", "palatiz", "palavr", "palavrej", "palecion", "palej",
"paleograf", "palerm", "palestr", "palet", "palh", "palhet",
"palhi"+u"\u00E7", "pali", "palidej", "palific", "palit", "palm",
"palmato", "palmatori", "palmej", "palmilh", "palom", "palomb",
"palor", "palorej", "palp", "palpabiliz", "palpebrej", "palpit",
"palr", "pan", "pana"+u"\u00E7", "pand", "pandeg", "pandemiz",
"pandicul", "pandilh", "pandulh", "panegiric", "panegiriz", "panej",
"panflet", "pang", "pangai", "panific", "panoramiz", "panri",
"pansianiz", "pantaniz", "pantograf", "pantomim", "pantomin", "panzu",
"pap", "papagai", "papagu"+u"\u00E7", "papaguej", "paparic", "paparrot",
"papej", "papelon", "papi", "papoc", "papoil", "papouc",
"papoul", "papuj", "paqueir", "paquer", "par", "parabeniz",
"paraboliz", "paradigmatiz", "paradox", "parafin", "parafiniz", "parafus",
"paragon", "paragraf", "paraleliz", "paralis", "paralitic", "paralogiz",
"parament", "parametriz", "paramilitariz", "paramuscul", "parangon", "paraninf",
"parapeit", "parasit", "parcel", "parcelariz", "parcialid", "parcializ",
"pard", "pardal", "pardalit", "pardej", "parej", "parelh",
"parent", "parentes", "parentesi", "paresi", "parific", "parisianiz",
"parl", "parlament", "parlamentariz", "parlamentiz", "parlend", "parleng",
"parodi", "parol", "paroqui", "parouvel", "paroxitoniz", "parr",
"parraf", "parran"+u"\u00E7", "parron", "partej", "particion", "particip",
"particulariz", "partidariz", "partilh", "parturej", "parvoeir", "parvoej",
"pascent", "pasco", "pasigraf", "pasm", "paspalh", "pasquin",
"pass", "passaj", "passaman", "passarinh", "passarit", "passej",
"passinh", "passiv", "past", "pastej", "pasteuriz", "pastich",
"pastilh", "pastinh", "pastor", "pastoraliz", "pastorej", "pastoriz",
"patanh", "patarat", "pateg", "patej", "patent", "patentiz",
"patet", "pati", "patin", "patinh", "patoil", "patol",
"patranh", "patriz", "patro", "patrocin", "patrol", "patroniz",
"patrulh", "patusc", "paul", "paulific", "paulistaniz", "pauperiz",
"paurometaboliz", "paus", "paut", "pavej", "paves", "paviment",
"paxaliz", "peal", "pec", "pech", "pechinch", "pechiring",
"pe"+u"\u00E7"+"onhent", "peculiariz", "pedagogiz", "pedal", "pedalej", "pedantiz",
"pedestaliz", "pedic", "pedicel", "pediculiz", "pediment", "pedinch",
"pedinh", "pedint", "pediplan", "pedr", "peg", "peganh",
"peguilh", "peguinh", "pegunt", "peid", "peidorr", "pein",
"peit", "peitalh", "peix", "pej", "pejor", "pel",
"pelech", "pelej", "peletiz", "pelich", "pelid", "pelintr",
"pelletiz", "peloriz", "pelotiz", "pember", "pembr", "pen",
"penach", "penaliz", "pendenci", "pendo", "pendor", "pendul",
"pendur", "penduric", "peneir", "penej", "peneplaniz", "penetr",
"penhor", "penic", "penific", "penisc", "penitenci", "pens",
"pension", "pentelh", "penuj", "penumbr", "pepin",
"peptiz", "peptoniz", "pequilh", "pequinh", "peragr", "peralt",
"peralvilh", "perambul", "perc", "percal"+u"\u00E7", "percepcion", "perceptualiz",
"percevej", "perch", "percint", "percol", "percorug", "perderiv",
"perdig", "perdigot", "perdo", "perdulari", "perdur", "peregrin",
"pereniz", "pererec", "perfectibiliz", "perfeicion", "perfei"+u"\u00E7"+"o", "perfi",
"perfil", "perfilh", "perfoli", "perform", "perfum", "perfur",
"pergaminh", "pergunt", "perici", "periclit", "perig", "periodiz",
"peripatetiz", "periquit", "perit", "peritoniz", "perjur", "perl",
"perlabor", "perlav", "perlej", "perleng", "perlong", "perlustr",
"permanganiz", "permeabiliz", "permineraliz", "permud", "permut", "pernej",
"pernoit", "pernosticiz", "pernout", "perol", "peroliz", "peror",
"peroxid", "perpass", "perpetr", "perpetu", "perreng", "perscrut",
"persever", "persign", "persilh", "personaliz", "personific", "persoterr",
"perspectiv", "perspetiv", "perspir", "pertent", "pertuch", "perturb",
"peru", "pervag", "pervoeir", "pes", "pesc", "pesg",
"pespeg", "pespont", "pesquis", "pessoaliz", "pestanej", "pestifer",
"pestilenci", "pestinh", "pet", "petanisc", "petard", "petarol",
"petec", "peteg", "peticion", "petilh", "petisc", "petit",
"petrarquiz", "petrech", "petrific", "petroliz", "pexot", "pezunh",
"pfuc", "pi", "piab", "piach", "piaf", "pial",
"pialh", "pian"+u"\u00E7", "pianiz", "pianol", "pic", "picardi",
"picaret", "pi"+u"\u00E7"+"arr", "pich", "piciric", "picot", "picu",
"picuinh", "pielograf", "pif", "pig", "pigarr", "pigment",
"pil", "pilch", "pild", "pildr", "pilh", "pilheri",
"pilot", "pilul", "pimb", "pimp", "pimpl", "pimpolh",
"pimpon", "pin", "pin"+u"\u00E7", "pincel", "pinch", "pincharol",
"pindariz", "pindoc", "pindong", "pindr", "pinel", "ping",
"pingalh", "pingent", "pingol", "pinic", "pinimb", "pinoc",
"pinot", "pint", "pintainh", "pintal", "pintalg", "pintalh",
"pintarol", "pintipar", "pinturil", "piolh", "pior", "pip",
"piparot", "pipet", "pipi", "pipil", "pipin", "pipiric",
"pipit", "pipoc", "piquet", "pir", "piramb", "piramid",
"piramidiz", "pirang", "pirat", "pirilamp", "pirilampej", "piriric",
"piroc", "pirograf", "pirograv", "pirolis", "pirotecniz", "pirra"+u"\u00E7",
"pirroniz", "piruet", "pis", "pisc", "piscainh", "piscalh",
"pisg", "piso", "pissit", "pist", "pit", "piteir",
"pitosg", "piuc", "pivot", "pixer", "placid", "placit",
"plagi", "plain", "plan", "planch", "planej", "planetiz",
"planific", "planilh", "planimetr", "planiz", "planopolariz", "plant",
"plasm", "plasmolis", "plastic", "plasticiz", "plastific", "platin",
"platoniz", "plebiscit", "plebiz", "pleit", "plenific", "pletor",
"pletoriz", "plic", "plid", "pliss", "plot", "plug",
"plum", "plumbagin", "plumej", "pluraliz", "pluricelul", "pluriestratific",
"plurific", "plurissecul", "pluristratific", "plutarquiz", "plutocratiz", "pneumencefalograf",
"pneumoencefalograf", "poc", "pod", "podometr", "poeir", "poematiz",
"poent", "poet", "poetific", "poetiz", "pois", "poit",
"poj", "polariz", "polc", "poleg", "polemic", "polemiz",
"polici", "policit", "policopi", "policrom", "policromiz", "poligraf",
"poliment", "polimeriz", "poliniz", "polirramific", "politic", "politip",
"politiz", "politon", "poloniz", "polp", "polvariz", "polvilh",
"polvoriz", "pombeir", "pomej", "pomific", "pomiz", "pompoariz",
"pon"+u"\u00E7", "ponder", "pong", "ponh", "pontalet",
"ponticul", "pontific", "pontilh", "pontinh", "ponto", "pontu",
"pontualiz", "popi", "popoc", "popul", "populariz", "porej",
"porfi", "porfiriz", "pormenoriz", "pornograf", "pororoc", "port",
"portaj", "portuch", "portugaliz", "portugues", "porvisc", "pos",
"posfaci", "posicion", "positiv", "pospont", "poss", "possession",
"possibilit", "possibiliz", "post", "posteg", "postej", "postem",
"posterg", "posteriz", "posti"+u"\u00E7", "postil", "postul", "postur",
"potenci", "potencializ", "potoc", "poup", "pous", "pousent",
"pout", "povo", "pracat", "pracej", "pradej", "prag",
"pragalh", "pragmatiz", "praguej", "pranch", "prant", "prasm",
"pratej", "pratic", "prax", "preadapt", "preadivinh", "prealeg",
"pream", "preambul", "preanunci", "prebend", "precal"+u"\u00E7", "precant",
"precariz", "precat", "precaucion", "precautel", "preceit", "preceitu",
"precific", "precint", "precipit", "precis", "precogit", "preconceitu",
"precondicion", "preconiz", "predat", "predemarc", "predestin", "predetermin",
"predic", "predicament", "predilecion", "predit", "predomin", "preemin",
"preestipul", "prefabric", "prefaci", "preferenci", "prefigur", "prefiltr",
"prefix", "prefoli", "prefulgur", "preg", "pregalh", "pregn",
"prego", "pregost", "pregui"+u"\u00E7", "pregunt", "pregust", "preit",
"preiteg", "preitej", "prejudic", "prelaci", "prelazi", "prelecion",
"prelev", "preli", "prelib", "preludi", "prem", "premasteriz",
"prematur", "premedit", "premi", "premud", "prend", "prenh",
"prenomin", "prenot", "prens", "prenunci", "prenunic", "preocup",
"preopin", "preorden", "prepar", "preponder", "preposicion", "preposter",
"preprocess", "prequestion", "pres", "presagi", "prescrut", "presenci",
"present", "presentific", "preserv", "presidi", "presig", "presilh",
"pressagi", "presselecion", "pression", "pressuriz", "prest", "prestacion",
"prestidigit", "prestigi", "presum", "pretej", "preternaturaliz", "pretext",
"pretorianiz", "pretra"+u"\u00E7", "prevaric", "prez", "prim", "primaver",
"primaveriz", "primitiv", "primor", "principi", "prior", "prioriz",
"prisc", "prism", "prismatiz", "pristin", "priv", "privatiz",
"privilegi", "pro", "probabiliz", "problematiz", "procedimentaliz", "process",
"procession", "proclam", "proclin", "procrastin", "procri", "procur",
"procurv", "prodig", "prodigaliz", "proej", "proemi", "proemin",
"profa"+u"\u00E7", "profal"+u"\u00E7", "profan", "profaniz", "profess", "professor",
"profet", "profetiz", "profil", "profissionaliz", "proflig", "profund",
"progener", "prognostic", "program", "programatiz", "progress", "projeit",
"projet", "prolat", "proletariz", "prolifer", "prolific", "prolog",
"prolong", "proman", "promand", "promulg", "pronomi", "pronomin",
"pronominaliz", "pronostic", "prontific", "prontuari", "pronunci", "propag",
"propal", "proparoxitoniz", "propici", "propin", "propolis", "propoliz",
"proporcion", "proporcionaliz", "proposit", "propugn", "propuls", "propulsion",
"prorrog", "pros", "prosific", "prospect", "prosper", "prospet",
"prostern", "prostr", "protagoniz", "protecion", "protel", "protest",
"protestantiz", "protocol", "protocoliz", "proton", "prototific", "protuber",
"prov", "proven"+u"\u00E7"+"aliz", "proverbi", "proverbializ", "providenci", "provincializ",
"provincianiz", "provisc", "provision", "provoc", "proz", "prudenci",
"prum", "prussianiz", "pseudojustific", "pseudotrabalh", "psicanalis", "psicoanalis",
"psicograf", "psicolog", "psicologiz", "pu", "pub", "public",
"publicit", "publiciz", "pudl", "pueriliz", "pugil", "pugn",
"puit", "puj", "pul", "pulh", "pulic", "pulinh",
"puls", "pulsion", "pult", "pulul", "pulveriz", "pulvin",
"pun"+u"\u00E7", "puncej", "puncion", "pun"+u"\u00E7"+"o", "punt", "pup",
"pupil", "pupiniz", "purg", "purific", "purpur", "purpurej",
"purpuriz", "putrific", "pux", "quadr", "quadricul", "quadrilh",
"quadrilob", "quadriniz", "quadruped", "quadrupl", "quadruplic", "qualific",
"quantific", "quantiz", "quar", "quarenten", "quaresm", "quart",
"quartej", "quartilh", "quass", "quaterniz", "quebr", "quebrant",
"qued", "queij", "queim", "quein", "queix", "quel",
"quenh", "quent", "queratiniz", "querel", "queren", "querenci",
"querend", "querosen", "question", "questiuncul", "quevind", "quezil",
"quiband", "quic", "quiet", "quilat", "quilh", "quilific",
"quilometr", "quilot", "quilunz", "quimb", "quimeriz", "quimific",
"quimiossintetiz", "quin", "quinch", "quing", "quinho",
"quintav", "quintessenci", "quintuplic", "quirograf", "quit", "quitand",
"quitiniz", "quixotiz", "quizil", "quocient", "quot", "quotidianiz",
"quotiz", "raban", "rabeir", "rabej", "rabi", "rabid",
"rabiniz", "rabios", "rabisc", "rabon", "rabot", "rabuj",
"rabul", "rabulej", "rabun", "rabunh", "rabusc", "racemiz",
"rach", "racin", "raciocin", "racion", "racionaliz", "ra"+u"\u00E7"+"o",
"racont", "radi", "radiativ", "radic", "radicaliz", "radici",
"radioativ", "radiobaliz", "radiocromatograf", "radiodetect", "radiodiagnostic", "radiofoniz",
"radiograf", "radiolocaliz", "radiomarc", "radionaveg", "radiopreg", "radiossond",
"radiotelegraf", "radiotelevis", "radiotransistoriz", "radob", "radub", "raf",
"raff", "rafi", "rafin", "rai", "raiv", "raivej",
"raj", "ral", "ralent", "ralh", "ram", "ramalh",
"ramalhet", "ramang", "ramel", "ramific", "ramilhet", "ramoc",
"rampan", "ran"+u"\u00E7", "ranceon", "rancidific", "rancific", "rancorej",
"rancur", "randomiz", "ranf", "rang", "ranguinh", "ranh",
"ranhur", "ranhuz", "ranilh", "ranzinz", "rap", "rapel",
"rapi", "rapig", "rapilh", "rapin", "rapinh", "rapos",
"raposinh", "rapt", "raquitiz", "rar", "rarej", "ras",
"rasc", "rascanh", "rascunh", "rasg", "rasmolg", "rasoir",
"rasour", "rasp", "raspan"+u"\u00E7", "raspinh", "rastaquer", "rasteir",
"rastej", "rastel", "rasteriz", "rastilh", "rastinh", "rastolh",
"rastrej", "rasur", "rat", "ratazan", "ratific", "ratin",
"ratinh", "raton", "raus", "ravenh", "ravin", "ravinh",
"razi", "razo", "razon", "reabilit", "reabit", "reabitu",
"reabjur", "reaboto", "reabra"+u"\u00E7", "reabrasileir", "reabrolh", "reabrot",
"reaceit", "reach", "reacion", "reacomod", "reacompanh", "reacopl",
"reacord", "reacostum", "reacumul", "reacus", "readapt", "readjudic",
"readmir", "readot", "reafet", "reafirm", "reafix", "reafret",
"reagend", "reaglomer", "reagrav", "reagrup", "reajunt", "reajust",
"realarg", "real"+u"\u00E7", "realegr", "realej", "realent", "realiment",
"realinh", "realist", "realiz", "realoc", "realoj", "realug",
"realumi", "ream", "reambul", "reanalis", "reand", "reanex",
"reanim", "reanimaliz", "reanod", "reapaixon", "reaparelh", "reapert",
"reaplic", "reapoder", "reapont", "reaportugues", "reaposs", "reapreci",
"reapresent", "reaprision", "reapropri", "reaprov", "reaproveit", "reaprovision",
"reaproxim", "reaquist", "rearboriz", "rearm", "rearmazen", "rearquitet",
"rearranj", "rearrum", "rearticul", "reasfalt", "reassegur", "reassent",
"reassimil", "reassin", "reassoci", "reassoldad", "reassom", "reassopr",
"reat", "reatent", "reaterr", "reatest", "reati"+u"\u00E7", "reativ",
"reatoch", "reatoriz", "reatravess", "reatualiz", "reatulh", "reaument",
"reautentic", "reautoriz", "reautu", "reavali", "reavi", "reavigor",
"reavis", "reavist", "reaviv", "reavult", "reb", "rebaix",
"rebalan"+u"\u00E7", "rebals", "reban", "rebanh", "rebarb", "rebarbariz",
"rebat", "rebatinh", "rebatiz", "rebeij", "rebel", "rebelic",
"rebelion", "rebent", "reberr", "rebesbelh", "rebic", "rebimb",
"rebimbalh", "rebiopsi", "rebisc", "rebit", "rebitol", "rebo",
"rebobin", "reboc", "reboj", "rebol", "rebolc", "reboli"+u"\u00E7",
"rebomb", "rebor", "reborbulh", "rebord", "reborqui", "rebot",
"rebou"+u"\u00E7", "rebrad", "rebram", "rebrasil", "rebrilh", "rebrot",
"rebu"+u"\u00E7", "rebuf", "rebulh", "rebuli"+u"\u00E7", "rebumb", "rebusc",
"rebusn", "rec", "recabed", "recach", "recad", "recadastr",
"recadej", "recal", "recalc", "recal"+u"\u00E7", "recalcific", "recalcitr",
"recalcul", "recalendariz", "recalibr", "recam", "recambi", "recanaliz",
"recandidat", "recant", "recap", "recapacit", "recapitaliz", "recapitul",
"recapt", "recaptur", "recarbonat", "recarboniz", "recarbur", "recard",
"recarg", "recarimb", "recarreg", "recartilh", "recartorializ", "recas",
"recat", "recategoriz", "recativ", "recauchut", "recaucion", "recautel",
"recav", "recavalg", "receit", "recelulariz", "recen", "recentr",
"recepcion", "recept", "recerr", "recha"+u"\u00E7", "rechap", "rechec",
"recheg", "rechi", "rechin", "rechoch", "rechonch", "rechup",
"recib", "recicl", "recidiv", "recint", "reciproc", "recit",
"reciviliz", "reclacitr", "reclam", "reclamiz", "reclassific", "reclin",
"reclus", "recobr", "recoc", "recogit", "recoit", "recol",
"recolig", "recoloc", "recoloniz", "recolt", "recombin", "recome"+u"\u00E7",
"recomend", "recoment", "recomod", "recompact", "recompartiment", "recompartimentaliz",
"recompens", "recompil", "recomplet", "recompr", "recompromiss", "reconceitu",
"reconcentr", "reconcert", "reconcili", "recondicion", "reconect", "reconfess",
"reconfigur", "reconfirm", "reconfort", "recongra"+u"\u00E7", "reconquist", "reconsagr",
"reconsert", "reconsider", "reconsolid", "reconsorci", "reconstitucionaliz", "reconsult",
"recont", "recontat", "recontextualiz", "recontrat", "reconvoc", "recopi",
"recopil", "recor"+u"\u00E7", "record", "recoro", "recort", "recost",
"recout", "recov", "recrav", "recredenci", "recrest", "recri",
"recrimin", "recriptograf", "recristaliz", "recristianiz", "recrucific", "recrut",
"recruz", "recu", "recud", "recuid", "recuinh", "recuit",
"recultiv", "recunh", "recuper", "recur", "recurs", "recurv",
"recus", "redactilograf", "redam", "redambal", "redardej", "redatilograf",
"redatori", "redeclar", "redecor", "redecret", "rededetiz", "rededic",
"redemocratiz", "redemoinh", "redemonstr", "redeng", "redeposit", "redescont",
"redesenh", "redesgrenh", "redesign", "redespert", "redestin", "redigit",
"redimension", "redintegr", "redirecion", "redispar", "rediviniz", "redizim",
"redob", "redobr", "redoi"+u"\u00E7", "redoir", "redomoinh", "redopi",
"redou"+u"\u00E7", "redour", "redr", "redubl", "redund", "reduplic",
"reeco", "reedific", "reedit", "reeditor", "reeduc", "reelabor",
"reembaralh", "reembarc", "reembas", "reembols", "reembrulh", "reemend",
"reemigr", "reempacot", "reempalh", "reempolg", "reemporc", "reemposs",
"reempreg", "reencadern", "reencafu", "reencaix", "reencaminh", "reencan",
"reencap", "reencarcer", "reencarn", "reencen", "reencet", "reencontr",
"reencuc", "reendere"+u"\u00E7", "reendireit", "reendoss", "reenergiz", "reenfi",
"reenfolh", "reengaj", "reengendr", "reengolip", "reenla"+u"\u00E7", "reenovel",
"reenquadr", "reensai", "reensin", "reentel", "reenterr", "reentr",
"reentroniz", "reenvas", "reenverniz", "reenvi", "reenvid", "reenxert",
"reequilibr", "reequip", "reescal", "reescalon", "reescrach", "reescrachet",
"reescrachin", "reescrafunch", "reescramalh", "reescramel", "reescrament", "reescramouc",
"reescramu"+u"\u00E7", "reescraviz", "reescrevinh", "reescritur", "reespecific", "reesper",
"reespos", "reespum", "reestamp", "reestiliz", "reestimul", "reestipul",
"reestrutur", "reestud", "reetiquet", "reexager", "reexamin", "reexecut",
"reexit", "reexpatri", "reexpi", "reexplic", "reexplor", "reexport",
"reextradit", "refal", "refals", "refart", "refastel", "refator",
"refatur", "refech", "refecund", "refeg", "refent", "referenci",
"referend", "referment", "referr", "refert", "refestel", "refez",
"refi", "refigur", "refil", "refilh", "refili", "refilm",
"refiltr", "refin", "refinanci", "refinc", "refint", "refirm",
"refit", "refl", "reflacion", "reflexion", "reflorest", "reflutu",
"reflux", "refoc", "refocaliz", "refocil", "refog", "refoleg",
"refolg", "refolh", "refoment", "refonologiz", "refor"+u"\u00E7", "reforj",
"reform", "reformat", "reformul", "refortific", "refotograf", "refract",
"refractur", "refranj", "refrat", "refratur", "refreg", "refrequent",
"refresc", "refret", "refric", "refriger", "refris", "refrit",
"refrond", "refrulh", "refug", "refugi", "refulgur", "refum",
"refund", "refunf", "refunfumeg", "refung", "refunh", "refus",
"refust", "refut", "reg", "rega"+u"\u00E7", "regal", "regalardo",
"regalvaniz", "regambi", "reganh", "regaseific", "regat", "regatinh",
"regel", "regener", "regent", "reger", "regermin", "regiment",
"regin", "regionaliz", "regir", "regist", "registr", "rego",
"regojiz", "regolf", "regom", "regoug", "regozij", "regr",
"regraci", "regrav", "regrax", "regress", "reguard", "regueif",
"regueir", "reguinch", "reguing", "regulament", "regulariz", "regurgit",
"reidrat", "reific", "reimagin", "reimplant", "reimplement", "reimport",
"reimput", "rein", "reinaugur", "reincarn", "reincit", "reincorpor",
"reincrust", "reindex", "reindustrializ", "reinerv", "reinfecion", "reinfect",
"reinfet", "reinflam", "reingress", "reinici", "reinicializ", "reinjet",
"reinocul", "reinstal", "reinstaur", "reintegr", "reintern", "reinternacionaliz",
"reinternaliz", "reinterpret", "reinterrog", "reinum", "reinvent", "reinvid",
"reinvoc", "reioniz", "reislamiz", "reiter", "reitoriz", "reiun",
"reivindic", "reix", "rejeit", "rejubil", "rejunc", "rejunt",
"rejur", "rejustific", "rel", "relacion", "relacr", "relamp",
"relampad", "relampadej", "relampaguej", "relampej", "relampr", "relan"+u"\u00E7",
"relancet", "relarg", "relat", "relativ", "relativiz", "relav",
"relax", "releg", "relegitim", "releix", "relembr", "relent",
"relep", "relev", "relevant", "relh", "relicit", "relig",
"relim", "relinch", "reling", "reloc", "relocaliz", "reloj",
"relouc", "relum", "relumbr", "relustr", "relut", "relv",
"relvej", "rem", "remadaleniz", "remagnetiz", "remalh", "remalinh",
"remanch", "remand", "remanej", "remang", "remanipul", "remanisc",
"remans", "remanufatur", "remarc", "remarid", "remartel", "remasc",
"remasteriz", "remastig", "remat", "rematerializ", "rematricul", "rembrandtiz",
"rembraniz", "remed", "remel", "remelg", "remembr", "rememor",
"rememori", "remend", "remenic", "remergulh", "remess", "remestr",
"remigi", "remigr", "remilitariz", "remim", "remin", "remineraliz",
"reminiscenci", "remir", "remistur", "remix", "remobil", "remobiliz",
"remoc", "remo"+u"\u00E7", "remodel", "remodul", "remoel", "remoidanh",
"remoinh", "remolc", "remolg", "remolh", "remonarquiz", "remond",
"remonotoniz", "remont", "remor", "remorc", "remordic", "remordisc",
"remost", "remostr", "remouc", "remud", "remug", "remunc",
"remuner", "remunhet", "remurmur", "remurmurej", "remusg", "renacionaliz",
"renatur", "renaturaliz", "renaveg", "rend", "renderiz", "rendibiliz",
"rendilh", "renegoci", "renegrej", "renembr", "renet", "renifl",
"renivel", "renormaliz", "renov", "rent", "rentabiliz", "rentilh",
"renumer", "renunci", "renzilh", "reobrig", "reobserv", "reocup",
"reoficializ", "reolis", "reoper", "reopin", "reorden", "reorganiz",
"reorient", "reorquestr", "reoxid", "reoxigen", "reoxigeniz", "repactu",
"repag", "repaganiz", "repagin", "repair", "repanh", "repapoil",
"repapoul", "repar", "reparafus", "reparametriz", "reparcel", "reparticion",
"repartilh", "repass", "repassarit", "repast", "repatan", "repatri",
"repatrocin", "repaviment", "repe"+u"\u00E7", "repech", "reped", "repeg",
"repeit", "repel", "repenetr", "repenic", "repens", "reperfil",
"repergunt", "repertori", "repes", "repesc", "repeten", "repic",
"repilg", "repimp", "repimpin", "repimpon", "repinch", "repinhaliz",
"repinic", "repint", "repiquet", "repis", "repisc", "repivatiz",
"replain", "replanej", "replanilh", "replant", "replen", "replet",
"replic", "repois", "repolariz", "repoleg", "repolg", "repolh",
"repoliniz", "reponder", "repont", "repontu", "repopul", "repopulariz",
"report", "reposicion", "repost", "repotron", "repous", "repovo",
"repreg", "repres", "represent", "reprimend", "reprincipi", "repris",
"repristin", "repristiniz", "reprivatiz", "reprocess", "reproch", "reprofund",
"reprogram", "reprojet", "reprov", "rept", "republic", "republicaniz",
"repudi", "repugn", "repul", "repuls", "repulul", "repurg",
"repurific", "reput", "repux", "requadr", "requadruped", "requalific",
"requebr", "requeim", "requent", "request", "requestion", "requint",
"requisit", "rerradi", "rerratific", "rerrespir", "resbun", "rescald",
"rescum", "resenh", "reserv", "resfolg", "resfri", "resg",
"resgalg", "resgat", "resguard", "residenci", "resign", "resin",
"resinific", "reslumbr", "resm", "resmalh", "resmeleng", "resmolg",
"resmoninh", "resmun", "resmung", "resmunh", "resmuninh", "resmusg",
"respald", "respan"+u"\u00E7", "respeit", "respig", "resping", "respinh",
"respir", "respons", "responsabiliz", "respont", "respost", "respumej",
"resqui", "ressabi", "ressac", "ressaci", "ressaib", "ressaibi",
"ressalt", "ressaltit", "ressalv", "ressanfonin", "ressangr", "ressec",
"ressegund", "ressegur", "ressel", "resseren", "resserr", "ressic",
"ressimboliz", "ressincroniz", "ressintetiz", "resso", "ressobr", "ressocializ",
"ressold", "ressolh", "ressolt", "resson", "ressonh", "ressopr",
"ressu", "ressubtiliz", "ressud", "ressulc", "ressum", "ressumbr",
"ressupin", "ressuscit", "rest", "restamp", "restart", "restaur",
"restauric", "restel", "restil", "restir", "restit", "restiv",
"restolh", "restral", "restrel", "restrib", "restrical", "restridul",
"restrug", "restrutur", "restuc", "result", "resval", "ret",
"retabul", "retac", "retalh", "retali", "retanch", "retard",
"reteim", "retelefon", "retelegraf", "retelh", "retemper", "retent",
"reterritorializ", "retes", "retesi", "retest", "reticenci", "retific",
"retilint", "retiliz", "retintin", "retipific", "retir", "retisn",
"retoc", "retoi"+u"\u00E7", "retom", "retonh", "retoric", "retorn",
"retos", "retost", "retouc", "retou"+u"\u00E7", "retov", "retrabalh",
"retra"+u"\u00E7", "retram", "retranc", "retran"+u"\u00E7", "retranslad", "retransplant",
"retransport", "retras", "retraslad", "retrat", "retrav", "retrein",
"retrilh", "retrin", "retrinc", "retrinch", "retro", "retroaliment",
"retroativ", "retrocarreg", "retrocit", "retrocruz", "retrodat", "retrograd",
"retroilumin", "retropedal", "retrovacin", "retrovej", "retruc", "retub",
"retumb", "reumaniz", "reumatiz", "reunific", "reurbaniz", "reus",
"reutiliz", "revacin", "revalid", "revaloriz", "revasculariz", "reveget",
"revel", "revener", "reverber", "reverdej", "reverenci", "reverg",
"reverific", "revermelh", "revers", "reves", "revess", "revez",
"revibr", "revi"+u"\u00E7", "revid", "revigor", "revigorent", "revigoriz",
"revindic", "reving", "revir", "revirginiz", "revis", "revisit",
"revist", "revitaliz", "revivenci", "revivific", "revo", "revoc",
"revoej", "revolc", "revolit", "revolt", "revolucion", "revor",
"revuls", "rez", "rezing", "rezip", "rib", "ribald",
"ribeir", "ribomb", "ri"+u"\u00E7", "ricerc", "ricochet", "ridic",
"ridiculariz", "ridiculiz", "rif", "rifl", "rig", "rij",
"ril", "rilh", "rim", "rimbomb", "rin"+u"\u00E7", "rinch",
"rinchal", "rinchavelh", "rincon", "rinf", "rinh", "rip",
"ripan"+u"\u00E7", "ripost", "risc", "riscanh", "ritm", "ritmiz",
"ritornel", "ritualiz", "rivaliz", "rix", "riz", "robech",
"robor", "roboriz", "robotiz", "roc", "ro"+u"\u00E7", "ro"+u"\u00E7"+"ag",
"rocalh", "roceg", "roci", "rocin", "rocl", "rod",
"rodej", "rodilh", "rodizi", "rodomoinh", "rodopi", "rodrig",
"rog", "roj", "rol", "rold", "rolet", "rolh",
"roli"+u"\u00E7", "rom", "romanesc", "romaniz", "romantiz", "romesent",
"ronc", "ronch", "rond", "ronfl", "ronquej", "ronron",
"ror", "rorej", "ros", "rosc", "roset", "rosmaninh",
"rosn", "rosnor", "rostilh", "rot", "rotacion", "rotativ",
"roteiriz", "rotej", "rotiniz", "rotograv", "rotul", "roub",
"rou"+u"\u00E7", "roufenh", "roup", "rouquej", "rouss", "rouxinol",
"rouxinoliz", "ru", "rubej", "rubific", "ruborej", "ruboriz",
"rubric", "rubriz", "ru"+u"\u00E7", "rudimentariz", "ruf", "rufi",
"rufl", "rug", "rugin", "rugit", "ruid", "rul",
"rulh", "rum", "rumb", "rumi", "rumin", "rumor",
"rumorej", "runf", "runh", "rup", "ruraliz", "rurbaniz",
"rusg", "russ", "russianiz", "russific", "russiz", "rustic",
"rustific", "rut", "rutil", "sabadej", "sabatin", "sabatiz",
"saberec", "sabererec", "sabich", "sabot", "sabrec", "sabuc",
"sabug", "sabuj", "sabul", "saburr", "sac", "sa"+u"\u00E7"+"aric",
"sacarific", "sacarrolh", "sach", "sachol", "saci", "sacol",
"sacolej", "sacraliz", "sacrament", "sacrific", "sacul", "saf",
"safan", "safiriz", "safrej", "sagin", "sagit", "sagorr",
"sagot", "sagr", "saibr", "salamord", "salari", "sald",
"salg", "salh", "salicil", "salient", "salific", "salin",
"saliniz", "salitr", "salitriz", "saliv", "salmej", "salmiz",
"salmodej", "salmodi", "salmoeir", "salmoir", "salmour", "salpic",
"salpiment", "salpint", "salpoeir", "salpres", "sals", "salt",
"saltarel", "saltaric", "saltarilh", "saltarinh", "saltinh", "saltit",
"salubrific", "salubriz", "salu"+u"\u00E7", "salud", "salv", "salvaguard",
"samang", "samb", "sambarc", "sambenit", "sambl", "samboc",
"sambr", "samp", "san", "sanatoriz", "sancion", "sand",
"sandej", "sanef", "sanfon", "sanfonin", "sanforiz", "sangr",
"sangrentej", "sanguej", "sanguel", "sanguent", "sanguessug", "sanguific",
"sanguinh", "sanic", "sanific", "sanitariz", "sanitiz", "sanj",
"sanquit", "sanscritiz", "santific", "santig", "sap", "sapat",
"sapec", "sapej", "saperec", "sapoil", "saponific", "sapori",
"sapoul", "saprem", "saquel", "sar", "sarafusc", "saraiv",
"sarandilh", "sarangonh", "sarapant", "sarapic", "sarapint", "saraqueim",
"saraquit", "sard", "sardanapaliz", "sardoniz", "sarilh", "sarj",
"sarn", "sarp", "sarr", "sarrabisc", "sarraf", "sarrafa"+u"\u00E7",
"sarrazin", "sart", "sass", "satani", "sataniz", "satelitiz",
"sateliz", "satiriz", "satisd", "satur", "saussuritiz", "saxific",
"sazo", "sazon", "schilleriz", "sebenisc", "sec", "seccion",
"secession", "seci", "secion", "seculariz",
"secund", "secundariz", "securitiz", "sed", "sedentariz", "sedi",
"sediment", "seg", "segment", "segreg",
"segur", "seit", "seiv", "sel", "selecion", "selet",
"selvatic", "semantiz", "semb", "sembr", "semelh", "sement",
"semiadapt", "semiafirm", "semiajust", "semianimaliz", "semiaplic", "semiaprimor",
"semiaprov", "semibenefici", "semicadastr", "semicapacit", "semicarboniz", "semicaricatur",
"semicerr", "semicol", "semiconect", "semidespert", "semidevor", "semidiscretiz",
"semidiviniz", "semidobr", "semidomestic", "semienergiz", "semiequip", "semifech",
"semiformat", "semilevant", "semimanufatur", "seminorm", "semiofert", "semiograf",
"semipatrocin", "semipint", "semipoliniz", "semitiz", "semito", "semiton",
"semivo", "semostr", "seng", "senhoriz", "seniliz", "sensaboriz",
"sensibiliz", "sensific", "sensualiz", "sent", "sentenci", "sentimentaliz",
"sentinel", "separ", "sept", "septuplic", "sepulcr", "sepult",
"sequel", "sequenci", "sequestr", "sequi", "serafiz", "seramang",
"serand", "seranz", "seren", "sereniz", "seri", "serigait",
"serigraf", "sering", "seringonh", "seriograf", "sermo", "sermon",
"sero", "serpej", "serpent", "serpentiniz", "serr", "serralh",
"serramanc", "serrazin", "serrilh", "serrin", "serrot", "sertanej",
"sertaniz", "serviliz", "sesm", "sess", "session", "sestr",
"set", "seteir", "setin", "setoriz", "setuplic", "sev",
"sevandij", "severiz", "sevici", "sex", "sextav", "sextuplic",
"sexu", "sexualiz", "sezo", "si", "sibarit", "sibil",
"sibilantiz", "sibit", "sider", "sideriz", "sifiliz", "sifl",
"sifon", "sigil", "sigl", "sigliz", "siglonimiz", "sign",
"signific", "silab", "silabific", "silenci", "silhuet", "silicat",
"silicatiz", "silicific", "silicon", "silogism", "silogistic", "silogiz",
"silv", "simbol", "simboliz", "simetriz", "simorfil", "simpatiz",
"simplific", "simul", "sin", "sinal", "sinalej", "sinaliz",
"sinapiz", "sincel", "sinceriz", "sincop", "sincopiz", "sincretiz",
"sincroniz", "sindic", "sindicaliz", "sindicat", "sinet", "sinfoniz",
"singr", "singulariz", "singult", "sinistr", "sinistriz", "siniz",
"sinonimiz", "sinoptiz", "sintec", "sinteriz", "sintetiz", "sintomatiz",
"sintoniz", "sinu", "sinuc", "sinuos", "siren", "sirg",
"sirigait", "siriric", "sis", "sism", "sistem", "sistematiz",
"sistol", "siti", "situ", "snif", "so", "soalh",
"soass", "sobal"+u"\u00E7", "sobej", "soberaniz", "soberb", "sobescav",
"sobest", "sobi", "sobneg", "soborralh", "sobr", "sobra"+u"\u00E7",
"sobrad", "sobran"+u"\u00E7", "sobras", "sobreabund", "sobreagit", "sobrealcooliz",
"sobrealcunh", "sobrealiment", "sobreavali", "sobreavis", "sobreazed", "sobrecab",
"sobrecapitaliz", "sobrecasac", "sobrecifr", "sobrecompens", "sobrecostur", "sobredoir",
"sobredour", "sobrefatur", "sobreger", "sobregiz", "sobreirrit", "sobreleit",
"sobrelev", "sobrelot", "sobrelustr", "sobremaravilh", "sobremont", "sobrenad",
"sobrenaturaliz", "sobreolh", "sobrepair", "sobrepartilh", "sobrepass", "sobrepens",
"sobrepes", "sobrepovo", "sobrepuj", "sobrerrest", "sobrerrold", "sobrerrond",
"sobrescrit", "sobresper", "sobressalt", "sobressar", "sobressatur", "sobressel",
"sobressol", "sobrestim", "sobretax", "sobretro", "sobreus", "sobrevaloriz",
"sobrevigi", "sobrevo", "soc", "socalc", "socav", "sochi",
"sociabiliz", "socializ", "socioculturaliz", "so"+u"\u00E7"+"obr", "so"+u"\u00E7"+"oc", "socorn",
"socratiz", "socrest", "sod", "sodomiz", "sofism", "sofistic",
"sofor", "sofrald", "sofreg", "sofren", "sog", "sogr",
"sojig", "sojorn", "sojug", "sol", "sola"+u"\u00E7", "solanc",
"solap", "solariz", "solavanc", "solaz", "sold", "solec",
"soleciz", "soleniz", "soletr", "solev", "solevant", "solf",
"solfej", "solh", "solicit", "solid", "solidariz", "solidific",
"soliloqui", "solinh", "solmiz", "solt", "solubiliz", "solu"+u"\u00E7",
"solucion", "som", "somatiz", "sombr", "sombrej", "somergulh",
"somitic", "somp", "son", "sonambul", "sond", "soneg",
"sonet", "sonh", "sonoriz", "sopap", "sopeg", "sopes",
"sopi", "sopit", "sopont", "soporiz", "sopr", "sopraniz",
"sopres", "soprez", "sopux", "soqueix", "sor", "sorbic",
"sorn", "soroneutraliz", "sororoc", "sorovacin", "sorrab", "sorrasc",
"sorren", "sorv", "soslai", "sospit", "sosseg", "sossobr",
"sosteniz", "sostrej", "sot", "sotalh", "sotavent", "soterr",
"sotranc", "soturn", "soturniz", "soupic", "sout", "sov",
"sovel", "sovietiz", "sovin", "sprint", "su", "suaviz",
"subadapt", "subafirm", "subaglomer", "subajust", "subaliment", "subaltern",
"subalterniz", "subaplic", "subaprimor", "subaprov", "subaproveit", "subarrend",
"subassin", "subast", "subavali", "subcandidat", "subcapacit", "subcaricatur",
"subclassific", "subconcession", "subconscientiz", "subcontrat", "subdelir", "subderiv",
"subdimension", "subelisc", "subemend", "subempraz", "subempreit", "subenfiteutic",
"subenxert", "subequip", "suberific", "suberiniz", "suberiz", "subespecific",
"subestim", "subexamin", "subfatur", "subfinanci", "subformat", "subfret",
"subgrup", "subinstal", "subintitul", "subjectiv", "subjeit", "subjetiv",
"subjetiviz", "subjug", "sublamel", "sublev", "sublevant", "sublicenci",
"sublim", "sublimiz", "sublinh", "subloc", "subminiaturiz", "subministr",
"subnivel", "subofert", "suborbit", "subordin", "suborn", "subparcel",
"subpatrocin", "subplanilh", "subpuj", "subscrit", "subsecretari", "subsequenci",
"subsidi", "subsol", "substanci", "substancializ", "substantific", "substantiv",
"subsult", "subterr", "subtiliz", "subtitul", "subtotaliz", "subtrat",
"suburbaniz", "subutiliz", "subvaloriz", "subvencion", "subverbet", "suc",
"sucat", "suci", "sud", "sudoest", "sudorific", "suest",
"sufix", "sufl", "sufoc", "sufrag", "sufumig", "sug",
"sugestion", "sugil", "suicid", "suj", "sujeit", "sujic",
"sujig", "sujug", "sul", "sulanc", "sulavent", "sulc",
"sulfat", "sulfatiz", "sulfet", "sulficarbonat", "sulfit", "sulfon",
"sulfur", "sulfuret", "sulfuriz", "sumagr", "sumari", "sumariz",
"sumbr", "sumptualiz", "sumul", "sung", "sunguil", "suntualiz",
"supedit", "supenhor", "super", "superabund", "superadapt", "superafirm",
"superaglomer", "superajunt", "superajust", "superaliment", "superaplic", "superaprimor",
"superaprov", "superativ", "superauxili", "superavali", "superbenefici", "supercalandr",
"supercalcin", "supercandidat", "supercapacit", "supercapitaliz", "supercaricatur", "superciviliz",
"supercompact", "supercompens", "supercomplex", "superconcentr", "superconfort", "superdiagnostic",
"superdimension", "superendivid", "superenergiz", "superequip", "superescal", "superestim",
"superestrutur", "superexager", "superexalt", "superexamin", "superexcit", "superexplor",
"superfatur", "superfet", "superformat", "superimpregn", "superindustri", "superindustrializ",
"superinterpret", "superioriz", "superlativ", "superlot", "superocup", "superofert",
"superorden", "superorganiz", "superotimiz", "superoxid", "superoxigen", "superpatrocin",
"superplanilh", "superpopul", "superpovo", "supersatur", "superselecion", "superst",
"supertrein", "supervaloriz", "supervis", "supervision", "suplant", "suplement",
"suplic", "suplici", "supont", "suport", "supracit", "supraexcit",
"supralimin", "supralist", "supur", "suput", "surc", "surdin",
"surf", "surmont", "surpass", "surpres", "surr", "surrealiz",
"surri", "surrib", "surripi", "surripilh", "surrupi", "surt",
"suruc", "sururuc", "susceptibiliz", "suscetibiliz", "suscit", "suspeit",
"suspir", "sussurr", "sussurrej", "sust", "susteniz", "sustent",
"sut", "sutiliz", "sutur", "sux", "tabardilh", "tabel",
"tabeli", "tabelion", "tabeliz", "tabic", "tabiz", "tabuc",
"tabul", "tabulet", "taburn", "tac", "tach", "tachon",
"tactiliz", "taful", "tafulh", "tagant", "tagarel", "tain",
"taip", "tairoc", "tal", "taler", "talh", "talim",
"taling", "talion", "talon", "talud", "tamanc", "tamborej",
"tamboril", "tamborin", "tamis", "tamp", "tampon", "tamusc",
"tan", "tanaz", "tanc", "tancam", "tanch", "tang",
"tangenci", "tanific", "tanin", "taniniz", "tano", "tantaliz",
"tap", "tape"+u"\u00E7", "tapet", "tapetiz", "tapi"+u"\u00E7", "tapiz",
"tapulh", "taquigraf", "tar", "taralh", "taramel", "tarantul",
"tard", "tardinh", "taref", "tarel", "tarif", "tarific",
"tarimb", "tarj", "taroc", "tarol", "tarouc", "tarraf",
"tarrax", "tarrinc", "tarrut", "tartamel", "tartariz", "tartufic",
"tartufiz", "tarug", "tasc", "tascanh", "tasco", "tasg",
"tasquin", "tasquinh", "tassalh", "tastavel", "tastavelh", "tatal",
"tataranh", "tatiliz", "tatu", "tauroboliz", "tauxi", "tax",
"taxi", "taxidemiz", "taxidermiz", "tayloriz", "teatin", "teatraliz",
"tec", "tecl", "tecniciz", "tecnocratiz", "tecnologiz", "teim",
"teimosi", "tel", "telecomand", "telecomunic", "telecurs", "teledetect",
"telefon", "telefoniz", "telefotograf", "telegraf", "telegui", "teleport",
"telerradiograf", "telerregul", "telescop", "telessinaliz", "telessond", "telessupervision",
"teletrabalh", "teletransport", "televis", "television", "telex", "telh",
"telint", "telomeriz", "teluriz", "tematiz", "tembl", "temon",
"temoriz", "temper", "tempestu", "templ", "temporaliz", "temporej",
"temporiz", "tenalh", "tenaz", "tencion", "ten"+u"\u00E7"+"o", "tendenci",
"tenebriz", "tenoriz", "tenrific", "tension", "tent", "tenten",
"teocratiz", "teofiliz", "teologiz", "teoriz", "tequet", "ter"+u"\u00E7",
"terceiriz", "tercet", "terci", "terebintin", "terebr",
"tergivers", "terjur", "terlad", "terlint", "termin", "termistoriz",
"termonucleariz", "termorregul", "tern", "terr", "terraform", "terramot",
"terraplan", "terraplen", "terrej", "terrific", "terrinc", "territorializ",
"terror", "terroriz", "tes", "tesauriz", "tesmin", "tesoir",
"tesour", "tessel", "test", "testament", "testavilh", "testemunh",
"testic", "testific", "testilh", "testug", "tet", "tetaniz",
"tetoniz", "textiliz", "textualiz", "textur", "texturiz", "tib",
"tibir", "tibung", "tic", "tiet", "tijol", "til",
"tild", "tilint", "timbalej", "timbr", "timbu", "timon",
"timpaniz", "tindaliz", "tindalliz", "ting", "tinguij", "tint",
"tintalh", "tintil", "tintin", "tintinabul", "tintl", "tipic",
"tipific", "tipiz", "tipograf", "tir", "tiramol", "tiraniz",
"tirilint", "tiriric", "tirit", "tirlint", "tirocin", "tisic",
"tisn", "titic", "titil", "titiric", "titub", "titul",
"titulariz", "tlint", "to", "toc", "tocai", "toes",
"tog", "toi"+u"\u00E7", "toir", "toirej", "told", "tolej",
"toler", "tolin", "tom", "tomb", "tombol", "tomograf",
"ton", "tonaliz", "tonific", "tonitro", "tonitru", "toniz",
"tons", "tonsur", "tontej", "top", "topej", "topet",
"topi", "topicaliz", "topograf", "tor", "torceg", "torcicol",
"torcion", "torcul", "torment", "torn", "tornej", "toron",
"torped", "torpilh", "torporiz", "torr", "torrej", "torric",
"torrific", "torrisc", "tortuej", "tortur", "torv", "torvelinh",
"tos", "tosc", "toscanej", "tosquenej", "tosqui", "tosseg",
"tossic", "tossig", "tost", "tosteg", "totaliz", "totemiz",
"touc", "tou"+u"\u00E7", "tour", "tourej", "toxic", "trabalh",
"trabalhisc", "trabalhuc", "trabelh", "trabuc", "trabul", "tra"+u"\u00E7",
"tracej", "tracion", "tracolej", "trad", "tradicionaliz", "trafeg",
"trafic", "trafulh", "trag", "tragedi", "tragin", "traicion",
"train", "traj", "tralad", "tralh", "tram", "tramalh",
"trambalh", "trambec", "trambic", "trambolh", "tramel", "tramit",
"tramont", "trampej", "trampolin", "tran", "tranc", "tran"+u"\u00E7",
"trancafi", "trancafil", "tranch", "tranqueir", "tranquelej", "tranquibern",
"tranquiberni", "tranquiliz", "tranquin", "trans", "transacion", "transbord",
"transbordej", "transcendentaliz", "transco", "transcodific", "transcol", "transcomplement",
"transcultur", "transcur", "transcurs", "transdisciplin", "transeccion", "transecion",
"transexualiz", "transfect", "transfeg", "transfigur", "transfiltr", "transfinaliz",
"transfix", "transfon", "transfor", "transform", "transfret", "transfur",
"transfus", "transignific", "transistoriz", "transit", "transitiv", "translad",
"transliter", "transloc", "translouc", "translucid", "translumbr", "transmalh",
"transmetil", "transmigr", "transmont", "transmud", "transmut", "transnacionaliz",
"transnad", "transnoit", "transnomin", "transnout", "transparent", "transpass",
"transpir", "transplant", "transport", "transtorn", "transtroc", "transubstanci",
"transud", "transum", "transuman", "transvas", "transvaz", "transverber",
"transvi", "transvo", "transvor", "trapa"+u"\u00E7", "trapach", "trapass",
"trapej", "traquej", "traquin", "traquitan", "trasand", "trasbord",
"trascal", "trascur", "trasfeg", "trasfoli", "traslad", "trasmalh",
"trasmont", "trasmud", "trasnoit", "trasnout", "traspass", "trasplant",
"trasport", "trass", "trastej", "trastemp", "trastorn", "trastroc",
"trasvas", "trasvaz", "trasvi", "trat", "trator", "traulit",
"traumatiz", "traut", "trav", "travej", "traves", "travess",
"travessur", "trebelh", "trebo", "trefeg", "trefil", "trefin",
"trein", "treit", "trejeit", "trejug", "trejur", "trelad",
"treli"+u"\u00E7", "trem", "tremebrilh", "tremel", "tremelej", "tremelhic",
"tremelic", "tremo"+u"\u00E7", "tremud", "tremul", "tremulej", "tremulin",
"tren", "trep", "trepan", "trepic", "trepid", "treplic",
"tresand", "tresbord", "trescal", "tresdobr", "tresfeg", "tresfi",
"tresfigur", "tresfil", "tresfoleg", "tresfolg", "tresfoli", "tresgast",
"tresjur", "treslad", "treslouc", "tresmalh", "tresmont", "tresmud",
"tresnoit", "tresnout", "trespass", "tressalt", "tressu", "trestamp",
"trestorn", "tresvari", "tresvi", "trevisc", "tri", "triangul",
"triangulariz", "tribaliz", "tribof", "tribul", "tribut", "tricalh",
"tricot", "trifurc", "trig", "trijunt", "tril", "trilater",
"trilh", "trimbol", "trin", "trinc", "trincafi", "trincafil",
"trinch", "trincheir", "trincolej", "trinf", "trint", "trinul",
"trip", "triplic", "tripsiniz", "tripudi", "tripul", "tris",
"trisc", "triss", "trissec", "trissect", "trissulc", "tristific",
"trit", "tritin", "tritrin", "tritur", "triunf", "trivializ",
"tro", "troc", "tro"+u"\u00E7", "trocadilh", "trocafi", "troch",
"trocisc", "tromb", "trombej", "trombet", "trombic", "trombocintilograf",
"trombos", "tromp", "trompej", "trompic", "trompilh", "tron",
"tronc", "tronch", "tronej", "trop", "trope"+u"\u00E7", "tropeg",
"tropej", "tropeli", "tropic", "tropicaliz", "troquel", "troquilh",
"trosqui", "trot", "trotej", "trotin", "trou"+u"\u00E7", "trov",
"trovej", "trovisc", "trovo", "truc", "trucid", "trucil",
"truf", "trumbic", "trunc", "trunf", "trup", "trupit",
"trusqui", "trustific", "trutin", "tub", "tuberculiniz", "tuberculiz",
"tuberific", "tuberiz", "tubuliz", "tucan", "tuf", "tumb",
"tumefic", "tumidific", "tumific", "tumul", "tumuliz", "tumultu",
"tun", "tund", "tung", "tunisific", "tur", "turb",
"turbilho", "turbilhon", "turbin", "turbolej", "turbulej", "turciz",
"turibul", "turibuliz", "turifer", "turific", "turm", "turquiz",
"turr", "turturej", "turturin", "turturinh", "turtuvi", "turv",
"turvej", "tut", "tutej", "tutel", "tuti", "tutor",
"tutuc", "tutuvi", "uber", "ufan", "ug", "ugalh",
"uiv", "ulcer", "ultim", "ultraciviliz", "ultracolaps", "ultradimension",
"ultraequip", "ultraestrutur", "ultrafiltr", "ultraj", "ultram", "ultramontaniz",
"ultraofert", "ultraotimiz", "ultrapass", "ultrapasteuriz", "ultraprov", "ultrapurific",
"ultrarromantiz", "ultrassonograf", "ulul", "umect", "umidific", "un",
"unanim", "unanimific", "unanimiz", "und", "undul", "unguent",
"unh", "unific", "uniform", "uniformiz", "unilocul", "unitiz",
"universaliz", "univoc", "unt", "untit", "up", "uralitiz",
"uraliz", "uran", "uraniz", "urbaniz", "urin", "urr",
"urtic", "urtig", "urubuz", "us", "usin", "usit",
"usm", "ustul", "usufructu", "usufrutu", "usur", "usurp",
"ut", "utensili", "utiliz", "utopiz", "vac", "vacil",
"vacin", "vacuoliz", "vadi", "vag", "vagabund", "vagamund",
"vaguej", "vai", "val", "vali", "valid", "valor",
"valoriz", "vals", "valsej", "vampir", "vampiriz", "vand",
"vandaliz", "vanglori", "vanguej", "vantaj", "vapor", "vaporiz",
"vapul", "vaquean", "vaqueir", "vaquej", "var", "vardasc",
"varej", "vari", "varicel", "varieg", "varioliz", "varrenh",
"varrisc", "varrusc", "vasc", "vascolej", "vasculariz", "vasculh",
"vasculiz", "vaselin", "vasoativ", "vasodilat", "vasquej", "vassal",
"vassoir", "vassour", "vast", "vaticin", "vavuc", "vaz",
"vazi", "vecej", "ved", "veementiz", "veget", "vegetaliz",
"vei", "veicul", "vel", "velariz", "velej", "velhac",
"velic", "velud", "velut", "venaliz", "vencelh", "vend",
"venefic", "venefici", "venen", "vener", "veniag", "venializ",
"vent", "ventanej", "ventil", "ventoinh", "ventur", "verbaliz",
"verbej", "verber", "verbet", "verdasc", "verdeg", "verdej",
"verduniz", "verg", "vergalh", "vergast", "vergonh", "verific",
"vermelhej", "vermicul", "vermifug", "vermin", "vermit",
"vern", "vernaculiz", "vernaliz", "veroduniz", "verrin", "verrug",
"verrum", "vers", "versej", "versific", "version", "vertebraliz",
"verticaliz", "vertigin", "vertiginiz", "vesic", "vess", "vest",
"vestirenxurr", "vet", "vetoriz", "vex", "vez", "viabiliz",
"viaj", "viand", "viatic", "vibr", "vibratiliz", "vi"+u"\u00E7",
"vicej", "vici", "vid", "vidr", "vig", "vigariz",
"vigi", "vigil", "vigor", "vigoriz", "vilegiatur", "vili",
"vilic", "vilific", "vilipendi", "vim", "vinagr", "vinc",
"vincilh", "vincul", "vindic", "vindim", "ving", "vinh",
"vinific", "vintiplic", "viol", "violent", "vir", "viravir",
"viravolt", "virginaliz", "virginiz", "virgul", "viriliz", "virtu",
"virtualiz", "vis", "visc", "viscondiz", "visg", "visibiliz",
"vision", "visit", "vislumbr", "visp", "visper", "vispor",
"vist", "vistori", "vistoriz", "visualiz", "vitalici", "vitaliz",
"vitamin", "vitaminiz", "vitim", "vitimiz", "vitori", "vitraliz",
"vitrific", "vitriol", "vitrioliz", "vitualh", "vituper", "viv",
"vivalh", "vivenci", "vivent", "vivific", "vivissect", "vizinh",
"vo", "vocabulariz", "vocabuliz", "vocacion", "vocaliz", "vocifer",
"voej", "vog", "volatiliz", "volatiz", "volc", "volit",
"volt", "voltej", "voltij", "voltiz", "volubiliz", "volum",
"voluntari", "volut", "volutu", "vomit", "vortilhon", "vot",
"vozeir", "vulcaniz", "vulgariz", "vulnerabiliz", "vult",
"vun", "vung", "vunz", "vurm", "vuvuc", "xabouc",
"xacat", "xadrez", "xant", "xaquet", "xarop", "xavec",
"xaxat", "xen", "xerardiz", "xeret", "xeroc", "xerocopi",
"xerograf", "xerox", "xetr", "xilograf", "xilograv", "ximbic",
"xin", "xing", "xinguil", "xoc", "xon", "xot",
"xumberg", "xumbreg", "zabumb", "zagai", "zagalot", "zagunch",
"zalum", "zamp", "zamparin", "zang", "zangarilh", "zangul",
"zangurr", "zanz", "zanzarilh", "zaragat", "zaragato", "zaranz",
"zarelh", "zargunch", "zarp", "zav", "zebr", "zel",
"zer", "zi", "zich", "zimbr", "zinc", "zincograf",
"zincograv", "zing", "zingr", "zinzilul", "zip", "zirr",
"zizani", "zizi", "zo", "zomb", "zon", "zonch",
"zongol", "zonz", "zonzon", "zoograf", "zorn", "zorrag",
"zort", "zuc", "zuel", "zul", "zumb", "zumbai",
"zumbeir", "zumbr", "zun", "zung", "zunzun", "zup",
"zurr"])


# VERBOS REGULARES TERMINADOS EM CAR, GAR E CCEDILHA AR - RADICAL
plvrCVbrar = set(["a", "abar", "abel", "abgre", "abju", "abjudi",
"abjur", "able", "abne", "abo", "abode", "abou",
"abra", "abri", "acer", "ache", "acidifi", "acirolo",
"aconche", "acrian", "adar", "ade", "adel", "aden",
"ader", "adjudi", "adli", "ado", "adoci", "adre",
"advo", "aerifi", "afa", "afian", "afidal", "afin",
"aflamen", "afo", "agale", "agre", "agu", "ajindun",
"ajuden", "al", "ala", "alar", "alavan", "alber",
"alcan", "aldea", "aletar", "alfande", "alguer", "alian",
"alicer", "almece", "almo", "almonde", "alo", "alon",
"alu", "alver", "alvori", "alvoro", "ama", "amantei",
"amatun", "amea", "ami", "amol", "amole", "amoque",
"amorda", "amoris", "amplifi", "amulheren", "anafra", "apa",
"apacifi", "ape", "apla", "apli", "apote", "aproche",
"ar", "ardi", "aren", "aris", "armen", "arrai",
"arran", "arrebi", "arrega", "arrei", "arreman", "arren",
"arrene", "arrepi", "arri", "arris", "arro", "arru",
"arrua", "assosse", "ata", "atartaru", "ati", "atoi",
"atra", "atur", "au", "autenti", "autentifi", "autodesli",
"autoli", "automedi", "autopropa", "autorrevo", "avan", "avancar",
"avar", "averdu", "averdun", "azou", "ba", "bagun",
"bajo", "balan", "ban", "barre", "barri", "batu",
"beberi", "berre", "bestifi", "bexi", "bifur", "bin",
"biodiversifi", "biofortifi", "bisna", "blo", "bo", "boi",
"bol", "bombi", "bon", "bonan", "bone", "bonifi",
"bor", "borra", "borre", "borri", "borris", "bote",
"boto", "bou", "brasilifi", "bre", "bri", "brin",
"brio", "bro", "brutifi", "bubulu", "bun", "bur",
"bura", "burri", "burrifi", "bus", "butu", "buze",
"ca", "caboro", "cabou", "cabro", "cabru", "caci",
"cadu", "cafan", "cafun", "cain", "cal", "calamo",
"calcifi", "calembur", "calhan", "calorifi", "can", "candon",
"cantari", "capan", "capen", "capian", "capis", "caprifi",
"car", "caran", "carbonifi", "cardu", "cari", "carnifi",
"caro", "carre", "cartilaginifi", "cas", "caseifi", "casti",
"castifi", "catalo", "catin", "catrace", "catrapis", "catu",
"caulifi", "causti", "caustifi", "cava", "caval", "cavo",
"cavou", "cavu", "caxin", "ce", "celifi", "centrifi",
"centrifu", "centupli", "cer", "cerifi", "certifi", "cha",
"chaba", "chabou", "chala", "chambo", "chambre", "chame",
"chamus", "chan", "chanas", "chapi", "chapis", "chapu",
"chaqui", "charan", "charavis", "charin", "charris", "chas",
"chavanis", "chavas", "che", "cheiri", "cheravas", "chi",
"chian", "chin", "chis", "cho", "chorami", "choramin",
"chorin", "choroco", "chorris", "chu", "chuma", "chumbre",
"chuvenis", "chuveris", "chuvis", "cientifi", "cin", "cinefi",
"circunave", "circunva", "cis", "clarifi", "classifi", "claudi",
"cli", "clini", "clo", "co", "cobi", "cocori",
"codifi", "coedu", "coindi", "coira", "coisifi", "col",
"cole", "coli", "coliti", "colma", "colo", "comar",
"combor", "come", "comis", "compe", "complexifi", "compli",
"compur", "comun", "comuni", "con", "conche", "concul",
"condrifi", "condupli", "confis", "confri", "congra", "congre",
"conju", "consignifi", "conspur", "contrabalan", "contradan",
"contraindi", "contramar", "contrarrepli", "convo", "coobri", "coossifi",
"copides", "coqueifi", "cor", "coris", "cornifi", "corporifi",
"corri", "corru", "corus", "cosi", "cou", "coura",
"cousifi", "cretifi", "criodesse", "criti", "croni", "crucifi",
"crustifi", "cu", "cubi", "cubifi", "cucuri", "cul",
"curu", "cutu", "dan", "dan"+u"\u00E7"+"ari", "danifi", "deba",
"deban", "debi", "deboi", "debor", "debou", "debru",
"decal", "decempli", "decodifi", "decorti", "decupli", "dedi",
"defe", "defla", "deifi", "dele", "delga", "deli",
"delin", "delon", "demar", "dene", "densifi", "depeni",
"depre", "dero", "derrai", "derran", "derre", "derrei",
"derren", "derri", "derris", "derro", "dervir", "desaban",
"desabo", "desabor", "desabra", "desabri", "desache", "desacidifi",
"desaconche", "desadere", "desadvo", "desafa", "desafo", "desafus",
"desagre", "desagu", "desala", "desalar", "desalcan", "desalfande",
"desalicer", "desalo", "desalu", "desamachu", "desami", "desamol",
"desamou", "desan", "desapa", "desape", "desapli", "desapre",
"desaqueren", "desar", "desarrai", "desarran", "desarrega", "desarrei",
"desarrene", "desarri", "desarrin", "desarris", "desarru", "desassosse",
"desata", "desatas", "desatra", "desatran", "desatravan", "desau",
"desava", "desavin", "desba", "desbal", "desbalan", "desban",
"desbarran", "desbarri", "desbato", "desbei", "desbi", "desbo",
"desbor", "desbra", "desbre", "desbrin", "desburri", "desburrifi",
"desca", "descaba", "descacha", "descal", "descalcifi", "descali",
"descan", "descanji", "descar", "descarapu", "descaro", "descarre",
"descas", "descaval", "desce", "descer", "desclassifi", "desco",
"descodifi", "descol", "descolo", "descompli", "descomun", "desconche",
"desconju", "desconvo", "descorti", "desedifi", "desedu", "desema",
"desemba", "desembar", "desembara", "desembarran", "desembarri", "desembei",
"desembo", "desembor", "desemborras", "desembos", "desembra", "desembria",
"desembrus", "desembu", "desemburri", "desemo", "desempa", "desempe",
"desempefli", "desempen", "desemperti", "desempo", "desempol", "desempre",
"desemulsifi", "desencabe", "desencacha", "desencan", "desencar", "desencaran",
"desencarapu", "desencarran", "desencarre", "desencas", "desencasa", "desencava",
"desencaval", "desenchar", "desenco", "desencoira", "desencorti", "desencoura",
"desencren", "desencu", "desenfarrus", "desenfeiti", "desenfo", "desenfor",
"desenfras", "desenfus", "desenga", "desengas", "desengon", "desengra",
"desengui", "desenjor", "desenla", "desenli", "desenloda", "desenras",
"desenri", "desenros", "desenru", "desensa", "desenso", "desentalis",
"desento", "desentran", "desentrela", "desentron", "desenver", "desenvis",
"desenxer", "desequivo", "desertifi", "desesperan", "desexcomun", "desfa",
"desfabri", "desfadi", "desfal", "desfalca", "desfo", "desfol",
"desfole", "desfor", "desfortifi", "desgal", "desgaseifi", "desgasifi",
"desgra", "desgre", "desidentifi", "desimpli", "desin", "desindi",
"desinteiri", "desinterli", "desintoxi", "desintri", "desintrin", "desipote",
"desis", "desla", "deslar", "desle", "deslei", "desli",
"deslignifi", "deslinhifi", "deslo", "deslou", "desman", "desmar",
"desmaris", "desmistifi", "desmitifi", "desmo", "desmortifi", "desmultipli",
"desmunhe", "desmus", "desnal", "desnari", "desnazifi", "desne",
"desno", "desnu", "desobri", "desofus", "desoleifi", "desou",
"despaulifi", "despe", "despeda", "despen", "desperdi", "despersonifi",
"despes", "despi", "despin", "despini", "despiro", "despon",
"desposti", "despre", "despregui", "despurifi", "desqualifi", "desrai",
"desrecal", "desri", "desris", "desros", "desru", "desrussifi",
"dessal", "dessalifi", "dessalinifi", "dessamou", "desse", "dessegre",
"dessili", "dessilicifi", "desso", "dessobra", "dessosse", "dessubju",
"desta", "destabo", "destalin", "destipifi", "desto", "destoiti",
"destou", "destouti", "destoutu", "destoxifi", "destra", "destran",
"destravan", "destri", "destrin", "destro", "destron", "desu",
"desumidifi", "desunifi", "desva", "desvi", "desvidra", "desvin",
"desvir", "desvis", "desvitrifi", "deszin", "deten", "detrin",
"detrun", "devitrifi", "devul", "dezin", "dezincifi", "di",
"diagnosti", "dialo", "diferen", "dignifi", "dilar", "dirradi",
"dis", "disfar", "disgre", "disse", "distrofi", "diton",
"diva", "divari", "diversifi", "divul", "do", "domesti",
"domifi", "domin", "dorminho", "dosifi", "dra", "dro",
"dulcifi", "dupli", "e", "ear", "eburnifi", "ecolo",
"edifi", "edu", "educomuni", "edul", "ei", "elan",
"elastifi", "electrifi", "electrodiagnosti", "electromedi", "elen", "eletrifi",
"eletromedi", "elon", "ema", "ema"+u"\u00E7"+"aro", "emandin", "emanhu",
"emanjeri", "emano", "emba", "embaba", "embaga", "embal",
"embalan", "embaloi", "embalou", "embar", "embara", "embarbas",
"embarra", "embarran", "embarri", "embasba", "embato", "embatu",
"embau", "embebe", "embei", "embel", "embele", "embetes",
"embi", "embibo", "embilo", "embin", "embio", "embiro",
"embis", "embites", "embizu", "embo", "embode", "embodo",
"emboldre", "emboli", "embone", "emboni", "embor", "emborras",
"embos", "embou", "embra", "embran", "embri", "embria",
"embrin", "embro", "embrua", "embrus", "embu", "embura",
"emburri", "emburris", "emedoi", "emedou", "emendi", "emeroi",
"emerou", "eminho", "emorda", "emoroi", "emorou", "emos",
"empa", "empa"+u"\u00E7"+"o", "empalhas", "empan", "empapu", "empar",
"empaupi", "empe", "empeiti", "empeli", "empen", "emperni",
"emperti", "empes", "empete", "empetele", "empi", "empile",
"empinho", "empino", "empipo", "empis", "empla", "empo",
"empocil", "empol", "empor", "emposti", "empre", "empregui",
"empul", "emulsifi", "en", "encabe", "encacha", "encachapu",
"encaga", "encal", "encalamou", "encali", "encalun", "encama",
"encambu", "encamoroi", "encamorou", "encamur", "encan", "encani",
"encar", "encaran", "encarapu", "encario", "encarni", "encaro",
"encarran", "encarrapi", "encarras", "encarre", "encarris", "encarvoi",
"encas", "encasa", "encausti", "encava", "encaval", "encazu",
"enchapu", "enchar", "encho", "enchoiri", "enchouri", "enchuma",
"encis", "encloa", "encoira", "encolo", "encomoro", "encomoroi",
"encomorou", "encon", "enconha", "enconi", "encor", "encorri",
"encorti", "encoura", "encramoio", "encramou", "encren", "encro",
"encu", "encurri", "endere", "endil", "endomin", "endra",
"enes", "enfacho", "enfan", "enfani", "enfarrus", "enfeiti",
"enfin", "enfiteuti", "enfo", "enfoi", "enfor", "enfou",
"enfra", "enfraldi", "enfras", "enfuma", "enfunis", "enfus",
"enga", "engal", "engali", "engalri", "engas", "engati",
"engero", "engi", "engon", "engra", "engui", "enjal",
"enjan", "enji", "enjor", "enju", "enjun", "enla",
"enlabrus", "enlaru", "enli", "enlo", "enloda", "enloi",
"enlou", "eno", "enoiri", "enouri", "enra", "enran",
"enras", "enre", "enredoi", "enredou", "enri", "enro",
"enrodri", "enros", "enru", "ensa", "ensal", "ense",
"enses", "enso", "ensofre", "ensova", "entabi", "entabo",
"entalei", "entali", "entalin", "entalis", "entan", "entani",
"entapi", "ente", "enteju", "enti", "entiju", "entisi",
"ento", "entoi", "entou", "entrambeli", "entrambi", "entran",
"entravis", "entre", "entrecho", "entrela", "entreli", "entreloi",
"entrelou", "entrepi", "entrepli", "entrerre", "entressa", "entressufo",
"entreto", "entrin", "entro", "entron", "entrope", "entropi",
"entrovis", "entrupi", "entuju", "enturvis", "envelha", "enver",
"enverru", "enves", "envi", "envidra", "envis", "enxal",
"enxaque", "enxau", "enxe", "enxer", "enxo", "enxu",
"epigramati", "epilo", "equivo", "eri", "erradi", "erri",
"es", "esbaba", "esbaga", "esbalan", "esbalou", "esban",
"esbarran", "esbarre", "esbarri", "esbarro", "esbei", "esbeltifi",
"esbeni", "esberra", "esbi", "esbo", "esbode", "esboi",
"esborra", "esborre", "esbou", "esbra", "esbranqui", "esbrin",
"esbron", "esbru", "esbur", "esbura", "esca", "escabe",
"escachou", "escadra", "escaga", "escalaman", "escalamou", "escali",
"escamur", "escamurren", "escan", "escane", "escar", "escaramu",
"escarapu", "escarda", "escardi", "escardu", "escarifi", "escarmou",
"escarni", "escarnifi", "escaro", "escarou", "escarrapi", "escarvan",
"escarvun", "escas", "escava", "esclamou", "esclerifi", "esco",
"escoi", "escor", "escorifi", "escorra", "escorre", "escorrima",
"escorti", "escou", "escozi", "escramou", "escramu", "escul",
"esfal", "esfalca", "esfande", "esfani", "esfarrun", "esfel",
"esflo", "esfoi", "esfole", "esfolha", "esfor", "esformi",
"esforni", "esforri", "esfou", "esfran", "esfre", "esfregon",
"esfuma", "esfura", "esfuran", "esfutri", "esga", "esgal",
"esgani", "esgar", "esgati", "esla", "eslin", "esma",
"esmadri", "esmar", "esmarne", "esmarno", "esmartu", "esmatru",
"esmija", "esmiun", "esmo", "esmoi", "esmon", "esmor",
"esmorda", "esmordi", "esmorra", "esmou", "esmurra", "esmurre",
"esmurren", "esna", "esno", "espa", "espada", "espaje",
"espalha", "espan", "espanas", "espandon", "espapa", "esparre",
"espassari", "espe", "especifi", "espectrifi", "espeda", "espedar",
"espedre", "espeni", "esperan", "esperdi", "esperme", "esperne",
"espesco", "espetrifi", "espi", "espica", "espicoi", "espicou",
"espin", "espini", "espipo", "espo", "esporifi", "espotri",
"espou", "espregui", "espreme", "espul", "espuma", "esquadra",
"esqui", "esquistifi", "esta", "estabou", "estafe", "estali",
"estan", "estardalha", "estarrifi", "estarrin", "estatistifi", "esteli",
"ester", "esterifi", "esterli", "esterni", "esti", "estilha",
"estin", "estira", "esto", "estoma", "estome", "estorce",
"estorci", "estorde", "estorne", "estorni", "estorri", "estorte",
"estra", "estrabou", "estrafe", "estran", "estrapa", "estratifi",
"estre", "estreban", "estrefe", "estreli", "estrelou", "estri",
"estrin", "estro", "estroci", "estron", "estrufe", "estrumbi",
"estu", "estultifi", "estupefi", "estupidifi", "esturri", "esver",
"esvidi", "esvoa", "eterifi", "evo", "exal", "exatifi",
"excarnifi", "excomun", "exemplifi", "exgre", "exiguifi", "expli",
"expur", "exsi", "extri", "fa", "fabri", "fadi",
"fal", "fala", "falca", "falho", "falo", "falsifi",
"falu", "fandan", "fandin", "fani", "fanu", "faris",
"farras", "farron", "farun", "fati", "femen", "fi",
"fin", "fis", "fitu", "flo", "flogisti", "fluidifi",
"fo", "fofo", "foi", "fol", "fole", "folhe",
"for", "forji", "formi", "forni", "forri", "forta",
"fortale", "fortifi", "fos", "fossan", "fossilifi", "fotomultipli",
"fou", "fra", "fraldi", "fre", "freju", "fres",
"frigorifi", "fro", "frute", "frutifi", "fu", "fube",
"fuji", "fule", "fuma", "fume", "fumi", "fun",
"fura", "furdun", "furti", "furun", "fus", "fusti",
"futi", "futri", "futu", "fuxi", "gadi", "gal",
"gali", "gan", "gani", "gar", "garan", "gargada",
"gargala", "gaseifi", "gasifi", "gelatinifi", "geleifi", "gelifi",
"gemel", "gemelhi", "gemi", "gin", "ginasti", "girova",
"gla", "glorifi", "gomifi", "gon", "gou", "gramati",
"granitifi", "gratifi", "gron", "guas", "guen", "hermetifi",
"heroifi", "heterocarre", "hiperapli", "hipote", "hispanifi", "homolo",
"honorifi", "honrifi", "horrifi", "hulhifi", "humifi", "i",
"identifi", "idiotifi", "ignifi", "ignifu", "ili", "imbeli",
"imbi", "imbri", "impel", "impersonifi", "impli", "impre",
"impurifi", "in", "incomuni", "incul", "incurri", "inda",
"indi", "indicifi", "indignifi", "indil", "infin", "infuni",
"injun", "injusti", "injustifi", "inli", "insti", "intei",
"inteiri", "intensifi", "intercomuni", "interesterifi", "interestratifi", "interi",
"interla", "interli", "interpi", "interro", "interse", "inti",
"intoxi", "intri", "intrin", "investi", "invo", "invul",
"irri", "irro", "is", "jan", "jantari", "jazzifi",
"jo", "jon", "jornalisti", "ju", "judi", "jul",
"jun", "jur", "justi", "justifi", "la", "labre",
"laicifi", "lambaris", "lambi", "lambis", "lambre", "lambu",
"lan", "langu", "lapidifi", "lar", "las", "late",
"lati", "latin", "lavaris", "lavas", "lave", "le",
"lei", "len", "lengalen", "lenhifi", "lenifi", "letifi",
"levi", "li", "lignifi", "lin", "linifi", "liquenifi",
"liquidifi", "liri", "lis", "liti", "litifi", "lo",
"lobre", "lobri", "logi", "lombri", "lor", "lu",
"lubri", "lubrifi", "lus", "luscofus", "lusifi", "ma",
"maca", "ma"+u"\u00E7"+"aro", "macaven", "machi", "machu", "macu",
"madefi", "madra", "madru", "magi", "magnifi", "malo",
"malu", "man", "mandin", "mandu", "manjeri", "mano",
"mar", "maris", "marri", "marru", "mas", "massifi",
"masti", "mastu", "mati", "matra", "matru", "maturran",
"mazur", "medi", "mei", "melifi", "men", "mendi",
"menospre", "mer", "mercurifi", "merendu", "mes", "mesti",
"metacomuni", "metafisi", "metalifi", "metodifi", "metrifi", "mexeri",
"mexeru", "mi", "mimi", "min", "minho", "minifi",
"ministrifi", "mirifi", "mis", "mistifi", "miti", "mitifi",
"mo", "modi", "modifi", "mogan", "mogi", "moji",
"mol", "mole", "molen", "molifi", "mon", "monolo",
"monoton", "moque", "mor", "moran", "morce", "morda",
"mordi", "mordis", "morra", "morse", "mortifi", "mos",
"mosse", "mostren", "mou", "mouris", "muchi", "mufi",
"mugan", "multipli", "mumifi", "mundifi", "mungan", "munhe",
"mupi", "mupu", "mus", "musi", "muxi", "na",
"nadifi", "namori", "namoris", "naufra", "nave", "nazifi",
"ne", "nega", "nene", "nes", "nevis", "nevoa",
"ni", "nidifi", "niilifi", "nitidifi", "nitrifi", "no",
"nobilifi", "noctiva", "notifi", "nuan", "nulifi", "nutrifi",
"o", "obce", "objectifi", "objetifi", "objur", "obri",
"octupli", "ofe", "ofus", "oi", "oiri", "opa",
"opacifi", "or", "organifi", "orti", "ortorretifi", "ossifi",
"ou", "ouri", "outor", "ozonifi", "pa", "pacifi",
"padu", "palan", "palhi", "palifi", "pan", "pana",
"pande", "panegiri", "panifi", "papagu", "papari", "papo",
"papou", "paraliti", "parifi", "parlen", "parran", "pate",
"patus", "paulifi", "pe", "pechirin", "pedi", "penduri",
"peni", "penifi", "penis", "per", "percal", "percoru",
"perdi", "perere", "peri", "perlen", "perlon", "perren",
"personifi", "perva", "pes", "pespe", "petanis", "pete",
"petis", "petrifi", "pfu", "pi", "pian", "piciri",
"pin", "pindo", "pindon", "pini", "pino", "pintal",
"pipiri", "pipo", "piran", "piriri", "piro", "pirra",
"pis", "pitos", "piu", "planifi", "plasti",
"plastifi", "plenifi", "pli", "plu", "pluriestratifi", "plurifi",
"pluristratifi", "po", "poetifi", "pol", "pole", "polemi",
"polirramifi", "politi", "pomifi", "pon", "pontifi", "popo",
"pororo", "porvis", "poste", "poster", "posti", "poto",
"pra", "prati", "pre", "preale", "precal", "precifi",
"predemar", "predi", "prefabri", "pregui", "preite", "prejudi",
"prenuni", "presentifi", "presi", "pretra", "prevari", "pris",
"prodi", "profa", "profal", "profli", "prognosti", "prolifi",
"prolo", "prolon", "promul", "pronosti", "prontifi", "propa",
"prorro", "prosifi", "prototifi", "provis", "provo", "pseudojustifi",
"psicolo", "publi", "puli", "pun", "pur", "purifi",
"putrifi", "quadrupli", "qualifi", "quantifi", "qui", "quilifi",
"quimifi", "quin", "quintupli", "rabis", "rabus", "radi",
"radiodiagnosti", "radiomar", "radionave", "radiopre", "raman", "ramifi",
"ramo", "ran", "rancidifi", "rancifi", "rapi", "ras",
"rasmol", "raspan", "ratifi", "re", "reabra", "readjudi",
"real", "realar", "realo", "realu", "reapli", "reati",
"reautenti", "rebalan", "rebeli", "rebi", "rebis", "rebo",
"rebol", "reboli", "rebou", "rebu", "rebuli", "rebus",
"recal", "recalcifi", "recar", "recarre", "recaval", "recha",
"reche", "recipro", "reclassifi", "reco", "recoli", "recolo",
"recome", "recongra", "reconvo", "recor", "recrucifi", "rededi",
"reden", "redoi", "redou", "redupli", "reedifi", "reedu",
"reembar", "reempol", "reempor", "reempre", "reencu", "reendere",
"reenla", "reescramou", "reescramu", "reespecifi", "reexpli", "refe",
"refin", "refo", "refol", "refole", "refor", "refortifi",
"refre", "refres", "refri", "refu", "refun", "refunfume",
"rega", "regaseifi", "regou", "reguin", "reifi", "reinterro",
"reinvo", "reivindi", "rejun", "rejustifi", "relan", "relar",
"rele", "reli", "relin", "relo", "relou", "reman",
"remanis", "remar", "remas", "remasti", "remel", "remeni",
"remo", "remol", "remor", "remordi", "remordis", "remou",
"remu", "remun", "remus", "renave", "reobri", "repa",
"repe", "repeni", "repes", "repi", "repil", "repini",
"repis", "repli", "repol", "repole", "repre", "republi",
"repur", "repurifi", "requalifi", "rerratifi", "res", "resfol",
"resgal", "resinifi", "resmelen", "resmol", "resmun", "resmus",
"respan", "respi", "respin", "ressa", "resse", "ressi",
"ressul", "restauri", "restru", "restu", "reta", "retifi",
"retipifi", "reto", "retoi", "retori", "retou", "retra",
"retran", "retrin", "retrocarre", "retru", "reunifi", "rever",
"reverifi", "revi", "revin", "revindi", "revivifi", "revo",
"revol", "rezin", "ri", "ricer", "ridi", "rin",
"ripan", "ris", "ro", "ro"+u"\u00E7"+"a", "roce", "rodri",
"roli", "romanes", "ron", "ros", "rou", "ru",
"rubifi", "rubri", "rus", "russifi", "rusti", "rustifi",
"sa", "sabere", "saberere", "sabre", "sabu", "sa"+u"\u00E7"+"ari",
"sacarifi", "sacrifi", "sal", "salifi", "salpi", "saltari",
"salu", "salubrifi", "saman", "sambar", "sambo", "sanguessu",
"sanguifi", "sani", "sanifi", "santi", "santifi", "sape",
"sapere", "saponifi", "sarafus", "sarapi", "sarrabis", "sarrafa",
"saxifi", "se", "sebenis", "segre", "selvati", "semiapli",
"semidomesti", "sen", "sensifi", "septupli", "seraman", "serin",
"serraman", "setupli", "sextupli", "signifi", "silabifi", "silicifi",
"silogisti", "simplifi", "sindi", "sinte", "sinu", "sir",
"siriri", "so", "sobal", "sobne", "sobra", "sobran",
"sobrecasa", "socal", "so"+u"\u00E7"+"o", "sofisti", "sofre",
"soji", "soju", "sola", "solan", "solavan", "sole",
"solidifi", "solu", "somiti", "sone", "sope", "sorbi",
"sororo", "sorras", "sosse", "sotran", "soupi", "su",
"subapli", "subclassifi", "subelis", "subenfiteuti", "suberifi", "subespecifi",
"subju", "sublo", "substantifi", "sudorifi", "sufo", "sufra",
"sufumi", "suji", "suju", "sul", "sulan", "sun",
"superapli", "superdiagnosti", "supli", "sur", "suru", "sururu",
"ta", "tabi", "tabu", "tairo", "talin", "taman",
"tamus", "tan", "tanifi", "tape", "tapi", "tarifi",
"taro", "tarou", "tarrin", "tartufi", "taru", "tas",
"te", "telecomuni", "tenrifi", "ter", "terrifi", "terrin",
"testi", "testifi", "testu", "ti", "tibun", "tin",
"tipi", "tipifi", "tiriri", "tisi", "titi", "titiri",
"to", "toi", "tonifi", "torce", "torri", "torrifi",
"torris", "tos", "tosse", "tossi", "toste", "tou",
"toxi", "tra", "trabalhis", "trabalhu", "trabu", "trafe",
"trafi", "trambe", "trambi", "tran", "transcodifi", "transfe",
"transignifi", "translo", "translou", "transtro", "trapa", "trasfe",
"trastro", "trefe", "treju", "treli", "tremelhi", "tremeli",
"tremo", "trepi", "trepli", "tresfe", "tresfol", "tresfole",
"treslou", "trevis", "tri", "trifur", "trin", "tripli",
"tris", "trisse", "trissul", "tristifi", "tro", "trocis",
"trombi", "trompi", "tron", "trope", "tropi", "trou",
"trovis", "tru", "trumbi", "trun", "trustifi", "tuberifi",
"tumefi", "tumidifi", "tumifi", "tun", "tunisifi", "turifi",
"tutu", "u", "ultrapurifi", "umidifi", "unanimifi", "unifi",
"univo", "urti", "va", "vardas", "varie", "varris",
"varrus", "vas", "vavu", "velha", "veli", "venefi",
"venia", "ver", "verdas", "verde", "verifi", "vermifu",
"verru", "versifi", "vesi", "vi", "viati", "vili",
"vilifi", "vin", "vindi", "vinifi", "vintipli", "vis",
"vitrifi", "vivifi", "vo", "vol", "vun", "vuvu",
"xabou", "xave", "xero", "ximbi", "xin", "xo",
"xumber", "xumbre", "zan", "zin", "zorra", "zu",
"zun"])

# EXCECAO VERBOS REGULARES TERMINADOS EM ER - RADICAL + bdhilmnoprstuvxz + er
exvrVbrxer = set(["como", "vivo"])

# VERBOS REGULARES TERMINADOS EM ER - RADICAL + bdhilmnoprstuvxz + er
plvrVbrxer = set(["abat", "abced", "absced", "abscond", "absolv",
"absorb", "absorv", "aced", "acend", "acolh",
"acomet", "acorr", "adjaz", "adscrev", "ambitend",
"ambivert", "amov", "anteced", "anted", "antemov",
"antevert", "apend", "aperceb", "apreend", "aprem",
"aprend", "ard", "arremet", "arrepend", "ascend",
"astrev", "atend", "atrev", "aurisplend", "autoabsorv",
"autoatend", "autocompreend", "autoconced", "autoconvert", "autodefend",
"autodesenvolv", "autopreench", "autopromov", "autossuspend", "avert",
"barr", "bat", "beb", "benz", "bival",
"carcom", "catafed", "ced", "chov", "cincunscrev",
"circumpercorr", "circunjaz", "circunscrev", "circunv", "circunvolv",
"codev", "coescrev", "coestend", "colh", "combat",
"com", "comet", "comov", "compon", "compreend",
"compromet", "conceb", "conced", "concorr", "condescend",
"contend", "contrabat", "contrarrespond", "contrarromp", "contravert",
"controvert", "convert", "conviv", "convolv", "coocorr",
"corr", "correspond", "corromp", "cos", "coz",
"debat", "decorr", "defend", "delamb", "demov",
"depend", "deperd", "depreend", "derret", "desacolh",
"desacorr", "desaperceb", "desaprend", "desarrepend", "desatend",
"desbeb", "descend", "descom", "descomet", "descomov",
"descompreend", "descompromet", "desconvert", "descos", "descrev",
"desd", "desembeb", "desench", "desencolh", "desentend",
"desentolh", "desenvolv", "desescond", "deslamb", "desmord",
"desmorr", "despend", "desperceb", "desprecav", "despreconceb",
"desprend", "despromov", "dessocorr", "dessorv", "dessoub",
"destem", "destolh", "desviv", "dev", "devolv",
"discorr", "dispend", "disperd", "dissolv", "distend",
"embat", "embeb", "empreend", "encend", "ench",
"encolh", "encoz", "enfond", "entend", "entolh",
"entrebat", "entrecolh", "entrecorr", "entrecoz", "entremet",
"entremord", "entreperceb", "entreprend", "entrescolh", "entromet",
"envolv", "erod", "esbat", "escafed", "escolh",
"escond", "escorr", "escoz", "escrev", "esferv",
"espland", "esplend", "esprem", "essolv", "estend",
"estrel", "estrem", "esvarr", "evolv", "exced",
"excel", "expend", "exsolv", "extravert", "fed",
"fend", "ferv", "fod", "frem", "frend",
"gem", "hiperabsorv", "hiperconced", "hiperconcorr", "hiperdesenvolv",
"hiperestend", "hipodesenvolv", "imov", "impend", "improced",
"incend", "incompreend", "incorr", "independ", "inscrev",
"intend", "interced", "intercorr", "intercorrespond", "interdepend",
"intermet", "interprend", "interromp", "intervert", "intromet",
"introvert", "invert", "irromp", "jaz", "juncarench",
"lamb", "locomov", "lucitrem", "malcoz", "malsofr",
"manuscrev", "megadesenvolv", "met", "mex", "mord",
"morremorr", "morr", "mov", "ocorr", "ofend",
"pendepend", "pend", "perceb", "percorr", "persolv",
"persorv", "perv", "pervert", "porfend", "precav",
"preced", "preconceb", "precorr", "preench", "prem",
"premorr", "prend", "prerrebat", "prerromp", "prescrev",
"pretend", "previv", "proced", "promet", "promov",
"propend", "prorromp", "proscrev", "protend", "reabsorv",
"reacend", "reaprend", "rearrepend", "reascend", "rebat",
"rebeb", "rebenz", "receb", "reced", "recend",
"recolh", "recom", "recompreend", "recompromet", "reconcorr",
"reconvert", "recorr", "recos", "recoz", "redescend",
"redissolv", "reempreend", "reench", "reentend", "reescond",
"reescrev", "refend", "referv", "reinscrev", "relamb",
"remet", "remex", "remord", "remorr", "remov",
"rend", "reouv", "repercorr", "repervert", "repre