/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef FB2COLLECTOR_H_INCLUDED
#define FB2COLLECTOR_H_INCLUDED

namespace libebook
{

struct FB2BlockFormat;
class FB2Style;

class FB2Collector
{
public:
  virtual ~FB2Collector() = 0;

  virtual void defineMetadataEntry(const char *name, const char *value) = 0;
  virtual void openMetadataEntry(const char *name) = 0;
  virtual void closeMetadataEntry() = 0;

  virtual void defineID(const char *id) = 0;

  virtual void openPageSpan() = 0;
  virtual void closePageSpan() = 0;

  virtual void openBlock() = 0;
  virtual void closeBlock() = 0;

  virtual void openParagraph(const FB2BlockFormat &format) = 0;
  virtual void closeParagraph() = 0;

  virtual void openSpan(const FB2Style &style) = 0;
  virtual void closeSpan() = 0;

  virtual void insertText(const char *text) = 0;

  virtual void openTable(const FB2BlockFormat &format) = 0;
  virtual void closeTable() = 0;

  virtual void openTableRow(const FB2BlockFormat &format) = 0;
  virtual void closeTableRow() = 0;

  virtual void openTableCell(int rowspan, int colspan) = 0;
  virtual void closeTableCell() = 0;
  virtual void insertCoveredTableCell() = 0;

  virtual void insertFootnote(const char *id) = 0;

  virtual void insertBitmap(const char *id) = 0;
  virtual void insertBitmapData(const char *contentType, const char *base64Data) = 0;
};

}

#endif // FB2COLLECTOR_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
