#!/usr/bin/python

import sys
import re
import io

definitionSet = set()
definitionToSourceLocationMap = dict()
definitionToTypeMap = dict()
callSet = set()
sourceLocationSet = set()
# things we need to exclude for reasons like :
# - it's a weird template thingy that confuses the plugin
exclusionSet = set([
    ])

# clang does not always use exactly the same numbers in the type-parameter vars it generates
# so I need to substitute them to ensure we can match correctly.
normalizeTypeParamsRegex = re.compile(r"type-parameter-\d+-\d+")
def normalizeTypeParams( line ):
    return normalizeTypeParamsRegex.sub("type-parameter-?-?", line)

# The parsing here is designed to avoid grabbing stuff which is mixed in from gbuild.
# I have not yet found a way of suppressing the gbuild output.
with io.open(sys.argv[1], "rb", buffering=1024*1024) as txt:
    for line in txt:
        if line.startswith("definition:\t"):
            idx1 = line.find("\t",12)
            idx2 = line.find("\t",idx1+1)
            idx3 = line.find("\t",idx2+1)
            funcInfo = (normalizeTypeParams(line[12:idx1]), line[idx1+1:idx2])
            definitionSet.add(funcInfo)
            definitionToTypeMap[funcInfo] = line[idx2+1:idx3].strip()
            definitionToSourceLocationMap[funcInfo] = line[idx3+1:].strip()
        elif line.startswith("touch:\t"):
            idx1 = line.find("\t",7)
            callInfo = (normalizeTypeParams(line[7:idx1]), line[idx1+1:].strip())
            callSet.add(callInfo)

# Invert the definitionToSourceLocationMap
# If we see more than one method at the same sourceLocation, it's being autogenerated as part of a template
# and we should just ignore
sourceLocationToDefinitionMap = {}
for k, v in definitionToSourceLocationMap.iteritems():
    sourceLocationToDefinitionMap[v] = sourceLocationToDefinitionMap.get(v, [])
    sourceLocationToDefinitionMap[v].append(k)
for k, definitions in sourceLocationToDefinitionMap.iteritems():
    if len(definitions) > 1:
        for d in definitions:
            definitionSet.remove(d)
    
tmp1set = set()
for d in definitionSet:
    clazz = d[0] + " " + d[1]
    if clazz in exclusionSet:
        continue
    if d in callSet:
        continue
    srcLoc = definitionToSourceLocationMap[d];
    if (srcLoc.startswith("include/")):
        continue
    if (srcLoc.startswith("external/")):
        continue
    # this is all representations of on-disk data structures
    if (srcLoc.startswith("sc/source/filter/inc/scflt.hxx")
        or srcLoc.startswith("sw/source/filter/ww8/")
        or srcLoc.startswith("vcl/source/filter/sgvmain.hxx")
        or srcLoc.startswith("vcl/source/filter/sgfbram.hxx")
        or srcLoc.startswith("vcl/inc/unx/XIM.h")
        or srcLoc.startswith("vcl/inc/unx/gtk/gloactiongroup.h")
        or srcLoc.startswith("include/svl/svdde.hxx")):
        continue

    tmp1set.add((clazz + " " + definitionToTypeMap[d], srcLoc))

# sort the results using a "natural order" so sequences like [item1,item2,item10] sort nicely
def natural_sort_key(s, _nsre=re.compile('([0-9]+)')):
    return [int(text) if text.isdigit() else text.lower()
            for text in re.split(_nsre, s)]

# sort results by name and line number
tmp1list = sorted(tmp1set, key=lambda v: natural_sort_key(v[1]))

# print out the results
for t in tmp1list:
    print t[1]
    print "    ", t[0]

    

# add an empty line at the end to make it easier for the unusedFieldsremove plugin to mmap() the output file 
print
        

