/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-notification-context.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_INDICATOR_CONTEXT_H
#define __UNITY_WEBAPPS_INDICATOR_CONTEXT_H

#include "../unity-webapps-gen-indicator.h"

#include "unity-webapps-action-manager.h"
#include "unity-webapps-indicator-manager.h"

#include "unity-webapps-presence-manager.h"

typedef struct _UnityWebappsIndicatorContext UnityWebappsIndicatorContext;

#include "unity-webapps-context-daemon.h"

struct _UnityWebappsIndicatorContext {
	GDBusConnection *connection;

	UnityWebappsGenIndicator *indicator_service_interface;

	UnityWebappsActionManager *action_manager;

	UnityWebappsIndicatorManager *indicator_manager;
	UnityWebappsIndicatorView *indicator_view;
	UnityWebappsIndicatorModel *indicator_model;
	
	gchar *canonical_name;
	gchar *desktop_path;

	guint num_actions;
	
	UnityWebappsPresenceManager *presence_manager;
};

UnityWebappsIndicatorContext *unity_webapps_indicator_context_new (GDBusConnection *connection, const gchar *desktop_path, const gchar *canonical_name, UnityWebappsInterestTracker *interest_tracker);
void unity_webapps_indicator_context_free (UnityWebappsIndicatorContext *indicator_context);

#endif
