'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbLatchGroup __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbLatchGroup \-  Latches the keysym group
.SH SYNOPSIS
.HP
.B Bool XkbLatchGroup
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "device_spec" "\^,"
.BI "unsigned int " "group" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to the X server 
.TP
.I device_spec
device ID, or XkbUseCoreKbd
.TP
.I group
index of the keysym group to latch
.SH DESCRIPTION
.LP

.I XkbLatchGroup 
sends a request to the server to latch the specified 
.I group
and 
does not wait for a reply. It returns True if the request was sent and False 
otherwise.

Reference the keysym group indices with these symbolic constants:

.TS
c s
l l
l l.
Table 1 Symbolic Group Names
_
Symbolic Name	Value
_
XkbGroup1Index	0
XkbGroup2Index	1
XkbGroup3Index	2
XkbGroup4Index	3
.TE
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbLatchGroup 
function returns True if a request was sent to the server to latch the specified 
.I group.
.TP 15
False
The 
.I XkbLatchGroup 
function returns False if the request was not sent.



