/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractListTester;
import com.google.common.collect.testing.testers.Platform;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

@GwtCompatible
public class ListAddTester<E>
extends AbstractListTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAdd_supportedPresent() {
        ListAddTester.assertTrue((String)"add(present) should return true", (boolean)this.getList().add(this.samples.e0));
        this.expectAdded(this.samples.e0);
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAdd_unsupportedPresent() {
        try {
            this.getList().add(this.samples.e0);
            ListAddTester.fail((String)"add(present) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAdd_supportedNullPresent() {
        Object[] array = this.createArrayWithNullElement();
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        ListAddTester.assertTrue((String)"add(nullPresent) should return true", (boolean)this.getList().add(null));
        List<Object> expected = Helpers.copyToList(array);
        expected.add(null);
        this.expectContents(expected);
    }

    public static Method getAddSupportedNullPresentMethod() {
        return Platform.getMethod(ListAddTester.class, "testAdd_supportedNullPresent");
    }
}

