/*
 * Copyright (c) 2001, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 4470717
 * @summary fix default handling and other misc
 *
 * @ignore run these by hand
 */

import com.sun.security.auth.callback.TextCallbackHandler;
import javax.security.auth.callback.*;

public class Default {
   public static void main(String args[]) throws Exception {
        TextCallbackHandler h = new TextCallbackHandler();
        NameCallback nc = new NameCallback("Name: ", "charlie");
        ConfirmationCallback cc = new ConfirmationCallback
                        ("Correct?",
                        ConfirmationCallback.INFORMATION,
                        ConfirmationCallback.YES_NO_OPTION,
                        ConfirmationCallback.NO);

        Callback[] callbacks = { nc, cc };
        h.handle(callbacks);

        if (cc.getSelectedIndex() == ConfirmationCallback.YES) {
            System.out.println("yes");
        } else {
            System.out.println("no");
        }
   }
}
