.TH saned 8 "29 Sep 2017" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX saned
.SH NAME
saned \- SANE network daemon
.SH SYNOPSIS
.B saned
.B [ \-a
.I [ username ]
.B ]
.B [ \-u
.I username
.B ]
.B [ \-b
.I address
.B ]
.B [ \-p
.I port
.B ]
.B [ \-l ]
.B [ \-D ]
.B [ \-o ]
.B [ \-d
.I n
.B ]
.B [ \-e ]
.B [ \-h ]

.SH DESCRIPTION
.B saned
is the SANE (Scanner Access Now Easy) daemon that allows remote clients
to access image acquisition devices available on the local host.

.SH OPTIONS
.PP
.B saned
recognises the following options:

.TP
.BR \-a "\fI [username]\fR, " \-\-alone [=\fIusername]\fR
is equivalent to the combination of
.B \-l \-D \-u
.I username
options. However,
.I username
is optional and running user will only be set when specified.

.TP
.BR \-u "\fI username\fR, " \-\-user =\fIusername\fR
requests that
.B saned
drop root privileges and run as the user (and group) associated with
.I username
after binding.

.TP
.BR \-b "\fI address\fR, " \-\-bind =\fIaddress\fR
tells
.B saned
to bind to the
.I address
given.

.TP
.BR \-p "\fI port\fR, " \-\-port=\fIport\fR
tells
.B saned
to listen on the
.I port
given.  A value of 0 tells
.B saned
to pick an unused port.  The default is the
.B sane-port (6566).

.TP
.BR \-l ", " \-\-listen
requests that
.B saned
run in standalone daemon mode.  In this mode,
.B saned
will listen for incoming client connections;
.BR inetd (8)
is not required for
.B saned
operations in this mode.

.TP
.BR \-D ", " \-\-daemonize
will request
.B saned
to detach from the console and run in the background.

.TP
.BR \-o ", " \-\-once
requests that
.B saned
exits after the first client disconnects.  This is useful for debugging.

.TP
.BR \-d "\fI n\fR, " \-\-debug =\fIn\fR
sets the level of
.B saned
debug output to
.IR n .
When compiled with debugging enabled, this flag may be
followed by a number to request more or less debug info.  The larger
the number, the more verbose the debug output.  E.g.,
.B \-d128
will request output of all debug info.  A level of 0 produces no
output at all.  The default value is 2.

.TP
.BR \-e ", " \-\-stderr
will divert
.B saned
debug output to stderr instead of the syslog default.

.TP
.BR \-h ", " \-\-help
displays a short help message.
.PP
If
.B saned
is run from other programs such as
.BR inetd (8),
.BR xinetd (8)
and
.BR systemd (1),
check that program's documentation on how to pass command-line options.

.SH CONFIGURATION
First and foremost:
.B saned
is not intended to be exposed to the internet or other non-trusted
networks. Make sure that access is limited by tcpwrappers and/or a firewall
setup. Don't depend only on
.BR saned 's
own authentication. Don't run
.B saned
as root if it's not necessary. And do
.B not
install
.B saned
as setuid root.
.PP
The
.I saned.conf
configuration file contains both options for the daemon and the access
list.
.TP
\fBdata_portrange\fP = \fImin_port\fP - \fImax_port\fP
Specify the port range to use for the data connection. Pick a port
range between 1024 and 65535; don't pick a too large port range, as it
may have performance issues. Use this option if your
.B saned
server is sitting behind a firewall. If that firewall is a Linux
machine, we strongly recommend using the Netfilter
\fInf_conntrack_sane\fP module instead.
.TP
\fBdata_connect_timeout\fP = \fItimeout\fP
Specify the time in milliseconds that
.B saned
will wait for a data
connection. Without this option, if the data connection is not done
before the scanner reaches the end of scan, the scanner will continue
to scan past the end and may damage it depending on the
backend. Specify zero to have the old behavior. The default is 4000ms.
.PP
The access list is a list of host names, IP addresses or IP subnets
(CIDR notation) that are permitted to use local SANE devices. IPv6
addresses must be enclosed in brackets, and should always be specified
in their compressed form. Connections from localhost are always
permitted. Empty lines and lines starting with a hash mark (#) are
ignored. A line containing the single character ``+'' is interpreted
to match any hostname. This allows any remote machine to use your
scanner and may present a security risk, so this shouldn't be used
unless you know what you're doing.
.PP
A sample configuration file is shown below:
.PP
.RS
# Daemon options
.br
data_portrange = 10000 - 10100
.br
# Access list
.br
scan\-client.somedomain.firm
.br
# this is a comment
.br
192.168.0.1
.br
192.168.2.12/29
.br
[::1]
.br
[2001:db8:185e::42:12]/64
.RE
.PP
The case of the host names does not matter, so AHost.COM is considered
identical to ahost.com.
.SH SERVER DAEMON CONFIGURATION
For
.B saned
to work properly in its default mode of operation, it is also necessary to
add the appropriate configuration for
.BR xinetd (8),
.BR inetd (8)
or
.BR systemd (1)
(see below).
Note that your
.BR inetd (8)
must support IPv6 if you want to connect to
.B saned
over IPv6;
.BR xinetd (8),
.BR openbsd-inetd (8)
and
.BR systemd (1)
are known to support IPv6, check the documentation for your
.BR inetd (8)
daemon.
.PP
In the sections below the configuration for
.BR inetd (8),
.BR xinetd (8)
and
.BR systemd (1)
are described in more detail.
.PP
For the configurations below it is necessary to add a line of the following
form to
.IR /etc/services :
.PP
.RS
sane\-port 6566/tcp # SANE network scanner daemon
.RE
.PP
The official IANA short name for port 6566 is "sane\-port". The older name
"sane" is now deprecated.

.SH INETD CONFIGURATION
It is required to add a single line to the
.BR inetd (8)
configuration file
.IR (/etc/inetd.conf)
.
.PP
The configuration line normally looks like this:
.PP
.RS
sane\-port stream tcp nowait saned.saned @SBINDIR@/saned saned
.RE
.PP
However, if your system uses
.BR tcpd (8)
for additional security screening, you may want to disable
.B saned
access control by putting ``+'' in
.IR saned.conf
and use a line of the following form in
.IR /etc/inetd.conf
instead:
.PP
.RS
sane\-port stream tcp nowait saned.saned /usr/sbin/tcpd @SBINDIR@/saned
.RE
.PP
Note that both examples assume that there is a
.B saned
group and a
.B saned
user.  If you follow this example, please make sure that the
access permissions on the special device are set such that
.B saned
can access the scanner (the program generally needs read and
write access to scanner devices).

.SH XINETD CONFIGURATION
If
.BR xinetd (8)
is installed on your system instead of
.BR inetd (8)
the following example for
.I /etc/xinetd.conf
may be helpful:
.PP
.RS
.ft CR
.nf
# default: off
# description: The sane server accepts requests
# for network access to a local scanner via the
# network.
service sane\-port
{
   port        = 6566
   socket_type = stream
   wait        = no
   user        = saned
   group       = saned
   server      = @SBINDIR@/saned
}
.fi
.ft R
.RE

.SH SYSTEMD CONFIGURATION
.B saned
can be compiled with explicit
.BR systemd (1)
support. This
will allow logging debugging information to be forwarded
to the
.BR systemd (1)
journal. The
.BR systemd (1)
support requires compilation with the systemd-devel package
installed on the system. This is the preferred option.

.B saned
can be used with
.BR systemd (1)
without the
.BR systemd (1)
integration compiled in, but then logging of debug information is not supported.

The
.BR systemd (1)
configuration is different for the 2 options, so both are described below.

.SH Systemd configuration for saned with systemd support compiled in
For
.BR systemd (1)
configuration we need to add 2 configuration files in
.IR /etc/systemd/system .
.PP
The first file we need to add here is called
.I saned.socket.
It shall have
the following contents:
.PP
.RS
.ft CR
.nf
[Unit]
Description=saned incoming socket

[Socket]
ListenStream=6566
Accept=yes
MaxConnections=1

[Install]
WantedBy=sockets.target
.fi
.ft R
.RE
.PP
The second file to be added is
.I saned@.service
with the following contents:
.PP
.RS
.ft CR
.nf
[Unit]
Description=Scanner Service
Requires=saned.socket

[Service]
ExecStart=/usr/sbin/saned
User=saned
Group=saned
StandardInput=null
StandardOutput=syslog
StandardError=syslog
Environment=SANE_CONFIG_DIR=@CONFIGDIR@
# If you need to debug your configuration uncomment the next line and
# change it as appropriate to set the desired debug options
# Environment=SANE_DEBUG_DLL=255 SANE_DEBUG_BJNP=5

[Install]
Also=saned.socket
.fi
.ft R
.RE
.PP
You need to set an environment variable for
.B SANE_CONFIG_DIR
pointing to the directory where
.B saned
can find its configuration files.
You will have to remove the # on the last line and set the variables
for the desired debugging information if required.  Multiple variables
can be set by separating the assignments by spaces as shown in the
example above.
.PP
Unlike
.BR xinetd (8)
and
.BR inetd (8),
.BR systemd (1)
allows debugging output from backends set using
.B SANE_DEBUG_XXX
to be captured. See the man-page for your backend to see what options
are  supported.
With the service unit as described above, the debugging output is
forwarded to the system log.

.SH Systemd configuration when saned is compiled without systemd support
This configuration will also work when
.B saned
is compiled WITH
.BR systemd (1)
integration support, but it does not allow debugging information to be logged.
.PP
For
.BR systemd (1)
configuration for
.BR saned ,
we need to add 2 configuration files in
.IR /etc/systemd/system .
.PP
The first file we need to add here is called
.I saned.socket.
It is identical to the version for
.BR systemd (1)
with the support compiled in.
It shall have the following contents:
.PP
.RS
.ft CR
.nf
[Unit]
Description=saned incoming socket

[Socket]
ListenStream=6566
Accept=yes
MaxConnections=1

[Install]
WantedBy=sockets.target
.fi
.ft R
.RE
.PP
The second file to be added is
.IR saned@.service .
This one differs from the version with
.BR systemd (1)
integration compiled in:
.PP
.RS
.ft CR
.nf
[Unit]
Description=Scanner Service
Requires=saned.socket

[Service]
ExecStart=/usr/sbin/saned
User=saned
Group=saned
StandardInput=socket

Environment=SANE_CONFIG_DIR=/etc/sane.d

[Install]
Also=saned.socket
.fi
.ft R
.RE
.PP

.SH FILES
.TP
.I /etc/hosts.equiv
The hosts listed in this file are permitted to access all local SANE
devices.  Caveat: this file imposes serious security risks and its use
is not recommended.
.TP
.I @CONFIGDIR@/saned.conf
Contains a list of hosts permitted to access local SANE devices (see
also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @CONFIGDIR@/saned.users
If this file contains lines of the form

user:password:backend

access to the listed backends is restricted. A backend may be listed multiple
times for different user/password combinations. The server uses MD5 hashing
if supported by the client.
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  On *NIX systems, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in
.IR @CONFIGDIR@ .
If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories
.IR tmp/config ,
.IR . ,
and
.I "@CONFIGDIR@"
being searched (in this order).

.SH "SEE ALSO"
.BR sane (7),
.BR scanimage (1),
.BR xscanimage (1),
.BR xcam (1),
.BR sane\-dll (5),
.BR sane\-net (5),
.BR sane\-"backendname" (5),
.BR inetd (8),
.BR xinetd (8),
.BR systemd (1)
.br
.I http://www.penguin-breeder.org/?page=sane\-net
.SH AUTHOR
David Mosberger
