/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* alice@strongswan.org */
  3, X'616c696365407374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* sun.strongswan.org */
  2, X'73756e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Sales, CN=alice@strongswan.org' */
  11, X'fb35c1df730e1570ee56ba1b6e1cf7f3ae48fcd9'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* %any */
  0, '%any'
);

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b8308202a0a003020102020100300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303130303131385a170d3139303930373130303131385a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381b23081af30120603551d130101ff040830060101ff020101300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010023929aa101b412d1f5a577532088f209b34798a72ed7bd6945d74beaa2b3a1768764ad7f8b0df8d97a1a3ed1102e92a5f107e3059dc2250be49d02261ca83a342e0e5de7d43c37744e3fcea3197720ca1184d4ef94e6beeb0d241746b0b92b7fb1004c08e88bf9eb4ce60f3e149466f3e9fc3f98bce449f448f9d465e52b59f0101e6203cfad0d89e23509fa043d4c12021e8f32be7db8b2edbada641d64aa1a04af64a2ee5b814a753dd76b30e3de04f3c6b61166e632f8364d51cf3730a9564a4d93b9227c28b09b0f5595d92a632f72fe509a129ca9ee54df2b0edc6c3d38564f10256efcd8be82b2ec64977e3a6f5ef098eaa7f00662a6cded16cb80637c'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Sales, CN=alice@strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, OU=Sales, CN=alice@strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 4
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 6
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_ALICE', 'PH_IP_SUN'
);

INSERT INTO ike_configs (
  local, remote
) VALUES (
  '%any', '%any'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, virtual
) VALUES (
  'nat-t', 1, 4, 5, '0.0.0.0'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, auth_method
) VALUES (
  'shunts', 2, 7, 7, 0
);

INSERT INTO child_configs (
  name
) VALUES (
  'nat-t'
);

INSERT INTO child_configs (
  name, mode, start_action
) VALUES (
  'local-net', 4, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  2, 2
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 0.0.0.0/0 */
  7, X'00000000', X'ffffffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 3, 2
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 1, 0
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 1, 1
);
