/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    static Log log = LogFactory.getLog((String)Transform.class.getName());
    static boolean _alreadyInitialized = false;
    static Map _transformHash = null;
    static HashMap classesHash = new HashMap();
    protected TransformSpi transformSpi = null;

    public Transform(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        super(document);
        this._constructionElement.setAttributeNS(null, "Algorithm", string);
        this.transformSpi = Transform.getImplementingClass(string);
        if (this.transformSpi == null) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create URI \"" + string + "\" class \"" + this.transformSpi.getClass() + "\""));
            log.debug((Object)("The NodeList is " + nodeList));
        }
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this._constructionElement.appendChild(nodeList.item(i).cloneNode(true));
            }
        }
    }

    public Transform(Element element, String string) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        String string2 = element.getAttributeNS(null, "Algorithm");
        if (string2 == null || string2.length() == 0) {
            Object[] objectArray = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
        this.transformSpi = Transform.getImplementingClass(string2);
        if (this.transformSpi == null) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
    }

    public static final Transform getInstance(Document document, String string) throws InvalidTransformException {
        return Transform.getInstance(document, string, (NodeList)null);
    }

    public static final Transform getInstance(Document document, String string, Element element) throws InvalidTransformException {
        HelperNodeList helperNodeList = new HelperNodeList();
        XMLUtils.addReturnToElement(document, helperNodeList);
        helperNodeList.appendChild(element);
        XMLUtils.addReturnToElement(document, helperNodeList);
        return Transform.getInstance(document, string, helperNodeList);
    }

    public static final Transform getInstance(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        return new Transform(document, string, nodeList);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _transformHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException {
        TransformSpi transformSpi = null;
        try {
            transformSpi = Transform.getImplementingClass(string);
        }
        catch (InvalidTransformException invalidTransformException) {
            Object[] objectArray = new Object[]{string, transformSpi};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        if (transformSpi != null) {
            Object[] objectArray = new Object[]{string, transformSpi};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            _transformHash.put(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput, this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput, outputStream, this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    private static TransformSpi getImplementingClass(String string) throws InvalidTransformException {
        try {
            Object v = classesHash.get(string);
            if (v != null) {
                return (TransformSpi)v;
            }
            Class clazz = (Class)_transformHash.get(string);
            if (clazz != null) {
                TransformSpi transformSpi = (TransformSpi)clazz.newInstance();
                classesHash.put(string, transformSpi);
                return transformSpi;
            }
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, illegalAccessException);
        }
        return null;
    }

    public String getBaseLocalName() {
        return "Transform";
    }
}

