/*
* Descent 3 
* Copyright (C) 2024 Parallax Software
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// Defines for indexes into the string table for in-code strings

#ifndef __STRING_TABLE____
#define __STRING_TABLE____

#define TXT(index) GetStringFromTable(index)

// Returns a pointer to the string at the index location from the string table
// if it is a bad index given, then the pointer to the error string "ERROR MISSING STRING" is given

const char *GetStringFromTable(int index);

#define TXT_NEW TXT(0)                //"New"
#define TXT_DELETE TXT(1)             //"Delete"
#define TXT_CONFIGURE TXT(2)          //"Configure"
#define TXT_OK TXT(3)                 //"OK"
#define TXT_CANCEL TXT(4)             //"Cancel"
#define TXT_DEFAULTMSHIPS TXT(5)      //"Default Multiplayer Ship"
#define TXT_NUMKILLS TXT(6)           //"Number of Kills:"
#define TXT_NUMDEATHS TXT(7)          //"Number of Deaths:"
#define TXT_KIDERATIO TXT(8)          //"Kill/Deaths Ratio:"
#define TXT_DIFFICULTYCOLON TXT(9)    //"Difficulty:"
#define TXT_LEVELSTRING TXT(10)       //"Level %d"
#define TXT_UNNAMED TXT(11)           //"<UnNamed>"
#define TXT_PRIMGOALS TXT(12)         //"Primary Goals"
#define TXT_SECONDARYGOALS TXT(13)    //"Secondary Goals"
#define TXT_SHIP_ TXT(14)             //"Ship:"
#define TXT_NOPILOT TXT(15)           //"No Pilot Selected"
#define TXT_PILOTS TXT(16)            //"Pilots"
#define TXT_PLTERROR TXT(17)          //"Pilot Error"
#define TXT_NEEDTOCREATE TXT(18)      //"You need to create and select a pilot"
#define TXT_PLTOKDEL TXT(19)          //"Are you sure you want to delete %s?"
#define TXT_PLTDELCONF TXT(20)        //"Delete Confirmation"
#define TXT_PLTDIFFICULT TXT(21)      //"Difficulty"
#define TXT_TRAINEE TXT(22)           //"Trainee"
#define TXT_ROOKIE TXT(23)            //"Rookie"
#define TXT_HOTSHOT TXT(24)           //"Hotshot"
#define TXT_ACE TXT(25)               //"Ace"
#define TXT_INSANE TXT(26)            //"Insane!"
#define TXT_CPYKEYCONF TXT(27)        //"COPY CONTROLS"
#define TXT_CUSTKEYB TXT(28)          //"CONFIGURE KEYBOARD"
#define TXT_CUSTGAMEC TXT(29)         //"CONFIGURE CONTROLLER"
#define TXT_COPYCONFERR TXT(30)       //"Copy Config Error"
#define TXT_COPYCONFERR1 TXT(31)      //"You Can't Copy the Configuration From The Same Pilot"
#define TXT_PLTENTERNAME TXT(32)      //"Enter Pilot Name"
#define TXT_PLTENTERNAME1 TXT(33)     //"Please enter a name for your pilot"
#define TXT_FILEERROR TXT(34)         //"File Error"
#define TXT_FILEERRPLT1 TXT(35)       //"Can't Create Pilot File (Out of Drive Space?)"
#define TXT_PLTERRORNAME TXT(36)      //"You Need To Name Your Pilot"
#define TXT_PLTERREXISTS TXT(37)      //"Pilot Already Exists, Please Rename"
#define TXT_PLTCHOOSE TXT(38)         //"Choose Pilot"
#define TXT_SAVEGAMENAME TXT(39)      // "You must specify a name."
#define TXT_LOADMESSAGE TXT(40)       // "loading"
#define TXT_AUDIOTAUNTC TXT(41)       //"Audio Taunt #3"
#define TXT_AUDIOTAUNTD TXT(42)       //"Audio Taunt #4"
#define TXT_MAXENERGY TXT(43)         // "Energy Full"
#define TXT_PRESETCONTROLS TXT(44)    //"Preset Controls"
#define TXT_NOGOALSAVAIL TXT(45)      //"There are no goals available"
#define TXT_USEPRESETS TXT(46)        //"Would you like to use one of the preset configurations?"
#define TXT_NOGUIDEBOT TXT(47)        //"One second... Waking up."
#define TXT_PRESSESCRET TXT(48)       //"Press ESC to return"
#define TXT_VIDEO TXT(49)             //"Graphics"
#define TXT_APPLY TXT(50)             //"Apply"
#define TXT_GAMMA TXT(51)             //"Gamma"
#define TXT_RENDERER TXT(52)          //"Renderer"
#define TXT_DIRECT3D TXT(53)          //"Direct 3D"
#define TXT_GLIDE TXT(54)             //"Glide (3DFX)"
#define TXT_OPENGL TXT(55)            //"OpenGL"
#define TXT_RESOLUTION TXT(56)        //"Resolution"
#define TXT_COMPLETED TXT(57)         //"Completed!"
#define TXT_NOTCOMPLETEDYET TXT(58)   //"Not Completed Yet"
#define TXT_CANT_LOAD_MULTI TXT(59)   // You cannot load a save game in multiplayer!
#define TXT_BILINEAR TXT(60)          //"Bilinear Filtering"
#define TXT_MIPMAPPING TXT(61)        //"Mipmapping"
#define TXT_DYNLIGHTING TXT(62)       //"Dynamic Lighting"
#define TXT_GOALSTATUSHEADING TXT(63) //"     Goal Status"
#define TXT_CANT_SAVE_MULTI TXT(64)   //"You cannot save a game in multiplayer!"
#define TXT_SOUND TXT(65)             //"Sound"
#define TXT_SOUNDVOL TXT(66)          //"Sound Volume"
#define TXT_GENERAL TXT(67)           //"General"
#define TXT_TERRAUTOLEV TXT(68)       //"Terrain Autoleveling"
#define TXT_MINEAUTOLEV TXT(69)       //"Mine Autoleveling"
#define TXT_LEFT TXT(70)              //"Left"
#define TXT_NONE TXT(71)              //"None"
#define TXT_MISSILE TXT(72)           //"Missile"
#define TXT_RIGHT TXT(73)             //"Right"
#define TXT_MISSILEVIEW TXT(74)       //"Missile View"
#define TXT_DETAILS TXT(75)           //"Details"
#define TXT_TERRDETAIL TXT(76)        //"Terrain Detail"
#define TXT_RENDDIST TXT(77)          //"Terrain Render Depth"
#define TXT_TERRCAST TXT(78)          //"Terrain Casting"
#define TXT_OFF TXT(79)               //"Off"
#define TXT_ON TXT(80)                //"On"
#define TXT_NO TXT(81)                //"No"
#define TXT_YES TXT(82)               //"Yes"
#define TXT_ERRUNINITCNT TXT(83)      //"Unable to initialize game control/joystick system."
#define TXT_CLICKXCLEAR TXT(84)       //"Click on 'X' or CTRL-C to clear bindings for selection."
#define TXT_ACTIVE TXT(85)            //"Active"
#define TXT_D3ERROR1 TXT(86)          //"%s file <%s>: errno = %d\n"
#define TXT_READING TXT(87)           //"Reading"
#define TXT_WRITING TXT(88)           //"Writing"
#define TXT_ADJUSTSETTINGS TXT(89)    //"Adjust settings"
#define TXT_ERRNORENDERER TXT(90)     //"Unable to initialize renderer.  Descent 3 requires a 3DFX for now."
#define TXT_ERRNOFONT TXT(91)         //"Unable to load font %s."
#define TXT_ERRSCRNSHT TXT(92)        //"Not enough memory to do screenshot!"
#define TXT_SCRNSHT TXT(93)           //"Screenshot saved as '%s'"
#define TXT_CHEATER TXT(94)           //"%s is cheating!"
#define TXT_HUDENABLED TXT(95)        //"HUD Enabled"
#define TXT_RECEIVINGDATA TXT(96)     //"Receiving data..."
#define TXT_LOADINGLEVEL TXT(97)      //"Loading level..."
#define TXT_HELP TXT(98)              //"Keys"
#define TXI_HLPPRNTSCRN 99            //"PrintScreen"
#define TXI_HLPTAKESCRNSHT 100        //"Save A Screenshot"
#define TXI_F3 101                    //"F3"
#define TXI_HLPCOCKPIT 102            //"Toggle Cockpit"
#define TXI_F2 103                    //"F2"
#define TXI_HLPCONFIG 104             //"Options Menu"
#define TXI_ESC 105                   //"ESC"
#define TXI_HLPQUIT 106               //"Abort Game"
#define TXI_PLUSMINUS 107             //"+/-"
#define TXI_HLPSCRNSIZE 108           //"Change Screen Size"
#define TXI_HLPPAUSE 109              //"Pause"
#define TXI_HLPPAUSEDESC 110          //"Pause The Game"
#define TXI_SF1 111                   //"SHIFT F1"
#define TXI_SF2 112                   //"SHIFT F2"
#define TXI_SF3 113                   //"SHIFT F3"
#define TXI_HLPREARLEFT 114           //"Show Rear View (Left Window)"
#define TXT_JOYMOUSESETTINGS TXT(115) //"Joystick-Mouse settings"
#define TXI_HLPREARRIGHT 116          //"Show Rear View (Right Window)"
#define TXT_HUDSAY TXT(117)           //"%s says: %s"
#define TXT_MESSAGE TXT(118)          //"Message: %s"
#define TXT_KEYSETTINGS TXT(119)      //""
#define TXT_INV TXT(120)              //"inv"
#define TXT_CLK TXT(121)              //"clk"
#define TXT_WPNSELBTN TXT(122)        //"%s-disabled"
#define TXT_INITDATA TXT(123)         //"Loading data..."
#define TXT_INITTABLEERR TXT(124)     //"Couldn't successfully load the table files.  I'm shutting down!"
#define TXT_INITCOLLATING TXT(125)    //"Collating..."
#define TXT_LEVELERRNEW TXT(126)      //"Don't know how to load level -- version number too new"
#define TXT_KEYCFGHELP TXT(127)       //"Select slot to configure for keyboard."
#define TXT_MENUNEWGAME TXT(128)      //"New Game"
#define TXT_MENUOPTIONS TXT(129)      //"Options"
#define TXT_MENUPILOTS TXT(130)       //"Pilots"
#define TXT_MENUMULTIPLAYER TXT(131)  //"Multiplayer"
#define TXT_MENUQUIT TXT(132)         //"Quit"
#define TXT_MENULOADMSN TXT(133)      //"Load Mission"
#define TXT_ERROR TXT(134)            //"Error"
#define TXT_ERRLOADMSN TXT(135)       //"Failed to load mission."
#define TXT_OPTCUSTKEYB TXT(136)      //"Customize Keyboard"
#define TXT_OPTCUSTCONT TXT(137)      //"Customize Game Controller"
#define TXT_OPTVIDEO TXT(138)         //"Video Settings"
#define TXT_OPTSOUND TXT(139)         //"Sound Settings"
#define TXT_OPTGENERAL TXT(140)       //"General Settings"
#define TXT_OPTDETAIL TXT(141)        //"Detail Level Settings"
#define TXT_DONE TXT(142)             //"Done"
#define TXT_CENTER TXT(143)           //"Center"
#define TXT_MSNERROR TXT(144)         //"Unable to find level file %s."
#define TXT_CFGHELP_KEYB TXT(145)     //"Keyboard"
#define TXT_MLTSHUTDOWN TXT(146)      //"Shutting down server!"
#define TXT_MLTLEAVEGAME TXT(147)     //"%s has left the game!"
#define TXT_MLTSERVERQUIT TXT(148)    //"The server quit!"
#define TXT_MLTDISCONNECT TXT(149)    //"%s disconnected!"
#define TXT_MLTLEVELNOMATCH TXT(150)  //"Levels don't match!"
#define TXT_MLTDISCFRMSERV TXT(151)   //"Disconnected from server!"
#define TXT_MLTCANTCONNECT TXT(152)   //"Can't connect. Reason: %s"
#define TXT_MLTNORESPONSE TXT(153)    //"No response from server"
#define TXT_MLTWAITSERVER TXT(154)    //"Waiting for server..."
#define TXT_MLTNOLEVELINFO TXT(155)   //"Couldn't get level info from server!"
#define TXI_MLTOK 156                 //"OK!"
#define TXI_MLTNOTSERV 157            //"Not server"
#define TXI_MLTDORK 158               //"You're a dork"
#define TXI_MLTNOTENOUGHSTR 159       //"Not enough start positions"
#define TXI_MLTGAMEFULL 160           //"All Full!"
#define TXT_MULTIPLAYER TXT(161)      //"Multiplayer"
#define TXT_MLTCHOOSETYPE TXT(162)    //"Choose Game Type"
#define TXT_MLTNOMULTI TXT(163)       //"No Multiplayer Files Found!"
#define TXT_WPNSELPREC TXT(164)       //"Weapon Selection Precedence"
#define TXT_SPACETOCONT TXT(165)      //"Press space bar to continue..."
#define TXI_SCRNNONE 166              //"None"
#define TXI_SCRNFEEBLE 167            //"Feeble"
#define TXI_SCRNPOOR 168              //"Poor"
#define TXI_SCRNAVG 169               //"Average"
#define TXI_SCRNGOOD 170              //"Good"
#define TXI_SCRNEXCELLENT 171         //"Excellent"
#define TXI_SCRNSUPREME 172           //"Supreme"
#define TXT_TCPLEASEWAIT TXT(173)     //"Please wait...Initializing"
#define TXT_TCMAINMENU TXT(174)       //"Main Menu"
#define TXT_TCBRIEFINGS TXT(175)      //"Briefings"
#define TXT_TCAUTOMAP TXT(176)        //"AutoMap"
#define TXI_WPN_LASER 177             //"Laser"
#define TXI_WPN_VAUSS 178             //"Vauss"
#define TXI_WPN_MICROWAVE 179         //"Microwave"
#define TXI_WPN_PLASMA 180            //"Plasma"
#define TXI_WPN_FUSION 181            //"Fusion"
#define TXI_WPN_SUPLASER 182          //"Super Laser"
#define TXI_WPN_MASSDRIVER 183        //"Mass Driver"
#define TXI_WPN_NAPALM 184            //"Napalm"
#define TXI_WPN_EMDGUN 185            //"EMD Gun"
#define TXI_WPN_OMEGA 186             //"Omega"
#define TXI_WPN_CONCUSSION 187        //"Concussion"
#define TXI_WPN_HOMING 188            //"Homing"
#define TXI_WPN_IMPACT 189            //"Impact Mortar"
#define TXI_WPN_SMART 190             //"Smart"
#define TXI_WPN_MEGA 191              //"Mega"
#define TXI_WPN_FRAG 192              //"Frag"
#define TXI_WPN_GUIDED 193            //"Guided"
#define TXI_WPN_NAPALMR 194           //"Napalm Rocket"
#define TXI_WPN_CYCLONE 195           //"Cyclone"
#define TXI_WPN_BLACKSHARK 196        //"Black Shark"
#define TXI_WPN_YELL_FLARE 197        //"Yellow Flare"
#define TXI_WPNC_LASER_1 198          //"Laser"
#define TXI_WPNC_LASER_2 199          //""
#define TXI_WPNC_VAUSS_1 200          //"Vauss"
#define TXI_WPNC_VAUSS_2 201          //""
#define TXI_WPNC_MICRO_1 202          //"Micro-"
#define TXI_WPNC_MICRO_2 203          //"wave"
#define TXI_WPNC_PLASMA_1 204         //"Plasma"
#define TXI_WPNC_PLASMA_2 205         //""
#define TXI_WPNC_FUSION_1 206         //"Fusion"
#define TXI_WPNC_FUSION_2 207         //""
#define TXI_WPNC_SUPLAS_1 208         //"Super"
#define TXI_WPNC_SUPLAS_2 209         //"Laser"
#define TXI_WPNC_MASSD_1 210          //"Mass"
#define TXI_WPNC_MASSD_2 211          //"Driver"
#define TXI_WPNC_NAPALM_1 212         //"Napalm"
#define TXI_WPNC_NAPALM_2 213         //""
#define TXI_WPNC_EMD_1 214            //"EMD"
#define TXI_WPNC_EMD_2 215            //"Gun"
#define TXI_WPNC_OMEGA_1 216          //"Omega"
#define TXI_WPNC_OMEGA_2 217          //""
#define TXI_WPNC_CONC_1 218           //"Concussn"
#define TXI_WPNC_CONC_2 219           //""
#define TXI_WPNC_HOMING_1 220         //"Homing"
#define TXI_WPNC_HOMING_2 221         //""
#define TXI_WPNC_IMPACT_1 222         //"Impact"
#define TXI_WPNC_IMPACT_2 223         //"Mortar"
#define TXI_WPNC_SMART_1 224          //"Smart"
#define TXI_WPNC_SMART_2 225          //""
#define TXI_WPNC_MEGA_1 226           //"Mega"
#define TXI_WPNC_MEGA_2 227           //""
#define TXI_WPNC_FRAG_1 228           //"Frag"
#define TXI_WPNC_FRAG_2 229           //""
#define TXI_WPNC_GUID_1 230           //"Guided"
#define TXI_WPNC_GUID_2 231           //""
#define TXI_WPNC_NAPALMR_1 232        //"Napalm"
#define TXI_WPNC_NAPALMR_2 233        //"Rocket"
#define TXI_WPNC_CYCLONE_1 234        //"Cyclone"
#define TXI_WPNC_CYCLONE_2 235        //""
#define TXI_WPNC_BLKSHRK_1 236        //"Black"
#define TXI_WPNC_BLKSHRK_2 237        //"Shark"
#define TXI_WPNC_YELFLARE_1 238       //"Yellow"
#define TXI_WPNC_YELFLARE_2 239       //"Flare"
#define TXT_WPNNOTAVAIL TXT(240)      //"That weapon is not available."
#define TXT_OBJECTIVES1 TXT(241)      //"Objectives" *not the one used in telcom*
#define TXT_WPNSELECT TXT(242)        //"%s selected."
#define TXT_WPNNONRG TXT(243)         //"Not enough energy available to fire this weapon!"
#define TXT_WPNNOAMMO TXT(244)        //"Not enough ammo available to fire this weapon!"
#define TXT_WPNNOPROJ TXT(245)        //"Not enough projectiles available!"
#define TXT_WPNFLARENONRG TXT(246)    //"Not enough energy available to fire flare!"
#define TXT_MLTDISCONNECTED TXT(247)  //""%s disconnected!"
#define TXT_PLRACCURACY TXT(248)      //"Accuracy rating:"
#define TXT_PLRSHIELD TXT(249)        //"Shield rating:"
#define TXT_PLRENERGY TXT(250)        //"Energy rating"
#define TXT_PLRENEMIESKILL TXT(251)   //"Enemies killed:"
#define TXT_PLRMINEEXPLORE TXT(252)   //"Mine explored:"
#define TXT_PLRTIME TXT(253)          //"Time played:"
#define TXT_PLRSAVERESRAT TXT(254)    //"Save/Restore ratio:"
#define TXT_PLRTITLE TXT(255)         //"Pilot Performance Review"
#define TXT_PLRSUCCESS TXT(256)       //"Success"
#define TXT_PLRFAILED TXT(257)        //"Failed"
#define TXI_KB_FIREPRIMARY 258        //"Fire Primary\t\t"
#define TXI_KB_FIRESECONDARY 259      //"Fire Secondary\t\t"
#define TXI_KB_ACCELERATE 260         //"Accelerate\t\t\t"
#define TXI_KB_REVERSE 261            //"Reverse\t\t\t"
#define TXI_KB_SLIDEHORIZ 262         //"Slide Horizontal\t\t"
#define TXI_KB_SLIDELEFT 263          //"Slide Left\t\t\t"
#define TXI_KB_SLIDERIGHT 264         //"Slide Right\t\t\t"
#define TXI_KB_SLIDEVERT 265          //"Slide Vertical\t\t"
#define TXI_KB_SLIDEUP 266            //"Slide Up\t\t\t"
#define TXI_KB_SLIDEDOWN 267          //"Slide Down\t\t\t"
#define TXI_KB_BANKLEFT 268           //"Bank Left\t\t\t"
#define TXI_KB_BANKRIGHT 269          //"Bank Right\t\t\t"
#define TXI_KB_PITCHUP 270            //"Pitch Up\t\t\t"
#define TXI_KB_PITCHDOWN 271          //"Pitch Down\t\t\t"
#define TXI_KB_TURNLEFT 272           //"Turn Left\t\t\t"
#define TXI_KB_TURNRIGHT 273          //"Turn Right\t\t\t"
#define TXI_KB_FIREFLARE 274          //"Fire Flare\t\t\t"
#define TXI_KB_TOGGLESLIDE 275        //"Toggle Slide\t\t"
#define TXI_KB_TOGGLEBANK 276         //"Toggle Bank\t\t\t"
#define TXI_KB_HEADING 277            //"Heading\t\t\t"
#define TXI_KB_PITCH 278              //"Pitch\t\t\t\t"
#define TXI_KB_THROTTLE 279           //"Throttle\t\t\t"
#define TXI_KB_FORWARD 280            //"Forward\t\t\t"
#define TXI_KB_BANK 281               //"Bank\t\t\t\t"
#define TXI_KB_AFTERBURN 282          //"Afterburner\t\t\t"
#define TXI_KB_AUTOMAP 283            //"Automap\t\t\t"
#define TXT_QUIT TXT(284)             //"Quit"
#define TXT_COMPLETED_HUD TXT(285)    //"Completed"
#define TXT_SNDMUSVOL TXT(286)        //"Music Volume"
#define TXT_SNDMIXER TXT(287)         //"Sound Mixer"
#define TXT_SNDM_SOFT TXT(288)        //"Software"
#define TXT_SNDM_DSND8 TXT(289)       //"DirectSound 8Bit"
#define TXT_SNDM_DS3D TXT(290)        //"DS3D"
#define TXT_SNDM_AUREAL TXT(291)      //"Aureal"
#define TXT_SNDQUALITY TXT(292)       //"Sound Quality"
#define TXT_SNDHIGH TXT(293)          //"High"
#define TXT_SNDNORMAL TXT(294)        //"Normal"
#define TXT_OPTHUD TXT(295)           //"Customize Hud"
#define TXT_CFGHELP_JOY TXT(296)      //"Joystick Handle"
#define TXT_TEXT TXT(297)             //"Text"
#define TXT_GRAPHICAL TXT(298)        //"Graphical"
#define TXT_HUDSHIPSTATUS TXT(299)    //"Ship Status"
#define TXT_HUDSHIELDENERGY TXT(300)  //"Shield/Energy"
#define TXT_HUDWEAPONS TXT(301)       //"Weapon Layout"
#define TXT_HUDAFTERBURN TXT(302)     //"Afterburner"
#define TXT_HUDGOALSTOGGLE TXT(303)   //"Goals"
#define TXT_HUDMISSIONSTATUS TXT(304) //"Mission Status"
#define TXT_HUDINVENTORY TXT(305)     //"Inventory"
#define TXT_CFGHELP_BTNS TXT(306)     //"Joystick, mouse buttons or hat."
#define TXT_SPECMAPPING TXT(307)      //"Specular Mapping"
#define TXT_CFG_BIND_1 TXT(308)       //"Bind 1: %s"
#define TXT_CFG_BIND_2 TXT(309)       //"Bind 2: %s"
#define TXT_SNDM_DSND16 TXT(310)      //"DirectSound 16Bit"
#define TXT_HUDCNTRMEASURE TXT(311)   //"Countermeasures"
#define TXT_HUDITM_ANTIGRAV TXT(312)  //"ANTIGRAV FAIL"
#define TXT_HUDITM_LOCK TXT(313)      //"LOCK"
#define TXT_CFG_CLEAR TXT(314)        //"Clear"
#define TXT_TCCARGO TXT(315)          //"Cargo"
#define TXT_ALL TXT(316)              //"All"
#define TXT_WARNINGS TXT(317)         //"Warnings"
#define TXT_IMPORTIFL TXT(318)        //"Import IFL File"
#define TXT_SELECTSHIP TXT(319)       //"Select Ship"
#define TXT_SHIPDISPLAY TXT(320)      //"Ship Display"
#define TXT_SHIPS TXT(321)            //"Ships"
#define TXT_CUSTOMTEXTURES TXT(322)   //"Custom Textures"
#define TXT_CHOOSE TXT(323)           //"Choose"
#define TXT_SUCCESS TXT(324)          //"Success"
#define TXT_ERRORIMPORT TXT(325)      //"There was an error importing"
#define TXT_SUCCESSIMPORT TXT(326)    //"Animated Bitmap Successfully Imported"
#define TXT_CUSTOMLOGO TXT(327)       //"Custom Logo"
#define TXT_SHIPCUSTOMIZE TXT(328)    //"SHIP CONFIGURATION"
#define TXT_UPTOPARENTDIR TXT(329)    //"Up To Parent Directory"
#define TXT_ERRCHOOSEFILE TXT(330)    //"You Must Select A Filename"
#define TXT_ERRFILENOTEXIST TXT(331)  //"File Does Not Exist"
#define TXT_ERRPATHNOTVALID TXT(332)  //"Invalid Path/Directory"
#define TXT_ILLEGALSAVEGAME TXT(333)  //"Illegal savegame file"
#define TXT_SAVEGAMEFAILED TXT(334)   //"Unable to save current game."
#define TXT_LOADGAMEFAILED TXT(335)   //"Unable to load game."
#define TXT_EMPTY TXT(336)            //"Empty"
#define TXT_ERRCREATEDIR TXT(337)     //"Unable to create directory."
#define TXT_ERRNOSAVEGAMES TXT(338)   //"There are no savegames to load."
#define TXT_NOMISSIONS TXT(339)       //"There are no valid missions in the missions directory."
#define TXT_LOADGAME TXT(340)         //"Load Game"
#define TXT_SAVEGAME TXT(341)         //"Save Game"
#define TXT_DESCRIPTION TXT(342)      //"Description"
#define TXT_FASTHEADLIGHT TXT(343)    //"Fast Headlight"
#define TXT_MIRRORSURF TXT(344)       //"Mirrored Surfaces"
#define TXI_KB_PREVINV 345            //"Prev Inven Item"
#define TXI_KB_NEXTINV 346            //"Next Inven Item"
#define TXI_KB_INVUSE 347             //"Use Inven Item"
#define TXI_KB_PREVCNTMS 348          //"Prev Counter Meas"
#define TXI_KB_NEXTCNTMS 349          //"Next Counter Meas"
#define TXI_KB_CNTMSUSE 350           //"Use Counter Meas"
#define TXT_SENSITIVITY TXT(351)      //"Sensitivity"
#define TXT_MSESENS TXT(352)          //"Mouse Sensitivity"
#define TXI_KB_HEADLIGHT 353          //"Headlight"
#define TXI_HLPALTF2 354              //"Alt-F2"
#define TXI_HLPSAVEGAME 355           //"Save Game"
#define TXI_HLPALTF3 356              //"Alt-F3"
#define TXI_HLPLOADGAME 357           //"Load Game"
#define TXI_HLPF4 358                 //"F4"
#define TXI_HLPGUIDEBOT 359           //"GuideBot Menu"
#define TXI_HLP1_5 360                //"1-5"
#define TXI_HLPSELPRIM 361            //"Select Primary Weapon"
#define TXI_HLP6_0 362                //"6-0"
#define TXI_HLPSELSECN 363            //"Select Secondary Weapon"
#define TXT_WRONGVERSION TXT(364)     //"Not available in this version."
#define TXT_SETDEFAULT TXT(365)       //"%s Set as Default"
#define TXT_SETITEMDEFAULT TXT(366)   //"Set Selected as Default"
#define TXT_REALHELP TXT(367)         //"Help"
#define TXT_LBNONE TXT(368)           //"[None]"
#define TXT_SAVE TXT(369)             //"Save"
#define TXT_OPEN TXT(370)             //"Open"
#define TXT_MULTINOFILES TXT(371)     //"No Multiplayer Files Found!"
#define TXT_MULTISAVESET TXT(372)     //"Save Multiplayer Settings"
#define TXT_MULTILOADSET TXT(373)     //"Load Multiplayer Settings"
#define TXT_ALLOWEDITEMS TXT(374)     //"Allowed items"
#define TXT_DISALLOWEDITEM TXT(375)   //"Disallowed items"
#define TXT_ALLOWEDSHIPS TXT(376)     //"Allowed Ships"
#define TXT_DISALLOWDSHIPS TXT(377)   //"Disallowed Ships"
#define TXT_ALLOW TXT(378)            //"Allow"
#define TXT_DISALLOW TXT(379)         //"Disallow"
#define TXT_SHIPSALLOWED TXT(380)     //"Ships Allowed:"
#define TXT_WPNCFGHELP0 TXT(381)      //"Select weapon to switch that slot with another weapon."
#define TXT_WPNCFGHELP1 TXT(382)   //"To disable a weapon, click on the 'X' button or use CTRL-C on highlighted weapon."
#define TXT_CFGHELP_TEXT TXT(383)  //"%s may be configured using"
#define TXT_WPNCFGHELP3 TXT(384)   //"Select weapon you want to switch precedence for:"
#define TXT_WPNSELDISABLE TXT(385) //"Disable/Enable Slot"
#define TXT_PRIMARY TXT(386)       //"Primary"
#define TXT_SECONDARY TXT(387)     //"Secondary"
#define TXT_LOWPRIORITY TXT(388)   //"Low Priority"
#define TXT_HIGHPRIORITY TXT(389)  //"High Priority"
#define TXI_F5 390                 //"F5"
#define TXI_TOGGLEDEMO 391         //"Toggle Demo"
#define TXI_KB_WPNPCYCLE 392       //"Cycle Primary"
#define TXI_KB_WPNSCYCLE 393       //"Cycle Secondary"
#define TXT_MENUCREDITS TXT(394)   //"Credits"
#define TXT_CFG_INVERT TXT(395)    //"Invert"
#define TXT_RESETTODEFAULT TXT(396)          //"Reset to Default Settings"
#define TXI_F6 397                           //"F6"
#define TXI_MLTMENU 398                      //"Multi On-Screen Menu"
#define TXT_VIEWDEMO TXT(399)                //"View Demo (main menu)"
#define TXT_RECORDINGDEMO TXT(400)           //"Recording Demo (hud)"
#define TXT_PLAYINGDEMO TXT(401)             //"Playing Demo (hud)"
#define TXT_DEMOFILENAME TXT(402)            //"Demo FileName"
#define TXT_CANTSAVEDEMO TXT(403)            //"Unable to save demo file!"
#define TXT_DEMOSAVED TXT(404)               //"Demo file saved!"
#define TXI_TCMM_GOALS 405                   //"Goal Status"
#define TXT_DEMOCANTCREATE TXT(406)          //"Unable to create demo file!"
#define TXT_CANTLOAD TXT(407)                //"Unable to load demo file!"
#define TXT_BADDEMOFILE TXT(408)             //"Bad Demo file, unable to read."
#define TXT_MINFPS TXT(409)                  //"Min. FPS: %.2f"
#define TXT_MAXFPS TXT(410)                  //"Max. FPS: %.2f"
#define TXT_AVGFSP TXT(411)                  //"Avg. FPS: %.2f"
#define TXT_PLAYLOOPING TXT(412)             //"Play Looping"
#define TXT_DEMOPAUSED TXT(413)              //"Demo Playback Paused"
#define TXT_DOWNLOADPROMPT TXT(414)          //"Would you like to download it?"
#define TXT_DONTHAVEMSN TXT(415)             //"You do not have this mission installed."
#define TXT_DOWNLOADMSN TXT(416)             //"Download Mission"
#define TXT_FMTDOWNLOADING TXT(417)          //"Downloading: %s"
#define TXT_FMTRECEIVED TXT(418)             //"Received: %d"
#define TXT_FMTTOTAL TXT(419)                //"Total: %d"
#define TXT_FMTTIMEELAPSED TXT(420)          //"Time Elapsed: %s"
#define TXT_FMTTIMELEFT TXT(421)             //"Time Left: %s"
#define TXT_FMTXFERRATE TXT(422)             //"Transfer Rate: %d Bytes/Second"
#define TXT_FMTCANTDNLD TXT(423)             //"Unable to download the selected mission!"
#define TXT_FMTTIMEHOUR TXT(424)             //"%d hr. "
#define TXT_FMTTIMEMIN TXT(425)              //"%d min. "
#define TXT_FMTTIMESEC TXT(426)              //"%d sec. "
#define TXT_GEN_EXIT TXT(427)                //"Exit"
#define TXT_GEN_MPLYROPTIONS TXT(428)        //"Multiplayer Options"
#define TXT_GEN_TIMELIMIT TXT(429)           //"Time Limit"
#define TXT_GEN_KILLGOAL TXT(430)            //"Goal Limit"
#define TXT_GEN_PPS TXT(431)                 //"Packets per second"
#define TXT_GEN_CFGALLOWEDSHIP TXT(432)      //"Configure Allowed Ships/Items"
#define TXT_GEN_SERVERMODE TXT(433)          //"Server mode"
#define TXT_GEN_CLIENTSERVER TXT(434)        //"Client/Server"
#define TXT_GEN_PEERPEER TXT(435)            //"Peer-Peer"
#define TXT_GEN_RESPAWNRATE TXT(436)         //"Respawn Rate"
#define TXT_GEN_USEROTVEL TXT(437)           //"Use rotational velocity"
#define TXT_GEN_USESMOOTHING TXT(438)        //"Movement averaging"
#define TXT_GEN_MAXPLAYERS TXT(439)          //"Max. Players"
#define TXT_GEN_ACC_WEAP_COLL TXT(440)       //"%c Use Accurate weapon collisions"
#define TXT_GEN_BRIGHT_PLAYERS TXT(441)      //"Bright player ships"
#define TXT_MAX_TERRAIN_DIST TXT(442)        //"Max terrain distance"
#define TXT_FIELD_OF_VIEW TXT(443)           //"Field of view"
#define TXT_GEN_PERMISSABLE_CS TXT(444)      //"Permissable client server"
#define TXT_AUTO_GAMMA TXT(445)              //"Auto gamma"
#define TXT_MULTIPLAYER_TAUNTS TXT(446)      //" Multiplayer taunt macros"
#define TXT_TAUNT_NUMBER TXT(447)            //""
#define TXT_TAUNT_TEXT 448                   //" Note!  This is not like the others!"
#define TXT_TAUNT_TEXTA 449                  //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_TAUNT_TEXTB 450                  //" Note!  This is not like the others!"
#define TXT_TAUNT_TEXTC 451                  //" Note!  This is not like the others!"
#define TXT_TAUNT_TEXTD 452                  //" Note!  This is not like the others!"
#define TXT_TAUNT_TEXTE 453                  //" Note!  This is not like the others!"
#define TXT_TAUNT_TEXTF 454                  //" Note!  This is not like the others!"
#define TXT_TAUNT_TEXTG 455                  //" Note!  This is not like the others!"
#define TXT_FILENOTFOUND TXT(456)            //"File Not Found"
#define TXT_NOTRIFF TXT(457)                 //"File Not In RIFF Format"
#define TXT_NOTWAVE TXT(458)                 //"File Not A WAVE "
#define TXT_INVALIDFILE TXT(459)             //"Invalid File"
#define TXT_FORMATNOTSUPPORTED TXT(460)      //"File Format Not Supported"
#define TXT_MUSTBEMONO TXT(461)              //"WAV Must Be In Mono Format"
#define TXT_BADSAMPLERATE TXT(462)           //"WAV Must Have 22,050 Sample Rate"
#define TXT_BADBITDEPTH TXT(463)             //"Invalid Bit Depth, Must Be 8 or 16"
#define TXT_NODATAINWAVE TXT(464)            //"No Data Found In WAV"
#define TXT_OSFALREADYEXISTS TXT(465)        //"OSF File Already Exists, Can't Overwrite"
#define TXT_INTERNALERROR TXT(466)           //"Internal Error"
#define TXT_COMPRESSFAIL TXT(467)            //"Compression Failure"
#define TXT_OUTOFMEMORY TXT(468)             //"Out of Memory"
#define TXT_CANTOPENOSF TXT(469)             //"Can't Open OSF For Writing"
#define TXT_NOERROR TXT(470)                 //"No Error"
#define TXT_GAMMAADJUSTA TXT(471)            //"Adjust the gamma slider so that the dark"
#define TXT_GAMMAADJUSTB TXT(472)            //"grey box above is barely visible inside the black box"
#define TXT_CFG_BITDEPTH TXT(473)            //"Bit Depth"
#define TXT_CFG_SIXTEENBIT TXT(474)          //"16 Bit"
#define TXT_CFG_THIRTYTWOBIT TXT(475)        //"32 Bit"
#define TXT_CFG_VSYNCENABLED TXT(476)        //"Vsync Enabled"
#define TXT_SNDM_CREATIVEEAX TXT(477)        //"Creative EAX"
#define TXT_CFG_MEDIUM TXT(478)              //"Medium"
#define TXT_CFG_MOUSEENABLED TXT(479)        //"Mouse"
#define TXT_CFG_CONTROLLERENABLED TXT(480)   //"Controller Enabled"
#define TXT_CFG_JOYSENSITIVITY TXT(481)      //"Joystick %c Sensitivity"
#define TXT_CFG_MOUSESENSITIVITY TXT(482)    //"Mouse %c Sensitivity"
#define TXT_CFG_CONFIGFORCEFEEDBACK TXT(483) //"Config ForceFeedback"
#define TXT_CFG_PRESETDETAILS TXT(484)       //"Preset Details"
#define TXT_LOW TXT(485)                     //"Low"
#define TXT_CFG_VERYHIGH TXT(486)            //"Very High"
#define TXT_CFG_CUSTOM TXT(487)              //"Custom"
#define TXT_CFG_OBJECTCOMPLEXITY TXT(488)    //"Object Complexity"
#define TXT_CFG_ENABLEFOG TXT(489)           //"Enable Fog"
#define TXT_CFG_ENABLELIGHTCORONA TXT(490)   //"Enable Light Coronas"
#define TXT_CFG_PROCEDURALS TXT(491)         //"Use Procedural Textures"
#define TXT_CFG_POWERUPHALOS TXT(492)        //"Powerup Halos"
#define TXT_CFG_SCORCHMARKS TXT(493)         //"Scorch Marks"
#define TXT_CFG_WEAPONEFFECTS TXT(494)       //"Weapon Effects"
#define TXT_TITLE_FORCEFEEDBACK TXT(495)     //"Force Feedback"
#define TXT_CFG_FFENABLED TXT(496)           //"Force Feedback Enabled"
#define TXT_CFG_FFAUTOCENTER TXT(497)        //"Controller AutoCenter"
#define TXT_CFG_FORCEGAIN TXT(498)           //"Force Gain"
#define TXT_CFG_HIGH TXT(499)                //"High"
#define TXT_HEADLIGHTTURNED TXT(500)         //"Headlight turned %s."
#define TXT_STRING_ON TXT(501)               //"on"
#define TXT_STRING_OFF TXT(502)              //"off"
#define TXT_REARVIEW TXT(503)                //"rear view"
#define TXT_JOYENABLED TXT(504)              //"Joystick"
#define TXT_DS_COULDNTINIT TXT(505)          //"Couldn't initialize connection '%s' DLL.\n"
#define TXT_DS_DLLINIT TXT(506)              //"Connection DLL initialized.\n"
#define TXT_DS_CONNECTLOADERR TXT(507)       //"Error loading connection dll '%s'.\n"
#define TXT_DS_LOADMISSIONERR TXT(508)       //"Couldn't load mission '%s' for dedicated server.\n"
#define TXT_DS_MISSIONLOADED TXT(509)        //"Mission '%s' loaded successfully.\n"
#define TXT_DS_SERVERNAME TXT(510)           //"-Server-"
#define TXT_DS_BADCOMMANDLINE TXT(511)       //"Bad command line\n"
#define TXT_DS_MISSINGCONFIG TXT(512)        //"Missing server config filename\n"
#define TXT_DS_BADCONFIG TXT(513)            //"Unable to open server config '%s' or bad file.\n"
#define TXT_DS_SETTINGSLOADED TXT(514)       //"Settings file loaded successfully.\n"
#define TXT_DS_SETTINGSERR TXT(515)          //"Settings file failed to load.\n"
#define TXT_DS_DISALLOWOBJECT TXT(516)       //"Disallowing objected named %s."
#define TXT_DS_ALLOWOBJECTS TXT(517)         //"Allowing objected named %s."
#define TXT_DS_VARSET TXT(518)               //"Setting '%s' variable to %s.\n"
#define TXT_DS_BADCOMMAND TXT(519)           //"Unrecognized command or bad format.\n"
#define TXT_DS_ENTERPASS TXT(520)            //"Enter Password:"
#define TXT_DS_REJECTREMOTE TXT(521)         //"Rejecting connection from remote host! (%s)\n"
#define TXT_DS_NEWCONNECT TXT(522)           //"New connection (%s)\n"
#define TXT_DS_REMOTECLOSE TXT(523)          //"Remote host %s closed the connection.\n"
#define TXT_DS_REMOTELOGGEDIN TXT(524)       //"Remote host %s logged in.\n"
#define TXT_DS_BADPASS TXT(525)              //"Invalid login password from %s.\n"
#define TXT_DEMO_PLAY_OPTIONS TXT(526)       //"Demo Playback options"
#define TXT_LOADMODULEERR TXT(527)           //"Couldn't Load Module"
#define TXT_INITMODULEERR TXT(528)           //"Couldn't Initialize Game Module"
#define TXT_CHEATATTEMPT TXT(529)            //"%s is attempting to cheat!!!"
#define TXT_LAMER TXT(530)                   //"Lamer!"
#define TXT_FRAMETIMEMSG TXT(531)            //"Frame time: %s"
#define TXT_ENABLED TXT(532)                 //"Enabled"
#define TXT_DISABLED TXT(533)                //"Disabled"
#define TXT_COOLTEXTURES TXT(534)            //"Cool Textures!!"
#define TXT_NORMALTEXTURES TXT(535)          //"Textures Back To Normal"
#define TXT_INVULNCHEATON TXT(536)           //"Your mother wont protect you now!"
#define TXT_INVULNCHEAT TXT(537)             //"You're a wimp!"
#define TXT_CLOAKCHEATOFF TXT(538)           //"You escape the darkness!"
#define TXT_CLOAKCHEATON TXT(539)            //"You enter the darkness!"
#define TXT_ALLWEAPONS TXT(540)              //"All weapons!"
#define TXT_ALLROBOTSDEAD TXT(541)           //"All robots dead!"
#define TXT_NOPAUSEINMULTI TXT(542)          //"You cannot pause in a multiplayer game"
#define TXT_PRESSOKTOCONT TXT(543)           //"The game is paused. Press OK to resume."
#define TXT_CONFIRM TXT(544)                 //"Confirm"
#define TXT_CONFIRMEXIT TXT(545)             //"Are You Sure You Want To Exit?"
#define TXT_NOCOCKPIT TXT(546)               //"This ship does not have a cockpit!"
#define TXT_HUD_GUIDED TXT(547)              //"guided"
#define TXT_HUD_ZOOM TXT(548)                //"zoom view"
#define TXT_HUD_ZOOM_UNITS TXT(549)          //"%.1f units"
#define TXT_HUD_SHIELDS TXT(550)             //"Shields: %03d"
#define TXT_HUD_ENERGY TXT(551)              //"Energy: %03d"
#define TXT_HUD_AFTERBURNER TXT(552)         //"Afterburner: %d%%"
#define TXT_HUD_INVULN TXT(553)              //"Invulnerable"
#define TXT_HUD_CLOAKED TXT(554)             //"Cloaked"
#define TXT_HUD_TEAMSAY TXT(555)             //"Team Say: %s"
#define TXT_HUD_MARKER TXT(556)              //"Marker: %s"
#define TXT_HUD_GAMEMESSAGES TXT(557)        //"Game Messages"
#define TXT_SHUTTINGDOWN TXT(558)            //"Shutting down!"
#define TXT_INVALIDTEAMCOUNT TXT(559)        // Invalid team count
#define TXT_DS_OPENLEVEL TXT(560)            //"Opening level '%s'...\n"
#define TXT_LEVELSELECT TXT(561)             //"Level Select"
#define TXT_LEVELSELECTB TXT(562)            //"Please select a level to start at (1 to %d)"
#define TXT_LEVELWARP TXT(563)               //"Level Warp"
#define TXT_LEVELWARPB TXT(564)              //"Please select a level to warp to (1 to %d)"
#define TXT_SELECT TXT(565)                  //"Select"
#define TXT_CHOOSELEVEL TXT(566)             //"Please choose a level between 1 and %d"
#define TXT_MISSIONNOTFOUND TXT(567)         //"Mission file not found"
#define TXT_DS_LEVELLOADSTATUS TXT(568)      //"%s %.0f Percent Complete\n"
#define TXT_LL_ROOMSLOADED TXT(569)          //"All rooms loaded"
#define TXT_LL_OBJECTSLOADED TXT(570)        //"Level objects loaded"
#define TXT_LL_PAGINGDATA TXT(571)           //"Paging data..."
#define TXT_DS_MISSIONDONE TXT(572)          //"Mission over.  Looping back to first level in mission file.\n"
#define TXT_LL_SCRIPTLOADED TXT(573)         //"Level script loaded"
#define TXT_LL_TERRAIN TXT(574)              //"Terrain loaded"
#define TXT_MD_DOWNLOADSTATUS TXT(575)       //"Download Status"
#define TXT_MULTI_DATACORRUPT TXT(576)       //"Network data corruption detected!"
#define TXT_MULTI_SERVERCHANGEA TXT(577)     //"Server changed levels"
#define TXT_MULTI_SERVERCHANGEB TXT(578)     //"Please try rejoining"
#define TXT_DS_ENDINGLEVEL TXT(579)          //"Ending level.\n"
#define TXT_MULTI_CORRUPTOBJ TXT(580)        //"Corrupted object received!\n"
#define TXT_NOTENOUGHSHIELDSFOROBS TXT(581)  //"Not enough shields to set observer!"
#define TXT_MULTI_CONNECTING TXT(582)        //"Connecting..."
#define TXT_CLOSE TXT(583)                   //"Close"
#define TXI_MSG_HAVEVAUSS 584                //"You already have the Vauss"
#define TXI_MSG_VAUSS 585                    //"Vauss!"
#define TXI_MSG_NAPALMHAVE 586               //"You already have the Napalm Gun"
#define TXI_MSG_NAPALM 587                   //"Napalm Gun!"
#define TXI_MSG_EMDALREADYHAVE 588           //"You already have the EMD Launcher"
#define TXI_MSG_EMD 589                      //"EMD Launcher!"
#define TXI_MSG_MICROWAVEHAVE 590            //"You already have the Microwave Cannon"
#define TXI_MSG_MICROWAVE 591                //"Microwave Cannon!"
#define TXI_MSG_MASSALREADYHAVE 592          //"You already have the Mass Driver"
#define TXI_MSG_MASSDRIVER 593               //"Mass Driver!"
#define TXI_MSG_SUPERLHAVE 594               //"You already have the Super Laser"
#define TXI_MSG_SUPERLASER 595               //"Super Laser!"
#define TXI_MSG_PLASMAHAVE 596               //"You already have the Plasma Cannon"
#define TXI_MSG_PLASMA 597                   //"Plasma Cannon!"
#define TXI_MSG_FUSIONHAVE 598               //"You already have the Fusion Cannon"
#define TXI_MSG_FUSION 599                   //"Fusion Cannon!"
#define TXI_MSG_OMEGAHAVE 600                //"You already have the Omega Cannon"
#define TXI_MSG_OMEGA 601                    //"Omega Cannon!"
#define TXI_MSG_FRAG 602                     //"Frag Missile!"
#define TXI_MSG_FRAGFULL 603                 //"Frag Missiles Full"
#define TXI_MSG_IMPACTM 604                  //"Impact Mortar!"
#define TXI_MSG_IMPACTMFULL 605              //"Impact Mortars Full"
#define TXI_MSG_NAPALMR 606                  //"Napalm Rocket!"
#define TXI_MSG_NAPALMRFULL 607              //"Napalm Rockets Full"
#define TXI_MSG_CYCLONE 608                  //"Cyclone Missile!"
#define TXI_MSG_CYCLONEFULL 609              //"Cyclone Missiles Full"
#define TXI_MSG_BSHARK 610                   //"Black Shark Missile!"
#define TXI_MSG_BSHARKFULL 611               //"Black Shark Missiles Full"
#define TXI_MSG_CONC 612                     //"Concussion Missile!"
#define TXI_MSG_CONCFULL 613                 //"Concussion Missiles Full"
#define TXI_MSG_HOMING 614                   //"Homing Missile!"
#define TXI_MSG_HOMINGFULL 615               //"Homing Missiles Full"
#define TXI_MSG_SMART 616                    //"Smart Missile!"
#define TXI_MSG_SMARTFULL 617                //"Smart Missiles Full"
#define TXI_MSG_MEGA 618                     //"Mega Missile!"
#define TXI_MSG_MEGAFULL 619                 //"Mega Missiles Full"
#define TXI_MSG_GUIDED 620                   //"Guided Missile!"
#define TXI_MSG_GUIDEDFULL 621               //"Guided Missiles Full"
#define TXI_MSG_MULTI_HOMING 622             //"%d Homing Missiles!"
#define TXI_MSG_MULTI_CONC 623               //"%d Concussion Missiles!"
#define TXI_MSG_MULTI_FRAG 624               //"%d Frag Missiles!"
#define TXI_MSG_MULTI_GUIDED 625             //"%d Guided Missiles!"
#define TXI_MSG_VAUSSAMMO 626                //"%d Vauss rounds"
#define TXI_MSG_VAUSSFULL 627                //"Vauss Cannon full"
#define TXI_MSG_MASSAMMO 628                 //"%d Mass Driver rounds"
#define TXI_MSG_MASSFULL 629                 //"Mass Driver full"
#define TXI_MSG_NAPALMFUEL 630               //"%d.%d liters of Napalm fuel"
#define TXI_MSG_NAPALMFULL 631               //"Napalm Cannon full"
#define TXT_INVULNOFF TXT(632)               //"Invulnerability Off"
#define TXT_CLOAKOFF TXT(633)                //"Cloak off"
#define TXT_MSG_CLOAKOFF TXT(634)            //"Cloak Off"
#define TXT_MAXSHIELDS TXT(635)              //"Shields Full"
#define TXT_SHIELDBOOST TXT(636)             //"Shields boosted to %d!"
#define TXT_MSG_ENERGY TXT(637)              //"Energy!"
#define TXT_QUADLASER TXT(638)               //"Quad Lasers!"
#define TXT_MSG_QUADHAVE TXT(639)            //"You already have Quad Lasers"
#define TXT_INVULNON TXT(640)                //"Invulnerability On"
#define TXT_INVULNALREADY TXT(641)           //"You're already invulnerable"
#define TXT_CLOAKON TXT(642)                 //"Cloak On"
#define TXT_CLOAKALREADY TXT(643)            //"You already are cloaked"
#define TXT_CHAFF TXT(644)                   //"Chaff"
#define TXT_MSG_MULTI_CHAFFS TXT(645)        //"%d Chaffs"
#define TXT_COUNTERMEASUREFULL TXT(646)      //"Counter Measures Full"
#define TXT_CHAFFSFULL TXT(647)              //"You Can't Carry Any More Chaffs"
#define TXT_BETTY TXT(648)                   //"Bouncing Betty"
#define TXT_MSG_MULTI_BETTY TXT(649)         //"%d Bouncing Bettys"
#define TXT_BETTYFULL TXT(650)               //"You Can't Carry Any More Bettys"
#define TXT_SEEKERMINE TXT(651)              //"Seeker Mine"
#define TXT_MSG_MULTI_SEEKERS TXT(652)       //"%d Seeker Mines"
#define TXT_SEEKERFULL TXT(653)              //"You Can't Carry Any More Seeker Mines"
#define TXT_GUNBOY TXT(654)                  //"GunBoy"
#define TXT_MSG_MULTI_GUNBOY TXT(655)        //"%d GunBoys"
#define TXT_GUNBOYFULL TXT(656)              //"You Can't Carry Any More GunBoys"
#define TXT_AFTERBURNERCOOLER TXT(657)       //"Afterburner Cooler!"
#define TXT_ABCOOLERHAVE TXT(658)            //"You Already Have An Afterburner Cooler"
#define TXT_ETOSCONVERTER TXT(659)           //"Energy-Shields Converter!"
#define TXT_ETOSCONVHAVE TXT(660)            //"You Already Have A Energy-Shields Converter"
#define TXT_FULLMAP TXT(661)                 //"Full Map!"
#define TXT_GETTINGFILES TXT(662)            //"Getting Files..."
#define TXT_TIMEDEMO TXT(663)                //"Timedemo reports %.2f FPS"
#define TXT_ADD TXT(664)                     //"Add"
#define TXT_EDIT TXT(665)                    //"Edit"
#define TXT_OLDPILOTNOEXIST TXT(666)         //"Old Pilot No Longer Exists, Please Select A New One"
#define TXT_SELPILOTPIC TXT(667)             //"CHOOSE PILOT PICTURE"
#define TXT_PILOTPICTITLE TXT(668)           //"Select a pilot from"
#define TXT_COPYCONTB TXT(669)               //"which to copy the"
#define TXT_COPYCONTOLSC TXT(670)            //"control settings"
#define TXT_IMPORTGRAPHIC TXT(671)           //"Import Graphic"
#define TXT_PLAYSOUND TXT(672)               //"Play"
#define TXT_IMPORTSOUND TXT(673)             //"Import Sound"
#define TXT_AUDIOTAUNTA TXT(674)             //"Audio Taunt #1"
#define TXT_AUDIOTAUNTB TXT(675)             //"Audio Taunt #2"
#define TXT_WARNING TXT(676)                 //"Warning"
#define TXT_SHIPSELECTERR TXT(677)           //"The ship you have selected wasn't found, using default"
#define TXT_COMPRESSTOOBIG TXT(678)          //"Compressed File Can't Be larger than %dK"
#define TXT_AUDIOIMPORTSUC TXT(679)          //"Audio File Imported"
#define TXT_COPYTEMPERR TXT(680)             //"Unable to copy temp file"
#define TXT_CANTCREATECRC TXT(681)           //"Unable to create CRC File"
#define TXT_NOPICSAVAIL TXT(682)             //"There are no available\npictures for this pilot"
#define TXT_ERRCREATINGDIALOG TXT(683)       //"An Error Occured Creating Dialog"
#define TXT_PILOTPICTURE TXT(684)            //"Pilot Picture"
#define TXT_PICTURES TXT(685)                //"Pictures"
#define TXT_DISPLAY TXT(686)                 //"Display"
#define TXT_ENTEROBS TXT(687)                //"Entering observer mode."
#define TXT_PLYRENTEROBS TXT(688)            //"%s starts observing."
#define TXT_LEAVEOBS TXT(689)                //"Leaving observer mode."
#define TXT_PLYRLEAVEOBS TXT(690)            //"%s stops observing."
#define TXT_NEEDMOREENERGY TXT(691)          //"Need more than %d energy to enable transfer"
#define TXT_SHIELDSATMAX TXT(692)            //"No transfer: Shields already at max"
#define TXI_TCMM_BRIEFINGS 693               //"Briefings"
#define TXI_TCMM_CARGO 694                   //"Cargo"
#define TXI_TCMM_AUTOMAP 695                 //"AutoMap"
#define TXT_TCINITIALIZING TXT(696)          //"Please wait... Initializing"
#define TXT_TCSHUTDOWN TXT(697)              //"Telcom Shutting Down"
#define TXT_TCAM_TERRAIN TXT(698)            //"F1 - Turn terrain %s"
#define TXT_TCAM_INSTRUCTIONS TXT(699)       //"F2 - Center on player    F3 - Realign to gravity"
#define TXT_MULTI_RANKS 700                  //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_MULTI_RANKSA 701                 //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_MULTI_RANKSB 702                 //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_MULTI_RANKSC 703                 //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_MULTI_RANKSD 704                 //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_MULTI_RANKSE 705                 //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_MULTI_RANKSF 706                 //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_MULTI_RANKSG 707                 //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_MULTI_RANKSH 708                 //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_MULTI_RANKSI 709                 //" Note!  This is not like the others!put in to keep parser happy"
#define TXT_HAS_BEEN TXT(710)                // "has been"
#define TXT_PROMOTED TXT(711)                // "promoted to"
#define TXT_DEMOTED TXT(712)                 // "demoted to"
#define TXT_PROXMINE TXT(713)                //"Prox Mine"
#define TXT_PROXMINECOUNT TXT(714)           //"%d Prox Mines"
#define TXT_PROXMINEFULL TXT(715)            //"You Can't Carry Any More Prox Mines"
#define TXT_PLAY TXT(716)                    //"Play" (play game)
#define TXT_OPTCONFIG TXT(717)               //"Config" (options menu)
#define TXT_TOGGLES TXT(718)                 //"Toggles"
#define TXT_GEOMETRY TXT(719)                // "Geometry"
#define TXT_MONITOR TXT(720)                 // "Monitor options"
#define TXT_CONTAXIS TXT(721)                // "%c-axis"
#define TXI_KB_WPNGRP 722                    // "Turning"
#define TXI_KB_MISCGRP 723                   // "Miscellaneous"
#define TXI_KB_THRUSTGRP 724                 // "Thrust"
#define TXI_KB_TURNINGGRP 725                // "Turning"
#define TXI_KB_AUDIOTAUNT1 726               // "Audio Taunt 1"
#define TXI_KB_AUDIOTAUNT2 727               // "Audio Taunt 2"
#define TXI_KB_REARVIEW 728                  // "Rear view"
#define TXT_HUDWARNINGS TXT(729)             // "HUD Warnings"
#define TXT_MSNINFO TXT(730)                 // "Info"
#define TXT_MSNNAME TXT(731)                 // "Name: %s"
#define TXT_MSNAUTHOR TXT(732)               // "Author: %s"
#define TXT_MSNNOTES TXT(733)                // "Notes: %s"
#define TXI_SHFTF9 734                       // "Shift-F9"
#define TXI_DISPLAYHUDMSGCONSOLE 735         // "Displays HUD Message Console"
#define TXI_SHFTF8 736                       // "Shift-F8"
#define TXI_DISPLAYGAMEMSGCONSOLE 737        // "Displays Game Message Console"
#define TXI_F12 738                          // "F12"
#define TXI_DROPSMARKER 739                  // "Drops a Marker"
#define TXT_SAVEGAMEHELP TXT(740)            // "Choose a slot to save game."
#define TXT_LOADGAMEHELP TXT(741)            // "Choose a slot to load a saved game."
#define TXT_SAVEGAMEDUP TXT(742)             // "There is already a saved game of that name. Please choose another."
#define TXT_OVERWRITESAVE TXT(743)           // "Overwrite current saved game?"
#define TXT_CONTROL_TOGGLES TXT(744)         // "Input devices"
#define TXI_SHFTTAB 745                      // "Shift-Tab"
#define TXI_TCMM 746                         // "TelCom Main Menu"
#define TXT_PLTCFILEERR TXT(747)             // "There was a file write error trying to create the Pilot file."
#define TXT_PLTUKNOWNERR TXT(748)            // "There was an internal error trying to create the Pilot file."
#define TXI_KB_AUDIOTAUNT3 749               // "Audio Taunt 3"
#define TXI_KB_AUDIOTAUNT4 750               // "Audio Taunt 4"
#define TXT_TEAMCOUNTPROMPT TXT(751)         //"Please enter the number of teams for"
#define TXT_DS_CANTUSEINIT TXT(752)          //"This value can't be set during server initialization\n"
#define TXT_DS_CANTUSEPLAY TXT(753)          //"This value can't be set during game play\n"
#define TXT_INVALIDNUMTEAMS TXT(754)         //"Invalid Number of Teams Set, defaulting to %d\n"
#define TXT_MAINMISSION TXT(755)             //"Descent 3: Retribution"
#define TXT_RANDOMPOWERUPRESPAWN TXT(756)    //"Randomize powerup respawn"
#define TXT_CONTROLSCONFIG TXT(757)          //"CONTROLS CONFIGURATION"
#define TXT_MULTIPLAYERCONFIG TXT(758)       //"MULTIPLAYER CONFIGURATION"
#define TXT_MISCELLANEOUS TXT(759)           //"MISCELLANEOUS"
#define TXT_PROFFILTER TXT(760)              //"FILTER PROFANITY"
#define TXT_NOPILOTSTOCOPY TXT(761)          //"There are no pilots to copy from"
#define TXT_MAJORPLTERROR TXT(762)           //"An error has occurred reading your pilot file, please create a new one"
#define TXT_PLTTOOOLD TXT(763)               //"Your pilot file is too old, delete and create a new one"
#define TXT_PLTTOONEW TXT(764)               //"Pilot File '%s' is not compatible with this version."
#define TXT_FAILED TXT(765)                  //"Failed"
#define TXT_SCORE TXT(766)                   //"Score"
#define TXT_PLR_MSN_SUCCESS TXT(767)         // Mission Successfull
#define TXT_PLR_MSN_FAILED TXT(768)          // Mission Failed
#define TXT_VIEW_GUIDEBOT TXT(769)           //"Guide-Bot"
#define TXT_VIEW_MARKER TXT(770)             //"Marker"
#define TXT_VIEW_REAR TXT(771)               //"Rear"
#define TXT_PREPARE_FOR_DESCENT TXT(772)     // Prepare for Descent...
#define TXT_ALREADY_HAVE_WEAPON TXT(773)     // Prepare for Descent...
#define TXT_CTLBINDHELP1 TXT(774)            // Press key to bind control
#define TXT_CTLBINDHELP2_0 TXT(775)          // Press a button on your mouse
#define TXT_CTLBINDHELP2_1 TXT(776)          // or joystick (including hat).
#define TXT_CTLBINDHELP3_0 TXT(777)          // Move your mouse or joystick
#define TXT_CTLBINDHELP3_1 TXT(778)          // in the desirec direction.
#define TXT_HUDMSGPOPUP_TITLE TXT(779)       // HUD Messages
#define TXT_MESSAGEBOXTITLE TXT(780)         // Message
#define TXT_MSN_OPENMN3FAILED TXT(781)       // Failed to open MN3 file.
#define TXT_MSN_MSNCOMMAND TXT(782)          // Command specified is a mission command.
#define TXT_MSN_LVLCOMMAND TXT(783)          // Command specified is not a level command.
#define TXT_MSN_NUMLVLSINVALID TXT(784)      // NUMLEVELS doesn't match number of level descript.
#define TXT_MSN_LVLNUMINVALID TXT(785)       // Level number is out of range.
#define TXT_MSN_ILLEGALCMD TXT(786)          // Illegal command %s
#define TXT_MSN_FAILEDCREATEDIR TXT(787)     // Failed to create missions directory.
#define TXT_CDPROMPT TXT(788)                // Please insert Descent 3 CD %d
#define TXT_CALIBJOYSTICKFAIL TXT(789)       // calibrate joystick failed.
#define TXT_CALIBJOYSTICK TXT(790)           // calibrate joystick.
#define TXT_MOUSECONTROL TXT(791)            // Mouse Control
#define TXT_MOUSEFLIGHTSIM TXT(792)          // Flight Sim
#define TXT_MOUSELOOK TXT(793)               // Mouselook
#define TXT_ALLOWMLOOK TXT(794)              // Allow Mouselookers
#define TXT_NOMOUSELOOK TXT(795)             // Mouselook not allowed
#define TXT_MLOOK_JOINANYWAY TXT(796)        // This game does not allow mouselook. Do you want to join anyway?
#define TXT_TRAININGABORTTITLE TXT(797)      // Abort Training System
#define TXT_TRAININGABORTTEXT TXT(798)       // Do you want to Skip to the first level, or abort the Mission?
#define TXT_SKIP TXT(799)                    // Skip
#define TXT_ABORT TXT(800)                   // Abort
#define TXT_REVERTCONTROLS TXT(801)          // Restore settings
#define TXT_QUICKSAVE TXT(802)               // Game saved
#define TXT_HITAKEYORBUTTON TXT(803)         //"Hit a button or the spacebar to continue"
#define TXT_ENABLED_KEY TXT(804)             //"Enabled Key: %s"
#define TXT_ENABLED_CONTROL TXT(805)         //"Enabled Control: %s"
#define TXT_PLRFRIENDSKILL TXT(806)          //"Friendlies killed:"
#define TXT_MSNNOTCOMPATIBLE TXT(807)        //"This mission is not compatible with the selected multiplayer mode."
#define TXT_MULTISELECTSHIP TXT(808)         //"Multiplayer Select Ship"
#define TXT_ABCOOLER TXT(809)                //"AB Cooler"
#define TXT_RETURNEDAUTOMAP TXT(810)         //"Your automap has been retrieved"
#define TXT_RETURNEDHEADLIGHT TXT(811)       //"Your headlight has been retrieved"
#define TXT_HAVEHEADLIGHT TXT(812)           //"You already have a headlight"
#define TXT_DONTHAVEHEADLIGHT TXT(813)       //"You don't have any headlight"
#define TXT_TOG_GUIDEDMISSILE TXT(814)       //"Guided missile view"
#define TXT_TOG_SHOWRETICLE TXT(815)         //"Show reticle"
#define TXT_TOG_SHIPSOUNDS TXT(816)          //"Ship sounds"
#define TXT_SNDCFG_SFXQUANTITY TXT(817)      //"SFX Quantity"
#define TXT_DEDICATED_SERVER TXT(818)        //"Dedicated server: %s"
#define TXT_NONDEDICATED_SERVER TXT(819)     //"Nondedicated server: %s"
#define TXT_GINFO_ALLOWMOUSELOOK TXT(820)    //"%s allow Mouselook."
#define TXT_DOES TXT(821)                    //"Does"
#define TXT_DOESNOT TXT(822)                 //"Does not"
#define TXT_GINFO_ACC_WEAPCOLL TXT(823)      //"Accurate weapon collisions: %s"
#define TXT_USE_ROTATIONAL_VEL TXT(824)      //"Use rotational velocity: %s"
#define TXT_RANDOMIZEPOWERUPSPAWN TXT(825)   //"Randomize powerup respawn: %s"
#define TXT_PLAYERS_X_OF_X TXT(826)          //"Players: %d of %d"
#define TXT_GINFO_MISSION TXT(827)           //"Mission: %s"
#define TXT_GAME_INFO TXT(828)               //"Game information"
#define TXT_PLTFILETOONEW TXT(829)           //"The selected pilot (%s) is too new, please delete and create a new one"
#define TXT_TELCOMLOAD TXT(830)              //"Accessing TelCom...Please wait"
#define TXT_CANTGETPLAYERLIST TXT(831)       //"Couldn't get player list from server!"
#define TXT_GAMEINFOPLAYERSTITLE TXT(832)    //"Players"
#define TXT_GETTINGPLAYERLIST TXT(833)       //"Getting Player list..."
#define TXT_FOUND_SECRET TXT(834)            // "You have found a secret area..."
#define TXT_GAMERESTORED TXT(835)            // "Game restored."
#define TXT_AUDIOTAUNTS TXT(836)             // "Audio Taunts"
#define TXT_GUIDEBOT TXT(837)                // "Guidebot"
#define TXT_ACCESSGUIDEBOT TXT(838)          // "Please wait, accessing Guidebot"
#define TXT_ESCTOCANCEL TXT(839)             // "Press ESC to Cancel"
#define TXT_QUITMESSAGE TXT(840)             // "Are you sure you want to exit?"
#define TXT_CFGSCREENHELP TXT(841)           // "Use CTRL-C to clear currently highlighted slot."
#define TXT_KEYCFGSCREENHELP1 TXT(842)       // "Press '?' for help"
#define TXT_JOYCFGSCREENHELP1 TXT(843)       // "Press '?' for help, or to invert axis"
#define TXT_KEYRAMPINGTIME TXT(844)          // "Key Ramping Time (s)"
#define TXT_ADJUSTCONTROLSETTINGS TXT(845)   //	"Controller settings"
#define TXT_JOYSENSBTN TXT(846)              // "Sensitivity"
#define TXT_KEYRAMPING TXT(847)              //	"Keyboard Ramping"
#define TXT_WPNCFGHELP2 TXT(848)             // "Select weapon slot to place \1\140\140\1%s"
#define TXT_ENTERSECRETLVL TXT(849)          // "Entering Secret Level"
#define TXI_SS_PY_SPEED 850                  //""
#define TXI_SS_PY_MANEUVERABILITY 851        //""
#define TXI_SS_PY_SHIELDS 852                //""
#define TXI_SS_PY_ORDANCE 853                //""
#define TXI_SS_PY_WINGSPAN 854               //""
#define TXI_SS_PY_LENGTH 855                 //""
#define TXI_SS_PY_HEIGHT 856                 //""
#define TXI_SS_PY_WEIGHT 857                 //""
#define TXI_SS_PH_SPEED 858                  //""
#define TXI_SS_PH_MANEUVERABILITY 859        //""
#define TXI_SS_PH_SHIELDS 860                //""
#define TXI_SS_PH_ORDANCE 861                //""
#define TXI_SS_PH_WINGSPAN 862               //""
#define TXI_SS_PH_LENGTH 863                 //""
#define TXI_SS_PH_HEIGHT 864                 //""
#define TXI_SS_PH_WEIGHT 865                 //""
#define TXI_SS_M_SPEED 866                   //""
#define TXI_SS_M_MANEUVERABILITY 867         //""
#define TXI_SS_M_SHIELDS 868                 //""
#define TXI_SS_M_ORDANCE 869                 //""
#define TXI_SS_M_WINGSPAN 870                //""
#define TXI_SS_M_LENGTH 871                  //""
#define TXI_SS_M_HEIGHT 872                  //""
#define TXI_SS_M_WEIGHT 873                  //""
#define TXT_ENABLED_CONTROLS TXT(874)        //"Enabled Controls:"
#define TXT_ENABLED_CONT_FORWARD TXT(875)    //"Forward"
#define TXT_ENABLED_CONT_REVERSE TXT(876)    //"Reverse"
#define TXT_ENABLED_CONT_SLIDELEFT TXT(877)  //"Slide Left"
#define TXT_ENABLED_CONT_SLIDERIGHT TXT(878) //"Slide Right"
#define TXT_ENABLED_CONT_SLIDEUP TXT(879)    //"Slide Up"
#define TXT_ENABLED_CONT_SLIDEDOWN TXT(880)  //"Slide Down"
#define TXT_ENABLED_CONT_PITCHUP TXT(881)    //"Pitch Up"
#define TXT_ENABLED_CONT_PITCHDOWN TXT(882)  //"Pitch Down"
#define TXT_ENABLED_CONT_HEADLEFT TXT(883)   //"Heading Left"
#define TXT_ENABLED_CONT_HEADRIGHT TXT(884)  //"Heading Right"
#define TXT_ENABLED_CONT_BANKLEFT TXT(885)   //"Bank Left"
#define TXT_ENABLED_CONT_BANKRIGHT TXT(886)  //"Bank Right"
#define TXT_ENABLED_CONT_PRIMWEAP TXT(887)   //"Primary Weapon"
#define TXT_ENABLED_CONT_SECWEAP TXT(888)    //"Secondary Weapon"
#define TXT_ENABLED_CONT_AFTERBURN TXT(889)  //"Afterburner"
#define TXT_RELIABLE_OVERRUN TXT(890)        //"Reliable buffer overrun"
#define TXI_HLP_QUIKSAVE 891                 // "Quick Save Game"
#define TXI_F9 892                           //"F9"
#define TXI_HLP_MULTIMSG 893                 //	"Send message in multiplayer"
#define TXI_F8 894                           // "F8"

// Before adding items search for unused entries!
#endif
