/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractJTableCellWriter;
import org.fest.swing.driver.JTableLocation;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableCheckBoxEditorCellWriter
extends AbstractJTableCellWriter {
    public JTableCheckBoxEditorCellWriter(Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void enterValue(JTable table, int row, int column, String value) {
        boolean realValue = Boolean.parseBoolean(value);
        Pair<Boolean, Point> editingInfo = JTableCheckBoxEditorCellWriter.doStartCellEditing(table, row, column, this.location);
        if ((Boolean)editingInfo.i == realValue) {
            return;
        }
        this.robot.click((Component)table, (Point)editingInfo.ii);
    }

    @Override
    @RunsInEDT
    public void startCellEditing(JTable table, int row, int column) {
        JTableCheckBoxEditorCellWriter.doStartCellEditing(table, row, column, this.location);
    }

    @RunsInEDT
    private static Pair<Boolean, Point> doStartCellEditing(final JTable table, final int row, final int column, final JTableLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                JCheckBox editor = AbstractJTableCellWriter.editor(table, row, column, JCheckBox.class);
                AbstractJTableCellWriter.scrollToCell(table, row, column, location);
                return new Pair<Boolean, Point>(editor.isSelected(), location.pointAt(table, row, column));
            }
        });
    }
}

