#include <linux/circ_buf.h>

typedef struct _fifo {
	/* struct circ_buf header; */
	u16 *buf;
	int head;
	int tail;

	int size;
	int mask;
} fifo_t;


static inline void fifo_init (fifo_t *fifo, u16 *buf, int _size) {
	fifo->buf = buf;
	fifo->size = _size;
	fifo->mask = fifo->size - 1;
}

static inline void fifo_next (fifo_t *fifo) {
	fifo->tail++;
	fifo->tail &= fifo->mask;
}

static inline int fifo_full (fifo_t *fifo) {
	return 0 == CIRC_SPACE (fifo->head, fifo->tail, fifo->size);
}

static inline int fifo_empty (fifo_t *fifo) {
	return fifo->head == fifo->tail;
}

static inline u8 fifo_data (fifo_t *fifo) {
	return cpu_to_le16 (fifo->buf[fifo->tail]) & 0xff;
	/*return * (u8 *) (fifo->buf + tail);*/
}

static inline u8 fifo_crl (fifo_t *fifo) {
	return cpu_to_le16 (fifo->buf[fifo->tail]) >> 8;
	/*return * 1 + (u8 *) (fifo->buf + tail);*/
}

static inline void fifo_put (fifo_t *fifo, u16 c) {
	fifo->buf[fifo->head++] = c;
	fifo->head &= fifo->mask;
}

static inline u16 *fifo_last_written (fifo_t *fifo) {
	return &fifo->buf[ (fifo->head - 1) & fifo->mask ];
}

static inline void fifo_flush (fifo_t *fifo) {
	fifo->head = fifo->tail = 0;
}

/* byte fifo */
typedef struct _fifo8 {
	/* struct circ_buf header; */
	u8 *buf;
	int head;
	int tail;

	int size;
	int mask;
} fifo8_t;

static inline void fifo8_init (fifo8_t *fifo, u8 *buf, int _size) {
	fifo->buf = buf;
	fifo->size = _size;
	fifo->mask = fifo->size - 1;
}

static inline void fifo8_next (fifo8_t *fifo) {
	fifo->tail++;
	fifo->tail &= fifo->mask;
}

static inline int fifo8_full (fifo8_t *fifo) {
	return 0 == CIRC_SPACE (fifo->head, fifo->tail, fifo->size);
}

static inline int fifo8_empty (fifo8_t *fifo) {
	return fifo->head == fifo->tail;
}

static inline void fifo8_flush (fifo8_t *fifo) {
	fifo->head = fifo->tail = 0;
}

static inline void fifo8_put (fifo8_t *fifo, u8 c) {
	fifo->buf[fifo->head++] = c;
	fifo->head &= fifo->mask;
}

