const char cgGLVertexShader[] = 

"// this is the vertex program\n"

"//#pragma bind appdata.position = ATTR0\n"
"//#pragma bind appdata.normal = ATTR1\n"

"struct appdata\n"
"{\n"
"	float4 center : POSITION;\n"
"	float4 color : COLOR0;\n"
"	//float4 offset : TEXCOORD0;\n"
"};\n"
"\n"
"struct vfconn\n"
"{\n"
"	float4 HPOS : POSITION;\n"
"	float4 TEX0 : TEXCOORD0;\n"
"	float4 TEX1 : TEXCOORD1;\n"
"	float4 TEX2 : TEXCOORD2;\n"
"	float4 primarycolor : COLOR0;\n"
"	float3 secondarycolor : COLOR1;\n"
"};\n"
"\n"
"float4 remapTo01(float4 v, float4 low, float4 high) {\n"
"	return saturate((v - low)/(high-low));\n"
"}\n"
"\n"
"vfconn main(appdata IN,\n"
"         uniform float4x4 ModelViewIT,\n"
"         uniform float4x4 ModelViewProj,\n"
"		 uniform float4x4 Proj,\n"
"		 uniform float4x4 ModelViewInverse)\n"
"{\n"
"	vfconn OUT;\n"
"	//float4 positions[4] = {float4(-1,-1,0, 0.1), float4(1,-1,0, 0.6), float4(1,1,0, 0.1), float4(-1,1,0, 0.1)};\n"
"	//float2 textures[4] = {float2(0,0), float2(1,0), float2(1,1), float2(0,1)};\n"
"	float3 offset;\n"
"	float ambient;\n"
"	if(IN.center.w == 0) {\n"
"               offset = float3(-1,-1,0);\n"
"               ambient = 0.1;\n"
"       }\n"
"       else if(IN.center.w == 1) {\n"
"               offset = float3(1,-1,0);\n"
"               ambient = 0.6;\n"
"       }\n"
"       else if(IN.center.w == 2) {\n"
"               offset = float3(1,1,0);\n"
"               ambient = 0.1;\n"
"       }\n"
"       else if(IN.center.w == 3) {\n"
"               offset = float3(-1,1,0);\n"
"               ambient = 0.1;\n"
"       }\n"
"\n"
"	OUT.TEX0 = remapTo01(float4(offset, 0.0), (float4)-1.0, (float4)1.0);\n"
"	OUT.TEX0.zw = float2(0,1);\n"
"	//OUT.TEX0.xy = textures[IN.center.w];\n"
"	//OUT.TEX0.zw = float2(0,1);\n"
"	IN.center.w = 1.0;\n"
"	float radius = IN.color.w;\n"
"   \n"
"	// 1. z_scale = radius * PROJ[10];\n"
"	OUT.TEX1.x = radius * Proj[2].z*0.5;\n"
"	\n"
"   // z_bias = MVP[2] * center;\n"
"   OUT.TEX1.z = dot(ModelViewProj[2], IN.center)*0.5;\n"
"	\n"
"\n"
"   // 2. w_scale = radius * PROJ[11]\n"
"   OUT.TEX2.x = radius * Proj[3].z;\n"
"    // w_bias = MVP[3] * center;\n"
"    OUT.TEX2.z = dot(ModelViewProj[3], IN.center);\n"
"\n"
"	// 3. optimization, instead of doing *0.5 + 0.5, we simply do it here itself\n"
"	OUT.TEX1.xz = OUT.TEX1.xz + OUT.TEX2.xz/2.0;\n"
"\n"
"	// In the above, we are assuming that OUT.TEX1.y = OUT.TEX2.y = 0, \n"
"	// and/or the low component in the depth map is 0!\n"
"\n"
"   // eye_space_offset = radius * v[OPOS]\n"
"    float4 eye_space_offset = radius * float4(offset, 0.0);\n"
"\n"
"   // object_space_offset = INV_MV * eye_space_offset\n"
"    float4 object_space_offset = mul(ModelViewInverse, eye_space_offset);\n"
"\n"
"   IN.center.xyz = IN.center.xyz + object_space_offset.xyz;\n"
"    // clip coordinates\n"
"   OUT.HPOS = mul(ModelViewProj, IN.center);\n"
"\n"
"	OUT.primarycolor.xyz = IN.color.xyz;\n"
"	OUT.primarycolor.w = ambient;\n"
"\n"
"//	OUT.TEX1 = OUT.TEX0;\n"
"\n"
"	//float4 lightVect = float4(600,600,640,1) - IN.center;\n"
"	float4 lightVect = float4(50,100,140,0);\n"
"	\n"
"	lightVect = normalize(lightVect);\n"
"\n"
"   // xform light vector into eye space\n"
"    float4 eyeLightVec = lightVect;//mul(ModelViewIT, lightVect);\n"
"\n"
"    // Range compress light vector to fit in a color\n"
"    OUT.secondarycolor.xyz = eyeLightVec.xyz * 0.5 + 0.5;\n"
"\n"
"	return OUT;\n"
"} // main;\n";


