/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.language.ast;

import com.nvidia.cuda.ide.language.ast.CudaTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public final class CudaCASTUtil {
    private static final Set<String> BUILTINS = new TreeSet<String>(Arrays.asList("threadIdx", "blockIdx", "blockDim", "gridDim", "warpSize"));
    private static final short CONST_BIT = 1;
    static final short DEVICE_BIT = 2;
    private static final short GLOBAL_BIT = 4;
    static final short HOST_BIT = 8;
    private static final short SHARED_BIT = 16;
    private static final short MANAGED_BIT = 40;

    private static short adjustFunctionBits(short functionBits) {
        if (functionBits == 4) {
            return 2;
        }
        if (functionBits == 0) {
            return 8;
        }
        return functionBits;
    }

    public static short encodeExtendedBits(boolean global, boolean device, boolean host, boolean shared, boolean constant, boolean managed) {
        short result = global ? (short)4 : 0;
        boolean isDevice = device || shared || constant;
        result = (short)(result + (isDevice ? 2 : 0));
        result = (short)(result + (host ? 8 : 0));
        result = (short)(result + (shared ? 16 : 0));
        result = (short)(result + (constant ? 1 : 0));
        result = (short)(result + (managed ? 40 : 0));
        return result;
    }

    public static IBinding[] filterBindings(IASTCompletionContext idExpression, IBinding[] bindings) {
        int mask = CudaCASTUtil.getLocation((IASTNode)idExpression);
        ArrayList<IBinding> filtered = new ArrayList<IBinding>(bindings.length);
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            int bits = mask;
            if (binding instanceof ICPPFunction) {
                bits = ((IFunction)binding).getExtendedBits();
                if (bits == 0) {
                    bits = 8;
                } else if ((bits & 4) != 0) {
                    bits = 8;
                }
            } else if (binding instanceof IVariable && !(binding instanceof IField)) {
                bits = CudaCASTUtil.getVariableScopeBits((ICPPVariable)binding);
            }
            if ((bits & mask) == mask) {
                filtered.add(binding);
            }
            ++n2;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }

    private static short getLocation(IASTNode idExpression) {
        ICPPASTFunctionDefinition definition = (ICPPASTFunctionDefinition)CPPVisitor.findAncestorWithType((IASTNode)idExpression, ICPPASTFunctionDefinition.class);
        if (definition == null) {
            return 8;
        }
        short extendedBits = definition.getDeclSpecifier().getExtendedBits();
        if ((extendedBits & 4) != 0) {
            return 2;
        }
        if (extendedBits == 0) {
            return 8;
        }
        return (short)(extendedBits & 0xA);
    }

    public static CudaTarget getTarget(Object node) {
        short extendedBits;
        if (node instanceof IASTDeclSpecifier) {
            extendedBits = ((IASTDeclSpecifier)node).getExtendedBits();
        } else if (node instanceof IFunction) {
            extendedBits = ((IFunction)node).getExtendedBits();
        } else {
            return CudaTarget.undefined;
        }
        if ((extendedBits & CudaTarget.cudaHostDevice.bits) == CudaTarget.cudaHostDevice.bits) {
            return CudaTarget.cudaHostDevice;
        }
        if ((extendedBits & 6) != 0) {
            return CudaTarget.cudaDevice;
        }
        return CudaTarget.cudaHost;
    }

    private static short getVariableScopeBits(ICPPVariable variable) {
        short bits = variable.getExtendedBits();
        if (bits != 0) {
            return bits;
        }
        IBinding owner = variable.getOwner();
        while (true) {
            if (owner == null) {
                if (variable instanceof ICPPInternalBinding) {
                    IASTNode definition = ((ICPPInternalBinding)variable).getDefinition();
                    return CudaCASTUtil.isCPPConst(definition) ? (short)10 : 8;
                }
                return 8;
            }
            if (owner instanceof IFunction) {
                return CudaCASTUtil.adjustFunctionBits(((IFunction)owner).getExtendedBits());
            }
            owner = owner.getOwner();
        }
    }

    public static boolean isBuiltinVariable(IVariable variable) {
        String name = variable.getName();
        if (BUILTINS.contains(name)) {
            try {
                return CudaCASTUtil.isDeviceVariable(variable) && variable.getScope() == null;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        return false;
    }

    public static boolean isConstantVariable(IVariable variable) {
        short extendedBits = variable.getExtendedBits();
        return (extendedBits & 1) != 0;
    }

    private static boolean isCPPConst(IASTNode definition) {
        while (definition != null && !(definition instanceof IASTDeclaration)) {
            definition = definition.getParent();
        }
        if (definition instanceof IASTSimpleDeclaration) {
            return ((IASTSimpleDeclaration)definition).getDeclSpecifier().isConst();
        }
        return false;
    }

    private static boolean isDeviceVariable(IVariable variable) {
        short extendedBits = variable.getExtendedBits();
        return (extendedBits & 2) != 0;
    }

    public static boolean isSharedVariable(IVariable variable) {
        short extendedBits = variable.getExtendedBits();
        return (extendedBits & 0x10) != 0;
    }

    public static boolean isManagedVariable(IVariable variable) {
        short extendedBits = variable.getExtendedBits();
        return (extendedBits & 0x28) != 0;
    }

    public static String[] toKeywords(short bits) {
        if ((bits & 0x10) == 16) {
            return new String[]{"__shared__"};
        }
        if ((bits & 1) == 1) {
            return new String[]{"__constant__"};
        }
        if ((bits & 2) == 2) {
            if ((bits & 8) == 8) {
                return new String[]{"__host__", "__device__"};
            }
            return new String[]{"__device__"};
        }
        if ((bits & 8) == 8) {
            return new String[]{"__host__"};
        }
        if ((bits & 0x28) == 40) {
            return new String[]{"__managed__"};
        }
        return new String[0];
    }

    private CudaCASTUtil() {
    }
}

