/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.ui.preferences.ISyncFilterWidgetPatternChangeListener;
import org.eclipse.ptp.internal.rdt.sync.ui.preferences.RemoteContentProvider;
import org.eclipse.ptp.internal.rdt.sync.ui.preferences.SyncFilterWidget;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SyncFileFilterDialog
extends Dialog
implements ISyncFilterWidgetPatternChangeListener {
    private static final Display display = Display.getCurrent();
    private final IProject project;
    private final AbstractSyncFileFilter filter;
    private CheckboxTreeViewer treeViewer;
    private Button showRemoteButton;
    private Label remoteErrorLabel;
    private SyncFilterWidget filterWidget;
    private static final boolean GRAB_EXCESS = true;
    private static final boolean DEBUG = false;

    private SyncFileFilterDialog(Shell parent, IProject p, AbstractSyncFileFilter targetFilter) {
        super(parent);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.project = p;
        this.filter = targetFilter == null ? (this.project == null ? SyncManager.getDefaultFileFilter() : SyncManager.getFileFilter((IProject)this.project).clone()) : targetFilter;
        this.setReturnCode(1);
    }

    public static int open(Shell parent, IProject project) {
        return new SyncFileFilterDialog(parent, project, null).open();
    }

    public static int openBlocking(Shell parent, AbstractSyncFileFilter filter) {
        SyncFileFilterDialog page = new SyncFileFilterDialog(parent, null, filter);
        page.setBlockOnOpen(true);
        return page.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.NewSyncFileFilterPage_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(main, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 500;
        composite.setLayoutData((Object)gd);
        if (this.project != null) {
            Composite treeViewerComposite = new Composite(composite, 0);
            GridLayout treeLayout = new GridLayout(2, false);
            treeViewerComposite.setLayout((Layout)treeLayout);
            gd = new GridData(4, 4, true, true);
            treeViewerComposite.setLayoutData((Object)gd);
            Label treeViewerLabel = new Label(treeViewerComposite, 0);
            treeViewerLabel.setText(Messages.NewSyncFileFilterPage_Select_files_to_be_included);
            gd = new GridData(16384, 0x1000000, false, false, 2, 1);
            treeViewerLabel.setLayoutData((Object)gd);
            this.treeViewer = new CheckboxTreeViewer(treeViewerComposite);
            gd = new GridData(4, 4, true, true, 2, 1);
            gd.heightHint = 200;
            this.treeViewer.getTree().setLayoutData((Object)gd);
            this.treeViewer.setContentProvider((IContentProvider)new SFTTreeContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new SFTTreeLabelProvider());
            this.treeViewer.setCheckStateProvider(new ICheckStateProvider(){

                public boolean isChecked(Object element) {
                    return !SyncFileFilterDialog.this.filter.shouldIgnore((IResource)element);
                }

                public boolean isGrayed(Object element) {
                    return false;
                }
            });
            this.treeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    SyncFileFilterDialog.this.filter.addPattern((IResource)event.getElement(), !event.getChecked());
                    SyncFileFilterDialog.this.update();
                }
            });
            this.treeViewer.setInput((Object)this.project);
            this.showRemoteButton = new Button(treeViewerComposite, 32);
            this.showRemoteButton.setText(Messages.NewSyncFileFilterPage_Show_remote_files);
            this.showRemoteButton.setSelection(((SFTTreeContentProvider)this.treeViewer.getContentProvider()).getShowRemoteFiles());
            this.showRemoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SyncFileFilterDialog.this.update();
                }
            });
            this.remoteErrorLabel = new Label(treeViewerComposite, 0x1000000);
            this.remoteErrorLabel.setForeground(display.getSystemColor(4));
            gd = new GridData(4, 0x1000000, true, false);
            this.remoteErrorLabel.setLayoutData((Object)gd);
        }
        this.filterWidget = new SyncFilterWidget(composite, 0);
        this.filterWidget.setLayoutData(new GridData(4, 4, true, true));
        this.filterWidget.setFilter(this.filter);
        this.filterWidget.addNewPatternChangeListener(this);
        this.update();
        return composite;
    }

    protected void okPressed() {
        if (this.project != null) {
            try {
                SyncManager.saveFileFilter((IProject)this.project, (AbstractSyncFileFilter)this.filter);
            }
            catch (CoreException e) {
                RDTSyncUIPlugin.log(e);
            }
        }
        this.setReturnCode(0);
        this.close();
    }

    private void update() {
        if (this.project != null) {
            boolean showRemote = this.showRemoteButton.getSelection();
            if (showRemote) {
                if (!((SFTTreeContentProvider)this.treeViewer.getContentProvider()).isConnected()) {
                    showRemote = false;
                    this.remoteErrorLabel.setText(Messages.NewSyncFileFilterPage_Remote_is_disconnected);
                } else {
                    this.remoteErrorLabel.setText("");
                }
            }
            this.showRemoteButton.setSelection(showRemote);
            ((SFTTreeContentProvider)this.treeViewer.getContentProvider()).setShowRemoteFiles(showRemote);
            this.treeViewer.refresh();
            this.filterWidget.update();
        }
    }

    private void colorComposite(Composite comp, int color) {
    }

    @Override
    public void patternChanged() {
        if (this.treeViewer != null) {
            this.treeViewer.refresh();
        }
    }

    public boolean close() {
        this.filterWidget.removePatternChangeListener(this);
        return super.close();
    }

    private class SFTTreeContentProvider
    implements ITreeContentProvider {
        private final RemoteContentProvider remoteFiles;
        private boolean showRemoteFiles = false;

        public SFTTreeContentProvider() {
            SyncConfig config = SyncConfigManager.getActive((IProject)SyncFileFilterDialog.this.project);
            if (config == null) {
                this.remoteFiles = null;
            } else {
                RemoteContentProvider tmpRCP;
                try {
                    tmpRCP = new RemoteContentProvider(config.getRemoteConnection(), (IPath)new Path(config.getLocation(SyncFileFilterDialog.this.project)), SyncFileFilterDialog.this.project);
                }
                catch (MissingConnectionException missingConnectionException) {
                    tmpRCP = null;
                }
                this.remoteFiles = tmpRCP;
            }
        }

        public boolean getShowRemoteFiles() {
            return this.showRemoteFiles;
        }

        public void setShowRemoteFiles(boolean b) {
            this.showRemoteFiles = b;
        }

        public Object[] getChildren(Object element) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            if (element instanceof IFolder && !SyncFileFilterDialog.this.filter.shouldIgnore((IResource)element)) {
                int n;
                int n2;
                Object[] objectArray;
                block7: {
                    if (((IFolder)element).isAccessible()) {
                        try {
                            objectArray = ((IFolder)element).members();
                            n2 = objectArray.length;
                            n = 0;
                            while (n < n2) {
                                IResource localChild = objectArray[n];
                                children.add(localChild);
                                ++n;
                            }
                        }
                        catch (CoreException coreException) {
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError();
                        }
                    }
                }
                if (this.showRemoteFiles && this.remoteFiles != null) {
                    objectArray = this.remoteFiles.getChildren(element);
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        IResource remoteChild = objectArray[n];
                        this.addUniqueResource(children, remoteChild);
                        ++n;
                    }
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return ((IResource)element).getParent();
        }

        public boolean hasChildren(Object element) {
            Object[] obj = this.getChildren(element);
            return obj == null ? false : obj.length > 0;
        }

        public Object[] getElements(Object element) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            if (element instanceof IProject && ((IProject)element).isAccessible()) {
                int n;
                int n2;
                Object[] objectArray;
                block6: {
                    try {
                        objectArray = ((IProject)element).members();
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            IResource localChild = objectArray[n];
                            children.add(localChild);
                            ++n;
                        }
                    }
                    catch (CoreException coreException) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError();
                    }
                }
                if (this.showRemoteFiles && this.remoteFiles != null) {
                    objectArray = this.remoteFiles.getElements(element);
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        IResource remoteChild = objectArray[n];
                        this.addUniqueResource(children, remoteChild);
                        ++n;
                    }
                }
            }
            return children.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer element, Object arg1, Object arg2) {
        }

        private boolean addUniqueResource(Collection<IResource> resList, IResource newRes) {
            for (IResource res : resList) {
                if (!res.getProjectRelativePath().equals((Object)newRes.getProjectRelativePath())) continue;
                return false;
            }
            resList.add(newRes);
            return true;
        }

        public boolean isConnected() {
            if (this.remoteFiles == null) {
                return false;
            }
            return this.remoteFiles.isOpen();
        }
    }

    private class SFTTreeLabelProvider
    implements ILabelProvider {
        private final Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private final Image fileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        private SFTTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IFolder) {
                return this.folderImage;
            }
            return this.fileImage;
        }

        public String getText(Object element) {
            return ((IResource)element).getName();
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String arg1) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

