/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class SWTUtils {
    public static final int MARGINS_DEFAULT = -1;
    public static final int MARGINS_NONE = 0;
    public static final int MARGINS_DIALOG = 1;

    public static PreferenceLinkArea createPreferenceLink(IWorkbenchPreferenceContainer container, Composite parent, String pageId, String text) {
        PreferenceLinkArea area = new PreferenceLinkArea(parent, 0, pageId, text, container, null);
        return area;
    }

    public static Link createPreferenceLink(Shell shell, Composite parent, String pageId, String message) {
        return SWTUtils.createPreferenceLink(shell, parent, pageId, new String[]{pageId}, message);
    }

    public static Link createPreferenceLink(final Shell shell, Composite parent, final String pageId, final String[] displayIds, String message) {
        Link link = new Link(parent, 0);
        link.setText(SWTUtils.getLinkLabel(pageId, message));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageId, (String[])displayIds, null);
                prefDialog.open();
            }
        });
        return link;
    }

    private static String getLinkLabel(String pageId, String message) {
        IPreferenceNode node = SWTUtils.getPreferenceNode(pageId);
        if (node == null) {
            return NLS.bind((String)TeamUIMessages.NotFound, (Object)pageId);
        }
        return MessageFormat.format((String)message, (Object[])new String[]{node.getLabelText()});
    }

    private static IPreferenceNode getPreferenceNode(String pageId) {
        Iterator iterator = PlatformUI.getWorkbench().getPreferenceManager().getElements(0).iterator();
        while (iterator.hasNext()) {
            IPreferenceNode next = (IPreferenceNode)iterator.next();
            if (!next.getId().equals(pageId)) continue;
            return next;
        }
        return null;
    }

    public static GridData createGridData(int width, int height, boolean hFill, boolean vFill) {
        return SWTUtils.createGridData(width, height, hFill ? 4 : 1, vFill ? 4 : 0x1000000, hFill, vFill);
    }

    public static GridData createGridData(int width, int height, int hAlign, int vAlign, boolean hGrab, boolean vGrab) {
        GridData gd = new GridData(hAlign, vAlign, hGrab, vGrab);
        gd.widthHint = width;
        gd.heightHint = height;
        return gd;
    }

    public static GridData createHFillGridData() {
        return SWTUtils.createHFillGridData(1);
    }

    public static GridData createHFillGridData(int span) {
        GridData gd = SWTUtils.createGridData(0, -1, 4, 0x1000000, true, false);
        gd.horizontalSpan = span;
        return gd;
    }

    public static Composite createHFillComposite(Composite parent, int margins) {
        return SWTUtils.createHFillComposite(parent, margins, 1);
    }

    public static Composite createHFillComposite(Composite parent, int margins, int columns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)SWTUtils.createHFillGridData());
        composite.setLayout((Layout)SWTUtils.createGridLayout(columns, new PixelConverter((Control)parent), margins));
        return composite;
    }

    public static Composite createHVFillComposite(Composite parent, int margins) {
        return SWTUtils.createHVFillComposite(parent, margins, 1);
    }

    public static Composite createHVFillComposite(Composite parent, int margins, int columns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)SWTUtils.createHVFillGridData());
        composite.setLayout((Layout)SWTUtils.createGridLayout(columns, new PixelConverter((Control)parent), margins));
        return composite;
    }

    public static Group createHFillGroup(Composite parent, String text, int margins) {
        return SWTUtils.createHFillGroup(parent, text, margins, 1);
    }

    public static Group createHFillGroup(Composite parent, String text, int margins, int rows) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)SWTUtils.createHFillGridData());
        if (text != null) {
            group.setText(text);
        }
        group.setLayout((Layout)SWTUtils.createGridLayout(rows, new PixelConverter((Control)parent), margins));
        return group;
    }

    public static Group createHVFillGroup(Composite parent, String text, int margins) {
        return SWTUtils.createHVFillGroup(parent, text, margins, 1);
    }

    public static Group createHVFillGroup(Composite parent, String text, int margins, int rows) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)SWTUtils.createHVFillGridData());
        if (text != null) {
            group.setText(text);
        }
        group.setLayout((Layout)SWTUtils.createGridLayout(rows, new PixelConverter((Control)parent), margins));
        return group;
    }

    public static GridData createHVFillGridData() {
        return SWTUtils.createHVFillGridData(1);
    }

    public static GridData createHVFillGridData(int span) {
        GridData gd = SWTUtils.createGridData(0, 0, true, true);
        gd.horizontalSpan = span;
        return gd;
    }

    public static GridLayout createGridLayout(int numColumns, PixelConverter converter, int margins) {
        Assert.isTrue((margins == -1 || margins == 0 || margins == 1 ? 1 : 0) != 0);
        GridLayout layout = new GridLayout(numColumns, false);
        layout.horizontalSpacing = converter.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = converter.convertVerticalDLUsToPixels(4);
        switch (margins) {
            case 0: {
                layout.marginRight = 0;
                layout.marginLeft = 0;
                layout.marginBottom = 0;
                layout.marginTop = 0;
                break;
            }
            case 1: {
                layout.marginLeft = layout.marginRight = converter.convertHorizontalDLUsToPixels(7);
                layout.marginTop = layout.marginBottom = converter.convertVerticalDLUsToPixels(7);
                break;
            }
            case -1: {
                layout.marginLeft = layout.marginRight = layout.marginWidth;
                layout.marginTop = layout.marginBottom = layout.marginHeight;
            }
        }
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    public static Label createLabel(Composite parent, String message) {
        return SWTUtils.createLabel(parent, message, 1);
    }

    public static Label createLabel(Composite parent, String message, int span) {
        Label label = new Label(parent, 64);
        if (message != null) {
            label.setText(message);
        }
        label.setLayoutData((Object)SWTUtils.createHFillGridData(span));
        return label;
    }

    public static Button createCheckBox(Composite parent, String message) {
        return SWTUtils.createCheckBox(parent, message, 1);
    }

    public static Button createCheckBox(Composite parent, String message, int span) {
        Button button = new Button(parent, 32);
        button.setText(message);
        button.setLayoutData((Object)SWTUtils.createHFillGridData(span));
        return button;
    }

    public static Button createRadioButton(Composite parent, String message) {
        return SWTUtils.createRadioButton(parent, message, 1);
    }

    public static Button createRadioButton(Composite parent, String message, int span) {
        Button button = new Button(parent, 16);
        button.setText(message);
        button.setLayoutData((Object)SWTUtils.createHFillGridData(span));
        return button;
    }

    public static Text createText(Composite parent) {
        return SWTUtils.createText(parent, 1);
    }

    public static Text createText(Composite parent, int span) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)SWTUtils.createHFillGridData(span));
        return text;
    }

    public static Control createPlaceholder(Composite parent, int heightInChars, int span) {
        Assert.isTrue((heightInChars > 0 ? 1 : 0) != 0);
        Composite placeHolder = new Composite(parent, 0);
        GridData gd = new GridData(1, 128, false, false);
        gd.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(heightInChars);
        gd.horizontalSpan = span;
        placeHolder.setLayoutData((Object)gd);
        return placeHolder;
    }

    public static Control createPlaceholder(Composite parent, int heightInChars) {
        return SWTUtils.createPlaceholder(parent, heightInChars, 1);
    }

    public static PixelConverter createDialogPixelConverter(Control control) {
        Dialog.applyDialogFont((Control)control);
        return new PixelConverter(control);
    }

    public static int calculateControlSize(PixelConverter converter, Control[] controls) {
        return SWTUtils.calculateControlSize(converter, controls, 0, controls.length - 1);
    }

    public static int calculateControlSize(PixelConverter converter, Control[] controls, int start, int end) {
        int minimum = converter.convertHorizontalDLUsToPixels(61);
        int i = start;
        while (i <= end) {
            int length = controls[i].computeSize((int)-1, (int)-1).x;
            if (minimum < length) {
                minimum = length;
            }
            ++i;
        }
        return minimum;
    }

    public static void equalizeControls(PixelConverter converter, Control[] controls) {
        SWTUtils.equalizeControls(converter, controls, 0, controls.length - 1);
    }

    public static void equalizeControls(PixelConverter converter, Control[] controls, int start, int end) {
        int size = SWTUtils.calculateControlSize(converter, controls, start, end);
        int i = start;
        while (i <= end) {
            Control button = controls[i];
            if (button.getLayoutData() instanceof GridData) {
                ((GridData)button.getLayoutData()).widthHint = size;
            }
            ++i;
        }
    }

    public static int getWidthInCharsForLongest(PixelConverter converter, String[] strings) {
        int minimum = 0;
        int i = 0;
        while (i < strings.length) {
            int length = converter.convertWidthInCharsToPixels(strings[i].length());
            if (minimum < length) {
                minimum = length;
            }
            ++i;
        }
        return minimum;
    }
}

