/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.StashApplyOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StashApplyCommand
extends RepositoriesViewCommandHandler<StashedCommitNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes(event);
        if (nodes.isEmpty()) {
            return null;
        }
        Repository repo = ((StashedCommitNode)nodes.get(0)).getRepository();
        if (repo == null) {
            return null;
        }
        final RevCommit commit = (RevCommit)((StashedCommitNode)nodes.get(0)).getObject();
        if (commit == null) {
            return null;
        }
        final StashApplyOperation op = new StashApplyOperation(repo, commit);
        WorkspaceJob job = new WorkspaceJob(MessageFormat.format(UIText.StashApplyCommand_jobTitle, commit.name())){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                }
                catch (CoreException e) {
                    return new Status(4, Activator.getPluginId(), MessageFormat.format(UIText.StashApplyCommand_applyFailed, commit.abbreviate(7).name(), e.getLocalizedMessage()), (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.STASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }
}

