/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.wizards.ContextPropertyStore;
import com.nvidia.common.wizards.IContextPropertyListener;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.cdt.launch.CApplicationLaunchShortcut;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugSessionType;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugWizardProperties;
import com.nvidia.cuda.ide.util.IdeUtil;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class AbstractRemoteDebugSession
implements IDebugSessionType,
IContextPropertyListener {
    public static final PropertyDescriptor<String> PROPERTY_LOCAL_EXECUTABLE_PATH = new PropertyDescriptor("local.executable.path", String.class);
    public static final PropertyDescriptor<IRemoteConnection> PROPERTY_REMOTE_CONNECTION = new PropertyDescriptor("remote.connection", IRemoteConnection.class);
    public static final PropertyDescriptor<String> PROPERTY_REMOTE_EXECUTABLE = new PropertyDescriptor("remote.executable", String.class);
    public static final PropertyDescriptor<Integer> PROPERTY_REMOTE_PORT = new PropertyDescriptor("remote.port", Integer.class);
    protected WizardContext context;
    private ContextPropertyStore defaultsStore = null;
    private IRemoteConnectionsService service;
    private ServiceReference<IRemoteConnectionsService> serviceReference;

    private static IBinary findDebugVersion(List<IBinary> binaries) {
        if (binaries.size() > 1) {
            for (IBinary binary : binaries) {
                IPath path = binary.getPath();
                if (path == null || path.segmentCount() <= 1 || !path.segment(path.segmentCount() - 2).toLowerCase().contains("debug")) continue;
                return binary;
            }
        }
        return binaries.get(0);
    }

    private static int getDefaultPort() {
        return Integer.parseInt("2345");
    }

    @Override
    public final ILaunchConfiguration createLaunchConfiguration() throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationType());
        String configurationName = (String)this.context.getProperty(IDebugWizardProperties.PROPERTY_LAUNCH_CONFIGURATION_NAME);
        String fixedName = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(configurationName);
        ILaunchConfigurationWorkingCopy lc = type.newInstance(null, fixedName);
        lc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
        lc.setAttribute("org.eclipse.cdt.launch.remote.RemoteCDSFDebuggerTab.DEFAULTS_SET", true);
        lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, ((Integer)this.context.getProperty(PROPERTY_REMOTE_PORT)).toString());
        IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(PROPERTY_REMOTE_CONNECTION);
        lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, connection.getName());
        this.fillExecutableProperties(lc);
        this.fillLaunchConfigurationProperties(lc, connection);
        ILaunchConfiguration configuration = lc.doSave();
        if (connection != null) {
            Activator.getDefault().getPreferenceStore().setValue(AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION.name, connection.getName());
            this.setDefault(connection, PROPERTY_REMOTE_PORT);
        }
        this.saveDefaults(connection);
        return configuration;
    }

    @Override
    public final void dispose() {
        if (this.service != null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            bundleContext.ungetService(this.serviceReference);
            this.service = null;
            this.serviceReference = null;
        }
    }

    protected void fillExecutableProperties(ILaunchConfigurationWorkingCopy lc) {
        String localPath = (String)this.context.getProperty(PROPERTY_LOCAL_EXECUTABLE_PATH);
        IFile file = IdeUtil.getWorkspaceFile((String)localPath);
        if (file != null) {
            lc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", file.getProject().getName());
            lc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", file.getProjectRelativePath().toPortableString());
            lc.setAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 2);
            lc.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
            lc.setMappedResources(new IResource[]{file.getProject()});
        } else {
            lc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", localPath);
            lc.setMappedResources(new IResource[0]);
        }
        lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, (String)this.context.getProperty(PROPERTY_REMOTE_EXECUTABLE));
        lc.setAttribute("lc.downloadso", true);
    }

    protected abstract void fillLaunchConfigurationProperties(ILaunchConfigurationWorkingCopy var1, IRemoteConnection var2);

    protected abstract String getLaunchConfigurationType();

    @Override
    public void init(WizardContext context) {
        this.context = context;
    }

    public final void propertyChanged(PropertyDescriptor<?> property, Object oldValue, Object newValue) {
        if (this.shouldRecomputeDefaults(property)) {
            this.recomputeDefaults(this.defaultsStore, null);
        }
    }

    protected abstract void recomputeDefaults(ContextPropertyStore var1, IProgressMonitor var2);

    protected abstract void saveDefaults(IRemoteConnection var1);

    protected final void setDefault(IRemoteConnection connection, PropertyDescriptor<?> property) {
        connection.setProperty(property.name, this.context.getProperty(property));
    }

    @Override
    public final void setDefaults(IProgressMonitor monitor) {
        if (this.defaultsStore == null) {
            IStructuredSelection selection;
            IRemoteConnection connection;
            ContextPropertyStore propertiesStore = this.context.getPropertiesStore();
            propertiesStore.addSessionPropertyListener((IContextPropertyListener)this);
            this.defaultsStore = propertiesStore.newDefaultsStore();
            String name = Activator.getDefault().getPreferenceStore().getString(AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION.name);
            if (!CoreUtil.isNullOrEmpty((String)name) && (connection = IRemoteConnectionsService.GetConnection.getConnection((String)name, (IProgressMonitor)monitor)) != null) {
                this.defaultsStore.setProperty(PROPERTY_REMOTE_CONNECTION, (Object)connection);
            }
            if ((selection = (IStructuredSelection)this.context.getProperty(IDebugWizardProperties.PROPERTY_SELECTION)) != null && !selection.isEmpty()) {
                try {
                    List binaries = CApplicationLaunchShortcut.findBinaries((Object[])selection.toArray(), (IProgressMonitor)new NullProgressMonitor());
                    if (!CoreUtil.isNullOrEmpty((Collection)binaries)) {
                        this.defaultsStore.setProperty(PROPERTY_LOCAL_EXECUTABLE_PATH, (Object)AbstractRemoteDebugSession.findDebugVersion(binaries).getPath().toOSString());
                    }
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                }
            }
            this.recomputeDefaults(this.defaultsStore, monitor);
        }
    }

    protected abstract boolean shouldRecomputeDefaults(PropertyDescriptor<?> var1);

    protected final IRemoteConnection updateContextConnectionProperties() {
        this.defaultsStore.setProperty(PROPERTY_REMOTE_PORT, (Object)AbstractRemoteDebugSession.getDefaultPort());
        IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(PROPERTY_REMOTE_CONNECTION);
        if (connection != null) {
            this.defaultsStore.setProperty(PROPERTY_REMOTE_PORT, (Object)connection.getProperty(AbstractRemoteDebugSession.PROPERTY_REMOTE_PORT.name, AbstractRemoteDebugSession.getDefaultPort()));
        }
        return connection;
    }
}

