/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import org.eclipse.cdt.internal.ui.buildconsole.BuildConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class BuildConsoleViewer
extends TextViewer
implements LineStyleListener,
LineBackgroundListener,
MouseTrackListener,
MouseListener {
    protected InternalDocumentListener fInternalDocumentListener = new InternalDocumentListener();
    private boolean fAutoScroll = true;

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public BuildConsoleViewer(Composite parent) {
        super(parent, BuildConsoleViewer.getSWTStyles());
        StyledText styledText = this.getTextWidget();
        if (styledText != null) {
            styledText.addLineStyleListener((LineStyleListener)this);
            styledText.addLineBackgroundListener((LineBackgroundListener)this);
            styledText.addMouseTrackListener((MouseTrackListener)this);
            styledText.setFont(parent.getFont());
            styledText.setDoubleClickEnabled(true);
            styledText.setEditable(false);
        }
    }

    private static int getSWTStyles() {
        int styles = 768;
        return styles;
    }

    protected void revealEndOfDocument() {
        StyledText widget;
        if (this.isAutoScroll() && (widget = this.getTextWidget()) != null) {
            IDocument doc = this.getDocument();
            int lines = doc.getNumberOfLines();
            try {
                int lineEndOffset;
                int lineStartOffset = doc.getLineOffset(lines - 1);
                if (lineStartOffset > 0) {
                    widget.setCaretOffset(lineStartOffset);
                    widget.showSelection();
                }
                if ((lineEndOffset = lineStartOffset + doc.getLineLength(lines - 1)) > 0) {
                    widget.setCaretOffset(lineEndOffset);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void setDocument(IDocument doc) {
        IDocument oldDoc = this.getDocument();
        IDocument document = doc;
        if (oldDoc == null && document == null) {
            return;
        }
        if (oldDoc != null) {
            oldDoc.removeDocumentListener((IDocumentListener)this.fInternalDocumentListener);
            if (oldDoc.equals(document)) {
                document.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
                return;
            }
        }
        super.setDocument(document);
        if (document != null) {
            this.revealEndOfDocument();
            document.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        BuildConsolePartitioner partitioner = (BuildConsolePartitioner)document.getDocumentPartitioner();
        if (partitioner == null) {
            return;
        }
        BuildConsolePartition p = partitioner.fDocumentMarkerManager.getCurrentPartition();
        Color problemHighlightedColor = partitioner.fManager.getProblemHighlightedColor();
        ITypedRegion[] regions = partitioner.computePartitioning(event.lineOffset, event.lineText.length());
        StyleRange[] styles = new StyleRange[regions.length];
        int i = 0;
        while (i < regions.length) {
            StyleRange styleRange;
            BuildConsolePartition partition = (BuildConsolePartition)regions[i];
            if (partition.getStream() == null) {
                return;
            }
            Color colorFG = partition.getStream().getColor();
            Color colorBG = null;
            if (partition == p) {
                colorFG = problemHighlightedColor;
            }
            styles[i] = styleRange = new StyleRange(partition.getOffset(), partition.getLength(), colorFG, colorBG);
            ++i;
        }
        event.styles = styles;
    }

    public void selectPartition(BuildConsolePartitioner partitioner, BuildConsolePartition p) {
        StyledText st = this.getTextWidget();
        if (st != null) {
            try {
                int start = partitioner.getDocument().getLineOfOffset(p.getOffset());
                int end = partitioner.getDocument().getLineOfOffset(p.getOffset() + p.getLength() - 1);
                if (this.fAutoScroll) {
                    int top = this.getTopIndex();
                    int bottom = this.getBottomIndex();
                    if (start < top + 1) {
                        this.setTopIndex(start - 1 > 0 ? start - 1 : 0);
                    } else if (end > bottom - 1) {
                        this.setTopIndex(top + start - bottom + 1);
                    }
                }
                st.redrawRange(0, partitioner.getDocument().getLength(), true);
            }
            catch (BadLocationException e) {
                CUIPlugin.log(e);
            }
        }
    }

    public void mouseEnter(MouseEvent e) {
        StyledText widget = this.getTextWidget();
        if (widget != null) {
            widget.addMouseListener((MouseListener)this);
        }
    }

    public void mouseExit(MouseEvent e) {
        StyledText widget = this.getTextWidget();
        if (widget != null) {
            widget.removeMouseListener((MouseListener)this);
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        StyledText widget = this.getTextWidget();
        if (widget != null) {
            int offset = -1;
            try {
                Point p = new Point(e.x, e.y);
                offset = widget.getOffsetAtLocation(p);
                BuildConsole.getCurrentPage().moveToError(offset);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        BuildConsolePartitioner partitioner = (BuildConsolePartitioner)document.getDocumentPartitioner();
        if (partitioner == null) {
            return;
        }
        BuildConsolePartition partition = (BuildConsolePartition)partitioner.getPartition(event.lineOffset);
        if (partition != null) {
            String type = partition.getType();
            if (type == BuildConsolePartition.ERROR_PARTITION_TYPE) {
                event.lineBackground = partitioner.fManager.getProblemBackgroundColor();
            } else if (type == BuildConsolePartition.WARNING_PARTITION_TYPE) {
                event.lineBackground = partitioner.fManager.getWarningBackgroundColor();
            } else if (type == BuildConsolePartition.INFO_PARTITION_TYPE) {
                event.lineBackground = partitioner.fManager.getInfoBackgroundColor();
            }
        }
    }

    class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            BuildConsoleViewer.this.revealEndOfDocument();
        }
    }
}

