/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.ui.viewmodel.HostStackFramesVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LayoutChangeEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LinkedSelectionChangedEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.SetDebuggerFocusEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.BlockVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.CDPCallStackNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.CudaAllThreadsVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.CudaContainerVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.DeviceThreadVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.FilteredKernelsNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.HostThreadVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.MulticolumnCudaStackFramesVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.PinnedThreadVMNode;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractLaunchVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.LaunchRootVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.GdbStandardProcessVMNode;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.DefaultVMModelProxyStrategy;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class DebugVMProvider
extends AbstractLaunchVMProvider
implements IDebugEventSetListener,
ILaunchesListener2,
IPropertyChangeListener {
    private final IRootVMNode root;

    @ThreadSafe
    public DebugVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.root = new LaunchRootVMNode((AbstractVMProvider)this);
        this.setRootNode(this.root);
        this.buildTree(session);
    }

    private void buildTree(DsfSession session) {
        IVMNode kernelsNode = this.createKernelSubtree(session);
        FilteredKernelsNode hiddenKernels = new FilteredKernelsNode((AbstractDMVMProvider)this, session);
        IVMNode containerNode = this.createHostSubtree();
        GdbStandardProcessVMNode processesNode = new GdbStandardProcessVMNode((AbstractVMProvider)this);
        this.addChildNodes((IVMNode)this.root, new IVMNode[]{kernelsNode, hiddenKernels, containerNode, processesNode});
    }

    private IVMNode createHostSubtree() {
        CudaContainerVMNode containerNode = new CudaContainerVMNode((AbstractDMVMProvider)this, this.getSession());
        HostThreadVMNode threadsNode = new HostThreadVMNode((AbstractDMVMProvider)this, this.getSession());
        HostStackFramesVMNode stackFramesNode = new HostStackFramesVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)threadsNode, new IVMNode[]{stackFramesNode});
        this.addChildNodes(containerNode, new IVMNode[]{threadsNode});
        return containerNode;
    }

    private IVMNode createKernelSubtree(DsfSession session) {
        KernelVMNode kernelsNode = new KernelVMNode((AbstractDMVMProvider)this, session, false);
        IVMNode pinnedThreadsNode = this.createdPinnedThreadsSubtree();
        CudaAllThreadsVMNode cudaAllThreadsNode = new CudaAllThreadsVMNode((AbstractDMVMProvider)this, session);
        IVMNode allThreadsBlocks = this.createBlocksSubtree(BlockVMNode.ParentKind.ALL_THREADS, false);
        IVMNode kernelBlocks = this.createBlocksSubtree(BlockVMNode.ParentKind.KERNELS, false);
        this.addChildNodes((IVMNode)cudaAllThreadsNode, new IVMNode[]{allThreadsBlocks});
        this.addChildNodes((IVMNode)kernelsNode, new IVMNode[]{pinnedThreadsNode, cudaAllThreadsNode, kernelBlocks, kernelsNode});
        return kernelsNode;
    }

    private IVMNode createdPinnedThreadsSubtree() {
        PinnedThreadVMNode pinnedThreadsNode = new PinnedThreadVMNode((AbstractDMVMProvider)this, this.getSession());
        MulticolumnCudaStackFramesVMNode cudaStackFramesNode = new MulticolumnCudaStackFramesVMNode((AbstractDMVMProvider)this, this.getSession());
        CDPCallStackNode cdpCallStackNode = new CDPCallStackNode((AbstractDMVMProvider)this, this.getSession());
        IVMNode cdpCallStackBlocks = this.createBlocksSubtree(BlockVMNode.ParentKind.CDP_CALLSTACK, true);
        this.addChildNodes((IVMNode)cdpCallStackNode, new IVMNode[]{cdpCallStackBlocks});
        this.addChildNodes(pinnedThreadsNode, new IVMNode[]{cudaStackFramesNode, cdpCallStackNode});
        return pinnedThreadsNode;
    }

    private IVMNode createBlocksSubtree(BlockVMNode.ParentKind parentKind, boolean selectPinned) {
        BlockVMNode cdpCallStackBlocks = new BlockVMNode((AbstractDMVMProvider)this, parentKind, this.getSession(), !selectPinned);
        DeviceThreadVMNode cdpCallStackThreads = new DeviceThreadVMNode((AbstractDMVMProvider)this, this.getSession(), selectPinned);
        MulticolumnCudaStackFramesVMNode unpinnedStackFrames = new MulticolumnCudaStackFramesVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)cdpCallStackThreads, new IVMNode[]{unpinnedStackFrames});
        this.addChildNodes((IVMNode)cdpCallStackBlocks, new IVMNode[]{cdpCallStackThreads});
        return cdpCallStackBlocks;
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        if (eventToSkip instanceof ICommandControlService.ICommandControlInitializedDMEvent || eventToSkip instanceof ICommandControlService.ICommandControlShutdownDMEvent) {
            return false;
        }
        if ((eventToSkip instanceof IGDBTraceControl.ITracingStartedDMEvent || eventToSkip instanceof IGDBTraceControl.ITracingStoppedDMEvent) && (newEvent instanceof IGDBTraceControl.ITracingStartedDMEvent || newEvent instanceof IGDBTraceControl.ITracingStoppedDMEvent)) {
            return true;
        }
        if (eventToSkip instanceof IGDBTraceControl.ITracingSupportedChangeDMEvent && newEvent instanceof IGDBTraceControl.ITracingSupportedChangeDMEvent) {
            return true;
        }
        boolean canSkip = super.canSkipHandlingEvent(newEvent, eventToSkip);
        return canSkip;
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void handleEvent(Object event, RequestMonitor rm) {
        if (event instanceof IGDBTraceControl.ITracingStartedDMEvent || event instanceof IGDBTraceControl.ITracingStoppedDMEvent || event instanceof IGDBTraceControl.ITracingSupportedChangeDMEvent) {
            this.refresh();
            rm.done();
            return;
        }
        if (event instanceof SetDebuggerFocusEvent) {
            ICudaRuntimeObject dmContext = ((SetDebuggerFocusEvent)event).getDMContext();
            event = new LinkedSelectionChangedEvent(dmContext);
        }
        super.handleEvent(event, rm);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("debug.view.cuda.layout".equals(property)) {
            this.refresh();
        } else if ("device.kernels.mode".equals(property)) {
            IAdaptable context = DebugUITools.getDebugContext();
            IDMContext object = DebugUtil.getObject(context, IDMContext.class, null);
            this.handleEvent((Object)new LayoutChangeEvent(object));
        }
    }

    public void refresh() {
        super.refresh();
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRunControl runControlService;
                    IStack stackService;
                    DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), DebugVMProvider.this.getSession().getId());
                    IProcesses processesService = (IProcesses)tracker.getService(IProcesses.class);
                    if (processesService instanceof ICachingService) {
                        ((ICachingService)processesService).flushCache(null);
                    }
                    if ((stackService = (IStack)tracker.getService(IStack.class)) instanceof ICachingService) {
                        ((ICachingService)stackService).flushCache(null);
                    }
                    if ((runControlService = (IRunControl)tracker.getService(IRunControl.class)) instanceof ICachingService) {
                        ((ICachingService)runControlService).flushCache(null);
                    }
                    tracker.dispose();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    protected IVMModelProxy createModelProxyStrategy(Object rootElement) {
        DefaultVMModelProxyStrategy strategy = new DefaultVMModelProxyStrategy((AbstractVMProvider)this, rootElement);
        strategy.setAllowRecursiveVMNodes(true);
        return strategy;
    }

    public String toString() {
        return "DebugVMProvider";
    }
}

