/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.io.PrintStream;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.Session;

public class DiffListener
extends CommandOutputListener {
    static final String ERR_NOSUCHDIRECTORY = "cvs [diff aborted]: no such directory";
    static final String INDEX = "Index: ";
    static final String BINARYFILESDIFFER = "Binary files .* and .* differ";
    PrintStream patchStream;
    boolean wroteToStream;
    private String index = "";

    public DiffListener(PrintStream patchStream) {
        this.patchStream = patchStream;
        this.wroteToStream = false;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (Session.IS_CRLF_PLATFORM && line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
            line = line.substring(0, line.length() - 1);
        }
        this.patchStream.println(line);
        this.wroteToStream = true;
        if (line.startsWith(INDEX)) {
            this.index = line.substring(INDEX.length());
        } else if (Pattern.matches(BINARYFILESDIFFER, line)) {
            String message = NLS.bind((String)CVSMessages.ThePatchDoesNotContainChangesFor_0, (Object[])new String[]{this.index});
            return new CVSStatus(2, -31, message, null);
        }
        return OK;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (this.getServerMessage(line, location) != null) {
            return super.errorLine(line, location, commandRoot, monitor);
        }
        if (line.indexOf(ERR_NOSUCHDIRECTORY) != -1) {
            return OK;
        }
        return super.errorLine(line, location, commandRoot, monitor);
    }

    public boolean wroteToStream() {
        return this.wroteToStream;
    }
}

