/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ui.IContextOwner;
import com.nvidia.viper.ui.SessionEditor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ContextManager
implements IPartListener {
    public static ContextManager singleton = new ContextManager();
    private Set<IContextOwner> possibleOwners = new HashSet<IContextOwner>();
    private Set<IWorkbenchPart> idempotentParts = new HashSet<IWorkbenchPart>();
    private IContextOwner owner = null;
    private SessionEditor activeSessionEditor;

    private ContextManager() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public static ContextManager getSingleton() {
        return singleton;
    }

    public IContextOwner getOwner() {
        return this.owner;
    }

    public SessionEditor getActiveSessionEditor() {
        return this.activeSessionEditor;
    }

    public void addPossibleOwner(IContextOwner owner) {
        this.possibleOwners.add(owner);
    }

    public void removePossibleOwner(IContextOwner owner) {
        this.possibleOwners.remove(owner);
    }

    public void addIdempotent(IWorkbenchPart part) {
        this.idempotentParts.add(part);
    }

    public void removeIdempotent(IWorkbenchPart part) {
        this.idempotentParts.remove(part);
    }

    protected void releaseOwnership(IWorkbenchPart part) {
        if (this.owner == part) {
            this.notifyOwners(this.owner, null);
            this.owner = null;
        }
        if (part == this.activeSessionEditor) {
            this.activeSessionEditor = null;
        }
    }

    protected void takeOwnership(IWorkbenchPart part) {
        if (part instanceof IContextOwner && this.possibleOwners.contains(part)) {
            IContextOwner newOwner = (IContextOwner)part;
            this.notifyOwners(this.owner, newOwner);
            this.owner = newOwner;
        } else if (!(part instanceof SessionEditor) && !this.idempotentParts.contains(part)) {
            this.notifyOwners(this.owner, null);
            this.owner = null;
        }
        if (part instanceof SessionEditor) {
            this.activeSessionEditor = (SessionEditor)part;
        }
    }

    protected void notifyOwners(IContextOwner oldOwner, IContextOwner newOwner) {
        if (oldOwner != newOwner) {
            if (oldOwner != null) {
                oldOwner.ownerChanged(oldOwner, newOwner);
            }
            for (IContextOwner owner : this.possibleOwners) {
                if (owner == oldOwner) continue;
                owner.ownerChanged(oldOwner, newOwner);
            }
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
        this.takeOwnership(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.releaseOwnership(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }
}

