/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_SoftwareInstallationServiceAccess.h"

const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_SoftwareUpdate";
string systemName;
string Name;

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	CF_assert(CF_getSoftwareInstallationServiceName(Name,errorMessage));
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SoftwareInstallationService>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	if(Name.empty()) return OK;
	
	OpenDRIM_SoftwareInstallationService instance;
	
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setCreationClassName(creationClassName);
	instance.setSystemName(systemName);
	instance.setName(Name);
	
	if(discriminant == "ei")
		CF_assert(SoftwareUpdate_OpenDRIM_SoftwareInstallationService_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SoftwareInstallationService& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.SystemCreationClassName != systemCreationClassName ||
			instance.CreationClassName != creationClassName ||
			instance.SystemName != systemName ||
			instance.Name != Name)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(SoftwareUpdate_OpenDRIM_SoftwareInstallationService_populate(instance,errorMessage));
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationService& newInstance, const OpenDRIM_SoftwareInstallationService& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationService& instance, unsigned int& returnValue, const OpenDRIM_SoftwareInstallationService_RequestStateChange_In& in, OpenDRIM_SoftwareInstallationService_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_StartService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_StopService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_CheckSoftwareIdentity(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationService& instance, unsigned int& returnValue, const OpenDRIM_SoftwareInstallationService_CheckSoftwareIdentity_In& in, OpenDRIM_SoftwareInstallationService_CheckSoftwareIdentity_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_InstallFromSoftwareIdentity(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationService& instance, unsigned int& returnValue, const OpenDRIM_SoftwareInstallationService_InstallFromSoftwareIdentity_In& in, OpenDRIM_SoftwareInstallationService_InstallFromSoftwareIdentity_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_InstallFromURI(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationService& instance, unsigned int& returnValue, const OpenDRIM_SoftwareInstallationService_InstallFromURI_In& in, OpenDRIM_SoftwareInstallationService_InstallFromURI_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_populate(OpenDRIM_SoftwareInstallationService& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] SystemCreationClassName  [KEY]
	 * [X] SystemName               [KEY]
	 * [X] CreationClassName        [KEY]
	 * [X] Name                     [KEY]
	 */
	// TODO
	_L_;
	return OK;
}

