/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_SSHCAPABILITIESACCESS_H_
#define OPENDRIM_SSHCAPABILITIESACCESS_H_

#include "SSH_Common.h"

#include "OpenDRIM_SSHCapabilities.h"

int SSH_OpenDRIM_SSHCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int SSH_OpenDRIM_SSHCapabilities_unload(string& errorMessage);

int SSH_OpenDRIM_SSHCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHCapabilities& instance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHCapabilities& newInstance, const OpenDRIM_SSHCapabilities& oldInstance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHCapabilities& instance, string& errorMessage);

int SSH_OpenDRIM_SSHCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHCapabilities& instance, string& errorMessage);

int SSH_OpenDRIM_SSHCapabilities_CreateGoalSettings(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHCapabilities& instance, unsigned short& returnValue, const OpenDRIM_SSHCapabilities_CreateGoalSettings_In& in, OpenDRIM_SSHCapabilities_CreateGoalSettings_Out& out, string& errorMessage);

int SSH_OpenDRIM_SSHCapabilities_populate(OpenDRIM_SSHCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_SSHCAPABILITIESACCESS_H_*/
