/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef ASSOCOPENDRIM_MEMORYCONFORMSTOPROFILE_H_
#define ASSOCOPENDRIM_MEMORYCONFORMSTOPROFILE_H_

#include "OpenDRIM_MemoryConformsToProfileAccess.h"

int SystemMemory_OpenDRIM_MemoryConformsToProfile_associatorFilter(const CMPIBroker* broker, const CMPIContext* ctx, const CMPIObjectPath* cop, Instance& knownInstance, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, bool& leftToRight, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_associator(const CMPIBroker* broker, const CMPIContext* ctx, const CMPIObjectPath* cop, Instance& knownInstance, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, const char** properties, vector<Instance>& associatedInstances, bool& leftToRight, string& errorMessage, const string& dicriminant);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_enumerateConformantStandards(const CMPIBroker* broker, const CMPIContext* ctx, vector<Instance>& instances, const char** properties, bool onlyNames, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_getConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Objectpath& objectpath, Instance& instance, const char** properties, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_enumerateManagedElements(const CMPIBroker* broker, const CMPIContext* ctx, vector<Instance>& instances, const char** properties, bool onlyNames, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_getManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Objectpath& objectpath, Instance& instance, const char** properties, string& errorMessage);

#endif /*ASSOCOPENDRIM_MEMORYCONFORMSTOPROFILE_H_*/
