#!/bin/sh
set -o errexit

###
# Copyright © 2015-2022, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright © 2021-2022, Daguhh
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Shovel Knight
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220102.1

# Set game-specific variables

GAME_ID='shovel-knight'
GAME_NAME='Shovel Knight: Treasure Trove'

ARCHIVE_BASE_0='shovel_knight_treasure_trove_4_1b_arby_s_46298.sh'
ARCHIVE_BASE_0_MD5='2f5e07e20ac615eb248ab81c25974d53'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='500000'
ARCHIVE_BASE_0_VERSION='4.1b-gog46298'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/shovel_knight'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_DOC_PATH='data/noarch/docs'
ARCHIVE_DOC_FILES='*.txt'
ARCHIVE_GAME_BIN32_PATH="${CONTENT_PATH_DEFAULT}/32"
ARCHIVE_GAME_BIN32_FILES='
ShovelKnight
lib'
ARCHIVE_GAME_BIN64_PATH="${CONTENT_PATH_DEFAULT}/64"
ARCHIVE_GAME_BIN64_FILES='
ShovelKnight
lib'
ARCHIVE_GAME_DATA_FILES='data'

APP_MAIN_TYPE='native'
APP_MAIN_EXE='ShovelKnight'
APP_MAIN_ICON='data/noarch/support/icon.png'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libSDL2-2.0.so.0 libGL.so.1"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"
 
# Extract game data
 
extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout
 
# Include game icons
 
PKG='PKG_DATA'
icons_get_from_workdir 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers
 
for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package
 
write_metadata
build_pkg
 
# Clean up
 
rm --recursive "$PLAYIT_WORKDIR"
 
# Print instructions
 
print_instructions
 
exit 0
