#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# J.U.L.I.A Among the Stars
# send your bug reports to contact@dotslashplay.it
###

script_version=20230205.2

GAME_ID='julia-among-the-stars'
GAME_NAME='J.U.L.I.A Among the Stars'

ARCHIVE_BASE_0='gog_j_u_l_i_a_among_the_stars_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='58becebfaf5a3705fe3f34d5531298d3'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='3100000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.1'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/julia_among_the_stars'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN32_PATH='data/noarch/game/lib'
CONTENT_LIBS_BIN32_FILES='
libbass_fx.so
libbass.so
libHalf.so.6
libIex.so.6
libIlmImf.so.6
libIlmThread.so.6
libjasper.so.1
libjpeg.so.8
liblcms.so.1
libopenjpeg.so.2
libpng12.so.0
libQtCore.so.4
libQtGui.so.4
libraw.so
libraw.so.9
libtheoraplayer.so.1'
CONTENT_GAME_BIN32_FILES='
julia'
CONTENT_LIBS_BIN64_PATH='data/noarch/game/lib64'
CONTENT_LIBS_BIN64_FILES='
libbass_fx.so
libbass.so
libHalf.so.6
libIex.so.6
libIlmImf.so.6
libIlmThread.so.6
libjasper.so.1
libjpeg.so.8
liblcms.so.1
libopenjpeg.so.2
libpng12.so.0
libQtCore.so.4
libQtGui.so.4
libraw.so
libraw.so.9
libtheoraplayer.so.1'
CONTENT_GAME_BIN64_FILES='
julia64'
CONTENT_GAME_DATA_FILES='
DLC
*.dcp'

APP_MAIN_EXE_BIN32='julia'
APP_MAIN_EXE_BIN64='julia64'
APP_MAIN_OPTIONS='-ignore _sd'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID"
PKG_BIN32_DEPENDENCIES_LIBRARIES='
libaudio.so.2
libc.so.6
libdl.so.2
libfontconfig.so.1
libfreeimage.so.3
libfreetype.so.6
libgcc_s.so.1
libglib-2.0.so.0
libgobject-2.0.so.0
libgomp.so.1
libICE.so.6
liblcms2.so.2
libm.so.6
libogg.so.0
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libSM.so.6
libstdc++.so.6
libtheoradec.so.1
libvorbis.so.0
libX11.so.6
libXext.so.6
libXi.so.6
libXrender.so.1
libz.so.1'

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN32_DEPENDENCIES_LIBRARIES"

# Load common functions

target_version='2.21'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

## Load the optional icons pack if it is provided
ARCHIVE_OPTIONAL_ICONS='julia-among-the-stars_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='8e9e8ec585123eb3b6e5d31723b7909c'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/resources/julia-among-the-stars/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
32x32
48x48
64x64
128x128'
archive_initialize_optional \
	'ARCHIVE_ICONS' \
	'ARCHIVE_OPTIONAL_ICONS'
if [ -n "$ARCHIVE_ICONS" ]; then
	## Include the original icons from the ./play.it-provided archive…
	archive_extraction 'ARCHIVE_ICONS'
	content_inclusion 'ICONS' 'PKG_DATA' "$(path_icons)"
else
	## …or fall back to the GOG-provided icon.
	PKG='PKG_DATA'
	icons_inclusion
fi

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write
done

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
