/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_tstate_ip_h__
#define __ls10_dev_tstate_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_TSTATE          0x00003fff:0x00003000 /* RW--D */
#define NV_TSTATE_TAGSTATECONTROL                          0x00003040      /* RW-4R */
#define NV_TSTATE_TAGSTATECONTROL_ATO_ENB                  9:9             /* RWEVF */
#define NV_TSTATE_TAGSTATECONTROL_ATO_ENB_ON               0x00000001      /* RWE-V */
#define NV_TSTATE_TAGSTATECONTROL_ATO_ENB_OFF              0x00000000      /* RW--V */
#define NV_TSTATE_ATO_TIMER_LIMIT                          0x00003048      /* RW-4R */
#define NV_TSTATE_ATO_TIMER_LIMIT_LIMIT                    19:0            /* RWEVF */
#define NV_TSTATE_ATO_TIMER_LIMIT_LIMIT_INIT               0x00000355      /* RWE-V */
#define NV_TSTATE_ERR_STATUS_0                             0x00003400      /* RW-4R */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOLBUFERR               0:0             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOLBUFERR__ONWRITE      "oneToClear"    /*       */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOLBUFERR_NONE          0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOLBUFERR_CLEAR         0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_LIMIT_ERR       1:1             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_LIMIT_ERR__ONWRITE "oneToClear" /*       */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_LIMIT_ERR_NONE  0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_LIMIT_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_DBE_ERR         2:2             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_DBE_ERR__ONWRITE "oneToClear"   /*       */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_DBE_ERR_NONE    0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_DBE_ERR_CLEAR   0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTOREBUFERR            3:3             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTOREBUFERR__ONWRITE   "oneToClear"    /*       */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTOREBUFERR_NONE       0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTOREBUFERR_CLEAR      0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_LIMIT_ERR    4:4             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_LIMIT_ERR__ONWRITE "oneToClear" /*       */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_LIMIT_ERR_NONE 0x00000000    /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_LIMIT_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_DBE_ERR      5:5             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_DBE_ERR__ONWRITE "oneToClear" /*       */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_DBE_ERR_NONE 0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_DBE_ERR_CLEAR 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_ATO_ERR                     6:6             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_ATO_ERR__ONWRITE            "oneToClear"    /*       */
#define NV_TSTATE_ERR_STATUS_0_ATO_ERR_NONE                0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_ATO_ERR_CLEAR               0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_CAMRSP_ERR                  7:7             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_CAMRSP_ERR__ONWRITE         "oneToClear"    /*       */
#define NV_TSTATE_ERR_STATUS_0_CAMRSP_ERR_NONE             0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_CAMRSP_ERR_CLEAR            0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0                             0x00003404      /* RW-4R */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOLBUFERR               0:0             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOLBUFERR__PROD         0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOLBUFERR_DISABLE       0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOLBUFERR_ENABLE        0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_LIMIT_ERR       1:1             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_LIMIT_ERR__PROD 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_LIMIT_ERR_DISABLE 0x00000000    /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_LIMIT_ERR_ENABLE 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_DBE_ERR         2:2             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_DBE_ERR__PROD   0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_DBE_ERR_DISABLE 0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_DBE_ERR_ENABLE  0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTOREBUFERR            3:3             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTOREBUFERR__PROD      0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTOREBUFERR_DISABLE    0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTOREBUFERR_ENABLE     0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_LIMIT_ERR    4:4             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_LIMIT_ERR__PROD 0x00000001   /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_ENABLE 0x00000001  /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_DBE_ERR      5:5             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_DBE_ERR__PROD 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_DBE_ERR_DISABLE 0x00000000   /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_DBE_ERR_ENABLE 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_ATO_ERR                     6:6             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_ATO_ERR__PROD               0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_ATO_ERR_DISABLE             0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_ATO_ERR_ENABLE              0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CAMRSP_ERR                  7:7             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_CAMRSP_ERR__PROD            0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CAMRSP_ERR_DISABLE          0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_CAMRSP_ERR_ENABLE           0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0                    0x00003408      /* RW-4R */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOLBUFERR      0:0             /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOLBUFERR__PROD 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOLBUFERR_DISABLE 0x00000000   /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOLBUFERR_ENABLE 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR 1:1          /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR 2:2            /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR   3:3             /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR__PROD 0x00000001  /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR 4:4       /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR 5:5         /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_ATO_ERR            6:6             /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_ATO_ERR__PROD      0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_ATO_ERR_DISABLE    0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_ATO_ERR_ENABLE     0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CAMRSP_ERR         7:7             /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CAMRSP_ERR__PROD   0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CAMRSP_ERR_DISABLE 0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CAMRSP_ERR_ENABLE  0x00000001      /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0                0x0000340c      /* RW-4R */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOLBUFERR  0:0             /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOLBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOLBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR 1:1      /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR 2:2        /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR 3:3           /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR 4:4   /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR 5:5     /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_ATO_ERR        6:6             /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_ATO_ERR_DISABLE 0x00000000     /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_ATO_ERR_ENABLE 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CAMRSP_ERR     7:7             /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CAMRSP_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CAMRSP_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0              0x00003410      /* RW-4R */
#define NV_TSTATE_ERR_CONTAIN_EN_0                         0x00003414      /* RW-4R */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOLBUFERR           0:0             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOLBUFERR__PROD     0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOLBUFERR_DISABLE   0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOLBUFERR_ENABLE    0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_LIMIT_ERR   1:1             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_DBE_ERR     2:2             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_DBE_ERR__PROD 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_DBE_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_DBE_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTOREBUFERR        3:3             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTOREBUFERR__PROD  0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTOREBUFERR_DISABLE 0x00000000     /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTOREBUFERR_ENABLE 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_LIMIT_ERR 4:4            /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_DBE_ERR  5:5             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_DBE_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_ATO_ERR                 6:6             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_ATO_ERR__PROD           0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_ATO_ERR_DISABLE         0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_ATO_ERR_ENABLE          0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CAMRSP_ERR              7:7             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CAMRSP_ERR__PROD        0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CAMRSP_ERR_DISABLE      0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CAMRSP_ERR_ENABLE       0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0                              0x0000341c      /* RW-4R */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOLBUFERR                0:0             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOLBUFERR__ONWRITE       "oneToClear"    /*       */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOLBUFERR_NONE           0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOLBUFERR_CLEAR          0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_LIMIT_ERR        1:1             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_LIMIT_ERR__ONWRITE "oneToClear"  /*       */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_LIMIT_ERR_NONE   0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_LIMIT_ERR_CLEAR  0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_DBE_ERR          2:2             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_DBE_ERR__ONWRITE "oneToClear"    /*       */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_DBE_ERR_NONE     0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_DBE_ERR_CLEAR    0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTOREBUFERR             3:3             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTOREBUFERR__ONWRITE    "oneToClear"    /*       */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTOREBUFERR_NONE        0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTOREBUFERR_CLEAR       0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_LIMIT_ERR     4:4             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_LIMIT_ERR__ONWRITE "oneToClear" /*       */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_LIMIT_ERR_NONE 0x00000000     /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_LIMIT_ERR_CLEAR 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_DBE_ERR       5:5             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_DBE_ERR__ONWRITE "oneToClear" /*       */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_DBE_ERR_NONE  0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_DBE_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_ATO_ERR                      6:6             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_ATO_ERR__ONWRITE             "oneToClear"    /*       */
#define NV_TSTATE_ERR_FIRST_0_ATO_ERR_NONE                 0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_ATO_ERR_CLEAR                0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_CAMRSP_ERR                   7:7             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_CAMRSP_ERR__ONWRITE          "oneToClear"    /*       */
#define NV_TSTATE_ERR_FIRST_0_CAMRSP_ERR_NONE              0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_CAMRSP_ERR_CLEAR             0x00000001      /* RW--V */
#define NV_TSTATE_ERR_DEBUG                                0x00003420      /* R--4R */
#define NV_TSTATE_ERR_DEBUG_ATO_SOURCE                     7:0             /* R-DVF */
#define NV_TSTATE_ERR_DEBUG_ATO_SOURCE_INIT                0x00000000      /* R-D-V */
#define NV_TSTATE_ERR_TIMESTAMP_LOG                        0x00003450      /* R--4R */
#define NV_TSTATE_ERR_TIMESTAMP_LOG_TIMESTAMP              23:0            /* R-DVF */
#define NV_TSTATE_ERR_TIMESTAMP_LOG_TIMESTAMP_INIT         0x00000000      /* R-D-V */
#define NV_TSTATE_ERR_MISC_LOG_0                           0x00003454      /* R--4R */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC                 10:8            /* R-DVF */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_CREQ            0x00000000      /* R-D-V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_DGD             0x00000001      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_ATR             0x00000002      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_ATSD            0x00000003      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_PROBE           0x00000004      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_CREQ_TD         0x00000005      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_DGD_TD          0x00000006      /* R---V */
#define NV_TSTATE_ERR_ECC_CTRL                             0x00003470      /* RW-4R */
#define NV_TSTATE_ERR_ECC_CTRL_CRUMBSTORE_ECC_ENABLE       0:0             /* RWEVF */
#define NV_TSTATE_ERR_ECC_CTRL_CRUMBSTORE_ECC_ENABLE_ENABLE 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_ECC_CTRL_CRUMBSTORE_ECC_ENABLE_DISABLE 0x00000000    /* RWE-V */
#define NV_TSTATE_ERR_ECC_CTRL_CRUMBSTORE_ECC_ENABLE__PROD 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_ECC_CTRL_TAGPOOL_ECC_ENABLE          1:1             /* RWEVF */
#define NV_TSTATE_ERR_ECC_CTRL_TAGPOOL_ECC_ENABLE_ENABLE   0x00000001      /* RW--V */
#define NV_TSTATE_ERR_ECC_CTRL_TAGPOOL_ECC_ENABLE_DISABLE  0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_ECC_CTRL_TAGPOOL_ECC_ENABLE__PROD    0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER         0x00003480      /* RW-4R */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_ERROR_COUNT 23:0        /* RWDVF */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000 /* RWD-V */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_LIMIT   0x00003484      /* RW-4R */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0  /* RWDVF */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS         0x00003488      /* R--4R */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_ERROR_ADDRESS 9:0       /* R-DVF */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_ERROR_ADDRESS_INIT 0x00000000 /* R-D-V */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_VALID   0x0000348c      /* R--4R */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_VALID_VALID 0:0         /* R-DVF */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_VALID_VALID_INVALID 0x00000000 /* R-D-V */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_VALID_VALID_VALID 0x00000001 /* R---V */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER            0x00003490      /* RW-4R */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_ERROR_COUNT 23:0           /* RWDVF */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000 /* RWD-V */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_LIMIT      0x00003494      /* RW-4R */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0     /* RWDVF */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS            0x00003498      /* R--4R */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_ERROR_ADDRESS 9:0          /* R-DVF */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_ERROR_ADDRESS_INIT 0x00000000 /* R-D-V */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_VALID      0x0000349c      /* R--4R */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_VALID_VALID 0:0            /* R-DVF */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_VALID_VALID_INVALID 0x00000000 /* R-D-V */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_VALID_VALID_VALID 0x00000001 /* R---V */
#endif // __ls10_dev_tstate_ip_h__
