/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import java.lang.reflect.Modifier;
import java.util.List;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.SignatureUtil;
import net.sf.jiapi.reflect.ConstantPoolHelper;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.InstructionList;
import net.sf.jiapi.reflect.InstructionParser;
import net.sf.jiapi.reflect.JiapiField;
import net.sf.jiapi.reflect.JiapiMethod;
import net.sf.jiapi.reflect.Signature;
import net.sf.jiapi.reflect.instruction.ANewArray;
import net.sf.jiapi.reflect.instruction.CheckCast;
import net.sf.jiapi.reflect.instruction.FieldAccess;
import net.sf.jiapi.reflect.instruction.IConst0;
import net.sf.jiapi.reflect.instruction.IConst1;
import net.sf.jiapi.reflect.instruction.IConst2;
import net.sf.jiapi.reflect.instruction.IConst3;
import net.sf.jiapi.reflect.instruction.IConst4;
import net.sf.jiapi.reflect.instruction.IConst5;
import net.sf.jiapi.reflect.instruction.Invocation;
import net.sf.jiapi.reflect.instruction.Ldc;
import net.sf.jiapi.reflect.instruction.LdcW;
import net.sf.jiapi.reflect.instruction.New;

public class InstructionFactory {
    private ConstantPool cp;

    public InstructionFactory() {
        this.cp = new ConstantPool();
    }

    InstructionFactory(ConstantPool cp) {
        this.cp = cp;
    }

    List<Instruction> createInstructionList(byte[] byteCode) {
        InstructionParser ip = new InstructionParser();
        return ip.createInstructionList(byteCode, this.cp);
    }

    public Instruction pushConstant(float constant) {
        short index = this.cp.addFloatInfo((int)constant).getEntryIndex();
        return this.createLDC(index);
    }

    public Instruction pushConstant(int constant) {
        switch (constant) {
            case 0: {
                return new IConst0();
            }
            case 1: {
                return new IConst1();
            }
            case 2: {
                return new IConst2();
            }
            case 3: {
                return new IConst3();
            }
            case 4: {
                return new IConst4();
            }
            case 5: {
                return new IConst5();
            }
        }
        short index = this.cp.addIntegerInfo(constant).getEntryIndex();
        return this.createLDC(index);
    }

    public Instruction pushConstant(String constant) {
        short index = this.cp.addStringInfo(constant).getEntryIndex();
        return this.createLDC(index);
    }

    public Instruction newClass(String className) {
        short index = this.cp.addClassInfo(className).getEntryIndex();
        return new New(index, this.cp);
    }

    public Instruction cast(String type) {
        ConstantPool.ClassInfo ci = this.cp.addClassInfo(type);
        short index = ci.getEntryIndex();
        return new CheckCast(index, this.cp);
    }

    public Instruction pushNull() {
        return new Instruction(new byte[]{1});
    }

    public Instruction pushThis() {
        return new Instruction(new byte[]{42});
    }

    public Instruction returnMethod(JiapiMethod jm) {
        String retType = jm.getSignature().getReturnType();
        Instruction ins = null;
        ins = "void".equals(retType) ? new Instruction(new byte[]{-79}) : ("boolean".equals(retType) || "int".equals(retType) || "short".equals(retType) || "byte".equals(retType) ? new Instruction(new byte[]{-84}) : ("long".equals(retType) ? new Instruction(new byte[]{-83}) : ("float".equals(retType) ? new Instruction(new byte[]{-82}) : ("double".equals(retType) ? new Instruction(new byte[]{-81}) : new Instruction(new byte[]{-80})))));
        return ins;
    }

    public Instruction invoke(int mods, String className, String methodName, Signature s) {
        short index = ConstantPoolHelper.addMethodReference(this.cp, className, methodName, s);
        byte[] bytes = Modifier.isStatic(mods) ? new byte[]{-72, (byte)(index >> 8), (byte)(index & 0xFF)} : (Modifier.isInterface(mods) ? new byte[]{-71, (byte)(index >> 8), (byte)(index & 0xFF), (byte)s.getParameters().length, 0} : ("<init>".equals(methodName) ? new byte[]{-73, (byte)(index >> 8), (byte)(index & 0xFF)} : new byte[]{-74, (byte)(index >> 8), (byte)(index & 0xFF)}));
        Invocation instruction = new Invocation(bytes, this.cp);
        return instruction;
    }

    public Instruction invoke(JiapiMethod jm) {
        String[] params = jm.getParameterTypeNames();
        short index = ConstantPoolHelper.addReference(this.cp, jm);
        byte[] bytes = Modifier.isStatic(jm.getModifiers()) ? new byte[]{-72, (byte)(index >> 8), (byte)(index & 0xFF)} : (Modifier.isInterface(jm.getModifiers()) ? new byte[]{-71, (byte)(index >> 8), (byte)(index & 0xFF), (byte)params.length, 0} : ("<init>".equals(jm.getName()) ? new byte[]{-73, (byte)(index >> 8), (byte)(index & 0xFF)} : new byte[]{-74, (byte)(index >> 8), (byte)(index & 0xFF)}));
        Invocation instruction = new Invocation(bytes, this.cp);
        return instruction;
    }

    private Instruction createLDC(short index) {
        if (index > 255) {
            return new LdcW(index, this.cp);
        }
        return new Ldc((byte)index, this.cp);
    }

    public Instruction getField(int modifiers, String className, String fieldName, String fieldType) {
        ConstantPool.ClassInfo ci = this.cp.addClassInfo(className);
        ConstantPool.FieldRefInfo fri = this.cp.addFieldRefInfo(ci, fieldName, fieldType);
        short index = fri.getEntryIndex();
        byte[] bytes = new byte[3];
        if (Modifier.isStatic(modifiers)) {
            bytes[0] = -78;
            bytes[1] = (byte)(index >> 8);
            bytes[2] = (byte)(index & 0xFF);
        } else {
            bytes[0] = -76;
            bytes[1] = (byte)(index >> 8);
            bytes[2] = (byte)(index & 0xFF);
        }
        FieldAccess instruction = new FieldAccess(bytes, this.cp);
        return instruction;
    }

    public Instruction getField(JiapiField field) {
        ConstantPool cp = field.getDeclaringClass().getConstantPool();
        ConstantPool.ClassInfo ci = cp.addClassInfo(field.getDeclaringClass().getName());
        ConstantPool.FieldRefInfo fri = cp.addFieldRefInfo(ci, field.getName(), field.getDescriptor());
        short index = fri.getEntryIndex();
        int modifiers = field.getModifiers();
        byte[] bytes = new byte[3];
        if (Modifier.isStatic(modifiers)) {
            bytes[0] = -78;
            bytes[1] = (byte)(index >> 8);
            bytes[2] = (byte)(index & 0xFF);
        } else {
            bytes[0] = -76;
            bytes[1] = (byte)(index >> 8);
            bytes[2] = (byte)(index & 0xFF);
        }
        FieldAccess instruction = new FieldAccess(bytes, cp);
        return instruction;
    }

    public Instruction setField(JiapiField field) {
        ConstantPool cp = field.getDeclaringClass().getConstantPool();
        ConstantPool.ClassInfo ci = cp.addClassInfo(field.getDeclaringClass().getName());
        ConstantPool.FieldRefInfo fri = cp.addFieldRefInfo(ci, field.getName(), field.getDescriptor());
        short index = fri.getEntryIndex();
        int modifiers = field.getModifiers();
        byte[] bytes = new byte[3];
        if (Modifier.isStatic(modifiers)) {
            bytes[0] = -77;
            bytes[1] = (byte)(index >> 8);
            bytes[2] = (byte)(index & 0xFF);
        } else {
            bytes[0] = -75;
            bytes[1] = (byte)(index >> 8);
            bytes[2] = (byte)(index & 0xFF);
        }
        FieldAccess instruction = new FieldAccess(bytes, cp);
        return instruction;
    }

    public Instruction aload(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{42});
            }
            case 1: {
                return new Instruction(new byte[]{43});
            }
            case 2: {
                return new Instruction(new byte[]{44});
            }
            case 3: {
                return new Instruction(new byte[]{45});
            }
        }
        return new Instruction(new byte[]{25, (byte)idx});
    }

    public Instruction iload(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{26});
            }
            case 1: {
                return new Instruction(new byte[]{27});
            }
            case 2: {
                return new Instruction(new byte[]{28});
            }
            case 3: {
                return new Instruction(new byte[]{29});
            }
        }
        return new Instruction(new byte[]{21, (byte)idx});
    }

    public Instruction lload(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{30});
            }
            case 1: {
                return new Instruction(new byte[]{31});
            }
            case 2: {
                return new Instruction(new byte[]{32});
            }
            case 3: {
                return new Instruction(new byte[]{33});
            }
        }
        return new Instruction(new byte[]{22, (byte)idx});
    }

    public Instruction dload(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{38});
            }
            case 1: {
                return new Instruction(new byte[]{39});
            }
            case 2: {
                return new Instruction(new byte[]{40});
            }
            case 3: {
                return new Instruction(new byte[]{41});
            }
        }
        return new Instruction(new byte[]{24, (byte)idx});
    }

    public Instruction fload(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{34});
            }
            case 1: {
                return new Instruction(new byte[]{35});
            }
            case 2: {
                return new Instruction(new byte[]{36});
            }
            case 3: {
                return new Instruction(new byte[]{37});
            }
        }
        return new Instruction(new byte[]{23, (byte)idx});
    }

    public Instruction astore(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{75});
            }
            case 1: {
                return new Instruction(new byte[]{76});
            }
            case 2: {
                return new Instruction(new byte[]{77});
            }
            case 3: {
                return new Instruction(new byte[]{78});
            }
        }
        return new Instruction(new byte[]{58, (byte)idx});
    }

    public Instruction istore(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{59});
            }
            case 1: {
                return new Instruction(new byte[]{60});
            }
            case 2: {
                return new Instruction(new byte[]{61});
            }
            case 3: {
                return new Instruction(new byte[]{62});
            }
        }
        return new Instruction(new byte[]{54, (byte)idx});
    }

    public Instruction lstore(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{63});
            }
            case 1: {
                return new Instruction(new byte[]{64});
            }
            case 2: {
                return new Instruction(new byte[]{65});
            }
            case 3: {
                return new Instruction(new byte[]{66});
            }
        }
        return new Instruction(new byte[]{55, (byte)idx});
    }

    public Instruction fstore(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{67});
            }
            case 1: {
                return new Instruction(new byte[]{68});
            }
            case 2: {
                return new Instruction(new byte[]{69});
            }
            case 3: {
                return new Instruction(new byte[]{70});
            }
        }
        return new Instruction(new byte[]{56, (byte)idx});
    }

    public Instruction dstore(int idx) {
        switch (idx) {
            case 0: {
                return new Instruction(new byte[]{71});
            }
            case 1: {
                return new Instruction(new byte[]{72});
            }
            case 2: {
                return new Instruction(new byte[]{73});
            }
            case 3: {
                return new Instruction(new byte[]{74});
            }
        }
        return new Instruction(new byte[]{57, (byte)idx});
    }

    public InstructionList newArray(String type, int size) {
        InstructionList il = new InstructionList(this.cp);
        il.add(this.pushConstant(size));
        if (SignatureUtil.isPrimitive((String)type)) {
            throw new RuntimeException("NOT implemented: new array for primitive types");
        }
        ConstantPool.ClassInfo ci = this.cp.addClassInfo("java.lang.Object");
        short idx = ci.getEntryIndex();
        il.add(new ANewArray(idx, this.cp));
        return il;
    }
}

