//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Detector/DetectorItemCatalog.h
//! @brief     Defines class DetectorItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_DETECTOR_DETECTORITEMCATALOG_H
#define BORNAGAIN_GUI_MODEL_DETECTOR_DETECTORITEMCATALOG_H

#include "GUI/Support/Type/UiInfo.h"
#include <QVector>

class DetectorItem;

class DetectorItemCatalog {
public:
    // used in SelectionProperty<Catalog>
    using CatalogedType = DetectorItem;

    // Do not change the numbering! It is serialized!
    enum class Type : uint8_t { Spherical = 0, Rectangular = 1 };

    //! Creates the item of the given type.
    static DetectorItem* create(Type type);

    //! List of available types, sorted as expected in the UI.
    static QVector<Type> types();

    //! UiInfo on the given type.
    static UiInfo uiInfo(Type t);

    //! Returns the enum type of the given item.
    static Type type(const DetectorItem* item);
};

#endif // BORNAGAIN_GUI_MODEL_DETECTOR_DETECTORITEMCATALOG_H
