//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/QCP_Util.h
//! @brief     Defines namespace ColorUtil
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_UTIL_QCP_UTIL_H
#define BORNAGAIN_GUI_SUPPORT_UTIL_QCP_UTIL_H

#include <QList>

class QCPAxis;
class QCPColorGradient;
class QCPColorScale;
class QCustomPlot;

//! Provides few helper functions for ColorMapPlot.

namespace GUI::QCP_Util {

void setLogz(QCPColorScale* scale, bool isLogz);

void setLogz(QCPAxis* axis, bool isLogz);

//! Sets default margins for axes rectangle plot.
void setDefaultMargins(QCustomPlot* customPlot);

QCPColorGradient colorGradientInferno();

} // namespace GUI::QCP_Util

#endif // BORNAGAIN_GUI_SUPPORT_UTIL_QCP_UTIL_H
