(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     54731,       1062]*)
(*NotebookOutlinePosition[     55579,       1092]*)
(*  CellTagsIndexPosition[     55490,       1086]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(pp[m_, n_] := Exp[\(-m\)] m\^n/\(n!\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pp[70, 10] // N\)], "Input"],

Cell[BoxData[
    \(3.09459367845508`*^-19\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(np[m_, x_] := 
      Exp[\(-\((x - m)\)\^2\)/\((2  m)\)]/\@\(2  \[Pi]\ m\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(np[70, 10] // N\)], "Input"],

Cell[BoxData[
    \(3.241818184317308`*^-13\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[{pp[1000, x], np[1000, x]}, {x, 990, 1010}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-47.1191 0.0476191 -10.4085 872.834 [
[.2619 .05299 -9 -9 ]
[.2619 .05299 9 0 ]
[.5 .05299 -12 -9 ]
[.5 .05299 12 0 ]
[.7381 .05299 -12 -9 ]
[.7381 .05299 12 0 ]
[.97619 .05299 -12 -9 ]
[.97619 .05299 12 0 ]
[.01131 .15277 -36 -4.5 ]
[.01131 .15277 0 4.5 ]
[.01131 .24006 -36 -4.5 ]
[.01131 .24006 0 4.5 ]
[.01131 .32734 -36 -4.5 ]
[.01131 .32734 0 4.5 ]
[.01131 .41462 -36 -4.5 ]
[.01131 .41462 0 4.5 ]
[.01131 .50191 -36 -4.5 ]
[.01131 .50191 0 4.5 ]
[.01131 .58919 -36 -4.5 ]
[.01131 .58919 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .06549 m
.2619 .07174 L
s
[(995)] .2619 .05299 0 1 Mshowa
.5 .06549 m
.5 .07174 L
s
[(1000)] .5 .05299 0 1 Mshowa
.7381 .06549 m
.7381 .07174 L
s
[(1005)] .7381 .05299 0 1 Mshowa
.97619 .06549 m
.97619 .07174 L
s
[(1010)] .97619 .05299 0 1 Mshowa
.125 Mabswid
.07143 .06549 m
.07143 .06924 L
s
.11905 .06549 m
.11905 .06924 L
s
.16667 .06549 m
.16667 .06924 L
s
.21429 .06549 m
.21429 .06924 L
s
.30952 .06549 m
.30952 .06924 L
s
.35714 .06549 m
.35714 .06924 L
s
.40476 .06549 m
.40476 .06924 L
s
.45238 .06549 m
.45238 .06924 L
s
.54762 .06549 m
.54762 .06924 L
s
.59524 .06549 m
.59524 .06924 L
s
.64286 .06549 m
.64286 .06924 L
s
.69048 .06549 m
.69048 .06924 L
s
.78571 .06549 m
.78571 .06924 L
s
.83333 .06549 m
.83333 .06924 L
s
.88095 .06549 m
.88095 .06924 L
s
.92857 .06549 m
.92857 .06924 L
s
.25 Mabswid
0 .06549 m
1 .06549 L
s
.02381 .15277 m
.03006 .15277 L
s
[(0.0121)] .01131 .15277 1 0 Mshowa
.02381 .24006 m
.03006 .24006 L
s
[(0.0122)] .01131 .24006 1 0 Mshowa
.02381 .32734 m
.03006 .32734 L
s
[(0.0123)] .01131 .32734 1 0 Mshowa
.02381 .41462 m
.03006 .41462 L
s
[(0.0124)] .01131 .41462 1 0 Mshowa
.02381 .50191 m
.03006 .50191 L
s
[(0.0125)] .01131 .50191 1 0 Mshowa
.02381 .58919 m
.03006 .58919 L
s
[(0.0126)] .01131 .58919 1 0 Mshowa
.125 Mabswid
.02381 .08295 m
.02756 .08295 L
s
.02381 .1004 m
.02756 .1004 L
s
.02381 .11786 m
.02756 .11786 L
s
.02381 .13532 m
.02756 .13532 L
s
.02381 .17023 m
.02756 .17023 L
s
.02381 .18769 m
.02756 .18769 L
s
.02381 .20514 m
.02756 .20514 L
s
.02381 .2226 m
.02756 .2226 L
s
.02381 .25751 m
.02756 .25751 L
s
.02381 .27497 m
.02756 .27497 L
s
.02381 .29243 m
.02756 .29243 L
s
.02381 .30988 m
.02756 .30988 L
s
.02381 .3448 m
.02756 .3448 L
s
.02381 .36225 m
.02756 .36225 L
s
.02381 .37971 m
.02756 .37971 L
s
.02381 .39717 m
.02756 .39717 L
s
.02381 .43208 m
.02756 .43208 L
s
.02381 .44954 m
.02756 .44954 L
s
.02381 .46699 m
.02756 .46699 L
s
.02381 .48445 m
.02756 .48445 L
s
.02381 .51936 m
.02756 .51936 L
s
.02381 .53682 m
.02756 .53682 L
s
.02381 .55428 m
.02756 .55428 L
s
.02381 .57173 m
.02756 .57173 L
s
.02381 .04803 m
.02756 .04803 L
s
.02381 .03058 m
.02756 .03058 L
s
.02381 .01312 m
.02756 .01312 L
s
.02381 .60665 m
.02756 .60665 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .11595 m
.06244 .19425 L
.10458 .27222 L
.14415 .33824 L
.18221 .39503 L
.22272 .44814 L
.26171 .49202 L
.30316 .53077 L
.34309 .56035 L
.3815 .58156 L
.40134 .58972 L
.41147 .59315 L
.42237 .59628 L
.43257 .5987 L
.4419 .60046 L
.44639 .60116 L
.45128 .60181 L
.45557 .60229 L
.4602 .6027 L
.46297 .60289 L
.46551 .60304 L
.46795 .60315 L
.46919 .6032 L
.47052 .60324 L
.47173 .60327 L
.47283 .60329 L
.47393 .60331 L
.47498 .60332 L
.4762 .60332 L
.47732 .60332 L
.47856 .60331 L
.47987 .60329 L
.48116 .60326 L
.48235 .60323 L
.48502 .60313 L
.48737 .60302 L
.48984 .60287 L
.4951 .60245 L
.50085 .60184 L
.51112 .60036 L
.52046 .59856 L
.54141 .593 L
.56059 .58604 L
.58139 .5765 L
.62231 .55165 L
.66171 .52017 L
.6996 .48298 L
.73994 .43601 L
.77876 .38371 L
.82004 .32062 L
Mistroke
.8598 .25266 L
.89804 .1808 L
.93874 .09747 L
.97619 .01472 L
Mfstroke
.02381 .06583 m
.06244 .14768 L
.10458 .22969 L
.14415 .29966 L
.18221 .36036 L
.22272 .41775 L
.26171 .46585 L
.30316 .50918 L
.34309 .54324 L
.3815 .56882 L
.40095 .57906 L
.42237 .58824 L
.44268 .59489 L
.45178 .59722 L
.46172 .5993 L
.4671 .60023 L
.4721 .60097 L
.47727 .60161 L
.48196 .60207 L
.48658 .60242 L
.4887 .60255 L
.49093 .60266 L
.49332 .60275 L
.49438 .60278 L
.49552 .60281 L
.49675 .60283 L
.49789 .60285 L
.49859 .60286 L
.49925 .60286 L
.50049 .60286 L
.50163 .60285 L
.50286 .60284 L
.50401 .60282 L
.50508 .6028 L
.50754 .60272 L
.51014 .60261 L
.51268 .60247 L
.51504 .60231 L
.5204 .60185 L
.5293 .60078 L
.53882 .5992 L
.54906 .59702 L
.56016 .59407 L
.58032 .58721 L
.60019 .57851 L
.62123 .56723 L
.65912 .54155 L
.69946 .50668 L
.73829 .46586 L
.77956 .41472 L
Mistroke
.81932 .35805 L
.85757 .29676 L
.89827 .2244 L
.93745 .1479 L
.97619 .06583 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00>P3oool00`000000oooo0?ooo`3o0?ooog@0oooo
000j0?ooo`030000003oool0oooo0?l0ooooM03oool003X0oooo00<000000?ooo`3oool0o`3ooomd
0?ooo`00>P3oool00`000000oooo0?ooo`3o0?ooog@0oooo000j0?ooo`<00000o`3ooomd0?ooo`00
>P3oool00`000000oooo0?ooo`3o0?ooof40oooo00<000000?ooo`3oool0403oool003X0oooo00<0
00000?ooo`3oool0o`3ooomQ0?ooo`030000003oool0oooo0100oooo000j0?ooo`030000003oool0
oooo04T0oooo00D0omnL04P0000000000000001d_`040?ooo`050?oOW0180000000000000000M;l0
1@3oool01@2oM0000000000000000000M;oo03`0oooo00<0okmd0000000000000`0000001@00M;l0
oooo0?ooo`3oool0okmd00<0000000<0M;oo0?ooo`3oool00P3oool01@3o_g@00000000000000000
M;oo00@0oooo00D0okmd000000000000000007Boo`0h0?ooo`030?noM0000000000000<0000000D0
07Bo0?ooo`3oool0oooo0?noM0030000000307Boo`3oool0oooo0080oooo00D0okmd000000000000
000007Boo`040?ooo`050;md0000000000000000001d_ol0>03oool00`3o_g@00000000000030000
0005001d_`3oool0oooo0?ooo`3o_g@00`0000001@1d_ol0oooo0000003oool0okmd00D0000000D0
07Bo0?ooo`3oool0oooo0?noM0030000000307Boo`3oool0oooo0040oooo000j0?ooo`030000003o
ool0oooo04d0oooo00<0_g@00018W03oool01P3oool00`2oM00004RL0?ooo`020?ooo`070;md0000
M;l0oooo0?ooo`3ogi`0B00007Boo`0n0?ooo`0309a8B02Lgol0oooo00@0oooo00H0W4Qd0;ooo`3o
ool0oono07@0M02oool30?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo0`3oool01P2LB7@0_ooo
0?ooo`3ookl0M01d0;ooocX0oooo00<0W4Q809cOo`3oool0103oool01P2LB7@0_ooo0?ooo`3ookl0
M01d0;ooo`<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02oool20?ooo`070;md0000M;l0oooo0?oo
o`3ogi`0B00007Boo`0j0?ooo`0309a8B02Lgol0oooo00@0oooo00L0W4Qd0;ooo`3oool0oono07@0
M02oool0000000@0oooo00<0W4Q809cOo`3oool0103oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oo
o`80oooo000j0?ooo`030000003oool0oooo04h0oooo00<0_g@004RLg`3oool01P3oool00`2oM000
B9cO0?ooo`060?ooo`030?noM000M;l0oooo03d0oooo00<0W4Q809cOo`3oool00`3oool00`3o_g@0
07Bo0?ooo`020?ooo`060=nLB018W=l0oooo0?ooo`3o_g@007Bo0`3oool01P3OW4P0B9cO0?ooo`3o
ool0okmd001d_`<0oooo00<0gia804RLg`3oool0>@3oool00`2LB4P0W=oo0?ooo`030?ooo`030?no
M000M;l0oooo0080oooo00H0gia804RLg`3oool0oooo0?noM000M;l30?ooo`030=nLB018W=l0oooo
00H0oooo00<0okmd001d_`3oool0>@3oool00`2LB4P0W=oo0?ooo`030?ooo`030?noM000M;l0oooo
0080oooo00<0gia80000003oool0103oool00`2LB4P0W=oo0?ooo`030?ooo`030?noM000M;l0oooo
0080oooo00<0gia804RLg`3oool00@3oool003X0oooo00<000000?ooo`3oool0CP3oool00`3o_g@0
04RL0?ooo`060?ooo`030?noM000B9`0oooo00H0oooo00<0okmd001d_`3oool0?@3oool00`2LB4P0
W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080oooo00H0okmd001d_`3oool0oooo0=nLB018W=l3
0?ooo`060?noM000M;l0oooo0?ooo`3OW4P0B9cO0`3oool00`3o_g@007Bo0?ooo`0i0?ooo`0309a8
B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool01P3o_g@007Bo0?ooo`3oool0gia804RL
g`<0oooo00<0okmd001d_`3oool01P3oool00`3o_g@007Bo0?ooo`0i0?ooo`0309a8B02Lgol0oooo
00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@000000?ooo`040?ooo`0309a8B02Lgol0oooo
00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`010?ooo`00>P3oool3000004X0
oooo00H0okmd000000000000000004QdM018B9`30?ooo`060?noM0000000000000000018M7@0B4RL
1`3oool00`2LB000M;oo0?ooo`0m0?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool0
0P3oool01P3o_g@007Bo0?ooo`3oool0gia804RLg`<0oooo00H0okmd001d_`3oool0oooo0=nLB018
W=l30?ooo`030?noM000M;l0oooo03T0oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0B9cO0?oo
o`020?ooo`060?noM000M;l0oooo0?ooo`3OW4P0B9cO0`3oool00`3o_g@007Bo0?ooo`060?ooo`03
09a8001d_ol0oooo03T0oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0B9cO0?ooo`020?ooo`03
00000000M;l0oooo00@0oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0B9cO0?ooo`020?ooo`03
0?noM000M;l0oooo0040oooo000j0?ooo`030000003oool0oooo04T0oooo00<0oono07@0B02Lgol0
0P3oool01`2LB00004RL0?ooo`3oool0oono07@0B02Lgol00P3oool01P2LB00004RL0?ooo`3oool0
oono07@000<0000000<0B9cO0?ooo`3oool0?@3oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018
W=l0oooo0080oooo00H0okmd001d_`3oool0oooo0=nLB018W=l30?ooo`060?noM000M;l0oooo0?oo
o`3OW4P0B9cO0`3oool00`3o_g@007Bo0?ooo`0i0?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia8
04RLg`3oool00P3oool01P3o_g@007Bo0?ooo`3oool0gia804RLg`<0oooo00H0okmd001d_`3oool0
oooo0?oo_`1d00030000000304RLg`3oool0oooo03T0oooo00<0W4Q809cOo`3oool00`3oool00`3O
W4P0B9cO0?ooo`020?ooo`0300000000M;l0oooo00@0oooo00<0W4Q809cOo`3oool00`3oool00`3O
W4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo0040oooo000j0?ooo`030000003oool0oooo04T0
oooo00<0okmd001d_`3oool00P3oool01P3ogi`0M9cO0?ooo`3oool0okmd001d_`<0oooo00L0omnL
07BLg`3oool0oooo0?oo_`1d07@0_ooo0480oooo00<0W4Q809cOo`3oool00`3oool00`3o_g@0B9cO
0?ooo`020?ooo`060=nLB018W=l0oooo0?ooo`3o_g@0B9cO0`3oool01P3OW4P0B9cO0?ooo`3oool0
okmd04RLg`<0oooo00<0gia804RLg`3oool0>@3oool00`2LB4P0W=oo0?ooo`030?ooo`030?noM018
W=l0oooo0080oooo00H0gia804RLg`3oool0oooo0?noM018W=l30?ooo`070=nLB018W=l0oooo0?oo
o`3ookl0M01d0;ooo`0n0?ooo`0309a8B02Lgol0oooo00<0oooo00L0okmd04RLg`3oool0oooo0000
003OW4P0B9cO00D0oooo00<0W4Q809cOo`3oool00`3oool00`3o_g@0B9cO0?ooo`020?ooo`030=nL
B018W=l0oooo0040oooo000j0?ooo`030000003oool0oooo04T0oooo00L0oono07@0B02Lgol0oooo
0?oo_`1d04P0W=oo0080oooo00L0oono07@0B02Lgol0oooo0?oo_`1d04P0W=oo0080oooo00<0oono
07@0M02oool0?`3oool01@3OW4P000000018W02LB4P0W=oo00D0oooo00H0W4P007Boo`3oool0omnL
04P0M02oool30?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo0`3oool01P2LB000M;oo0?ooo`3o
gi`0B01d0;ooocL0oooo00D0gia800000000B9`0W4Q809cOo`050?ooo`0609a8001d_ol0oooo0?oO
W01807@0_ooo0`3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooo`80oooo00<0oono07@0M02oool0
>`3oool01@3OW4P000000018W02LB4P0W=oo00D0oooo00H0W4P007Boo`3oool0000004P0M02oool2
0?ooo`050=nLB000000004RL09a8B02Lgol01@3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooo`80
oooo000j0?ooo`030000003oool0oooo04X0oooo00D0okmd000000000000000007Boo`040?ooo`05
0?noM000000000000000001d_ol00`3oool00`3ookl0M00000000002000000030000M02oool0oooo
03`0oooo00<0gia80000B02Lgol01@3oool01@3ookl0M0000000000004P0W=oo00@0oooo00D0oono
07@000000000001809cOo`040?ooo`050?oo_`1d000000000000B02Lgol0>P3oool00`3OW4P00018
09cOo`050?ooo`050?oo_`1d000000000000B02Lgol0103oool01@3ookl0M0000000000004P0W=oo
00<0oooo00<0oono07@0000000000P0000000`0007@0_ooo0?ooo`0h0?ooo`030=nLB00004P0W=oo
00D0oooo00D0oono07@000000000001809cOo`050?ooo`030=nLB00004P0W=oo00D0oooo00D0oono
07@000000000001809cOo`030?ooo`00>P3oool00`000000oooo0?ooo`3o0?oooe`0oooo00<00000
0?ooo`3oool05@3oool003X0oooo0`00003o0?oooe`0oooo00<000000?ooo`3oool05@3oool003X0
oooo00<000000?ooo`3oool0o`3ooomK0?ooo`030000003oool0oooo01H0oooo000j0?ooo`030000
003oool0oooo0?l0ooooF`3oool00`000000oooo0?ooo`0F0?ooo`00>P3oool00`000000oooo0?oo
o`3o0?oooeX0oooo00<000000?ooo`3oool05`3oool003X0oooo00<000000?ooo`3oool0o`3ooomJ
0?ooo`030000003oool0oooo01L0oooo000j0?ooo`030000003oool0oooo0?l0ooooF@3oool00`00
0000oooo0?ooo`0H0?ooo`00>P3oool00`000000oooo0?ooo`3o0?oooeT0oooo00<000000?ooo`3o
ool0603oool00340ooooo`00001f000000X0oooo000j0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0100oooo000j
0?ooo`800000E`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05H0oooo00<00000
0?ooo`3oool0C@3oool00`000000oooo0?ooo`050?ooo`8000004P3oool003X0oooo0P00003o0?oo
oeP0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0A0?ooo`00>P3oool00`000000
oooo0000003o0?oooeL0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0B0?ooo`00
>P3oool00`000000oooo0000003o0?oooeH0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0B0?ooo`00>P3oool400000?l0ooooE@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo01<0oooo000j0?ooo`040000003oool0oooo00000?l0ooooE03oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo01<0oooo000j0?ooo`050000003oool0oooo0?ooo`000000o`3o
oomC0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0503oool003X0oooo00D00000
0?ooo`3oool0oooo0000003o0?oooe80oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0D0?ooo`00>P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0ooooC`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo01D0oooo000j0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool05@3oool003X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooodd0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0F0?ooo`00>P3oool3000000<0oooo
00<000000?ooo`3oool0o`3ooom<0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
5P3oool003X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oood/0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0G0?ooo`00>P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0?l0ooooBP3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo01L0oooo000j0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooom90?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0603oool003X0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`3o0?ooodP0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0H0?ooo`00>P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo
A`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01T0oooo000j0?ooo`<000001P3o
ool00`000000oooo0?ooo`3o0?ooodH0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0I0?ooo`00>P3oool2000000P0oooo00<000000?ooo`3oool0o`3ooom50?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool06P3oool003X0oooo0P0000080?ooo`030000003oool0oooo
0?l0ooooA03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01X0oooo000j0?ooo`03
0000003oool0000000P0oooo00<000000?ooo`3oool0o`3ooom30?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool06`3oool003X0oooo00<000000?ooo`000000203oool00`000000oooo
0?ooo`3o0?oood80oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0K0?ooo`00>P3o
ool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo0?l0oooo@@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo01`0oooo000j0?ooo`040000003oool0oooo000000P0oooo
00<000000?ooo`3oool0o`3ooom00?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
703oool003X0oooo0`0000000`3oool000000?ooo`070?ooo`030000003oool0oooo0?l0oooo?`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01d0oooo000j0?ooo`050000003oool0
oooo0?ooo`000000203oool00`000000oooo0?ooo`3o0?oooch0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0M0?ooo`00>P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0o`3ooolm0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool07P3oool00080oooo00D0okmd000000000000000007Boo`050?ooo`030;md00000000
07Bo00D0oooo00D0okmd000000000000000007Boo`030?ooo`030?noM0000000000000<0000000@0
07Bo0?ooo`3ookl0M0001@000000101d_ol0oooo0?ooo`3o_g@500000003001d_`3oool0oooo00<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0
oooo?03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01h0oooo00020?ooo`0609a8
M02oool0oooo0?oo_`1d07@0_ooo103oool00`2oM0000000001d_`050?ooo`0609a8M02oool0oooo
0?oo_`1d07@0_ooo1@3oool00`2LB4P0W=oo0?ooo`030?ooo`030;md000007@0_ooo0080oooo00<0
giad09cOo`3oool0103oool00`2LB4P0W=oo0?ooo`060?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`3o0?oooc/0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0O0?ooo`0000<0oooo0?noM000M;l00`3oool00`3OW4P0B9cO0?ooo`0:
0?ooo`030?noM000M;l0oooo0080oooo00<0gia804RLg`3oool0103oool00`2LB4P0W=oo0?ooo`04
0?ooo`030?noM00004P0W=oo00P0oooo00<0W4Q809cOo`3oool01P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3ooolj0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool07`3oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d
_`3oool02P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<0W4Q809cO
o`3oool01@3oool00`3ogi`0B00004RLg`070?ooo`0309a8B02Lgol0oooo00H0oooo0`0000040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooolj0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0803oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3o
ool02P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<0W4Q809cOo`3o
ool01`3oool00`2LB000B9cO0?ooo`050?ooo`0309a8B02Lgol0oooo00H0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo>03oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0200oooo00000`3oool0gia804RLg`030?ooo`030?no
M000M;l0oooo00X0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`040?ooo`0309a8
B02Lgol0oooo00P0oooo00<0W4Qd0;ooo`3oool0103oool00`2LB4P0W=oo0?ooo`060?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooocP0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0Q0?ooo`0000<0oooo0?noM018W=l00`3o
ool00`3OW4P0B9cO0?ooo`0:0?ooo`030?noM018W=l0oooo0080oooo00<0gia804RLg`3oool0103o
ool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB01d_ol0oooo0080oooo00<0_g@007Boo`3oool0103o
ool00`2LB4P0W=oo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`3o0?ooocH0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0Q0?ooo`000P3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooo``0oooo00H0W4P007Boo`3oool0
omnL04P0M02oool20?ooo`050=nLB000000004RL09a8B02Lgol0103oool01`3o_g@0001d0;ooo`3o
ool0okmd0000B02Lgol00P3oool01@3OW4P000000018W02LB4P0W=oo00L0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo=P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0280oooo00020?ooo`050?oo_`1d000000000000B02L
gol03@3oool01@3ookl0M0000000000004P0W=oo00D0oooo00<0gia80000B02Lgol01@3oool01@3o
_g@000000000000004P0W=oo00D0oooo00<0gia80000B02Lgol01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3ooold0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool08P3oool003X0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo=03oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo02<0oooo000j0?ooo`<000001`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0?l0oooo<P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02<0
oooo000j0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`3o0?oooc80oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0T0?ooo`00>P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3o
ool`0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0903oool003X0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo<03oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo02D0oooo000j0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3o0?ooobh0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0U0?ooo`00>P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3oool]0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool09P3oool003X0oooo0`00000:0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0o`3oool/0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
9P3oool003X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo0?l0oooo:`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02L0oooo000j
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3o
0?ooobX0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0W0?ooo`00>P3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooolY0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0:03oool003X0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo:03oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo02P0oooo000j0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooobL0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0Y0?ooo`00>P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0o`3ooolV0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0:@3oool003X0oooo0`00000>0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0o`3ooolU0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0:P3oool0
03X0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0?l0oooo903oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02X0oooo000j0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooob<0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0[0?ooo`00>P3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0:`3oool003X0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo8@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo02`0oooo000j0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooob00oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0/0?ooo`00>P3oool300000140oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`3o0?oooal0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0]0?oo
o`00>P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0o`3ooolN0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0;@3oool003X0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo
7@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02h0oooo00020?ooo`050?noM000
000000000000001d_ol01@3oool00`2oM0000000001d_`050?ooo`050?noM000000000000000001d
_ol00`3oool00`3o_g@000000000000300000004001d_`3oool0oono07@000D0000000@0M;oo0?oo
o`3ookl0M0001@0000000`1d_ol0oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?oooa`0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0^0?ooo`000P3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`@0oooo00<0
_g@000000000M;l01@3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`D0oooo00<0W4Q809cOo`3o
ool00`3oool00`2oM000001d0;ooo`020?ooo`070=nLM02Lgol0oooo0?ooo`2oM000001d0;ooo`02
0?ooo`030=nLM02Lgol0oooo00@0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0?l0oooo6P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo02l0oooo00000`3oool0okmd001d_`030?ooo`030=nLB018W=l0oooo00X0oooo00<0okmd001d
_`3oool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`0309a8B02Lgol0oooo00@0oooo00<0okmd0000
B02Lgol01P3oool00`3o_g@0001809cOo`080?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`3o0?oooaX0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0_0?ooo`0000<0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0:0?ooo`03
0=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool00`2LB4P0W=oo0?ooo`050?ooo`03
0?oOW0180000B9cO00H0oooo00<0omnL04P00018W=l01`3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3ooolH0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0<03oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool0
2P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<0W4Q809cOo`3oool0
1`3oool00`2LB000B9cO0?ooo`060?ooo`0309a80018W=l0oooo00D0oooo0`00000E0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooolH0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0<@3oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool02P3o
ool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<0W4Q809cOo`3oool0203o
ool00`2LB7@0_ooo0?ooo`060?ooo`0309a8M02oool0oooo00@0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo5P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0340oooo00000`3oool0okmd04RLg`030?ooo`030=nLB018W=l0
oooo00X0oooo00<0okmd04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`0309a8B02Lgol0
oooo00<0oooo00<0gia807Boo`3oool00P3oool01P2oM000M;oo0?ooo`3oool0gia807Boo`<0oooo
00<0_g@007Boo`3oool0103oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0o`3ooolF0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
<P3oool00080oooo00H0W4P007Boo`3oool0omnL04P0M02oool<0?ooo`0609a8001d_ol0oooo0?oO
W01807@0_ooo0P3oool01@3OW4P000000018W02LB4P0W=oo00@0oooo00L0okmd0000M02oool0oooo
0?noM00004P0W=oo0080oooo00L0okmd0000M02oool0oooo0?noM00004P0W=oo00D0oooo00<00000
0?ooo`3oool05P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo503oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo0380oooo00020?ooo`050?oo_`1d00000000
0000B02Lgol03@3oool01@3ookl0M0000000000004P0W=oo00D0oooo00<0gia80000B02Lgol01@3o
ool01@3o_g@000000000000004P0W=oo00@0oooo00D0okmd000000000000001809cOo`060?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3o0?oooa<0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0c0?ooo`00>P3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3ooolB0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0=03oool003X0oooo0`00000H0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0o`3oool@0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0=03oool003X0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0?l0oooo403oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo03D0oooo000j0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`3o0?ooo`h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0e0?oo
o`00>P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0o`3oool>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0=P3oool003X0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo
303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03H0oooo000j0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?ooo`X0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0g0?ooo`00>P3oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3oool:0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0>03oool003X0oooo0`00000L0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0o`3oool80?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0>03oool003X0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0?l0oooo203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03T0
oooo000j0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`3o0?ooo`H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0i0?ooo`00>P3o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0o`3o
ool40?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0>P3oool003X0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo103oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo03/0oooo000j0?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3o0?ooo`80oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0k0?ooo`00>P3oool3000001l0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`3o0?ooo`80oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0l0?ooo`00>P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0o`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03`0oooo
000j0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`3n0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0?@3oool003X0oooo00<00000
0?ooo`3oool08@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0n0?ooo`00>P3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0n`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo03h0oooo000j0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`3k0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0?`3oool003X0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo0?T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0o0?ooo`00>P3o
ool3000002@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3h0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0@03oool003X0oooo00<000000?ooo`3oool0903oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo0?L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`110?ooo`00>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0440oooo00020?ooo`050?noM000000000000000001d_ol01@3oool00`2oM0000000001d_`050?oo
o`050?noM000000000000000001d_ol00`3oool00`3o_g@000000000000300000004001d_`3oool0
oono07@000D0000000D0M;oo0?ooo`3oool0oooo0;md00030000000304RLg`3oool0oooo00@0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`120?ooo`000P3oool01P2LB7@0_ooo0?oo
o`3ookl0M01d0;ooo`@0oooo00<0_g@000000000M;l01@3oool01P2LB7@0_ooo0?ooo`3ookl0M01d
0;ooo`D0oooo00<0W4Q809cOo`3oool00`3oool00`2oM000001d0;ooo`020?ooo`060=nLM02Lgol0
oooo0?ooo`2oM00007Bo0P3oool00`3ookl0M00004RLg`050?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0@P3oool000030?ooo`3o_g@007Bo00<0oooo00<0gia804RLg`3oool02P3o
ool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo00@0oooo00<0W4Q809cOo`3oool0103o
ool00`3o_g@0001809cOo`0:0?ooo`030?noM000M;l0oooo00@0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?80oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`130?ooo`0000<0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0:
0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool00`2LB4P0W=oo0?ooo`05
0?ooo`030?oOW0180000B9cO00P0oooo00<0omnL04P0B02Lgol01@3oool3000002L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`3a0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0A03oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool02P3oool00`3O
W4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<0W4Q809cOo`3oool01`3oool00`2L
B000B9cO0?ooo`040?ooo`040=nLB0000000001809cOo`H0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo0>l0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`140?ooo`0000<0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0:0?oo
o`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool00`2LB4P0W=oo0?ooo`080?oo
o`0309a8M02oool0oooo00D0oooo00<0omnL04P0B02Lgol01@3oool00`000000oooo0?ooo`0Y0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0kP3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo04D0oooo00000`3oool0okmd04RLg`030?ooo`030=nLB018W=l0oooo00X0
oooo00<0okmd04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`0309a8B02Lgol0oooo00<0
oooo00<0gia807Boo`3oool00P3oool00`2oM000M;oo0?ooo`060?ooo`030;md001d_ol0oooo00@0
oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0>d0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`160?ooo`000P3oool01P2LB000M;oo
0?ooo`3ogi`0B01d0;ooo``0oooo00H0W4P007Boo`3oool0omnL04P0M02oool20?ooo`050=nLB000
000004RL09a8B02Lgol0103oool01`3o_g@0001d0;ooo`3oool0okmd0000B02Lgol00P3oool01`3o
_g@0001809cOo`3oool0omnL04P0B02Lgol01@3oool00`000000oooo0?ooo`0Z0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0j`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo04H0oooo00020?ooo`050?oo_`1d000000000000B02Lgol03@3oool01@3ookl0M0000000
000004P0W=oo00D0oooo00<0gia80000B02Lgol01@3oool01@3o_g@000000000000004P0W=oo00@0
oooo00D0omnL04P000000000000007Boo`060?ooo`030000003oool0oooo02/0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`3Z0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0A`3oool003X0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0>T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`170?ooo`00
>P3oool3000002`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3X0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0B03oool003X0oooo00<000000?ooo`3oool0;@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0>H0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`190?ooo`00>P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0i@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo04T0oooo000j0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`3T0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0BP3oool003X0
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0><0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1:0?ooo`00>P3oool00`000000oooo
0?ooo`0_0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0hP3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo04/0oooo000j0?ooo`<00000<03oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0>00oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`1<0?ooo`00>P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0g`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo04`0oooo000j0?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3N0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0C@3oool003X0oooo00<000000?ooo`3o
ool0<P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`1>0?ooo`00>P3oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo04l0oooo000j0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`3I0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0C`3o
ool003X0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0=P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1@0?ooo`00>P3oool30000
03@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3G0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0D@3oool003X0oooo00<000000?ooo`3oool0=@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0=D0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`1A0?ooo`00>P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0e03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0580oooo
000j0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`3C0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0D`3oool003X0oooo00<00000
0?ooo`3oool0=`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0=40oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`1D0?ooo`00>P3oool00`000000oooo0?ooo`0g0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0c`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo05@0oooo000j0?ooo`<00000>03oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0<h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1E0?ooo`00
>P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
c@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo05H0oooo000j0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3;0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0EP3oool00080oooo00D0okmd000000000000000007Bo
o`050?ooo`030;md0000000007Bo00D0oooo00D0okmd000000000000000007Boo`030?ooo`030?no
M0000000000000<0000000@007Bo0?ooo`3ookl0M0001@0000000`1d_ol0oooo0?ooo`020?ooo`05
0?oOW018000000000000001d_ol01@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0bP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
05L0oooo00020?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo103oool00`2oM0000000001d_`05
0?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo1@3oool00`2LB4P0W=oo0?ooo`030?ooo`030;md
000007@0_ooo0080oooo00<0giad09cOo`3oool01@3oool00`2oM000M;oo0?ooo`050?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`390?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0F03oool000030?ooo`3o_g@007Bo00<0oooo00<0
gia804RLg`3oool02P3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo00@0oooo00<0
W4Q809cOo`3oool0103oool00`3o_g@0001809cOo`090?ooo`030;md001d_ol0oooo00D0oooo00<0
00000?ooo`3oool0?03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0<L0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1I0?ooo`0000<0oooo0=nLB018W=l00`3oool0
0`3o_g@007Bo0?ooo`0:0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool0
0`2LB4P0W=oo0?ooo`050?ooo`030?oOW0180000B9cO00@0oooo00<0gia80000000000000`000000
0`1d_ol0oooo0?ooo`030?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`350?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0F@3oool0
00030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool02P3oool00`3OW4P0B9cO0?ooo`020?oo
o`030?noM000M;l0oooo00@0oooo00<0W4Q809cOo`3oool01`3oool00`2LB000B9cO0?ooo`020?oo
o`060?noM00007@0_ooo0?ooo`2oM000M;oo1P3oool3000003h0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`350?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0FP3o
ool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool02P3oool00`3OW4P0B9cO0?ooo`02
0?ooo`030?noM000M;l0oooo00@0oooo00<0W4Q809cOo`3oool0203oool00`2LB7@0_ooo0?ooo`02
0?ooo`050=nLB000M;l0oooo0;md001d_ol01P3oool00`000000oooo0?ooo`0n0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0``3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo05/0oooo00000`3oool0okmd04RLg`030?ooo`030=nLB018W=l0oooo00X0oooo00<0okmd
04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia8
07Boo`3oool00P3oool00`2oM000M;oo0?ooo`030?ooo`0409a80018W=l0_g@007Boo`H0oooo00<0
00000?ooo`3oool0?`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0<40oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1L0?ooo`000P3oool01P2LB000M;oo0?ooo`3o
gi`0B01d0;ooo``0oooo00H0W4P007Boo`3oool0omnL04P0M02oool20?ooo`050=nLB000000004RL
09a8B02Lgol0103oool01`3o_g@0001d0;ooo`3oool0okmd0000B02Lgol0103oool0103ogi`0B018
04Q8001d_ol60?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`2o0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0G03oool00080oooo
00D0oono07@000000000001809cOo`0=0?ooo`050?oo_`1d000000000000B02Lgol01@3oool00`3O
W4P0001809cOo`050?ooo`050?noM000000000000000B02Lgol01P3oool00`3o_g@0000007Boo`06
0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`2o
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0G@3oool003X0oooo00<000000?oo
o`3oool0@@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0;d0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`1N0?ooo`00>P3oool300000480oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`2k0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0G`3oool003X0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo0;X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1P0?ooo`00>P3o
ool00`000000oooo0?ooo`140?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0^03o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0600oooo000j0?ooo`030000003oool0
oooo04D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2f0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0H@3oool003X0oooo00<000000?ooo`3oool0A@3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo0;D0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`1R0?ooo`00>P3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0/`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06<0
oooo000j0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`2a0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0H`3oool003X0oooo0`00
00180?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0/03oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo06@0oooo000j0?ooo`030000003oool0oooo04T0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`2^0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0I@3oool003X0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo0:`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1V0?oo
o`00>P3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0Z`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06L0oooo000j0?ooo`030000
003oool0oooo04/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2Y0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0I`3oool003X0oooo00<000000?ooo`3oool0C03o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`1X0?ooo`00>P3oool3000004d0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`2U0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0J@3oool0
03X0oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0:<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1Z0?ooo`00>P3oool00`000000
oooo0?ooo`1?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0XP3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo06/0oooo000j0?ooo`030000003oool0oooo0500oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2P0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0K03oool003X0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo09h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`1]0?ooo`00>P3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0W03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06h0oooo000j0?oo
o`030000003oool0oooo0580oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`2J0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0K`3oool003X0oooo0`00001C0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0V03oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0700oooo000j0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`2G0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
L03oool003X0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo09D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1a0?ooo`000P3oool0
1@3o_g@00000000000000000M;oo00D0oooo00<0_g@000000000M;l01@3oool01@3o_g@000000000
00000000M;oo00<0oooo00<0okmd0000000000000`0000001000M;l0oooo0?oo_`1d000500000005
07Boo`3oool0oooo0?ooo`2oM0000`0000000`1d_ol0oooo0?ooo`040?ooo`030000003oool0oooo
05H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0LP3oool00080oooo00H0W4Qd0;ooo`3oool0oono07@0M02oool4
0?ooo`030;md0000000007Bo00D0oooo00H0W4Qd0;ooo`3oool0oono07@0M02oool50?ooo`0309a8
B02Lgol0oooo00<0oooo00<0_g@00000M02oool00P3oool01P3OW7@0W=oo0?ooo`3oool0_g@0001d
_`80oooo00<0omnL04P0001d_ol01@3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
07<0oooo00000`3oool0okmd001d_`030?ooo`030=nLB018W=l0oooo00X0oooo00<0okmd001d_`3o
ool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`0309a8B02Lgol0oooo00@0oooo00<0okmd0000B02L
gol02P3oool00`3o_g@007Bo0?ooo`040?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`2?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0M03oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool02P3oool00`3OW4P0B9cO
0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<0W4Q809cOo`3oool01@3oool00`3ogi`0B000
04RLg`090?ooo`030?noM000M;l0oooo00@0oooo0`00001I0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0S03oool2000000P0oooo00<000000?ooo`3oool0M@3oool000030?ooo`3O
W4P0B9cO00<0oooo00<0okmd001d_`3oool02P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000
M;l0oooo00@0oooo00<0W4Q809cOo`3oool01`3oool00`2LB000B9cO0?ooo`070?ooo`0309a8001d
_ol0oooo00@0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo08X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1f0?ooo`0000<0oooo
0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0:0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd
001d_`3oool0103oool00`2LB4P0W=oo0?ooo`080?ooo`0609a8M02oool0oooo0?ooo`3ookl0M000
0`0000000`18W=l0oooo0?ooo`040?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
M`3oool000030?ooo`3o_g@0B9cO00<0oooo00<0gia804RLg`3oool02P3oool00`3o_g@0B9cO0?oo
o`020?ooo`030=nLB018W=l0oooo00@0oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0M;oo0?oo
o`020?ooo`070;md001d_ol0oooo0?ooo`3ookl0M01d0;ooo`090?ooo`030000003oool0oooo05`0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0N03oool00080oooo00H0W4P007Boo`3oool0omnL04P0M02oool<0?oo
o`0609a8001d_ol0oooo0?oOW01807@0_ooo0P3oool01@3OW4P000000018W02LB4P0W=oo00@0oooo
00L0okmd0000M02oool0oooo0?noM00004P0W=oo0080oooo00<0oono07@0M02oool02@3oool00`00
0000oooo0?ooo`1M0?ooo`8000001`3oool00`000000oooo0?ooo`240?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0N@3oool00080oooo00D0oono07@000000000001809cOo`0=0?oo
o`050?oo_`1d000000000000B02Lgol01@3oool00`3OW4P0001809cOo`050?ooo`050?noM0000000
00000000B02Lgol00`3oool00`3ookl0M00000000002000000030000M02oool0oooo00@0oooo00<0
00000?ooo`3oool0G`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0880oooo00<0
00000?ooo`3oool01P3oool2000007`0oooo000j0?ooo`030000003oool0oooo0600oooo00<00000
0?ooo`3oool01@3oool200000840oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1l
0?ooo`00>P3oool300000640oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1m0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0O@3oool003X0oooo00<000000?ooo`3o
ool0HP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07/0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`1n0?ooo`00>P3oool00`000000oooo0?ooo`1S0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo07l0oooo000j0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`1f0?ooo`800000203oool00`000000oooo0?ooo`200?ooo`00>P3oool0
0`000000oooo0?ooo`1U0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0M03oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0840oooo000j0?ooo`030000003oool0oooo
06H0oooo0P0000070?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool01P3oool20000
08@0oooo000j0?ooo`<00000J03oool00`000000oooo0?ooo`050?ooo`800000L@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo08@0oooo000j0?ooo`030000003oool0oooo06T0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0Q@3oool003X0oooo00<000000?ooo`3oool0JP3oool2000000L0oooo00<0
00000?ooo`3oool0J`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo08H0oooo000j
0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1X
0?ooo`8000001`3oool2000008T0oooo000j0?ooo`030000003oool0oooo06d0oooo00<000000?oo
o`3oool01@3oool2000006L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`290?oo
o`00>P3oool00`000000oooo0?ooo`1^0?ooo`8000001`3oool00`000000oooo0?ooo`1S0?ooo`03
0000003oool0oooo00D0oooo0P00002<0?ooo`00>P3oool00`000000oooo0?ooo`1`0?ooo`030000
003oool0oooo00D0oooo0P00001R0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
S03oool003X0oooo0`00001a0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0G@3o
ool2000000H0oooo0P00002?0?ooo`00>P3oool00`000000oooo0?ooo`1b0?ooo`8000001`3oool2
000005/0oooo0P0000070?ooo`030000003oool0oooo08l0oooo000j0?ooo`030000003oool0oooo
07@0oooo00<000000?ooo`3oool01P3oool2000005P0oooo00<000000?ooo`3oool01@3oool20000
0980oooo000j0?ooo`030000003oool0oooo07D0oooo0P0000080?ooo`030000003oool0oooo05<0
oooo0P0000070?ooo`030000003oool0oooo0980oooo000j0?ooo`030000003oool0oooo07L0oooo
0P0000070?ooo`800000D@3oool2000000L0oooo0P00002E0?ooo`00>P3oool00`000000oooo0?oo
o`1i0?ooo`8000001`3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0U@3oool003X0oooo0`00001k0?ooo`030000003oool0oooo00D0oooo0P00001;
0?ooo`8000001`3oool2000009P0oooo000j0?ooo`030000003oool0oooo07`0oooo0P0000070?oo
o`800000A`3oool2000000L0oooo0P00002J0?ooo`00>P3oool00`000000oooo0?ooo`1n0?ooo`80
00001`3oool2000004@0oooo00<000000?ooo`3oool01@3oool2000009`0oooo00020?ooo`050?no
M000000000000000001d_ol01@3oool00`2oM0000000001d_`050?ooo`050?noM000000000000000
001d_ol00`3oool00`3o_g@000000000000300000004001d_`3oool0oono07@000D0000000<0M;oo
0?ooo`3oool00P3oool01@2oM00000000000000007@0_ooo00D0oooo00<000000?ooo`3oool0P03o
ool2000000L0oooo0P0000100?ooo`8000001P3oool2000009h0oooo00020?ooo`0609a8M02oool0
oooo0?oo_`1d07@0_ooo103oool00`2oM0000000001d_`050?ooo`0609a8M02oool0oooo0?oo_`1d
07@0_ooo1@3oool00`2LB4P0W=oo0?ooo`030?ooo`030;md000007@0_ooo0080oooo00<0giad09cO
o`3oool00P3oool01P3OW4P007Bo0?ooo`3oool0okmd001d_`D0oooo00<000000?ooo`3oool0PP3o
ool2000000L0oooo0P00000l0?ooo`8000001P3oool200000:00oooo00000`3oool0okmd001d_`03
0?ooo`030=nLB018W=l0oooo00X0oooo00<0okmd001d_`3oool00P3oool00`3OW4P0B9cO0?ooo`04
0?ooo`0309a8B02Lgol0oooo00@0oooo00<0okmd0000B02Lgol01@3oool00`3ookl0M00007Boo`02
0?ooo`030?oo_`1dB9`0oooo00@0oooo00<000000?ooo`3oool0Q03oool2000000L0oooo0`00000g
0?ooo`8000001@3oool300000:80oooo00000`3oool0gia804RLg`030?ooo`030?noM000M;l0oooo
00X0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`040?ooo`0309a8B02Lgol0oooo
00D0oooo00<0omnL04P00018W=l0103oool01`3o_g@004Q807@0M02oool0oooo0=nLB000M;l01@3o
ool00`000000oooo0?ooo`260?ooo`<000001`3oool300000340oooo0`0000040?ooo`<00000Y@3o
ool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool02P3oool00`3OW4P0B9cO0?ooo`02
0?ooo`030?noM000M;l0oooo00@0oooo00<0W4Q809cOo`3oool01`3oool00`2LB000B9cO0?ooo`02
0?ooo`030?oOW018B9`0okmd0080000000<004RL0?ooo`3oool0103oool3000008T0oooo0`000007
0?ooo`800000:`3oool4000000D0oooo0P00002X0?ooo`0000<0oooo0=nLB018W=l00`3oool00`3o
_g@007Bo0?ooo`0:0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool00`2L
B4P0W=oo0?ooo`080?ooo`0709a8M02oool0oooo0?ooo`3ookl0M01d0;ooo`090?ooo`030000003o
ool0oooo08`0oooo0`0000060?ooo`<000009@3oool3000000L0oooo0P00002Z0?ooo`0000<0oooo
0?noM018W=l00`3oool00`3OW4P0B9cO0?ooo`0:0?ooo`030?noM018W=l0oooo0080oooo00<0gia8
04RLg`3oool0103oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB01d_ol0oooo0080oooo00<0_g@0
07Boo`3oool00P3oool00`2oM000B9cO0?ooo`080?ooo`030000003oool0oooo08l0oooo10000005
0?ooo`<000007P3oool4000000L0oooo0`00002/0?ooo`000P3oool01P2LB000M;oo0?ooo`3ogi`0
B01d0;ooo``0oooo00H0W4P007Boo`3oool0omnL04P0M02oool20?ooo`050=nLB000000004RL09a8
B02Lgol0103oool01`3o_g@0001d0;ooo`3oool0okmd0000B02Lgol00`3oool00`3ookl0M000001d
_`080?ooo`030000003oool0oooo09<0oooo100000040?ooo`<000005`3oool4000000L0oooo1000
002_0?ooo`000P3oool01@3ookl0M0000000000004P0W=oo00d0oooo00D0oono07@0000000000018
09cOo`050?ooo`030=nLB00004P0W=oo00D0oooo00D0okmd000000000000001809cOo`060?ooo`04
0;md0000000000000018W0D0oooo00<000000?ooo`3oool0U`3oool6000000030?ooo`0000000000
00L000002P3oool4000000<0oooo2000002c0?ooo`00>P3oool00`000000oooo0?ooo`2M0?oooa/0
0000^`3oool003X0oooo0`00003o0?ooog@0oooo000j0?ooo`030000003oool0oooo0?l0ooooM03o
ool003X0oooo00<000000?ooo`3oool0o`3ooomd0?ooo`00>P3oool00`000000oooo0?ooo`3o0?oo
og@0oooo000j0?ooo`030000003oool0oooo0?l0ooooM03oool003X0oooo00<000000?ooo`3oool0
o`3ooomd0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00
o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00
o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00
o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {265.875, 0}} -> {986.69, 0.0118696, \
0.0846629, 4.61895*^-06}}]
}, Open  ]],

Cell[BoxData[
    \(pcdf[m_, n_] := Sum[pp[m, i], {i, 0, n}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Erf\)\)], "Input"],

Cell[BoxData[
    RowBox[{"\<\"Erf[z] gives the error function erf(z). Erf[z0, z1] gives \
the generalized error function erf(z1) - erf(z0).\"\>", " ", 
      ButtonBox[
        StyleBox["More\[Ellipsis]",
          "SR"],
        ButtonData:>"Erf",
        Active->True,
        ButtonStyle->"RefGuideLink"]}]], "Print",
  CellTags->"Info3363258018-9909557"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdf[m_, x_] := \((1 + Erf[\((x - m)\)/\@\(2  m\)])\)/2\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(ncdf\\)\\\" is similar to existing symbol \\\
\"\\!\\(pcdf\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pcdf[1000. , 1000] // N\)], "Input"],

Cell[BoxData[
    \(0.508409367168508`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdf[1000, 1000] // N\)], "Input"],

Cell[BoxData[
    \(0.5`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1680}, {0, 963}},
WindowSize->{808, 932},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3363258018-9909557"->{
    Cell[53592, 1019, 359, 9, 60, "Print",
      CellTags->"Info3363258018-9909557"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3363258018-9909557", 55378, 1079}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 70, 1, 42, "Input"],

Cell[CellGroupData[{
Cell[1849, 56, 48, 1, 42, "Input"],
Cell[1900, 59, 56, 1, 43, "Output"]
}, Open  ]],
Cell[1971, 63, 107, 2, 49, "Input"],

Cell[CellGroupData[{
Cell[2103, 69, 48, 1, 42, "Input"],
Cell[2154, 72, 57, 1, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2248, 78, 86, 1, 42, "Input"],
Cell[2337, 81, 51098, 927, 279, 5122, 355, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[53450, 1011, 73, 1, 42, "Input"],

Cell[CellGroupData[{
Cell[53548, 1016, 41, 1, 42, "Input"],
Cell[53592, 1019, 359, 9, 60, "Print",
  CellTags->"Info3363258018-9909557"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53988, 1033, 88, 1, 53, "Input"],
Cell[54079, 1036, 356, 5, 53, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54472, 1046, 56, 1, 42, "Input"],
Cell[54531, 1049, 52, 1, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54620, 1055, 54, 1, 42, "Input"],
Cell[54677, 1058, 38, 1, 41, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

